unit StatusForm;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, dcDecompThread;

type
  TStatusFrm = class(TForm)
    lvDebug: TListView;
    Panel1: TPanel;
    btnMain: TButton;
    lbStatus: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure btnMainClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    { Private declarations }
    FStatus: TdcStatus;
    procedure SetStatus(Value: TdcStatus);
    function GetStatusText: string;
    procedure SetStatusText(const Value: string);
  public
    { Public declarations }
    property StatusText: string read GetStatusText write SetStatusText;
    property Status: TdcStatus read FStatus write SetStatus;
  end;

var
  StatusFrm: TStatusFrm;
  DecompThread: TdcDecompThread;
  
implementation

uses
  Consts, MainForm;

{$R *.DFM}

resourcestring
  SStsTxtCancelling = 'Cancelling.';
  SCaptionCancel = '&Cancel';
  SCaptionOK = '&OK';
  SBasicApplTitle = 'Revendepro';
  SApplTitleDecompiling = 'Revendepro - decompiling';
  SApplTitleFinished = 'Revendepro - finished';
  SApplTitleError = 'Revendepro - error';
  SApplTitleCancelling = 'Revendepro - cancelling';
  SApplTitleCanceled = 'Revendepro - canceled';

procedure TStatusFrm.FormCreate(Sender: TObject);
begin
  Status := sCanCancel;
  {$IFOPT D+}
  // Make the lvDebug view appear on the form.
  ClientHeight := ClientHeight + 100;
  {$ELSE}
  lvDebug.Visible := False;
  {$ENDIF}
end;

procedure TStatusFrm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  case Status of
    sCanCancel: begin
                // Require the decompilation process to Cancel.
                DecompThread.Terminate;
                Status := sCancelling;
                StatusText := SStsTxtCancelling;
                CanClose := False;
                end;
    sCanNotCancel, sCancelling: CanClose := False;
    else
      // give the status as return value.
      ModalResult := Integer(Status);
      Application.Title := SBasicApplTitle;
  end;
end;

function TStatusFrm.GetStatusText: string;
begin
  Result := lbStatus.Caption;
end;

procedure TStatusFrm.SetStatusText(const Value: string);
begin
  lbStatus.Caption := Value;
end;

procedure TStatusFrm.SetStatus(Value: TdcStatus);
const
  CancelStatus: array[TdcStatus] of Boolean = (True, True, False, False, False, False);
  EnabledStatus: array[TdcStatus] of Boolean = (True, False, True, False, True, True);
  CaptionStatus: array[TdcStatus] of string = (SCancelButton, SCancelButton, SOKButton, SCancelButton, SOKButton, SOKButton);
  ApplTitleStatus: array[TdcStatus] of string = (SApplTitleDecompiling, SApplTitleDecompiling,
         SApplTitleFinished, SApplTitleCancelling, SApplTitleCanceled, SApplTitleError);
begin
  FStatus := Value;
  // Update the main button using the status.
  with btnMain do
  begin
    Cancel := CancelStatus[Value];
    Enabled := EnabledStatus[Value];
    Caption := CaptionStatus[Value];
  end;
  Application.Title := ApplTitleStatus[Value];
  {$IFDEF DebugView}
  if FStatus = sFinished then
    Self.Close;
  {$ENDIF DebugView}
end;

procedure TStatusFrm.btnMainClick(Sender: TObject);
begin
  // Close the form.
  Self.Close;
end;

procedure TStatusFrm.FormDestroy(Sender: TObject);
begin
  StatusFrm := nil;
end;

end.
