program Revendepro;

uses
  Forms,
  SysUtils,
  Windows,
  Dialogs,
  FileCtrl,
  Classes,
  MainForm in 'MainForm.pas' {DecompilerFrm},
  ObjFileConsts4 in 'ObjFileConsts4.pas',
  ObjFileConsts5 in 'ObjFileConsts5.pas',
  PEFileClass in 'PEFileClass.pas',
  DisAsm in 'DisAsm.pas',
  DisAsmTables in 'DisAsmTables.pas',
  ProcDecomp in 'ProcDecomp.pas',
  Procs in 'Procs.pas',
  Vars in 'Vars.pas',
  SysVars in 'SysVars.pas',
  dcUnits in 'dcUnits.pas',
  dcDecomps in 'dcDecomps.pas',
  dcFields in 'dcFields.pas',
  dcNTInfoTypes in 'dcNTInfoTypes.pas',
  dcThrVar in 'dcThrVar.pas',
  dcType in 'dcType.pas',
  dcTypeIntf in 'dcTypeIntf.pas',
  dcDebug in 'dcDebug.pas',
  StatusForm in 'StatusForm.pas' {StatusFrm},
  dcDecompThread in 'dcDecompThread.pas',
  MethodLists in 'MethodLists.pas',
  dcDFMs in 'dcDFMs.pas',
  NameMangling in 'NameMangling.pas',
  dcSystemProcs in 'dcSystemProcs.pas',
  dcImportDecomps in 'dcImportDecomps.pas',
  dcOpcToInstr in 'dcOpcToInstr.pas',
  dcInstrSource in 'dcInstrSource.pas',
  dcAssignInstrTable in 'dcAssignInstrTable.pas',
  DisAsmX in 'DisAsmX.pas',
  dcProcInstr in 'dcProcInstr.pas',
  dcCondition in 'dcCondition.pas',
  dcParams in 'dcParams.pas',
  dcAsmInstr in 'dcAsmInstr.pas';

{$R *.RES}

{$R FfmtObj.RES}

{$IFNDEF VER120}
  {$IFNDEF VER130}
    Error. //This program can only be used with Delphi 4 or 5.
  {$ENDIF}
{$ENDIF}

{ The program will display addional message when DebugInformation is enabled.
  If you define the conditional definetion DebugView, the program won't
  generate output files, but will display a form with information about the exe.
}

function GetFileName(var AFileName: string): Boolean;
var
  I: Integer;
begin
  // Get the filename.
  for I := 1 to ParamCount do
    if Copy(ParamStr(I), 1, 2) = '-f' then
    begin
      Result := True;
      AFileName := ParamStr(I);
      Delete(AFileName, 1, 2);
      Exit;
    end;
  with TOpenDialog.Create(Application) do
  try
    DefaultExt := 'exe';
    Filter := 'project (*.exe, *.dll, *.bpl)|*.dll;*.exe;*.bpl|programs (*.exe)|*.exe|libraries (*.dll)|*.dll|packages (*.bpl)|*.bpl|all files (*.*)|*.*';
    Options := [ofReadOnly, ofFileMustExist];
    Title := 'Select program to decompile';
    Result := Execute;
    AFileName := FileName;
  finally
    Free;
  end;
end;

{$IFNDEF DebugView}
function GetDir(var Dir: string): Boolean;
var
  I: Integer;
begin
  // Get the directory for the output file.
  for I := 1 to ParamCount do
    if Copy(ParamStr(I), 1, 2) = '-d' then
    begin
      Result := True;
      Dir := ParamStr(I);
      Delete(Dir, 1, 2);
      Exit;
    end;
  Result := SelectDirectory('Select the output directory.', Dir, Dir)
end;
{$ENDIF DebugView}

procedure WizardAsk;
var
  FileName: string;
{$IFNDEF DebugView}Dir: string;{$ENDIF}
begin
  if GetFileName(FileName)
    {$IFNDEF DebugView} and GetDir(Dir) {$ENDIF} then
  begin
    try
      StatusFrm := TStatusFrm.Create(nil);
      try
        {$IFDEF DebugView}
        // Create the decomp thread which decompiles the file.
        DecompThread := TdcDecompThread.CreateDecomp(FileName);
        // Show the status form modal.
        if TdcStatus(StatusFrm.ShowModal) = sFinished then
        begin
          // If the decompilation is succesfully finished show information
          // about the file.
          Application.Title := 'Revendepro';
  Application.CreateForm(TDecompilerFrm, DecompilerFrm);
  try
            DecompilerFrm.PEFile := DecompThread.PEFileClasses[DecompThread.PEFileClassCount -1] as TPEFileClass;
            Application.Run;
          finally
            DecompilerFrm.Free;
          end;
        end;
        {$ELSE}
        // Create the decomp thread which decompiles the file.
        TdcDecompThread.CreateDecomp(FileName, Dir);
        // Show the status form modal.
        StatusFrm.ShowModal;
        {$ENDIF DebugView}
      finally
        StatusFrm.Free;
      end;
    finally
      DecompThread.Free;
    end;
  end;
end;

begin
  Application.Initialize;
  WizardAsk;                                                   
end.

