unit ObjFileConsts5;

interface

uses
  Procs;

const
  AbstractErrorProcName = '@AbstractError';
  InitResStringImportsProcName = '@InitResStringImports';
  InitImportsProcName = '@InitImports';
  HandleOnExceptionProcName = '@HandleOnException'; 

type
  PProc = ^TProc;

  PHCBlock = ^THCBlock;
  THCBlock = record
    Size: Integer;
    RAC: Integer;
    RA: Pointer; // ^array[0..RAC-1] of TRA  Reference addresses to proc.
    ValC: Integer;
    Val: Pointer; // ^array[0..ValC-1] of  TVal
    VarsC: Integer;
    Vars: Pointer; // ^array[0..VarsC-1] of TCVar Vars
    IAC: Integer;
    IA: Pointer; // ^array[0..IAC-1] of TIA internal addresses
    PRC: Integer;
    PR: Pointer; // ^array[0..PRC-1] of TPR proc refs.
  end;

  TRA = record
    RA: Integer;     // Relative address
    PN: string;      // proc name
    CN: string;      // class name
    PV: PProc;       // Proc var
    PT: TProcType;   // Proc type (ptProcedure or ptMethodProcedure by default)
    Source: string;  // Source of the unit.
  end;
  
  PRAArray = ^TRAArray;
  TRAArray = array[0..$FFFF] of TRA;
  TVal = record
    RA: Integer;
    Count: Integer;
    Val: Pointer; // ^array[0..Count-1] of Byte;
  end;
  PValArray = ^TValArray;
  TValArray = array[0..$FFFF] of TVal;
  TCVar = record
    RA: Integer;
    VN: string; // var name
    VRA: Integer; // Offset of the var.
  end;
  TVarArray = array[0..$FFFF] of TCVar;
  TIA = record
    RA: Integer;
    RRA: Integer; // referenced relative address
  end;
  TIAArray = array[0..$FFFF] of TIA;
  TPR = record
    RA: Integer;
    PN: string;
    CN: string;
  end;
  TPRArray = array[0..$FFFF] of TPR;

{ TODO -cAdditions : This is the Delphi 4 file, with only @Halt0 converted, some other procs also have to  beconverted }

const
  HCBlock0RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetBlockDesc'; CN: ''));
  HCBlock0Val0: array[0..2] of byte = (
    $53, $56, $BE);
  HCBlock0Val1: array[0..12] of byte = (
    $83, $3E, $00, $75, $3A, $68, $44, $06, $00, $00, $6A, $00, $E8);
  HCBlock0Val2: array[0..11] of byte = (
    $8B, $C8, $85, $C9, $75, $05, $33, $C0, $5E, $5B, $C3, $A1);
  HCBlock0Val3: array[0..3] of byte = (
    $89, $01, $89, $0D);
  HCBlock0Val4: array[0..30] of byte = (
    $33, $D2, $8B, $C2, $03, $C0, $8D, $44, $C1, $04, $8B, $1E, $89, $18, $89, $06, 
    $42, $83, $FA, $64, $75, $EC, $8B, $06, $8B, $10, $89, $16, $5E, $5B, $C3);
  HCBlock0Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock0Val0); Val: @HCBlock0Val0), 
    (RA: $7; Count: length(HCBlock0Val1); Val: @HCBlock0Val1),
    (RA: $18; Count: length(HCBlock0Val2); Val: @HCBlock0Val2), 
    (RA: $28; Count: length(HCBlock0Val3); Val: @HCBlock0Val3),
    (RA: $30; Count: length(HCBlock0Val4); Val: @HCBlock0Val4));
  HCBlock0Vars: array[0..1] of TCVar = (
    (RA: $3; VN: 'blockDescFreeList'), 
    (RA: $24; VN: 'blockDescBlockList'));
  HCBlock0: THCBlock = (
    Size: $50;
    RAC: length(HCBlock0RA); RA: @HCBlock0RA;
    ValC: length(HCBlock0Val); Val: @HCBlock0Val;
    VarsC: length(HCBlock0Vars); Vars: @HCBlock0Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock1RA: array[0..0] of TRA = (
    (RA: $0; PN: 'MakeEmpty'; CN: ''));
  HCBlock1Val0: array[0..5] of byte = (
    $89, $00, $89, $40, $04, $C3);
  HCBlock1Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock1Val0); Val: @HCBlock1Val0));
  HCBlock1: THCBlock = (
    Size: $8;
    RAC: length(HCBlock1RA); RA: @HCBlock1RA;
    ValC: length(HCBlock1Val); Val: @HCBlock1Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock2RA: array[0..0] of TRA = (
    (RA: $0; PN: 'AddBlockAfter'; CN: ''));
  HCBlock2Val0: array[0..6] of byte = (
    $53, $56, $8B, $F2, $8B, $D8, $E8);
  HCBlock2Val1: array[0..35] of byte = (
    $85, $C0, $75, $05, $33, $C0, $5E, $5B, $C3, $8B, $16, $89, $50, $08, $8B, $56, 
    $04, $89, $50, $0C, $8B, $13, $89, $10, $89, $58, $04, $89, $42, $04, $89, $03, 
    $B0, $01, $5E, $5B);
  HCBlock2Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock2Val0); Val: @HCBlock2Val0), 
    (RA: $B; Count: length(HCBlock2Val1); Val: @HCBlock2Val1));
  HCBlock2: THCBlock = (
    Size: $30;
    RAC: length(HCBlock2RA); RA: @HCBlock2RA;
    ValC: length(HCBlock2Val); Val: @HCBlock2Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock3RA: array[0..0] of TRA = (
    (RA: $0; PN: 'DeleteBlock'; CN: ''));
  HCBlock3Val0: array[0..11] of byte = (
    $8B, $50, $04, $8B, $08, $89, $0A, $89, $51, $04, $8B, $15);
  HCBlock3Val1: array[0..2] of byte = (
    $89, $10, $A3);
  HCBlock3Val2: array[0..0] of byte = (
    $C3);
  HCBlock3Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock3Val0); Val: @HCBlock3Val0), 
    (RA: $10; Count: length(HCBlock3Val1); Val: @HCBlock3Val1), 
    (RA: $17; Count: length(HCBlock3Val2); Val: @HCBlock3Val2));
  HCBlock3Vars: array[0..0] of TCVar = (
    (RA: $C; VN: 'blockDescFreeList'));
  HCBlock3: THCBlock = (
    Size: $18;
    RAC: length(HCBlock3RA); RA: @HCBlock3RA;
    ValC: length(HCBlock3Val); Val: @HCBlock3Val;
    VarsC: length(HCBlock3Vars); Vars: @HCBlock3Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock4RA: array[0..0] of TRA = (
    (RA: $0; PN: 'MergeBlockAfter'; CN: ''));
  HCBlock4Val0: array[0..44] of byte = (
    $53, $56, $57, $55, $51, $8B, $F1, $89, $14, $24, $8B, $E8, $8B, $5D, $00, $8B,
    $04, $24, $8B, $10, $89, $16, $8B, $50, $04, $89, $56, $04, $8B, $3B, $8B, $43, 
    $08, $8B, $D0, $03, $53, $0C, $3B, $16, $75, $14, $8B, $C3, $E8);
  HCBlock4Val1: array[0..24] of byte = (
    $8B, $43, $08, $89, $06, $8B, $43, $0C, $01, $46, $04, $EB, $16, $8B, $16, $03, 
    $56, $04, $3B, $C2, $75, $0D, $8B, $C3, $E8);
  HCBlock4Val2: array[0..16] of byte = (
    $8B, $43, $0C, $01, $46, $04, $8B, $DF, $3B, $EB, $75, $C2, $8B, $D6, $8B, $C5, 
    $E8);
  HCBlock4Val3: array[0..13] of byte = (
    $84, $C0, $75, $04, $33, $C0, $89, $06, $5A, $5D, $5F, $5E, $5B, $C3);
  HCBlock4Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock4Val0); Val: @HCBlock4Val0), 
    (RA: $31; Count: length(HCBlock4Val1); Val: @HCBlock4Val1), 
    (RA: $4E; Count: length(HCBlock4Val2); Val: @HCBlock4Val2), 
    (RA: $63; Count: length(HCBlock4Val3); Val: @HCBlock4Val3));
  HCBlock4: THCBlock = (
    Size: $74;
    RAC: length(HCBlock4RA); RA: @HCBlock4RA;
    ValC: length(HCBlock4Val); Val: @HCBlock4Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock5RA: array[0..0] of TRA = (
    (RA: $0; PN: 'RemoveBlock'; CN: ''));
  HCBlock5Val0: array[0..58] of byte = (
    $53, $56, $57, $55, $83, $C4, $F8, $8B, $D8, $8B, $FB, $8B, $32, $8B, $43, $08, 
    $3B, $F0, $72, $6C, $8B, $CE, $03, $4A, $04, $8B, $E8, $03, $6B, $0C, $3B, $CD, 
    $77, $5E, $3B, $F0, $75, $1B, $8B, $42, $04, $01, $43, $08, $8B, $42, $04, $29, 
    $43, $0C, $83, $7B, $0C, $00, $75, $44, $8B, $C3, $E8);
  HCBlock5Val1: array[0..48] of byte = (
    $EB, $3B, $8B, $0A, $8B, $72, $04, $03, $CE, $8B, $F8, $03, $7B, $0C, $3B, $CF, 
    $75, $05, $29, $73, $0C, $EB, $26, $8B, $0A, $03, $4A, $04, $89, $0C, $24, $2B, 
    $F9, $89, $7C, $24, $04, $8B, $12, $2B, $D0, $89, $53, $0C, $8B, $D4, $8B, $C3, 
    $E8);
  HCBlock5Val2: array[0..26] of byte = (
    $84, $C0, $75, $04, $33, $C0, $EB, $0C, $B0, $01, $EB, $08, $8B, $1B, $3B, $FB, 
    $75, $85, $33, $C0, $59, $5A, $5D, $5F, $5E, $5B, $C3);
  HCBlock5Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock5Val0); Val: @HCBlock5Val0), 
    (RA: $3F; Count: length(HCBlock5Val1); Val: @HCBlock5Val1), 
    (RA: $74; Count: length(HCBlock5Val2); Val: @HCBlock5Val2));
  HCBlock5: THCBlock = (
    Size: $90;
    RAC: length(HCBlock5RA); RA: @HCBlock5RA;
    ValC: length(HCBlock5Val); Val: @HCBlock5Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock6RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetSpace'; CN: ''));
  HCBlock6Val0: array[0..47] of byte = (
    $53, $56, $57, $8B, $DA, $8B, $F0, $81, $FE, $00, $00, $10, $00, $7D, $07, $BE, 
    $00, $00, $10, $00, $EB, $0C, $81, $C6, $FF, $FF, $00, $00, $81, $E6, $00, $00, 
    $FF, $FF, $89, $73, $04, $6A, $01, $68, $00, $20, $00, $00, $56, $6A, $00, $E8);
  HCBlock6Val1: array[0..10] of byte = (
    $8B, $F8, $89, $3B, $85, $FF, $74, $23, $8B, $D3, $B8);
  HCBlock6Val2: array[0..14] of byte = (
    $84, $C0, $75, $13, $68, $00, $80, $00, $00, $6A, $00, $8B, $03, $50, $E8);
  HCBlock6Val3: array[0..7] of byte = (
    $33, $C0, $89, $03, $5F, $5E, $5B, $C3);
  HCBlock6Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock6Val0); Val: @HCBlock6Val0), 
    (RA: $34; Count: length(HCBlock6Val1); Val: @HCBlock6Val1), 
    (RA: $48; Count: length(HCBlock6Val2); Val: @HCBlock6Val2), 
    (RA: $5B; Count: length(HCBlock6Val3); Val: @HCBlock6Val3));
  HCBlock6Vars: array[0..0] of TCVar = (
    (RA: $3F; VN: 'spaceRoot'));
  HCBlock6: THCBlock = (
    Size: $64;
    RAC: length(HCBlock6RA); RA: @HCBlock6RA;
    ValC: length(HCBlock6Val); Val: @HCBlock6Val;
    VarsC: length(HCBlock6Vars); Vars: @HCBlock6Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock7RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetSpaceAt'; CN: ''));
  HCBlock7Val0: array[0..30] of byte = (
    $53, $56, $57, $55, $8B, $D9, $8B, $F2, $8B, $E8, $C7, $43, $04, $00, $00, $10, 
    $00, $6A, $04, $68, $00, $20, $00, $00, $68, $00, $00, $10, $00, $55, $E8);
  HCBlock7Val1: array[0..32] of byte = (
    $8B, $F8, $89, $3B, $85, $FF, $75, $1F, $81, $C6, $FF, $FF, $00, $00, $81, $E6, 
    $00, $00, $FF, $FF, $89, $73, $04, $6A, $04, $68, $00, $20, $00, $00, $56, $55, 
    $E8);
  HCBlock7Val2: array[0..9] of byte = (
    $89, $03, $83, $3B, $00, $74, $23, $8B, $D3, $B8);
  HCBlock7Val3: array[0..14] of byte = (
    $84, $C0, $75, $13, $68, $00, $80, $00, $00, $6A, $00, $8B, $03, $50, $E8);
  HCBlock7Val4: array[0..8] of byte = (
    $33, $C0, $89, $03, $5D, $5F, $5E, $5B, $C3);
  HCBlock7Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock7Val0); Val: @HCBlock7Val0), 
    (RA: $23; Count: length(HCBlock7Val1); Val: @HCBlock7Val1), 
    (RA: $48; Count: length(HCBlock7Val2); Val: @HCBlock7Val2), 
    (RA: $5B; Count: length(HCBlock7Val3); Val: @HCBlock7Val3), 
    (RA: $6E; Count: length(HCBlock7Val4); Val: @HCBlock7Val4));
  HCBlock7Vars: array[0..0] of TCVar = (
    (RA: $52; VN: 'spaceRoot'));
  HCBlock7: THCBlock = (
    Size: $78;
    RAC: length(HCBlock7RA); RA: @HCBlock7RA;
    ValC: length(HCBlock7Val); Val: @HCBlock7Val;
    VarsC: length(HCBlock7Vars); Vars: @HCBlock7Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock8RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FreeSpace'; CN: ''));
  HCBlock8Val0: array[0..40] of byte = (
    $53, $56, $57, $55, $83, $C4, $EC, $89, $4C, $24, $04, $89, $14, $24, $C7, $44, 
    $24, $08, $FF, $FF, $FF, $FF, $33, $D2, $89, $54, $24, $0C, $8B, $E8, $8B, $04, 
    $24, $03, $C5, $89, $44, $24, $10, $8B, $1D);
  HCBlock8Val1: array[0..55] of byte = (
    $EB, $51, $8B, $3B, $8B, $73, $08, $3B, $EE, $77, $46, $8B, $C6, $03, $43, $0C, 
    $3B, $44, $24, $10, $77, $3B, $3B, $74, $24, $08, $73, $04, $89, $74, $24, $08, 
    $8B, $C6, $03, $43, $0C, $3B, $44, $24, $0C, $76, $04, $89, $44, $24, $0C, $68, 
    $00, $80, $00, $00, $6A, $00, $56, $E8);
  HCBlock8Val2: array[0..5] of byte = (
    $85, $C0, $75, $0A, $C7, $05);
  HCBlock8Val3: array[0..2] of byte = (
    $8B, $C3, $E8);
  HCBlock8Val4: array[0..3] of byte = (
    $8B, $DF, $81, $FB);
  HCBlock8Val5: array[0..49] of byte = (
    $75, $A7, $8B, $44, $24, $04, $33, $D2, $89, $10, $83, $7C, $24, $0C, $00, $74, 
    $19, $8B, $44, $24, $04, $8B, $54, $24, $08, $89, $10, $8B, $44, $24, $0C, $2B, 
    $44, $24, $08, $8B, $54, $24, $04, $89, $42, $04, $83, $C4, $14, $5D, $5F, $5E, 
    $5B, $C3);
  HCBlock8Val: array[0..5] of TVal = (
    (RA: $0; Count: length(HCBlock8Val0); Val: @HCBlock8Val0), 
    (RA: $2D; Count: length(HCBlock8Val1); Val: @HCBlock8Val1), 
    (RA: $69; Count: length(HCBlock8Val2); Val: @HCBlock8Val2), 
    (RA: $77; Count: length(HCBlock8Val3); Val: @HCBlock8Val3), 
    (RA: $7E; Count: length(HCBlock8Val4); Val: @HCBlock8Val4), 
    (RA: $86; Count: length(HCBlock8Val5); Val: @HCBlock8Val5));
  HCBlock8Vars: array[0..1] of TCVar = (
    (RA: $29; VN: 'spaceRoot'), 
    (RA: $6F; VN: 'heapErrorCode'));
  HCBlock8: THCBlock = (
    Size: $B8;
    RAC: length(HCBlock8RA); RA: @HCBlock8RA;
    ValC: length(HCBlock8Val); Val: @HCBlock8Val;
    VarsC: length(HCBlock8Vars); Vars: @HCBlock8Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock9RA: array[0..0] of TRA = (
    (RA: $0; PN: 'Commit'; CN: ''));
  HCBlock9Val0: array[0..63] of byte = (
    $53, $56, $57, $55, $83, $C4, $F4, $89, $4C, $24, $04, $89, $14, $24, $8B, $D0, 
    $8B, $EA, $81, $E5, $00, $F0, $FF, $FF, $03, $14, $24, $81, $C2, $FF, $0F, $00, 
    $00, $81, $E2, $00, $F0, $FF, $FF, $89, $54, $24, $08, $8B, $44, $24, $04, $89, 
    $28, $8B, $44, $24, $08, $2B, $C5, $8B, $54, $24, $04, $89, $42, $04, $8B, $35);
  HCBlock9Val1: array[0..41] of byte = (
    $EB, $3C, $8B, $5E, $08, $8B, $7E, $0C, $03, $FB, $3B, $EB, $76, $02, $8B, $DD, 
    $3B, $7C, $24, $08, $76, $04, $8B, $7C, $24, $08, $3B, $FB, $76, $1E, $6A, $04, 
    $68, $00, $10, $00, $00, $2B, $FB, $57, $53, $E8);
  HCBlock9Val2: array[0..17] of byte = (
    $85, $C0, $75, $0A, $8B, $44, $24, $04, $33, $D2, $89, $10, $EB, $0A, $8B, $36, 
    $81, $FE);
  HCBlock9Val3: array[0..9] of byte = (
    $75, $BC, $83, $C4, $0C, $5D, $5F, $5E, $5B, $C3);
  HCBlock9Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock9Val0); Val: @HCBlock9Val0), 
    (RA: $44; Count: length(HCBlock9Val1); Val: @HCBlock9Val1), 
    (RA: $72; Count: length(HCBlock9Val2); Val: @HCBlock9Val2), 
    (RA: $88; Count: length(HCBlock9Val3); Val: @HCBlock9Val3));
  HCBlock9Vars: array[0..0] of TCVar = (
    (RA: $40; VN: 'spaceRoot'));
  HCBlock9: THCBlock = (
    Size: $94;
    RAC: length(HCBlock9RA); RA: @HCBlock9RA;
    ValC: length(HCBlock9Val); Val: @HCBlock9Val;
    VarsC: length(HCBlock9Vars); Vars: @HCBlock9Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock10RA: array[0..0] of TRA = (
    (RA: $0; PN: 'Decommit'; CN: ''));
  HCBlock10Val0: array[0..48] of byte = (
    $53, $56, $57, $55, $51, $8B, $D8, $8B, $F3, $81, $C6, $FF, $0F, $00, $00, $81, 
    $E6, $00, $F0, $FF, $FF, $89, $34, $24, $8B, $EB, $03, $EA, $81, $E5, $00, $F0, 
    $FF, $FF, $8B, $04, $24, $89, $01, $8B, $C5, $2B, $04, $24, $89, $41, $04, $8B, 
    $35);
  HCBlock10Val1: array[0..37] of byte = (
    $EB, $38, $8B, $5E, $08, $8B, $7E, $0C, $03, $FB, $3B, $1C, $24, $73, $03, $8B, 
    $1C, $24, $3B, $EF, $73, $02, $8B, $FD, $3B, $FB, $76, $1C, $68, $00, $40, $00, 
    $00, $2B, $FB, $57, $53, $E8);
  HCBlock10Val2: array[0..5] of byte = (
    $85, $C0, $75, $0A, $C7, $05);
  HCBlock10Val3: array[0..3] of byte = (
    $8B, $36, $81, $FE);
  HCBlock10Val4: array[0..7] of byte = (
    $75, $C0, $5A, $5D, $5F, $5E, $5B, $C3);
  HCBlock10Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock10Val0); Val: @HCBlock10Val0), 
    (RA: $35; Count: length(HCBlock10Val1); Val: @HCBlock10Val1), 
    (RA: $5F; Count: length(HCBlock10Val2); Val: @HCBlock10Val2), 
    (RA: $6D; Count: length(HCBlock10Val3); Val: @HCBlock10Val3), 
    (RA: $75; Count: length(HCBlock10Val4); Val: @HCBlock10Val4));
  HCBlock10Vars: array[0..1] of TCVar = (
    (RA: $31; VN: 'spaceRoot'), 
    (RA: $65; VN: 'heapErrorCode'));
  HCBlock10: THCBlock = (
    Size: $80;
    RAC: length(HCBlock10RA); RA: @HCBlock10RA;
    ValC: length(HCBlock10Val); Val: @HCBlock10Val;
    VarsC: length(HCBlock10Vars); Vars: @HCBlock10Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock11RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetCommitted'; CN: ''));
  HCBlock11Val0: array[0..11] of byte = (
    $53, $56, $57, $55, $83, $C4, $F8, $8B, $F2, $8B, $F8, $BD);
  HCBlock11Val1: array[0..29] of byte = (
    $81, $C7, $FF, $3F, $00, $00, $81, $E7, $00, $C0, $FF, $FF, $8B, $5D, $00, $EB,
    $33, $3B, $7B, $0C, $7F, $2C, $8B, $CE, $8B, $D7, $8B, $43, $08, $E8);
  HCBlock11Val2: array[0..25] of byte = (
    $83, $3E, $00, $74, $50, $8B, $46, $04, $01, $43, $08, $8B, $46, $04, $29, $43,
    $0C, $83, $7B, $0C, $00, $75, $3E, $8B, $C3, $E8);
  HCBlock11Val3: array[0..12] of byte = (
    $EB, $35, $8B, $1B, $3B, $DD, $75, $C9, $8B, $D6, $8B, $C7, $E8);
  HCBlock11Val4: array[0..11] of byte = (
    $83, $3E, $00, $74, $21, $8B, $CC, $8B, $D6, $8B, $C5, $E8);
  HCBlock11Val5: array[0..13] of byte = (
    $83, $3C, $24, $00, $75, $A5, $8B, $CC, $8B, $56, $04, $8B, $06, $E8);
  HCBlock11Val6: array[0..10] of byte = (
    $33, $C0, $89, $06, $59, $5A, $5D, $5F, $5E, $5B, $C3);
  HCBlock11Val: array[0..6] of TVal = (
    (RA: $0; Count: length(HCBlock11Val0); Val: @HCBlock11Val0), 
    (RA: $10; Count: length(HCBlock11Val1); Val: @HCBlock11Val1), 
    (RA: $32; Count: length(HCBlock11Val2); Val: @HCBlock11Val2), 
    (RA: $50; Count: length(HCBlock11Val3); Val: @HCBlock11Val3), 
    (RA: $61; Count: length(HCBlock11Val4); Val: @HCBlock11Val4), 
    (RA: $71; Count: length(HCBlock11Val5); Val: @HCBlock11Val5), 
    (RA: $83; Count: length(HCBlock11Val6); Val: @HCBlock11Val6));
  HCBlock11Vars: array[0..0] of TCVar = (
    (RA: $C; VN: 'decommittedRoot'));
  HCBlock11: THCBlock = (
    Size: $90;
    RAC: length(HCBlock11RA); RA: @HCBlock11RA;
    ValC: length(HCBlock11Val); Val: @HCBlock11Val;
    VarsC: length(HCBlock11Vars); Vars: @HCBlock11Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock12RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetCommittedAt'; CN: ''));
  HCBlock12Val0: array[0..14] of byte = (
    $53, $56, $57, $55, $83, $C4, $EC, $89, $0C, $24, $8B, $FA, $8B, $F0, $BD);
  HCBlock12Val1: array[0..57] of byte = (
    $81, $C7, $FF, $3F, $00, $00, $81, $E7, $00, $C0, $FF, $FF, $8B, $5D, $00, $EB, 
    $02, $8B, $1B, $3B, $DD, $74, $05, $3B, $73, $08, $75, $F5, $3B, $73, $08, $75, 
    $57, $3B, $7B, $0C, $0F, $8E, $96, $00, $00, $00, $8D, $4C, $24, $04, $8B, $D7, 
    $2B, $53, $0C, $8B, $43, $08, $03, $43, $0C, $E8);
  HCBlock12Val2: array[0..17] of byte = (
    $83, $7C, $24, $04, $00, $74, $33, $8D, $4C, $24, $0C, $8D, $54, $24, $04, $8B, 
    $C5, $E8);
  HCBlock12Val3: array[0..19] of byte = (
    $83, $7C, $24, $0C, $00, $75, $B1, $8D, $4C, $24, $0C, $8B, $54, $24, $08, $8B, 
    $44, $24, $04, $E8);
  HCBlock12Val4: array[0..20] of byte = (
    $8B, $04, $24, $33, $D2, $89, $10, $E9, $90, $00, $00, $00, $8D, $4C, $24, $04, 
    $8B, $D7, $8B, $C6, $E8);
  HCBlock12Val5: array[0..17] of byte = (
    $83, $7C, $24, $04, $00, $74, $34, $8D, $4C, $24, $0C, $8D, $54, $24, $04, $8B, 
    $C5, $E8);
  HCBlock12Val6: array[0..23] of byte = (
    $83, $7C, $24, $0C, $00, $0F, $85, $66, $FF, $FF, $FF, $8D, $4C, $24, $0C, $8B, 
    $54, $24, $08, $8B, $44, $24, $04, $E8);
  HCBlock12Val7: array[0..28] of byte = (
    $8B, $04, $24, $33, $D2, $89, $10, $EB, $48, $8B, $6B, $08, $3B, $F5, $75, $3A, 
    $3B, $7B, $0C, $7F, $35, $8B, $0C, $24, $8B, $D7, $8B, $C5, $E8);
  HCBlock12Val8: array[0..34] of byte = (
    $8B, $04, $24, $83, $38, $00, $74, $28, $8B, $04, $24, $8B, $40, $04, $01, $43, 
    $08, $8B, $04, $24, $8B, $40, $04, $29, $43, $0C, $83, $7B, $0C, $00, $75, $10,
    $8B, $C3, $E8);
  HCBlock12Val9: array[0..16] of byte = (
    $EB, $07, $8B, $04, $24, $33, $D2, $89, $10, $83, $C4, $14, $5D, $5F, $5E, $5B, 
    $C3);
  HCBlock12Val: array[0..9] of TVal = (
    (RA: $0; Count: length(HCBlock12Val0); Val: @HCBlock12Val0), 
    (RA: $13; Count: length(HCBlock12Val1); Val: @HCBlock12Val1), 
    (RA: $51; Count: length(HCBlock12Val2); Val: @HCBlock12Val2), 
    (RA: $67; Count: length(HCBlock12Val3); Val: @HCBlock12Val3), 
    (RA: $7F; Count: length(HCBlock12Val4); Val: @HCBlock12Val4), 
    (RA: $98; Count: length(HCBlock12Val5); Val: @HCBlock12Val5), 
    (RA: $AE; Count: length(HCBlock12Val6); Val: @HCBlock12Val6), 
    (RA: $CA; Count: length(HCBlock12Val7); Val: @HCBlock12Val7), 
    (RA: $EB; Count: length(HCBlock12Val8); Val: @HCBlock12Val8),
    (RA: $112; Count: length(HCBlock12Val9); Val: @HCBlock12Val9));
  HCBlock12Vars: array[0..0] of TCVar = (
    (RA: $F; VN: 'decommittedRoot'));
  HCBlock12: THCBlock = (
    Size: $124;
    RAC: length(HCBlock12RA); RA: @HCBlock12RA;
    ValC: length(HCBlock12Val); Val: @HCBlock12Val;
    VarsC: length(HCBlock12Vars); Vars: @HCBlock12Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock13RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FreeCommitted'; CN: ''));
  HCBlock13Val0: array[0..46] of byte = (
    $53, $56, $57, $83, $C4, $EC, $8B, $F9, $89, $14, $24, $8D, $98, $FF, $3F, $00, 
    $00, $81, $E3, $00, $C0, $FF, $FF, $8B, $34, $24, $03, $F0, $81, $E6, $00, $C0, 
    $FF, $FF, $3B, $DE, $73, $5B, $8B, $CF, $8B, $D6, $2B, $D3, $8B, $C3, $E8);
  HCBlock13Val1: array[0..6] of byte = (
    $8D, $4C, $24, $04, $8B, $D7, $B8);
  HCBlock13Val2: array[0..18] of byte = (
    $8B, $5C, $24, $04, $85, $DB, $74, $1F, $8D, $4C, $24, $0C, $8B, $54, $24, $08, 
    $8B, $C3, $E8);
  HCBlock13Val3: array[0..27] of byte = (
    $8B, $44, $24, $0C, $89, $44, $24, $04, $8B, $44, $24, $10, $89, $44, $24, $08, 
    $83, $7C, $24, $04, $00, $74, $14, $8D, $54, $24, $04, $B8);
  HCBlock13Val4: array[0..12] of byte = (
    $EB, $04, $33, $C0, $89, $07, $83, $C4, $14, $5F, $5E, $5B, $C3);
  HCBlock13Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock13Val0); Val: @HCBlock13Val0), 
    (RA: $33; Count: length(HCBlock13Val1); Val: @HCBlock13Val1), 
    (RA: $43; Count: length(HCBlock13Val2); Val: @HCBlock13Val2), 
    (RA: $5A; Count: length(HCBlock13Val3); Val: @HCBlock13Val3), 
    (RA: $7F; Count: length(HCBlock13Val4); Val: @HCBlock13Val4));
  HCBlock13Vars: array[0..0] of TCVar = (
    (RA: $3A; VN: 'decommittedRoot'));
  HCBlock13: THCBlock = (
    Size: $8C;
    RAC: length(HCBlock13RA); RA: @HCBlock13RA;
    ValC: length(HCBlock13Val); Val: @HCBlock13Val;
    VarsC: length(HCBlock13Vars); Vars: @HCBlock13Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock14RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InitAllocator'; CN: ''));
  HCBlock14Val0: array[0..6] of byte = (
    $55, $8B, $EC, $33, $D2, $55, $68);
  HCBlock14Val1: array[0..6] of byte = (
    $64, $FF, $32, $64, $89, $22, $68);
  HCBlock14Val2: array[0..0] of byte = (
    $E8);
  HCBlock14Val3: array[0..1] of byte = (
    $80, $3D);
  HCBlock14Val4: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock14Val5: array[0..0] of byte = (
    $E8);
  HCBlock14Val6: array[0..0] of byte = (
    $B8);
  HCBlock14Val7: array[0..0] of byte = (
    $E8);
  HCBlock14Val8: array[0..0] of byte = (
    $B8);
  HCBlock14Val9: array[0..0] of byte = (
    $E8);
  HCBlock14Val10: array[0..0] of byte = (
    $B8);
  HCBlock14Val11: array[0..0] of byte = (
    $E8);
  HCBlock14Val12: array[0..7] of byte = (
    $68, $F8, $0F, $00, $00, $6A, $00, $E8);
  HCBlock14Val13: array[0..0] of byte = (
    $A3);
  HCBlock14Val14: array[0..1] of byte = (
    $83, $3D);
  HCBlock14Val15: array[0..8] of byte = (
    $74, $2F, $B8, $03, $00, $00, $00, $8B, $15);
  HCBlock14Val16: array[0..14] of byte = (
    $33, $C9, $89, $4C, $82, $F4, $40, $3D, $01, $04, $00, $00, $75, $EC, $B8);
  HCBlock14Val17: array[0..5] of byte = (
    $89, $40, $04, $89, $00, $A3);
  HCBlock14Val18: array[0..1] of byte = (
    $C6, $05);
  HCBlock14Val19: array[0..8] of byte = (
    $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock14Val20: array[0..1] of byte = (
    $80, $3D);
  HCBlock14Val21: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock14Val22: array[0..0] of byte = (
    $E8);
  HCBlock14Val23: array[0..1] of byte = (
    $C3, $E9);
  HCBlock14Val24: array[0..2] of byte = (
    $EB, $E5, $A0);
  HCBlock14Val25: array[0..1] of byte = (
    $5D, $C3);
  HCBlock14Val: array[0..25] of TVal = (
    (RA: $0; Count: length(HCBlock14Val0); Val: @HCBlock14Val0), 
    (RA: $B; Count: length(HCBlock14Val1); Val: @HCBlock14Val1), 
    (RA: $16; Count: length(HCBlock14Val2); Val: @HCBlock14Val2), 
    (RA: $1B; Count: length(HCBlock14Val3); Val: @HCBlock14Val3), 
    (RA: $22; Count: length(HCBlock14Val4); Val: @HCBlock14Val4), 
    (RA: $29; Count: length(HCBlock14Val5); Val: @HCBlock14Val5), 
    (RA: $2E; Count: length(HCBlock14Val6); Val: @HCBlock14Val6), 
    (RA: $33; Count: length(HCBlock14Val7); Val: @HCBlock14Val7), 
    (RA: $38; Count: length(HCBlock14Val8); Val: @HCBlock14Val8), 
    (RA: $3D; Count: length(HCBlock14Val9); Val: @HCBlock14Val9), 
    (RA: $42; Count: length(HCBlock14Val10); Val: @HCBlock14Val10), 
    (RA: $47; Count: length(HCBlock14Val11); Val: @HCBlock14Val11),
    (RA: $4C; Count: length(HCBlock14Val12); Val: @HCBlock14Val12), 
    (RA: $58; Count: length(HCBlock14Val13); Val: @HCBlock14Val13), 
    (RA: $5D; Count: length(HCBlock14Val14); Val: @HCBlock14Val14), 
    (RA: $64; Count: length(HCBlock14Val15); Val: @HCBlock14Val15), 
    (RA: $71; Count: length(HCBlock14Val16); Val: @HCBlock14Val16), 
    (RA: $84; Count: length(HCBlock14Val17); Val: @HCBlock14Val17), 
    (RA: $8E; Count: length(HCBlock14Val18); Val: @HCBlock14Val18), 
    (RA: $95; Count: length(HCBlock14Val19); Val: @HCBlock14Val19), 
    (RA: $A2; Count: length(HCBlock14Val20); Val: @HCBlock14Val20), 
    (RA: $A9; Count: length(HCBlock14Val21); Val: @HCBlock14Val21), 
    (RA: $B0; Count: length(HCBlock14Val22); Val: @HCBlock14Val22), 
    (RA: $B5; Count: length(HCBlock14Val23); Val: @HCBlock14Val23), 
    (RA: $BB; Count: length(HCBlock14Val24); Val: @HCBlock14Val24), 
    (RA: $C2; Count: length(HCBlock14Val25); Val: @HCBlock14Val25));
  HCBlock14Vars: array[0..8] of TCVar = (
    (RA: $12; VN: 'heapLock'), 
    (RA: $1D; VN: 'IsMultiThread'), 
    (RA: $2F; VN: 'spaceRoot'), 
    (RA: $39; VN: 'decommittedRoot'), 
    (RA: $43; VN: 'committedRoot'), 
    (RA: $59; VN: 'smallTab'), 
    (RA: $80; VN: 'avail'), 
    (RA: $8A; VN: 'rover'), 
    (RA: $90; VN: 'initialized'));
  HCBlock14IA: array[0..1] of TIA = (
    (RA: $7; RRA: $B6), 
    (RA: $9E; RRA: $BD));
  HCBlock14: THCBlock = (
    Size: $C4;
    RAC: length(HCBlock14RA); RA: @HCBlock14RA;
    ValC: length(HCBlock14Val); Val: @HCBlock14Val;
    VarsC: length(HCBlock14Vars); Vars: @HCBlock14Vars;
    IAC: length(HCBlock14IA); IA: @HCBlock14IA;
    PRC: 0; PR: nil);

  HCBlock15RA: array[0..0] of TRA = (
    (RA: $0; PN: 'UniniAllocator'; CN: ''));
  HCBlock15Val0: array[0..5] of byte = (
    $55, $8B, $EC, $53, $80, $3D);
  HCBlock15Val1: array[0..9] of byte = (
    $0F, $84, $CC, $00, $00, $00, $33, $D2, $55, $68);
  HCBlock15Val2: array[0..7] of byte = (
    $64, $FF, $32, $64, $89, $22, $80, $3D);
  HCBlock15Val3: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock15Val4: array[0..0] of byte = (
    $E8);
  HCBlock15Val5: array[0..1] of byte = (
    $C6, $05);
  HCBlock15Val6: array[0..0] of byte = (
    $A1);
  HCBlock15Val7: array[0..1] of byte = (
    $50, $E8);
  HCBlock15Val8: array[0..2] of byte = (
    $33, $C0, $A3);
  HCBlock15Val9: array[0..1] of byte = (
    $8B, $1D);
  HCBlock15Val10: array[0..13] of byte = (
    $EB, $12, $68, $00, $80, $00, $00, $6A, $00, $8B, $43, $08, $50, $E8);
  HCBlock15Val11: array[0..3] of byte = (
    $8B, $1B, $81, $FB);
  HCBlock15Val12: array[0..2] of byte = (
    $75, $E6, $B8);
  HCBlock15Val13: array[0..0] of byte = (
    $E8);
  HCBlock15Val14: array[0..0] of byte = (
    $B8);
  HCBlock15Val15: array[0..0] of byte = (
    $E8);
  HCBlock15Val16: array[0..0] of byte = (
    $B8);
  HCBlock15Val17: array[0..0] of byte = (
    $E8);
  HCBlock15Val18: array[0..0] of byte = (
    $A1);
  HCBlock15Val19: array[0..7] of byte = (
    $85, $C0, $74, $17, $8B, $10, $89, $15);
  HCBlock15Val20: array[0..1] of byte = (
    $50, $E8);
  HCBlock15Val21: array[0..0] of byte = (
    $A1);
  HCBlock15Val22: array[0..12] of byte = (
    $85, $C0, $75, $E9, $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock15Val23: array[0..1] of byte = (
    $80, $3D);
  HCBlock15Val24: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock15Val25: array[0..0] of byte = (
    $E8);
  HCBlock15Val26: array[0..0] of byte = (
    $68);
  HCBlock15Val27: array[0..0] of byte = (
    $E8);
  HCBlock15Val28: array[0..1] of byte = (
    $C3, $E9);
  HCBlock15Val29: array[0..4] of byte = (
    $EB, $DB, $5B, $5D, $C3);
  HCBlock15Val: array[0..29] of TVal = (
    (RA: $0; Count: length(HCBlock15Val0); Val: @HCBlock15Val0), 
    (RA: $B; Count: length(HCBlock15Val1); Val: @HCBlock15Val1), 
    (RA: $19; Count: length(HCBlock15Val2); Val: @HCBlock15Val2), 
    (RA: $26; Count: length(HCBlock15Val3); Val: @HCBlock15Val3), 
    (RA: $2D; Count: length(HCBlock15Val4); Val: @HCBlock15Val4), 
    (RA: $32; Count: length(HCBlock15Val5); Val: @HCBlock15Val5), 
    (RA: $39; Count: length(HCBlock15Val6); Val: @HCBlock15Val6), 
    (RA: $3E; Count: length(HCBlock15Val7); Val: @HCBlock15Val7), 
    (RA: $44; Count: length(HCBlock15Val8); Val: @HCBlock15Val8), 
    (RA: $4B; Count: length(HCBlock15Val9); Val: @HCBlock15Val9), 
    (RA: $51; Count: length(HCBlock15Val10); Val: @HCBlock15Val10), 
    (RA: $63; Count: length(HCBlock15Val11); Val: @HCBlock15Val11), 
    (RA: $6B; Count: length(HCBlock15Val12); Val: @HCBlock15Val12), 
    (RA: $72; Count: length(HCBlock15Val13); Val: @HCBlock15Val13), 
    (RA: $77; Count: length(HCBlock15Val14); Val: @HCBlock15Val14), 
    (RA: $7C; Count: length(HCBlock15Val15); Val: @HCBlock15Val15), 
    (RA: $81; Count: length(HCBlock15Val16); Val: @HCBlock15Val16), 
    (RA: $86; Count: length(HCBlock15Val17); Val: @HCBlock15Val17), 
    (RA: $8B; Count: length(HCBlock15Val18); Val: @HCBlock15Val18), 
    (RA: $90; Count: length(HCBlock15Val19); Val: @HCBlock15Val19), 
    (RA: $9C; Count: length(HCBlock15Val20); Val: @HCBlock15Val20), 
    (RA: $A2; Count: length(HCBlock15Val21); Val: @HCBlock15Val21), 
    (RA: $A7; Count: length(HCBlock15Val22); Val: @HCBlock15Val22), 
    (RA: $B8; Count: length(HCBlock15Val23); Val: @HCBlock15Val23), 
    (RA: $BF; Count: length(HCBlock15Val24); Val: @HCBlock15Val24), 
    (RA: $C6; Count: length(HCBlock15Val25); Val: @HCBlock15Val25),
    (RA: $CB; Count: length(HCBlock15Val26); Val: @HCBlock15Val26), 
    (RA: $D0; Count: length(HCBlock15Val27); Val: @HCBlock15Val27), 
    (RA: $D5; Count: length(HCBlock15Val28); Val: @HCBlock15Val28), 
    (RA: $DB; Count: length(HCBlock15Val29); Val: @HCBlock15Val29));
  HCBlock15Vars: array[0..7] of TCVar = (
    (RA: $6; VN: 'initialized'), 
    (RA: $21; VN: 'IsMultiThread'), 
    (RA: $29; VN: 'heapLock'), 
    (RA: $3A; VN: 'smallTab'), 
    (RA: $4D; VN: 'spaceRoot'), 
    (RA: $78; VN: 'decommittedRoot'), 
    (RA: $82; VN: 'committedRoot'), 
    (RA: $8C; VN: 'blockDescBlockList'));
  HCBlock15IA: array[0..1] of TIA = (
    (RA: $15; RRA: $D6), 
    (RA: $B4; RRA: $DD));
  HCBlock15: THCBlock = (
    Size: $E0;
    RAC: length(HCBlock15RA); RA: @HCBlock15RA;
    ValC: length(HCBlock15Val); Val: @HCBlock15Val;
    VarsC: length(HCBlock15Vars); Vars: @HCBlock15Vars;
    IAC: length(HCBlock15IA); IA: @HCBlock15IA;
    PRC: 0; PR: nil);

  HCBlock16RA: array[0..0] of TRA = (
    (RA: $0; PN: 'DeleteFree'; CN: ''));
  HCBlock16Val0: array[0..2] of byte = (
    $53, $3B, $05);
  HCBlock16Val1: array[0..6] of byte = (
    $75, $09, $8B, $50, $04, $89, $15);
  HCBlock16Val2: array[0..28] of byte = (
    $8B, $50, $04, $8B, $48, $08, $81, $F9, $00, $10, $00, $00, $7F, $38, $3B, $C2,
    $75, $17, $85, $C9, $79, $03, $83, $C1, $03, $C1, $F9, $02, $A1);
  HCBlock16Val3: array[0..19] of byte = (
    $33, $D2, $89, $54, $88, $F4, $EB, $24, $85, $C9, $79, $03, $83, $C1, $03, $C1,
    $F9, $02, $8B, $1D);
  HCBlock16Val4: array[0..21] of byte = (
    $89, $54, $8B, $F4, $8B, $00, $89, $02, $89, $50, $04, $5B, $C3, $8B, $00, $89, 
    $02, $89, $50, $04, $5B, $C3);
  HCBlock16Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock16Val0); Val: @HCBlock16Val0), 
    (RA: $7; Count: length(HCBlock16Val1); Val: @HCBlock16Val1), 
    (RA: $12; Count: length(HCBlock16Val2); Val: @HCBlock16Val2), 
    (RA: $33; Count: length(HCBlock16Val3); Val: @HCBlock16Val3), 
    (RA: $4B; Count: length(HCBlock16Val4); Val: @HCBlock16Val4));
  HCBlock16Vars: array[0..1] of TCVar = (
    (RA: $3; VN: 'rover'), 
    (RA: $2F; VN: 'smallTab'));
  HCBlock16: THCBlock = (
    Size: $64;
    RAC: length(HCBlock16RA); RA: @HCBlock16RA;
    ValC: length(HCBlock16Val); Val: @HCBlock16Val;
    VarsC: length(HCBlock16Vars); Vars: @HCBlock16Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock17RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FindCommitted'; CN: ''));
  HCBlock17Val0: array[0..1] of byte = (
    $8B, $15);
  HCBlock17Val1: array[0..19] of byte = (
    $EB, $10, $8B, $4A, $08, $3B, $C1, $72, $07, $03, $4A, $0C, $3B, $C1, $72, $16,
    $8B, $12, $81, $FA);
  HCBlock17Val2: array[0..3] of byte = (
    $75, $E8, $C7, $05);
  HCBlock17Val3: array[0..4] of byte = (
    $33, $D2, $8B, $C2, $C3);
  HCBlock17Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock17Val0); Val: @HCBlock17Val0), 
    (RA: $6; Count: length(HCBlock17Val1); Val: @HCBlock17Val1), 
    (RA: $1E; Count: length(HCBlock17Val2); Val: @HCBlock17Val2), 
    (RA: $2A; Count: length(HCBlock17Val3); Val: @HCBlock17Val3));
  HCBlock17Vars: array[0..1] of TCVar = (
    (RA: $2; VN: 'committedRoot'), 
    (RA: $22; VN: 'heapErrorCode'));
  HCBlock17: THCBlock = (
    Size: $30;
    RAC: length(HCBlock17RA); RA: @HCBlock17RA;
    ValC: length(HCBlock17Val); Val: @HCBlock17Val;
    VarsC: length(HCBlock17Vars); Vars: @HCBlock17Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock18RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FillBeforeGap'; CN: ''));
  HCBlock18Val0: array[0..22] of byte = (
    $53, $8B, $CA, $83, $E9, $04, $8D, $1C, $01, $83, $FA, $10, $7C, $0F, $C7, $03, 
    $07, $00, $00, $80, $8B, $D1, $E8);
  HCBlock18Val1: array[0..20] of byte = (
    $5B, $C3, $83, $FA, $04, $7C, $0C, $8B, $CA, $81, $C9, $02, $00, $00, $80, $89, 
    $08, $89, $0B, $5B, $C3);
  HCBlock18Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock18Val0); Val: @HCBlock18Val0),
    (RA: $1B; Count: length(HCBlock18Val1); Val: @HCBlock18Val1));
  HCBlock18: THCBlock = (
    Size: $30;
    RAC: length(HCBlock18RA); RA: @HCBlock18RA;
    ValC: length(HCBlock18Val); Val: @HCBlock18Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock19RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InternalFreeMem'; CN: ''));
  HCBlock19Val0: array[0..17] of byte = (
    $8B, $D0, $83, $EA, $04, $8B, $12, $81, $E2, $FC, $FF, $FF, $7F, $83, $EA, $04, 
    $01, $15);
  HCBlock19Val1: array[0..0] of byte = (
    $C3);
  HCBlock19Val: array[0..1] of TVal = (
    (RA: $6; Count: length(HCBlock19Val0); Val: @HCBlock19Val0),
    (RA: $21; Count: length(HCBlock19Val1); Val: @HCBlock19Val1));
  HCBlock19Vars: array[0..1] of TCVar = (
    (RA: $2; VN: 'AllocMemCount'),
    (RA: $18; VN: 'AllocMemSize'));
  HCBlock19: THCBlock = (
    Size: $24;
    RAC: length(HCBlock19RA); RA: @HCBlock19RA;
    ValC: length(HCBlock19Val); Val: @HCBlock19Val;
    VarsC: length(HCBlock19Vars); Vars: @HCBlock19Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock20RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FillAfterGap'; CN: ''));
  HCBlock20Val0: array[0..13] of byte = (
    $83, $FA, $0C, $7C, $0E, $83, $CA, $02, $89, $10, $83, $C0, $04, $E8);
  HCBlock20Val1: array[0..21] of byte = (
    $C3, $83, $FA, $04, $7C, $0A, $8B, $CA, $81, $C9, $02, $00, $00, $80, $89, $08, 
    $03, $C2, $83, $20, $FE, $C3);
  HCBlock20Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock20Val0); Val: @HCBlock20Val0), 
    (RA: $12; Count: length(HCBlock20Val1); Val: @HCBlock20Val1));
  HCBlock20: THCBlock = (
    Size: $28;
    RAC: length(HCBlock20RA); RA: @HCBlock20RA;
    ValC: length(HCBlock20Val); Val: @HCBlock20Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock21RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FillerSizeBeforeGap'; CN: ''));
  HCBlock21Val0: array[0..26] of byte = (
    $53, $56, $8B, $D0, $83, $EA, $04, $8B, $12, $8B, $CA, $81, $E1, $02, $00, $00, 
    $80, $81, $F9, $02, $00, $00, $80, $74, $0A, $C7, $05);
  HCBlock21Val1: array[0..23] of byte = (
    $8B, $DA, $81, $E3, $FC, $FF, $FF, $7F, $2B, $C3, $8B, $C8, $33, $11, $F7, $C2, 
    $FE, $FF, $FF, $FF, $74, $0A, $C7, $05);
  HCBlock21Val2: array[0..21] of byte = (
    $F6, $01, $01, $74, $20, $8B, $D0, $83, $EA, $0C, $8B, $72, $08, $2B, $C6, $3B, 
    $70, $08, $74, $0A, $C7, $05);
  HCBlock21Val3: array[0..0] of byte = (
    $E8);
  HCBlock21Val4: array[0..6] of byte = (
    $03, $DE, $8B, $C3, $5E, $5B, $C3);
  HCBlock21Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock21Val0); Val: @HCBlock21Val0), 
    (RA: $23; Count: length(HCBlock21Val1); Val: @HCBlock21Val1), 
    (RA: $43; Count: length(HCBlock21Val2); Val: @HCBlock21Val2), 
    (RA: $61; Count: length(HCBlock21Val3); Val: @HCBlock21Val3), 
    (RA: $66; Count: length(HCBlock21Val4); Val: @HCBlock21Val4));
  HCBlock21Vars: array[0..0] of TCVar = (
    (RA: $1B; VN: 'heapErrorCode'));
  HCBlock21: THCBlock = (
    Size: $70;
    RAC: length(HCBlock21RA); RA: @HCBlock21RA;
    ValC: length(HCBlock21Val); Val: @HCBlock21Val;
    VarsC: length(HCBlock21Vars); Vars: @HCBlock21Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock22RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FillerSizeAfterGap'; CN: ''));
  HCBlock22Val0: array[0..35] of byte = (
    $53, $56, $57, $8B, $D8, $33, $FF, $8B, $03, $A9, $00, $00, $00, $80, $74, $0B, 
    $25, $FC, $FF, $FF, $7F, $03, $F8, $03, $D8, $8B, $03, $A8, $02, $75, $13, $8B, 
    $F3, $8B, $C6, $E8);
  HCBlock22Val1: array[0..15] of byte = (
    $8B, $46, $08, $03, $F8, $03, $D8, $83, $23, $FE, $8B, $C7, $5F, $5E, $5B, $C3);
  HCBlock22Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock22Val0); Val: @HCBlock22Val0), 
    (RA: $28; Count: length(HCBlock22Val1); Val: @HCBlock22Val1));
  HCBlock22: THCBlock = (
    Size: $38;
    RAC: length(HCBlock22RA); RA: @HCBlock22RA;
    ValC: length(HCBlock22Val); Val: @HCBlock22Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock23RA: array[0..0] of TRA = (
    (RA: $0; PN: 'DecommitFree'; CN: ''));
  HCBlock23Val0: array[0..13] of byte = (
    $53, $56, $57, $55, $83, $C4, $F8, $8B, $FA, $8B, $F0, $8B, $C6, $E8);
  HCBlock23Val1: array[0..46] of byte = (
    $8B, $D8, $8B, $6B, $08, $8B, $C5, $03, $43, $0C, $8B, $D0, $8D, $0C, $37, $2B, 
    $D1, $83, $FA, $0C, $7F, $04, $8B, $F8, $2B, $FE, $8B, $C6, $2B, $C5, $83, $F8, 
    $0C, $7D, $12, $8B, $CC, $8B, $D6, $2B, $53, $08, $03, $D7, $8B, $C5, $E8);
  HCBlock23Val2: array[0..12] of byte = (
    $EB, $0F, $8B, $CC, $8B, $D7, $83, $EA, $04, $8D, $46, $04, $E8);
  HCBlock23Val3: array[0..17] of byte = (
    $8B, $2C, $24, $85, $ED, $75, $04, $33, $C0, $EB, $30, $8B, $D5, $2B, $D6, $8B, 
    $C6, $E8);
  HCBlock23Val4: array[0..21] of byte = (
    $8B, $C5, $03, $44, $24, $04, $8B, $53, $08, $03, $53, $0C, $3B, $C2, $73, $0A, 
    $8D, $14, $37, $2B, $D0, $E8);
  HCBlock23Val5: array[0..4] of byte = (
    $8B, $D4, $8B, $C3, $E8);
  HCBlock23Val6: array[0..8] of byte = (
    $B0, $01, $59, $5A, $5D, $5F, $5E, $5B, $C3);
  HCBlock23Val: array[0..6] of TVal = (
    (RA: $0; Count: length(HCBlock23Val0); Val: @HCBlock23Val0), 
    (RA: $12; Count: length(HCBlock23Val1); Val: @HCBlock23Val1), 
    (RA: $45; Count: length(HCBlock23Val2); Val: @HCBlock23Val2), 
    (RA: $56; Count: length(HCBlock23Val3); Val: @HCBlock23Val3), 
    (RA: $6C; Count: length(HCBlock23Val4); Val: @HCBlock23Val4),
    (RA: $86; Count: length(HCBlock23Val5); Val: @HCBlock23Val5), 
    (RA: $8F; Count: length(HCBlock23Val6); Val: @HCBlock23Val6));
  HCBlock23: THCBlock = (
    Size: $98;
    RAC: length(HCBlock23RA); RA: @HCBlock23RA;
    ValC: length(HCBlock23Val); Val: @HCBlock23Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock24RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InsertFree'; CN: ''));
  HCBlock24Val0: array[0..42] of byte = (
    $53, $56, $57, $8B, $F2, $8B, $F8, $8B, $DF, $89, $73, $08, $8B, $C3, $03, $C6, 
    $83, $E8, $0C, $89, $70, $08, $81, $FE, $00, $10, $00, $00, $7F, $37, $8B, $D6, 
    $85, $D2, $79, $03, $83, $C2, $03, $C1, $FA, $02, $A1);
  HCBlock24Val1: array[0..8] of byte = (
    $8B, $44, $90, $F4, $85, $C0, $75, $10, $A1);
  HCBlock24Val2: array[0..37] of byte = (
    $89, $5C, $90, $F4, $89, $5B, $04, $89, $1B, $EB, $3A, $8B, $10, $89, $43, $04, 
    $89, $13, $89, $18, $89, $5A, $04, $EB, $2C, $81, $FE, $00, $3C, $00, $00, $7C, 
    $0D, $8B, $D6, $8B, $C7, $E8);
  HCBlock24Val3: array[0..4] of byte = (
    $84, $C0, $75, $17, $A1);
  HCBlock24Val4: array[0..1] of byte = (
    $89, $1D);
  HCBlock24Val5: array[0..15] of byte = (
    $8B, $10, $89, $43, $04, $89, $13, $89, $18, $89, $5A, $04, $5F, $5E, $5B, $C3);
  HCBlock24Val: array[0..5] of TVal = (
    (RA: $0; Count: length(HCBlock24Val0); Val: @HCBlock24Val0), 
    (RA: $2F; Count: length(HCBlock24Val1); Val: @HCBlock24Val1),
    (RA: $3C; Count: length(HCBlock24Val2); Val: @HCBlock24Val2), 
    (RA: $66; Count: length(HCBlock24Val3); Val: @HCBlock24Val3), 
    (RA: $6F; Count: length(HCBlock24Val4); Val: @HCBlock24Val4), 
    (RA: $75; Count: length(HCBlock24Val5); Val: @HCBlock24Val5));
  HCBlock24Vars: array[0..1] of TCVar = (
    (RA: $2B; VN: 'smallTab'), 
    (RA: $6B; VN: 'rover'));
  HCBlock24: THCBlock = (
    Size: $88;
    RAC: length(HCBlock24RA); RA: @HCBlock24RA;
    ValC: length(HCBlock24Val); Val: @HCBlock24Val;
    VarsC: length(HCBlock24Vars); Vars: @HCBlock24Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock25RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FreeCurAlloc'; CN: ''));
  HCBlock25Val0: array[0..1] of byte = (
    $83, $3D);
  HCBlock25Val1: array[0..3] of byte = (
    $7E, $40, $83, $3D);
  HCBlock25Val2: array[0..3] of byte = (
    $7D, $0C, $C7, $05);
  HCBlock25Val3: array[0..2] of byte = (
    $EB, $2B, $A1);
  HCBlock25Val4: array[0..4] of byte = (
    $83, $C8, $02, $8B, $15);
  HCBlock25Val5: array[0..2] of byte = (
    $89, $02, $A1);
  HCBlock25Val6: array[0..3] of byte = (
    $83, $C0, $04, $E8);
  HCBlock25Val7: array[0..2] of byte = (
    $33, $C0, $A3);
  HCBlock25Val8: array[0..2] of byte = (
    $33, $C0, $A3);
  HCBlock25Val9: array[0..0] of byte = (
    $C3);
  HCBlock25Val: array[0..9] of TVal = (
    (RA: $0; Count: length(HCBlock25Val0); Val: @HCBlock25Val0), 
    (RA: $7; Count: length(HCBlock25Val1); Val: @HCBlock25Val1), 
    (RA: $10; Count: length(HCBlock25Val2); Val: @HCBlock25Val2), 
    (RA: $1C; Count: length(HCBlock25Val3); Val: @HCBlock25Val3), 
    (RA: $23; Count: length(HCBlock25Val4); Val: @HCBlock25Val4), 
    (RA: $2C; Count: length(HCBlock25Val5); Val: @HCBlock25Val5), 
    (RA: $33; Count: length(HCBlock25Val6); Val: @HCBlock25Val6), 
    (RA: $3B; Count: length(HCBlock25Val7); Val: @HCBlock25Val7), 
    (RA: $42; Count: length(HCBlock25Val8); Val: @HCBlock25Val8), 
    (RA: $49; Count: length(HCBlock25Val9); Val: @HCBlock25Val9));
  HCBlock25Vars: array[0..2] of TCVar = (
    (RA: $2; VN: 'remBytes'), 
    (RA: $14; VN: 'heapErrorCode'),
    (RA: $28; VN: 'curAlloc'));
  HCBlock25: THCBlock = (
    Size: $4C;
    RAC: length(HCBlock25RA); RA: @HCBlock25RA;
    ValC: length(HCBlock25Val); Val: @HCBlock25Val;
    VarsC: length(HCBlock25Vars); Vars: @HCBlock25Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock26RA: array[0..0] of TRA = (
    (RA: $0; PN: 'MergeCommit'; CN: ''));
  HCBlock26Val0: array[0..15] of byte = (
    $53, $56, $57, $83, $C4, $F0, $8B, $F0, $8D, $3C, $24, $A5, $A5, $8B, $FC, $E8);
  HCBlock26Val1: array[0..6] of byte = (
    $8D, $4C, $24, $08, $8B, $D7, $B8);
  HCBlock26Val2: array[0..0] of byte = (
    $E8);
  HCBlock26Val3: array[0..18] of byte = (
    $8B, $5C, $24, $08, $85, $DB, $75, $04, $33, $C0, $EB, $52, $8B, $07, $3B, $D8, 
    $73, $0A, $E8);
  HCBlock26Val4: array[0..20] of byte = (
    $29, $07, $01, $47, $04, $8B, $07, $03, $47, $04, $8B, $F3, $03, $74, $24, $0C, 
    $3B, $C6, $73, $08, $E8);
  HCBlock26Val5: array[0..20] of byte = (
    $01, $47, $04, $8B, $07, $03, $47, $04, $3B, $F0, $75, $11, $83, $E8, $04, $BA, 
    $04, $00, $00, $00, $E8);
  HCBlock26Val6: array[0..6] of byte = (
    $83, $6F, $04, $04, $8B, $07, $A3);
  HCBlock26Val7: array[0..3] of byte = (
    $8B, $47, $04, $A3);
  HCBlock26Val8: array[0..8] of byte = (
    $B0, $01, $83, $C4, $10, $5F, $5E, $5B, $C3);
  HCBlock26Val: array[0..8] of TVal = (
    (RA: $0; Count: length(HCBlock26Val0); Val: @HCBlock26Val0), 
    (RA: $14; Count: length(HCBlock26Val1); Val: @HCBlock26Val1), 
    (RA: $1F; Count: length(HCBlock26Val2); Val: @HCBlock26Val2), 
    (RA: $24; Count: length(HCBlock26Val3); Val: @HCBlock26Val3), 
    (RA: $3B; Count: length(HCBlock26Val4); Val: @HCBlock26Val4), 
    (RA: $54; Count: length(HCBlock26Val5); Val: @HCBlock26Val5), 
    (RA: $6D; Count: length(HCBlock26Val6); Val: @HCBlock26Val6), 
    (RA: $78; Count: length(HCBlock26Val7); Val: @HCBlock26Val7), 
    (RA: $80; Count: length(HCBlock26Val8); Val: @HCBlock26Val8));
  HCBlock26Vars: array[0..2] of TCVar = (
    (RA: $1B; VN: 'committedRoot'), 
    (RA: $74; VN: 'curAlloc'), 
    (RA: $7C; VN: 'remBytes'));
  HCBlock26: THCBlock = (
    Size: $8C;
    RAC: length(HCBlock26RA); RA: @HCBlock26RA;
    ValC: length(HCBlock26Val); Val: @HCBlock26Val;
    VarsC: length(HCBlock26Vars); Vars: @HCBlock26Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock27RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NewCommit'; CN: ''));
  HCBlock27Val0: array[0..11] of byte = (
    $53, $83, $C4, $F8, $8B, $D8, $8B, $D4, $8D, $43, $04, $E8);
  HCBlock27Val1: array[0..8] of byte = (
    $83, $3C, $24, $00, $74, $0B, $8B, $C4, $E8);
  HCBlock27Val2: array[0..13] of byte = (
    $84, $C0, $75, $04, $33, $C0, $EB, $02, $B0, $01, $59, $5A, $5B, $C3);
  HCBlock27Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock27Val0); Val: @HCBlock27Val0),
    (RA: $10; Count: length(HCBlock27Val1); Val: @HCBlock27Val1),
    (RA: $1D; Count: length(HCBlock27Val2); Val: @HCBlock27Val2));
  HCBlock27: THCBlock = (
    Size: $2C;
    RAC: length(HCBlock27RA); RA: @HCBlock27RA;
    ValC: length(HCBlock27Val); Val: @HCBlock27Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock28RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NewCommitAt'; CN: ''));
  HCBlock28Val0: array[0..16] of byte = (
    $53, $56, $83, $C4, $F8, $8B, $F2, $8B, $D8, $8B, $CC, $8D, $56, $04, $8B, $C3, 
    $E8);
  HCBlock28Val1: array[0..8] of byte = (
    $83, $3C, $24, $00, $74, $0B, $8B, $C4, $E8);
  HCBlock28Val2: array[0..14] of byte = (
    $84, $C0, $75, $04, $33, $C0, $EB, $02, $B0, $01, $59, $5A, $5E, $5B, $C3);
  HCBlock28Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock28Val0); Val: @HCBlock28Val0), 
    (RA: $15; Count: length(HCBlock28Val1); Val: @HCBlock28Val1), 
    (RA: $22; Count: length(HCBlock28Val2); Val: @HCBlock28Val2));
  HCBlock28: THCBlock = (
    Size: $34;
    RAC: length(HCBlock28RA); RA: @HCBlock28RA;
    ValC: length(HCBlock28Val); Val: @HCBlock28Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock29RA: array[0..0] of TRA = (
    (RA: $0; PN: 'SearchSmallBlocks'; CN: ''));
  HCBlock29Val0: array[0..20] of byte = (
    $33, $D2, $85, $C0, $79, $03, $83, $C0, $03, $C1, $F8, $02, $3D, $00, $04, $00, 
    $00, $7F, $16, $8B, $15);
  HCBlock29Val1: array[0..18] of byte = (
    $8B, $54, $82, $F4, $85, $D2, $75, $08, $40, $3D, $01, $04, $00, $00, $75, $EA, 
    $8B, $C2, $C3);
  HCBlock29Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock29Val0); Val: @HCBlock29Val0), 
    (RA: $19; Count: length(HCBlock29Val1); Val: @HCBlock29Val1));
  HCBlock29Vars: array[0..0] of TCVar = (
    (RA: $15; VN: 'smallTab'));
  HCBlock29: THCBlock = (
    Size: $2C;
    RAC: length(HCBlock29RA); RA: @HCBlock29RA;
    ValC: length(HCBlock29Val); Val: @HCBlock29Val;
    VarsC: length(HCBlock29Vars); Vars: @HCBlock29Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock30RA: array[0..0] of TRA = (
    (RA: $0; PN: 'TryHarder'; CN: ''));
  HCBlock30Val0: array[0..6] of byte = (
    $53, $56, $57, $55, $8B, $F0, $BF);
  HCBlock30Val1: array[0..0] of byte = (
    $BD);
  HCBlock30Val2: array[0..1] of byte = (
    $8B, $1D);
  HCBlock30Val3: array[0..52] of byte = (
    $3B, $73, $08, $0F, $8E, $84, $00, $00, $00, $8B, $1F, $8B, $43, $08, $3B, $F0, 
    $7E, $7B, $89, $73, $08, $8B, $5B, $04, $3B, $73, $08, $7F, $F8, $8B, $17, $89, 
    $42, $08, $3B, $1F, $74, $04, $89, $1F, $EB, $63, $81, $FE, $00, $10, $00, $00, 
    $7F, $0D, $8B, $C6, $E8);
  HCBlock30Val4: array[0..8] of byte = (
    $8B, $D8, $85, $DB, $75, $4E, $8B, $C6, $E8);
  HCBlock30Val5: array[0..33] of byte = (
    $84, $C0, $75, $07, $33, $C0, $E9, $88, $00, $00, $00, $3B, $75, $00, $7F, $A4, 
    $29, $75, $00, $83, $7D, $00, $0C, $7D, $08, $03, $75, $00, $33, $C0, $89, $45, 
    $00, $A1);
  HCBlock30Val6: array[0..1] of byte = (
    $01, $35);
  HCBlock30Val7: array[0..11] of byte = (
    $8B, $D6, $83, $CA, $02, $89, $10, $83, $C0, $04, $FF, $05);
  HCBlock30Val8: array[0..4] of byte = (
    $83, $EE, $04, $01, $35);
  HCBlock30Val9: array[0..4] of byte = (
    $EB, $4C, $8B, $C3, $E8);
  HCBlock30Val10: array[0..17] of byte = (
    $8B, $53, $08, $8B, $C2, $2B, $C6, $83, $F8, $0C, $7C, $0C, $8B, $D3, $03, $D6, 
    $92, $E8);
  HCBlock30Val11: array[0..33] of byte = (
    $EB, $12, $8B, $F2, $3B, $1F, $75, $05, $8B, $43, $04, $89, $07, $8B, $C3, $03, 
    $C6, $83, $20, $FE, $8B, $C3, $8B, $D6, $83, $CA, $02, $89, $10, $83, $C0, $04, 
    $FF, $05);
  HCBlock30Val12: array[0..4] of byte = (
    $83, $EE, $04, $01, $35);
  HCBlock30Val13: array[0..4] of byte = (
    $5D, $5F, $5E, $5B, $C3);
  HCBlock30Val: array[0..13] of TVal = (
    (RA: $0; Count: length(HCBlock30Val0); Val: @HCBlock30Val0), 
    (RA: $B; Count: length(HCBlock30Val1); Val: @HCBlock30Val1), 
    (RA: $10; Count: length(HCBlock30Val2); Val: @HCBlock30Val2), 
    (RA: $16; Count: length(HCBlock30Val3); Val: @HCBlock30Val3), 
    (RA: $4F; Count: length(HCBlock30Val4); Val: @HCBlock30Val4), 
    (RA: $5C; Count: length(HCBlock30Val5); Val: @HCBlock30Val5), 
    (RA: $82; Count: length(HCBlock30Val6); Val: @HCBlock30Val6), 
    (RA: $88; Count: length(HCBlock30Val7); Val: @HCBlock30Val7), 
    (RA: $98; Count: length(HCBlock30Val8); Val: @HCBlock30Val8), 
    (RA: $A1; Count: length(HCBlock30Val9); Val: @HCBlock30Val9), 
    (RA: $AA; Count: length(HCBlock30Val10); Val: @HCBlock30Val10),
    (RA: $C0; Count: length(HCBlock30Val11); Val: @HCBlock30Val11), 
    (RA: $E6; Count: length(HCBlock30Val12); Val: @HCBlock30Val12), 
    (RA: $EF; Count: length(HCBlock30Val13); Val: @HCBlock30Val13));
  HCBlock30Vars: array[0..4] of TCVar = (
    (RA: $7; VN: 'rover'), 
    (RA: $C; VN: 'remBytes'), 
    (RA: $7E; VN: 'curAlloc'), 
    (RA: $94; VN: 'AllocMemCount'), 
    (RA: $9D; VN: 'AllocMemSize'));
  HCBlock30: THCBlock = (
    Size: $F4;
    RAC: length(HCBlock30RA); RA: @HCBlock30RA;
    ValC: length(HCBlock30Val); Val: @HCBlock30Val;
    VarsC: length(HCBlock30Vars); Vars: @HCBlock30Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock31RA: array[0..0] of TRA = (
    (RA: $0; PN: 'SysGetMem'; CN: ''));
  HCBlock31Val0: array[0..12] of byte = (
    $55, $8B, $EC, $83, $C4, $F8, $53, $56, $57, $8B, $D8, $80, $3D);
  HCBlock31Val1: array[0..2] of byte = (
    $75, $13, $E8);
  HCBlock31Val2: array[0..17] of byte = (
    $84, $C0, $75, $0A, $33, $C0, $89, $45, $FC, $E9, $54, $01, $00, $00, $33, $C9, 
    $55, $68);
  HCBlock31Val3: array[0..7] of byte = (
    $64, $FF, $31, $64, $89, $21, $80, $3D);
  HCBlock31Val4: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock31Val5: array[0..0] of byte = (
    $E8);
  HCBlock31Val6: array[0..41] of byte = (
    $83, $C3, $07, $83, $E3, $FC, $83, $FB, $0C, $7D, $05, $BB, $0C, $00, $00, $00, 
    $81, $FB, $00, $10, $00, $00, $0F, $8F, $93, $00, $00, $00, $8B, $C3, $85, $C0, 
    $79, $03, $83, $C0, $03, $C1, $F8, $02, $8B, $15);
  HCBlock31Val7: array[0..37] of byte = (
    $8B, $54, $82, $F4, $85, $D2, $74, $79, $8B, $F2, $8B, $C6, $03, $C3, $83, $20, 
    $FE, $8B, $42, $04, $3B, $D0, $75, $1A, $8B, $C3, $85, $C0, $79, $03, $83, $C0, 
    $03, $C1, $F8, $02, $8B, $0D);
  HCBlock31Val8: array[0..21] of byte = (
    $33, $FF, $89, $7C, $81, $F4, $EB, $26, $8B, $CB, $85, $C9, $79, $03, $83, $C1, 
    $03, $C1, $F9, $02, $8B, $3D);
  HCBlock31Val9: array[0..37] of byte = (
    $89, $44, $8F, $F4, $8B, $0A, $89, $4D, $F8, $8B, $4D, $F8, $89, $41, $04, $8B, 
    $4D, $F8, $89, $08, $8B, $C6, $8B, $52, $08, $83, $CA, $02, $89, $10, $83, $C0, 
    $04, $89, $45, $FC, $FF, $05);
  HCBlock31Val10: array[0..4] of byte = (
    $83, $EB, $04, $01, $1D);
  HCBlock31Val11: array[0..0] of byte = (
    $E8);
  HCBlock31Val12: array[0..6] of byte = (
    $E9, $84, $00, $00, $00, $3B, $1D);
  HCBlock31Val13: array[0..3] of byte = (
    $7F, $4A, $29, $1D);
  HCBlock31Val14: array[0..1] of byte = (
    $83, $3D);
  HCBlock31Val15: array[0..3] of byte = (
    $7D, $0D, $03, $1D);
  HCBlock31Val16: array[0..2] of byte = (
    $33, $C0, $A3);
  HCBlock31Val17: array[0..0] of byte = (
    $A1);
  HCBlock31Val18: array[0..1] of byte = (
    $01, $1D);
  HCBlock31Val19: array[0..14] of byte = (
    $8B, $D3, $83, $CA, $02, $89, $10, $83, $C0, $04, $89, $45, $FC, $FF, $05);
  HCBlock31Val20: array[0..4] of byte = (
    $83, $EB, $04, $01, $1D);
  HCBlock31Val21: array[0..0] of byte = (
    $E8);
  HCBlock31Val22: array[0..4] of byte = (
    $EB, $32, $8B, $C3, $E8);
  HCBlock31Val23: array[0..11] of byte = (
    $89, $45, $FC, $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock31Val24: array[0..1] of byte = (
    $80, $3D);
  HCBlock31Val25: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock31Val26: array[0..0] of byte = (
    $E8);
  HCBlock31Val27: array[0..1] of byte = (
    $C3, $E9);
  HCBlock31Val28: array[0..11] of byte = (
    $EB, $E5, $8B, $45, $FC, $5F, $5E, $5B, $59, $59, $5D, $C3);
  HCBlock31Val: array[0..28] of TVal = (
    (RA: $0; Count: length(HCBlock31Val0); Val: @HCBlock31Val0), 
    (RA: $12; Count: length(HCBlock31Val1); Val: @HCBlock31Val1), 
    (RA: $19; Count: length(HCBlock31Val2); Val: @HCBlock31Val2), 
    (RA: $2F; Count: length(HCBlock31Val3); Val: @HCBlock31Val3), 
    (RA: $3C; Count: length(HCBlock31Val4); Val: @HCBlock31Val4), 
    (RA: $43; Count: length(HCBlock31Val5); Val: @HCBlock31Val5), 
    (RA: $48; Count: length(HCBlock31Val6); Val: @HCBlock31Val6),
    (RA: $76; Count: length(HCBlock31Val7); Val: @HCBlock31Val7), 
    (RA: $A0; Count: length(HCBlock31Val8); Val: @HCBlock31Val8), 
    (RA: $BA; Count: length(HCBlock31Val9); Val: @HCBlock31Val9), 
    (RA: $E4; Count: length(HCBlock31Val10); Val: @HCBlock31Val10), 
    (RA: $ED; Count: length(HCBlock31Val11); Val: @HCBlock31Val11), 
    (RA: $F2; Count: length(HCBlock31Val12); Val: @HCBlock31Val12), 
    (RA: $FD; Count: length(HCBlock31Val13); Val: @HCBlock31Val13), 
    (RA: $105; Count: length(HCBlock31Val14); Val: @HCBlock31Val14), 
    (RA: $10C; Count: length(HCBlock31Val15); Val: @HCBlock31Val15), 
    (RA: $114; Count: length(HCBlock31Val16); Val: @HCBlock31Val16), 
    (RA: $11B; Count: length(HCBlock31Val17); Val: @HCBlock31Val17), 
    (RA: $120; Count: length(HCBlock31Val18); Val: @HCBlock31Val18), 
    (RA: $126; Count: length(HCBlock31Val19); Val: @HCBlock31Val19), 
    (RA: $139; Count: length(HCBlock31Val20); Val: @HCBlock31Val20), 
    (RA: $142; Count: length(HCBlock31Val21); Val: @HCBlock31Val21), 
    (RA: $147; Count: length(HCBlock31Val22); Val: @HCBlock31Val22), 
    (RA: $150; Count: length(HCBlock31Val23); Val: @HCBlock31Val23), 
    (RA: $160; Count: length(HCBlock31Val24); Val: @HCBlock31Val24), 
    (RA: $167; Count: length(HCBlock31Val25); Val: @HCBlock31Val25), 
    (RA: $16E; Count: length(HCBlock31Val26); Val: @HCBlock31Val26), 
    (RA: $173; Count: length(HCBlock31Val27); Val: @HCBlock31Val27), 
    (RA: $179; Count: length(HCBlock31Val28); Val: @HCBlock31Val28));
  HCBlock31Vars: array[0..8] of TCVar = (
    (RA: $D; VN: 'initialized'), 
    (RA: $37; VN: 'IsMultiThread'), 
    (RA: $3F; VN: 'heapLock'), 
    (RA: $72; VN: 'smallTab'), 
    (RA: $E0; VN: 'AllocMemCount'), 
    (RA: $E9; VN: 'AllocMemSize'), 
    (RA: $F9; VN: 'remBytes'), 
    (RA: $11C; VN: 'curAlloc'),
    (RA: $16A; VN: 'heapLock'));
  HCBlock31IA: array[0..1] of TIA = (
    (RA: $2B; RRA: $174), 
    (RA: $15C; RRA: $17B));
  HCBlock31: THCBlock = (
    Size: $188;
    RAC: length(HCBlock31RA); RA: @HCBlock31RA;
    ValC: length(HCBlock31Val); Val: @HCBlock31Val;
    VarsC: length(HCBlock31Vars); Vars: @HCBlock31Vars;
    IAC: length(HCBlock31IA); IA: @HCBlock31IA;
    PRC: 0; PR: nil);

  HCBlock32RA: array[0..0] of TRA = (
    (RA: $0; PN: 'SysFreeMem'; CN: ''));
  HCBlock32Val0: array[0..11] of byte = (
    $55, $8B, $EC, $51, $53, $56, $57, $8B, $D8, $33, $C0, $A3);
  HCBlock32Val1: array[0..1] of byte = (
    $80, $3D);
  HCBlock32Val2: array[0..2] of byte = (
    $75, $1F, $E8);
  HCBlock32Val3: array[0..5] of byte = (
    $84, $C0, $75, $16, $C7, $05);
  HCBlock32Val4: array[0..15] of byte = (
    $C7, $45, $FC, $08, $00, $00, $00, $E9, $61, $01, $00, $00, $33, $C9, $55, $68);
  HCBlock32Val5: array[0..7] of byte = (
    $64, $FF, $31, $64, $89, $21, $80, $3D);
  HCBlock32Val6: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock32Val7: array[0..0] of byte = (
    $E8);
  HCBlock32Val8: array[0..13] of byte = (
    $8B, $F3, $83, $EE, $04, $8B, $1E, $F6, $C3, $02, $75, $0F, $C7, $05);
  HCBlock32Val9: array[0..6] of byte = (
    $E9, $F5, $00, $00, $00, $FF, $0D);
  HCBlock32Val10: array[0..11] of byte = (
    $8B, $C3, $25, $FC, $FF, $FF, $7F, $83, $E8, $04, $29, $05);
  HCBlock32Val11: array[0..27] of byte = (
    $F6, $C3, $01, $74, $45, $8B, $C6, $83, $E8, $0C, $8B, $50, $08, $83, $FA, $0C, 
    $7C, $08, $F7, $C2, $03, $00, $00, $80, $74, $0F, $C7, $05);
  HCBlock32Val12: array[0..15] of byte = (
    $E9, $B6, $00, $00, $00, $8B, $C6, $2B, $C2, $3B, $50, $08, $74, $0F, $C7, $05);
  HCBlock32Val13: array[0..9] of byte = (
    $E9, $9E, $00, $00, $00, $03, $DA, $8B, $F0, $E8);
  HCBlock32Val14: array[0..13] of byte = (
    $81, $E3, $FC, $FF, $FF, $7F, $8B, $C6, $03, $C3, $8B, $F8, $3B, $3D);
  HCBlock32Val15: array[0..3] of byte = (
    $75, $2C, $29, $1D);
  HCBlock32Val16: array[0..1] of byte = (
    $01, $1D);
  HCBlock32Val17: array[0..1] of byte = (
    $81, $3D);
  HCBlock32Val18: array[0..2] of byte = (
    $7E, $05, $E8);
  HCBlock32Val19: array[0..5] of byte = (
    $33, $C0, $89, $45, $FC, $E8);
  HCBlock32Val20: array[0..24] of byte = (
    $E9, $85, $00, $00, $00, $8B, $10, $F6, $C2, $02, $74, $1C, $81, $E2, $FC, $FF, 
    $FF, $7F, $83, $FA, $04, $7D, $0C, $C7, $05);
  HCBlock32Val21: array[0..27] of byte = (
    $EB, $37, $83, $08, $01, $EB, $29, $8B, $C7, $83, $78, $04, $00, $74, $0B, $83, 
    $38, $00, $74, $06, $83, $78, $08, $0C, $7D, $0C, $C7, $05);
  HCBlock32Val22: array[0..7] of byte = (
    $EB, $13, $8B, $50, $08, $03, $DA, $E8);
  HCBlock32Val23: array[0..4] of byte = (
    $8B, $D3, $8B, $C6, $E8);
  HCBlock32Val24: array[0..0] of byte = (
    $A1);
  HCBlock32Val25: array[0..11] of byte = (
    $89, $45, $FC, $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock32Val26: array[0..1] of byte = (
    $80, $3D);
  HCBlock32Val27: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock32Val28: array[0..0] of byte = (
    $E8);
  HCBlock32Val29: array[0..1] of byte = (
    $C3, $E9);
  HCBlock32Val30: array[0..10] of byte = (
    $EB, $E5, $8B, $45, $FC, $5F, $5E, $5B, $59, $5D, $C3);
  HCBlock32Val: array[0..30] of TVal = (
    (RA: $0; Count: length(HCBlock32Val0); Val: @HCBlock32Val0), 
    (RA: $10; Count: length(HCBlock32Val1); Val: @HCBlock32Val1), 
    (RA: $17; Count: length(HCBlock32Val2); Val: @HCBlock32Val2), 
    (RA: $1E; Count: length(HCBlock32Val3); Val: @HCBlock32Val3), 
    (RA: $2C; Count: length(HCBlock32Val4); Val: @HCBlock32Val4), 
    (RA: $40; Count: length(HCBlock32Val5); Val: @HCBlock32Val5), 
    (RA: $4D; Count: length(HCBlock32Val6); Val: @HCBlock32Val6), 
    (RA: $54; Count: length(HCBlock32Val7); Val: @HCBlock32Val7), 
    (RA: $59; Count: length(HCBlock32Val8); Val: @HCBlock32Val8), 
    (RA: $6F; Count: length(HCBlock32Val9); Val: @HCBlock32Val9), 
    (RA: $7A; Count: length(HCBlock32Val10); Val: @HCBlock32Val10), 
    (RA: $8A; Count: length(HCBlock32Val11); Val: @HCBlock32Val11), 
    (RA: $AE; Count: length(HCBlock32Val12); Val: @HCBlock32Val12),
    (RA: $C6; Count: length(HCBlock32Val13); Val: @HCBlock32Val13), 
    (RA: $D4; Count: length(HCBlock32Val14); Val: @HCBlock32Val14), 
    (RA: $E6; Count: length(HCBlock32Val15); Val: @HCBlock32Val15), 
    (RA: $EE; Count: length(HCBlock32Val16); Val: @HCBlock32Val16), 
    (RA: $F4; Count: length(HCBlock32Val17); Val: @HCBlock32Val17), 
    (RA: $FE; Count: length(HCBlock32Val18); Val: @HCBlock32Val18), 
    (RA: $105; Count: length(HCBlock32Val19); Val: @HCBlock32Val19), 
    (RA: $10F; Count: length(HCBlock32Val20); Val: @HCBlock32Val20), 
    (RA: $130; Count: length(HCBlock32Val21); Val: @HCBlock32Val21), 
    (RA: $154; Count: length(HCBlock32Val22); Val: @HCBlock32Val22), 
    (RA: $160; Count: length(HCBlock32Val23); Val: @HCBlock32Val23), 
    (RA: $169; Count: length(HCBlock32Val24); Val: @HCBlock32Val24), 
    (RA: $16E; Count: length(HCBlock32Val25); Val: @HCBlock32Val25), 
    (RA: $17E; Count: length(HCBlock32Val26); Val: @HCBlock32Val26), 
    (RA: $185; Count: length(HCBlock32Val27); Val: @HCBlock32Val27), 
    (RA: $18C; Count: length(HCBlock32Val28); Val: @HCBlock32Val28), 
    (RA: $191; Count: length(HCBlock32Val29); Val: @HCBlock32Val29), 
    (RA: $197; Count: length(HCBlock32Val30); Val: @HCBlock32Val30));
  HCBlock32Vars: array[0..7] of TCVar = (
    (RA: $C; VN: 'heapErrorCode'), 
    (RA: $12; VN: 'initialized'), 
    (RA: $48; VN: 'IsMultiThread'), 
    (RA: $50; VN: 'heapLock'), 
    (RA: $76; VN: 'AllocMemCount'), 
    (RA: $86; VN: 'AllocMemSize'), 
    (RA: $E2; VN: 'curAlloc'), 
    (RA: $F0; VN: 'remBytes'));
  HCBlock32IA: array[0..1] of TIA = (
    (RA: $3C; RRA: $192), 
    (RA: $17A; RRA: $199));
  HCBlock32: THCBlock = (
    Size: $1A4;
    RAC: length(HCBlock32RA); RA: @HCBlock32RA;
    ValC: length(HCBlock32Val); Val: @HCBlock32Val;
    VarsC: length(HCBlock32Vars); Vars: @HCBlock32Vars;
    IAC: length(HCBlock32IA); IA: @HCBlock32IA;
    PRC: 0; PR: nil);

  HCBlock33RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ResizeInPlace'; CN: ''));
  HCBlock33Val0: array[0..61] of byte = (
    $53, $56, $57, $55, $83, $C4, $F8, $8B, $F2, $83, $C6, $07, $83, $E6, $FC, $83, 
    $FE, $0C, $7D, $05, $BE, $0C, $00, $00, $00, $8B, $E8, $83, $ED, $04, $8B, $7D, 
    $00, $81, $E7, $FC, $FF, $FF, $7F, $8B, $C5, $03, $C7, $8B, $D8, $3B, $FE, $0F, 
    $8C, $83, $00, $00, $00, $8B, $D7, $2B, $D6, $89, $14, $24, $3B, $1D);
  HCBlock33Val1: array[0..6] of byte = (
    $75, $38, $8B, $04, $24, $29, $05);
  HCBlock33Val2: array[0..4] of byte = (
    $8B, $04, $24, $01, $05);
  HCBlock33Val3: array[0..1] of byte = (
    $83, $3D);
  HCBlock33Val4: array[0..10] of byte = (
    $0F, $8D, $4C, $01, $00, $00, $8B, $04, $24, $01, $05);
  HCBlock33Val5: array[0..4] of byte = (
    $8B, $04, $24, $29, $05);
  HCBlock33Val6: array[0..22] of byte = (
    $8B, $F7, $E9, $33, $01, $00, $00, $8B, $D8, $F6, $03, $02, $75, $0D, $8B, $C3, 
    $8B, $50, $08, $01, $14, $24, $E8);
  HCBlock33Val7: array[0..23] of byte = (
    $83, $3C, $24, $0C, $7C, $1B, $8B, $DD, $03, $DE, $8B, $04, $24, $83, $C8, $02, 
    $89, $03, $8B, $C3, $83, $C0, $04, $E8);
  HCBlock33Val8: array[0..21] of byte = (
    $E9, $FE, $00, $00, $00, $8B, $F7, $E9, $F7, $00, $00, $00, $8B, $C6, $2B, $C7, 
    $89, $44, $24, $04, $3B, $1D);
  HCBlock33Val9: array[0..2] of byte = (
    $75, $67, $A1);
  HCBlock33Val10: array[0..11] of byte = (
    $3B, $44, $24, $04, $7C, $53, $8B, $44, $24, $04, $29, $05);
  HCBlock33Val11: array[0..5] of byte = (
    $8B, $44, $24, $04, $01, $05);
  HCBlock33Val12: array[0..1] of byte = (
    $83, $3D);
  HCBlock33Val13: array[0..2] of byte = (
    $7D, $18, $A1);
  HCBlock33Val14: array[0..1] of byte = (
    $01, $05);
  HCBlock33Val15: array[0..1] of byte = (
    $03, $35);
  HCBlock33Val16: array[0..2] of byte = (
    $33, $C0, $A3);
  HCBlock33Val17: array[0..5] of byte = (
    $8B, $C6, $2B, $C7, $01, $05);
  HCBlock33Val18: array[0..20] of byte = (
    $8B, $45, $00, $25, $03, $00, $00, $80, $0B, $F0, $89, $75, $00, $B0, $01, $E9, 
    $A2, $00, $00, $00, $E8);
  HCBlock33Val19: array[0..42] of byte = (
    $8B, $DD, $03, $DF, $F6, $03, $02, $75, $4D, $8B, $D3, $8B, $C2, $8B, $48, $08, 
    $89, $0C, $24, $8B, $0C, $24, $3B, $4C, $24, $04, $7D, $0E, $03, $14, $24, $8B, 
    $DA, $8B, $04, $24, $29, $44, $24, $04, $EB, $2C, $E8);
  HCBlock33Val20: array[0..20] of byte = (
    $8B, $44, $24, $04, $29, $04, $24, $83, $3C, $24, $0C, $7C, $0E, $8B, $C5, $03, 
    $C6, $8B, $14, $24, $E8);
  HCBlock33Val21: array[0..38] of byte = (
    $EB, $3A, $03, $34, $24, $8B, $DD, $03, $DE, $83, $23, $FE, $EB, $2E, $8B, $03, 
    $A9, $00, $00, $00, $80, $74, $21, $25, $FC, $FF, $FF, $7F, $03, $C3, $8B, $D8, 
    $8B, $54, $24, $04, $8B, $C3, $E8);
  HCBlock33Val22: array[0..22] of byte = (
    $84, $C0, $74, $09, $8B, $DD, $03, $DF, $E9, $0D, $FF, $FF, $FF, $33, $C0, $EB, 
    $19, $8B, $C6, $2B, $C7, $01, $05);
  HCBlock33Val23: array[0..21] of byte = (
    $8B, $45, $00, $25, $03, $00, $00, $80, $0B, $F0, $89, $75, $00, $B0, $01, $59, 
    $5A, $5D, $5F, $5E, $5B, $C3);
  HCBlock33Val: array[0..23] of TVal = (
    (RA: $0; Count: length(HCBlock33Val0); Val: @HCBlock33Val0), 
    (RA: $42; Count: length(HCBlock33Val1); Val: @HCBlock33Val1), 
    (RA: $4D; Count: length(HCBlock33Val2); Val: @HCBlock33Val2), 
    (RA: $56; Count: length(HCBlock33Val3); Val: @HCBlock33Val3), 
    (RA: $5D; Count: length(HCBlock33Val4); Val: @HCBlock33Val4), 
    (RA: $6C; Count: length(HCBlock33Val5); Val: @HCBlock33Val5), 
    (RA: $75; Count: length(HCBlock33Val6); Val: @HCBlock33Val6), 
    (RA: $90; Count: length(HCBlock33Val7); Val: @HCBlock33Val7), 
    (RA: $AC; Count: length(HCBlock33Val8); Val: @HCBlock33Val8), 
    (RA: $C6; Count: length(HCBlock33Val9); Val: @HCBlock33Val9), 
    (RA: $CD; Count: length(HCBlock33Val10); Val: @HCBlock33Val10), 
    (RA: $DD; Count: length(HCBlock33Val11); Val: @HCBlock33Val11), 
    (RA: $E7; Count: length(HCBlock33Val12); Val: @HCBlock33Val12), 
    (RA: $EE; Count: length(HCBlock33Val13); Val: @HCBlock33Val13), 
    (RA: $F5; Count: length(HCBlock33Val14); Val: @HCBlock33Val14), 
    (RA: $FB; Count: length(HCBlock33Val15); Val: @HCBlock33Val15), 
    (RA: $101; Count: length(HCBlock33Val16); Val: @HCBlock33Val16), 
    (RA: $108; Count: length(HCBlock33Val17); Val: @HCBlock33Val17), 
    (RA: $112; Count: length(HCBlock33Val18); Val: @HCBlock33Val18), 
    (RA: $12B; Count: length(HCBlock33Val19); Val: @HCBlock33Val19), 
    (RA: $15A; Count: length(HCBlock33Val20); Val: @HCBlock33Val20),
    (RA: $173; Count: length(HCBlock33Val21); Val: @HCBlock33Val21), 
    (RA: $19E; Count: length(HCBlock33Val22); Val: @HCBlock33Val22), 
    (RA: $1B9; Count: length(HCBlock33Val23); Val: @HCBlock33Val23));
  HCBlock33Vars: array[0..2] of TCVar = (
    (RA: $3E; VN: 'curAlloc'), 
    (RA: $52; VN: 'remBytes'), 
    (RA: $10E; VN: 'AllocMemSize'));
  HCBlock33: THCBlock = (
    Size: $1D0;
    RAC: length(HCBlock33RA); RA: @HCBlock33RA;
    ValC: length(HCBlock33Val); Val: @HCBlock33Val;
    VarsC: length(HCBlock33Vars); Vars: @HCBlock33Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock34RA: array[0..0] of TRA = (
    (RA: $0; PN: 'SysReallocMem'; CN: ''));
  HCBlock34Val0: array[0..12] of byte = (
    $55, $8B, $EC, $51, $53, $56, $57, $8B, $F2, $8B, $D8, $80, $3D);
  HCBlock34Val1: array[0..2] of byte = (
    $75, $13, $E8);
  HCBlock34Val2: array[0..17] of byte = (
    $84, $C0, $75, $0A, $33, $C0, $89, $45, $FC, $E9, $91, $00, $00, $00, $33, $D2, 
    $55, $68);
  HCBlock34Val3: array[0..7] of byte = (
    $64, $FF, $32, $64, $89, $22, $80, $3D);
  HCBlock34Val4: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock34Val5: array[0..0] of byte = (
    $E8);
  HCBlock34Val6: array[0..4] of byte = (
    $8B, $D6, $8B, $C3, $E8);
  HCBlock34Val7: array[0..11] of byte = (
    $84, $C0, $74, $05, $89, $5D, $FC, $EB, $36, $8B, $C6, $E8);
  HCBlock34Val8: array[0..32] of byte = (
    $8B, $F8, $8B, $C3, $83, $E8, $04, $8B, $00, $25, $FC, $FF, $FF, $7F, $83, $E8, 
    $04, $3B, $F0, $7D, $02, $8B, $C6, $85, $FF, $74, $11, $8B, $D7, $8B, $CB, $91, 
    $E8);
  HCBlock34Val9: array[0..2] of byte = (
    $8B, $C3, $E8);
  HCBlock34Val10: array[0..11] of byte = (
    $89, $7D, $FC, $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock34Val11: array[0..1] of byte = (
    $80, $3D);
  HCBlock34Val12: array[0..2] of byte = (
    $74, $0A, $68);
  HCBlock34Val13: array[0..0] of byte = (
    $E8);
  HCBlock34Val14: array[0..1] of byte = (
    $C3, $E9);
  HCBlock34Val15: array[0..10] of byte = (
    $EB, $E5, $8B, $45, $FC, $5F, $5E, $5B, $59, $5D, $C3);
  HCBlock34Val: array[0..15] of TVal = (
    (RA: $0; Count: length(HCBlock34Val0); Val: @HCBlock34Val0), 
    (RA: $12; Count: length(HCBlock34Val1); Val: @HCBlock34Val1), 
    (RA: $19; Count: length(HCBlock34Val2); Val: @HCBlock34Val2), 
    (RA: $2F; Count: length(HCBlock34Val3); Val: @HCBlock34Val3), 
    (RA: $3C; Count: length(HCBlock34Val4); Val: @HCBlock34Val4), 
    (RA: $43; Count: length(HCBlock34Val5); Val: @HCBlock34Val5), 
    (RA: $48; Count: length(HCBlock34Val6); Val: @HCBlock34Val6), 
    (RA: $51; Count: length(HCBlock34Val7); Val: @HCBlock34Val7), 
    (RA: $61; Count: length(HCBlock34Val8); Val: @HCBlock34Val8),
    (RA: $86; Count: length(HCBlock34Val9); Val: @HCBlock34Val9), 
    (RA: $8D; Count: length(HCBlock34Val10); Val: @HCBlock34Val10), 
    (RA: $9D; Count: length(HCBlock34Val11); Val: @HCBlock34Val11), 
    (RA: $A4; Count: length(HCBlock34Val12); Val: @HCBlock34Val12), 
    (RA: $AB; Count: length(HCBlock34Val13); Val: @HCBlock34Val13), 
    (RA: $B0; Count: length(HCBlock34Val14); Val: @HCBlock34Val14), 
    (RA: $B6; Count: length(HCBlock34Val15); Val: @HCBlock34Val15));
  HCBlock34Vars: array[0..2] of TCVar = (
    (RA: $D; VN: 'initialized'), 
    (RA: $37; VN: 'IsMultiThread'), 
    (RA: $3F; VN: 'heapLock'));
  HCBlock34IA: array[0..1] of TIA = (
    (RA: $2B; RRA: $B1), 
    (RA: $99; RRA: $B8));
  HCBlock34: THCBlock = (
    Size: $C4;
    RAC: length(HCBlock34RA); RA: @HCBlock34RA;
    ValC: length(HCBlock34Val); Val: @HCBlock34Val;
    VarsC: length(HCBlock34Vars); Vars: @HCBlock34Vars;
    IAC: length(HCBlock34IA); IA: @HCBlock34IA;
    PRC: 0; PR: nil);

  HCBlock35RA: array[0..0] of TRA = (
    (RA: $0; PN: '@GetMem'; CN: ''));
  HCBlock35Val0: array[0..5] of byte = (
    $85, $C0, $74, $0A, $FF, $15);
  HCBlock35Val1: array[0..7] of byte = (
    $09, $C0, $74, $01, $C3, $B0, $01, $E9);
  HCBlock35Val2: array[0..0] of byte = (
    $C3);
  HCBlock35Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock35Val0); Val: @HCBlock35Val0), 
    (RA: $A; Count: length(HCBlock35Val1); Val: @HCBlock35Val1), 
    (RA: $16; Count: length(HCBlock35Val2); Val: @HCBlock35Val2));
  HCBlock35Vars: array[0..0] of TCVar = (
    (RA: $6; VN: 'MemoryManager'));
  HCBlock35: THCBlock = (
    Size: $18;
    RAC: length(HCBlock35RA); RA: @HCBlock35RA;
    ValC: length(HCBlock35Val); Val: @HCBlock35Val;
    VarsC: length(HCBlock35Vars); Vars: @HCBlock35Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock36RA: array[0..0] of TRA = (
    (RA: $0; PN: '@FreeMem'; CN: ''));
  HCBlock36Val0: array[0..5] of byte = (
    $85, $C0, $74, $0A, $FF, $15);
  HCBlock36Val1: array[0..7] of byte = (
    $09, $C0, $75, $01, $C3, $B0, $02, $E9);
  HCBlock36Val2: array[0..0] of byte = (
    $C3);
  HCBlock36Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock36Val0); Val: @HCBlock36Val0),
    (RA: $A; Count: length(HCBlock36Val1); Val: @HCBlock36Val1),
    (RA: $16; Count: length(HCBlock36Val2); Val: @HCBlock36Val2));
  HCBlock36Var: array[0..0] of TCVar = (
    (RA: $6; VN: 'MemoryManager'; VRA: $4));
  HCBlock36: THCBlock = (
    Size: $18;
    RAC: length(HCBlock36RA); RA: @HCBlock36RA;
    ValC: length(HCBlock36Val); Val: @HCBlock36Val;
    VarsC: Length(HCBlock36Var); Vars: @HCBlock36Var;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock37RA: array[0..0] of TRA = (
    (RA: $0; PN: 'Error'; CN: ''));
  HCBlock37Val0: array[0..4] of byte = (
    $83, $E0, $7F, $8B, $0D);
  HCBlock37Val1: array[0..9] of byte = (
    $85, $C9, $74, $03, $5A, $FF, $D1, $48, $8A, $80);
  HCBlock37Val2: array[0..2] of byte = (
    $79, $0B, $E8);
  HCBlock37Val3: array[0..1] of byte = (
    $8B, $80);
  HCBlock37Val4: array[0..0] of byte = (
    $E9);
  HCBlock37Val5: array[0..24] of byte = (
    $CB, $CC, $C8, $C9, $D7, $CF, $C8, $CD, $CE, $DB, $D8, $CA, $D9, $DA, $DC, $DD, 
    $DE, $DF, $E0, $E1, $E3, $00, $E4, $E5, $C3);
  HCBlock37Val: array[0..5] of TVal = (
    (RA: $0; Count: length(HCBlock37Val0); Val: @HCBlock37Val0), 
    (RA: $9; Count: length(HCBlock37Val1); Val: @HCBlock37Val1), 
    (RA: $17; Count: length(HCBlock37Val2); Val: @HCBlock37Val2), 
    (RA: $1E; Count: length(HCBlock37Val3); Val: @HCBlock37Val3), 
    (RA: $24; Count: length(HCBlock37Val4); Val: @HCBlock37Val4), 
    (RA: $29; Count: length(HCBlock37Val5); Val: @HCBlock37Val5));
  HCBlock37Vars: array[0..0] of TCVar = (
    (RA: $5; VN: 'ErrorProc'));
  HCBlock37IA: array[0..0] of TIA = (
    (RA: $13; RRA: $29));
  HCBlock37: THCBlock = (
    Size: $44;
    RAC: length(HCBlock37RA); RA: @HCBlock37RA;
    ValC: length(HCBlock37Val); Val: @HCBlock37Val;
    VarsC: length(HCBlock37Vars); Vars: @HCBlock37Vars;
    IAC: length(HCBlock37IA); IA: @HCBlock37IA;
    PRC: 0; PR: nil);

  HCBlock38RA: array[0..0] of TRA = (
    (RA: $0; PN: 'SetInOutRes'; CN: ''));
  HCBlock38Val0: array[0..1] of byte = (
    $50, $E8);
  HCBlock38Val1: array[0..6] of byte = (
    $8F, $80, $04, $00, $00, $00, $C3);
  HCBlock38Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock38Val0); Val: @HCBlock38Val0),
    (RA: $6; Count: length(HCBlock38Val1); Val: @HCBlock38Val1));
  HCBlock38: THCBlock = (
    Size: $10;
    RAC: length(HCBlock38RA); RA: @HCBlock38RA;
    ValC: length(HCBlock38Val); Val: @HCBlock38Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock39RA: array[0..0] of TRA = (
    (RA: $0; PN: 'Move'; CN: ''));
  HCBlock39Val0: array[0..63] of byte = (
    $56, $57, $89, $C6, $89, $D7, $89, $C8, $39, $F7, $77, $13, $74, $2F, $C1, $F9, 
    $02, $78, $2A, $F3, $A5, $89, $C1, $83, $E1, $03, $F3, $A4, $5F, $5E, $C3, $8D, 
    $74, $0E, $FC, $8D, $7C, $0F, $FC, $C1, $F9, $02, $78, $11, $FD, $F3, $A5, $89, 
    $C1, $83, $E1, $03, $83, $C6, $03, $83, $C7, $03, $F3, $A4, $FC, $5F, $5E, $C3);
  HCBlock39Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock39Val0); Val: @HCBlock39Val0));
  HCBlock39: THCBlock = (
    Size: $40;
    RAC: length(HCBlock39RA); RA: @HCBlock39RA;
    ValC: length(HCBlock39Val); Val: @HCBlock39Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock40RA: array[0..0] of TRA = (
    (RA: $0; PN: '@isNECWindows'; CN: ''));
  HCBlock40Val0: array[0..5] of byte = (
    $53, $33, $DB, $6A, $00, $E8);
  HCBlock40Val1: array[0..7] of byte = (
    $83, $F8, $07, $75, $1C, $6A, $01, $E8);
  HCBlock40Val2: array[0..24] of byte = (
    $25, $00, $FF, $00, $00, $3D, $00, $0D, $00, $00, $74, $07, $3D, $00, $04, $00, 
    $00, $75, $02, $B3, $01, $8B, $C3, $5B, $C3);
  HCBlock40Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock40Val0); Val: @HCBlock40Val0), 
    (RA: $A; Count: length(HCBlock40Val1); Val: @HCBlock40Val1), 
    (RA: $16; Count: length(HCBlock40Val2); Val: @HCBlock40Val2));
  HCBlock40: THCBlock = (
    Size: $30;
    RAC: length(HCBlock40RA); RA: @HCBlock40RA;
    ValC: length(HCBlock40Val); Val: @HCBlock40Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock41RA: array[0..0] of TRA = (
    (RA: $0; PN: '@FpuMaskInit'; CN: ''));
  HCBlock41Val0: array[0..8] of byte = (
    $55, $8B, $EC, $83, $C4, $F4, $0F, $B7, $05);
  HCBlock41Val1: array[0..11] of byte = (
    $89, $45, $F8, $8D, $45, $FC, $50, $6A, $01, $6A, $00, $68);
  HCBlock41Val2: array[0..5] of byte = (
    $68, $02, $00, $00, $80, $E8);
  HCBlock41Val3: array[0..7] of byte = (
    $85, $C0, $75, $4D, $33, $C0, $55, $68);
  HCBlock41Val4: array[0..25] of byte = (
    $64, $FF, $30, $64, $89, $20, $C7, $45, $F4, $04, $00, $00, $00, $8D, $45, $F4, 
    $50, $8D, $45, $F8, $50, $6A, $00, $6A, $00, $68);
  HCBlock41Val5: array[0..4] of byte = (
    $8B, $45, $FC, $50, $E8);
  HCBlock41Val6: array[0..8] of byte = (
    $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock41Val7: array[0..4] of byte = (
    $8B, $45, $FC, $50, $E8);
  HCBlock41Val8: array[0..1] of byte = (
    $C3, $E9);
  HCBlock41Val9: array[0..3] of byte = (
    $EB, $EF, $66, $A1);
  HCBlock41Val10: array[0..16] of byte = (
    $66, $25, $C0, $FF, $66, $8B, $55, $F8, $66, $83, $E2, $3F, $66, $0B, $C2, $66, 
    $A3);
  HCBlock41Val11: array[0..16] of byte = (
    $8B, $E5, $5D, $C3, $00, $53, $4F, $46, $54, $57, $41, $52, $45, $5C, $42, $6F, 
    $72);
  HCBlock41Val12: array[0..7] of byte = (
    $61, $6E, $64, $5C, $44, $65, $6C, $70);
  HCBlock41Val13: array[0..11] of byte = (
    $69, $5C, $52, $54, $4C, $00, $46, $50, $55, $4D, $61, $73);
  HCBlock41Val14: array[0..3] of byte = (
    $56, $61, $6C, $75);
  HCBlock41Val: array[0..14] of TVal = (
    (RA: $0; Count: length(HCBlock41Val0); Val: @HCBlock41Val0), 
    (RA: $D; Count: length(HCBlock41Val1); Val: @HCBlock41Val1), 
    (RA: $1D; Count: length(HCBlock41Val2); Val: @HCBlock41Val2), 
    (RA: $27; Count: length(HCBlock41Val3); Val: @HCBlock41Val3), 
    (RA: $33; Count: length(HCBlock41Val4); Val: @HCBlock41Val4), 
    (RA: $51; Count: length(HCBlock41Val5); Val: @HCBlock41Val5), 
    (RA: $5A; Count: length(HCBlock41Val6); Val: @HCBlock41Val6), 
    (RA: $67; Count: length(HCBlock41Val7); Val: @HCBlock41Val7), 
    (RA: $70; Count: length(HCBlock41Val8); Val: @HCBlock41Val8), 
    (RA: $76; Count: length(HCBlock41Val9); Val: @HCBlock41Val9), 
    (RA: $7E; Count: length(HCBlock41Val10); Val: @HCBlock41Val10), 
    (RA: $93; Count: length(HCBlock41Val11); Val: @HCBlock41Val11), 
    (RA: $A5; Count: length(HCBlock41Val12); Val: @HCBlock41Val12), 
    (RA: $AE; Count: length(HCBlock41Val13); Val: @HCBlock41Val13), 
    (RA: $BB; Count: length(HCBlock41Val14); Val: @HCBlock41Val14));
  HCBlock41Vars: array[0..0] of TCVar = (
    (RA: $9; VN: 'Default8087CW'));
  HCBlock41IA: array[0..3] of TIA = (
    (RA: $19; RRA: $98), 
    (RA: $2F; RRA: $71), 
    (RA: $4D; RRA: $B4), 
    (RA: $63; RRA: $78));
  HCBlock41: THCBlock = (
    Size: $C4;
    RAC: length(HCBlock41RA); RA: @HCBlock41RA;
    ValC: length(HCBlock41Val); Val: @HCBlock41Val;
    VarsC: length(HCBlock41Vars); Vars: @HCBlock41Vars;
    IAC: length(HCBlock41IA); IA: @HCBlock41IA;
    PRC: 0; PR: nil);

  HCBlock42RA: array[0..0] of TRA = (
    (RA: $0; PN: '@FpuInit'; CN: ''));
  HCBlock42Val0: array[0..4] of byte = (
    $DB, $E3, $9B, $D9, $2D);
  HCBlock42Val1: array[0..0] of byte = (
    $C3);
  HCBlock42Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock42Val0); Val: @HCBlock42Val0), 
    (RA: $9; Count: length(HCBlock42Val1); Val: @HCBlock42Val1));
  HCBlock42Vars: array[0..0] of TCVar = (
    (RA: $5; VN: 'Default8087CW'));
  HCBlock42: THCBlock = (
    Size: $C;
    RAC: length(HCBlock42RA); RA: @HCBlock42RA;
    ValC: length(HCBlock42Val); Val: @HCBlock42Val;
    VarsC: length(HCBlock42Vars); Vars: @HCBlock42Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock43RA: array[0..0] of TRA = (
    (RA: $0; PN: 'Create'; CN: 'TObject'; PT: ptConstructor));
  HCBlock43Val0: array[0..7] of byte = (
    $84, $D2, $74, $08, $83, $C4, $F0, $E8);
  HCBlock43Val1: array[0..4] of byte = (
    $84, $D2, $74, $0F, $E8);
  HCBlock43Val2: array[0..2] of byte = (
    $64, $8F, $05);
  HCBlock43Val3: array[0..3] of byte = (
    $83, $C4, $0C, $C3);
  HCBlock43Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock43Val0); Val: @HCBlock43Val0),
    (RA: $C; Count: length(HCBlock43Val1); Val: @HCBlock43Val1),
    (RA: $15; Count: length(HCBlock43Val2); Val: @HCBlock43Val2),
    (RA: $1C; Count: length(HCBlock43Val3); Val: @HCBlock43Val3));
  HCBlock43: THCBlock = (
    Size: $20;
    RAC: length(HCBlock43RA); RA: @HCBlock43RA;
    ValC: length(HCBlock43Val); Val: @HCBlock43Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock44RA: array[0..0] of TRA = (
    (RA: $0; PN: 'Free'; CN: 'TObject'));
  HCBlock44Val0: array[0..11] of byte = (
    $85, $C0, $74, $07, $8B, $08, $B2, $01, $FF, $51, $FC, $C3);
  HCBlock44Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock44Val0); Val: @HCBlock44Val0));
  HCBlock44: THCBlock = (
    Size: $C;
    RAC: length(HCBlock44RA); RA: @HCBlock44RA;
    ValC: length(HCBlock44Val); Val: @HCBlock44Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock45RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InitInstance'; CN: 'TObject'));
  HCBlock45Val0: array[0..28] of byte = (
    $53, $56, $57, $89, $C3, $89, $D7, $AB, $8B, $4B, $D8, $31, $C0, $51, $C1, $E9,
    $02, $49, $F3, $AB, $59, $83, $E1, $03, $F3, $AA, $89, $D0, $89);
  HCBlock45Val1: array[0..52] of byte = (
    $85, $C9, $74, $01, $51, $8B, $5B, $DC, $85, $DB, $74, $04, $8B, $1B, $EB, $ED,
    $39, $D4, $74, $1D, $5B, $8B, $0B, $83, $C3, $04, $8B, $73, $10, $85, $F6, $74,
    $06, $8B, $7B, $14, $89, $34, $38, $83, $C3, $1C, $49, $75, $ED, $39, $D4, $75,
    $E3, $5F, $5E, $5B, $C3);
  HCBlock45Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock45Val0); Val: @HCBlock45Val0),
    (RA: $21; Count: length(HCBlock45Val1); Val: @HCBlock45Val1));
  HCBlock45: THCBlock = (
    Size: $58;
    RAC: length(HCBlock45RA); RA: @HCBlock45RA;
    ValC: length(HCBlock45Val); Val: @HCBlock45Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock46RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetDynaMethod'; CN: ''));
  HCBlock46Val0: array[0..45] of byte = (
    $57, $93, $EB, $02, $8B, $1B, $8B, $7B, $D0, $85, $FF, $74, $0D, $0F, $B7, $0F, 
    $51, $83, $C7, $02, $66, $F2, $AF, $74, $0A, $59, $8B, $5B, $DC, $85, $DB, $75, 
    $E3, $5F, $C3, $58, $01, $C0, $29, $C8, $8B, $5C, $47, $FC, $5F, $C3);
  HCBlock46Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock46Val0); Val: @HCBlock46Val0));
  HCBlock46: THCBlock = (
    Size: $30;
    RAC: length(HCBlock46RA); RA: @HCBlock46RA;
    ValC: length(HCBlock46Val); Val: @HCBlock46Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock47RA: array[0..0] of TRA = (
    (RA: $0; PN: '@ClassCreate'; CN: ''));
  HCBlock47Val0: array[0..26] of byte = (
    $52, $51, $53, $84, $D2, $7C, $03, $FF, $50, $F4, $31, $D2, $8D, $4C, $24, $10, 
    $64, $8B, $1A, $89, $19, $89, $69, $08, $C7, $41, $04);
  HCBlock47Val1: array[0..10] of byte = (
    $89, $41, $0C, $64, $89, $0A, $5B, $59, $5A, $C3, $E9);
  HCBlock47Val2: array[0..20] of byte = (
    $8B, $44, $24, $2C, $8B, $40, $0C, $85, $C0, $74, $0E, $8B, $08, $B2, $81, $50, 
    $FF, $51, $FC, $58, $E8);
  HCBlock47Val3: array[0..0] of byte = (
    $E8);
  HCBlock47Val4: array[0..0] of byte = (
    $C3);
  HCBlock47Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock47Val0); Val: @HCBlock47Val0), 
    (RA: $1F; Count: length(HCBlock47Val1); Val: @HCBlock47Val1), 
    (RA: $2E; Count: length(HCBlock47Val2); Val: @HCBlock47Val2), 
    (RA: $47; Count: length(HCBlock47Val3); Val: @HCBlock47Val3), 
    (RA: $4C; Count: length(HCBlock47Val4); Val: @HCBlock47Val4));
  HCBlock47IA: array[0..0] of TIA = (
    (RA: $1B; RRA: $29));
  HCBlock47: THCBlock = (
    Size: $50;
    RAC: length(HCBlock47RA); RA: @HCBlock47RA;
    ValC: length(HCBlock47Val); Val: @HCBlock47Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock47IA); IA: @HCBlock47IA;
    PRC: 0; PR: nil);

  HCBlock48RA: array[0..0] of TRA = (
    (RA: $0; PN: '@ClassDestroy'; CN: ''));
  HCBlock48Val0: array[0..5] of byte = (
    $8B, $10, $FF, $52, $F8, $C3);
  HCBlock48Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock48Val0); Val: @HCBlock48Val0));
  HCBlock48: THCBlock = (
    Size: $8;
    RAC: length(HCBlock48RA); RA: @HCBlock48RA;
    ValC: length(HCBlock48Val); Val: @HCBlock48Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock49RA: array[0..0] of TRA = (
    (RA: $0; PN: '@AfterConstruction'; CN: ''));
  HCBlock49Val0: array[0..7] of byte = (
    $50, $8B, $10, $FF, $52, $E4, $58, $C3);
  HCBlock49Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock49Val0); Val: @HCBlock49Val0));
  HCBlock49: THCBlock = (
    Size: $8;
    RAC: length(HCBlock49RA); RA: @HCBlock49RA;
    ValC: length(HCBlock49Val); Val: @HCBlock49Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock50RA: array[0..0] of TRA = (
    (RA: $0; PN: '@BeforeDestruction'; CN: ''));
  HCBlock50Val0: array[0..14] of byte = (
    $84, $D2, $7F, $01, $C3, $50, $52, $8B, $10, $FF, $52, $E8, $5A, $58, $C3);
  HCBlock50Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock50Val0); Val: @HCBlock50Val0));
  HCBlock50: THCBlock = (
    Size: $10;
    RAC: length(HCBlock50RA); RA: @HCBlock50RA;
    ValC: length(HCBlock50Val); Val: @HCBlock50Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock51RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyReRaise'; CN: ''));
  HCBlock51Val0: array[0..1] of byte = (
    $80, $3D);
  HCBlock51Val1: array[0..13] of byte = (
    $76, $10, $6A, $00, $6A, $00, $6A, $00, $68, $DF, $FA, $ED, $0E, $E8);
  HCBlock51Val2: array[0..0] of byte = (
    $C3);
  HCBlock51Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock51Val0); Val: @HCBlock51Val0), 
    (RA: $7; Count: length(HCBlock51Val1); Val: @HCBlock51Val1), 
    (RA: $19; Count: length(HCBlock51Val2); Val: @HCBlock51Val2));
  HCBlock51Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'DebugHook'));
  HCBlock51: THCBlock = (
    Size: $1C;
    RAC: length(HCBlock51RA); RA: @HCBlock51RA;
    ValC: length(HCBlock51Val); Val: @HCBlock51Val;
    VarsC: length(HCBlock51Vars); Vars: @HCBlock51Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock52RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyNonDelphiException'; CN: ''));
  HCBlock52Val0: array[0..1] of byte = (
    $80, $3D);
  HCBlock52Val1: array[0..15] of byte = (
    $74, $16, $50, $50, $52, $54, $6A, $02, $6A, $00, $68, $E4, $FA, $ED, $0E, $E8);
  HCBlock52Val2: array[0..4] of byte = (
    $83, $C4, $08, $58, $C3);
  HCBlock52Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock52Val0); Val: @HCBlock52Val0), 
    (RA: $7; Count: length(HCBlock52Val1); Val: @HCBlock52Val1), 
    (RA: $1B; Count: length(HCBlock52Val2); Val: @HCBlock52Val2));
  HCBlock52Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'DebugHook'));
  HCBlock52: THCBlock = (
    Size: $20;
    RAC: length(HCBlock52RA); RA: @HCBlock52RA;
    ValC: length(HCBlock52Val); Val: @HCBlock52Val;
    VarsC: length(HCBlock52Vars); Vars: @HCBlock52Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock53RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyExcept'; CN: ''));
  HCBlock53Val0: array[0..10] of byte = (
    $54, $6A, $01, $6A, $00, $68, $E0, $FA, $ED, $0E, $E8);
  HCBlock53Val1: array[0..4] of byte = (
    $83, $C4, $04, $58, $C3);
  HCBlock53Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock53Val0); Val: @HCBlock53Val0), 
    (RA: $F; Count: length(HCBlock53Val1); Val: @HCBlock53Val1));
  HCBlock53: THCBlock = (
    Size: $14;
    RAC: length(HCBlock53RA); RA: @HCBlock53RA;
    ValC: length(HCBlock53Val); Val: @HCBlock53Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock54RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyAnyExcept'; CN: ''));
  HCBlock54Val0: array[0..1] of byte = (
    $80, $3D);
  HCBlock54Val1: array[0..4] of byte = (
    $76, $07, $50, $53, $E9);
  HCBlock54Val2: array[0..0] of byte = (
    $C3);
  HCBlock54Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock54Val0); Val: @HCBlock54Val0), 
    (RA: $7; Count: length(HCBlock54Val1); Val: @HCBlock54Val1), 
    (RA: $10; Count: length(HCBlock54Val2); Val: @HCBlock54Val2));
  HCBlock54Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'DebugHook'));
  HCBlock54: THCBlock = (
    Size: $14;
    RAC: length(HCBlock54RA); RA: @HCBlock54RA;
    ValC: length(HCBlock54Val); Val: @HCBlock54Val;
    VarsC: length(HCBlock54Vars); Vars: @HCBlock54Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock55RA: array[0..0] of TRA = (
    (RA: $0; PN: 'CheckJmp'; CN: ''));
  HCBlock55Val0: array[0..29] of byte = (
    $85, $C9, $74, $19, $8B, $41, $01, $80, $39, $E9, $74, $0C, $80, $39, $EB, $75, 
    $0C, $0F, $BE, $C0, $41, $41, $EB, $03, $83, $C1, $05, $01, $C1, $C3);
  HCBlock55Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock55Val0); Val: @HCBlock55Val0));
  HCBlock55: THCBlock = (
    Size: $20;
    RAC: length(HCBlock55RA); RA: @HCBlock55RA;
    ValC: length(HCBlock55Val); Val: @HCBlock55Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock56RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyExceptFinally'; CN: ''));
  HCBlock56Val0: array[0..1] of byte = (
    $80, $3D);
  HCBlock56Val1: array[0..5] of byte = (
    $76, $1C, $50, $52, $51, $E8);
  HCBlock56Val2: array[0..11] of byte = (
    $51, $54, $6A, $01, $6A, $00, $68, $E1, $FA, $ED, $0E, $E8);
  HCBlock56Val3: array[0..4] of byte = (
    $59, $59, $5A, $58, $C3);
  HCBlock56Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock56Val0); Val: @HCBlock56Val0),
    (RA: $7; Count: length(HCBlock56Val1); Val: @HCBlock56Val1), 
    (RA: $11; Count: length(HCBlock56Val2); Val: @HCBlock56Val2), 
    (RA: $21; Count: length(HCBlock56Val3); Val: @HCBlock56Val3));
  HCBlock56Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'DebugHook'));
  HCBlock56: THCBlock = (
    Size: $28;
    RAC: length(HCBlock56RA); RA: @HCBlock56RA;
    ValC: length(HCBlock56Val); Val: @HCBlock56Val;
    VarsC: length(HCBlock56Vars); Vars: @HCBlock56Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock57RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyTerminate'; CN: ''));
  HCBlock57Val0: array[0..1] of byte = (
    $80, $3D);
  HCBlock57Val1: array[0..13] of byte = (
    $76, $11, $52, $54, $6A, $01, $6A, $00, $68, $E2, $FA, $ED, $0E, $E8);
  HCBlock57Val2: array[0..1] of byte = (
    $5A, $C3);
  HCBlock57Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock57Val0); Val: @HCBlock57Val0), 
    (RA: $7; Count: length(HCBlock57Val1); Val: @HCBlock57Val1), 
    (RA: $19; Count: length(HCBlock57Val2); Val: @HCBlock57Val2));
  HCBlock57Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'DebugHook'));
  HCBlock57: THCBlock = (
    Size: $1C;
    RAC: length(HCBlock57RA); RA: @HCBlock57RA;
    ValC: length(HCBlock57Val); Val: @HCBlock57Val;
    VarsC: length(HCBlock57Vars); Vars: @HCBlock57Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock58RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyUnhandled'; CN: ''));
  HCBlock58Val0: array[0..3] of byte = (
    $50, $52, $80, $3D);
  HCBlock58Val1: array[0..12] of byte = (
    $76, $0F, $54, $6A, $02, $6A, $00, $68, $E3, $FA, $ED, $0E, $E8);
  HCBlock58Val2: array[0..2] of byte = (
    $5A, $58, $C3);
  HCBlock58Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock58Val0); Val: @HCBlock58Val0),
    (RA: $9; Count: length(HCBlock58Val1); Val: @HCBlock58Val1),
    (RA: $1A; Count: length(HCBlock58Val2); Val: @HCBlock58Val2));
  HCBlock58Vars: array[0..0] of TCVar = (
    (RA: $4; VN: 'DebugHook'));
  HCBlock58: THCBlock = (
    Size: $20;
    RAC: length(HCBlock58RA); RA: @HCBlock58RA;
    ValC: length(HCBlock58Val); Val: @HCBlock58Val;
    VarsC: length(HCBlock58Vars); Vars: @HCBlock58Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock59RA: array[0..0] of TRA = (
    (RA: $0; PN: '@HandleAnyException'; CN: ''));
  HCBlock59Val0: array[0..32] of byte = (
    $8B, $44, $24, $04, $F7, $40, $04, $06, $00, $00, $00, $0F, $85, $B9, $00, $00, 
    $00, $81, $38, $DE, $FA, $ED, $0E, $8B, $50, $18, $8B, $48, $14, $74, $3C, $FC,
    $E8);
  HCBlock59Val1: array[0..1] of byte = (
    $8B, $15);
  HCBlock59Val2: array[0..34] of byte = (
    $85, $D2, $0F, $84, $97, $00, $00, $00, $FF, $D2, $85, $C0, $0F, $84, $8D, $00, 
    $00, $00, $8B, $54, $24, $0C, $8B, $4C, $24, $04, $81, $39, $CE, $FA, $EF, $0E, 
    $74, $05, $E8);
  HCBlock59Val3: array[0..33] of byte = (
    $89, $C2, $8B, $44, $24, $04, $8B, $48, $0C, $83, $48, $04, $02, $53, $31, $DB, 
    $56, $57, $55, $64, $8B, $1B, $53, $50, $52, $51, $8B, $54, $24, $28, $6A, $00, 
    $50, $68);
  HCBlock59Val4: array[0..1] of byte = (
    $52, $E8);
  HCBlock59Val5: array[0..4] of byte = (
    $8B, $7C, $24, $28, $E8);
  HCBlock59Val6: array[0..20] of byte = (
    $FF, $B0, $00, $00, $00, $00, $89, $A0, $00, $00, $00, $00, $8B, $6F, $08, $8B, 
    $5F, $04, $C7, $47, $04);
  HCBlock59Val7: array[0..3] of byte = (
    $83, $C3, $05, $E8);
  HCBlock59Val8: array[0..2] of byte = (
    $FF, $E3, $E9);
  HCBlock59Val9: array[0..0] of byte = (
    $E8);
  HCBlock59Val10: array[0..17] of byte = (
    $8B, $88, $00, $00, $00, $00, $8B, $11, $89, $90, $00, $00, $00, $00, $8B, $41,
    $08, $E9);
  HCBlock59Val11: array[0..5] of byte = (
    $B8, $01, $00, $00, $00, $C3);
  HCBlock59Val: array[0..11] of TVal = (
    (RA: $0; Count: length(HCBlock59Val0); Val: @HCBlock59Val0),
    (RA: $25; Count: length(HCBlock59Val1); Val: @HCBlock59Val1), 
    (RA: $2B; Count: length(HCBlock59Val2); Val: @HCBlock59Val2), 
    (RA: $52; Count: length(HCBlock59Val3); Val: @HCBlock59Val3), 
    (RA: $78; Count: length(HCBlock59Val4); Val: @HCBlock59Val4), 
    (RA: $7E; Count: length(HCBlock59Val5); Val: @HCBlock59Val5), 
    (RA: $87; Count: length(HCBlock59Val6); Val: @HCBlock59Val6), 
    (RA: $A0; Count: length(HCBlock59Val7); Val: @HCBlock59Val7), 
    (RA: $A8; Count: length(HCBlock59Val8); Val: @HCBlock59Val8), 
    (RA: $AF; Count: length(HCBlock59Val9); Val: @HCBlock59Val9), 
    (RA: $B4; Count: length(HCBlock59Val10); Val: @HCBlock59Val10), 
    (RA: $CA; Count: length(HCBlock59Val11); Val: @HCBlock59Val11));
  HCBlock59Vars: array[0..0] of TCVar = (
    (RA: $27; VN: 'ExceptObjProc'));
  HCBlock59IA: array[0..1] of TIA = (
    (RA: $74; RRA: $7E), 
    (RA: $9C; RRA: $AA));
  HCBlock59: THCBlock = (
    Size: $D0;
    RAC: length(HCBlock59RA); RA: @HCBlock59RA;
    ValC: length(HCBlock59Val); Val: @HCBlock59Val;
    VarsC: length(HCBlock59Vars); Vars: @HCBlock59Vars;
    IAC: length(HCBlock59IA); IA: @HCBlock59IA;
    PRC: 0; PR: nil);

  HCBlock60RA: array[0..0] of TRA = (
    (RA: $0; PN: '@HandleFinally'; CN: ''));
  HCBlock60Val0: array[0..22] of byte = (
    $8B, $44, $24, $04, $8B, $54, $24, $08, $F7, $40, $04, $06, $00, $00, $00, $74,
    $1F, $8B, $4A, $04, $C7, $42, $04);
  HCBlock60Val1: array[0..10] of byte = (
    $53, $56, $57, $55, $8B, $6A, $08, $83, $C1, $05, $E8);
  HCBlock60Val2: array[0..11] of byte = (
    $FF, $D1, $5D, $5F, $5E, $5B, $B8, $01, $00, $00, $00, $C3);
  HCBlock60Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock60Val0); Val: @HCBlock60Val0), 
    (RA: $1B; Count: length(HCBlock60Val1); Val: @HCBlock60Val1), 
    (RA: $2A; Count: length(HCBlock60Val2); Val: @HCBlock60Val2));
  HCBlock60IA: array[0..0] of TIA = (
    (RA: $17; RRA: $30));
  HCBlock60: THCBlock = (
    Size: $38;
    RAC: length(HCBlock60RA); RA: @HCBlock60RA;
    ValC: length(HCBlock60Val); Val: @HCBlock60Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock60IA); IA: @HCBlock60IA;
    PRC: 0; PR: nil);

  HCBlock61RA: array[0..0] of TRA = (
    (RA: $0; PN: '@RaiseAgain'; CN: ''));
  HCBlock61Val0: array[0..6] of byte = (
    $8B, $44, $24, $30, $C7, $40, $04);
  HCBlock61Val1: array[0..0] of byte = (
    $E8);
  HCBlock61Val2: array[0..32] of byte = (
    $8B, $90, $00, $00, $00, $00, $8B, $0A, $89, $88, $00, $00, $00, $00, $8B, $42, 
    $0C, $83, $60, $04, $FD, $81, $38, $DE, $FA, $ED, $0E, $74, $0D, $8B, $42, $08, 
    $E8);
  HCBlock61Val3: array[0..0] of byte = (
    $E8);
  HCBlock61Val4: array[0..22] of byte = (
    $31, $C0, $83, $C4, $14, $64, $8B, $10, $59, $8B, $12, $89, $11, $5D, $5F, $5E, 
    $5B, $B8, $01, $00, $00, $00, $C3);
  HCBlock61Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock61Val0); Val: @HCBlock61Val0), 
    (RA: $B; Count: length(HCBlock61Val1); Val: @HCBlock61Val1), 
    (RA: $10; Count: length(HCBlock61Val2); Val: @HCBlock61Val2), 
    (RA: $35; Count: length(HCBlock61Val3); Val: @HCBlock61Val3), 
    (RA: $3A; Count: length(HCBlock61Val4); Val: @HCBlock61Val4));
  HCBlock61IA: array[0..0] of TIA = (
    (RA: $7; RRA: $4B));
  HCBlock61: THCBlock = (
    Size: $54;
    RAC: length(HCBlock61RA); RA: @HCBlock61RA;
    ValC: length(HCBlock61Val); Val: @HCBlock61Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock61IA); IA: @HCBlock61IA;
    PRC: 0; PR: nil);

  HCBlock62RA: array[0..0] of TRA = (
    (RA: $0; PN: '@DoneExcept'; CN: ''));
  HCBlock62Val0: array[0..0] of byte = (
    $E8);
  HCBlock62Val1: array[0..17] of byte = (
    $8B, $90, $00, $00, $00, $00, $8B, $0A, $89, $88, $00, $00, $00, $00, $8B, $42, 
    $08, $E8);
  HCBlock62Val2: array[0..13] of byte = (
    $5A, $8B, $64, $24, $2C, $31, $C0, $59, $64, $89, $08, $58, $5D, $E8);
  HCBlock62Val3: array[0..2] of byte = (
    $FF, $E2, $C3);
  HCBlock62Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock62Val0); Val: @HCBlock62Val0), 
    (RA: $5; Count: length(HCBlock62Val1); Val: @HCBlock62Val1), 
    (RA: $1B; Count: length(HCBlock62Val2); Val: @HCBlock62Val2),
    (RA: $2D; Count: length(HCBlock62Val3); Val: @HCBlock62Val3));
  HCBlock62: THCBlock = (
    Size: $30;
    RAC: length(HCBlock62RA); RA: @HCBlock62RA;
    ValC: length(HCBlock62Val); Val: @HCBlock62Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock63RA: array[0..0] of TRA = (
    (RA: $0; PN: '@TryFinallyExit'; CN: ''));
  HCBlock63Val0: array[0..21] of byte = (
    $31, $D2, $8B, $4C, $24, $08, $8B, $44, $24, $04, $83, $C1, $05, $64, $89, $02, 
    $FF, $D1, $C2, $0C, $00, $C3);
  HCBlock63Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock63Val0); Val: @HCBlock63Val0));
  HCBlock63: THCBlock = (
    Size: $18;
    RAC: length(HCBlock63RA); RA: @HCBlock63RA;
    ValC: length(HCBlock63Val); Val: @HCBlock63Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock64RA: array[0..0] of TRA = (
    (RA: $0; PN: 'RunErrorAt'; CN: ''));
  HCBlock64Val0: array[0..3] of byte = (
    $89, $14, $24, $E9);
  HCBlock64Val1: array[0..0] of byte = (
    $C3);
  HCBlock64Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock64Val0); Val: @HCBlock64Val0), 
    (RA: $8; Count: length(HCBlock64Val1); Val: @HCBlock64Val1));
  HCBlock64: THCBlock = (
    Size: $C;
    RAC: length(HCBlock64RA); RA: @HCBlock64RA;
    ValC: length(HCBlock64Val); Val: @HCBlock64Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock66RA: array[0..0] of TRA = (
    (RA: $0; PN: 'MapToRunError'; CN: ''));
  HCBlock66Val0: array[0..151] of byte = (
    $55, $8B, $EC, $8B, $55, $08, $8B, $02, $3D, $92, $00, $00, $C0, $7F, $2C, $74, 
    $5C, $3D, $8E, $00, $00, $C0, $7F, $15, $74, $57, $2D, $05, $00, $00, $C0, $74, 
    $5C, $2D, $87, $00, $00, $00, $74, $3D, $48, $74, $4E, $EB, $60, $05, $71, $FF, 
    $FF, $3F, $83, $E8, $02, $72, $36, $74, $30, $EB, $52, $3D, $96, $00, $00, $C0, 
    $7F, $11, $74, $3D, $2D, $93, $00, $00, $C0, $74, $2E, $48, $74, $13, $48, $74, 
    $24, $EB, $3A, $2D, $FD, $00, $00, $C0, $74, $2F, $83, $E8, $3D, $74, $26, $EB, 
    $2C, $B0, $C8, $EB, $2A, $B0, $C9, $EB, $26, $B0, $CD, $EB, $22, $B0, $CF, $EB, 
    $1E, $B0, $C8, $EB, $1A, $B0, $D7, $EB, $16, $B0, $CE, $EB, $12, $B0, $D8, $EB, 
    $0E, $B0, $DA, $EB, $0A, $B0, $D9, $EB, $06, $B0, $CA, $EB, $02, $B0, $FF, $25, 
    $FF, $00, $00, $00, $8B, $52, $0C, $E8);
  HCBlock66Val1: array[0..8] of byte = (
    $5D, $C2, $04, $00, $8B, $44, $24, $04, $F7);
  HCBlock66Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock66Val0); Val: @HCBlock66Val0), 
    (RA: $9C; Count: length(HCBlock66Val1); Val: @HCBlock66Val1));
  HCBlock66: THCBlock = (
    Size: $A0;
    RAC: length(HCBlock66RA); RA: @HCBlock66RA;
    ValC: length(HCBlock66Val); Val: @HCBlock66Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock67RA: array[0..0] of TRA = (
    (RA: $0; PN: '@ExceptionHandler'; CN: ''));
  HCBlock67Val0: array[0..14] of byte = (
    $8B, $44, $24, $04, $F7, $40, $04, $06, $00, $00, $00, $75, $6C, $FC, $E8);
  HCBlock67Val1: array[0..7] of byte = (
    $8B, $54, $24, $08, $6A, $00, $50, $68);
  HCBlock67Val2: array[0..1] of byte = (
    $52, $E8);
  HCBlock67Val3: array[0..19] of byte = (
    $8B, $5C, $24, $04, $81, $3B, $DE, $FA, $ED, $0E, $8B, $53, $14, $8B, $43, $18,
    $74, $1D, $8B, $15);
  HCBlock67Val4: array[0..3] of byte = (
    $85, $D2, $0F, $84);
  HCBlock67Val5: array[0..7] of byte = (
    $89, $D8, $FF, $D2, $85, $C0, $0F, $84);
  HCBlock67Val6: array[0..3] of byte = (
    $8B, $53, $0C, $E8);
  HCBlock67Val7: array[0..1] of byte = (
    $8B, $0D);
  HCBlock67Val8: array[0..21] of byte = (
    $85, $C9, $74, $02, $FF, $D1, $8B, $4C, $24, $04, $B8, $D9, $00, $00, $00, $8B,
    $51, $14, $89, $14, $24, $E9);
  HCBlock67Val9: array[0..2] of byte = (
    $31, $C0, $C3);
  HCBlock67Val: array[0..9] of TVal = (
    (RA: $0; Count: length(HCBlock67Val0); Val: @HCBlock67Val0),
    (RA: $13; Count: length(HCBlock67Val1); Val: @HCBlock67Val1), 
    (RA: $1F; Count: length(HCBlock67Val2); Val: @HCBlock67Val2), 
    (RA: $25; Count: length(HCBlock67Val3); Val: @HCBlock67Val3),
    (RA: $3D; Count: length(HCBlock67Val4); Val: @HCBlock67Val4), 
    (RA: $45; Count: length(HCBlock67Val5); Val: @HCBlock67Val5), 
    (RA: $51; Count: length(HCBlock67Val6); Val: @HCBlock67Val6), 
    (RA: $59; Count: length(HCBlock67Val7); Val: @HCBlock67Val7), 
    (RA: $5F; Count: length(HCBlock67Val8); Val: @HCBlock67Val8), 
    (RA: $79; Count: length(HCBlock67Val9); Val: @HCBlock67Val9));
  HCBlock67Vars: array[0..1] of TCVar = (
    (RA: $39; VN: 'ExceptObjProc'), 
    (RA: $5B; VN: 'ExceptProc'));
  HCBlock67IA: array[0..0] of TIA = (
    (RA: $1B; RRA: $25));
  HCBlock67: THCBlock = (
    Size: $7C;
    RAC: length(HCBlock67RA); RA: @HCBlock67RA;
    ValC: length(HCBlock67Val); Val: @HCBlock67Val;
    VarsC: length(HCBlock67Vars); Vars: @HCBlock67Vars;
    IAC: length(HCBlock67IA); IA: @HCBlock67IA;
    PRC: 0; PR: nil);

  HCBlock68RA: array[0..0] of TRA = (
    (RA: $0; PN: 'SetExceptionHandler'; CN: ''));
  HCBlock68Val0: array[0..15] of byte = (
    $31, $D2, $8D, $45, $F4, $64, $8B, $0A, $64, $89, $02, $89, $08, $C7, $40, $04);
  HCBlock68Val1: array[0..4] of byte = (
    $89, $68, $08, $89, $05);
  HCBlock68Val2: array[0..0] of byte = (
    $C3);
  HCBlock68Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock68Val0); Val: @HCBlock68Val0), 
    (RA: $14; Count: length(HCBlock68Val1); Val: @HCBlock68Val1), 
    (RA: $1D; Count: length(HCBlock68Val2); Val: @HCBlock68Val2));
  HCBlock68: THCBlock = (
    Size: $20;
    RAC: length(HCBlock68RA); RA: @HCBlock68RA;
    ValC: length(HCBlock68Val); Val: @HCBlock68Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock69RA: array[0..0] of TRA = (
    (RA: $0; PN: 'UnsetExceptionHandler'; CN: ''));
  HCBlock69Val0: array[0..3] of byte = (
    $31, $D2, $8B, $05);
  HCBlock69Val1: array[0..28] of byte = (
    $64, $8B, $0A, $39, $C8, $75, $08, $8B, $00, $64, $89, $02, $C3, $8B, $09, $83, 
    $F9, $FF, $74, $08, $39, $01, $75, $F5, $8B, $00, $89, $01, $C3);
  HCBlock69Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock69Val0); Val: @HCBlock69Val0), 
    (RA: $8; Count: length(HCBlock69Val1); Val: @HCBlock69Val1));
  HCBlock69: THCBlock = (
    Size: $28;
    RAC: length(HCBlock69RA); RA: @HCBlock69RA;
    ValC: length(HCBlock69Val); Val: @HCBlock69Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock70RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FInitUnits'; CN: ''));
  HCBlock70Val0: array[0..6] of byte = (
    $55, $8B, $EC, $53, $56, $57, $BF);
  HCBlock70Val1: array[0..16] of byte = (
    $8B, $47, $08, $85, $C0, $74, $48, $8B, $5F, $0C, $8B, $70, $04, $33, $D2, $55, 
    $68);
  HCBlock70Val2: array[0..38] of byte = (
    $64, $FF, $32, $64, $89, $22, $85, $DB, $7E, $12, $4B, $89, $5F, $0C, $8B, $44, 
    $DE, $04, $85, $C0, $74, $02, $FF, $D0, $85, $DB, $7F, $EE, $33, $C0, $5A, $59, 
    $59, $64, $89, $10, $EB, $14, $E9);
  HCBlock70Val3: array[0..5] of byte = (
    $E8, $B0, $FF, $FF, $FF, $E8);
  HCBlock70Val4: array[0..0] of byte = (
    $E8);
  HCBlock70Val5: array[0..4] of byte = (
    $5F, $5E, $5B, $5D, $C3);
  HCBlock70Val: array[0..5] of TVal = (
    (RA: $0; Count: length(HCBlock70Val0); Val: @HCBlock70Val0), 
    (RA: $B; Count: length(HCBlock70Val1); Val: @HCBlock70Val1), 
    (RA: $20; Count: length(HCBlock70Val2); Val: @HCBlock70Val2), 
    (RA: $4B; Count: length(HCBlock70Val3); Val: @HCBlock70Val3), 
    (RA: $55; Count: length(HCBlock70Val4); Val: @HCBlock70Val4), 
    (RA: $5A; Count: length(HCBlock70Val5); Val: @HCBlock70Val5));
  HCBlock70Vars: array[0..0] of TCVar = (
    (RA: $7; VN: 'InitContext'));
  HCBlock70IA: array[0..0] of TIA = (
    (RA: $1C; RRA: $46));
  HCBlock70: THCBlock = (
    Size: $60;
    RAC: length(HCBlock70RA); RA: @HCBlock70RA;
    ValC: length(HCBlock70Val); Val: @HCBlock70Val;
    VarsC: length(HCBlock70Vars); Vars: @HCBlock70Vars;
    IAC: length(HCBlock70IA); IA: @HCBlock70IA;
    PRC: 0; PR: nil);

  HCBlock71RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InitUnits'; CN: ''));
  HCBlock71Val0: array[0..6] of byte = (
    $55, $8B, $EC, $53, $56, $57, $A1);
  HCBlock71Val1: array[0..14] of byte = (
    $85, $C0, $74, $4B, $8B, $30, $33, $DB, $8B, $78, $04, $33, $D2, $55, $68);
  HCBlock71Val2: array[0..15] of byte = (
    $64, $FF, $32, $64, $89, $22, $3B, $F3, $7E, $14, $8B, $04, $DF, $43, $89, $1D);
  HCBlock71Val3: array[0..20] of byte = (
    $85, $C0, $74, $02, $FF, $D0, $3B, $F3, $7F, $EC, $33, $C0, $5A, $59, $59, $64, 
    $89, $10, $EB, $14, $E9);
  HCBlock71Val4: array[0..0] of byte = (
    $E8);
  HCBlock71Val5: array[0..0] of byte = (
    $E8);
  HCBlock71Val6: array[0..0] of byte = (
    $E8);
  HCBlock71Val7: array[0..4] of byte = (
    $5F, $5E, $5B, $5D, $C3);
  HCBlock71Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock71Val0); Val: @HCBlock71Val0), 
    (RA: $B; Count: length(HCBlock71Val1); Val: @HCBlock71Val1), 
    (RA: $1E; Count: length(HCBlock71Val2); Val: @HCBlock71Val2),
    (RA: $32; Count: length(HCBlock71Val3); Val: @HCBlock71Val3), 
    (RA: $4B; Count: length(HCBlock71Val4); Val: @HCBlock71Val4), 
    (RA: $50; Count: length(HCBlock71Val5); Val: @HCBlock71Val5), 
    (RA: $55; Count: length(HCBlock71Val6); Val: @HCBlock71Val6), 
    (RA: $5A; Count: length(HCBlock71Val7); Val: @HCBlock71Val7));
  HCBlock71IA: array[0..0] of TIA = (
    (RA: $1A; RRA: $46));
  HCBlock71: THCBlock = (
    Size: $60;
    RAC: length(HCBlock71RA); RA: @HCBlock71RA;
    ValC: length(HCBlock71Val); Val: @HCBlock71Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock71IA); IA: @HCBlock71IA;
    PRC: 0; PR: nil);

  HCBlock72RA: array[0..0] of TRA = (
    (RA: $0; PN: '@StartExe'; CN: ''));
  HCBlock72Val0: array[0..1] of byte = (
    $89, $05);
  HCBlock72Val1: array[0..3] of byte = (
    $31, $C0, $89, $05);
  HCBlock72Val2: array[0..1] of byte = (
    $89, $15);
  HCBlock72Val3: array[0..4] of byte = (
    $8B, $42, $04, $89, $05);
  HCBlock72Val4: array[0..0] of byte = (
    $E8);
  HCBlock72Val5: array[0..1] of byte = (
    $C6, $05);
  HCBlock72Val6: array[0..0] of byte = (
    $E8);
  HCBlock72Val7: array[0..0] of byte = (
    $C3);
  HCBlock72Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock72Val0); Val: @HCBlock72Val0), 
    (RA: $6; Count: length(HCBlock72Val1); Val: @HCBlock72Val1),
    (RA: $E; Count: length(HCBlock72Val2); Val: @HCBlock72Val2), 
    (RA: $14; Count: length(HCBlock72Val3); Val: @HCBlock72Val3), 
    (RA: $1D; Count: length(HCBlock72Val4); Val: @HCBlock72Val4), 
    (RA: $22; Count: length(HCBlock72Val5); Val: @HCBlock72Val5), 
    (RA: $29; Count: length(HCBlock72Val6); Val: @HCBlock72Val6), 
    (RA: $2E; Count: length(HCBlock72Val7); Val: @HCBlock72Val7));
  HCBlock72Vars: array[0..1] of TCVar = (
    (RA: $19; VN: 'MainInstance'), 
    (RA: $24; VN: 'IsLibrary'));
  HCBlock72: THCBlock = (
    Size: $30;
    RAC: length(HCBlock72RA); RA: @HCBlock72RA;
    ValC: length(HCBlock72Val); Val: @HCBlock72Val;
    VarsC: length(HCBlock72Vars); Vars: @HCBlock72Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock73RA: array[0..0] of TRA = (
    (RA: $0; PN: 'MakeErrorMessage'; CN: ''));
  HCBlock73Val0: array[0..2] of byte = (
    $53, $8B, $05);
  HCBlock73Val1: array[0..0] of byte = (
    $BB);
  HCBlock73Val2: array[0..20] of byte = (
    $B9, $0A, $00, $00, $00, $31, $D2, $F7, $F1, $80, $C2, $30, $88, $13, $4B, $85, 
    $C0, $75, $F2, $8B, $05);
  HCBlock73Val3: array[0..0] of byte = (
    $E8);
  HCBlock73Val4: array[0..1] of byte = (
    $8B, $15);
  HCBlock73Val5: array[0..3] of byte = (
    $92, $29, $D0, $BB);
  HCBlock73Val6: array[0..6] of byte = (
    $89, $C2, $83, $E2, $0F, $8A, $92);
  HCBlock73Val7: array[0..9] of byte = (
    $88, $13, $4B, $C1, $E8, $04, $75, $ED, $5B, $C3);
  HCBlock73Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock73Val0); Val: @HCBlock73Val0), 
    (RA: $7; Count: length(HCBlock73Val1); Val: @HCBlock73Val1), 
    (RA: $C; Count: length(HCBlock73Val2); Val: @HCBlock73Val2), 
    (RA: $25; Count: length(HCBlock73Val3); Val: @HCBlock73Val3), 
    (RA: $2A; Count: length(HCBlock73Val4); Val: @HCBlock73Val4), 
    (RA: $30; Count: length(HCBlock73Val5); Val: @HCBlock73Val5), 
    (RA: $38; Count: length(HCBlock73Val6); Val: @HCBlock73Val6), 
    (RA: $43; Count: length(HCBlock73Val7); Val: @HCBlock73Val7));
  HCBlock73Vars: array[0..3] of TCVar = (
    (RA: $3; VN: 'ExitCode'),
    (RA: $21; VN: 'ErrorAddr'),
    (RA: $3F; VN: 'dig'),
    (RA: $8; VN: 'runErrMsg'; VRA: $10));
  HCBlock73: THCBlock = (
    Size: $50;
    RAC: length(HCBlock73RA); RA: @HCBlock73RA;
    ValC: length(HCBlock73Val); Val: @HCBlock73Val;
    VarsC: length(HCBlock73Vars); Vars: @HCBlock73Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock74RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ExitDll'; CN: ''));
  HCBlock74Val0: array[0..0] of byte = (
    $BF);
  HCBlock74Val1: array[0..1] of byte = (
    $8B, $1D);
  HCBlock74Val2: array[0..1] of byte = (
    $8B, $2D);
  HCBlock74Val3: array[0..20] of byte = (
    $FF, $77, $1C, $FF, $77, $20, $8B, $37, $B9, $0B, $00, $00, $00, $F3, $A5, $5F, 
    $5E, $31, $C0, $87, $05);
  HCBlock74Val4: array[0..9] of byte = (
    $F7, $D8, $19, $C0, $40, $C9, $C2, $0C, $00, $C3);
  HCBlock74Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock74Val0); Val: @HCBlock74Val0),
    (RA: $5; Count: length(HCBlock74Val1); Val: @HCBlock74Val1), 
    (RA: $B; Count: length(HCBlock74Val2); Val: @HCBlock74Val2), 
    (RA: $11; Count: length(HCBlock74Val3); Val: @HCBlock74Val3), 
    (RA: $2A; Count: length(HCBlock74Val4); Val: @HCBlock74Val4));
  HCBlock74Vars: array[0..1] of TCVar = (
    (RA: $1; VN: 'InitContext'), 
    (RA: $26; VN: 'ExitCode'));
  HCBlock74: THCBlock = (
    Size: $34;
    RAC: length(HCBlock74RA); RA: @HCBlock74RA;
    ValC: length(HCBlock74Val); Val: @HCBlock74Val;
    VarsC: length(HCBlock74Vars); Vars: @HCBlock74Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock75RA: array[0..0] of TRA = (
    (RA: $0; PN: '@Halt0'; CN: ''));
  HCBlock75Val0: array[0..4 {8}] of byte = (
    $53, $56, $57, $55, $BB);
  HCBlock75Val1: array[0..2] of byte = (
    $74, $47, $E8);
  HCBlock75Val2: array[0..1] of byte = (
    $80, $3D);
  HCBlock75Val3: array[0..2] of byte = (
    $74, $16, $BA);
  HCBlock75Val4: array[0..0] of byte = (
    $E8);
  HCBlock75Val5: array[0..3] of byte = (
    $EB, $1C, $80, $3D);
  HCBlock75Val6: array[0..4] of byte = (
    $75, $13, $6A, $00, $68);
  HCBlock75Val7: array[0..2] of byte = (
    $33, $C0, $A3);
  HCBlock75Val8: array[0..16] of byte = (
    $80, $7B, $24, $02, $75, $0A, $83, $3E, $00, $75, $05, $33, $C0, $89, $43, $0C,
    $E8);
  HCBlock75Val9: array[0..18] of byte = (
    $80, $7B, $24, $01, $76, $05, $83, $3E, $00, $74, $1D, $8B, $43, $10, $85, $C0,
    $74, $16, $E8);
  HCBlock75Val10: array[0..4] of byte = (
    $8B, $43, $10, $8B, $50);
  HCBlock75Val11: array[0..0] of byte = (
    $E8);
  HCBlock75Val12: array[0..15] of byte = (
    $80, $7B, $24, $01, $75, $03, $FF, $53, $28, $80, $7B, $24, $00, $74, $05, $E8);
  HCBlock75Val13: array[0..8] of byte = (
    $83, $3B, $00, $75, $08, $8B, $06, $50, $E8);
  HCBlock75Val14: array[0..19] of byte = (
    $8B, $03, $56, $8B, $F0, $8B, $FB, $B9, $0B, $00, $00, $00, $F3, $A5, $5E, $EB,
    $8C, $50, $6F, $72);
  HCBlock75Val15: array[0..7] of byte = (
    $69, $6F, $6E, $73, $20, $43, $6F, $70);
  HCBlock75Val16: array[0..0] of byte = (
    $72);
  HCBlock75Val17: array[0..18] of byte = (
    $67, $68, $74, $20, $28, $63, $29, $20, $31, $39, $38, $33, $2C, $39, $39, $20,
    $42, $6F, $72);
  HCBlock75Val18: array[0..8] of byte = (
    $61, $6E, $64, $00, $5D, $5F, $5E, $5B, $C3);
  HCBlock75Val: array[0..18] of TVal = (
    (RA: $0; Count: length(HCBlock75Val0); Val: @HCBlock75Val0),
    (RA: $36; Count: length(HCBlock75Val1); Val: @HCBlock75Val1),
    (RA: $3D; Count: length(HCBlock75Val2); Val: @HCBlock75Val2),
    (RA: $44; Count: length(HCBlock75Val3); Val: @HCBlock75Val3),
    (RA: $55; Count: length(HCBlock75Val4); Val: @HCBlock75Val4),
    (RA: $5A; Count: length(HCBlock75Val5); Val: @HCBlock75Val5),
    (RA: $63; Count: length(HCBlock75Val6); Val: @HCBlock75Val6),
    (RA: $78; Count: length(HCBlock75Val7); Val: @HCBlock75Val7),
    (RA: $7F; Count: length(HCBlock75Val8); Val: @HCBlock75Val8),
    (RA: $94; Count: length(HCBlock75Val9); Val: @HCBlock75Val9),
    (RA: $AB; Count: length(HCBlock75Val10); Val: @HCBlock75Val10), 
    (RA: $BC; Count: length(HCBlock75Val11); Val: @HCBlock75Val11), 
    (RA: $C1; Count: length(HCBlock75Val12); Val: @HCBlock75Val12), 
    (RA: $D5; Count: length(HCBlock75Val13); Val: @HCBlock75Val13), 
    (RA: $E2; Count: length(HCBlock75Val14); Val: @HCBlock75Val14), 
    (RA: $F7; Count: length(HCBlock75Val15); Val: @HCBlock75Val15),
    (RA: $100; Count: length(HCBlock75Val16); Val: @HCBlock75Val16), 
    (RA: $102; Count: length(HCBlock75Val17); Val: @HCBlock75Val17), 
    (RA: $116; Count: length(HCBlock75Val18); Val: @HCBlock75Val18));
  HCBlock75Vars: array[0..2] of TCVar = (
    (RA: $31; VN: 'ErrorAddr'), 
    (RA: $3F; VN: 'IsConsole'), 
    (RA: $5E; VN: 'NoErrMsg'));
  HCBlock75: THCBlock = (
    Size: $120;
    RAC: length(HCBlock75RA); RA: @HCBlock75RA;
    ValC: length(HCBlock75Val); Val: @HCBlock75Val;
    VarsC: length(HCBlock75Vars); Vars: @HCBlock75Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock77RA: array[0..0] of TRA = (
    (RA: $0; PN: '@Halt'; CN: ''));
  HCBlock77Val0: array[0..1] of byte = (
    $89, $05);
  HCBlock77Val1: array[0..0] of byte = (
    $E9);
  HCBlock77Val2: array[0..0] of byte = (
    $C3);
  HCBlock77Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock77Val0); Val: @HCBlock77Val0),
    (RA: $6; Count: length(HCBlock77Val1); Val: @HCBlock77Val1),
    (RA: $B; Count: length(HCBlock77Val2); Val: @HCBlock77Val2));
  HCBlock77Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'ExitCode'));
  HCBlock77PR: array[0..0] of TPR = (
    (RA: $7; PN: '@Halt0'; CN: ''));
  HCBlock77: THCBlock = (
    Size: $C;
    RAC: length(HCBlock77RA); RA: @HCBlock77RA;
    ValC: length(HCBlock77Val); Val: @HCBlock77Val;
    VarsC: length(HCBlock77Vars); Vars: @HCBlock77Vars;
    IAC: 0; IA: nil;
    PRC: length(HCBlock77PR); PR: @HCBlock77PR);

  HCBlock78RA: array[0..0] of TRA = (
    (RA: $0; PN: '@RunError'; CN: ''));
  HCBlock78Val0: array[0..1] of byte = (
    $8F, $05);
  HCBlock78Val1: array[0..0] of byte = (
    $E9);
  HCBlock78Val2: array[0..0] of byte = (
    $C3);
  HCBlock78Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock78Val0); Val: @HCBlock78Val0), 
    (RA: $6; Count: length(HCBlock78Val1); Val: @HCBlock78Val1), 
    (RA: $B; Count: length(HCBlock78Val2); Val: @HCBlock78Val2));
  HCBlock78Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'ErrorAddr'));
  HCBlock78PR: array[0..0] of TPR = (
    (RA: $7; PN: '@Halt'; CN: ''));
  HCBlock78: THCBlock = (
    Size: $C;
    RAC: length(HCBlock78RA); RA: @HCBlock78RA;
    ValC: length(HCBlock78Val); Val: @HCBlock78Val;
    VarsC: length(HCBlock78Vars); Vars: @HCBlock78Vars;
    IAC: 0; IA: nil;
    PRC: length(HCBlock78PR); PR: @HCBlock78PR);

  HCBlock79RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrClr'; CN: ''));
  HCBlock79Val0: array[0..27] of byte = (
    $8B, $10, $85, $D2, $74, $1B, $C7, $00, $00, $00, $00, $00, $8B, $4A, $F8, $49,
    $7C, $0F, $89, $4A, $F8, $75, $0A, $50, $8D, $42, $F8, $E8);
  HCBlock79Val1: array[0..1] of byte = (
    $58, $C3);
  HCBlock79Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock79Val0); Val: @HCBlock79Val0),
    (RA: $20; Count: length(HCBlock79Val1); Val: @HCBlock79Val1));
  HCBlock79: THCBlock = (
    Size: $24;
    RAC: length(HCBlock79RA); RA: @HCBlock79RA;
    ValC: length(HCBlock79Val); Val: @HCBlock79Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock80RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrArrayClr'; CN: ''));
  HCBlock80Val0: array[0..32] of byte = (
    $53, $56, $89, $C3, $89, $D6, $8B, $13, $85, $D2, $74, $19, $C7, $03, $00, $00,
    $00, $00, $8B, $4A, $F8, $49, $7C, $0D, $89, $4A, $F8, $75, $08, $8D, $42, $F8,
    $E8);
  HCBlock80Val1: array[0..8] of byte = (
    $83, $C3, $04, $4E, $75, $DB, $5E, $5B, $C3);
  HCBlock80Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock80Val0); Val: @HCBlock80Val0), 
    (RA: $25; Count: length(HCBlock80Val1); Val: @HCBlock80Val1));
  HCBlock80: THCBlock = (
    Size: $30;
    RAC: length(HCBlock80RA); RA: @HCBlock80RA;
    ValC: length(HCBlock80Val); Val: @HCBlock80Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock81RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrClr'; CN: ''));
  HCBlock81Val0: array[0..14] of byte = (
    $8B, $10, $85, $D2, $74, $0E, $C7, $00, $00, $00, $00, $00, $50, $52, $E8);
  HCBlock81Val1: array[0..1] of byte = (
    $58, $C3);
  HCBlock81Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock81Val0); Val: @HCBlock81Val0),
    (RA: $13; Count: length(HCBlock81Val1); Val: @HCBlock81Val1));
  HCBlock81: THCBlock = (
    Size: $18;
    RAC: length(HCBlock81RA); RA: @HCBlock81RA;
    ValC: length(HCBlock81Val); Val: @HCBlock81Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock82RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrArrayClr'; CN: ''));
  HCBlock82Val0: array[0..19] of byte = (
    $53, $56, $89, $C3, $89, $D6, $8B, $03, $85, $C0, $74, $0C, $C7, $03, $00, $00, 
    $00, $00, $50, $E8);
  HCBlock82Val1: array[0..8] of byte = (
    $83, $C3, $04, $4E, $75, $E8, $5E, $5B, $C3);
  HCBlock82Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock82Val0); Val: @HCBlock82Val0),
    (RA: $18; Count: length(HCBlock82Val1); Val: @HCBlock82Val1));
  HCBlock82: THCBlock = (
    Size: $24;
    RAC: length(HCBlock82RA); RA: @HCBlock82RA;
    ValC: length(HCBlock82Val); Val: @HCBlock82Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock83RA: array[0..0] of TRA = (
    (RA: $0; PN: '@FinalizeRecord'; CN: ''));
  HCBlock83Val0: array[0..27] of byte = (
    $31, $C9, $53, $8A, $4A, $01, $56, $57, $89, $C3, $8D, $74, $0A, $0A, $8B, $7C, 
    $0A, $06, $8B, $16, $8B, $46, $04, $01, $D8, $8B, $12, $E8);
  HCBlock83Val1: array[0..11] of byte = (
    $83, $C6, $08, $4F, $7F, $EC, $89, $D8, $5F, $5E, $5B, $C3);
  HCBlock83Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock83Val0); Val: @HCBlock83Val0), 
    (RA: $20; Count: length(HCBlock83Val1); Val: @HCBlock83Val1));
  HCBlock83: THCBlock = (
    Size: $2C;
    RAC: length(HCBlock83RA); RA: @HCBlock83RA;
    ValC: length(HCBlock83Val); Val: @HCBlock83Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock84RA: array[0..0] of TRA = (
    (RA: $0; PN: '@FinalizeArray'; CN: ''));
  HCBlock84Val0: array[0..66] of byte = (
    $50, $53, $56, $57, $89, $C3, $89, $D6, $89, $CF, $31, $D2, $8A, $06, $8A, $56,
    $01, $80, $F8, $0A, $74, $31, $80, $F8, $0B, $74, $46, $80, $F8, $0C, $74, $58, 
    $80, $F8, $0D, $74, $62, $80, $F8, $0E, $74, $7B, $80, $F8, $0F, $0F, $84, $88, 
    $00, $00, $00, $80, $F8, $11, $0F, $84, $8E, $00, $00, $00, $5F, $5E, $5B, $58, 
    $B0, $02, $E9);
  HCBlock84Val1: array[0..7] of byte = (
    $83, $F9, $01, $89, $D8, $7F, $0A, $E8);
  HCBlock84Val2: array[0..7] of byte = (
    $E9, $81, $00, $00, $00, $89, $CA, $E8);
  HCBlock84Val3: array[0..9] of byte = (
    $EB, $78, $83, $F9, $01, $89, $D8, $7F, $07, $E8);
  HCBlock84Val4: array[0..4] of byte = (
    $EB, $6A, $89, $CA, $E8);
  HCBlock84Val5: array[0..7] of byte = (
    $EB, $61, $89, $D8, $83, $C3, $10, $E8);
  HCBlock84Val6: array[0..46] of byte = (
    $4F, $7F, $F3, $EB, $52, $55, $89, $D5, $8B, $54, $2E, $0A, $89, $D8, $03, $5C, 
    $2E, $02, $8B, $4C, $2E, $06, $8B, $12, $E8, $61, $FF, $FF, $FF, $4F, $7F, $E8, 
    $5D, $EB, $34, $55, $89, $D5, $89, $D8, $03, $5C, $2E, $02, $89, $F2, $E8);
  HCBlock84Val7: array[0..11] of byte = (
    $4F, $7F, $F0, $5D, $EB, $1E, $89, $D8, $83, $C3, $04, $E8);
  HCBlock84Val8: array[0..12] of byte = (
    $4F, $7F, $F3, $EB, $0F, $89, $D8, $89, $F2, $83, $C3, $04, $E8);
  HCBlock84Val9: array[0..7] of byte = (
    $4F, $7F, $F1, $5F, $5E, $5B, $58, $C3);
  HCBlock84Val: array[0..9] of TVal = (
    (RA: $0; Count: length(HCBlock84Val0); Val: @HCBlock84Val0), 
    (RA: $47; Count: length(HCBlock84Val1); Val: @HCBlock84Val1), 
    (RA: $53; Count: length(HCBlock84Val2); Val: @HCBlock84Val2), 
    (RA: $5F; Count: length(HCBlock84Val3); Val: @HCBlock84Val3), 
    (RA: $6D; Count: length(HCBlock84Val4); Val: @HCBlock84Val4), 
    (RA: $76; Count: length(HCBlock84Val5); Val: @HCBlock84Val5),
    (RA: $82; Count: length(HCBlock84Val6); Val: @HCBlock84Val6), 
    (RA: $B5; Count: length(HCBlock84Val7); Val: @HCBlock84Val7), 
    (RA: $C5; Count: length(HCBlock84Val8); Val: @HCBlock84Val8), 
    (RA: $D6; Count: length(HCBlock84Val9); Val: @HCBlock84Val9));
  HCBlock84: THCBlock = (
    Size: $E0;
    RAC: length(HCBlock84RA); RA: @HCBlock84RA;
    ValC: length(HCBlock84Val); Val: @HCBlock84Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock85RA: array[0..0] of TRA = (
    (RA: $0; PN: '@Finalize'; CN: ''));
  HCBlock85Val0: array[0..5] of byte = (
    $B9, $01, $00, $00, $00, $E9);
  HCBlock85Val1: array[0..0] of byte = (
    $C3);
  HCBlock85Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock85Val0); Val: @HCBlock85Val0), 
    (RA: $A; Count: length(HCBlock85Val1); Val: @HCBlock85Val1));
  HCBlock85PR: array[0..0] of TPR = (
    (RA: $6; PN: '@FinalizeArray'; CN: ''));
  HCBlock85: THCBlock = (
    Size: $C;
    RAC: length(HCBlock85RA); RA: @HCBlock85RA;
    ValC: length(HCBlock85Val); Val: @HCBlock85Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock85PR); PR: @HCBlock85PR);

  HCBlock86RA: array[0..0] of TRA = (
    (RA: $0; PN: 'VarCastError'; CN: ''));
  HCBlock86Val0: array[0..2] of byte = (
    $B0, $0F, $E9);
  HCBlock86Val1: array[0..0] of byte = (
    $C3);
  HCBlock86Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock86Val0); Val: @HCBlock86Val0), 
    (RA: $7; Count: length(HCBlock86Val1); Val: @HCBlock86Val1));
  HCBlock86: THCBlock = (
    Size: $8;
    RAC: length(HCBlock86RA); RA: @HCBlock86RA;
    ValC: length(HCBlock86Val); Val: @HCBlock86Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock87RA: array[0..0] of TRA = (
    (RA: $0; PN: 'VarInvalidOp'; CN: ''));
  HCBlock87Val0: array[0..2] of byte = (
    $B0, $10, $E9);
  HCBlock87Val1: array[0..0] of byte = (
    $C3);
  HCBlock87Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock87Val0); Val: @HCBlock87Val0), 
    (RA: $7; Count: length(HCBlock87Val1); Val: @HCBlock87Val1));
  HCBlock87: THCBlock = (
    Size: $8;
    RAC: length(HCBlock87RA); RA: @HCBlock87RA;
    ValC: length(HCBlock87Val); Val: @HCBlock87Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock88RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarClear'; CN: ''));
  HCBlock88Val0: array[0..32] of byte = (
    $31, $D2, $66, $8B, $10, $F7, $C2, $00, $40, $00, $00, $75, $28, $83, $FA, $08,
    $72, $23, $81, $FA, $00, $01, $00, $00, $74, $0E, $81, $FA, $01, $01, $00, $00, 
    $75);
  HCBlock88Val1: array[0..1] of byte = (
    $FF, $25);
  HCBlock88Val2: array[0..8] of byte = (
    $66, $C7, $00, $00, $00, $83, $C0, $08, $E9);
  HCBlock88Val3: array[0..5] of byte = (
    $66, $C7, $00, $00, $00, $C3);
  HCBlock88Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock88Val0); Val: @HCBlock88Val0), 
    (RA: $22; Count: length(HCBlock88Val1); Val: @HCBlock88Val1), 
    (RA: $28; Count: length(HCBlock88Val2); Val: @HCBlock88Val2), 
    (RA: $35; Count: length(HCBlock88Val3); Val: @HCBlock88Val3));
  HCBlock88Vars: array[0..0] of TCVar = (
    (RA: $24; VN: 'ClearAnyProc'));
  HCBlock88: THCBlock = (
    Size: $44;
    RAC: length(HCBlock88RA); RA: @HCBlock88RA;
    ValC: length(HCBlock88Val); Val: @HCBlock88Val;
    VarsC: length(HCBlock88Vars); Vars: @HCBlock88Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock89RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarClr'; CN: ''));
  HCBlock89Val0: array[0..1] of byte = (
    $50, $E8);
  HCBlock89Val1: array[0..1] of byte = (
    $58, $C3);
  HCBlock89Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock89Val0); Val: @HCBlock89Val0),
    (RA: $6; Count: length(HCBlock89Val1); Val: @HCBlock89Val1));
  HCBlock89PR: array[0..0] of TPR = (
    (RA: $2; PN: '@VarClear'; CN: ''));
  HCBlock89: THCBlock = (
    Size: $8;
    RAC: length(HCBlock89RA); RA: @HCBlock89RA;
    ValC: length(HCBlock89Val); Val: @HCBlock89Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock89PR); PR: @HCBlock89PR);

  HCBlock90RA: array[0..0] of TRA = (
    (RA: $0; PN: '@DynArrayClear'; CN: ''));
  HCBlock90Val0: array[0..42] of byte = (
    $8B, $08, $85, $C9, $74, $32, $C7, $00, $00, $00, $00, $00, $FF, $49, $F8, $75, 
    $27, $50, $89, $C8, $31, $C9, $8A, $4A, $01, $8B, $54, $0A, $06, $85, $D2, $74, 
    $0E, $8B, $48, $FC, $85, $C9, $74, $07, $8B, $12, $E8);
  HCBlock90Val1: array[0..3] of byte = (
    $83, $E8, $08, $E8);
  HCBlock90Val2: array[0..1] of byte = (
    $58, $C3);
  HCBlock90Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock90Val0); Val: @HCBlock90Val0), 
    (RA: $2F; Count: length(HCBlock90Val1); Val: @HCBlock90Val1),
    (RA: $37; Count: length(HCBlock90Val2); Val: @HCBlock90Val2));
  HCBlock90: THCBlock = (
    Size: $3C;
    RAC: length(HCBlock90RA); RA: @HCBlock90RA;
    ValC: length(HCBlock90Val); Val: @HCBlock90Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock91RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FindHInstance'; CN: ''));
  HCBlock91Val0: array[0..11] of byte = (
    $83, $C4, $E4, $6A, $1C, $8D, $54, $24, $04, $52, $50, $E8);
  HCBlock91Val1: array[0..21] of byte = (
    $81, $7C, $24, $10, $00, $10, $00, $00, $75, $06, $8B, $44, $24, $04, $EB, $02, 
    $33, $C0, $83, $C4, $1C, $C3);
  HCBlock91Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock91Val0); Val: @HCBlock91Val0), 
    (RA: $10; Count: length(HCBlock91Val1); Val: @HCBlock91Val1));
  HCBlock91: THCBlock = (
    Size: $28;
    RAC: length(HCBlock91RA); RA: @HCBlock91RA;
    ValC: length(HCBlock91Val); Val: @HCBlock91Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock92RA: array[0..0] of TRA = (
    (RA: $0; PN: 'LoadResourceModule'; CN: ''));
  HCBlock92Val0: array[0..28] of byte = (
    $55, $8B, $EC, $81, $C4, $E0, $FE, $FF, $FF, $53, $56, $89, $45, $FC, $68, $05,
    $01, $00, $00, $8D, $85, $E3, $FE, $FF, $FF, $50, $6A, $00, $E8);
  HCBlock92Val1: array[0..15] of byte = (
    $C6, $45, $EE, $00, $8D, $45, $F8, $50, $68, $3F, $00, $0F, $00, $6A, $00, $68);
  HCBlock92Val2: array[0..5] of byte = (
    $68, $01, $00, $00, $80, $E8);
  HCBlock92Val3: array[0..15] of byte = (
    $85, $C0, $74, $1E, $8D, $45, $F8, $50, $68, $3F, $00, $0F, $00, $6A, $00, $68);
  HCBlock92Val4: array[0..5] of byte = (
    $68, $01, $00, $00, $80, $E8);
  HCBlock92Val5: array[0..7] of byte = (
    $85, $C0, $75, $6D, $33, $C0, $55, $68);
  HCBlock92Val6: array[0..36] of byte = (
    $64, $FF, $30, $64, $89, $20, $C7, $45, $E8, $05, $00, $00, $00, $8D, $45, $E8, 
    $50, $8D, $45, $EE, $50, $6A, $00, $6A, $00, $8D, $85, $E3, $FE, $FF, $FF, $50, 
    $8B, $45, $F8, $50, $E8);
  HCBlock92Val7: array[0..16] of byte = (
    $85, $C0, $74, $1A, $8D, $45, $E8, $50, $8D, $45, $EE, $50, $6A, $00, $6A, $00, 
    $68);
  HCBlock92Val8: array[0..4] of byte = (
    $8B, $45, $F8, $50, $E8);
  HCBlock92Val9: array[0..8] of byte = (
    $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock92Val10: array[0..4] of byte = (
    $8B, $45, $F8, $50, $E8);
  HCBlock92Val11: array[0..1] of byte = (
    $C3, $E9);
  HCBlock92Val12: array[0..13] of byte = (
    $EB, $EF, $8B, $45, $FC, $50, $8D, $85, $E3, $FE, $FF, $FF, $50, $E8);
  HCBlock92Val13: array[0..8] of byte = (
    $6A, $05, $8D, $45, $F3, $50, $6A, $03, $E8);
  HCBlock92Val14: array[0..1] of byte = (
    $50, $E8);
  HCBlock92Val15: array[0..38] of byte = (
    $33, $F6, $80, $BD, $E3, $FE, $FF, $FF, $00, $0F, $84, $AF, $00, $00, $00, $80,
    $7D, $F3, $00, $75, $0A, $80, $7D, $EE, $00, $0F, $84, $9F, $00, $00, $00, $8D,
    $85, $E3, $FE, $FF, $FF, $50, $E8);
  HCBlock92Val16: array[0..50] of byte = (
    $8B, $D8, $8D, $85, $E3, $FE, $FF, $FF, $03, $D8, $EB, $01, $4B, $80, $3B, $2E,
    $74, $0A, $8D, $85, $E3, $FE, $FF, $FF, $3B, $D8, $75, $F0, $8D, $85, $E3, $FE,
    $FF, $FF, $3B, $D8, $74, $6D, $43, $80, $7D, $EE, $00, $74, $1C, $8D, $45, $EE,
    $50, $53, $E8);
  HCBlock92Val17: array[0..11] of byte = (
    $6A, $02, $6A, $00, $8D, $85, $E3, $FE, $FF, $FF, $50, $E8);
  HCBlock92Val18: array[0..17] of byte = (
    $8B, $F0, $85, $F6, $75, $46, $80, $7D, $F3, $00, $74, $40, $8D, $45, $F3, $50,
    $53, $E8);
  HCBlock92Val19: array[0..11] of byte = (
    $6A, $02, $6A, $00, $8D, $85, $E3, $FE, $FF, $FF, $50, $E8);
  HCBlock92Val20: array[0..15] of byte = (
    $8B, $F0, $85, $F6, $75, $20, $C6, $45, $F5, $00, $8D, $45, $F3, $50, $53, $E8);
  HCBlock92Val21: array[0..11] of byte = (
    $6A, $02, $6A, $00, $8D, $85, $E3, $FE, $FF, $FF, $50, $E8);
  HCBlock92Val22: array[0..9] of byte = (
    $8B, $F0, $8B, $C6, $5E, $5B, $8B, $E5, $5D, $C3);
  HCBlock92Val: array[0..22] of TVal = (
    (RA: $0; Count: length(HCBlock92Val0); Val: @HCBlock92Val0),
    (RA: $21; Count: length(HCBlock92Val1); Val: @HCBlock92Val1),
    (RA: $35; Count: length(HCBlock92Val2); Val: @HCBlock92Val2),
    (RA: $3F; Count: length(HCBlock92Val3); Val: @HCBlock92Val3),
    (RA: $53; Count: length(HCBlock92Val4); Val: @HCBlock92Val4),
    (RA: $5D; Count: length(HCBlock92Val5); Val: @HCBlock92Val5),
    (RA: $69; Count: length(HCBlock92Val6); Val: @HCBlock92Val6),
    (RA: $92; Count: length(HCBlock92Val7); Val: @HCBlock92Val7),
    (RA: $A7; Count: length(HCBlock92Val8); Val: @HCBlock92Val8),
    (RA: $B0; Count: length(HCBlock92Val9); Val: @HCBlock92Val9),
    (RA: $BD; Count: length(HCBlock92Val10); Val: @HCBlock92Val10),
    (RA: $C6; Count: length(HCBlock92Val11); Val: @HCBlock92Val11),
    (RA: $CC; Count: length(HCBlock92Val12); Val: @HCBlock92Val12),
    (RA: $DE; Count: length(HCBlock92Val13); Val: @HCBlock92Val13),
    (RA: $EB; Count: length(HCBlock92Val14); Val: @HCBlock92Val14),
    (RA: $F1; Count: length(HCBlock92Val15); Val: @HCBlock92Val15),
    (RA: $11C; Count: length(HCBlock92Val16); Val: @HCBlock92Val16),
    (RA: $153; Count: length(HCBlock92Val17); Val: @HCBlock92Val17),
    (RA: $163; Count: length(HCBlock92Val18); Val: @HCBlock92Val18),
    (RA: $179; Count: length(HCBlock92Val19); Val: @HCBlock92Val19),
    (RA: $189; Count: length(HCBlock92Val20); Val: @HCBlock92Val20),
    (RA: $19D; Count: length(HCBlock92Val21); Val: @HCBlock92Val21),
    (RA: $1AD; Count: length(HCBlock92Val22); Val: @HCBlock92Val22));
  HCBlock92IA: array[0..1] of TIA = (
    (RA: $65; RRA: $C7),
    (RA: $B9; RRA: $CE));
  HCBlock92: THCBlock = (
    Size: $1F8;
    RAC: length(HCBlock92RA); RA: @HCBlock92RA;
    ValC: length(HCBlock92Val); Val: @HCBlock92Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock92IA); IA: @HCBlock92IA;
    PRC: 0; PR: nil);

  HCBlock93RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyModuleUnload'; CN: ''));
  HCBlock93Val0: array[0..12] of byte = (
    $55, $8B, $EC, $83, $C4, $F8, $53, $56, $57, $89, $45, $FC, $A1);
  HCBlock93Val1: array[0..12] of byte = (
    $89, $45, $F8, $83, $7D, $F8, $00, $74, $39, $33, $C0, $55, $68);
  HCBlock93Val2: array[0..25] of byte = (
    $64, $FF, $30, $64, $89, $20, $8B, $5D, $F8, $8B, $45, $FC, $FF, $53, $04, $33, 
    $C0, $5A, $59, $59, $64, $89, $10, $EB, $0A, $E9);
  HCBlock93Val3: array[0..0] of byte = (
    $E8);
  HCBlock93Val4: array[0..20] of byte = (
    $8B, $45, $F8, $8B, $00, $89, $45, $F8, $83, $7D, $F8, $00, $75, $C7, $5F, $5E, 
    $5B, $59, $59, $5D, $C3);
  HCBlock93Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock93Val0); Val: @HCBlock93Val0),
    (RA: $11; Count: length(HCBlock93Val1); Val: @HCBlock93Val1), 
    (RA: $22; Count: length(HCBlock93Val2); Val: @HCBlock93Val2), 
    (RA: $40; Count: length(HCBlock93Val3); Val: @HCBlock93Val3), 
    (RA: $45; Count: length(HCBlock93Val4); Val: @HCBlock93Val4));
  HCBlock93Vars: array[0..0] of TCVar = (
    (RA: $D; VN: 'ModuleUnloadList'));
  HCBlock93IA: array[0..0] of TIA = (
    (RA: $1E; RRA: $3B));
  HCBlock93: THCBlock = (
    Size: $5C;
    RAC: length(HCBlock93RA); RA: @HCBlock93RA;
    ValC: length(HCBlock93Val); Val: @HCBlock93Val;
    VarsC: length(HCBlock93Vars); Vars: @HCBlock93Vars;
    IAC: length(HCBlock93IA); IA: @HCBlock93IA;
    PRC: 0; PR: nil);

  HCBlock94RA: array[0..0] of TRA = (
    (RA: $0; PN: 'RegisterModule'; CN: ''));
  HCBlock94Val0: array[0..1] of byte = (
    $8B, $15);
  HCBlock94Val1: array[0..2] of byte = (
    $89, $10, $A3);
  HCBlock94Val2: array[0..0] of byte = (
    $C3);
  HCBlock94Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock94Val0); Val: @HCBlock94Val0),
    (RA: $6; Count: length(HCBlock94Val1); Val: @HCBlock94Val1), 
    (RA: $D; Count: length(HCBlock94Val2); Val: @HCBlock94Val2));
  HCBlock94Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'LibModuleList'));
  HCBlock94: THCBlock = (
    Size: $10;
    RAC: length(HCBlock94RA); RA: @HCBlock94RA;
    ValC: length(HCBlock94Val); Val: @HCBlock94Val;
    VarsC: length(HCBlock94Vars); Vars: @HCBlock94Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock95RA: array[0..0] of TRA = (
    (RA: $0; PN: 'UnregisterModule'; CN: ''));
  HCBlock95Val0: array[0..10] of byte = (
    $55, $8B, $EC, $51, $89, $45, $FC, $33, $D2, $55, $68);
  HCBlock95Val1: array[0..12] of byte = (
    $64, $FF, $32, $64, $89, $22, $8B, $45, $FC, $8B, $40, $04, $E8);
  HCBlock95Val2: array[0..8] of byte = (
    $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock95Val3: array[0..4] of byte = (
    $8B, $45, $FC, $3B, $05);
  HCBlock95Val4: array[0..7] of byte = (
    $75, $0C, $8B, $45, $FC, $8B, $00, $A3);
  HCBlock95Val5: array[0..2] of byte = (
    $EB, $1F, $A1);
  HCBlock95Val6: array[0..27] of byte = (
    $85, $C0, $74, $16, $8B, $10, $3B, $55, $FC, $75, $09, $8B, $55, $FC, $8B, $12, 
    $89, $10, $EB, $06, $8B, $00, $85, $C0, $75, $EA, $C3, $E9);
  HCBlock95Val7: array[0..4] of byte = (
    $EB, $C2, $59, $5D, $C3);
  HCBlock95Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock95Val0); Val: @HCBlock95Val0), 
    (RA: $F; Count: length(HCBlock95Val1); Val: @HCBlock95Val1), 
    (RA: $20; Count: length(HCBlock95Val2); Val: @HCBlock95Val2), 
    (RA: $2D; Count: length(HCBlock95Val3); Val: @HCBlock95Val3),
    (RA: $36; Count: length(HCBlock95Val4); Val: @HCBlock95Val4), 
    (RA: $42; Count: length(HCBlock95Val5); Val: @HCBlock95Val5), 
    (RA: $49; Count: length(HCBlock95Val6); Val: @HCBlock95Val6), 
    (RA: $69; Count: length(HCBlock95Val7); Val: @HCBlock95Val7));
  HCBlock95Vars: array[0..0] of TCVar = (
    (RA: $32; VN: 'LibModuleList'));
  HCBlock95IA: array[0..1] of TIA = (
    (RA: $B; RRA: $64), 
    (RA: $29; RRA: $6B));
  HCBlock95: THCBlock = (
    Size: $70;
    RAC: length(HCBlock95RA); RA: @HCBlock95RA;
    ValC: length(HCBlock95Val); Val: @HCBlock95Val;
    VarsC: length(HCBlock95Vars); Vars: @HCBlock95Vars;
    IAC: length(HCBlock95IA); IA: @HCBlock95IA;
    PRC: 0; PR: nil);

  HCBlock96RA: array[0..0] of TRA = (
    (RA: $0; PN: '@IntfClear'; CN: ''));
  HCBlock96Val0: array[0..20] of byte = (
    $8B, $10, $85, $D2, $74, $0E, $C7, $00, $00, $00, $00, $00, $50, $52, $8B, $02, 
    $FF, $50, $08, $58, $C3);
  HCBlock96Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock96Val0); Val: @HCBlock96Val0));
  HCBlock96: THCBlock = (
    Size: $18;
    RAC: length(HCBlock96RA); RA: @HCBlock96RA;
    ValC: length(HCBlock96Val); Val: @HCBlock96Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock97RA: array[0..0] of TRA = (
    (RA: $0; PN: '@GetTls'; CN: ''));
  HCBlock97Val0: array[0..1] of byte = (
    $8A, $0D);
  HCBlock97Val1: array[0..1] of byte = (
    $8B, $05);
  HCBlock97Val2: array[0..15] of byte = (
    $84, $C9, $75, $28, $64, $8B, $15, $2C, $00, $00, $00, $8B, $04, $82, $C3, $E8);
  HCBlock97Val3: array[0..1] of byte = (
    $8B, $05);
  HCBlock97Val4: array[0..1] of byte = (
    $50, $E8);
  HCBlock97Val5: array[0..6] of byte = (
    $85, $C0, $74, $01, $C3, $8B, $05);
  HCBlock97Val6: array[0..2] of byte = (
    $C3, $50, $E8);
  HCBlock97Val7: array[0..4] of byte = (
    $85, $C0, $74, $D9, $C3);
  HCBlock97Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock97Val0); Val: @HCBlock97Val0), 
    (RA: $6; Count: length(HCBlock97Val1); Val: @HCBlock97Val1), 
    (RA: $C; Count: length(HCBlock97Val2); Val: @HCBlock97Val2), 
    (RA: $20; Count: length(HCBlock97Val3); Val: @HCBlock97Val3), 
    (RA: $26; Count: length(HCBlock97Val4); Val: @HCBlock97Val4), 
    (RA: $2C; Count: length(HCBlock97Val5); Val: @HCBlock97Val5),
    (RA: $37; Count: length(HCBlock97Val6); Val: @HCBlock97Val6),
    (RA: $3E; Count: length(HCBlock97Val7); Val: @HCBlock97Val7));
  HCBlock97Vars: array[0..2] of TCVar = (
    (RA: $2; VN: 'ModuleIsLib'), 
    (RA: $8; VN: 'TlsIndex'),
    (RA: $33; VN: 'TlsBuffer'));
  HCBlock97: THCBlock = (
    Size: $44;
    RAC: length(HCBlock97RA); RA: @HCBlock97RA;
    ValC: length(HCBlock97Val); Val: @HCBlock97Val;
    VarsC: length(HCBlock97Vars); Vars: @HCBlock97Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock98RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InitThreadTls'; CN: ''));
  HCBlock98Val0: array[0..11] of byte = (
    $53, $B8, $08, $00, $00, $00, $85, $C0, $74, $43, $83, $3D);
  HCBlock98Val1: array[0..7] of byte = (
    $7D, $0A, $B8, $E2, $00, $00, $00, $E8);
  HCBlock98Val2: array[0..7] of byte = (
    $68, $08, $00, $00, $00, $6A, $40, $E8);
  HCBlock98Val3: array[0..11] of byte = (
    $8B, $D8, $85, $DB, $75, $0C, $B8, $E2, $00, $00, $00, $E8);
  HCBlock98Val4: array[0..3] of byte = (
    $EB, $0C, $53, $A1);
  HCBlock98Val5: array[0..1] of byte = (
    $50, $E8);
  HCBlock98Val6: array[0..1] of byte = (
    $89, $1D);
  HCBlock98Val7: array[0..1] of byte = (
    $5B, $C3);
  HCBlock98Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock98Val0); Val: @HCBlock98Val0), 
    (RA: $11; Count: length(HCBlock98Val1); Val: @HCBlock98Val1), 
    (RA: $1D; Count: length(HCBlock98Val2); Val: @HCBlock98Val2),
    (RA: $29; Count: length(HCBlock98Val3); Val: @HCBlock98Val3), 
    (RA: $39; Count: length(HCBlock98Val4); Val: @HCBlock98Val4),
    (RA: $41; Count: length(HCBlock98Val5); Val: @HCBlock98Val5), 
    (RA: $47; Count: length(HCBlock98Val6); Val: @HCBlock98Val6), 
    (RA: $4D; Count: length(HCBlock98Val7); Val: @HCBlock98Val7));
  HCBlock98Vars: array[0..1] of TCVar = (
    (RA: $C; VN: 'TlsIndex'), 
    (RA: $49; VN: 'TlsBuffer'));
  HCBlock98: THCBlock = (
    Size: $50;
    RAC: length(HCBlock98RA); RA: @HCBlock98RA;
    ValC: length(HCBlock98Val); Val: @HCBlock98Val;
    VarsC: length(HCBlock98Vars); Vars: @HCBlock98Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock99RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InitializeModule'; CN: ''));
  HCBlock99Val0: array[0..17] of byte = (
    $53, $81, $C4, $F8, $FE, $FF, $FF, $68, $05, $01, $00, $00, $8D, $44, $24, $04, 
    $50, $A1);
  HCBlock99Val1: array[0..1] of byte = (
    $50, $E8);
  HCBlock99Val2: array[0..2] of byte = (
    $8B, $C4, $E8);
  HCBlock99Val3: array[0..3] of byte = (
    $8B, $D8, $89, $1D);
  HCBlock99Val4: array[0..4] of byte = (
    $85, $DB, $75, $0A, $A1);
  HCBlock99Val5: array[0..0] of byte = (
    $A3);
  HCBlock99Val6: array[0..0] of byte = (
    $B8);
  HCBlock99Val7: array[0..0] of byte = (
    $E8);
  HCBlock99Val8: array[0..7] of byte = (
    $81, $C4, $08, $01, $00, $00, $5B, $C3);
  HCBlock99Val: array[0..8] of TVal = (
    (RA: $0; Count: length(HCBlock99Val0); Val: @HCBlock99Val0), 
    (RA: $16; Count: length(HCBlock99Val1); Val: @HCBlock99Val1), 
    (RA: $1C; Count: length(HCBlock99Val2); Val: @HCBlock99Val2), 
    (RA: $23; Count: length(HCBlock99Val3); Val: @HCBlock99Val3), 
    (RA: $2B; Count: length(HCBlock99Val4); Val: @HCBlock99Val4), 
    (RA: $34; Count: length(HCBlock99Val5); Val: @HCBlock99Val5), 
    (RA: $39; Count: length(HCBlock99Val6); Val: @HCBlock99Val6), 
    (RA: $3E; Count: length(HCBlock99Val7); Val: @HCBlock99Val7), 
    (RA: $43; Count: length(HCBlock99Val8); Val: @HCBlock99Val8));
  HCBlock99Vars: array[0..0] of TCVar = (
    (RA: $12; VN: 'HInstance'));
  HCBlock99: THCBlock = (
    Size: $4C;
    RAC: length(HCBlock99RA); RA: @HCBlock99RA;
    ValC: length(HCBlock99Val); Val: @HCBlock99Val;
    VarsC: length(HCBlock99Vars); Vars: @HCBlock99Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock100RA: array[0..0] of TRA = (
    (RA: $0; PN: '@InitExe'; CN: ''));
  HCBlock100Val0: array[0..3] of byte = (
    $50, $6A, $00, $E8);
  HCBlock100Val1: array[0..0] of byte = (
    $BA);
  HCBlock100Val2: array[0..2] of byte = (
    $52, $89, $05);
  HCBlock100Val3: array[0..17] of byte = (
    $89, $42, $04, $C7, $42, $08, $00, $00, $00, $00, $C7, $42, $0C, $00, $00, $00, 
    $00, $E8);
  HCBlock100Val4: array[0..2] of byte = (
    $5A, $58, $E8);
  HCBlock100Val5: array[0..0] of byte = (
    $C3);
  HCBlock100Val: array[0..5] of TVal = (
    (RA: $0; Count: length(HCBlock100Val0); Val: @HCBlock100Val0), 
    (RA: $8; Count: length(HCBlock100Val1); Val: @HCBlock100Val1), 
    (RA: $D; Count: length(HCBlock100Val2); Val: @HCBlock100Val2), 
    (RA: $14; Count: length(HCBlock100Val3); Val: @HCBlock100Val3), 
    (RA: $2A; Count: length(HCBlock100Val4); Val: @HCBlock100Val4), 
    (RA: $31; Count: length(HCBlock100Val5); Val: @HCBlock100Val5));
  HCBlock100Vars: array[0..1] of TCVar = (
    (RA: $9; VN: 'Module'),
    (RA: $10; VN: 'HInstance'));
  HCBlock100: THCBlock = (
    Size: $34;
    RAC: length(HCBlock100RA); RA: @HCBlock100RA;
    ValC: length(HCBlock100Val); Val: @HCBlock100Val;
    VarsC: length(HCBlock100Vars); Vars: @HCBlock100Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock101RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetCmdShow'; CN: ''));
  HCBlock101Val0: array[0..10] of byte = (
    $53, $83, $C4, $BC, $BB, $0A, $00, $00, $00, $54, $E8);
  HCBlock101Val1: array[0..18] of byte = (
    $F6, $44, $24, $2C, $01, $74, $05, $0F, $B7, $5C, $24, $30, $8B, $C3, $83, $C4,
    $44, $5B, $C3);
  HCBlock101Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock101Val0); Val: @HCBlock101Val0),
    (RA: $F; Count: length(HCBlock101Val1); Val: @HCBlock101Val1));
  HCBlock101: THCBlock = (
    Size: $24;
    RAC: length(HCBlock101RA); RA: @HCBlock101RA;
    ValC: length(HCBlock101Val); Val: @HCBlock101Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock102RA: array[0..0] of TRA = (
    (RA: $0; PN: HandleOnExceptionProcName; CN: ''));
  HCBlock102Val0: array[0..26] of byte = (
    $8B, $44, $24, $04, $F7, $40, $04, $06, $00, $00, $00, $0F, $85, $1E, $01, $00,
    $00, $81, $38, $DE, $FA, $ED, $0E, $74, $1F, $FC, $E8);
  HCBlock102Val1: array[0..1] of byte = (
    $8B, $15);
  HCBlock102Val2: array[0..85] of byte = (
    $85, $D2, $0F, $84, $02, $01, $00, $00, $FF, $D2, $85, $C0, $75, $0A, $E9, $F7,
    $00, $00, $00, $8B, $40, $18, $8B, $00, $8B, $54, $24, $08, $53, $56, $57, $55,
    $8B, $4A, $04, $8B, $59, $05, $8D, $71, $09, $89, $C5, $8B, $06, $85, $C0, $74,
    $43, $89, $EF, $EB, $02, $8B, $3F, $8B, $00, $39, $F8, $74, $37, $8B, $48, $D8,
    $3B, $4F, $D8, $75, $17, $8B, $40, $D4, $8B, $57, $D4, $31, $C9, $8A, $08, $3A,
    $0A, $75, $09, $40, $42, $E8);
  HCBlock102Val3: array[0..45] of byte = (
    $74, $18, $8B, $7F, $DC, $8B, $06, $85, $FF, $75, $D0, $83, $C6, $08, $4B, $75,
    $C0, $5D, $5F, $5E, $5B, $E9, $96, $00, $00, $00, $8B, $44, $24, $14, $81, $38,
    $DE, $FA, $ED, $0E, $8B, $50, $18, $8B, $48, $14, $74, $18, $FF, $15);
  HCBlock102Val4: array[0..4] of byte = (
    $8B, $54, $24, $1C, $E8);
  HCBlock102Val5: array[0..30] of byte = (
    $89, $C2, $8B, $44, $24, $14, $8B, $48, $0C, $31, $DB, $64, $8B, $1B, $53, $50,
    $52, $51, $8B, $54, $24, $28, $83, $48, $04, $02, $56, $6A, $00, $50, $68);
  HCBlock102Val6: array[0..1] of byte = (
    $52, $E8);
  HCBlock102Val7: array[0..5] of byte = (
    $5B, $8B, $7C, $24, $28, $E8);
  HCBlock102Val8: array[0..17] of byte = (
    $FF, $B0, $00, $00, $00, $00, $89, $A0, $00, $00, $00, $00, $8B, $6F, $08, $C7,
    $47, $04);
  HCBlock102Val9: array[0..4] of byte = (
    $8B, $44, $24, $08, $E8);
  HCBlock102Val10: array[0..3] of byte = (
    $FF, $63, $04, $E9);
  HCBlock102Val11: array[0..0] of byte = (
    $E8);
  HCBlock102Val12: array[0..17] of byte = (
    $8B, $88, $00, $00, $00, $00, $8B, $11, $89, $90, $00, $00, $00, $00, $8B, $41,
    $08, $E9);
  HCBlock102Val13: array[0..5] of byte = (
    $B8, $01, $00, $00, $00, $C3);
  HCBlock102Val: array[0..13] of TVal = (
    (RA: $0; Count: length(HCBlock102Val0); Val: @HCBlock102Val0),
    (RA: $1F; Count: length(HCBlock102Val1); Val: @HCBlock102Val1),
    (RA: $25; Count: length(HCBlock102Val2); Val: @HCBlock102Val2),
    (RA: $7F; Count: length(HCBlock102Val3); Val: @HCBlock102Val3),
    (RA: $B1; Count: length(HCBlock102Val4); Val: @HCBlock102Val4),
    (RA: $BA; Count: length(HCBlock102Val5); Val: @HCBlock102Val5),
    (RA: $DD; Count: length(HCBlock102Val6); Val: @HCBlock102Val6),
    (RA: $E3; Count: length(HCBlock102Val7); Val: @HCBlock102Val7),
    (RA: $ED; Count: length(HCBlock102Val8); Val: @HCBlock102Val8),
    (RA: $103; Count: length(HCBlock102Val9); Val: @HCBlock102Val9),
    (RA: $10C; Count: length(HCBlock102Val10); Val: @HCBlock102Val10),
    (RA: $114; Count: length(HCBlock102Val11); Val: @HCBlock102Val11),
    (RA: $119; Count: length(HCBlock102Val12); Val: @HCBlock102Val12),
    (RA: $12F; Count: length(HCBlock102Val13); Val: @HCBlock102Val13));
  HCBlock102Vars: array[0..1] of TCVar = (
    (RA: $21; VN: 'ExceptClsProc'),
    (RA: $AD; VN: 'ExceptObjProc'));
  HCBlock102IA: array[0..1] of TIA = (
    (RA: $D9; RRA: $E3),
    (RA: $FF; RRA: $10F));
  HCBlock102: THCBlock = (
    Size: $138;
    RAC: length(HCBlock102RA); RA: @HCBlock102RA;
    ValC: length(HCBlock102Val); Val: @HCBlock102Val;
    VarsC: length(HCBlock102Vars); Vars: @HCBlock102Vars;
    IAC: length(HCBlock102IA); IA: @HCBlock102IA;
    PRC: 0; PR: nil);

  HCBlock103RA: array[0..0] of TRA = (
    (RA: $0; PN: '@ReallocMem'; CN: ''));
  HCBlock103Val0: array[0..14] of byte = (
    $8B, $08, $85, $C9, $74, $32, $85, $D2, $74, $18, $50, $89, $C8, $FF, $15);
  HCBlock103Val1: array[0..10] of byte = (
    $59, $09, $C0, $74, $19, $89, $01, $C3, $B0, $02, $E9);
  HCBlock103Val2: array[0..5] of byte = (
    $89, $10, $89, $C8, $FF, $15);
  HCBlock103Val3: array[0..7] of byte = (
    $09, $C0, $75, $EB, $C3, $B0, $01, $E9);
  HCBlock103Val4: array[0..8] of byte = (
    $85, $D2, $74, $10, $50, $89, $D0, $FF, $15);
  HCBlock103Val5: array[0..7] of byte = (
    $59, $09, $C0, $74, $E7, $89, $01, $C3);
  HCBlock103Val: array[0..5] of TVal = (
    (RA: $0; Count: length(HCBlock103Val0); Val: @HCBlock103Val0), 
    (RA: $13; Count: length(HCBlock103Val1); Val: @HCBlock103Val1), 
    (RA: $22; Count: length(HCBlock103Val2); Val: @HCBlock103Val2), 
    (RA: $2C; Count: length(HCBlock103Val3); Val: @HCBlock103Val3), 
    (RA: $38; Count: length(HCBlock103Val4); Val: @HCBlock103Val4),
    (RA: $45; Count: length(HCBlock103Val5); Val: @HCBlock103Val5));
  HCBlock103Vars: array[0..0] of TCVar = (
    (RA: $41; VN: 'MemoryManager'));
  HCBlock103: THCBlock = (
    Size: $50;
    RAC: length(HCBlock103RA); RA: @HCBlock103RA;
    ValC: length(HCBlock103Val); Val: @HCBlock103Val;
    VarsC: length(HCBlock103Vars); Vars: @HCBlock103Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock104RA: array[0..0] of TRA = (
    (RA: $0; PN: AbstractErrorProcName; CN: ''));
  HCBlock104Val0: array[0..1] of byte = (
    $83, $3D);
  HCBlock104Val1: array[0..3] of byte = (
    $74, $06, $FF, $15);
  HCBlock104Val2: array[0..5] of byte = (
    $B8, $D2, $00, $00, $00, $E9);
  HCBlock104Val3: array[0..0] of byte = (
    $C3);
  HCBlock104Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock104Val0); Val: @HCBlock104Val0),
    (RA: $7; Count: length(HCBlock104Val1); Val: @HCBlock104Val1),
    (RA: $F; Count: length(HCBlock104Val2); Val: @HCBlock104Val2),
    (RA: $19; Count: length(HCBlock104Val3); Val: @HCBlock104Val3));
  HCBlock104Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'AbstractErrorProc'));
  HCBlock104: THCBlock = (
    Size: $1C;
    RAC: length(HCBlock104RA); RA: @HCBlock104RA;
    ValC: length(HCBlock104Val); Val: @HCBlock104Val;
    VarsC: length(HCBlock104Vars); Vars: @HCBlock104Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock105RA: array[0..0] of TRA = (
    (RA: $0; PN: InitResStringImportsProcName; CN: ''));
  HCBlock105Val0: array[0..14] of byte = (
    $53, $56, $8B, $18, $8D, $70, $04, $8B, $46, $04, $8B, $16, $8B, $00, $E8);
  HCBlock105Val1: array[0..8] of byte = (
    $83, $C6, $08, $4B, $75, $EE, $5E, $5B, $C3);
  HCBlock105Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock105Val0); Val: @HCBlock105Val0), 
    (RA: $13; Count: length(HCBlock105Val1); Val: @HCBlock105Val1));
  HCBlock105: THCBlock = (
    Size: $1C;
    RAC: length(HCBlock105RA); RA: @HCBlock105RA;
    ValC: length(HCBlock105Val); Val: @HCBlock105Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock106RA: array[0..0] of TRA = (
    (RA: $0; PN: InitImportsProcName; CN: ''));
  HCBlock106Val0: array[0..29] of byte = (
    $53, $56, $8B, $18, $8D, $70, $04, $8B, $46, $04, $8B, $16, $8B, $4E, $08, $8B, 
    $00, $01, $C8, $89, $02, $83, $C6, $0C, $4B, $75, $EC, $5E, $5B, $C3);
  HCBlock106Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock106Val0); Val: @HCBlock106Val0));
  HCBlock106: THCBlock = (
    Size: $20;
    RAC: length(HCBlock106RA); RA: @HCBlock106RA;
    ValC: length(HCBlock106Val); Val: @HCBlock106Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock107RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrAsg'; CN: ''));
  HCBlock107Val0: array[0..15] of byte = (
    $85, $D2, $74, $23, $8B, $4A, $F8, $41, $7F, $1A, $50, $52, $8B, $42, $FC, $E8);
  HCBlock107Val1: array[0..7] of byte = (
    $89, $C2, $58, $52, $8B, $48, $FC, $E8);
  HCBlock107Val2: array[0..27] of byte = (
    $5A, $58, $EB, $03, $89, $4A, $F8, $87, $10, $85, $D2, $74, $13, $8B, $4A, $F8,
    $49, $7C, $0D, $89, $4A, $F8, $75, $08, $8D, $42, $F8, $E8);
  HCBlock107Val3: array[0..0] of byte = (
    $C3);
  HCBlock107Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock107Val0); Val: @HCBlock107Val0),
    (RA: $14; Count: length(HCBlock107Val1); Val: @HCBlock107Val1), 
    (RA: $20; Count: length(HCBlock107Val2); Val: @HCBlock107Val2), 
    (RA: $40; Count: length(HCBlock107Val3); Val: @HCBlock107Val3));
  HCBlock107: THCBlock = (
    Size: $44;
    RAC: length(HCBlock107RA); RA: @HCBlock107RA;
    ValC: length(HCBlock107Val); Val: @HCBlock107Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock108RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrLAsg'; CN: ''));
  HCBlock108Val0: array[0..33] of byte = (
    $85, $D2, $74, $09, $8B, $4A, $F8, $41, $7E, $03, $89, $4A, $F8, $87, $10, $85, 
    $D2, $74, $13, $8B, $4A, $F8, $49, $7C, $0D, $89, $4A, $F8, $75, $08, $8D, $42, 
    $F8, $E8);
  HCBlock108Val1: array[0..0] of byte = (
    $C3);
  HCBlock108Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock108Val0); Val: @HCBlock108Val0), 
    (RA: $26; Count: length(HCBlock108Val1); Val: @HCBlock108Val1));
  HCBlock108: THCBlock = (
    Size: $28;
    RAC: length(HCBlock108RA); RA: @HCBlock108RA;
    ValC: length(HCBlock108Val); Val: @HCBlock108Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock109RA: array[0..0] of TRA = (
    (RA: $0; PN: '@NewAnsiString'; CN: ''));
  HCBlock109Val0: array[0..8] of byte = (
    $85, $C0, $7E, $1C, $50, $83, $C0, $09, $E8);
  HCBlock109Val1: array[0..21] of byte = (
    $83, $C0, $08, $5A, $89, $50, $FC, $C7, $40, $F8, $01, $00, $00, $00, $C6, $04, 
    $10, $00, $C3, $31, $C0, $C3);
  HCBlock109Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock109Val0); Val: @HCBlock109Val0), 
    (RA: $D; Count: length(HCBlock109Val1); Val: @HCBlock109Val1));
  HCBlock109: THCBlock = (
    Size: $24;
    RAC: length(HCBlock109RA); RA: @HCBlock109RA;
    ValC: length(HCBlock109Val); Val: @HCBlock109Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock110RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromPCharLen'; CN: ''));
  HCBlock110Val0: array[0..11] of byte = (
    $53, $56, $57, $89, $C3, $89, $D6, $89, $CF, $89, $F8, $E8);
  HCBlock110Val1: array[0..12] of byte = (
    $89, $F9, $89, $C7, $85, $F6, $74, $09, $89, $C2, $89, $F0, $E8);
  HCBlock110Val2: array[0..2] of byte = (
    $89, $D8, $E8);
  HCBlock110Val3: array[0..5] of byte = (
    $89, $3B, $5F, $5E, $5B, $C3);
  HCBlock110Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock110Val0); Val: @HCBlock110Val0), 
    (RA: $10; Count: length(HCBlock110Val1); Val: @HCBlock110Val1), 
    (RA: $21; Count: length(HCBlock110Val2); Val: @HCBlock110Val2),
    (RA: $28; Count: length(HCBlock110Val3); Val: @HCBlock110Val3));
  HCBlock110: THCBlock = (
    Size: $30;
    RAC: length(HCBlock110RA); RA: @HCBlock110RA;
    ValC: length(HCBlock110Val); Val: @HCBlock110Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock111RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromPWCharLen'; CN: ''));
  HCBlock111Val0: array[0..22] of byte = (
    $53, $56, $57, $55, $81, $C4, $00, $F8, $FF, $FF, $8B, $D9, $8B, $EA, $8B, $F8, 
    $85, $DB, $7F, $09, $8B, $C7, $E8);
  HCBlock111Val1: array[0..30] of byte = (
    $EB, $67, $81, $FB, $00, $04, $00, $00, $7D, $2C, $6A, $00, $6A, $00, $68, $00, 
    $08, $00, $00, $8D, $44, $24, $0C, $50, $53, $55, $6A, $00, $6A, $00, $E8);
  HCBlock111Val2: array[0..12] of byte = (
    $8B, $F0, $85, $F6, $7E, $0D, $8B, $D4, $8B, $C7, $8B, $CE, $E8);
  HCBlock111Val3: array[0..16] of byte = (
    $EB, $33, $6A, $00, $6A, $00, $6A, $00, $6A, $00, $53, $55, $6A, $00, $6A, $00, 
    $E8);
  HCBlock111Val4: array[0..8] of byte = (
    $8B, $F0, $8B, $C7, $8B, $CE, $33, $D2, $E8);
  HCBlock111Val5: array[0..14] of byte = (
    $6A, $00, $6A, $00, $56, $8B, $07, $50, $53, $55, $6A, $00, $6A, $00, $E8);
  HCBlock111Val6: array[0..10] of byte = (
    $81, $C4, $00, $08, $00, $00, $5D, $5F, $5E, $5B, $C3);
  HCBlock111Val: array[0..6] of TVal = (
    (RA: $0; Count: length(HCBlock111Val0); Val: @HCBlock111Val0), 
    (RA: $1B; Count: length(HCBlock111Val1); Val: @HCBlock111Val1),
    (RA: $3E; Count: length(HCBlock111Val2); Val: @HCBlock111Val2), 
    (RA: $4F; Count: length(HCBlock111Val3); Val: @HCBlock111Val3), 
    (RA: $64; Count: length(HCBlock111Val4); Val: @HCBlock111Val4), 
    (RA: $71; Count: length(HCBlock111Val5); Val: @HCBlock111Val5), 
    (RA: $84; Count: length(HCBlock111Val6); Val: @HCBlock111Val6));
  HCBlock111: THCBlock = (
    Size: $90;
    RAC: length(HCBlock111RA); RA: @HCBlock111RA;
    ValC: length(HCBlock111Val); Val: @HCBlock111Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock112RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromChar'; CN: ''));
  HCBlock112Val0: array[0..8] of byte = (
    $52, $89, $E2, $B9, $01, $00, $00, $00, $E8);
  HCBlock112Val1: array[0..1] of byte = (
    $5A, $C3);
  HCBlock112Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock112Val0); Val: @HCBlock112Val0), 
    (RA: $D; Count: length(HCBlock112Val1); Val: @HCBlock112Val1));
  HCBlock112: THCBlock = (
    Size: $10;
    RAC: length(HCBlock112RA); RA: @HCBlock112RA;
    ValC: length(HCBlock112Val); Val: @HCBlock112Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock113RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromPChar'; CN: ''));
  HCBlock113Val0: array[0..39] of byte = (
    $31, $C9, $85, $D2, $74, $21, $52, $3A, $0A, $74, $17, $3A, $4A, $01, $74, $11, 
    $3A, $4A, $02, $74, $0B, $3A, $4A, $03, $74, $05, $83, $C2, $04, $EB, $E8, $42, 
    $42, $42, $89, $D1, $5A, $29, $D1, $E9);
  HCBlock113Val1: array[0..0] of byte = (
    $C3);
  HCBlock113Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock113Val0); Val: @HCBlock113Val0), 
    (RA: $2C; Count: length(HCBlock113Val1); Val: @HCBlock113Val1));
  HCBlock113: THCBlock = (
    Size: $30;
    RAC: length(HCBlock113RA); RA: @HCBlock113RA;
    ValC: length(HCBlock113Val); Val: @HCBlock113Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock114RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromPWChar'; CN: ''));
  HCBlock114Val0: array[0..51] of byte = (
    $31, $C9, $85, $D2, $74, $2D, $52, $66, $3B, $0A, $74, $20, $66, $3B, $4A, $02, 
    $74, $17, $66, $3B, $4A, $04, $74, $0E, $66, $3B, $4A, $06, $74, $05, $83, $C2, 
    $08, $EB, $E4, $83, $C2, $02, $83, $C2, $02, $83, $C2, $02, $89, $D1, $5A, $29, 
    $D1, $D1, $E9, $E9);
  HCBlock114Val1: array[0..0] of byte = (
    $C3);
  HCBlock114Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock114Val0); Val: @HCBlock114Val0), 
    (RA: $38; Count: length(HCBlock114Val1); Val: @HCBlock114Val1));
  HCBlock114: THCBlock = (
    Size: $3C;
    RAC: length(HCBlock114RA); RA: @HCBlock114RA;
    ValC: length(HCBlock114Val); Val: @HCBlock114Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock115RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromArray'; CN: ''));
  HCBlock115Val0: array[0..18] of byte = (
    $57, $50, $51, $89, $D7, $31, $C0, $F2, $AE, $75, $02, $F7, $D1, $58, $01, $C1, 
    $58, $5F, $E9);
  HCBlock115Val1: array[0..0] of byte = (
    $C3);
  HCBlock115Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock115Val0); Val: @HCBlock115Val0), 
    (RA: $17; Count: length(HCBlock115Val1); Val: @HCBlock115Val1));
  HCBlock115: THCBlock = (
    Size: $18;
    RAC: length(HCBlock115RA); RA: @HCBlock115RA;
    ValC: length(HCBlock115Val); Val: @HCBlock115Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock116RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromWStr'; CN: ''));
  HCBlock116Val0: array[0..11] of byte = (
    $31, $C9, $85, $D2, $74, $05, $8B, $4A, $FC, $D1, $E9, $E9);
  HCBlock116Val1: array[0..0] of byte = (
    $C3);
  HCBlock116Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock116Val0); Val: @HCBlock116Val0), 
    (RA: $10; Count: length(HCBlock116Val1); Val: @HCBlock116Val1));
  HCBlock116: THCBlock = (
    Size: $14;
    RAC: length(HCBlock116RA); RA: @HCBlock116RA;
    ValC: length(HCBlock116Val); Val: @HCBlock116Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock117RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrLen'; CN: ''));
  HCBlock117Val0: array[0..7] of byte = (
    $85, $C0, $74, $03, $8B, $40, $FC, $C3);
  HCBlock117Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock117Val0); Val: @HCBlock117Val0));
  HCBlock117: THCBlock = (
    Size: $8;
    RAC: length(HCBlock117RA); RA: @HCBlock117RA;
    ValC: length(HCBlock117Val); Val: @HCBlock117Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock118RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrCat'; CN: ''));
  HCBlock118Val0: array[0..9] of byte = (
    $85, $D2, $74, $3F, $8B, $08, $85, $C9, $0F, $84);
  HCBlock118Val1: array[0..19] of byte = (
    $53, $56, $57, $89, $C3, $89, $D6, $8B, $79, $FC, $8B, $56, $FC, $01, $FA, $39,
    $CE, $74, $17, $E8);
  HCBlock118Val2: array[0..9] of byte = (
    $89, $F0, $8B, $4E, $FC, $8B, $13, $01, $FA, $E8);
  HCBlock118Val3: array[0..4] of byte = (
    $5F, $5E, $5B, $C3, $E8);
  HCBlock118Val4: array[0..6] of byte = (
    $8B, $03, $89, $F9, $EB, $E8, $C3);
  HCBlock118Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock118Val0); Val: @HCBlock118Val0), 
    (RA: $E; Count: length(HCBlock118Val1); Val: @HCBlock118Val1), 
    (RA: $26; Count: length(HCBlock118Val2); Val: @HCBlock118Val2), 
    (RA: $34; Count: length(HCBlock118Val3); Val: @HCBlock118Val3), 
    (RA: $3D; Count: length(HCBlock118Val4); Val: @HCBlock118Val4));
  HCBlock118: THCBlock = (
    Size: $44;
    RAC: length(HCBlock118RA); RA: @HCBlock118RA;
    ValC: length(HCBlock118Val); Val: @HCBlock118Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock119RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrCatN'; CN: ''));
  HCBlock119Val0: array[0..22] of byte = (
    $53, $56, $52, $50, $89, $D3, $31, $C0, $8B, $4C, $94, $10, $85, $C9, $74, $03, 
    $03, $41, $FC, $4A, $75, $F2, $E8);
  HCBlock119Val1: array[0..18] of byte = (
    $50, $89, $C6, $8B, $44, $9C, $14, $89, $F2, $85, $C0, $74, $0A, $8B, $48, $FC, 
    $01, $CE, $E8);
  HCBlock119Val2: array[0..12] of byte = (
    $4B, $75, $E9, $5A, $58, $85, $D2, $74, $03, $FF, $4A, $F8, $E8);
  HCBlock119Val3: array[0..9] of byte = (
    $5A, $5E, $5B, $58, $8D, $24, $94, $FF, $E0, $C3);
  HCBlock119Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock119Val0); Val: @HCBlock119Val0), 
    (RA: $1B; Count: length(HCBlock119Val1); Val: @HCBlock119Val1), 
    (RA: $32; Count: length(HCBlock119Val2); Val: @HCBlock119Val2), 
    (RA: $43; Count: length(HCBlock119Val3); Val: @HCBlock119Val3));
  HCBlock119: THCBlock = (
    Size: $50;
    RAC: length(HCBlock119RA); RA: @HCBlock119RA;
    ValC: length(HCBlock119Val); Val: @HCBlock119Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock120RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrToPChar'; CN: ''));
  HCBlock120Val0: array[0..6] of byte = (
    $85, $C0, $74, $02, $C3, $00, $B8);
  HCBlock120Val1: array[0..0] of byte = (
    $C3);
  HCBlock120Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock120Val0); Val: @HCBlock120Val0), 
    (RA: $B; Count: length(HCBlock120Val1); Val: @HCBlock120Val1));
  HCBlock120IA: array[0..0] of TIA = (
    (RA: $7; RRA: $5));
  HCBlock120: THCBlock = (
    Size: $C;
    RAC: length(HCBlock120RA); RA: @HCBlock120RA;
    ValC: length(HCBlock120Val); Val: @HCBlock120Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock120IA); IA: @HCBlock120IA;
    PRC: 0; PR: nil);

  HCBlock121RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrCopy'; CN: ''));
  HCBlock121Val0: array[0..35] of byte = (
    $53, $85, $C0, $74, $2D, $8B, $58, $FC, $85, $DB, $74, $26, $4A, $7C, $1B, $39, 
    $DA, $7D, $1F, $29, $D3, $85, $C9, $7C, $19, $39, $D9, $7F, $11, $01, $C2, $8B, 
    $44, $24, $08, $E8);
  HCBlock121Val1: array[0..14] of byte = (
    $EB, $11, $31, $D2, $EB, $E5, $89, $D9, $EB, $EB, $8B, $44, $24, $08, $E8);
  HCBlock121Val2: array[0..4] of byte = (
    $5B, $C2, $04, $00, $C3);
  HCBlock121Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock121Val0); Val: @HCBlock121Val0), 
    (RA: $28; Count: length(HCBlock121Val1); Val: @HCBlock121Val1), 
    (RA: $3B; Count: length(HCBlock121Val2); Val: @HCBlock121Val2));
  HCBlock121: THCBlock = (
    Size: $40;
    RAC: length(HCBlock121RA); RA: @HCBlock121RA;
    ValC: length(HCBlock121Val); Val: @HCBlock121Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock122RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrSetLength'; CN: ''));
  HCBlock122Val0: array[0..34] of byte = (
    $53, $56, $57, $89, $C3, $89, $D6, $31, $FF, $85, $D2, $74, $48, $8B, $03, $85, 
    $C0, $74, $23, $83, $78, $F8, $01, $75, $1D, $83, $E8, $08, $83, $C2, $09, $50, 
    $89, $E0, $E8);
  HCBlock122Val1: array[0..17] of byte = (
    $58, $83, $C0, $08, $89, $03, $89, $70, $FC, $C6, $04, $30, $00, $EB, $28, $89, 
    $D0, $E8);
  HCBlock122Val2: array[0..19] of byte = (
    $89, $C7, $8B, $03, $85, $C0, $74, $10, $89, $FA, $8B, $48, $FC, $39, $F1, $7C, 
    $02, $89, $F1, $E8);
  HCBlock122Val3: array[0..2] of byte = (
    $89, $D8, $E8);
  HCBlock122Val4: array[0..5] of byte = (
    $89, $3B, $5F, $5E, $5B, $C3);
  HCBlock122Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock122Val0); Val: @HCBlock122Val0), 
    (RA: $27; Count: length(HCBlock122Val1); Val: @HCBlock122Val1), 
    (RA: $3D; Count: length(HCBlock122Val2); Val: @HCBlock122Val2), 
    (RA: $55; Count: length(HCBlock122Val3); Val: @HCBlock122Val3), 
    (RA: $5C; Count: length(HCBlock122Val4); Val: @HCBlock122Val4));
  HCBlock122: THCBlock = (
    Size: $64;
    RAC: length(HCBlock122RA); RA: @HCBlock122RA;
    ValC: length(HCBlock122Val); Val: @HCBlock122Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock123RA: array[0..0] of TRA = (
    (RA: $0; PN: '@ValLong'; CN: ''));
  HCBlock123Val0: array[0..203] of byte = (
    $53, $56, $57, $89, $C6, $50, $85, $C0, $74, $73, $31, $C0, $31, $DB, $BF, $CC, 
    $CC, $CC, $0C, $8A, $1E, $46, $80, $FB, $20, $74, $F8, $B5, $00, $80, $FB, $2D, 
    $74, $69, $80, $FB, $2B, $74, $66, $80, $FB, $24, $74, $66, $80, $FB, $78, $74, 
    $61, $80, $FB, $58, $74, $5C, $80, $FB, $30, $75, $13, $8A, $1E, $46, $80, $FB,
    $78, $74, $4F, $80, $FB, $58, $74, $4A, $84, $DB, $74, $20, $EB, $04, $84, $DB, 
    $74, $34, $80, $EB, $30, $80, $FB, $09, $77, $2C, $39, $F8, $77, $28, $8D, $04, 
    $80, $01, $C0, $01, $D8, $8A, $1E, $46, $84, $DB, $75, $E6, $FE, $CD, $74, $10, 
    $85, $C0, $7C, $12, $59, $31, $F6, $89, $32, $5F, $5E, $5B, $C3, $46, $EB, $06, 
    $F7, $D8, $7E, $F0, $78, $EE, $5B, $29, $DE, $EB, $EC, $FE, $C5, $8A, $1E, $46, 
    $EB, $BC, $BF, $FF, $FF, $FF, $0F, $8A, $1E, $46, $84, $DB, $74, $DF, $80, $FB, 
    $61, $72, $03, $80, $EB, $20, $80, $EB, $30, $80, $FB, $09, $76, $0B, $80, $EB, 
    $11, $80, $FB, $05, $77, $D0, $80, $C3, $0A, $39, $F8, $77, $C9, $C1, $E0, $04, 
    $01, $D8, $8A, $1E, $46, $84, $DB, $75, $D5, $EB, $A9, $C3);
  HCBlock123Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock123Val0); Val: @HCBlock123Val0));
  HCBlock123: THCBlock = (
    Size: $CC;
    RAC: length(HCBlock123RA); RA: @HCBlock123RA;
    ValC: length(HCBlock123Val); Val: @HCBlock123Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock124RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FindResourceHInstance'; CN: ''));
  HCBlock124Val0: array[0..1] of byte = (
    $8B, $15);
  HCBlock124Val1: array[0..2] of byte = (
    $85, $D2, $74);
  HCBlock124Val2: array[0..13] of byte = (
    $3B, $42, $04, $74, $0A, $3B, $42, $08, $74, $05, $3B, $42, $0C, $75);
  HCBlock124Val3: array[0..3] of byte = (
    $8B, $42, $10, $C3);
  HCBlock124Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock124Val0); Val: @HCBlock124Val0),
    (RA: $6; Count: length(HCBlock124Val1); Val: @HCBlock124Val1),
    (RA: $A; Count: length(HCBlock124Val2); Val: @HCBlock124Val2),
    (RA: $19; Count: length(HCBlock124Val3); Val: @HCBlock124Val3));
  HCBlock124Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'LibModuleList'));
  HCBlock124: THCBlock = (
    Size: $24;
    RAC: length(HCBlock124RA); RA: @HCBlock124RA;
    ValC: length(HCBlock124Val); Val: @HCBlock124Val;
    VarsC: length(HCBlock124Vars); Vars: @HCBlock124Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock125RA: array[0..0] of TRA = (
    (RA: $0; PN: 'LoadResString'; CN: ''));
  HCBlock125Val0: array[0..43] of byte = (
    $53, $56, $81, $C4, $00, $FC, $FF, $FF, $8B, $F2, $8B, $D8, $85, $DB, $74, $3D,
    $81, $7B, $04, $00, $00, $01, $00, $7D, $2A, $68, $00, $04, $00, $00, $8D, $44, 
    $24, $04, $50, $8B, $43, $04, $50, $8B, $03, $8B, $00, $E8);
  HCBlock125Val1: array[0..1] of byte = (
    $50, $E8);
  HCBlock125Val2: array[0..6] of byte = (
    $8B, $C8, $8B, $D4, $8B, $C6, $E8);
  HCBlock125Val3: array[0..7] of byte = (
    $EB, $0A, $8B, $C6, $8B, $53, $04, $E8);
  HCBlock125Val4: array[0..8] of byte = (
    $81, $C4, $00, $04, $00, $00, $5E, $5B, $C3);
  HCBlock125Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock125Val0); Val: @HCBlock125Val0), 
    (RA: $30; Count: length(HCBlock125Val1); Val: @HCBlock125Val1),
    (RA: $36; Count: length(HCBlock125Val2); Val: @HCBlock125Val2),
    (RA: $41; Count: length(HCBlock125Val3); Val: @HCBlock125Val3),
    (RA: $4D; Count: length(HCBlock125Val4); Val: @HCBlock125Val4));
  HCBlock125: THCBlock = (
    Size: $58;
    RAC: length(HCBlock125RA); RA: @HCBlock125RA;
    ValC: length(HCBlock125Val); Val: @HCBlock125Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock128RA: array[0..0] of TRA = (
    (RA: $0; PN: '@_IOTest'; CN: ''));
  HCBlock128Val0: array[0..3] of byte = (
    $50, $52, $51, $E8);
  HCBlock128Val1: array[0..15] of byte = (
    $83, $B8, $04, $00, $00, $00, $00, $59, $5A, $58, $75, $01, $C3, $31, $C0, $E9);
  HCBlock128Val2: array[0..0] of byte = (
    $C3);
  HCBlock128Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock128Val0); Val: @HCBlock128Val0),
    (RA: $8; Count: length(HCBlock128Val1); Val: @HCBlock128Val1),
    (RA: $1C; Count: length(HCBlock128Val2); Val: @HCBlock128Val2));
  HCBlock128: THCBlock = (
    Size: $20;
    RAC: length(HCBlock128RA); RA: @HCBlock128RA;
    ValC: length(HCBlock128Val); Val: @HCBlock128Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock129RA: array[0..0] of TRA = (
    (RA: $0; PN: 'IOResult'; CN: ''));
  HCBlock129Val0: array[0..0] of byte = (
    $E8);
  HCBlock129Val1: array[0..16] of byte = (
    $31, $D2, $8B, $88, $04, $00, $00, $00, $89, $90, $04, $00, $00, $00, $89, $C8,
    $C3);
  HCBlock129Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock129Val0); Val: @HCBlock129Val0),
    (RA: $5; Count: length(HCBlock129Val1); Val: @HCBlock129Val1));
  HCBlock129: THCBlock = (
    Size: $18;
    RAC: length(HCBlock129RA); RA: @HCBlock129RA;
    ValC: length(HCBlock129Val); Val: @HCBlock129Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock130RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ClassName'; CN: 'TObject'));
  HCBlock130Val0: array[0..16] of byte = (
    $56, $57, $89, $D7, $8B, $70, $D4, $31, $C9, $8A, $0E, $41, $F3, $A4, $5F, $5E,
    $C3);
  HCBlock130Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock130Val0); Val: @HCBlock130Val0));
  HCBlock130: THCBlock = (
    Size: $14;
    RAC: length(HCBlock130RA); RA: @HCBlock130RA;
    ValC: length(HCBlock130Val); Val: @HCBlock130Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock131RA: array[0..0] of TRA = (
    (RA: $0; PN: '@IsClass'; CN: ''));
  HCBlock131Val0: array[0..20] of byte = (
    $85, $C0, $74, $10, $8B, $00, $39, $D0, $74, $08, $8B, $40, $DC, $85, $C0, $75, 
    $F3, $C3, $B0, $01, $C3);
  HCBlock131Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock131Val0); Val: @HCBlock131Val0));
  HCBlock131: THCBlock = (
    Size: $18;
    RAC: length(HCBlock131RA); RA: @HCBlock131RA;
    ValC: length(HCBlock131Val); Val: @HCBlock131Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock132RA: array[0..0] of TRA = (
    (RA: $0; PN: '@RaiseExcept'; CN: ''));
  HCBlock132Val0: array[0..19] of byte = (
    $5A, $54, $55, $57, $56, $53, $50, $52, $54, $6A, $07, $6A, $01, $68, $DE, $FA, 
    $ED, $0E, $52, $E9);
  HCBlock132Val1: array[0..0] of byte = (
    $C3);
  HCBlock132Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock132Val0); Val: @HCBlock132Val0), 
    (RA: $18; Count: length(HCBlock132Val1); Val: @HCBlock132Val1));
  HCBlock132: THCBlock = (
    Size: $1C;
    RAC: length(HCBlock132RA); RA: @HCBlock132RA;
    ValC: length(HCBlock132Val); Val: @HCBlock132Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock133RA: array[0..0] of TRA = (
    (RA: $0; PN: 'WideCharLenToStrVar'; CN: ''));
  HCBlock133Val0: array[0..22] of byte = (
    $53, $56, $57, $55, $81, $C4, $00, $F8, $FF, $FF, $8B, $F1, $8B, $DA, $8B, $F8,
    $85, $DB, $75, $09, $8B, $C6, $E8);
  HCBlock133Val1: array[0..30] of byte = (
    $EB, $61, $81, $FB, $00, $04, $00, $00, $7D, $26, $6A, $00, $6A, $00, $68, $00,
    $08, $00, $00, $8D, $44, $24, $0C, $50, $53, $57, $6A, $00, $6A, $00, $E8);
  HCBlock133Val2: array[0..6] of byte = (
    $8B, $C8, $8B, $D4, $8B, $C6, $E8);
  HCBlock133Val3: array[0..16] of byte = (
    $EB, $33, $6A, $00, $6A, $00, $6A, $00, $6A, $00, $53, $57, $6A, $00, $6A, $00,
    $E8);
  HCBlock133Val4: array[0..8] of byte = (
    $8B, $E8, $8B, $C6, $8B, $CD, $33, $D2, $E8);
  HCBlock133Val5: array[0..14] of byte = (
    $6A, $00, $6A, $00, $55, $8B, $06, $50, $53, $57, $6A, $00, $6A, $00, $E8);
  HCBlock133Val6: array[0..10] of byte = (
    $81, $C4, $00, $08, $00, $00, $5D, $5F, $5E, $5B, $C3);
  HCBlock133Val: array[0..6] of TVal = (
    (RA: $0; Count: length(HCBlock133Val0); Val: @HCBlock133Val0),
    (RA: $1B; Count: length(HCBlock133Val1); Val: @HCBlock133Val1),
    (RA: $3E; Count: length(HCBlock133Val2); Val: @HCBlock133Val2),
    (RA: $49; Count: length(HCBlock133Val3); Val: @HCBlock133Val3),
    (RA: $5E; Count: length(HCBlock133Val4); Val: @HCBlock133Val4),
    (RA: $6B; Count: length(HCBlock133Val5); Val: @HCBlock133Val5),
    (RA: $7E; Count: length(HCBlock133Val6); Val: @HCBlock133Val6));
  HCBlock133: THCBlock = (
    Size: $8C;
    RAC: length(HCBlock133RA); RA: @HCBlock133RA;
    ValC: length(HCBlock133Val); Val: @HCBlock133Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock134RA: array[0..0] of TRA = (
    (RA: $0; PN: 'OleStrToStrVar'; CN: ''));
  HCBlock134Val0: array[0..15] of byte = (
    $53, $56, $6A, $00, $8B, $F2, $8B, $D8, $89, $1C, $24, $8B, $04, $24, $50, $E8);
  HCBlock134Val1: array[0..6] of byte = (
    $8B, $D0, $8B, $CE, $8B, $C3, $E8);
  HCBlock134Val2: array[0..3] of byte = (
    $5A, $5E, $5B, $C3);
  HCBlock134Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock134Val0); Val: @HCBlock134Val0), 
    (RA: $14; Count: length(HCBlock134Val1); Val: @HCBlock134Val1), 
    (RA: $1F; Count: length(HCBlock134Val2); Val: @HCBlock134Val2));
  HCBlock134: THCBlock = (
    Size: $24;
    RAC: length(HCBlock134RA); RA: @HCBlock134RA;
    ValC: length(HCBlock134Val); Val: @HCBlock134Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock135RA: array[0..0] of TRA = (
    (RA: $0; PN: 'StringToOleStr'; CN: ''));
  HCBlock135Val0: array[0..14] of byte = (
    $53, $56, $57, $55, $81, $C4, $00, $F8, $FF, $FF, $8B, $D8, $8B, $C3, $E8);
  HCBlock135Val1: array[0..4] of byte = (
    $8B, $F0, $8B, $C3, $E8);
  HCBlock135Val2: array[0..20] of byte = (
    $3D, $00, $04, $00, $00, $7D, $2B, $68, $00, $04, $00, $00, $8D, $44, $24, $04, 
    $50, $56, $8B, $C3, $E8);
  HCBlock135Val3: array[0..5] of byte = (
    $50, $6A, $00, $6A, $00, $E8);
  HCBlock135Val4: array[0..6] of byte = (
    $50, $8D, $44, $24, $04, $50, $E8);
  HCBlock135Val5: array[0..14] of byte = (
    $8B, $F8, $EB, $28, $6A, $00, $6A, $00, $56, $53, $6A, $00, $6A, $00, $E8);
  HCBlock135Val6: array[0..5] of byte = (
    $8B, $E8, $55, $6A, $00, $E8);
  HCBlock135Val7: array[0..10] of byte = (
    $8B, $F8, $55, $57, $56, $53, $6A, $00, $6A, $00, $E8);
  HCBlock135Val8: array[0..12] of byte = (
    $8B, $C7, $81, $C4, $00, $08, $00, $00, $5D, $5F, $5E, $5B, $C3);
  HCBlock135Val: array[0..8] of TVal = (
    (RA: $0; Count: length(HCBlock135Val0); Val: @HCBlock135Val0), 
    (RA: $13; Count: length(HCBlock135Val1); Val: @HCBlock135Val1), 
    (RA: $1C; Count: length(HCBlock135Val2); Val: @HCBlock135Val2), 
    (RA: $35; Count: length(HCBlock135Val3); Val: @HCBlock135Val3), 
    (RA: $3F; Count: length(HCBlock135Val4); Val: @HCBlock135Val4), 
    (RA: $4A; Count: length(HCBlock135Val5); Val: @HCBlock135Val5), 
    (RA: $5D; Count: length(HCBlock135Val6); Val: @HCBlock135Val6), 
    (RA: $67; Count: length(HCBlock135Val7); Val: @HCBlock135Val7), 
    (RA: $76; Count: length(HCBlock135Val8); Val: @HCBlock135Val8));
  HCBlock135: THCBlock = (
    Size: $84;
    RAC: length(HCBlock135RA); RA: @HCBlock135RA;
    ValC: length(HCBlock135Val); Val: @HCBlock135Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock136RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarCopy'; CN: ''));
  HCBlock136Val0: array[0..31] of byte = (
    $39, $D0, $0F, $84, $8F, $00, $00, $00, $66, $83, $38, $08, $72, $2A, $50, $52, 
    $66, $81, $38, $00, $01, $74, $17, $66, $81, $38, $01, $01, $74, $08, $50, $E8);
  HCBlock136Val1: array[0..3] of byte = (
    $EB, $10, $FF, $15);
  HCBlock136Val2: array[0..5] of byte = (
    $EB, $08, $83, $C0, $08, $E8);
  HCBlock136Val3: array[0..47] of byte = (
    $5A, $58, $66, $83, $3A, $08, $73, $11, $8B, $0A, $89, $08, $8B, $4A, $08, $89, 
    $48, $08, $8B, $4A, $0C, $89, $48, $0C, $C3, $66, $81, $3A, $00, $01, $74, $14, 
    $66, $81, $3A, $01, $01, $75, $26, $50, $E8, $DB, $FF, $FF, $FF, $58, $FF, $25);
  HCBlock136Val4: array[0..32] of byte = (
    $8B, $52, $08, $09, $D2, $74, $09, $8B, $4A, $F8, $41, $7E, $03, $89, $4A, $F8, 
    $66, $C7, $00, $00, $01, $89, $50, $08, $C3, $66, $C7, $00, $00, $00, $52, $50, 
    $E8);
  HCBlock136Val5: array[0..3] of byte = (
    $09, $C0, $0F, $85);
  HCBlock136Val6: array[0..0] of byte = (
    $C3);
  HCBlock136Val: array[0..6] of TVal = (
    (RA: $0; Count: length(HCBlock136Val0); Val: @HCBlock136Val0), 
    (RA: $24; Count: length(HCBlock136Val1); Val: @HCBlock136Val1), 
    (RA: $2C; Count: length(HCBlock136Val2); Val: @HCBlock136Val2), 
    (RA: $36; Count: length(HCBlock136Val3); Val: @HCBlock136Val3), 
    (RA: $6A; Count: length(HCBlock136Val4); Val: @HCBlock136Val4), 
    (RA: $8F; Count: length(HCBlock136Val5); Val: @HCBlock136Val5), 
    (RA: $97; Count: length(HCBlock136Val6); Val: @HCBlock136Val6));
  HCBlock136Vars: array[0..1] of TCVar = (
    (RA: $28; VN: 'ClearAnyProc'), 
    (RA: $66; VN: 'RefAnyProc'));
  HCBlock136: THCBlock = (
    Size: $98;
    RAC: length(HCBlock136RA); RA: @HCBlock136RA;
    ValC: length(HCBlock136Val); Val: @HCBlock136Val;
    VarsC: length(HCBlock136Vars); Vars: @HCBlock136Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock137RA: array[0..0] of TRA = (
    (RA: $0; PN: 'AnyChangeType'; CN: ''));
  HCBlock137Val0: array[0..30] of byte = (
    $55, $8B, $EC, $83, $C4, $F0, $53, $56, $57, $8B, $F2, $8D, $7D, $F0, $51, $B9, 
    $04, $00, $00, $00, $F3, $A5, $59, $8B, $F1, $8B, $D8, $8D, $45, $F0, $E8);
  HCBlock137Val1: array[0..3] of byte = (
    $33, $C0, $55, $68);
  HCBlock137Val2: array[0..10] of byte = (
    $64, $FF, $30, $64, $89, $20, $8D, $45, $F0, $FF, $15);
  HCBlock137Val3: array[0..7] of byte = (
    $8D, $55, $F0, $8B, $C3, $8B, $CE, $E8);
  HCBlock137Val4: array[0..8] of byte = (
    $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock137Val5: array[0..3] of byte = (
    $8D, $45, $F0, $E8);
  HCBlock137Val6: array[0..1] of byte = (
    $C3, $E9);
  HCBlock137Val7: array[0..8] of byte = (
    $EB, $F0, $5F, $5E, $5B, $8B, $E5, $5D, $C3);
  HCBlock137Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock137Val0); Val: @HCBlock137Val0), 
    (RA: $23; Count: length(HCBlock137Val1); Val: @HCBlock137Val1), 
    (RA: $2B; Count: length(HCBlock137Val2); Val: @HCBlock137Val2), 
    (RA: $3A; Count: length(HCBlock137Val3); Val: @HCBlock137Val3), 
    (RA: $46; Count: length(HCBlock137Val4); Val: @HCBlock137Val4), 
    (RA: $53; Count: length(HCBlock137Val5); Val: @HCBlock137Val5), 
    (RA: $5B; Count: length(HCBlock137Val6); Val: @HCBlock137Val6), 
    (RA: $61; Count: length(HCBlock137Val7); Val: @HCBlock137Val7));
  HCBlock137Vars: array[0..0] of TCVar = (
    (RA: $36; VN: 'ChangeAnyProc'));
  HCBlock137IA: array[0..1] of TIA = (
    (RA: $27; RRA: $5C),
    (RA: $4F; RRA: $63));
  HCBlock137: THCBlock = (
    Size: $6C;
    RAC: length(HCBlock137RA); RA: @HCBlock137RA;
    ValC: length(HCBlock137Val); Val: @HCBlock137Val;
    VarsC: length(HCBlock137Vars); Vars: @HCBlock137Vars;
    IAC: length(HCBlock137IA); IA: @HCBlock137IA;
    PRC: 0; PR: nil);

  HCBlock138RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ChangeSourceAny'; CN: ''));
  HCBlock138Val0: array[0..10] of byte = (
    $53, $33, $DB, $66, $81, $3A, $01, $01, $75, $07, $E8);
  HCBlock138Val1: array[0..5] of byte = (
    $B3, $01, $8B, $C3, $5B, $C3);
  HCBlock138Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock138Val0); Val: @HCBlock138Val0),
    (RA: $F; Count: length(HCBlock138Val1); Val: @HCBlock138Val1));
  HCBlock138: THCBlock = (
    Size: $18;
    RAC: length(HCBlock138RA); RA: @HCBlock138RA;
    ValC: length(HCBlock138Val); Val: @HCBlock138Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock139RA: array[0..0] of TRA = (
    (RA: $0; PN: 'VarChangeType'; CN: ''));
  HCBlock139Val0: array[0..37] of byte = (
    $55, $8B, $EC, $83, $C4, $F0, $53, $56, $57, $8B, $F9, $8B, $F2, $8B, $D8, $66, 
    $8B, $03, $66, $2D, $00, $01, $74, $07, $66, $FF, $C8, $74, $4C, $EB, $57, $8B, 
    $D6, $8B, $C3, $8B, $CF, $E8);
  HCBlock139Val1: array[0..23] of byte = (
    $84, $C0, $75, $6F, $66, $C7, $45, $F0, $00, $00, $57, $6A, $00, $68, $00, $04, 
    $00, $00, $56, $8D, $45, $F0, $50, $E8);
  HCBlock139Val2: array[0..4] of byte = (
    $85, $C0, $74, $05, $E8);
  HCBlock139Val3: array[0..2] of byte = (
    $8B, $C3, $E8);
  HCBlock139Val4: array[0..25] of byte = (
    $8B, $45, $F0, $89, $03, $8B, $45, $F8, $89, $43, $08, $8B, $45, $FC, $89, $43, 
    $0C, $EB, $34, $8B, $D6, $8B, $C3, $8B, $CF, $E8);
  HCBlock139Val5: array[0..8] of byte = (
    $EB, $27, $8B, $D6, $8B, $C3, $8B, $CF, $E8);
  HCBlock139Val6: array[0..14] of byte = (
    $84, $C0, $75, $18, $57, $6A, $00, $68, $00, $04, $00, $00, $56, $53, $E8);
  HCBlock139Val7: array[0..4] of byte = (
    $85, $C0, $74, $05, $E8);
  HCBlock139Val8: array[0..6] of byte = (
    $5F, $5E, $5B, $8B, $E5, $5D, $C3);
  HCBlock139Val: array[0..8] of TVal = (
    (RA: $0; Count: length(HCBlock139Val0); Val: @HCBlock139Val0), 
    (RA: $2A; Count: length(HCBlock139Val1); Val: @HCBlock139Val1), 
    (RA: $46; Count: length(HCBlock139Val2); Val: @HCBlock139Val2), 
    (RA: $4F; Count: length(HCBlock139Val3); Val: @HCBlock139Val3), 
    (RA: $56; Count: length(HCBlock139Val4); Val: @HCBlock139Val4), 
    (RA: $74; Count: length(HCBlock139Val5); Val: @HCBlock139Val5), 
    (RA: $81; Count: length(HCBlock139Val6); Val: @HCBlock139Val6), 
    (RA: $94; Count: length(HCBlock139Val7); Val: @HCBlock139Val7), 
    (RA: $9D; Count: length(HCBlock139Val8); Val: @HCBlock139Val8));
  HCBlock139: THCBlock = (
    Size: $A4;
    RAC: length(HCBlock139RA); RA: @HCBlock139RA;
    ValC: length(HCBlock139Val); Val: @HCBlock139Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock140RA: array[0..0] of TRA = (
    (RA: $0; PN: 'VarOleStrToString'; CN: ''));
  HCBlock140Val0: array[0..18] of byte = (
    $55, $8B, $EC, $51, $53, $8B, $D8, $33, $C0, $89, $45, $FC, $8B, $42, $08, $8D,
    $55, $FC, $E8);
  HCBlock140Val1: array[0..2] of byte = (
    $8B, $C3, $E8);
  HCBlock140Val2: array[0..14] of byte = (
    $66, $C7, $03, $00, $01, $8B, $45, $FC, $89, $43, $08, $5B, $59, $5D, $C3);
  HCBlock140Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock140Val0); Val: @HCBlock140Val0), 
    (RA: $17; Count: length(HCBlock140Val1); Val: @HCBlock140Val1), 
    (RA: $1E; Count: length(HCBlock140Val2); Val: @HCBlock140Val2));
  HCBlock140: THCBlock = (
    Size: $30;
    RAC: length(HCBlock140RA); RA: @HCBlock140RA;
    ValC: length(HCBlock140Val); Val: @HCBlock140Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock141RA: array[0..0] of TRA = (
    (RA: $0; PN: 'VarStringToOleStr'; CN: ''));
  HCBlock141Val0: array[0..7] of byte = (
    $53, $56, $8B, $D8, $8B, $42, $08, $E8);
  HCBlock141Val1: array[0..4] of byte = (
    $8B, $F0, $8B, $C3, $E8);
  HCBlock141Val2: array[0..10] of byte = (
    $66, $C7, $03, $08, $00, $89, $73, $08, $5E, $5B, $C3);
  HCBlock141Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock141Val0); Val: @HCBlock141Val0),
    (RA: $C; Count: length(HCBlock141Val1); Val: @HCBlock141Val1),
    (RA: $15; Count: length(HCBlock141Val2); Val: @HCBlock141Val2));
  HCBlock141: THCBlock = (
    Size: $20;
    RAC: length(HCBlock141RA); RA: @HCBlock141RA;
    ValC: length(HCBlock141Val); Val: @HCBlock141Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock142RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarCast'; CN: ''));
  HCBlock142Val0: array[0..23] of byte = (
    $55, $8B, $EC, $83, $C4, $EC, $53, $89, $45, $EC, $66, $8B, $02, $8B, $D9, $66, 
    $3B, $D8, $75, $0D, $8B, $45, $EC, $E8);
  HCBlock142Val1: array[0..20] of byte = (
    $E9, $CE, $00, $00, $00, $66, $3D, $00, $01, $75, $59, $66, $83, $FB, $08, $75, 
    $0D, $8B, $45, $EC, $E8);
  HCBlock142Val2: array[0..14] of byte = (
    $E9, $B5, $00, $00, $00, $66, $C7, $45, $F0, $00, $00, $8D, $45, $F0, $E8);
  HCBlock142Val3: array[0..3] of byte = (
    $33, $C0, $55, $68);
  HCBlock142Val4: array[0..14] of byte = (
    $64, $FF, $30, $64, $89, $20, $8D, $55, $F0, $8B, $45, $EC, $8B, $CB, $E8);
  HCBlock142Val5: array[0..8] of byte = (
    $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock142Val6: array[0..3] of byte = (
    $8D, $45, $F0, $E8);
  HCBlock142Val7: array[0..1] of byte = (
    $C3, $E9);
  HCBlock142Val8: array[0..24] of byte = (
    $EB, $F0, $66, $81, $FB, $00, $01, $75, $5E, $66, $3D, $01, $01, $74, $58, $66, 
    $83, $F8, $08, $75, $0A, $8B, $45, $EC, $E8);
  HCBlock142Val9: array[0..15] of byte = (
    $EB, $52, $66, $C7, $45, $F0, $00, $00, $8D, $45, $F0, $66, $B9, $08, $00, $E8);
  HCBlock142Val10: array[0..3] of byte = (
    $33, $C0, $55, $68);
  HCBlock142Val11: array[0..12] of byte = (
    $64, $FF, $30, $64, $89, $20, $8D, $55, $F0, $8B, $45, $EC, $E8);
  HCBlock142Val12: array[0..8] of byte = (
    $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock142Val13: array[0..3] of byte = (
    $8D, $45, $F0, $E8);
  HCBlock142Val14: array[0..1] of byte = (
    $C3, $E9);
  HCBlock142Val15: array[0..7] of byte = (
    $EB, $F0, $8B, $45, $EC, $8B, $CB, $E8);
  HCBlock142Val16: array[0..4] of byte = (
    $5B, $8B, $E5, $5D, $C3);
  HCBlock142Val: array[0..16] of TVal = (
    (RA: $0; Count: length(HCBlock142Val0); Val: @HCBlock142Val0), 
    (RA: $1C; Count: length(HCBlock142Val1); Val: @HCBlock142Val1), 
    (RA: $35; Count: length(HCBlock142Val2); Val: @HCBlock142Val2), 
    (RA: $48; Count: length(HCBlock142Val3); Val: @HCBlock142Val3), 
    (RA: $50; Count: length(HCBlock142Val4); Val: @HCBlock142Val4), 
    (RA: $63; Count: length(HCBlock142Val5); Val: @HCBlock142Val5), 
    (RA: $70; Count: length(HCBlock142Val6); Val: @HCBlock142Val6),
    (RA: $78; Count: length(HCBlock142Val7); Val: @HCBlock142Val7), 
    (RA: $7E; Count: length(HCBlock142Val8); Val: @HCBlock142Val8), 
    (RA: $9B; Count: length(HCBlock142Val9); Val: @HCBlock142Val9), 
    (RA: $AF; Count: length(HCBlock142Val10); Val: @HCBlock142Val10), 
    (RA: $B7; Count: length(HCBlock142Val11); Val: @HCBlock142Val11), 
    (RA: $C8; Count: length(HCBlock142Val12); Val: @HCBlock142Val12), 
    (RA: $D5; Count: length(HCBlock142Val13); Val: @HCBlock142Val13), 
    (RA: $DD; Count: length(HCBlock142Val14); Val: @HCBlock142Val14), 
    (RA: $E3; Count: length(HCBlock142Val15); Val: @HCBlock142Val15), 
    (RA: $EF; Count: length(HCBlock142Val16); Val: @HCBlock142Val16));
  HCBlock142IA: array[0..3] of TIA = (
    (RA: $4C; RRA: $79), 
    (RA: $6C; RRA: $EF), 
    (RA: $B3; RRA: $DE), 
    (RA: $D1; RRA: $EF));
  HCBlock142: THCBlock = (
    Size: $F4;
    RAC: length(HCBlock142RA); RA: @HCBlock142RA;
    ValC: length(HCBlock142Val); Val: @HCBlock142Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock142IA); IA: @HCBlock142IA;
    PRC: 0; PR: nil);

  HCBlock143RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarToLStr'; CN: ''));
  HCBlock143Val0: array[0..10] of byte = (
    $66, $81, $3A, $00, $01, $75, $08, $8B, $52, $08, $E9);
  HCBlock143Val1: array[0..19] of byte = (
    $53, $89, $C3, $83, $EC, $10, $66, $C7, $04, $24, $00, $00, $89, $E0, $B9, $00, 
    $01, $00, $00, $E8);
  HCBlock143Val2: array[0..2] of byte = (
    $89, $D8, $E8);
  HCBlock143Val3: array[0..10] of byte = (
    $8B, $44, $24, $08, $89, $03, $83, $C4, $10, $5B, $C3);
  HCBlock143Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock143Val0); Val: @HCBlock143Val0), 
    (RA: $F; Count: length(HCBlock143Val1); Val: @HCBlock143Val1),
    (RA: $27; Count: length(HCBlock143Val2); Val: @HCBlock143Val2), 
    (RA: $2E; Count: length(HCBlock143Val3); Val: @HCBlock143Val3));
  HCBlock143: THCBlock = (
    Size: $3C;
    RAC: length(HCBlock143RA); RA: @HCBlock143RA;
    ValC: length(HCBlock143Val); Val: @HCBlock143Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock144RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarAddRef'; CN: ''));
  HCBlock144Val0: array[0..24] of byte = (
    $66, $83, $38, $08, $72, $1A, $FF, $70, $0C, $FF, $70, $08, $FF, $70, $04, $FF, 
    $30, $66, $C7, $00, $00, $00, $89, $E2, $E8);
  HCBlock144Val1: array[0..3] of byte = (
    $83, $C4, $10, $C3);
  HCBlock144Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock144Val0); Val: @HCBlock144Val0),
    (RA: $1D; Count: length(HCBlock144Val1); Val: @HCBlock144Val1));
  HCBlock144: THCBlock = (
    Size: $24;
    RAC: length(HCBlock144RA); RA: @HCBlock144RA;
    ValC: length(HCBlock144Val); Val: @HCBlock144Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock145RA: array[0..0] of TRA = (
    (RA: $0; PN: 'RaiseList'; CN: ''));
  HCBlock145Val0: array[0..0] of byte = (
    $E8);
  HCBlock145Val1: array[0..6] of byte = (
    $8B, $80, $00, $00, $00, $00, $C3);
  HCBlock145Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock145Val0); Val: @HCBlock145Val0), 
    (RA: $5; Count: length(HCBlock145Val1); Val: @HCBlock145Val1));
  HCBlock145PR: array[0..0] of TPR = (
    (RA: $1; PN: '@GetTls'; CN: ''));
  HCBlock145: THCBlock = (
    Size: $C;
    RAC: length(HCBlock145RA); RA: @HCBlock145RA;
    ValC: length(HCBlock145Val); Val: @HCBlock145Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock145PR); PR: @HCBlock145PR);

  HCBlock146RA: array[0..0] of TRA = (
    (RA: $0; PN: '@AStrCmp'; CN: ''));
  HCBlock146Val0: array[0..111] of byte = (
    $53, $56, $51, $89, $CE, $C1, $EE, $02, $74, $26, $8B, $08, $8B, $1A, $39, $D9, 
    $75, $45, $4E, $74, $15, $8B, $48, $04, $8B, $5A, $04, $39, $D9, $75, $38, $83, 
    $C0, $08, $83, $C2, $08, $4E, $75, $E2, $EB, $06, $83, $C0, $04, $83, $C2, $04, 
    $5E, $83, $E6, $03, $74, $36, $8A, $08, $3A, $0A, $75, $30, $4E, $74, $13, $8A, 
    $48, $01, $3A, $4A, $01, $75, $25, $4E, $74, $08, $8A, $48, $02, $3A, $4A, $02,
    $75, $1A, $31, $C0, $5E, $5B, $C3, $5E, $38, $D9, $75, $10, $38, $FD, $75, $0C,
    $C1, $E9, $10, $C1, $EB, $10, $38, $D9, $75, $02, $38, $FD, $5E, $5B, $C3, $90);
  HCBlock146Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock146Val0); Val: @HCBlock146Val0));
  HCBlock146: THCBlock = (
    Size: $70;
    RAC: length(HCBlock146RA); RA: @HCBlock146RA;
    ValC: length(HCBlock146Val); Val: @HCBlock146Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock147RA: array[0..0] of TRA = (
    (RA: $0; PN: '@FillChar'; CN: ''));
  HCBlock147Val0: array[0..31] of byte = (
    $57, $89, $C7, $88, $CD, $89, $C8, $C1, $E0, $10, $66, $89, $C8, $89, $D1, $C1, 
    $F9, $02, $78, $09, $F3, $AB, $89, $D1, $83, $E1, $03, $F3, $AA, $5F, $C3, $90);
  HCBlock147Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock147Val0); Val: @HCBlock147Val0));
  HCBlock147: THCBlock = (
    Size: $20;
    RAC: length(HCBlock147RA); RA: @HCBlock147RA;
    ValC: length(HCBlock147Val); Val: @HCBlock147Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock148RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ClassType'; CN: 'TObject'));
  HCBlock148Val0: array[0..2] of byte = (
    $8B, $00, $C3);
  HCBlock148Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock148Val0); Val: @HCBlock148Val0));
  HCBlock148: THCBlock = (
    Size: $4;
    RAC: length(HCBlock148RA); RA: @HCBlock148RA;
    ValC: length(HCBlock148Val); Val: @HCBlock148Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock149RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ClassNameIs'; CN: 'TObject'));
  HCBlock149Val0: array[0..38] of byte = (
    $53, $31, $DB, $09, $D2, $74, $1C, $8B, $40, $D4, $31, $C9, $8A, $08, $3B, $4A,
    $FC, $75, $10, $4A, $8A, $3C, $08, $32, $3C, $0A, $80, $E7, $DF, $75, $04, $49,
    $75, $F2, $43, $88, $D8, $5B, $C3);
  HCBlock149Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock149Val0); Val: @HCBlock149Val0));
  HCBlock149: THCBlock = (
    Size: $28;
    RAC: length(HCBlock149RA); RA: @HCBlock149RA;
    ValC: length(HCBlock149Val); Val: @HCBlock149Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock150RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ClassParent'; CN: 'TObject'));
  HCBlock150Val0: array[0..9] of byte = (
    $8B, $40, $DC, $85, $C0, $74, $02, $8B, $00, $C3);
  HCBlock150Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock150Val0); Val: @HCBlock150Val0));
  HCBlock150: THCBlock = (
    Size: $C;
    RAC: length(HCBlock150RA); RA: @HCBlock150RA;
    ValC: length(HCBlock150Val); Val: @HCBlock150Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock151RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InvokeImplGetter'; CN: ''));
  HCBlock151Val0: array[0..39] of byte = (
    $87, $CA, $81, $F9, $00, $00, $00, $FF, $73, $11, $81, $F9, $00, $00, $00, $FE, 
    $72, $07, $0F, $BF, $C9, $03, $08, $FF, $21, $FF, $E1, $81, $E1, $FF, $FF, $FF, 
    $00, $01, $C1, $89, $D0, $8B, $11, $E9);
  HCBlock151Val1: array[0..0] of byte = (
    $C3);
  HCBlock151Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock151Val0); Val: @HCBlock151Val0), 
    (RA: $2C; Count: length(HCBlock151Val1); Val: @HCBlock151Val1));
  HCBlock151: THCBlock = (
    Size: $30;
    RAC: length(HCBlock151RA); RA: @HCBlock151RA;
    ValC: length(HCBlock151Val); Val: @HCBlock151Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock152RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetInterface'; CN: 'TObject'));
  HCBlock152Val0: array[0..24] of byte = (
    $55, $8B, $EC, $83, $C4, $F8, $53, $56, $57, $33, $DB, $89, $5D, $F8, $8B, $F9,
    $89, $55, $FC, $8B, $F0, $33, $C0, $55, $68);
  HCBlock152Val1: array[0..11] of byte = (
    $64, $FF, $30, $64, $89, $20, $8B, $55, $FC, $8B, $06, $E8);
  HCBlock152Val2: array[0..27] of byte = (
    $8B, $D8, $85, $DB, $74, $3F, $8B, $43, $14, $85, $C0, $74, $06, $03, $F0, $89,
    $37, $EB, $17, $8D, $4D, $F8, $8B, $53, $18, $8B, $C6, $E8);
  HCBlock152Val3: array[0..5] of byte = (
    $8B, $55, $F8, $8B, $C7, $E8);
  HCBlock152Val4: array[0..41] of byte = (
    $83, $3F, $00, $74, $12, $83, $7B, $14, $00, $74, $08, $8B, $07, $50, $8B, $00,
    $FF, $50, $04, $B3, $01, $EB, $0A, $33, $DB, $EB, $06, $33, $C0, $89, $07, $33,
    $DB, $33, $C0, $5A, $59, $59, $64, $89, $10, $68);
  HCBlock152Val5: array[0..3] of byte = (
    $8D, $45, $F8, $E8);
  HCBlock152Val6: array[0..1] of byte = (
    $C3, $E9);
  HCBlock152Val7: array[0..10] of byte = (
    $EB, $F0, $8B, $C3, $5F, $5E, $5B, $59, $59, $5D, $C3);
  HCBlock152Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock152Val0); Val: @HCBlock152Val0),
    (RA: $1D; Count: length(HCBlock152Val1); Val: @HCBlock152Val1),
    (RA: $2D; Count: length(HCBlock152Val2); Val: @HCBlock152Val2),
    (RA: $4D; Count: length(HCBlock152Val3); Val: @HCBlock152Val3),
    (RA: $57; Count: length(HCBlock152Val4); Val: @HCBlock152Val4),
    (RA: $85; Count: length(HCBlock152Val5); Val: @HCBlock152Val5),
    (RA: $8D; Count: length(HCBlock152Val6); Val: @HCBlock152Val6),
    (RA: $93; Count: length(HCBlock152Val7); Val: @HCBlock152Val7));
  HCBlock152IA: array[0..1] of TIA = (
    (RA: $19; RRA: $8E),
    (RA: $81; RRA: $95));
  HCBlock152: THCBlock = (
    Size: $A0;
    RAC: length(HCBlock152RA); RA: @HCBlock152RA;
    ValC: length(HCBlock152Val); Val: @HCBlock152Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock152IA); IA: @HCBlock152IA;
    PRC: 0; PR: nil);

  HCBlock153RA: array[0..0] of TRA = (
    (RA: $0; PN: 'GetInterfaceEntry'; CN: 'TObject'));
  HCBlock153Val0: array[0..67] of byte = (
    $53, $56, $89, $C3, $8B, $43, $B8, $85, $C0, $74, $29, $8B, $08, $83, $C0, $04,
    $8B, $32, $3B, $30, $75, $18, $8B, $72, $04, $3B, $70, $04, $75, $10, $8B, $72,
    $08, $3B, $70, $08, $75, $08, $8B, $72, $0C, $3B, $70, $0C, $74, $13, $83, $C0,
    $1C, $49, $75, $DC, $8B, $5B, $DC, $85, $DB, $74, $04, $8B, $1B, $EB, $C5, $31,
    $C0, $5E, $5B, $C3);
  HCBlock153Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock153Val0); Val: @HCBlock153Val0));
  HCBlock153: THCBlock = (
    Size: $44;
    RAC: length(HCBlock153RA); RA: @HCBlock153RA;
    ValC: length(HCBlock153Val); Val: @HCBlock153Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock154RA: array[0..0] of TRA = (
    (RA: $0; PN: '@CallDynaInst'; CN: ''));
  HCBlock154Val0: array[0..4] of byte = (
    $50, $51, $8B, $00, $E8);
  HCBlock154Val1: array[0..7] of byte = (
    $59, $58, $74, $02, $FF, $E3, $59, $E9);
  HCBlock154Val2: array[0..0] of byte = (
    $C3);
  HCBlock154Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock154Val0); Val: @HCBlock154Val0), 
    (RA: $9; Count: length(HCBlock154Val1); Val: @HCBlock154Val1), 
    (RA: $15; Count: length(HCBlock154Val2); Val: @HCBlock154Val2));
  HCBlock154: THCBlock = (
    Size: $18;
    RAC: length(HCBlock154RA); RA: @HCBlock154RA;
    ValC: length(HCBlock154Val); Val: @HCBlock154Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock155RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ClassInfo'; CN: 'TObject'));
  HCBlock155Val0: array[0..3] of byte = (
    $8B, $40, $C4, $C3);
  HCBlock155Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock155Val0); Val: @HCBlock155Val0));
  HCBlock155: THCBlock = (
    Size: $4;
    RAC: length(HCBlock155RA); RA: @HCBlock155RA;
    ValC: length(HCBlock155Val); Val: @HCBlock155Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock156RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FieldAddress'; CN: 'TObject'));
  HCBlock156Val0: array[0..79] of byte = (
    $53, $56, $57, $31, $C9, $31, $FF, $8A, $1A, $50, $8B, $00, $8B, $70, $C8, $85,
    $F6, $74, $14, $66, $8B, $3E, $83, $C6, $06, $8A, $4E, $06, $38, $D9, $74, $18,
    $8D, $74, $0E, $07, $4F, $75, $F2, $8B, $40, $DC, $85, $C0, $75, $DC, $5A, $EB,
    $1B, $8A, $1A, $8A, $4E, $06, $EB, $E8, $8A, $5C, $0E, $06, $32, $1C, $0A, $80,
    $E3, $DF, $75, $ED, $49, $75, $F1, $8B, $06, $5A, $01, $D0, $5F, $5E, $5B, $C3);
  HCBlock156Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock156Val0); Val: @HCBlock156Val0));
  HCBlock156: THCBlock = (
    Size: $50;
    RAC: length(HCBlock156RA); RA: @HCBlock156RA;
    ValC: length(HCBlock156Val); Val: @HCBlock156Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock157RA: array[0..0] of TRA = (
    (RA: $0; PN: 'NotifyOnExcept'; CN: ''));
  HCBlock157Val0: array[0..1] of byte = (
    $80, $3D);
  HCBlock157Val1: array[0..6] of byte = (
    $76, $09, $50, $FF, $73, $04, $E9);
  HCBlock157Val2: array[0..0] of byte = (
    $C3);
  HCBlock157Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock157Val0); Val: @HCBlock157Val0), 
    (RA: $7; Count: length(HCBlock157Val1); Val: @HCBlock157Val1), 
    (RA: $12; Count: length(HCBlock157Val2); Val: @HCBlock157Val2));
  HCBlock157Vars: array[0..0] of TCVar = (
    (RA: $2; VN: 'DebugHook'));
  HCBlock157: THCBlock = (
    Size: $14;
    RAC: length(HCBlock157RA); RA: @HCBlock157RA;
    ValC: length(HCBlock157Val); Val: @HCBlock157Val;
    VarsC: length(HCBlock157Vars); Vars: @HCBlock157Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock158RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrToString'; CN: ''));
  HCBlock158Val0: array[0..22] of byte = (
    $53, $85, $D2, $74, $18, $8B, $5A, $FC, $85, $DB, $74, $11, $39, $D9, $7C, $02, 
    $89, $D9, $88, $08, $40, $92, $E8);
  HCBlock158Val1: array[0..8] of byte = (
    $5B, $C3, $C6, $00, $00, $5B, $C3, $8B, $C0);
  HCBlock158Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock158Val0); Val: @HCBlock158Val0), 
    (RA: $1B; Count: length(HCBlock158Val1); Val: @HCBlock158Val1));
  HCBlock158: THCBlock = (
    Size: $24;
    RAC: length(HCBlock158RA); RA: @HCBlock158RA;
    ValC: length(HCBlock158Val); Val: @HCBlock158Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock159RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrCmp'; CN: ''));
  HCBlock159Val0: array[0..161] of byte = (
    $53, $56, $57, $89, $C6, $89, $D7, $39, $D0, $0F, $84, $8F, $00, $00, $00, $85, 
    $F6, $74, $68, $85, $FF, $74, $6B, $8B, $46, $FC, $8B, $57, $FC, $29, $D0, $77, 
    $02, $01, $C2, $52, $C1, $EA, $02, $74, $26, $8B, $0E, $8B, $1F, $39, $D9, $75, 
    $58, $4A, $74, $15, $8B, $4E, $04, $8B, $5F, $04, $39, $D9, $75, $4B, $83, $C6, 
    $08, $83, $C7, $08, $4A, $75, $E2, $EB, $06, $83, $C6, $04, $83, $C7, $04, $5A, 
    $83, $E2, $03, $74, $22, $8B, $0E, $8B, $1F, $38, $D9, $75, $41, $4A, $74, $17, 
    $38, $FD, $75, $3A, $4A, $74, $10, $81, $E3, $00, $00, $FF, $00, $81, $E1, $00, 
    $00, $FF, $00, $39, $D9, $75, $27, $01, $C0, $EB, $23, $8B, $57, $FC, $29, $D0, 
    $EB, $1C, $8B, $46, $FC, $29, $D0, $EB, $15, $5A, $38, $D9, $75, $10, $38, $FD, 
    $75, $0C, $C1, $E9, $10, $C1, $EB, $10, $38, $D9, $75, $02, $38, $FD, $5F, $5E, 
    $5B, $C3);
  HCBlock159Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock159Val0); Val: @HCBlock159Val0));
  HCBlock159: THCBlock = (
    Size: $A4;
    RAC: length(HCBlock159RA); RA: @HCBlock159RA;
    ValC: length(HCBlock159Val); Val: @HCBlock159Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock160RA: array[0..0] of TRA = (
    (RA: $0; PN: 'UniqueString'; CN: ''));
  HCBlock160Val0: array[0..18] of byte = (
    $8B, $10, $85, $D2, $74, $2B, $8B, $4A, $F8, $49, $74, $25, $53, $89, $C3, $8B, 
    $42, $FC, $E8);
  HCBlock160Val1: array[0..18] of byte = (
    $89, $C2, $8B, $03, $89, $13, $8B, $48, $F8, $49, $7C, $03, $89, $48, $F8, $8B, 
    $48, $FC, $E8);
  HCBlock160Val2: array[0..5] of byte = (
    $8B, $13, $5B, $89, $D0, $C3);
  HCBlock160Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock160Val0); Val: @HCBlock160Val0), 
    (RA: $17; Count: length(HCBlock160Val1); Val: @HCBlock160Val1), 
    (RA: $2E; Count: length(HCBlock160Val2); Val: @HCBlock160Val2));
  HCBlock160: THCBlock = (
    Size: $34;
    RAC: length(HCBlock160RA); RA: @HCBlock160RA;
    ValC: length(HCBlock160Val); Val: @HCBlock160Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock161RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrPos'; CN: ''));
  HCBlock161Val0: array[0..71] of byte = (
    $85, $C0, $74, $40, $85, $D2, $74, $31, $53, $56, $57, $89, $C6, $89, $D7, $8B, 
    $4F, $FC, $57, $8B, $56, $FC, $4A, $78, $1B, $8A, $06, $46, $29, $D1, $7E, $14, 
    $F2, $AE, $75, $10, $89, $CB, $56, $57, $89, $D1, $F3, $A6, $5F, $5E, $74, $0C, 
    $89, $D9, $EB, $EC, $5A, $31, $C0, $EB, $08, $31, $C0, $C3, $5A, $89, $F8, $29, 
    $D0, $5F, $5E, $5B, $C3, $8D, $40, $00);
  HCBlock161Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock161Val0); Val: @HCBlock161Val0));
  HCBlock161: THCBlock = (
    Size: $48;
    RAC: length(HCBlock161RA); RA: @HCBlock161RA;
    ValC: length(HCBlock161Val); Val: @HCBlock161Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock162RA: array[0..0] of TRA = (
    (RA: $0; PN: 'WStrError'; CN: ''));
  HCBlock162Val0: array[0..2] of byte = (
    $B0, $01, $E9);
  HCBlock162Val1: array[0..0] of byte = (
    $C3);
  HCBlock162Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock162Val0); Val: @HCBlock162Val0), 
    (RA: $7; Count: length(HCBlock162Val1); Val: @HCBlock162Val1));
  HCBlock162PR: array[0..0] of TPR = (
    (RA: $3; PN: 'Error'; CN: ''));
  HCBlock162: THCBlock = (
    Size: $8;
    RAC: length(HCBlock162RA); RA: @HCBlock162RA;
    ValC: length(HCBlock162Val); Val: @HCBlock162Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock162PR); PR: @HCBlock162PR);

  HCBlock163RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrAsg'; CN: ''));
  HCBlock163Val0: array[0..3] of byte = (
    $85, $D2, $0F, $84);
  HCBlock163Val1: array[0..6] of byte = (
    $8B, $4A, $FC, $D1, $E9, $0F, $84);
  HCBlock163Val2: array[0..3] of byte = (
    $51, $52, $50, $E8);
  HCBlock163Val3: array[0..3] of byte = (
    $85, $C0, $0F, $84);
  HCBlock163Val4: array[0..0] of byte = (
    $C3);
  HCBlock163Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock163Val0); Val: @HCBlock163Val0), 
    (RA: $8; Count: length(HCBlock163Val1); Val: @HCBlock163Val1), 
    (RA: $13; Count: length(HCBlock163Val2); Val: @HCBlock163Val2), 
    (RA: $1B; Count: length(HCBlock163Val3); Val: @HCBlock163Val3), 
    (RA: $23; Count: length(HCBlock163Val4); Val: @HCBlock163Val4));
  HCBlock163: THCBlock = (
    Size: $24;
    RAC: length(HCBlock163RA); RA: @HCBlock163RA;
    ValC: length(HCBlock163Val); Val: @HCBlock163Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock164RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrFromPCharLen'; CN: ''));
  HCBlock164Val0: array[0..22] of byte = (
    $53, $56, $57, $55, $81, $C4, $00, $F8, $FF, $FF, $8B, $D9, $8B, $EA, $8B, $F8, 
    $85, $DB, $7F, $09, $8B, $C7, $E8);
  HCBlock164Val1: array[0..26] of byte = (
    $EB, $5B, $81, $FB, $00, $04, $00, $00, $7D, $28, $68, $00, $04, $00, $00, $8D, 
    $44, $24, $04, $50, $53, $55, $6A, $00, $6A, $00, $E8);
  HCBlock164Val2: array[0..12] of byte = (
    $8B, $F0, $85, $F6, $7E, $0D, $8B, $D4, $8B, $C7, $8B, $CE, $E8);
  HCBlock164Val3: array[0..12] of byte = (
    $EB, $2B, $6A, $00, $6A, $00, $53, $55, $6A, $00, $6A, $00, $E8);
  HCBlock164Val4: array[0..8] of byte = (
    $8B, $F0, $8B, $C7, $8B, $CE, $33, $D2, $E8);
  HCBlock164Val5: array[0..10] of byte = (
    $56, $8B, $07, $50, $53, $55, $6A, $00, $6A, $00, $E8);
  HCBlock164Val6: array[0..10] of byte = (
    $81, $C4, $00, $08, $00, $00, $5D, $5F, $5E, $5B, $C3);
  HCBlock164Val: array[0..6] of TVal = (
    (RA: $0; Count: length(HCBlock164Val0); Val: @HCBlock164Val0), 
    (RA: $1B; Count: length(HCBlock164Val1); Val: @HCBlock164Val1), 
    (RA: $3A; Count: length(HCBlock164Val2); Val: @HCBlock164Val2), 
    (RA: $4B; Count: length(HCBlock164Val3); Val: @HCBlock164Val3), 
    (RA: $5C; Count: length(HCBlock164Val4); Val: @HCBlock164Val4), 
    (RA: $69; Count: length(HCBlock164Val5); Val: @HCBlock164Val5), 
    (RA: $78; Count: length(HCBlock164Val6); Val: @HCBlock164Val6));
  HCBlock164: THCBlock = (
    Size: $84;
    RAC: length(HCBlock164RA); RA: @HCBlock164RA;
    ValC: length(HCBlock164Val); Val: @HCBlock164Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock165RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrFromPWCharLen'; CN: ''));
  HCBlock165Val0: array[0..3] of byte = (
    $85, $C9, $0F, $84);
  HCBlock165Val1: array[0..3] of byte = (
    $50, $51, $52, $E8);
  HCBlock165Val2: array[0..3] of byte = (
    $85, $C0, $0F, $84);
  HCBlock165Val3: array[0..5] of byte = (
    $5A, $FF, $32, $89, $02, $E8);
  HCBlock165Val4: array[0..0] of byte = (
    $C3);
  HCBlock165Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock165Val0); Val: @HCBlock165Val0), 
    (RA: $8; Count: length(HCBlock165Val1); Val: @HCBlock165Val1), 
    (RA: $10; Count: length(HCBlock165Val2); Val: @HCBlock165Val2), 
    (RA: $18; Count: length(HCBlock165Val3); Val: @HCBlock165Val3), 
    (RA: $22; Count: length(HCBlock165Val4); Val: @HCBlock165Val4));
  HCBlock165: THCBlock = (
    Size: $24;
    RAC: length(HCBlock165RA); RA: @HCBlock165RA;
    ValC: length(HCBlock165Val); Val: @HCBlock165Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock166RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrFromLStr'; CN: ''));
  HCBlock166Val0: array[0..9] of byte = (
    $31, $C9, $85, $D2, $74, $03, $8B, $4A, $FC, $E9);
  HCBlock166Val1: array[0..0] of byte = (
    $C3);
  HCBlock166Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock166Val0); Val: @HCBlock166Val0), 
    (RA: $E; Count: length(HCBlock166Val1); Val: @HCBlock166Val1));
  HCBlock166: THCBlock = (
    Size: $10;
    RAC: length(HCBlock166RA); RA: @HCBlock166RA;
    ValC: length(HCBlock166Val); Val: @HCBlock166Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock167RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrLen'; CN: ''));
  HCBlock167Val0: array[0..9] of byte = (
    $85, $C0, $74, $05, $8B, $40, $FC, $D1, $E8, $C3);
  HCBlock167Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock167Val0); Val: @HCBlock167Val0));
  HCBlock167: THCBlock = (
    Size: $C;
    RAC: length(HCBlock167RA); RA: @HCBlock167RA;
    ValC: length(HCBlock167Val); Val: @HCBlock167Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock168RA: array[0..0] of TRA = (
    (RA: $0; PN: '@NewWideString'; CN: ''));
  HCBlock168Val0: array[0..7] of byte = (
    $85, $C0, $74, $10, $50, $6A, $00, $E8);
  HCBlock168Val1: array[0..3] of byte = (
    $85, $C0, $0F, $84);
  HCBlock168Val2: array[0..0] of byte = (
    $C3);
  HCBlock168Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock168Val0); Val: @HCBlock168Val0), 
    (RA: $C; Count: length(HCBlock168Val1); Val: @HCBlock168Val1), 
    (RA: $14; Count: length(HCBlock168Val2); Val: @HCBlock168Val2));
  HCBlock168: THCBlock = (
    Size: $18;
    RAC: length(HCBlock168RA); RA: @HCBlock168RA;
    ValC: length(HCBlock168Val); Val: @HCBlock168Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock169RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrSetLength'; CN: ''));
  HCBlock169Val0: array[0..15] of byte = (
    $53, $56, $57, $8B, $F2, $8B, $F8, $33, $DB, $85, $F6, $7E, $27, $8B, $C6, $E8);
  HCBlock169Val1: array[0..4] of byte = (
    $8B, $D8, $8B, $07, $E8);
  HCBlock169Val2: array[0..18] of byte = (
    $85, $C0, $7E, $13, $3B, $F0, $7D, $02, $8B, $C6, $8B, $C8, $03, $C9, $8B, $D3, 
    $8B, $07, $E8);
  HCBlock169Val3: array[0..4] of byte = (
    $8B, $C7, $8B, $D3, $E8);
  HCBlock169Val4: array[0..3] of byte = (
    $5F, $5E, $5B, $C3);
  HCBlock169Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock169Val0); Val: @HCBlock169Val0),
    (RA: $14; Count: length(HCBlock169Val1); Val: @HCBlock169Val1),
    (RA: $1D; Count: length(HCBlock169Val2); Val: @HCBlock169Val2),
    (RA: $34; Count: length(HCBlock169Val3); Val: @HCBlock169Val3),
    (RA: $3D; Count: length(HCBlock169Val4); Val: @HCBlock169Val4));
  HCBlock169: THCBlock = (
    Size: $44;
    RAC: length(HCBlock169RA); RA: @HCBlock169RA;
    ValC: length(HCBlock169Val); Val: @HCBlock169Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock170RA: array[0..0] of TRA = (
    (RA: $0; PN: '@CopyRecord'; CN: ''));
  HCBlock170Val0: array[0..39] of byte = (
    $53, $56, $57, $55, $89, $C3, $89, $D6, $31, $C0, $8A, $41, $01, $8D, $7C, $01, 
    $0A, $8B, $6F, $FC, $31, $C0, $8B, $4F, $F8, $51, $8B, $4F, $04, $29, $C1, $7E, 
    $0B, $89, $C2, $01, $F0, $01, $DA, $E8);
  HCBlock170Val1: array[0..58] of byte = (
    $8B, $47, $04, $8B, $17, $8B, $12, $8A, $0A, $80, $F9, $0A, $74, $31, $80, $F9, 
    $0B, $74, $3D, $80, $F9, $0C, $74, $49, $80, $F9, $0D, $74, $55, $80, $F9, $0E, 
    $74, $70, $80, $F9, $0F, $0F, $84, $80, $00, $00, $00, $80, $F9, $11, $0F, $84, 
    $88, $00, $00, $00, $B0, $02, $5D, $5F, $5E, $5B, $E9);
  HCBlock170Val2: array[0..5] of byte = (
    $8B, $14, $06, $01, $D8, $E8);
  HCBlock170Val3: array[0..12] of byte = (
    $B8, $04, $00, $00, $00, $EB, $7D, $8B, $14, $06, $01, $D8, $E8);
  HCBlock170Val4: array[0..12] of byte = (
    $B8, $04, $00, $00, $00, $EB, $6C, $8D, $14, $06, $01, $D8, $E8);
  HCBlock170Val5: array[0..31] of byte = (
    $B8, $10, $00, $00, $00, $EB, $5B, $31, $C9, $8A, $4A, $01, $FF, $74, $0A, $02, 
    $FF, $74, $0A, $06, $8B, $4C, $0A, $0A, $8B, $09, $8D, $14, $06, $01, $D8, $E8);
  HCBlock170Val6: array[0..33] of byte = (
    $58, $EB, $3B, $31, $C9, $8A, $4A, $01, $8B, $4C, $0A, $02, $51, $89, $D1, $8D, 
    $14, $06, $01, $D8, $E8, $2C, $FF, $FF, $FF, $58, $EB, $22, $8B, $14, $06, $01, 
    $D8, $E8);
  HCBlock170Val7: array[0..14] of byte = (
    $B8, $04, $00, $00, $00, $EB, $11, $89, $D1, $8B, $14, $06, $01, $D8, $E8);
  HCBlock170Val8: array[0..28] of byte = (
    $B8, $04, $00, $00, $00, $03, $47, $04, $83, $C7, $08, $4D, $0F, $85, $14, $FF, 
    $FF, $FF, $59, $29, $C1, $7E, $0A, $8D, $14, $03, $01, $F0, $E8);
  HCBlock170Val9: array[0..4] of byte = (
    $5D, $5F, $5E, $5B, $C3);
  HCBlock170Val: array[0..9] of TVal = (
    (RA: $0; Count: length(HCBlock170Val0); Val: @HCBlock170Val0), 
    (RA: $2C; Count: length(HCBlock170Val1); Val: @HCBlock170Val1), 
    (RA: $6B; Count: length(HCBlock170Val2); Val: @HCBlock170Val2), 
    (RA: $75; Count: length(HCBlock170Val3); Val: @HCBlock170Val3), 
    (RA: $86; Count: length(HCBlock170Val4); Val: @HCBlock170Val4), 
    (RA: $97; Count: length(HCBlock170Val5); Val: @HCBlock170Val5), 
    (RA: $BB; Count: length(HCBlock170Val6); Val: @HCBlock170Val6), 
    (RA: $E1; Count: length(HCBlock170Val7); Val: @HCBlock170Val7), 
    (RA: $F4; Count: length(HCBlock170Val8); Val: @HCBlock170Val8), 
    (RA: $115; Count: length(HCBlock170Val9); Val: @HCBlock170Val9));
  HCBlock170: THCBlock = (
    Size: $11C;
    RAC: length(HCBlock170RA); RA: @HCBlock170RA;
    ValC: length(HCBlock170Val); Val: @HCBlock170Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock171RA: array[0..0] of TRA = (
    (RA: $0; PN: '@CopyArray'; CN: ''));
  HCBlock171Val0: array[0..65] of byte = (
    $53, $56, $57, $55, $89, $C3, $89, $D6, $89, $CF, $8B, $6C, $24, $14, $8A, $0F, 
    $80, $F9, $0A, $74, $31, $80, $F9, $0B, $74, $43, $80, $F9, $0C, $74, $52, $80, 
    $F9, $0D, $74, $61, $80, $F9, $0E, $74, $7D, $80, $F9, $0F, $0F, $84, $91, $00, 
    $00, $00, $80, $F9, $11, $0F, $84, $9C, $00, $00, $00, $B0, $02, $5D, $5F, $5E, 
    $5B, $E9);
  HCBlock171Val1: array[0..4] of byte = (
    $89, $D8, $8B, $16, $E8);
  HCBlock171Val2: array[0..18] of byte = (
    $83, $C3, $04, $83, $C6, $04, $4D, $75, $EE, $E9, $8E, $00, $00, $00, $89, $D8, 
    $8B, $16, $E8);
  HCBlock171Val3: array[0..15] of byte = (
    $83, $C3, $04, $83, $C6, $04, $4D, $75, $EE, $EB, $7A, $89, $D8, $89, $F2, $E8);
  HCBlock171Val4: array[0..50] of byte = (
    $83, $C3, $10, $83, $C6, $10, $4D, $75, $EE, $EB, $66, $31, $C9, $8A, $4F, $01, 
    $8D, $7C, $0F, $02, $89, $D8, $89, $F2, $8B, $4F, $08, $FF, $77, $04, $E8, $63, 
    $FF, $FF, $FF, $03, $1F, $03, $37, $4D, $75, $EA, $EB, $45, $89, $D8, $89, $F2, 
    $89, $F9, $E8);
  HCBlock171Val5: array[0..22] of byte = (
    $31, $C0, $8A, $47, $01, $03, $5C, $07, $02, $03, $74, $07, $02, $4D, $75, $E5, 
    $EB, $28, $89, $D8, $8B, $16, $E8);
  HCBlock171Val6: array[0..17] of byte = (
    $83, $C3, $04, $83, $C6, $04, $4D, $75, $EE, $EB, $14, $89, $D8, $8B, $16, $89, 
    $F9, $E8);
  HCBlock171Val7: array[0..16] of byte = (
    $83, $C3, $04, $83, $C6, $04, $4D, $75, $EC, $5D, $5F, $5E, $5B, $C2, $04, $00, 
    $C3);
  HCBlock171Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock171Val0); Val: @HCBlock171Val0), 
    (RA: $46; Count: length(HCBlock171Val1); Val: @HCBlock171Val1), 
    (RA: $4F; Count: length(HCBlock171Val2); Val: @HCBlock171Val2), 
    (RA: $66; Count: length(HCBlock171Val3); Val: @HCBlock171Val3), 
    (RA: $7A; Count: length(HCBlock171Val4); Val: @HCBlock171Val4), 
    (RA: $B1; Count: length(HCBlock171Val5); Val: @HCBlock171Val5), 
    (RA: $CC; Count: length(HCBlock171Val6); Val: @HCBlock171Val6), 
    (RA: $E2; Count: length(HCBlock171Val7); Val: @HCBlock171Val7));
  HCBlock171: THCBlock = (
    Size: $F4;
    RAC: length(HCBlock171RA); RA: @HCBlock171RA;
    ValC: length(HCBlock171Val); Val: @HCBlock171Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock172RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarFromLStr'; CN: ''));
  HCBlock172Val0: array[0..8] of byte = (
    $66, $83, $38, $08, $72, $09, $50, $52, $E8);
  HCBlock172Val1: array[0..22] of byte = (
    $5A, $58, $85, $D2, $74, $23, $8B, $4A, $F8, $41, $7E, $05, $89, $4A, $F8, $EB,
    $18, $50, $52, $8B, $42, $FC, $E8);
  HCBlock172Val2: array[0..7] of byte = (
    $89, $C2, $58, $52, $8B, $4A, $FC, $E8);
  HCBlock172Val3: array[0..10] of byte = (
    $5A, $58, $66, $C7, $00, $00, $01, $89, $50, $08, $C3);
  HCBlock172Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock172Val0); Val: @HCBlock172Val0), 
    (RA: $D; Count: length(HCBlock172Val1); Val: @HCBlock172Val1), 
    (RA: $28; Count: length(HCBlock172Val2); Val: @HCBlock172Val2), 
    (RA: $34; Count: length(HCBlock172Val3); Val: @HCBlock172Val3));
  HCBlock172: THCBlock = (
    Size: $40;
    RAC: length(HCBlock172RA); RA: @HCBlock172RA;
    ValC: length(HCBlock172Val); Val: @HCBlock172Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock173RA: array[0..0] of TRA = (
    (RA: $0; PN: '@VarFromWStr'; CN: ''));
  HCBlock173Val0: array[0..8] of byte = (
    $50, $66, $83, $38, $08, $72, $07, $52, $E8);
  HCBlock173Val1: array[0..16] of byte = (
    $5A, $31, $C0, $85, $D2, $74, $16, $8B, $42, $FC, $D1, $E8, $74, $0F, $50, $52, 
    $E8);
  HCBlock173Val2: array[0..3] of byte = (
    $85, $C0, $0F, $84);
  HCBlock173Val3: array[0..9] of byte = (
    $5A, $66, $C7, $02, $08, $00, $89, $42, $08, $C3);
  HCBlock173Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock173Val0); Val: @HCBlock173Val0), 
    (RA: $D; Count: length(HCBlock173Val1); Val: @HCBlock173Val1), 
    (RA: $22; Count: length(HCBlock173Val2); Val: @HCBlock173Val2), 
    (RA: $2A; Count: length(HCBlock173Val3); Val: @HCBlock173Val3));
  HCBlock173: THCBlock = (
    Size: $34;
    RAC: length(HCBlock173RA); RA: @HCBlock173RA;
    ValC: length(HCBlock173Val); Val: @HCBlock173Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock174RA: array[0..0] of TRA = (
    (RA: $0; PN: '@DynArrayLength'; CN: ''));
  HCBlock174Val0: array[0..7] of byte = (
    $85, $C0, $74, $03, $8B, $40, $FC, $C3);
  HCBlock174Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock174Val0); Val: @HCBlock174Val0));
  HCBlock174: THCBlock = (
    Size: $8;
    RAC: length(HCBlock174RA); RA: @HCBlock174RA;
    ValC: length(HCBlock174Val); Val: @HCBlock174Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock175RA: array[0..0] of TRA = (
    (RA: $0; PN: '@DynArrayHigh'; CN: ''));
  HCBlock175Val0: array[0..0] of byte = (
    $E8);
  HCBlock175Val1: array[0..1] of byte = (
    $48, $C3);
  HCBlock175Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock175Val0); Val: @HCBlock175Val0), 
    (RA: $5; Count: length(HCBlock175Val1); Val: @HCBlock175Val1));
  HCBlock175: THCBlock = (
    Size: $8;
    RAC: length(HCBlock175RA); RA: @HCBlock175RA;
    ValC: length(HCBlock175Val); Val: @HCBlock175Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock176RA: array[0..0] of TRA = (
    (RA: $0; PN: 'CopyArray'; CN: ''));
  HCBlock176Val0: array[0..6] of byte = (
    $55, $8B, $EC, $FF, $75, $08, $E8);
  HCBlock176Val1: array[0..8] of byte = (
    $5D, $C2, $04, $00, $90, $E9, $77, $F7, $FF);
  HCBlock176Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock176Val0); Val: @HCBlock176Val0), 
    (RA: $B; Count: length(HCBlock176Val1); Val: @HCBlock176Val1));
  HCBlock176: THCBlock = (
    Size: $10;
    RAC: length(HCBlock176RA); RA: @HCBlock176RA;
    ValC: length(HCBlock176Val); Val: @HCBlock176Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock177RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FinalizeArray'; CN: ''));
  HCBlock177Val0: array[0..0] of byte = (
    $E9);
  HCBlock177Val1: array[0..0] of byte = (
    $C3);
  HCBlock177Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock177Val0); Val: @HCBlock177Val0), 
    (RA: $5; Count: length(HCBlock177Val1); Val: @HCBlock177Val1));
  HCBlock177PR: array[0..0] of TPR = (
    (RA: $1; PN: '@FinalizeArray'; CN: ''));
  HCBlock177: THCBlock = (
    Size: $8;
    RAC: length(HCBlock177RA); RA: @HCBlock177RA;
    ValC: length(HCBlock177Val); Val: @HCBlock177Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock177PR); PR: @HCBlock177PR);

  HCBlock178RA: array[0..0] of TRA = (
    (RA: $0; PN: 'DynArrayClear'; CN: ''));
  HCBlock178Val0: array[0..0] of byte = (
    $E8);
  HCBlock178Val1: array[0..0] of byte = (
    $C3);
  HCBlock178Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock178Val0); Val: @HCBlock178Val0), 
    (RA: $5; Count: length(HCBlock178Val1); Val: @HCBlock178Val1));
  HCBlock178PR: array[0..0] of TPR = (
    (RA: $1; PN: '@DynArrayClear'; CN: ''));
  HCBlock178: THCBlock = (
    Size: $8;
    RAC: length(HCBlock178RA); RA: @HCBlock178RA;
    ValC: length(HCBlock178Val); Val: @HCBlock178Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock178PR); PR: @HCBlock178PR);

  HCBlock179RA: array[0..0] of TRA = (
    (RA: $0; PN: 'DynArraySetLength'; CN: ''));
  HCBlock179Val0: array[0..37] of byte = (
    $55, $8B, $EC, $83, $C4, $E0, $53, $56, $57, $89, $4D, $F8, $8B, $F2, $89, $45, 
    $FC, $8B, $5D, $FC, $8B, $1B, $8B, $45, $08, $8B, $38, $85, $FF, $7F, $1A, $85, 
    $FF, $7D, $07, $B0, $04, $E8);
  HCBlock179Val1: array[0..5] of byte = (
    $8B, $45, $FC, $8B, $D6, $E8);
  HCBlock179Val2: array[0..72] of byte = (
    $E9, $48, $01, $00, $00, $33, $C0, $89, $45, $F0, $85, $DB, $74, $0B, $83, $EB, 
    $04, $8B, $03, $89, $45, $F0, $83, $EB, $04, $33, $C0, $8A, $46, $01, $01, $C6, 
    $8B, $46, $02, $89, $45, $E8, $8B, $46, $06, $85, $C0, $74, $04, $8B, $30, $EB, 
    $02, $33, $F6, $8B, $C7, $F7, $6D, $E8, $89, $45, $E4, $8B, $45, $E4, $99, $F7, 
    $FF, $3B, $45, $E8, $74, $07, $B0, $04, $E8);
  HCBlock179Val3: array[0..45] of byte = (
    $83, $45, $E4, $08, $85, $DB, $74, $05, $83, $3B, $01, $75, $35, $89, $5D, $E0, 
    $3B, $7D, $F0, $7D, $1D, $85, $F6, $74, $19, $8B, $C3, $83, $C0, $08, $8B, $D7, 
    $0F, $AF, $55, $E8, $03, $C2, $8B, $4D, $F0, $2B, $CF, $8B, $D6, $E8);
  HCBlock179Val4: array[0..6] of byte = (
    $8D, $45, $E0, $8B, $55, $E4, $E8);
  HCBlock179Val5: array[0..10] of byte = (
    $8B, $5D, $E0, $EB, $5E, $FF, $0B, $8B, $45, $E4, $E8);
  HCBlock179Val6: array[0..34] of byte = (
    $8B, $D8, $8B, $45, $F0, $89, $45, $EC, $3B, $7D, $EC, $7D, $03, $89, $7D, $EC, 
    $85, $F6, $74, $2A, $8B, $55, $EC, $0F, $AF, $55, $E8, $8B, $C3, $83, $C0, $08, 
    $33, $C9, $E8);
  HCBlock179Val7: array[0..16] of byte = (
    $8B, $45, $EC, $50, $8B, $55, $FC, $8B, $12, $8B, $C3, $83, $C0, $08, $8B, $CE,
    $E8);
  HCBlock179Val8: array[0..19] of byte = (
    $EB, $16, $8B, $4D, $EC, $0F, $AF, $4D, $E8, $8B, $D3, $83, $C2, $08, $8B, $45, 
    $FC, $8B, $00, $E8);
  HCBlock179Val9: array[0..34] of byte = (
    $C7, $03, $01, $00, $00, $00, $83, $C3, $04, $89, $3B, $83, $C3, $04, $8B, $D7, 
    $2B, $55, $F0, $0F, $AF, $55, $E8, $8B, $45, $E8, $0F, $AF, $45, $F0, $03, $C3, 
    $33, $C9, $E8);
  HCBlock179Val10: array[0..70] of byte = (
    $83, $7D, $F8, $01, $7E, $2E, $83, $45, $08, $04, $FF, $4D, $F8, $4F, $85, $FF, 
    $7C, $22, $47, $C7, $45, $F4, $00, $00, $00, $00, $8B, $45, $08, $50, $8B, $45, 
    $F4, $8D, $04, $83, $8B, $4D, $F8, $8B, $D6, $E8, $8A, $FE, $FF, $FF, $FF, $45, 
    $F4, $4F, $75, $E6, $8B, $45, $FC, $89, $18, $5F, $5E, $5B, $8B, $E5, $5D, $C2, 
    $04, $00, $8B, $C0, $54, $83, $04);
  HCBlock179Val: array[0..10] of TVal = (
    (RA: $0; Count: length(HCBlock179Val0); Val: @HCBlock179Val0), 
    (RA: $2A; Count: length(HCBlock179Val1); Val: @HCBlock179Val1), 
    (RA: $34; Count: length(HCBlock179Val2); Val: @HCBlock179Val2), 
    (RA: $81; Count: length(HCBlock179Val3); Val: @HCBlock179Val3), 
    (RA: $B3; Count: length(HCBlock179Val4); Val: @HCBlock179Val4), 
    (RA: $BE; Count: length(HCBlock179Val5); Val: @HCBlock179Val5), 
    (RA: $CD; Count: length(HCBlock179Val6); Val: @HCBlock179Val6), 
    (RA: $F4; Count: length(HCBlock179Val7); Val: @HCBlock179Val7), 
    (RA: $109; Count: length(HCBlock179Val8); Val: @HCBlock179Val8), 
    (RA: $121; Count: length(HCBlock179Val9); Val: @HCBlock179Val9), 
    (RA: $148; Count: length(HCBlock179Val10); Val: @HCBlock179Val10));
  HCBlock179: THCBlock = (
    Size: $18C;
    RAC: length(HCBlock179RA); RA: @HCBlock179RA;
    ValC: length(HCBlock179Val); Val: @HCBlock179Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock180RA: array[0..0] of TRA = (
    (RA: $0; PN: '@DynArraySetLength'; CN: ''));
  HCBlock180Val0: array[0..5] of byte = (
    $54, $83, $04, $24, $04, $E8);
  HCBlock180Val1: array[0..0] of byte = (
    $C3);
  HCBlock180Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock180Val0); Val: @HCBlock180Val0), 
    (RA: $A; Count: length(HCBlock180Val1); Val: @HCBlock180Val1));
  HCBlock180PR: array[0..0] of TPR = (
    (RA: $6; PN: 'DynArraySetLength'; CN: ''));
  HCBlock180: THCBlock = (
    Size: $C;
    RAC: length(HCBlock180RA); RA: @HCBlock180RA;
    ValC: length(HCBlock180Val); Val: @HCBlock180Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock180PR); PR: @HCBlock180PR);

  HCBlock181RA: array[0..0] of TRA = (
    (RA: $0; PN: '@DynArrayAsg'; CN: ''));
  HCBlock181Val0: array[0..26] of byte = (
    $53, $8B, $18, $85, $D2, $74, $03, $FF, $42, $F8, $85, $DB, $74, $13, $FF, $4B, 
    $F8, $75, $0E, $50, $52, $89, $CA, $FF, $43, $F8, $E8);
  HCBlock181Val1: array[0..5] of byte = (
    $5A, $58, $89, $10, $5B, $C3);
  HCBlock181Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock181Val0); Val: @HCBlock181Val0), 
    (RA: $1F; Count: length(HCBlock181Val1); Val: @HCBlock181Val1));
  HCBlock181: THCBlock = (
    Size: $28;
    RAC: length(HCBlock181RA); RA: @HCBlock181RA;
    ValC: length(HCBlock181Val); Val: @HCBlock181Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock182RA: array[0..0] of TRA = (
    (RA: $0; PN: 'AddModuleUnloadProc'; CN: ''));
  HCBlock182Val0: array[0..8] of byte = (
    $53, $8B, $D8, $B8, $08, $00, $00, $00, $E8);
  HCBlock182Val1: array[0..1] of byte = (
    $8B, $15);
  HCBlock182Val2: array[0..5] of byte = (
    $89, $10, $89, $58, $04, $A3);
  HCBlock182Val3: array[0..1] of byte = (
    $5B, $C3);
  HCBlock182Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock182Val0); Val: @HCBlock182Val0), 
    (RA: $D; Count: length(HCBlock182Val1); Val: @HCBlock182Val1), 
    (RA: $13; Count: length(HCBlock182Val2); Val: @HCBlock182Val2), 
    (RA: $1D; Count: length(HCBlock182Val3); Val: @HCBlock182Val3));
  HCBlock182Vars: array[0..0] of TCVar = (
    (RA: $F; VN: 'ModuleUnloadList'));
  HCBlock182: THCBlock = (
    Size: $20;
    RAC: length(HCBlock182RA); RA: @HCBlock182RA;
    ValC: length(HCBlock182Val); Val: @HCBlock182Val;
    VarsC: length(HCBlock182Vars); Vars: @HCBlock182Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock183RA: array[0..0] of TRA = (
    (RA: $0; PN: 'RemoveModuleUnloadProc'; CN: ''));
  HCBlock183Val0: array[0..3] of byte = (
    $53, $56, $8B, $35);
  HCBlock183Val1: array[0..11] of byte = (
    $85, $F6, $74, $22, $8B, $56, $04, $3B, $D0, $75, $1B, $A1);
  HCBlock183Val2: array[0..2] of byte = (
    $8B, $00, $A3);
  HCBlock183Val3: array[0..7] of byte = (
    $BA, $08, $00, $00, $00, $8B, $C6, $E8);
  HCBlock183Val4: array[0..35] of byte = (
    $5E, $5B, $C3, $8B, $D6, $85, $D2, $74, $27, $8B, $0A, $85, $C9, $74, $1B, $8B, 
    $59, $04, $3B, $D8, $75, $14, $8B, $F1, $8B, $01, $89, $02, $BA, $08, $00, $00, 
    $00, $8B, $C6, $E8);
  HCBlock183Val5: array[0..12] of byte = (
    $EB, $06, $8B, $12, $85, $D2, $75, $D9, $5E, $5B, $C3, $8B, $C0);
  HCBlock183Val: array[0..5] of TVal = (
    (RA: $0; Count: length(HCBlock183Val0); Val: @HCBlock183Val0), 
    (RA: $8; Count: length(HCBlock183Val1); Val: @HCBlock183Val1), 
    (RA: $18; Count: length(HCBlock183Val2); Val: @HCBlock183Val2), 
    (RA: $1F; Count: length(HCBlock183Val3); Val: @HCBlock183Val3), 
    (RA: $2B; Count: length(HCBlock183Val4); Val: @HCBlock183Val4), 
    (RA: $53; Count: length(HCBlock183Val5); Val: @HCBlock183Val5));
  HCBlock183Vars: array[0..0] of TCVar = (
    (RA: $4; VN: 'ModuleUnloadList'));
  HCBlock183: THCBlock = (
    Size: $60;
    RAC: length(HCBlock183RA); RA: @HCBlock183RA;
    ValC: length(HCBlock183Val); Val: @HCBlock183Val;
    VarsC: length(HCBlock183Vars); Vars: @HCBlock183Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock184RA: array[0..0] of TRA = (
    (RA: $0; PN: '@IntfCopy'; CN: ''));
  HCBlock184Val0: array[0..26] of byte = (
    $8B, $08, $89, $10, $85, $D2, $74, $08, $51, $52, $8B, $02, $FF, $50, $04, $59,
    $85, $C9, $74, $06, $51, $8B, $01, $FF, $50, $08, $C3);
  HCBlock184Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock184Val0); Val: @HCBlock184Val0));
  HCBlock184: THCBlock = (
    Size: $1C;
    RAC: length(HCBlock184RA); RA: @HCBlock184RA;
    ValC: length(HCBlock184Val); Val: @HCBlock184Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock185RA: array[0..0] of TRA = (
    (RA: $0; PN: 'InitThreadTLS'; CN: ''));
  HCBlock185Val0: array[0..11] of byte = (
    $53, $B8, $0C, $00, $00, $00, $85, $C0, $74, $43, $83, $3D);
  HCBlock185Val1: array[0..7] of byte = (
    $7D, $0A, $B8, $E2, $00, $00, $00, $E8);
  HCBlock185Val2: array[0..7] of byte = (
    $68, $0C, $00, $00, $00, $6A, $40, $E8);
  HCBlock185Val3: array[0..11] of byte = (
    $8B, $D8, $85, $DB, $75, $0C, $B8, $E2, $00, $00, $00, $E8);
  HCBlock185Val4: array[0..3] of byte = (
    $EB, $0C, $53, $A1);
  HCBlock185Val5: array[0..1] of byte = (
    $50, $E8);
  HCBlock185Val6: array[0..1] of byte = (
    $89, $1D);
  HCBlock185Val7: array[0..1] of byte = (
    $5B, $C3);
  HCBlock185Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock185Val0); Val: @HCBlock185Val0), 
    (RA: $11; Count: length(HCBlock185Val1); Val: @HCBlock185Val1), 
    (RA: $1D; Count: length(HCBlock185Val2); Val: @HCBlock185Val2), 
    (RA: $29; Count: length(HCBlock185Val3); Val: @HCBlock185Val3), 
    (RA: $39; Count: length(HCBlock185Val4); Val: @HCBlock185Val4), 
    (RA: $41; Count: length(HCBlock185Val5); Val: @HCBlock185Val5), 
    (RA: $47; Count: length(HCBlock185Val6); Val: @HCBlock185Val6), 
    (RA: $4D; Count: length(HCBlock185Val7); Val: @HCBlock185Val7));
  HCBlock185Vars: array[0..1] of TCVar = (
    (RA: $C; VN: 'TlsIndex'), 
    (RA: $49; VN: 'tlsBuffer'));
  HCBlock185: THCBlock = (
    Size: $50;
    RAC: length(HCBlock185RA); RA: @HCBlock185RA;
    ValC: length(HCBlock185Val); Val: @HCBlock185Val;
    VarsC: length(HCBlock185Vars); Vars: @HCBlock185Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock186RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrFromString'; CN: ''));
  HCBlock186Val0: array[0..5] of byte = (
    $31, $C9, $8A, $0A, $42, $E9);
  HCBlock186Val1: array[0..0] of byte = (
    $C3);
  HCBlock186Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock186Val0); Val: @HCBlock186Val0), 
    (RA: $A; Count: length(HCBlock186Val1); Val: @HCBlock186Val1));
  HCBlock186: THCBlock = (
    Size: $C;
    RAC: length(HCBlock186RA); RA: @HCBlock186RA;
    ValC: length(HCBlock186Val); Val: @HCBlock186Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock187RA: array[0..0] of TRA = (
    (RA: $0; PN: 'WStrSet'; CN: ''));
  HCBlock187Val0: array[0..9] of byte = (
    $8B, $08, $89, $10, $85, $C9, $74, $06, $51, $E8);
  HCBlock187Val1: array[0..0] of byte = (
    $C3);
  HCBlock187Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock187Val0); Val: @HCBlock187Val0), 
    (RA: $E; Count: length(HCBlock187Val1); Val: @HCBlock187Val1));
  HCBlock187: THCBlock = (
    Size: $10;
    RAC: length(HCBlock187RA); RA: @HCBlock187RA;
    ValC: length(HCBlock187Val); Val: @HCBlock187Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock188RA: array[0..0] of TRA = (
    (RA: $0; PN: 'QueryInterface'; CN: 'TInterfacedObject'));
  HCBlock188Val0: array[0..15] of byte = (
    $55, $8B, $EC, $53, $8B, $5D, $08, $8B, $4D, $10, $8B, $55, $0C, $8B, $C3, $E8);
  HCBlock188Val1: array[0..22] of byte = (
    $84, $C0, $74, $04, $33, $C0, $EB, $05, $B8, $02, $40, $00, $80, $5B, $5D, $C2,
    $0C, $00, $8B, $C0, $55, $8B, $EC);
  HCBlock188Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock188Val0); Val: @HCBlock188Val0),
    (RA: $14; Count: length(HCBlock188Val1); Val: @HCBlock188Val1));
  HCBlock188: THCBlock = (
    Size: $28;
    RAC: length(HCBlock188RA); RA: @HCBlock188RA;
    ValC: length(HCBlock188Val); Val: @HCBlock188Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock189RA: array[0..0] of TRA = (
    (RA: $0; PN: '@IntfAddRef'; CN: ''));
  HCBlock189Val0: array[0..10] of byte = (
    $85, $C0, $74, $06, $50, $8B, $00, $FF, $50, $04, $C3);
  HCBlock189Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock189Val0); Val: @HCBlock189Val0));
  HCBlock189: THCBlock = (
    Size: $C;
    RAC: length(HCBlock189RA); RA: @HCBlock189RA;
    ValC: length(HCBlock189Val); Val: @HCBlock189Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock190RA: array[0..0] of TRA = (
    (RA: $0; PN: 'FindClassHInstance'; CN: ''));
  HCBlock190Val0: array[0..0] of byte = (
    $E8);
  HCBlock190Val1: array[0..0] of byte = (
    $C3);
  HCBlock190Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock190Val0); Val: @HCBlock190Val0), 
    (RA: $5; Count: length(HCBlock190Val1); Val: @HCBlock190Val1));
  HCBlock190PR: array[0..0] of TPR = (
    (RA: $1; PN: 'FindHInstance'; CN: ''));
  HCBlock190: THCBlock = (
    Size: $8;
    RAC: length(HCBlock190RA); RA: @HCBlock190RA;
    ValC: length(HCBlock190Val); Val: @HCBlock190Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock190PR); PR: @HCBlock190PR);
    
  HCBlock191RA: array[0..0] of TRA = (
    (RA: $0; PN: '_Release'; CN: 'TInterfacedObject'));
  HCBlock191Val0: array[0..12] of byte = (
    $55, $8B, $EC, $53, $56, $8B, $5D, $08, $8D, $43, $04, $50, $E8);
  HCBlock191Val1: array[0..23] of byte = (
    $8B, $F0, $85, $F6, $75, $09, $B2, $01, $8B, $C3, $8B, $08, $FF, $51, $FC, $8B,
    $C6, $5E, $5B, $5D, $C2, $04, $00, $FF);
  HCBlock191Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock191Val0); Val: @HCBlock191Val0),
    (RA: $11; Count: length(HCBlock191Val1); Val: @HCBlock191Val1));
  HCBlock191: THCBlock = (
    Size: $28;
    RAC: length(HCBlock191RA); RA: @HCBlock191RA;
    ValC: length(HCBlock191Val); Val: @HCBlock191Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock192RA: array[0..0] of TRA = (
    (RA: $0; PN: '@ROUND'; CN: ''));
  HCBlock192Val0: array[0..9] of byte = (
    $83, $EC, $08, $DF, $3C, $24, $9B, $58, $5A, $C3);
  HCBlock192Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock192Val0); Val: @HCBlock192Val0));
  HCBlock192: THCBlock = (
    Size: $C;
    RAC: length(HCBlock192RA); RA: @HCBlock192RA;
    ValC: length(HCBlock192Val); Val: @HCBlock192Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock193RA: array[0..0] of TRA = (
    (RA: $0; PN: '@PStrNCpy'; CN: ''));
  HCBlock193Val0: array[0..46] of byte = (
    $56, $57, $89, $C7, $31, $C0, $89, $D6, $8A, $02, $38, $C8, $77, $12, $40, $89, 
    $C1, $83, $E0, $03, $C1, $E9, $02, $F3, $A5, $89, $C1, $F3, $A4, $5F, $5E, $C3, 
    $88, $0F, $46, $47, $81, $E1, $FF, $00, $00, $00, $F3, $A4, $5F, $5E, $C3);
  HCBlock193Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock193Val0); Val: @HCBlock193Val0));
  HCBlock193: THCBlock = (
    Size: $30;
    RAC: length(HCBlock193RA); RA: @HCBlock193RA;
    ValC: length(HCBlock193Val); Val: @HCBlock193Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock194RA: array[0..0] of TRA = (
    (RA: $0; PN: '@PStrCmp'; CN: ''));
  HCBlock194Val0: array[0..129] of byte = (
    $53, $56, $57, $89, $C6, $89, $D7, $31, $C0, $31, $D2, $8A, $06, $8A, $17, $46, 
    $47, $29, $D0, $77, $02, $01, $C2, $52, $C1, $EA, $02, $74, $26, $8B, $0E, $8B, 
    $1F, $39, $D9, $75, $44, $4A, $74, $15, $8B, $4E, $04, $8B, $5F, $04, $39, $D9, 
    $75, $37, $83, $C6, $08, $83, $C7, $08, $4A, $75, $E2, $EB, $06, $83, $C6, $04, 
    $83, $C7, $04, $5A, $83, $E2, $03, $74, $1C, $8A, $0E, $3A, $0F, $75, $2F, $4A, 
    $74, $13, $8A, $4E, $01, $3A, $4F, $01, $75, $24, $4A, $74, $08, $8A, $4E, $02,
    $3A, $4F, $02, $75, $19, $01, $C0, $EB, $15, $5A, $38, $D9, $75, $10, $38, $FD,
    $75, $0C, $C1, $E9, $10, $C1, $EB, $10, $38, $D9, $75, $02, $38, $FD, $5F, $5E,
    $5B, $C3);
  HCBlock194Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock194Val0); Val: @HCBlock194Val0));
  HCBlock194: THCBlock = (
    Size: $84;
    RAC: length(HCBlock194RA); RA: @HCBlock194RA;
    ValC: length(HCBlock194Val); Val: @HCBlock194Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock195RA: array[0..0] of TRA = (
    (RA: $0; PN: '@_CToPasStr'; CN: ''));
  HCBlock195Val0: array[0..22] of byte = (
    $50, $B1, $FF, $8A, $2A, $42, $84, $ED, $74, $07, $40, $88, $28, $FE, $C9, $75,
    $F2, $5A, $29, $D0, $88, $02, $C3);
  HCBlock195Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock195Val0); Val: @HCBlock195Val0));
  HCBlock195: THCBlock = (
    Size: $18;
    RAC: length(HCBlock195RA); RA: @HCBlock195RA;
    ValC: length(HCBlock195Val); Val: @HCBlock195Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock196RA: array[0..0] of TRA = (
    (RA: $0; PN: '@_CLenToPasStr'; CN: ''));
  HCBlock196Val0: array[0..34] of byte = (
    $53, $50, $81, $F9, $FF, $00, $00, $00, $76, $05, $B9, $FF, $00, $00, $00, $8A,
    $1A, $42, $84, $DB, $74, $06, $40, $88, $18, $49, $75, $F3, $5A, $29, $D0, $88,
    $02, $5B, $C3);
  HCBlock196Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock196Val0); Val: @HCBlock196Val0));
  HCBlock196: THCBlock = (
    Size: $24;
    RAC: length(HCBlock196RA); RA: @HCBlock196RA;
    ValC: length(HCBlock196Val); Val: @HCBlock196Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock197RA: array[0..0] of TRA = (
    (RA: $0; PN: '@AsClass'; CN: ''));
  HCBlock197Val0: array[0..21] of byte = (
    $85, $C0, $74, $16, $89, $C1, $8B, $09, $39, $D1, $74, $0E, $8B, $49, $DC, $85, 
    $C9, $75, $F3, $B0, $0A, $E9);
  HCBlock197Val1: array[0..0] of byte = (
    $C3);
  HCBlock197Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock197Val0); Val: @HCBlock197Val0), 
    (RA: $1A; Count: length(HCBlock197Val1); Val: @HCBlock197Val1));
  HCBlock197: THCBlock = (
    Size: $1C;
    RAC: length(HCBlock197RA); RA: @HCBlock197RA;
    ValC: length(HCBlock197Val); Val: @HCBlock197Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock198RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrCat3'; CN: ''));
  HCBlock198Val0: array[0..7] of byte = (
    $85, $D2, $74, $61, $85, $C9, $0F, $84);
  HCBlock198Val1: array[0..10] of byte = (
    $3B, $10, $74, $5C, $3B, $08, $74, $0E, $50, $51, $E8);
  HCBlock198Val2: array[0..2] of byte = (
    $5A, $58, $E9);
  HCBlock198Val3: array[0..14] of byte = (
    $53, $56, $57, $89, $D3, $89, $CE, $50, $8B, $43, $FC, $03, $46, $FC, $E8);
  HCBlock198Val4: array[0..9] of byte = (
    $89, $C7, $89, $C2, $89, $D8, $8B, $4B, $FC, $E8);
  HCBlock198Val5: array[0..10] of byte = (
    $89, $FA, $89, $F0, $8B, $4E, $FC, $03, $53, $FC, $E8);
  HCBlock198Val6: array[0..10] of byte = (
    $58, $89, $FA, $85, $FF, $74, $03, $FF, $4F, $F8, $E8);
  HCBlock198Val7: array[0..6] of byte = (
    $5F, $5E, $5B, $C3, $89, $CA, $E9);
  HCBlock198Val8: array[0..2] of byte = (
    $89, $CA, $E9);
  HCBlock198Val9: array[0..0] of byte = (
    $C3);
  HCBlock198Val: array[0..9] of TVal = (
    (RA: $0; Count: length(HCBlock198Val0); Val: @HCBlock198Val0), 
    (RA: $C; Count: length(HCBlock198Val1); Val: @HCBlock198Val1), 
    (RA: $1B; Count: length(HCBlock198Val2); Val: @HCBlock198Val2), 
    (RA: $22; Count: length(HCBlock198Val3); Val: @HCBlock198Val3), 
    (RA: $35; Count: length(HCBlock198Val4); Val: @HCBlock198Val4), 
    (RA: $43; Count: length(HCBlock198Val5); Val: @HCBlock198Val5), 
    (RA: $52; Count: length(HCBlock198Val6); Val: @HCBlock198Val6), 
    (RA: $61; Count: length(HCBlock198Val7); Val: @HCBlock198Val7), 
    (RA: $6C; Count: length(HCBlock198Val8); Val: @HCBlock198Val8), 
    (RA: $73; Count: length(HCBlock198Val9); Val: @HCBlock198Val9));
  HCBlock198: THCBlock = (
    Size: $74;
    RAC: length(HCBlock198RA); RA: @HCBlock198RA;
    ValC: length(HCBlock198Val); Val: @HCBlock198Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock199RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrAddRef'; CN: ''));
  HCBlock199Val0: array[0..13] of byte = (
    $85, $C0, $74, $09, $8B, $50, $F8, $42, $7E, $03, $89, $50, $F8, $C3);
  HCBlock199Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock199Val0); Val: @HCBlock199Val0));
  HCBlock199: THCBlock = (
    Size: $10;
    RAC: length(HCBlock199RA); RA: @HCBlock199RA;
    ValC: length(HCBlock199Val); Val: @HCBlock199Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock200RA: array[0..0] of TRA = (
    (RA: $0; PN: '@LStrDelete'; CN: ''));
  HCBlock200Val0: array[0..9] of byte = (
    $53, $56, $57, $89, $C3, $89, $D6, $89, $CF, $E8);
  HCBlock200Val1: array[0..35] of byte = (
    $8B, $13, $85, $D2, $74, $30, $8B, $4A, $FC, $4E, $7C, $2A, $39, $CE, $7D, $26, 
    $85, $FF, $7E, $22, $29, $F1, $39, $CF, $7E, $02, $89, $CF, $29, $F9, $01, $F2, 
    $8D, $04, $3A, $E8);
  HCBlock200Val2: array[0..9] of byte = (
    $8B, $13, $89, $D8, $8B, $52, $FC, $29, $FA, $E8);
  HCBlock200Val3: array[0..3] of byte = (
    $5F, $5E, $5B, $C3);
  HCBlock200Val: array[0..3] of TVal = (
    (RA: $0; Count: length(HCBlock200Val0); Val: @HCBlock200Val0), 
    (RA: $E; Count: length(HCBlock200Val1); Val: @HCBlock200Val1), 
    (RA: $36; Count: length(HCBlock200Val2); Val: @HCBlock200Val2), 
    (RA: $44; Count: length(HCBlock200Val3); Val: @HCBlock200Val3));
  HCBlock200: THCBlock = (
    Size: $48;
    RAC: length(HCBlock200RA); RA: @HCBlock200RA;
    ValC: length(HCBlock200Val); Val: @HCBlock200Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock201RA: array[0..0] of TRA = (
    (RA: $0; PN: '@InitializeRecord'; CN: ''));
  HCBlock201Val0: array[0..27] of byte = (
    $31, $C9, $53, $8A, $4A, $01, $56, $57, $89, $C3, $8D, $74, $0A, $0A, $8B, $7C, 
    $0A, $06, $8B, $16, $8B, $46, $04, $01, $D8, $8B, $12, $E8);
  HCBlock201Val1: array[0..9] of byte = (
    $83, $C6, $08, $4F, $7F, $EC, $5F, $5E, $5B, $C3);
  HCBlock201Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock201Val0); Val: @HCBlock201Val0), 
    (RA: $20; Count: length(HCBlock201Val1); Val: @HCBlock201Val1));
  HCBlock201: THCBlock = (
    Size: $2C;
    RAC: length(HCBlock201RA); RA: @HCBlock201RA;
    ValC: length(HCBlock201Val); Val: @HCBlock201Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock202RA: array[0..0] of TRA = (
    (RA: $0; PN: '@InitializeArray'; CN: ''));
  HCBlock202Val0: array[0..58] of byte = (
    $53, $56, $57, $89, $C3, $89, $D6, $89, $CF, $31, $D2, $8A, $06, $8A, $56, $01, 
    $31, $C9, $80, $F8, $0A, $74, $28, $80, $F8, $0B, $74, $23, $80, $F8, $0C, $74, 
    $28, $80, $F8, $0D, $74, $36, $80, $F8, $0E, $74, $4F, $80, $F8, $0F, $74, $0F, 
    $80, $F8, $11, $74, $0A, $B0, $02, $5F, $5E, $5B, $E9);
  HCBlock202Val1: array[0..70] of byte = (
    $89, $0B, $83, $C3, $04, $4F, $7F, $F8, $EB, $45, $89, $0B, $89, $4B, $04, $89, 
    $4B, $08, $89, $4B, $0C, $83, $C3, $10, $4F, $7F, $EF, $EB, $32, $55, $89, $D5, 
    $8B, $54, $2E, $0A, $89, $D8, $03, $5C, $2E, $02, $8B, $4C, $2E, $06, $8B, $12, 
    $E8, $8C, $FF, $FF, $FF, $4F, $7F, $E8, $5D, $EB, $14, $55, $89, $D5, $89, $D8, 
    $03, $5C, $2E, $02, $89, $F2, $E8);
  HCBlock202Val2: array[0..7] of byte = (
    $4F, $7F, $F0, $5D, $5F, $5E, $5B, $C3);
  HCBlock202Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock202Val0); Val: @HCBlock202Val0), 
    (RA: $3F; Count: length(HCBlock202Val1); Val: @HCBlock202Val1), 
    (RA: $8A; Count: length(HCBlock202Val2); Val: @HCBlock202Val2));
  HCBlock202: THCBlock = (
    Size: $94;
    RAC: length(HCBlock202RA); RA: @HCBlock202RA;
    ValC: length(HCBlock202Val); Val: @HCBlock202Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock203RA: array[0..0] of TRA = (
    (RA: $0; PN: '@Initialize'; CN: ''));
  HCBlock203Val0: array[0..5] of byte = (
    $B9, $01, $00, $00, $00, $E9);
  HCBlock203Val1: array[0..0] of byte = (
    $C3);
  HCBlock203Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock203Val0); Val: @HCBlock203Val0),
    (RA: $A; Count: length(HCBlock203Val1); Val: @HCBlock203Val1));
  HCBlock203PR: array[0..0] of TPR = (
    (RA: $6; PN: '@InitializeArray'; CN: ''));
  HCBlock203: THCBlock = (
    Size: $C;
    RAC: length(HCBlock203RA); RA: @HCBlock203RA;
    ValC: length(HCBlock203Val); Val: @HCBlock203Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock203PR); PR: @HCBlock203PR);

  HCBlock204RA: array[0..0] of TRA = (
    (RA: $0; PN: 'MethodAddress'; CN: 'TObject'));
  HCBlock204Val0: array[0..77] of byte = (
    $53, $56, $57, $31, $C9, $31, $FF, $8A, $1A, $EB, $02, $8B, $00, $8B, $70, $CC, 
    $85, $F6, $74, $15, $66, $8B, $3E, $83, $C6, $02, $8A, $4E, $06, $38, $D9, $74, 
    $15, $66, $8B, $0E, $01, $CE, $4F, $75, $F1, $8B, $40, $DC, $85, $C0, $75, $DB, 
    $EB, $18, $8A, $1A, $EB, $EB, $B5, $00, $8A, $5C, $0E, $06, $32, $1C, $0A, $80, 
    $E3, $DF, $75, $EE, $49, $75, $F1, $8B, $46, $02, $5F, $5E, $5B, $C3);
  HCBlock204Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock204Val0); Val: @HCBlock204Val0));
  HCBlock204: THCBlock = (
    Size: $50;
    RAC: length(HCBlock204RA); RA: @HCBlock204RA;
    ValC: length(HCBlock204Val); Val: @HCBlock204Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock205RA: array[0..0] of TRA = (
    (RA: $0; PN: '_AddRef'; CN: 'TInterfacedObject'));
  HCBlock205Val0: array[0..10] of byte = (
    $55, $8B, $EC, $8B, $45, $08, $83, $C0, $04, $50, $E8);
  HCBlock205Val1: array[0..8] of byte = (
    $5D, $C2, $04, $00, $90, $55, $8B, $EC, $53);
  HCBlock205Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock205Val0); Val: @HCBlock205Val0), 
    (RA: $F; Count: length(HCBlock205Val1); Val: @HCBlock205Val1));
  HCBlock205: THCBlock = (
    Size: $14;
    RAC: length(HCBlock205RA); RA: @HCBlock205RA;
    ValC: length(HCBlock205Val); Val: @HCBlock205Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock206RA: array[0..0] of TRA = (
    (RA: $0; PN: '@InitLib'; CN: ''));
  HCBlock206Val0: array[0..0] of byte = (
    $BA);
  HCBlock206Val6: array[0..9] of byte = (
    $83, $7D, $0C, $01, $75, $2A, $50, $52, $C6, $05);
  HCBlock206Val1: array[0..4] of byte = (
    $8B, $4D, $08, $89, $0D);
  HCBlock206Val2: array[0..17] of byte = (
    $89, $4A, $04, $C7, $42, $08, $00, $00, $00, $00, $C7, $42, $0C, $00, $00, $00,
    $00, $E8);
  HCBlock206Val3: array[0..3] of byte = (
    $5A, $58, $FF, $35);
  HCBlock206Val4: array[0..0] of byte = (
    $B9);
  HCBlock206Val5: array[0..0] of byte = (
    $C3);
  HCBlock206Val: array[0..6] of TVal = (
    (RA: $0; Count: length(HCBlock206Val0); Val: @HCBlock206Val0),
    (RA: $5; Count: length(HCBlock206Val6); Val: @HCBlock206Val6),
    (RA: $14; Count: length(HCBlock206Val1); Val: @HCBlock206Val1),
    (RA: $1D; Count: length(HCBlock206Val2); Val: @HCBlock206Val2),
    (RA: $33; Count: length(HCBlock206Val3); Val: @HCBlock206Val3),
    (RA: $3B; Count: length(HCBlock206Val4); Val: @HCBlock206Val4), 
    (RA: $45; Count: length(HCBlock206Val5); Val: @HCBlock206Val5));
  HCBlock206Vars: array[0..2] of TCVar = (
    (RA: $F; VN: 'ModuleIsLib'), 
    (RA: $19; VN: 'HInstance'), 
    (RA: $37; VN: 'DllProc'));
  HCBlock206: THCBlock = (
    Size: $48;
    RAC: length(HCBlock206RA); RA: @HCBlock206RA;
    ValC: length(HCBlock206Val); Val: @HCBlock206Val;
    VarsC: length(HCBlock206Vars); Vars: @HCBlock206Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock207RA: array[0..0] of TRA = (
    (RA: $0; PN: '@InitPkg'; CN: ''));
  HCBlock207Val0: array[0..12] of byte = (
    $55, $8B, $EC, $53, $56, $8B, $5D, $0C, $8B, $45, $08, $C6, $05);
  HCBlock207Val1: array[0..1] of byte = (
    $C6, $05);
  HCBlock207Val2: array[0..0] of byte = (
    $A3);
  HCBlock207Val3: array[0..3] of byte = (
    $33, $D2, $89, $15);
  HCBlock207Val4: array[0..3] of byte = (
    $33, $D2, $89, $15);
  HCBlock207Val5: array[0..0] of byte = (
    $A3);
  HCBlock207Val6: array[0..11] of byte = (
    $B8, $08, $00, $00, $00, $85, $C0, $74, $09, $8B, $34, $9D);
  HCBlock207Val7: array[0..7] of byte = (
    $FF, $D6, $83, $FB, $01, $75, $07, $E8);
  HCBlock207Val8: array[0..6] of byte = (
    $EB, $09, $85, $DB, $75, $05, $E8);
  HCBlock207Val9: array[0..8] of byte = (
    $83, $C8, $FF, $5E, $5B, $5D, $C2, $0C, $00);
  HCBlock207Val: array[0..9] of TVal = (
    (RA: $0; Count: length(HCBlock207Val0); Val: @HCBlock207Val0),
    (RA: $12; Count: length(HCBlock207Val1); Val: @HCBlock207Val1),
    (RA: $19; Count: length(HCBlock207Val2); Val: @HCBlock207Val2),
    (RA: $1E; Count: length(HCBlock207Val3); Val: @HCBlock207Val3),
    (RA: $26; Count: length(HCBlock207Val4); Val: @HCBlock207Val4),
    (RA: $2E; Count: length(HCBlock207Val5); Val: @HCBlock207Val5),
    (RA: $33; Count: length(HCBlock207Val6); Val: @HCBlock207Val6),
    (RA: $43; Count: length(HCBlock207Val7); Val: @HCBlock207Val7),
    (RA: $4F; Count: length(HCBlock207Val8); Val: @HCBlock207Val8),
    (RA: $5A; Count: length(HCBlock207Val9); Val: @HCBlock207Val9));
  HCBlock207Vars: array[0..3] of TCVar = (
    (RA: $D; VN: 'ModuleIsLib'),
    (RA: $14; VN: 'ModuleIsPackage'),
    (RA: $2F; VN: 'HInstance'),
    (RA: $3F; VN: 'TlsProc'));
  HCBlock207: THCBlock = (
    Size: $64;
    RAC: length(HCBlock207RA); RA: @HCBlock207RA;
    ValC: length(HCBlock207Val); Val: @HCBlock207Val;
    VarsC: length(HCBlock207Vars); Vars: @HCBlock207Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock208RA: array[0..0] of TRA = (
    (RA: $0; PN: '@Write0LString'; CN: ''));
  HCBlock208Val0: array[0..2] of byte = (
    $31, $C9, $E9);
  HCBlock208Val1: array[0..0] of byte = (
    $C3);
  HCBlock208Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock208Val0); Val: @HCBlock208Val0), 
    (RA: $7; Count: length(HCBlock208Val1); Val: @HCBlock208Val1));
  HCBlock208PR: array[0..0] of TPR = (
    (RA: $3; PN: '@WriteLString'; CN: ''));
  HCBlock208: THCBlock = (
    Size: $8;
    RAC: length(HCBlock208RA); RA: @HCBlock208RA;
    ValC: length(HCBlock208Val); Val: @HCBlock208Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: length(HCBlock208RA); PR: @HCBlock208PR);

  HCBlock209RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WriteLString'; CN: ''));
  HCBlock209Val0: array[0..17] of byte = (
    $53, $89, $D3, $89, $CA, $31, $C9, $85, $DB, $74, $05, $8B, $4B, $FC, $29, $CA, 
    $51, $E8);
  HCBlock209Val1: array[0..4] of byte = (
    $59, $89, $DA, $5B, $E9);
  HCBlock209Val2: array[0..0] of byte = (
    $C3);
  HCBlock209Val: array[0..2] of TVal = (
    (RA: $0; Count: length(HCBlock209Val0); Val: @HCBlock209Val0), 
    (RA: $16; Count: length(HCBlock209Val1); Val: @HCBlock209Val1), 
    (RA: $1F; Count: length(HCBlock209Val2); Val: @HCBlock209Val2));
  HCBlock209: THCBlock = (
    Size: $20;
    RAC: length(HCBlock209RA); RA: @HCBlock209RA;
    ValC: length(HCBlock209Val); Val: @HCBlock209Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock210RA: array[0..0] of TRA = (
    (RA: $0; PN: '@WStrToPWChar'; CN: ''));
  HCBlock210Val0: array[0..8] of byte = (
    $85, $C0, $74, $04, $C3, $90, $00, $00, $B8);
  HCBlock210Val1: array[0..0] of byte = (
    $C3);
  HCBlock210Val: array[0..1] of TVal = (
    (RA: $0; Count: length(HCBlock210Val0); Val: @HCBlock210Val0), 
    (RA: $D; Count: length(HCBlock210Val1); Val: @HCBlock210Val1));
  HCBlock210IA: array[0..0] of TIA = (
    (RA: $9; RRA: $6));
  HCBlock210: THCBlock = (
    Size: $10;
    RAC: length(HCBlock210RA); RA: @HCBlock210RA;
    ValC: length(HCBlock210Val); Val: @HCBlock210Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock210IA); IA: @HCBlock210IA;
    PRC: 0; PR: nil);

  HCBlock211RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ParamStr'; CN: ''));
  HCBlock211Val0: array[0..29] of byte = (
    $53, $56, $57, $81, $C4, $F8, $FE, $FF, $FF, $8B, $F2, $8B, $D8, $85, $DB, $75, 
    $1E, $68, $05, $01, $00, $00, $8D, $44, $24, $04, $50, $6A, $00, $E8);
  HCBlock211Val1: array[0..6] of byte = (
    $8B, $C8, $8B, $D4, $8B, $C6, $E8);
  HCBlock211Val2: array[0..2] of byte = (
    $EB, $1E, $E8);
  HCBlock211Val3: array[0..6] of byte = (
    $8B, $F8, $8B, $D6, $8B, $C7, $E8);
  HCBlock211Val4: array[0..23] of byte = (
    $8B, $F8, $85, $DB, $74, $08, $83, $3E, $00, $74, $03, $4B, $EB, $E9, $81, $C4, 
    $08, $01, $00, $00, $5F, $5E, $5B, $C3);
  HCBlock211Val: array[0..4] of TVal = (
    (RA: $0; Count: length(HCBlock211Val0); Val: @HCBlock211Val0), 
    (RA: $22; Count: length(HCBlock211Val1); Val: @HCBlock211Val1), 
    (RA: $2D; Count: length(HCBlock211Val2); Val: @HCBlock211Val2), 
    (RA: $34; Count: length(HCBlock211Val3); Val: @HCBlock211Val3), 
    (RA: $3F; Count: length(HCBlock211Val4); Val: @HCBlock211Val4));
  HCBlock211: THCBlock = (
    Size: $58;
    RAC: length(HCBlock211RA); RA: @HCBlock211RA;
    ValC: length(HCBlock211Val); Val: @HCBlock211Val;
    VarsC: 0; Vars: nil;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlock212RA: array[0..0] of TRA = (
    (RA: $0; PN: 'ParamCount'; CN: ''));
  HCBlock212Val0: array[0..10] of byte = (
    $55, $8B, $EC, $6A, $00, $53, $56, $33, $C0, $55, $68);
  HCBlock212Val1: array[0..6] of byte = (
    $64, $FF, $30, $64, $89, $20, $E8);
  HCBlock212Val2: array[0..3] of byte = (
    $8D, $55, $FC, $E8);
  HCBlock212Val3: array[0..9] of byte = (
    $8B, $D8, $33, $F6, $8D, $55, $FC, $8B, $C3, $E8);
  HCBlock212Val4: array[0..19] of byte = (
    $8B, $D8, $83, $7D, $FC, $00, $74, $03, $46, $EB, $EB, $33, $C0, $5A, $59, $59, 
    $64, $89, $10, $68);
  HCBlock212Val5: array[0..3] of byte = (
    $8D, $45, $FC, $E8);
  HCBlock212Val6: array[0..1] of byte = (
    $C3, $E9);
  HCBlock212Val7: array[0..8] of byte = (
    $EB, $F0, $8B, $C6, $5E, $5B, $59, $5D, $C3);
  HCBlock212Val: array[0..7] of TVal = (
    (RA: $0; Count: length(HCBlock212Val0); Val: @HCBlock212Val0), 
    (RA: $F; Count: length(HCBlock212Val1); Val: @HCBlock212Val1), 
    (RA: $1A; Count: length(HCBlock212Val2); Val: @HCBlock212Val2), 
    (RA: $22; Count: length(HCBlock212Val3); Val: @HCBlock212Val3), 
    (RA: $30; Count: length(HCBlock212Val4); Val: @HCBlock212Val4), 
    (RA: $48; Count: length(HCBlock212Val5); Val: @HCBlock212Val5), 
    (RA: $50; Count: length(HCBlock212Val6); Val: @HCBlock212Val6), 
    (RA: $56; Count: length(HCBlock212Val7); Val: @HCBlock212Val7));
  HCBlock212IA: array[0..1] of TIA = (
    (RA: $B; RRA: $51), 
    (RA: $44; RRA: $58));
  HCBlock212: THCBlock = (
    Size: $60;
    RAC: length(HCBlock212RA); RA: @HCBlock212RA;
    ValC: length(HCBlock212Val); Val: @HCBlock212Val;
    VarsC: 0; Vars: nil;
    IAC: length(HCBlock212IA); IA: @HCBlock212IA;
    PRC: 0; PR: nil);

// ----------

 type
  THCProc = record
    R: Integer;
    N: string;
  end;

const
  // Assign obj (contains Assign and Flush)
  AssignObj: array[0..21] of Byte = (
    $33, $D2, $89, $50, $10, $89, $50, $0C, $52, $8D, $50, $10, $52, $FF, $70, $08, $FF, $70,
    $14, $FF, $30, $E8);
  AssignObjSize = $2A4; {already 4 byte aligned}
  AssignProcS: array[0..1] of THCProc =
    ((R: $202; N: '@Assign'), (R: $529; N: '@Flush'));

  // Close obj.
  CloseObj: array [0..37] of Byte = (
    $53, $8B, $D8, $8B, $50, $04, $81, $EA, $B1, $D7, $00, $00, $74, $0E, $83, $FA, $02, $77,
    $19, $FF, $50, $1C, $85, $C0, $75, $0B, $8B, $C3, $FF, $53, $24, $85, $C0, $75, $02, $5B,
    $C3, $E8);
  CloseObjSize = $3C;
  CloseProcs: array[0..0] of THCProc =
    ((R: $0; N: '@Close'));

  // OpenText obj
  OpenTextObj: array[0..22] of Byte = (
    $53, $56, $8B, $F0, $8B, $DA, $8B, $56, $04, $81, $EA, $B0, $D7, $00, $00, $74, $0A, $83,
    $FA, $03, $77, $19, $E8);
  OpenTextObjSize = $50;
  OpenTextProcs: array[0..2] of THCProc =
    ((R: $3B; N: '@ResetText'), (R: $42; N: '@RewritText'), (R: $49; N: '@Append'));

  // RewriteStr obj.
  HCBlock127RA: array[0..8] of TRA = (
    (RA: 0; PN: '@WriteBytes'), (RA: $6B; PN: '@WriteSpaces'), (RA: $A4; PN: '@Write0String'),
    (RA: $AE; PN: '@WriteString'), (RA: $CB; PN: '@WriteLn'), (RA: $DF; PN: '@Write0Char'),
    (RA: $131; PN: '@WriteChar'), (RA: $148; PN: '@Write0CString'), (RA: $14C; PN: '@WriteCString'));
  HCBlock127Val0: array[0..59] of byte = (
    $56, $57, $8B, $F2, $81, $78, $04, $B2, $D7, $00, $00, $75, $2E, $8B, $78, $14, $03, $78,
    $0C, $8B, $50, $08, $2B, $50, $0C, $3B, $D1, $7F, $16, $01, $50, $0C, $2B, $CA, $50, $51,
    $8B, $CA, $F3, $A4, $FF, $50, $1C, $85, $C0, $75, $33, $59, $58, $EB, $DA, $01, $48, $0C,
    $F3, $A4, $5F, $5E, $C3, $3D);
  HCBlock127Val: array[0..0] of TVal = (
    (RA: $0; Count: length(HCBlock127Val0); Val: @HCBlock127Val0));
  HCBlock127Vars: array[0..1] of TCVar = (
    (RA: $6E; VN: 'RewriteStr.spBuf'),
    (RA: $CC; VN: 'RewriteStr.crlf'));
  HCBlock127: THCBlock = (
    Size: $178;
    RAC: length(HCBlock127RA); RA: @HCBlock127RA;
    ValC: length(HCBlock127Val); Val: @HCBlock127Val;
    VarsC: Length(HCBlock127Vars); Vars: @HCBlock127Vars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  BlockreaObj: array[0..37] of Byte = (
    $53, $56, $8B, $D8, $8B, $F2, $8B, $53, $04, $81, $EA, $B1, $D7, $00, $00, $83,
    $FA, $02, $77, $48, $51, $6A, $00, $8B, $C4, $6A, $00, $50, $8B, $43, $08, $F7, $E1, $50,
    $56, $FF, $33, $E8);
  BlockreaObjSize = $64;
  BlockReaProcs: array[0..0] of THCProc = ((R: $0; N: '@BlockRead'));

  BlockwriObj: array[0..36] of Byte = (
    $53, $56, $8B, $D8, $8B, $F2, $8B, $40, $04, $2D, $B2, $D7, $00, $00, $83, $F8, $01, $77,
    $48, $51, $6A, $00, $8B, $C4, $6A, $00, $50, $8B, $43, $08, $F7, $E1, $50, $56, $FF, $33,
    $E8);
  BlockwriObjSize = $64;
  BlockWriProcs: array[0..0] of THCProc = ((R: $0; N: '@BlockWrite'));

  EoffileObj: array[0..21] of Byte = (
    $53, $8B, $D8, $8B, $53, $04, $81, $EA, $B1, $D7, $00, $00, $83, $FA, $02, $77, $32, $6A,
    $00, $FF, $33, $E8);
  EoffileObjSize = $54;
  EofFileProcs: array[0..0] of THCProc = ((R: $0; N: '@EofFile'));

  EoftextObj: array[0..34] of Byte = (
    $81, $78, $04, $B1, $D7, $00, $00, $75, $18, $8B, $50, $0C, $3B, $50, $10, $73, $10, $03,
    $50, $14, $B0, $00, $8A, $0A, $80, $F9, $1A, $74, $01, $C3, $B0, $01, $C3, $50, $E8);
  EoftextObjSize = $34;
  EofTextProcs: array[0..0] of THCProc = ((R: $0; N: '@EofText'));

  EolnObj: array[0..38] of Byte = (
    $81, $78, $04, $B1, $D7, $00, $00, $75, $1D, $8B, $50, $0C, $3B, $50, $10, $73, $15, $03,
    $50, $14, $B0, $00, $8A, $0A, $80, $F9, $0D, $74, $06, $80, $F9, $1A, $74, $01, $C3, $B0,
    $01, $C3, $50);
  EolnObjSize = $3C;
  EolnProcs: array[0..0] of THCProc = ((R: $0; N: '@Eoln'));

  EreaseObj: array[0..18] of Byte = (
    $8B, $50, $04, $81, $EA, $B0, $D7, $00, $00, $83, $FA, $03, $77, $19, $8D, $40, $48, $50,
    $E8);
  EreaseObjSize = $30;
  EreaseProcs: array[0..0] of THCProc = ((R: $0; N: '@Erase'));

  FDivObj: array[6..15] of Byte = (
    $01, $50, $83, $EC, $0C, $DB, $3C, $24, $DD, $05);
  FDivObjSize = $12C;
  FDivProcs: array[0..1] of THCProc = ((R: $44; N: '@FSafeDivideR'), (R: $46; N: '@FSafeDivide'));
  FTestFDiv = $2;  // byte Var

 FileposObj: array[0..25] of Byte = (
    $53, $8B, $D8, $8B, $53, $04, $81, $EA, $B1, $D7, $00, $00, $83, $FA, $02, $77, $23,
    $6A, $01, $6A, $00, $6A, $00, $FF, $33, $E8);
  FileposObjSize = $44;
  FileposProcs: array[0..0] of THCProc = ((R: $0; N: '@Filepos'));

 FilesizeObj: array[0..21] of Byte = (
   $53, $8B, $D8, $8B, $53, $04, $81, $EA, $B1, $D7, $00, $00, $83, $FA, $02, $77, $1F, $6A,
   $00, $FF, $33, $E8);
  FilesizeObjSize = $40;
  FilesizeProcs: array[0..0] of THCProc = ((R: $0; N: '@Filesize'));

  ReadrecObj: array[0..48] of Byte = (
    $53, $8B, $D8, $8B, $4B, $04, $81, $E9, $B1, $D7, $00, $00, $74, $05, $83, $E9, $02, $75,
    $29, $6A, $00, $8B, $C4, $6A, $00, $50, $FF, $73, $08, $52, $FF, $33, $E8, $E3, $DC, $FF,
    $FF, $5A, $48, $75, $07, $3B, $53, $08, $75, $15, $5B, $C3, $E8);
  ReadrecObjSize = $4C;
  ReadrecProcs: array[0..0] of THCProc = ((R: $0; N: '@Readrec'));

  ReadcharObj: array[0..47] of Byte = (
    $81, $78, $04, $B1, $D7, $00, $00, $75, $1A, $8B, $50, $0C, $3B, $50, $10, $73, $3B, $8B,
    $48, $14, $8A, $0C, $11, $80, $F9, $1A, $74, $04, $42, $89, $50, $0C, $8A, $C1, $C3, $3D,
    $38, $50, $9F, $00, $74, $0D, $B8, $68, $00, $00, $00, $E8);
  ReadcharObjSize = $74;
  ReadcharProcs: array[0..0] of THCProc = ((R: $0; N: '@Readchar'));

  ReadlongObjA: array[$41..$54] of Byte = (
    $83, $C4, $24, $5F, $5E, $5B, $C3, $3C, $1A, $74, $D9, $FF, $4E, $0C, $EB, $D4, $33,
    $C0, $EB, $EC);
  readlongObjB: array[$32..$32] of Byte = ($5A);
  ReadlongObjSize = $58;
  ReadlongProcs: array[0..0] of THCProc =
    ((R: $0; N: '@ReadLong'));

  ReadstrObj: array[0..96] of Byte = (
    $52, $42, $E8, $10, $00, $00, $00, $5A, $88, $0A, $C3, $52, $E8, $06, $00, $00, $00, $5A, $C6,
    $04, $0A, $00, $C3, $53, $56, $57, $51, $8B, $D8, $8B, $F1, $8B, $FA, $81, $7B, $04, $B1, $D7,
    $00, $00, $75, $48, $85, $F6, $7E, $26, $8B, $53, $0C, $8B, $4B, $10, $2B, $CA, $03, $53, $14,
    $49, $7C, $1F, $8A, $02, $42, $3C, $1A, $74, $11, $3C, $0D, $74, $06, $AA, $4E, $7F, $EE, $EB,
    $01, $4A, $2B, $53, $14, $89, $53, $0C, $59, $2B, $CE, $5F, $5E, $5B, $C3, $89, $53, $0C, $8B,
    $C3, $E8);
  ReadstrObjSize = $98;
  ReadStrProcs: array[0..1] of THCProc =
    ((R: $0; N: '@ReadString'), (R: $B; N: '@ReadCString'));

  ReadExtObj: array[$D..$17] of Byte = (
    $FE, $C8, $74, $40, $8B, $FC, $B3, $40, $8B, $C6, $E8);
  ReadextObjSize = $58;
  ReadextProcs: array[0..0] of THCProc =
    ((R: $0; N: '@ReadExt'));

  ReadlnObj: array[$19..$3E] of Byte = (
    $3C, $0A, $74, $07, $3C, $1A,
    $74, $05, $FF, $4B, $0C, $5B, $C3, $5B, $C3, $53, $56, $8B, $F0, $8B, $DA, $8B, $56, $04,
    $81, $EA, $B0, $D7, $00, $00, $74, $0A, $83, $FA, $03, $77, $19, $E8);
  ReadlnObjSize = $28;
  ReadlnProcs: array[0..0] of THCProc =
    ((R: $0; N: 'Readln'));

  RenameObj: array[0..25] of Byte = (
   $81, $78, $04, $B0, $D7, $00, $00, $75, $41, $85, $D2, $75, $05, $BA, $0D, $35, $9F, $00,
   $8D, $40, $48, $52, $50, $52, $50, $E8);
  RenameObjSize = $54;
  RenameProcs: array[0..0] of THCProc =
    ((R: $0; N: 'Rename'));

  OpenfileObj: array[0..36] of Byte = (
    $53, $56, $57, $8B, $D8, $8B, $F2, $8B, $F9, $8B, $53, $04, $81, $EA, $B0, $D7, $00, $00,
    $74, $15, $83, $FA, $03, $0F, $87, $AA, $00, $00, $00, $FF, $53, $24, $85, $C0, $74, $05,
    $E8);
  OpenfileObjSize = $138;
  OpenfileProcs: array[0..1] of THCProc =
    ((R: $101; N: '@ResetFile'), (R: $118; N: '@RewritFile'));

  SeekObj: array[0..27] of Byte = (
    $8B, $C8, $8B, $41, $04, $2D, $B1, $D7, $00, $00, $83, $F8, $02, $77, $19,
    $6A, $00, $8B, $41, $08, $F7, $E2, $6A, $00, $50, $FF, $31, $E8);
  SeekObjSize = $34;
  SeekProcs: array[0..0] of THCProc =
    ((R: $0; N: '@Seek'));

  SeekeofObj: array[10..30] of Byte = (
    $3C, $20, $77, $06, $3C, $1A, $74, $09, $EB, $EF, $FF, $4B, $0C, $5B, $B0, $00, $C3, $B0,
    $01, $5B, $C3);
  SeekeofObjSize = $20;
  SeekeofProcs: array[0..0] of THCProc =
    ((R: $0; N: '@SeekEof'));

  SeekeolnObj: array[10..36] of Byte = (
     $3C, $20, $77, $0C, $3C, $1A, $74, $0F, $3C, $0D, $75, $ED, $B0, $01,
     $EB, $02, $B0, $00, $FF, $4B, $0C, $5B, $C3, $B0, $01, $5B, $C3);
  SeekeolnObjSize = $28;
  SeekeolnProcs: array[0..0] of THCProc =
    ((R: $0; N: '@SeekEoln'));

  SetTextBObj: array[0..15] of Byte = (
    $89, $50, $14, $33, $D2, $89, $48, $08, $89, $50, $0C, $89, $50, $10, $C3, $90);
  SetTextBObjSize = $10;
  SetTextBProcs: array[0..0] of THCProc =
    ((R: $0; N: '@SetTextBuf'));

  TruncateObj: array[0..16] of Byte = (
    $8B, $50, $04, $81, $EA, $B1, $D7, $00, $00, $83, $FA, $02, $77, $0F, $FF, $30, $E8);
  TruncateObjSize = $28;
  TruncateProcs: array[0..0] of THCProc =
    ((R: $0; N: '@Truncate'));

  strextObj: array[0..$267] of Byte = (
    $8B, $C8, $B8, $17, $00, $00, $00, $83, $CA, $FF, $EB, $07, $8B, $CA, $83, $CA, $FF, $EB,
    $00, $DB, $6C, $24, $04, $53, $56, $57, $8B, $D8, $8B, $F2, $51, $81, $EC, $00, $01, $00,
    $00, $81, $FB, $FF, $00, $00, $00, $7E, $05, $BB, $FF, $00, $00, $00, $D9, $C0, $DB, $3C,
    $24, $33, $C0, $66, $8B, $44, $24, $08, $8B, $F8, $C1, $EF, $0F, $66, $25, $FF, $7F, $66,
    $3D, $FF, $7F, $0F, $84, $3E, $01, $00, $00, $D9, $E1, $85, $F6, $0F, $8D, $A1, $00, $00,
    $00, $E8, $DE, $01, $00, $00, $8B, $F3, $83, $EE, $08, $83, $FE, $02, $7D, $07, $BE, $02,
    $00, $00, $00, $EB, $0A, $83, $FE, $12, $7E, $05, $BE, $12, $00, $00, $00, $8B, $D4, $50,
    $8B, $C6, $E8, $4F, $01, $00, $00, $8B, $D7, $8B, $BC, $24, $04, $01, $00, $00, $88, $1F,
    $47, $B0, $20, $8B, $CB, $2B, $CE, $83, $E9, $08, $7E, $02, $F3, $AA, $28, $4F, $FF, $84,
    $D2, $74, $02, $B0, $2D, $AA, $58, $8B, $CE, $8B, $F4, $80, $3E, $30, $74, $02, $40, $4E,
    $46, $A4, $C6, $07, $2E, $47, $49, $F3, $A4, $C6, $07, $45, $B1, $2B, $85, $C0, $7D, $04,
    $B1, $2D, $F7, $D8, $88, $4F, $01, $33, $D2, $66, $B9, $0A, $00, $66, $F7, $F1, $80, $C2,
    $30, $88, $57, $05, $33, $D2, $66, $F7, $F1, $80, $C2, $30, $88, $57, $04, $33, $D2, $66,
    $F7, $F1, $80, $C2, $30, $88, $57, $03, $04, $30, $88, $47, $02, $E9, $86, $00, $00, $00,
    $81, $FE, $D8, $00, $00, $00, $7E, $05, $BE, $D8, $00, $00, $00, $DC, $15, $3C, $35, $9F,
    $00, $9B, $DF, $E0, $9E, $B8, $00, $00, $00, $00, $72, $0E, $E8, $1F, $01, $00, $00, $83,
    $F8, $23, $0F, $8F, $38, $FF, $FF, $FF, $40, $8B, $D4, $50, $03, $C6, $E8, $A1, $00, $00,
    $00, $58, $8B, $D6, $8B, $F4, $80, $3E, $30, $74, $02, $40, $4E, $46, $8B, $C8, $03, $CF,
    $85, $D2, $74, $09, $41, $03, $CA, $3B, $D9, $7F, $02, $8B, $D9, $50, $57, $8B, $BC, $24,
    $08, $01, $00, $00, $88, $1F, $47, $2B, $D9, $8B, $CB, $7E, $04, $B0, $20, $F3, $AA, $28,
    $4F, $FF, $58, $59, $85, $C0, $74, $04, $C6, $07, $2D, $47, $F3, $A4, $85, $D2, $74, $08,
    $C6, $07, $2E, $47, $8B, $CA, $F3, $A4, $81, $C4, $00, $01, $00, $00, $59, $5F, $5E, $5B,
    $C2, $0C, $00, $DD, $D8, $81, $7C, $24, $04, $00, $00, $00, $80, $BE, $1A, $37, $9F, $00,
    $75, $0D, $4F, $BE, $1E, $37, $9F, $00, $75, $05, $BE, $23, $37, $9F, $00, $8B, $F9, $8B,
    $CB, $88, $0F, $47, $2A, $0E, $76, $04, $B0, $20, $F3, $AA, $28, $4F, $FF, $8A, $0E, $46,
    $F3, $A4, $EB, $BC, $03, $4E, $61, $6E, $04, $2B, $49, $6E, $66, $04, $2D, $49, $6E, $66,
    $57, $8B, $FA, $8B, $C8, $83, $EC, $0A, $C6, $07, $30, $DC, $0D, $44, $35, $9F, $00, $D9,
    $FC, $DC, $15, $4C, $35, $9F, $00, $9B, $DF, $E0, $9E, $72, $09, $DC, $25, $4C, $35, $9F,
    $00, $C6, $07, $31, $DF, $34, $24, $BA, $08, $00, $00, $00, $47, $9B, $8A, $04, $14, $8A,
    $E0, $C0, $E8, $04, $80, $E4, $0F, $66, $05, $30, $30, $66, $AB, $4A, $79, $EB, $83, $E9,
    $12, $7C, $06, $B0, $30, $F3, $AA, $EB, $14, $03, $F9, $80, $3F, $35, $7C, $0D, $4F, $FE,
    $07, $80, $3F, $39, $7E, $05, $C6, $07, $30, $EB, $F3, $83, $C4, $0A, $5F, $C3, $53, $83,
    $EC, $0C, $33, $DB, $D9, $C0, $DB, $3C, $24, $66, $8B, $44, $24, $08, $66, $85, $C0, $74,
    $22, $66, $2D, $FF, $3F, $66, $BA, $10, $4D, $66, $F7, $EA, $0F, $BF, $C2, $F7, $D8, $74,
    $09, $2B, $D8, $E8);
  strextObjSize = $284;
  strextProcs: array[0..2] of THCProc =
    ((R: $0; N: 'Str0Ext'), (R: $C; N: 'str1ext'), (R: $13; N: 'str2ext'));

  writerecObj: array[0..29] of Byte = (
    $53, $8B, $D8, $8B, $40, $04, $2D, $B2, $D7, $00, $00, $83, $F8, $01, $77, $2B, $6A, $00,
    $8B, $C4, $6A, $00, $50, $FF, $73, $08, $52, $FF, $33, $E8);
  writerecObjSize = $48;
  writerecProcs: array[0..0] of THCProc =
    ((R: $0; N: '@WriteRec'));

  valextObj: array[0..216] of Byte = (
    $53, $56, $57, $8B, $F0, $50, $D9, $EE, $33, $C0, $33, $DB, $33, $FF, $53, $85, $F6, $0F,
    $84, $DB, $00, $00, $00, $8A, $1E, $46, $80, $FB, $20, $74, $F8, $B5, $00, $80, $FB, $2D,
    $74, $07, $80, $FB, $2B, $74, $04, $EB, $05, $FE, $C5, $8A, $1E, $46, $84, $DB, $0F, $84,
    $B9, $00, $00, $00, $80, $EB, $30, $80, $FB, $09, $77, $18, $DC, $0D, $E9, $35, $9F, $00,
    $89, $1C, $24, $DA, $04, $24, $8A, $1E, $46, $84, $DB, $75, $E5, $EB, $7D, $90, $90, $90,
    $80, $FB, $FE, $75, $25, $8A, $1E, $46, $84, $DB, $74, $6E, $80, $EB, $30, $80, $FB, $09,
    $77, $16, $DC, $0D, $E9, $35, $9F, $00, $89, $1C, $24, $DA, $04, $24, $48, $8A, $1E, $46,
    $84, $DB, $75, $E4, $EB, $50, $80, $FB, $15, $74, $05, $80, $FB, $35, $75, $65, $8A, $1E,
    $46, $B4, $00, $80, $FB, $2D, $74, $07, $80, $FB, $2B, $74, $04, $EB, $05, $FE, $C4, $8A,
    $1E, $46, $80, $EB, $30, $80, $FB, $09, $77, $47, $8B, $FB, $8A, $1E, $46, $84, $DB, $74,
    $16, $80, $EB, $30, $80, $FB, $09, $77, $36, $8D, $3C, $BF, $03, $FF, $03, $FB, $8A, $1E,
    $46, $84, $DB, $75, $EA, $FE, $CC, $75, $02, $F7, $DF, $0F, $BE, $C0, $03, $C7, $52, $51,
    $E8);
  valextObjSize = $101;
  valextProcs: array[0..0] of THCProc =
    ((R: $0; N: 'ValExt'));

  pow10Obj: array[0..$1B] of Byte = (
    $85, $C0, $7C, $48, $74,
    $45, $3D, $00, $14, $00, $00, $0F, $8D, $7F, $00, $00, $00, $8B, $D0, $83, $E2, $1F, $8D,
    $14, $92, $DB, $2C, $55);
  pow10ObjSize = $2d4;
  pow10Procs: array[0..0] of THCProc =
    ((R: $0; N: 'FPower10'));

  Real2extObj: array[0..44] of Byte = (
    $8A, $70, $05, $80, $E6, $80, $8A, $10, $84, $D2, $74, $1E, $66, $81, $C2, $7E, $3F, $52,
    $8B, $50, $02, $81, $CA, $00, $00, $00, $80, $52, $8A, $50, $01, $C1, $E2, $18, $52, $DB,
    $2C, $24, $83, $C4, $0C, $C3, $D9, $EE, $C3);
  Real2extObjSize = $30;
  Real2extProcs: array[0..0] of THCProc =
    ((R: $0; N: '@Real2Ext'));

  ext2realObj: array[0..69] of Byte = (
    $53, $83, $EC, $0C, $DB, $3C, $24, $5B,
    $5A, $59, $C1, $EB, $18, $80, $D3, $00, $83, $D2, $00, $66, $83, $D1, $00, $70, $29, $03,
    $D2, $66, $03, $C9, $D1, $DA, $66, $D1, $E9, $66, $81, $E9, $7E, $3F, $7E, $0E, $84, $ED,
    $7F, $14, $88, $08, $88, $58, $01, $89, $50, $02, $5B, $C3, $33, $C9, $89, $08, $66, $89,
    $48, $04, $5B, $C3, $5B, $B0, $08, $E9);
  ext2realObjSize = $4C;
  ext2realProcs: array[0..0] of THCProc =
    ((R: $0; N: '@Ext2Real'));

  _llObj: array[0..$286] of Byte = (
    $52, $50, $8B, $44, $24, $10, $F7, $24, $24, $8B, $C8, $8B, $44, $24, $04, $F7, $64, $24,
    $0C, $03, $C8, $8B, $04, $24, $F7, $64, $24, $0C, $03, $D1, $59, $59, $C2, $08, $00, $52,
    $50, $8B, $44, $24, $10, $F7, $24, $24, $8B, $C8, $8B, $44, $24, $04, $F7, $64, $24, $0C,
    $03, $C8, $8B, $04, $24, $F7, $64, $24, $0C, $03, $D1, $59, $59, $C2, $08, $00, $55, $53,
    $56, $57, $33, $FF, $8B, $5C, $24, $14, $8B, $4C, $24, $18, $0B, $C9, $75, $08, $0B, $D2,
    $74, $5C, $0B, $DB, $74, $58, $0B, $D2, $79, $0A, $F7, $DA, $F7, $D8, $83, $DA, $00, $83,
    $CF, $01, $0B, $C9, $79, $0A, $F7, $D9, $F7, $DB, $83, $D9, $00, $83, $F7, $01, $8B, $E9,
    $B9, $40, $00, $00, $00, $57, $33, $FF, $33, $F6, $D1, $E0, $D1, $D2, $D1, $D6, $D1, $D7,
    $3B, $FD, $72, $0B, $77, $04, $3B, $F3, $72, $05, $2B, $F3, $1B, $FD, $40, $E2, $E7, $5B,
    $F7, $C3, $01, $00, $00, $00, $74, $07, $F7, $DA, $F7, $D8, $83, $DA, $00, $5F, $5E, $5B,
    $5D, $C2, $08, $00, $F7, $F3, $33, $D2, $EB, $F3, $56, $8B, $74, $24, $0C, $23, $74, $24,
    $08, $83, $FE, $FF, $75, $11, $8B, $F0, $0B, $F2, $81, $FE, $00, $00, $00, $80, $75, $05,
    $8B, $C6, $5E, $48, $C3, $5E, $FF, $74, $24, $08, $FF, $74, $24, $08, $E8, $5B, $FF, $FF,
    $FF, $23, $C0, $C2, $08, $00, $55, $53, $56, $57, $8B, $5C, $24, $14, $8B, $4C, $24, $18,
    $0B, $C9, $75, $08, $0B, $D2, $74, $2F, $0B, $DB, $74, $2B, $8B, $E9, $B9, $40, $00, $00,
    $00, $33, $FF, $33, $F6, $D1, $E0, $D1, $D2, $D1, $D6, $D1, $D7, $3B, $FD, $72, $0B, $77,
    $04, $3B, $F3, $72, $05, $2B, $F3, $1B, $FD, $40, $E2, $E7, $5F, $5E, $5B, $5D, $C2, $08,
    $00, $F7, $F3, $33, $D2, $EB, $F3, $55, $53, $56, $57, $33, $FF, $8B, $5C, $24, $14, $8B,
    $4C, $24, $18, $0B, $C9, $75, $08, $0B, $D2, $74, $5D, $0B, $DB, $74, $59, $0B, $D2, $79,
    $0A, $F7, $DA, $F7, $D8, $83, $DA, $00, $83, $CF, $01, $0B, $C9, $79, $07, $F7, $D9, $F7,
    $DB, $83, $D9, $00, $8B, $E9, $B9, $40, $00, $00, $00, $57, $33, $FF, $33, $F6, $D1, $E0,
    $D1, $D2, $D1, $D6, $D1, $D7, $3B, $FD, $72, $0B, $77, $04, $3B, $F3, $72, $05, $2B, $F3,
    $1B, $FD, $40, $E2, $E7, $8B, $C6, $8B, $D7, $5B, $F7, $C3, $01, $00, $00, $00, $74, $07,
    $F7, $DA, $F7, $D8, $83, $DA, $00, $5F, $5E, $5B, $5D, $C2, $08, $00, $F7, $F3, $92, $33,
    $D2, $EB, $F2, $56, $8B, $74, $24, $0C, $23, $74, $24, $08, $83, $FE, $FF, $75, $11, $8B,
    $F0, $0B, $F2, $81, $FE, $00, $00, $00, $80, $75, $05, $8B, $C6, $5E, $48, $C3, $5E, $FF,
    $74, $24, $08, $FF, $74, $24, $08, $E8, $59, $FF, $FF, $FF, $23, $C0, $C2, $08, $00, $55,
    $53, $56, $57, $8B, $5C, $24, $14, $8B, $4C, $24, $18, $0B, $C9, $75, $08, $0B, $D2, $74,
    $33, $0B, $DB, $74, $2F, $8B, $E9, $B9, $40, $00, $00, $00, $33, $FF, $33, $F6, $D1, $E0,
    $D1, $D2, $D1, $D6, $D1, $D7, $3B, $FD, $72, $0B, $77, $04, $3B, $F3, $72, $05, $2B, $F3,
    $1B, $FD, $40, $E2, $E7, $8B, $C6, $8B, $D7, $5F, $5E, $5B, $5D, $C2, $08, $00, $F7, $F3,
    $92, $33, $D2, $EB, $F2, $80, $F9, $20, $7C, $11, $80, $F9, $40, $7C, $05, $33, $D2, $33,
    $C0, $C3, $8B, $D0, $D3, $E2, $33, $C0, $C3, $0F, $A5, $C2, $D3, $E0, $C3, $80, $F9, $20,
    $7C, $11, $80, $F9, $40, $7C, $06, $C1, $FA, $1F, $8B, $C2, $C3, $8B, $C2, $99, $D3, $F8,
    $C3, $0F, $AD, $D0, $D3, $FA, $C3, $80, $F9, $20, $7C, $11, $80, $F9, $40, $7C, $05, $33,
    $D2, $33, $C0, $C3, $8B, $C2, $33, $D2, $D3, $E8, $C3, $0F, $AD, $D0, $D3, $EA, $C3);
  _llObjSize = $288;
  _llProcs: array[0..10] of THCProc =
    ((R: $0; N: '@_llmul'), (R:$23; N: '@_llmulo'), (R: $46; N: '@_lldiv'),
    (r: $BE; N: '@_lldivo'), (R:$139; N: '@_llmod'), (R: $1b3; N: '@_llmodo'),
    (R: $1E5; N: '@_llumod'), (R:$233; N: '@_llshl'), (R: $24f; N: '@_llshr'),
    (R: $26b; N: '@_llushr'), (R:$f0; N: '@_lludiv'));

  Readint64ObjA: array[$41..$54] of Byte = (
    $83, $C4, $24, $5F, $5E, $5B, $C3, $3C, $1A, $74, $D9, $FF, $4E, $0C, $EB, $D4, $33,
    $C0, $EB, $EC);
  readint64ObjB: array[$32..$32] of Byte = ($59);
  readint64ObjSize = $58;
  readint64Procs: array[0..0] of THCProc =
    ((R: $0; N: '@ReadInt64'));

  // String Consts.
  
  OldLocaleOverrideKeyConstSig: array[0..$1B] of Byte = (
    $53, $6F, $66, $74, $77, $61, $72, $65, $5C, $42, $6F, $72, $6C, $61, $6E, $64, $5C, $4C,
    $6F, $63, $61, $6C, $65, $73, $00, $00, $00, $00);
  OldLocaleOverrideKeyConstSize = $1C;
  OldLocaleOverrideKeyConstName = 'OldLocaleOverrideKey';

  NewLocaleOverrideKeyConstSig: array[0..$1F] of Byte = (
    $53, $6F, $66, $74, $77, $61, $72, $65, $5C, $42, $6F, $72, $6C, $61, $6E, $64, $5C, $44,
    $65, $6C, $70, $68, $69, $5C, $4C, $6F, $63, $61, $6C, $65, $73, $00);
  NewLocaleOverrideKeyConstSize = $20;
  NewLocaleOverrideKeyConstName = 'NewLocaleOverrideKey';

  // FFMT.OBJ  in SysUtils.pas.

  SysUtilsHCBlockRA: array[0..3] of TRA = (
    (RA: $7AF; PN: 'TextToFloat'; CN: '';
       Source: '{$L FFMT.OBJ}'#10#13'procedure TextToFloat; external;'),
    (RA: $5BE; PN: 'FloatToDecimal';
       Source: 'procedure FloatToDecimal; external;'),
    (RA: $2EB; PN: 'FloatToTextFmt';
       Source: 'procedure FloatToTextFmt; external;'),
    (RA: $22; PN: 'FloatToText';
       Source: 'procedure FloatToText; external;'));
  SysUtilsHCBlockVars: array[0..4] of TCVar = (
    (RA: $151; VN: 'DecimalSeparator'),
    (RA: $1F6; VN: 'ThousandSeparator'),
    (RA: $278; VN: 'CurrencyString'),
    (RA: $233; VN: 'NegCurrFormat'),
    (RA: $222; VN: 'CurrencyFormat'));
  SysUtilsHCBlockVal0: array[0..23] of byte = (
    $55, $8B, $EC, $83, $EC, $06, $57, $56, $53, $8B, $F0, $8B, $FA, $8B, $D9, $9B,
    $D9, $7D, $FA, $9B, $DB, $E2, $D9, $2D);
  SysUtilsHCBlockVal1: array[0..2] of byte = (
    $D9, $EE, $E8);
  SysUtilsHCBlockVal2: array[0..15] of byte = (
    $8A, $3E, $80, $FF, $2B, $74, $05, $80, $FF, $2D, $75, $01, $46, $8B, $CE, $E8);
  SysUtilsHCBlockVal3: array[0..5] of byte = (
    $33, $D2, $8A, $06, $3A, $05);
  SysUtilsHCBlockVal4: array[0..3] of byte = (
    $75, $08, $46, $E8);
  SysUtilsHCBlockVal5: array[0..16] of byte = (
    $F7, $DA, $3B, $CE, $74, $4A, $8A, $06, $24, $DF, $3C, $45, $75, $0A, $46, $52,
    $E8);
  SysUtilsHCBlockVal6: array[0..3] of byte = (
    $58, $03, $D0, $E8);
  SysUtilsHCBlockVal7: array[0..15] of byte = (
    $80, $3E, $00, $75, $2E, $8B, $C2, $80, $FB, $01, $75, $03, $83, $C0, $04, $E8);
  SysUtilsHCBlockVal8: array[0..48] of byte = (
    $80, $FF, $2D, $75, $02, $D9, $E0, $80, $FB, $00, $74, $04, $DF, $3F, $EB, $02,
    $DB, $3F, $9B, $DF, $E0, $66, $A9, $09, $00, $75, $06, $B0, $01, $EB, $04, $DD,
    $D8, $33, $C0, $9B, $DB, $E2, $D9, $6D, $FA, $9B, $5B, $5E, $5F, $8B, $E5, $5D,
    $C3);
  SysUtilsHCBlockVal: array[0..8] of TVal = (
    (RA: $7af; Count: length(SysUtilsHCBlockVal0); Val: @SysUtilsHCBlockVal0),
    (RA: $7cb; Count: length(SysUtilsHCBlockVal1); Val: @SysUtilsHCBlockVal1),
    (RA: $7d2; Count: length(SysUtilsHCBlockVal2); Val: @SysUtilsHCBlockVal2),
    (RA: $7e6; Count: length(SysUtilsHCBlockVal3); Val: @SysUtilsHCBlockVal3),
    (RA: $7f0; Count: length(SysUtilsHCBlockVal4); Val: @SysUtilsHCBlockVal4),
    (RA: $7f8; Count: length(SysUtilsHCBlockVal5); Val: @SysUtilsHCBlockVal5),
    (RA: $80d; Count: length(SysUtilsHCBlockVal6); Val: @SysUtilsHCBlockVal6),
    (RA: $815; Count: length(SysUtilsHCBlockVal7); Val: @SysUtilsHCBlockVal7),
    (RA: $829; Count: length(SysUtilsHCBlockVal8); Val: @SysUtilsHCBlockVal8));
  SysUtilsHCBlock: THCBlock = (
    Size: $8B0;
    RAC: length(SysUtilsHCBlockRA); RA: @SysUtilsHCBlockRA;
    ValC: length(SysUtilsHCBlockVal); Val: @SysUtilsHCBlockVal;
    VarsC: Length(SysUtilsHCBlockVars); Vars: @SysUtilsHCBlockVars;
    IAC: 0; IA: nil;
    PRC: 0; PR: nil);

  HCBlockCount = 210;

  HCBlocks: array[0..HCBlockCount] of PHCBlock = (
    @HCBlock0, @HCBlock1, @HCBlock2, @HCBlock3, @HCBlock4, @HCBlock5, @HCBlock6, @HCBlock7,
    @HCBlock8, @HCBlock9, @HCBlock10, @HCBlock11, @HCBlock12, @HCBlock13, @HCBlock14, @HCBlock15,
    @HCBlock16, @HCBlock17, @HCBlock18, @HCBlock19, @HCBlock20, @HCBlock21, @HCBlock22, @HCBlock23,
    @HCBlock24, @HCBlock25, @HCBlock26, @HCBlock27, @HCBlock28, @HCBlock29, @HCBlock30, @HCBlock31,
    @HCBlock32, @HCBlock33, @HCBlock34, @HCBlock35, @HCBlock36, @HCBlock37, @HCBlock38, @HCBlock39,
    @HCBlock40, @HCBlock41, @HCBlock42, @HCBlock43, @HCBlock44, @HCBlock45, @HCBlock46, @HCBlock47,
    @HCBlock48, @HCBlock49, @HCBlock50, @HCBlock51, @HCBlock52, @HCBlock53, @HCBlock54, @HCBlock55,
    @HCBlock56, @HCBlock57, @HCBlock58, @HCBlock59, @HCBlock60, @HCBlock61, @HCBlock62, @HCBlock63,
    @HCBlock64, @HCBlock66, @HCBlock67, @HCBlock68, @HCBlock69, @HCBlock70, @HCBlock71,
    @HCBlock72, @HCBlock73, @HCBlock74, @HCBlock75, @HCBlock77, @HCBlock78, @HCBlock79,
    @HCBlock80, @HCBlock81, @HCBlock82, @HCBlock83, @HCBlock84, @HCBlock85, @HCBlock86, @HCBlock87,
    @HCBlock88, @HCBlock89, @HCBlock90, @HCBlock91, @HCBlock92, @HCBlock93, @HCBlock94, @HCBlock95,
    @HCBlock96, @HCBlock97, @HCBlock98, @HCBlock99, @HCBlock100, @HCBlock101, @HCBlock102, @HCBlock103,
    @HCBlock104, @HCBlock105, @HCBlock106, @HCBlock107, @HCBlock108, @HCBlock109, @HCBlock110,
    @HCBlock111, @HCBlock112, @HCBlock113, @HCBlock114, @HCBlock115, @HCBlock116, @HCBlock117,
    @HCBlock118, @HCBlock119, @HCBlock120, @HCBlock121, @HCBlock122, @HCBlock123, @HCBlock124,
    @HCBlock125, @HCBlock127, @HCBlock128, @HCBlock129, @HCBlock130, @HCBlock131, @HCBlock132,
    @HCBlock133, @HCBlock134, @HCBlock135, @HCBlock136, @HCBlock137, @HCBlock138, @HCBlock139,
    @HCBlock140, @HCBlock141, @HCBlock142, @HCBlock143, @HCBlock144, @HCBlock145, @HCBlock146,
    @HCBlock147, @HCBlock148, @HCBlock149, @HCBlock150, @HCBlock151, @HCBlock152, @HCBlock153,
    @HCBlock154, @HCBlock155, @HCBlock156, @HCBlock157, @HCBlock158, @HCBlock159, @HCBlock160,
    @HCBlock161, @HCBlock162, @HCBlock163, @HCBlock164, @HCBlock165, @HCBlock166, @HCBlock167,
    @HCBlock168, @HCBlock169, @HCBlock170, @HCBlock171, @HCBlock172, @HCBlock173, @HCBlock174,
    @HCBlock175, @HCBlock176, @HCBlock177, @HCBlock178, @HCBlock179, @HCBlock180, @HCBlock181,
    @HCBlock182, @HCBlock183, @HCBlock184, @HCBlock185, @HCBlock186, @HCBlock187, @HCBlock188,
    @HCBlock189, @HCBlock190, @HCBlock191, @HCBlock192, @HCBlock193, @HCBlock194, @HCBlock195,
    @HCBlock196, @HCBlock196, @HCBlock197, @HCBlock198, @HCBlock199, @HCBlock200, @HCBlock201,
    @HCBlock202, @HCBlock203, @HCBlock204, @HCBlock205, @HCBlock206, @HCBlock207, @HCBlock209,
    @HCBlock208, @HCBlock210, @HCBlock211, @HCBlock212);

implementation

end.
