unit MainForm;

interface

uses
  PEFileClass, PEFile, Controls, ExtCtrls, StdCtrls, ComCtrls, Classes, Forms;

type
  TDecompilerFrm = class(TForm)
    pcInfoPages: TPageControl;
    tsClasses: TTabSheet;
    lvClasses: TListView;
    tsTypeInfos: TTabSheet;
    lvTypeInfos: TListView;
    tsProcs: TTabSheet;
    lvProcs: TListView;
    tsUnits: TTabSheet;
    lvUnits: TListView;
    tsInterfaces: TTabSheet;
    lvInterfaces: TListView;
    tsStrings: TTabSheet;
    lvStrings: TListView;
    tsVars: TTabSheet;
    lvVars: TListView;
    meProcInstr: TMemo;
    meClassDef: TMemo;
    meUnitSrc: TMemo;
    pBottom: TPanel;
    btnSaveFiles: TButton;
    procedure lvProcsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure lvClassesSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure lvUnitsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure btnSaveFilesClick(Sender: TObject);
  private
    { Private declarations }
    FPEFile: TPEFileClass;
    procedure SetPEFile(Value: TPEFileClass);
  public
    { Public declarations }
    property PEFile: TPEFileClass read FPEFile write SetPEFile;
  end;

var
  DecompilerFrm: TDecompilerFrm;

implementation

uses
  TypInfo, Procs, DisAsm, dcUnits, peExports, FileCtrl,
  SysUtils, ComObj, StatusForm;

{$R *.DFM}

procedure TDecompilerFrm.SetPEFile(Value: TPEFileClass);
var
  I, J: Integer;
  Str: string;
begin
  FPEFile := Value;
  begin
    lvUnits.Items.BeginUpdate;
    lvStrings.Items.BeginUpdate;
    LvVars.Items.BeginUpdate;
    lvClasses.Items.BeginUpdate;
    try
      lvTypeInfos.Items.BeginUpdate;
      try
        lvProcs.Items.BeginUpdate;
        try
          lvClasses.Items.Clear;
          lvTypeInfos.Items.Clear;
          lvProcs.Items.Clear;
          lvUnits.Items.Clear;
          lvStrings.Items.Clear;
          for I := 0 to PEFile.Classes.Count -1 do
            with lvClasses.Items.Add do
            begin
              Caption := Format('$%p', [Pointer(PEFile.Classes[I].AClass)]);
              SubItems.Add(PEFile.Classes[I].AClass.ClassName);
              Str := '';
              for J := 0 to PEFile.Classes[I].InterfaceCount -1 do
                Str := Str + GUIDToString(PEFile.Classes[I].Interfaces[J].GUID);
              SubItems.Add(Str);
              SubItems.Add(Format('$%p', [Pointer(PEFile.Classes[I].Address)]));
              SubItems.Add(IntToStr(PEFile.Classes[I].Size));
              Data := PEFile.Classes[I];
            end;
          for I := 0 to PEFile.TypeInfos.Count -1 do
            with lvTypeInfos.Items.Add do
            begin               
              Caption := Format('$%p', [PEFile.TypeInfos[I].TypeInfo]);
              SubItems.Add(PEFile.TypeInfos[I].TypeInfo.Name);
              SubItems.Add(Format('$%p', [Pointer(PEFile.TypeInfos[I].Address)]));
              SubItems.Add(IntToStr(PEFile.TypeInfos[I].Size));
              Data := PEFile.TypeInfos[I];
            end;
          for I := 0 to PEFile.Procs.Count -1 do
            with lvProcs.Items.Add do
            begin
              Caption := Format('$%p', [Pointer(PEFile.Procs[I].Address), PEFile.Procs[I].Name]);
              SubItems.Add(IntToHex(PEFile.Procs[I].Size, 4));
              SubItems.Add(PEFile.Procs[I].Name);
              Str := '';
              case PEFile.Procs[I].ProcType of
                ptProcedure: Str := 'proc, ';
                ptClassProcedure: Str := Str + 'class proc, ';
                ptMethodProcedure: Str := Str + 'Method proc, ';
                ptConstructor  : Str := Str + 'Constructor, ';
                ptDestructor: Str := Str + 'Destructor';
                ptInitialization: Str := Str + 'Initilization';
                ptFinalization: Str := Str + 'Finalization';
                ptEntryPointProc: Str := Str + 'EntryPointProc';
              end;
              SubItems.Add(Str);
              if PEFile.Procs[I].AClass <> nil then
                SubItems.Add(PEFile.Procs[I].AClass.AClass.ClassName)
              else
                SubItems.Add('');
              case PEFile.Procs[I].MethodBindingType of
                mbtVirtual: SubItems.Add('Virtual');
                mbtDynamic: SubItems.Add('Dynamic');
                mbtStatic: SubItems.Add('Static');
              end;
              if PEFile.Procs[I].MethodBindingType <> mbtStatic then
                SubItems.Add(Format('%d', [PEFile.Procs[I].MethodIndex]))
              else
                SubItems.Add('');
              if PEFile.Procs[I].ImportInfo.Imported then
              begin
                SubItems.Add(PEFile.Procs[I].ImportInfo.DLLName);
                if PEFIle.Procs[I].ImportInfo.Entry.NameOrID = niName then
                  SubItems.Add(PEFile.Procs[I].ImportInfo.Entry.Name)
                else
                  SubItems.Add(IntToStr(PEFIle.Procs[I].ImportInfo.Entry.ID));
              end
              else
              begin
                SubItems.Add('');
                SubItems.Add('');
              end;
              case PEFile.Procs[I].AppendBefore of
                atMust: SubItems.Add('must');
                atMay: SubItems.Add('may');
                atMayNot: SubItems.Add('not may');
              end;
              case PEFile.Procs[I].AppendAfter of
                atMust: SubItems.Add('must');
                atMay: SubItems.Add('may');
                atMayNot: SubItems.Add('not may');
              end;
              Data := Pointer(PEFile.Procs[I]);
            end;
          for I := 0 to PEFIle.Units.Count -1 do
            with lvUnits.Items.Add do
            begin
              Caption := Format('$%p', [Pointer(PEFile.Units[I].Address)]);
              SubItems.Add(Format('%x', [PEFile.Units[I].Size]));
              SubItems.Add(PEFile.Units[I].Name);
              Data := PEFile.Units[I];
            end;
{          for I := 0 to PEFile.Interfaces.Count -1 do
          begin
            with lvInterfaces.Items.Add do
            begin
              Caption := IntToStr(PEFile.Interfaces[I].MethodCount);
              SubItems.Add(GUIDToString(PEFile.Interfaces[I].GUID));
            end;
          end;}
          for I := 0 to PEFile.StringInfos.Count -1 do
          begin
            with lvStrings.Items.Add do
            begin
              Caption := Format('$%p', [Pointer(PEFile.StringInfos[I].Address)]);
              SubItems.Add(EnhQuotedStr(PEFile.StringInfos[I].Value));
            end;
          end;

          for I := 0 to PEFile.VarInfos.Count -1 do
          begin
            with lvVars.Items.Add do
            begin
              Caption := Format('$%p', [Pointer(PEFile.VarInfos[I].Address)]);
              SubItems.Add(Format('%x', [PEFile.VarInfos[I].Size]));
              if PEFile.VarInfos[I].AUnit <> nil then
                SubItems.Add((PEFile.VarInfos[I].AUnit as TUnit).Name)
              else
                SubItems.Add('');
              SubItems.Add(PEFile.VarInfos[I].Name);
            end;
          end;
        finally
          lvProcs.Items.EndUpdate;
        end;
      finally
        lvTypeInfos.Items.EndUpdate;
      end;
    finally
      lvClasses.Items.EndUpdate;
      LvVars.Items.EndUpdate;
      lvStrings.Items.EndUpdate;
      lvUnits.Items.EndUpdate;
    end;
  end;
end;

procedure TDecompilerFrm.lvProcsSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
begin
  if Selected then
    meProcInstr.Lines := TProc(Item.Data).Instr.Text;
end;

procedure TDecompilerFrm.lvClassesSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
begin
  if Selected then
    meClassDef.Lines := TClassInfo(Item.Data).ClassDef
  else
    meClassDef.Lines.Clear;
end;

procedure TDecompilerFrm.lvUnitsSelectItem(Sender: TObject;
  Item: TListItem; Selected: Boolean);
begin
  if Selected then
    meUnitSrc.Lines := TUnit(Item.Data).UnitSrc
  else
    meUnitSrc.Lines.Clear;
end;

procedure TDecompilerFrm.FormCreate(Sender: TObject);
begin
  DecompilerFrm := Self;
end;

procedure TDecompilerFrm.FormDestroy(Sender: TObject);
begin
  DecompilerFrm := nil;
end;

procedure TDecompilerFrm.btnSaveFilesClick(Sender: TObject);
var
  ADir: string;
begin
  if SelectDirectory('Select the output directory.', ADir, ADir) then
  begin
    Screen.Cursor := crHourglass;
    try
      DecompThread.Dir := ADir;
      DecompThread.SaveFiles;
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

end.
