
//========================================================\\
//                                                        \\
//      Last Compilation Date component                   \\
//      Written By Alek Shamrai, September 1997           \\
//      (mailto: alexsh@adm.univd.kharkov.ua)             \\
//                                                        \\
//      If you like it, just be happy, if no ... 	  \\
//      (anyway keep coding!)                             \\
//                                                        \\
//========================================================\\

unit LCDate;

interface

uses
  Classes, SysUtils;

type
  TLCDate = class(TComponent)
  private
    { Private declarations }
    fLCDate: tDateTime;
    fAU_LCD: Boolean;
    function GetLCDate: tDateTime;
  protected
    { Protected declarations }
    procedure Loaded; override;
  public
    { Public declarations }
    constructor Create(aOwner: tComponent); override;
  published
    { Published declarations }
    property LCDate: tDateTime read GetLCDate write fLCDate;
    property AU_LCD: Boolean read fAU_LCD write fAU_LCD default True;
  end;

procedure Register;

implementation

  { tLCDate }

constructor tLCDate.Create(aOwner: tComponent);
begin
  inherited;
  AU_LCD := True;
end;

procedure tLCDate.Loaded;
begin
  inherited;
  if (csDesigning in ComponentState) then begin
    if AU_LCD then LCDate := Now;
  end;
end;

function tLCDate.GetLCDate: tDateTime;
begin
  if (csWriting in ComponentState) and AU_LCD then LCDate := Now;
  Result := fLCDate;
end;

  // registration

procedure Register;
begin
  RegisterComponents('AlexSh', [TLCDate]);
end;

end.
