
// AlexSh@Adm.Univd.Kharkov.UA

(*

  Alek's home tools.

  History:
  ~~~~~~~~

    [+] -- added;
    [*] -- fixed;
    [-] -- removed;

    13 December 1997:
      [+] function SelectFolder(aHandle: tHandle; const aRoot, aMsg: string): string;
      [+] function  GetRegStr(const aAppName, aKeyName, aDefValue: string): string;
      [+] procedure SetRegStr(const aAppName, aKeyName, aKeyValue: string);
    21 December 1997:
      [+] tFileMappingRecord;
      [+] function NewFileMapping(const aFileName: string; var aFMR: tFileMappingRecord): Boolean;
      [+] function FreeFileMapping(var aFMR: tFileMappingRecord): Boolean;
      [+] function SeekBuf(Buf1: Pointer; Buf1Size: Integer; Buf2: Pointer; Buf2Size: Integer): Integer;
      [+] function SeekStr(aBuf: Pointer; aBufSize: Integer; const aStr: string; IgnoreCase: Boolean): Integer;
    25/26 December 1997:
      [*] bug in SeekStr;
    26 December 1997:
      [*] GetRegStr now will not create key if it doesn't exists;
    12 JAN 1998
      [+] finction AddBackSlash(const aPath: string): string;
    27 JAN 1998
      [+] function AskYN(const aMsg: string): Boolean;
      [+] function AskYNC(const aMsg: string): Integer;
    04 MAR 1998
      [+] function Str2Int(const aStr: string; aDefValue: Integer): Integer;
    15? MAR 1998
      [+] function ReadTextFile(const aFileName: string): string;
      [+] function AddTextToFile(const aFileName, aText: string; AddCRLF: Boolean): Boolean;
    05 APR 1998
      [*] another bug in SeekStr -- wrong detection of buffer's end
      [+] function ParseString(const aString: string; aVChar: Char; aValues: tStrings);
    12 APR 1998
      [+] procedure SetRegInt(const aAppName, aKeyName: string; aKeyValue: Integer);
      [+] function  GetRegInt(const aAppName, aKeyName: string; aDefValue: Integer): Integer;
    20 APR 1998
      [+] function Min(A, B: Integer): Integer;
      [+] function Max(A, B: Integer): Integer;
    22 APR 1998
      [*] Trim added in Str2Int for universality
    30 APR 1998
      [+] function Date2Str(aDate: tDateTime): string;
    04 MAY 1998
      [+] function RegLoadFont(aFont: tFont; const aRegAppName: string): Boolean;
      [+] function RegSaveFont(aFont: tFont; const aRegAppName: string): Boolean;
    05 MAY 1998
      [+] procedure RegSaveControl(aControl: tControl; const anAppName: string);
      [+] function RegLoadControl(aControl: tControl; const anAppName: string): Boolean;
    MAY/JUN 1998
      [+] function Hex2Int(const S: string): Integer;
      [+] function Str2ASCII(const aStr: string): string;
      [+] function ASCII2Str(const aStr: string): string;
      [+] procedure ParsePasConsts(const aConsts: string; aList: tStrings);
      [+] function Date2EngStr(aDate: tDateTime): string;
      [+] function IsGoodSubStr(aSubStr: string; const aStr: string; Poss: tList; out FirstMatch: string): Boolean;
    12 JUN 1998
      [+] function EngStr2Date(const aStr: string): Integer;
    26 JUN 1998
      [+] function Base64Code(const aInput: string): string;
      [+] function Base64Decode(const aInput: string): string;
    18 JUL 1998
      [+] procedure SetWindowULong(aHandle: tHandle; aLong: Integer);
      [+] function FindWindowULong(ProgID: Integer): hWnd;
    01 AUG 1998
      [*] fixed several bugs in SelectFolder (bugs appear only in Delphi 4!)

*)

unit HomeTool;

interface

uses
  Windows, Classes, Graphics, Controls;

// show "standar"
// aHandle -- handle of the owner window for the dialog box. Can be 0;
// aRoot -- location of the "root" folder to browse from.
//   Only the specified by aRoot folder and its subfolders appear in the dialog box.
//   This member can be '', and in that case, the name space root (the desktop folder) is used;
// aMsg -- string that is displayed above the tree view control in the dialog box.
//   This string can be used to specify instructions to the user;
// Result -- if user chooses the Cancel button in the dialog box, the return value is '',
//   else result is selected folder;
function SelectFolder(aHandle: tHandle; const aRoot, aMsg: string): string;

type
  pBytes = ^tBytes;
  tBytes = array[0..High(Integer)-16] of Byte;

  // this record is used to store and access created file mappings
  tFileMappingRecord = record
    fFileHandle	: tHandle;
    fFileMapping: tHandle;
    case Integer of
      1: (fFileBase: Pointer);
      2: (fBytes   : pBytes);
  end;

// creates new file mapping (contents of file can be accessed by pointer);
//  aFileName -- file name to create mapping of;
//  aFMR -- if Result is true you can use aFMR.fFileBase to access file contents
function NewFileMapping(const aFileName: string; var aFMR: tFileMappingRecord): Boolean;

// this function frees up resources taken by NewFileMapping
function FreeFileMapping(var aFMR: tFileMappingRecord): Boolean;

// I have no time to test this function
function SeekBuf(Buf1: Pointer; Buf1Size: Integer; Buf2: Pointer; Buf2Size: Integer): Integer;

// fast way to seek a substring in string (or any buffer)
// aBuf -- pointer to buffer to seek in;
// aBufSize -- size of buffer;
// aStr -- substring to seek;
// IgnoreCase -- ignore or not the case (international characters not supported!);
//               (for binary seeking set this parameter to False);
// Result -- position in aBuf of firt occurance of aStr or -1 if none;
//           (0 means start of buffer);
function SeekStr(aBuf: Pointer; aBufSize: Integer; const aStr: string; IgnoreCase: Boolean): Integer;

const
  // change this in runtime, if you want
  regRoot: string = 'Software\HammerSoft\Projects\';

//
const
  regRootKey: hKey = HKEY_CURRENT_USER;	// may change to something like HKEY_LOCAL_MACHINE

// used to read value from registry;
// aAppName -- application title (i.e. 'ASWS', 'Project1', ...);
//             it will be used to create registry key name: [HKEY_CURRENT_USER\regRoot\aAppName]
// aKeyName -- name of registry key to get (i.e. 'Settings', 'Form1\Left', ...);
//             (do not add '\' after key name!);
// aDefValue -- will be returned if key (aKeyName) does not exists;
// NOTE: key will NOT be created, use SetRegStr to do this.
function GetRegStr(const aAppName, aKeyName, aDefValue: string): string;

// used to write value to registry;
// aAppName -- application title (i.e. 'ASWS', 'Project1', ...);
//             it will be used to create registry key name: [HKEY_CURRENT_USER\regRoot\aAppName]
// aKeyName -- name of registry key to set (i.e. 'Settings', 'Form1\Left', ...);
// aKeyValue -- value to be set;
// if key doesn't exists, it will be created.
procedure SetRegStr(const aAppName, aKeyName, aKeyValue: string);

// like SetRegStr but works with integer
procedure SetRegInt(const aAppName, aKeyName: string; aKeyValue: Integer);

// like GetRegStr but works with integer
function GetRegInt(const aAppName, aKeyName: string; aDefValue: Integer): Integer;

// correctly adds '\' to the given path:
//   C:\temp\	=> C:\temp\
//   C:\temp	=> C:\temp\
//   C:\        => C:\
//   C:		=> C:
//   C:\temp/	=> C:\temp/
function AddBackSlash(const aPath: string): string;

// shows message dialog with [Yes] [No] buttons
function AskYN(const aMsg: string): Boolean;

// show message dialog with [Yes] [No] [Cancel] buttons
// resturns: mrYes = Yes; mrNo = No; mrCancel = Cancel
function AskYNC(const aMsg: string): Integer;

// safetly converts a string to Integer;
// if error occured, then returns aDefValue
function Str2Int(const aStr: string; aDefValue: Integer): Integer;

// just reads all text from file
function ReadTextFile(const aFileName: string): string;

// adds string to text file
// (optionally adding CR LF after inserted line)
function AddTextToFile(const aFileName, aText: string; AddCRLF: Boolean): Boolean;

// will parse given string like this:
//
//  aString = Welcome to %NAME%, dear %USER%
//  aVChar  = %
//  aValues[0] = 'NAME=Alek'
//  aValues[1] = 'USER=Local'
//
// result:
//    Welcome to Alek, dear Local
function ParseString(const aString: string; aVChar: Char; aValues: tStrings): string;

// if A < B then result is A, else B
function Min(A, B: Integer): Integer;

// if A > B then result is A, else B
function Max(A, B: Integer): Integer;

// works more correctly with russian/ukranian dates
function Date2Str(const aDate: tDateTime): string;

//
function RegLoadFont(aFont: tFont; const aRegAppName: string): Boolean;

//
function RegSaveFont(aFont: tFont; const aRegAppName: string): Boolean;

//
procedure RegSaveControl(aControl: tControl; const anAppName: string);

//
function RegLoadControl(aControl: tControl; const anAppName: string): Boolean;

// converts hexadecimal string into integer
function Hex2Int(const S: string): Integer;

// changes "unprintable" characters into #xx equialents
function Str2ASCII(const aStr: string): string;

// changes all #xx characters into real ones
function ASCII2Str(const aStr: string): string;

// ...
procedure ParsePasConsts(const aConsts: string; aList: tStrings);

// too complex to work :)
function IsGoodSubStr(aSubStr: string; const aStr: string; Poss: tList; out FirstMatch: string): Boolean;

// will convert given date into string
function Date2EngStr(aDate: tDateTime): string;

// converts string to date
// NOTE: use only with strings created by Date2EngStr
function EngStr2Date(const aStr: string): Integer;

// encodes string into base64 format
function Base64Code(const aInput: string): string;

// decodes string from base64 format
function Base64Decode(const aInput: string): string;

// sets user long data for window
procedure SetWindowULong(aHandle: tHandle; aLong: Integer);

// returns window (if any) having user data = ProgID
function FindWindowULong(ProgID: Integer): hWnd;

implementation

uses
  SysUtils, ShlObj, ActiveX, Registry, Dialogs, Forms;

// WEIRD! Is this new Microsofto style?
function SelectFolder(aHandle: tHandle; const aRoot, aMsg: string): string;
var
   lM	: iMalloc;
   lB	: Boolean;
  lB2	: Boolean;
  lBI	: TBrowseInfo;
  lDN 	: array[0..MAX_PATH] of Char;
  lDN2	: array[0..MAX_PATH] of Char;
  lWD	: pWideChar;
  lPI	: pItemIDList;
  lPI2	: pItemIDList;
  lIS	: iShellFolder;
  lEaten: uLong;
  lAttrs: uLong;
  lRL   : Integer;
begin
  Result := '';
  lB  := Succeeded(SHGetMalloc(lM));
  lRL := Length(Trim(aRoot));
  if (lRL > 0) then lB2 := Succeeded(SHGetDesktopFolder(lIS))
	       else lB2 := False;
  with lBI do begin
    hwndOwner := aHandle;
    if lB2 then begin
      GetMem(lWD, (lRL + 1) shl 1);
      try
	StringToWideChar(Trim(aRoot), lWD, lRL + 1);
	lIS.ParseDisplayName(aHandle, nil, lWD, lEaten, lPI, lAttrs);
      finally
	FreeMem(lWD, (lRL + 1) shl 1);
	pidlRoot := lPI;
      end;
    end
    else pidlRoot := nil;
    pszDisplayName := lDN;
    GetMem(lpszTitle, Length(aMsg) + 1);
    try
      StrPCopy(lpszTitle, aMsg);
      ulFlags := BIF_RETURNONLYFSDIRS;
      lpfn    := nil;
      lParam  := 0;
      lPI2    := SHBrowseForFolder(lBI);
    finally
      FreeMem(lpszTitle, Length(aMsg) + 1);
    end;
    if Assigned(lPI2) then begin
      SHGetPathFromIDList(lPI2, lDN2);
      Result := lDN2;
    end;
  end;
  //if lB2 then lIS._Release;
  if lB then begin
    lM.Free(lPI);
    if Assigned(lPI2) then lM.Free(lPI);
    lM._Release;
  end;
end;

//
function GetRegStr(const aAppName, aKeyName, aDefValue: string): string;
begin
  Result := aDefValue;
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, False) then begin
      if ValueExists(aKeyName) then Result := ReadString(aKeyName);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
procedure SetRegStr(const aAppName, aKeyName, aKeyValue: string);
begin
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, True) then begin
      WriteString(aKeyName, aKeyValue);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
procedure SetRegInt(const aAppName, aKeyName: string; aKeyValue: Integer);
begin
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, True) then begin
      WriteInteger(aKeyName, aKeyValue);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
function GetRegInt(const aAppName, aKeyName: string; aDefValue: Integer): Integer;
begin
  Result := aDefValue;
  with tRegistry.Create do try
    RootKey := regRootKey;
    if OpenKey(regRoot + aAppName, False) then begin
      if ValueExists(aKeyName) then Result := ReadInteger(aKeyName);
      CloseKey;
    end;
  finally
    Free;
  end;
end;

//
function NewFileMapping(const aFileName: string; var aFMR: tFileMappingRecord): Boolean;
begin
  Result := False;
  with aFMR do begin
    fFileHandle := CreateFile(PChar(aFileName), GENERIC_READ, FILE_SHARE_READ + FILE_SHARE_WRITE, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
    if (fFileHandle <> INVALID_HANDLE_VALUE) then begin
      fFileMapping := CreateFileMapping(fFileHandle, nil, PAGE_READONLY, 0, 0, nil);
      if (fFileMapping <> 0) then begin
	fFileBase := MapViewOfFile(fFileMapping, FILE_MAP_READ, 0, 0, 0);
	Result := (fFileBase <> nil);
      end;
    end;
  end;
end;

//
function FreeFileMapping(var aFMR: tFileMappingRecord): Boolean;
begin
  Result := False;
  with aFMR do
    if (fFileHandle <> INVALID_HANDLE_VALUE) then begin
      UnmapViewOfFile(fFileBase);
      CloseHandle(fFileMapping);
      CloseHandle(fFileHandle);
      Result := True;
    end;
  if Result then FillChar(aFMR, SizeOf(aFMR), #0);
end;

// WARNING: I don't test this function yet!
function SeekBuf(Buf1: Pointer; Buf1Size: Integer; Buf2: Pointer; Buf2Size: Integer): Integer;
var
  Pos1 : Integer;
  Found: Boolean;
begin
  Result := -1;		// not found
  if (Buf2Size <= Buf1Size) then begin
    asm
	cld
    end;
    Pos1 := 0;
    while (Pos1 <= Buf1Size - Buf2Size) do begin
      asm
	push	edi
	push	esi
	push	ecx

	mov	ecx, Buf2Size
	mov	edi, Buf1
	mov	esi, Buf2
	add	edi, Pos1

	repz	cmpsb

	mov	Found, False
	jnz     @Skip

	or	ecx, ecx
	jnz	@Skip

	mov	Found, True
  @Skip:

	pop	ecx
	pop     esi
	pop	edi
      end;
      if Found then Break;
      Inc(Pos1);
    end;
    if Found then Result := Pos1;
  end;
end;

//
function SeekStr(aBuf: Pointer; aBufSize: Integer; const aStr: string; IgnoreCase: Boolean): Integer;
var
  P : pChar;
  i : Integer;
  j : Integer;
  M : Integer;
  OK: Boolean;
begin
  P := pChar(aBuf);
  i := 0;	// pos in aBuf
  j := 0;	// size of mached bytes
  M := Length(aStr);
  while (j < M) and (i < aBufSize) do begin
    if IgnoreCase then OK := (UpCase(P[i]) = UpCase(aStr[j + 1]))
		  else OK := (P[i] = aStr[j + 1]);
    if OK then Inc(j)
	  else j := 0;
    Inc(i);
  end;
  if (j = M) then Result := i - M// - 1 a bug?
	     else Result := -1;
end;

//
function AddBackSlash(const aPath: string): string;
var
  L: Integer;
begin
  Result := Trim(aPath);
  L := Length(Result);
  if (L > 0) then
    if not (Result[L] in ['/', '\', ':']) then Result := Result + '\';
end;

//
function AskYN(const aMsg: string): Boolean;
begin
  Result := (MessageDlg(aMsg, mtConfirmation, [mbYes, mbNo], 0) = mrYes);
end;

//
function AskYNC(const aMsg: string): Integer;
begin
  Result := MessageDlg(aMsg, mtConfirmation, [mbYes, mbNo, mbCancel], 0);
end;

//
function Str2Int(const aStr: string; aDefValue: Integer): Integer;
var
  lC: Integer;
begin
  Val(Trim(aStr), Result, lC);
  if (lC <> 0) then Result := aDefValue;
end;

//
function ReadTextFile(const aFileName: string): string;
var
  lF: Integer;
  lZ: Integer;
begin
  lF := FileOpen(aFileName, fmOpenRead + fmShareDenyNone);
  if (lF > 0) then begin
    lZ := FileSeek(lF, 0, 2);
    FileSeek(lF, 0, 0);
    SetLength(Result, lZ);
    if (lZ > 0) then FileRead(lF, Result[1], lZ);
  end
  else Result := '';
  FileClose(lF);
end;

//
function AddTextToFile(const aFileName, aText: string; AddCRLF: Boolean): Boolean;
var
  lF: Integer;
  lS: string;
begin
  Result := False;
  if FileExists(aFileName) then lF := FileOpen(aFileName, fmOpenWrite + fmShareDenyNone)
			   else lF := FileCreate(aFileName);
  if (lF >= 0) then
    try
      FileSeek(lF, 0, 2);
      if AddCRLF then lS := aText + #13#10
		 else lS := aText;
      FileWrite(lF, lS[1], Length(lS));
    finally
      FileClose(lF);
    end;
end;

//
function ParseString(const aString: string; aVChar: Char; aValues: tStrings): string;
var
  i: Integer;
  W: string;
  B: Boolean;
begin
  i := 1;
  Result := '';
  B := False;
  while (i <= Length(aString)) do begin
    if (aString[i] = aVChar) then
      if B then begin
	if (W = '') then Result := Result + aVChar
		    else Result := Result + aValues.Values[AnsiUpperCase(W)];
	B := False;
      end
      else begin
	B := True;
	W := '';
      end
    else
      if B then W := W + aString[i]
	   else Result := Result + aString[i];
    Inc(i);
  end;
end;

//
function Min(A{eax}, B{edx}: Integer):{eax} Integer;
asm
	cmp	eax, edx
	jbe	@exit
	mov	eax, edx
  @exit:
end;

//
function Max(A{eax}, B{edx}: Integer):{eax} Integer;
asm
	cmp	eax, edx
	jae	@exit
	mov	eax, edx
  @exit:
end;

//
function Date2Str(const aDate: tDateTime{; const aMask: string}): string;
var
  lST: tSystemTime;
  lY,
  lM,
  lD: Word;
  lB: array[0..255] of Char;
begin
  DecodeDate(aDate, lY, lM, lD);
  lST.wYear  := lY;
  lST.wMonth := lM;
  lST.wDay   := lD;
  GetDateFormat(GetThreadLocale, DATE_LONGDATE, @lST, nil, lB, 255);
  Result := lB;
end;

//
function RegLoadFont(aFont: tFont; const aRegAppName: string): Boolean;
var
  lRK: string;
  lST: string;
  lF : tFont;
begin
  lRK := {AddBackSlash(}aRegAppName{)};
  //Delete(lRK, Length(lRK), 1);
  lF := tFont.Create;
  with lF do try
    CharSet := GetRegInt(lRK, 'CharSet', DEFAULT_CHARSET);
    Color   := GetRegInt(lRK, 'Color',   clWindowText);
    Height  := GetRegInt(lRK, 'Height',  -11);
    Name    := GetRegStr(lRK, 'Name',   'MS Sans Serif');
    Pitch   := tFontPitch(GetRegInt(lRK, 'Pitch',   Ord(fpDefault)));
    Size    := GetRegInt(lRK, 'Size',    8);
    lST     := GetRegStr(lRK, 'Style',   '0000');
    if (Length(lST) < 4) then lST := lST + '0000';
    if (lST[1] <> '0') then Style := Style + [fsBold];
    if (lST[2] <> '0') then Style := Style + [fsItalic];
    if (lST[3] <> '0') then Style := Style + [fsUnderline];
    if (lST[4] <> '0') then Style := Style + [fsStrikeOut];
  finally
    aFont.Assign(lF);
    Free;
  end;
  Result := True;
end;

//
function RegSaveFont(aFont: tFont; const aRegAppName: string): Boolean;
var
  lRK: string;
  lST: string;
begin
  lRK := {AddBackSlash(}aRegAppName{)};
  with aFont do begin
    SetRegInt(lRK, 'CharSet', CharSet);
    SetRegInt(lRK, 'Color',   Color);
    SetRegInt(lRK, 'Height',  Height);
    SetRegStr(lRK, 'Name',    Name);
    SetRegInt(lRK, 'Pitch',   Ord(Pitch));
    SetRegInt(lRK, 'Size',    Size);
    lST := '0000';
    if (fsBold      in Style) then lST[1] := 'A';
    if (fsItalic    in Style) then lST[2] := 'l';
    if (fsUnderline in Style) then lST[3] := 'e';
    if (fsStrikeOut in Style) then lST[4] := 'k';
    SetRegStr(lRK, 'Style', lST);
  end;
  Result := True;
end;

//
procedure RegSaveControl(aControl: tControl; const anAppName: string);
var
  lS: string;
begin
  with aControl do
    if (Name <> '') then begin
      lS := anAppName + '\Controls\' + Name;
      //SetRegStr(lS, 'Caption', Caption);
      //SetRegInt(lS, 'Color', Color);
      SetRegInt(lS, 'Height', Height);
      SetRegInt(lS, 'Left', Left);
      SetRegInt(lS, 'Top', Top);
      SetRegInt(lS, 'Visible', Ord(Visible));
      SetRegInt(lS, 'Width', Width);
      if (aControl is tCustomForm) then SetRegInt(lS, 'WState', Ord((aControl as tCustomForm).WindowState));
    end;
end;

//
function RegLoadControl(aControl: tControl; const anAppName: string): Boolean;
var
  lS: string;
begin
  with aControl do
    if (Name <> '') then begin
      lS := anAppName + '\Controls\' + Name;
      //SetRegStr(lS, 'Caption', Caption);
      //SetRegInt(lS, 'Color', Color);
      Height  := GetRegInt(lS, 'Height', Height);
      Left    := GetRegInt(lS, 'Left', Left);
      Top     := GetRegInt(lS, 'Top', Top);
      Visible := (GetRegInt(lS, 'Visible', Ord(Visible)) = Ord(True));
      Width   := GetRegInt(lS, 'Width', Width);
      if (aControl is tCustomForm) then (aControl as tCustomForm).WindowState := tWindowState(GetRegInt(lS, 'WState', Ord((aControl as tCustomForm).WindowState)));
    end;
  Result := True;
end;

function HexD(C: Char): Byte;
begin
  case UpCase(C) of
    '0'..'9': Result := Ord(C) - Ord('0');
    'A'..'F': Result := Ord(C) - Ord('A') + 10;
    else Result := 0;
  end;
end;

//
function Hex2Int(const S: string): Integer;
var
  H: string;
  M: Integer;
begin
  H := Trim(S);
  M := Length(H);
  Result := 0;
  while (M > 0) do begin
    Result := Result + HexD(H[Length(H) - M + 1]) shl ((M - 1) shl 2);
    Dec(M);
  end;
end;

function Str2ASCII(const aStr: string): string;
var
  i: Integer;
begin
  Result := '';
  for i := 1 to Length(aStr) do
    case aStr[i] of
      #00..#31: Result := Result + '#' + IntToHex(Byte(aStr[i]), 2);
      '#'     : Result := Result + '#' + IntToHex(Byte('#'), 2);
      else      Result := Result + aStr[i];
    end;
end;

function ASCII2Str(const aStr: string): string;
var
  i: Integer;
begin
  Result := '';
  i := 1;
  while (i <= Length(aStr)) do begin
    if (aStr[i] = '#') then
      if (i + 2 <= Length(aStr)) then begin
	Result := Result + Char(Hex2Int(aStr[i + 1] + aStr[i + 2]));
	Inc(i, 2);
      end
      else
    else Result := Result + aStr[i];
    Inc(i);
  end;
end;

procedure ParsePasConsts(const aConsts: string; aList: tStrings);
const
  ttError	= -1;
  ttNone	= 1;
  ttID		= 2;
  ttString	= 3;
  ttDelim	= 4;

var
  lS: string;
  lP: Integer;
  lL: Integer;

  function NextToken(out lType: Integer): string;
  begin
    Result := '';
    lType  := ttNone;
    {$B-}
    // skip white space
    while (lP <= lL) and (lS[lP] in [' ', #0..#31]) do Inc(lP);
    while (lP <= lL) do begin
      case UpCase(lS[lP]) of
	'/': begin
	  lType  := ttDelim;
	  Result := '';
	  while (lP <= lL) and (lS[lP] <> #13) do Inc(lP);
	  Break;
	end;
	'{': begin
	  lType  := ttDelim;
	  Result := '';
	  while (lP <= lL) and (lS[lP] <> '}') do Inc(lP);
	  Break;
	end;
	'A'..'Z', '0'..'9', '_': begin
	  lType  := ttID;
	  Result := Result + lS[lP];
	end;
	'''': begin
	  if (Result = '') then begin
	    lType := ttString;
	    Inc(lP);
	    while (lP <= lL) do begin
	      case lS[lP] of
		'''': if (lP < lL) and (lS[lP + 1] = '''') then Result := Result + ''''
							   else Break;
		#00..#31: lType := ttError;
		else Result := Result + lS[lP];
	      end;
	      Inc(lP);
	    end;
	    Inc(lP);
	    Break;
	  end
	  else Break;
	end;
	else begin
	  if (Result = '') then begin
	    lType  := ttDelim;
	    Result := lS[lP];
	    Inc(lP);
	    Break;
	  end
	  else Break;	// token is over
	end;
      end;
      Inc(lP);
    end;
  end;

var
  lTT: Integer;
  lT : string;
  lID: string;
  lE : Boolean;
begin
  lP  := 1;
  lS  := Trim(aConsts);
  lL  := Length(lS);
  lID := '';
  lE  := False;
  repeat
    lT := NextToken(lTT);
    case lTT of
      ttNone, ttError: Break;
      ttID    : begin
	lID := lT;
	lE  := False;
      end;
      ttDelim : if not lE then lE := (lT = '=')
			  else lE := False;
      ttString: begin
	if lE then aList.Add(UpperCase(lID) + '=' + lT);
	lE := False;
      end;
    end;
  until (lTT = 0);
end;

function IsGoodSubStr(aSubStr: string; const aStr: string; Poss: tList; out FirstMatch: string): Boolean;
const
  ttWord	= 1;	//  some word (including such as "*ing" or even "*?")
  ttEOL 	= 2;	//  at end of string
  ttStar	= 3;	//  just * or ****
  Letters: set of Char = [{'''',} 'A'..'Z', 'a'..'z', '0'..'9', '_', #129..#255];

  function NextToken(const aStr: string; var aToken: string; var aPos: Integer): Integer;
  var
    lLen    : Integer;
    nonStars: Boolean;
    zPos    : Integer;
  begin
    lLen := Length(aStr);
    while (aPos <= lLen) and not ((aStr[aPos] in Letters) or (aStr[aPos] in ['*', '?'])) do Inc(aPos);
    if (aPos > lLen) then Result := ttEOL
    else begin
      aToken   := '';
      nonStars := False;
      zPos     := aPos;	// freeze the aPos
      while (zPos <= lLen) and ((aStr[zPos] in Letters) or (aStr[zPos] in ['*', '?'])) do begin
	aToken := aToken + aStr[zPos];
	if (aStr[zPos] <> '*') then nonStars := True;
	Inc(zPos);
      end;
      if nonStars then Result := ttWord
		  else Result := ttStar;
    end;
  end;

  function TokenMatch(const aMask, aToken: string): Boolean;
  var
    lP : Integer;
    lL : Integer;
    lTP: Integer;
    lTL: Integer;
    wC : Char;
    mustHave: Integer;
  begin
    lP  := 1;
    lL  := Length(aMask);
    lTP := 1;
    lTL := Length(aToken);
    while (lP <= lL) and (lTP <= lTL) do begin
      wC := aMask[lP];
      if (wC in Letters) then
	if (aToken[lTP] <> wC) then lTP := -1		// letters not match
			       else
      else
	case wC of
	  '*': begin
	    MustHave := 0;
	    while (lP <= lL) do begin
	      wC := aMask[lP];
	      case wC of
		'*': ;
		'?': Inc(mustHave);
		else Break;	// we found what we must found
	      end;
	      Inc(lP);
	    end;
	    Inc(lTP, mustHave);	// skip all "?"s
	    if (lTP > lTL) then lTP := -1	// don't have enough letters
	    else
	      if (lP > lL) then lTP := lTL	// we done, no more to check!
	      else begin
		while (lTP <= lTL) and (aToken[lTP] <> wC) do Inc(lTP);
		if (lTP > lTL) then lTP := -1;	// don't found what we must to
	      end;
	  end;
	  '?': ;	// any letter will do!
	end;
      if (lTP < 0) then Break;
      Inc(lP);
      Inc(lTP);
    end;
    Result := (lTP > lTL) and (lP > lL);
  end;

var
  lLen   : Integer;
  lSubLen: Integer;
  lPos   : Integer;
  lCurPos: Integer;
  lSubPos: Integer;
  lToken : string;
  lSubToken: string;
  CanSkip: Integer;
  lPoss  : tList;
  lTS    : Integer;
    i    : Integer;
begin
  Result     := False;
  lLen       := Length(aStr);
  aSubStr    := Trim(aSubStr);
  lSubLen    := Length(aSubStr);
  lPoss      := tList.Create;
  if Assigned(Poss) then Poss.Clear;
  lTS        := 0;		// just to eliminate warnings
  FirstMatch := '';
  if (lSubLen > 0) then begin
    lPos := 1;
    while (lPos <= lLen) do begin
      lSubPos := 1;
      lCurPos := lPos;
      CanSkip := 0;
      lPoss.Clear;
      while (lSubPos <= lSubLen) and (lCurPos > 0) do begin
	case NextToken(aSubStr, lSubToken, lSubPos) of
	  ttWord: begin
	    repeat
	      if (NextToken(aStr, lToken, lCurPos) = ttEOL) then begin
		lCurPos := -1;
		Break;
	      end
	      else begin
		lTS := lCurPos;
		Inc(lCurPos, Length(lToken));
	      end;
	      if TokenMatch(lSubToken, lToken) then begin
		lPoss.Add(Pointer(lTS));
		lPoss.Add(Pointer(Length(lToken)));
		FirstMatch := FirstMatch + ' ' + lToken;
		Break;
	      end
	      else begin
		Dec(CanSkip);
		FirstMatch := '';
	      end;
	    until (CanSkip < 0);
	    if (CanSkip < 0) then begin
	      lCurPos := -1;
	      Break;
	    end;
	    CanSkip := 0;
	  end;
	  ttEOL : ;
	  ttStar: Inc(CanSkip);
	end;
	Inc(lSubPos, Length(lSubToken));
      end;
      if (lCurPos > 0) and (lPoss.Count > 0) then begin
	if Assigned(Poss) then
	  for i := 0 to lPoss.Count - 1 do Poss.Add(lPoss[i]);
	NextToken(aStr, lToken, lCurPos);
	lPos := lCurPos;
	Result := True;
	if not Assigned(Poss) then Break;
      end
      else begin
	NextToken(aStr, lToken, lPos);
	Inc(lPos, Length(lToken));
	NextToken(aStr, lToken, lPos);
      end;
    end;
  end;
  lPoss.Free;
end;

const
  MonthStr = 'JANFEBMARAPRMAYJUNJULAUGSEPOCTNOVDEC';

function Date2EngStr(aDate: tDateTime): string;
var
  lY,
  lM,
  lD: Word;
begin
  DecodeDate(aDate, lY, lM, lD);
  Result := IntToStr(lD) + ' ' + Copy(MonthStr, (lM - 1) * 3 + 1, 3) + ' ' + IntToStr(lY);
end;

function EngStr2Date(const aStr: string): Integer;
var
  lD,
  lM,
  lY: Integer;
begin
  lD := Str2Int(Copy(aStr, 1, 2), 0);
  lM := Pos(Copy(aStr, Pos(' ', aStr) + 1, 3), MonthStr) div 3 + 1;
  lY := Str2Int(Copy(aStr, Pos(' ', aStr) + 1 + 3 + 1, Length(aStr)), 0);
  Result := Trunc(EncodeDate(lY, lM, lD));
end;

function Base64Code(const aInput: string): string;

const
  Base64: string[64] = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/';

var
  L: Integer;
  Z: Integer;
  P: string;
  j: Integer;
  i: Integer;
begin
  Result := '';
  i := 1;
  Z := Length(aInput);
  while (i <= Z) do begin
    P := '';
    L := Ord(aInput[i]) shl 16;
    Inc(i);
    if (i <= Z) then begin
      L := L + Ord(aInput[i]) shl 8;
      Inc(i);
      if (i <= Z) then L := L + Ord(aInput[i])
		  else P := '=';
    end
    else P := '==';
    for j := 1 to 4 - Length(P) do begin
      Result := Result + Base64[(L and $FC0000) shr 18 + 1];
      L := L shl 6;
    end;
    Result := Result + P;
    if (P <> '') then Break;
    Inc(i);
  end;
end;

function Char2Int(C: Char): Integer;
begin
  case C of
    'A'..'Z': Result := Ord(C) - Ord('A');
    'a'..'z': Result := Ord(C) - Ord('a') + 26;
    '0'..'9': Result := Ord(C) - Ord('0') + 52;
    '+'     : Result := 62;
    else      Result := 63;
  end;
end;

function Base64Decode(const aInput: string): string;
var
  Z: Integer;
  L: Integer;
  i: Integer;
  j: Integer;
  V: Byte;
begin
  //
  Result := '';
  i := 1;
  Z := Length(aInput);
  while (i <= Z) do begin
    V := 3;
    L := Char2Int(aInput[i]) shl 18;
    Inc(i);
    if (i <= Z) then begin
      L := L + Char2Int(aInput[i]) shl 12;
      Inc(i);
      {$B-}
      if (i <= Z) and (aInput[i] <> '=') then begin
	L := L + Char2Int(aInput[i]) shl 6;
	Inc(i);
	if (i <= Z) and (aInput[i] <> '=') then L := L + Char2Int(aInput[i])
	else V := 2	// only two chars are valid
      end
      else V := 1;	// only first is valid
    end
    else V := 0;	// not valid at all
    for j := 1 to V do begin
      Result := Result + Chr((L and $FF0000) shr 16);
      L := L shl 8;
    end;
    Inc(i);
    if (V <> 3) then Break;
  end;
end;

//
procedure SetWindowULong(aHandle: tHandle; aLong: Integer);
begin
  SetWindowLong(aHandle, GWL_USERDATA, aLong);
end;

//
type
  phWnd = ^hWnd;

var
  MyID: Integer;

function EnumFunc(Wnd: hWnd; lParam: phWnd): Bool; stdcall;
var
  lID: Integer;
begin
  lID := GetWindowLong(Wnd, GWL_USERDATA);
  if (lID = MyID) then begin
    lParam^ := Wnd;
    Result  := False;
  end
  else Result := True;
end;

//
function FindWindowULong(ProgID: Integer): hWnd;
begin
  MyID   := ProgID;
  Result := 0;
  EnumWindows(@EnumFunc, Integer(@Result));
end;

end.

