
unit RXMain;

{

  This program provides an example of how to use the TreeView and ListView
  components in a fashion similar to the Microsoft Windows Explorer.

  It is not intended to be a fully functional resource viewer.

}

interface

uses
  Forms, TB97, Menus, ImgList, Controls, Dialogs, MPlayer, StdCtrls, Messages,
  ComCtrls, ExtCtrls, Buttons, FileCtrl, Classes, Mover, ExeImage, HexDump,
  LCDate;

const
  // page indexes
  piListView	= 1;
  piImage	= 2;
  piStrings	= 3;
  piVerInfo	= 4;
  piIntro	= 5;
  piMMedia	= 6;
  piHexDump     = 7;
  piExeObject	= 8;

type
  TMainForm = class(TForm)
    StatusBar: TStatusBar;
    TreeViewPanel: TPanel;
    FileDirPanel: TPanel;
    TreeView: TTreeView;
    FOD: TOpenDialog;
    FSD: TSaveDialog;
    Small: TImageList;
    Large: TImageList;
    DLB1: TDirectoryListBox;
    FLB1: TFileListBox;
    Panel2: TPanel;
    DCB1: TDriveComboBox;
    FCB1: TFilterComboBox;
    PM1: TPopupMenu;
    Saveresource1: TMenuItem;
    PM2: TPopupMenu;
    Saveas1: TMenuItem;
    Fullexpand1: TMenuItem;
    Fullcollapse1: TMenuItem;
    Mover1: TMover;
    Mover3: TMover;
    Mover2: TMover;
    PCMain: TPageControl;
    TS1: TTabSheet;
    Panel4: TPanel;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    ListView: TListView;
    TS2: TTabSheet;
    ImageViewer: TImage;
    TS3: TTabSheet;
    TS4: TTabSheet;
    VIList: TListView;
    Label3: TLabel;
    TS5: TTabSheet;
    Memo1: TMemo;
    TS6: TTabSheet;
    Panel6: TPanel;
    MPlayer: TMediaPlayer;
    Panel5: TPanel;
    Panel8: TPanel;
    Label1: TLabel;
    TS7: TTabSheet;
    StringViewer: TRichEdit;
    DockTop: TDock97;
    TB97_1: TToolbar97;
    TBB_Switch: TToolbarButton97;
    TBB_Save: TToolbarButton97;
    TBB_Open: TToolbarButton97;
    ToolbarSep971: TToolbarSep97;
    ToolbarSep972: TToolbarSep97;
    TBB_Exit: TToolbarButton97;
    TBB_About: TToolbarButton97;
    DockLeft: TDock97;
    DockRight: TDock97;
    TS8: TTabSheet;
    SB_Back: TSpeedButton;
    SB_ASK: TSpeedButton;
    PCExe: TPageControl;
    TSHeader: TTabSheet;
    LVEO: TListView;
    TSData: TTabSheet;
    LBExe: TListBox;
    LCD: TLCDate;
    procedure FormCreate(Sender: TObject);
    procedure ListViewEnter(Sender: TObject);
    procedure SelectListViewType(Sender: TObject);
    procedure TreeViewChange(Sender: TObject; Node: TTreeNode);
    procedure Fullexpand1Click(Sender: TObject);
    procedure Fullcollapse1Click(Sender: TObject);
    procedure PM2Popup(Sender: TObject);
    procedure ListViewChange(Sender: TObject; Item: TListItem; Change: TItemChange);
    procedure MPlayerNotify(Sender: TObject);
    procedure TBB_OpenClick(Sender: TObject);
    procedure TBB_SaveClick(Sender: TObject);
    procedure TBB_SwitchClick(Sender: TObject);
    procedure TBB_AboutClick(Sender: TObject);
    procedure TBB_ExitClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FLB1Click(Sender: TObject);
    procedure FLB1Change(Sender: TObject);
    procedure TreeViewCollapsing(Sender: TObject; Node: TTreeNode; var AllowCollapse: Boolean);
    procedure Saveas1Click(Sender: TObject);
    procedure Saveresource1Click(Sender: TObject);
    procedure TreeViewMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure TreeViewCollapsed(Sender: TObject; Node: TTreeNode);
    procedure DLB1Change(Sender: TObject);
    procedure SB_BackClick(Sender: TObject);
    procedure SB_ASKClick(Sender: TObject);
  private
    // private
    fHistoryPtr	 : Integer;
    FExeFile  	 : tExeImage;
    HexDump   	 : tHexDump;
    MediaFile 	 : string;
    isUpdating	 : Boolean;
    fFileName 	 : string;
    fCollapsedNode: tTreeNode;
    fActivePage  : Integer;
    fHistory  	 : tStrings;
    fInBackChange: Boolean;
    fOldDir	 : string;
    procedure DoSaveRes;
    procedure LoadResources(ResList: tExeObjList; Node: tTreeNode);
    procedure SetHistoryPtr(const Value: Integer);
    procedure DisplayResources;
    procedure UpdateViewPanel;
    procedure UpdateListView(ResList: tExeObjList);
    procedure UpdateStatusLine(ResItem: tExeObjItem);
    procedure MyOnClose(Sender: tObject; var Action: TCloseAction);
    procedure MyMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure SetActivePage(const Value: Integer);
    procedure CheckTBBSwDown;
    procedure SetFile(const aName: string);
    procedure SetEC(const aErrorCaption: string);
    procedure RescanFiles;
    procedure WMDropFiles(var Msg: tMessage); message wm_DropFiles;
    procedure CheckASKButton;
    procedure RestoreSettings;
    procedure SaveSettings;
    //
    property ErrorCaption: string write SetEC;
    property ActivePage  : Integer read fActivePage write SetActivePage;
    property HistoryPtr  : Integer read fHistoryPtr write SetHistoryPtr;
  end;

var
  MainForm: TMainForm;

const
  SCopyright     = 'Copyright  1996 Borland International';

implementation

uses
  Windows, ShellAPI, SysUtils, Graphics, About, RXTypes, HomeTool{, Url}{, TypInfo};

{$R *.DFM}
{$R RXIMAGES.RES}
{$R RXMANUAL.RES}

const
  itBitmap   : tResType = imglist.rtBitmap; // Reference for duplicate identifier
  ImageMap   : array[tResourceType] of Byte = (2, 4, 5, 3, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2);
  iResFiltMap: array[tResourceType] of Byte = (1, 4, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1);

  SNoResSelected = 'No resource selected';
  SFormCaption   = 'Resource Explorer';
  SDefExt	 : array[tResourceType] of string = ('Dat', 'Cur', 'Bmp', 'Ico', 'Mnu', 'Dlg', 'Str', 'Fnt', 'Fnt', 'Acc', 'RCD', 'Msg', 'Cur', 'U13', 'Ico', 'U15', 'Ver');
  SSaveFilter    = 'Other Resource (*.*)|*.*|Bitmaps (*.BMP)|*.BMP|'+
		   'Icons (*.ICO)|*.ICO|Cursor (*.CUR)|*.CUR';
  SOpenFilter    = 'Executable File Images (*.EXE;*.DLL)|*.EXE;*.DLL|'+
		   'All Files (*.*)|*.*';

  // Utility Functions

function GetResFiltMap(aType: Integer): Integer;
begin
  if GoodType(aType) then Result := iResFiltMap[tResourceType(aType)]
		     else Result := 1;
end;

function GetDefExt(aType: Integer): string;
begin
  if GoodType(aType) then Result := SDefExt[tResourceType(aType)]
		     else Result := 'U2';
end;

procedure Error(const ErrMsg: string);
begin
  raise Exception.Create(ErrMsg);
end;

procedure ErrorFmt(const ErrMsg: string; Params: array of const);
begin
  raise Exception.Create(Format(ErrMsg, Params));
end;

function Confirm(const AMsg: String): Boolean;
begin
  Result := (MessageDlg(AMsg, mtConfirmation, mbYesNoCancel, 0) = mrYes);
end;

  // the form

procedure tMainForm.LoadResources(ResList: tExeObjList; Node: TTreeNode);
var
  I    : Integer;
  CNode: TTreeNode;
begin
  if Assigned(ResList) then
    for I := 0 to ResList.Count - 1 do
      with ResList[I] do begin
	CNode := TreeView.Items.AddChildObject(Node, Name, ResList[I]);
	if IsList then begin
	  CNode.SelectedIndex := 1;
	  LoadResources(List, CNode);
	end
	else begin
	  CNode.ImageIndex    := ImageMap[ResList[I].ImageTypeIndex];
	  CNode.SelectedIndex := CNode.ImageIndex;
	end;
      end;
end;

const
  ImageType2Str: array[tImageType] of string =
    ('None', 'DOS', 'NE', 'PE', 'LX', 'LE');

procedure tMainForm.DisplayResources;
begin
  ListView.Items.Clear;
  TreeView.Selected := nil;
  TreeView.Items.Clear;
  LoadResources(fExeFile.Resources, nil);
  if (fExeFile.Error = 3) then ErrorCaption := 'No resources.'
  else begin
    Caption := Format('%s - %s [%s]', [SFormCaption, LowerCase(fExeFile.FileName), ImageType2Str[fExeFile.ImageType]]);
    with TreeView do begin
      SetFocus;
      if (Items.Count > 0) then Selected := Items[0];
    end;
  end;
end;

function MyDlgProc(aDlg: hWnd; aMsg: uInt; awParam: wParam; alParam: lParam): uInt; stdcall;
begin
  Result := 0;
  case aMsg of
    wm_InitDialog: ;
    wm_Command     : if (awParam = idCancel) then DestroyWindow(aDlg);
  end;
end;

procedure tMainForm.MyOnClose(Sender: tObject; var Action: TCloseAction);
begin
  with (Sender as tForm) do begin
    DestroyWindow(Tag);
    Free;
  end;
end;

function GetTMPFileName(Prefix: pChar; DoCreate: Boolean): string;
var
  lTempPath: array[0..MAX_PATH] of Char;
  lNumber  : Integer;
begin
  if (GetTempPath(SizeOf(lTempPath), lTempPath) < 1) then lTempPath := '.\';
  if DoCreate then lNumber := 0 else lNumber := 1973;
  if (GetTempFileName(lTempPath, Prefix, lNumber, lTempPath) < 1) then lTempPath := '_temp_.$$$';
  Result := lTempPath;
end;

procedure tMainForm.UpdateViewPanel;
var
  VIBuf : Pointer;
  R	: TResourceItem;

  procedure AddVI(Index: Integer; const aVIStr: string);
  type
    tVIBuf = array[0..1024] of Char;
  var
    lVIB  : ^tVIBuf;
    lZ    : LongWord;
    lS    : string;
    lA    : array[0..120] of Char;

    function iH(Index: Integer): string;
    begin
      Result := IntToHex(Byte(lVIB[Index]), 2);
    end;

    function GetHex: string;
    begin
      Result := iH(1) + iH(0) + iH(3) + iH(2);
    end;

  begin
    lS := '';
    StrPCopy(lA, '\VarFileInfo\Translation');
    if not VerQueryValue(VIBuf, lA, Pointer(lVIB), lZ) then lZ := 0;
    if (lZ > 3) then begin
      Label3.Caption := 'Lang-charset: ' + GetHex;
      StrPCopy(lA, '\StringFileInfo\' + GetHex + '\' + aVIStr);
      if not VerQueryValue(VIBuf, lA, Pointer(lVIB), lZ) then lZ := 0;
      if (lZ > 0) then begin
	SetLength(lS, lZ);
	Move(lVIB^[0], lS[1], lZ);
      end;
    end;
    VIList.Items[Index].SubItems[0] := lS;
  end;

  procedure AssignPicture(aType: Byte);
  begin
    case aType of
      1: ImageViewer.Picture.Bitmap.Assign(R);
      2: ImageViewer.Picture.Assign(R);
      3: ImageViewer.Picture.Icon.Assign(R);
    end;
    ActivePage := piImage;
  end;

  function Long2Hex(aInt: Integer): string;
  type
    tLong = record
      L: Word;
      H: Word;
    end;
  begin
    Result := IntToHex(tLong(aInt).H, 4) + '.' + IntToHex(tLong(aInt).L, 4);
  end;

  type
    tIStr = record
      V: Integer;
      A: string;
    end;

  function FF2Str(Flags: Integer): string;
  type
    FFEnum = (eVS_FF_DEBUG, eVS_FF_PRERELEASE, eVS_FF_PATCHED,
	      eVS_FF_PRIVATEBUILD, eVS_FF_INFOINFERRED, eVS_FF_SPECIALBUILD);
  const
    fFStr: array[FFEnum] of tIStr =
      ((V: VS_FF_DEBUG;		A: 'Debug'),
       (V: VS_FF_PRERELEASE;	A: 'Pre-release'),
       (V: VS_FF_PATCHED;	A: 'Patched'),
       (V: VS_FF_PRIVATEBUILD;	A: 'Private build'),
       (V: VS_FF_INFOINFERRED;  A: 'Info inferred'),
       (V: VS_FF_SPECIALBUILD;	A: 'Special build'));
  var
    i: FFEnum;
  begin
    Result := '';
    for i := Low(i) to High(i) do
      if ((fFStr[i].V and Flags) <> 0) then Result := Result + fFStr[i].A + ' ';
    if (Result = '') then Result := '<none>';
  end;

  function OS2Str(Flags: Integer): string;
  type
    OSEnum = (eVOS_UNKNOWN, eVOS_DOS, eVOS_OS216, eVOS_OS232, eVOS_NT, eVOS__WINDOWS16, eVOS__PM16, eVOS__PM32, eVOS__WINDOWS32);
  const
    fOSStr: array[OSEnum] of tIStr =
      ((V: VOS_UNKNOWN;		A: 'Unknown'),
       (V: VOS_DOS;		A: 'DOS'),
       (V: VOS_OS216;		A: 'OS/2 16'),
       (V: VOS_OS232;		A: 'OS/2 32'),
       (V: VOS_NT;		A: 'NT'),
       (V: VOS__WINDOWS16;	A: 'Win16'),
       (V: VOS__PM16;		A: 'PM 16'),
       (V: VOS__PM32;		A: 'PM 32'),
       (V: VOS__WINDOWS32;	A: 'Win32'));
  var
    i: OSEnum;
  begin
    Result := '';
    for i := Low(i) to High(i) do
      if (fOSStr[i].V = (Flags and $F0000)) then Result := fOSStr[i].A;
    for i := Low(i) to High(i) do
      if (fOSStr[i].V = (Flags and $F)) then Result := Result + ' with ' + fOSStr[i].A;
  end;

  function FT2Str(Flags, SubFlags: Integer): string;
  type
    FTEnum = (eVFT_UNKNOWN, eVFT_APP, eVFT_DLL, eVFT_DRV, eVFT_FONT, eVFT_VXD, eVFT_STATIC_LIB);
    FT2Enum = (e0, e1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    FT3Enum = (e31, e32, e33);
  const
    fFTStr: array[FTEnum] of tIStr =
      ((V: VFT_UNKNOWN;		A: 'Unknown'),
       (V: VFT_APP;		A: 'Application'),
       (V: VFT_DLL;		A: 'Dynamic-link library'),
       (V: VFT_DRV;		A: 'Device driver:'),
       (V: VFT_FONT;		A: 'Font-'),
       (V: VFT_VXD;		A: 'Virtual device'),
       (V: VFT_STATIC_LIB;	A: 'Static-link library'));
     fFT2Str: array[FT2Enum] of tIStr =
       ((V: VFT2_UNKNOWN;		A: 'Unknown'),
	(V: VFT2_DRV_PRINTER;		A: 'printer'),
	(V: VFT2_DRV_KEYBOARD;		A: 'keyboard'),
	(V: VFT2_DRV_LANGUAGE;		A: 'language'),
	(V: VFT2_DRV_DISPLAY;		A: 'display'),
	(V: VFT2_DRV_MOUSE;		A: 'mouse'),
	(V: VFT2_DRV_NETWORK;		A: 'network'),
	(V: VFT2_DRV_SYSTEM;		A: 'system'),
	(V: VFT2_DRV_INSTALLABLE;	A: 'installable'),
	(V: VFT2_DRV_SOUND;		A: 'sound'),
	(V: VFT2_DRV_COMM;		A: 'comm'));
     fFT3Str: array[FT3Enum] of tIStr =
       ((V: VFT2_FONT_RASTER;		A: 'raster'),
	(V: VFT2_FONT_VECTOR;		A: 'vector'),
	(V: VFT2_FONT_TRUETYPE;		A: 'true type'));
  var
    i: FTEnum;
    j: FT2Enum;
    k: FT3Enum;
  begin
    Result := '';
    for i := Low(i) to High(i) do
      if (fFTStr[i].V = Flags) then Result := fFTStr[i].A;
    if (Result <> '') and (Result[Length(Result)] = ':') then
      for j := Low(j) to High(j) do
	if (fFT2Str[j].V = SubFlags) then Result := Result + ' ' + fFT2Str[j].A;
    if (Result <> '') and (Result[Length(Result)] = '-') then
      for k := Low(k) to High(k) do
	if (fFT3Str[k].V = SubFlags) then Result := Result + ' ' + fFT3Str[k].A;
  end;

type
  tAviHdr = record
    ID1 : Integer;
    Size: Integer;
    ID2 : Integer;
    ID3 : Integer;
  end;

  tJPGHdr = record
    ID1: LongWord;
    ID2: LongWord;
  end;

  tBigArray	= array [Word] of Byte;

const
  FormS: array[1..4] of Char = 'TPF0';

var
  VISize: Integer;
  fHnd  : tHandle;
  fName : array[0..512] of Char;
  hDlg  : tHandle;
  lP    : pDlgTemplate;
  lpW   : ^Word;
  lAH   : ^tAviHdr;
  lPJPEG: ^tJPGHdr;
  lFVI  : pVSFixedFileInfo;
  lZ    : LongWord;
  k     : Integer;
  FORMD : ^LongWord;
  lRS	: tResourceStream;
  lOS   : tMemoryStream;
  lOS1  : tMemoryStream;
  lF    : tForm;
  lEO   : tExeObjItem;
  lStrs : tStrings;
begin
  with TreeView do if Visible and Assigned(Selected) then
    if tObject(Selected.Data) is tResourceItem then begin
      R := tResourceItem(Selected.Data);
      if R.IsList then UpdateListView(R.List)
      else begin
	case tResourceType(R.ResType) of
	  rtBitmap	: AssignPicture(1);
	  rtIconEntry,
	  rtCursorEntry	: AssignPicture(3);
	  rtString,
	  rtMenu		: begin
	    StringViewer.Lines.Assign(R);
	    StringViewer.SelStart := 0;
	    ActivePage := piStrings;
	  end;
	  rtVersion	: begin	// version info
	    StrPCopy(fName, FLB1.FileName);
	    VISize := GetFileVersionInfoSize(fName, fHnd);
	    if (VISize > 0) then begin
	      GetMem(VIBuf, VISize);
	      try
		ActivePage := piVerInfo;
		if GetFileVersionInfo(fName, fHnd, VISize, VIBuf) then begin
		  AddVI(0, 'CompanyName');
		  AddVI(1, 'FileDescription');
		  AddVI(2, 'FileVersion');
		  AddVI(3, 'InternalName');
		  AddVI(4, 'LegalCopyright');
		  AddVI(5, 'OriginalFilename');
		  AddVI(6, 'ProductName');
		  AddVI(7, 'ProductVersion');
		end;
		if not VerQueryValue(VIBuf, '\', Pointer(lFVI), lZ) then lZ := 0;
		if (lZ > 0) then begin
		  VIList.Items[9].SubItems[0]  := Long2Hex(lFVI.dwStrucVersion);
		  VIList.Items[10].SubItems[0] := Long2Hex(lFVI.dwFileVersionMS) + '.' + Long2Hex(lFVI.dwFileVersionLS);
		  VIList.Items[11].SubItems[0] := Long2Hex(lFVI.dwProductVersionMS) + '.' + Long2Hex(lFVI.dwProductVersionLS);
		  VIList.Items[12].SubItems[0] := FF2Str(lFVI.dwFileFlagsMask and lFVI.dwFileFlags);
		  VIList.Items[13].SubItems[0] := OS2Str(lFVI.dwFileOS);
		  VIList.Items[14].SubItems[0] := FT2Str(lFVI.dwFileType, lFVI.dwFileSubtype);
		  VIList.Items[15].SubItems[0] := 'not done yet.'
		end;
	      finally
		fHnd := GetLastError;
		FreeMem(VIBuf, VISize);
	      end;
	    end;
	  end;
	  rtDialog	: begin	// standart dialog
	    StrPCopy(fName, FLB1.FileName);
	    fHnd := LoadLibrary(fName);
	    if (fHnd > 0) then try
	      lRS := tResourceStream.Create(fHnd, R.GoodName, RT_DIALOG);
	      lZ  := lRS.Size + 16;
	      GetMem(lP, lZ);
	      try
		FillChar(lP^, lZ, 0);
		lRS.Read(lP^, lRS.Size);
		k := lP.cdit;
		lF := tForm.Create(Application);
		lF.FormStyle := fsStayOnTop;
		repeat
		  hDlg := CreateDialogIndirectParam(fHnd, lP^, lF.Handle, @MyDlgProc, 1973);
		  if (hDlg < 1) then Dec(lP.cdit);
		until (hDlg > 0) or (lP.cdit < 1);
		if (hDlg > 0) then begin
		  lF.Tag := hDlg;
		  lF.OnClose := MyOnClose;
		  lF.OnMouseDown := MyMouseDown;
		  lF.Width := 500;
		  lF.Caption := 'I''m just a placeholder for dialog. Click anywhere on me to destroy.';
		  if (lP.cdit <> k) then ErrorCaption := IntToStr(k - lP.cdit) + ' control(s) has been stripped.'
				    else ErrorCaption := 'Take a look!';
		  lF.Show;
		  ShowWindow(hDlg, SW_SHOW);
		end
		else begin
		  ErrorCaption := 'Unable to create this dialog, sorry.';
		  lF.Free;
		end;
	      finally
		FreeMem(lP, lZ);
		lRS.Free;
	      end;
	    finally
	      FreeLibrary(fHnd);
	    end
	    else ErrorCaption := 'Unable to load library: ' + fName;
	  end;
	  else begin	// unknown type
	    lPW    := R.RawData;
	    lAH    := R.RawData;
	    lpJPEG := R.RawData;
	    FORMD  := R.RawData;
	    if (lPW^ = Ord('B') + Ord('M') shl 8) then AssignPicture(1)
	    else
	    if (lpJPEG.ID1 = $e0ffd8ff) and (lpJPEG.ID2 = $464a1000) then AssignPicture(2)
	    else
	    if ((lAH.ID1 = $46464952) and (lAH.ID2 = $20495641)) then begin
	      MediaFile := GetTMPFileName('AVI', True);
	      R.SaveToFile(MediaFile);
	      ActivePage := piMMedia;
	      MPlayer.FileName := MediaFile;
	      MPlayer.DeviceType := dtAVIVideo;
	      MPlayer.Open;
	      MPlayer.Play;
	    end else
	    if (FORMD^ = LongWord(FormS)) then begin
	      lOS1 := tMemoryStream.Create;
	      lOS1.Write(R.RawData^, R.Size);
	      lOS  := tMemoryStream.Create;
	      try
		lOS1.Position := 0;
		ObjectBinaryToText(lOS1, lOS);
		lOS.Position := 0;
		StringViewer.Lines.LoadFromStream(lOS);
		ActivePage := piStrings;
	      finally
		lOS1.Free;
		lOS.Free;
	      end;
	    end
	    else begin	// do hex dump
	      HexDump.Address  := R.RawData;
	      HexDump.DataSize := R.Size;
	      ActivePage       := piHexDump;
	    end;
	  end;
	end;	// case
      end;
      UpdateStatusLine(R);
    end
    else begin
      lEO := tExeObjItem(Selected.Data);
      if lEO.IsList then UpdateListView(lEO.List)
      else begin
	ActivePage := piExeObject;
	if (lEO.OType = otListView) then
	  with LVEO.Items do try
	    BeginUpdate;
	    TSHeader.TabVisible := True;
	    TSData.TabVisible   := False;
	    PCExe.ActivePage    := TSHeader;
	    lStrs := tStringList.Create;
	    lEO.AssignLVValues(lStrs);
	    Clear;
	    for k := 0 to lStrs.Count - 1 do
	      with Add do begin
		Caption := lStrs.Names[k];
		SubItems.Add(lStrs.Values[lStrs.Names[k]]);
	      end;
	  finally
	    EndUpdate;
	  end
	else
	if (lEO.OType = otListBox) then
	  with LBExe.Items do try
	    BeginUpdate;
	    TSData.TabVisible   := True;
	    TSHeader.TabVisible := False;
	    PCExe.ActivePage    := TSData;
	    Clear;
	    Text := lEO.AssignLBValues;
	  finally
	    EndUpdate;
	  end;
      end;
      UpdateStatusLine(lEO);
    end;
end;

procedure tMainForm.UpdateListView(ResList: tExeObjList);
var
  I: Integer;
begin
  ListView.Items.BeginUpdate;
  try
    ListView.Items.Clear;
    for I := 0 to ResList.Count - 1 do
      with ResList[I], ListView.Items.Add do begin
	Data       := ResList[I];
	Caption    := Name;
	ImageIndex := ImageMap[ImageTypeIndex];
	SubItems.Add(Format('%.7x', [Offset]));
	SubItems.Add(Format('%.5x', [Size]));
      end;
    ActivePage := piListView;
  finally
    ListView.Items.EndUpdate;
  end;
end;

procedure tMainForm.UpdateStatusLine(ResItem: tExeObjItem);
begin
  if ResItem.IsList then begin
    StatusBar.Panels[0].Text := Format(' %d object(s)', [ListView.Items.Count]);
    StatusBar.Panels[1].Text := Format(' Offset: %x', [ResItem.Offset]);
  end
  else with ResItem do begin
    StatusBar.Panels[0].Text := '';
    StatusBar.Panels[1].Text := Format(' Offset: %x  Size: %x', [Offset, Size]);
  end;
end;

{ Form Initialization }

const
  regAppName	= 'ResourceExplorer';
  LastPathStr	= 'LastPath';

procedure tMainForm.RestoreSettings;
begin
  RegLoadControl(Self, regAppName);
  RegLoadControl(TreeViewPanel, regAppName);
  RegLoadControl(FileDirPanel, regAppName);
  RegLoadControl(DLB1, regAppName);
  RegLoadToolbarPositions(Self, regRoot + regAppName);
  TBB_Switch.Down := (GetRegInt(regAppName, 'TBB_SW.Down', Ord(True)) = Ord(True));
  SB_ASK.Down     := (GetRegInt(regAppName, 'SB_ASK.Down', Ord(False)) = Ord(True));
end;

procedure tMainForm.FormCreate(Sender: TObject);
var
  lS: string;
begin
  fHistory := tStringList.Create;
  RestoreSettings;
  CheckASKButton;
  CheckTBBSwDown;
  DockLeft.Left := TreeViewPanel.Left - 1;
  HexDump := CreateHexDump(TS7);
  FOD.Filter := SOpenFilter;
  FSD.Filter := SSaveFilter;
  Small.ResourceLoad(itBitmap, 'SmallImages', clOlive);
  Large.ResourceLoad(itBitmap, 'LargeImages', clOlive);
  ActivePage := piIntro;
  fInBackChange := True;
  try
    if (ParamCount > 0) then SetFile(ParamStr(1))
    else begin
      lS := GetRegStr(regAppName, LastPathStr, '');
      if (lS <> '') then DLB1.Directory := lS;
    end;
    FLB1.Mask  := FCB1.Mask;
    Memo1.Text := 'Welcome to Resource Explorer.'#13#10'  (Hint: try to extract MANUAL from ResXplor.Exe)';
    fOldDir    := DLB1.Directory;
    HistoryPtr := 0;
  finally
    fInBackChange := False;
  end;
  DragAcceptFiles(Handle, True);
end;

procedure tMainForm.SetFile(const aName: string);
begin
  if FileExists(aName) then
    if (aName <> fFileName) then begin
      fFileName  := aName;
      isUpdating := True;
      TreeView.Items.Clear;
      isUpdating := False;
      fExeFile.Free;
      fExeFile   := tExeImage.Create(Self, aName);
      if (fExeFile.Error = 2) then ErrorCaption := 'Unknown new-executable format.'
			      else DisplayResources;
    end
    else	// already displaying this file
  else begin
    isUpdating   := True;
    TreeView.Items.Clear;
    isUpdating   := False;
    ActivePage   := piIntro;
    fFileName    := '';
    ErrorCaption := 'Hello!';
  end;
  TBB_Save.Enabled := False;
end;

procedure tMainForm.ListViewEnter(Sender: TObject);
begin
  with ListView do
    if (Items.Count > 1) and (Selected = nil) then
    begin
      Selected := Items[0];
      ItemFocused := Selected;
    end;
end;

procedure tMainForm.DoSaveRes;
var
  ResItem: TResourceitem;

  function TreeViewResourceSelected: Boolean;
  begin
    Result := Assigned(TreeView.Selected) and
	      Assigned(TreeView.Selected.Data) and
	      (tObject(TreeView.Selected.Data) is tResourceItem) and
	      not tResourceItem(TreeView.Selected.Data).IsList;
    if Result then ResItem := tResourceItem(TreeView.Selected.Data);
  end;

  function ListViewResourceSelected: Boolean;
  begin
    Result := Assigned(ListView.Selected) and
	      Assigned(ListView.Selected.Data) and
	      (tObject(ListView.Selected.Data) is tResourceItem) and
	      not tResourceItem(ListView.Selected.Data).IsList;
    if Result then ResItem := tResourceItem(ListView.Selected.Data);
  end;

begin
  if TreeViewResourceSelected or ListViewResourceSelected then with FSD do begin
    FilterIndex := GetResFiltMap(ResItem.ResType);
    FileName := ResItem.Name + '.' + GetDefExt(ResItem.ResType);
    if Execute then ResItem.SaveToFile(FileName);
  end
  else Error(SNoResSelected);
end;

procedure tMainForm.SelectListViewType(Sender: TObject);
begin
  ListView.ViewStyle := TViewStyle(TComponent(Sender).Tag);
end;

procedure tMainForm.TreeViewChange(Sender: TObject; Node: TTreeNode);
var
  lC: Integer;
begin
  if Assigned(Node) and not Node.Deleting and not IsUpdating then UpdateViewPanel;
  {$B-}
  if not IsUpdating then
    with TreeView do begin
      lC := Selected.Count;
      TBB_Save.Enabled := Assigned(Selected) and (lC < 1) and Assigned(Selected.Data) and (tObject(Selected.Data) is tResourceItem);
      if Assigned(Selected) and (lC > 0) and (Selected <> fCollapsedNode) then Selected.Expand(False);
    end;
end;

procedure tMainForm.Fullexpand1Click(Sender: TObject);
begin
  TreeView.FullExpand;
end;

procedure tMainForm.Fullcollapse1Click(Sender: TObject);
begin
  TreeView.FullCollapse;
end;

procedure tMainForm.PM2Popup(Sender: TObject);
var
  lN: tTreeNode;
  lL: tListItem;
begin
  {$B-}
  lN := TreeView.Selected;
  lL := ListView.Selected;
  SaveAs1.Enabled := (Assigned(lN) and (lN.Count < 1) and Assigned(lN.Data) and (tObject(lN.Data) is tResourceItem)) or
		     (Assigned(lL) and Assigned(lL.Data) and (tObject(lL.Data) is tResourceItem));
  Saveresource1.Enabled := SaveAs1.Enabled;
end;

procedure tMainForm.SetEC(const aErrorCaption: string);
begin
  ActivePage := piIntro;
  Label1.Caption := aErrorCaption;
end;

procedure tMainForm.ListViewChange(Sender: TObject; Item: TListItem; Change: TItemChange);
var
  lL: tListItem;
begin
  lL := ListView.Selected;
  TBB_Save.Enabled := Assigned(lL) and Assigned(lL.Data) and (tObject(lL.Data) is tResourceItem);
end;

procedure tMainForm.MPlayerNotify(Sender: TObject);
var
  lBuf: array[0..MAX_PATH] of Char;
begin
  MPlayer.Close;
  StrPCopy(lBuf, MediaFile);
  DeleteFile(lBuf);
  ErrorCaption := 'To play again, select again.';
end;

procedure tMainForm.MyMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  (Sender as tForm).Close;
end;

procedure tMainForm.SetActivePage(const Value: Integer);
var
    i: Integer;
  lTS: tTabSheet;
begin
  if (fActivePage <> Value) then begin
    case Value of
      piListView : lTS := TS1;
      piImage    : lTS := TS2;
      piStrings  : lTS := TS3;
      piVerInfo  : lTS := TS4;
      piIntro    : lTS := TS5;
      piMMedia   : lTS := TS6;
      piHexDump  : lTS := TS7;
      piExeObject: lTS := TS8;
      else         lTS := nil;
    end;
    if Assigned(lTS) then begin
      for i := 0 to PCMain.PageCount - 1 do PCMain.Pages[i].TabVisible := (PCMain.Pages[i] = lTS);
      PCMain.ActivePage := lTS;
      fActivePage       := Value;
      // f*kin' bug in Delphi4's PageControl?
      if StringViewer.Showing then StringViewer.Align := alClient;
      if TS2.Showing          then ImageViewer.Align  := alClient;
      if ListView.Showing     then ListView.Align     := alClient;
      if PCExe.Showing        then PCExe.Align        := alClient;
    end;
  end;
end;

procedure tMainForm.TBB_OpenClick(Sender: TObject);
begin
  with FOD do
    if Execute then begin
      DLB1.Directory := ExtractFilePath(FileName);
      SetFile(FileName);
    end;
end;

procedure tMainForm.TBB_SaveClick(Sender: TObject);
begin
  DoSaveRes;
end;

procedure tMainForm.CheckTBBSwDown;
begin
  if TBB_Switch.Down then begin
    Panel2.Show;
    FileDirPanel.Show;
    Mover1.Show;
  end
  else begin
    Mover1.Hide;
    FileDirPanel.Hide;
    Panel2.Hide;
  end;
end;

procedure tMainForm.TBB_SwitchClick(Sender: TObject);
begin
  CheckTBBSwDown;
end;

procedure tMainForm.TBB_AboutClick(Sender: TObject);
begin
  ShowAboutBox;
end;

procedure tMainForm.TBB_ExitClick(Sender: TObject);
begin
  Close;
end;

procedure tMainForm.SaveSettings;
begin
  RegSaveControl(Self, regAppName);
  RegSaveControl(TreeViewPanel, regAppName);
  RegSaveControl(FileDirPanel, regAppName);
  RegSaveControl(DLB1, regAppName);
  SetRegStr(regAppName, LastPathStr, DLB1.Directory);
  RegSaveToolBarPositions(Self, regRoot + regAppName);
  SetRegInt(regAppName, 'TBB_SW.Down', Ord(TBB_Switch.Down));
  SetRegInt(regAppName, 'SB_ASK.Down', Ord(SB_ASK.Down));
end;

procedure tMainForm.FormDestroy(Sender: TObject);
begin
  SaveSettings;
end;

procedure tMainForm.FLB1Click(Sender: TObject);
begin
  SetFile(FLB1.FileName);
end;

procedure tMainForm.FLB1Change(Sender: TObject);
begin
  SetFile(FLB1.FileName);
end;

procedure tMainForm.TreeViewCollapsing(Sender: TObject; Node: TTreeNode; var AllowCollapse: Boolean);
begin
  fCollapsedNode := Node;
  AllowCollapse := True;
end;

procedure tMainForm.Saveas1Click(Sender: TObject);
begin
  DoSaveRes;
end;

procedure tMainForm.Saveresource1Click(Sender: TObject);
begin
  DoSaveRes;
end;

procedure tMainForm.TreeViewMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  Node: tTreeNode;
begin
  if Assigned(TreeView.Selected) and (Button = mbRight) then begin
    Node := TreeView.GetNodeAt(X, Y);
    if Assigned(Node) then TreeView.Selected := Node;
  end;
end;

procedure tMainForm.TreeViewCollapsed(Sender: TObject; Node: TTreeNode);
begin
  fCollapsedNode := nil;
end;

procedure tMainForm.RescanFiles;
var
  i: Integer;
begin
  i := 0;
  while (i < FLB1.Items.Count) do begin
    with tExeImage.Create(Self, FLB1.Directory + '\' + FLB1.Items[i]) do try
      if (ImageType = itNone) then begin
	FLB1.Items.Delete(i);
	Dec(i);
      end;
    finally
      Free;
    end;
    Inc(i);
  end;
end;

procedure tMainForm.DLB1Change(Sender: TObject);
begin
  if not fInBackChange then begin
    fHistory.Add(fOldDir);
    fOldDir := DLB1.Directory;
    HistoryPtr := fHistory.Count;
  end;
  if SB_ASK.Down then RescanFiles;
end;

procedure tMainForm.SetHistoryPtr(const Value: Integer);
begin
  fHistoryPtr := Value;
  SB_Back.Enabled := (Value > 0);
  if SB_Back.Enabled then SB_Back.Hint := 'Back to ' + fHistory[fHistoryPtr - 1]
		     else SB_Back.Hint := '';
end;

procedure tMainForm.SB_BackClick(Sender: TObject);
begin
  if (HistoryPtr > 0) then begin
    fInBackChange := True;
    try
      HistoryPtr := HistoryPtr - 1;
      fOldDir    := fHistory[HistoryPtr];
      DLB1.Directory := fOldDir;
    finally
      fInBackChange := False;
    end;
  end;
end;

// this routine written by Alexander Herchanovsky
procedure tMainForm.WMDropFiles(var Msg: TMessage);
var
  Fname : String;
  TempFile: array[0..255] of Char;
  //Icon : TIcon;
  Drop : THandle; {Handle for Msg.wParam}
  i,{K,}
  NumFiles, NameLength : integer;
  DirName, ShortName, OldMask: string;
begin
  try
    screen.cursor := crHourglass;
    Drop := Msg.wParam;
    {Query how many files were dropped on the app}
    NumFiles := DragQueryFile(Drop, Cardinal(-1), Nil, 0);
    case NumFiles of
      0: ;
      1: begin
	  NameLength := DragQueryFile(Drop, 0, Nil , 0);
	  DragQueryFile(Drop, 0, TempFile, NameLength+1);
	  FName := StrPas(TempFile);
	  SetFile(Fname);
	  DirName:= Fname;
	  for i:=length(DirName) downto 1 do
	    if DirName[i]='\' then break;
	  System.Delete(DirName,i,255);
//          DLB1.Directory:=DirName;
//          if Fname[2]=':' then
//            DriveComboBox1.Drive:=UpCase(Fname[1]);
	  ShortName:=System.Copy( Fname, i+1, 255 );
	  OldMask:=FLB1.Mask;
	  FLB1.ApplyFilePath(Fname);
	  FLB1.Mask:=OldMask;
	  if FLB1.FileName='' then
	  begin
	    FLB1.Mask:='*.*';
	    FLB1.ApplyFilePath(Fname);
	  end;
{          FLB1.FileName := Fname;//ShortName;
	  FLB1.Update;}
	end;
      else
	ShowMessage('Could not accept more than one file.');
    end;
  finally
    screen.cursor := crDefault;
  end; {main begin}
end;  {WMDropFiles}

procedure tMainForm.CheckASKButton;
begin
  FCB1.Visible := not SB_ASK.Down;
  if SB_ASK.Down then begin
    FLB1.Mask := '*.*';
    RescanFiles;
  end
  else FLB1.Mask := FCB1.Mask;	// restore old mask
end;

procedure tMainForm.SB_ASKClick(Sender: TObject);
begin
  CheckASKButton;
end;

end.

