
// www.borland.... oops, WWW.Inprise.Com
// AlexSh@Adm.Univd.Kharkov.UA

unit ExeImage;

interface

uses
  TypInfo, Classes, SysUtils, Windows, Graphics, RXTypes;

type
  // types
  tExeObjListType = (otNone, otRoot, otRootDir, otHeaders, otSections, otListView, otListBox);
  tImageType = (itNone, itDOS, itNE, itPE, itLX, itLE);

  // Exceptions
  eExeError = class(Exception);

  // forward declarations
  //tExeObjItem = class;
  //tExeObjClass = class of tExeObjItem;
  tExeObjList = class;
  tExeImage   = class;

  tResourceItem  = class;
  tResourceClass = class of tResourceItem;
  //tResourceList  = class;

  // tExexObjItem

  tExeObjItem = class(tComponent)
  private
    fList: tExeObjList;
    fType: tExeObjListType;
    fBase: Pointer;
    function GetExeImage: tExeImage;
    function GetEOItem(aIndex: Integer): tExeObjItem;
    function GetImageType: tImageType;
    function DoGetImageTypeIndex: tResourceType;
  protected
    function GetEOList : tExeObjList; virtual;
    function GetName   : string;   virtual; abstract;
    function GetOffset : LongWord; virtual;
    function GetSize   : Integer; virtual;
    function GetIsList : Boolean;  virtual; abstract;
    function GetRawData: Pointer;  virtual;
    function GetImageTypeIndex: tResourceType; virtual;
  public
    constructor Create(aOwner: tComponent; aBase: Pointer; aType: tExeObjListType); reintroduce;
    procedure SaveToFile(const aFileName: string);
    procedure SaveToStream(aStream: tStream); virtual;
    procedure AssignLVValues(Dest: tStrings); virtual;
    function AssignLBValues: string; virtual;
    //
    property IsList   : Boolean read GetIsList;
    property Size     : Integer read GetSize;
    property Offset   : LongWord read GetOffset;
    property ExeImage : tExeImage read GetExeImage;
    property ImageType: tImageType read GetImageType;
    property List     : tExeObjList read GetEOList;
    property Name     : string read GetName;
    property Items[aIndex: Integer]: tExeObjItem read GetEOItem; default;
    property RawData  : Pointer read GetRawData;
    property ImageTypeIndex: tResourceType read DoGetImageTypeIndex;
    property OType    : tExeObjListType read fType;
  end;

  // tRootItem

  tRootItem = class(tExeObjItem)
  private
    function GetName: string; override;
  protected
    function GetIsList: Boolean; override;
  end;

  // tHeaderItem

  tHeaderItem = class(tExeObjItem)
  private
    function GetName: string; override;
  protected
    function GetOffset : LongWord; override;
    function GetIsList: Boolean; override;
  end;

  // tDosHeaderItem

  tDosHeaderItem = class(tHeaderItem)
    procedure AssignLVValues(Dest: tStrings); override;
  end;

  // tNewHeaderItem

  tNewHeaderItem = class(tHeaderItem)
    procedure AssignLVValues(Dest: tStrings); override;
  end;

  // tSectionItem

  tSectionItem = class(tExeObjItem)
  private
    function GetName: string; override;
  protected
    function GetIsList: Boolean; override;
  end;

  // tPEObjectsItem

  tPEObjectsItem = class(tSectionItem)
  private
    function GetName: string; override;
  public  
    function AssignLBValues: string; override;
  end;

  // tResourceItem

  tResourceItem = class(tExeObjItem)
  private
    fDirEntryPE    : pIMAGE_RESOURCE_DIRECTORY_ENTRY;
    fDescriptionNE : pImageNE_Resource_Description;
    fDirectoryNE   : pImageNE_Resource_Group;
    function DataEntry: pIMAGE_RESOURCE_DATA_ENTRY;
    function FirstChildDirEntry: pIMAGE_RESOURCE_DIRECTORY_ENTRY;
    function GetIsRoot: Boolean;
    function GetID: LongWord;
    function GetResourceType: Integer;
    function GetImageTypeIndex: tResourceType; override;
  protected
    function GetName    : string; override;
    function GetGoodName: string;
    function GetEOList  : tExeObjList; override;
    procedure AssignTo(Dest: tPersistent); override;
    function GetOffset  : LongWord; override;
    function GetSize    : Integer; override;
    function GetRawData : Pointer; override;
    function GetIsList  : Boolean; override;
  public
    constructor Create(aOwner: tComponent; aDirEntry: Pointer); reintroduce;
    function ResTypeStr: string;
    //
    property GoodName	 : string read GetGoodName;
    property IsRoot      : Boolean read GetIsRoot;
    property ID		 : LongWord read GetID;
    property ResType     : Integer read GetResourceType;
  end;

  // tIconResource

  tIconResource = class(tResourceItem)
  protected
    function GetEOList: tExeObjList; override;
    function GetIsList: Boolean; override;
  end;

  // tIconResEntry

  tIconResEntry = class(tResourceItem)
  private
    fResInfo: pIconResInfo;
  protected
    function GetName: string; override;
    procedure AssignTo(Dest: tPersistent); override;
  public
    procedure SaveToStream(Stream: tStream); override;
  end;

  // tCursorResource

  tCursorResource = class(tIconResource)
  protected
    function GetEOList: tExeObjList; override;
  end;

  // tCursorResEntry

  tCursorResEntry = class(tIconResEntry)
  private
    fResInfo: pCursorResInfo;
  protected
    function GetName: string; override;
  end;

  // tBitmapResource

  tBitMapResource = class(tResourceItem)
  protected
  public
    procedure SaveToStream(Stream: tStream); override;
  end;

  // tStringResource

  tStringResource = class(TResourceItem)
  protected
    procedure AssignTo(Dest: tPersistent); override;
  end;

  // tMenuResource

  tMenuResource = class(tResourceItem)
  private
    fNestStr  : string;
    fNestLevel: Integer;
    procedure SetNestLevel(Value: Integer);
  protected
    procedure AssignTo(Dest: tPersistent); override;
    //
    property NestLevel: Integer read fNestLevel write SetNestLevel;
    property NestStr  : string read fNestStr;
  end;

  // tExeObjList

  tExeObjList = class(tComponent)
  private
    fList    : tList;
    fExeImage: tExeImage;
    fBase    : Pointer;
    function GetCount: Integer;
    function GetEOItem(aIndex: Integer): tExeObjItem;
    function GetImageType: tImageType;
  protected
    function GetList: tList; virtual;
  public
    constructor Create(aOwner: tComponent; aType: tExeObjListType; aBase: Pointer; aExeImage: tExeImage); reintroduce;
    destructor  Destroy; override;
    //
    property List     : tList     read GetList;
    property Base     : Pointer   read fBase;
    property ExeImage : tExeImage read fExeImage;
    property Count    : Integer   read GetCount;
    property Items[aIndex: Integer]: tExeObjItem read GetEOItem; default;
    property ImageType: tImageType read GetImageType;
  end;

  // tResourceList

  tResourceList = class(tExeObjList)
  private
    fResDirPE: pIMAGE_RESOURCE_DIRECTORY;
    fResDirNE: pImageNE_Resource_Group;
    fResType : Integer;
    function GetNEAligment: Integer;
  protected
    function GetList: tList; override;
  public
    constructor Create(aOwner: tComponent; aBase: LongWord; aExeImage: tExeImage); reintroduce;
    //
    property AligmentNE: Integer read GetNEAligment;
  end;

  // tIconResourceList

  tIconResourceList = class(tResourceList)
  protected
    function GetList: tList; override;
  end;

  // tCursorResourceList

  tCursorResourceList = class(tResourceList)
  protected
    function GetList: tList; override;
  end;

  // tExeImage
  tExeImage = class(tComponent)
  private
    fFileName	 : string;
    fFileHandle	 : tHandle;
    fFileMapping : tHandle;
    fFileBase	 : Pointer;
    fDosHeader	 : pIMAGE_DOS_HEADER;
    fNTHeader	 : pIMAGE_NT_HEADERS;
    fOS2Header	 : pImage_OS2_Header;
    fResourceList: tResourceList;
    //fExeObjList  : tExeObjList;
    fIconResources  : tResourceItem;
    fCursorResources: tResourceItem;
    fResourceBase: LongWord;
    fResourceRVA : LongWord;
    fImageType   : tImageType;
    function GetResourceList: tResourceList;
    function GetSectionHdr(const SectionName: string; var Header: pIMAGE_SECTION_HEADER): Boolean;
  public
    Error: Integer;
    constructor Create(aOwner: tComponent; const aFileName: string); reintroduce;
    destructor Destroy; override;
    //
    property FileName : string read fFileName;
    property Resources: tResourceList read GetResourceList;
    property ImageType: tImageType read fImageType;
    property DosHeader: pIMAGE_DOS_HEADER read fDosHeader;
    property NTHeader : pIMAGE_NT_HEADERS read fNTHeader;
    property OS2Header: pImage_OS2_Header read fOS2Header;
  end;

implementation

uses
  HomeTool, JPeg;

// This function maps a resource type to the associated resource class
function GetResourceClass(ResType: Integer): tResourceClass;
const
  tResourceClasses: array[tResourceType] of tResourceClass = (
    tResourceItem,      { rtUnknown0 }
    tCursorResEntry,    { rtCursorEntry }
    tBitmapResource,    { rtBitmap }
    tIconResEntry,      { rtIconEntry }
    tMenuResource,      { rtMenu }
    tResourceItem,      { rtDialog }
    tStringResource,    { rtString }
    tResourceItem,      { rtFontDir }
    tResourceItem,      { rtFont }
    tResourceItem,      { rtAccelerators }
    tResourceItem,      { rtRCData }
    tResourceItem,      { rtMessageTable }
    tCursorResource,    { rtGroupCursor }
    tResourceItem,      { rtUnknown13 }
    tIconResource,      { rtIcon }
    tResourceItem,      { rtUnknown15 }
    tResourceItem);     { rtVersion }

begin
  if GoodType(ResType) then Result := tResourceClasses[tResourceType(ResType)]
		       else Result := tResourceItem;
end;

// This function checks if an offset is a string name, or a directory
// Assumes: IMAGE_RESOURCE_NAME_IS_STRING = IMAGE_RESOURCE_DATA_IS_DIRECTORY
function HighBitSet(L: LongWord): Boolean;
begin
  Result := (L and IMAGE_RESOURCE_DATA_IS_DIRECTORY) <> 0;
end;

function StripHighBit(L: LongWord): LongWord;
begin
  Result := (L and IMAGE_OFFSET_STRIP_HIGH);
end;

function StripHighPtr(L: LongWord): Pointer;
begin
  Result := Pointer(L and IMAGE_OFFSET_STRIP_HIGH);
end;

// This function converts a pointer to a wide char string into a pascal string
function WideCharToStr(WStr: PWChar; Len: Integer): string;
begin
  if (Len = 0) then Len := lstrlenw(WStr);
  SetLength(Result, Len);
  WideCharToMultiByte(CP_ACP, 0, WStr, Len, PChar(Result), Len, nil, nil);
end;

  { Exceptions }

procedure ExeError(const ErrMsg: string);
begin
  raise eExeError.Create(ErrMsg);
end;

  { tExeImage }

constructor tExeImage.Create(aOwner: TComponent; const aFileName: string);
var
  P: ^Word;
  L: ^LongWord;
begin
  inherited Create(aOwner);
  fImageType  := itNone;
  fFileName   := aFileName;
  fFileHandle := CreateFile(pChar(fFileName), GENERIC_READ, FILE_SHARE_READ + FILE_SHARE_WRITE, nil, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, 0);
  if (fFileHandle = INVALID_HANDLE_VALUE) or (FileSeek(fFileHandle, 0, 2) < 1) then Error := 3
  else begin
    fFileMapping := CreateFileMapping(fFileHandle, nil, PAGE_READONLY, 0, 0, nil);
    if (fFileMapping = 0) then ExeError('CreateFileMapping failed');
    fFileBase := MapViewOfFile(fFileMapping, FILE_MAP_READ, 0, 0, 0);
    if (fFileBase = nil) then ExeError('MapViewOfFile failed');
    fDosHeader := pIMAGE_DOS_HEADER(fFileBase);
    if not (fDosHeader.e_magic = IMAGE_DOS_SIGNATURE) then Error := 8
    else begin
      if (fDosHeader.e_lfanew < LongWord(FileSeek(fFileHandle, 0, 2))) and
	 ((fDosHeader.e_lfarlc + fDosHeader.e_crlc shl 2) <= fDosHeader.e_lfanew) then begin
	P := Pointer(LongWord(fFileBase) + fDosHeader.e_lfanew);
	L := Pointer(P);
	if (P^ = IMAGE_OS2_SIGNATURE)    then fImageType := itNE
	else
	if (P^ = IMAGE_OS2_SIGNATURE_LE) then fImageType := itLE
	else
	if (P^ = IMAGE_LX_SIGNATURE)     then fImageType := itLX
	else
	if (L^ = IMAGE_NT_SIGNATURE)     then fImageType := itPE
	else begin
	  fImageType := itDOS;
	  Error := 2;
	end;
	// assign header
	if (fImageType = itPE) then fNTHeader  := pIMAGE_NT_HEADERS(L)
	else
	if (fImageType = itNE) then fOS2Header := pImage_OS2_Header(P);
	Error := 0;
      end
      else fImageType := itDOS;
    end;
  end;
end;

destructor tExeImage.Destroy;
begin
  if (fFileHandle <> INVALID_HANDLE_VALUE) then begin
    UnmapViewOfFile(fFileBase);
    CloseHandle(fFileMapping);
    CloseHandle(fFileHandle);
  end;
  inherited Destroy;
end;

function tExeImage.GetSectionHdr(const SectionName: string; var Header: pIMAGE_SECTION_HEADER): Boolean;
var
  I: Integer;
begin
  Header := pIMAGE_SECTION_HEADER(fNTHeader);
  Inc(pIMAGE_NT_HEADERS(Header));
  Result := True;
  for I := 0 to fNTHeader.FileHeader.NumberOfSections - 1 do begin
    if (Strlicomp(Header.Name, pChar(SectionName), IMAGE_SIZEOF_SHORT_NAME) = 0) then Exit;
    Inc(Header);
  end;
  Result := False;
end;

function tExeImage.GetResourceList: tResourceList;
var
  ResSectHdr: pIMAGE_SECTION_HEADER;
begin
  Error := 0;
  if not Assigned(fResourceList) then begin
    // add resources
    fResourceBase := 0;
    fResourceRVA  := 0;
    if (fImageType = itPE) then
      if GetSectionHdr('.rsrc', ResSectHdr) then begin
	fResourceBase := ResSectHdr.PointerToRawData + LongWord(fDosHeader);
	fResourceRVA  := ResSectHdr.VirtualAddress;
      end
      else
    else
    if (fImageType = itNE) then fResourceBase := LongWord(fDosHeader) + fDosHeader.e_lfanew + fOS2Header.ResourceTableOffset;
    fResourceList := tResourceList.Create(Self, fResourceBase, Self);
    // now add other sections
    // (note, what by referencing List we will create it!)
    fResourceList.List.Add(tRootItem.Create(fResourceList, nil, otRootDir));
  end;
  Result := fResourceList;
end;

  { tResourceItem }

constructor tResourceItem.Create(aOwner: tComponent; aDirEntry: Pointer);
begin
  inherited Create(aOwner, aDirEntry, otNone);
  if (ImageType = itPE) then fDirEntryPE := aDirEntry
  else
  if (ImageType = itNE) then
    if IsRoot then fDirectoryNE := aDirEntry
	      else fDescriptionNE := aDirEntry;
end;

function tResourceItem.DataEntry: pIMAGE_RESOURCE_DATA_ENTRY;
begin
  if (ImageType = itPE) then Result := pIMAGE_RESOURCE_DATA_ENTRY(FirstChildDirEntry.OffsetToData + ExeImage.fResourceBase)
			else Result := nil;
end;

function tResourceItem.FirstChildDirEntry: pIMAGE_RESOURCE_DIRECTORY_ENTRY;
begin
  if (ImageType = itPE) then Result := pIMAGE_RESOURCE_DIRECTORY_ENTRY(StripHighBit(fDirEntryPE.OffsetToData) + ExeImage.fResourceBase + LongWord(SizeOf(IMAGE_RESOURCE_DIRECTORY)))
			else Result := nil;
end;

function tResourceItem.GetResourceType: Integer;
begin
  Result := (Owner as tResourceList).fResType;
end;

function tResourceItem.GetIsList: Boolean;
begin
  if (ImageType = itPE) then Result := HighBitSet(FirstChildDirEntry.OffsetToData)
  else
  if (ImageType = itNE) then Result := IsRoot
  else
    Result := False;
end;

function tResourceItem.GetEOList: tExeObjList;
begin
  if not IsList then ExeError('ResourceItem is not a list');
  if not Assigned(fList) then
    if (ImageType = itPE) then fList := tResourceList.Create(Self, StripHighBit(fDirEntryPE.OffsetToData) + ExeImage.fResourceBase, ExeImage)
    else
    if (ImageType = itNE) then fList := tResourceList.Create(Self, LongWord(fBase), ExeImage);
  Result := fList;
end;

function tResourceItem.GetGoodName: string;
begin
  if (ImageType = itPE) then
    if (IsRoot and not HighBitSet(fDirEntryPE.Name) and (fDirEntryPE.Name <= 16)) or
      HighBitSet(fDirEntryPE.Name) then Result := GetName
				   else Result := '#' + GetName
  else
  if (ImageType = itNE) then Result := 'Good Name';
end;

function tResourceItem.GetName: string;
var
  DirStr: pIMAGE_RESOURCE_DIR_STRING_U;

  function Word2Name(aWord: Word; AsType: Boolean): string;
  var
    fBase: Pointer;
    B    : ^Byte;
  begin
    fBase := ExeImage.fResourceList.fBase;
    if ((aWord and $8000) <> 0) then
      if AsType then Result := Copy(GetEnumName(TypeInfo(tResourceType), aWord and $7FFF), 3, 20)
		else Result := IntToStr(aWord and $7FFF)
    else begin
      B := Pointer(LongWord(fBase) + aWord);
      SetLength(Result, B^);
      Inc(B);
      Move(B^, Result[1], Length(Result));
    end;
  end;

begin
  { Check for Level1 entries, these are resource types. }
  if (ImageType = itPE) then
    if IsRoot and not HighBitSet(fDirEntryPE.Name) and (fDirEntryPE.Name <= 16) then Result := Copy(GetEnumName(TypeInfo(tResourceType), fDirEntryPE.Name), 3, 20)
    else
      if HighBitSet(fDirEntryPE.Name) then begin
	DirStr := pIMAGE_RESOURCE_DIR_STRING_U(StripHighBit(fDirEntryPE.Name) + ExeImage.fResourceBase);
	Result := WideCharToStr(@DirStr.NameString, DirStr.Length);
      end
      else Result := Format('%d', [fDirEntryPE.Name])
  else
  if (ImageType = itNE) then
    if IsRoot then Result := Word2Name(fDirectoryNE.ResourceType, True)
	      else Result := Word2Name(fDescriptionNE.ResourceName, False)
  else
    Result := 'none?';
end;

function tResourceItem.GetOffset: LongWord;
begin
  case ImageType of
    itPE: if IsList then Result := StripHighBit(fDirEntryPE.OffsetToData)
		    else Result := DataEntry.OffsetToData;
    itNE: if IsRoot then Result := Integer(fDirectoryNE) - Integer(ExeImage.fFileBase)
		    else Result := Integer(fDescriptionNE) - Integer(ExeImage.fFileBase);
    else Result := 0;
  end;
end;

function tResourceItem.GetRawData: Pointer;
begin
  case ImageType of
    itPE: with ExeImage do Result := Pointer(fResourceBase - fResourceRVA + DataEntry.OffsetToData);
    itNE: if isRoot then Result := fBase
		    else Result := Pointer(LongWord(ExeImage.fDosHeader) + fDescriptionNE.ResourceOffset shl tResourceList(Owner).AligmentNE);
    else Result := nil;
  end;
end;

function tResourceItem.ResTypeStr: string;
begin
  Result := Copy(GetEnumName(TypeInfo(tResourceType), Ord(ResType)), 3, 20);
end;

function tResourceItem.GetSize: Integer;
begin
  if (ImageType = itPE) then
      if IsList then Result := -1
		else Result := DataEntry.Size
  else
  if (ImageType = itNE) then
    if IsRoot then Result := SizeOf(ImageNE_Resource_Group) + fDirectoryNE.ResourceCount * SizeOf(ImageNE_Resource_Description)
	      else Result := fDescriptionNE.ResourceLength shl tResourceList(Owner).AligmentNE
  else
    Result := -1;
end;

procedure tResourceItem.AssignTo(Dest: TPersistent);
var
  MemStr: TMemoryStream;
  BitMap: TBitMap;
  JI    : tJpegImage;
begin
  BitMap := nil;
  if (Dest is TBitmap) then BitMap  := TBitmap(Dest)
  else
    if (Dest is tPicture) then BitMap := TPicture(Dest).Bitmap;
  if Assigned(BitMap) then begin
    MemStr := TMemoryStream.Create;
    try
      SaveToStream(MemStr);
      MemStr.Seek(0, 0);
      if (Dest is TBitmap) then BitMap.LoadFromStream(MemStr)
      else begin
	JI := tJpegImage.Create;
	with JI do try
	  LoadFromStream(MemStr);
	  BitMap.Assign(JI);
	finally
	  Free;
	end;
      end;
    finally
      MemStr.Free;
    end
  end
  else inherited AssignTo(Dest);
end;

function tResourceItem.GetIsRoot: Boolean;
begin
  Result := (Owner.Owner = ExeImage);
end;

function tResourceItem.GetID: LongWord;
begin
  case ImageType of
    itPE: Result := fDirEntryPE.Name;
    itNE: Result := (fDescriptionNE.ResourceName and $7FFF);
    else  Result := 0;
  end;
end;

function tResourceItem.GetImageTypeIndex: tResourceType;
begin
  if GoodType(ResType) then Result := tResourceType(ResType)
		       else Result := rtUnknown0;
end;
          
  { tBitmapResource }

procedure tBitmapResource.SaveToStream(Stream: TStream);

  function GetDInColors(BitCount: Word): Integer;
  begin
    case BitCount of
      1, 4, 8: Result := 1 shl BitCount;
      else     Result := 0;
    end;
  end;

var
  BH: tBitmapFileHeader;
  BI: pBitmapInfoHeader;
  BC: pBitmapCoreHeader;
  ClrUsed: Integer;
begin
  FillChar(BH, sizeof(BH), #0);
  BH.bfType := $4D42;
  BH.bfSize := Self.Size + sizeof(BH);
  BI := PBitmapInfoHeader(RawData);
  if (BI.biSize = SizeOf(TBitmapInfoHeader)) then begin
    ClrUsed := BI.biClrUsed;
    if (ClrUsed = 0) then ClrUsed := GetDInColors(BI.biBitCount);
    BH.bfOffBits := ClrUsed * SizeOf(TRgbQuad) + sizeof(tBitmapInfoHeader) + SizeOf(BH);
  end
  else begin
    BC := pBitmapCoreHeader(RawData);
    ClrUsed := GetDInColors(BC.bcBitCount);
    BH.bfOffBits :=  ClrUsed * SizeOf(TRGBTriple) + SizeOf(tBitmapCoreHeader) + SizeOf(BH);
  end;
  Stream.Write(BH, SizeOf(BH));
  Stream.Write(RawData^, Self.Size);
end;

  { tIconResource }

function tIconResource.GetEOList: tExeObjList;
begin
  if not Assigned(fList) then fList := tIconResourceList.Create(Owner, LongWord(RawData), ExeImage);
  Result := fList;
end;

function tIconResource.GetIsList: Boolean;
begin
  Result := True;
end;

  { tIconResEntry }

procedure tIconResEntry.AssignTo(Dest: TPersistent);
var
  hIco: HIcon;
begin
  if (Dest is tIcon) then begin
    hIco := CreateIconFromResource(RawData, Size, (ResType = Ord(rtIconEntry)), $30000);
    tIcon(Dest).Handle := hIco;
  end
  else inherited AssignTo(Dest);
end;

function tIconResEntry.GetName: string;
begin
  if Assigned(fResInfo) then
    with fResInfo^ do Result := Format('%d X %d %d Colors', [bWidth, bHeight, bColorCount])
  else
    Result := inherited GetName;
end;

procedure tIconResEntry.SaveToStream(Stream: tStream);
begin
  with tIcon.Create do
  try
    Handle := CreateIconFromResource(RawData, Self.Size, (ResType <> Ord(rtIcon)), $30000);
    SaveToStream(Stream);
  finally
    Free;
  end;
end;

  { TCursorResource }

function tCursorResource.GetEOList: tExeObjList;
begin
  if not Assigned(fList) then fList := tCursorResourceList.Create(Owner, LongWord(RawData), ExeImage);
  Result := fList;
end;

  { TCursorResEntry }

function tCursorResEntry.GetName: string;
begin
  if Assigned(FResInfo) then
    with FResInfo^ do
      Result := Format('%d X %d %d Bit(s)', [wWidth, wWidth, wBitCount])
  else
    Result := inherited GetName;
end;

  { tStringResource }

procedure tStringResource.AssignTo(Dest: TPersistent);
var
  Pw : pWChar;
  Pc : pChar;
  ID : Integer;
  Cnt: LongWord;
  Len: Word;
begin
  if (Dest is TStrings) then
    with TStrings(Dest) do begin
      BeginUpdate;
      try
	Clear;
	Pw := RawData;
	Pc := RawData;
	Cnt := 0;
	while (Cnt < StringsPerBlock) do begin
	  case ImageType of
	    itPE: Len := Word(Pw^);
	    itNE: Len := Byte(Pc^);
	    else  Len := 0;
	  end;
	  Inc(Pw);
	  Inc(Pc);
	  if (Len > 0) then
	    case ImageType of
	      itPE : begin
		ID := ((FDirEntryPE.Name - 1) shl 4) + Cnt;
		Add(Format('%d,  "%s"', [ID, WideCharToStr(Pw, Len)]));
		Inc(Pw, Len);
	      end;
	      itNE: begin
		ID := ((fDescriptionNE.ResourceName and $7FFF) shl 4) + Cnt;
		Add(Format('%d,  "%s"', [ID, Copy(Pc, 1, Len)]));
		Inc(Pc, Len);
	      end;
	    end;
	  Inc(Cnt);
	end;
      finally
	EndUpdate;
      end;
    end
  else
    inherited AssignTo(Dest);
end;

  { tMenuResource }

procedure tMenuResource.SetNestLevel(Value: Integer);
begin
  FNestLevel := Value;
  SetLength(FNestStr, Value * 2);
  FillChar(FNestStr[1], Value * 2, ' ');
end;

procedure tMenuResource.AssignTo(Dest: TPersistent);
var
  IsPopup  : Boolean;
  Len      : Word;
  MenuData : pWord;
  MenuEnd  : pChar;
  MenuTextW: PWChar;
  MenuTextC: pChar;
  MenuID   : Word;
  MenuFlags: Word;
  S	   : string;
begin
  if (Dest is tStrings) then
    with tStrings(Dest) do begin
      BeginUpdate;
      try
	Clear;
	MenuData := RawData;
	MenuEnd  := pChar(RawData) + Size;
	Inc(MenuData, 2);
	NestLevel := 0;
	while (pChar(MenuData) < MenuEnd) do begin
	  MenuFlags := MenuData^;
	  Inc(MenuData);
	  IsPopup := (MenuFlags and MF_POPUP) = MF_POPUP;
	  MenuID := 0;
	  if not IsPopup then begin
	    MenuID := MenuData^;
	    Inc(MenuData);
	  end;
	  MenuTextW := nil;
	  MenuTextC := nil;
	  case ImageType of
	    itPE: begin
	      MenuTextW := PWChar(MenuData);
	      Len := lstrlenw(MenuTextW);
	    end;
	    itNE: begin
	      MenuTextC := pChar(MenuData);
	      Len := Length(MenuTextC);
	    end;
	    else Len := 0;
	  end;
	  if (Len = 0) then S := 'MENUITEM SEPARATOR'
	  else
	    case ImageType of
	      itPE: S := WideCharToStr(MenuTextW, Len);
	      itNE: S := MenuTextC;
	      else  S := '';
	    end;
	  if IsPopup then
	    if (Len = 0) then S := Format('POPUP %s', [S])
			 else S := Format('POPUP "%s"', [S])
	  else
	    if (Len = 0) then S := Format('%s', [S])
			 else S := Format('MENUITEM "%s",  %d', [S, MenuID]);
	  case ImageType of
	    itPE: Inc(MenuData, Len + 1);
	    itNE: MenuData := Pointer(LongWord(MenuData) + Len + 1);
	  end;
	  Add(NestStr + S);
	  if IsPopup then NestLevel := NestLevel + 1;
	  if ((MenuFlags and MF_END) = MF_END) then begin
	    NestLevel := NestLevel - 1;
	    Add(NestStr + 'ENDPOPUP');
	  end;
	  if (NestLevel < 0) then Break;
	end;
      finally
	EndUpdate;
      end;
    end
  else
    inherited AssignTo(Dest);
end;

  { tResourceList }

constructor tResourceList.Create(aOwner: tComponent; aBase: LongWord; aExeImage: tExeImage);
var
  DirEntry: pIMAGE_RESOURCE_DIRECTORY_ENTRY;
begin
  inherited Create(aOwner, otNone, Pointer(aBase), aExeImage);
  // remove default list
  fList.Free;
  fList   := nil;
  if (ImageType = itPE) then begin
    fResDirPE := Pointer(aBase);
    if (aOwner <> aExeImage) then	// we are not root list
      if (aOwner.Owner.Owner = aExeImage) then begin	// we are at second level
	DirEntry := pIMAGE_RESOURCE_DIRECTORY_ENTRY(fResDirPE);
	Inc(pIMAGE_RESOURCE_DIRECTORY(DirEntry));
	fResType := tResourceItem(Owner).fDirEntryPE.Name;
      end
      else fResType := (aOwner.Owner.Owner as tResourceList).fResType	// ask owner list for type
    else
  end
  else
  if (ImageType = itNE) then begin
    if (aOwner = ExeImage) then fResDirNE := @pImageNE_Resource_Table(aBase).Resources
			   else fResDirNE := Pointer(aBase);
    if (aOwner <> aExeImage) then	// we are not root list
      if (aOwner.Owner.Owner = aExeImage) then 	// we are at second level
	if (fResDirNE.ResourceType > $7FFF) then fResType := (fResDirNE.ResourceType and $7FFF)	// get type from group description
					    else fResType := fResDirNE.ResourceType;
  end
  else
  if (ImageType = itLX) then {}
end;

function tResourceList.GetList: tList;
var
  I       : Integer;
  DirEntry: pIMAGE_RESOURCE_DIRECTORY_ENTRY;
  DirCnt  : Integer;
  ResItem : tResourceItem;
  ResGroup: pImageNE_Resource_Group;
  ResEntry: pImageNE_Resource_Description;
begin
  if not Assigned(fList) then begin
    fList    := tList.Create;
    case ImageType of
      itPE: if Assigned(fBase) then begin
	DirEntry := pIMAGE_RESOURCE_DIRECTORY_ENTRY(fResDirPE);
	Inc(PIMAGE_RESOURCE_DIRECTORY(DirEntry));
	DirCnt   := fResDirPE.NumberOfNamedEntries + fResDirPE.NumberOfIdEntries;
	for I := 0 to DirCnt - 1 do begin
	  { Handle Cursors and Icons specially }
	  ResItem := GetResourceClass(fResType).Create(Self, DirEntry);
	  if (Owner = ExeImage) then
	    if (tResourceType(DirEntry.Name) in [rtCursorEntry, rtIconEntry]) then begin
	      if (tResourceType(DirEntry.Name) = rtCursorEntry) then ExeImage.fCursorResources := ResItem
								else ExeImage.fIconResources   := ResItem;
	      Inc(DirEntry);
	      Continue;
	    end;
	  fList.Add(ResItem);
	  Inc(DirEntry);
	end;
      end;
      itNE: if (Owner <> ExeImage) or (ExeImage.fOS2Header.ResNamesTableOffset - ExeImage.fOS2Header.ResourceTableOffset > 0) then begin
	ResGroup := Pointer(fResDirNE);
	while (ResGroup.ResourceType > 0) do begin
	  if (fResType = 0) then begin
	    ResItem := tResourceItem.Create(Self, ResGroup);	// create a root item
	    if (ResGroup.ResourceType > $7FFF) then
	      if (tResourceType(ResGroup.ResourceType and $7FFF) = rtIconEntry) then ExeImage.fIconResources := ResItem
	      else
	      if (tResourceType(ResGroup.ResourceType and $7FFF) = rtCursorEntry) then ExeImage.fCursorResources := ResItem;
	    fList.Add(ResItem);
	    ResGroup := Pointer(LongWord(ResGroup) + LongWord(ResItem.Size));
	  end
	  else begin
	    ResEntry := @ResGroup.ResourceDescriptions;
	    for I := 0 to ResGroup.ResourceCount - 1 do begin
	      ResItem := GetResourceClass(fResType).Create(Self, ResEntry);
	      fList.Add(ResItem);
	      Inc(ResEntry);
	    end;
	    Break;
	  end;
	end
      end;
      else ;
    end;
  end;
  Result := fList;
end;

function tResourceList.GetNEAligment: Integer;
begin
  Result := pImageNE_Resource_Table(ExeImage.fResourceList.fBase).ShiftCount;
end;

  { tIconResourceList }

function tIconResourceList.GetList: tList;
var
  I,
  J, Cnt : Integer;
  ResData: pIconResInfo;
  ResList: tExeObjList;
  ResID  : LongWord;
  IconResource: tIconResEntry;
begin
  if not Assigned(fList) then begin
    fList   := tList.Create;
    Cnt     := pIconHeader(fBase).wCount;
    ResData := Pointer(LongWord(fBase) + SizeOf(tIconHeader));
    ResList := ExeImage.fIconResources.List;
    for I := 0 to Cnt - 1 do begin
      ResID := ResData.wNameOrdinal;
      for J := 0 to ResList.Count - 1 do begin
	if (ResID = tResourceItem(ResList[J]).ID) then begin
	  IconResource := (ResList[J] as tIconResEntry);
	  IconResource.fResInfo := ResData;
	  fList.Add(IconResource);
	end;
      end;
      Inc(ResData);
    end;
  end;
  Result := fList;
end;

  { tCursorResourceList }

function tCursorResourceList.GetList: TList;
var
  I,
  J, Cnt : Integer;
  ResData: pCursorResInfo;
  ResList: tExeObjList;
  ResID  : LongWord;
  CursorResource: TCursorResEntry;
begin
  if not Assigned(fList) then begin
    fList   := tList.Create;
    Cnt     := pIconHeader(fBase).wCount;
    ResData := Pointer(LongWord(fBase) + SizeOf(tIconHeader));
    ResList := ExeImage.fCursorResources.List;
    for I := 0 to Cnt - 1 do begin
      ResID := ResData.wNameOrdinal;
      for J := 0 to ResList.Count - 1 do begin
	if (ResID = tResourceItem(ResList[J]).ID) then begin
	  CursorResource := (ResList[J] as tCursorResEntry);
	  CursorResource.fResInfo := ResData;
	  fList.Add(CursorResource);
	end;
      end;
      Inc(ResData);
    end;
  end;
  Result := fList;
end;

  { tExeObjList }

constructor tExeObjList.Create(aOwner: tComponent; aType: tExeObjListType; aBase: Pointer; aExeImage: tExeImage);
begin
  inherited Create(aOwner);
  fExeImage := aExeImage;
  fBase     := aBase;
  fList     := tList.Create;
  case aType of
    otRootDir: begin
      if (ExeImage.ImageType <> itNone) then fList.Add(tRootItem.Create(Self, nil, otHeaders));
      if not (ExeImage.ImageType in [itNone, itDos]) then fList.Add(tRootItem.Create(Self, nil, otSections));
    end;
    otHeaders: begin
      if (ExeImage.ImageType <> itNone) then fList.Add(tDosHeaderItem.Create(Self, fExeImage.fFileBase, otListView));
      if not (ExeImage.ImageType in [itNone, itDos]) then fList.Add(tNewHeaderItem.Create(Self, Pointer(LongWord(fExeImage.fFileBase) + fExeImage.fDosHeader.e_lfanew), otListView));
    end;
    otSections: begin
      if (ExeImage.ImageType = itPE) then fList.Add(tPEObjectsItem.Create(Self, nil, otListBox));
      //fList.Add(tSectionItem.Create(Self, nil, otNone));
    end;
  end;
end;

destructor tExeObjList.Destroy;
begin
  fList.Free;
  inherited;
end;

function tExeObjList.GetCount: Integer;
begin
  Result := List.Count;
end;

function tExeObjList.GetEOItem(aIndex: Integer): tExeObjItem;
begin
  Result := tExeObjItem(List[aIndex]);
end;

function tExeObjList.GetImageType: tImageType;
begin
  Result := ExeImage.ImageType;
end;

function tExeObjList.GetList: tList;
begin
  Result := fList;
end;

  { tExeObjItem }

function tExeObjItem.AssignLBValues: string;
begin
  Result := '';
end;

procedure tExeObjItem.AssignLVValues(Dest: tStrings);
begin
end;

constructor tExeObjItem.Create(aOwner: tComponent; aBase: Pointer; aType: tExeObjListType);
begin
  inherited Create(aOwner);
  fType := aType;
  fBase := aBase;
end;

function tExeObjItem.DoGetImageTypeIndex: tResourceType;
begin
  Result := GetImageTypeIndex;
  if (Ord(Result) < 1) or (Ord(Result) > 5) then Result := rtUnknown0;
end;

function tExeObjItem.GetEOItem(aIndex: Integer): tExeObjItem;
begin
  Result := List[aIndex];
end;

function tExeObjItem.GetEOList: tExeObjList;
begin
  if not IsList then ExeError('ExeObjectItem is not list');
  if not Assigned(fList) then fList := tExeObjList.Create(Self, fType, fBase, ExeImage);
  Result := fList;
end;

function tExeObjItem.GetExeImage: tExeImage;
begin
  Result := (Owner as tExeObjList).ExeImage;
end;

function tExeObjItem.GetImageType: tImageType;
begin
  Result := ExeImage.fImageType;
end;

function tExeObjItem.GetImageTypeIndex: tResourceType;
begin
  Result := rtUnknown0;
end;

function tExeObjItem.GetOffset: LongWord;
begin
  Result := LongWord(fBase);
end;

function tExeObjItem.GetRawData: Pointer;
begin
  Result := fBase;
end;

function tExeObjItem.GetSize: Integer;
begin
  Result := -1;
end;

procedure tExeObjItem.SaveToFile(const aFileName: string);
var
  FS: tFileStream;
begin
  FS := tFileStream.Create(aFileName, fmCreate);
  try
    Self.SaveToStream(FS);
  finally
    FS.Free;
  end;
end;

procedure tExeObjItem.SaveToStream(aStream: tStream);
begin
  aStream.Write(RawData^, Size);
end;

  { tDosHeaderItem }

function tHeaderItem.GetName: string;
var
  P: ^Word;
  L: ^LongWord;
begin
  P := fBase;
  L := fBase;
  if (P^ = IMAGE_DOS_SIGNATURE)    then Result := 'Dos Header'
  else
  if (P^ = IMAGE_OS2_SIGNATURE)    then Result := 'NE header'
  else
  if (P^ = IMAGE_OS2_SIGNATURE_LE) then Result := 'LE header'
  else
  if (P^ = IMAGE_LX_SIGNATURE)     then Result := 'LX header'
  else
  if (L^ = IMAGE_NT_SIGNATURE)     then Result := 'PE Header'
  else Result := 'Unknown type of header';
end;

function tHeaderItem.GetIsList: Boolean;
begin
  Result := False;
end;

function tHeaderItem.GetOffset: LongWord;
begin
  Result := LongWord(fBase) - LongWord(ExeImage.fFileBase); 
end;

  { tDosHeaderItem }

type
  pBigArray = ^tBigArray;
  tBigArray = array[Byte] of Word;

procedure tDosHeaderItem.AssignLVValues(Dest: tStrings);
const
  // NOTE: this array MUST be indexed starting with 0!
  PropNames: array[0..13] of string =
    ('Magic number',
     'Bytes on last page of file',
     'Pages in file',
     'Relocations',
     'Size of header in paragraphs',
     'Minimum extra paragraphs needed',
     'Maximum extra paragraphs needed',
     'Initial (relative) SS value',
     'Initial SP value',
     'Checksum',
     'Initial IP value',
     'Initial (relative) CS value',
     'File address of relocation table',
     'Overlay number');
var
  lP: pBigArray;
   i: Integer;
  lS: string;
begin
  with ExeImage do begin
    lP := @DosHeader.e_magic;
    for i := Low(PropNames) to High(PropNames) do
      Dest.Add(PropNames[i] + '=$' + IntToHex(lP^[i], 4));
    if (ExeImage.ImageType <> itDOS) then begin	// we have new header, so add some more fields
      lS := '';
      for i := 0 to 3 do lS := lS + '$' + IntToHex(lP^[14 + i], 4) + ' ';
      Dest.Add('Reserved 0..3=' + lS);
      Dest.Add('OEM identifier=$' + IntToHex(lP^[18], 4));
      Dest.Add('OEM information=$' + IntToHex(lP^[19], 4));
      lS := '';
      for i := 0 to 9 do lS := lS + '$' + IntToHex(lP^[20 + i], 4) + ' ';
      Dest.Add('Reserved 0..9=' + lS);
      Dest.Add('File address of new exe header=$' + IntToHex(lP^[30] + lP^[31] shl 16, 8));
    end;
  end;
end;

  { tNewHeaderItem }

procedure tNewHeaderItem.AssignLVValues(Dest: tStrings);
type
  tPEProp = record
    N: string;
    Z: Byte;
  end;

const
  NEPropNames: array[1..30] of tPEProp =
    ((N: 'Signature';			Z: 2),
     (N: 'Linker Version';		Z: 2),
     (N: 'Entry Table Offset (from NE)';Z: 2),
     (N: 'Entry Table Size';		Z: 2),
     (N: 'Checksum';			Z: 4),
     (N: 'Module Flags';		Z: 2),
     (N: 'AutoData Segment Number';	Z: 2),
     (N: 'Initial Local Heap Size';	Z: 2),
     (N: 'Initial Stack Size';		Z: 2),
     (N: 'Initial IP';			Z: 2),
     (N: 'Initial CS Segment';		Z: 2),
     (N: 'Initial SP';			Z: 2),
     (N: 'Initial SS Segment';		Z: 2),
     (N: 'Segment Count';		Z: 2),
     (N: 'Module Reference Count';	Z: 2),
     (N: 'Nonresident Names Table Size';		Z: 2),
     (N: 'Segment Table Offset (from NE)';		Z: 2),
     (N: 'Resource Table Offset (from NE)';		Z: 2),
     (N: 'Resident Names Table Offset (from NE)';	Z: 2),
     (N: 'Module Reference Table Offset (from NE)';	Z: 2),
     (N: 'Imported Names Table Offset (from NE)';	Z: 2),
     (N: 'Nonresident Names Table Offset';		Z: 4),
     (N: 'Moveable Entry Point Count';		Z: 2),
     (N: 'File Alignment Shift Count';		Z: 2),
     (N: 'Miminum Code Swap Area Size';		Z: 2),
     (N: 'Target OS and Flags';			Z: 2),
     (N: 'Fastload Area Offset (use shift)';	Z: 2),
     (N: 'Fastload Area Size (use shift)';	Z: 2),
     (N: 'Reserved';				Z: 2),
     (N: 'Expected Windows Version'; 		Z: 2));

  PEFilePropNames: array[1..7] of tPEProp =
    ((N: 'Machine';			Z: 2),
     (N: 'Number of Sections'; 		Z: 2),
     (N: 'TimeDate Stamp';     		Z: 4),
     (N: 'Pointer to Symbol Table';	Z: 4),
     (N: 'Number of Symbols';		Z: 4),
     (N: 'Size of Optional Header';    	Z: 2),
     (N: 'Characteristics';		Z: 2));

  PEPropNames: array[1..29] of tPEProp =
    ((N: 'Magic'; 			Z: 2),
     (N: 'Linker Version'; 		Z: 2),
     (N: 'Size of Code'; 		Z: 4),
     (N: 'Size of Initialized Data';	Z: 4),
     (N: 'Size of Uninitialized Data';	Z: 4),
     (N: 'Address of Entry Point';	Z: 4),
     (N: 'Base of Code';		Z: 4),
     (N: 'Base of Data';		Z: 4),
     // NT additional fields.
     (N: 'Image Base';				Z: 4),
     (N: 'Section Alignment';			Z: 4),
     (N: 'File Alignment';	   		Z: 4),
     (N: 'Major Operating System Version';	Z: 2),
     (N: 'Minor Operating System Version';	Z: 2),
     (N: 'Major Image Version';			Z: 2),
     (N: 'Minor Image Version';			Z: 2),
     (N: 'Major Subsystem Version';		Z: 2),
     (N: 'Minor Subsystem Version';		Z: 2),
     (N: 'Reserved_1';				Z: 4),
     (N: 'Size of Image';			Z: 4),
     (N: 'Size of Headers';			Z: 4),
     (N: 'CheckSum';				Z: 4),
     (N: 'Subsystem';				Z: 2),
     (N: 'Dll Characteristics';			Z: 2),
     (N: 'Size of Stack Reserve';  		Z: 4),
     (N: 'Size of Stack Commit';   		Z: 4),
     (N: 'Size of Heap Reserve';   		Z: 4),
     (N: 'Size of Heap Commit';			Z: 4),
     (N: 'Loader Flags';	   		Z: 4),
     (N: 'Number of Rva And Sizes';		Z: 4));

  PERVAsNames: array[1..IMAGE_NUMBEROF_DIRECTORY_ENTRIES] of tPEProp =
    (
    (N: 'Exports'; 	Z:8),
    (N: 'Imports'; 	Z:8),
    (N: 'Resources'; 	Z:8),
    (N: 'Exceptions'; 	Z:8),
    (N: 'Security'; 	Z:8),
    (N: 'Fixups'; 	Z:8),
    (N: 'Debug'; 	Z:8),
    (N: 'Description';	Z:8),
    (N: 'TLS';	 	Z:8),
    (N: 'Callbacks'; 	Z:8),
    (N: 'reserved 0'; 	Z:8),
    (N: 'reserved 1'; 	Z:8),
    (N: 'reserved 2'; 	Z:8),
    (N: 'reserved 3'; 	Z:8),
    (N: 'reserved 4'; 	Z:8),
    (N: 'reserved 5'; 	Z:8)
    );

  procedure AddPEHeaderItems(Data: pBigArray; anItems: array of tPEProp);
  var
    i: Integer;
    O: Integer;
  begin
    O := 0;
    for i := Low(anItems) to High(anItems) do begin
      if (anItems[i].Z = 2) then Dest.Add(anItems[i].N + '=$' + IntToHex(Data^[O], 4))
      else
      if (anItems[i].Z = 4) then begin
	Dest.Add(anItems[i].N + '=$' + IntToHex(Data^[O] + (Data^[O + 1] shl 16), 8));
	Inc(O);
      end
      else
      if (anItems[i].Z = 8) then begin
	Dest.Add(anItems[i].N + '=$' + IntToHex(Data^[O + 0] + (Data^[O + 1] shl 16), 8) +
				'/$' + IntToHex(Data^[O + 2] + (Data^[O + 3] shl 16), 8));
	Inc(O, 3);
      end
      else Dest.Add('Internal data error=');
      Inc(O);
    end;
  end;

var
  P : ^Word;
  L : ^LongWord;
begin
  P := fBase;
  L := fBase;
  if (P^ = IMAGE_OS2_SIGNATURE) then begin
    // assign NE header
    AddPEHeaderItems(@ExeImage.OS2Header.Signature, NEPropNames);
  end
  else
  if (P^ = IMAGE_OS2_SIGNATURE_LE) then begin
    // assign LE header
  end
  else
  if (P^ = IMAGE_LX_SIGNATURE) then begin
    // assign LX header
  end
  else
  if (L^ = IMAGE_NT_SIGNATURE) then begin
    // assign PE Header
    Dest.Add('Signature=$' + IntToHex(L^, 8));
    Dest.Add('--- File Header ---=');
    AddPEHeaderItems(@ExeImage.NTHeader.FileHeader.Machine, PEFilePropNames);
    Dest.Add('---  NT Header  ---=');
    AddPEHeaderItems(@ExeImage.NTHeader.OptionalHeader.Magic, PEPropNames);
    Dest.Add('--- Interesting RVAs ---=      RVA / Size');
    AddPEHeaderItems(@ExeImage.NTHeader.OptionalHeader.DataDirectory, PERVAsNames);
  end
  else Dest.Add('Unknown type of header=');
end;

  { tRootItem }

function tRootItem.GetName: string;
begin
  case fType of
    otRootDir : Result := 'EXE Objects';
    otHeaders : Result := 'Headers';
    otSections: Result := 'Sections';
  end;
end;

function tRootItem.GetIsList: Boolean;
begin
  Result := True;
end;

  { tSectionItem }

function tSectionItem.GetName: string;
begin
  Result := 'Section';
end;

function tSectionItem.GetIsList: Boolean;
begin
  Result := False;
end;

  { tPEObjectsItem }

function tPEObjectsItem.AssignLBValues: string;
var
  Header: pIMAGE_SECTION_HEADER;
       I: Integer;
begin
  Header := pIMAGE_SECTION_HEADER(ExeImage.fNTHeader);
  Inc(pIMAGE_NT_HEADERS(Header));
  Result := 'Name'#9'VirtSize'#9'RVA'#9'PhysSize'#9'PhysOfs'#9'Flags'#13#10'-------'#9'--------'#9'--------'#9'--------'#9'--------'#9'--------'#13#10;
  for I := 0 to ExeImage.fNTHeader.FileHeader.NumberOfSections - 1 do begin
    Result := Result + Header.Name + #9 +
		       IntToHex(Header.PhysicalAddress, 8) + #9 +
		       IntToHex(Header.VirtualAddress, 8) + #9 +
		       IntToHex(Header.SizeOfRawData, 8) + #9 +
		       IntToHex(Header.PointerToRawData, 8) + #9 +
		       {IntToHex(Header.PointerToRelocations, 8) + #9 +
		       IntToHex(Header.PointerToLinenumbers, 8) + #9 +
		       IntToHex(Header.NumberOfRelocations, 8) + #9 +
		       IntToHex(Header.NumberOfLinenumbers, 8) + #9 +}
		       IntToHex(Header.Characteristics, 8) + #9 +
	      #13#10;
    Inc(Header);
  end;
end;

function tPEObjectsItem.GetName: string;
begin
  Result := 'Ojbect Table';
end;

end.

