
unit About;

interface

uses
  Forms, StdCtrls, Controls, ExtCtrls, Classes;

type
  TAboutBox = class(TForm)
    OKButton: TButton;
    Panel1: TPanel;
    ProgramIcon: TImage;
    ProgramName: TLabel;
    Copyright: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ProgramIconDblClick(Sender: TObject);
    procedure ProgramIconMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  AboutBox: TAboutBox;

procedure ShowAboutBox;

implementation

uses
  SysUtils, RXMain, Dialogs, HomeTool;

{$R *.DFM}

procedure ShowAboutBox;
begin
  with TAboutBox.Create(Application) do try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TAboutBox.FormCreate(Sender: TObject);
begin
  Copyright.Caption := SCopyright;
  Caption := Format('About %s', [Application.Title]);
  ProgramIcon.Picture.Assign(Application.Icon);
  ProgramName.Caption := Application.Title;
end;

procedure TAboutBox.ProgramIconDblClick(Sender: TObject);
begin
  ShowMessage('Clever! But what next?');
end;

procedure TAboutBox.ProgramIconMouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if (ssCtrl in Shift) then ShowMessage('Very clever! You are getting closer.');
  if (ssAlt in Shift) and (Button = mbRight) then ShowMessage('Compiled: ' + Date2Str(MainForm.LCD.LCDate));
end;

end.

