unit RasExampleMainDialog;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, RasManager, StdCtrls, Buttons, ToolWin, ComCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    ListBox: TListBox;
    RasManager: TRasManager;
    Label1: TLabel;
    lbDeviceName: TLabel;
    lbDeviceType: TLabel;
    Label4: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    lbIPClient: TLabel;
    lbIPServer: TLabel;
    Button: TButton;
    Label5: TLabel;
    lbConnected: TLabel;
    Timer: TTimer;
    Label6: TLabel;
    lbPhoneNumber: TLabel;
    Label7: TLabel;
    lbAreacode: TLabel;
    Label8: TLabel;
    lbCountryCode: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure RasManagerConnect(Sender: TObject; Connection: TRasEntry);
    procedure RasManagerDisconnect(Sender: TObject; Connection: TRasEntry);
    procedure RasManagerConnecting(Sender: TObject; Index, Msg, State,
      Error: Integer);
    procedure ButtonClick(Sender: TObject);
    procedure TimerTimer(Sender: TObject);
  private
    { Private-Deklarationen }
    procedure RefreshStatus;
  public
    { Public-Deklarationen }
  end;

var
  MainForm: TMainForm;

implementation

uses RasExampleMemoDialog;

var cYesNo: array [false..true] of string = ('no', 'yes' );
    cConnectDisConnect: array [false..true] of string = ('connect', 'disconnect' );

{$R *.dfm}

procedure TMainForm.RefreshStatus;
begin
  if Listbox.ItemIndex >= 0 then begin
    lbDeviceName.Caption := RasManager.DeviceName[Listbox.ItemIndex];
    lbDeviceType.Caption := RasManager.DeviceType[Listbox.ItemIndex];
    lbIPClient.Caption := RasManager.IPClient[Listbox.ItemIndex];
    lbIPServer.Caption := RasManager.IPServer[Listbox.ItemIndex];
    lbConnected.Caption := cYesNo[RasManager.Connected[Listbox.ItemIndex]];
    lbPhoneNumber.Caption := RasManager.PhoneNumber[ListBox.ItemIndex];
    lbAreacode.Caption := RasManager.AreaCode[ListBox.ItemIndex];
    lbCountryCode.Caption := IntToStr(RasManager.CountryCode[ListBox.ItemIndex]);
    Button.Caption := cConnectDisConnect[RasManager.Connected[Listbox.ItemIndex]];
  end else begin
    lbDeviceName.Caption := '';
    lbDeviceType.Caption := '';
    lbIPClient.Caption := '';
    lbIPServer.Caption := '';
    lbConnected.Caption := '';
    lbPhoneNumber.Caption := '';
    lbAreacode.Caption := '';
    lbCountryCode.Caption := '';
    Button.Caption := '';
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
var i: Integer;
begin
  for i := 1 to RASManager.Count do begin
    ListBox.Items.Add( RasManager.Name[i-1] );
  end;
  lbDeviceName.Caption := '';
  lbDeviceType.Caption := '';
  lbIPClient.Caption := '';
  lbIPServer.Caption := '';
  lbConnected.Caption := '';
  lbPhoneNumber.Caption := '';
  lbAreacode.Caption := '';
  lbCountryCode.Caption := '';
  Button.Caption := '';
  Caption := Caption + ' - ' + RasManager.Version;
end;

procedure TMainForm.ListBoxClick(Sender: TObject);
begin
  RefreshStatus;
end;

procedure TMainForm.FormShow(Sender: TObject);
begin
  RasManager.Start;
  MemoForm.Show;
end;

procedure TMainForm.RasManagerConnect(Sender: TObject;
  Connection: TRasEntry);
begin
  MemoForm.Write( 'connected: ' + Connection.Name);
end;

procedure TMainForm.RasManagerDisconnect(Sender: TObject;
  Connection: TRasEntry);
begin
  MemoForm.Write( 'disconnected: ' + Connection.Name);
end;

procedure TMainForm.RasManagerConnecting(Sender: TObject; Index, Msg,
  State, Error: Integer);
begin
  MemoForm.Write( 'connecting: ' + RasManager.Name[Index] + ' -> ' + GetStatusString(State) );
end;

procedure TMainForm.ButtonClick(Sender: TObject);
begin
  if Listbox.ItemIndex >= 0 then begin
    if RasManager.Connected[Listbox.ItemIndex] then begin
      RasManager.DisConnect(Listbox.ItemIndex);
    end else begin
      RasManager.Connect(Listbox.ItemIndex);
    end;
  end;
end;

procedure TMainForm.TimerTimer(Sender: TObject);
begin
  RefreshStatus;
end;

end.
