unit MainFrm;

interface

uses   
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBTables, ExtCtrls, DBGrids, QuickSelect, DBCtrls, Buttons,
  QSComboBox, Grids;

type
  TMainForm = class(TForm)
    QuickSelect: TQuickSelect;
    DataSource: TDataSource;
    Query: TQuery;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;           
    Panel4: TPanel;
    SQLMmo: TMemo;
    DBGrid: TDBGrid;
    BuildBtn: TButton;
    ExitBtn: TButton;
    ExecuteBtn: TButton;
    Panel5: TPanel;
    Panel6: TPanel;
    DBNavigator1: TDBNavigator;
    QSComboBox: TQSComboBox;
    Label1: TLabel;
    procedure BuildBtnClick(Sender: TObject);
    procedure ExecuteBtnClick(Sender: TObject);
    procedure ExitBtnClick(Sender: TObject);
    procedure QuickSelectPreview(Sender: TObject; SQL: TStrings;
      Report: TQSReportType);
    procedure QSComboBoxChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.BuildBtnClick(Sender: TObject);
begin
  if QuickSelect.Execute then
  begin
    Screen.Cursor := crHourglass;
    try
      SQLMmo.Lines := QuickSelect.SQL;
      QSComboBox.UpdateReportNames;
      QSComboBox.ItemIndex := QSComboBox.Items.IndexOf (QuickSelect.ActiveReport);
      ExecuteBtnClick (ExecuteBtn);
    finally
      Screen.Cursor := crDefault;
    end;
  end;
end;

procedure TMainForm.ExecuteBtnClick(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  try
    if Query.Active then Query.Close;
    Query.SQL := SQLMmo.Lines;
    Query.Open;                     
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TMainForm.ExitBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.QuickSelectPreview(Sender: TObject; SQL: TStrings;
  Report: TQSReportType);
begin
  DataSource.DataSet := nil;

  Query.SQL := SQL;
  Query.Open;
  try
    MessageDlg ('The query returns ' + IntToStr (Query.RecordCount) + ' rows  ',mtInformation,[mbOK],0);
  finally
    Query.Close;
  end;

  DataSource.DataSet := Query;
end;

procedure TMainForm.QSComboBoxChange(Sender: TObject);
begin
  Screen.Cursor := crHourglass;
  try
    SQLMmo.Lines := QuickSelect.SQL;
    if QSComboBox.ItemIndex > -1
      then ExecuteBtnClick (ExecuteBtn)
      else Query.Active := False;
  finally                                       
    Screen.Cursor := crDefault;
  end;
end;

end.
