unit DemoUnit;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, PrpGrid, Mask, Filectrl, Menus, ComCtrls,  ShellAPi;

type
  TPropertyGridForm = class(TForm)
    Panel1: TPanel;
    PropertyGrid1: TPropertyGrid;
    OpenDialog1: TOpenDialog;
    MainMenu1: TMainMenu;
    Addproperty1: TMenuItem;
    Actions1: TMenuItem;
    Changeproperty1: TMenuItem;
    Deleteproperty1: TMenuItem;
    N1: TMenuItem;
    Clearproperties1: TMenuItem;
    Resetmodified1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    View1: TMenuItem;
    ShowCheckColumn1: TMenuItem;
    goTitleinOptions1: TMenuItem;
    CommonFlatView1: TMenuItem;
    N3: TMenuItem;
    EditFrameStyle1: TMenuItem;
    Framed1: TMenuItem;
    ThinFramed1: TMenuItem;
    Flat1: TMenuItem;
    PrpGridStatus: TStatusBar;
    Readmetxt1: TMenuItem;
    procedure AddClick(Sender: TObject);
    procedure ChangeClick(Sender: TObject);
    procedure DeleteClick(Sender: TObject);
    procedure PropertyGrid1EditButtonClick(Sender: TObject; ARow: Integer);
    procedure ExitClick(Sender: TObject);
    procedure PropertyGrid1CheckBoxClick(Sender: TObject; ARow: Integer);
    procedure ClearClick(Sender: TObject);
    procedure PropertyGrid1ShowHint(Sender: TObject; ARow: Integer;
      var PropHint: String);
    procedure ShowCheckColumn1Click(Sender: TObject);
    procedure goTitleinOptions1Click(Sender: TObject);
    procedure CommonFlatView1Click(Sender: TObject);
    procedure Framed1Click(Sender: TObject);
    procedure PropertyGrid1SetEditText(Sender: TObject; ACol,
      ARow: Integer; const Value: String);
    procedure PropertyGrid1SelectCell(Sender: TObject; ACol, ARow: Integer;
      var CanSelect: Boolean);
    procedure Resetmodified1Click(Sender: TObject);
    procedure Readmetxt1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    procedure UpdateStatus(ARow:LongInt);
  end;

var
  PropertyGridForm: TPropertyGridForm;

implementation

{$R *.DFM}

procedure TPropertyGridForm.AddClick(Sender: TObject);
begin
  PropertyGrid1.AddPropertyRow('New Property','(new object)', emEllipsis);
  with PropertyGrid1 do
    PropValues[Pred(RowCount)].Tag:=3;
end;

procedure TPropertyGridForm.ChangeClick(Sender: TObject);
begin
  PropertyGrid1.ChangePropertyRow(PropertyGrid1.Row,'Change Property','Second',emPickList);
  with PropertyGrid1 do
    PropValues[Row].PickList.Text:='First'#$D#$A'Second'#$D#$A'Third';
end;

procedure TPropertyGridForm.DeleteClick(Sender: TObject);
begin
  with PropertyGrid1 do DeletePropertyRow(Row);
end;

procedure TPropertyGridForm.PropertyGrid1EditButtonClick(Sender: TObject; ARow: Integer);
var Dir:String;
begin
  with PropertyGrid1.PropValues[ARow] do
    case Tag of
      1: begin
           if (OpenDialog1.Execute) then
             PropertyValue := OpenDialog1.FileName;
         end;
      2: begin
           Dir := ExtractFilePath(ParamStr(0));
           if SelectDirectory(Dir,[sdAllowCreate, sdPerformCreate, sdPrompt],0) then
             PropertyValue := Dir;
         end;
    else
      ShowMessage('EventHandler not defined!');
    end;
  UpdateStatus(ARow);
end;

procedure TPropertyGridForm.ExitClick(Sender: TObject);
begin
  Close;
end;

procedure TPropertyGridForm.PropertyGrid1CheckBoxClick(Sender: TObject;
  ARow: Integer);
begin
  if ARow= PropertyGrid1.Row then UpdateStatus(ARow);
end;

procedure TPropertyGridForm.ClearClick(Sender: TObject);
begin
  Propertygrid1.PropValues.Clear;
end;

procedure TPropertyGridForm.PropertyGrid1ShowHint(Sender: TObject;
  ARow: Integer; var PropHint: String);
begin
  case ARow of
    1:PropHint := 'Just edit your text...';
    2:PropHint := 'Push the button and choose item from list';
    3:PropHint := 'Look upper plus edit in place';
//  4..5:PropHint := 'Push the button to call external handler';
    8:PropHint := 'Masked edit #1';
    9:PropHint := 'Masked edit #2';
    10:PropHint := 'Spin and enjoy!';
  end;
end;

procedure TPropertyGridForm.ShowCheckColumn1Click(Sender: TObject);
begin
  ShowCheckColumn1.Checked := not ShowCheckColumn1.Checked;
  PropertyGrid1.ShowCheckColumn := ShowCheckColumn1.Checked;
  with PropertyGrid1 do
    if ShowCheckColumn then Row := 1;
end;

procedure TPropertyGridForm.goTitleinOptions1Click(Sender: TObject);
begin
  goTitleInOptions1.Checked := not goTitleInOptions1.Checked;
  if goTitleInOptions1.Checked then
    PropertyGrid1.Options := PropertyGrid1.Options + [goTitle]
  else
    begin
      PropertyGrid1.Options := PropertyGrid1.Options - [goTitle];
      PropertyGrid1.Row := 1;
    end;
end;

procedure TPropertyGridForm.CommonFlatView1Click(Sender: TObject);
begin
  CommonFlatView1.Checked := not CommonFlatView1.Checked;
  if CommonFlatView1.Checked then
    begin
      Propertygrid1.Options := Propertygrid1.Options - [goFixedVertLine, goFixedHorzLine{, goHorzLine}];
      Framed1Click(Flat1);
    end
  else
    Propertygrid1.Options := Propertygrid1.Options + [goFixedVertLine, goFixedHorzLine, goHorzLine];
end;

procedure TPropertyGridForm.Framed1Click(Sender: TObject);
var i:Integer;
begin
  if TMenuItem(Sender).Checked then Exit;
  for i:= 0 to Pred(EditFrameStyle1.Count) do
    EditFrameStyle1.Items[i].Checked := False;
  TMenuItem(Sender).Checked := True;
  with PropertyGrid1 do
    case TMenuItem(Sender).GroupIndex of
      0:EditFrameStyle:=efFramed;
      1:EditFrameStyle:=efThinFramed;
      2:EditFrameStyle:=efFlat;
    end;
end;

procedure TPropertyGridForm.PropertyGrid1SetEditText(Sender: TObject; ACol,
  ARow: Integer; const Value: String);
begin
  UpdateStatus(PropertyGrid1.Row);
end;

procedure TPropertyGridForm.UpdateStatus(ARow: Integer);
var tmpStr:string;
begin
  if PropertyGrid1.PropValues[ARow].Checked then tmpStr :='True' else tmpStr:='False';
  PrpGridStatus.Panels[0].Text := Copy(PrpGridStatus.Panels[0].Text, 1, Pos(':', PrpGridStatus.Panels[0].Text))+IntToStr(ARow);
  PrpGridStatus.Panels[1].Text := Copy(PrpGridStatus.Panels[1].Text, 1, Pos(':', PrpGridStatus.Panels[1].Text))
   +tmpStr;
  if PropertyGrid1.PropValues[ARow].Modified then PrpGridStatus.Panels[2].Text := 'Modified'
  else PrpGridStatus.Panels[2].Text := '';
  PrpGridStatus.Update;
end;

procedure TPropertyGridForm.PropertyGrid1SelectCell(Sender: TObject; ACol,
  ARow: Integer; var CanSelect: Boolean);
begin
  UpdateStatus(ARow);
end;

procedure TPropertyGridForm.Resetmodified1Click(Sender: TObject);
begin
  PropertyGrid1.PropValues.ResetModified;
  UpdateStatus(PropertyGrid1.Row);
end;

procedure TPropertyGridForm.Readmetxt1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'OPEN', 'README.TXT', '', '', 0);
end;

procedure TPropertyGridForm.FormCreate(Sender: TObject);
begin
  UpdateStatus(PropertyGrid1.Row);
end;

end.
