unit MainF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  dmagicProgress, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    DemoReestimateButton: TButton;
    DemoFixedEstimateButton: TButton;
    WaitCheckBox: TCheckBox;
    CancelCheckBox: TCheckBox;
    OnlyMainJobButton: TButton;
    AtomicSubJobOperationsButton: TButton;
    ShowImmediatelyCheckBox: TCheckBox;
    TestModalButton: TButton;
    FromSubFormButton: TButton;
    NoDialogCheckBox: TCheckBox;
    AfterJobStatusCheckBox: TCheckBox;
    DemoInSubJobUnitsButton: TButton;
    procedure DemoReestimateButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DemoFixedEstimateButtonClick(Sender: TObject);
    procedure OnlyMainJobButtonClick(Sender: TObject);
    procedure AtomicSubJobOperationsButtonClick(Sender: TObject);
    procedure TestModalButtonClick(Sender: TObject);
    procedure FromSubFormButtonClick(Sender: TObject);
    procedure DemoInSubJobUnitsButtonClick(Sender: TObject);
  private
    FStartTime: integer;

    procedure SetProgressOptionsFromForm(AProgress: TdmProgress);
    procedure AfterJob;
  public
  end;

var
  MainForm: TMainForm;

implementation

uses ExtraF;

{$R *.DFM}

procedure TMainForm.AfterJob;
begin
  if AfterJobStatusCheckBox.Checked then
    ShowMessage(
      Format(
        'Job done i %d milliseconds.',
        [(integer(GetTickCount) - FStartTime) div 1]));
end;

procedure TMainForm.SetProgressOptionsFromForm(AProgress: TdmProgress);
begin
  FStartTime := GetTickCount;

  AProgress.Options := [];
  if CancelCheckBox.Checked then
    AProgress.Options := AProgress.Options + [poCancelButton];
  if WaitCheckBox.Checked then
    AProgress.Options := AProgress.Options + [poCloseButton];
  if ShowImmediatelyCheckBox.Checked then
    AProgress.Options := AProgress.Options + [poShowImmediately];
  if NoDialogCheckBox.Checked then
    AProgress.Options := AProgress.Options + [poNoDialog];
end;

procedure TMainForm.DemoReestimateButtonClick(Sender: TObject);
var
  FProgress: TdmProgress;
  MainJobStep, SubJobStep: integer;
  SubJobLength: integer;
const
  MainJobLength = 10;
begin
	FProgress := TdmProgress.Create(nil);
  try
    SetProgressOptionsFromForm(FProgress);

    FProgress.AverageSubJobLengthGuess := 50;
		FProgress.SetMainJob('Generating whatever',
      MainJobLength * FProgress.AverageSubJobLengthGuess);

    for MainJobStep := 0 to MainJobLength-1 do
    begin
      SubJobLength := Random(100);
      FProgress.SetSubJob(
        Format('Processing item #%d', [MainJobStep+1]), SubJobLength);
      for SubJobStep := 0 to SubJobLength-1 do
      begin
        Sleep(20);
      	FProgress.IncJobPos;
      end;
      if FProgress.Cancelled then
        Exit;

      FProgress.ReEstimate(MainJobStep, MainJobLength, FProgress.CurrStep);

    end;

    AfterJob;

   	FProgress.FinishJob;
  finally
    FProgress.Free;
  end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Randomize;
end;

procedure TMainForm.DemoFixedEstimateButtonClick(Sender: TObject);
var
  FProgress: TdmProgress;
  MainJobStep, SubJobStep: integer;
const
  MainJobLength = 10;
  SubJobLength = 20;
begin
	FProgress := TdmProgress.Create(nil);
  try
    SetProgressOptionsFromForm(FProgress);

		FProgress.SetMainJob('Generating whatever',
      MainJobLength * SubJobLength);

    for MainJobStep := 0 to MainJobLength-1 do
    begin
      FProgress.SetSubJob(
        Format('Processing item #%d', [MainJobStep+1]), SubJobLength);
      for SubJobStep := 0 to SubJobLength-1 do
      begin
        Sleep(50);
      	FProgress.IncJobPos;
      end;
      if FProgress.Cancelled then
        Exit;
    end;

    AfterJob;

   	FProgress.FinishJob;
  finally
    FProgress.Free;
  end;
end;

procedure TMainForm.OnlyMainJobButtonClick(Sender: TObject);
var
  FProgress: TdmProgress;
  MainJobStep: integer;
const
  MainJobLength = 10;
begin
	FProgress := TdmProgress.Create(nil);
  try
    SetProgressOptionsFromForm(FProgress);

		FProgress.SetMainJob('Generating whatever',
      MainJobLength);

    for MainJobStep := 0 to MainJobLength-1 do
    begin
      Sleep(300);
      FProgress.IncJobPos;
      if FProgress.Cancelled then
        Exit;
    end;

    AfterJob;

   	FProgress.FinishJob;
  finally
    FProgress.Free;
  end;
end;

procedure TMainForm.AtomicSubJobOperationsButtonClick(Sender: TObject);
var
  FProgress: TdmProgress;
  MainJobStep: integer;
const
  MainJobLength = 10;
begin
	FProgress := TdmProgress.Create(nil);
  try
    SetProgressOptionsFromForm(FProgress);

		FProgress.SetMainJob('Generating whatever',
      MainJobLength);

    for MainJobStep := 0 to MainJobLength-1 do
    begin
      FProgress.SetSubJob(
        Format('Processing item #%d', [MainJobStep+1]), 1);
      Sleep(300);
    	FProgress.IncJobPos;
      if FProgress.Cancelled then
        Exit;
    end;

    AfterJob;

   	FProgress.FinishJob;
  finally
    FProgress.Free;
  end;
end;

procedure TMainForm.TestModalButtonClick(Sender: TObject);
begin
  MessageBeep(0);
  ShowMessage('Not modal! - not very nice!!');
end;

procedure TMainForm.FromSubFormButtonClick(Sender: TObject);
var
  f: TExtraForm;
begin
  f := TExtraForm.Create(nil);
  try
    f.ShowModal;
  finally
    f.Free;
  end;
end;

procedure TMainForm.DemoInSubJobUnitsButtonClick(Sender: TObject);
var
  FProgress: TdmProgress;
  MainJobStep, SubJobStep: integer;
const
  MainJobLength = 10;
  SubJobLength = 20;
begin
	FProgress := TdmProgress.Create(nil);
  try
    SetProgressOptionsFromForm(FProgress);

		FProgress.SetMainJob('Generating whatever', MainJobLength);
    FProgress.SeperateSubJobUnits := true;

    for MainJobStep := 0 to MainJobLength-1 do
    begin
      FProgress.SetSubJob(
        Format('Processing item #%d', [MainJobStep+1]), SubJobLength);
      for SubJobStep := 0 to SubJobLength-1 do
      begin
        Sleep(50);
      	FProgress.IncJobPos;
      end;
      if FProgress.Cancelled then
        Exit;
    end;

    AfterJob;

   	FProgress.FinishJob;
  finally
    FProgress.Free;
  end;
end;

end.
