unit ExtraF;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls;

type
  TExtraForm = class(TForm)
    ProgressButton: TButton;
    Label1: TLabel;
    MainJobLengthEdit: TEdit;
    Label2: TLabel;
    DelayEdit: TEdit;
    SecsBeforeDisplayTrackBar: TTrackBar;
    Label3: TLabel;
    Label4: TLabel;
    procedure ProgressButtonClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    MainJobLength, Delay: integer;
    
    procedure DisplayData;
  public
  end;

implementation

uses dmagicProgress;

{$R *.DFM}

procedure TExtraForm.DisplayData;
begin
  MainJobLengthEdit.Text := IntToStr(MainJobLength);
  DelayEdit.Text := IntToStr(Delay);
end;

procedure TExtraForm.ProgressButtonClick(Sender: TObject);
var
  FProgress: TdmProgress;
  MainJobStep: integer;
begin
	FProgress := TdmProgress.Create(nil);
  try
    FProgress.ShowDelayTimerInterval := SecsBeforeDisplayTrackBar.Position * 1000;

		FProgress.SetMainJob('Working hard to move button',
      MainJobLength);

    for MainJobStep := 0 to MainJobLength-1 do
    begin
      Sleep(Delay);
      FProgress.IncJobPos;
      if FProgress.Cancelled then
        Exit;
    end;

   	FProgress.FinishJob;
  finally
    FProgress.Free;
  end;
  ProgressButton.Left := ProgressButton.Left + 10;

  Delay := Random(100) + 50;
  MainJobLength := Random(50) + 25;
  DisplayData;
end;

procedure TExtraForm.FormCreate(Sender: TObject);
begin
  MainJobLength := 50;
  Delay := 100;
  DisplayData;
end;

end.
