{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxUtils;

interface

uses
  SysUtils, Windows, Classes, WinSpool, stdctrls, messages, clipbrd,
  CommDlg, Forms,

  pr_TxConsts, pr_Common, pr_MultiLang;

type
////////////////////////////
//
// TprTxOEMMemo
//
////////////////////////////
TprTxOEMMemo = class(TMemo)
private
  procedure WMCopy(var Msg : TWMCopy); message WM_COPY;
  procedure WMPaste(var Msg : TWMPaste); message WM_PASTE;
  procedure WMChar(var Msg : TWMChar); message WM_CHAR;
public
  Decode : boolean;

  constructor Create(AOwner : TComponent); override;
end;

function ParsePages(Lines          : TStrings;
                    UseLinesOnPage : boolean;
                    LinesOnPage    : integer;
                    PagesList      : TList) : integer;

function RemoveESCFromString(const s : string) : string;

function TxPrintStrings(Lines               : TStrings;
                        PrinterName         : string; //  
                        ESCModel            : TprESCModel; // ESC  
                        ReportTitle         : string; //     Spooler Windows
                        Copies              : integer; //  
                        WrapAfterColumn     : integer; //       
                        LeftSpaces          : integer; //    
                        PaperType           : TprTxPaperType; //     
                        PrintRulonMode      : TprTxPrintRulonMode; //      :     
                        MakeFormFeedOnRulon : boolean; //   true          
                        FromLine            : integer; //        ,     1
                        ToLine              : integer; //        ,     1
                        PrintPagesMode      : TprPrintPagesMode; //      : ,  ,   
                        LinesOnPage         : integer; //    
                        UseLinesOnPage      : boolean; //   True          ,       LinesOnPage
                        PrintPagesList      : TList; //   ,  ,         1
                        FromPage            : integer; //     ,   1
                        ToPage              : integer; //     ,   1
                        NeedDecode          : boolean=false;  //    DOS 
                        StartNewLineOnWrap  : boolean=false
                        ) : boolean;

function TxSetupPrintParams(hWndOwner               : THandle; // Handle ,   Owner    
                            MaxPage                 : integer; //   
                            MaxLines                : integer;
                            var LinesOnPage         : integer;
                            var FromPage            : integer;
                            var ToPage              : integer;
                            var PrintPagesMode      : TprPrintPagesMode;
                            var ESCModelName        : string;
                            var PrinterName         : string;
                            var UseLinesOnPage      : boolean;
                            var WrapAfterColumn     : integer;
                            var MakeFormFeedOnRulon : boolean;
                            var LeftSpaces          : integer;
                            var PrintRulonMode      : TprTxPrintRulonMode;
                            var FromLine            : integer;
                            var ToLine              : integer;
                            var PrintPages          : string;
                            PrintPagesList          : TList;
                            var PaperType           : TprTxPaperType;
                            var Copies              : integer
                            )  : boolean;

function TxGetESCModelForPrinter(PrinterName : string) : TprESCModel;

implementation

uses
  pr_Strings, pr_Utils;

function TxGetESCModelForPrinter;
var
  Buf,Buffer : PChar;
  i,BytesNeeded,NumInfo : cardinal;
begin
Result     :=nil;
Buffer     :=nil;
BytesNeeded:=0;

EnumPrinters(PRINTER_ENUM_LOCAL or PRINTER_ENUM_CONNECTIONS,nil,2,Buffer,0,BytesNeeded,NumInfo);
if BytesNeeded<>0 then
  begin
    GetMem(Buffer,BytesNeeded);
    try
      if EnumPrinters(PRINTER_ENUM_LOCAL or PRINTER_ENUM_CONNECTIONS,PChar(PrinterName),2,Buffer,BytesNeeded,BytesNeeded,NumInfo) then
        begin
          i  :=0;
          Buf:=Buffer;
          while (i<NumInfo) and (StrPas(PPrinterInfo2(Buf).pPrinterName)<>PrinterName) do
            begin
              Inc(i);
              Buf:=Buf+sizeof(TPrinterInfo2);
            end;
          if i<NumInfo then
            begin
              Result:=ESCModels.FindByDriverName(StrPas(PPrinterInfo2(Buf).pDriverName));
            end;
        end;
    finally
      FreeMem(Buffer);
    end;
  end;
end;

function RemoveESCFromString;
var
  j,l,bi : integer;
begin
l :=Length(s);
j :=1;
bi:=1;
SetLength(Result,l);
while j<=l do
  begin
    if (s[j]=ESCSymbol) and (j<l) then
      Inc(j)
    else
      begin
        Result[bi]:=s[j];
        Inc(bi);
      end;
    Inc(j);
  end;
SetLength(Result,bi-1);
end;


type
  rSetupPrintParams = record
    MaxLines            : integer;
    PrintPagesMode      : TprPrintPagesMode;
    ESCModelName        : string;
    PrinterName         : string;
    UseLinesOnPage      : boolean;
    WrapAfterColumn     : integer;
    MakeFormFeedOnRulon : boolean;
    LeftSpaces          : integer;
    PrintRulonMode      : TprTxPrintRulonMode;
    FromLine            : integer;
    ToLine              : integer;
    PrintPages          : string;
    PrintPagesList      : TList;
    PaperType           : TprTxPaperType;
    LinesOnPage         : integer;
  end;
  pSetupPrintParams = ^rSetupPrintParams;


const
  IDD_PRINTTEMPLATE = 1002;
  IDC_PAGESLIST     = 1000;
  IDC_ALL           = 1056;
  IDC_PAGES         = 1058;
  IDC_SELECTION     = 1057;
  IDC_EDITPAGESLIST = 1001;
  IDC_FROMPAGE      = 1152;
  IDC_TOPAGE        = 1153;

  IDC_PAPERPAGE     = 1007;
  IDC_PAPERRULON    = 1008;

  IDC_RULONALLLINES   = 1059;
  IDC_RULONLINESRANGE = 1060;

  IDC_LINESFROM       = 1155;
  IDC_LINESTO         = 1156;

  IDC_ESCMODEL        = 1002;

  IDC_PRINTERS        = 1139;

  IDC_MAKEFORMFEEDONRULON = 1006;
  IDC_LEFTSPACES          = 1003;

  IDC_USELINESONPAGE      = 1004;
  IDC_LINESONPAGE         = 1157;

  IDC_WRAPAFTERCOLUMN     = 1005;

var
  cpd  : PPrintDlg;
  pspr : pSetupPrintParams;

procedure CenterWindow(Wnd: HWnd);
var
  Rect: TRect;
  Monitor: TMonitor;
begin
  GetWindowRect(Wnd, Rect);
  if Application.MainForm <> nil then
    Monitor := Application.MainForm.Monitor
  else
    Monitor := Screen.Monitors[0];
  SetWindowPos(Wnd,
               0,
               Monitor.Left + ((Monitor.Width - Rect.Right + Rect.Left) div 2),
               Monitor.Top + ((Monitor.Height - Rect.Bottom + Rect.Top) div 3),
               0, 0, SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOZORDER);
end;

function DialogHook(Wnd: HWnd; Msg: UINT; WParam: WPARAM; LParam: LPARAM): UINT; stdcall;
var
  pl : TList;
  Buf : string;
  bBuf : LongBool;
  ESCModel : TprESCModel;
  Min,Max,lMin,lMax,CtrlID,TextLength : integer;

  procedure Check(CtrlIDs : array of integer);
  var
    i : integer;
  begin
  for i:=0 to High(CtrlIDs) do
    SendDlgItemMessage(Wnd,CtrlIDs[i],BM_SETCHECK,BST_CHECKED,0);
  end;

  procedure UnCheck(CtrlIDs : array of integer);
  var
    i : integer;
  begin
  for i:=0 to High(CtrlIDs) do
    SendDlgItemMessage(Wnd,CtrlIDs[i],BM_SETCHECK,BST_UNCHECKED,0);
  end;

  function IsChecked(CtrlID : integer) : boolean;
  begin
  Result:=SendDlgItemMessage(Wnd,CtrlID,BM_GETCHECK,0,0)=BST_CHECKED;
  end;

  function GetText(CtrlID : integer) : string;
  var
    TextLength : integer;
  begin
  TextLength:=GetWindowTextLength(GetDlgItem(Wnd,CtrlID));
  if TextLength>0 then
    begin
      SetLength(Result,TextLength);
      if GetDlgItemText(Wnd,CtrlID,@(Result[1]),TextLength+1)<=0 then
        Result:='';
    end
  else
    Result:='';
  end;

  function GetSelText(CtrlID : integer) : string;
  var
    i,TextLength : integer;
  begin
  Result:='';
  i     :=SendDlgItemMessage(Wnd,CtrlID,CB_GETCURSEL,0,0);
  if i<>CB_ERR then
    begin
      TextLength:=SendDlgItemMessage(Wnd,CtrlID,CB_GETLBTEXTLEN,i,0);
      if TextLength>0 then
        begin
          SetLength(Result,TextLength);
          if SendDlgItemMessage(Wnd,CtrlID,CB_GETLBTEXT,i,integer(@(Result[1])))=CB_ERR then
            Result:=''
        end
      else
        Result:='';
    end;
  end;

begin
Result := 0;

case Msg of
  WM_INITDIALOG:
    begin
      cpd :=PPrintDlg(lParam);
      pspr:=pSetupPrintParams(cpd.lCustData);

      SetDlgItemText(Wnd,IDC_EDITPAGESLIST,PChar(pspr.PrintPages));
      SetDlgItemInt(Wnd,IDC_LINESFROM,pspr.FromLine,false);
      SetDlgItemInt(Wnd,IDC_LINESTO,pspr.ToLine,false);
      SetDlgItemInt(Wnd,IDC_LINESONPAGE,pspr.LinesOnPage,false);
      SetDlgItemInt(Wnd,IDC_WRAPAFTERCOLUMN,pspr.WrapAfterColumn,false);

      UnCheck([IDC_PAGESLIST,
               IDC_PAGES,
               IDC_SELECTION,
               IDC_ALL,
               IDC_MAKEFORMFEEDONRULON,
               IDC_PAPERRULON,
               IDC_PAPERPAGE,
               IDC_USELINESONPAGE,
               IDC_RULONALLLINES,
               IDC_RULONLINESRANGE]);


      if pspr.MakeFormFeedOnRulon then
        Check([IDC_MAKEFORMFEEDONRULON]);

      SetDlgItemInt(Wnd,IDC_LEFTSPACES,pspr.LeftSpaces,false);

      case pspr.PaperType of
        ptRulon:
          begin
            Check([IDC_PAPERRULON]);
            case pspr.PrintRulonMode of
              prmAllLines  : Check([IDC_RULONALLLINES]);
              prmLinesRange: Check([IDC_RULONLINESRANGE]);
            end;
          end;
        ptPage :
          begin
            Check([IDC_PAPERPAGE]);
            case pspr.PrintPagesMode of
              ppmPagesList : Check([IDC_PAGESLIST]);
              ppmPagesRange: Check([IDC_PAGES]);
              ppmSelection : Check([IDC_SELECTION]);
                        else Check([IDC_ALL]);
            end;
          end;
      end;

      for Min:=0 to ESCModels.Count-1 do
        SendDlgItemMessage(Wnd,IDC_ESCMODEL,CB_ADDSTRING,0,integer(PChar(ESCModels[Min].ModelName)));

      SendDlgItemMessage(Wnd,IDC_ESCMODEL,CB_SELECTSTRING,0,integer(PChar(pspr.ESCModelName)));
      SendDlgItemMessage(Wnd,IDC_PRINTERS,CB_SELECTSTRING,0,integer(PChar(pspr.PrinterName)));
      SendMessage(Wnd,WM_COMMAND,(CBN_SELCHANGE shl 16) or IDC_PRINTERS,GetDlgItem(Wnd,IDC_PRINTERS));

      if pspr.UseLinesOnPage then
        Check([IDC_USELINESONPAGE]);

      CenterWindow(Wnd);
    end;
  WM_COMMAND:
    begin
      case wParam of
        IDOK:
          begin
            ////////////////////////
            //   [OK]
            ////////////////////////

            //  ESCMODEL
            Min:=SendDlgItemMessage(Wnd,IDC_ESCMODEL,CB_GETCURSEL,0,0);
            if Min=CB_ERR then
              Result:=1
            else
              begin
                TextLength:=SendDlgItemMessage(Wnd,IDC_ESCMODEL,CB_GETLBTEXTLEN,Min,0)+1;
                Buf       :=MakeStr(' ',TextLength);
                if SendDlgItemMessage(Wnd,IDC_ESCMODEL,CB_GETLBTEXT,Min,integer(@(Buf[1])))<>CB_ERR then
                  begin
                    Min:=ESCModels.IndexByModelName(Buf);
                    if Min=-1 then
                      Result:=1;
                  end;
              end;
            if Result=1 then
              Application.MessageBox(PChar(prLoadStr(sSetupPrintError5)),PChar(prLoadStr(sAttention)),MB_OK+MB_ICONEXCLAMATION);


            //   
            if (Result=0) and
               (IsChecked(IDC_RULONLINESRANGE)) then
              begin
                lMin:=GetDlgItemInt(Wnd,IDC_LINESFROM,bBuf,false);
                lMax:=GetDlgItemInt(Wnd,IDC_LINESTO,bBuf,false);
                if lMin>lMax then
                  begin
                    Application.MessageBox(PChar(prLoadStr(sSetupPrintError3)),PChar(prLoadStr(sAttention)),MB_OK+MB_ICONEXCLAMATION);
                    Result:=1;
                  end;
                if (lMin<=0) or (lMax>pspr.MaxLines) then
                  begin
                    Application.MessageBox(PChar(Format(prLoadStr(sSetupPrintError4),[1,pspr.MaxLines])),PChar(prLoadStr(sAttention)),MB_OK+MB_ICONEXCLAMATION);
                    Result:=1;
                  end;
              end;

            //   
            if (Result=0) and
               IsChecked(IDC_PAGESLIST) then
              begin
                // 
                Buf:=GetText(IDC_EDITPAGESLIST);
                if Buf='' then
                  begin
                    Application.MessageBox(PChar(prLoadStr(sSetupPrintError1)),PChar(prLoadStr(sAttention)),MB_OK+MB_ICONEXCLAMATION);
                    Result:=1;
                  end
                else
                  begin
                    pl:=TList.Create;
                    try
                      TextToPageList(Buf,pl);
                      Min :=cpd.nMinPage;
                      Max :=cpd.nMaxPage;
                      lMin:=integer(pl[0]);
                      lMax:=integer(pl[pl.Count-1]);
                      if (lMin<Min) or (lMin>Max) or (lMax<Min) or (lMax>Max) then
                        begin
                          SetFocus(GetDlgItem(Wnd,IDC_EDITPAGESLIST));
                          Application.MessageBox(PChar(Format(prLoadStr(sSetupPrintError2),[Min,Max])),PChar(prLoadStr(sAttention)),MB_ICONEXCLAMATION+MB_OK);
                          Result:=1;
                        end;
                    finally
                      pl.Free;
                    end;
                  end;
              end;

            //  LinesOnPage
            if (Result=0) and
               IsChecked(IDC_USELINESONPAGE) then
              begin
                Min:=GetDlgItemInt(Wnd,IDC_LINESONPAGE,bBuf,false);
                if Min<=0 then
                  begin
                    Application.MessageBox(PChar(prLoadStr(sSetupPrintError6)),PChar(prLoadStr(sAttention)),MB_OK+MB_ICONEXCLAMATION);
                    Result:=1;
                  end;
              end;

            if Result=0 then
              begin
                //////////////////////
                //  
                //////////////////////
                pspr.ESCModelName   :=GetSelText(IDC_ESCMODEL);
                pspr.PrinterName    :=GetSelText(IDC_PRINTERS);

                pspr.UseLinesOnPage :=IsChecked(IDC_USELINESONPAGE);
                pspr.LinesOnPage    :=GetDlgItemInt(Wnd,IDC_LINESONPAGE,bBuf,false);

                pspr.WrapAfterColumn:=GetDlgItemInt(Wnd,IDC_WRAPAFTERCOLUMN,bBuf,false);

                pspr.MakeFormFeedOnRulon:=IsChecked(IDC_MAKEFORMFEEDONRULON);
                pspr.LeftSpaces         :=GetDlgItemInt(Wnd,IDC_LEFTSPACES,bBuf,false);

                if IsChecked(IDC_PAPERRULON) then
                  pspr.PaperType:=ptRulon
                else
                  if IsChecked(IDC_PAPERPAGE) then
                    pspr.PaperType:=ptPage;

                pspr.FromLine :=GetDlgItemInt(Wnd,IDC_LINESFROM,bBuf,false);
                pspr.ToLine   :=GetDlgItemInt(Wnd,IDC_LINESTO,bBuf,false);

                if IsChecked(IDC_RULONALLLINES) then
                  pspr.PrintRulonMode:=prmAllLines
                else
                  if IsChecked(IDC_RULONLINESRANGE) then
                    pspr.PrintRulonMode:=prmLinesRange;

                pspr.PrintPages:=GetText(IDC_EDITPAGESLIST);
                TextToPageList(pspr.PrintPages,pspr.PrintPagesList);

                if IsChecked(IDC_PAGESLIST) then
                  pspr.PrintPagesMode:=ppmPagesList
                else
                  if IsChecked(IDC_ALL) then
                    pspr.PrintPagesMode:=ppmAll
                  else
                    if IsChecked(IDC_PAGES) then
                      pspr.PrintPagesMode:=ppmPagesRange;
              end;
          end
        else
          case WParam shr 16 of
            BN_CLICKED :
              begin
                CtrlID:=GetDlgCtrlID(LParam);
                case CtrlID of
                  IDC_PAPERPAGE:
                    begin
                      UnCheck([IDC_PAPERRULON,IDC_RULONALLLINES,IDC_RULONLINESRANGE]);
                      Check([IDC_PAPERPAGE]);
                    end;
                  IDC_PAPERRULON:
                    begin
                      UnCheck([IDC_PAPERPAGE,IDC_ALL,IDC_PAGES,IDC_SELECTION,IDC_PAGESLIST]);
                      Check([IDC_PAPERRULON]);
                    end;
                  IDC_RULONALLLINES:
                    begin
                      UnCheck([IDC_PAPERPAGE,IDC_RULONLINESRANGE,IDC_ALL,IDC_PAGES,IDC_SELECTION,IDC_PAGESLIST]);
                      Check([IDC_PAPERRULON,IDC_RULONALLLINES]);
                    end;
                  IDC_RULONLINESRANGE:
                    begin
                      UnCheck([IDC_PAPERPAGE,IDC_RULONALLLINES,IDC_ALL,IDC_PAGES,IDC_SELECTION,IDC_PAGESLIST]);
                      Check([IDC_PAPERRULON,IDC_RULONLINESRANGE]);

                      SetFocus(GetDlgItem(Wnd,IDC_LINESFROM));
                    end;
                  IDC_PAGESLIST:
                    begin
                      UnCheck([IDC_PAPERRULON,IDC_RULONALLLINES,IDC_RULONLINESRANGE,IDC_ALL,IDC_PAGES,IDC_SELECTION]);
                      Check([IDC_PAPERPAGE,IDC_PAGESLIST]);

                      SetFocus(GetDlgItem(Wnd,IDC_EDITPAGESLIST));
                      Result:=1;
                    end;
                  IDC_ALL,IDC_PAGES,IDC_SELECTION:
                    begin
                      UnCheck([IDC_PAPERRULON,IDC_PAGESLIST,IDC_RULONALLLINES,IDC_RULONLINESRANGE]);
                      Check([IDC_PAPERPAGE]);
                    end;
                end;
              end;
            EN_CHANGE:
              begin
                case GetDlgCtrlID(lParam) of
                  IDC_EDITPAGESLIST:
                    begin
                      UnCheck([IDC_PAPERRULON,IDC_RULONALLLINES,IDC_RULONLINESRANGE,IDC_ALL,IDC_PAGES,IDC_SELECTION]);
                      Check([IDC_PAPERPAGE,IDC_PAGESLIST]);
                    end;
                  IDC_FROMPAGE,IDC_TOPAGE:
                    begin
                      UnCheck([IDC_PAPERRULON,IDC_RULONALLLINES,IDC_RULONLINESRANGE,IDC_ALL,IDC_SELECTION]);
                      Check([IDC_PAPERPAGE]);
                    end;
                  IDC_LINESFROM,IDC_LINESTO:
                    begin
                      UnCheck([IDC_PAPERPAGE,IDC_RULONALLLINES,IDC_ALL,IDC_PAGES,IDC_SELECTION,IDC_PAGESLIST]);
                      Check([IDC_PAPERRULON,IDC_RULONLINESRANGE]);
                    end;
                end;
              end;
            CBN_SELCHANGE:
              begin
                case GetDlgCtrlID(lParam) of
                  IDC_PRINTERS:
                    begin
                      Min:=SendDlgItemMessage(Wnd,IDC_PRINTERS,CB_GETCURSEL,0,0);
                      if Min<>CB_ERR then
                        begin
                          TextLength:=SendDlgItemMessage(Wnd,IDC_PRINTERS,CB_GETLBTEXTLEN,Min,0)+1;
                          Buf       :=MakeStr(' ',TextLength);
                          if SendDlgItemMessage(Wnd,IDC_PRINTERS,CB_GETLBTEXT,Min,integer(@(Buf[1])))<>CB_ERR then
                            begin
                              ESCModel:=ESCModels.FindByDriverName(Buf);
                              if ESCModel<>nil then
                                SendDlgItemMessage(Wnd,IDC_ESCMODEL,CB_SELECTSTRING,0,integer(PChar(ESCModel.ModelName)))
                              else
                                SendDlgItemMessage(Wnd,IDC_ESCMODEL,CB_SETCURSEL,-1,0)
                            end;
                        end;
                    end;
                end;
              end;
          end;
      end;
    end;
end;
end;


function TxSetupPrintParams;
var
  pd : tagPDA;
  spr : rSetupPrintParams;
begin
spr.MaxLines           :=MaxLines;
spr.PrintPagesMode     :=PrintPagesMode;
spr.ESCModelName       :=ESCModelName;
spr.PrinterName        :=PrinterName;
spr.UseLinesOnPage     :=UseLinesOnPage;
spr.WrapAfterColumn    :=WrapAfterColumn;
spr.MakeFormFeedOnRulon:=MakeFormFeedOnRulon;
spr.LeftSpaces         :=LeftSpaces;
spr.PrintRulonMode     :=PrintRulonMode;
spr.FromLine           :=FromLine;
spr.ToLine             :=ToLine;
spr.PrintPages         :=PrintPages;
spr.PrintPagesList     :=PrintPagesList;
spr.PaperType          :=PaperType;
spr.LinesOnPage        :=LinesOnPage;

ZeroMemory(@pd,sizeof(pd));
pd.hWndOwner          :=hWndOwner;
pd.lStructSize        :=sizeof(pd);
pd.hInstance          :=SysInit.hInstance;
pd.lpPrintTemplateName:=PChar(IDD_PRINTTEMPLATE);
pd.nCopies            :=Copies;
if pd.nCopies=0 then
  pd.nCopies:=1;
pd.nMinPage           :=1;
pd.nMaxPage           :=MaxPage;
pd.nFromPage          :=FromPage;
if pd.nFromPage=0 then
  pd.nFromPage:=1;
pd.nToPage            :=ToPage;
if pd.nToPage>MaxPage then
  pd.nToPage:=MaxPage;
if pd.nToPage=0 then
  pd.nToPage:=1;
pd.lCustData          :=integer(@spr);
pd.lpfnPrintHook      :=@DialogHook;
pd.Flags              :=PD_HIDEPRINTTOFILE or PD_NONETWORKBUTTON or
                        PD_ENABLEPRINTHOOK or PD_NOSELECTION or
                        PD_ENABLEPRINTTEMPLATE;
case PrintPagesMode of
  ppmAll       : pd.Flags:=pd.Flags+PD_ALLPAGES;
  ppmPagesRange: pd.Flags:=pd.Flags+PD_PAGENUMS;
end;


Result:=PrintDlg(pd);
if Result then
  begin
    Copies             :=pd.nCopies;
    FromPage           :=pd.nFromPage;
    ToPage             :=pd.nToPage;

    PrintPagesMode     :=spr.PrintPagesMode;
    ESCModelName       :=spr.ESCModelName;
    PrinterName        :=spr.PrinterName;
    UseLinesOnPage     :=spr.UseLinesOnPage;
    WrapAfterColumn    :=spr.WrapAfterColumn;
    MakeFormFeedOnRulon:=spr.MakeFormFeedOnRulon;
    LeftSpaces         :=spr.LeftSpaces;
    PrintRulonMode     :=spr.PrintRulonMode;
    FromLine           :=spr.FromLine;
    ToLine             :=spr.ToLine;
    PrintPages         :=spr.PrintPages;
    PaperType          :=spr.PaperType;
    LinesOnPage        :=spr.LinesOnPage;
  end;
end;



function ParsePages;
var
  i,j : integer;
  Buf : string;
begin
Result:=1;
if PagesList<>nil then
  PagesList.Add(pointer(0));
  
Buf:=ESCSymbol+ESCSpecifiers[ecFormFeed];
j  :=0;
for i:=0 to Lines.Count-1 do
  begin
    if pos(Buf,Lines[i])<>0 then
      begin
        if PagesList<>nil then
          PagesList.Add(pointer(i+1));
        j:=0;
        Inc(Result);
      end
    else
      begin
        if (UseLinesOnPage) and (j>=LinesOnPage) then
          begin
            if PagesList<>nil then
              PagesList.Add(pointer(i+1));
            j:=0;
            Inc(Result);
          end;
      end;
    Inc(j);
  end;
end;

//
//
//
function TxPrintStrings;
var
  h : Cardinal;
  DocInfo : DOC_INFO_1;
  wc,WrapCount,i,j,k,l,ml,_FromLine,_ToLine : integer;
  PrinterOpened,DocStarted,PageStarted : boolean;
  PagesList : TList;

  //      Esc 
  function StrLengthNoEsc(const s : string) : integer;
  var
    l,i : integer;
  begin
  Result:=0;
  l     :=Length(s);
  i     :=1;
  while i<=l do
    begin
      if (s[i]=ESCSymbol) and (i<l) and (s[i+1] in ESCSpecifiersSet) then
        Inc(i)
      else
        Inc(Result);
      Inc(i);
    end;
  end;

  //   ,    wc, wc   0
  //       , 
  //     
  procedure PrintLine(const s : string; wc : integer; PrintFormFeed : boolean);
  var
    j : TprESCCode;
    i,l,sl,el : integer;
    b1,b2 : string;
    BytesWritten : cardinal;

    procedure SkipTo(var i : integer; LenStr : integer; SkipCount : integer);
    var
      sl : integer;
    begin
    sl:=1;
    while (i<=LenStr) and (sl<=SkipCount) do
      begin
        if (s[i]=ESCSymbol) and (i<l) and (s[i+1] in ESCSpecifiersSet) then
          Inc(i)
        else
          Inc(sl);
        Inc(i);
      end;
    end;

  begin
  //      S
  l:=Length(s);
  if WrapAfterColumn<1 then
    begin
      sl:=1;
      el:=l+1;
    end
  else
    begin
      i :=1;
      SkipTo(i,l,wc*WrapAfterColumn);
      sl :=i;
      SkipTo(i,l,WrapAfterColumn);
      el :=i;
    end;
  if (sl>l) and ((l>0) or (wc>0)) and StartNewLineOnWrap then
    exit; 

  //   ESC    
  b2:='';
  i :=1;
  while i<sl do
    begin
      if (s[i]=ESCSymbol) and (i<(sl-1)) then
        begin
          Inc(i);
          //   ESC 
          j:=GetESCCodeByESCSpecifier(s[i]);
          if (j<>TprESCCode(-1)) and ((j<>ecFormFeed) or PrintFormFeed) then
            b2:=b2+ESCModel.ESCs[j];
        end;
      Inc(i);
    end;

  //   
  b1:=MakeStr(' ',LeftSpaces)+Copy(s,sl,el-sl)+#13#10;
  i :=1;
  l :=Length(b1);
  while i<=l do
    begin
      if (b1[i]=ESCSymbol) and (i<l) then
        begin
          Inc(i);
          j:=GetESCCodeByESCSpecifier(s[i]);
          if (j<>TprESCCode(-1)) and ((j<>ecFormFeed) or PrintFormFeed) then
            b2:=b2+ESCModel.ESCs[j];
        end
      else
        b2:=b2+b1[i];
      Inc(i);
    end;

  if NeedDecode then
    prWINtoOEM(PChar(b2),PChar(b2));
  WritePrinter(h, @(b2[1]), Length(b2), BytesWritten);
  end;

  procedure CheckStartPagePrinter;
  begin
  PageStarted:=StartPagePrinter(h);
  if not PageStarted then
    raise Exception.CreateFmt(prLoadStr(sErrorTxStartPage),[GetLastError]);
  end;

  procedure EjectPage;
  var
    b : string;
    BytesWritten : cardinal;
  begin
  b:=ESCModel.Style[ecFormFeed];
  WritePrinter(h,@(b[1]),Length(b),BytesWritten);
  end;
  
  procedure PrintPage(PageIndex : integer);
  var
    i,j,l : integer;
  begin
  if PageIndex>=PagesList.Count-1 then
    l:=Lines.Count
  else
    l:=integer(PagesList[PageIndex+1]);

  if StartNewLineOnWrap then
    begin
      for i:=integer(PagesList[PageIndex]) to l-1 do
        for j:=0 to WrapCount do
          PrintLine(Lines[i],j,false);
      EjectPage;
    end
  else
    begin
      for j:=0 to WrapCount do
        begin
          for i:=integer(PagesList[PageIndex]) to l-1 do
            PrintLine(Lines[i],j,false);
          EjectPage;
        end;
    end;
  end;

begin
Result       :=false;
PrinterOpened:=false;
DocStarted   :=false;
PageStarted  :=false;
PagesList    :=TList.Create;
try
  if not OpenPrinter(PChar(PrinterName),h,nil) then
    raise Exception.CreateFmt(prLoadStr(sErrorTxOpenPrinter),[GetLastError]);
  PrinterOpened:=true;

  DocInfo.pDocName   :=PChar(ReportTitle);
  DocInfo.pOutputFile:=nil;
  DocInfo.pDatatype  :='RAW';
  if StartDocPrinter(h,1,@DocInfo)=0 then
    raise Exception.CreateFmt(prLoadStr(sErrorTxStartDoc),[GetLastError]);
  DocStarted:=true;

  CheckStartPagePrinter;

  //   ,
  //      
  WrapCount:=0;
  if WrapAfterColumn>1 then
    begin
      ml:=StrLengthNoEsc(Lines[0]);
      for i:=1 to Lines.Count-1 do
        begin
          l:=StrLengthNoEsc(Lines[i]);
          if ml<l then
            ml:=l;
        end;

      WrapCount:=ml div WrapAfterColumn;
      if (ml mod WrapAfterColumn)=0 then
        Dec(WrapCount);
      if WrapCount=-1 then
        WrapCount:=0;
    end;

  //    PagesList,   
  //    Lines     
  if PaperType=ptPage then
    ParsePages(Lines,UseLinesOnPage,LinesOnPage,PagesList);

  case PaperType of
    ptRulon:
      begin
        ///////////////////
        //   
        ///////////////////
        _FromLine:=0;
        _ToLine  :=Lines.Count-1;
        case PrintRulonMode of
          prmLinesRange : begin _FromLine:=FromLine-1; _ToLine:=ToLine-1; end;
        end;

        for i:=1 to Copies do
          if StartNewLineOnWrap then
            for j:=_FromLine to _ToLine do
              for wc:=0 to WrapCount do
                PrintLine(Lines[j],wc,MakeFormFeedOnRulon)
          else
            for wc:=0 to WrapCount do
              for j:=_FromLine to _ToLine do
                PrintLine(Lines[j],wc,MakeFormFeedOnRulon);
      end;


    ptPage:
      begin
        ///////////////////
        //   
        ///////////////////
        for j:=1 to Copies do
          begin
            case PrintPagesMode of
              ppmAll,ppmPagesRange:
                begin
                  /////////////////////////////////////
                  //     
                  /////////////////////////////////////
                  i:=0;
                  k:=PagesList.Count-1;
                  if PrintPagesMode=ppmPagesRange then
                    begin
                      i:=FromPage-1;
                      k:=ToPage-1;
                    end;
                  for i:=i to k do
                    PrintPage(i);
                end;
              ppmPagesList:
                begin
                  ///////////////////////////////////////////////
                  // ,    PrintPagesList
                  ///////////////////////////////////////////////
                  for i:=0 to PrintPagesList.Count-1 do
                    PrintPage(integer(PrintPagesList[i])-1)
                end;
            end;
          end;
      end;
  end;

  Result:=true;

finally
  PagesList.Free;
  if PageStarted then
    EndPagePrinter(h);
  if DocStarted then
    EndDocPrinter(h);
  if PrinterOpened then
    ClosePrinter(h);
end;
end;

/////////////////////////
//
// TprTxOEMMemo
//
/////////////////////////
constructor TprTxOEMMemo.Create;
begin
inherited;
Font.Name := 'Courier New';
Font.Size := 12;
Font.Charset := OEM_CHARSET;
Decode := true;
end;

procedure TprTxOEMMemo.WMPaste;
var
  i : integer;
  s : string;
begin
s:=ClipBoard.AsText;
for i:=1 to Length(s) do
  SendMessage(Handle,WM_CHAR,integer(s[i]),0);
end;

procedure TprTxOEMMemo.WMCopy;
var
  s : string;
begin
inherited;
s := ClipBoard.AsText;
prOEMtoWIN(PChar(s),PChar(s));
ClipBoard.AsText:=s;
end;

procedure TprTxOEMMemo.WMChar;
var
  s : array [0..1] of char;
begin
if Decode then
  begin
    // 
    ZeroMemory(@(s[0]),2);
    s[0] := char(Msg.CharCode);
    prWINtoOEM(s,s);
    Msg.CharCode := word(s[0]);
  end;
inherited;
end;

end.

