{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxPageParams;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  typinfo, StdCtrls, ComCtrls, ExtCtrls, CheckLst,

  pr_Common, pr_TxClasses, pr_TxConsts, pr_MultiLang;

type
  TprTxPageParamsForm = class(TprForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    EDPageType: TComboBox;
    EDColNum: TEdit;
    EDLineNum: TEdit;
    UDColNum: TUpDown;
    UDLineNum: TUpDown;
    Button1: TButton;
    Button2: TButton;
    GroupBox1: TGroupBox;
    Label4: TLabel;
    EDDefTxFontStyle: TComboBox;
    Label5: TLabel;
    EDDefTxFontOptions: TCheckListBox;
    prMLRes1: TprMLRes;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
    function EditOptions(Page : TprTxPage) : boolean;
  end;

implementation

{$R *.DFM}

procedure TprTxPageParamsForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
ACtion:=caFree;
end;

function TprTxPageParamsForm.EditOptions;
var
  i : integer;
  fo : TTxFontOptionsSet;
begin
GetEnumNamesToStrings(TypeInfo(TprTxPageType),integer(High(TprTxPageType)),EDPageType.Items);
GetEnumNamesToStrings(TypeInfo(TTxFontStyle),integer(High(TTxFontStyle)),EDDefTxFontStyle.Items);

for i:=0 to integer(High(TTxFontOptions)) do
  begin
    EDDefTxFontOptions.Items.Add(GetEnumName(TypeInfo(TTxFontOptions),i));
    EDDefTxFontOptions.Checked[i]:=TTxFontOptions(i) in Page.DefTxFontOptions;
  end;

EDPageType.ItemIndex:=integer(Page.PageType);
UDColNum.Position   :=Page.ColNum;
UDLineNum.Position  :=Page.LineNum;
EDDefTxFontStyle.ItemIndex:=integer(Page.DefTxFontStyle);

Result:=ShowModal=mrOk;
if Result then
  begin
    Page.PageType:=TprTxPageType(EDPageType.ItemIndex);
    Page.ColNum  :=UDColNum.Position;
    Page.LineNum :=UDLineNum.Position;

    Page.DefTxFontStyle:=TTxFontStyle(EDDefTxFontStyle.ItemIndex);
    fo:=[];
    for i:=0 to integer(High(TTxFontOptions)) do
      if EDDefTxFontOptions.Checked[i] then
        Include(fo,TTxFontOptions(i));
    Page.DefTxFontOptions:=fo;
  end;
end;

end.
