{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxMemoLinesEditorForm;

interface
              
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Buttons, Grids,

  pr_Common, pr_TxClasses, pr_TxUtils, pr_MultiLang;

type
  TprTxMemoLinesEditorForm = class(TprForm)
    Panel1: TPanel;
    SG: TDrawGrid;
    bExpression: TSpeedButton;
    bPasteSymbol: TSpeedButton;
    bOK: TButton;
    bCancel: TButton;
    Bevel1: TBevel;
    prMLRes1: TprMLRes;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure SGDrawCell(Sender: TObject; ACol, ARow: Integer; Rect: TRect;
      State: TGridDrawState);
    procedure bExpressionClick(Sender: TObject);
    procedure SGDblClick(Sender: TObject);
    procedure bPasteSymbolClick(Sender: TObject);
    procedure SGKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure SGKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    Report  : TprTxReport;
    Lines   : TStrings;
    Memo    : TprTxOEMMemo;

    procedure PasteCurrentSymbol;
  public
    { Public declarations }
    procedure EditLines(_Report : TprTxReport; _Lines : TStrings);
  end;

implementation

uses pr_FormatExpression;

{$R *.DFM}

procedure TprTxMemoLinesEditorForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
Action:=caFree;
end;

procedure TprTxMemoLinesEditorForm.FormCreate(Sender: TObject);
begin
SG.Font.Charset:=OEM_CHARSET;

Memo:=TprTxOEMMemo.Create(Self);
with Memo do
  begin
    Align     :=alClient;
    Parent    :=Self;
    ScrollBars:=ssBoth;
  end;

LoadResImage(bExpression.Glyph,'OPEN');
LoadResImage(bPasteSymbol.Glyph,'PASTE');
end;

procedure TprTxMemoLinesEditorForm.SGDrawCell(Sender: TObject; ACol,
  ARow: Integer; Rect: TRect; State: TGridDrawState);
var
  s : string;
begin
s:=chr(ARow*16+ACol);
DrawTextEx(SG.Canvas.Handle,PChar(s),1,Rect,DT_CENTER+DT_VCENTER+DT_SINGLELINE,nil);
end;

procedure TprTxMemoLinesEditorForm.EditLines;
begin
Lines   :=_Lines;
Report  :=_Report;
Memo.Lines.Assign(Lines);

if ShowModal=mrOk then
  begin
    Lines.Assign(Memo.Lines);
  end;
end;

procedure TprTxMemoLinesEditorForm.bExpressionClick(Sender: TObject);
var
  s : string;
begin
TprFormatExpressionForm.Create(Application).SelectExpression(Report,Memo,s);
end;

procedure TprTxMemoLinesEditorForm.PasteCurrentSymbol;
begin
Memo.Decode:=false;
SendMessage(Memo.Handle,WM_CHAR,SG.Row*16+SG.Col,0);
Memo.Decode:=true;
end;

procedure TprTxMemoLinesEditorForm.SGDblClick(Sender: TObject);
begin
PasteCurrentSymbol;
end;

procedure TprTxMemoLinesEditorForm.bPasteSymbolClick(Sender: TObject);
begin
PasteCurrentSymbol;
end;

procedure TprTxMemoLinesEditorForm.SGKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
if Shift=[] then
  case Key of
    VK_SPACE:
      begin
        PasteCurrentSymbol;
        Key:=0;
      end;
  end;
end;

procedure TprTxMemoLinesEditorForm.SGKeyPress(Sender: TObject;
  var Key: Char);
begin
if Key<>' ' then
  SendMessage(Memo.Handle,WM_CHAR,byte(Key),0);
Key:=#0;
end;

end.
