{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxMemoEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Grids, ComCtrls,
  StdCtrls, ExtCtrls, Buttons, CheckLst,

  pr_Common, pr_TxClasses, pr_CommonDesigner, pr_TxUtils, pr_MultiLang,
  pr_Strings;

type
  TprTxMemoEditorForm = class(TprObjPropsForm)
    PC: TPageControl;
    PText: TTabSheet;
    PView: TTabSheet;
    PAlign: TTabSheet;
    RGvAlign: TRadioGroup;
    RGhAlign: TRadioGroup;
    TabSheet1: TTabSheet;
    CBDeleteEmptyLines: TCheckBox;
    CBDeleteEmptyLinesAtEnd: TCheckBox;
    CBCanResizeX: TCheckBox;
    CBCanResizeY: TCheckBox;
    CBWordWrap: TCheckBox;
    Panel1: TPanel;
    bDBFieldName: TSpeedButton;
    Label1: TLabel;
    EDTxFontStyle: TComboBox;
    Label2: TLabel;
    LBTxFontOptions: TCheckListBox;
    bLinesEditor: TSpeedButton;
    prMLRes1: TprMLRes;
    CBDefaultFont: TCheckBox;
    procedure CBDeleteEmptyLinesClick(Sender: TObject);
    procedure SBDBFieldNameClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure bLinesEditorClick(Sender: TObject);
  private
    { Private declarations }
    Memo : TprTxOEMMemo;
  protected
    procedure SetEnabledAfterCopyToControls; override;
    procedure CopySinglePropertiesFromControls(V : TprObjRecVersion); override;
    procedure CopyMultiplyPropertiesFromControls(L : TList); override;
    procedure CopySinglePropertiesToControls(V : TprObjRecVersion); override;
    procedure CopyMultiplyPropertiesToControls(L : TList); override;
  public
    { Public declarations }
  end;

implementation

uses pr_FormatExpression, pr_DesignerFunctions, pr_TxConsts,
  pr_TxMemoLinesEditorForm;

{$R *.DFM}

procedure TprTxMemoEditorForm.FormCreate(Sender: TObject);
begin
Memo:=TprTxOEMMemo.Create(Self);
with Memo do
  begin
    Align     :=alClient;
    Parent    :=PText;
    ScrollBars:=ssBoth;
  end;

RGvAlign.Items[0]:=prLoadStr(sTextAlignTop);
RGvAlign.Items[1]:=prLoadStr(sTextAlignVertCenter);
RGvAlign.Items[2]:=prLoadStr(sTextAlignBottom);

RGhAlign.Items[0]:=prLoadStr(sTextAlignLeft);
RGhAlign.Items[1]:=prLoadStr(sTextAlignHorzCenter);
RGhAlign.Items[2]:=prLoadStr(sTextAlignRight);

LoadResImage(bDBFieldName.Glyph,'OPEN');
LoadResImage(bLinesEditor.Glyph,'CHARMAP');

GetEnumNamesToStrings(TypeInfo(TTxFontStyle),integer(High(TTxFontStyle)),EDTxFontStyle.Items);
GetEnumNamesToStrings(TypeInfo(TTxFontOptions),integer(High(TTxFontOptions)),LBTxFontOptions.Items);
end;

procedure TprTxMemoEditorForm.CopySinglePropertiesFromControls;
var
  i : integer;
begin
TprTxMemoObjRecVersion(v).Memo.Clear;
for i:=0 to Memo.Lines.Count-1 do
  begin
    TprTxMemoObjRecVersion(v).Memo.Add(Memo.Lines[i]);
    prOemToWin(PChar(TprTxMemoObjRecVersion(v).Memo[i]),
               PChar(TprTxMemoObjRecVersion(v).Memo[i]));
  end;
inherited;
end;

procedure TprTxMemoEditorForm.CopyMultiplyPropertiesFromControls;
var
  i : integer;
begin
prSetProp(L,'vAlign',RGvAlign.ItemIndex,RGvAlign.ItemIndex=-1);
prSetProp(L,'hAlign',RGhAlign.ItemIndex,RGhAlign.ItemIndex=-1);

prSetProp(L,'DefaultFont',CBDefaultFont.State=cbChecked,CBDefaultFont.State=cbGrayed);
prSetProp(L,'TxFontStyle',EDTxFontStyle.ItemIndex,EDTxFontStyle.ItemIndex=-1);

for i:=integer(Low(TTxFontOptions)) to integer(High(TTxFontOptions)) do
  prSetPropSet(L,'TxFontOptions',i,LBTxFontOptions.State[i]=cbChecked,LBTxFontOptions.State[i]=cbGrayed);

prSetProp(L,'DeleteEmptyLines',CBDeleteEmptyLines.State=cbChecked,CBDeleteEmptyLines.State=cbGrayed);
prSetProp(L,'DeleteEmptyLinesAtEnd',CBDeleteEmptyLinesAtEnd.State=cbChecked,CBDeleteEmptyLinesAtEnd.State=cbGrayed);
prSetProp(L,'CanResizeX',CBCanResizeX.State=cbChecked,CBCanResizeX.State=cbGrayed);
prSetProp(L,'CanResizeY',CBCanResizeY.State=cbChecked,CBCanResizeY.State=cbGrayed);
prSetProp(L,'WordWrap',CBWordWrap.State=cbChecked,CBWordWrap.State=cbGrayed);

inherited;
end;

procedure TprTxMemoEditorForm.SetEnabledAfterCopyToControls;
begin
bDBFieldName.Enabled:=Designer.SelObjs.Count=1;
bLinesEditor.Enabled:=Designer.SelObjs.Count=1;
Memo.Enabled        :=Designer.SelObjs.Count=1;

if Designer.SelObjs.Count<>1 then
  begin
    Memo.Clear;
  end;
end;

procedure TprTxMemoEditorForm.CopySinglePropertiesToControls;
var
  s : string;
  i,l : integer;
begin
Memo.Lines.BeginUpdate;
try
  Memo.Lines.Clear;
  for i:=0 to TprTxMemoObjRecVersion(v).Memo.Count-1 do
    begin
      l:=Length(TprTxMemoObjRecVersion(v).Memo[i]);
      SetLength(s,l);
      MoveMemory(@(s[1]),@(TprTxMemoObjRecVersion(v).Memo[i][1]),l);
      prWinToOem(PChar(s),PChar(s));

      Memo.Lines.Add(s);
    end;
finally
  Memo.Lines.EndUpdate;
end;

inherited;
end;

procedure TprTxMemoEditorForm.CopyMultiplyPropertiesToControls;
var
  i : integer;
begin
RGvAlign.ItemIndex:=prGetPropDef(L,'vAlign',-1);
RGhAlign.ItemIndex:=prGetPropDef(L,'hAlign',-1);

CBDefaultFont.State := prGetPropDefBool(L,'DefaultFont');
EDTxFontStyle.ItemIndex:=prGetPropDef(L,'TxFontStyle',-1);

for i:=integer(Low(TTxFontOptions)) to integer(High(TTxFontOptions)) do
  LBTxFontOptions.State[i] :=TCheckBoxState(prGetPropDefSet(L,'TxFontOptions',i));

CBDeleteEmptyLines.State     :=prGetPropDefBool(L,'DeleteEmptyLines');
CBDeleteEmptyLinesAtEnd.State:=prGetPropDefBool(L,'DeleteEmptyLinesAtEnd');
CBCanResizeX.State           :=prGetPropDefBool(L,'CanResizeX');
CBCanResizeY.State           :=prGetPropDefBool(L,'CanResizeY');
CBWordWrap.State             :=prGetPropDefBool(L,'WordWrap');

CBDeleteEmptyLinesClick(nil);
end;

procedure TprTxMemoEditorForm.CBDeleteEmptyLinesClick(Sender: TObject);
begin
if CBDeleteEmptyLines.Checked then
  begin
    CBDeleteEmptyLinesAtEnd.Checked:=true;
    CBDeleteEmptyLinesAtEnd.Enabled:=false;
  end
else
  begin
    CBDeleteEmptyLinesAtEnd.Enabled:=true;
  end;
end;

procedure TprTxMemoEditorForm.SBDBFieldNameClick(Sender: TObject);
var
  s : string;
begin
TprFormatExpressionForm.Create(Application).SelectExpression(Designer.Report,Memo,s);
end;

procedure TprTxMemoEditorForm.bLinesEditorClick(Sender: TObject);
begin
TprTxMemoLinesEditorForm.Create(Application).EditLines(TprTxReport(Designer.Report),Memo.Lines);
end;

end.

