{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxExportParams;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons,

  pr_Common, pr_txclasses, pr_MultiLang;

type
  TprTxExportParamsForm = class(TprForm)
    Label1: TLabel;
    EDExportFileName: TEdit;
    bFileName: TSpeedButton;
    GroupBox1: TGroupBox;
    Label2: TLabel;
    RBAll: TRadioButton;
    RBPagesRange: TRadioButton;
    RBPagesList: TRadioButton;
    EDExportPages: TEdit;
    EDExportFromPage: TEdit;
    EDExportToPage: TEdit;
    RBLinesRange: TRadioButton;
    EDExportFromLine: TEdit;
    EDExportToLine: TEdit;
    Label3: TLabel;
    EDExportESCModelName: TComboBox;
    bOK: TButton;
    bCancel: TButton;
    SaveDialog: TSaveDialog;
    prMLRes1: TprMLRes;
    EDExportCodePage: TComboBox;
    Label4: TLabel;
    Label5: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure bFileNameClick(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure RBPagesRangeClick(Sender: TObject);
    procedure RBPagesListClick(Sender: TObject);
    procedure RBLinesRangeClick(Sender: TObject);
    procedure EDExportFromPageChange(Sender: TObject);
    procedure EDExportPagesChange(Sender: TObject);
    procedure EDExportFromLineChange(Sender: TObject);
  private
    { Private declarations }
    PagesCount : integer;
  public
    { Public declarations }
    Report : TprTxReport;
    function EditParams(_Report : TprTxReport) : boolean;
  end;

implementation

uses
  pr_Strings, pr_Utils, pr_TxUtils, pr_TxConsts;
  
{$R *.DFM}

procedure TprTxExportParamsForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
Action := caFree;
end;

procedure TprTxExportParamsForm.FormCreate(Sender: TObject);
var
  i : integer;
begin
LoadResImage(bFileName.Glyph,'OPEN');
SaveDialog.Filter := prLoadStr(sPreviewExportTXTFileMask);
EDExportESCModelName.Items.Add(prLoadStr(sExportNotUseESCModels));
for i:=0 to ESCModels.Count-1 do
  EDExportESCModelName.Items.Add(ESCModels[i].ModelName);
for i:=integer(Low(TprTxCodePage)) to integer(High(TprTxCodePage)) do
  EDExportCodePage.Items.Add(prLoadStr(sTxCodePageTitlesOffset-i));
end;

function TprTxExportParamsForm.EditParams;
begin
Report := _Report;
PagesCount := ParsePages(Report.TextDevice.SList,false,0,nil);

RBPagesRange.Enabled := PagesCount>1;
Label2.Enabled := PagesCount>1;
RBPagesList.Enabled := PagesCount>1;
EDExportPages.Enabled := PagesCount>1;
EDExportFromPage.Enabled := PagesCount>1;
EDExportToPage.Enabled := PagesCount>1;
EDExportFromLine.Enabled := Report.TextDevice.SList.Count>1;
EDExportToLine.Enabled := Report.TextDevice.SList.Count>1;
RBLinesRange.Enabled := Report.TextDevice.SList.Count>1;
Label5.Enabled := Report.TextDevice.SList.Count>1;

if Report.ExportFromPage>0 then
  EDExportFromPage.Text := IntToStr(Report.ExportFromPage);
if Report.ExportToPage>0 then
  EDExportToPage.Text := IntToStr(Report.ExportToPage);
if Report.ExportFromLine>0 then
  EDExportFromLine.Text := IntToStr(Report.ExportFromLine);
if Report.ExportToLine>0 then
  EDExportToLine.Text := IntToStr(Report.ExportToLine);
EDExportPages.Text := Report.ExportPages;

EDExportFileName.Text := Report.ExportFileName;
RBAll.Checked := (Report.ExportPagesMode=ppmAll) or (PagesCount=1);
RBPagesRange.Checked := (Report.ExportPagesMode=ppmPagesRange) and (PagesCount>1);
RBPagesList.Checked := (Report.ExportPagesMode=ppmPagesList) and (PagesCount>1);
RBLinesRange.Checked := (prtxeoLinesRange in Report.ExportTxOptions) and (Report.TextDevice.SList.Count>1);

EDExportCodePage.ItemIndex := integer(Report.ExportCodePage);
if (prtxeoUseESCModel in Report.ExportTxOptions) and (ESCModels.IndexByModelName(Report.ExportESCModelName)<>-1) then
  EDExportESCModelName.ItemIndex := ESCModels.IndexByModelName(Report.ExportESCModelName)+1
else
  EDExportESCModelName.ItemIndex := 0;
Result := ShowModal=mrOk;
end;

procedure TprTxExportParamsForm.bFileNameClick(Sender: TObject);
begin
SaveDialog.FileName := EDExportFileName.Text;
if SaveDialog.Execute then
  EDExportFileName.Text := SaveDialog.FileName;
end;

procedure TprTxExportParamsForm.bOKClick(Sender: TObject);
var
  pl : TList;
  FromPage,ToPage,FromLine,ToLine,valCode : integer;
begin
FromPage := 0;
ToPage := 0;
FromLine := 0;
ToLine := 0;
if Trim(EDExportFileName.Text)='' then
  begin
    ActiveControl := EDExportFileName;
    MBError(prLoadStr(sExportFileNotDefined));
    exit;
  end;
if RBPagesRange.Checked then
  begin
    val(EDExportFromPage.Text,FromPage,valCode);
    if (valCode<>0) or (FromPage<1) or (FromPage>PagesCount) then
      begin
        ActiveControl := EDExportFromPage;
        MBError(prLoadStr(sExportPagesRangeNotValid));
        exit;
      end;
    val(EDExportToPage.Text,ToPage,valCode);
    if (valCode<>0) or (ToPage<1) or (ToPage>PagesCount) then
      begin
        ActiveControl := EDExportToPage;
        MBError(prLoadStr(sExportPagesRangeNotValid));
        exit;
      end;
    if FromPage>ToPage then
      begin
        ActiveControl := EDExportFromPage;
        MBError(prLoadStr(sExportPagesRangeNotValid));
        exit;
      end
  end
else
  if RBPagesList.Checked then
    begin
      pl := TList.Create;
      try
        TextToPageList(EDExportPages.Text,pl);
        if (pl.Count<1) or (integer(pl[0])<1) or (integer(pl[0])>PagesCount) or (integer(pl[pl.Count-1])<1) or (integer(pl[pl.Count-1])>PagesCount) then
          begin
            ActiveControl := EDExportPages;
            MBError(prLoadStr(sExportPagesListNotValid));
            exit;
          end;
      finally
        pl.Free;
      end;
    end
  else
    if RBLinesRange.Checked then
      begin
        val(EDExportFromLine.Text,FromLine,valCode);
        if (valCode<>0) or (FromLine<1) or (FromLine>Report.TextDevice.SList.Count) then
          begin
            ActiveControl := EDExportFromLine;
            MBError(prLoadStr(sExportLinesRangeNotValid));
            exit;
          end;
        val(EDExportToLine.Text,ToLine,valCode);
        if (valCode<>0) or (ToLine<1) or (ToLine>Report.TextDevice.SList.Count) then
          begin
            ActiveControl := EDExportToLine;
            MBError(prLoadStr(sExportLinesRangeNotValid));
            exit;
          end;
        if FromLine>ToLine then
          begin
            ActiveControl := EDExportFromLine;
            MBError(prLoadStr(sExportLinesRangeNotValid));
            exit;
          end
      end;

Report.ExportFileName := EDExportFileName.Text;
Report.ExportTxOptions := Report.ExportTxOptions-[prtxeoLinesRange];
if RBPagesRange.Checked then
  Report.ExportPagesMode := ppmPagesRange
else
  if RBPagesList.Checked then
    Report.ExportPagesMode := ppmPagesList
  else
    if RBLinesRange.Checked then
      Report.ExportTxOptions := Report.ExportTxOptions+[prtxeoLinesRange]
    else
      Report.ExportPagesMode := ppmAll;
Report.ExportFromPage := FromPage;
Report.ExportToPage := ToPage;
Report.ExportPages := EDExportPages.Text;
Report.ExportFromLine := FromLine;
Report.ExportToLine := ToLine;
Report.ExportCodePage := TprTxCodePage(EDExportCodePage.ItemIndex);
if EDExportESCModelName.ItemIndex>0 then
  begin
    Report.ExportESCModelName := EDExportESCModelName.Items[EDExportESCModelName.ItemIndex];
    Report.ExportTxOptions := Report.ExportTxOptions+[prtxeoUseESCModel];
  end
else
  begin
    Report.ExportESCModelName := '';
    Report.ExportTxOptions := Report.ExportTxOptions-[prtxeoUseESCModel];
  end;
ModalResult := mrOk;
end;

procedure TprTxExportParamsForm.RBPagesRangeClick(Sender: TObject);
begin
ActiveControl := EDExportFromPage;
end;

procedure TprTxExportParamsForm.RBPagesListClick(Sender: TObject);
begin
ActiveControl := EDExportPages;
end;

procedure TprTxExportParamsForm.RBLinesRangeClick(Sender: TObject);
begin
ActiveControl := EDExportFromLine;
end;

procedure TprTxExportParamsForm.EDExportFromPageChange(Sender: TObject);
begin
RBPagesRange.Checked := true;
end;

procedure TprTxExportParamsForm.EDExportPagesChange(Sender: TObject);
begin
RBPagesList.Checked := true;
end;

procedure TprTxExportParamsForm.EDExportFromLineChange(Sender: TObject);
begin
RBLinesRange.Checked := true;
end;

end.
