{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxDesigner;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ActnList, Menus, ExtCtrls,
  TypInfo, Pr_Utils, ClipBrd, IniFiles, ComCtrls, 
  StdCtrls, Grids, ToolWin,

  pr_Common, pr_CommonDesigner, pr_TxClasses, pr_TxConsts, pr_MultiLang;

type
  TprTxDPanel = class;

  TprTxDesignerForm = class(TprCustomDesignerForm)
    SB: TStatusBar;
    ActionList: TActionList;
    aNew: TAction;                  
    aOpen: TAction;
    aSave: TAction;
    aSaveAs: TAction;
    aQuit: TAction;
    aGroups: TAction;
    aFunc: TAction;
    aDelete: TAction;
    aPreview: TAction;
    aPrint: TAction;
    aPageParams: TAction;
    aReportParams: TAction;
    aCopy: TAction;
    aPaste: TAction;
    aCut: TAction;
    aNewPage: TAction;
    aDelPage: TAction;
    aNextPage: TAction;
    aPriorPage: TAction;
    aObjLinks: TAction;
    aBandLinks: TAction;
    aSendToBack: TAction;
    aBringToFront: TAction;
    aProperties: TAction;
    aInplaceEdit: TAction;
    MainMenu: TMainMenu;
    N1: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N19: TMenuItem;
    N20: TMenuItem;
    N21: TMenuItem;
    N16: TMenuItem;
    N17: TMenuItem;
    N18: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    N2: TMenuItem;
    N22: TMenuItem;
    N23: TMenuItem;
    N24: TMenuItem;
    N25: TMenuItem;
    N12: TMenuItem;
    N37: TMenuItem;
    N38: TMenuItem;
    N39: TMenuItem;
    N11: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    N26: TMenuItem;
    N35: TMenuItem;
    N36: TMenuItem;
    N46: TMenuItem;
    N47: TMenuItem;
    N48: TMenuItem;
    N34: TMenuItem;
    N27: TMenuItem;
    N28: TMenuItem;
    N29: TMenuItem;
    N30: TMenuItem;
    N32: TMenuItem;
    N31: TMenuItem;
    ImageList: TImageList;
    AlignActionList: TActionList;
    aHToLeft: TAction;
    aHCenterInWindow: TAction;
    aHCenters: TAction;
    aHSpaceEqually: TAction;
    aHToRight: TAction;
    aVToTop: TAction;
    aVCenterInWindow: TAction;
    aVCenters: TAction;
    aVSpaceEqually: TAction;
    aVToBottom: TAction;
    aOLeft: TAction;
    aORight: TAction;
    aOTop: TAction;
    aOBottom: TAction;
    aSLeft: TAction;
    aSRight: TAction;
    aSTop: TAction;
    aSBottom: TAction;
    aWToSmall: TAction;
    aWToLarge: TAction;
    aHToSmall: TAction;
    aHToLarge: TAction;
    PMInsertBand: TPopupMenu;
    PMFontOptions: TPopupMenu;
    ControlBar1: TControlBar;
    tbFile: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    tbObject: TToolBar;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    tbObjects: TToolBar;
    bInsertBand: TToolButton;
    ToolButton18: TToolButton;
    bObjArrow: TToolButton;
    tbText: TToolBar;
    EDFontStyle: TComboBox;
    bFontOptions: TToolButton;
    ToolButton17: TToolButton;
    bHLeft: TToolButton;
    bHCenter: TToolButton;
    bHRight: TToolButton;
    ToolButton22: TToolButton;
    bVTop: TToolButton;
    bVCenter: TToolButton;
    bVBottom: TToolButton;
    tbAlign: TToolBar;
    ToolButton26: TToolButton;
    ToolButton27: TToolButton;
    ToolButton28: TToolButton;
    ToolButton29: TToolButton;
    ToolButton30: TToolButton;
    ToolButton31: TToolButton;
    ToolButton32: TToolButton;
    ToolButton33: TToolButton;
    ToolButton34: TToolButton;
    ToolButton35: TToolButton;
    ToolButton36: TToolButton;
    tbSize: TToolBar;
    ToolButton37: TToolButton;
    ToolButton38: TToolButton;
    ToolButton39: TToolButton;
    ToolButton40: TToolButton;
    ToolButton41: TToolButton;
    ToolButton42: TToolButton;
    ToolButton43: TToolButton;
    ToolButton44: TToolButton;
    ToolButton45: TToolButton;
    tbNudge: TToolBar;
    ToolButton46: TToolButton;
    ToolButton47: TToolButton;
    ToolButton48: TToolButton;
    ToolButton49: TToolButton;
    PMDPanel: TPopupMenu;
    N40: TMenuItem;
    N41: TMenuItem;
    N42: TMenuItem;
    N52: TMenuItem;
    N45: TMenuItem;
    N44: TMenuItem;
    N49: TMenuItem;
    N50: TMenuItem;
    N51: TMenuItem;
    prMLRes1: TprMLRes;
    N13: TMenuItem;
    N14: TMenuItem;
    mtbFile: TMenuItem;
    mtbObject: TMenuItem;
    mtbObjects: TMenuItem;
    mtbText: TMenuItem;
    mtbAlign: TMenuItem;
    mtbSize: TMenuItem;
    mtbNudge: TMenuItem;
    aPosSize: TAction;
    N15: TMenuItem;
    ToolButton16: TToolButton;
    N33: TMenuItem;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormCreate(Sender: TObject);
    procedure aNewExecute(Sender: TObject);
    procedure aQuitExecute(Sender: TObject);
    procedure aOpenExecute(Sender: TObject);
    procedure aSaveExecute(Sender: TObject);
    procedure aSaveAsExecute(Sender: TObject);
    procedure aGroupsExecute(Sender: TObject);
    procedure aFuncExecute(Sender: TObject);
    procedure aDeleteUpdate(Sender: TObject);
    procedure aDeleteExecute(Sender: TObject);
    procedure aPreviewExecute(Sender: TObject);
    procedure aPrintExecute(Sender: TObject);
    procedure aPageParamsExecute(Sender: TObject);
    procedure aReportParamsExecute(Sender: TObject);
    procedure aCopyUpdate(Sender: TObject);
    procedure aCopyExecute(Sender: TObject);
    procedure aPasteUpdate(Sender: TObject);
    procedure aPasteExecute(Sender: TObject);
    procedure aCutExecute(Sender: TObject);
    procedure aNewPageExecute(Sender: TObject);
    procedure aDelPageUpdate(Sender: TObject);
    procedure aDelPageExecute(Sender: TObject);
    procedure aNextPageUpdate(Sender: TObject);
    procedure aNextPageExecute(Sender: TObject);
    procedure aPriorPageUpdate(Sender: TObject);
    procedure aPriorPageExecute(Sender: TObject);
    procedure aObjLinksUpdate(Sender: TObject);
    procedure aObjLinksExecute(Sender: TObject);
    procedure aBandLinksUpdate(Sender: TObject);
    procedure aBandLinksExecute(Sender: TObject);
    procedure aSendToBackUpdate(Sender: TObject);
    procedure aSendToBackExecute(Sender: TObject);
    procedure aBringToFrontExecute(Sender: TObject);
    procedure aPropertiesUpdate(Sender: TObject);
    procedure aPropertiesExecute(Sender: TObject);
    procedure aHToLeftUpdate(Sender: TObject);
    procedure aHCenterInWindowUpdate(Sender: TObject);
    procedure aHSpaceEquallyUpdate(Sender: TObject);
    procedure aOLeftExecute(Sender: TObject);
    procedure aORightExecute(Sender: TObject);
    procedure aOTopExecute(Sender: TObject);
    procedure aOBottomExecute(Sender: TObject);
    procedure aSLeftUpdate(Sender: TObject);
    procedure aSTopUpdate(Sender: TObject);
    procedure aSLeftExecute(Sender: TObject);
    procedure aSRightExecute(Sender: TObject);
    procedure aSTopExecute(Sender: TObject);
    procedure aSBottomExecute(Sender: TObject);
    procedure bHLeftClick(Sender: TObject);
    procedure bVTopClick(Sender: TObject);
    procedure SBDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
    procedure EDFontStyleClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure aInplaceEditUpdate(Sender: TObject);
    procedure aInplaceEditExecute(Sender: TObject);
    procedure aCommonAction(Sender: TObject);
    procedure mtbNudgeClick(Sender: TObject);
    procedure aPosSizeExecute(Sender: TObject);
    procedure aPosSizeUpdate(Sender: TObject);
    procedure aSaveUpdate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure aHToLeftExecute(Sender: TObject);
  private
    { Private declarations }
    FSelectedTopLeft : TBitmap;
    FSelectedSizes   : TBitmap;
    FMouse           : TBitmap;
  protected
    fUpdated : boolean;
    OldOnMouseMove : TMouseMoveEvent;

    procedure prRestoreProperties(Ini : TIniFile; sn : string); override;
    procedure prSaveProperties(Ini : TIniFile; sn : string); override;

    function  CreateDPanel : TprCustomDPanel; override;
    function  CreatePage : TprCustomPage; override;

    procedure InitInternalPropsForms; override;

    procedure OnDPanelMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);

    procedure OnObjInserted(Obj : TprObj); override;
    procedure mSubScriptClick(Sender: TObject);
  public
    { Public declarations }
    function  UseGrid : boolean; override;
    function  ShowGrid : boolean; override;
    function  GridSizeX : integer; override;
    function  GridSizeY : integer; override;

    procedure ConvertToDesignerCoords(const rSource : TRect; var rDest : TRect); override;
    function  ConvertXToDesignerCoords(X : integer) : integer; override;
    function  ConvertYToDesignerCoords(Y : integer) : integer; override;
    procedure ConvertFromDesignerCoords(const rSource : TRect; var rDest : TRect); override;
    function  ConvertXFromDesignerCoords(X : integer) : integer; override;
    function  ConvertYFromDesignerCoords(Y : integer) : integer; override;

    procedure ShowPage(PageIndex : integer); override;

    procedure UpdateStatusBar; override;
    procedure UpdateSelectedRegionSizes(r : TRect; fEmpty : boolean); override;
    procedure UpdateTextActions; override;

    constructor CreateDesigner(AOwner : TComponent; _Report : TprCustomReport); override;
  end;

  TprTxDPanel = class(TprCustomDPanel)
  private
    procedure UpdateFont;
  protected
    function  GetExData : pointer; override;
  public
    TxExData : rTxExData;

    procedure InplaceEditObj(pdi : pDesignInfo); override;
    procedure EndInplaceEdit; override;
    procedure SaveInplaceEdit; override;

    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  end;

implementation

uses pr_Strings, pr_DesignerFunctions, pr_TxMemoEditor, pr_GroupsEditor,
  pr_ValuesEditor, pr_TxPageParams, pr_TxReportParams, pr_TxObjectPosSizeForm,
  pr_BandEditor;

{$R *.DFM}

///////////////////////////
//
// TprTxDPanel
//
///////////////////////////
constructor TprTxDPanel.Create;
begin
inherited;
Color  :=clWindow;
end;

destructor TprTxDPanel.Destroy;
begin
inherited;
end;

procedure TprTxDPanel.UpdateFont;
var
  fn : HFONT;
  DC1,DC2 : HDC;
  LogFont : TLogFont;
begin
DC1:=GetDC(0);
DC2:=CreateCompatibleDC(DC1);
ZeroMemory(@LogFont,sizeof(LogFont));
with LogFont do
  begin
    lfHeight        :=-MulDiv(TxExData.FontSize, GetDeviceCaps(DC2, LOGPIXELSY), 72);
    lfWeight        :=FW_NORMAL;
    lfOutPrecision  :=OUT_DEFAULT_PRECIS;
    lfClipPrecision :=CLIP_DEFAULT_PRECIS;
    lfQuality       :=DEFAULT_QUALITY;
    lfPitchAndFamily:=DEFAULT_PITCH;
    lfCharSet       :=OEM_CHARSET;
    StrPCopy(lfFaceName,TxExData.FontName);
  end;
fn:=CreateFontIndirect(LogFont);
SelectObject(DC2,fn);
GetTextExtentPoint32(DC2,'1',1,TxExData.SymbolSize);
DeleteObject(fn);
ReleaseDC(0,DC1);
DeleteDC(DC2);

Width :=TxExData.SymbolSize.cx*TprTxPage(Designer.CurPage).ColNum;
Height:=TxExData.SymbolSize.cy*TprTxPage(Designer.CurPage).LineNum;

DesignerGridSizeChanged;
UpdateObjectsPDI;
end;

function TprTxDPanel.GetExData;
begin
Result:=@TxExData;
end;

procedure TprTxDPanel.SaveInplaceEdit;
begin
if FInplaceEditedObj<>nil then
  begin
    TprTxMemoObj(FInplaceEditedObj).SaveInplaceEdit(FInplaceEditor);
    EndInplaceEdit;
    Report.TemplateChanged:=true;
  end;
end;

procedure TprTxDPanel.EndInplaceEdit;
  procedure EnableToolbar(tb : TToolbar);
  var
    i : integer;
  begin
  for i:=0 to tb.ControlCount-1 do
    tb.Controls[i].Enabled:=true;
  end;
begin
EnableToolbar(TprTxDesignerForm(Designer).tbObjects);
EnableToolbar(TprTxDesignerForm(Designer).tbText);
inherited;
end;

procedure TprTxDPanel.InplaceEditObj;

  procedure DisableToolbar(tb : TToolbar);
  var
    i : integer;
  begin
  for i:=0 to tb.ControlCount-1 do
    tb.Controls[i].Enabled:=false;
  end;

begin
DisableToolbar(TprTxDesignerForm(Designer).tbObjects);
DisableToolbar(TprTxDesignerForm(Designer).tbText);

FInplaceEditedObj:=pdi.Parent;
TprObj(FInplaceEditedObj).InplaceEdit(Self,FInplaceEditor);
end;

///////////////////////////
//
// TprTxDesignerForm
//
///////////////////////////
constructor TprTxDesignerForm.CreateDesigner;
begin
inherited;
end;

procedure TprTxDesignerForm.InitInternalPropsForms;
var
  i : TprBandType;
begin
SetLength(prInternalPropsForms,integer(High(TprBandType))+1);

for i:=Low(TprBandType) to High(TprBandType) do
  begin
    prInternalPropsForms[integer(i)].ClassName          :=Report.GetBandClass(i).ClassName;
    prInternalPropsForms[integer(i)].PropsFormClassName :='TprBandEditorForm';
  end;
end;

procedure TprTxDesignerForm.prRestoreProperties;
begin
inherited;
TprTxDPanel(FDPanel).UpdateFont;
mtbFile.Checked   :=ini.ReadBool(sn,'tbFile',tbFile.Visible);
mtbObject.Checked :=ini.ReadBool(sn,'tbObject',tbObject.Visible);
mtbObjects.Checked:=ini.ReadBool(sn,'tbObjects',tbObjects.Visible);
mtbText.Checked   :=ini.ReadBool(sn,'tbText',tbText.Visible);
mtbAlign.Checked  :=ini.ReadBool(sn,'tbAlign',tbAlign.Visible);
mtbSize.Checked   :=ini.ReadBool(sn,'tbSize',tbSize.Visible);
mtbNudge.Checked  :=ini.ReadBool(sn,'tbNudge',tbNudge.Visible);

tbFile.Visible   :=mtbFile.Checked;
tbObject.Visible :=mtbObject.Checked;
tbObjects.Visible:=mtbObjects.Checked;
tbText.Visible   :=mtbText.Checked;
tbAlign.Visible  :=mtbAlign.Checked;
tbSize.Visible   :=mtbSize.Checked;
tbNudge.Visible  :=mtbNudge.Checked;
end;

procedure TprTxDesignerForm.prSaveProperties;
begin
inherited;
ini.WriteBool(sn,'tbFile',tbFile.Visible);
ini.WriteBool(sn,'tbObject',tbObject.Visible);
ini.WriteBool(sn,'tbObjects',tbObjects.Visible);
ini.WriteBool(sn,'tbText',tbText.Visible);
ini.WriteBool(sn,'tbAlign',tbAlign.Visible);
ini.WriteBool(sn,'tbSize',tbSize.Visible);
ini.WriteBool(sn,'tbNudge',tbNudge.Visible);
end;

function TprTxDesignerForm.ShowGrid;
begin
Result:=true;
end;

function TprTxDesignerForm.UseGrid;
begin
Result:=true;
end;

function TprTxDesignerForm.GridSizeX;
begin
Result:=TprTxDPanel(FDPanel).TxExData.SymbolSize.cx;
end;

function TprTxDesignerForm.GridSizeY;
begin
Result:=TprTxDPanel(FDPanel).TxExData.SymbolSize.cy;
end;

procedure TprTxDesignerForm.ConvertToDesignerCoords;
begin
rDest:=MulRect(rSource,GridSizeX,GridSizeY);
end;

function  TprTxDesignerForm.ConvertXToDesignerCoords;
begin
Result:=X*GridSizeX;
end;

function  TprTxDesignerForm.ConvertYToDesignerCoords;
begin
Result:=Y*GridSizeY;
end;

procedure TprTxDesignerForm.ConvertFromDesignerCoords;
begin
rDest:=DivRect(rSource,GridSizeX,GridSizeY);
end;

function  TprTxDesignerForm.ConvertXFromDesignerCoords;
begin
Result:=X div GridSizeX;
end;

function  TprTxDesignerForm.ConvertYFromDesignerCoords;
begin
Result:=Y div GridSizeY;
end;

function TprTxDesignerForm.CreateDPanel;
begin
Result:=TprTxDPanel.Create(Self);
end;

function TprTxDesignerForm.CreatePage;
begin
Result:=TprTxPage.Create(Report.prOwner);
end;

procedure TprTxDesignerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
FDPanel.EndInplaceEdit;
Action:=caFree;
end;

procedure TprTxDesignerForm.FormCreate(Sender: TObject);
var
  i : integer;
  m : TMenuItem;

  procedure LoadBitmap(var bmp : TBitmap; ResID : string);
  begin
  bmp:=TBitmap.Create;
  try
    bmp.LoadFromResourceName(hInstance,'PR_'+ResID);
  except
  end;
  bmp.TransparentMode:=tmAuto;
  bmp.Transparent:=true;
  end;

begin
prLoadResImages(Self,ImageList);
InitprObjToolbar(Report,Self,tbObjects,OnObjButtonClick);
InitBandsMenu(Self,PMInsertBand,OnInsertBandClick);
// init font styles menu
for i:=integer(Low(TTxFontOptions)) to integer(High(TTxFontOptions)) do
  begin
    m := TMenuItem.Create(Self);
    m.Caption := GetEnumName(TypeInfo(TTxFontOptions),i);
    m.OnClick := mSubScriptClick;
    m.Tag := i;
    PMFontOptions.Items.Add(m);
  end;

LoadBitmap(FSelectedTopLeft,'SELECTEDTOPLEFT');
LoadBitmap(FSelectedSizes,'SELECTEDSIZES');
LoadBitmap(FMouse,'MOUSE');

GetEnumNamesToStrings(TypeInfo(TTxFontStyle),integer(High(TTxFontStyle)),EDFontStyle.Items);

TprTxDPanel(FDPanel).TxExData.FontName:='Courier New';
TprTxDPanel(FDPanel).TxExData.FontSize:=14;

FDPanel.PopupMenu  :=PMDPanel;
OldOnMouseMove     :=FDPanel.OnMouseMove;
FDPanel.OnMouseMove:=OnDPanelMouseMove;

bObjArrow.OnClick:=OnObjButtonClick;

PosSizeForm := TprTxObjectPosSizeForm.CreatePosSizeForm(Self,Self);
UpdatePosSizeForm;

ShowPage(IndexCurPage);
end;

procedure TprTxDesignerForm.ShowPage;
begin
TprTxDPanel(FDPanel).UpdateFont;
inherited;
end;

procedure TprTxDesignerForm.OnObjInserted;
begin
TprTxMemoObjRecVersion(Obj.dRec.Versions[0]).TxFontStyle  :=TprTxPage(CurPage).DefTxFontStyle;
TprTxMemoObjRecVersion(Obj.dRec.Versions[0]).TxFontOptions:=TprTxPage(CurPage).DefTxFontOptions;
end;

procedure TprTxDesignerForm.UpdateStatusBar;
begin
SB.Panels[0].Text:=Format(prLoadStr(sPageNumber),[IndexCurPage+1,Report.PagesCount]);
end;

procedure TprTxDesignerForm.UpdateSelectedRegionSizes;
begin
if fEmpty then
  begin
    SB.Panels[1].Text:='';
    SB.Panels[2].Text:='';
  end
else
  begin
    ConvertFromDesignerCoords(r,r);
    SB.Panels[1].Text:=Format('%d,%d',[r.Left,
                                       r.Top]);
    SB.Panels[2].Text:=Format('%d,%d',[r.Right-r.Left,
                                       r.Bottom-r.Top]);
  end;
case SelCount of
  0 : SB.Panels[4].Text := prLoadStr(sNoObjectsSelected);
  1 : if TObject(SelObjs[0]) is TComponent then
        SB.Panels[4].Text := Format('%s : %s',[TComponent(SelObjs[0]).Name,TComponent(SelObjs[0]).ClassName])
      else
        SB.Panels[4].Text := TObject(SelObjs[0]).ClassName;
  else SB.Panels[4].Text := Format(prLoadStr(sSelectedMoreThenOneObject),[SelCount]);
end;
end;

procedure TprTxDesignerForm.UpdateTextActions;
var
  i : integer;
  fEnabled : boolean;
  L : TList;
  cs : TCardinalSet;
begin
fUpdated:=true;
//       TpeMemoObj
i:=0;
while (i<SelObjs.Count) and (not (TObject(SelObjs[i]) is TprTxMemoObj)) do Inc(i);
fEnabled:=i<SelObjs.Count;

for i:=0 to tbText.ControlCount-1 do
  tbText.Controls[i].Enabled:=fEnabled;



if fEnabled then
  begin
    L:=TList.Create;
    try
      MakedRecDefVersionList(SelObjs,L);

      // now - update buttons
      EDFontStyle.ItemIndex:=prGetPropDef(L,'TxFontStyle',-1);

      cs:=(TCardinalSet(cardinal(prGetPropDef(L,'TxFontOptions',0))));
      for i:=0 to PMFontOptions.Items.Count-1 do
        PMFontOptions.Items[i].Checked := PMFontOptions.Items[i].Tag in cs;

      case TprHAlign(prGetPropDef(L,'hAlign',-1)) of
        prhLeft  : bHLeft.Down  :=true;
        prhCenter: bHCenter.Down:=true;
        prhRight : bHRight.Down :=true;
        else
          begin
            bHLeft.Down  :=false;
            bHCenter.Down:=false;
            bHRight.Down :=false;
          end;
      end;

      case TprVAlign(prGetPropDef(L,'vAlign',-1)) of
        prvTop   : bVTop.Down  :=true;
        prvCenter: bVCenter.Down:=true;
        prvBottom: bVBottom.Down :=true;
        else
          begin
            bVTop.Down   :=false;
            bVCenter.Down:=false;
            bVBottom.Down:=false;
          end;
      end;

    finally
      L.Free;
    end;
  end;
fUpdated:=false;
end;


procedure TprTxDesignerForm.aNewExecute(Sender: TObject);
begin
New;
end;

procedure TprTxDesignerForm.aQuitExecute(Sender: TObject);
begin
Close;
end;

procedure TprTxDesignerForm.aOpenExecute(Sender: TObject);
begin
Open;
end;

procedure TprTxDesignerForm.aSaveExecute(Sender: TObject);
begin
Save;
end;

procedure TprTxDesignerForm.aSaveAsExecute(Sender: TObject);
begin
SaveAs;
end;

procedure TprTxDesignerForm.aGroupsExecute(Sender: TObject);
begin
TprGroupsEditorForm.Create(Application).EditGroups(Report);
UpdateCurrentPage;
end;

procedure TprTxDesignerForm.aFuncExecute(Sender: TObject);
begin
TprValuesEditorForm.Create(Application).EditValues(Report);
end;

procedure TprTxDesignerForm.aDeleteUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowDelete;
end;

procedure TprTxDesignerForm.aDeleteExecute(Sender: TObject);
begin
FDPanel.DeleteSelectedObjects;
end;

procedure TprTxDesignerForm.aPreviewExecute(Sender: TObject);
begin
if Report.PrepareReport then
  Report.PreviewPreparedReport(true);
end;

procedure TprTxDesignerForm.aPrintExecute(Sender: TObject);
begin
Print;
end;

procedure TprTxDesignerForm.aPageParamsExecute(Sender: TObject);
begin
if TprTxPageParamsForm.Create(Application).EditOptions(TprTxPage(Report.Pages[IndexCurPage])) then
  begin
    UpdateCurrentPage;
    Report.TemplateChanged:=true;
  end;
end;

procedure TprTxDesignerForm.aReportParamsExecute(Sender: TObject);
begin
if TprTxReportParamsForm.Create(Application).EditParams(TprTxReport(Report)) then
  begin
    UpdateCurrentPage;
    Report.TemplateChanged:=true;
  end;
end;

procedure TprTxDesignerForm.aCopyUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowCopy;
end;

procedure TprTxDesignerForm.aCopyExecute(Sender: TObject);
begin
FDPanel.Copy;
end;

procedure TprTxDesignerForm.aPasteUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowPaste;
end;

procedure TprTxDesignerForm.aPasteExecute(Sender: TObject);
begin
FDPanel.Paste;
end;

procedure TprTxDesignerForm.aCutExecute(Sender: TObject);
begin
FDPanel.Cut;
end;

procedure TprTxDesignerForm.aNewPageExecute(Sender: TObject);
begin
NewPage;
end;

procedure TprTxDesignerForm.aDelPageUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (Report.PagesCount>1);
end;

procedure TprTxDesignerForm.aDelPageExecute(Sender: TObject);
begin
DelPage;
end;

procedure TprTxDesignerForm.aNextPageUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (IndexCurPage<Report.PagesCount-1);
end;

procedure TprTxDesignerForm.aNextPageExecute(Sender: TObject);
begin
NextPage;
end;

procedure TprTxDesignerForm.aPriorPageUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (IndexCurPage>0);
end;

procedure TprTxDesignerForm.aPriorPageExecute(Sender: TObject);
begin
PriorPage;
end;

procedure TprTxDesignerForm.aObjLinksUpdate(Sender: TObject);
begin
TAction(Sender).Checked:=ObjLinksForm.Visible;
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprTxDesignerForm.aObjLinksExecute(Sender: TObject);
begin
ObjLinksForm.Visible:=not ObjLinksForm.Visible;
end;

procedure TprTxDesignerForm.aBandLinksUpdate(Sender: TObject);
begin
TAction(Sender).Checked:=BandLinksForm.Visible;
TACtion(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprTxDesignerForm.aBandLinksExecute(Sender: TObject);
begin
BandLinksForm.Visible:=not BandLinksForm.Visible;
end;

procedure TprTxDesignerForm.aSendToBackUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.IsAnyTprObjSelected;
end;

procedure TprTxDesignerForm.aSendToBackExecute(Sender: TObject);
begin
FDPanel.SendToBack;
end;

procedure TprTxDesignerForm.aBringToFrontExecute(Sender: TObject);
begin
FDPanel.BringToFront;
end;

procedure TprTxDesignerForm.aPropertiesUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
TAction(Sender).Checked:=ObjectsPropsForm.Visible;
end;

procedure TprTxDesignerForm.aPropertiesExecute(Sender: TObject);
begin
ObjectsPropsForm.Visible:=not ObjectsPropsForm.Visible;
end;

procedure TprTxDesignerForm.aHToLeftUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (FDPanel.GetNumDragSelectedRegions>=2);
end;

procedure TprTxDesignerForm.aHCenterInWindowUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (FDPanel.GetNumDragSelectedRegions>=1);
end;

procedure TprTxDesignerForm.aHSpaceEquallyUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (FDPanel.GetNumDragSelectedRegions>=3);
end;

procedure TprTxDesignerForm.aOLeftExecute(Sender: TObject);
begin
FDPanel.Nudge(-1,0);
end;

procedure TprTxDesignerForm.aORightExecute(Sender: TObject);
begin
FDPanel.Nudge(1,0);
end;

procedure TprTxDesignerForm.aOTopExecute(Sender: TObject);
begin
FDPanel.Nudge(0,-1);
end;

procedure TprTxDesignerForm.aOBottomExecute(Sender: TObject);
begin
FDPanel.Nudge(0,1);
end;

procedure TprTxDesignerForm.aSLeftUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowSizeLeftRight;
end;

procedure TprTxDesignerForm.aSTopUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowSizeTopBottom;
end;

procedure TprTxDesignerForm.aSLeftExecute(Sender: TObject);
begin
FDPanel.Size(-GridSizeX,0);
end;

procedure TprTxDesignerForm.aSRightExecute(Sender: TObject);
begin
FDPanel.Size(GridSizeY,0);
end;

procedure TprTxDesignerForm.aSTopExecute(Sender: TObject);
begin
FDPanel.Size(0,GridSizeY);
end;

procedure TprTxDesignerForm.aSBottomExecute(Sender: TObject);
begin
FDPanel.Size(0,-GridSizeY);
end;

procedure TprTxDesignerForm.bHLeftClick(Sender: TObject);
var
  i : integer;
  a : TprHAlign;
begin
if fUpdated then exit;

if bHLeft.Down then
  a:=prhLeft
else
  if bHCenter.Down then
    a:=prhCenter
  else
    if bHRight.Down then
      a:=prhRight
    else
      exit;

for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprTxMemoObj then
    begin
      TprTxMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).hAlign:=a;
      Report.TemplateChanged:=true;
    end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprTxDesignerForm.bVTopClick(Sender: TObject);
var
  i : integer;
  a : TprVAlign;
begin
if fUpdated then exit;

if bVTop.Down then
  a:=prvTop
else
  if bVCenter.Down then
    a:=prvCenter
  else
    if bVBottom.Down then
      a:=prvBottom
    else
      exit;

for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprTxMemoObj then
    begin
      TprTxMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).vAlign:=a;
      Report.TemplateChanged:=true;
    end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprTxDesignerForm.OnDPanelMouseMove;
begin
OldOnMouseMove(Sender,Shift,X,Y);
SB.Panels[3].Text:=Format('%d,%d',[ConvertXFromDesignerCoords(X),ConvertYFromDesignerCoords(Y)]);
end;

procedure TprTxDesignerForm.SBDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
var
  b : TBitmap;
begin
if Panel.Index in [1,2,3] then
  begin
    b:=nil;
    case Panel.Index of
      1: b:=FSelectedTopLeft;
      2: b:=FSelectedSizes;
      3: b:=FMouse;
    end;

    SB.Canvas.FillRect(Rect);
    StatusBar.Canvas.Draw(Rect.Left+1,Rect.Top+1,b);
    SB.Canvas.TextOut(Rect.Left+2+ImageList.Width,Rect.Top+2,Panel.Text);
  end
end;

procedure TprTxDesignerForm.EDFontStyleClick(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;

for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprTxMemoObj then
    begin
      with TprTxMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]) do
        TxFontStyle:=TTxFontStyle(EDFontStyle.ItemIndex);
      Report.TemplateChanged:=true;
    end;

FDPanel.RepaintSelectedObjects;
end;

procedure TprTxDesignerForm.mSubScriptClick(Sender: TObject);
var
  i : integer;
  fo : TTxFontOptionsSet;
begin
if fUpdated then exit;

for i:=0 to FDPanel.SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprTxMemoObj then
    with TprTxMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]) do
      begin
        fo := TxFontOptions;
        if TMenuItem(Sender).Checked then
          //  
          Exclude(fo,TTxFontOptions(TMenuItem(Sender).Tag))
        else
          //  
          Include(fo,TTxFontOptions(TMenuItem(Sender).Tag));
        TxFontOptions := fo;
        Report.TemplateChanged := true;
      end;
TMenuItem(Sender).Checked := not TMenuItem(Sender).Checked;

FDPanel.RepaintSelectedObjects;
end;

procedure TprTxDesignerForm.FormDestroy(Sender: TObject);
begin
FSelectedTopLeft.Free;
FSelectedSizes.Free;
FMouse.Free;
end;

procedure TprTxDesignerForm.aInplaceEditUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and
                         (SelObjs.Count>0) and
                         (TObject(SelObjs[0]) is TprObj) and
                         (TprObj(SelObjs[0]).AllowInplaceEdit);
end;

procedure TprTxDesignerForm.aInplaceEditExecute(Sender: TObject);
begin
FDPanel.InplaceEditObj(SelPDI[0]);
end;

procedure TprTxDesignerForm.aCommonAction(Sender: TObject);
begin
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprTxDesignerForm.mtbNudgeClick(Sender: TObject);
begin
with TMenuItem(Sender) do
  begin
    Checked:=not Checked;
    TToolBar(Self.FindComponent(Copy(Name,2,Length(Name)-1))).Visible:=Checked;
  end;
end;

procedure TprTxDesignerForm.aPosSizeExecute(Sender: TObject);
begin
PosSizeForm.Visible:=not PosSizeForm.Visible;
end;

procedure TprTxDesignerForm.aPosSizeUpdate(Sender: TObject);
begin
TAction(Sender).Checked:=PosSizeForm.Visible;
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprTxDesignerForm.aSaveUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=Report.TemplateChanged and (FDPanel.FInplaceEditor=nil);
end;

procedure TprTxDesignerForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
CanClose:=true;
if not (csDesigning in Report.ComponentState) and Report.TemplateChanged then
  begin
    case MBox(prLoadStr(sTemplaceSaveQuestion),prLoadStr(sAttention),MB_YESNOCANCEL+MB_ICONQUESTION) of
      IDYES   : aSave.Execute;
      IDNO    : ;
      IDCANCEL: CanClose:=false;
    end;
  end
end;

procedure TprTxDesignerForm.aHToLeftExecute(Sender: TObject);
begin
FDPanel.AlignAction(TprAlignActionCode(GetEnumValue(TypeInfo(TprAlignActionCode),'aac'+Copy(TAction(Sender).Name,2,Length(TAction(Sender).Name)))));
end;

initialization

RegisterClass(TprTxMemoEditorForm);
RegisterClass(TprBandEditorForm);
RegisterClass(TprTxDesignerForm);

end.

