{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxConsts;

interface

uses
  SysUtils, Classes, Graphics, typinfo, windows;

const
  _sESCModelsFileName = 'ESCModel.ini';

type
  TprTxPaperType = (ptPage,ptRulon);
  TprTxPrintRulonMode = (prmAllLines,prmLinesRange);
  TTxFontStyle = (tfsNormal,tfsPica,tfsElite);
  TTxFontOptions = (tfoCondenced,tfoBold,tfoItalic,tfoUnderline,tfoSuperScript,tfoSubscript,tfoWide,tfo12cpi);
  TTxFontOptionsSet = set of TTxFontOptions;

  TprESCCode = (ecReset,
                ecFormFeed,
                ecNormal,
                ecPica,
                ecElite,
                ecCondensedOn,
                ecCondensedOff,
                ecBoldOn,
                ecBoldOff,
                ecItalicOn,
                ecItalicOff,
                ecUnderlineOn,
                ecUnderlineOff,
                ecSuperScriptOn,
                ecSuperScriptOff,
                ecSubScriptOn,
                ecSubScriptOff,
                ecWideOn,
                ecWideOff,
                ec12cpiOn,
                ec12cpiOff);
  TprESCFontChangeType = (escNone,escChange,escPushChange,escPop,escSpecial);

  TprESCSpecifiers = array[TprESCCode] of Char;

  rESCFontChange = record
    ESCType : TprESCFontChangeType;
    Styles : TFontStyles;
    Color : TColor;
  end;
  PESCFontChange = ^rESCFontChange;

  TprESC = string[32];
  TprESCs = array[TprESCCode] of TprESC;

  ///////////////////////////
  //
  // TprESCModel
  //
  ///////////////////////////
  TprESCModel = class(TPersistent)
  private
    FModelName : string;
    FPrinterDriver : string;
    function GetValue(Index: TprESCCode): string;
    procedure SetValue(Index: TprESCCode; const Value: string);
  public
    ESCs : TprESCs;
    property ModelName : string read FModelName write FModelName;
    property PrinterDriver : string read FPrinterDriver write FPrinterDriver;
    property Style[index : TprESCCode] : string read GetValue write SetValue;
  end;

  ///////////////////////////
  //
  // TprESCModels
  //
  ///////////////////////////
  TprESCModels = class(TList)
  private
    function GetItm(Index : integer) : TprESCModel;
    function GetByModelName(ModelName : string) : TprESCModel;
  public
    property Items[Index : integer] : TprESCModel read GetItm; default;
    property ByModelName[ModelName : string] : TprESCModel read GetByModelName;
    function FindByDriverName(DriverName : string) : TprESCModel;
    function IndexByModelName(ModelName : string) : integer;
    procedure LoadFromFile(FileName : string);
  end;

const
  ESCSymbol=#27;

var
  ESCSpecifiers : TprESCSpecifiers =
  ('@',{ecReset}
   '=',{ecFormFeed}
   'D',{ecNormal}
   'P',{ecPica}
   'E',{ecElite}
   'C',{ecCondensedOn}
   'c',{ecCondensedOff}
   'B',{ecBoldOn}
   'b',{ecBoldOff}
   'I',{ecItalicOn}
   'i',{ecItalicOff}
   'U',{ecUnderlineOn}
   'u',{ecUnderlineOff}
   'H',{ecSuperScriptOn}
   'h',{ecSuperScriptOff}
   'L',{ecSubScriptOn}
   'l',{ecSubScriptOff}
   'W',{ecWideOn}
   'w',{ecWideOff}
   'Q',{ec12cpiOn}
   'q'{ec12cpiOff});

  //   ESC     Preview
  ESCFontChanges : array [TprESCCode] of rESCFontChange =
  ((ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escSpecial;    Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escPushChange; Styles : [fsBold]; Color : clNone),
   (ESCType : escPop;        Styles : []; Color : clNone),
   (ESCType : escPushChange; Styles : [fsItalic]; Color : clNone),
   (ESCType : escPop;        Styles : []; Color : clNone),
   (ESCType : escPushChange; Styles : [fsUnderline]; Color : clNone),
   (ESCType : escPop;        Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone),
   (ESCType : escNone;       Styles : []; Color : clNone));

  TxFontStyleToESCSpecifier : array [TTxFontStyle] of char = ('D','P','E');
  TxFontOptionsToESCSpecifier : array [TTxFontOptions,1..2] of char =
   (('C','c'),
    ('B','b'),
    ('I','i'),
    ('U','u'),
    ('H','h'),
    ('L','l'),
    ('W','w'),
    ('Q','q'));

var
  ESCSpecifiersSet : set of char;
  ESCModels : TprESCModels;
  prESCModelsFileName : string;
  prOEMtoWINTable : array [0..127] of char = #192#193#194#195#196#197#198#199#200#201#202#203#204#205#206#207#208#209#210#211#212#213#214#215#216#217#218#219#220#221#222#223#224#225#226#227#228#229#230#231#232#233#234#235#236#237#238#239#128#129#130#131#132#133#134#135#136#137#138#139#140#141#142#143#144#145#146#147#148#149#150#151#152#153#154#155#156#157#158#159#160#161#162#163#164#165#166#167#168#169#170#171#172#173#174#175#240#241#242#243#244#245#246#247#248#249#250#251#252#253#254#255#176#177#178#179#180#181#182#183#184#185#186#187#185#189#190#191;
  prWINtoOEMTable : array [0..127] of char = #176#177#178#179#180#181#182#183#184#185#186#187#188#189#190#191#192#193#194#195#196#197#198#199#200#201#202#203#204#205#206#207#208#209#210#211#212#213#214#215#216#217#218#219#220#221#222#223#240#241#242#243#244#245#246#247#248#78#250#251#252#253#254#255#128#129#130#131#132#133#134#135#136#137#138#139#140#141#142#143#144#145#146#147#148#149#150#151#152#153#154#155#156#157#158#159#160#161#162#163#164#165#166#167#168#169#170#171#172#173#174#175#224#225#226#227#228#229#230#231#232#233#234#235#236#237#238#239;
                                                                                                                                                                                                                                                                                  {249}
///////////////////////////////////
//
// 
//
///////////////////////////////////
procedure prOEMtoWIN(sSource : PChar; sDest : PChar);
procedure prWINtoOEM(sSource : PChar; sDest : PChar);
function GetESCCodeByESCSpecifier(c : char) : TprESCCode;

implementation

uses
  pr_Utils, pr_Strings, pr_MultiLang;

procedure Decode(sSource : PChar; sDest : PChar; Table : PChar);
var
  i : integer;
begin
for i:=0 to lstrlen(sSource)-1 do
  if byte(sSource[i])>=128 then
    sDest[i]:=Table[byte(sSource[i])-128];
end;

procedure prOEMtoWIN;
begin
Decode(sSource,sDest,prOEMtoWINTable);
end;

procedure prWINtoOEM;
begin
Decode(sSource,sDest,prWINtoOEMTable);
end;

function GetESCCodeByESCSpecifier;
begin
Result := Low(TprESCCode);
while (Result<=High(TprESCCode)) and (ESCSpecifiers[Result]<>c) do Inc(Result);
if Result>High(TprESCCode) then
  Result := TprESCCode(-1);
end;

//////////////////////////////////////////
//
// TprESCModel
//
//////////////////////////////////////////
function TprESCModel.GetValue(Index: TprESCCode): String;
begin
Result := ESCs[Index];
end;

procedure TprESCModel.SetValue(Index: TprESCCode; const Value: String);
begin
if Value <> GetValue(Index) then
  ESCs[Index] := Value;
end;

////////////////////////
//
// TprESCModels
//
////////////////////////
function TprESCModels.GetItm;
begin
Result:=TprESCModel(inherited Items[Index]);
end;

function TprESCModels.FindByDriverName;
var
  i : integer;
begin
i := 0;
while (i<Count) and (pos(AnsiUpperCase(Items[i].PrinterDriver),AnsiUpperCase(DriverName))=0) do Inc(i);
if i<Count then
  Result := Items[i]
else
  Result := nil;
end;

function TprESCModels.IndexByModelName;
begin
Result := 0;
while (Result<Count) and (CompText(Items[Result].ModelName,ModelName)<>0) do Inc(Result);
if Result>=Count then
  Result := -1;
end;

function TprESCModels.GetByModelName;
var
  i : integer;
begin
i := IndexByModelName(ModelName);
if i=-1 then
  raise Exception.CreateFmt(prLoadStr(sErrorTxESCModelNotFound),[ModelName]);
Result := Items[i];
end;

procedure TprESCModels.LoadFromFile;
var
  f : TextFile;
  i,p,l : integer;
  ESCModel : TprESCModel;
  FileOpened : boolean;
  b1,b2,PropName,PropValue : string;
begin
if not FileExists(FileName) then exit;
ESCModel := nil;
FileOpened := false;

try
  try
    AssignFile(f,FileName);
    Reset(f);
    FileOpened := true;
    while not eof(f) do
      begin
        ReadLn(f,b1);
        b1 := Trim(b1);
    
        if b1<>'' then
          begin
            if CompText(b1,'StartModel')=0 then
              begin
                //  
                if ESCModel<>nil then
                  Add(ESCModel);
    
                ESCModel:=TprESCModel.Create;
              end;
    
            p:=pos('=',b1);
            if (p<>0) and (ESCModel<>nil) then
              begin
                PropName := Trim(Copy(b1,1,p-1));
                b1 := Trim(Copy(b1,p+1,Length(b1)));
                PropValue := '';
                i := 1;
                l := Length(b1);
                while i<=l do
                  begin
                    if b1[i]='#' then
                      begin
                        Inc(i);
                        b2 := '';
                        while (i<=l) and (b1[i] in ['0'..'9']) do
                          begin
                            b2 := b2+b1[i];
                            Inc(i);
                          end;
                        PropValue := PropValue+chr(StrToIntDef(b2,0));
                      end
                    else
                      begin
                        PropValue := PropValue+b1[i];
                        Inc(i);
                      end;
                  end;

                if AnsiCompareText(PropName,'ModelName')=0 then
                  ESCModel.ModelName := PropValue
                else
                  if AnsiCompareText(PropName,'PrinterDriver')=0 then
                    ESCModel.PrinterDriver := PropValue
                  else
                    ESCModel.Style[TprESCCode(GetEnumValue(TypeInfo(TprESCCode),'ec'+PropName))] := PropValue;
              end;
          end;
      end;
    if ESCModel<>nil then
      Add(ESCModel);
  except
  end;
finally
  if FileOpened then
    CloseFile(f);
end;
end;

var
  i : TprESCCode;

initialization

prESCModelsFileName := GetFindFileName(_sESCModelsFileName);
ESCModels := TprESCModels.Create;
ESCModels.LoadFromFile(prESCModelsFileName);

for i:=Low(TprESCCode) to High(TprESCCode) do
  Include(ESCSpecifiersSet,ESCSpecifiers[i]);

finalization

ESCModels.Free;

end.


