{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_TxClasses;

{$i pr.inc}

interface

uses
  SysUtils, Windows, Classes, Graphics, WinSpool, DB,
  Dialogs, typinfo, Pr_Utils, Math, Forms, IniFiles, Messages, Controls,
  stdctrls, CommDlg, {$ifdef PR_D6} types, {$endif}

  pr_Common, pr_Progress, pr_TxConsts, pr_MultiLang;

const
  sFixedFontName = 'Courier New';
type

TprTextDevice = class;
TprTxReport = class;

rTxExData = record
  FontSize   : integer;
  FontName   : string;
  SymbolSize : TSize;
end;
PTxExData = ^rTxExData;

//////////////////////////
//
// TprTxMemoObjRecVersion
//
//////////////////////////
TprTxMemoObjRecVersion = class(TprObjRecVersion)
private
  FMemo                  : TStrings;
  FDeleteEmptyLinesAtEnd : boolean;
  FDeleteEmptyLines      : boolean;
  FCanResizeX            : boolean;
  FCanResizeY            : boolean;

  FhAlign                : TprHAlign;
  FvAlign                : TprvAlign;
  FTxFontStyle           : TTxFontStyle;
  FTxFontOptions         : TTxFontOptionsSet;
  FWordWrap              : boolean;
  FDefaultFont           : boolean;

  SecondPassNeeded       : boolean; // true -       Memo
public
  procedure Assign(Source : TPersistent); override;

  constructor Create(Collection : TCollection); override;
  destructor Destroy; override;
published
  property Memo                  : TStrings read FMemo write FMemo;
  property DeleteEmptyLinesAtEnd : boolean read FDeleteEmptyLinesAtEnd write FDeleteEmptyLinesAtEnd;
  property DeleteEmptyLines      : boolean read FDeleteEmptyLines write FDeleteEmptyLines;
  property CanResizeX            : boolean read FCanResizeX write FCanResizeX;
  property CanResizeY            : boolean read FCanResizeY write FCanResizeY;

  property hAlign                : TprHAlign read FhAlign write FhAlign;
  property vAlign                : TprvAlign read FvAlign write FvAlign;
  property DefaultFont           : boolean read FDefaultFont write FDefaultFont;
  property TxFontStyle           : TTxFontStyle read FTxFontStyle write FTxFontStyle;
  property TxFontOptions         : TTxFontOptionsSet read FTxFontOptions write FTxFontOptions;

  property WordWrap              : boolean read FWordWrap write FWordWrap;
end;

//////////////////////////
//
// TprTxMemoObjRec
//
//////////////////////////
TprTxMemoObjRec = class(TprObjRec)
protected
  function CreateVersions : TprObjRecVersions; override;
public
  //  
  procedure PlaceOnEndPage(Device : TObject; r : TRect); override;

  procedure SecondPass; override;

  function  CreateCopy : TprObjRec; override;
end;

//////////////////////////
//
// TprTxMemoObj
//
//////////////////////////
TprTxMemoObj = class(TprObj)
protected
  procedure InitdRec; override;
  procedure UpdatePDIdPageRect; override;
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  function  GetDesc : string; override;

  function  AllowInplaceEdit : boolean; override;
  procedure InplaceEdit(_Parent : TWinControl; var InplaceEditor : TWinControl); override;
  procedure SaveInplaceEdit(InplaceEditor : TWinControl); override;

  procedure FirstPass; override;
end;


///////////////////////////////
//
// TprTxHTitleBand
//
///////////////////////////////
TprTxHTitleBand = class(TprCustomHTitleBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

//////////////////////////////
//
// TprTxHSummaryBand
//
//////////////////////////////
TprTxHSummaryBand = class(TprCustomHSummaryBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

/////////////////////////
//
// TprTxHPageHeaderBand
//
/////////////////////////
TprTxHPageHeaderBand = class(TprCustomHPageHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

/////////////////////////
//
// TprTxHPageFooterBand
//
/////////////////////////
TprTxHPageFooterBand = class(TprCustomHPageFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////////////
//
// TprTxHDetailBand
//
///////////////////////////////////
TprTxHDetailBand = class(TprCustomHDetailBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////
//
// TprTxHDetailHeaderBand
//
///////////////////////////
TprTxHDetailHeaderBand = class(TprCustomHDetailHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

////////////////////////////
//
// TprTxHDetailFooterBand
//
////////////////////////////
TprTxHDetailFooterBand = class(TprCustomHDetailFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////
//
// TprTxHGroupHeaderBand
//
///////////////////////////
TprTxHGroupHeaderBand = class(TprCustomHGroupHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////
//
// TprTxHGroupFooterBand
//
///////////////////////////
TprTxHGroupFooterBand = class(TprCustomHGroupFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;







///////////////////////////////
//
// TprTxVTitleBand
//
///////////////////////////////
TprTxVTitleBand = class(TprCustomVTitleBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

//////////////////////////////
//
// TprTxVSummaryBand
//
//////////////////////////////
TprTxVSummaryBand = class(TprCustomVSummaryBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

/////////////////////////
//
// TprTxVPageHeaderBand
//
/////////////////////////
TprTxVPageHeaderBand = class(TprCustomVPageHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

/////////////////////////
//
// TprTxVPageFooterBand
//
/////////////////////////
TprTxVPageFooterBand = class(TprCustomVPageFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////////////
//
// TprTxVDetailBand
//
///////////////////////////////////
TprTxVDetailBand = class(TprCustomVDetailBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////
//
// TprTxVDetailHeaderBand
//
///////////////////////////
TprTxVDetailHeaderBand = class(TprCustomVDetailHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

////////////////////////////
//
// TprTxVDetailFooterBand
//
////////////////////////////
TprTxVDetailFooterBand = class(TprCustomVDetailFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////
//
// TprTxVGroupHeaderBand
//
///////////////////////////
TprTxVGroupHeaderBand = class(TprCustomVGroupHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;

///////////////////////////
//
// TprTxVGroupFooterBand
//
///////////////////////////
TprTxVGroupFooterBand = class(TprCustomVGroupFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  procedure UpdatePDI(ExData : pointer); override;
end;




TprTxPageType = (tptPage,tptRoll);
////////////////////////////////////
//
// TprTxPage
//
////////////////////////////////////
TprTxPage = class(TprCustomPage)
private
  FColNum           : integer;
  FLineNum          : integer;
  FPageType         : TprTxPageType;

  FDefTxFontStyle   : TTxFontStyle;
  FDefTxFontOptions : TTxFontOptionsSet;
protected
  procedure Loaded; override;

//  procedure ReportSetted; override;
public
  // 
  function  GetPageRect : TRect; override;
  procedure DrawDesign(Canvas : TCanvas; ExData : pointer); override;

  constructor Create(AOwner : TComponent); override;
published
  property LineNum          : integer read FLineNum write FLineNum;
  property ColNum           : integer read FColNum write FColNum;
  property PageType         : TprTxPageType read FPageType write FPageType;

  property DefTxFontStyle   : TTxFontStyle read FDefTxFontStyle write FDefTxFontStyle;
  property DefTxFontOptions : TTxFontOptionsSet read FDefTxFontOptions write FDefTxFontOptions;
end;

//////////////////////////
//
// TprTxEndPage
//    ,   
//    
//
//////////////////////////
TprTxEndPage = class(TprCustomEndPage)
public
  ColNum   : integer;
  LineNum  : integer;
  PageType : TprTxPageType;
  TextDevice : TprTextDevice;
  CurDefTxFontStyle : TTxFontStyle;
  CurDefTxFontOptions : TTxFontOptionsSet;

  function GetPageRect : TRect; override;
  procedure ThirdPass; override;

  constructor Create(_Page : TprCustomPage); override;
  constructor CreateEmpty(_Report : TprCustomReport); override;
end;


rTextDeviceRec = packed record
  rPlace : TRect;
  UserData : TprPreviewUserData;
end;
pTextDeviceRec = ^rTextDeviceRec;

//////////////////////////////////
//
// TprTextDevice
//
//////////////////////////////////
TprTextDevice = class(TObject)
private
  Report : TprTxReport;
  CurEndPage : TprTxEndPage;
  CurTopLine : integer;
  CureFormat : string;
  CurDefTxFontStyle : TTxFontStyle;
  CurDefTxFontOptions : TTxFontOptionsSet;
  procedure ClearRecs;
public
  Recs : TList;
  SList : TStrings;

  procedure BeginEndPage(EndPage : TprTxEndPage);
  procedure PlaceMemo(Memo : TStrings; r : TRect; vAlign : TprVAlign; hAlign : TprHAlign);
  procedure PlaceTxMemo(rec : TprTxMemoObjRecVersion; r : TRect; PreviewUserData : TprPreviewUserData);
  procedure Reset;

  procedure LoadFromStream(Stream : TStream);
  procedure AppendFromStream(Stream : TStream);
  procedure SaveToStream(Stream : TStream);

  constructor CreateTextDevice(_Report : TprTxReport);
  destructor Destroy; override;
end;

TprTxExportOptions = (prtxeoLinesRange,prtxeoUseESCModel);
TprTxExportOptionsSet = set of TprTxExportOptions;
TprTxCodePage = (prtxcpDOS866,prtxcpWIN1251);
///////////////////////////////////
//
// TprTxReport
//
///////////////////////////////////
TprTxReport = class(TprCustomReport)
private
  FPrinterName : string;
  FESCModelName : string;

  FLeftSpaces : integer;
  FWrapAfterColumn : integer;
  FStartNewLineOnWrap : boolean;

  FPaperType : TprTxPaperType;

  FUseLinesOnPage : boolean;
  FLinesOnPage : integer;

  FMakeFormFeedOnRulon : boolean;
  FPrintRulonMode : TprTxPrintRulonMode;
  FFromLine : integer;
  FToLine : integer;

  FExportTxOptions : TprTxExportOptionsSet;
  FExportFromLine : integer;
  FExportToLine : integer;
  FExportESCModelName : string;
  FExportCodePage : TprTxCodePage;

protected
  function GetDesignerFormClass : string; override;
  function GetPreviewFormClass : string; override;
  function CheckEndPagesCountOnPreview : boolean; override;
public
  TextDevice : TprTextDevice;

  function  GetPrinterName : string; override;
  procedure SetPrinterName(Value : string); override;

  function  CreateEndPage(Page : TprCustomPage) : TprCustomEndPage; override;
  function  CreateEmptyEndPage : TprCustomEndPage; override;

  function  GetBandClass(BandType : TprBandType) : TprBandClass; override;

  procedure ChangePrinter(OldIndex,NewIndex : integer); override;

  procedure ClearPreparedReport; override;
  function PrepareReport : boolean; override;
  function SetupPrintParams : boolean; override;
  function PrintPreparedReport : boolean; override;

  procedure LoadPreparedReport(Stream : TStream); override;
  procedure AppendPreparedReport(Stream : TStream); override;
  procedure SavePreparedReport(Stream : TStream); override;

  function SetupExportParams : boolean;
  procedure ExportToTXT;

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;
published
  property ESCModelName : string read FESCModelName write FESCModelName;

  property LeftSpaces : integer read FLeftSpaces write FLeftSpaces;
  property WrapAfterColumn : integer read FWrapAfterColumn write FWrapAfterColumn;
  property StartNewLineOnWrap : boolean read FStartNewLineOnWrap write FStartNewLineOnWrap;

  property PaperType : TprTxPaperType read FPaperType write FPaperType;

  property UseLinesOnPage : boolean read FUseLinesOnPage write FUseLinesOnPage;
  property LinesOnPage : integer read FLinesOnPage write FLinesOnPage;

  property MakeFormFeedOnRulon : boolean read FMakeFormFeedOnRulon write FMakeFormFeedOnRulon;
  property PrintRulonMode : TprTxPrintRulonMode read FPrintRulonMode write FPrintRulonMode;
  property FromLine : integer read FFromLine write FFromLine;
  property ToLine : integer read FToLine write FToLine;

  property ExportTxOptions : TprTxExportOptionsSet read FExportTxOptions write FExportTxOptions;
  property ExportFromLine : integer read FExportFromLine write FExportFromLine;
  property ExportToLine : integer read FExportToLine write FExportToLine;
  property ExportESCModelName : string read FExportESCModelName write FExportESCModelName;
  property ExportCodePage : TprTxCodePage read FExportCodePage write FExportCodePage; 
end;

implementation

uses
  pr_Strings, pr_TxPreview, pr_TxUtils, pr_TxExportParams;

procedure WrapMemo2(Memo : TStrings; w : integer);
var
  s : string;
  l : TStringList;
  i,j,p,slen : integer;
begin
// aRec.Memo -> aRec.Memo  WordWrap
l:=TStringList.Create;
try
  for i:=0 to Memo.Count-1 do
    begin
      s   :=Memo[i];
      slen:=Length(s);
      p   :=1;
      repeat
        j:=p+w-1;
        while (j>=p) and (j<=slen) and (not (s[j] in [' ','.',',','-',';'])) do Dec(j);
        if j<p then
          begin
            //   ,    ,   
            l.Add(Copy(s,p,w));
            p:=p+w;
          end
        else
          begin
            l.Add(TrimRight(Copy(s,p,j-p+1)));
            p:=j+1;
          end;
      until (p>=slen);
    end;

  Memo.Assign(l);
finally
  l.Free;
end;
end;

/////////////////////////
//
// TprTxMemoObjRecVersion
//
/////////////////////////
constructor TprTxMemoObjRecVersion.Create;
begin
inherited;
FMemo:=TStringList.Create;
end;

destructor TprTxMemoObjRecVersion.Destroy;
begin
FMemo.Free;
inherited;
end;

procedure TprTxMemoObjRecVersion.Assign;
begin
with Source as TprTxMemoObjRecVersion do
  begin
    Self.SecondPassNeeded      :=SecondPassNeeded;
    Self.FhAlign               :=FhAlign;
    Self.FvAlign               :=FvAlign;
    Self.FDeleteEmptyLinesAtEnd:=FDeleteEmptyLinesAtEnd;
    Self.FDeleteEmptyLines     :=FDeleteEmptyLines;
    Self.FCanResizeX           :=FCanResizeX;
    Self.FCanResizeY           :=FCanResizeY;
    Self.FWordWrap             :=FWordWrap;
    Self.FDefaultFont          :=FDefaultFont;
    Self.FTxFontStyle          :=FTxFontStyle;
    Self.FTxFontOptions        :=FTxFontOptions;
    Self.FMemo.Assign(FMemo);
  end;
inherited;
end;

//////////////////////
//
// TprTxMemoObjRec
//
//////////////////////
function TprTxMemoObjRec.CreateCopy;
begin
Result:=TprTxMemoObjRec.Create(Self.Page,Self.Obj);
Result.Assign(Self);
end;

function TprTxMemoObjRec.CreateVersions;
begin
Result:=TprObjRecVersions.Create(TprTxMemoObjRecVersion);
end;

procedure TprTxMemoObjRec.SecondPass;
var
  i : integer;
  l : TStringList;
  v : TprTxMemoObjRecVersion;
begin
inherited; //  

l := TStringList.Create;
try
  for i:=0 to Versions.Count-1 do
    if TprTxMemoObjRecVersion(Versions[i]).SecondPassNeeded then
      begin
        v := TprTxMemoObjRecVersion(Versions[i]);
        Obj.Band.Report.FormatStrings(v.Memo,
                                      l,
                                      v.DeleteEmptyLines,
                                      v.DeleteEmptyLinesAtEnd);
        v.Memo.Assign(l);

        if v.WordWrap then
          WrapMemo2(v.Memo,dx);
      end;
finally
  l.Free;
end;
end;

procedure TprTxMemoObjRec.PlaceOnEndPage;
var
  v : TprTxMemoObjRecVersion;
begin
//  Memo    
if not Versions[CurVersion].Visible then exit;

v := TprTxMemoObjRecVersion(Versions[CurVersion]);
TprTextDevice(Device).PlaceTxMemo(v,r,PreviewUserData);
PreviewUserData := nil;
end;

//////////////////////////////
//
// TprTxMemoObj
//
//////////////////////////////
function TprTxMemoObj.AllowInplaceEdit;
begin
Result:=true;
end;

procedure TprTxMemoObj.InplaceEdit;
var
  r : TRect;
  v : TprTxMemoObjRecVersion;
  s : string;
  i,l : integer;
begin
v:=TprTxMemoObjRecVersion(dRec.Versions[dRec.DefVersion]);
InplaceEditor:=TprTxOEMMemo.Create(_Parent);

with TprTxOEMMemo(InplaceEditor) do
  begin
    WordWrap       :=false;
    ParentCtl3D    :=False;
    Ctl3D          :=False;
    TabStop        :=False;
    BorderStyle    :=bsNone;
    DoubleBuffered :=False;
    Left           :=pdi.dPageRect.Left;
    Top            :=pdi.dPageRect.Top-1;
    Width          :=pdi.dPageRect.Right-pdi.dPageRect.Left;
    Height         :=pdi.dPageRect.Bottom-pdi.dPageRect.Top+2;
    Parent         :=_Parent;
    Font.Size      :=14;

    //   
    Lines.BeginUpdate;
    try
      Lines.Clear;
      for i:=0 to v.Memo.Count-1 do
        begin
          l:=Length(v.Memo[i]);
          SetLength(s,l);
          MoveMemory(@(s[1]),@(v.Memo[i][1]),l);
          prWinToOem(PChar(s),PChar(s));

          Lines.Add(s);
        end;
    finally
      Lines.EndUpdate;
    end;

    r:=Rect(0,0,Width,Height);
    SendMessage(InplaceEditor.Handle, EM_SETRECT, 0, LongInt(@R));
    SendMessage(InplaceEditor.Handle, EM_SETSEL, 0, 0);

    Show;
    SetFocus;
  end;
end;

procedure TprTxMemoObj.SaveInplaceEdit;
var
  i : integer;
  v : TprTxMemoObjRecVersion;
begin
v:=TprTxMemoObjRecVersion(dRec.Versions[dRec.DefVersion]);
with TprTxOEMMemo(InplaceEditor) do
  begin
    v.Memo.Clear;
    for i:=0 to Lines.Count-1 do
      begin
        v.Memo.Add(Lines[i]);
        prOemToWin(PChar(v.Memo[i]),
                   PChar(v.Memo[i]));
      end;
  end;
end;

procedure TprTxMemoObj.InitdRec;
begin
FdRec:=TprTxMemoObjRec.Create(nil,Self);
dRec.Versions.Add;
end;

procedure TprTxMemoObj.UpdatePDIdPageRect;
begin
inherited;
pdi.dPageRect.Right :=pdi.dPageRect.Right+1;
pdi.dPageRect.Bottom:=pdi.dPageRect.Bottom+1;
end;

function TprTxMemoObj.GetDesc;
var
  i : integer;
  v : TprTxMemoObjRecVersion;
begin
v:=TprTxMemoObjRecVersion(dRec.Versions[dRec.DefVersion]);
i:=0;
while (i<v.Memo.Count) and
      (Trim(v.Memo[i])='') do Inc(i);
if i<v.Memo.Count then
  Result:=Trim(v.Memo[i])
else
  Result:=inherited GetDesc;
end;

type
  rTxFontStylesToGDIFont = record
    Name  : string;
    Color : TColor;
  end;

  rTxFontOptionsToGDIFont = record
    DeletedStyles : TFontStyles;
    AddedStyles   : TFontStyles;
  end;

const
  StylesArray  : array [TTxFontStyle] of rTxFontStylesToGDIFont=
  ((Name : sFixedFontName; Color : clNone),
   (Name : sFixedFontName; Color : clNone),
   (Name : sFixedFontName; Color : clNone));

  OptionsArray : array [TTxFontOptions] of rTxFontOptionsToGDIFont=
  ((DeletedStyles : []; AddedStyles : []),
   (DeletedStyles : []; AddedStyles : [fsBold]),
   (DeletedStyles : []; AddedStyles : [fsItalic]),
   (DeletedStyles : []; AddedStyles : [fsUnderline]),
   (DeletedStyles : []; AddedStyles : []),
   (DeletedStyles : []; AddedStyles : []),
   (DeletedStyles : []; AddedStyles : []),
   (DeletedStyles : []; AddedStyles : []));

procedure TprTxMemoObj.DrawDesign;
var
  s : string;
  v : TprTxMemoObjRecVersion;
  r : TRect;
  fs : TFontStyles;
  nbr : HBRUSH;
  CalcH : integer;
  opn,npn : HPEN;
  nfn,ofn : HFONT;
  LogFont : TLogFont;
  i,l,CurY,CurX : integer;
begin
v:=TprTxMemoObjRecVersion(dRec.Versions[dRec.DefVersion]);
r:=PDI.dPageRect;

npn:=CreatePen(PS_DOT,1,clGray);
opn:=SelectObject(DC,npn);
nbr:=CreateSolidBrush(clWhite);
FillRect(DC,r,nbr);
DrawRect(DC,r);
SelectObject(DC,opn);
DeleteObject(npn);
DeleteObject(nbr);

//   
fs:=[];
for i:=integer(Low(TTxFontOptions)) to integer(High(TTxFontOptions)) do
  if (TTxFontOptions(i) in v.TxFontOptions) or
     (TTxFontOptions(i) in TprTxPage(Band.Page).DefTxFontOptions) then
    fs:=fs-OptionsArray[TTxFontOptions(i)].DeletedStyles+OptionsArray[TTxFontOptions(i)].AddedStyles;

ZeroMemory(@LogFont,sizeof(LogFont));
with LogFont do
  begin
    lfHeight        :=-MulDiv(PTxExData(ExData).FontSize,GetDeviceCaps(DC,LOGPIXELSY),72);
    lfWeight        :=FW_NORMAL;
    lfCharSet       :=OEM_CHARSET;
    lfOutPrecision  :=OUT_DEFAULT_PRECIS;
    lfClipPrecision :=CLIP_DEFAULT_PRECIS;
    lfQuality       :=DEFAULT_QUALITY;
    lfPitchAndFamily:=DEFAULT_PITCH;
    lfItalic        :=byte(fsItalic in fs);
    lfUnderline     :=byte(fsUnderline in fs);
    lfCharSet       :=OEM_CHARSET;
    StrPCopy(lfFaceName,PTxExData(ExData).FontName);
  end;
nfn:=CreateFontIndirect(LogFont);
ofn:=SelectObject(DC,nfn);
try
  CalcH:=v.Memo.Count;

  case v.vAlign of
    prvCenter:
      if r.Bottom-r.Top<CalcH then CurY:=0
                              else CurY:=(dRec.pRect.Bottom-dRec.pRect.Top-CalcH) div 2;
    prvBottom:
      if r.Bottom-r.Top<CalcH then CurY:=0
                              else CurY:=dRec.pRect.Bottom-dRec.pRect.Top-CalcH
    else
      CurY:=0;
  end;

  SetBkMode(DC,TRANSPARENT);
  for i:=0 to v.Memo.Count-1 do
    begin
      l:=Length(v.Memo[i]);
      SetLength(s,l);
      MoveMemory(@(s[1]),@(v.Memo[i][1]),l);
      prWinToOem(PChar(s),PChar(s));

      case v.hAlign of
        prhCenter:
          if r.Right-r.Left<l then CurX:=0
                              else CurX:=(dRec.pRect.Right-dRec.pRect.Left-l) div 2;
        prhRight:
          if r.Right-r.Left<l then CurX:=dRec.pRect.Left
                              else CurX:=dRec.pRect.Right-dRec.pRect.Left-l
        else
          CurX:=0;
      end;

      ExtTextOut(DC,
                 r.Left+CurX*PTxExData(ExData).SymbolSize.cx,
                 r.Top+CurY*PTxExData(ExData).SymbolSize.cy,
                 ETO_CLIPPED,
                 @r,
                 PChar(s),
                 l,
                 nil);
      Inc(CurY);
    end;
  SetBkMode(DC,OPAQUE);
finally
  SelectObject(DC,ofn);
  DeleteObject(nfn);
end;
inherited;
end;

procedure TprTxMemoObj.FirstPass;
var
  v : TprTxMemoObjRecVersion;
  i,mw : integer;
  ManuallyProcessed : boolean;
begin
if aRec=nil then
  aRec := TprTxMemoObjRec.Create(nil,Self);
aRec.Assign(dRec);

//   
aRec.FirstPassCalcCurVersion;

//   (OnFirstPassObject)
Band.Report.DoOnFirstPassObject(Self,ManuallyProcessed);

//    aRec.Memo
if not ManuallyProcessed then
  for i:=0 to aRec.Versions.Count-1 do
    TprTxMemoObjRecVersion(aRec.Versions[i]).SecondPassNeeded := not Band.Report.FormatStrings(TprTxMemoObjRecVersion(dRec.Versions[i]).Memo,
                                                                                               TprTxMemoObjRecVersion(aRec.Versions[i]).Memo,
                                                                                               TprTxMemoObjRecVersion(aRec.Versions[i]).DeleteEmptyLines,
                                                                                               TprTxMemoObjRecVersion(aRec.Versions[i]).DeleteEmptyLinesAtEnd);

v := TprTxMemoObjRecVersion(aRec.Versions[aRec.CurVersion]);

aRec.DX := dRec.pRect.Right-dRec.pRect.Left;
aRec.DY := dRec.pRect.Bottom-dRec.pRect.Top;

//    DX  DY
if v.WordWrap then
  WrapMemo2(v.Memo,aRec.dx)
else
  if v.CanResizeX then
    begin
      //  DX       Memo
      mw := 0;
      for i:=0 to v.Memo.Count-1 do
        if Length(v.Memo[i])>mw then
          mw:=Length(v.Memo[i]);
      aRec.DX := mw;
    end;

if v.CanResizeY then
  aRec.DY := v.Memo.Count;

aRec.pRect := Rect(-1,-1,-1,-1);

inherited;
end;









//
// Band   -  
// Canvas -   
// R      - ,    ,   
//           
//
procedure TprTxHBand_DrawDesign(Band : TprCustomHBand; DC : HDC; ExData : pointer);
var
  s : string;
  sz : tagSize;
  npn,npn2,opn : HPEN;
  nfn,ofn : HFONT;
begin
npn :=CreatePen(PS_DOT,1,clBlue);
npn2:=CreatePen(PS_SOLID,1,clSilver);
opn :=SelectObject(DC,npn);
nfn :=CreateDefFont(DC,8,clBlack);
ofn :=SelectObject(DC,nfn);

try
  DrawRect(DC,Band.pdi.dPageRect);

  s:=Band.GetDrawDesignCaption;
  GetTextExtentPoint32(DC,PChar(s),Length(s),sz);

  ExtTextOut(DC,
             Band.pdi.dPageRect.Left+2,
             Band.pdi.dPageRect.Bottom-sz.cy-2,
             ETO_CLIPPED,
             @Band.pdi.dPageRect,
             PChar(s),
             Length(s),
             nil);
finally
  SelectObject(DC,ofn);
  SelectObject(DC,opn);
  DeleteObject(nfn);
  DeleteObject(npn);
  DeleteObject(npn2);
end;
end;

procedure TprTxHBand_UpdatePDI(Band : TprCustomHBand; ExData : pointer);
begin
Inc(Band.pdi.dPageRect.Bottom);
end;

//////////////////////////
//
// TprTxHTitleBand
//
//////////////////////////
procedure TprTxHTitleBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHTitleBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

/////////////////////////
//
// TprTxHSummaryBand
//
/////////////////////////
procedure TprTxHSummaryBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHSummaryBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

//////////////////////////
//
// TprTxHPageHeaderBand
//
//////////////////////////
procedure TprTxHPageHeaderBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHPageHeaderBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

/////////////////////////////
//
// TprTxHPageFooterBand
//
/////////////////////////////
procedure TprTxHPageFooterBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHPageFooterBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

//////////////////////////
//
// TprTxHDetailBand
//
//////////////////////////
procedure TprTxHDetailBand.DrawDesign;
var
  opn,npn : HPEN;
  cx,cy,i,ColWidth : integer;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
//  
if ColCount>1 then
  begin
    cx :=PTxExData(ExData).SymbolSize.cx;
    cy :=PTxExData(ExData).SymbolSize.cy;
    npn:=CreatePen(PS_DOT,1,clBlue);
    opn:=SelectObject(DC,npn);
    try
      ColWidth:=((dPageRect.Right-dPageRect.Left) div ColCount)*cx;
      for i:=1 to ColCount-1 do
        begin
          MoveToEx(DC,dPageRect.Left*cx+ColWidth*i,dPageRect.Top*cy,nil);
          LineTo(DC,dPageRect.Left*cx+ColWidth*i,dPageRect.Bottom*cy);
        end;
    finally
      SelectObject(DC,opn);
      DeleteObject(npn);
    end;
  end;
end;

procedure TprTxHDetailBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////
//
// TprTxHDetailHeaderBand
//
////////////////////////////////
procedure TprTxHDetailHeaderBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHDetailHeaderBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////
//
// TprTxHDetailFooterBand
//
////////////////////////////////
procedure TprTxHDetailFooterBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHDetailFooterBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////////
//
// TprTxHGroupHeaderBand
//
////////////////////////////////////
procedure TprTxHGroupHeaderBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHGroupHeaderBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////////
//
// TprTxHGroupFooterBand
//
////////////////////////////////////
procedure TprTxHGroupFooterBand.DrawDesign;
begin
TprTxHBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxHGroupFooterBand.UpdatePDI;
begin
inherited;
TprTxHBand_UpdatePDI(Self,ExData);
end;





////////////////////////////////
//
//  BANDS
//
////////////////////////////////





//
// Canvas -   
// R      - ,    ,   
//           
//
procedure TprTxVBand_DrawDesign(Band : TprBand; DC : HDC; ExData : pointer);
var
  s : string;
  sz : tagSize;
  npn,opn : HPEN;
  nfn,ofn : HFONT;
begin
npn :=CreatePen(PS_DOT,1,clRed);
opn :=SelectObject(DC,npn);
nfn :=Create90DefFont(DC,8,clBlack);
ofn :=SelectObject(DC,nfn);

try
  DrawRect(DC,Band.pdi.dPageRect);

  s:=Band.GetDrawDesignCaption;
  GetTextExtentPoint32(DC,PChar(s),Length(s),sz);

  ExtTextOut(DC,
             Band.pdi.dPageRect.Right-sz.cy-2,
             Band.pdi.dPageRect.Bottom-2,
             ETO_CLIPPED,
             @Band.pdi.dPageRect,
             PChar(s),
             Length(s),
             nil);
finally
  SelectObject(DC,ofn);
  SelectObject(DC,opn);
  DeleteObject(nfn);
  DeleteObject(npn);
end;
end;

procedure TprTxVBand_UpdatePDI(Band : TprCustomVBand; ExData : pointer);
begin
Inc(Band.pdi.dPageRect.Right);
end;

//////////////////////////
//
// TprTxVTitleBand
//
//////////////////////////
procedure TprTxVTitleBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVTitleBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

/////////////////////////
//
// TprTxVSummaryBand
//
/////////////////////////
procedure TprTxVSummaryBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVSummaryBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

//////////////////////////
//
// TprTxVPageHeaderBand
//
//////////////////////////
procedure TprTxVPageHeaderBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVPageHeaderBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

/////////////////////////////
//
// TprTxVPageFooterBand
//
/////////////////////////////
procedure TprTxVPageFooterBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVPageFooterBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

//////////////////////////
//
// TprTxVDetailBand
//
//////////////////////////
procedure TprTxVDetailBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVDetailBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////
//
// TprTxVDetailHeaderBand
//
////////////////////////////////
procedure TprTxVDetailHeaderBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVDetailHeaderBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////
//
// TprTxVDetailFooterBand
//
////////////////////////////////
procedure TprTxVDetailFooterBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVDetailFooterBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////////
//
// TprTxVGroupHeaderBand
//
////////////////////////////////////
procedure TprTxVGroupHeaderBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVGroupHeaderBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;

////////////////////////////////////
//
// TprTxVGroupFooterBand
//
////////////////////////////////////
procedure TprTxVGroupFooterBand.DrawDesign;
begin
TprTxVBand_DrawDesign(Self,DC,ExData);
end;

procedure TprTxVGroupFooterBand.UpdatePDI;
begin
inherited;
TprTxVBand_UpdatePDI(Self,ExData);
end;







//////////////////////////
//
// TprTxEndPage
//
//////////////////////////
constructor TprTxEndPage.CreateEmpty;
begin
inherited CreateEmpty(_Report);
end;

constructor TprTxEndPage.Create;
begin
CreateEmpty(_Page.Report);

ColNum    :=TprTxPage(_Page).ColNum;
LineNum   :=TprTxPage(_Page).LineNum;
PageType  :=TprTxPage(_Page).PageType;

Rect.Top  :=0;
Rect.Left :=0;
Rect.Right:=ColNum;
case PageType of
  tptPage: Rect.Bottom:=LineNum;
  tptRoll: Rect.Bottom:=High(integer);
end;

TextDevice:=TprTxReport(_Page.Report).TextDevice;
CurDefTxFontStyle  :=TprTxPage(_Page).DefTxFontStyle;
CurDefTxFontOptions:=TprTxPage(_Page).DefTxFontOptions;
end;

function TprTxEndPage.GetPageRect;
begin
if PageType=tptPage then
  Result:=Classes.Rect(0,0,ColNum,LineNum)
else
  Result:=Classes.Rect(0,0,ColNum,High(integer));
end;

procedure TprTxEndPage.ThirdPass;
var
  i : integer;
begin
TextDevice.BeginEndPage(Self);
for i:=0 to oRecsCount-1 do
  begin
    oRec[i].SecondPass;
    oRec[i].PlaceOnEndPage(Report.ObjectCalcSizesDevice,oRec[i].pRect);
  end;
end;


/////////////////////////////////
//
// TprTxPage
//
/////////////////////////////////
constructor TprTxPage.Create;
begin
inherited;
ColNum   :=80;
LineNum  :=60;
end;

procedure TprTxPage.Loaded;
begin
UpdateBandsPageRect;
inherited;
end;

procedure TprTxPage.DrawDesign;
begin
inherited;
end;

function TprTxPage.GetPageRect;
begin
Result:=Classes.Rect(0,0,ColNum,LineNum)
end;

////////////////////////////
//
// TprTextDevice
//      
//
////////////////////////////
constructor TprTextDevice.CreateTextDevice;
begin
inherited;
Report := _Report;
CurEndPage := nil;
CurTopLine := 0;
SList := TStringList.Create;
Recs := TList.Create;
end;

destructor TprTextDevice.Destroy;
begin
ClearRecs;
Recs.Free;
SList.Free;
inherited;
end;

procedure TprTextDevice.ClearRecs;
var
  i : integer;
begin
for i:=0 to Recs.Count-1 do
  FreeMem(Recs[i]);
Recs.Clear;
end;

procedure TprTextDevice.Reset;
begin
ClearRecs;
SList.Clear;
CurEndPage := nil;
CurTopLine := 0;
CureFormat := '';
CurDefTxFontStyle := TTxFontStyle(-1);
CurDefTxFontOptions := [];
end;

procedure TprTextDevice.BeginEndPage;
var
  i : TTxFontOptions;
  sFormat : string;
begin
if CurEndPage<>nil then
  begin
    //      
    if (CurEndPage.PageType=tptPage) or (EndPage.PageType=tptPage) then
      begin
        // 
        if SList.Count>0 then
          SList[SList.Count-1] := SList[SList.Count-1]+ESCSymbol+ESCSpecifiers[ecFormFeed];
      end;
  end;
CurEndPage := EndPage;
CurTopLine := SList.Count;

if (CurDefTxFontStyle<>EndPage.CurDefTxFontStyle) or (CurDefTxFontOptions<>EndPage.CurDefTxFontOptions) then
  begin
    //     ,  CureFormat
    if CureFormat<>'' then
      begin
        if SList.Count=0 then
          SList.Add('');
        SList[SList.Count-1] := SList[SList.Count-1]+CureFormat;
      end;

    // make new formats
    CureFormat := '';
    sFormat := ESCSymbol+TxFontStyleToESCSpecifier[EndPage.CurDefTxFontStyle];
    for i:=Low(TTxFontOptions) to High(TTxFontOptions) do
      if i in EndPage.CurDefTxFontOptions then
        begin
          sFormat := sFormat+ESCSymbol+TxFontOptionsToESCSpecifier[i,1];
          CureFormat := ESCSymbol+TxFontOptionsToESCSpecifier[i,2]+CureFormat;
        end;

    CurDefTxFontStyle := EndPage.CurDefTxFontStyle;
    CurDefTxFontOptions := EndPage.CurDefTxFontOptions;

    if sFormat<>'' then
      begin
        if SList.Count=0 then
          SList.Add('');
        SList[SList.Count-1] := SList[SList.Count-1]+sFormat;
      end;
  end;
end;

//
//     ESC ,
//   R   
//  
//
procedure TprTextDevice.PlaceTxMemo;
var
  m : TTxFontOptions;
  tdr : pTextDeviceRec;
  s,Buf,sFormat,eFormat : string;
  i,j,k,l,n,w,y,CurY,CalcH : integer;

  function IsESCSpecifier(c : char) : boolean;
  var
    i : TprESCCode;
  begin
  i := Low(TprESCCode);
  while (i<=High(TprESCCode)) and (c<>ESCSpecifiers[i]) do Inc(i);
  Result := i<=High(TprESCCode);
  end;

begin
CalcH := Min(rec.Memo.Count,r.Bottom-r.Top);
case rec.vAlign of
  prvCenter:
    if r.Bottom-r.Top<CalcH then CurY:=0
                            else CurY:=(r.Bottom-r.Top-CalcH) div 2;
  prvBottom:
    if r.Bottom-r.Top<CalcH then CurY:=0
                            else CurY:=r.Bottom-r.Top-CalcH
  else
    CurY:=0;
end;
w := r.Right-r.Left;

GetMem(tdr,sizeof(rTextDeviceRec));
with tdr^ do
  begin
    rPlace := Rect(r.Left,r.Top+CurTopLine,r.Right-1,r.Bottom+CurTopLine-1);
    UserData := PreviewUserData;
  end;
Recs.Add(tdr);

for i:=0 to CalcH-1 do
  begin
    y := CurTopLine+i+r.Top+CurY;

    while SList.Count<=y do
      SList.Add('');

    Buf := SList[y];
    l := Length(Buf);

    //        Memo[i]
    j := 1;
    n := 0;
    while (j<=l) and (n<=r.Left) do
      if (Buf[j]=ESCSymbol) and (j<l) and IsESCSpecifier(Buf[j+1]) then
        begin
          j := j+2;
        end
      else
        begin
          Inc(n);
          Inc(j);
        end;

    if j>l then
      //  n      
      //     (j)  
      //  ,   :
      j := j+r.Left-n
    else
      begin
        //       ,
        k := j;
        Dec(j);
        while (k<=l) and (n<=r.Right) do
          if (Buf[k]=ESCSymbol) and (k<l) and IsESCSpecifier(Buf[k+1]) then
            begin
              k := k+2;
            end
          else
            begin
              Inc(n);
              Inc(k);
            end;
      end;

    if r.Right>n then
      //   , n -  ""    (  )
      Buf := AddCharR(' ',Buf,r.Right-n+l);

    // j   -       Memo[i]
    // Buf -    
    sFormat := '';
    eFormat := '';
    if not rec.DefaultFont then
      begin
        if rec.TxFontStyle<>CurDefTxFontStyle then
          begin
            sFormat := sFormat+ESCSymbol+TxFontStyleToESCSpecifier[rec.TxFontStyle];
            eFormat := eFormat+ESCSymbol+TxFontStyleToESCSpecifier[CurDefTxFontStyle];
          end;
        for m:=Low(TTxFontOptions) to High(TTxFontOptions) do
          if (m in CurDefTxFontOptions) and not(m in rec.TxFontOptions) then
            begin
              // must off this style
              sFormat := sFormat+ESCSymbol+TxFontOptionsToESCSpecifier[m,2];
              eFormat := ESCSymbol+TxFontOptionsToESCSpecifier[m,1]+eFormat;
            end
          else
            if not(m in CurDefTxFontOptions) and (m in rec.TxFontOptions) then
              begin
                // must on this style
                sFormat := sFormat+ESCSymbol+TxFontOptionsToESCSpecifier[m,1];
                eFormat := ESCSymbol+TxFontOptionsToESCSpecifier[m,2]+eFormat;
              end;
      end;

    if sFormat<>'' then
      begin
        Insert(sFormat,Buf,j);
        j := j+Length(sFormat);
      end;

    FillMemory(@(Buf[j]),w,32);

    l := Length(rec.Memo[i]);
    SetLength(s,l);
    MoveMemory(@(s[1]),@(rec.Memo[i][1]),l);
    prWinToOem(PChar(s),PChar(s));

    case rec.hAlign of
      prhLeft:
        MoveMemory(@(Buf[j]),@(s[1]),Min(w,l));
      prhCenter:
        if w<=l then
          MoveMemory(@(Buf[j]),@(s[1]),w)
        else
          MoveMemory(@(Buf[j+((w-l) div 2)]),@(s[1]),l);
      prhRight:
        if w<=l then
          MoveMemory(@(Buf[j]),@(s[1]),w)
        else
          MoveMemory(@(Buf[j+w-l]),@(s[1]),l);
    end;

    if eFormat<>'' then
      Insert(eFormat,Buf,j+w);

    SList[y] := Buf;
  end;
end;

procedure TprTextDevice.PlaceMemo;
var
  s,Buf : string;
  i,l,w,y,CurY,CurX,CalcH : integer;
begin
CalcH:=Memo.Count;
case vAlign of
  prvCenter:
    if r.Bottom-r.Top<CalcH then CurY:=0
                            else CurY:=(r.Bottom-r.Top-CalcH) div 2;
  prvBottom:
    if r.Bottom-r.Top<CalcH then CurY:=0
                            else CurY:=r.Bottom-r.Top-CalcH
  else
    CurY:=0;
end;

for i:=0 to Memo.Count-1 do
  begin
    y:=CurTopLine+i+r.Top+CurY;

    while SList.Count<=y do
      SList.Add('');

    l:=Length(Memo[i]);
    SetLength(s,l);
    MoveMemory(@(s[1]),@(Memo[i][1]),l);
    prWinToOem(PChar(s),PChar(s));

    w   :=Min(r.Right-r.Left,l);
    CurX:=r.Left;
    case hAlign of
      prhCenter:
        if r.Right-r.Left>l then CurX:=CurX+(r.Right-r.Left-l) div 2;
      prhRight:
        if r.Right-r.Left>l then CurX:=CurX+r.Right-r.Left-l;
    end;

    if w>0 then
      begin
        Buf:=AddChar(' ',SList[y],CurX+w-Length(SList[y])+1);

        MoveMemory(@(Buf[CurX+1]),@(s[1]),w);

        SList[y]:=Buf;
      end;
  end;
end;

const
  TextDeviceSignature = $0101;

procedure TprTextDevice.LoadFromStream;
var
  r : TRect;
  s : string;
  tdr : pTextDeviceRec;
  i,n : integer;
  PreviewUserData : TprPreviewUserData;
begin
Stream.Read(n,4);
if n=TextDeviceSignature then
  begin
    Stream.Read(n,sizeof(n));
    for i:=0 to n-1 do
      begin
        ReadRect(Stream,r);
        s := ReadString(Stream);
        if s<>'' then
          begin
            PreviewUserData := CreateprPreviewUserData(s);
            PreviewUserData.LoadFromStream(Stream);
          end
        else
          PreviewUserData := nil;

        GetMem(tdr,sizeof(rTextDeviceRec));
        with tdr^ do
          begin
            rPlace := r;
            UserData := PreviewUserData;
          end;
        Recs.Add(tdr);
        if PreviewUserData<>nil then
          Report.AddPreviewUserData(PreviewUserData);
      end;
  end
else
  Stream.Seek(0,soFromBeginning);
SList.LoadFromStream(Stream);
end;

procedure TprTextDevice.AppendFromStream;
var
  r : TRect;
  s : string;
  l : TStringList;
  tdr : pTextDeviceRec;
  i,n : integer;
  PreviewUserData : TprPreviewUserData;
begin
Stream.Read(n,4);
if n=TextDeviceSignature then
  begin
    Stream.Read(n,sizeof(n));
    for i:=0 to n-1 do
      begin
        ReadRect(Stream,r);
        r.Top := r.Top+SList.Count;
        r.Bottom := r.Bottom+SList.Count;
        s := ReadString(Stream);
        if s<>'' then
          begin
            PreviewUserData := CreateprPreviewUserData(s);
            PreviewUserData.LoadFromStream(Stream);
          end
        else
          PreviewUserData := nil;

        GetMem(tdr,sizeof(rTextDeviceRec));
        with tdr^ do
          begin
            rPlace := r;
            UserData := PreviewUserData;
          end;
        Recs.Add(tdr);
        if PreviewUserData<>nil then
          Report.AddPreviewUserData(PreviewUserData);
      end;
  end
else
  Stream.Seek(0,soFromBeginning);
l := TStringList.Create;
try
  l.LoadFromStream(Stream);
  SList.AddStrings(l);
finally
  l.Free;
end;
end;

procedure TprTextDevice.SaveToStream;
var
  i,n : integer;

  procedure WriteRec(Rec : pTextDeviceRec);
  begin
  WriteRect(Stream,Rec.rPlace);
  if Rec.UserData<>nil then
    begin
      WriteString(Stream,Rec.UserData.ClassName);
      Rec.UserData.SaveToStream(Stream);
    end
  else
    WriteString(Stream,'');
  end;

begin
n := TextDeviceSignature;
Stream.Write(n,4);
n := Recs.Count;
Stream.Write(n,sizeof(n));
if (Stream is TMemoryStream) and (n>0) then
  begin
    i := 0;
    repeat
      WriteRec(pTextDeviceRec(Recs[i]));
      Inc(i);
      if Stream.Size=Stream.Position then
        Stream.Size := muldiv(n,Stream.Size,i);
    until (i>=n);
    Stream.Size := Stream.Position;
  end
else
  for i:=0 to Recs.Count-1 do
    WriteRec(pTextDeviceRec(Recs[i]));
SList.SaveToStream(Stream);
end;

///////////////////////////
//
// TprTxReport
//
///////////////////////////
constructor TprTxReport.Create;
begin
inherited;
TextDevice := TprTextDevice.CreateTextDevice(Self);
ObjectCalcSizesDevice := TextDevice;
end;

destructor TprTxReport.Destroy;
begin
TextDevice.Free;
inherited;
end;

function TprTxReport.GetDesignerFormClass;
begin
Result:='TprTxDesignerForm';
end;

function TprTxReport.GetPreviewFormClass;
begin
Result:='TprTxPreviewForm';
end;

function TprTxReport.CheckEndPagesCountOnPreview;
begin
Result := false;
end;

function TprTxReport.CreateEndPage;
begin
Result:=TprTxEndPage.Create(Page as TprTxPage);
end;

function TprTxReport.CreateEmptyEndPage;
begin
Result:=TprTxEndPage.CreateEmpty(Self);
end;

procedure TprTxReport.SetPrinterName;
begin
FPrinterName:=Value;
end;

function TprTxReport.GetPrinterName;
begin
Result:=FPrinterName;
end;

procedure TprTxReport.ChangePrinter;
begin
end;

function TprTxReport.SetupPrintParams;
begin
Result:=TxSetupPrintParams(application.Handle,
                           ParsePages(TextDevice.SList,UseLinesOnPage,LinesOnPage,nil),
                           TextDevice.SList.Count,
                           FLinesOnPage,
                           FFromPage,
                           FToPage,
                           FPrintPagesMode,
                           FESCModelName,
                           FPrinterName,
                           FUseLinesOnPage,
                           FWrapAfterColumn,
                           FMakeFormFeedOnRulon,
                           FLeftSpaces,
                           FPrintRulonMode,
                           FFromLine,
                           FToLine,
                           FPrintPages,
                           FPrintPagesList,
                           FPaperType,
                           FCopies);
if Assigned(OnCloseSetupDialog) then
  OnCloseSetupDialog(Self,Result);
end;

procedure TprTxReport.ClearPreparedReport;
begin
inherited;
TextDevice.Reset;
end;

function TprTxReport.PrepareReport;
begin
TextDevice.Reset;
Result := inherited PrepareReport;
ClearEndPages;
end;

function TprTxReport.PrintPreparedReport;
var
  em : TprESCModel;
begin
Result:=false;
if ShowProgress then
  CreateProgressForm(prLoadStr(sPrintReportCaption),0);
try
  try
    if PrinterName='' then
      begin
        //      ESC    
        PrinterName:=prGetDefaultPrinterName;
        if PrinterName<>'' then
          begin
            // ESC 
            em:=TxGetESCModelForPrinter(PrinterName);
            if em<>nil then
              ESCModelName:=em.ModelName;
          end;
      end;

    Result:=TxPrintStrings(TextDevice.SList,
                           PrinterName,
                           ESCModels.ByModelName[ESCModelName],
                           Title,
                           Copies,
                           WrapAfterColumn,
                           LeftSpaces,
                           PaperType,
                           PrintRulonMode,
                           MakeFormFeedOnRulon,
                           FromLine,
                           ToLine,
                           PrintPagesMode,
                           LinesOnPage,
                           UseLinesOnPage,
                           FPrintPagesList,
                           FromPage,
                           ToPage,
                           false,
                           StartNewLineOnWrap);
  except
    on E : Exception do
      begin
        if E is EActionCanceled then
          FActionCanceled:=true
        else
          raise;
      end;
  end;
finally
  CloseProgressForm;
  if Result and Assigned(OnPrintComplete) then
    OnPrintComplete(Self);
end;
end;

function TprTxReport.GetBandClass;
begin
Result:=TprBandClass(GetClass('TprTx'+Copy(GetEnumName(TypeInfo(TprBandType),integer(BandType)),3,Length(GetEnumName(TypeInfo(TprBandType),integer(BandType))))+'Band'));
end;

procedure TprTxReport.LoadPreparedReport;
begin
inherited;
TextDevice.Reset;
TextDevice.LoadFromStream(Stream);
end;

procedure TprTxReport.AppendPreparedReport;
begin
inherited;
TextDevice.AppendFromStream(Stream);
end;

procedure TprTxReport.SavePreparedReport;
begin
inherited;
TextDevice.SaveToStream(Stream);
end;

function TprTxReport.SetupExportParams;
begin
Result := TprTxExportParamsForm.Create(nil).EditParams(Self);
end;

procedure TprTxReport.ExportToTXT;
var
  i,FromLine,ToLine : integer;
  pl,PagesList : TList;
  pCap : string;
  hFile : THandle;
  ESCModel : TprESCModel;

  procedure ExportLine(const s : string);
  var
    b : string;
    j : TprESCCode;
    i,l : integer;
    BytesWrited : cardinal;
  begin
  l := Length(s);
  i := 1;
  while i<=l do
    begin
      if s[i]=ESCSymbol then
        begin
          Inc(i);
          if ESCModel<>nil then
            begin
              //   ESC 
              j := GetESCCodeByESCSpecifier(s[i]);
              if j<>TprESCCode(-1) then
                b := b+ESCModel.ESCs[j];
            end;
        end
      else
        b := b+s[i];
      Inc(i);
    end;
  if (ExportCodePage=prtxcpWIN1251) and (b<>'') then
    prOEMtoWIN(@(b[1]),@(b[1]));
  b := b+#13#10;
  if not WriteFile(hFile,b[1],Length(b),BytesWrited,nil) or (BytesWrited<>cardinal(Length(b))) then
    raise Exception.CreateFmt(prLoadStr(sExportTXTErrorWriteFile),[SysErrorMessage(GetLastError)]);
  end;
  
  procedure ExportPage(PageIndex : integer);
  var
    i,l : integer;
  begin
  if PageIndex>=PagesList.Count-1 then
    l := TextDevice.SList.Count
  else
    l := integer(PagesList[PageIndex+1]);
  for i:=integer(PagesList[PageIndex]) to l-1 do
    ExportLine(TextDevice.SList[i]);
  end;
begin
if TextDevice.SList.Count<=0 then
  raise Exception.Create(prLoadStr(sReportEmptyInExport));
if preoShowParamsDlg in ExportOptions then
  if not SetupExportParams then
    exit;

hFile := CreateFile(PChar(ExportFileName),
                    GENERIC_WRITE,
                    FILE_SHARE_READ,
                    nil,
                    CREATE_ALWAYS,
                    FILE_ATTRIBUTE_NORMAL,
                    0);
if hFile=INVALID_HANDLE_VALUE then
  raise Exception.CreateFmt(prLoadStr(sExportTXTErrorCreateFile),[SysErrorMessage(GetLastError)]);
ESCModel := nil;
if prtxeoUseESCModel in ExportTxOptions then
  ESCModel := ESCModels.ByModelName[ExportESCModelName];
pl := nil;
PagesList := nil;
if not (prtxeoLinesRange in ExportTxOptions) then
  begin
    if ExportPagesMode=ppmPagesList then
      pl := TList.Create;
    if ExportPagesMode in [ppmPagesList,ppmPagesRange] then
      PagesList := TList.Create;
  end;
try
  if PagesList<>nil then
    ParsePages(TextDevice.SList,false,0,PagesList);
  if pl<>nil then
    TextToPageList(ExportPages,pl);

  if preoShowProgress in ExportOptions then
    begin
      if prtxeoLinesRange in ExportTxOptions then
        i := ExportToLine-ExportFromLine
      else
        if ExportPagesMode=ppmPagesRange then
          i := ExportToPage-ExportFromPage
        else
          if ExportPagesMode=ppmPagesList then
            i := pl.Count
          else
            i := TextDevice.SList.Count;
      CreateProgressForm(Format(prLoadStr(sExportReportCaption),[ExportFileName]),i);
    end;

  if (prtxeoLinesRange in ExportTxOptions) or (ExportPagesMode=ppmAll) then
    begin
      if prtxeoLinesRange in ExportTxOptions then
        begin
          FromLine := ExportFromLine-1;
          ToLine := ExportToLine-1;
        end
      else
        begin
          FromLine := 0;
          ToLine := TextDevice.SList.Count-1;
        end;
      pCap := prLoadStr(sExportReportProgressLines);
      for i:=FromLine to ToLine do
        begin
          UpdateProgressForm(Format(pCap,[i+1,ToLine+1]));
          ExportLine(TextDevice.SList[i]);
        end;
    end
  else
    begin
      pCap := prLoadStr(sExportReportProgress);
      case ExportPagesMode of
        ppmPagesRange:
          for i:=ExportFromPage to ExportToPage do
            begin
              UpdateProgressForm(Format(pCap,[i-ExportFromPage,ExportToPage-ExportFromPage+1]));
              ExportPage(i-1);
            end;
        ppmPagesList:
          for i:=0 to pl.Count-1 do
            begin
              UpdateProgressForm(Format(pCap,[i+1,pl.Count]));
              ExportPage(integer(pl[i])-1);
            end;
      end;
    end;

finally
  CloseHandle(hFile);
  if pl<>nil then
    pl.Free;
  if PagesList<>nil then
    PagesList.Free;
  CloseProgressForm;
end;
end;

initialization

RegisterClass(TprTxHTitleBand);
RegisterClass(TprTxHSummaryBand);
RegisterClass(TprTxHPageHeaderBand);
RegisterClass(TprTxHPageFooterBand);
RegisterClass(TprTxHDetailBand);
RegisterClass(TprTxHDetailHeaderBand);
RegisterClass(TprTxHDetailFooterBand);
RegisterClass(TprTxHGroupHeaderBand);
RegisterClass(TprTxHGroupFooterBand);
RegisterClass(TprTxVTitleBand);
RegisterClass(TprTxVSummaryBand);
RegisterClass(TprTxVPageHeaderBand);
RegisterClass(TprTxVPageFooterBand);
RegisterClass(TprTxVDetailBand);
RegisterClass(TprTxVDetailHeaderBand);
RegisterClass(TprTxVDetailFooterBand);
RegisterClass(TprTxVGroupHeaderBand);
RegisterClass(TprTxVGroupFooterBand);

RegisterClass(TprTxPage);
RegisterClass(TprTxMemoObj);
RegisterClass(TprTxReport);

prRegisterObj(TprTxMemoObj,
              TprTxMemoObjRec,
              TprTxReport,
              sTxMemoObjCaption,
              sTxMemoObjHint,
              'TprTxMemoEditorForm',
              '');

end.

