{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_Properties;

{$i pr.inc}

interface

uses
  Classes, forms,
  {$ifdef PR_D6} DesignIntf, DesignEditors, {$else} dsgnintf, {$endif}
  
  pr_Common, pr_Classes, pr_Designer, pr_TxClasses, pr_MultiLang, pr_MultiLangForm;

type

//
// TprMLResEditor
//
TprMLResEditor = class(TComponentEditor)
public
  procedure Edit; override;
  procedure ExecuteVerb(Index: Integer); override;
  function GetVerb(Index: Integer): String; override;
  function GetVerbCount: Integer; override;
end;

//
// TprCustomReportEditor
//
TprCustomReportEditor = class(TComponentEditor)
public
  procedure Edit; override;
  procedure ExecuteVerb(Index: Integer); override;
  function GetVerb(Index: Integer): String; override;
  function GetVerbCount: Integer; override;
end;

//
// TprValuesProperty
//
TprValuesProperty = class(TPropertyEditor)
public
  function  GetAttributes: TPropertyAttributes; override;
  function  GetValue : string; override;
  procedure Edit; override;
end;

//
// TprPrinterNameProperty
//
TprPrinterNameProperty = class(TPropertyEditor)
public
  function  GetAttributes: TPropertyAttributes; override;
  procedure GetValues(Proc : TGetStrProc); override;
  function  GetValue : string; override;
  procedure SetValue(const Value : string); override;
end;

//
// TprTxPrinterNameProperty
//
TprTxPrinterNameProperty = class(TPropertyEditor)
public
  function  GetAttributes: TPropertyAttributes; override;
  procedure GetValues(Proc : TGetStrProc); override;
  function  GetValue : string; override;
  procedure SetValue(const Value : string); override;
end;

implementation

uses
  pr_ValuesEditor, pr_GroupsEditor, pr_Utils, pr_Strings;

///////////////////////
//
// TprValuesProperty
//
///////////////////////
function TprValuesProperty.GetAttributes;
begin
Result:=[paDialog];
end;

function TprValuesProperty.GetValue;
begin
Result:='(TprValues)';
end;

procedure TprValuesProperty.Edit;
var
  r : TprCustomReport;
begin
r         :=GetComponent(0) as TprCustomReport;
r.Designer:=Designer;
TprValuesEditorForm.Create(nil).EditValues(r);
end;

//////////////////////////////////////
//
// TprPrinterNameProperty
//
//////////////////////////////////////
function TprPrinterNameProperty.GetAttributes;
begin
Result:=[paValueList,paRevertable];
end;

procedure TprPrinterNameProperty.GetValues;
var
  i : integer;
  Report : TprReport;
begin
Report:=TprReport(GetComponent(0));
for i:=0 to Report.prPrinter.Printers.Count-1 do
  Proc(Report.prPrinter.Printers[i]);
end;

function TprPrinterNameProperty.GetValue;
begin
Result:=GetStrValue;
end;

procedure TprPrinterNameProperty.SetValue;
begin
SetStrValue(Value)
end;

//////////////////////////////////////
//
// TprTxPrinterNameProperty
//
//////////////////////////////////////
function TprTxPrinterNameProperty.GetAttributes;
begin
Result:=[paValueList,paRevertable];
end;

procedure TprTxPrinterNameProperty.GetValues;
var
  i : integer;
  L : TStringList;
begin
L := TStringList.Create;
try
  UpdatePrintersList(L,'');
  for i:=0 to L.Count-1 do
    Proc(L[i]);
finally
  L.Free;
end;
end;

function TprTxPrinterNameProperty.GetValue;
begin
Result:=GetStrValue;
end;

procedure TprTxPrinterNameProperty.SetValue;
begin
SetStrValue(Value)
end;

//////////////////////
//
// TprCustomReportEditor
//
//////////////////////
procedure TprCustomReportEditor.Edit;
var
  r : TprCustomReport;
begin
r := Component as TprCustomReport;
r.Designer := Designer;
r.DesignReport({$IFDEF PR_D6}false{$ELSE}true{$ENDIF});
end;

procedure TprCustomReportEditor.ExecuteVerb(Index: Integer);
var
  r : TprCustomReport;
begin
r := Component as TprCustomReport;
r.Designer := Designer;
case Index of
  0: Edit;
  1: TprValuesEditorForm.Create(nil).EditValues(r);
  2: TprGroupsEditorForm.Create(nil).EditGroups(r);
end;
end;

function TprCustomReportEditor.GetVerbCount: Integer;
begin
  Result := 3;
end;

function TprCustomReportEditor.GetVerb(Index: Integer): String;
begin
  case Index of
    0  : Result := prLoadStr(sPropertiesEditTemplate);
    1  : Result := prLoadStr(sPropertiesEditVars);
    2  : Result := prLoadStr(sPropertiesEditGroups);
    else Result := '';
  end;
end;

//////////////////////
//
// TprMLResEditor
//
//////////////////////
procedure TprMLResEditor.Edit;
begin
TprMultiLangForm.Create(nil).EditRes(Component as TprMLRes,Component.Owner as TForm);
end;

procedure TprMLResEditor.ExecuteVerb(Index: Integer);
begin
  case Index of
    0: Edit;
  end;
end;

function TprMLResEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

function TprMLResEditor.GetVerb(Index: Integer): String;
begin
  case Index of
    0  : Result := 'Edit StringID table';
    else Result := '';
  end;
end;

procedure TemplateChangedGlobalProc(Report : TprCustomReport);
begin
if Assigned(Report.Designer) then
  (Report.Designer as {$ifdef PR_D6} IDesigner{$else}IFormDesigner{$endif}).Modified;
end;

initialization

prTemplateChangedGlobalProc:=TemplateChangedGlobalProc;

finalization

prTemplateChangedGlobalProc:=nil;

end.

