{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_Preview;

interface     

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ImgList, ActnList, StdCtrls, ToolWin, ComCtrls,
  flatsb, clipbrd, inifiles, menus, typinfo,

  pr_Common, pr_Classes, Pr_Utils, pr_MultiLang, pr_DesignerFunctions,
  pr_FontComboBox, pr_ColorButton;

const
  PagesStepX = 5;
  PagesStepY = 5;

  LeftOffs = 10;
  TopOffs = 10;
  RightOffs = 10;
  BottomOffs = 10;

  crPreviewNormalCursor = 1;
  crPreviewScrollCursor = 2;

type
  TprScaleMode = (smPageWidth,smOnePagePercent,smPages);
  TprPreviewAction = (prpaPrint,
                      prpaCut,
                      prpaCopy,
                      prpaPaste,
                      prpaDelete,
                      prpaFind,
                      prpaFindNext,
                      prpaFindPrev,
                      prpaFindCancel,
                      prpaBringToFront,
                      prpaSendToBack,
                      prpaProperties,
                      prpaWholePage,
                      prpaPages,
                      prpaTwoPages,
                      prpaPageWidth,
                      prpaShowGrid,
                      prpaAlignToGrid,
                      prpaGridSize,
                      prpaNewPage,
                      prpaDelPage,
                      prpaPageParams);
  ////////////////////////
  //
  // TprPrevewBox
  //
  ////////////////////////
  TprPreviewBox = class(TScrollBox)
  private
    FScrollLastX : integer;
    FScrollLastY : integer;

    FMaxWidth : integer;
    FMaxHeight : integer;
    FScaleMul : integer;
    FScaleDiv : integer;
    FFindPos : integer;

    FPagesPerHeight : integer;
    FPagesPerWidth : integer;
    FScaleMode : TprScaleMode;
    FScalePercent : integer;
    FOldScaleKoef : double;

    DrawWidth : integer;   //     
    DrawHeight : integer;   //     

    FLastHighlightedObject : TprExObjRecVersion;
    FLastHighlightedEndPage : TprEndPage;

    FFirstMoveAfterDown : boolean;
    FDblClick : boolean;
    FSelObjs : TList;
    FUseGrid : boolean;
    FShowGrid : boolean;
    FGridSize : integer;
    FMouseMode : TprMouseMode;
    FResizeObj : TprExObjRecVersion;
    FResizeMode : TprResizeType;
    FLastX : integer;
    FLastY : integer;
    FStartX : integer;
    FStartY : integer;
    FStartRealX : integer;
    FStartRealY : integer;
    FDownObj : TprExObjRecVersion;
    FDownPointInfo : TprPointInfo;
    FDownResizeMode : TprResizeType;
    FDragObj : TprExObjRecVersion;
    FCurClassRef : TprObjVersionClass;
    FCurPage : TprEndPage;

    FFindDialog : TFindDialog;
    FGridBitmap : HBITMAP;

    FOnScalePercentChanged : TNotifyEvent;
    FOnSelectionChanged : TNotifyEvent;
    FOnObjectsPropsChanged : TNotifyEvent;
    
    procedure SetPagesPerHeight(Value : integer);
    procedure SetPagesPerWidth(value : integer);
    procedure SetScaleMode(Value : TprScaleMode);
    procedure SetScalePercent(Value : integer);
    function GetScaleKoef : integer;
    function GetFindedCount : integer;
    function GetIsFindMode : boolean;
    function GetCaseSensitive : boolean;
    procedure SetCaseSensitive(Value : boolean);
    function GetFindText : string;
    procedure SetFindText(Value : string);
    procedure SetProgressBar(Value : TProgressBar);
    function GetProgressBar : TProgressBar;
    procedure SetStatusBar(Value : TStatusBar);
    function GetStatusBar : TStatusBar;
    procedure SetShowGrid(Value : boolean);
    procedure SetGridSize(Value : integer);
    procedure SetCurPage(Value : TprEndPage);
    function GetCurPageIndex : integer;
    procedure DrawPageRect(DC : HDC; ep : TprEndPage; Selected : boolean);

    procedure CalcMaxSizes;
    procedure ClearFindList;

    procedure SetRPDI;
    procedure ResetRPDI;

    procedure InternalCalcPagesSizes;
    function  InternalFind : boolean;
    procedure InvertObject(DC : HDC; ep : TprEndPage; v : TprExObjRecVersion);

    procedure DoObjectsDraggedSizes;
    procedure DoSelectionChanged;
    procedure DoObjectsPropsChanged;
    procedure DoDragOrResize(v : TprExObjRecVersion; oTop,oLeft,oBottom,oRight : integer; prps : pPrPaintStruct);
    procedure GetPointInfoAt(x,y : integer;
                             var Obj : TprExObjRecVersion;
                             var EndPage : TprEndPage;
                             var PointInfo  : TprPointInfo;
                             var ResizeMode : TprResizeType);
    procedure DrawAnime(DC : HDC; x,y,lastx,lasty : integer);
    procedure DrawSelectedObjects(DC : HDC);
    function AllowDragObj(v : TprExObjRecVersion) : boolean;
    function AllowResizeObj(v : TprExObjRecVersion) : boolean;
    function GetSelObj(i : integer) : TprExObjRecVersion;
    function GetSelObjsCount : integer;
    function GetSSR(i : integer) : TRect;
    function GetObjPage(v : TprExObjRecVersion) : TprEndPage;
    function GetObjScreenRect(v : TprExObjRecVersion) : TRect;
    function GetPageScreenRect(ep : TprEndPage) : TRect;
    procedure SelectObj(v : TprExObjRecVersion);
    procedure DeselectObj(v : TprExObjRecVersion);
    procedure ClearSelected;
    procedure UpdateInternalDataSelectedObjects;
    procedure _BeginPaint(var prps : rPrPaintStruct);
    procedure _EndPaint(const prps : rPrPaintStruct);
    procedure InternalPaint(DC : HDC; Rgn : HRGN);
    procedure FindDialogFind(Sender : TObject);
    procedure PagesChanged;
  protected
    procedure Resize; override;
    procedure mPaint(var Message : TWMPaint); message WM_PAINT;
    procedure mVScroll(var Message: TWMVScroll); message WM_VSCROLL;
    procedure mHScroll(var Message: TWMHScroll); message WM_HSCROLL;
    procedure mKeyDown(var Message : TWMKeyDown); message WM_KEYDOWN;
    procedure mGetDlgCode(var Message : TWMGetDlgCode); message WM_GETDLGCODE;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure DblClick; override;
  public
    Report : TprReport;
    rpdi : rPrPreviewDrawInfo;
    ObjectsPropsForm : TForm;

    property SelObjs[i : integer] : TprExObjRecVersion read GetSelObj;
    property SelObjsCount : integer read GetSelObjsCount;
    property SSR[i : integer] : TRect read GetSSR;
    property SelObjsList : TList read FSelObjs;

    property PagesPerHeight : integer read FPagesPerHeight write SetPagesPerHeight; //   
    property PagesPerWidth : integer read FPagesPerWidth write SetPagesPerWidth;  //   
    property ScaleMode : TprScaleMode read FScaleMode write SetScaleMode;
    property ScalePercent : integer read FScalePercent write SetScalePercent;    //  (   )
    property ScaleKoef : integer read GetScaleKoef;
    property CaseSensitive : boolean read GetCaseSensitive write SetCaseSensitive;
    property FindText : string read GetFindText write SetFindText;
    property FindedCount : integer read GetFindedCount;
    property IsFindMode : boolean read GetIsFindMode;

    property UseGrid : boolean read FUseGrid write FUseGrid;
    property ShowGrid : boolean read FShowGrid write SetShowGrid;
    property GridSize : integer read FGridSize write SetGridSize;
    property StatusBar : TStatusBar read GetStatusBar write SetStatusBar;
    property ProgressBar : TProgressBar read GetProgressBar write SetProgressBar;

    property CurPage : TprEndPage read FCurPage write SetCurPage;
    property CurPageIndex : integer read GetCurPageIndex;

    procedure Find;
    procedure CancelFind;
    procedure FindNext;
    procedure FindPrior;

    procedure WholePage;
    procedure PageWidth;
    procedure ManyPages(PerHeight,PerWidth : integer);

    procedure Print;
    procedure LoadPreparedReport(const FileName : string);

    // editor methods
    procedure DeleteSelectedObjects;
    procedure CopySelectedObjectsToClipboard;
    procedure CutSelectedObjectsToClipboard;
    procedure PasteObjectsFromClipboard;

    procedure AddPage(BeforePageIndex : integer); // AfterPageIndex = -1 insert in top of report 
    procedure DelPage(PageIndex : integer);
    procedure PageParams(PageIndex : integer);

    function IsObjectsPropsFormVisible : boolean;
    procedure UpdateSelectedObjects;
    procedure PropsOfSelectedObjectsChanged;

    procedure BringToFront;
    procedure SendToBack;

    procedure AlignAction(ActionCode : TprAlignActionCode);
    procedure Nudge(dx,dy : integer);
    procedure Size(sx,sy : integer);
    procedure SetPosSizeProp(Prop : TprObjectPosSizeProps; PropValue : integer);
    procedure InsertObj(ObjClassRef : TprObjClass);
    function AllowAction(ActionCode : TprPreviewAction) : boolean;
    procedure ProcessAction(ActionCode : TprPreviewAction);

    procedure UpdateSettings;

    constructor CreatePreview(AOwner : TComponent; _Report : TprReport);
    destructor Destroy; override;

    property OnScalePercentChanged : TNotifyEvent read FOnScalePercentChanged write FOnScalePercentChanged;
    property OnSelectionChanged : TNotifyEvent read FOnSelectionChanged write FOnSelectionChanged;
    property OnObjectsPropsChanged : TNotifyEvent read FOnObjectsPropsChanged write FOnObjectsPropsChanged;  
  end;

  //////////////////////////
  //
  // TprPreviewForm
  //
  //////////////////////////
  TprPreviewForm = class(TprPreview)
    ActionList: TActionList;
    ImageList: TImageList;
    aPrint: TAction;
    aWholePage: TAction;
    aPages: TAction;
    aClose: TAction;
    aPageWidth: TAction;
    aTwoPages: TAction;
    aFind: TAction;
    aFindNext: TAction;
    aFindPrev: TAction;
    aFindCancel: TAction;
    aSave: TAction;
    aOpen: TAction;
    SaveDialog: TSaveDialog;
    OpenDialog: TOpenDialog;
    SB: TStatusBar;
    aCustomAction: TAction;
    prMLRes1: TprMLRes;
    aExportToXLS: TAction;
    MainMenu: TMainMenu;
    TEST1: TMenuItem;
    SUBTEST1: TMenuItem;
    ControlBar1: TControlBar;
    tbPreviewCommon: TToolBar;
    ToolButton1: TToolButton;
    ToolButton16: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton17: TToolButton;
    ToolButton18: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    EDScale: TEdit;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    tbText: TToolBar;
    CBFontSize: TComboBox;
    bBold: TToolButton;
    bItalic: TToolButton;
    bUnderline: TToolButton;
    ToolButton20: TToolButton;
    bFontColor: TToolButton;
    bFillColor: TToolButton;
    ToolButton23: TToolButton;
    bHLeft: TToolButton;
    bHCenter: TToolButton;
    bHRight: TToolButton;
    ToolButton27: TToolButton;
    bVTop: TToolButton;
    bVCenter: TToolButton;
    bVBottom: TToolButton;
    tbBorders: TToolBar;
    bbTop: TToolButton;
    bbLeft: TToolButton;
    bbBottom: TToolButton;
    bbRight: TToolButton;
    ToolButton35: TToolButton;
    bbAll: TToolButton;
    bbNone: TToolButton;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    Excel1: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    N9: TMenuItem;
    N10: TMenuItem;
    N11: TMenuItem;
    mToolbars: TMenuItem;
    N13: TMenuItem;
    N14: TMenuItem;
    N15: TMenuItem;
    N16: TMenuItem;
    N17: TMenuItem;
    CBFontName: TprFontComboBox;
    AlignActionList: TActionList;
    aHToLeft: TAction;
    aHCenterInWindow: TAction;
    aHCenters: TAction;
    aHSpaceEqually: TAction;
    aHToRight: TAction;
    aVToTop: TAction;
    aVCenterInWindow: TAction;
    aVCenters: TAction;
    aVSpaceEqually: TAction;
    aVToBottom: TAction;
    aOLeft: TAction;
    aORight: TAction;
    aOTop: TAction;
    aOBottom: TAction;
    aSLeft: TAction;
    aSRight: TAction;
    aSTop: TAction;
    aSBottom: TAction;
    aWToSmall: TAction;
    aWToLarge: TAction;
    aHToSmall: TAction;
    aHToLarge: TAction;
    aAlignToGridLeftTop: TAction;
    aAlignToGridAll: TAction;
    tbAlign: TToolBar;
    ToolButton19: TToolButton;
    ToolButton21: TToolButton;
    ToolButton22: TToolButton;
    ToolButton24: TToolButton;
    ToolButton25: TToolButton;
    ToolButton26: TToolButton;
    ToolButton28: TToolButton;
    ToolButton29: TToolButton;
    ToolButton30: TToolButton;
    ToolButton31: TToolButton;
    ToolButton32: TToolButton;
    tbSize: TToolBar;
    ToolButton33: TToolButton;
    ToolButton34: TToolButton;
    ToolButton36: TToolButton;
    ToolButton37: TToolButton;
    ToolButton38: TToolButton;
    ToolButton39: TToolButton;
    ToolButton40: TToolButton;
    ToolButton41: TToolButton;
    ToolButton42: TToolButton;
    tbNudge: TToolBar;
    ToolButton43: TToolButton;
    ToolButton44: TToolButton;
    ToolButton45: TToolButton;
    ToolButton46: TToolButton;
    aCut: TAction;
    aCopy: TAction;
    aPaste: TAction;
    aDelete: TAction;
    aBringToFront: TAction;
    aSendToBack: TAction;
    N12: TMenuItem;
    Custom1: TMenuItem;
    aCopy1: TMenuItem;
    aPaste1: TMenuItem;
    N18: TMenuItem;
    aDelete1: TMenuItem;
    N19: TMenuItem;
    aBringToFront1: TMenuItem;
    aSendToBack1: TMenuItem;
    N20: TMenuItem;
    aProperties: TAction;
    aProperties1: TMenuItem;
    N21: TMenuItem;
    aShowGrid: TAction;
    aAlignToGrid: TAction;
    aGridSize: TAction;
    N22: TMenuItem;
    aShowGrid1: TMenuItem;
    aAlignToGrid1: TMenuItem;
    aGridSize1: TMenuItem;
    Page1: TMenuItem;
    aNewPage: TAction;
    aDelPage: TAction;
    aPageParams: TAction;
    aNewPage1: TMenuItem;
    aDelPage1: TMenuItem;
    aPageParams1: TMenuItem;
    tbObject: TToolBar;
    ToolButton47: TToolButton;
    ToolButton48: TToolButton;
    ToolButton49: TToolButton;
    ToolButton50: TToolButton;
    ToolButton51: TToolButton;
    ToolButton52: TToolButton;
    ToolButton53: TToolButton;
    ToolButton54: TToolButton;
    aPreviewEdit: TAction;
    Custom2: TMenuItem;
    N23: TMenuItem;
    aPreviewEdit1: TMenuItem;
    ToolButton55: TToolButton;
    ToolButton56: TToolButton;
    tbObjects: TToolBar;
    bObjArrow: TToolButton;
    ToolButton57: TToolButton;
    PMPreview: TPopupMenu;
    aCut1: TMenuItem;
    aCopy2: TMenuItem;
    aPaste2: TMenuItem;
    N24: TMenuItem;
    aAlignToGridLeftTop1: TMenuItem;
    aAlignToGridAll1: TMenuItem;
    N25: TMenuItem;
    aProperties2: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure aCloseExecute(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure EDScaleKeyPress(Sender: TObject; var Key: Char);
    procedure aSaveExecute(Sender: TObject);
    procedure aOpenExecute(Sender: TObject);
    procedure SBDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
    procedure aCustomActionUpdate(Sender: TObject);
    procedure aCustomActionExecute(Sender: TObject);
    procedure aExportToXLSUpdate(Sender: TObject);
    procedure aExportToXLSExecute(Sender: TObject);
    procedure CBFontNameClick(Sender: TObject);
    procedure CBFontSizeChange(Sender: TObject);
    procedure bBoldClick(Sender: TObject);
    procedure bFontColorClick(Sender: TObject);
    procedure bHLeftClick(Sender: TObject);
    procedure bVTopClick(Sender: TObject);
    procedure bbTopClick(Sender: TObject);
    procedure bbAllClick(Sender: TObject);
    procedure aHToLeftUpdate(Sender: TObject);
    procedure aHToLeftExecute(Sender: TObject);
    procedure aSLeftExecute(Sender: TObject);
    procedure aOLeftExecute(Sender: TObject);
    procedure aPrintExecute(Sender: TObject);
    procedure aPrintUpdate(Sender: TObject);
    procedure mToolbarsClick(Sender: TObject);
    procedure aNewPageExecute(Sender: TObject);
    procedure aDelPageExecute(Sender: TObject);
    procedure aPreviewEditExecute(Sender: TObject);
    procedure aPreviewEditUpdate(Sender: TObject);
    procedure aPageParamsExecute(Sender: TObject);
  private
    { Private declarations }
    Preview : TprPreviewBox;
    FUpdated : boolean;
    FPreviewChanged : boolean;
    FOtherColor : TColor;
    FFontColor : TColor;
    FFillColor : TColor;
    FPaletteForm : TprColorPaletteForm;

    procedure SetPreviewChanged(Value : boolean);
    procedure OnObjButtonClick(Sender : TObject);
    procedure ScaleChanged(Sender : TObject);
    procedure UpdateToolbar;
    procedure SelectionChanged(Sender : TObject);
    procedure ObjectsPropsChanged(Sender : TObject);
    procedure SetPopupColor(IsFillColor : boolean; Color: TColor);
    procedure FontColorSetColor(Sender: TObject; Color: TColor);
    procedure FillColorSetColor(Sender: TObject; Color: TColor);
    procedure WMGetDlgCode(var Message : TWMGetDlgCode); message WM_GETDLGCODE;
    function GetToolbar(t : TprPreviewToolbars) : TToolBar;

    procedure UpdateStatusBar;
    procedure InitForm;
    procedure InitmToolbars;

    procedure ToolBarMenuItemClick(Sender : TObject);
    procedure ControlBar1BandInfo(Sender: TObject; Control: TControl;
      var Insets: TRect; var PreferredSize, RowCount: Integer);
  protected
    procedure prRestoreProperties(Ini : TIniFile; sn : string); override;
    procedure prSaveProperties(Ini : TIniFile; sn : string); override;
  public
    { Public declarations }
    property PreviewChanged : boolean read FPReviewChanged write SetPreviewChanged;
  end;

implementation

uses
  pr_Strings, pr_PreviewObjectsProps, pr_GridSize, pr_PageParams;

var
  FNormalCursor,FScrollCursor : TCursor;

{$R *.DFM}

////////////////////////
//
// TprPreviewBox
//
////////////////////////
constructor TprPreviewBox.CreatePreview;
begin
Report := _Report;

rpdi.FindList := TList.Create;
FScaleMode := smPageWidth;
FScalePercent := 100;
FPagesPerHeight := 1;
FPagesPerWidth := 1;
CalcMaxSizes;
SetRPDI;
FGridBitmap := 0;
GridSize := 4;

FSelObjs := TList.Create;

inherited Create(AOwner);
HorzScrollBar.Tracking := true;
VertScrollBar.Tracking := true;
TabStop := true;
Cursor := FNormalCursor;

ObjectsPropsForm := TprPreviewObjectsPropsForm.Create(Self);
FFindDialog := TFindDialog.Create(Self);
FFindDialog.Options := [frDown,frFindNext,frHideWholeWord,frDisableWholeWord];
FFindDialog.OnFind := FindDialogFind;
end;

destructor TprPreviewBox.Destroy;
begin
if FGridBitmap<>0 then
  DeleteObject(FGridBitmap);
  
ResetRPDI;
ClearFindList;
rpdi.FindList.Free;
FSelObjs.Free;
inherited;
end;

procedure TprPreviewBox.SetRPDI;
var
  i : integer;
begin
for i:=0 to Report.EndPagesCount-1 do
  TprEndPage(Report.EndPages[i]).rdi.ppdi:=@rpdi;
end;

procedure TprPreviewBox.ResetRPDI;
var
  i : integer;
begin
for i:=0 to Report.EndPagesCount-1 do
  TprEndPage(Report.EndPages[i]).rdi.ppdi := nil;
end;

procedure TprPreviewBox.mGetDlgCode;
begin
inherited;
Message.Result := Message.Result or DLGC_WANTARROWS;
end;

procedure TprPreviewBox.DoObjectsDraggedSizes;
begin
end;

procedure TprPreviewBox.DoSelectionChanged;
begin
if ObjectsPropsForm<>nil then
  TprPreviewObjectsPropsForm(ObjectsPropsForm).SelectionChanged;
if Assigned(OnSelectionChanged) then
  OnSelectionChanged(Self);
end;

procedure TprPreviewBox.DoObjectsPropsChanged;
begin
if Assigned(OnObjectsPropsChanged) then
  OnObjectsPropsChanged(Self);
end;

procedure TprPreviewBox.DoDragOrResize;
var
  r : TRect;
  i : integer;
  ep,ep2 : TprEndPage;
begin
if ((oLeft=oRight) and (oTop=oBottom) and not AllowDragObj(v)) or
    (not AllowResizeObj(v)) then exit;
    
ep2 := GetObjPage(v);
r.Left := v.RealRect.Left+oLeft+ep2.rdi.bRect.Left;
r.Right := v.RealRect.Right+oRight+ep2.rdi.bRect.Left;
r.Top := v.RealRect.Top+oTop+ep2.rdi.bRect.Top;
r.Bottom := v.RealRect.Bottom+oBottom+ep2.rdi.bRect.Top;
// detect page in wich object must placed
i := 0;
ep := nil;
while i<Report.EndPagesCount do
  begin
    ep := TprEndPage(Report.EndPages[i]);
    if RectInRect(r,ep.rdi.bRect) then
      break;
    Inc(i);
  end;
if i>=Report.EndPagesCount then exit;
if prps<>nil then
  AddRectToRegion(prps.ClipRgn,GetObjScreenRect(v));
// ep - new page
// ep2 - current page
if ep2=ep then
  begin
    v.RealRect.Left := v.RealRect.Left+oLeft;
    v.RealRect.Right := v.RealRect.Right+oRight;
    v.RealRect.Top := v.RealRect.Top+oTop;
    v.RealRect.Bottom := v.RealRect.Bottom+oBottom;
  end
else
  begin
    // move object from one page to other
    ep2.VL.Remove(v);
    ep.VL.Add(v);
    v.RealRect.Left := v.RealRect.Left+oLeft-ep.rdi.bRect.Left+ep2.rdi.bRect.Left;
    v.RealRect.Right := v.RealRect.Right+oRight-ep.rdi.bRect.Left+ep2.rdi.bRect.Left;
    v.RealRect.Top := v.RealRect.Top+oTop-ep.rdi.bRect.Top+ep2.rdi.bRect.Top;
    v.RealRect.Bottom := v.RealRect.Bottom+oBottom-ep.rdi.bRect.Top+ep2.rdi.bRect.Top;
  end;
with ep.rdi do
  v.GeneratedRect := MulDivRect(v.RealRect,xdiv,xmul,ydiv,ymul);
if prps<>nil then
  AddRectToRegion(prps.ClipRgn,GetObjScreenRect(v));
end;

function TprPreviewBox.GetSelObj;
begin
Result := TprExObjRecVersion(FSelObjs[i]);
end;

function TprPreviewBox.GetSelObjsCount;
begin
Result := FSelObjs.Count;
end;

function TprPreviewBox.GetSSR;
begin
Result := GetObjScreenRect(SelObjs[i]);
end;

function TprPreviewBox.AllowDragObj;
begin
Result := true;
end;

function TprPreviewBox.AllowResizeObj;
begin
Result := true;
end;

function TprPreviewBox.GetPageScreenRect;
begin
Result := Rect(ep.rdi.bRect.Left-HorzScrollBar.Position,
               ep.rdi.bRect.Top-VertScrollBar.Position,
               ep.rdi.bRect.Right-HorzScrollBar.Position,
               ep.rdi.bRect.Bottom-VertScrollBar.Position);
end;

function TprPreviewBox.GetObjPage;
var
  i : integer;
begin
for i:=0 to Report.EndPagesCount-1 do
  if TprEndPage(Report.EndPages[i]).VL.IndexOf(v)<>-1 then
    begin
      Result := TprEndPage(Report.EndPages[i]);
      exit;
    end;
Result := nil;
end;

function TprPreviewBox.GetObjScreenRect;
var
  r : TRect;
  ep : TprEndPage;
begin
Result := v.RealRect;
ep := GetObjPage(v);
if ep<>nil then
  begin
    r := GetPageScreenRect(ep);
    Result.Left := Result.Left+r.Left;
    Result.Top := Result.Top+r.Top;
    Result.Right := Result.Right+r.Left;
    Result.Bottom := Result.Bottom+r.Top;
  end;
end;

procedure TprPreviewBox.GetPointInfoAt;
var
  i,j : integer;

  function AnalysObject(v : TprExObjRecVersion) : boolean;
  var
    r : TRect;
  begin
  Result := true;
  r := GetObjScreenRect(v);

  if AllowResizeObj(v) and GetResizeType(X,Y,r,ResizeMode) then
    begin
      PointInfo := piRegionResize;
      exit;
    end;

  if PointInRect(X,Y,r) then
    begin
      // mouse over object
      PointInfo := piRegionInside;
      exit;
    end;
  Result := false;
  end;

begin
// check selected objects
for i:=0 to FSelObjs.Count-1 do
  begin
    Obj := SelObjs[i];
    if AnalysObject(Obj) then
      begin
        EndPage := GetObjPage(Obj);
        exit;
      end;
  end;

for i:=0 to Report.EndPagesCount-1 do
  begin
    EndPage := TprEndPage(Report.EndPages[i]);
    if PointInRect(X,Y,GetPageScreenRect(EndPage)) then
      begin
        // page visible on screen and mouse over page
        // check all page objects
        for j:=EndPage.vl.Count-1 downto 0 do
          begin
            Obj := TprExObjRecVersion(EndPage.vl[j]);
            if AnalysObject(Obj) then
              exit;
          end;
        Obj := nil;
        exit;
      end;
  end;
Obj := nil;
EndPage := nil;
end;

procedure TprPreviewBox.DrawAnime;
var
  r : TRect;
  npn,opn : HPEN;
  pmm,oBottom,oLeft,oTop,oRight : integer;
  procedure DrawObjectsOffs(dx,dy : integer);
  var
    i : integer;
    r : TRect;
  begin
  for i:=0 to FSelObjs.Count-1 do
    if AllowDragObj(SelObjs[i]) then
      begin
        r := GetObjScreenRect(SelObjs[i]);
        r.Left := r.Left+dx;
        r.Top := r.Top+dy;
        r.Right := r.Right+dx;
        r.Bottom := r.Bottom+dy;
        DrawRect(DC,r);
      end;
  end;
begin
case FMouseMode of
  mmInsertObj:
    begin
      //   
      if (FStartX<>LastX) or (FStartY<>LastY) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,LastX,LastY));
      if (FStartX<>X) or (FStartY<>Y) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,X,Y));
    end;
  mmSelect:
    begin
      //   
      if (FStartX<>LastX) or (FStartY<>LastY) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,LastX,LastY));
      if (FStartX<>X) or (FStartY<>Y) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,X,Y));
    end;
  mmSelectedRegionsDrag:
    begin
      //    (   )
      pmm := SetROP2(DC,R2_NOT);
      npn := CreatePen(PS_SOLID,1,clBlack);
      opn := SelectObject(DC,npn);

      if (FStartX<>LastX) or (FStartY<>LastY) then
        DrawObjectsOffs(LastX-FStartX,LastY-FStartY);
      if (FStartX<>X) or (FStartY<>Y) then
        DrawObjectsOffs(X-FStartX,Y-FStartY);

      SelectObject(DC,opn);
      DeleteObject(npn);
      SetROP2(DC,pmm);

      DoObjectsDraggedSizes;
    end;
  mmRegionResize:
    begin
      //    FResizeRegion
      r := GetObjScreenRect(FResizeObj);
      if (FStartX<>LastX) or (FStartY<>LastY) then
        begin
          CalcOffs(LastX-FStartX,LastY-FStartY,FResizeMode,oTop,oLeft,oBottom,oRight);
          DrawFocusRect(DC,
                        Rect(r.Left+oLeft,
                             r.Top+oTop,
                             r.Right+oRight,
                             r.Bottom+oBottom));
        end;
      if (FStartX<>X) or (FStartY<>Y) then
        begin
          CalcOffs(X-FStartX,Y-FStartY,FResizeMode,oTop,oLeft,oBottom,oRight);
          DrawFocusRect(DC,
                        Rect(r.Left+oLeft,
                             r.Top+oTop,
                             r.Right+oRight,
                             r.Bottom+oBottom));
          DoObjectsDraggedSizes;
        end;
    end;
  mmSelectedResize:
    begin
{
      //      (FSelectedRect)
      if not ((FStartX=LastX) and (FStartY=LastY)) then
        begin
          dx:=LastX-FStartX;
          dy:=LastY-FStartY;
          CalcOffs(dx,dy,ppRightBottom,oTop,oLeft,oBottom,oRight);
          DrawFocusRect(DC,
                        Rect(FSelectedRect.Left+oLeft,
                             FSelectedRect.Top+oTop,
                             FSelectedRect.Right+oRight,
                             FSelectedRect.Bottom+oBottom));
        end;
      LastX:=X;
      LastY:=Y;
      dx:=LastX-FStartX;
      dy:=LastY-FStartY;
      CalcOffs(dx,dy,ppRightBottom,oTop,oLeft,oBottom,oRight);
      DrawFocusRect(DC,
                    Rect(FSelectedRect.Left+oLeft,
                         FSelectedRect.Top+oTop,
                         FSelectedRect.Right+oRight,
                         FSelectedRect.Bottom+oBottom));
}
    end;
end;
end;

procedure TprPreviewBox.DrawSelectedObjects;
var
  i : integer;
  pmm : integer;
  npn,opn : HPEN;
begin
if FSelObjs.Count>1 then
  npn := CreatePen(PS_SOLID,SelectPointSize,clWhite)
else
  npn := CreatePen(PS_SOLID,SelectPointSize,clWhite);
pmm := SetROP2(DC,R2_XORPEN);
opn := SelectObject(DC,npn);

for i:=0 to FSelObjs.Count-1 do
  DrawSelectedObject(DC,GetObjScreenRect(SelObjs[i]),[ppLeftTop,ppTop,ppRightTop,ppRight,ppRightBottom,ppBottom,ppLeftBottom,ppLeft]);

SetROP2(DC,pmm);
SelectObject(DC,opn);
DeleteObject(npn);
end;

procedure TprPreviewBox.ClearSelected;
begin
FSelObjs.Clear;
end;

procedure TprPreviewBox.SelectObj;
begin
if FSelObjs.IndexOf(v)=-1 then
  FSelObjs.Add(v);
end;

procedure TprPreviewBox.DeselectObj;
begin
FSelObjs.Remove(v);
end;

procedure TprPreviewBox.MouseDown;
label
  lFin;
var
  ep : TprEndPage;
  DC : HDC;
  FDownSelected : boolean;
  PreviewUserData : TprPreviewUserData;

  function AnySelectedRegionCanDrag : boolean;
  var
    i : integer;
  begin
  i := 0;
  while (i<FSelObjs.Count) and not AllowDragObj(SelObjs[i]) do Inc(i);
  Result := i<FSelObjs.Count;
  end;

begin
inherited;
GetPointInfoAt(X,Y,FDownObj,ep,FDownPointInfo,FDownResizeMode);
PreviewUserData := nil;
if FDownObj<>nil then
  PreviewUserData := FDownObj.PreviewUserData;
Report.DoOnPreviewMouseDown(PreviewUserData,Shift);

if ((ssLeft in Shift) and (not Report.CanUserEdit)) or
   (([ssLeft,ssCtrl]*Shift=[ssLeft,ssCtrl]) and Report.CanUserEdit) then
  begin
    Cursor := FScrollCursor;
    SetCursor(Screen.Cursors[FScrollCursor]);
    FScrollLastX := X;
    FScrollLastY := Y;
    exit;
  end;

//////////////////
// Now - Designer
//////////////////
if not Report.CanUserEdit then exit;

CurPage := ep;

if FDblClick then
  begin
    // DblClick
    FDblClick := false;
    exit;
  end;

if [ssLeft,ssRight]*Shift=[] then exit; // left mouse button or right mouse button not pressed

// starting mouse coord`s
if UseGrid then
  begin
    FLastX := ATG(X,GridSize);
    FLastY := ATG(Y,GridSize);
  end
else
  begin
    FLastX := X;
    FLastY := Y;
  end;
FStartX := FLastX;
FStartY := FLastY;
FStartRealX := X;
FStartRealY := Y;
FFirstMoveAfterDown := true;
FDownSelected := FSelObjs.IndexOf(FDownObj)<>-1;
DC := GetDC(Handle);
try
  // clear current selection
  DrawSelectedObjects(DC);
  if FCurClassRef<>nil then
    begin
      // mode - inserting object
      FMouseMode := mmInsertObj;
      goto lFin;
    end;
  if ssRight in Shift then
    begin
      // Right mouse button pressed
      if FDownObj<>nil then
        begin
          if ssShift in Shift then
            begin
              if not FDownSelected then
                SelectObj(FDownObj);
            end
          else
            begin
              ClearSelected;
              SelectObj(FDownObj);
            end
        end;
      FMouseMode := mmNone;
      DrawSelectedObjects(DC);
      DoSelectionChanged;
      exit;
    end;

  // left mouse button pressed
  if FDownObj=nil then
    begin
      ClearSelected;
      FMouseMode := mmSelect;
      goto lFin;
    end;

  // v<>nil
  if ssShift in Shift then
    begin
      // this is selection always
      if FDownSelected then
        DeSelectObj(FDownObj)
      else
        SelectObj(FDownObj);
      FMouseMode := mmNone;
      DrawSelectedObjects(DC);
      DoSelectionChanged;
      exit;
    end;

  if FDownSelected then
    begin
      if FSelObjs.Count=1 then
        begin
          // one object selected, may be : resize, drag
          case FDownPointInfo of
            piRegionInside:
              begin
                // inside object
                if AllowDragObj(FDownObj) then
                  begin
                    FDragObj := FDownObj;
                    FMouseMode := mmSelectedRegionsDrag;
                  end
                else
                  FMouseMode := mmSelect;
              end;
            piRegionResize:
              begin
                FMouseMode := mmRegionResize;
                FResizeObj := FDownObj;
                FResizeMode :=FDownResizeMode;
              end;
            else
              FMouseMode := mmNone;
          end;
        end
      else
        begin
          FMouseMode := mmSelectedRegionsDrag;
        end;
    end
  else
    begin
      ClearSelected;
      if AllowDragObj(FDownObj) then
        begin
          SelectObj(FDownObj);
          FMouseMode := mmSelectedRegionsDrag;
        end
      else
        FMouseMode := mmSelect;
    end;
  lFin:
finally
  ReleaseDC(Handle,DC);
end;
end;

procedure TprPreviewBox.DblClick;
var
  p : TPoint;
  v : TprExObjRecVersion;
  ep : TprEndPage;
  PointInfo : TprPointInfo;
  ResizeMode : TprResizeType;
  PreviewUserData : TprPreviewUserData;
begin
inherited;
FFirstMoveAfterDown := false;
GetCursorPos(p);
p := ScreenToClient(p);
GetPointInfoAt(p.X,p.Y,v,ep,PointInfo,ResizeMode);
PreviewUserData := nil;
if v<>nil then
  begin
    PreviewUserData := v.PreviewUserData;
    if Report.CanUserEdit and not ObjectsPropsForm.Visible then
      ObjectsPropsForm.Visible := true;
  end;
Report.DoOnPreviewDblClick(PreviewUserData);
end;

procedure TprPreviewBox.MouseUp;
var
  r : TRect;
  v : TprExObjRecVersion;
  DC : HDC;
  ep : TprEndPage;
  ClipRgn : HRGN;
  dx,dy,oLeft,oTop,oRight,oBottom,i,j,RealX,RealY : integer;

  procedure InsertObj(r : TRect);
  var
    i : integer;
    v : TprExObjRecVersion;
    ep : TprEndPage;
    epr : TRect;
  begin
  // find page or rect [R]
  i := 0;
  while (i<Report.EndPagesCount) and (not RectInRect(r,GetPageScreenRect(TprEndPage(Report.EndPages[i])))) do Inc(i);
  if i>=Report.EndPagesCount then exit;
  ep := TprEndPage(Report.EndPages[i]);
  epr := GetPageScreenRect(ep);

  if UseGrid then
    begin
      r.Top := ATG(r.Top,GridSize);
      r.Left := ATG(r.Left,GridSize);
      r.Right := ATG(r.Right,GridSize)+1;
      r.Bottom := ATG(r.Bottom,GridSize)+1;
    end;

  ClipRgn := CreateRectRgnIndirect(r);
  ClearSelected;

  v := TprExObjRecVersion(FCurClassRef.Create(nil));
  v.InitInDesigner;
  v.RealRect.Left := r.Left-epr.Left;
  v.RealRect.Right := r.Right-epr.Left;
  v.RealRect.Top := r.Top-epr.Top;
  v.RealRect.Bottom := r.Bottom-epr.Top;
  with ep.rdi do
    v.GeneratedRect := MulDivRect(v.GeneratedRect,xdiv,xmul,ydiv,ymul);
  v.PreviewUpdateProps(@ep.rdi);
  ep.VL.Add(v);

  SelectObj(v);
  DoSelectionChanged;
  end;

begin
inherited;
if Cursor=FScrollCursor then
  Cursor := FNormalCursor;

//////////////////
// Now - Designer
//////////////////
if not Report.CanUserEdit then exit;
RealX := X;
RealY := Y;
if UseGrid then
  begin
    X := ATG(X,GridSize);
    Y := ATG(Y,GridSize);
  end;

DC := GetDC(Handle);
try
  DrawAnime(DC,X,Y,FStartX,FStartY);

  ClipRgn := 0;
  case FMouseMode of
    mmNone:
      begin
        // may possible ???
      end;
    mmInsertObj:
      begin
        // insert object
        if FFirstMoveAfterDown then
          r := Rect(x,y,x+100,y+40)
        else
          r := NormalizeRect(FStartX,FStartY,X,Y);
        // r - place of inserted object
        InsertObj(r);
        DrawSelectedObjects(DC);
        DoSelectionChanged;
      end;
    mmSelect:
      begin
        if Shift<>[ssShift] then
          ClearSelected;
        r := NormalizeRect(FStartRealX,FStartRealY,RealX,RealY);
        for i:=0 to Report.EndPagesCount-1 do
          begin
            ep := TprEndPage(Report.EndPages[i]);
            if RectOverRect(r,GetPageScreenRect(ep)) then
              begin
                // check this page
                for j:=0 to ep.vl.Count-1 do
                  begin
                    v := TprExObjRecVersion(ep.vl[j]);
                    if RectOverRect(r,GetObjScreenRect(v)) then
                      SelectObj(v);
                  end;
              end;
          end;
        // draw selection
        DrawSelectedObjects(DC);
        DoSelectionChanged;
      end;
    mmRegionResize:
      begin
        // resize object
        CalcOffs(x-FStartX,y-FStartY,FResizeMode,oTop,oLeft,oBottom,oRight);
        r := GetObjScreenRect(FResizeObj);
        if (r.Left+oLeft<r.Right+oRight) and
           (r.Top+oTop<r.Bottom+oBottom) then
          begin
            AddRectToRegion(ClipRgn,r);
            DoDragOrResize(FResizeObj,oTop,oLeft,oBottom,oRight,nil);
            AddRectToRegion(ClipRgn,GetObjScreenRect(FResizeObj));
          end;
        DrawSelectedObjects(DC);
        DoSelectionChanged;
      end;
    mmSelectedRegionsDrag:
      begin
        dx := X-FStartX;
        dy := Y-FStartY;
        if (dx<>0) or (dy<>0) then
          for i:=0 to FSelObjs.Count-1 do
            begin
              v := SelObjs[i];
              AddRectToRegion(ClipRgn,GetObjScreenRect(v));
              DoDragOrResize(v,dy,dx,dy,dx,nil);
              AddRectToRegion(ClipRgn,GetObjScreenRect(v));
            end;
        DrawSelectedObjects(DC);
        DoSelectionChanged;
      end;
  end;

  if ClipRgn<>0 then
    begin
      InternalPaint(DC,ClipRgn);
      DeleteObject(ClipRgn);
    end;
  FMouseMode:=mmNone;
finally
  ReleaseDC(Handle,DC);
end;
end;

procedure TprPreviewBox.MouseMove;
var
  v : TprExObjRecVersion;
  ep : TprEndPage;
  DC : HDC;
  cur : TCursor;
  Selected : boolean;
  PointInfo : TprPointInfo;
  ResizeMode : TprResizeType;
  PreviewUserData : TprPreviewUserData;
  HighlightObject : boolean;
begin
inherited;
FFirstMoveAfterDown := false;
GetPointInfoAt(x,y,v,ep,PointInfo,ResizeMode);
HighlightObject := false;
PreviewUserData := nil;
if v<>nil then
  PreviewUserData := v.PreviewUserData;
cur := Low(TCursor);
Report.DoOnPreviewMouseMove(PreviewUserData,cur,HighlightObject);

if v<>FLastHighlightedObject then
  begin
    //  
    DC := GetDC(Handle);
    if (FLastHighlightedObject<>nil) and (FLastHighlightedEndPage<>nil) then
      InvertObject(DC,FLastHighlightedEndPage,FLastHighlightedObject);
    if (v<>nil) and HighlightObject then
      begin
        InvertObject(DC,ep,v);
        FLastHighlightedObject := v;
        FLastHighlightedEndPage := ep;
      end
    else
      FLastHighlightedObject := nil;
    ReleaseDC(Handle,DC);
  end;

if not Report.CanUserEdit or (ssCtrl in Shift) then
  begin
    if cur=Low(Cursor) then
      begin
        if ssLeft in Shift then
          begin
            if Cursor<>FScrollCursor then
              Cursor := FScrollCursor;
            if (FScrollLastX<>X) or (FScrollLastY<>Y) then
              begin
                HorzScrollBar.Position := HorzScrollBar.Position+FScrollLastX-X;
                VertScrollBar.Position := VertScrollBar.Position+FScrollLastY-Y;
                FScrollLastX := X;
                FScrollLastY := Y;
              end;
          end
        else
          if Cursor<>FNormalCursor then
            Cursor := FNormalCursor
      end
    else
      if cur<>Cursor then
        Cursor := cur;
  end
else
  begin
    if UseGrid and ((ssLeft in Shift) or (ssRight in Shift)) then
      begin
        X := ATG(X,GridSize);
        Y := ATG(Y,GridSize);
      end;
    DC := GetDC(Handle);
    DrawAnime(DC,X,Y,FLastX,FLastY);
    ReleaseDC(Handle,DC);
    FLastX := X;
    FLastY := Y;
    
    // Update Mouse cursor
    if FMouseMode=mmNone then
      begin
        if FCurClassRef<>nil then
          cur := crCross
        else
          begin
            Selected := FSelObjs.IndexOf(v)<>-1;
            if PointInfo=piSelectedResize then
              cur := prResizeCursors[ResizeMode]
            else
              if (FSelObjs.Count>1) and (v<>nil) and Selected then
                cur := crMultiDrag
              else
                if (v<>nil) and AllowDragObj(v) and ((not Selected) or (Selected and (PointInfo=piRegionInside))) then
                  cur := crDrag
                else
                  if (PointInfo=piRegionResize) and Selected and AllowResizeObj(v) then
                    cur := prResizeCursors[ResizeMode];
          end;
      end;
    if Cursor<>cur then
      Cursor := cur;
  end;
end;

procedure TprPreviewBox.InsertObj;
begin
if ObjClassRef=nil then
  FCurClassRef := nil
else
  FCurClassRef := TprObjVersionClass(GetClass(ObjClassRef.ClassName+'RecVersion'));
end;

function TprPreviewBox.AllowAction;
begin
case ActionCode of
  prpaPrint,prpaFind,prpaWholePage,prpaPageWidth,prpaPages,prpaTwoPages : Result := true;
  prpaNewPage,prpaAlignToGrid,prpaShowGrid,prpaGridSize,prpaProperties : Result := Report.CanUserEdit;
  prpaCopy,prpaCut,prpaDelete,prpaBringToFront,prpaSendToBack : Result := Report.CanUserEdit and (FSelObjs.Count>0);
  prpaPaste : Result := Report.CanUserEdit and Clipboard.HasFormat(CF_PROBJVERSIONS);
  prpaFindNext,prpaFindPrev,prpaFindCancel : Result := IsFindMode;
  prpaPageParams,prpaDelPage : Result := Report.CanUserEdit and (FCurPage<>nil);
  else Result := false;
end;
end;

procedure TprPreviewBox.ProcessAction;
var
  i : integer;
begin
case ActionCode of
  prpaPrint : Print;
  prpaFind : Find;
  prpaFindNext : FindNext;
  prpaFindPrev : FindPrior;
  prpaFindCancel : CancelFind;
  prpaBringToFront : BringToFront;
  prpaSendToBack : SendToBack;
  prpaCut : CutSelectedObjectsToClipboard;
  prpaCopy : CopySelectedObjectsToClipboard;
  prpaPaste : PasteObjectsFromClipboard;
  prpaDelete : DeleteSelectedObjects;
  prpaProperties : ObjectsPropsForm.Visible := not ObjectsPropsForm.Visible;
  prpaWholePage : WholePage;
  prpaPageWidth : PageWidth;
  prpaPages : ManyPages(2,2);
  prpaTwoPages : ManyPages(1,2);
  prpaAlignToGrid : UseGrid := not UseGrid;
  prpaShowGrid : ShowGrid := not ShowGrid;
  prpaGridSize :
    begin
      i := GridSize;
      if TprGridSizeForm.Create(Application).EditGridSize(i) then
        GridSize := i;
    end;
  prpaDelPage:
    begin
      if MBox(prLoadStr(sPreviewDeletePageQuestion),prLoadStr(sAttention),MB_YESNO or MB_ICONEXCLAMATION)<>IDYES then exit;
      DelPage(CurPageIndex);
    end;
  prpaNewPage:
    begin
      if CurPage<>nil then
        AddPage(CurPageIndex+1)
      else
        AddPage(Report.EndPagesCount);
    end;
  prpaPageParams: PageParams(CurPageIndex);
end;
end;

function TprPreviewBox.IsObjectsPropsFormVisible;
begin
Result := (ObjectsPropsForm<>nil) and (ObjectsPropsForm.Visible);
end;

procedure TprPreviewBox.UpdateInternalDataSelectedObjects;
var
  i : integer;
begin
for i:=0 to FSelObjs.Count-1 do
  SelObjs[i].PreviewUpdateProps(@GetObjPage(SelObjs[i]).rdi);
end;

procedure TprPreviewBox.PropsOfSelectedObjectsChanged;
begin
UpdateSelectedObjects;
DoObjectsPropsChanged;
end;

procedure TprPreviewBox.UpdateSelectedObjects;
var
  i : integer;
  r : TRect;
  DC : HDC;
  Rgn,TempRgn : HRGN;
begin
UpdateInternalDataSelectedObjects;
Rgn := 0;
for i:=0 to FSelObjs.Count-1 do
  begin
    r := GetObjScreenRect(SelObjs[i]);
    if Rgn=0 then
      Rgn := CreateRectRgnIndirect(r)
    else
      begin
        TempRgn := CreateRectRgnIndirect(r);
        CombineRgn(Rgn,Rgn,TempRgn,RGN_OR);
        DeleteObject(TempRgn);
      end;
  end;
if Rgn<>0 then
  begin
    DC := GetDC(Handle);
    InternalPaint(DC,Rgn);
    ReleaseDC(Handle,DC);
    DeleteObject(Rgn);
  end;
end;

procedure TprPreviewBox.AlignAction;
var
  l : TList;
  r : TRect;
  v : TprExObjRecVersion;
  prps : rPrPaintStruct;
  rg,rgLeft,rgRight,rgTop,rgBottom : TprExObjRecVersion;
  oBottom,oRight,i,Width,Delta,Right,Left,Height,Bottom,Top,j,Min,iMin,Cur,Minw,Minh,Maxw,Maxh : integer;

  function GetLeft(o : TObject) : integer;
  begin
  Result := GetObjScreenRect(TprExObjRecVersion(o)).Left;//+(r.Right-r.Left) div 2;
  end;

  function GetTop(o : TObject) : integer;
  begin
  Result := GetObjScreenRect(TprExObjRecVersion(o)).Top;//+(r.Right-r.Left) div 2;
  end;
begin
_BeginPaint(prps);
case ActionCode of
  aacHToLeft:
    begin
      for i:=1 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       0,
                       SSR[0].Left-SSR[i].Left,
                       0,
                       SSR[0].Left-SSR[i].Left,
                       @prps);
    end;
  aacHToRight:
    begin
      for i:=1 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       0,
                       SSR[0].Right-SSR[i].Right,
                       0,
                       SSR[0].Right-SSR[i].Right,
                       @prps);
    end;
  aacVToTop:
    begin
      for i:=1 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       SSR[0].Top-SSR[i].Top,
                       0,
                       SSR[0].Top-SSR[i].Top,
                       0,
                       @prps);
    end;
  aacVToBottom:
    begin
      for i:=1 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       SSR[0].Bottom-SSR[i].Bottom,
                       0,
                       SSR[0].Bottom-SSR[i].Bottom,
                       0,
                       @prps);
    end;
  aacVCenters:
    begin
      for i:=1 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       0,
                       (SSR[0].Left+(SSR[0].Right-SSR[0].Left) div 2-
                        SSR[i].Left-(SSR[i].Right-SSR[i].Left) div 2),
                       0,
                       (SSR[0].Left+(SSR[0].Right-SSR[0].Left) div 2-
                        SSR[i].Left-(SSR[i].Right-SSR[i].Left) div 2),
                       @prps);
    end;
  aacHCenters:
    begin
      for i:=1 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       (SSR[0].Top+(SSR[0].Bottom-SSR[0].Top) div 2-
                        SSR[i].Top-(SSR[i].Bottom-SSR[i].Top) div 2),
                       0,
                       (SSR[0].Top+(SSR[0].Bottom-SSR[0].Top) div 2-
                        SSR[i].Top-(SSR[i].Bottom-SSR[i].Top) div 2),
                       0,
                       @prps);
    end;
  aacHCenterInWindow:
    begin
      for i:=0 to FSelObjs.Count-1 do
        begin
          r := GetPageScreenRect(GetObjPage(SelObjs[i]));
          DoDragOrResize(SelObjs[i],
                         0,
                         (r.Right-r.Left-SSR[i].Right+SSR[i].Left) div 2-SSR[i].Left+r.Left,
                         0,
                         (r.Right-r.Left-SSR[i].Right+SSR[i].Left) div 2-SSR[i].Left+r.Left,
                         @prps);
        end;
    end;
  aacVCenterInWindow:
    begin
      for i:=0 to FSelObjs.Count-1 do
        begin
          r := GetPageScreenRect(GetObjPage(SelObjs[i]));
          DoDragOrResize(SelObjs[i],
                         (r.Bottom-r.Top-SSR[i].Bottom+SSR[i].Top) div 2-SSR[i].Top+r.Top,
                         0,
                         (r.Bottom-r.Top-SSR[i].Bottom+SSR[i].Top) div 2-SSR[i].Top+r.Top,
                         0,
                         @prps);
        end;
    end;
  aacWToSmall:
    begin
      Minw := SSR[0].Right-SSR[0].Left;
      for i:=1 to FSelObjs.Count-1 do
        if Minw>SSR[i].Right-SSR[i].Left then
          Minw := SSR[i].Right-SSR[i].Left;
      for i:=0 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       0,
                       0,
                       0,
                       Minw-SSR[i].Right+SSR[i].Left,
                       @prps);
    end;
  aacWToLarge:
    begin
      Maxw := SSR[0].Right-SSR[0].Left;
      for i:=1 to FSelObjs.Count-1 do
        if Maxw<SSR[i].Right-SSR[i].Left then
          Maxw := SSR[i].Right-SSR[i].Left;
      for i:=0 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       0,
                       0,
                       0,
                       Maxw-SSR[i].Right+SSR[i].Left,
                       @prps);
    end;
  aacHToSmall:
    begin
      Minh := SSR[0].Bottom-SSR[0].Top;
      for i:=1 to FSelObjs.Count-1 do
        if Minh>SSR[i].Bottom-SSR[i].Top then
          Minh := SSR[i].Bottom-SSR[i].Top;
      for i:=0 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       0,
                       0,
                       Minh-SSR[i].Bottom+SSR[i].Top,
                       0,
                       @prps);
    end;
  aacHToLarge:
    begin
      Maxh := SSR[0].Bottom-SSR[0].Top;
      for i:=1 to FSelObjs.Count-1 do
        if Maxh<SSR[i].Bottom-SSR[i].Top then
          Maxh := SSR[i].Bottom-SSR[i].Top;
      for i:=0 to FSelObjs.Count-1 do
        DoDragOrResize(SelObjs[i],
                       0,
                       0,
                       Maxh-SSR[i].Bottom+SSR[i].Top,
                       0,
                       @prps);
    end;
  aacAlignToGridLeftTop:
    begin
      for i:=0 to FSelObjs.Count-1 do
        with SelObjs[i] do
          DoDragOrResize(SelObjs[i],
                         (RealRect.Top div GridSize)*GridSize-RealRect.Top,
                         (RealRect.Left div GridSize)*GridSize-RealRect.Left,
                         (RealRect.Top div GridSize)*GridSize-RealRect.Top,
                         (RealRect.Left div GridSize)*GridSize-RealRect.Left,
                         @prps);
    end;
  aacAlignToGridAll:
    begin
      for i:=0 to FSelObjs.Count-1 do
        begin
          v := SelObjs[i];
          DoDragOrResize(v,
                         (v.RealRect.Top div GridSize)*GridSize-v.RealRect.Top,
                         (v.RealRect.Left div GridSize)*GridSize-v.RealRect.Left,
                         (v.RealRect.Top div GridSize)*GridSize-v.RealRect.Top,
                         (v.RealRect.Left div GridSize)*GridSize-v.RealRect.Left,
                         @prps);
          if AllowResizeObj(v) then
            begin
              if ((v.RealRect.Bottom-v.RealRect.Top-1) mod GridSize)=0 then
                oBottom := 0
              else
                oBottom := ((v.RealRect.Bottom-v.RealRect.Top) div GridSize+1)*GridSize-(v.RealRect.Bottom-v.RealRect.Top)+1;
              if ((v.RealRect.Right-v.RealRect.Left-1) mod GridSize)=0 then
                oRight := 0
              else
                oRight := ((v.RealRect.Right-v.RealRect.Left) div GridSize+1)*GridSize-(v.RealRect.Right-v.RealRect.Left)+1;
              DoDragOrResize(v,
                             0,
                             0,
                             oBottom,
                             oRight,
                             @prps);
            end;
        end;
    end;
  aacHSpaceEqually:
    begin
      l := TList.Create;
      try
        for i:=0 to FSelObjs.Count-1 do
          if AllowDragObj(SelObjs[i]) then
            l.Add(SelObjs[i]);

        for i:=0 to l.Count-1 do
          begin
            iMin := i;
            Min := GetLeft(l[i]);
            for j:=i+1 to l.Count-1 do
              begin
                Cur := GetLeft(l[j]);
                if Cur<Min then
                  begin
                    iMin := j;
                    Min := Cur;
                  end;
              end;
            if iMin<>i then
              l.Exchange(i,iMin);
          end;
        rgLeft := TprExObjRecVersion(l[0]);
        Left := GetObjScreenRect(rgLeft).Left;

        //   Right
        rgRight := rgLeft;
        Right := GetObjScreenRect(rgRight).Right;
        for i:=1 to l.Count-1 do
          begin
            if Right<GetObjScreenRect(TprExObjRecVersion(l[i])).Right then
              begin
                rgRight := TprExObjRecVersion(l[i]);
                Right := GetObjScreenRect(rgRight).Right;
              end;
          end;

        //    ""
        Width := 0;
        for i:=1 to l.Count-1 do
          if GetObjScreenRect(TprExObjRecVersion(l[i])).Right<Right then
            Width := Width+GetObjScreenRect(TprExObjRecVersion(l[i])).Right-GetObjScreenRect(TprExObjRecVersion(l[i])).Left;

        //     
        Delta:=(Right-Left-(GetObjScreenRect(rgLeft).Right-GetObjScreenRect(rgLeft).Left)-
                           (GetObjScreenRect(rgRight).Right-GetObjScreenRect(rgRight).Left)-Width) div (l.Count-1);

        //     
        Left := GetObjScreenRect(rgLeft).Right;
        for i:=1 to l.Count-1 do
          begin
            rg := TprExObjRecVersion(l[i]);
            if rg<>rgRight then
              begin
                DoDragOrResize(rg,
                               0,
                               Left+Delta-GetObjScreenRect(rg).Left,
                               0,
                               Left+Delta-GetObjScreenRect(rg).Left,
                               @prps);
                Left := Left+Delta+GetObjScreenRect(rg).Right-GetObjScreenRect(rg).Left;
              end;
          end;
      finally
        l.Free;
      end;
    end;
  aacVSpaceEqually:
    begin
      l := TList.Create;
      try
        for i:=0 to FSelObjs.Count-1 do
          if AllowDragObj(SelObjs[i]) then
            l.Add(SelObjs[i]);
        for i:=0 to l.Count-1 do
          begin
            iMin := i;
            Min := GetTop(l[i]);
            for j:=i+1 to l.Count-1 do
              begin
                Cur := GetTop(l[j]);
                if Cur<Min then
                  begin
                    iMin := j;
                    Min := Cur;
                  end;
              end;
            if iMin<>i then
              l.Exchange(i,iMin);
          end;
        rgTop := TprExObjRecVersion(l[0]);
        Top := GetObjScreenRect(rgTop).Top;

        //   Bottom
        rgBottom := rgTop;
        Bottom := GetObjScreenRect(rgBottom).Bottom;
        for i:=1 to l.Count-1 do
          begin
            if Bottom<GetObjScreenRect(TprExObjRecVersion(l[i])).Bottom then
              begin
                rgBottom := TprExObjRecVersion(l[i]);
                Bottom  := GetObjScreenRect(rgBottom).Bottom;
              end;
          end;
      
        //    ""
        Height := 0;
        for i:=1 to l.Count-1 do
          if GetObjScreenRect(TprExObjRecVersion(l[i])).Bottom<Bottom then
            Height := Height+GetObjScreenRect(TprExObjRecVersion(l[i])).Bottom-GetObjScreenRect(TprExObjRecVersion(l[i])).Top;
      
        //     
        Delta:=(Bottom-Top-(GetObjScreenRect(rgTop).Bottom-GetObjScreenRect(rgTop).Top)-(GetObjScreenRect(rgBottom).Bottom-GetObjScreenRect(rgBottom).Top)-Height) div (l.Count-1);

        //     
        Top := GetObjScreenRect(rgTop).Bottom;
        for i:=1 to l.Count-1 do
          begin
            rg := TprExObjRecVersion(l[i]);
            if rg<>rgBottom then
              begin
                DoDragOrResize(rg,
                               Top+Delta-GetObjScreenRect(rg).Top,
                               0,
                               Top+Delta-GetObjScreenRect(rg).Top,
                               0,
                               @prps);
                Top:=Top+Delta+GetObjScreenRect(rg).Bottom-GetObjScreenRect(rg).Top;
              end;
          end;
      finally
        l.Free;
      end;
    end;
end;
_EndPaint(prps);
end;

procedure TprPreviewBox.Nudge;
var
  i : integer;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to FSelObjs.Count-1 do
  DoDragOrResize(SelObjs[i],dy,dx,dy,dx,@prps);
_EndPaint(prps);
end;

procedure TprPreviewBox.Size;
var
  i : integer;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to FSelObjs.Count-1 do
  DoDragOrResize(SelObjs[i],0,0,sy,sx,@prps);
_EndPaint(prps);
end;

procedure TprPreviewBox.SetPosSizeProp;
var
  v : TprExObjRecVersion;
  ep : TprEndPage;
  i,pv : integer;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to FSelObjs.Count-1 do
  begin
    v := SelObjs[i];
    ep := GetObjPage(v);
    if Prop in [prpsaLeft,prpsaRight,prpsaWidth] then pv := MulDiv(PropValue,ep.rdi.xmul,ep.rdi.xdiv)
                                                 else pv := MulDiv(PropValue,ep.rdi.ymul,ep.rdi.ydiv);
    case Prop of
      prpsaLeft : DoDragOrResize(v,0,pv-v.RealRect.Left,0,pv-v.RealRect.Left,@prps);
      prpsaRight : DoDragOrResize(v,0,0,0,pv-v.RealRect.Right,@prps);
      prpsaTop : DoDragOrResize(v,pv-v.RealRect.Top,0,pv-v.RealRect.Top,0,@prps);
      prpsaBottom : DoDragOrResize(v,0,0,pv-v.RealRect.Bottom,0,@prps);
      prpsaWidth : DoDragOrResize(v,0,0,0,pv-v.RealRect.Right+v.RealRect.Left,@prps);
      prpsaHeight : DoDragOrResize(v,0,0,pv-v.RealRect.Bottom+v.RealRect.Top,0,@prps);
    end;
  end;
_EndPaint(prps);
end;

procedure TprPreviewBox.BringToFront;
var
  i : integer;
  v : TprExObjRecVersion;
  ep : TprEndPage;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to FSelObjs.Count-1 do
  begin
    v := SelObjs[i];
    ep := GetObjPage(v);
    ep.VL.Remove(v);
    ep.VL.Add(v);
    AddRectToRegion(prps.ClipRgn,GetObjScreenRect(v));
  end;
_EndPaint(prps);
end;

procedure TprPreviewBox.SendToBack;
var
  i : integer;
  v : TprExObjRecVersion;
  ep : TprEndPage;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to FSelObjs.Count-1 do
  begin
    v := SelObjs[i];
    ep := GetObjPage(v);
    ep.VL.Remove(v);
    ep.VL.Insert(0,v);
    AddRectToRegion(prps.ClipRgn,GetObjScreenRect(v));
  end;
_EndPaint(prps);
end;

procedure TprPreviewBox.DeleteSelectedObjects;
var
  i : integer;
  v : TprExObjRecVersion;
  ep : TprEndPage;
  DC : HDC;
  ClipRgn : HRGN;
begin
DC := GetDC(Handle);
try
  DrawSelectedObjects(DC);  //  
  i := 0;
  ClipRgn := 0;
  while i<FSelObjs.Count do
    begin
      v := SelObjs[i];
      ep := GetObjPage(v);
      AddRectToRegion(ClipRgn,GetObjScreenRect(v));
      ep.VL.Remove(v);
      v.Free;
      Inc(i);
    end;
  ClearSelected;

  InternalPaint(DC,ClipRgn);

  if ClipRgn<>0 then
    DeleteObject(ClipRgn);

  DoSelectionChanged;
finally
  ReleaseDC(Handle,DC);
end;
end;

procedure TprPreviewBox.CopySelectedObjectsToClipboard;
var
  ms : TMemoryStream;
  hMem : THandle;
  pMem : pointer;
begin
//    MemoryStream
ms := TMemoryStream.Create;
try
  SaveObjectsVersionsToStream(ms,FSelObjs);
  //       
  ClipBoard.Open;
  try
    hMem := GlobalAlloc(GMEM_MOVEABLE+GMEM_SHARE+GMEM_ZEROINIT,ms.Size);
    if hMem<>0 then
      begin
        pMem := GlobalLock(hMem);
        if pMem<>nil then
          begin
            CopyMemory(pMem,ms.Memory,ms.Size);
            GlobalUnLock(hMem);
            ClipBoard.SetAsHandle(CF_PROBJVERSIONS,hMem);
          end;
      end;
  finally
    ClipBoard.Close;
  end;
finally
  ms.Free;
end;
end;

procedure TprPreviewBox.CutSelectedObjectsToClipboard;
begin
CopySelectedObjectsToClipboard;
DeleteSelectedObjects;
end;

procedure TprPreviewBox.PasteObjectsFromClipboard;
var
  i : integer;
  l : TList;
  v : TprExObjRecVersion;
  ms : TMemoryStream;
  hMem : THandle;
  pMem : pointer;
  prps : rPrPaintStruct;
  hSize : DWORD;
begin
if FCurPage=nil then
  begin
    MBMessage(prLoadStr(sPreviewSelectPageForPaste),prLoadStr(sAttention));
    exit;
  end;
ClipBoard.Open;
try
  hMem := Clipboard.GetAsHandle(CF_PROBJVERSIONS);
  pMem := GlobalLock(hMem);
  if pMem<>nil then
    begin
      hSize := GlobalSize(hMem);
      ms := TMemoryStream.Create;
      try
        ms.Write(pMem^,hSize);
        ms.Seek(soFromBeginning,0);
        l := TList.Create;
        try
          LoadObjectsVersionsFromStream(ms,l);
          _BeginPaint(prps);
          ClearSelected;
          for i:=0 to l.Count-1 do
            begin
              v := TprExObjRecVersion(l[i]);
              OffsetRect(v.GeneratedRect,GridSize,GridSize);
              if v.GeneratedRect.Right>FCurPage.pInfo.saRect.Right then
                v.GeneratedRect.Left := v.GeneratedRect.Left-v.GeneratedRect.Right+FCurPage.pInfo.saRect.Right;
              if v.GeneratedRect.Bottom>FCurPage.pInfo.saRect.Bottom then
                v.GeneratedRect.Top := v.GeneratedRect.Top-v.GeneratedRect.Bottom+FCurPage.pInfo.saRect.Bottom;
              v.PreviewUpdateProps(@FCurPage.rdi);
              FCurPage.VL.Add(v);
              SelectObj(v);
              AddRectToRegion(prps.ClipRgn,GetObjScreenRect(v));
            end;
          _EndPaint(prps);
        finally
          l.Free;
        end;
      finally
        GlobalUnlock(hMem);
        ms.Free;
      end;
    end;
finally
  Clipboard.Close;
end;
end;

procedure TprPreviewBox.PagesChanged;
begin
rpdi.DrawMode := dmDraw;
ClearFindList;
CalcMaxSizes;
FLastHighlightedObject := nil;
Resize;
end;

procedure TprPreviewBox.AddPage;
var
  ep,cp : TprEndPage;
begin
ep := TprEndPage.CreateEmpty(Report);
cp := FCurPage;
if cp=nil then
  begin
    if Report.EndPagesCount>0 then
      cp := TprEndPage(Report.EndPages[0]);
  end;
if cp=nil then
  Report.prPrinter.UpdatepInfo(ep,ep.pInfo,ep.lMargin,ep.rMargin,ep.tMargin,ep.bMargin)
else
  with ep do
    begin
      PaperSize := cp.PaperSize;
      Orientation := cp.Orientation;
      lMargin := cp.lMargin; // margins left, top and etc
      rMargin := cp.rMargin;
      tMargin := cp.tMargin;
      bMargin := cp.bMargin;
      pInfo := cp.pInfo;
    end;
ep.rdi.ppdi := @rpdi;
if BeforePageIndex=Report.EndPagesCount then
  Report.AddEndPageToList(ep)
else
  Report.InsertEndPageIntoList(ep,BeforePageIndex);
PagesChanged;
Report.TemplateChanged := true;
end;

procedure TprPreviewBox.DelPage;
var
  ep : TprEndPage;
begin
ep := TprEndPage(Report.EndPages[PageIndex]);
if ep=FCurPage then
  FCurPage := nil;
Report.DeleteEndPage(PageIndex);
PagesChanged;
Report.TemplateChanged := true;
end;

procedure TprPreviewBox.PageParams;
var
  p : TprEndPage;
  lMargin : integer;
  rMargin : integer;
  tMargin : integer;
  bMargin : integer;
  PaperSize : integer;
  Orientation : TprPrinterOrientation;
  Width,Height : integer;
begin
if (PageIndex<0) or (PageIndex>=Report.EndPagesCount) then exit;
p := TprEndPage(Report.EndPages[PageIndex]);
PaperSize := p.PaperSize;
Orientation := p.Orientation;
Width := p.Width;
Height := p.Height;
lMargin := p.lMargin;
rMargin := p.rMargin;
tMargin := p.tMargin;
bMargin := p.bMargin;
if TprPageParamsForm.Create(Application).EditOptions(TprReport(p.Report),p.pInfo,PaperSize,Orientation,Width,Height,lMargin,tMargin,rMargin,bMargin) then
  begin
    p.lMargin := lMargin;
    p.rMargin := rMargin;
    p.tMargin := tMargin;
    p.bMargin := bMargin;
    p.ChangePaper(Report,PaperSize,Width,Height,Orientation);
    PagesChanged;
    Report.TemplateChanged := true;
  end;
end;

procedure TprPreviewBox.mKeyDown;
var
  si : tagSCROLLINFO;
  ss : TShiftState;
begin
//inherited;
ss:=KeyDataToShiftState(Message.KeyData);

if ss=[] then
  case Message.CharCode of
    VK_DOWN:
      VertScrollBar.Position:=VertScrollBar.Position+VertScrollBar.Increment;
    VK_UP:
      VertScrollBar.Position:=VertScrollBar.Position-VertScrollBar.Increment;
    VK_RIGHT:
      HorzScrollBar.Position:=HorzScrollBar.Position+HorzScrollBar.Increment;
    VK_LEFT:
      HorzScrollBar.Position:=HorzScrollBar.Position-HorzScrollBar.Increment;
    VK_NEXT,VK_PRIOR:
      begin
        ZeroMemory(@si,sizeof(si));
        si.cbSize := sizeof(si);
        si.fMask := SIF_PAGE;
        if GetScrollInfo(Handle,SB_VERT,si) then
          begin
            if Message.CharCode=VK_NEXT then
              VertScrollBar.Position:=VertScrollBar.Position+integer(si.nPage)
            else
              VertScrollBar.Position:=VertScrollBar.Position-integer(si.nPage);
          end;
      end;
    else
      inherited;
  end
else
  if ss=[ssCtrl] then
    case Message.CharCode of
      VK_NEXT:
        VertScrollBar.Position:=VertScrollBar.Range;
      VK_PRIOR:
        VertScrollBar.Position:=0;
    end;
end;

procedure TprPreviewBox.CalcMaxSizes;
var
  i : integer;
begin
FMaxWidth :=TprEndPage(Report.EndPages[0]).pInfo.sWidth;
FMaxHeight:=TprEndPage(Report.EndPages[0]).pInfo.sHeight;
for i:=1 to Report.EndPagesCount-1 do
  begin
    if FMaxWidth<TprEndPage(Report.EndPages[i]).pInfo.sWidth then
      FMaxWidth:=TprEndPage(Report.EndPages[i]).pInfo.sWidth;
    if FMaxHeight<TprEndPage(Report.EndPages[i]).pInfo.sHeight then
      FMaxHeight:=TprEndPage(Report.EndPages[i]).pInfo.sHeight;
  end;
end;

function TprPreviewBox.GetScaleKoef;
begin
Result := Round(FScaleMul/FScaleDiv*100);
end;

procedure TprPreviewBox.SetPagesPerHeight;
begin
if (FPagesPerHeight=Value) or (Value<1) then exit;

FPagesPerHeight:=Value;
FScaleMode     :=smPages;
UpdateSettings;
end;

procedure TprPreviewBox.SetPagesPerWidth;
begin
if (FPagesPerWidth=Value) or (Value<1) then exit;

FPagesPerWidth:=Value;
FScaleMode    :=smPages;
UpdateSettings;
end;

procedure TprPreviewBox.SetScaleMode;
begin
if FScaleMode=Value then exit;

FScaleMode:=Value;
UpdateSettings;
end;

procedure TprPreviewBox.SetScalePercent;
begin
if (FScalePercent=Value) or (Value<1) then exit;

FScalePercent:=Value;
FScaleMode   :=smOnePagePercent;
UpdateSettings;
end;

procedure TprPreviewBox.UpdateSettings;
begin
Resize;
end;

procedure TprPreviewBox.InternalCalcPagesSizes;
var
  ep : TprEndPage;
  i,j,sbw,sbh,mmw,mmh,n,l,t,w,h : integer;

  procedure CachePage;
  var
    r : TRect;
  begin
  r.Left := l;
  r.Top := t;
  r.Right := l+w;
  r.Bottom := t+h;

  ep.Cache(r,false);
  end;

begin
//   ScaleKoef    
if FScaleDiv=0 then
  FOldScaleKoef := 0
else
  FOldScaleKoef := FScaleMul/FScaleDiv;
sbw := ClientWidth;
sbh := ClientHeight;
case ScaleMode of
  smPages:
    begin
      mmw := FMaxWidth*PagesPerWidth+(PagesPerWidth-1)*PagesStepX;
      mmh := FMaxHeight*PagesPerHeight+(PagesPerHeight-1)*PagesStepY;
      if (sbw-LeftOffs-RightOffs)/mmw<(sbh-TopOffs-BottomOffs)/mmh then
        begin
          FScaleMul := sbw-LeftOffs-RightOffs;
          FScaleDiv := mmw;
        end
      else
        begin
          FScaleMul := sbh-TopOffs-BottomOffs;
          FScaleDiv := mmh;
        end;
      if Round(FScaleMul/FScaleDiv*100)<=0 then
        begin
          FScaleMul := 1;
          FScaleDiv := 100;
        end;

      n := Report.EndPagesCount div PagesPerWidth;
      n := n+(Report.EndPagesCount mod PagesPerWidth);

      DrawWidth := LeftOffs+RightOffs+muldiv(FMaxWidth,FScaleMul,FScaleDiv)*PagesPerWidth+(PagesPerWidth-1)*PagesStepX;
      DrawHeight := TopOffs+BottomOffs+muldiv(FMaxHeight,FScaleMul,FScaleDiv)*n+(n-1)*PagesStepY;
    end;

  smPageWidth:
    begin
      FScaleMul := sbw-LeftOffs-RightOffs;
      FScaleDiv := FMaxWidth;
      DrawWidth := sbw;
      DrawHeight := TopOffs+BottomOffs+muldiv(FMaxHeight,FScaleMul,FScaleDiv)*(Report.EndPagesCount)+PagesStepY*(Report.EndPagesCount-1);
    end;

  smOnePagePercent:
    begin
      FScaleMul := ScalePercent;
      FScaleDiv := 100;
      DrawWidth := LeftOffs+RightOffs+muldiv(FMaxWidth,FScaleMul,FScaleDiv);
      DrawHeight := TopOffs+BottomOffs+muldiv(FMaxHeight,FScaleMul,FScaleDiv)*(Report.EndPagesCount)+PagesStepY*(Report.EndPagesCount-1);
    end;
end;

//   ScrollBars
HorzScrollBar.Range:=DrawWidth;
VertScrollBar.Range:=DrawHeight;

//  
case ScaleMode of
  smPages:
    begin
      i:=0;
      while i*PagesPerWidth<Report.EndPagesCount do
        begin
          j:=0;
          while (j<PagesPerWidth) and (i*PagesPerWidth+j<Report.EndPagesCount) do
            begin
              ep := TprEndPage(Report.EndPages[i*PagesPerWidth+j]);
              w := muldiv(ep.pInfo.sWidth,FScaleMul,FScaleDiv);
              h := muldiv(ep.pInfo.sHeight,FScaleMul,FScaleDiv);
              l := LeftOffs+(muldiv(FMaxWidth,FScaleMul,FScaleDiv)+PagesStepX)*j;
              t := TopOffs+(muldiv(FMaxHeight,FScaleMul,FScaleDiv)+PagesStepY)*i;

              CachePage;
              Inc(j);
            end;
          Inc(i);
        end;
    end;
  smPageWidth,smOnePagePercent:
    begin
      for i:=0 to Report.EndPagesCount-1 do
        begin
          ep := TprEndPage(Report.EndPages[i]);
          w := muldiv(ep.pInfo.sWidth,FScaleMul,FScaleDiv);
          h := muldiv(ep.pInfo.sHeight,FScaleMul,FScaleDiv);
          l := LeftOffs;
          t := TopOffs+(muldiv(FMaxHeight,FScaleMul,FScaleDiv)+PagesStepY)*i;

          CachePage;
        end;
    end;
end;
end;

procedure TprPreviewBox.ClearFindList;
var
  i : integer;
begin
for i:=0 to rpdi.FindList.Count-1 do
  TprFindText(rpdi.FindList[i]).Free;
rpdi.FindList.Clear;
end;

function TprPreviewBox.InternalFind;
var
  ep : TprEndPage;
  DC,TempDC : HDC;
  i,j,k,n,Top,TopIndex : integer;
begin
Result:=false;
DC    :=0;

ClearFindList;
rpdi.DrawMode:=dmFindFirst;

if rpdi.ProgressBar<>nil then
  begin
    rpdi.ProgressBar.Min     :=0;
    rpdi.ProgressBar.Position:=0;
    rpdi.ProgressBar.Max     :=Report.EndPagesCount;
  end;
if rpdi.StatusBar<>nil then
  begin
    rpdi.StatusBar.Panels[1].Text:=prLoadStr(sFind);
    rpdi.StatusBar.Repaint;
  end;
try
  TempDC       :=GetDC(0);
  DC           :=CreateCompatibleDC(TempDC);
  ReleaseDC(0,TempDC);

  for i:=0 to Report.EndPagesCount-1 do
    begin
      if rpdi.ProgressBar<>nil then
        begin
          rpdi.ProgressBar.Position:=rpdi.ProgressBar.Position+1;
          Application.ProcessMessages;
        end;

      //  
      n :=rpdi.FindList.Count;
      ep:=TprEndPage(Report.EndPages[i]);
      for j:=0 to ep.vl.Count-1 do
        TprExObjRecVersion(ep.vl[j]).Draw(DC,@ep.rdi);

      //     TextRect.Top
      j:=n;
      while j<rpdi.FindList.Count do
        begin
          Top:=TprFindText(rpdi.FindList[j]).TextRect.Top;
          k  :=j+1;
          while k<rpdi.FindList.Count do
            if Top=TprFindText(rpdi.FindList[k]).TextRect.Top then
              begin
                TprFindText(rpdi.FindList[k]).Free;
                rpdi.FindList.Delete(k)
              end
            else
              Inc(k);
          with TprFindText(rpdi.FindList[j]).TextRect do
            begin
              Left  :=Left+ep.rdi.bRect.Left;
              Top   :=Top+ep.rdi.bRect.Top;
              Right :=Right+ep.rdi.bRect.Left;
              Bottom:=Bottom+ep.rdi.bRect.Top;
            end;
          Inc(j);
        end;

      //   TextRect.Top
      for j:=n to rpdi.FindList.Count-1 do
        begin
          Top     :=TprFindText(rpdi.FindList[j]).TextRect.Top;
          TopIndex:=j;
          for k:=j+1 to rpdi.FindList.Count-1 do
            if TprFindText(rpdi.FindList[k]).TextRect.Top<Top then
              begin
                Top     :=TprFindText(rpdi.FindList[k]).TextRect.Top;
                TopIndex:=k;
              end;
          if j<>TopIndex then
            rpdi.FindList.Exchange(j,TopIndex);
        end;
    end;

  Result:=rpdi.FindList.Count>0;
finally
  if rpdi.StatusBar<>nil then
    rpdi.StatusBar.Panels[1].Text:='';
  if rpdi.ProgressBar<>nil then
    rpdi.ProgressBar.Position:=0;
  if DC<>0 then
    DeleteDC(DC);
  if Result then
    rpdi.DrawMode:=dmFind
  else
    rpdi.DrawMode:=dmDraw;
end;
end;

procedure TprPreviewBox.Resize;
begin
inherited;
InternalCalcPagesSizes;
if rpdi.DrawMode=dmFind then
  InternalFind;
Repaint;
if (Abs(FOldScaleKoef-FScaleMul/FScaleDiv)>0.001) and Assigned(OnScalePercentChanged) then
  OnScalePercentChanged(Self);
end;

procedure TprPreviewBox.InvertObject;
var
  OldOrgEx : TPoint;
begin
SetViewportOrgEx(DC,ep.rdi.bRect.Left-HorzScrollBar.Position,ep.rdi.bRect.Top-VertScrollBar.Position,@OldOrgEx);
InvertRect(DC,v.RealRect);
SetViewportOrgEx(DC,OldOrgEx.X,OldOrgEx.Y,nil);
end;

procedure TprPreviewBox._BeginPaint;
var
  DC : HDC;
begin
prps.ClipRgn := 0;
prps.ClipState := [];
DC := GetDC(Handle);
DrawSelectedObjects(DC);
ReleaseDC(Handle,DC);
end;

procedure TprPreviewBox._EndPaint;
var
  DC : HDC;
begin
DC := GetDC(Handle);
DrawSelectedObjects(DC);
if prps.ClipRgn<>0 then
  begin
    InternalPaint(DC,prps.ClipRgn);
    DeleteObject(prps.ClipRgn);
  end;
ReleaseDC(Handle,DC);
end;

procedure TprPreviewBox.InternalPaint;
var
  v : TprExObjRecVersion;
  ep : TprEndPage;
  nbr : HBRUSH;
  r1,r2,r3 : TRect;
  npn,opn : HPEN;
  rcPaint : TRect;
  OldOrgEx : TPoint;
  ObjsRgn,BackRgn,TempRgn : HRGN;
  hsb,vsb,i,j,k,w,h : integer;
begin
DrawSelectedObjects(DC);

hsb := HorzScrollBar.Position;
vsb := VertScrollBar.Position;
if GetRgnBox(rgn,rcPaint)=NULLREGION then
  rcPaint := Rect(0,0,ClientWidth,ClientHeight);
r1 := Rect(rcPaint.Left+hsb,rcPaint.Top+vsb,rcPaint.Right+hsb,rcPaint.Bottom+vsb);
npn := CreatePen(PS_SOLID,1,clBlack);
opn := SelectObject(DC,npn);
SelectClipRgn(DC,rgn);
try
  for i:=0 to Report.EndPagesCount-1 do
    begin
      ep := TprEndPage(Report.EndPages[i]);
      ep.rdi.hsb := hsb;
      ep.rdi.vsb := vsb;
      if RectOverRect(ep.rdi.bRect,r1) then
        begin
          // draw page
          r2 := Rect(rcPaint.Left-ep.rdi.bRect.Left+hsb,
                     rcPaint.Top-ep.rdi.bRect.Top+vsb,
                     rcPaint.Right-ep.rdi.bRect.Left+hsb,
                     rcPaint.Bottom-ep.rdi.bRect.Top+vsb);

          // draw background
          BackRgn := CreateRectRgn(ep.rdi.bRect.Left-hsb,ep.rdi.bRect.Top-vsb,
                                   ep.rdi.bRect.Right-hsb,ep.rdi.bRect.Bottom-vsb);
          ObjsRgn := CreateRectRgn(0,0,0,0);
          CombineRgn(BackRgn,BackRgn,Rgn,RGN_AND);
          for j:=0 to ep.VL.Count-1 do
            begin
              v := TprExObjRecVersion(ep.vl[j]);
              r3 := Rect(v.RealRect.Left+ep.rdi.bRect.Left-hsb,
                         v.RealRect.Top+ep.rdi.bRect.Top-vsb,
                         v.RealRect.Right+ep.rdi.bRect.Left-hsb,
                         v.RealRect.Bottom+ep.rdi.bRect.Top-vsb);
              TempRgn := CreateRectRgnIndirect(r3);
              CombineRgn(BackRgn,BackRgn,TempRgn,RGN_DIFF);
              if RectOverRect(r2,v.RealRect) then
                CombineRgn(ObjsRgn,ObjsRgn,TempRgn,RGN_OR);
              DeleteObject(TempRgn);
            end;
          if Report.CanUserEdit and ShowGrid and (GridSize>1) then
            begin
              if FGridBitmap=0 then
                begin
                  // draw using points
                  nbr := CreateSolidBrush(clWhite);
                  FillRgn(DC,BackRgn,nbr);
                  DeleteObject(nbr);
                  w := ep.rdi.bRect.Right-hsb;
                  h := ep.rdi.bRect.Bottom-vsb;
                  k := ep.rdi.bRect.Left-hsb;
                  while k<w do
                    begin
                      j := ep.rdi.bRect.Top-vsb;
                      while j<h do
                        begin
                          if PtInRegion(BackRgn,k,j) then
                            SetPixelV(DC,k,j,clBlack);
                          Inc(j,GridSize);
                        end;
                      Inc(k,GridSize);
                    end;
                end
              else
                begin
                  nbr := CreatePatternBrush(FGridBitmap);
                  SetBrushOrgEx(DC,ep.rdi.bRect.Left-hsb,ep.rdi.bRect.Top-vsb,@OldOrgEx);
                  FillRgn(DC,BackRgn,nbr);
                  DeleteObject(nbr);
                  SetBrushOrgEx(DC,OldOrgEx.X,OldOrgEx.Y,nil);
                end;
            end
          else
            begin
              nbr := CreateSolidBrush(clWhite);
              FillRgn(DC,BackRgn,nbr);
              DeleteObject(nbr);
            end;
          DeleteObject(BackRgn);

          // fill ObjsRgn
          nbr := CreateSolidBrush(clWhite);
          FillRgn(DC,ObjsRgn,nbr);
          DeleteObject(nbr);
          DeleteObject(ObjsRgn);

          // page borders
          DrawPageRect(DC,ep,ep=FCurPage);
          SetViewportOrgEx(DC,ep.rdi.bRect.Left-hsb,ep.rdi.bRect.Top-vsb,@OldOrgEx);
          // now - draw objects
          for j:=0 to ep.vl.Count-1 do
            begin
              v := TprExObjRecVersion(ep.vl[j]);
              if RectOverRect(r2,v.RealRect) then
                begin
                  v.Draw(DC,@ep.rdi);
                  if v=FLastHighlightedObject then
                    InvertRect(DC,v.RealRect);
                end;
            end;
          SetViewportOrgEx(DC,OldOrgEx.X,OldOrgEx.Y,nil);
        end;
    end;
finally
  SelectObject(DC,opn);
  SelectClipRgn(DC,0);
  DeleteObject(npn);
  DrawSelectedObjects(DC);
end;
end;

procedure TprPreviewBox.mPaint;
var
  DC : hDC;
  PS : TPaintStruct;
  rgn : HRGN;
begin
Message.Result := 1;
DC := BeginPaint(Handle,PS);
rgn := CreateRectRgnIndirect(ps.rcPaint);
InternalPaint(DC,Rgn);
DeleteObject(rgn); 
EndPaint(Handle,PS);
end;

procedure TprPreviewBox.mVScroll;
begin
inherited;
end;

procedure TprPreviewBox.mHScroll;
begin
inherited;
end;

function TprPreviewBox.GetFindedCount;
begin
Result:=rpdi.FindList.Count;
end;

function TprPreviewBox.GetIsFindMode;
begin
Result := rpdi.DrawMode=dmFind;
end;

procedure TprPreviewBox.SetCaseSensitive;
begin
rpdi.CaseSensitive := Value;
end;

function TprPreviewBox.GetCaseSensitive;
begin
Result := rpdi.CaseSensitive;
end;

procedure TprPreviewBox.SetFindText;
begin
rpdi.FindText := Value;
end;

function TprPreviewBox.GetFindText;
begin
Result := rpdi.FindText;
end;

procedure TprPreviewBox.SetProgressBar;
begin
rpdi.ProgressBar := Value;
end;

function TprPreviewBox.GetProgressBar;
begin
Result := rpdi.ProgressBar;
end;

procedure TprPreviewBox.SetStatusBar;
begin
rpdi.StatusBar := Value;
end;

function TprPreviewBox.GetStatusBar;
begin
Result := rpdi.StatusBar;
end;

procedure TprPreviewBox.SetShowGrid;
begin
if FShowGrid=Value then exit;
FShowGrid := Value;
if HandleAllocated then
  Repaint;
end;

procedure TprPreviewBox.SetGridSize;
begin
if FGridSize=Value then exit;
FGridSize := Value;
UpdateGridBitmap(FGridBitmap,FGridSize,FGridSize);
if HandleAllocated then
  Repaint;
end;

procedure TprPreviewBox.DrawPageRect;
var
  r : TRect;
  br : HBRUSH;
begin
r := GetPageScreenRect(ep);
if Selected then
  br := CreateSolidBrush(clBlue)
else
  br := CreateSolidBrush(clBlack);
FrameRect(DC,Rect(r.Left-1,r.Top-1,r.Right+1,r.Bottom+1),br);
DeleteObject(br);
end;

procedure TprPreviewBox.SetCurPage;
var
  DC : HDC;
begin
if FCurPage=Value then exit;
DC := GetDC(Handle);
try
  if FCurPage<>nil then
    DrawPageRect(DC,FCurPage,false);
  FCurPage := Value;
  if FCurPage<>nil then
    DrawPageRect(DC,FCurPage,true);
finally
  ReleaseDC(Handle,DC);
end;
end;

function TprPreviewBox.GetCurPageIndex;
begin
Result := Report.EndPageIndex(FCurPage);
end;

procedure TprPreviewBox.FindDialogFind;
begin
if IsFindMode then
  begin
    if frDown in FFindDialog.Options then
      FindNext
    else
      FindPrior;
  end
else
  begin
    CaseSensitive := frMatchCase in FFindDialog.Options;
    if rpdi.CaseSensitive then
      FindText := FFindDialog.FindText
    else
      FindText := AnsiUpperCase(FFindDialog.FindText);
    if InternalFind then
      begin
        FFindPos := -1;
        FindNext;
        Repaint;
      end
    else
      begin
        MBError(Format(prLoadStr(sTextNotFound),[rpdi.FindText]));
      end;
  end;
end;

procedure TprPreviewBox.Find;
begin
FFindDialog.Execute;
end;

procedure TprPreviewBox.CancelFind;
begin
rpdi.DrawMode:=dmDraw;
ClearFindList;
Repaint;
end;

procedure TprPreviewBox.FindNext;
begin
if FFindPos<rpdi.FindList.Count-1 then
  begin
    Inc(FFindPos)
  end
else
  begin
    if MBox(prLoadStr(sEndOfFind),prLoadStr(sAttention),MB_YESNO+MB_ICONQUESTION)=IDNO then
      exit;
    FFindPos:=0;
  end;
HorzScrollBar.Position := TprFindText(rpdi.FindList[FFindPos]).TextRect.Left;
VertScrollBar.Position := TprFindText(rpdi.FindList[FFindPos]).TextRect.Top;
end;

procedure TprPreviewBox.FindPrior;
begin
if FFindPos>0 then
  begin
    Dec(FFindPos);
  end
else
  begin
    if MBox(prLoadStr(sStartOfFind),prLoadStr(sAttention),MB_YESNO+MB_ICONQUESTION)=IDNO then
      exit;
    FFindPos:=rpdi.FindList.Count-1;
  end;
HorzScrollBar.Position := TprFindText(rpdi.FindList[FFindPos]).TextRect.Left;
VertScrollBar.Position := TprFindText(rpdi.FindList[FFindPos]).TextRect.Top;
end;

procedure TprPreviewBox.WholePage;
begin
FPagesPerHeight := 1;
FPagesPerWidth := 1;
FScaleMode :=smPages;
UpdateSettings;
end;

procedure TprPreviewBox.PageWidth;
begin
FScaleMode := smPageWidth;
UpdateSettings;
end;

procedure TprPreviewBox.ManyPages;
begin
FPagesPerHeight := PerHeight;
FPagesPerWidth := PerWidth;
FScaleMode := smPages;
UpdateSettings;
end;

procedure TprPreviewBox.Print;
begin
if Report.SetupPrintParams then
  Report.PrintPreparedReport;
end;

procedure TprPreviewBox.LoadPreparedReport;
begin
Report.LoadPreparedReportFromFile(FileName);
SetRPDI;
CalcMaxSizes;
FLastHighlightedObject := nil;
VertScrollBar.Position := 0;
HorzScrollBar.Position := 0;
Resize;
end;

///////////////////////////
//
// TprPreviewForm
//
///////////////////////////
procedure TprPreviewForm.SetPreviewChanged;
begin
FPreviewChanged := Value;
end;

procedure TprPreviewForm.mToolbarsClick(Sender: TObject);
var
  i : integer;
  tb : TToolBar;
begin
with TMenuItem(Sender) do
  for i:=0 to Count-1 do
    begin
      tb := TToolBar(Self.FindComponent(Copy(Items[i].Name,2,Length(Items[i].Name)-1)));
      Items[i].Checked := (tb<>nil) and tb.Visible;
    end;
end;

procedure TprPreviewForm.ToolBarMenuItemClick;
var
  tb : TToolBar;
begin
TMenuItem(Sender).Checked := not TMenuItem(Sender).Checked;
tb := TToolBar(FindComponent(Copy(TMenuItem(Sender).Name,2,Length(TMenuItem(Sender).Name)-1)));
if tb<>nil then
  tb.Visible := TMenuItem(Sender).Checked;
end;

function TprPreviewForm.GetToolbar;
var
  s : string;
begin
s := GetEnumName(TypeInfo(TprPreviewToolbars),integer(t));
s := 'tb'+Copy(s,5,Length(s)-4);
Result := TToolBar(FindComponent(s));
end;

procedure TprPreviewForm.prRestoreProperties;
var
  i : integer;
  tb : TToolBar;
begin
inherited;
for i:=integer(Low(TprPreviewToolbars)) to integer(High(TprPreviewToolbars)) do
  begin
    tb := GetToolbar(TprPreviewToolbars(i));
    if tb<>nil then
      tb.Visible := (TprPreviewToolbars(i) in TprReport(Report).PreviewParams.ShowToolbars) and ini.ReadBool(sn,tb.Name,tb.Visible);
  end;
InitmToolbars;

Preview.FShowGrid := Ini.ReadBool(sn,'GridShow',Preview.FShowGrid);
Preview.FGridSize := Ini.ReadInteger(sn,'GridSize',Preview.FGridSize);
Preview.FUseGrid := Ini.ReadBool(sn,'GridAlign',Preview.FUseGrid);
end;

procedure TprPreviewForm.prSaveProperties;
var
  i : integer;
  tb : TToolBar;
begin
inherited;
for i:=integer(Low(TprPreviewToolbars)) to integer(High(TprPreviewToolbars)) do
  if TprPreviewToolbars(i) in TprReport(Report).PreviewParams.ShowToolbars then
    begin
      tb := GetToolbar(TprPreviewToolbars(i));
      if tb<>nil then
        ini.WriteBool(sn,tb.Name,tb.Visible);
    end;
    
Ini.WriteBool(sn,'GridShow',Preview.FShowGrid);
Ini.WriteInteger(sn,'GridSize',Preview.FGridSize);
Ini.WriteBool(sn,'GridAlign',Preview.FUseGrid);
end;

procedure TprPreviewForm.InitmToolbars;
var
  i : integer;
  m : TMenuItem;
  tb : TToolBar;
begin
while mToolbars.Count>0 do
  MToolbars.Items[0].Free;
if prpoAllowShowHideToolbars in TprReport(Report).PreviewParams.Options then
  for i:=integer(Low(TprPreviewToolbars)) to integer(High(TprPreviewToolbars)) do
    begin
      tb := GetToolbar(TprPreviewToolbars(i));
      if (tb<>nil) and (TprPreviewToolbars(i) in TprReport(Report).PreviewParams.ShowToolbars) then
        begin
          m := TMenuItem.Create(Self);
          m.Name := 'm'+tb.Name;
          m.Caption := tb.Caption;
          m.OnClick := ToolBarMenuItemClick;
          mToolbars.Add(m);
        end;
    end;
mToolbars.Visible := mToolbars.Count>0;
N11.Visible := mToolbars.Count>0;
end;

procedure TprPreviewForm.InitForm;
begin
if not (prpoShowMenu in TprReport(Report).PreviewParams.Options) then
  Menu := nil
else
  Menu := MainMenu;
if prpoAllowDragToolbars in TprReport(Report).PreviewParams.Options then
  begin
    tbPreviewCommon.DragKind := dkDock;
    tbText.DragKind := dkDock;
    tbBorders.DragKind := dkDock;
    tbAlign.DragKind := dkDock;
    tbSize.DragKind := dkDock;
    tbNudge.DragKind := dkDock;
    tbObjects.DragKind := dkDock;
    tbObject.DragKind := dkDock;
  end;
if Report.CanUserEdit then
  aPreviewEdit.Caption := prLoadStr(sPreviewModePreview)
else
  aPreviewEdit.Caption := prLoadStr(sPreviewModeEdit)
end;

procedure TprPreviewForm.FormCreate(Sender: TObject);
begin
prLoadResImages(Self,ImageList);
if Report.Title='' then
  Caption := Format(prLoadStr(sPreviewCaption),[prLoadStr(sNoReportName)])
else
  Caption := Format(prLoadStr(sPreviewCaption),[Report.Title]);
SaveDialog.Filter := prLoadStr(sPreviewFileMask);
OpenDialog.Filter := prLoadStr(sPreviewFileMask);

InitForm;
InitprObjToolbar(Report,Self,tbObjects,OnObjButtonClick);
bObjArrow.OnClick := OnObjButtonClick;

ControlBar1.OnBandInfo := ControlBar1BandInfo;

Preview := TprPreviewBox.CreatePreview(Self,TprReport(Report));
Preview.Parent := Self;
Preview.Align := alClient;
Preview.StatusBar := SB;
Preview.ProgressBar := TProgressBar.Create(Self);
Preview.ProgressBar.Parent := SB;
Preview.OnScalePercentChanged := ScaleChanged;
Preview.OnSelectionChanged := SelectionChanged;
Preview.OnObjectsPropsChanged := ObjectsPropsChanged;
Preview.PopupMenu := PMPreview;

UpdateStatusBar;
SelectionChanged(Preview);

aCustomAction.Hint := Report.CustomActionInPreviewCaption;
ActiveControl := Preview;
end;

procedure TprPreviewForm.OnObjButtonClick;
var
  Tag : integer;
begin
(Sender as TToolButton).Down := true;
Tag := (Sender as TToolButton).Tag;
if Tag=-1 then
  begin
    Preview.InsertObj(nil);
  end
else
  begin
    //  
    Preview.InsertObj(prObjRegInfos[Tag].ClassRef);
  end;
end;

procedure TprPreviewForm.ScaleChanged;
begin
EDScale.Text := Format('%d %%',[Preview.ScaleKoef]);
end;

procedure TprPreviewForm.aCloseExecute(Sender: TObject);
begin
Close;
end;

procedure TprPreviewForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
Preview.StatusBar := nil;
Preview.ProgressBar := nil;
Action := caFree;
end;

procedure TprPreviewForm.EDScaleKeyPress(Sender: TObject; var Key: Char);
begin
if (Key=#13) and (Trim(EDScale.Text)<>'') then
  begin
    Preview.ScalePercent := StrToIntDef(Trim(EDScale.Text),100);
    Preview.ScaleMode := smOnePagePercent;
  end;
end;

procedure TprPreviewForm.aSaveExecute(Sender: TObject);
begin
if SaveDialog.Execute then
  Report.SavePreparedReportToFile(SaveDialog.FileName);
end;

procedure TprPreviewForm.aOpenExecute(Sender: TObject);
begin
if OpenDialog.Execute then
  begin
    Preview.LoadPreparedReport(OpenDialog.FileName);
    UpdateStatusBar;
  end;
end;

procedure TprPreviewForm.WMGetDlgCode;
begin
inherited;
Message.Result := Message.Result and not DLGC_WANTARROWS;
end;

procedure TprPreviewForm.UpdateStatusBar;
begin
SB.Panels[0].Text := Format(prLoadStr(sTotalPages),[Report.EndPagesCount]);
end;

procedure TprPreviewForm.SBDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
begin
if Panel.Index=2 then
  Preview.rpdi.ProgressBar.SetBounds(Rect.Left-1,Rect.Top-1,Rect.Right-Rect.Left+2,Rect.Bottom-Rect.Top+2);
end;

procedure TprPreviewForm.aCustomActionUpdate(Sender: TObject);
begin
TAction(Sender).Enabled := Assigned(Report.OnCustomActionInPreview);
end;          

procedure TprPreviewForm.aCustomActionExecute(Sender: TObject);
begin
DoOnCustomAction;
end;

procedure TprPreviewForm.aExportToXLSUpdate(Sender: TObject);
begin
TAction(Sender).Enabled := true;
end;
                                                      
procedure TprPreviewForm.aExportToXLSExecute(Sender: TObject);
begin
TprReport(Report).ExportToXLS;
end;

procedure TprPreviewForm.UpdateToolbar;
var
  i : integer;
  cs : TCardinalSet;
  fEnabled,fEnabledBorders : boolean;
begin
FUpdated:=true;
fEnabled := false;
fEnabledBorders := false;
if Report.CanUserEdit then
  begin
    i := 0;
    while i<Preview.FSelObjs.Count do
      begin
        fEnabled := fEnabled or (Preview.SelObjs[i] is TprMemoObjRecVersion);
        fEnabledBorders := fEnabledBorders or (Preview.SelObjs[i] is TprRichObjRecVersion);
        Inc(i);
      end;
  end;

for i:=0 to tbText.ControlCount-1 do
  tbText.Controls[i].Enabled := fEnabled;
for i:=0 to tbBorders.ControlCount-1 do
  tbBorders.Controls[i].Enabled := fEnabledBorders or fEnabled;

if fEnabled or fEnabledBorders then
  begin
    //    
    if fEnabled then
      begin
        FFontColor := prGetPropDef(Preview.FSelObjs,'Font.Color',clBlack);
        FFillColor := prGetPropDef(Preview.FSelObjs,'FillColor',clNone);
        CBFontName.ItemIndex := CBFontName.Items.IndexOf(prGetPropDef(Preview.FSelObjs,'Font.Name',''));
        i := prGetPropDef(Preview.FSelObjs,'Font.Size',-1);
        if i=-1 then
          CBFontSize.Text := ''
        else
          begin
            CBFontSize.ItemIndex := CBFontSize.Items.IndexOf(IntToStr(i));
            if CBFontSize.ItemIndex=-1 then
              CBFontSize.Text := IntToStr(i);
          end;

        cs := (TCardinalSet(cardinal(prGetPropDef(Preview.FSelObjs,'Font.Style',0))));
        bBold.Down := cardinal(fsBold) in cs;
        bItalic.Down := cardinal(fsItalic) in cs;
        bUnderline.Down := cardinal(fsUnderLine) in cs;

        case TprHAlign(prGetPropDef(Preview.FSelObjs,'hAlign',-1)) of
          prhLeft : bHLeft.Down := true;
          prhCenter : bHCenter.Down := true;
          prhRight : bHRight.Down := true;
          else
            begin
              bHLeft.Down := false;
              bHCenter.Down := false;
              bHRight.Down := false;
            end;
        end;

        case TprVAlign(prGetPropDef(Preview.FSelObjs,'vAlign',-1)) of
          prvTop : bVTop.Down := true;
          prvCenter : bVCenter.Down := true;
          prvBottom : bVBottom.Down := true;
          else
            begin
              bVTop.Down := false;
              bVCenter.Down := false;
              bVBottom.Down := false;
            end;
        end;
    end;

    bbTop.Down := prGetPropDef(Preview.FSelObjs,'tBorder.Show',false);
    bbLeft.Down := prGetPropDef(Preview.FSelObjs,'lBorder.Show',false);
    bbRight.Down := prGetPropDef(Preview.FSelObjs,'rBorder.Show',false);
    bbBottom.Down := prGetPropDef(Preview.FSelObjs,'bBorder.Show',false);
  end;
FUpdated := false;
end;

procedure TprPreviewForm.SelectionChanged;
begin
UpdateToolbar;
end;

procedure TprPreviewForm.ObjectsPropsChanged;
begin
UpdateToolbar;
end;

var
  Cur : HCURSOR;
  
procedure TprPreviewForm.CBFontNameClick(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;
for i:=0 to Preview.FSelObjs.Count-1 do
  if Preview.SelObjs[i] is TprMemoObjRecVersion then
    begin
      TprMemoObjRecVersion(Preview.SelObjs[i]).Font.Name := CBFontName.Items[CBFontName.ItemIndex];
      PreviewChanged := true;
    end;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.CBFontSizeChange(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;
for i:=0 to Preview.FSelObjs.Count-1 do
  if Preview.SelObjs[i] is TprMemoObjRecVersion then
    begin
      TprMemoObjRecVersion(Preview.SelObjs[i]).Font.Size := StrToInt(CBFontSize.Text);
      PreviewChanged := true;
    end;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.bBoldClick(Sender: TObject);
var
  i : integer;
  fs : TFontStyles;
begin
if fUpdated then exit;
if Sender=bBold then
  fs := [fsBold]
else
  if Sender=bItalic then
    fs := [fsItalic]
  else
    if Sender=bUnderline then
      fs := [fsUnderline]
    else
      exit;
for i:=0 to Preview.FSelObjs.Count-1 do
  if Preview.SelObjs[i] is TprMemoObjRecVersion then
    begin
      if TToolButton(Sender).Down then
        TprMemoObjRecVersion(Preview.SelObjs[i]).Font.Style := TprMemoObjRecVersion(Preview.SelObjs[i]).Font.Style+fs
      else
        TprMemoObjRecVersion(Preview.SelObjs[i]).Font.Style := TprMemoObjRecVersion(Preview.SelObjs[i]).Font.Style-fs;
      PreviewChanged := true;
    end;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.SetPopupColor;
var
  i : integer;
begin
if fUpdated then exit;
FOtherColor := FPaletteForm.OtherColor;
for i:=0 to Preview.FSelObjs.Count-1 do
  if Preview.SelObjs[i] is TprMemoObjRecVersion then
    begin
      if IsFillColor then
        TprMemoObjRecVersion(Preview.SelObjs[i]).FillColor := Color
      else
        TprMemoObjRecVersion(Preview.SelObjs[i]).Font.Color := Color;
      PreviewChanged := true;
    end;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.FontColorSetColor;
begin
FFontColor := Color;
SetPopupColor(false,Color);
end;

procedure TprPreviewForm.FillColorSetColor;
begin
FFillColor := Color;
SetPopupColor(true,Color);
end;

procedure TprPreviewForm.bFontColorClick(Sender: TObject);
var
  p : TPoint;
begin
if Sender=bFontColor then
  begin
    p := bFontColor.ClientToScreen(point(0,0));
    FPaletteForm := PopupPaletteForm(Self,
                     p.x,
                     p.y+bFontColor.Height,
                     FFontColor,
                     FOtherColor,
                     FontColorSetColor,
                     prLoadStr(sColorBtnOtherColorCaption),
                     prLoadStr(sColorBtnNoColorCaption))
  end
else
  if Sender=bFillColor then
    begin
      p := bFillColor.ClientToScreen(point(0,0));
      FPaletteForm := PopupPaletteForm(Self,
                       p.x,
                       p.y+bFillColor.Height,
                       FFillColor,
                       FOtherColor,
                       FillColorSetColor,
                       prLoadStr(sColorBtnOtherColorCaption),
                       prLoadStr(sColorBtnNoColorCaption))
    end;
end;

procedure TprPreviewForm.bHLeftClick(Sender: TObject);
var
  i : integer;
  a : TprHAlign;
begin
if fUpdated then exit;
if bHLeft.Down then
  a := prhLeft
else
  if bHCenter.Down then
    a := prhCenter
  else
    if bHRight.Down then
      a := prhRight
    else
      exit;
for i:=0 to Preview.FSelObjs.Count-1 do
  if Preview.SelObjs[i] is TprMemoObjRecVersion then
    begin
      TprMemoObjRecVersion(Preview.SelObjs[i]).hAlign := a;
      PreviewChanged := true;
    end;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.bVTopClick(Sender: TObject);
var
  i : integer;
  a : TprVAlign;
begin
if fUpdated then exit;

if bVTop.Down then
  a:=prvTop
else
  if bVCenter.Down then
    a:=prvCenter
  else
    if bVBottom.Down then
      a:=prvBottom
    else
      exit;

for i:=0 to Preview.FSelObjs.Count-1 do
  if Preview.SelObjs[i] is TprMemoObjRecVersion then
    begin
      TprMemoObjRecVersion(Preview.SelObjs[i]).vAlign := a;
      PreviewChanged := true;
    end;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.bbTopClick(Sender: TObject);
var
  s : string;
begin
if fUpdated then exit;
if Sender=bbTop then
  s := 'tBorder.Show'
else
  if Sender=bbLeft then
    s := 'lBorder.Show'
  else
    if Sender=bbBottom then
      s := 'bBorder.Show'
    else
      if Sender=bbRight then
        s := 'rBorder.Show'
      else
        exit;
prSetProp(Preview.FSelObjs,s,TToolButton(Sender).Down,false);
PreviewChanged := true;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.bbAllClick(Sender: TObject);
begin
if fUpdated then exit;
prSetProp(Preview.FSelObjs,'tBorder.Show',Sender=bbAll,false);
prSetProp(Preview.FSelObjs,'bBorder.Show',Sender=bbAll,false);
prSetProp(Preview.FSelObjs,'lBorder.Show',Sender=bbAll,false);
prSetProp(Preview.FSelObjs,'rBorder.Show',Sender=bbAll,false);
PreviewChanged := true;
Preview.UpdateSelectedObjects;
end;

procedure TprPreviewForm.aHToLeftUpdate(Sender: TObject);
begin
if (Sender=aHToLeft) or (Sender=aHCenters) or (Sender=ahToRight) or
   (Sender=aVToTop) or (Sender=aVCenters) or (Sender=avToBottom) or
   (Sender=aWToSmall) or (Sender=aWToLarge) or (Sender=aHToSmall) or (Sender=aHToLarge) then
  begin
    TAction(Sender).Enabled := Report.CanUserEdit and (Preview.FSelObjs.Count>=2);
  end
else
  if (Sender=aHCenterInWindow) or (Sender=aVCenterInWindow) or
     (Sender=aOLeft) or (Sender=aORight) or (Sender=aOTop) or (Sender=aOBottom) or
     (Sender=aSLeft) or (Sender=aSRight) or (Sender=aSTop) or (Sender=aSBottom) or
     (Sender=aAlignToGridLeftTop) or (Sender=aAlignToGridAll) then
    begin
      TAction(Sender).Enabled := Report.CanUserEdit and (Preview.FSelObjs.Count>=1);
    end
  else
    begin
      TAction(Sender).Enabled := Report.CanUserEdit and (Preview.FSelObjs.Count>=3);
    end;
end;

procedure TprPreviewForm.aHToLeftExecute(Sender: TObject);
begin
Preview.AlignAction(TprAlignActionCode(GetEnumValue(TypeInfo(TprAlignActionCode),'aac'+Copy(TAction(Sender).Name,2,Length(TAction(Sender).Name)))));
end;

procedure TprPreviewForm.aSLeftExecute(Sender: TObject);
begin
if Sender=aSLeft then
  Preview.Size(-1,0)
else
  if Sender=aSRight then
    Preview.Size(1,0)
  else
    if Sender=aSTop then
      Preview.Size(0,-1)
    else
      if Sender=aSBottom then
        Preview.Size(0,1);
end;

procedure TprPreviewForm.aOLeftExecute(Sender: TObject);
begin
if Sender=aOLeft then
  Preview.Nudge(-1,0)
else
  if Sender=aORight then
    Preview.Nudge(1,0)
  else
    if Sender=aOTop then
      Preview.Nudge(0,-1)
    else
      if Sender=aOBottom then
        Preview.Nudge(0,1);
end;

procedure TprPreviewForm.aPrintExecute(Sender: TObject);
begin
Preview.ProcessAction(TprPreviewAction(GetEnumValue(TypeInfo(TprPreviewAction),'prp'+TAction(Sender).Name)));
end;

procedure TprPreviewForm.aPrintUpdate(Sender: TObject);
begin
TAction(Sender).Enabled := Preview.AllowAction(TprPreviewAction(GetEnumValue(TypeInfo(TprPreviewAction),'prp'+TAction(Sender).Name)));
if Sender=aShowGrid then
  aShowGrid.Checked := Preview.ShowGrid
else
  if Sender=aAlignToGrid then
    aAlignToGrid.Checked := Preview.UseGrid;
end;

procedure TprPreviewForm.aNewPageExecute(Sender: TObject);
begin
Preview.ProcessAction(prpaNewPage);
UpdateStatusBar;
end;

procedure TprPreviewForm.aDelPageExecute(Sender: TObject);
begin
Preview.ProcessAction(prpaDelPage);
UpdateStatusBar;
end;

procedure TprPreviewForm.aPageParamsExecute(Sender: TObject);
begin
Preview.ProcessAction(prpaPageParams);
UpdateStatusBar;
end;

procedure TprPreviewForm.aPreviewEditExecute(Sender: TObject);
var
  i : TprPreviewToolbars;
  a : array [TprPreviewToolbars] of TPoint;
  tb : TToolBar;
begin
Report.CanUserEdit := not Report.CanUserEdit;
if Report.CanUserEdit then
  begin
    TprReport(Report).PreviewParams.Options := [prpoAllowChangePreviewMode,prpoShowMenu,prpoAllowShowHideToolbars,prpoAllowDragToolbars];
    TprReport(Report).PreviewParams.ShowToolbars := [prptPreviewCommon,prptEdit,prptInsertObject,prptText,prptBorders,prptAlign,prptSize,prptNudge,prptObjects,prptObject];
  end
else
  begin
    Preview.ObjectsPropsForm.Hide;
    TprReport(Report).PreviewParams.Options := [prpoAllowChangePreviewMode];
    TprReport(Report).PreviewParams.ShowToolbars := [prptPreviewCommon];
  end;
if Assigned(TprReport(Report).OnPreviewModeChanged) then
  TprReport(Report).OnPreviewModeChanged(Self);
// Show/Hide toolbars
for i:=Low(TprPreviewToolbars) to High(TprPreviewToolbars) do
  begin
    tb := GetToolbar(i);
    if tb<>nil then
      a[i] := Point(tb.Left,tb.Top);
  end;
for i:=Low(TprPreviewToolbars) to High(TprPreviewToolbars) do
  begin
    tb := GetToolbar(i);
    if tb<>nil then
      tb.Visible := i in TprReport(Report).PreviewParams.ShowToolbars;
  end;
for i:=Low(TprPreviewToolbars) to High(TprPreviewToolbars) do
  begin
    tb := GetToolbar(i);
    if tb<>nil then
      begin
        tb.Left := a[i].x;
        tb.Top := a[i].y;
      end;
  end;

InitmToolbars;
InitForm;
end;

procedure TprPreviewForm.aPreviewEditUpdate(Sender: TObject);
begin
TAction(Sender).Enabled := prpoAllowChangePreviewMode in TprReport(Report).PreviewParams.Options;
end;

procedure TprPreviewForm.ControlBar1BandInfo(Sender: TObject;
  Control: TControl; var Insets: TRect; var PreferredSize,
  RowCount: Integer);
begin
if (Control<>nil) and (Control.Tag<>0) then
  PreferredSize := Control.Tag;
end;

initialization

RegisterClass(TprPreviewForm);

Cur := LoadImage(hInstance,'PR_SCROLL',IMAGE_CURSOR,0,0,LR_DEFAULTSIZE or LR_DEFAULTCOLOR);
if Cur=0 then
  FNormalCursor := crArrow
else
  begin
    Screen.Cursors[crPreviewNormalCursor] := Cur;
    FNormalCursor := crPreviewNormalCursor;
  end;

Cur := LoadImage(hInstance,'PR_SCROLLDRAG',IMAGE_CURSOR,0,0,LR_DEFAULTSIZE or LR_DEFAULTCOLOR);
if Cur=0 then
  FScrollCursor := crArrow
else
  begin
    Screen.Cursors[crPreviewScrollCursor] := Cur;
    FScrollCursor := crPreviewScrollCursor;
  end;

end.

