{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_PageParams;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ComCtrls, StdCtrls, ExtCtrls, Pr_Utils,

  pr_Common, pr_Classes, pr_MultiLang;

type
  TprPageParamsForm = class(TprForm)
    PC: TPageControl;
    TabSheet1: TTabSheet;
    TabSheet2: TTabSheet;
    bOK: TButton;
    bCancel: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    iPagePortrait: TImage;
    iPageLandscape: TImage;
    RBPortrait: TRadioButton;
    RBLandscape: TRadioButton;
    EDPaperSize: TComboBox;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    EDPageWidth: TEdit;
    EDPageHeight: TEdit;
    UDPageWidth: TUpDown;
    UDPageHeight: TUpDown;
    CBOther: TCheckBox;
    Label2: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    EDLeft: TEdit;
    EDTop: TEdit;
    EDRight: TEdit;
    EDBottom: TEdit;
    UDLeft: TUpDown;
    UDTop: TUpDown;
    UDRight: TUpDown;
    UDBottom: TUpDown;
    Label8: TLabel;
    Label9: TLabel;
    Bevel1: TBevel;
    Bevel2: TBevel;
    EDTopMin: TEdit;
    EDBottomMin: TEdit;
    EDLeftMin: TEdit;
    EDRightMin: TEdit;
    prMLRes1: TprMLRes;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure RBPortraitClick(Sender: TObject);
    procedure bOKClick(Sender: TObject);
    procedure CBOtherClick(Sender: TObject);
  private
    { Private declarations }
    Report : TprReport;
    pInfo : PprPageInfo;
  public
    { Public declarations }
    function EditOptions(_Report : TprReport;
                         var _pInfo : TprPageInfo;
                         var PaperSize : integer;
                         var Orientation : TprPrinterOrientation;
                         var Width,Height,lMargin,tMargin,rMargin,bMargin : integer) : boolean;
  end;

implementation

uses pr_Strings;

{$R *.DFM}

procedure TprPageParamsForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
Action := caFree;
end;

function TprPageParamsForm.EditOptions;
begin
Report := _Report;
pInfo := @_pInfo;
RBPortrait.Checked := Orientation=poPortrait;
RBLandscape.Checked := Orientation=poLandscape;
EDPaperSize.Items.Assign(Report.prPrinter.PaperNames);
EDPaperSize.ItemIndex := Report.prPrinter.GetPaperSizeArrayPos(PaperSize);
CBOther.Checked := EDPaperSize.ItemIndex=-1;
UDPageWidth.Position := Width;
UDPageHeight.Position := Height;
UDLeft.Position := lMargin;
UDTop.Position := tMargin;
UDRight.Position := rMargin;
UDBottom.Position := bMargin;
EDLeftMin.Text := IntToStr(pInfo.mmlMargin);
EDTopMin.Text := IntToStr(pInfo.mmtMargin);
EDRightMin.Text := IntToStr(pInfo.mmrMargin);
EDBottomMin.Text := IntToStr(pInfo.mmbMargin);

RBPortraitClick(nil);
CBOtherClick(nil);

Result := ShowModal=mrOk;
if Result then
  begin
    Orientation := poPortrait;
    if RBLandscape.Checked then
      Orientation := poLandscape;
    if CBOther.Checked then
      begin
        PaperSize := -1;
        Width := UDPageWidth.Position;
        Height := UDPageHeight.Position;
      end
    else
      begin
        PaperSize := Report.prPrinter.PaperSizes[EDPaperSize.ItemIndex];
        Width := UDPageWidth.Position;
        Height := UDPageHeight.Position;
      end;
    lMargin := UDLeft.Position;
    rMargin := UDRight.Position;
    tMargin := UDTop.Position;
    bMargin := UDBottom.Position;
  end;
end;

procedure TprPageParamsForm.RBPortraitClick(Sender: TObject);
begin
iPagePortrait.Visible := RBPortrait.Checked;
iPageLandscape.Visible := RBLandscape.Checked;
end;

procedure TprPageParamsForm.CBOtherClick(Sender: TObject);
begin
EDPageWidth.Enabled := CBOther.Checked;
EDPageHeight.Enabled := CBOther.Checked;
UDPageWidth.Enabled := CBOther.Checked;
UDPageHeight.Enabled := CBOther.Checked;
EDPaperSize.Enabled := not CBOther.Checked;
end;

procedure TprPageParamsForm.bOKClick(Sender: TObject);
begin
if (UDLeft.Position<pInfo.mmlMargin) or
   (UDRight.Position<pInfo.mmrMargin) or
   (UDTop.Position<pInfo.mmtMargin) or
   (UDBottom.Position<pInfo.mmbMargin) then
  begin
    if MBox(prLoadStr(sPageMarginsWarning),prLoadStr(sAttention),MB_YESNO+MB_ICONEXCLAMATION)=IDNO then
      exit;
  end;
ModalResult := mrOk;
end;

end.
