{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_ObjectsProps;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls,

  pr_Common, pr_CommonDesigner, pr_Utils, pr_MultiLang;

type
  TprObjectsPropsForm = class(TprForm)
    Label1: TLabel;
    Panel1: TPanel;
    bOK: TButton;
    bCancel: TButton;
    bApply: TButton;
    prMLRes1: TprMLRes;
    procedure bOKClick(Sender: TObject);
    procedure bCancelClick(Sender: TObject);
    procedure bApplyClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
  protected
    PropsForm : TprPropsForm;
  public
    { Public declarations }
    function  Designer : TprCustomDesignerForm;
    procedure DesignerSelectionChanged;
  end;

implementation

uses pr_Strings;

{$R *.DFM}

function TprObjectsPropsForm.Designer;
begin
Result:=TprCustomDesignerForm(Owner);
end;

procedure TprObjectsPropsForm.DesignerSelectionChanged;
var
  i : integer;
  o : TObject;
  fc : TprPropsFormClass;
  Obj : TObject;
begin
if Designer.SelObjs.Count<=0 then
  begin
    if PropsForm<>nil then
      begin
        PropsForm.Free{Release};
        PropsForm:=nil;
      end;
    Caption:='';
    exit;
  end;

//     
i  :=1;
fc :=nil;
Obj:=TObject(Designer.SelObjs[0]);
while (i<Designer.SelObjs.Count) and
      (CompText(TObject(Designer.SelObjs[i]).ClassName,Obj.ClassName)=0) do Inc(i);

if i>=Designer.SelObjs.Count then
  begin
    //    
    //       
    i:=0;
    while (i<=High(Designer.prInternalPropsForms)) and
          (CompText(Obj.ClassName,Designer.prInternalPropsForms[i].ClassName)<>0) do Inc(i);

    if i<=High(Designer.prInternalPropsForms) then
      begin
        fc:=TprPropsFormClass(GetClass(Designer.prInternalPropsForms[i].PropsFormClassName));
      end
    else
      begin
        i:=0;
        while (i<Length(prObjRegInfos)) and
              (CompText(Obj.ClassName,prObjRegInfos[i].ClassRef.ClassName)<>0) do Inc(i);
        if i<Length(prObjRegInfos) then
          begin
            fc:=TprPropsFormClass(GetClass(prObjRegInfos[i].PropsFormClassName));
          end;
      end;
  end
else
  begin
    //   
  end;

// fc -      
if ((PropsForm<>nil) and (fc=nil)) or
   ((PropsForm<>nil) and not (PropsForm is fc)) then
  begin
    PropsForm.Free{Release};
    PropsForm:=nil;
  end;

if (fc<>nil) and (PropsForm=nil) then
  begin
    PropsForm := fc.CreatePropsForm(Self,Designer);
    with PropsForm do
      begin
        Align := alClient;
        Parent := Self;
      end;
  end;

Caption:='';
if PropsForm<>nil then
  begin
    if Designer.SelObjs.Count=1 then
      begin
        o:=Designer.SelObjs[0];
        if o is TprObj then
          Caption:=TprObj(o).GetDesc
        else
          if o is TprBand then
            Caption:=TprBand(o).GetDrawDesignCaption
          else
            Caption:=o.ClassName;
      end
    else
      Caption:=Format(prLoadStr(sPropsFormManyObjectsSelectedCaption),[Designer.SelObjs.Count])
  end;

if PropsForm<>nil then
  PropsForm.DesignerSelectionChanged;
end;

procedure TprObjectsPropsForm.bOKClick(Sender: TObject);
begin
if PropsForm<>nil then
  begin
    PropsForm.Apply;
    Designer.UpdateTextActions;
  end;
Close;
end;

procedure TprObjectsPropsForm.bCancelClick(Sender: TObject);
begin
if PropsForm<>nil then
  PropsForm.Cancel;
Close;
end;

procedure TprObjectsPropsForm.bApplyClick(Sender: TObject);
begin
if PropsForm<>nil then
  begin
    PropsForm.Apply;
    Designer.UpdateTextActions;
  end;
end;

procedure TprObjectsPropsForm.FormShow(Sender: TObject);
begin
if fsModal in TForm(Owner).FormState then
  begin
    SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE +
      SWP_NOSIZE + SWP_NOACTIVATE + SWP_NOZORDER);

    SetWindowLong (Handle, GWL_HWNDPARENT, Longint(TForm(Owner).Handle));
  end;
end;

procedure TprObjectsPropsForm.FormCreate(Sender: TObject);
begin
Caption:='';
end;

procedure TprObjectsPropsForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if (Key=VK_ESCAPE) and (Shift=[]) then
  begin Key:=0; Close; end;
end;

end.
