{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_Link;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls,

  Pr_Utils, pr_Common, pr_MultiLang;

type
  TprObjLinksForm = class(TprForm)
    PC: TPageControl;
    PLeft: TTabSheet;
    PTop: TTabSheet;
    PWidth: TTabSheet;
    PHeight: TTabSheet;
    LBLeft: TListBox;
    LBTop: TListBox;
    LBWidth: TListBox;
    LBHeight: TListBox;
    Label1: TLabel;
    CBLeftMode: TComboBox;
    Label2: TLabel;
    CBTopMode: TComboBox;
    Label3: TLabel;
    CBWidthMode: TComboBox;
    Label4: TLabel;
    CBHeightMode: TComboBox;
    bDelLink: TSpeedButton;
    prMLRes1: TprMLRes;
    procedure FormShow(Sender: TObject);
    procedure bDelLinkClick(Sender: TObject);
    procedure CBLeftModeChange(Sender: TObject);
    procedure CBTopModeChange(Sender: TObject);
    procedure CBWidthModeChange(Sender: TObject);
    procedure CBHeightModeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Obj : TprObj;

    procedure UpdateObjLinksInfo(_Obj : TprObj);
  end;

implementation

uses
  pr_CommonDesigner, pr_Strings;

{$R *.DFM}

procedure TprObjLinksForm.UpdateObjLinksInfo;

  procedure AddList(var o : TprObjs; LB : TListBox);
  var
    i : integer;
  begin
  LB.Clear;
  for i:=0 to o.Count-1 do
    LB.Items.AddObject(o[i].GetDesc,o[i]);
  if LB.Items.Count>0 then
    LB.ItemIndex:=0;
  end;

begin
Obj    :=_Obj;
if Obj=nil then
  begin
    Caption         :=prLoadStr(sNoObjSelected);
    PC.Visible      :=false;
    bDelLink.Enabled:=false;
  end
else
  begin
    Caption         :=Obj.GetDesc;
    PC.Visible      :=true;
    bDelLink.Enabled:=true;

    AddList(Obj.LeftObjs,LBLeft);
    CBLeftMode.ItemIndex:=integer(Obj.LeftMode);
    
    AddList(Obj.TopObjs,LBTop);
    CBTopMode.ItemIndex:=integer(Obj.TopMode);
    
    AddList(Obj.WidthObjs,LBWidth);
    CBWidthMode.ItemIndex:=integer(Obj.WidthMode);
    
    AddList(Obj.HeightObjs,LBHeight);
    CBHeightMode.ItemIndex:=integer(Obj.HeightMode);
  end;
end;

procedure TprObjLinksForm.FormShow(Sender: TObject);
begin
if fsModal in TForm(Owner).FormState then
  begin
    SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE +
      SWP_NOSIZE + SWP_NOACTIVATE + SWP_NOZORDER);

    SetWindowLong (Handle, GWL_HWNDPARENT, Longint(TForm(Owner).Handle));
  end;
end;

procedure TprObjLinksForm.bDelLinkClick(Sender: TObject);
var
  L : TprObjs;
  LB : TListBox;
begin
case PC.ActivePage.TabIndex of
  0:   begin L:=Obj.LeftObjs; LB:=LBLeft; end;
  1:   begin L:=Obj.TopObjs; LB:=LBTop; end;
  2:   begin L:=Obj.WidthObjs; LB:=LBWidth; end
  else begin L:=Obj.HeightObjs; LB:=LBHeight; end;
end;
if LB.ItemIndex<0 then
  MBError(prLoadStr(sLinkNotSelected))
else
  begin
    TprCustomDesignerForm(Obj.Band.Report.DesignerForm).DrawLinks;

    L.Remove(LB.Items.Objects[LB.ItemIndex]);
    LB.Items.Delete(LB.ItemIndex);
    if LB.Items.Count>0 then
      LB.ItemIndex:=0;

    TprCustomDesignerForm(Obj.Band.Report.DesignerForm).DrawLinks;
    Obj.Report.TemplateChanged:=true;
  end;
end;

procedure TprObjLinksForm.CBLeftModeChange(Sender: TObject);
begin
Obj.LeftMode              :=TprHLinkMode(CBLeftMode.ItemIndex);
Obj.Report.TemplateChanged:=true;
end;

procedure TprObjLinksForm.CBTopModeChange(Sender: TObject);
begin
Obj.TopMode               :=TprVLinkMode(CBTopMode.ItemIndex);
Obj.Report.TemplateChanged:=true;
end;

procedure TprObjLinksForm.CBWidthModeChange(Sender: TObject);
begin
Obj.WidthMode             :=TprHResizeMode(CBWidthMode.ItemIndex);
Obj.Report.TemplateChanged:=true;
end;

procedure TprObjLinksForm.CBHeightModeChange(Sender: TObject);
begin
Obj.HeightMode            :=TprVResizeMode(CBHeightMode.ItemIndex);
Obj.Report.TemplateChanged:=true;
end;

procedure TprObjLinksForm.FormCreate(Sender: TObject);
begin
LoadResImage(bDelLink.Glyph,'DELVERSION');

CBLeftMode.Items.Add(prLoadStr(sLinkLeftDependFromMaxRight));
CBLeftMode.Items.Add(prLoadStr(sLinkLeftDependFromMinRight));

CBTopMode.Items.Add(prLoadStr(sLinkTopDependFromMaxBottom));
CBTopMode.Items.Add(prLoadStr(sLinkTopDependFromMinBottom));

CBWidthMode.Items.Add(prLoadStr(sLinkWidthDependFromMaxRight));
CBWidthMode.Items.Add(prLoadStr(sLinkWidthDependFromMinRight));

CBHeightMode.Items.Add(prLoadStr(sLinkHeightDependFromMaxBottom));
CBHeightMode.Items.Add(prLoadStr(sLinkHeightDependFromMinBottom));
end;

end.

