{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_FontComboBox;

interface

uses
  SysUtils, Messages, Windows, Classes, StdCtrls, graphics, Controls,

  pr_Common;

{$I pr.inc}
{$R prFontComboBox.res}

type

  ////////////////////////////
  //
  // TprFontComboBox
  //
  ////////////////////////////
  TprFontComboBox = class(TCustomComboBox)
  private
    FTempDC : HDC;
    FListFontSize : integer;
    FItemHeight : integer;
    FMaxWidth : integer;
    FDroppingDown : boolean;
    FFocusChanged : boolean;
    FIsFocused : boolean;
    procedure SetListFontSize(Value : integer);
    procedure UpdateItems;
  protected
    procedure AdjustDropDown;  {$IFDEF PR_D6}override;{$ENDIF}
    procedure WMDrawItem(var Msg: TWMDrawItem); message WM_DRAWITEM;
    procedure CNCommand(var Message: TWMCommand); message CN_COMMAND;
    procedure CreateWnd; override;
    procedure WndProc(var Msg: TMessage); override;
  public
    constructor Create(AOwner : TComponent); override;
  published
    property ListFontSize : integer read FListFontSize write SetListFontSize;
    property Anchors;
    property BiDiMode;
    property Color;
    property Constraints;
    property Ctl3D;
    property DragCursor;
    property DragKind;
    property DragMode;
    property DropDownCount;
    property Enabled;
    property Font;
    property ImeMode;
    property ImeName;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property Sorted;
    property TabOrder;
    property TabStop;
    property Text;
    property Visible;
    property OnChange;
    property OnClick;
{$IFDEF PR_D5}
    property OnContextPopup;
{$ENDIF}
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDropDown;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnStartDock;
    property OnStartDrag;
  end;

implementation

var
  TrueTypeBitmap : TBitmap;

////////////////////////
//
// TprFontComboBox
//
////////////////////////
constructor TprFontComboBox.Create;
begin
inherited;
Style := csOwnerDrawFixed;
FListFontSize := 12;
FItemHeight := ItemHeight;
end;

function EnumFontsProc(var LogFont : TLogFont;
                       var TextMetric : TTextMetric;
                       FontType : Integer;
                       Data : Pointer): Integer; stdcall;
var
  f : TLogFont;
  sz : TSize;
  fnt,ofnt : HFONT;
begin
with TprFontComboBox(Data) do
  begin
    Items.AddObject(StrPas(LogFont.lfFaceName),TObject(FontType));

    ZeroMemory(@f,sizeof(f));
    f.lfCharSet := DEFAULT_CHARSET;
    f.lfHeight := -MulDiv(ListFontSize, GetDeviceCaps(FTempDC, LOGPIXELSY), 72);
    strcopy(f.lfFaceName,LogFont.lfFaceName);
    fnt := CreateFontIndirect(F);
    ofnt := SelectObject(FTempDC,fnt);
    GetTextExtentPoint32(FTempDC,LogFont.lfFaceName,strlen(LogFont.lfFaceName),sz);
    if sz.cy>FItemHeight then
      FItemHeight := sz.cy;
    if sz.cx>FMaxWidth then
      FMaxWidth := sz.cx;
    SelectObject(FTempDC,ofnt);
    DeleteObject(fnt);
  end;
Result := 1;
end;

procedure TprFontComboBox.UpdateItems;
begin
Items.BeginUpdate;
Items.Clear;
FItemHeight := 0;
FMaxWidth := 0;
FTempDC := GetDC(0);
EnumFonts(FTempDC,nil,@EnumFontsProc,pointer(Self));
ReleaseDC(0,FTempDC);
FItemHeight := FItemHeight+2;
FMaxWidth := FMaxWidth +4;
SendMessage(Handle,CB_SETITEMHEIGHT,0,FItemHeight);  // update item height
SendMessage(Handle,CB_SETDROPPEDWIDTH,FMaxWidth,0);
Items.EndUpdate;
end;

procedure TprFontComboBox.CreateWnd;
begin
inherited;
UpdateItems;
end;

procedure TprFontComboBox.WndProc;
begin
if Msg.Msg=WM_SIZE then
  begin
    if FDroppingDown then
      begin
        DefaultHandler(Msg);
        Exit;
      end;
  end;
inherited;
end;

procedure TprFontComboBox.SetListFontSize;
begin
if Value<>FListFontSize then
  begin
    FListFontSize := Value;
    RecreateWnd;
  end;
end;

procedure TprFontComboBox.AdjustDropDown;
var
  ItemCount: Integer;
begin
ItemCount := Items.Count;
if ItemCount > DropDownCount then ItemCount := DropDownCount;
if ItemCount < 1 then ItemCount := 1;
FDroppingDown := True;
try
  SetWindowPos(Handle, 0, 0, 0, Width, FItemHeight * ItemCount +
    Height + 2, SWP_NOMOVE + SWP_NOZORDER + SWP_NOACTIVATE + SWP_NOREDRAW +
    SWP_HIDEWINDOW);
finally
  FDroppingDown := False;
end;
SetWindowPos(Handle, 0, 0, 0, 0, 0, SWP_NOMOVE + SWP_NOSIZE +
  SWP_NOZORDER + SWP_NOACTIVATE + SWP_NOREDRAW + SWP_SHOWWINDOW);
end;

procedure TprFontComboBox.CNCommand;
begin
case Message.NotifyCode of
  CBN_DROPDOWN:
    begin
      FFocusChanged := False;
      DropDown;
      AdjustDropDown;
      if FFocusChanged then
      begin
        PostMessage(Handle, WM_CANCELMODE, 0, 0);
        if not FIsFocused then PostMessage(Handle, CB_SHOWDROPDOWN, 0, 0);
      end;
    end;
  CBN_SETFOCUS:
    begin
      FIsFocused := True;
      FFocusChanged := True;
      SetIme;
    end;
  CBN_KILLFOCUS:
    begin
      FIsFocused := False;
      FFocusChanged := True;
      ResetIme;
    end;
  else
    inherited;
end;
end;

procedure TprFontComboBox.WMDrawItem;
var
  F : TLogFont;
  s : string;
  sz : TSize;
  br : HBRUSH;
  Canvas : TCanvas;
  Fnt,ofnt : HFONT;
begin
Msg.Result := 1;
with Msg.DrawItemStruct^ do
  begin
    ZeroMemory(@F,sizeof(F));
    F.lfCharSet := DEFAULT_CHARSET;
    if (itemState and ODS_COMBOBOXEDIT)<>0 then
      begin
        F.lfHeight := -MulDiv(Font.Size, GetDeviceCaps(hDC, LOGPIXELSY), 72);
        StrPCopy(F.lfFaceName,Font.Name);
        if ItemIndex=-1 then
          s := ''
        else
          s := Items[ItemIndex];
      end
    else
      begin
        F.lfHeight := -MulDiv(ListFontSize, GetDeviceCaps(hDC, LOGPIXELSY), 72);
        s := Items[ItemID];
        StrPCopy(F.lfFaceName,s);
      end;
    Fnt := CreateFontIndirect(F);


    if (itemState and ODS_SELECTED)<>0 then
      begin
        SetTextColor(hDC,GetSysColor(COLOR_HIGHLIGHTTEXT));
        br := GetSysColorBrush(COLOR_HIGHLIGHT);
      end
    else
      begin
        SetTextColor(hDC,GetSysColor(COLOR_WINDOWTEXT));
        br := GetSysColorBrush(COLOR_WINDOW);
      end;

    FillRect(hDC,rcItem,br);
    DeleteObject(br);

    ofnt := SelectObject(hDC,Fnt);
    GetTextExtentPoint32(hDC,PChar(s),length(s),sz);
    SetBkMode(hDC,TRANSPARENT);
    TextOut(hDC,rcItem.Left+TrueTypeBitmap.Width+2+2,rcItem.Top+(rcItem.Bottom-rcItem.Top-sz.cy) div 2,PChar(s),Length(s));
    SelectObject(hDC,ofnt);
    DeleteObject(fnt);

    if (ItemID<>$FFFFFFFF) and ((Integer(Items.Objects[ItemID]) and TRUETYPE_FONTTYPE) <> 0) then
      begin
        Canvas := TCanvas.Create;
        try
          Canvas.Handle := hDC;
          Canvas.Draw(rcItem.Left,
                      rcItem.Top+(rcItem.Bottom-rcItem.Top-TrueTypeBitmap.Height) div 2,
                      TrueTypeBitmap);
        finally
          Canvas.Free;
        end;
      end;
  end;
end;

initialization

TrueTypeBitmap := TBitmap.Create;
try
  TrueTypeBitmap.LoadFromResourceName(hInstance,'PR_TRUETYPE');
except
end;
TrueTypeBitmap.TransparentMode := tmAuto;
TrueTypeBitmap.Transparent := true;

finalization

TrueTypeBitmap.Free;

end.
