{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_DesignerFunctions;

{$i pr.inc}

interface

uses
  Windows, Menus, SysUtils, Classes, StdCtrls, comctrls, controls,
  typinfo, graphics, {$ifdef PR_D6} Variants, {$endif}

  pr_Common, pr_MultiLang, pr_Utils, pr_ColorButton;

type
  TprObjectPosSizeProps = (prpsaLeft,prpsaRight,prpsaTop,prpsaBottom,prpsaWidth,prpsaHeight);
  TprObjectPosSizePropsSet = set of TprObjectPosSizeProps;
  TprElementMode = (premNotExists,premExists,premExistsOrNot);
  TCardinalSet = set of 0..SizeOf(Cardinal) * 8 - 1;

  TprClip = (prcsNone,prcsObj,prcsBand);
  TprClipState = set of TprClip;
  rPrPaintStruct = record
    ClipRgn : HRGN;
    ClipState : TprClipState;
  end;
  pPrPaintStruct = ^rPrPaintStruct;

  TprAlignActionCode = (aacHToLeft,
                        aacHToRight,
                        aacVToTop,
                        aacVToBottom,
                        aacHCenters,
                        aacVCenters,
                        aacHCenterInWindow,
                        aacVCenterInWindow,
                        aacWToSmall,
                        aacWToLarge,
                        aacHToSmall,
                        aacHToLarge,
                        aacAlignToGridLeftTop,
                        aacAlignToGridAll,
                        aacHSpaceEqually,
                        aacVSpaceEqually);
                        
const
  CF_PROBJ  = CF_MAX+1;
  CF_VALUES = CF_PROBJ+1;
  CF_GROUPS = CF_VALUES+1;
  CF_PROBJVERSIONS = CF_GROUPS+1;

  SelectPointSize = 5;
  DesignerEmptyString = #12;
  prResizeCursors : array[TprResizeType] of TCursor = (crSizeNWSE,
                                                       crSizeNS,
                                                       crSizeNESW,
                                                       crSizeWE,
                                                       crSizeNWSE,
                                                       crSizeNS,
                                                       crSizeNESW,
                                                       crSizeWE);

procedure InitprObjToolbar(Report : TprCustomReport;
                           DesignerForm : TprForm;
                           Toolbar : TToolbar;
                           _OnClick : TNotifyEvent);

procedure InitBandsMenu(Designer : TprDesigner;
                        PopupMenu : TPopupMenu;
                        _OnClick : TNotifyEvent);

procedure AddRectToRegion(var Rgn : HRGN; const r : TRect; Op : integer = RGN_OR);
function ATG(Coord,Step : integer) : integer;
function NormalizeRect(X1,Y1,X2,Y2 : integer) : TRect;
procedure CalcOffs(dx,dy : integer; ResizeMode : TprResizeType; var oTop,oLeft,oBottom,oRight : integer);
function CSP(X,Y : integer; x2,y2 : integer) : boolean;
function GetResizeType(X,Y : integer; const r : TRect; var ResizeMode : TprResizeType) : boolean;
procedure DrawSelectedObject(DC : HDC; r : TRect; AllowResizeTypes : TprResizeTypeSet);

procedure MakedRecDefVersionList(LSource,LDest : TList);

function prGetListItemString(LB : TComboBox) : string;
function prGetListItemObject(LB : TComboBox) : TObject; 

function prGetProp(L : TList; PropName : string; var PropValue : Variant) : boolean;
function prGetPropDef(L : TList; PropName : string; DefPropValue : Variant) : Variant;
function prGetPropDefBool(L : TList; PropName : string) : TCheckBoxState;
function prGetPropDefSet(L : TList; PropName : string; SetElement : integer) : TprElementMode;
procedure prSetProp(L : TList; PropName : string; const PropValue : Variant; IsNull : boolean);
procedure prSetPropSet(L : TList; PropName : string; SetElement : integer; IncludeFlag : boolean; IsNull : boolean);

procedure SetFrameLine(L : TList; EDShow : TCheckBox; EDStyle : TComboBox; UDWidth : TUpDown; BColor : TprColorButton; Prefix : string);
procedure GetFrameLine(L : TList; EDShow : TCheckBox; EDStyle : TComboBox; UDWidth : TUpDown; BColor : TprColorButton; Prefix : string);
procedure prInitColorButtons(aButtons : array of TprColorButton);
procedure UpdateGridBitmap(var Bitmap : HBITMAP; sx,sy : integer);

implementation

uses
  pr_Strings;

procedure UpdateGridBitmap;
var
  br : HBRUSH;
  DC,MemDC : HDC;
begin
if Bitmap<>0 then
  begin
    DeleteObject(Bitmap);
    Bitmap := 0;
  end;
if (Win32Platform=VER_PLATFORM_WIN32_NT) or ((sx=8) and (sy=8)) then
  begin
    DC := GetDC(0);
    MemDC := CreateCompatibleDC(DC);
    Bitmap := CreateCompatibleBitmap(DC,sx,sy);
    SelectObject(MemDC,Bitmap);
    br := CreateSolidBrush(clWhite);
    FillRect(MemDC,Rect(0,0,sx,sy),br);
    DeleteObject(br);
    SetPixelV(MemDC,0,0,clBlack);
    DeleteDC(MemDC);
    ReleaseDC(0,DC);
  end;
end;

procedure prInitColorButtons;
var
  i : integer;
begin
for i:=0 to High(aButtons) do
  with aButtons[i] do
    begin
      OtherString := prLoadStr(sColorBtnOtherColorCaption);
      TransparentString := prLoadStr(sColorBtnNoColorCaption);      
    end;
end;
 
procedure SetFrameLine;
begin
EDShow.State := prGetPropDefBool(L,Prefix+'Border.Show');
EDStyle.ItemIndex := prGetPropDef(L,Prefix+'Border.Style',-1);
UDWidth.Position := prGetPropDef(L,Prefix+'Border.Width',0);
BColor.SelectedColor := prGetPropDef(L,Prefix+'Border.Color',clDefault);
end;

procedure GetFrameLine;
begin
prSetProp(L,Prefix+'Border.Show',EDShow.State=cbChecked,EDShow.State=cbGrayed);
prSetProp(L,Prefix+'Border.Style',EDStyle.ItemIndex,EDStyle.ItemIndex=-1);
prSetProp(L,Prefix+'Border.Width',UDWidth.Position,UDWidth.Position=0);
prSetProp(L,Prefix+'Border.Color',BColor.SelectedColor,BColor.SelectedColor=clDefault);
end;

procedure MakedRecDefVersionList;
var
  i : integer;
begin
LDest.Clear;
for i:=0 to LSource.Count-1 do
  if TObject(LSource[i]) is TprObj then
    LDest.Add(TprObj(LSource[i]).dRec.Versions[TprObj(LSource[i]).dRec.DefVersion]);
end;

function prGetListItemString;
begin
if LB.ItemIndex=-1 then
  Result:=''
else
  Result:=LB.Items[LB.ItemIndex];
end;

function prGetListItemObject;
begin
if LB.ItemIndex=-1 then
  Result:=nil
else
  Result:=LB.Items.Objects[LB.ItemIndex];
end;

procedure DecompileProp(o : TObject; var obj : TObject; var lpi : PPropInfo; HasSubProp : boolean; PropName,ClassPropName,SubPropName : string);
var
  td : PTypeData;
begin
if HasSubProp then
  begin
    lpi:=GetPropInfo(o.ClassInfo,ClassPropName);
    if (lpi<>nil) and (lpi^.PropType^.Kind=tkClass) then
      begin
        Obj:=TObject(GetOrdProp(o,lpi));
        td :=GetTypeData(lpi^.PropType^);
        lpi:=GetPropInfo(td.ClassType.ClassInfo,SubPropName);
      end;
  end
else
  begin
    Obj:=o;
    lpi:=GetPropInfo(o.ClassInfo,PropName);
  end;
end;

procedure prSetProp;
var
  i,p,PropValueInt : integer;
  Obj : TObject;
  lpi : PPropInfo;
  HasSubProp : boolean;
  PropValueString,ClassPropName,SubPropName : string;
  PropValueExt : extended;
begin
if IsNull then exit;

PropValueInt   :=0;
PropValueExt   :=0.0;
PropValueString:='';
case VarType(PropValue) of
  varSmallint,varInteger,varByte:
    PropValueInt:=PropValue;
  varBoolean:
    if PropValue then
      PropValueInt:=1
    else
      PropValueInt:=0;
  varSingle,varDouble,varCurrency,varDate:
    PropValueExt:=PropValue;
  varOleStr,varString:
    PropValueString:=VarToStr(PropValue);
  else
    exit;
end;

p         :=pos('.',PropName);
HasSubProp:=p<>0;
if HasSubProp then
  begin
    ClassPropName:=Copy(PropName,1,p-1);
    SubPropName  :=Copy(PropName,p+1,Length(PropName));
  end;

for i:=0 to L.Count-1 do
  begin
    DecompileProp(L[i],Obj,lpi,HasSubProp,PropName,ClassPropName,SubPropName);
    if (Obj<>nil) and (lpi<>nil) then
      begin
        case lpi^.PropType^.Kind of
          tkInteger,tkSet,tkEnumeration,tkChar,tkClass:
            SetOrdProp(Obj,lpi,PropValueInt);
          tkString,tkLString:
            SetStrProp(Obj,lpi,PropValueString);
          tkFloat:
            SetFloatProp(Obj,lpi,PropValueExt);
        end;
      end;
  end;
end;

procedure prSetPropSet;
var
//  ti : PTypeInfo;
  i,p : integer;
  Obj : TObject;
  lpi : PPropInfo;
  cs : TCardinalSet;
  HasSubProp : boolean;
  ClassPropName,SubPropName : string;
begin
if IsNull then exit;

p         :=pos('.',PropName);
HasSubProp:=p<>0;
if HasSubProp then
  begin
    ClassPropName:=Copy(PropName,1,p-1);
    SubPropName  :=Copy(PropName,p+1,Length(PropName));
  end;

for i:=0 to L.Count-1 do
  begin
    DecompileProp(L[i],Obj,lpi,HasSubProp,PropName,ClassPropName,SubPropName);
    if (Obj<>nil) and (lpi<>nil) then
      begin
        if lpi^.PropType^.Kind=tkSet then
          begin
            cs:=TCardinalSet(cardinal(GetOrdProp(Obj,lpi)));
            if IncludeFlag then
              Include(cs,SetElement)
            else
              Exclude(cs,SetElement);
            SetOrdProp(Obj,lpi,cardinal(cs));
          end;
      end;
  end;
end;

function prGetProp;
var
//  ti : PTypeInfo;
  f : boolean;
  i,p : integer;
  Obj : TObject;
  Lastlpi,lpi : PPropInfo;
  HasSubProp : boolean;
  FirstOrdProp : longint;
  FirstFloatProp : extended;
  FirstStringProp : string;
  ClassPropName,SubPropName : string;

begin
Result   :=false;
PropValue:=UnAssigned;
if L.Count<=0 then exit;

p         :=pos('.',PropName);
HasSubProp:=p<>0;
if HasSubProp then
  begin
    ClassPropName:=Copy(PropName,1,p-1);
    SubPropName  :=Copy(PropName,p+1,Length(PropName));
  end;

FirstOrdProp   :=0;
FirstStringProp:='';
FirstFloatProp :=0;
Lastlpi        :=nil;

i     :=0;
f     :=true;
Result:=true;
while i<L.Count do
  begin
    DecompileProp(L[i],Obj,lpi,HasSubProp,PropName,ClassPropName,SubPropName);
    if (Obj<>nil) and (lpi<>nil) then
      begin
        Lastlpi:=lpi;
        if f then
          begin
            case lpi^.PropType^.Kind of
              tkInteger,tkSet,tkEnumeration,tkChar,tkClass:
                FirstOrdProp:=GetOrdProp(Obj,lpi);
              tkString,tkLString:
                FirstStringProp:=GetStrProp(Obj,lpi);
              tkFloat:
                FirstFloatProp:=GetFloatProp(Obj,lpi);
            end;
            f:=false;
          end
        else
          begin
            case lpi^.PropType^.Kind of
              tkInteger,tkSet,tkEnumeration,tkChar,tkClass:
                Result:=Result and (FirstOrdProp=GetOrdProp(Obj,lpi));
              tkString,tkLString:
                Result:=Result and (FirstStringProp=GetStrProp(Obj,lpi));
              tkFloat:
                Result:=Result and (FirstFloatProp=GetFloatProp(Obj,lpi));
            end;
          end;
      end;
    Inc(i);
  end;

Result:=Result and (not f);
if Result then
  case Lastlpi^.PropType^.Kind of
    tkInteger,tkSet,tkEnumeration,tkChar,tkClass:
      PropValue:=FirstOrdProp;
    tkString,tkLString:
      PropValue:=FirstStringProp;
    tkFloat:
      PropValue:=FirstFloatProp;
  end
end;

function prGetPropDefSet;
var
//  ti : PTypeInfo;
  i,p : integer;
  Obj : TObject;
  lpi : PPropInfo;
  cs : TCardinalSet;
  HasSubProp : boolean;
  ClassPropName,SubPropName : string;
begin
Result   :=premExistsOrNot;
if L.Count<=0 then exit;

p         :=pos('.',PropName);
HasSubProp:=p<>0;
if HasSubProp then
  begin
    ClassPropName:=Copy(PropName,1,p-1);
    SubPropName  :=Copy(PropName,p+1,Length(PropName));
  end;

i     :=0;
Result:=premExistsOrNot;
while i<L.Count do
  begin
    DecompileProp(L[i],Obj,lpi,HasSubProp,PropName,ClassPropName,SubPropName);
    if (Obj<>nil) and (lpi<>nil) then
      begin
        if lpi^.PropType^.Kind=tkSet then
          begin
            cs:=TCardinalSet(cardinal(GetOrdProp(Obj,lpi)));
            if Result=premExistsOrNot then
              begin
                if SetElement in cs then
                  Result:=premExists
                else
                  Result:=premNotExists;
              end
            else
              begin
                if SetElement in cs then
                  begin
                    if Result=premNotExists then
                      Result:=premExistsOrNot;
                  end
                else
                  begin
                    if Result=premExists then
                      Result:=premExistsOrNot;
                  end;
                if Result=premExistsOrNot then
                  break;
              end;
          end;
      end;
    Inc(i);
  end;
end;

function prGetPropDef;
begin
if not prGetProp(L,PropName,Result) then
  Result:=DefPropValue;
end;

function prGetPropDefBool;
var
  v : Variant;
begin
if not prGetProp(L,PropName,v) then
  Result:=cbGrayed
else
  begin
    if v then
      Result:=cbChecked
    else
      Result:=cbUnchecked;
  end;
end;


procedure AddRectToRegion;
var
  Rgn2 : HRGN;
begin
if Rgn=0 then
  Rgn:=CreateRectRgnIndirect(r)
else
  begin
    Rgn2:=CreateRectRgnIndirect(r);
    CombineRgn(Rgn,Rgn,Rgn2,Op);
    DeleteObject(Rgn2);
  end;
end;

function CSP;
var
  w : integer;
begin
w := SelectPointSize div 2;
Result := PointInRect(X,Y,Rect(x2-w,y2-w,x2+w,y2+w));
end;

procedure DrawSelectedObject;
var
  dx,dy : integer;
begin
dx := (r.Right-r.Left) div 2;
dy := (r.Bottom-r.Top) div 2;
r.Right := r.Right-1;
r.Bottom := r.Bottom-1;

if ppLeftTop in AllowResizeTypes then
  begin
    MoveToEx(DC,r.Left,r.Top,nil);
    LineTo(DC,r.Left,r.Top);
  end;
if (ppTop in AllowResizeTypes) and (r.Right-r.Left>SelectPointSize*2+4) then
  begin
    MoveToEx(DC,r.Left+dx,r.Top,nil);
    LineTo(DC,r.Left+dx,r.Top);
  end;
if ppRightTop in AllowResizeTypes then
  begin
    MoveToEx(DC,r.Right,r.Top,nil);
    LineTo(DC,r.Right,r.Top);
  end;
if (ppRight in AllowResizeTypes) and (r.Bottom-r.Top>SelectPointSize*2+4) then
  begin
    MoveToEx(DC,r.Right,r.Top+dy,nil);
    LineTo(DC,r.Right,r.Top+dy);
  end;
if ppRightBottom in AllowresizeTypes then
  begin
    MoveToEx(DC,r.Right,r.Bottom,nil);
    LineTo(DC,r.Right,r.Bottom);
  end;
if (ppBottom in AllowResizeTypes) and (r.Right-r.Left>SelectPointSize*2+4) then
  begin
    MoveToEx(DC,r.Left+dx,r.Bottom,nil);
    LineTo(DC,r.Left+dx,r.Bottom);
  end;
if ppLeftBottom in AllowResizeTypes then
  begin
    MoveToEx(DC,r.Left,r.Bottom,nil);
    LineTo(DC,r.Left,r.Bottom);
  end;
if (ppLeft in AllowResizeTypes) and (r.Bottom-r.Top>SelectPointSize*2+4) then
  begin
    MoveToEx(DC,r.Left,r.Top+dy,nil);
    LineTo(DC,r.Left,r.Top+dy);
  end;
end;

function GetResizeType;
var
  dx,dy : integer;
begin
Result := true;
dx :=(r.Right-r.Left) div 2;
dy :=(r.Bottom-r.Top) div 2;
if CSP(X,Y,r.Left,r.Top) then
  begin
    ResizeMode := ppLeftTop;
    exit;
  end;

if CSP(X,Y,r.Left+dx,r.Top) then
  begin
    ResizeMode := ppTop;
    exit;
  end;

if CSP(X,Y,r.Right,r.Top) then
  begin
    ResizeMode := ppRightTop;
    exit;
  end;

if CSP(X,Y,r.Right,r.Top+dy) then
  begin
    ResizeMode := ppRight;
    exit;
  end;

if CSP(X,Y,r.Right,r.Bottom) then
  begin
    ResizeMode := ppRightBottom;
    exit;
  end;

if CSP(X,Y,r.Left+dx,r.Bottom) then
  begin
    ResizeMode := ppBottom;
    exit;
  end;

if CSP(X,Y,r.Left,r.Bottom) then
  begin
    ResizeMode := ppLeftBottom;
    exit;
  end;

if CSP(X,Y,r.Left,r.Top+dy) then
  begin
    ResizeMode := ppLeft;
    exit;
  end;
Result := false;
end;

procedure CalcOffs;
begin
oTop := 0;
oLeft := 0;
oRight := 0;
oBottom := 0;
case ResizeMode of
  ppLeftTop:
    begin oTop:=dy; oLeft:=dx; end;
  ppTop:
    begin oTop:=dy end;
  ppRightTop:
    begin oTop:=dy; oRight:=dx; end;
  ppRight:
    begin oRight:=dx; end;
  ppRightBottom:
    begin oBottom:=dy; oRight:=dx; end;
  ppBottom:
    begin oBottom:=dy; end;
  ppLeftBottom:
    begin oBottom:=dy; oLeft:=dx; end;
  ppLeft:
    begin oLeft:=dx; end;
end;
end;

function NormalizeRect;
begin
if X1>X2 then
  begin
    Result.Left :=X2;
    Result.Right:=X1;
  end
else
  begin
    Result.Left :=X1;
    Result.Right:=X2;
  end;
if Y1>Y2 then
  begin
    Result.Top   :=Y2;
    Result.Bottom:=Y1;
  end
else
  begin
    Result.Top   :=Y1;
    Result.Bottom:=Y2;
  end;
end;

function ATG;
begin
Result:=(Coord div Step) * Step
end;

procedure InitBandsMenu;
var
  m : TMenuItem;
  bt : TprBandType;
begin
for bt:=Low(TprBandType) to High(TprBandType) do
  begin
    m        :=TMenuItem.Create(Designer);
    m.Caption:=BandTitles[bt];
    m.Tag    :=integer(bt);
    m.Onclick:=_OnClick;
    m.Enabled:=Designer.Report.GetBandClass(bt)<>nil;
    PopupMenu.Items.Add(m);
  end;
end;

procedure InitprObjToolbar;
var
  i : integer;
  b : TBitmap;
  s : string;
begin
b:=TBitmap.Create;
try
  for i:=0 to High(prObjRegInfos) do
    if Report is prObjRegInfos[i].ReportRef then //// Report.ClassName=prObjRegInfos[i].ReportRef.ClassName then
      begin
        Toolbar.Width := Toolbar.Width+23;

        with TToolButton.Create(DesignerForm) do
          begin
            Parent := Toolbar;
            Left := Toolbar.ClientWidth;
            Caption := prLoadStr(prObjRegInfos[i].CaptionResID);
            Hint := prLoadStr(prObjRegInfos[i].HintResID);
            AllowAllUp := true;
            Grouped := true;
            ShowHint := true;
            Tag := i;
            Style := tbsCheck;
            OnClick := _OnClick;

            s := 'PR_'+AnsiUpperCase(prObjRegInfos[i].ClassRef.ClassName);
            if FindResource(hInstance,PChar(s),RT_BITMAP)=0 then
              s := 'PR_'+AnsiUpperCase(sDefaultObjResName);
            try
              b.LoadFromResourceName(hInstance,s);
            except
            end;
            ImageIndex := Toolbar.Images.AddMasked(b,b.TransparentColor);
          end;
      end;
  Toolbar.Tag := Toolbar.Width;
finally
  b.Free;
end;
end;

end.
