{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_Designer;

interface            
                     
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ActnList, Menus, ExtCtrls,
  TypInfo, Pr_Utils, ClipBrd, IniFiles, ComCtrls,
  StdCtrls, Grids, ToolWin,                    
  

  pr_Common, pr_CommonDesigner, pr_Classes, pr_Link, pr_BandLinks,
  pr_MultiLang, pr_FontComboBox, pr_ColorButton;

type
  TprDPanel = class;
  TprDesignerForm = class;

  //////////////////////
  //
  // TprHLinePanel
  //
  //////////////////////
  TprHLinePanel = class(TPanel)
  protected
    procedure Paint; override;
    procedure Resize; override;
  public
    LeftOffs : integer;
    function Designer : TprDesignerForm;

    constructor Create(AOwner : TComponent); override;
  end;

  //////////////////////
  //
  // TprVLinePanel
  //
  //////////////////////
  TprVLinePanel = class(TPanel)
  protected
    procedure Paint; override;
    procedure Resize; override;
  public
    TopOffs : integer;
    function Designer : TprDesignerForm;

    constructor Create(AOwner : TComponent); override;
  end;

  /////////////////////////////
  //
  // TprDesignerForm
  //
  /////////////////////////////
  TprDesignerForm = class(TprCustomDesignerForm)
    MainMenu: TMainMenu;
    ActionList: TActionList;
    ImageList: TImageList;
    N1: TMenuItem;
    N2: TMenuItem;
    aOpen: TAction;
    aNew: TAction;
    aSave: TAction;
    aSaveAs: TAction;
    aClose: TAction;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    PMInsertBand: TPopupMenu;
    aGroups: TAction;
    N9: TMenuItem;
    aFunc: TAction;
    N10: TMenuItem;
    aDelete: TAction;
    N11: TMenuItem;
    N12: TMenuItem;
    aShowGrid: TAction;
    aAlignToGrid: TAction;
    N13: TMenuItem;
    N14: TMenuItem;
    N15: TMenuItem;
    AlignActionList: TActionList;
    aHToLeft: TAction;
    aHCenterInWindow: TAction;
    aHCenters: TAction;
    aHSpaceEqually: TAction;
    aHToRight: TAction;
    aVToTop: TAction;
    aVCenterInWindow: TAction;
    aVCenters: TAction;
    aVSpaceEqually: TAction;
    aVToBottom: TAction;
    aOLeft: TAction;
    aORight: TAction;
    aOTop: TAction;
    aOBottom: TAction;
    aSLeft: TAction;
    aSRight: TAction;
    aSTop: TAction;
    aSBottom: TAction;
    aPreview: TAction;
    aPrint: TAction;
    aPageParams: TAction;
    N16: TMenuItem;
    N17: TMenuItem;
    N18: TMenuItem;
    aReportParams: TAction;
    N19: TMenuItem;
    N20: TMenuItem;
    N21: TMenuItem;
    aCopy: TAction;
    aPaste: TAction;
    aCut: TAction;
    N22: TMenuItem;
    N23: TMenuItem;
    N24: TMenuItem;
    N25: TMenuItem;
    aNewPage: TAction;
    aDelPage: TAction;
    N27: TMenuItem;
    N28: TMenuItem;
    aNextPage: TAction;
    aPriorPage: TAction;
    N29: TMenuItem;
    N30: TMenuItem;
    N31: TMenuItem;
    N32: TMenuItem;
    SB: TStatusBar;
    aGridSize: TAction;
    N33: TMenuItem;
    aObjLinks: TAction;
    aBandLinks: TAction;
    N34: TMenuItem;
    N26: TMenuItem;
    N35: TMenuItem;
    N36: TMenuItem;
    aSendToBack: TAction;
    aBringToFront: TAction;
    N37: TMenuItem;
    N38: TMenuItem;
    N39: TMenuItem;
    PMDPanel: TPopupMenu;
    N40: TMenuItem;
    N41: TMenuItem;
    N42: TMenuItem;
    N43: TMenuItem;
    N44: TMenuItem;
    N45: TMenuItem;
    aProperties: TAction;
    aInplaceEdit: TAction;
    N46: TMenuItem;
    N47: TMenuItem;
    N48: TMenuItem;
    N49: TMenuItem;
    N50: TMenuItem;
    N51: TMenuItem;
    aWToSmall: TAction;
    aWToLarge: TAction;
    aHToSmall: TAction;
    aHToLarge: TAction;
    aAlignToGridLeftTop: TAction;
    aAlignToGridAll: TAction;
    N52: TMenuItem;
    N53: TMenuItem;
    N54: TMenuItem;
    ControlBar1: TControlBar;
    tbObjects: TToolBar;
    bInsertBand: TToolButton;
    ToolButton18: TToolButton;
    bObjArrow: TToolButton;
    tbText: TToolBar;
    tbFile: TToolBar;
    ToolButton1: TToolButton;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    tbObject: TToolBar;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    ToolButton9: TToolButton;
    ToolButton10: TToolButton;
    ToolButton11: TToolButton;
    ToolButton12: TToolButton;
    ToolButton13: TToolButton;
    ToolButton14: TToolButton;
    ToolButton15: TToolButton;
    CBFontSize: TComboBox;
    bBold: TToolButton;
    bItalic: TToolButton;
    bUnderline: TToolButton;
    ToolButton20: TToolButton;
    bFontColor: TToolButton;
    bFillColor: TToolButton;
    ToolButton23: TToolButton;
    bHLeft: TToolButton;
    bHCenter: TToolButton;
    bHRight: TToolButton;
    ToolButton27: TToolButton;
    bVTop: TToolButton;
    bVCenter: TToolButton;
    bVBottom: TToolButton;
    tbBorders: TToolBar;
    bbTop: TToolButton;
    bbLeft: TToolButton;
    bbBottom: TToolButton;
    bbRight: TToolButton;
    ToolButton35: TToolButton;
    bbAll: TToolButton;
    bbNone: TToolButton;
    tbAlign: TToolBar;
    ToolButton16: TToolButton;
    ToolButton17: TToolButton;
    ToolButton19: TToolButton;
    ToolButton21: TToolButton;
    ToolButton22: TToolButton;
    ToolButton24: TToolButton;
    ToolButton25: TToolButton;
    ToolButton26: TToolButton;
    ToolButton28: TToolButton;
    ToolButton29: TToolButton;
    ToolButton30: TToolButton;
    tbSize: TToolBar;
    ToolButton31: TToolButton;
    ToolButton32: TToolButton;
    ToolButton33: TToolButton;
    ToolButton34: TToolButton;
    ToolButton36: TToolButton;
    ToolButton37: TToolButton;
    ToolButton38: TToolButton;
    ToolButton39: TToolButton;
    ToolButton40: TToolButton;
    tbNudge: TToolBar;
    ToolButton41: TToolButton;
    ToolButton42: TToolButton;
    ToolButton43: TToolButton;
    ToolButton44: TToolButton;
    prMLRes1: TprMLRes;
    N55: TMenuItem;
    N56: TMenuItem;
    mtbFile: TMenuItem;
    mtbObject: TMenuItem;
    mtbObjects: TMenuItem;
    mtbText: TMenuItem;
    mtbBorders: TMenuItem;
    mtbAlign: TMenuItem;
    mtbSize: TMenuItem;
    mtbNudge: TMenuItem;
    ToolButton45: TToolButton;
    aPosSize: TAction;
    N57: TMenuItem;
    N58: TMenuItem;
    CBFontName: TprFontComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure aSaveExecute(Sender: TObject);
    procedure aSaveAsExecute(Sender: TObject);
    procedure aOpenExecute(Sender: TObject);
    procedure aNewExecute(Sender: TObject);
    procedure aCloseExecute(Sender: TObject);
    procedure aGroupsExecute(Sender: TObject);
    procedure aFuncExecute(Sender: TObject);
    procedure aDeleteUpdate(Sender: TObject);
    procedure aDeleteExecute(Sender: TObject);
    procedure aShowGridExecute(Sender: TObject);
    procedure aAlignToGridExecute(Sender: TObject);
    procedure aShowGridUpdate(Sender: TObject);
    procedure aAlignToGridUpdate(Sender: TObject);
    procedure aHCenterInWindowUpdate(Sender: TObject);
    procedure aHToLeftUpdate(Sender: TObject);
    procedure aHSpaceEquallyUpdate(Sender: TObject);
    procedure aSLeftUpdate(Sender: TObject);
    procedure aSTopUpdate(Sender: TObject);
    procedure aOLeftExecute(Sender: TObject);
    procedure aORightExecute(Sender: TObject);
    procedure aOTopExecute(Sender: TObject);
    procedure aOBottomExecute(Sender: TObject);
    procedure aSLeftExecute(Sender: TObject);
    procedure aSRightExecute(Sender: TObject);
    procedure aSTopExecute(Sender: TObject);
    procedure aSBottomExecute(Sender: TObject);
    procedure aPrintExecute(Sender: TObject);
    procedure aPageParamsExecute(Sender: TObject);
    procedure aReportParamsExecute(Sender: TObject);
    procedure aPreviewExecute(Sender: TObject);
    procedure aCopyUpdate(Sender: TObject);
    procedure aPasteUpdate(Sender: TObject);
    procedure aCopyExecute(Sender: TObject);
    procedure aPasteExecute(Sender: TObject);
    procedure aCutExecute(Sender: TObject);
    procedure aNewPageExecute(Sender: TObject);
    procedure aDelPageUpdate(Sender: TObject);
    procedure aDelPageExecute(Sender: TObject);
    procedure aNextPageUpdate(Sender: TObject);
    procedure aNextPageExecute(Sender: TObject);
    procedure aPriorPageExecute(Sender: TObject);
    procedure aPriorPageUpdate(Sender: TObject);
    procedure aGridSizeExecute(Sender: TObject);
    procedure aObjLinksUpdate(Sender: TObject);
    procedure aObjLinksExecute(Sender: TObject);
    procedure aBandLinksUpdate(Sender: TObject);
    procedure aBandLinksExecute(Sender: TObject);
    procedure aSendToBackUpdate(Sender: TObject);
    procedure aSendToBackExecute(Sender: TObject);
    procedure aBringToFrontExecute(Sender: TObject);
    procedure SBDrawPanel(StatusBar: TStatusBar; Panel: TStatusPanel;
      const Rect: TRect);
    procedure CBFontNameClick(Sender: TObject);
    procedure CBFontSizeChange(Sender: TObject);
    procedure bBoldClick(Sender: TObject);
    procedure bHLeftClick(Sender: TObject);
    procedure bVCenterClick(Sender: TObject);
    procedure bbTopClick(Sender: TObject);
    procedure bbLeftClick(Sender: TObject);
    procedure bbBottomClick(Sender: TObject);
    procedure bbRightClick(Sender: TObject);
    procedure bbAllClick(Sender: TObject);
    procedure aPropertiesUpdate(Sender: TObject);
    procedure aInplaceEditUpdate(Sender: TObject);
    procedure aPropertiesExecute(Sender: TObject);
    procedure aInplaceEditExecute(Sender: TObject);
    procedure aAlignToGridAllUpdate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure bFontColorClick(Sender: TObject);
    procedure aCommonAction(Sender: TObject);
    procedure mtbNudgeClick(Sender: TObject);
    procedure aPosSizeUpdate(Sender: TObject);
    procedure aPosSizeExecute(Sender: TObject);
    procedure aSaveUpdate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure N56Click(Sender: TObject);
    procedure aHToLeftExecute(Sender: TObject);
  private
    { Private declarations }
    FGridShow : boolean;
    FGridAlign : boolean;
    FGridSize : integer; //  
    FSelectedTopLeft : TBitmap;
    FSelectedSizes : TBitmap;
    FPaletteForm : TprColorPaletteForm;

    LeftPanel : TprVLinePanel;
    TopPanel : TprHLinePanel;

    FUpdated : boolean;
    FOtherColor : TColor;
    FFontColor : TColor;
    FFillColor : TColor;

    procedure sBoxClick(Sender : TObject; Msg : TWMScroll);

    procedure SetPopupColor(IsFillColor : boolean; Color: TColor);
    procedure FontColorSetColor(Sender: TObject; Color: TColor);
    procedure FillColorSetColor(Sender: TObject; Color: TColor);
  protected
    procedure prRestoreProperties(Ini : TIniFile; sn : string); override;
    procedure prSaveProperties(Ini : TIniFile; sn : string); override;

    function  CreateDPanel : TprCustomDPanel; override;
    function  CreatePage : TprCustomPage; override;

    procedure InitInternalPropsForms; override;
  public
    { Public declarations }
    function  UseGrid : boolean; override;
    function  ShowGrid : boolean; override;
    function  GridSizeX : integer; override;
    function  GridSizeY : integer; override;

    procedure UpdateSelectedRegionSizes(r : TRect; fEmpty : boolean); override;
    procedure UpdateTextActions; override;

    procedure ShowPage(PageIndex : integer); override;
    procedure UpdateStatusBar; override;
  end;

  /////////////////////////////
  //
  // TprDPanel
  //
  /////////////////////////////
  TprDPanel = class(TprCustomDPanel)
  protected
    procedure PaintOther(DC : HDC); override;
  public
    procedure InplaceEditObj(PDI : pDesignInfo); override;
    procedure EndInplaceEdit; override;
    procedure SaveInplaceEdit; override;
  end;

implementation

uses pr_GroupsEditor, pr_ValuesEditor, pr_PageParams, pr_ReportParams,
  pr_Preview, pr_Strings, pr_GridSize, pr_ImageEditor, pr_MemoEditor,
  pr_RichEditor,
  pr_BandEditor, pr_DesignerFunctions, pr_ObjectPosSizeForm;

{$R *.DFM}

var
  LinePanelSize : integer = 16;

////////////////////////////
//
// TprHLinePanel
//
////////////////////////////
constructor TprHLinePanel.Create;
begin
inherited;
end;

function TprHLinePanel.Designer;
begin
Result:=TprDesignerForm(Owner);
end;

procedure TprHLinePanel.Resize;
begin
inherited;
Repaint;
end;

procedure TprHLinePanel.Paint;
var
  s : string;
  i,step,mw,o,n,w : integer;
  nRgn : HRGN;
begin
Step := Round(GetDeviceCaps(Canvas.Handle,LOGPIXELSX)/SantimetersPerInch);

Canvas.Font.Size:=8;
Canvas.Font.Name:=sArialFont;

Canvas.Brush.Color:=clBtnFace;
Canvas.FillRect(Rect(0,0,ClientWidth,ClientHeight));
Canvas.Brush.Color:=clWhite;
Canvas.FillRect(Rect(LinePanelSize+ScrollBoxBorderWidth,0,ClientWidth,ClientHeight-2));

nRgn:=CreateRectRgn(LinePanelSize+ScrollBoxBorderWidth,0,ClientWidth,ClientHeight);
SelectClipRgn(Canvas.Handle,nRgn);
try
  i := Step;
  n := 1;
  o := LinePanelSize+ScrollBoxBorderWidth-LeftOffs;
  mw := TprPage(Designer.Report.Pages[Designer.IndexCurPage]).pInfo.sWidth;

  Canvas.MoveTo(o+Step div 2,5);
  Canvas.LineTo(o+Step div 2,ClientHeight-7);

  while i<mw do
    begin
      s:=IntToStr(n);
      w:=Canvas.TextWidth(s);

      Canvas.TextOut(o+i-w div 2,0,s);

      Canvas.MoveTo(o+i+Step div 2,5);
      Canvas.LineTo(o+i+Step div 2,ClientHeight-7);

      Inc(n);
      i := i+Step;
    end;
finally
  SelectClipRgn(Canvas.Handle,0);
  DeleteObject(nRgn);
end;
end;

////////////////////////////
//
// TprVLinePanel
//
////////////////////////////
constructor TprVLinePanel.Create;
begin
inherited;
Font.Size:=8;
Font.Name:=sArialFont;
end;

function TprVLinePanel.Designer;
begin
Result:=TprDesignerForm(Owner);
end;

procedure TprVLinePanel.Resize;
begin
inherited;
Repaint;
end;

procedure TprVLinePanel.Paint;
var
  s : string;
  i,Step,mh,o,n,w : integer;
  NewH,OldH : HFONT;
  nRgn : HRGN;
begin
Step := Round(GetDeviceCaps(Canvas.Handle,LOGPIXELSY)/SantimetersPerInch);

Canvas.Font.Size:=8;
Canvas.Font.Name:=sArialFont;

Canvas.Brush.Color:=clBtnFace;
Canvas.FillRect(Rect(0,0,ClientWidth,ClientHeight));

Canvas.Brush.Color:=clWhite;
Canvas.FillRect(Rect(0,ScrollBoxBorderHeight,ClientWidth-2,ClientHeight));

nRgn:=CreateRectRgn(0,ScrollBoxBorderHeight,ClientWidth,ClientHeight);
SelectClipRgn(Canvas.Handle,nRgn);
NewH:=Create90Font(Canvas.Font);
OldH:=SelectObject(Canvas.Handle,NewH);
try
  i := Step;
  n := 1;
  o := ScrollBoxBorderHeight-TopOffs;
  mh := TprPage(Designer.Report.Pages[Designer.IndexCurPage]).pInfo.sHeight;

  Canvas.MoveTo(5,o+Step div 2);
  Canvas.LineTo(ClientWidth-7,o+Step div 2);
  while i<mh do
    begin
      s:=IntToStr(n);
      w:=Canvas.TextWidth(s);

      Canvas.TextOut(0,o+i+w div 2,s);

      Canvas.MoveTo(5,o+i+Step div 2);
      Canvas.LineTo(ClientWidth-7,o+i+Step div 2);

      Inc(n);
      i := i+Step;
    end;
finally
  SelectClipRgn(Canvas.Handle,0);
  DeleteObject(nRgn);
  SelectObject(Canvas.Handle,OldH);
  DeleteObject(NewH);
end;
end;

////////////////////////////
//
// TprDPanel
//
////////////////////////////
procedure TprDPanel.PaintOther;
var
  npn1,npn2,opn : HPEN;
begin
npn1:=CreatePen(PS_SOLID,1,clBlack);
npn2:=CreatePen(PS_DOT,1,clBlack);
opn :=SelectObject(DC,npn1);
try
  DrawRect(DC,TprPage(Designer.CurPage).pInfo.PrnSRect);

  SelectObject(DC,npn2);
  DrawRect(DC,TprPage(Designer.CurPage).pInfo.saRect);

finally
  SelectObject(DC,opn);
  DeleteObject(npn1);
  DeleteObject(npn2);
end;
end;

procedure TprDPanel.SaveInplaceEdit;
begin
if FInplaceEditedObj<>nil then
  begin
    TprMemoObj(FInplaceEditedObj).SaveInplaceEdit(FInplaceEditor);
    EndInplaceEdit;
    Report.TemplateChanged:=true;
  end;
end;

procedure TprDPanel.EndInplaceEdit;
  procedure EnableToolbar(tb : TToolbar);
  var
    i : integer;
  begin
  for i:=0 to tb.ControlCount-1 do
    tb.Controls[i].Enabled:=true;
  end;
begin
EnableToolbar(TprDesignerForm(Designer).tbObjects);
EnableToolbar(TprDesignerForm(Designer).tbText);
EnableToolbar(TprDesignerForm(Designer).tbBorders);
inherited;
end;

procedure TprDPanel.InplaceEditObj;

  procedure DisableToolbar(tb : TToolbar);
  var
    i : integer;
  begin
  for i:=0 to tb.ControlCount-1 do
    tb.Controls[i].Enabled:=false;
  end;

begin
DisableToolbar(TprDesignerForm(Designer).tbObjects);
DisableToolbar(TprDesignerForm(Designer).tbText);
DisableToolbar(TprDesignerForm(Designer).tbBorders);

FInplaceEditedObj:=pdi.Parent;
TprObj(FInplaceEditedObj).InplaceEdit(Self,FInplaceEditor);
end;

///////////////////////////////
//
// TprDesignerForm
//
///////////////////////////////
procedure TprDesignerForm.InitInternalPropsForms;
var
  i : TprBandType;
begin
SetLength(prInternalPropsForms,integer(High(TprBandType))+1);

for i:=Low(TprBandType) to High(TprBandType) do
  begin
    prInternalPropsForms[integer(i)].ClassName          :=Report.GetBandClass(i).ClassName;
    prInternalPropsForms[integer(i)].PropsFormClassName :='TprBandEditorForm';
  end;
end;

procedure TprDesignerForm.prRestoreProperties;
begin
inherited;
FGridShow := Ini.ReadBool(sn,'GridShow',FGridShow);
FGridSize := Ini.ReadInteger(sn,'GridSize',FGridSize);
FGridAlign := Ini.ReadBool(sn,'GridAlign',FGridAlign);

tbFile.Visible := ini.ReadBool(sn,'tbFile',tbFile.Visible);
tbObject.Visible := ini.ReadBool(sn,'tbObject',tbObject.Visible);
tbObjects.Visible := ini.ReadBool(sn,'tbObjects',tbObjects.Visible);
tbText.Visible := ini.ReadBool(sn,'tbText',tbText.Visible);
tbBorders.Visible := ini.ReadBool(sn,'tbBorders',tbBorders.Visible);
tbAlign.Visible := ini.ReadBool(sn,'tbAlign',tbAlign.Visible);
tbSize.Visible := ini.ReadBool(sn,'tbSize',tbSize.Visible);
tbNudge.Visible := ini.ReadBool(sn,'tbNudge',tbNudge.Visible);

FDPanel.DesignerGridSizeChanged;
end;

procedure TprDesignerForm.prSaveProperties;
begin
inherited;
Ini.WriteBool(sn,'GridShow',FGridShow);
Ini.WriteInteger(sn,'GridSize',FGridSize);
Ini.WriteBool(sn,'GridAlign',FGridAlign);

ini.WriteBool(sn,'tbFile',tbFile.Visible);
ini.WriteBool(sn,'tbObject',tbObject.Visible);
ini.WriteBool(sn,'tbObjects',tbObjects.Visible);
ini.WriteBool(sn,'tbText',tbText.Visible);
ini.WriteBool(sn,'tbBorders',tbBorders.Visible);
ini.WriteBool(sn,'tbAlign',tbAlign.Visible);
ini.WriteBool(sn,'tbSize',tbSize.Visible);
ini.WriteBool(sn,'tbNudge',tbNudge.Visible);
end;

function TprDesignerForm.UseGrid;
begin
Result:=FGridAlign;
end;

function TprDesignerForm.ShowGrid;
begin
Result:=FGridShow;
end;

function TprDesignerForm.GridSizeX;
begin
Result:=FGridSize;
end;

function TprDesignerForm.GridSizeY;
begin
Result:=FGridSize;
end;

function TprDesignerForm.CreateDPanel;
begin
Result:=TprDPanel.Create(Self);
end;

function TprDesignerForm.CreatePage;
begin
Result:=TprPage.Create(Report.prOwner);
end;

procedure TprDesignerForm.FormCreate(Sender: TObject);

  procedure LoadBitmap(var bmp : TBitmap; ResID : string);
  begin
  bmp:=TBitmap.Create;
  try
    bmp.LoadFromResourceName(hInstance,'PR_'+ResID);
  except
  end;
  bmp.TransparentMode:=tmAuto;
  bmp.Transparent:=true;
  end;

begin
prLoadResImages(Self,ImageList);
InitprObjToolbar(Report,Self,tbObjects,OnObjButtonClick);
InitBandsMenu(Self,PMInsertBand,OnInsertBandClick);

LoadBitmap(FSelectedTopLeft,'SELECTEDTOPLEFT');
LoadBitmap(FSelectedSizes,'SELECTEDSIZES');

fOtherColor:=clBlack;
LinePanelSize := Canvas.TextHeight('0')+3;

FGridSize       :=4;
FGridShow       :=false;
FDPanel.DesignerGridSizeChanged;

TopPanel        :=TprHLinePanel.Create(Self);
TopPanel.Height :=LinePanelSize;
TopPanel.Top    :=ControlBar1.Height+10;
TopPanel.Align  :=alTop;
TopPanel.Parent :=Self;

LeftPanel       :=TprVLinePanel.Create(Self);
LeftPanel.Width :=LinePanelSize;
LeftPanel.Align :=alLeft;
LeftPanel.Parent:=Self;

sBox.OnVScroll   :=sBoxClick;
sBox.OnHScroll   :=sBoxClick;
FDPanel.PopupMenu:=PMDPanel;
bObjArrow.OnClick:=OnObjButtonClick;

PosSizeForm      :=TprObjectPosSizeForm.CreatePosSizeForm(Self,Self);
UpdatePosSizeForm;

ShowPage(IndexCurPage);
end;

procedure TprDesignerForm.sBoxClick;
begin
LeftPanel.TopOffs:=sBox.VertScrollBar.Position;
LeftPanel.Repaint;
TopPanel.LeftOffs:=sBox.HorzScrollBar.Position;
TopPanel.Repaint;
end;

procedure TprDesignerForm.FormDestroy(Sender: TObject);
begin
FSelectedTopLeft.Free;
FSelectedSizes.Free;
end;

procedure TprDesignerForm.ShowPage;
begin
LeftPanel.Height := TprPage(Report.Pages[IndexCurPage]).pInfo.sHeight;
TopPanel.Width := TprPage(Report.Pages[IndexCurPage]).pInfo.sWidth;
FDPanel.Width := TprPage(Report.Pages[IndexCurPage]).pInfo.sWidth;
FDPanel.Height := TprPage(Report.Pages[IndexCurPage]).pInfo.sHeight;
inherited;
end;

procedure TprDesignerForm.UpdateStatusBar;
begin
SB.Panels[0].Text:=Format(prLoadStr(sPageNumber),[IndexCurPage+1,Report.PagesCount]);
end;

procedure TprDesignerForm.UpdateSelectedRegionSizes;

  function ToMM(c : integer; IsVert : boolean) : string;
  begin
  Result:=Trim(Format('%10.2f',[prConvertFromPixels(c,prpsuMM,not IsVert)]));
  end;

begin
if fEmpty then
  begin
    SB.Panels[1].Text:='';
    SB.Panels[2].Text:='';
  end
else
  begin
    SB.Panels[1].Text:=Format('%d,%d (%s,%smm)',[r.Left,
                                                 r.Top,
                                                 ToMM(r.Left,false),
                                                 ToMM(r.Top,True)]);
    SB.Panels[2].Text:=Format('%d,%d (%s,%smm)',[r.Right-r.Left,
                                                 r.Bottom-r.Top,
                                                 ToMM(r.Right-r.Left,false),
                                                 ToMM(r.Bottom-r.Top,true)]);
  end;
case SelCount of
  0 : SB.Panels[3].Text := prLoadStr(sNoObjectsSelected);
  1 : if TObject(SelObjs[0]) is TComponent then
        SB.Panels[3].Text := Format('%s : %s',[TComponent(SelObjs[0]).Name,TComponent(SelObjs[0]).ClassName])
      else
        SB.Panels[3].Text := TObject(SelObjs[0]).ClassName;
  else SB.Panels[3].Text := Format(prLoadStr(sSelectedMoreThenOneObject),[SelCount]);
end;
end;

procedure TprDesignerForm.aSaveExecute(Sender: TObject);
begin
Save;
end;                                       

procedure TprDesignerForm.aSaveAsExecute(Sender: TObject);
begin
SaveAs;
end;

procedure TprDesignerForm.aOpenExecute(Sender: TObject);
begin
Open;
end;

procedure TprDesignerForm.aNewExecute(Sender: TObject);
begin
New;
end;

procedure TprDesignerForm.aCloseExecute(Sender: TObject);
begin
Close;
end;

procedure TprDesignerForm.aGroupsExecute(Sender: TObject);
begin
TprGroupsEditorForm.Create(Application).EditGroups(Report);
UpdateCurrentPage;
end;

procedure TprDesignerForm.aFuncExecute(Sender: TObject);
begin
TprValuesEditorForm.Create(Application).EditValues(Report);
end;

procedure TprDesignerForm.aDeleteUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowDelete;
end;

procedure TprDesignerForm.aDeleteExecute(Sender: TObject);
begin
FDPanel.Delete;
end;

procedure TprDesignerForm.aShowGridExecute(Sender: TObject);
begin
FGridShow:=not FGridShow;
UpdateCurrentPage;
end;

procedure TprDesignerForm.aAlignToGridExecute(Sender: TObject);
begin
FGridAlign:=not FGridAlign;
end;

procedure TprDesignerForm.aShowGridUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
TAction(Sender).Checked:=FGridShow;
end;

procedure TprDesignerForm.aAlignToGridUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
TAction(Sender).Checked:=FGridAlign;
end;

procedure TprDesignerForm.aHCenterInWindowUpdate(Sender: TObject);
begin
//      
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (FDPanel.GetNumDragSelectedRegions>=1);
end;

procedure TprDesignerForm.aHToLeftUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (FDPanel.GetNumDragSelectedRegions>=2);
end;

procedure TprDesignerForm.aHSpaceEquallyUpdate(Sender: TObject);
begin
//      ,   
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (FDPanel.GetNumDragSelectedRegions>=3);
end;

procedure TprDesignerForm.aSLeftUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowSizeLeftRight;
end;

procedure TprDesignerForm.aSTopUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowSizeTopBottom;
end;

procedure TprDesignerForm.aOLeftExecute(Sender: TObject);
begin
FDPanel.Nudge(-1,0);
end;

procedure TprDesignerForm.aORightExecute(Sender: TObject);
begin
FDPanel.Nudge(1,0);
end;

procedure TprDesignerForm.aOTopExecute(Sender: TObject);
begin
FDPanel.Nudge(0,-1);
end;

procedure TprDesignerForm.aOBottomExecute(Sender: TObject);
begin
FDPanel.Nudge(0,1);
end;

procedure TprDesignerForm.aSLeftExecute(Sender: TObject);
begin
FDPanel.Size(-1,0);
end;

procedure TprDesignerForm.aSRightExecute(Sender: TObject);
begin
FDPanel.Size(1,0);
end;

procedure TprDesignerForm.aSTopExecute(Sender: TObject);
begin
FDPanel.Size(0,1);
end;

procedure TprDesignerForm.aSBottomExecute(Sender: TObject);
begin
FDPanel.Size(0,-1);
end;

procedure TprDesignerForm.aPrintExecute(Sender: TObject);
begin
Print;
end;

procedure TprDesignerForm.aPageParamsExecute(Sender: TObject);
var
  p : TprPage;
  lMargin : integer;
  rMargin : integer;
  tMargin : integer;
  bMargin : integer;
  PaperSize : integer;
  Orientation : TprPrinterOrientation;
  Width,Height : integer;
begin
p := TprPage(Report.Pages[IndexCurPage]);
PaperSize := p.PaperSize;
Orientation := p.Orientation;
Width := p.Width;
Height := p.Height;
lMargin := p.lMargin;
rMargin := p.rMargin;
tMargin := p.tMargin;
bMargin := p.bMargin;
if TprPageParamsForm.Create(Application).EditOptions(TprReport(p.Report),p.pInfo,PaperSize,Orientation,Width,Height,lMargin,tMargin,rMargin,bMargin) then
  begin
    p.lMargin := lMargin;
    p.rMargin := rMargin;
    p.tMargin := tMargin;
    p.bMargin := bMargin;
    p.ChangePaper(PaperSize,Width,Height,Orientation);
    UpdateCurrentPage;
    Report.TemplateChanged := true;
  end;
end;

procedure TprDesignerForm.aReportParamsExecute(Sender: TObject);
begin
if TprReportParamsForm.Create(Application).EditParams(TprReport(Report)) then
  begin
    UpdateCurrentPage;
    Report.TemplateChanged:=true;
  end;
end;

procedure TprDesignerForm.aPreviewExecute(Sender: TObject);
begin
if Report.PrepareReport then
  Report.PreviewPreparedReport(true);
end;

procedure TprDesignerForm.aCopyUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowCopy;
end;

procedure TprDesignerForm.aPasteUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.AllowPaste;
end;

procedure TprDesignerForm.aCopyExecute(Sender: TObject);
begin
FDPanel.Copy;
end;

procedure TprDesignerForm.aPasteExecute(Sender: TObject);
begin
FDPanel.Paste;
end;

procedure TprDesignerForm.aCutExecute(Sender: TObject);
begin
FDPanel.Cut;
end;

procedure TprDesignerForm.aNewPageExecute(Sender: TObject);
begin
NewPage;
end;

procedure TprDesignerForm.aDelPageUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (Report.PagesCount>1);
end;

procedure TprDesignerForm.aDelPageExecute(Sender: TObject);
begin
DelPage;
end;

procedure TprDesignerForm.aNextPageUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (IndexCurPage<Report.PagesCount-1);
end;

procedure TprDesignerForm.aNextPageExecute(Sender: TObject);
begin
NextPage;
end;

procedure TprDesignerForm.aPriorPageExecute(Sender: TObject);
begin
PriorPage;
end;

procedure TprDesignerForm.aPriorPageUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (IndexCurPage>0);
end;

procedure TprDesignerForm.aGridSizeExecute(Sender: TObject);
begin
if TprGridSizeForm.Create(Application).EditGridSize(FGridSize) then
  begin
    FDPanel.DesignerGridSizeChanged;
    UpdateCurrentPage;
  end;
end;

procedure TprDesignerForm.aObjLinksUpdate(Sender: TObject);
begin
TAction(Sender).Checked:=ObjLinksForm.Visible;
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprDesignerForm.aObjLinksExecute(Sender: TObject);
begin
ObjLinksForm.Visible:=not ObjLinksForm.Visible;
end;

procedure TprDesignerForm.aBandLinksUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
TAction(Sender).Checked:=BandLinksForm.Visible;
end;

procedure TprDesignerForm.aBandLinksExecute(Sender: TObject);
begin
BandLinksForm.Visible:=not BandLinksForm.Visible;
end;

procedure TprDesignerForm.aSendToBackUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and FDPanel.IsAnyTprObjSelected;
end;

procedure TprDesignerForm.aSendToBackExecute(Sender: TObject);
begin
FDPanel.SendToBack;
end;

procedure TprDesignerForm.aBringToFrontExecute(Sender: TObject);
begin
FDPanel.BringToFront;
end;

procedure TprDesignerForm.SBDrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
var
  b : TBitmap;
begin
if Panel.Index in [1,2] then
  begin
    b:=nil;
    case Panel.Index of
      1: b:=FSelectedTopLeft;
      2: b:=FSelectedSizes;
    end;
    SB.Canvas.FillRect(Rect);
    StatusBar.Canvas.Draw(Rect.Left+1,Rect.Top+1,b);
    SB.Canvas.TextOut(Rect.Left+2+ImageList.Width,Rect.Top+2,Panel.Text);
  end
end;

procedure TprDesignerForm.UpdateTextActions;
var
  i : integer;
  fEnabled,fEnabledBorders : boolean;
  L : TList;
  cs : TCardinalSet;
begin
fUpdated:=true;
//       TprMemoObj
i := 0;
fEnabled := false;
fEnabledBorders := false;
while i<SelObjs.Count do
  begin
    fEnabled := fEnabled or (TObject(SelObjs[i]) is TprMemoObj);
    fEnabledBorders := fEnabledBorders or (TObject(SelObjs[i]) is TprRichObj);
    Inc(i);
  end;

for i:=0 to tbText.ControlCount-1 do
  tbText.Controls[i].Enabled := fEnabled;
for i:=0 to tbBorders.ControlCount-1 do
  tbBorders.Controls[i].Enabled := fEnabledBorders or fEnabled;

if fEnabled or fEnabledBorders then
  begin
    L := TList.Create;
    try
      MakedRecDefVersionList(SelObjs,L);

      //    
      FFontColor := prGetPropDef(L,'Font.Color',clBlack);
      FFillColor := prGetPropDef(L,'FillColor',clNone);
      CBFontName.ItemIndex := CBFontName.Items.IndexOf(prGetPropDef(L,'Font.Name',''));
      i := prGetPropDef(L,'Font.Size',-1);
      if i=-1 then
        CBFontSize.Text := ''
      else
        begin
          CBFontSize.ItemIndex := CBFontSize.Items.IndexOf(IntToStr(i));
          if CBFontSize.ItemIndex=-1 then
            CBFontSize.Text := IntToStr(i);
        end;

      cs:=(TCardinalSet(cardinal(prGetPropDef(L,'Font.Style',0))));
      bBold.Down     :=cardinal(fsBold) in cs;
      bItalic.Down   :=cardinal(fsItalic) in cs;
      bUnderline.Down:=cardinal(fsUnderLine) in cs;

      case TprHAlign(prGetPropDef(L,'hAlign',-1)) of
        prhLeft  : bHLeft.Down  :=true;
        prhCenter: bHCenter.Down:=true;
        prhRight : bHRight.Down :=true;
        else
          begin
            bHLeft.Down  :=false;
            bHCenter.Down:=false;
            bHRight.Down :=false;
          end;
      end;

      case TprVAlign(prGetPropDef(L,'vAlign',-1)) of
        prvTop   : bVTop.Down  :=true;
        prvCenter: bVCenter.Down:=true;
        prvBottom: bVBottom.Down :=true;
        else
          begin
            bVTop.Down   :=false;
            bVCenter.Down:=false;
            bVBottom.Down:=false;
          end;
      end;

      bbTop.Down := prGetPropDef(L,'tBorder.Show',false);
      bbLeft.Down := prGetPropDef(L,'lBorder.Show',false);
      bbRight.Down := prGetPropDef(L,'rBorder.Show',false);
      bbBottom.Down := prGetPropDef(L,'bBorder.Show',false);
    finally
      L.Free;
    end;
  end;
fUpdated:=false;
end;

procedure TprDesignerForm.CBFontNameClick(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;

for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprMemoObj then
    begin
      TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).Font.Name:=CBFontName.Items[CBFontName.ItemIndex];
      Report.TemplateChanged:=true;
    end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.CBFontSizeChange(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;

for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprMemoObj then
    begin
      TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).Font.Size:=StrToInt(CBFontSize.Text);
      Report.TemplateChanged:=true;
    end;

FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bBoldClick(Sender: TObject);
var
  i : integer;
  fs : TFontStyles;
begin
if fUpdated then exit;
if Sender=bBold then
  fs := [fsBold]
else
  if Sender=bItalic then
    fs := [fsItalic]
  else
    if Sender=bUnderline then
      fs := [fsUnderline]
    else
      exit;
for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprMemoObj then
    begin
      if TToolButton(Sender).Down then
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).Font.Style:=TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).Font.Style+fs
      else
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).Font.Style:=TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).Font.Style-fs;
      Report.TemplateChanged:=true;
    end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bHLeftClick(Sender: TObject);
var
  i : integer;
  a : TprHAlign;
begin
if fUpdated then exit;

if bHLeft.Down then
  a:=prhLeft
else
  if bHCenter.Down then
    a:=prhCenter
  else
    if bHRight.Down then
      a:=prhRight
    else
      exit;

for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprMemoObj then
    begin
      TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).hAlign:=a;
      Report.TemplateChanged:=true;
    end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bVCenterClick(Sender: TObject);
var
  i : integer;
  a : TprVAlign;
begin
if fUpdated then exit;

if bVTop.Down then
  a:=prvTop
else
  if bVCenter.Down then
    a:=prvCenter
  else
    if bVBottom.Down then
      a:=prvBottom
    else
      exit;

for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprMemoObj then
    begin
      TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).vAlign:=a;
      Report.TemplateChanged:=true;
    end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bbTopClick(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;
for i:=0 to SelObjs.Count-1 do
  begin
    if TObject(SelObjs[i]) is TprMemoObj then
      begin
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).tBorder.Show := bbTop.Down;
        Report.TemplateChanged := true;
      end;
    if TObject(SelObjs[i]) is TprRichObj then
      begin
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).tBorder.Show := bbTop.Down;
        Report.TemplateChanged := true;
      end;
  end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bbLeftClick(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;
for i:=0 to SelObjs.Count-1 do
  begin
    if TObject(SelObjs[i]) is TprMemoObj then
      begin
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).lBorder.Show := bbLeft.Down;
        Report.TemplateChanged := true;
      end;
    if TObject(SelObjs[i]) is TprRichObj then
      begin
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).lBorder.Show := bbLeft.Down;
        Report.TemplateChanged := true;
      end;
  end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bbBottomClick(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;
for i:=0 to SelObjs.Count-1 do
  begin
    if TObject(SelObjs[i]) is TprMemoObj then
      begin
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).bBorder.Show := bbBottom.Down;
        Report.TemplateChanged := true;
      end;
    if TObject(SelObjs[i]) is TprRichObj then
      begin
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).bBorder.Show := bbBottom.Down;
        Report.TemplateChanged := true;
      end;
  end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bbRightClick(Sender: TObject);
var
  i : integer;
begin
if fUpdated then exit;
for i:=0 to SelObjs.Count-1 do
  begin
    if TObject(SelObjs[i]) is TprMemoObj then
      begin
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).rBorder.Show := bbRight.Down;
        Report.TemplateChanged := true;
      end;
    if TObject(SelObjs[i]) is TprRichObj then
      begin
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).rBorder.Show := bbRight.Down;
        Report.TemplateChanged := true;
      end;
  end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.bbAllClick(Sender: TObject);
var
  i : integer;
  f : boolean;
begin
if fUpdated then exit;
if Sender=bbAll then
  f := true
else
  if Sender=bbNone then
    f := false
  else
    exit;
for i:=0 to SelObjs.Count-1 do
  begin
    if TObject(SelObjs[i]) is TprMemoObj then
      begin
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).tBorder.Show := f;
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).lBorder.Show := f;
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).bBorder.Show := f;
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).rBorder.Show := f;
        Report.TemplateChanged := true;
      end;
    if TObject(SelObjs[i]) is TprRichObj then
      begin
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).tBorder.Show := f;
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).lBorder.Show := f;
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).bBorder.Show := f;
        TprRichObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).rBorder.Show := f;
        Report.TemplateChanged := true;
      end;
  end;
bbTop.Down := f;
bbLeft.Down := f;
bbBottom.Down := f;
bbRight.Down := f;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.aPropertiesUpdate(Sender: TObject);
begin
TAction(Sender).Checked:=ObjectsPropsForm.Visible;
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprDesignerForm.aInplaceEditUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and
                         (SelObjs.Count>0) and
                         (FDPanel.SelPDI[0].Parent is TprObj) and
                         (TprObj(FDPanel.SelPDI[0].Parent).AllowInplaceEdit);
end;

procedure TprDesignerForm.aPropertiesExecute(Sender: TObject);
begin
ObjectsPropsForm.Visible:=not ObjectsPropsForm.Visible;
end;

procedure TprDesignerForm.aInplaceEditExecute(Sender: TObject);
begin
FDPanel.InplaceEditObj(FDPanel.SelPDI[0]);
end;

procedure TprDesignerForm.aAlignToGridAllUpdate(Sender: TObject);
var
  i : integer;
begin
//          
i:=0;
while (i<SelObjs.Count) and (not FDPanel.SelPDI[i].AllowDrag) do Inc(i);
if i>=SelObjs.Count then
  begin
    i:=0;
    while (i<SelObjs.Count) and
          (([ppBottom,ppLeftBottom,ppRightBottom] * FDPanel.SelPDI[i].AllowResizeTypes)=[]) and
          (([ppRight,ppRightTop,ppRightBottom] * FDPanel.SelPDI[i].AllowResizeTypes)=[]) do Inc(i);
    TAction(Sender).Enabled:=(FDPanel.FInplaceEditor=nil) and (i<SelObjs.Count);
  end
else
  TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprDesignerForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
FDPanel.EndInplaceEdit;
Action:=caFree;
end;

procedure TprDesignerForm.SetPopupColor;
var
  i : integer;
begin
if fUpdated then exit;
FOtherColor := FPaletteForm.OtherColor;
for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprMemoObj then
    begin
      if IsFillColor then
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).FillColor := Color
      else
        TprMemoObjRecVersion(TprObj(SelObjs[i]).dRec.Versions[TprObj(SelObjs[i]).dRec.DefVersion]).Font.Color := Color;
      Report.TemplateChanged:=true;
    end;
FDPanel.RepaintSelectedObjects;
end;

procedure TprDesignerForm.FontColorSetColor;
begin
FFontColor := Color;
SetPopupColor(false,Color);
end;

procedure TprDesignerForm.FillColorSetColor;
begin
FFillColor := Color;
SetPopupColor(true,Color);
end;

procedure TprDesignerForm.bFontColorClick(Sender: TObject);
var
  p : TPoint;
begin
if Sender=bFontColor then
  begin
    p := bFontColor.ClientToScreen(Point(0,0));
    FPaletteForm := PopupPaletteForm(Self,
                                     p.x,
                                     p.y+bFontColor.Height,
                                     FFontColor,
                                     FOtherColor,
                                     FontColorSetColor,
                                     prLoadStr(sColorBtnOtherColorCaption),
                                     prLoadStr(sColorBtnNoColorCaption))
  end
else
  if Sender=bFillColor then
    begin
      p := bFillColor.ClientToScreen(Point(0,0));
      FPaletteForm := PopupPaletteForm(Self,
                                       p.x,
                                       p.y+bFillColor.Height,
                                       FFillColor,
                                       FOtherColor,
                                       FillColorSetColor,
                                       prLoadStr(sColorBtnOtherColorCaption),
                                       prLoadStr(sColorBtnNoColorCaption))
    end;
end;

procedure TprDesignerForm.aCommonAction(Sender: TObject);
begin
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprDesignerForm.mtbNudgeClick(Sender: TObject);
begin
with TMenuItem(Sender) do
  begin
    Checked := not Checked;
    TToolBar(Self.FindComponent(Copy(Name,2,Length(Name)-1))).Visible:=Checked;
  end;
end;

procedure TprDesignerForm.aPosSizeUpdate(Sender: TObject);
begin
TAction(Sender).Checked:=PosSizeForm.Visible;
TAction(Sender).Enabled:=FDPanel.FInplaceEditor=nil;
end;

procedure TprDesignerForm.aPosSizeExecute(Sender: TObject);
begin
PosSizeForm.Visible:=not PosSizeForm.Visible;
end;

procedure TprDesignerForm.aSaveUpdate(Sender: TObject);
begin
TAction(Sender).Enabled:=Report.TemplateChanged and (FDPanel.FInplaceEditor=nil);
end;

procedure TprDesignerForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
CanClose:=true;
if not (csDesigning in Report.ComponentState) and Report.TemplateChanged then
  begin
    case MBox(prLoadStr(sTemplaceSaveQuestion),prLoadStr(sAttention),MB_YESNOCANCEL+MB_ICONQUESTION) of
      IDYES   : aSave.Execute;
      IDNO    : ;
      IDCANCEL: CanClose:=false;
    end;
  end
end;

procedure TprDesignerForm.N56Click(Sender: TObject);
var
  i : integer;
  tb : TToolBar;
begin
for i:=0 to TMenuItem(Sender).Count-1 do
  begin
    tb := TToolBar(FindComponent(Copy(TMenuItem(Sender)[i].Name,2,Length(TMenuItem(Sender)[i].Name)-1)));
    TMenuItem(Sender)[i].Enabled := tb<>nil;
    if tb<>nil then
      TMenuItem(Sender)[i].Checked := tb.Visible
  end;
end;

procedure TprDesignerForm.aHToLeftExecute(Sender: TObject);
begin
FDPanel.AlignAction(TprAlignActionCode(GetEnumValue(TypeInfo(TprAlignActionCode),'aac'+Copy(TAction(Sender).Name,2,Length(TAction(Sender).Name)))));
end;

initialization

RegisterClass(TprRichEditorForm);
RegisterClass(TprImageEditorForm);
RegisterClass(TprMemoEditorForm);
RegisterClass(TprBandEditorForm);
RegisterClass(TprDesignerForm);

end.

