{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_Dataset;

{$I pr.inc}
interface

uses
   SysUtils, Classes, DB, stdctrls {$ifdef PR_D6}, variants{$endif};
   
type

TprDatasetType = (prdtNone,prdtNativeDataset,prdtPrDataset);
/////////////////////////////
//
// TprDataset
//
/////////////////////////////
TprDataset = class(TComponent)
public
  function Active : boolean; virtual; abstract;
  function Eof : boolean; virtual; abstract;
  function RecordCount : integer; virtual; abstract;
  function GetFieldValue(FieldName : string) : Variant; virtual; abstract;

  procedure Open; virtual; abstract;
  procedure First; virtual; abstract;
  procedure Next; virtual; abstract;
  procedure Prior; virtual; abstract;

  procedure GetFieldsList(L : TStrings); virtual; abstract;
end;

/////////////////////////
//
// TprStringsDataset
//
/////////////////////////
TprStringSourceType = (prssNone,prssListBox,prssComboBox,prssMemo);
TprStringsDataset = class(TprDataset)
private
  FCurIndex          : integer;
  FStrings           : TStrings;
  FStringsSource     : TComponent;
  FStringsSourceType : TprStringSourceType;

  procedure SetStringsSource(Value : TComponent);
  function GetStrings : TStrings;
protected
  procedure Notification(AComponent : TComponent; AOperation : TOperation); override;
public
  property Strings : TStrings read GetStrings write FStrings;

  function Active : boolean; override;
  function Eof : boolean; override;
  function RecordCount : integer; override;
  function GetFieldValue(FieldName : string) : Variant; override;

  procedure Open; override;
  procedure First; override;
  procedure Next; override;
  procedure Prior; override;

  procedure GetFieldsList(L : TStrings); override;

  constructor Create(AOwner : TComponent); override;
published
  property StringsSource : TComponent read FStringsSource write SetStringsSource;
end;

/////////////////////////
//
// TprEventsDataset
//
/////////////////////////
TprEventsDatasetOnProcedure = procedure (prDataset : TprDataset) of object;
TprEventsDatasetOnActive = procedure (prDataset : TprDataset; var IsActive : boolean) of object;
TprEventsDatasetOnEof = procedure (prDataset : TprDataset; var IsEof : boolean) of object;
TprEventsDatasetOnRecordCount = procedure (prDataset : TprDataset; var RecordCount : integer) of object;
TprEventsDatasetOnGetFieldValue = procedure (prDataset : TprDataset; const FieldName : string; var FieldValue : Variant) of object;
TprEventsDatasetOnGetFieldsList = procedure (prDataset : TprDataset; L : TStrings) of object;

TprEventsDataset = class(TprDataset)
private
  FOnActive        : TprEventsDatasetOnActive;
  FOnEof           : TprEventsDatasetOnEof;
  FOnRecordCount   : TprEventsDatasetOnRecordCount;
  FOnGetFieldValue : TprEventsDatasetOnGetFieldValue;

  FOnOpen          : TprEventsDatasetOnProcedure;
  FOnFirst         : TprEventsDatasetOnProcedure;
  FOnNext          : TprEventsDatasetOnProcedure;
  FOnPrior         : TprEventsDatasetOnProcedure;

  FOnGetFieldsList : TprEventsDatasetOnGetFieldsList;
public
  function Active : boolean; override;
  function Eof : boolean; override;
  function RecordCount : integer; override;
  function GetFieldValue(FieldName : string) : Variant; override;

  procedure Open; override;
  procedure First; override;
  procedure Next; override;
  procedure Prior; override;

  procedure GetFieldsList(L : TStrings); override;
published
  property OnActive        : TprEventsDatasetOnActive read FOnActive write FOnActive;
  property OnEof           : TprEventsDatasetOnEof read FOnEof write FOnEof;
  property OnRecordCount   : TprEventsDatasetOnRecordCount read FOnRecordCount write FOnRecordCount;
  property OnGetFieldValue : TprEventsDatasetOnGetFieldValue read FOnGetFieldValue write FOnGetFieldValue;

  property OnOpen          : TprEventsDatasetOnProcedure read FOnOpen write FOnOpen;
  property OnFirst         : TprEventsDatasetOnProcedure read FOnFirst write FOnFirst;
  property OnNext          : TprEventsDatasetOnProcedure read FOnNext write FOnNext;
  property OnPrior         : TprEventsDatasetOnProcedure read FOnPrior write FOnPrior;

  property OnGetFieldsList : TprEventsDatasetOnGetFieldsList read FOnGetFieldsList write FOnGetFieldsList;
end;

//////////////////////////////
//
// TprDatasetLink
//
//////////////////////////////
TprDatasetLink = class(TObject)
private
  FDataset     : TObject;
  FDatasetType : TprDatasetType;

  procedure SetDataset(Value: TObject);
public
  property Dataset : TObject read FDataset write SetDataset;

  function Active : boolean;
  function Eof : boolean;

  procedure Open;
  procedure First;
  procedure Next;
  procedure Prior;

  constructor Create;
end;

implementation

uses
  pr_Strings, pr_MultiLang, pr_Utils;

/////////////////////////////////
//
// TprStringsDataset
//
/////////////////////////////////
constructor TprStringsDataset.Create;
begin
inherited;
FStringsSourceType:=prssNone;
end;

procedure TprStringsDataset.Notification;
begin
inherited;
if (AComponent=FStringsSource) and (AOperation=opRemove) then
  FStringsSource:=nil;
end;

procedure TprStringsDataset.SetStringsSource;
begin
if (Value=nil) or (Value is TComboBox) or (Value is TListBox) or (Value is TMemo) then
  begin
    FStringsSource:=Value;
    if FStringsSource is TComboBox then
      FStringsSourceType:=prssComboBox
    else
      if FStringsSource is TListBox then
        FStringsSourceType:=prssListBox
      else
        if FStringsSource is TMemo then
          FStringsSourceType:=prssMemo
        else
          FStringsSourceType:=prssNone;
  end
else
  raise Exception.Create(prLoadStr(sErrorInvalidStringsSource));
end;

function TprStringsDataset.GetStrings;
begin
Result:=nil;
if  FStringsSourceType<>prssNone then
  case FStringsSourceType of
    prssComboBox: Result:=TComboBox(FStringsSource).Items;
    prssListBox : Result:=TListBox(FStringsSource).Items;
    prssMemo    : Result:=TMemo(FStringsSource).Lines;
  end
else
  if Strings<>nil then
    Result:=Strings
  else
    raise Exception.Create(prLoadStr(sErrorStringsSourceNotDefined));
end;

function TprStringsDataset.Active;
begin
Result:=true;
end;

function TprStringsDataset.Eof;
begin
Result:=FCurIndex>=Strings.Count;
end;

function TprStringsDataset.RecordCount;
begin
Result:=Strings.Count;
end;

function TprStringsDataset.GetFieldValue;
begin
if CompText('NAME',FieldName)=0 then
  Result:=Strings[FCurIndex]
else
  if CompText('ID',FieldName)=0 then
    Result:=integer(Strings.Objects[FCurIndex]);
end;

procedure TprStringsDataset.Open;
begin
FCurIndex:=0;
end;

procedure TprStringsDataset.First;
begin
FCurIndex:=0;
end;

procedure TprStringsDataset.Next;
begin
if FCurIndex<=Strings.Count then
  Inc(FCurIndex);
end;

procedure TprStringsDataset.Prior;
begin
if FCurIndex>0 then
  Dec(FCurIndex);
end;

procedure TprStringsDataset.GetFieldsList;
begin
L.Add('NAME');
L.Add('ID');
end;

/////////////////////////////////
//
// TprDataset
//
/////////////////////////////////

/////////////////////////////////
//
// TprDatasetLink
//
/////////////////////////////////
constructor TprDatasetLink.Create;
begin
inherited;
FDataset    :=nil;
FDatasetType:=prdtNone;
end;

procedure TprDatasetLink.SetDataset;
begin
if (Value is TDataset) or (Value is TprDataset) or (Value=nil) then
  begin
    FDataset:=Value;
    if FDataset=nil then
      FDatasetType:=prdtNone
    else
      if FDataset is TDataset then
        FDatasetType:=prdtNativeDataset
      else
        FDatasetType:=prdtPrDataset;
  end
else
  raise Exception.Create(prLoadStr(sErrorInvalidDatasetForprDataset));
end;

function TprDatasetLink.Active;
begin
Result:=false;
case FDatasetType of
  prdtNativeDataset: Result:=TDataset(FDataset).Active;
  prdtPrDataset    : Result:=TprDataset(FDataset).Active;
end;
end;

function TprDatasetLink.Eof;
begin
Result:=false;
case FDatasetType of
  prdtNativeDataset: Result:=TDataset(FDataset).Eof;
  prdtPrDataset    : Result:=TprDataset(FDataset).Eof;
end;
end;

procedure TprDatasetLink.Open;
begin
case FDatasetType of
  prdtNativeDataset: TDataset(FDataset).Open;
  prdtPrDataset    : TprDataset(FDataset).Open;
end;
end;

procedure TprDatasetLink.First;
begin
case FDatasetType of
  prdtNativeDataset: TDataset(FDataset).First;
  prdtPrDataset    : TprDataset(FDataset).First;
end;
end;

procedure TprDatasetLink.Next;
begin
case FDatasetType of
  prdtNativeDataset: TDataset(FDataset).Next;
  prdtPrDataset    : TprDataset(FDataset).Next;
end;
end;

procedure TprDatasetLink.Prior;
begin
case FDatasetType of
  prdtNativeDataset: TDataset(FDataset).Prior;
  prdtPrDataset    : TprDataset(FDataset).Prior;
end;
end;

////////////////////////////
//
// TprEventsDataset
//
////////////////////////////
function TprEventsDataset.Active;
begin
Result:=false;
if Assigned(FOnActive) then
  FOnActive(Self,Result);
end;

function TprEventsDataset.Eof;
begin
Result:=false;
if Assigned(FOnEof) then
  FOnEof(Self,Result);
end;

function TprEventsDataset.RecordCount;
begin
Result:=-1;
if Assigned(FOnRecordCount) then
  FOnRecordCount(Self,Result);
end;

function TprEventsDataset.GetFieldValue;
begin
Result:=UnAssigned;
if Assigned(FOnGetFieldValue) then
  FOnGetFieldValue(Self,FieldName,Result);
end;

procedure TprEventsDataset.Open;
begin
if Assigned(FOnOpen) then
  FOnOpen(Self);
end;

procedure TprEventsDataset.First;
begin
if Assigned(FOnFirst) then
  FOnFirst(Self);
end;

procedure TprEventsDataset.Next;
begin
if Assigned(FOnNext) then
  FOnNext(Self);
end;

procedure TprEventsDataset.Prior;
begin
if Assigned(FOnPrior) then
  FOnPrior(Self);
end;

procedure TprEventsDataset.GetFieldsList;
begin
if Assigned(FOnGetFieldsList) then
  FOnGetFieldsList(Self,L);
end;

initialization

RegisterClass(TprDataset);

end.

