{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_CommonDesigner;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ImgList, ActnList, Menus, ExtCtrls,
  TypInfo, Pr_Utils, ClipBrd, IniFiles, ComCtrls, 
  StdCtrls, Grids,

  pr_Common, pr_Link, pr_BandLinks, pr_VersionsEditor,
  pr_MultiLang, pr_DesignerFunctions;

{$I PR.INC}

const
  PasteOffs = 1;
  ScrollBoxBorderWidth = 2;
  ScrollBoxBorderHeight = 2;
type
  TprCustomDPanel = class;
  TprCustomDesignerForm = class;

  rInternalPropsForm = record
    ClassName : string;
    PropsFormClassName : string;
  end;

  ///////////////////////////////
  //
  // TprPropsForm
  //
  ///////////////////////////////
  TprPropsForm = class(TForm)
  protected
  public
    Designer : TprCustomDesignerForm;

    procedure DesignerSelectionChanged; virtual;

    procedure Apply; virtual;
    procedure Cancel; virtual;

    procedure CreateParams(var Params : TCreateParams); override;
    procedure DoClose(var Action : TCloseAction); override;

    constructor CreatePropsForm(AOwner : TComponent; _Designer : TprCustomDesignerForm);
  end;
  TprPropsFormClass = class of TprPropsForm;

  //////////////////////////////////
  //
  // TprObjPropsForm
  //
  //////////////////////////////////
  TprObjPropsForm = class(TprPropsForm)
  protected
    VersionsEditor : TprObjVersionsEditor;

    procedure OnVersionChanged(Sender : TObject; OldVersion,NewVersion : TprObjRecVersion);
    procedure _CopyMultiplyPropertiesToControls;
    procedure _CopyMultiplyPropertiesFromControls;

    procedure SetEnabledAfterCopyToControls; virtual;
    procedure CopySinglePropertiesFromControls(V : TprObjRecVersion); virtual;
    procedure CopyMultiplyPropertiesFromControls(L : TList); virtual;
    procedure CopySinglePropertiesToControls(V : TprObjRecVersion); virtual;
    procedure CopyMultiplyPropertiesToControls(L : TList); virtual;

    procedure DefaultCopyToControls(L : TList);
    procedure DefaultCopyFromControls(L : TList);
  public
    procedure DesignerSelectionChanged; override;
    procedure Apply; override;
    procedure Cancel; override;

    procedure AfterConstruction; override;
  end;

  /////////////////////////////////
  //
  // TprCustomObjectPosSizeForm
  //
  /////////////////////////////////
  TprCustomObjectPosSizeForm = class(TprForm)
  public
    Designer     : TprCustomDesignerForm;
    EnabledProps : TprObjectPosSizePropsSet;
    EqProps      : TprObjectPosSizePropsSet;

    SizePosArray : array [TprObjectPosSizeProps] of integer;

    procedure SetPosSizeProp(Value : integer; p : TprObjectPosSizeProps);
    procedure CopyPropertiesToControls; virtual;
    procedure CopyPropertiesFromControls; virtual;
    procedure DesignerSelectionChanged;

    constructor CreatePosSizeForm(AOwner : TComponent; _Designer : TprCustomDesignerForm);
  end;

  /////////////////////////////
  //
  // TprCustomDesignerForm
  //
  /////////////////////////////
  TprCustomDesignerForm = class(TprDesigner)
  private
    FFileName        : string;

    FDisablePageDraw : boolean;

    FCurClassRef     : TprObjClass;

    procedure SetFileName(Value : string);

    function  GetSelObjs : TList;
    function  GetSelPDI(i : integer) : pDesignInfo;
    function  GetSelCount : integer;
  protected
    FDPanel : TprCustomDPanel;
    SBox    : TprScrollBox;

    function  CreateDPanel : TprCustomDPanel; virtual; abstract;
    function  CreatePage : TprCustomPage; virtual; abstract;

    procedure KeyDown(var Key: Word; Shift: TShiftState); override;

    procedure SelectionChanged;
    procedure UpdatePropsForm; virtual;
    procedure UpdateLinksForms; virtual;
    procedure UpdatePosSizeForm; virtual;

    procedure UpdateSelectedRegionSizes(r : TRect; fEmpty : boolean); virtual; abstract;

    procedure OnInsertBandClick(Sender : TObject);
    procedure OnObjButtonClick(Sender : TObject);
    procedure OnObjInserted(Obj : TprObj); virtual;

    procedure InitInternalPropsForms; virtual;
  public
    { Public declarations }
    IndexCurPage     : integer; //    

    ObjLinksForm     : TprObjLinksForm;
    BandLinksForm    : TprBandLinksForm;
    PosSizeForm      : TprCustomObjectPosSizeForm;
    ObjectsPropsForm : TForm;

    prInternalPropsForms : array of rInternalPropsForm;

    property FileName            : string read FFileName write SetFileName;

    property SelObjs             : TList read GetSelObjs;           // list selected objects in FDPanel
    property SelPDI[i : integer] : pDesignInfo read GetSelPDI;
    property SelCount            : integer read GetSelCount;        // count of selected objects

    function  UseGrid : boolean; virtual; abstract;
    function  ShowGrid : boolean; virtual; abstract;
    function  GridSizeX : integer; virtual; abstract;
    function  GridSizeY : integer; virtual; abstract;

    procedure ShowPage(PageIndex : integer); virtual;

    function  CurPage : TprCustomPage;

    procedure UpdateCurrentPage; override;
    procedure UpdateStatusBar; virtual;
    procedure UpdateTextActions; virtual; abstract;

    procedure DrawLinks;

    procedure AfterConstruction; override;

    procedure Save; virtual;
    procedure SaveAs; virtual;
    procedure Open; virtual;
    procedure New;
    procedure Print;
    procedure Preview;

    procedure NewPage;
    procedure DelPage;
    procedure NextPage;
    procedure PriorPage;

    procedure BeforeDestruction; override;

    constructor CreateDesigner(AOwner : TComponent; _Report : TprCustomReport); override;
  end;

  /////////////////////////////
  //
  // TprCustomDPanel
  //
  /////////////////////////////

  TprCustomDPanel = class(TPanel)
  private
    FSelPDI             : TList; //     pDesignInfo  

    FMouseMode          : TprMouseMode;

    FDownRegion         : pDesignInfo;
    FDownPointInfo      : TprPointInfo;
    FDownResizeMode     : TprResizeType;
    FDownLinkMode       : TprLinkType;
    FFirstMoveAfterDown : boolean;
    FDblClick           : boolean;
    FTickCount          : DWORD;

    FPrevObj            : TObject;

    FDragRegion         : pDesignInfo;

    FResizeRegion       : pDesignInfo;        // ,    (  )
    FResizeMode         : TprResizeType;

    FLinkRegion         : pDesignInfo;
    FLinkMode           : TprLinkType;

    FLastX              : integer;
    FLastY              : integer;
    FStartX             : integer;
    FStartY             : integer;
    FStartRealX         : integer;
    FStartRealY         : integer;

    FPastePRPS          : rPrPaintStruct;

    procedure GetPointInfoAt(x,y            : integer;
                             var PDI        : pDesignInfo;
                             var PointInfo  : TprPointInfo;
                             var ResizeMode : TprResizeType;
                             var LinkMode   : TprLinkType);

    procedure SetMouseCursorState(X,Y : integer);

    procedure DrawAnime(DC : HDC; x,y,lastx,lasty : integer);

    procedure _BeginPaint(var prps : rPrPaintStruct);
    procedure _EndPaint(const prps : rPrPaintStruct);
    procedure UpdateSelectedInfo;
    procedure SelectionChanged;

    procedure _MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure _MouseDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
    procedure _MouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
    procedure _MouseDblClick(Sender : TObject);

    function  GetSelPDI(i : integer) : pDesignInfo;
    function  GetSelCount : integer;

    procedure SelectedObjectsToClipboard;

    procedure PasteCallBack(Component : TComponent);
    procedure PasteSetName(Reader: TReader; Component: TComponent; var Name: string);
  protected
    FSelectedRect     : TRect;
    FInplaceEditedObj : TObject;
    FGridBitmap       : HBITMAP;

    //         
    procedure DoLink(SourceRegion : pDesignInfo; DestRegion : pDesignInfo; LinkMode : TprLinkType);
    procedure DoResize(ResizeRegion : pDesignInfo; oTop,oLeft,oBottom,oRight : integer; prps : pPrPaintStruct);
    procedure DoDrag(DragRegion : pDesignInfo; dx,dy : integer; prps : pPrPaintStruct);

    procedure UpdateObjectsPDI;

    function  GetExData : pointer; virtual;

    procedure InternalPaint(DC : HDC; Rgn : HRGN); virtual;
    procedure PaintOther(DC : HDC); virtual;
    procedure DrawLinks(DC : HDC);
    procedure DrawSelectedObjects(DC : HDC); //      

    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure mGetDlgCode(var Message : TWMGetDlgCode); message WM_GETDLGCODE;
    procedure mPaint(var Message : TWMPaint); message WM_PAINT;
    procedure mEraseBkgnd(var Message: TWmEraseBkgnd); message WM_ERASEBKGND;
  public
    FInplaceEditor : TWinControl;
    SelObjs        : TList; //     

    property SelPDI[i : integer]  : pDesignInfo read GetSelPDI;
    property SelCount             : integer read GetSelCount;

    procedure DesignerGridSizeChanged;
    procedure RepaintSelectedObjects;

    function  IsObjSelected(pdi : pDesignInfo) : boolean;
    procedure ClearSelected;
    procedure SelectObj(pdi : pDesignInfo);
    procedure DeSelectObj(pdi : pDesignInfo);
    procedure DeleteSelectedObjects;

    procedure InplaceEditObj(PDI : pDesignInfo); virtual; abstract;
    procedure EndInplaceEdit; virtual;
    procedure SaveInplaceEdit; virtual; abstract;
    function  AllowInplaceEdit : boolean;

    function  IsAnyTprObjSelected : boolean;
    function  AllowSizeLeftRight : boolean;
    function  AllowSizeTopBottom : boolean;
    function  AllowDelete : boolean;
    function  AllowCopy : boolean;
    function  AllowPaste : boolean;
    function  AllowCut : boolean;
    function  AllowAlignToGridAll : boolean;
    function  GetNumDragSelectedRegions : integer;

    procedure Paste;
    procedure Cut;
    procedure Copy;

    procedure Delete;

    procedure AlignAction(ActionCode : TprAlignActionCode);

    procedure Nudge(dx,dy : integer);
    procedure Size(sx,sy : integer);
    procedure SetPosSizeProp(Prop : TprObjectPosSizeProps; Value : integer);

    procedure SendToBack;
    procedure BringToFront;

    function  Designer : TprCustomDesignerForm;
    function  Report : TprCustomReport;

    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
  end;

implementation

uses pr_Strings, pr_ObjectsProps;

///////////////////////////////
//
// TprPropsForm
//
///////////////////////////////
constructor TprPropsForm.CreatePropsForm;
begin
Designer := _Designer;
inherited Create(AOwner);
end;

procedure TprPropsForm.CreateParams;
begin
inherited;
Params.Style := Params.Style and (not WS_BORDER) and (not WS_CAPTION) and (not WS_DISABLED);
Params.Style := Params.Style or WS_CHILD or WS_VISIBLE;
Params.ExStyle := Params.ExStyle or WS_EX_CONTROLPARENT;
Params.WndParent := TWinControl(Owner).Handle;
end;

procedure TprPropsForm.DoClose;
begin
Action := caFree;
inherited;
end;

procedure TprPropsForm.DesignerSelectionChanged;
begin
end;

procedure TprPropsForm.Apply;
begin
Designer.Report.TemplateChanged := true;
end;

procedure TprPropsForm.Cancel;
begin
end;

/////////////////////////////////////
//
// TprObjPropsForm
//
/////////////////////////////////////
procedure TprObjPropsForm.AfterConstruction;
begin
VersionsEditor := TprObjVersionsEditor.Create(Self);
VersionsEditor.Parent := Self;
VersionsEditor.Align := alTop;
VersionsEditor.OnVersionChanged := OnVersionChanged;
inherited;
end;

procedure TprObjPropsForm.DesignerSelectionChanged;
begin
if Designer.SelObjs.Count>1 then
  begin
    VersionsEditor.Obj:=nil;
    _CopyMultiplyPropertiesToControls;
    SetEnabledAfterCopyToControls;
  end
else
  begin
    VersionsEditor.Obj:=TprObj(Designer.SelObjs[0]);
    CopySinglePropertiesToControls(VersionsEditor.CurrentVersion);
    SetEnabledAfterCopyToControls;
  end;
end;

procedure TprObjPropsForm.OnVersionChanged;
begin
if OldVersion<>nil then
  begin
    CopySinglePropertiesFromControls(OldVersion);
  end;
if NewVersion<>nil then
  begin
    CopySinglePropertiesToControls(NewVersion);
  end;
end;

procedure TprObjPropsForm._CopyMultiplyPropertiesToControls;
var
  L : TList;
begin
L:=TList.Create;
try
  MakedRecDefVersionList(Designer.SelObjs,L);
  CopyMultiplyPropertiesToControls(L);
finally
  L.Free;
end;
end;

procedure TprObjPropsForm._CopyMultiplyPropertiesFromControls;
var
  L : TList;
begin
L:=TList.Create;
try
  MakedRecDefVersionList(Designer.SelObjs,L);
  CopyMultiplyPropertiesFromControls(L);
finally
  L.Free;
end;
end;

procedure TprObjPropsForm.SetEnabledAfterCopyToControls;
begin
end;

procedure TprObjPropsForm.CopySinglePropertiesFromControls;
var
  L : TList;
begin
L:=TList.Create;
try
  L.Add(v);
  CopyMultiplyPropertiesFromControls(L);
finally
  L.Free;
end;
end;

procedure TprObjPropsForm.CopyMultiplyPropertiesFromControls;
begin
end;

procedure TprObjPropsForm.CopySinglePropertiesToControls;
var
  L : TList;
begin
L:=TList.Create;
try
  L.Add(v);
  CopyMultiplyPropertiesToControls(L);
finally
  L.Free;
end;
end;

procedure TprObjPropsForm.CopyMultiplyPropertiesToControls;
begin
end;

procedure TprObjPropsForm.Apply;
begin
if VersionsEditor.CurrentVersion<>nil then
  CopySinglePropertiesFromControls(VersionsEditor.CurrentVersion)
else
  _CopyMultiplyPropertiesFromControls;

Designer.FDPanel.RepaintSelectedObjects;
inherited;
end;

procedure TprObjPropsForm.Cancel;
begin
end;

procedure TprObjPropsForm.DefaultCopyToControls;
begin
end;

procedure TprObjPropsForm.DefaultCopyFromControls;
begin
end;

////////////////////////////////////////
//
// TprCustomObjectPosSizeForm
//
////////////////////////////////////////
constructor TprCustomObjectPosSizeForm.CreatePosSizeForm;
begin
Designer:=_Designer;
inherited Create(AOwner);
end;

procedure TprCustomObjectPosSizeForm.DesignerSelectionChanged;
var
  i : integer;
  j : TprObjectPosSizeProps;

  function GetPropValue(Obj : TObject; p : TprObjectPosSizeProps) : integer;
  begin
  Result:=-1;

  if Obj is TprObj then
    case p of
      prpsaLeft  : Result:=TprObj(Obj).Band.dPageRect.Left+TprObj(Obj).dRec.Left;
      prpsaRight : Result:=TprObj(Obj).Band.dPageRect.Left+TprObj(Obj).dRec.Right;
      prpsaTop   : Result:=TprObj(Obj).Band.dPageRect.Top+TprObj(Obj).dRec.Top;
      prpsaBottom: Result:=TprObj(Obj).Band.dPageRect.Top+TprObj(Obj).dRec.Bottom;
      prpsaWidth : Result:=TprObj(Obj).dRec.Right-TprObj(Obj).dRec.Left;
      prpsaHeight: Result:=TprObj(Obj).dRec.Bottom-TprObj(Obj).dRec.Top;
    end
  else
    if Obj is TprBand then
      case p of
        prpsaLeft  : Result:=TprBand(Obj).dPageRect.Left;
        prpsaRight : Result:=TprBand(Obj).dPageRect.Right;
        prpsaTop   : Result:=TprBand(Obj).dPageRect.Top;
        prpsaBottom: Result:=TprBand(Obj).dPageRect.Bottom;
        prpsaWidth : Result:=TprBand(Obj).dPageRect.Right-TprBand(Obj).dPageRect.Left;
        prpsaHeight: Result:=TprBand(Obj).dPageRect.Bottom-TprBand(Obj).dPageRect.Top;
      end;
  end;

begin
//
//   ,  SelObjs   :
//   - ,   
//   -  
//   -  
if Designer.SelObjs.Count>0 then
  begin
    EnabledProps:=[prpsaLeft,prpsaRight,prpsaTop,prpsaBottom,prpsaWidth,prpsaHeight];
    EqProps     :=[prpsaLeft,prpsaRight,prpsaTop,prpsaBottom,prpsaWidth,prpsaHeight];

    for j:=Low(TprObjectPosSizeProps) to High(TprObjectPosSizeProps) do
      SizePosArray[j]:=GetPropValue(Designer.SelObjs[0],j);

    for i:=0 to Designer.SelObjs.Count-1 do
      begin
        if TObject(Designer.SelObjs[i]) is TprCustomHBand then
          EnabledProps:=EnabledProps-[prpsaLeft,prpsaRight,prpsaTop,prpsaBottom,prpsaWidth]
        else
          if TObject(Designer.SelObjs[i]) is TprCustomVBand then
            EnabledProps:=EnabledProps-[prpsaLeft,prpsaRight,prpsaTop,prpsaBottom,prpsaHeight];

        if i>0 then
          for j:=Low(TprObjectPosSizeProps) to High(TprObjectPosSizeProps) do
            if not (j in EnabledProps) or (SizePosArray[j]<>GetPropValue(Designer.SelObjs[i],j)) then
              EqProps:=EqProps-[j];
      end;
  end
else
  begin
    EnabledProps:=[];
    EqProps     :=[];
    for j:=Low(TprObjectPosSizeProps) to High(TprObjectPosSizeProps) do
      SizePosArray[j]:=-1;
  end;

CopyPropertiesToControls;
end;

procedure TprCustomObjectPosSizeForm.SetPosSizeProp;
begin
Designer.FDPanel.SetPosSizeProp(p,Value);
end; 

procedure TprCustomObjectPosSizeForm.CopyPropertiesToControls;
begin
end;

procedure TprCustomObjectPosSizeForm.CopyPropertiesFromControls;
begin
end;

////////////////////////////
//
// TprCustomDPanel
//
////////////////////////////
constructor TprCustomDPanel.Create;
begin
inherited;
SelObjs       :=TList.Create;
FSelPDI       :=TList.Create;

OnMouseUp     :=_MouseUp;
OnMouseMove   :=_MouseMove;
OnMouseDown   :=_MouseDown;
OnDblClick    :=_MouseDblClick;
TabStop       :=true;

FGridBitmap   :=0;
end;

destructor TprCustomDPanel.Destroy;
begin
if FGridBitmap<>0 then
  DeleteObject(FGridBitmap);

SelObjs.Free;
FSelPDI.Free;
inherited;
end;

procedure TprCustomDPanel.mGetDlgCode;
begin
inherited;
Message.Result:=Message.Result or DLGC_WANTALLKEYS or DLGC_WANTARROWS;
end;

procedure TprCustomDPanel.UpdateObjectsPDI;
var
  i,j,k : integer;
begin
for i:=0 to Report.PagesCount-1 do
  for j:=0 to Report.Pages[i].Bands.Count-1 do
    begin
      Report.Pages[i].Bands[j].UpdatePDI(GetExData);
      for k:=0 to Report.Pages[i].Bands[j].Objects.Count-1 do
        Report.Pages[i].Bands[j].Objects[k].UpdatePDI(GetExData);
    end;
end;

function TprCustomDPanel.GetSelPDI;
begin
Result:=pDesignInfo(FSelPDI[i]);
end;

function TprCustomDPanel.GetSelCount;
begin
Result:=FSelPDI.Count;
end;

procedure TprCustomDPanel.ClearSelected;
begin
FSelPDI.Clear;
SelObjs.Clear;
end;

function TprCustomDPanel.IsObjSelected;
begin
Result:=FSelPDI.IndexOf(pdi)<>-1;
end;

procedure TprCustomDPanel.SelectObj;
begin
if not IsObjSelected(pdi) then
  begin
    FSelPDI.Add(pdi);
    SelObjs.Add(pdi.Parent);
  end;
end;

procedure TprCustomDPanel.DeSelectObj;
begin
FSelPDI.Remove(pdi);
SelObjs.Remove(pdi.Parent);
end;

procedure TprCustomDPanel.DeleteSelectedObjects;
var
  f : boolean;
  i,j : integer;
  pdi : pDesignInfo;
  ClipRgn : HRGN;
begin
DrawSelectedObjects(Canvas.Handle);  //  
DrawLinks(Canvas.Handle);            //  

i:=0;
f:=false;
ClipRgn:=0;
while i<FSelPDI.Count do
  begin
    pdi:=SelPDI[i];
    if pdi<>nil then
      begin
        if pdi.Parent is TprObj then
          begin
            AddRectToRegion(ClipRgn,pdi.dPageRect);
            TprObj(pdi.Parent).DesignerDelete;
            Report.TemplateChanged:=true;
          end
        else
          if pdi.Parent is TprBand then
            begin
              f:=true;
              for j:=i+1 to FSelPDI.Count-1 do
                if (pdi.Parent is TprObj) and (TprObj(pdi.Parent).Band=pdi.Parent) then
                  FSelPDI[j]:=nil;
              TprBand(pdi.Parent).DesignerDelete;
              Report.TemplateChanged:=true;
            end;
      end;
    Inc(i);
  end;
ClearSelected;

if f then
  begin
    //   
    Designer.CurPage.UpdateBandsPageRect; //   
    UpdateObjectsPDI;                     //     PDI
    Repaint;
  end
else
  begin
    DrawLinks(Canvas.Handle);
    InternalPaint(Canvas.Handle,ClipRgn);
  end;

if ClipRgn<>0 then
  DeleteObject(ClipRgn);
  
SelectionChanged;
end;

procedure TprCustomDPanel.KeyDown;
var
  o : TprObj;
  p : TprCustomPage;
  sb : TScrollBox;
  b,b2 : TprBand;
  prps : rPrPaintStruct;
  vs,hs : TControlScrollBar;
  pdiCur,pdiNext : pDesignInfo;
  StepX,StepY,rl,rr,rt,rb,i,j : integer;
begin
if Shift=[] then
  begin
    if Key=VK_ESCAPE then
      begin
        //   ,  TprObj
        if FMouseMode<>mmNone then
          begin
            DrawAnime(Canvas.Handle,FStartX,FStartY,FLastX,FLastY);
            DrawSelectedObjects(Canvas.Handle);
            DrawLinks(Canvas.Handle);
            FMouseMode:=mmNone;
          end
        else
          begin
            if FInplaceEditor=nil then
              begin
                i:=0;
                while (i<SelObjs.Count) and (not(TObject(SelObjs[i]) is TprObj)) do Inc(i);
                if i<SelObjs.Count then
                  begin
                    o:=TprObj(SelPDI[i].Parent);
                    DrawSelectedObjects(Canvas.Handle);
                    ClearSelected;
                    SelectObj(o.Band.PDI);
                    DrawSelectedObjects(Canvas.Handle);
                    SelectionChanged;
                  end;
              end;
          end;
        Key:=0;
      end;

    if Key in [VK_LEFT,VK_UP,VK_DOWN,VK_RIGHT] then
      begin
        pdiNext:=nil;
        p      :=Designer.CurPage;
        case SelObjs.Count of
          0:
            begin
              //   ,    
              if p.Bands.Count>0 then
                begin
                  b:=p.Bands[0];
                  for i:=1 to p.Bands.Count-1 do
                    if b.pdi.dPageRect.Top>p.Bands[i].pdi.dPageRect.Top then
                      b:=p.Bands[i];
                  pdiNext:=b.pdi;
                end;
            end;
          1:
            begin
              //  1 
              pdiCur:=SelPDI[0];
              if pdiCur.Parent is TprObj then
                begin
                  //  
                  b:=TprObj(pdiCur.Parent).Band;
                  o:=nil;
                  case Key of
                    VK_LEFT:
                      begin
                        for i:=0 to b.Objects.Count-1 do
                          if (b.Objects[i].pdi.dPageRect.Left<pdiCur.dPageRect.Left) and
                             (b.Objects[i]<>o) and
                             ((o=nil) or
                              (o.pdi.dPageRect.Left<b.Objects[i].pdi.dPageRect.Left)) then
                            o:=b.Objects[i];
                      end;
                    VK_RIGHT:
                      begin
                        for i:=0 to b.Objects.Count-1 do
                          if (b.Objects[i].pdi.dPageRect.Left>pdiCur.dPageRect.Left) and
                             (b.Objects[i]<>o) and
                             ((o=nil) or
                              (o.pdi.dPageRect.Left>b.Objects[i].pdi.dPageRect.Left)) then
                            o:=b.Objects[i];
                      end;
                    VK_UP:
                      begin
                        for i:=0 to b.Objects.Count-1 do
                          if (b.Objects[i].pdi.dPageRect.Top<pdiCur.dPageRect.Top) and
                             (b.Objects[i]<>o) and
                             ((o=nil) or
                              (o.pdi.dPageRect.Top<b.Objects[i].pdi.dPageRect.Top)) then
                            o:=b.Objects[i];
                      end;
                    VK_DOWN:
                      begin
                        for i:=0 to b.Objects.Count-1 do
                          if (b.Objects[i].pdi.dPageRect.Top>pdiCur.dPageRect.Top) and
                             (b.Objects[i]<>o) and
                             ((o=nil) or
                              (o.pdi.dPageRect.Top>b.Objects[i].pdi.dPageRect.Top)) then
                            o:=b.Objects[i];
                      end;
                  end;

                  if o<>nil then
                    begin
                      if Key in [VK_LEFT,VK_RIGHT] then
                        begin
                          //       y  pdiCur
                          //    Left
                          for i:=0 to b.Objects.Count-1 do
                            if (b.Objects[i]<>o) and
                               (b.Objects[i].pdi.dPageRect.Left=o.pdi.dPageRect.Left) and
                               (abs(b.Objects[i].pdi.dPageRect.Top-pdiCur.dPageRect.Top)<abs(b.Objects[i].pdi.dPageRect.Top-o.pdi.dPageRect.Top)) then
                              o:=b.Objects[i];
                        end
                      else
                        begin
                          //       x  pdiCur
                          //    Top
                          for i:=0 to b.Objects.Count-1 do
                            if (b.Objects[i]<>o) and
                               (b.Objects[i].pdi.dPageRect.Top=o.pdi.dPageRect.Top) and
                               (abs(b.Objects[i].pdi.dPageRect.Left-pdiCur.dPageRect.Left)<abs(b.Objects[i].pdi.dPageRect.Left-o.pdi.dPageRect.Left)) then
                              o:=b.Objects[i];
                        end;
                      pdiNext:=o.pdi
                    end
                  else
                    if b<>nil then
                      pdiNext:=b.pdi;
                end
              else
                if pdiCur.Parent is TprBand then
                  begin
                    //      -  ,
                    //     -.
                    //          
                    b:=TprBand(pdiCur.Parent);
                    if b.BandType in VerticalBands then
                      begin
                        case Key of
                          VK_LEFT  :
                            begin
                              //   
                              b2:=nil;
                              for i:=0 to p.Bands.Count-1 do
                                if (p.Bands[i].BandType in VerticalBands) and
                                   (p.Bands[i]<>b) and
                                   (p.Bands[i].pdi.dPageRect.Left<pdiCur.dPageRect.Left) and
                                   ((b2=nil) or
                                    (b2.pdi.dPageRect.Left<p.Bands[i].pdi.dPageRect.Left)) then
                                  b2:=p.Bands[i];
                              if b2<>nil then
                                pdiNext:=b2.pdi;
                            end;
                          VK_RIGHT :
                            begin
                              //   
                              b2:=nil;
                              for i:=0 to p.Bands.Count-1 do
                                if (p.Bands[i].BandType in VerticalBands) and
                                   (p.Bands[i]<>b) and
                                   (p.Bands[i].pdi.dPageRect.Left>pdiCur.dPageRect.Left) and
                                   ((b2=nil) or
                                    (b2.pdi.dPageRect.Left>p.Bands[i].pdi.dPageRect.Left)) then
                                  b2:=p.Bands[i];
                              if b2<>nil then
                                pdiNext:=b2.pdi;
                            end;
                          VK_UP,VK_DOWN:
                            begin
                              o:=nil;
                              //   
                              for i:=0 to p.Bands.Count-1 do
                                for j:=0 to p.Bands[i].Objects.Count-1 do
                                  if RectInRect(p.Bands[i].Objects[j].pdi.dPageRect,b.pdi.dPageRect) then
                                    begin
                                      //  
                                      if (o=nil) or (o.pdi.dPageRect.Top>p.Bands[i].Objects[j].pdi.dPageRect.Top) then
                                        o:=p.Bands[i].Objects[j];
                                    end;
                              if o<>nil then
                                pdiNext:=o.pdi;
                            end;
                        end;
                      end
                    else
                      if b.BandType in HorizontalBands then
                        begin
                          case Key of
                            VK_UP  :
                              begin
                                //   
                                b2:=nil;
                                for i:=0 to p.Bands.Count-1 do
                                  if (p.Bands[i].BandType in HorizontalBands) and
                                     (p.Bands[i]<>b) and
                                     (p.Bands[i].pdi.dPageRect.Top<pdiCur.dPageRect.Top) and
                                     ((b2=nil) or
                                      (b2.pdi.dPageRect.Top<p.Bands[i].pdi.dPageRect.Top)) then
                                    b2:=p.Bands[i];
                                if b2<>nil then
                                  pdiNext:=b2.pdi;
                              end;
                            VK_DOWN :
                              begin
                                //   
                                b2:=nil;
                                for i:=0 to p.Bands.Count-1 do
                                  if (p.Bands[i].BandType in HorizontalBands) and
                                     (p.Bands[i]<>b) and
                                     (p.Bands[i].pdi.dPageRect.Top>pdiCur.dPageRect.Top) and
                                     ((b2=nil) or
                                      (b2.pdi.dPageRect.Top>p.Bands[i].pdi.dPageRect.Top)) then
                                    b2:=p.Bands[i];
                                if b2<>nil then
                                  pdiNext:=b2.pdi;
                              end;
                            VK_LEFT,VK_RIGHT:
                              begin
                                //   
                                if b.Objects.Count>0 then
                                  begin
                                    o:=b.Objects[0];
                                    for i:=1 to b.Objects.Count-1 do
                                      if o.pdi.dPageRect.Left>b.Objects[i].pdi.dPageRect.Left then
                                        o:=b.Objects[i];
                                    pdiNext:=o.pdi;
                                  end;
                              end;
                          end;
                        end;
                  end;
            end;
          else
            begin
              pdiNext:=SelPDI[0];
            end;
        end;

        //
        if pdiNext<>nil then
          begin
            DrawSelectedObjects(Canvas.Handle);
            ClearSelected;
            SelectObj(pdiNext);
            DrawSelectedObjects(Canvas.Handle);
            SelectionChanged;

            //        
            sb:=TScrollBox(Parent);
            hs:=sb.HorzScrollBar;
            vs:=sb.VertScrollBar;
            rl:=hs.Position;
            rr:=hs.Position+sb.ClientWidth;
            rt:=vs.Position;
            rb:=vs.Position+sb.ClientHeight;
            if (pdiNext.dPageRect.Left<rl) or
               (pdiNext.dPageRect.Left>rr) or
               (pdiNext.dPageRect.Right<rl) or
               (pdiNext.dPageRect.Right>rr) then
              begin
                if (pdiNext.dPageRect.Right-pdiNext.dPageRect.Left>rr-rl) or (pdiNext.dPageRect.Left<rl) then
                  hs.Position:=pdiNext.dPageRect.Left
                else
                  hs.Position:=pdiNext.dPageRect.Right-rr+rl;
              end;
            if (pdiNext.dPageRect.Top<rt) or
               (pdiNext.dPageRect.Top>rb) or
               (pdiNext.dPageRect.Bottom<rt) or
               (pdiNext.dPageRect.Bottom>rb) then
              begin
                if (pdiNext.dPageRect.Bottom-pdiNext.dPageRect.Top>rb-rt) or (pdiNext.dPageRect.Top<rt) then
                  vs.Position:=pdiNext.dPageRect.Top
                else
                  vs.Position:=pdiNext.dPageRect.Bottom-rb+rt;
              end;
          end;
        Key:=0;
      end;

  end
else
  begin
    if Designer.UseGrid then
      begin
        StepY:=Designer.GridSizeY;
        StepX:=Designer.GridSizeX;
      end
    else
      begin
        StepY:=Designer.ConvertYToDesignerCoords(1);
        StepX:=Designer.ConvertXToDesignerCoords(1);
      end;

    if (Shift=[ssShift]) and (Key in [VK_LEFT,VK_RIGHT,VK_UP,VK_DOWN]) then
      begin
        _BeginPaint(prps);
        for i:=0 to FSelPDI.Count-1 do
          case Key of
            VK_LEFT:
              if ([ppLeftTop,ppLeft,ppLeftBottom]*SelPDI[i].AllowResizeTypes)<>[] then
                DoResize(SelPDI[i],0,0,0,-StepX,@prps);
            VK_RIGHT:
              if ([ppRightTop,ppRight,ppRightBottom]*SelPDI[i].AllowResizeTypes)<>[] then
                DoResize(SelPDI[i],0,0,0,StepX,@prps);
            VK_UP:
              if ([ppLeftTop,ppTop,ppRightTop]*SelPDI[i].AllowResizeTypes)<>[] then
                DoResize(SelPDI[i],0,0,-StepY,0,@prps);
            VK_DOWN:
              if ([ppLeftBottom,ppBottom,ppRightBottom]*SelPDI[i].AllowResizeTypes)<>[] then
                DoResize(SelPDI[i],0,0,StepY,0,@prps);
          end;
        _EndPaint(prps);
      end
    else
      if (Shift=[ssCtrl]) and (Key in [VK_LEFT,VK_RIGHT,VK_UP,VK_DOWN]) then
        begin
          _BeginPaint(prps);
          for i:=0 to FSelPDI.Count-1 do
            if SelPDI[i].AllowDrag then
              case Key of
                VK_LEFT:
                  DoDrag(SelPDI[i],-StepX,0,@prps);
                VK_RIGHT:
                  DoDrag(SelPDI[i],StepX,0,@prps);
                VK_UP:
                  DoDrag(SelPDI[i],0,-StepY,@prps);
                VK_DOWN:
                  DoDrag(SelPDI[i],0,StepY,@prps);
              end;
          _EndPaint(prps);
        end;
  end;
  
inherited;
end;

procedure TprCustomDPanel.EndInplaceEdit;
var
  pt,pl : integer;
begin
if FInplaceEditor<>nil then
  begin
    pl:=TScrollBox(Parent).HorzScrollBar.Position;
    pt:=TScrollBox(Parent).VertScrollBar.Position;

    SetFocus;
    FInplaceEditor.Free;
    FInplaceEditor   :=nil;
    FInplaceEditedObj:=nil;

    TScrollBox(Parent).HorzScrollBar.Position:=pl;
    TScrollBox(Parent).VertScrollBar.Position:=pt;

    Designer.UpdateCurrentPage;
  end;
end;

function TprCustomDPanel.AllowInplaceEdit;
begin
Result:=(SelObjs.Count=1) and (TObject(SelObjs[0]) is TprObj);
end;

function TprCustomDPanel.GetExData;
begin
Result:=nil;
end;

function TprCustomDPanel.Designer;
begin
Result:=TprCustomDesignerForm(Owner);
end;

function TprCustomDPanel.Report;
begin
Result:=TprCustomReport(Designer.Report);
end;

procedure TprCustomDPanel.DrawAnime;
var
  npn,opn : HPEN;
  pmm,oBottom,oLeft,oTop,oRight : integer;

  procedure DrawObjectsOffs(dx,dy : integer);
  var
    i : integer;
  begin
  for i:=0 to SelObjs.Count-1 do
    with SelPDI[i]^ do
      if AllowDrag then
        DrawRect(DC,Rect(dPageRect.Left+dx,dPageRect.Top+dy,dPageRect.Right+dx,dPageRect.Bottom+dy));
  end;

begin
case FMouseMode of
  mmInsertObj:
    begin
      //   
      if (FStartX<>LastX) or (FStartY<>LastY) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,LastX,LastY));
      if (FStartX<>X) or (FStartY<>Y) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,X,Y));
    end;
  mmSelect:
    begin
      //   
      if (FStartX<>LastX) or (FStartY<>LastY) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,LastX,LastY));
      if (FStartX<>X) or (FStartY<>Y) then
        DrawFocusRect(DC,NormalizeRect(FStartX,FStartY,X,Y));
    end;
  mmSelectedRegionsDrag:
    begin
      //    (   )
      pmm:=SetROP2(DC,R2_NOT);
      npn:=CreatePen(PS_SOLID,1,clBlack);
      opn:=SelectObject(DC,npn);

      if (FStartX<>LastX) or (FStartY<>LastY) then
        DrawObjectsOffs(LastX-FStartX,LastY-FStartY);
      if (FStartX<>X) or (FStartY<>Y) then
        DrawObjectsOffs(X-FStartX,Y-FStartY);

      SelectObject(DC,opn);
      DeleteObject(npn);
      SetROP2(DC,pmm);

      Designer.UpdateSelectedRegionSizes(Rect(FSelectedRect.Left+X-FStartX,
                                              FSelectedRect.Top+Y-FStartY,
                                              FSelectedRect.Right+X-FStartX,
                                              FSelectedRect.Bottom+Y-FStartY),false);
    end;
  mmRegionResize:
    begin
      //    FResizeRegion
      if (FStartX<>LastX) or (FStartY<>LastY) then
        begin
          CalcOffs(LastX-FStartX,LastY-FStartY,FResizeMode,oTop,oLeft,oBottom,oRight);
          DrawFocusRect(DC,
                        Rect(FResizeRegion.dPageRect.Left+oLeft,
                             FResizeRegion.dPageRect.Top+oTop,
                             FResizeRegion.dPageRect.Right+oRight,
                             FResizeRegion.dPageRect.Bottom+oBottom));
        end;
      if (FStartX<>X) or (FStartY<>Y) then
        begin
          CalcOffs(X-FStartX,Y-FStartY,FResizeMode,oTop,oLeft,oBottom,oRight);
          DrawFocusRect(DC,
                        Rect(FResizeRegion.dPageRect.Left+oLeft,
                             FResizeRegion.dPageRect.Top+oTop,
                             FResizeRegion.dPageRect.Right+oRight,
                             FResizeRegion.dPageRect.Bottom+oBottom));
          Designer.UpdateSelectedRegionSizes(Rect(FResizeRegion.dPageRect.Left+oLeft,
                                                  FResizeRegion.dPageRect.Top+oTop,
                                                  FResizeRegion.dPageRect.Right+oRight,
                                                  FResizeRegion.dPageRect.Bottom+oBottom),false);
        end;
    end;
  mmRegionLink:
    begin
      //  
      pmm:=SetROP2(DC,R2_NOT);
      npn:=CreatePen(PS_SOLID,1,clBlack);
      opn:=SelectObject(DC,npn);

      if (FStartX<>LastX) or (FStartY<>LastY) then
        begin
          Canvas.MoveTo(FStartX,FStartY);
          Canvas.LineTo(LastX,LastY);
        end;

      if (FStartX<>X) or (FStartY<>Y) then
        begin
          Canvas.MoveTo(FStartX,FStartY);
          Canvas.LineTo(X,Y);
        end;

      SelectObject(DC,opn);
      DeleteObject(npn);
      SetROP2(DC,pmm);
    end;
  mmSelectedResize:
    begin
{
      //      (FSelectedRect)
      if not ((FStartX=LastX) and (FStartY=LastY)) then
        begin
          dx:=LastX-FStartX;
          dy:=LastY-FStartY;
          CalcOffs(dx,dy,ppRightBottom,oTop,oLeft,oBottom,oRight);
          DrawFocusRect(DC,
                        Rect(FSelectedRect.Left+oLeft,
                             FSelectedRect.Top+oTop,
                             FSelectedRect.Right+oRight,
                             FSelectedRect.Bottom+oBottom));
        end;
      LastX:=X;
      LastY:=Y;
      dx:=LastX-FStartX;
      dy:=LastY-FStartY;
      CalcOffs(dx,dy,ppRightBottom,oTop,oLeft,oBottom,oRight);
      DrawFocusRect(DC,
                    Rect(FSelectedRect.Left+oLeft,
                         FSelectedRect.Top+oTop,
                         FSelectedRect.Right+oRight,
                         FSelectedRect.Bottom+oBottom));
}
    end;
end;
end;

procedure TprCustomDPanel.DrawLinks;
var
  p : TprCustomPage;
  b : TprBand;
  o : TprObj;
  r1,r2 : TRect;
  npn,opn : HPEN;
  i,j,k,pmm : integer;
begin
p  :=Designer.CurPage;
pmm:=SetROP2(DC,R2_NOT);
npn:=CreatePen(PS_SOLID,1,clBlack);
opn:=SelectObject(DC,npn);

for i:=0 to p.Bands.Count-1 do
  begin
    b:=p.Bands[i];
    for j:=0 to b.ResizeObjs.Count-1 do
      begin
        r1:=b.ResizeObjs[j].pdi.dPageRect;

        if b.BandType in HorizontalBands then
          begin
            MoveToEx(DC,
                     r1.Left+(r1.Right-r1.Left) div 2,
                     r1.Bottom,
                     nil);
            LineTo(DC,
                   b.pdi.dPageRect.Left+(b.pdi.dPageRect.Right-b.pdi.dPageRect.Left) div 2,
                   b.pdi.dPageRect.Bottom);
          end
        else
          if b.BandType in VerticalBands then
            begin
              MoveToEx(DC,
                       r1.Right,
                       r1.Top+(r1.Bottom-r1.Top) div 2,
                       nil);
              LineTo(DC,
                     b.pdi.dPageRect.Right,
                     b.pdi.dPageRect.Top+(b.pdi.dPageRect.Bottom-b.pdi.dPageRect.Top) div 2);
            end;
      end;

    for j:=0 to b.Objects.Count-1 do
      begin
        o :=b.Objects[j];
        r2:=o.PDI.dPageRect;
        for k:=0 to o.TopObjs.Count-1 do
          begin
            r1:=o.TopObjs[k].PDI.dPageRect;
            MoveToEx(DC,r2.Left+(r2.Right-r2.Left) div 2,r2.Top,nil);
            LineTo(DC,r1.Left+(r1.Right-r1.Left) div 2,r1.Bottom);
          end;

        for k:=0 to o.LeftObjs.Count-1 do
          begin
            r1:=o.LeftObjs[k].PDI.dPageRect;
            MoveToEx(DC,r2.Left,r2.Top+(r2.Bottom-r2.Top) div 2,nil);
            LineTo(DC,r1.Right,r1.Top+(r1.Bottom-r1.Top) div 2);
          end;

        for k:=0 to o.WidthObjs.Count-1 do
          begin
            r1:=o.WidthObjs[k].PDI.dPageRect;
            MoveToEx(DC,r2.Right,r2.Top+(r2.Bottom-r2.Top) div 2,nil);
            LineTo(DC,r1.Right,r1.Top+(r1.Bottom-r1.Top) div 2);
          end;

        for k:=0 to o.HeightObjs.Count-1 do
          begin
            r1:=o.HeightObjs[k].PDI.dPageRect;
            MoveToEx(DC,r2.Left+(r2.Right-r2.Left) div 2,r2.Bottom,nil);
            LineTo(DC,r1.Left+(r1.Right-r1.Left) div 2,r1.Bottom);
          end;
      end;
  end;

SelectObject(DC,opn);
DeleteObject(npn);
SetROP2(DC,pmm);
end;

procedure TprCustomDPanel.DesignerGridSizeChanged;
begin
UpdateGridBitmap(FGridBitmap,Designer.GridSizeX,Designer.GridSizeY);
end;

procedure TprCustomDPanel.RepaintSelectedObjects;
var
  i : integer;
  pdi : pDesignInfo;
  Rgn,TempRgn : HRGN;
begin
Rgn:=0;
for i:=0 to SelObjs.Count-1 do
  if TObject(SelObjs[i]) is TprObj then
    begin
      pdi:=SelPDI[i];
      if Rgn=0 then
        Rgn:=CreateRectRgnIndirect(pdi.dPageRect)
      else
        begin
          TempRgn:=CreateRectRgnIndirect(pdi.dPageRect);
          CombineRgn(Rgn,Rgn,TempRgn,RGN_OR);
          DeleteObject(TempRgn);
        end;
    end;
if Rgn<>0 then
  begin
    InternalPaint(Canvas.Handle,Rgn);
    DeleteObject(Rgn);
  end;
end;

procedure TprCustomDPanel.InternalPaint;
var
  b : TprBand;
  o : TprObj;
  p : TprCustomPage;
  nbr : HBRUSH;
  i,j : integer;
  BackRgn,TempRgn : HRGN;

begin
p:=Designer.CurPage;

// 0.      
DrawSelectedObjects(DC);
DrawLinks(DC);

// 1.  ,    
//  BackRgn
BackRgn:=CreateRectRgn(0,0,Width,Height);
CombineRgn(BackRgn,BackRgn,Rgn,RGN_AND);
for i:=0 to p.Bands.Count-1 do
  for j:=0 to p.Bands[i].Objects.Count-1 do
    begin
      o:=p.Bands[i].Objects[j];
      if RectInRegion(Rgn,o.PDI.dPageRect) then
        begin
          TempRgn:=CreateRectRgnIndirect(o.PDI.dPageRect);
          CombineRgn(BackRgn,BackRgn,TempRgn,RGN_DIFF);
          DeleteObject(TempRgn);
        end;
    end;
//  
if Designer.ShowGrid then
  begin
    if (FGridBitmap=0) or
       ((Win32Platform<>VER_PLATFORM_WIN32_NT) and ((Designer.GridSizeX<>8) or (Designer.GridSizeY<>8))) then
      begin
        //  
        nbr:=CreateSolidBrush(clWhite);
        FillRgn(DC,BackRgn,nbr);
        DeleteObject(nbr);

        i:=0;
        while i<Width do
          begin
            j:=0;
            while j<Height do
              begin
                if PtInRegion(BackRgn,i,j) then
                  SetPixelV(DC,i,j,clBlack);
                Inc(j,Designer.GridSizeY);
              end;
            Inc(i,Designer.GridSizeX);
          end;
      end
    else
      begin
        nbr:=CreatePatternBrush(FGridBitmap);
        FillRgn(DC,BackRgn,nbr);
        DeleteObject(nbr);
      end;
  end
else
  begin
    nbr:=CreateSolidBrush(clWhite);
    FillRgn(DC,BackRgn,nbr);
    DeleteObject(nbr);
  end;
DeleteObject(BackRgn);

// 2.    ,    Rgn,
SelectClipRgn(DC,Rgn);
//  
for i:=0 to p.Bands.Count-1 do
  begin
    b:=p.Bands[i];
    if RectInRegion(Rgn,b.PDI.dPageRect) then
      begin
        // 
        b.DrawDesign(DC,GetExData);
      end;
  end;

//  
for i:=0 to p.Bands.Count-1 do
  for j:=0 to p.Bands[i].Objects.Count-1 do
    begin
      o:=p.Bands[i].Objects[j];
      if RectInRegion(Rgn,o.PDI.dPageRect) then
        begin
          // 
          o.DrawDesign(DC,GetExData);
        end;
    end;

// 3.    ,   TprReport -  
PaintOther(DC);

// 4.    
SelectClipRgn(DC,0);
DrawLinks(DC);
DrawSelectedObjects(DC);
end;

procedure TprCustomDPanel.PaintOther;
begin
end;

procedure TprCustomDPanel.mPaint;
var
  PS : TPaintStruct;
  DC : HDC;
  Rgn : HRGN;
begin
Message.Result := 1;
if Designer.FDisablePageDraw or
   (csDestroying in Designer.CurPage.ComponentState) then exit;

DC := BeginPaint(Handle,PS);
Rgn := CreateRectRgnIndirect(PS.rcPaint);
InternalPaint(DC,Rgn);
DeleteObject(Rgn);
EndPaint(Handle,PS);
end;

procedure TprCustomDPanel.mEraseBkgnd;
begin
Message.Result := 1;
end;

procedure TprCustomDPanel.DrawSelectedObjects;
var
  i : integer;
  pmm : integer;
  npn,opn : HPEN;
begin
if SelObjs.Count>1 then
  npn := CreatePen(PS_SOLID,SelectPointSize,clWhite)
else
  npn := CreatePen(PS_SOLID,SelectPointSize,clWhite);
pmm := SetROP2(DC,R2_XORPEN);
opn := SelectObject(DC,npn);

for i:=0 to SelObjs.Count-1 do
  DrawSelectedObject(DC,SelPDI[i].dPageRect,SelPDI[i].AllowResizeTypes);

SetROP2(DC,pmm);
SelectObject(DC,opn);
DeleteObject(npn);
end;

procedure TprCustomDPanel.GetPointInfoAt;
var
  p : TprCustomPage;
  i,j,dx,dy : integer;

  function AnalysListResize(L : TList) : boolean;
  var
    i : integer;
  begin
  Result:=true;
  for i:=0 to L.Count-1 do
    begin
      PDI:=pDesignInfo(L[i]);
      dx :=(PDI.dPageRect.Right-PDI.dPageRect.Left) div 2;
      dy :=(PDI.dPageRect.Bottom-PDI.dPageRect.Top) div 2;
      if GetResizeType(X,Y,PDI.dPageRect,ResizeMode) and (ResizeMode in PDI.AllowResizeTypes) then
        exit;
    end;
  Result:=false;
  end;

  function AnalysListLink(L : TList) : boolean;
  var
    i : integer;
  begin
  Result:=true;
  for i:=0 to L.Count-1 do
    begin
      PDI:=pDesignInfo(L[i]);

      if (ltLeft in PDI.AllowLinkTypes) and PointInRect(X,Y,Rect(PDI.dPageRect.Left-2,PDI.dPageRect.Top,PDI.dPageRect.Left+2,PDI.dPageRect.Bottom)) then
        begin
          LinkMode:=ltLeft;
          exit;
        end;

      if (ltTop in PDI.AllowLinkTypes) and PointInRect(X,Y,Rect(PDI.dPageRect.Left,PDI.dPageRect.Top-2,PDI.dPageRect.Right,PDI.dPageRect.Top+2)) then
        begin
          LinkMode:=ltTop;
          exit;
        end;

      if (ltRight in PDI.AllowLinkTypes) and PointInRect(X,Y,Rect(PDI.dPageRect.Right-2,PDI.dPageRect.Top,PDI.dPageRect.Right+2,PDI.dPageRect.Bottom)) then
        begin
          LinkMode:=ltRight;
          exit;
        end;
  
      if (ltBottom in PDI.AllowLinkTypes) and PointInRect(X,Y,Rect(PDI.dPageRect.Left,PDI.dPageRect.Bottom-2,PDI.dPageRect.Right,PDI.dPageRect.Bottom+2)) then
        begin
          LinkMode:=ltBottom;
          exit;
        end;
    end;
  Result:=false;
  end;

begin
PDI       :=nil;
PointInfo :=piNone;

//  
if (SelObjs.Count>1) and CSP(X,Y,FSelectedRect.Right,FSelectedRect.Bottom) then
  begin
    PointInfo :=piSelectedResize;
    ResizeMode:=ppRightBottom;
    exit;
  end;

//    ,   Resize
PointInfo:=piRegionResize;
if AnalysListResize(FSelPDI) then exit;

//    ,   Link
PointInfo:=piRegionLink;
if AnalysListLink(FSelPDI) then exit;

//    
PDI      :=nil;
PointInfo:=piNone;
p        :=Designer.CurPage;

//   
for i:=0 to p.Bands.Count-1 do
  for j:=p.Bands[i].Objects.Count-1 downto 0 do
    if PointInRect(X,Y,p.Bands[i].Objects[j].PDI.dPageRect) then
      begin
        PDI      :=p.Bands[i].Objects[j].PDI;
        PointInfo:=piRegionInside;
        exit;
      end;

//   
for i:=0 to p.Bands.Count-1 do
  if (p.Bands[i].BandType in HorizontalBands) and
     PointInRect(X,Y,p.Bands[i].PDI.dPageRect) then
    begin
      PDI      :=p.Bands[i].PDI;
      PointInfo:=piRegionInside;
      exit;
    end;

//   
for i:=0 to p.Bands.Count-1 do
  if (p.Bands[i].BandType in VerticalBands) and
     PointInRect(X,Y,p.Bands[i].PDI.dPageRect) then
    begin
      PDI      :=p.Bands[i].PDI;
      PointInfo:=piRegionInside;
      exit;
    end;

//  ,  - 
for i:=0 to p.Bands.Count-1 do
  if not(p.Bands[i].BandType in HorizontalBands) and
     not(p.Bands[i].BandType in VerticalBands) and
     PointInRect(X,Y,p.Bands[i].PDI.dPageRect) then
    begin
      PDI      :=p.Bands[i].PDI;
      PointInfo:=piRegionInside;
      exit;
    end;
end;

//
//       
//
procedure TprCustomDPanel.SelectionChanged;
begin
{$IFDEF DEBUG}
WriteToLog('TprCustomDPanel.SelectionChanged');
{$ENDIF}
UpdateSelectedInfo;
Designer.SelectionChanged;
end;

//
//  FSelectedRect,      
//      
//
procedure TprCustomDPanel.UpdateSelectedInfo;
var
  i : integer;
  r : TRect;
begin
{$IFDEF DEBUG}
WriteToLog('TprCustomDPanel.UpdateSelectedInfo');
{$ENDIF}

if SelObjs.Count=0 then
  begin
    FSelectedRect:=Rect(-1,-1,-1,-1);
  end
else
  begin
    FSelectedRect:=SelPDI[0].dPageRect;
    for i:=1 to SelObjs.Count-1 do
      begin
        r:=SelPDI[i].dPageRect;
        if r.Top<FSelectedRect.Top then
          FSelectedRect.Top:=r.Top;
        if r.Left<FSelectedRect.Left then
          FSelectedRect.Left:=r.Left;
        if r.Bottom>FSelectedRect.Bottom then
          FSelectedRect.Bottom:=r.Bottom;
        if r.Right>FSelectedRect.Right then
          FSelectedRect.Right:=r.Right;
      end;
  end;

Designer.UpdateSelectedRegionSizes(FSelectedRect,SelObjs.Count=0);
end;

procedure TprCustomDPanel.SetMouseCursorState;
var
  nc : TCursor;
  PDI : pDesignInfo;
  PointInfo : TprPointInfo;
  ResizeMode : TprResizeType;
  LinkMode : TprLinkType;
  Selected : boolean;
begin
nc:=crArrow;

if FMouseMode=mmNone then
  begin
    if Designer.FCurClassRef<>nil then
      nc:=crCross
    else
      begin
        GetPointInfoAt(X,Y,pdi,PointInfo,ResizeMode,LinkMode);
        Selected:=IsObjSelected(pdi);
        
        if PointInfo=piSelectedResize then
          nc:=prResizeCursors[ResizeMode]
        else
          if (SelObjs.Count>1) and (pdi<>nil) and Selected then
            nc:=crMultiDrag
          else
            if (pdi<>nil) and pdi.AllowDrag and ((not Selected) or (Selected and (PointInfo=piRegionInside))) then
              nc:=crDrag
            else
              case PointInfo of
                piRegionResize:
                  begin
                    if Selected and (ResizeMode in PDI.AllowResizeTypes) then
                      nc:=prResizeCursors[ResizeMode];
                  end;
                piRegionLink:
                  begin
                    if Selected and (LinkMode in PDI.AllowLinkTypes) then
                      nc:=crHandPoint
                  end
              end;
      end;
  end;

if Cursor<>nc then
  Cursor:=nc;
end;

procedure TprCustomDPanel.DoLink;
var
  LinkAccepted : boolean;
begin
if SourceRegion.Parent is TprObj then
  begin
    LinkAccepted:=false;
    TprObj(SourceRegion.Parent).DesignerLink(DestRegion,LinkMode,LinkAccepted,GetExData);
    Report.TemplateChanged:=true;
  end
else
  if SourceRegion.Parent is TprBand then
    begin
      LinkAccepted:=false;
      TprBand(SourceRegion.Parent).DesignerLink(DestRegion,LinkMode,LinkAccepted);
      Report.TemplateChanged:=true;
    end;
end;

procedure TprCustomDPanel.DoResize;
begin
oLeft := Designer.ConvertXFromDesignerCoords(oLeft);
oRight := Designer.ConvertXFromDesignerCoords(oRight);
oTop := Designer.ConvertYFromDesignerCoords(oTop);
oBottom := Designer.ConvertYFromDesignerCoords(oBottom);
if ResizeRegion.Parent is TprObj then
  begin
    if prps<>nil then
      AddRectToRegion(prps.ClipRgn,ResizeRegion.dPageRect);
    TprObj(ResizeRegion.Parent).DesignerResize(oTop,oLeft,oBottom,oRight,GetExData);
    if prps<>nil then
      begin
        AddRectToRegion(prps.ClipRgn,ResizeRegion.dPageRect);
        Include(prps.ClipState,prcsObj);
      end;
    Report.TemplateChanged:=true;
  end
else
  if ResizeRegion.Parent is TprBand then
    begin
      TprBand(ResizeRegion.Parent).DesignerResize(oTop,oLeft,oBottom,oRight);
      if prps<>nil then
        Include(prps.ClipState,prcsBand);
      Report.TemplateChanged:=true;
    end
end;

procedure TprCustomDPanel.DoDrag;
begin
dx:=Designer.ConvertXFromDesignerCoords(dx);
dy:=Designer.ConvertYFromDesignerCoords(dy);
if DragRegion.Parent is TprObj then
  begin
    if prps<>nil then
      AddRectToRegion(prps.ClipRgn,DragRegion.dPageRect);
    TprObj(DragRegion.Parent).DesignerDrag(dx,dy,GetExData);
    if prps<>nil then
      begin
        AddRectToRegion(prps.ClipRgn,DragRegion.dPageRect);
        Include(prps.ClipState,prcsObj);
      end;
    Report.TemplateChanged:=true;
  end;
end;

procedure TprCustomDPanel._MouseDblClick;
begin
if FDownRegion<>nil then
  begin
    FFirstMoveAfterDown := false;
    FMouseMode := mmNone;
    FDblClick := true;
    if not Designer.ObjectsPropsForm.Visible then
      Designer.ObjectsPropsForm.Visible := true;
  end;
end;

//
//    ,     
//  Selected
//
procedure TprCustomDPanel._MouseDown;
label
  lFin;
var
  FDownSelected : boolean;
begin
if FDblClick then
  begin
    //    
    FDblClick:=false;
    exit;
  end;

if [ssLeft,ssRight]*Shift=[] then exit; //        

//   ,  
if Designer.UseGrid then
  begin
    FLastX := ATG(X,Designer.GridSizeX);
    FLastY := ATG(Y,Designer.GridSizeY);
  end
else
  begin
    FLastX := X;
    FLastY := Y;
  end;
FStartX := FLastX;
FStartY := FLastY;
FStartRealX := X;
FStartRealY := Y;
FFirstMoveAfterDown := true;

//      
GetPointInfoAt(X,Y,FDownRegion,FDownPointInfo,FDownResizeMode,FDownLinkMode);
FDownSelected:=IsObjSelected(FDownRegion);

if (FInplaceEditor<>nil) and ((FDownRegion=nil) or (FDownRegion.Parent<>FInplaceEditedObj)) then
  begin
    //  Inplace 
    SaveInplaceEdit;
    FPrevObj:=nil;
  end;

//   
DrawSelectedObjects(Canvas.Handle);
DrawLinks(Canvas.Handle);

if Designer.FCurClassRef<>nil then
  begin
    //   
    FMouseMode:=mmInsertObj;
    goto lFin;
  end;

if ssRight in Shift then
  begin
    //    
    if FDownRegion<>nil then
      begin
        if ssShift in Shift then
          begin
            if not FDownSelected then
              SelectObj(FDownRegion);
          end
        else
          begin
            ClearSelected;
            SelectObj(FDownRegion);
          end
      end;

    FMouseMode:=mmNone;
    DrawSelectedObjects(Canvas.Handle);
    DrawLinks(Canvas.Handle);
    SelectionChanged;
    exit;
  end;

//    
if FDownPointInfo=piSelectedResize then
  begin
    //        
    FMouseMode:=mmSelectedResize;
    goto lFin;
  end;

if FDownRegion=nil then
  begin
    ClearSelected;
    FMouseMode:=mmSelect;
    goto lFin;
  end;

// FDownRegion<>nil
if ssShift in Shift then
  begin
    //   
    if FDownSelected then
      DeSelectObj(FDownRegion)
    else
      SelectObj(FDownRegion);
    FMouseMode:=mmNone;
    DrawSelectedObjects(Canvas.Handle);
    DrawLinks(Canvas.Handle);
    SelectionChanged;
    exit;
  end;

if FDownSelected then
  begin
    if SelObjs.Count=1 then
      begin
        //       
        //     , ,  
        case FDownPointInfo of
          piRegionInside:
            begin
              //  
              if FDownRegion.AllowDrag then
                begin
                  //   ,  
                  FDragRegion:=FDownRegion;
                  FMouseMode :=mmSelectedRegionsDrag;
                end
              else
                //   
                FMouseMode:=mmSelect;
            end;
          piRegionResize:
            begin
              FMouseMode   :=mmRegionResize;
              FResizeRegion:=FDownregion;
              FResizeMode  :=FDownResizeMode;
            end;
          piRegionLink:
            begin
              FMouseMode :=mmRegionLink;
              FLinkRegion:=FDownRegion;
              FLinkMode  :=FDownLinkMode;
            end;
          else
            //       
            FMouseMode:=mmNone;
        end;
      end
    else
      begin
        FMouseMode :=mmSelectedRegionsDrag;
      end;
  end
else
  begin
    ClearSelected;
    if FDownRegion.AllowDrag then
      begin
        //  
        SelectObj(FDownRegion);
        FMouseMode:=mmSelectedRegionsDrag;
      end
    else
      //   
      FMouseMode:=mmSelect;
  end;
lFin:
UpdateSelectedInfo
end;

//
// :
//   -  
//   -  
//   -  
//   -  
//
procedure TprCustomDPanel._MouseUp;
var
  o : TprObj;
  L : TList;
  p : TprCustomPage;
  f : boolean;
  PDI : pDesignInfo;
  r,r2 : TRect;
  Delta : DWORD;
  ClipRgn : HRGN;
  LinkMode : TprLinkType;
  PointInfo : TprPointInfo;
  ResizeMode : TprResizeType;
  RealX,RealY,i,j,dx,dy,oTop,oLeft,oBottom,oRight : integer;

  procedure InsertObj(r : TRect);
  var
    b : TprBand;
  begin
  if FDownRegion<>nil then
    begin
      if FDownRegion.Parent is TprObj then
        b:=TprObj(FDownRegion.Parent).Band
      else
        if FDownRegion.Parent is TprCustomHBand then
          b:=TprCustomHBand(FDownRegion.Parent)
        else
          if FDownRegion.Parent is TprCustomVBand then
            b:=TprCustomVBand(FDownRegion.Parent)
          else
            b:=nil;

        if b<>nil then
          begin
            if Designer.UseGrid then
              begin
                r.Top   :=ATG(r.Top,Designer.GridSizeY);
                r.Left  :=ATG(r.Left,Designer.GridSizeX);
                r.Right :=ATG(r.Right,Designer.GridSizeX)+1;
                r.Bottom:=ATG(r.Bottom,Designer.GridSizeY)+1;
              end;
            Designer.ConvertFromDesignerCoords(r,r2);
            if (r2.Right-r2.Left>0) and (r2.Bottom-r2.Top>0) then
              begin
                ClipRgn:=CreateRectRgnIndirect(r);
                ClearSelected;
                o                  :=CreatePrObj(Designer.FCurClassRef,b);
                o.dRec.pRect.Left  :=r2.Left  -b.dPageRect.Left;
                o.dRec.pRect.Top   :=r2.Top   -b.dPageRect.Top;
                o.dRec.pRect.Right :=r2.Right -b.dPageRect.Left;
                o.dRec.pRect.Bottom:=r2.Bottom-b.dPageRect.Top;
                Designer.OnObjInserted(o);

                o.UpdatePDI(GetExData);
                SelectObj(o.PDI);
                SelectionChanged;

                Report.TemplateChanged:=true;
              end;
          end;
    end;
  end;

begin
RealX:=X;
RealY:=Y;
if (FMouseMode<>mmRegionLink) and Designer.UseGrid then
  begin
    X:=ATG(X,Designer.GridSizeX);
    Y:=ATG(Y,Designer.GridSizeY);
  end;

DrawAnime(Canvas.Handle,X,Y,FStartX,FStartY);

ClipRgn:=0;
case FMouseMode of
  mmNone:
    begin
      //  ,  -
    end;
  mmInsertObj:
    begin
      //   
      if FFirstMoveAfterDown then
        r:=Rect(x,y,x+100,y+40)
      else
        r:=NormalizeRect(FStartX,FStartY,X,Y);

      // r -    
      InsertObj(r);

      DrawSelectedObjects(Canvas.Handle);
      SelectionChanged;
      DrawLinks(Canvas.Handle);
    end;
  mmSelect:
    begin
      //    -  , :
      //      ,  Band   
      //       
      //         
      // 
      if Shift<>[ssShift] then
        ClearSelected;

      r:=NormalizeRect(FStartRealX,FStartRealY,RealX,RealY);
      p:=Designer.CurPage;
      f:=true;
      for i:=0 to p.Bands.Count-1 do
        for j:=0 to p.Bands[i].Objects.Count-1 do
          if RectOverRect(p.Bands[i].Objects[j].PDI.dPageRect,r) then
            begin
              SelectObj(p.Bands[i].Objects[j].PDI);
              f:=false;
            end;
      if f then
        begin
          L:=TList.Create;
          try
            for i:=0 to p.Bands.Count-1 do
              if RectOverRect(p.Bands[i].PDI.dPageRect,r) then
                L.Add(p.Bands[i].PDI);
            if L.Count>0 then
              if (FStartRealX=RealX) and (FStartRealY=RealY) then
                begin
                  //        
                  i:=0;
                  while (i<L.Count) and not(pDesignInfo(L[i]).Parent is TprCustomHBand) do Inc(i);
                  if i<L.Count then
                    SelectObj(pDesignInfo(L[i]))
                  else
                    SelectObj(pDesignInfo(L[0]));
                end
              else
                begin
                  //  
                  for i:=0 to L.Count-1 do
                    SelectObj(pDesignInfo(L[i]));
                end;
          finally
            L.Free;
          end;
        end;
      //   
      DrawSelectedObjects(Canvas.Handle);
      SelectionChanged;
      DrawLinks(Canvas.Handle);
    end;
  mmRegionLink:
    begin
      GetPointInfoAt(x,y,PDI,PointInfo,ResizeMode,LinkMode);
      if (PDI<>FLinkRegion) and (PDI<>nil) then
        begin
          DoLink(FLinkRegion,PDI,FLinkMode);
          Designer.UpdateLinksForms;
        end;
      DrawSelectedObjects(Canvas.Handle);
      DrawLinks(Canvas.Handle);
    end;
  mmRegionResize:
    begin
      //   ,      
      CalcOffs(x-FStartX,y-FStartY,FResizeMode,oTop,oLeft,oBottom,oRight);
      if (FResizeRegion.dPageRect.Left+oLeft<FResizeRegion.dPageRect.Right+oRight) and
         (FResizeRegion.dPageRect.Top+oTop<FResizeRegion.dPageRect.Bottom+oBottom) then
        begin
          //
          if FResizeRegion.Parent is TprObj then
            begin
              AddRectToRegion(ClipRgn,FResizeRegion.dPageRect);
              DoResize(FResizeRegion,oTop,oLeft,oBottom,oRight,nil);
              AddRectToRegion(ClipRgn,FResizeRegion.dPageRect);

              if (FInplaceEditor<>nil) and (FInplaceEditedObj=FResizeRegion.Parent) then
                begin
                  FInplaceEditor.Left  :=FInplaceEditor.Left+oLeft;
                  FInplaceEditor.Top   :=FInplaceEditor.Top+oTop;
                  FInplaceEditor.Width :=FInplaceEditor.Width+oRight;
                  FInplaceEditor.Height:=FInplaceEditor.Height+oBottom;
                end;
            end
          else
            if FResizeRegion.Parent is TprBand then
              begin
                DoResize(FResizeRegion,oTop,oLeft,oBottom,oRight,nil);
                //    
                Designer.CurPage.UpdateBandsPageRect; //   
                UpdateObjectsPDI;                     //     PDI
                UpdateSelectedInfo;
                ClipRgn:=CreateRectRgn(0,0,Width,Height);
              end;
        end;
      DrawSelectedObjects(Canvas.Handle);
      SelectionChanged;
      DrawLinks(Canvas.Handle);
    end;
  mmSelectedResize:
    begin
    end;
  mmSelectedRegionsDrag:
    begin
      dx:=X-FStartX;
      dy:=Y-FStartY;
      if (dx<>0) or (dy<>0) then
        begin
          for i:=0 to SelObjs.Count-1 do
            begin
              PDI:=SelPDI[i];
              if PDI.AllowDrag then
                begin
                  AddRectToRegion(ClipRgn,pdi.dPageRect);
                  DoDrag(PDI,dx,dy,nil);
                  AddRectToRegion(ClipRgn,pdi.dPageRect);
                end;
            end;
        end;

      DrawSelectedObjects(Canvas.Handle);
      SelectionChanged;
      DrawLinks(Canvas.Handle);
    end;
end;

if ClipRgn<>0 then
  begin
    InternalPaint(Canvas.Handle,ClipRgn);
    DeleteObject(ClipRgn);
  end;

if (FInplaceEditor=nil) and
   (Shift=[]) and
   (SelObjs.Count=1) and
   (FMouseMode in [mmSelect,mmRegionDrag,mmSelectedRegionsDrag]) then
  begin
    //    InplaceEditor
    if (FStartX=FLastX) and //
       (FStartY=FLastY) and //     
       (FDownRegion<>nil) and
       (FDownRegion.Parent is TprObj) and
       (TprObj(FDownRegion.Parent).AllowInplaceEdit) then
      begin
        //    
        if (FPrevObj<>nil) and
           (FPrevObj=FDownRegion.Parent) then
          begin
            //     
            Delta:=GetTickCount-FTickCount;
            if (Delta>700) and
               (Delta<1700) and
               (FDownPointInfo=piRegionInside) then
              begin
                // -    
                InplaceEditObj(FDownRegion);
              end
            else
              begin
                //   
                if Delta>1700 then
                  // ,  ,   
                  FTickCount:=GetTickCount;
              end;
          end
        else
          begin
            //    ( ),   
            FPrevObj  :=FDownRegion.Parent;
            FTickCount:=GetTickCount;
          end;
      end
    else
      begin
        FPrevObj:=nil;
      end;
  end;

FMouseMode:=mmNone;
end;

procedure TprCustomDPanel._MouseMove;
begin
FFirstMoveAfterDown := false;

if (FMouseMode<>mmRegionLink) and (Designer.UseGrid) and ((ssLeft in Shift) or (ssRight in shift)) then
  begin
    X := ATG(X,Designer.GridSizeX);
    Y := ATG(Y,Designer.GridSizeY);
  end;
DrawAnime(Canvas.Handle,X,Y,FLastX,FLastY);
FLastX :=X;
FLastY :=Y;

SetMouseCursorState(X,Y);
end;

procedure TprCustomDPanel.Delete;
begin
DeleteSelectedObjects;
end;

procedure TprCustomDPanel._BeginPaint;
begin
prps.ClipRgn := 0;
prps.ClipState := [];
DrawSelectedObjects(Canvas.Handle);
DrawLinks(Canvas.Handle);
end;

procedure TprCustomDPanel._EndPaint;
begin
if prcsBand in prps.ClipState then
  begin
    //    
    Designer.CurPage.UpdateBandsPageRect; //   
    UpdateObjectsPDI;                     //     PDI
    Repaint;
    UpdateSelectedInfo;
  end
else
  if prcsObj in prps.ClipState then
    begin
      if prps.ClipRgn<>0 then
        begin
          DrawSelectedObjects(Canvas.Handle);
          DrawLinks(Canvas.Handle);
          InternalPaint(Canvas.Handle,prps.ClipRgn);
          UpdateSelectedInfo;
        end;
    end;
if prps.ClipRgn<>0 then
  DeleteObject(prps.ClipRgn);
end;

procedure TprCustomDPanel.SelectedObjectsToClipboard;
var
  hMem : THandle;
  pMem : pointer;
  i : integer;
  ms : TMemoryStream;
  s : string;
  o : TprObj;
  w : TWriter;
begin
//    MemoryStream
ms    :=TMemoryStream.Create;
try
  w     :=TWriter.Create(ms,1024);
  w.Root:=nil;
  try
    for i:=0 to SelObjs.Count-1 do
      if SelPDI[i].Parent is TprObj then
        begin
          o     :=TprObj(SelPDI[i].Parent);
          s     :=o.Name;
          o.Name:='';
          try
            w.WriteSignature;
            w.WriteComponent(o);
          finally
            o.Name:=s;
          end;
        end;
    w.WriteListEnd;
  finally
    w.Free;
  end;

  //       
  ClipBoard.Open;
  try
    hMem:=GlobalAlloc(GMEM_MOVEABLE+GMEM_SHARE+GMEM_ZEROINIT,ms.Size);
    if hMem<>0 then
      begin
        pMem:=GlobalLock(hMem);
        if pMem<>nil then
          begin
            CopyMemory(pMem,ms.Memory,ms.Size);
            GlobalUnLock(hMem);
            ClipBoard.SetAsHandle(CF_PROBJ,hMem);
          end;
      end;
  finally
    ClipBoard.Close;
  end;
finally
  ms.Free;
end;
end;

procedure TprCustomDPanel.Copy;
begin
SelectedObjectsToClipboard;
end;

procedure TprCustomDPanel.Paste;
var
  r : TReader;
  ms : TMemoryStream;
  hMem : THandle;
  pMem : pointer;
  hSize : DWORD;
begin
if (SelObjs.Count=1) and (SelPDI[0].Parent is TprBand) then
  begin
    Clipboard.Open;
    try
      hMem := Clipboard.GetAsHandle(CF_PROBJ);
      pMem := GlobalLock(hMem);
      if pMem<>nil then
        begin
          hSize:=GlobalSize(hMem);
          ms   :=TMemoryStream.Create;
          r    :=TReader.Create(ms,1024);
          try
            ms.Write(pMem^,hSize);
            ms.Seek(soFromBeginning,0);

            r.OnSetName:=PasteSetName;
            _BeginPaint(FPastePRPS);
            r.ReadComponents(Report,TprBand(SelPDI[0].Parent),PasteCallback);
            DeselectObj(SelPDI[0]);
            _EndPaint(FPastePRPS);
            Report.TemplateChanged:=true;
          finally
            GlobalUnlock(hMem);
            r.Free;
            ms.Free;
          end;
        end;
    finally
      Clipboard.Close;
    end;
  end
else
  MBError(prLoadStr(sErrorClipboardPaste));
end;

procedure TprCustomDPanel.PasteSetName;
begin
Name := GetValidComponentName(Component);
end;

procedure TprCustomDPanel.PasteCallBack;
begin
with TprObj(Component) do
  begin
    dRec.pRect.Left := dRec.pRect.Left+1;
    dRec.pRect.Top := dRec.pRect.Top+1;
    dRec.pRect.Right := dRec.pRect.Right+1;
    dRec.pRect.Bottom := dRec.pRect.Bottom+1;
    AfterReportLoaded;
    UpdatePDI(GetExData);

    AddRectToRegion(FPastePRPS.ClipRgn,PDI.dPageRect);
    Include(FPastePRPS.ClipState,prcsObj);
  end;
SelectObj(TprObj(Component).pdi);
end;

procedure TprCustomDPanel.Cut;
begin
SelectedObjectsToClipboard;
DeleteSelectedObjects;
end;

procedure TprCustomDPanel.SendToBack;
var
  o : TprObj;
  i,j : integer;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to SelObjs.Count-1 do
  if SelPDI[i].Parent is TprObj then
    begin
      o:=TprObj(SelPDI[i].Parent);
      j:=o.Band.Objects.IndexOf(o);
      if j<>-1 then
        begin
          o.Band.Objects.Insert(0,o);
          o.Band.Objects.Delete(j+1);
        end;
      AddRectToRegion(prps.ClipRgn,o.pdi.dPageRect);
      Include(prps.ClipState,prcsObj);
    end;
_EndPaint(prps);
end;

procedure TprCustomDPanel.BringToFront;
var
  o : TprObj;
  i,j : integer;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to SelObjs.Count-1 do
  if SelPDI[i].Parent is TprObj then
    begin
      o := TprObj(SelPDI[i].Parent);
      j := o.Band.Objects.IndexOf(o);
      if j<>-1 then
        begin
          o.Band.Objects.Add(o);
          o.Band.Objects.Delete(j);
        end;
      AddRectToRegion(prps.ClipRgn,o.pdi.dPageRect);
      Include(prps.ClipState,prcsObj);
    end;
_EndPaint(prps);
end;

procedure TprCustomDPanel.Size;
var
  i : integer;
  PDI : pDesignInfo;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to SelObjs.Count-1 do
  begin
    PDI:=SelPDI[i];
    if ((sx=0) or
        (([ppRight,ppRightTop,ppRightBottom] * pdi.AllowResizeTypes)<>[])) and
       ((sy=0) or
        (([ppBottom,ppLeftBottom,ppRightBottom] * pdi.AllowResizeTypes)<>[])) and
       (pdi.dPageRect.Bottom-pdi.dPageRect.Top+sy>0) and
       (pdi.dPageRect.Right-pdi.dPageRect.Left+sx>0) then
      begin
        DoResize(pdi,0,0,sy,sx,@prps);
      end
  end;
_EndPaint(prps);
end;

procedure TprCustomDPanel.Nudge;
var
  i : integer;
  pdi : pDesignInfo;
  prps : rPrPaintStruct;
begin
dx:=Designer.ConvertXToDesignerCoords(dx);
dy:=Designer.ConvertYToDesignerCoords(dy);
_BeginPaint(prps);
for i:=0 to SelObjs.Count-1 do
  begin
    pdi:=SelPDI[i];
    if pdi.AllowDrag then
      DoDrag(pdi,dx,dy,@prps);
  end;
_EndPaint(prps);
end;

procedure TprCustomDPanel.SetPosSizeProp;
var
  i : integer;
  pdi : pDesignInfo;
  prps : rPrPaintStruct;
begin
_BeginPaint(prps);
for i:=0 to SelObjs.Count-1 do
  begin
    pdi:=SelPDI[i];

    if (Prop in [prpsaLeft,prpsaRight,prpsaTop,prpsaBottom]) and pdi.AllowDrag then
      begin
        // nudge
        case Prop of
          prpsaLeft  : DoDrag(pdi,Value-pdi.dPageRect.Left,0,@prps);
          prpsaTop   : DoDrag(pdi,0,Value-pdi.dPageRect.Top,@prps);
          prpsaRight : DoDrag(pdi,Value-pdi.dPageRect.Right,0,@prps);
          prpsaBottom: DoDrag(pdi,0,Value-pdi.dPageRect.Bottom,@prps);
        end;
      end
    else
      begin
        if (Prop in [prpsaWidth,prpsaHeight]) then
          begin
            // resize
            case Prop of
              prpsaWidth : DoResize(pdi,0,0,0,Value-pdi.dPageRect.Right+pdi.dPageRect.Left,@prps);
              prpsaHeight: DoResize(pdi,0,0,Value-pdi.dPageRect.Bottom+pdi.dPageRect.Top,0,@prps);
            end;
          end;
      end;
  end;
_EndPaint(prps);
Designer.UpdatePosSizeForm;
end;

procedure TprCustomDPanel.AlignAction;
var
  l : TList;
  r : TRect;
  pdi : pDesignInfo;
  prps : rPrPaintStruct;
  rg,rgLeft,rgRight,rgTop,rgBottom : pDesignInfo;
  oBottom,oRight,i,Width,Delta,Right,Left,Height,Bottom,Top,j,Min,iMin,Cur,Minw,Minh,Maxw,Maxh : integer;

  function GetLeft(o : TObject) : integer;
  begin
  Result:=pDesignInfo(o).dPageRect.Left;//+(r.Right-r.Left) div 2;
  end;

  function GetTop(o : TObject) : integer;
  begin
  Result:=pDesignInfo(o).dPageRect.Top;//+(r.Right-r.Left) div 2;
  end;

begin
_BeginPaint(prps);
case ActionCode of
  aacHToLeft:
    begin
      for i:=1 to SelObjs.Count-1 do
        if SelPDI[i].AllowDrag then
          DoDrag(SelPDI[i],
                 SelPDI[0].dPageRect.Left-SelPDI[i].dPageRect.Left,
                 0,
                 @prps);
    end;
  aacHToRight:
    begin
      for i:=1 to SelObjs.Count-1 do
        if SelPDI[i].AllowDrag then
          DoDrag(SelPDI[i],
                 SelPDI[0].dPageRect.Right-SelPDI[i].dPageRect.Right,
                 0,
                 @prps);
    end;
  aacVToTop:
    begin
      for i:=1 to SelObjs.Count-1 do
        if SelPDI[i].AllowDrag then
          DoDrag(SelPDI[i],
                 0,
                 SelPDI[0].dPageRect.Top-SelPDI[i].dPageRect.Top,
                 @prps);
    end;
  aacVToBottom:
    begin
      for i:=1 to SelObjs.Count-1 do
        if SelPDI[i].AllowDrag then
          DoDrag(SelPDI[i],
                 0,
                 SelPDI[0].dPageRect.Bottom-SelPDI[i].dPageRect.Bottom,
                 @prps);
    end;
  aacVCenters:
    begin
      for i:=1 to SelObjs.Count-1 do
        if SelPDI[i].AllowDrag then
          DoDrag(SelPDI[i],
                 (SelPDI[0].dPageRect.Left+
                  (SelPDI[0].dPageRect.Right-SelPDI[0].dPageRect.Left) div 2-
                  SelPDI[i].dPageRect.Left-
                  (SelPDI[i].dPageRect.Right-SelPDI[i].dPageRect.Left) div 2),
                 0,
                 @prps);
    end;
  aacHCenters:
    begin
      for i:=1 to SelObjs.Count-1 do
        if SelPDI[i].AllowDrag then
          DoDrag(SelPDI[i],
                 0,
                 (SelPDI[0].dPageRect.Top+
                  (SelPDI[0].dPageRect.Bottom-SelPDI[0].dPageRect.Top) div 2-
                  SelPDI[i].dPageRect.Top-
                  (SelPDI[i].dPageRect.Bottom-SelPDI[i].dPageRect.Top) div 2),
                 @prps);
    end;
  aacHCenterInWindow:
    begin
      for i:=0 to SelObjs.Count-1 do
        if (SelPDI[i].Parent is TprObj) and SelPDI[i].AllowDrag then
          begin
            Designer.ConvertToDesignerCoords(TprObj(SelPDI[i].Parent).Band.dPageRect,r);
            DoDrag(SelPDI[i],
                   (r.Right-r.Left-SelPDI[i].dPageRect.Right+SelPDI[i].dPageRect.Left) div 2-SelPDI[i].dPageRect.Left+r.Left,
                   0,
                   @prps);
          end;
    end;
  aacVCenterInWindow:
    begin
      for i:=0 to SelObjs.Count-1 do
        if (SelPDI[i].Parent is TprObj) and
           SelPDI[i].AllowDrag then
          begin
            Designer.ConvertToDesignerCoords(TprObj(SelPDI[i].Parent).Band.dPageRect,r);
            DoDrag(SelPDI[i],
                   0,
                   (r.Bottom-r.Top-SelPDI[i].dPageRect.Bottom+SelPDI[i].dPageRect.Top) div 2-SelPDI[i].dPageRect.Top+r.Top,
                   @prps);
          end;
    end;
  aacWToSmall:
    begin
      Minw:=SelPDI[0].dPageRect.Right-SelPDI[0].dPageRect.Left;

      for i:=1 to SelObjs.Count-1 do
        if Minw>SelPDI[i].dPageRect.Right-SelPDI[i].dPageRect.Left then
          Minw:=SelPDI[i].dPageRect.Right-SelPDI[i].dPageRect.Left;

      for i:=0 to SelObjs.Count-1 do
        DoResize(SelPDI[i],
                 0,
                 0,
                 0,
                 Minw-SelPDI[i].dPageRect.Right+SelPDI[i].dPageRect.Left,
                 @prps);
    end;
  aacWToLarge:
    begin
      Maxw:=SelPDI[0].dPageRect.Right-SelPDI[0].dPageRect.Left;

      for i:=1 to SelObjs.Count-1 do
        if Maxw<SelPDI[i].dPageRect.Right-SelPDI[i].dPageRect.Left then
          Maxw:=SelPDI[i].dPageRect.Right-SelPDI[i].dPageRect.Left;

      for i:=0 to SelObjs.Count-1 do
        DoResize(SelPDI[i],
                 0,
                 0,
                 0,
                 Maxw-SelPDI[i].dPageRect.Right+SelPDI[i].dPageRect.Left,
                 @prps);
    end;
  aacHToSmall:
    begin
      Minh:=SelPDI[0].dPageRect.Bottom-SelPDI[0].dPageRect.Top;

      for i:=1 to SelObjs.Count-1 do
        if Minh>SelPDI[i].dPageRect.Bottom-SelPDI[i].dPageRect.Top then
          Minh:=SelPDI[i].dPageRect.Bottom-SelPDI[i].dPageRect.Top;

      for i:=0 to SelObjs.Count-1 do
        DoResize(SelPDI[i],
                 0,
                 0,
                 Minh-SelPDI[i].dPageRect.Bottom+SelPDI[i].dPageRect.Top,
                 0,
                 @prps);
    end;
  aacHToLarge:
    begin
      Maxh:=SelPDI[0].dPageRect.Bottom-SelPDI[0].dPageRect.Top;

      for i:=1 to SelObjs.Count-1 do
        if Maxh<SelPDI[i].dPageRect.Bottom-SelPDI[i].dPageRect.Top then
          Maxh:=SelPDI[i].dPageRect.Bottom-SelPDI[i].dPageRect.Top;

      for i:=0 to SelObjs.Count-1 do
        DoResize(SelPDI[i],
                         0,
                         0,
                         Maxh-SelPDI[i].dPageRect.Bottom+SelPDI[i].dPageRect.Top,
                         0,
                         @prps);
    end;
  aacAlignToGridLeftTop:
    begin
      for i:=0 to SelObjs.Count-1 do
        begin
          pdi:=SelPDI[i];
          if pdi.AllowDrag then
            DoDrag(pdi,
                   (pdi.dPageRect.Left div Designer.GridSizeX)*Designer.GridSizeX-pdi.dPageRect.Left,
                   (pdi.dPageRect.Top div Designer.GridSizeY)*Designer.GridSizeY-pdi.dPageRect.Top,
                   @prps);
        end;
    end;
  aacAlignToGridAll:
    begin
      for i:=0 to SelObjs.Count-1 do
        begin
          pdi:=SelPDI[i];
          if pdi.AllowDrag then
            DoDrag(pdi,
                   (pdi.dPageRect.Left div Designer.GridSizeX)*Designer.GridSizeX-pdi.dPageRect.Left,
                   (pdi.dPageRect.Top div Designer.GridSizeY)*Designer.GridSizeY-pdi.dPageRect.Top,
                   @prps);

          if ((([ppRight,ppRightTop,ppRightBottom] * pdi.AllowResizeTypes)<>[]) or
              (([ppBottom,ppLeftBottom,ppRightBottom] * pdi.AllowResizeTypes)<>[])) then
            begin
              if ((pdi.dPageRect.Bottom-pdi.dPageRect.Top-1) mod Designer.GridSizeY)=0 then
                oBottom:=0
              else
                oBottom:=((pdi.dPageRect.Bottom-pdi.dPageRect.Top) div Designer.GridSizeY+1)*Designer.GridSizeY-(pdi.dPageRect.Bottom-pdi.dPageRect.Top)+1;
              if ((pdi.dPageRect.Right-pdi.dPageRect.Left-1) mod Designer.GridSizeX)=0 then
                oRight:=0
              else
                oRight:=((pdi.dPageRect.Right-pdi.dPageRect.Left) div Designer.GridSizeX+1)*Designer.GridSizeX-(pdi.dPageRect.Right-pdi.dPageRect.Left)+1;
              DoResize(pdi,
                       0,
                       0,
                       oBottom,
                       oRight,
                       @prps);
            end;
        end;
    end;
  aacHSpaceEqually:
    begin
      l:=TList.Create;
      try
        for i:=0 to SelObjs.Count-1 do
          if SelPDI[i].AllowDrag then
            l.Add(SelPDI[i]);

        for i:=0 to l.Count-1 do
          begin
            iMin:=i;
            Min :=GetLeft(l[i]);
            for j:=i+1 to l.Count-1 do
              begin
                Cur :=GetLeft(l[j]);
                if Cur<Min then
                  begin
                    iMin:=j;
                    Min :=Cur;
                  end;
              end;
            if iMin<>i then
              l.Exchange(i,iMin);
          end;
        rgLeft:=pDesignInfo(l[0]);
        Left  :=rgLeft.dPageRect.Left;

        //   Right
        Right  :=pDesignInfo(l[0]).dPageRect.Right;
        rgRight:=pDesignInfo(l[0]);
        for i:=1 to l.Count-1 do
          begin
            if Right<pDesignInfo(l[i]).dPageRect.Right then
              begin
                rgRight:=pDesignInfo(l[i]);
                Right  :=rgRight.dPageRect.Right;
              end;
          end;

        //    ""
        Width:=0;
        for i:=1 to l.Count-1 do
          if pDesignInfo(l[i]).dPageRect.Right<Right then
            Width:=Width+pDesignInfo(l[i]).dPageRect.Right-pDesignInfo(l[i]).dPageRect.Left;

        //     
        Delta:=(Right-Left-(rgLeft.dPageRect.Right-rgLeft.dPageRect.Left)-(rgRight.dPageRect.Right-rgRight.dPageRect.Left)-Width) div (l.Count-1);

        //     
        Left:=rgLeft.dPageRect.Right;
        for i:=1 to l.Count-1 do
          begin
            rg:=pDesignInfo(l[i]);
            if rg<>rgRight then
              begin
                DoDrag(rg,
                       Left+Delta-rg.dPageRect.Left,
                       0,
                       @prps);
                Left:=Left+Delta+rg.dPageRect.Right-rg.dPageRect.Left;
              end;
          end;
      finally
        l.Free;
      end;
    end;
  aacVSpaceEqually:
    begin
      l:=TList.Create;
      try
        for i:=0 to SelObjs.Count-1 do
          if SelPDI[i].AllowDrag then
            l.Add(SelPDI[i]);

        for i:=0 to l.Count-1 do
          begin
            iMin:=i;
            Min :=GetTop(l[i]);
            for j:=i+1 to l.Count-1 do
              begin
                Cur :=GetTop(l[j]);
                if Cur<Min then
                  begin
                    iMin:=j;
                    Min :=Cur;
                  end;
              end;
            if iMin<>i then
              l.Exchange(i,iMin);
          end;
        rgTop:=pDesignInfo(l[0]);
        Top  :=rgTop.dPageRect.Top;

        //   Bottom
        Bottom  :=pDesignInfo(l[0]).dPageRect.Bottom;
        rgBottom:=pDesignInfo(l[0]);
        for i:=1 to l.Count-1 do
          begin
            if Bottom<pDesignInfo(l[i]).dPageRect.Bottom then
              begin
                rgBottom:=pDesignInfo(l[i]);
                Bottom  :=rgBottom.dPageRect.Bottom;
              end;
          end;
      
        //    ""
        Height:=0;
        for i:=1 to l.Count-1 do
          if pDesignInfo(l[i]).dPageRect.Bottom<Bottom then
            Height:=Height+pDesignInfo(l[i]).dPageRect.Bottom-pDesignInfo(l[i]).dPageRect.Top;
      
        //     
        Delta:=(Bottom-Top-(rgTop.dPageRect.Bottom-rgTop.dPageRect.Top)-(rgBottom.dPageRect.Bottom-rgBottom.dPageRect.Top)-Height) div (l.Count-1);
      
        //     
        Top:=rgTop.dPageRect.Bottom;
        for i:=1 to l.Count-1 do
          begin
            rg:=pDesignInfo(l[i]);
            if rg<>rgBottom then
              begin
                DoDrag(rg,
                       0,
                       Top+Delta-rg.dPageRect.Top,
                       @prps);
                Top:=Top+Delta+rg.dPageRect.Bottom-rg.dPageRect.Top;
              end;
          end;
      finally
        l.Free;
      end;
    end;
end;
_EndPaint(prps);
end;

function TprCustomDPanel.AllowAlignToGridAll;
var
  i : integer;
begin
//          
i:=0;
while (i<SelObjs.Count) and (not SelPDI[i].AllowDrag) do Inc(i);
if i>=SelObjs.Count then
  begin
    i:=0;
    while (i<SelObjs.Count) and
          (([ppBottom,ppLeftBottom,ppRightBottom] * SelPDI[i].AllowResizeTypes)=[]) and
          (([ppRight,ppRightTop,ppRightBottom] * SelPDI[i].AllowResizeTypes)=[]) do Inc(i);
    Result:=i<SelObjs.Count;
  end
else
  Result:=true;
end;

function TprCustomDPanel.AllowSizeLeftRight;
var
  i : integer;
begin
i:=0;
while (i<SelObjs.Count) and
      (([ppRight,ppRightTop,ppRightBottom] * SelPDI[i].AllowResizeTypes)=[]) do Inc(i);
Result:=i<SelObjs.Count;
end;

function TprCustomDPanel.AllowSizeTopBottom;
var
  i : integer;
begin
i:=0;
while (i<SelObjs.Count) and
      (([ppBottom,ppLeftBottom,ppRightBottom] * SelPDI[i].AllowResizeTypes)=[]) do Inc(i);
Result:=i<SelObjs.Count;
end;

function TprCustomDPanel.AllowDelete;
begin
Result:=SelObjs.Count>0;
end;

function TprCustomDPanel.GetNumDragSelectedRegions;
var
  i : integer;
begin
Result:=0;
for i:=0 to SelObjs.Count-1 do
  if SelPDI[i].AllowDrag then
    Inc(Result);
end;

// true -     
function TprCustomDPanel.IsAnyTprObjSelected;
var
  i : integer;
begin
i:=0;
while (i<SelObjs.Count) and not (SelPDI[i].Parent is TprObj) do Inc(i);
Result:=i<SelObjs.Count;
end;

function TprCustomDPanel.AllowCopy;
begin
Result:=IsAnyTprObjSelected;
end;

function TprCustomDPanel.AllowCut;
begin
Result:=IsAnyTprObjSelected;
end;

function TprCustomDPanel.AllowPaste;
begin
Result:=Clipboard.HasFormat(CF_PROBJ);
end;

///////////////////////////////
//
// TprCustomDesignerForm
//
///////////////////////////////
constructor TprCustomDesignerForm.CreateDesigner;
begin
inherited;

InitInternalPropsForms;
end;

procedure TprCustomDesignerForm.BeforeDestruction;
begin
{$IFDEF DEBUG}
WriteToLog('TprCustomDesignerForm.BeforeDestruction');
{$ENDIF}
Finalize(prInternalPropsForms);
inherited;
end;

function TprCustomDesignerForm.GetSelObjs;
begin
Result:=FDPanel.SelObjs;
end;

function TprCustomDesignerForm.GetSelPDI;
begin
Result:=FDPanel.SelPDI[i];
end;

function TprCustomDesignerForm.GetSelCount;
begin
Result:=FDPanel.SelCount;
end;

procedure TprCustomDesignerForm.InitInternalPropsForms;
begin
SetLength(prInternalPropsForms,0);
end;

procedure TprCustomDesignerForm.SetFileName;
begin
FFileName:=Value;
Caption  :=Format(prLoadStr(sDesignerCaption),[FFileName]);
end;

procedure TprCustomDesignerForm.UpdatePropsForm;
begin
TprObjectsPropsForm(ObjectsPropsForm).DesignerSelectionChanged;
end;

procedure TprCustomDesignerForm.UpdateLinksForms;
begin
if SelObjs.Count=1 then
  begin
    if TObject(SelObjs[0]) is TprObj then
      begin
        ObjLinksForm.UpdateObjLinksInfo(TprObj(SelObjs[0]));
        BandLinksForm.UpdateObjLinksInfo(nil);
      end
    else
      if TObject(SelObjs[0]) is TprBand then
        begin
          BandLinksForm.UpdateObjLinksInfo(TprBand(SelObjs[0]));
          ObjLinksForm.UpdateObjLinksInfo(nil);
        end
      else
        begin
          BandLinksForm.UpdateObjLinksInfo(nil);
          ObjLinksForm.UpdateObjLinksInfo(nil);
        end;
  end
else
  begin
    BandLinksForm.UpdateObjLinksInfo(nil);
    ObjLinksForm.UpdateObjLinksInfo(nil);
  end;
end;

procedure TprCustomDesignerForm.UpdatePosSizeForm;
begin
PosSizeForm.DesignerSelectionChanged;
end;

procedure TprCustomDesignerForm.SelectionChanged;
begin
UpdateLinksForms;
UpdatePropsForm;
UpdatePosSizeForm;
UpdateTextActions;
end;

procedure TprCustomDesignerForm.AfterConstruction;
begin
FileName                   :='';

SBox                       :=TprScrollBox.Create(Self);
SBox.Align                 :=alClient;
SBox.Parent                :=Self;
SBox.HorzScrollBar.Tracking:=true;
SBox.VertScrollBar.Tracking:=true;

FDPanel          :=CreateDPanel;
FDPanel.Parent   :=SBox;
FDPanel.Top      :=0;
FDPanel.Left     :=0;

FDPanel.UpdateObjectsPDI;

if Report.PagesCount=0 then
  with CreatePage do
    Report:=Self.Report;

IndexCurPage:=0;

ObjLinksForm    :=TprObjLinksForm.Create(Self);
BandLinksForm   :=TprBandLinksForm.Create(Self);
ObjectsPropsForm:=TprObjectsPropsForm.Create(Self);
ObjLinksForm.UpdateObjLinksInfo(nil);
BandLinksForm.UpdateObjLinksInfo(nil);

inherited;
end;

procedure TprCustomDesignerForm.ShowPage;
begin
Report.Pages[IndexCurPage].UpdateBandsPageRect;
FDPanel.UpdateObjectsPDI; 
FDPanel.UpdateSelectedInfo;
FDPanel.Repaint;
UpdateStatusBar;
UpdateTextActions;
end;

procedure TprCustomDesignerForm.UpdateCurrentPage;
begin
ShowPage(IndexCurPage);
end;

procedure TprCustomDesignerForm.UpdateStatusBar;
begin
end;

procedure TprCustomDesignerForm.DrawLinks;
begin
FDPanel.DrawLinks(FDPanel.Canvas.Handle);
end;

procedure TprCustomDesignerForm.OnObjInserted;
begin
end;

procedure TprCustomDesignerForm.OnInsertBandClick;
var
  b : TprBand;
  p : TprCustomPage;
  bc : TprBandClass;
begin
//  
bc :=Report.GetBandClass(TprBandType(TMenuItem(Sender).Tag));
if bc<>nil then
  begin
    p:=CurPage;
    b:=bc.Create(Report.prOwner);
    try
      if b.BandType in HorizontalBands then
        TprCustomHBand(b).Height:=ConvertYFromDesignerCoords(40)
      else
        if b.BandType in VerticalBands then
          TprCustomVBand(b).Width:=ConvertXFromDesignerCoords(40);
      b.OnInsertIntoPage(p);
      b.Page:=p;
      b.UpdatePDI(FDPanel.GetExData);
      ShowPage(IndexCurPage);
      Report.TemplateChanged:=true;
    except
      on e : exception do
        begin
          b.Free;
          MBError(e.Message);
        end;
    end;
  end;
end;

procedure TprCustomDesignerForm.OnObjButtonClick(Sender: TObject);
var
  Tag : integer;
begin
(Sender as TToolButton).Down:=true;
Tag:=(Sender as TToolButton).Tag;
if Tag=-1 then
  begin
    //
    FCurClassRef:=nil;
  end
else
  begin
    //  
    FCurClassRef:=prObjRegInfos[Tag].ClassRef;
  end;
end;

procedure TprCustomDesignerForm.Save;
var
  fn : string;
begin
if FileName='' then
  SaveAs
else
  begin
    fn:=FileName;
    if Assigned(Report.OnDesignerSave) then
      begin
        Report.OnDesignerSave(Report,fn,false);
        FileName:=fn;
      end;
    Report.SaveTemplateToFile(FileName,false);
  end;
end;

procedure TprCustomDesignerForm.SaveAs;
var
  fn : string;
  sd : TSaveDialog;
begin
sd:=TSaveDialog.Create(Self);
try
  sd.Filter    :=prLoadStr(prSaveReportTemplateFilter);
  sd.DefaultExt:='prt';
  sd.FileName  :=FileName;
  sd.Options   :=[ofHideReadOnly,ofPathMustExist,ofEnableSizing];
  if sd.Execute then
    begin
      fn:=sd.FileName;
      if Assigned(Report.OnDesignerSave) then
        Report.OnDesignerSave(Report,fn,true);
      FileName:=fn;
      Report.SaveTemplateToFile(FileName,false);
    end;
finally
  sd.Free;
end;
end;

procedure TprCustomDesignerForm.Open;
var
  od : TOpenDialog;
begin
od:=TOpenDialog.Create(Self);
try
  od.Filter := prLoadStr(prSaveReportTemplateFilter);
  od.DefaultExt := 'prt';
  od.FileName := FileName;
  od.Options := [ofHideReadOnly,ofPathMustExist,ofFileMustExist,ofEnableSizing];
  if od.Execute then
    begin
      FDisablePageDraw := true;

      FDPanel.ClearSelected;
      FDPanel.SelectionChanged;
      Report.LoadTemplateFromFile(od.FileName,false);
      FDPanel.UpdateObjectsPDI;

      FileName := od.FileName;
      IndexCurPage := 0;
      FDisablePageDraw := false;
  
      ShowPage(IndexCurPage);
    end;
finally
  od.Free;
end;
end;

procedure TprCustomDesignerForm.New;
begin
FDisablePageDraw:=true;

FDPanel.ClearSelected;
FDPanel.SelectionChanged;
Report.ClearTemplate;
with CreatePage do
  Report:=Self.Report;

FileName        :='';
IndexCurPage    :=0;
FDisablePageDraw:=false;

ShowPage(IndexCurPage);
end;

procedure TprCustomDesignerForm.Print;
begin
if Report.PrepareReport then
  if Report.SetupPrintParams then
    Report.PrintPreparedReport;
end;

procedure TprCustomDesignerForm.Preview;
begin
if Report.PrepareReport then
  Report.PreviewPreparedReport(true);
end;

procedure TprCustomDesignerForm.NewPage;
begin
with CreatePage do
  Report:=TprCustomReport(Self.Report);

IndexCurPage:=Report.PagesCount-1;
ShowPage(IndexCurPage);
end;

procedure TprCustomDesignerForm.DelPage;
begin
if MBox(prLoadStr(sDeletePageQuestion),prLoadStr(sAttention),MB_YESNO+MB_ICONEXCLAMATION) =IDYES then
  begin
    FDisablePageDraw:=true;

    Report.Pages[IndexCurPage].Free;

    if IndexCurPage>=Report.PagesCount then
      IndexCurPage:=Report.PagesCount-1;

    FDisablePageDraw:=false;
    ShowPage(IndexCurPage);
  end;
end;

procedure TprCustomDesignerForm.NextPage;
begin
Inc(IndexCurPage);
FDPanel.ClearSelected;
ShowPage(IndexCurPage);
end;

procedure TprCustomDesignerForm.PriorPage;
begin
Dec(IndexCurPage);
FDPanel.ClearSelected;
ShowPage(IndexCurPage);
end;

function TprCustomDesignerForm.CurPage;
begin
Result:=Report.Pages[IndexCurPage];
end;

procedure TprCustomDesignerForm.KeyDown;
begin
if ActiveControl=FDPanel.FInplaceEditor then
  begin
    if (Shift=[]) and (Key=VK_ESCAPE) then
      begin
        FDPanel.SaveInplaceEdit;
        Key:=0;
      end;
  end;
inherited;
end;

end.

