{******************************************}
{                                          }
{                 PReport v1.6             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_Common;

interface

{$I PR.INC}

uses
  SysUtils, Windows, Classes, Graphics, WinSpool, DB,
  Dialogs, typinfo, Math, Forms, IniFiles, Messages, Controls,
  stdctrls, CommDlg, ComCtrls, ActnList, {$ifdef PR_D6} Variants, {$endif}

  pr_Progress, pr_MultiLang, pr_Dataset, pr_Utils;

{$R prStrings.res}
{$R prDialogs.res}
{$R preport.res}

const
  AngleSize = 5;
  _sPrIniFileName = 'pr.ini';
  sDefaultObjResName = 'TprDefaultObjResName';
  MAX_PAGEHEADERSFOOTERS = 3;
  MAX_PAGEBANDSORDER = 8;
  MAX_PAGEBANDSORDERVERT = 8;
  sPReportVersion = '1.60.2';

type
TprGenCell = class;
TprGenVector = class;
TprGenGrid = class;
TprBand = class;
TprBands = class;
TprObj = class;
TprValue = class;
TprObjClass = class of TprObj;
TprObjRecClass = class of TprObjRec;
TprObjVersionClass = class of TprObjRecVersion;
TprGroup = class;
TprGroups = class;
TprBandClass = class of TprBand;
TprCustomEndPage = class;
TprCustomPage = class;
TprCustomReport = class;
TprDesigner = class;
TprDesignerClass = class of TprDesigner;
TprPreview = class;
TprPreviewClass = class of TprPreview;
TprCustomReportClass = class of TprCustomReport;

TprIntegerArray = array [0..16383] of integer;
PprIntegerArray = ^TprIntegerArray;

TprPrinterOrientation = (poPortrait, poLandscape);
TprHAlign = (prhLeft,prhCenter,prhRight);
TprVAlign = (prvTop,prvCenter,prvBottom);
TprCommonAlign = (praToMin,praCenter,praToMax);

TprColDirectionType = (prcdTopBottomLeftRight,prcdLeftRightTopBottom);
/////////////////////////////
//
// Value if var, used in parser
//
/////////////////////////////
TprVarValueType = (prvvtBoolean,prvvtInteger,prvvtDateTime,prvvtString,prvvtDouble,prvvtObject,prvvtNull,prvvtNotCalced);
(*$NODEFINE TprVarValueType*)
(*$HPPEMIT 'namespace Pr_common'*)
(*$HPPEMIT '{'*)

(*$HPPEMIT '#pragma option push -b-'*)
(*$HPPEMIT 'enum TprVarValueType { prvvtBoolean, prvvtInteger, prvvtDateTime, prvvtString, prvvtDouble, prvvtObject,'*)
(*$HPPEMIT '	prvvtNull, prvvtNotCalced };'*)
(*$HPPEMIT '#pragma option pop'*)

TprVarValue = record
  vType : TprVarValueType;
  vString : string;
  case TprVarValueType of
    prvvtBoolean : (vBoolean : boolean);
    prvvtInteger : (vInteger : integer);
    prvvtDateTime : (vDateTime : TDateTime);
    prvvtDouble : (vDouble : double);
    prvvtObject : (vObject : TObject);
end;
(*$NODEFINE TprVarValue*)
(*$HPPEMIT 'struct TprVarValue'*)
(*$HPPEMIT '{'*)
(*$HPPEMIT '	TprVarValueType vType;'*)
(*$HPPEMIT '	AnsiString vString;'*)
(*$HPPEMIT '	union'*)
(*$HPPEMIT '	{'*)
(*$HPPEMIT '		struct a'*)
(*$HPPEMIT '		{'*)
(*$HPPEMIT '			System::TObject* vObject;'*)
(*$HPPEMIT '		};'*)
(*$HPPEMIT '		struct b'*)
(*$HPPEMIT '		{'*)
(*$HPPEMIT '			double vDouble;'*)
(*$HPPEMIT '		};'*)
(*$HPPEMIT '		struct c'*)
(*$HPPEMIT '		{'*)
(*$HPPEMIT '			System::TDateTime vDateTime;'*)
(*$HPPEMIT '		};'*)
(*$HPPEMIT '		struct d'*)
(*$HPPEMIT '		{'*)
(*$HPPEMIT '			int vInteger;'*)
(*$HPPEMIT '		};'*)
(*$HPPEMIT '		struct e'*)
(*$HPPEMIT '		{'*)
(*$HPPEMIT '			bool vBoolean;'*)
(*$HPPEMIT '		};'*)
(*$HPPEMIT '	};'*)
(*$HPPEMIT '} ;'*)

PprVarValue  = ^TprVarValue;
TprVarsArray = array of TprVarValue;

///////////////////////
//
// TprScrollBox
//
///////////////////////
TOnScroll = procedure (Sender : TObject; Msg : TWMScroll) of object;
TprScrollBox = class(TScrollBox)
private
  FOnVScroll : TOnScroll;
  FOnHScroll : TOnScroll;

  procedure mWM_VSCROLL(var Msg : TWMScroll); message WM_VSCROLL;
  procedure mWM_HSCROLL(var Msg : TWMScroll); message WM_HSCROLL;
public
  property OnVScroll : TOnScroll read FOnVScroll write FOnVScroll;
  property OnHScroll : TOnScroll read FOnHScroll write FOnHScroll;
end;

/////////////////////////////////////////////////
//
// Base form class, for all forms
// in PReport
//
/////////////////////////////////////////////////
TprForm = class(TForm)
protected
  procedure prRestoreProperties(Ini : TIniFile; sn : string); virtual;
  procedure prSaveProperties(Ini : TIniFile; sn : string); virtual;
public
  procedure AfterConstruction; override;
  procedure BeforeDestruction; override;
end;

TprSelectedMode = (smNone,smOne,smMult);
TprMouseMode = (mmNone,mmSelect,mmRegionDrag,mmRegionResize,mmRegionLink,mmSelectedResize,mmSelectedRegionsDrag,mmInsertObj);
/////////////////////////////////////////////////
//
// Designer form class, for all report designers
//
/////////////////////////////////////////////////
TprDesigner = class(TprForm)
private
protected
  procedure Loaded; override;
public
  Report : TprCustomReport;

  procedure CreateWnd; override;

  procedure UpdateCurrentPage; virtual; abstract;

  procedure ConvertToDesignerCoords(const rSource : TRect; var rDest : TRect); virtual;
  function  ConvertXToDesignerCoords(X : integer) : integer; virtual;
  function  ConvertYToDesignerCoords(Y : integer) : integer; virtual;
  procedure ConvertFromDesignerCoords(const rSource : TRect; var rDest : TRect); virtual;
  function  ConvertXFromDesignerCoords(X : integer) : integer; virtual;
  function  ConvertYFromDesignerCoords(Y : integer) : integer; virtual;

  procedure   BeforeDestruction; override;
  constructor CreateDesigner(AOwner : TComponent; _Report : TprCustomReport); virtual;
end;

/////////////////////////////////////////////////
//
// Base preview form class, for all reports
// preview forms
//
/////////////////////////////////////////////////
TprPreview  = class(TprForm)
protected
  procedure Loaded; override;
public
  Report : TprCustomReport;

  procedure DoOnCustomAction;
  
  procedure CreateWnd; override;

  procedure   BeforeDestruction; override;
  constructor CreatePreview(AOwner : TComponent; _Report : TprCustomReport); virtual;
end;

TprPointInfo    = (piNone,piRegionInside,piRegionResize,piRegionLink,piSelectedResize);
TprResizeType    = (ppLeftTop,ppTop,ppRightTop,ppRight,ppRightBottom,ppBottom,ppLeftBottom,ppLeft);
TprResizeTypeSet = set of TprResizeType;
TprLinkType      = (ltLeft,ltTop,ltRight,ltBottom);
TprLinkTypeSet   = set of TprLinkType;

/////////////////////////////////////////////////
//
// rDesignInfo
//
/////////////////////////////////////////////////
rDesignInfo = record
  dPageRect         : TRect; // object coords in designer,
                             // from left top corner of page
                             // in designer units,
                             // for example in text reports, its coords:
                             //  x - 0 .. ColumnCountOnPage*SymbolWidth
                             //  y - 0 .. RowCountOnPage*SymbolHeight

  AllowResizeTypes  : TprResizeTypeSet; // supported resize types

  AllowDrag         : boolean;          // can be dragged

  AllowLinkTypes    : TprLinkTypeSet;   // how its can be linked to other pbjects

  Parent            : TObject;           
end;
pDesignInfo = ^rDesignInfo;

/////////////////////////////////////////////////
//
// TprPreviewUserData
//
/////////////////////////////////////////////////
TprPreviewUserData = class(TPersistent)
public
  Tag : integer;
  procedure Assign(Source : TPersistent); override;
  procedure SaveToStream(Stream : TStream); virtual;
  procedure LoadFromStream(Stream : TStream); virtual;
end;

/////////////////////
//
// TprObjRecVersion
//
/////////////////////
TprObjRecVersion = class(TCollectionItem)
private
  FFormula : string;
  FVisible : boolean;
  FCompiledFormula : string;
  FMayBeUse : boolean;
  FSecondPassCalcCurVersionNeeded : boolean;
public
  procedure Assign(Source : TPersistent); override;
  constructor Create(Collection : TCollection); override;
published
  property Formula : string read FFormula write FFormula;
  property Visible : boolean read FVisible write FVisible;
end;

/////////////////////
//
// TprObjRecVersions
//
/////////////////////
TprObjRecVersions = class(TCollection)
private
  function GetItm(i : integer) : TprObjRecVersion;
public
  property Items[i : integer] : TprObjRecVersion read GetItm; default;
end;

/////////////////////
//
// TprObjRec
//
/////////////////////
TprObjRec = class(TPersistent)
private
  FVersions : TprObjRecVersions;
  FDefVersion : integer;           // default version
  FSecondPassCalcCurVersionNeeded : boolean;
  FWidthAsVerticalBand : boolean;
  FHeightAsHorizontalBand : boolean;
  function GetLeft : integer;
  function GetTop : integer;
  function GetRight : integer;
  function GetBottom : integer;
  procedure SetLeft(Value : integer);
  procedure SetTop(Value : integer);
  procedure SetRight(Value : integer);
  procedure SetBottom(Value : integer);
protected
  function CreateVersions : TprObjRecVersions; virtual; abstract;
public
  Obj : TprObj;              // object
  Page : TprCustomEndPage;
  pRect : TRect;              
  X,Y,DX,DY : integer;             // calced on  FirstPass
  CurVersion : integer;            // version selected in report generate
  PreviewUserData : TprPreviewUserData;

  procedure FirstPassCalcCurVersion; virtual;

  procedure SecondPass; virtual;

  procedure PlaceOnEndPage(Device : TObject; r : TRect); virtual; abstract;

  procedure Assign(Source : TPersistent); override;
  function  CreateCopy : TprObjRec; virtual; abstract;

  procedure Save(Stream : TStream); virtual;
  procedure Load(Stream : TStream); virtual;

  constructor Create(_Page : TprCustomEndPage; _Obj : TprObj); virtual;
  destructor Destroy; override;
published
  property DefVersion : integer read FDefVersion write FDefVersion;
  property Versions : TprObjRecVersions read FVersions write FVersions;
  property Left : integer read GetLeft write SetLeft;
  property Top : integer read GetTop write SetTop;
  property Right : integer read GetRight write SetRight;
  property Bottom : integer read GetBottom write SetBottom;
  property WidthAsVerticalBand : boolean read FWidthAsVerticalBand write FWidthAsVerticalBand default false;
  property HeightAsHorizontalBand : boolean read FHeightAsHorizontalBand write FHeightAsHorizontalBand default false;
end;

/////////////////////
//
// TprObjs
//
/////////////////////
TprObjs = class(TList)
private
  function GetItm(index : integer) : TprObj;
public
  property Items[index : integer] : TprObj read GetItm; default;
end;

/////////////////////
//
// TprObj
//
/////////////////////
TprVLinkMode    = (prlmMaxBottom,prlmMinBottom);
TprHLinkMode    = (prlmMaxRight,prlmMinRight);
TprVResizeMode  = (prrmMaxBottom, prrmMinBottom);
TprHResizeMode  = (prrmMaxRight, prrmMinRight);
TprLinkMode     = (prlLeft,prlTop,prlWidth,prlHeight);

TprObj = class(TComponent)
private
  FBand : TprBand;

  FirstPassProcessed : boolean;

  FVisible : boolean;

  FTopMode : TprVLinkMode;
  FLeftMode : TprHLinkMode;
  FWidthMode : TprHResizeMode;
  FHeightMode : TprVResizeMode;

  FTopObjsNames : TStrings; //     (ReadLinks)    UpdateReadedLinks
  FLeftObjsNames : TStrings;
  FWidthObjsNames : TStrings;
  FHeightObjsNames : TStrings;

  procedure SetBand(Value : TprBand);
  function  GetReport : TprCustomReport;
  function  IsLinkedTo(LinkMode : TprLinkMode; Obj : TprObj) : boolean;
protected
  FdRec : TprObjRec;

  procedure InitdRec; virtual; abstract;

  procedure ReadLeft(Reader : TReader);
  procedure WriteLeft(Writer : TWriter);
  procedure ReadTop(Reader : TReader);
  procedure WriteTop(Writer : TWriter);
  procedure ReadWidth(Reader : TReader);
  procedure WriteWidth(Writer : TWriter);
  procedure ReadHeight(Reader : TReader);
  procedure WriteHeight(Writer : TWriter);

  procedure DefineProperties(Filer : TFiler); override;

  procedure UpdatePDIdPageRect; virtual;

  procedure SetParentComponent(Value : TComponent); override;
  function  GetChildOwner : TComponent; override;

  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  aRec       : TprObjRec;     // ,     ,   FistPass
  PDI        : pDesignInfo;   //  

  TopObjs    : TprObjs;
  LeftObjs   : TprObjs;
  WidthObjs  : TprObjs;
  HeightObjs : TprObjs;

  property Band   : TprBand read FBand write SetBand;
  property Report : TprCustomReport read GetReport;
  //  ,  
  function  GetDesc : string; virtual;
  //     ,    r
  procedure DrawDesign(DC : HDC; ExData : pointer); virtual;
  //    
  procedure UpdatePDI(ExData : pointer); virtual;
  //     
  procedure FirstPass; virtual;

  //        Resize,
  //    Drag   ,
  //    ,     ,
  //    
  procedure DesignerResize(oTop,oLeft,oBottom,oRight : integer; ExData : pointer); virtual;
  procedure DesignerDrag(dx,dy : integer; ExData : pointer); virtual;
  procedure DesignerLink(Linked : pDesignInfo; LinkMode : TprLinkType; var LinkAccepted : boolean; ExData : pointer); virtual;
  procedure DesignerDelete; virtual;

  function  AllowInplaceEdit : boolean; virtual;
  procedure InplaceEdit(_Parent : TWinControl; var InplaceEditor : TWinControl); virtual;
  procedure SaveInplaceEdit(InplaceEditor : TWinControl); virtual;

  procedure AfterReportLoaded; virtual;

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;

  function  HasParent : boolean; override;
  function  GetParentComponent : TComponent; override;
published
  property dRec : TprObjRec read FdRec write FdRec;

  property TopMode : TprVLinkMode read FTopMode write FTopMode;
  property LeftMode : TprHLinkMode read FLeftMode write FLeftMode;
  property WidthMode : TprHResizeMode read FWidthMode write FWidthMode;
  property HeightMode : TprVResizeMode read FHeightMode write FHeightMode;

  property Visible : boolean read FVisible write FVisible;
end;





TprBandType = (bthTitle,
               bthSummary,
               bthPageHeader,
               bthPageFooter,
               bthDetail,
               bthDetailHeader,
               bthDetailFooter,
               bthGroupHeader,
               bthGroupFooter,
               btvTitle,
               btvSummary,
               btvPageHeader,
               btvPageFooter,
               btvDetail,
               btvDetailHeader,
               btvDetailFooter,
               btvGroupHeader,
               btvGroupFooter);
TprBandTypeArray = array of TprBandType;
TOnGetRegions = procedure (L,SelList : TList) of object;
TGenerateCellCallbackProc = procedure(Sender : TprBand; Cell : TprGenCell; Objects : TprObjs) of object;
////////////////////////
//
// TprBand
//
////////////////////////
TprBandResizeMode = (prbrmNone,prbrmMaxObj,prbrmMaxResizeObj,prbrmMinResizeObj);
TprBandLinkType = (prltAfter,prltBefore);

TprBand = class(TComponent)
private
  FPage            : TprCustomPage;

  FResizeObjsNames : TStrings;

  FResizeMode      : TprBandResizeMode;
  FVisible         : boolean;

  procedure SetPage(Value : TprCustomPage);
protected
  procedure GroupRemoved(Group : TprGroup); virtual;
  procedure GroupAdded(Group : TprGroup); virtual;

  procedure GetChildren(Proc : TGetChildProc; Root : TComponent); override;
  procedure SetParentComponent(Value : TComponent); override;
  procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  function  GetChildOwner : TComponent; override;

  procedure ReadResizeObjs(Reader : TReader);
  procedure WriteResizeObjs(Writer : TWriter);
  procedure DefineProperties(Filer : TFiler); override;
public
  FCalced      : boolean;

  BandType     : TprBandType;        // type of Band

  ResizeObjs   : TprObjs;

  dPageRect    : TRect;              // band coords, from top left of page

  PDI          : pDesignInfo;        // used in designer

  Objects      : TprObjs;

  property  Page   : TprCustomPage read FPage write SetPage;

  function  Report : TprCustomReport;

  function  GetFullBandName : string;

  function  GenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc; fSimpleCreateCell : boolean) : TprGenCell; virtual; abstract;

  function  GetStartNewPage : boolean; virtual;
  function  GetLinkToBand : TprBand; virtual;
  function  GetLinkType : TprBandLinkType; virtual;

  procedure InitDataSet; virtual;

  procedure CalcdPageRect(var CurPageRect : TRect; ExData : pointer); virtual; abstract;
  procedure UpdatePDI(ExData : pointer); virtual;
  procedure OnInsertIntoPage(p : TprCustomPage); virtual;

  procedure DesignerDelete; virtual;
  procedure DesignerResize(oTop,oLeft,oBottom,oRight : integer); virtual;
  procedure DesignerLink(Linked : pDesignInfo; LinkMode : TprLinkType; var LinkAccepted : boolean); virtual;

  procedure DrawDesign(DC : HDC; ExData : pointer); virtual; abstract;
  function  GetDrawDesignCaption : string; virtual;

  procedure AfterReportLoaded; virtual;

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;

  function  HasParent : boolean; override;
  function  GetParentComponent : TComponent; override;
published
  property ResizeMode : TprBandResizeMode read FResizeMode write FResizeMode;
  property Visible : boolean read FVisible write FVisible;
end;

////////////////////////
//
// TprCustomHBand
//
////////////////////////
TprCustomHBand = class(TprBand)
protected
  FHeight           : integer;
  FUseVerticalBands : boolean;
public
  procedure CalcdPageRect(var CurPageRect : TRect; ExData : pointer); override;

  //  
  function  GetUseColumns   : boolean; virtual;
  function  GetColCount     : integer; virtual;
  function  GetColDirection : TprColDirectionType; virtual;
  function  GenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc; fSimpleCreateCell : boolean) : TprGenCell; override;
  procedure GenerateCellCallback(Sender : TprBand; Cell : TprGenCell; Objects : TprObjs);

  //  
  procedure DesignerResize(oTop,oLeft,oBottom,oRight : integer); override;
  procedure DesignerLink(Linked : pDesignInfo; LinkMode : TprLinkType; var LinkAccepted : boolean); override;

  constructor Create(AOwner : TComponent); override;
published
  property Height           : integer read FHeight write FHeight;
  property UseVerticalBands : boolean read FUseVerticalBands write FUseVerticalBands;
end;

////////////////////////
//
// TprCustomHTitleBand
//
////////////////////////
TprCustomHTitleBand = class(TprCustomHBand)
end;

//////////////////////////////
//
// TprCustomHSummaryBand
//
//////////////////////////////
TprCustomHSummaryBand = class(TprCustomHBand)
private
  FPrintWithBand : TprCustomHBand;
public
  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  constructor Create(AOwner : TComponent); override;
published
  property PrintWithBand : TprCustomHBand read FPrintWithBand write FPrintWithBand;
end;

/////////////////////////
//
// TprCustomHPageHeaderBand
//
/////////////////////////
TprCustomHPageHeaderBand = class(TprCustomHBand)
private
  FPrintOnFirstPage : boolean;
published
  property PrintOnFirstPage : boolean read FPrintOnFirstPage write FPrintOnFirstPage;
end;

/////////////////////////
//
// TprCustomHPageFooterBand
//
/////////////////////////
TprCustomHPageFooterBand = class(TprCustomHBand)
private
  FPrintOnFirstPage : boolean;
  FPrintAfterLastBandOnPage : boolean;
public
  procedure CalcdPageRect(var CurPageRect : TRect; ExData : pointer); override;
published
  property PrintOnFirstPage : boolean read FPrintOnFirstPage write FPrintOnFirstPage;
  property PrintAfterLastBandOnPage : boolean read FPrintAfterLastBandOnPage write FPrintAfterLastBandOnPage;
end;

///////////////////////////////////
//
// TprCustomHDetailBand
//
///////////////////////////////////
TprCustomHDetailBand = class(TprCustomHBand)
private
  FParentDetail : TprCustomHDetailBand;
  FDataSetName : string;
  FColCount : integer;
  FColDirection : TprColDirectionType;
  FValid : string;
  FGroupsNames : TStrings; // list of groups linked to this band
  FBandsNames : TStrings;

  procedure SetParentDetail(Value : TprCustomHDetailBand);
protected
  procedure GroupRemoved(Group : TprGroup); override;
  procedure GroupAdded(Group : TprGroup); override;

  procedure ReadGroups(Reader : TReader);
  procedure WriteGroups(Writer : TWriter);
  procedure ReadBands(Reader : TReader);
  procedure WriteBands(Writer : TWriter);
  procedure DefineProperties(Filer : TFiler); override;

  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  DataSet : TprDatasetLink; // initializated in prepare report
  Groups : TprGroups;
  Bands : TprBands; // list of bands, depended from this band (Header, Footer, Child detail bands)

  procedure CalcdPageRect(var CurPageRect : TRect; ExData : pointer); override;

  // generate report
  function GenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc; fSimpleCreateCell : boolean) : TprGenCell; override;
  function GetUseColumns : boolean; override;
  function GetColCount : integer; override;
  function GetColDirection : TprColDirectionType; override;
  procedure InitDataSet; override;

  // for designer
  procedure OnInsertIntoPage(p : TprCustomPage); override;
  function  GetDrawDesignCaption : string; override;

  procedure AfterReportLoaded; override;

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;
published
  property DataSetName : string read FDataSetName write FDataSetName;
  property ColCount : integer read FColCount write FColCount;
  property ColDirection : TprColDirectionType read FColDirection write FColDirection;
  property ParentDetail : TprCustomHDetailBand read FParentDetail write SetParentDetail;
  property Valid : string read FValid write FValid;
end;

///////////////////////////
//
// TprCustomHDetailHeaderBand
//
///////////////////////////
TprCustomHDetailHeaderBand = class(TprCustomHBand)
private
  FDetailBand        : TprCustomHDetailBand;
  FColCount          : integer;
  FColDirection      : TprColDirectionType;
  FReprintOnEachPage : boolean;

  FLinkToDetail      : boolean;

  procedure SetDetailBand(Value : TprCustomHDetailBand);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  function  GetUseColumns : boolean; override;
  function  GetColCount : integer; override;
  function  GetColDirection : TprColDirectionType; override;

  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  procedure OnInsertIntoPage(p : TprCustomPage); override;
  function  GetDrawDesignCaption : string; override;
published
  property DetailBand        : TprCustomHDetailBand read FDetailBand write SetDetailBand;

  property ColCount          : integer read FColCount write FColCount;
  property ColDirection      : TprColDirectionType read FColDirection write FColDirection;
  property ReprintOnEachPage : boolean read FReprintOnEachPage write FReprintOnEachPage;

  property LinkToDetail      : boolean read FLinkToDetail write FLinkToDetail;
end;

////////////////////////////
//
// TprCustomHDetailFooterBand
//
////////////////////////////
TprCustomHDetailFooterBand = class(TprCustomHBand)
private
  FDetailBand   : TprCustomHDetailBand;
  FColCount     : integer;
  FColDirection : TprColDirectionType;

  FLinkToDetail : boolean;
  
  procedure SetDetailBand(Value : TprCustomHDetailBand);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  function  GetUseColumns : boolean; override;
  function  GetColCount : integer; override;
  function  GetColDirection : TprColDirectionType; override;

  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  procedure OnInsertIntoPage(p : TprCustomPage); override;
  function  GetDrawDesignCaption : string; override;
published
  property DetailBand   : TprCustomHDetailBand read FDetailBand write SetDetailBand;

  property ColCount     : integer read FColCount write FColCount;
  property ColDirection : TprColDirectionType read FColDirection write FColDirection;

  property LinkToDetail : boolean read FLinkToDetail write FLinkToDetail;
end;

///////////////////////////
//
// TprCustomHGroupHeaderBand
//
///////////////////////////
TprCustomHGroupHeaderBand = class(TprCustomHBand)
private
  FGroup        : TprGroup;
  FColCount     : integer;
  FColDirection : TprColDirectionType;

  FLinkToDetail : boolean;
  FStartNewPage : boolean;

  procedure SetGroup(Value : TprGroup);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  procedure OnInsertIntoPage(p : TprCustomPage); override;

  function  GetUseColumns : boolean; override;
  function  GetColCount : integer; override;
  function  GetColDirection : TprColDirectionType; override;

  function  GetStartNewPage : boolean; override;
  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  function GetDrawDesignCaption : string; override;
published
  property Group        : TprGroup read FGroup write SetGroup;

  property ColCount     : integer read FColCount write FColCount;
  property ColDirection : TprColDirectionType read FColDirection write FColDirection;

  property LinkToDetail : boolean read FLinkToDetail write FLinkToDetail;
  property StartNewPage : boolean read FStartNewPage write FStartNewPage;
end;

///////////////////////////
//
// TprCustomHGroupFooterBand
//
///////////////////////////
TprCustomHGroupFooterBand = class(TprCustomHBand)
private
  FGroup        : TprGroup;
  FColCount     : integer;
  FColDirection : TprColDirectionType;

  FLinkToDetail : boolean;

  procedure SetGroup(Value : TprGroup);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  procedure OnInsertIntoPage(p : TprCustomPage); override;

  function  GetUseColumns : boolean; override;
  function  GetColCount : integer; override;
  function  GetColDirection : TprColDirectionType; override;

  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  function  GetDrawDesignCaption : string; override;
published
  property Group        : TprGroup read FGroup write SetGroup;

  property ColCount     : integer read FColCount write FColCount;
  property ColDirection : TprColDirectionType read FColDirection write FColDirection;

  property LinkToDetail : boolean read FLinkToDetail write FLinkToDetail;
end;






////////////////////////
//
// TprCustomVBand
//
////////////////////////
TprCustomVBand = class(TprBand)
private
  FUseHorizontalBands : boolean;
protected
  FWidth             : integer;
  FCallerHBand       : TprCustomHBand;
  FCrossTabGenerated : boolean; //      ,
                                //     
public
  procedure CalcdPageRect(var CurPageRect : TRect; ExData : pointer); override;

  //   
  function  GenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc; fSimpleCreateCell : boolean) : TprGenCell; override;

  //  
  procedure DesignerResize(oTop,oLeft,oBottom,oRight : integer); override;
  procedure DesignerLink(Linked : pDesignInfo; LinkMode : TprLinkType; var LinkAccepted : boolean); override;

  constructor Create(AOwner : TComponent); override;
published
  property Width : integer read FWidth write FWidth;
  property UseHorizontalBands : boolean read FUseHorizontalBands write FUseHorizontalBands;
end;

///////////////////////////////
//
// TprCustomVTitleBand
//
///////////////////////////////
TprCustomVTitleBand = class(TprCustomVBand)
end;

//////////////////////////////
//
// TprCustomVSummaryBand
//
//////////////////////////////
TprCustomVSummaryBand = class(TprCustomVBand)
private
  FPrintWithBand : TprCustomVBand;
public
  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  constructor Create(AOwner : TComponent); override;
published
  property PrintWithBand : TprCustomVBand read FPrintWithBand write FPrintWithBand;
end;

/////////////////////////
//
// TprVPageHeaderBand
//
/////////////////////////
TprCustomVPageHeaderBand = class(TprCustomVBand)
private
  FPrintOnFirstPage : boolean;
public
published
  property PrintOnFirstPage : boolean read FPrintOnFirstPage write FPrintOnFirstPage;
end;


/////////////////////////
//
// TprVPageFooterBand
//
/////////////////////////
TprCustomVPageFooterBand = class(TprCustomVBand)
private
  FPrintOnFirstPage : boolean;
  FPrintAfterLastBandOnPage : boolean;
public
  procedure CalcdPageRect(var CurPageRect : TRect; ExData : pointer); override;
published
  property PrintOnFirstPage : boolean read FPrintOnFirstPage write FPrintOnFirstPage;
  property PrintAfterLastBandOnPage : boolean read FPrintAfterLastBandOnPage write FPrintAfterLastBandOnPage;
end;

///////////////////////////////////
//
// TprCustomVDetailBand
//
///////////////////////////////////
TprCustomVDetailBand = class(TprCustomVBand)
private
  FParentDetail : TprCustomVDetailBand;
  FDataSetName  : string;
  FValid        : string;

  FGroupsNames  : TStrings;  // list of groups linked to this band
  FBandsNames   : TStrings;

  procedure SetParentDetail(Value : TprCustomVDetailBand);
protected
  procedure GroupRemoved(Group : TprGroup); override;
  procedure GroupAdded(Group : TprGroup); override;

  procedure ReadGroups(Reader : TReader);
  procedure WriteGroups(Writer : TWriter);
  procedure ReadBands(Reader : TReader);
  procedure WriteBands(Writer : TWriter);

  procedure Notification(AComponent : TComponent; Operation : TOperation); override;

  procedure DefineProperties(Filer : TFiler); override;
public
  DataSet : TprDatasetLink; // initializated in report generate

  Groups  : TprGroups;
  Bands   : TprBands; // list of bands depended from this band

  procedure CalcdPageRect(var CurPageRect : TRect; ExData : pointer); override;

  // generate report
  function  GenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc; fSimpleCreateCell : boolean) : TprGenCell; override;
  procedure InitDataSet; override;

  // for designer
  procedure OnInsertIntoPage(p : TprCustomPage); override;
  function  GetDrawDesignCaption : string; override;

  procedure AfterReportLoaded; override;

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;
published
  property DataSetName  : string read FDataSetName write FDataSetName;
  property ParentDetail : TprCustomVDetailBand read FParentDetail write SetParentDetail;
  property Valid        : string read FValid write FValid;
end;

///////////////////////////
//
// TprCustomVDetailHeaderBand
//
///////////////////////////
TprCustomVDetailHeaderBand = class(TprCustomVBand)
private
  FDetailBand        : TprCustomVDetailBand;
  FReprintOnEachPage : boolean;

  FLinkToDetail      : boolean;

  procedure SetDetailBand(Value : TprCustomVDetailBand);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  procedure OnInsertIntoPage(p : TprCustomPage); override;
  function  GetDrawDesignCaption : string; override;
published
  property DetailBand        : TprCustomVDetailBand read FDetailBand write SetDetailBand;

  property ReprintOnEachPage : boolean read FReprintOnEachPage write FReprintOnEachPage;
  property LinkToDetail      : boolean read FLinkToDetail write FLinkToDetail;
end;

////////////////////////////
//
// TprCustomVDetailFooterBand
//
////////////////////////////
TprCustomVDetailFooterBand = class(TprCustomVBand)
private
  FDetailBand   : TprCustomVDetailBand;

  FLinkToDetail : boolean;

  procedure SetDetailBand(Value : TprCustomVDetailBand);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  procedure OnInsertIntoPage(p : TprCustomPage); override;
  function  GetDrawDesignCaption : string; override;
published
  property DetailBand        : TprCustomVDetailBand read FDetailBand write SetDetailBand;

  property LinkToDetail : boolean read FLinkToDetail write FLinkToDetail;
end;

///////////////////////////
//
// TprCustomVGroupHeaderBand
//
///////////////////////////
TprCustomVGroupHeaderBand = class(TprCustomVBand)
private
  FGroup        : TprGroup;

  FLinkToDetail : boolean;
  FStartNewPage : boolean;

  procedure SetGroup(Value : TprGroup);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  procedure OnInsertIntoPage(p : TprCustomPage); override;

  function  GetStartNewPage : boolean; override;
  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  function GetDrawDesignCaption : string; override;
published
  property Group        : TprGroup read FGroup write SetGroup;

  property LinkToDetail : boolean read FLinkToDetail write FLinkToDetail;
  property StartNewPage : boolean read FStartNewPage write FStartNewPage;
end;

///////////////////////////
//
// TprCustomVGroupFooterBand
//
///////////////////////////
TprCustomVGroupFooterBand = class(TprCustomVBand)
private
  FGroup        : TprGroup;

  FLinkToDetail : boolean;

  procedure SetGroup(Value : TprGroup);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
public
  procedure OnInsertIntoPage(p : TprCustomPage); override;

  function  GetLinkToBand : TprBand; override;
  function  GetLinkType : TprBandLinkType; override;

  function GetDrawDesignCaption : string; override;
published
  property Group        : TprGroup read FGroup write SetGroup;

  property LinkToDetail : boolean read FLinkToDetail write FLinkToDetail;
end;





///////////////////////////////
//
// TprBands
//
///////////////////////////////
TprBands = class(TList)
private
  function GetItm(index : integer) : TprBand;
  function GetByBandType(BandType : TprBandType) : TprBand;
  function GetByName(Name : string) : TprBand;
public
  property Items[index : integer] : TprBand read GetItm; default;
  property ByBandType[BandType : TprBandType] : TprBand read GetByBandType;
  property ByName[Name : string] : TprBand read GetByName;

  function IndexByBandType(BandType : TprBandType) : integer;
  function IndexByName(Name : string) : integer;
end;

//////////////////////////
//
// TprGroup
//
//////////////////////////
TprGroup = class(TComponent)
private
  FValid       : string;
  FDetailBand  : TprBand;

  FPrevValue   : Variant;
  FNeedHeaders : boolean;
  FNeedFooters : boolean;
  FLineNo      : integer;

  FReport      : TprCustomReport;

  procedure SetReport(Value : TprCustomReport);
  procedure SetDetailBand(Value : TprBand);
protected
  procedure SetParentComponent(Value : TComponent); override;
  function  GetChildOwner : TComponent; override;
  procedure Notification(AComponent : TComponent; AOperation : TOperation); override;
public
  Headers : TprBands;
  Footers : TprBands;

  property  GroupEnded : boolean read FNeedFooters;
  property  LineNo     : integer read FLineNo write FLineNo;
  property  Report     : TprCustomReport read FReport write SetReport;

  function  IndexInReport : integer;

  procedure Reset;
  procedure CalcValue;

  procedure HeadersGenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc);
  procedure FootersGenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc);
  procedure FootersAlwaysGenerateCell(CallerBand : TprBand; CallbackProc : TGenerateCellCallbackProc);

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;

  function  HasParent : boolean; override;
  function  GetParentComponent : TComponent; override;
published
  property Valid      : string read FValid write FValid;
  property DetailBand : TprBand read FDetailBand write SetDetailBand;
end;

////////////////////////////
//
// TprGroups
//
////////////////////////////
TprGroups = class(TList)
private
  function GetItm(index : integer) : TprGroup;
  function GetByName(Name : string) : TprGroup;
public
  property Items[index : integer] : TprGroup read GetItm; default;
  property ByName[Name : string] : TprGroup read GetByName;

  function IndexByName(Name : string) : integer;
end;

/////////////////////////
//
// TprValueVersion
//
/////////////////////////
TprValueVersion = class(TObject)
public
  V1 : Variant;
  V2 : integer;
  Value : TprValue; 
  ID : integer;   // ident
  V : Variant;   
  constructor Create;
end;

/////////////////////////
//
// TprSavedValue
//
/////////////////////////
TprSavedValue = class(TObject)
  V : TprVarValue;
  Cell : TprGenCell;
end;

/////////////////////////
//
// TprValue
//
/////////////////////////
TprResetValueType = (rvtReport,rvtGroup,rvtPage,rvtDataSetEof);
TprCalcValueType  = (cvtDataSetNext,cvtEventOnReset,cvtCrossTab);
// cvtEventOnReset -    OnReset,  OnCalc
// cvtDataSetNext  -      DataSet   Formula
TprOnValueCalc = procedure (Value : TprValue) of object;
TprOnGetVersionByVersionID = procedure (ValueVersion : TprValueVersion) of object;
TprAggFunction = (prafSum,prafCount,prafAvg,prafMin,prafMax);

TprValue = class(TCollectionItem)
private
  FName : string;
  FAggFunction : TprAggFunction;
  FFormula : string;           //     
  FResetOn : TprResetValueType;// 
  FCalcOn : TprCalcValueType; //  
  FDataSetName : string;           //  DataSet,   
  FResetDataSetName : string;           //  DataSet,    Reset
  FCrossTabHorzDataSetName : string;           //
  FGroup : TprGroup;
  FVersions : TList;
  FCurrentValueExists : boolean;
  FSavedValues : TList;
  function GetVersion(index : integer) : TprValueVersion;
  procedure SetCurrentValue(Value : Variant);
  procedure SetName(Value : string);
  procedure SetFormula(Value : string);
  function AddSavedValue : TprSavedValue;
  procedure InternalCalcValue(ver : TprValueVersion; V : TprVarValue);
public
  SavedIndex : integer;        // used in CrossTab
  OnCalc : TprOnValueCalc; // cvtEventOnReset
  OnGetVersionByVersionID : TprOnGetVersionByVersionID;
  DataSet : TprDatasetLink;
  ResetDataSet : TprDatasetLink;
  CrossTabHorzDataSet : TprDatasetLink;

  property CurrentValue : Variant write SetCurrentValue;
  property Versions[index : integer] : TprValueVersion read GetVersion;
  function Report : TprCustomReport;
  function VersionsCount : integer;
  function GetCurrentVersion : TprValueVersion; overload;
  function GetCurrentVersion(var fCreated : boolean) : TprValueVersion; overload;
  function GetCurrentVersionID : string;
  function VersionByVersionID(ID : integer) : TprValueVersion;
  procedure Init;
  procedure Reset;
  procedure Clear;
  procedure Calculate(Cell : TprGenCell);
  constructor Create(Collection : TCollection); override;
  destructor Destroy; override;
published
  property Group : TprGroup read FGroup write FGroup;
  property Name : string read FName write SetName;
  property AggFunction : TprAggFunction read FAggFunction write FAggFunction; 
  property Formula : string read FFormula write SetFormula;
  property ResetOn : TprResetValueType read FResetOn write FResetOn;
  property CalcOn : TprCalcValueType read FCalcOn write FCalcOn;
  property DataSetName : string read FDataSetName write FDataSetName;
  property ResetDataSetName : string read FResetDataSetName write FResetDataSetName;
  property CrossTabHorzDataSetName : string read FCrossTabHorzDataSetName write FCrossTabHorzDataSetName;
end;

//////////////////////////
//
// TprValues
//
//////////////////////////
TprValues = class(TCollection)
private
  function GetItm(index : integer) : TprValue;
  function GetByName(name : string) : TprValue;
public
  Report : TprCustomReport;
  property Items[index : integer] : TprValue read GetItm; default;
  property ByName[Name : string] : TprValue read GetByName;
  function IndexByName(name : string) : integer;
  function VersionByVersionID(id : string) : TprValueVersion;
end;

/////////////////////////////////////////////////
//
// TprCustomEndPage
//
/////////////////////////////////////////////////
TprCustomEndPage = class(TObject)
private
  FoRecs : TList;
  PageX : integer;
  PageY : integer; 

  function GetoRec(index : integer) : TprObjRec;
public
  Report : TprCustomReport;
  Width : integer;
  Height : integer;

  Rect : TRect;   // used in method SecondPassPlaceGridOnEndPage, internal var
  AvailableRect : TRect;   // page rect after placed bands:
                           // vTitle,hTitle,vPageHeader,hPageHeader,vPageFooter,hPageFooter

  property oRec[index : integer] : TprObjRec read GetoRec;
  function CurrentWidth : integer;  // Rect.Right-Rect.Left
  function CurrentHeight : integer; // Rect.Bottom-Rect.Top
  function oRecsCount : integer;
  procedure ThirdPass; virtual; abstract;
  function GetPageRect : TRect; virtual; abstract;
  procedure FreeGeneratedObjects;
  constructor Create(_Page : TprCustomPage); virtual;
  constructor CreateEmpty(_Report : TprCustomReport); virtual;
  destructor Destroy; override;
end;

//////////////////////////
//
// TprGenCell
//
//////////////////////////
TprGenCell = class(TObject)
private
  FObjRecs : TList;
  function GetObjRec(i : integer) : TprObjRec;
public
  Page : TprCustomEndPage; //  ,    
  XOffs : integer;          //      
  YOffs : integer;          //
  Width : integer;
  Height : integer;
  HVector : TprGenVector;
  VVector : TprGenVector;
  property ObjRecs[i : integer] : TprObjRec read GetObjRec;
  function ObjRecsCount : integer;
  procedure Add(ObjRec : TprObjRec);
  constructor Create;
  destructor Destroy; override;
end;

////////////////////////////
//
// TprGenVector
//
////////////////////////////
TprGenVector = class(TList)
private
  FLinkToVector : TprGenVector;
  function GetItm(i : integer) : TprGenCell;
public
  Page : integer; //   - PageX  EndPage,   PageY  EndPage
  XOffs : integer;
  YOffs : integer;
  Height : integer;
  Width : integer;
  Band : TprBand;

  property Itms[i : integer] : TprGenCell read GetItm; default;
  procedure AddCell(Cell : TprGenCell);

  constructor Create(_Band : TprBand);
end;

///////////////////////////
//
// TprGenGrid
//
///////////////////////////
TprGenGrid = class(TObject)
private
  FCurHVector : TprGenVector;
  FCurVVectorIndex : integer;
  FVVectors : TList;
  FHVectors : TList;
  FInsertedVectors : TList;
  FCells : TList;
  FHPageHeaderCells : TList;
  FHPageFooterCells : TList;
  FVPageHeaderCells : TList;
  FVPageFooterCells : TList;
  FProgressUpdateCounter : integer;
  function GetVVector(i : integer) : TprGenVector;
  function GetHVector(i : integer) : TprGenVector;
  function GetCell(i : integer) : TprGenCell;
  function GetHPageHeaderCell(i : integer) : TprGenCell;
  function GetHPageFooterCell(i : integer) : TprGenCell;
  function GetVPageHeaderCell(i : integer) : TprGenCell;
  function GetVPageFooterCell(i : integer) : TprGenCell;
public
  Page : TprCustomPage;
  vTitleCell : TprGenCell;
  hTitleCell : TprGenCell;
  vSummaryCell : TprGenCell;
  hSummaryCell : TprGenCell;

  property VVectors[i : integer] : TprGenVector read GetVVector;
  property HVectors[i : integer] : TprGenVector read GetHVector;
  property Cells[i : integer] : TprGenCell read GetCell;
  property HPageHeaderCells[i : integer] : TprGenCell read GetHPageHeaderCell;
  property HPageFooterCells[i : integer] : TprGenCell read GetHPageFooterCell;
  property VPageHeaderCells[i : integer] : TprGenCell read GetVPageHeaderCell;
  property VPageFooterCells[i : integer] : TprGenCell read GetVPageFooterCell;

  function VVectorsCount : integer;
  function HVectorsCount : integer;
  function CellsCount : integer;
  function HPageHeaderCellsCount : integer;
  function HPageFooterCellsCount : integer;
  function VPageHeaderCellsCount : integer;
  function VPageFooterCellsCount : integer;

  function IndexOfVVector(Vector : TprGenVector) : integer;
  function FindPriorVVectorOnPage(FromIndex : integer; Band : TprBand; EndPagePageX : integer) : TprGenVector;
  function FindPriorVVector(FromIndex : integer; Band : TprBand; MinEndPageIndex : integer) : TprGenVector;
  function CopyVVector(SourceVector : TprGenVector; Index : integer) : TprGenVector;

  function IndexOfHVector(Vector : TprGenVector) : integer;
  function FindPriorHVectorOnPage(FromIndex : integer; Band : TprBand; EndPagePageY : integer) : TprGenVector;
  function FindPriorHVector(FromIndex : integer; Band : TprBand; MinEndPageIndex : integer) : TprGenVector;
  function CopyHVector(SourceVector : TprGenVector; Index : integer) : TprGenVector;

  function AddCell(_HBand : TprCustomHBand; _VBand : TprCustomVBand) : TprGenCell;
  function AddCellSimple : TprGenCell;
  procedure AddHPageHeaderCell(_Cell : TprGenCell);
  procedure AddHPageFooterCell(_Cell : TprGenCell);
  procedure AddVPageHeaderCell(_Cell : TprGenCell);
  procedure AddVPageFooterCell(_Cell : TprGenCell);
  procedure EndOfLine;

  procedure Clear;

  constructor Create(_Page : TprCustomPage);
  destructor Destroy; override;
end;

//////////////////////////
//
// TprCustomPage
//
//////////////////////////
TprCustomPage = class(TComponent)
private
  FWidth : integer;
  FHeight : integer;

  FReport : TprCustomReport;

  FOldEndPagesRects : array of TRect;

  procedure SetReport(Value : TprCustomReport);
protected
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
  procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
  procedure SetParentComponent(Value : TComponent); override;
  function  GetChildOwner : TComponent; override;
  procedure ReportSetted; virtual;
public
  Grid : TprGenGrid;
  Bands : TprBands; // list of bands on page
  dPageRect  : PRect;  

  property Report : TprCustomReport read FReport write SetReport;

  function IndexInReport : integer;

  //  
  function  GetPageRect : TRect; virtual; abstract;
  function  HasVerticalBands : boolean;

  //
  procedure FirstPassGenerateGrid;
  procedure SecondPassPlaceGridOnEndPage;

  // 
  procedure UpdateBandsPageRect;
  procedure DrawDesign(Canvas : TCanvas; ExData : pointer); virtual;

  // 
  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;

  function  HasParent : boolean; override;
  function  GetParentComponent : TComponent; override;
published
  property Width  : integer read FWidth write FWidth;
  property Height : integer read FHeight write FHeight;
end;

///////////////////////////
//
// TprCustomReport
//
///////////////////////////
rDataSetRecNo = record
  DataSet : TprDatasetLink;
  RecNo : integer;
end;
(*$NODEFINE rDataSetRecNo*)
TDataSetRecNoArray = array of rDataSetRecNo;
(*$NODEFINE TDataSetRecNoArray*)
(*$HPPEMIT 'struct rDataSetRecNo'*)
(*$HPPEMIT '{'*)
(*$HPPEMIT '	Pr_dataset::TprDatasetLink* DataSet;'*)
(*$HPPEMIT '	int RecNo;'*)
(*$HPPEMIT '} ;'*)
(*$HPPEMIT 'typedef DynamicArray<rDataSetRecNo >  TDataSetRecNoArray;'*)
(*$HPPEMIT '}'*)

TOnBandGenerateCell       = procedure (Sender : TObject; Band : TprBand) of object;
TOnPageStart              = procedure (Sender : TObject; EndPage : TprCustomEndPage) of object;
TOnPageEnd                = procedure (Sender : TObject; EndPage : TprCustomEndPage) of object;
TOnFirstPassObject        = procedure (Sender : TObject; Obj : TprObj; var ManuallyProcessed : boolean) of object;
TOnUnknownVariable        = procedure (Sender : TObject; const VarName : string;
                                                         var Value : TprVarValue;
                                                         var IsProcessed : boolean) of object;
TOnUnknownFunction        = procedure (Sender : TObject; const FuncName   : string;
                                                         const Parameters : TprVarsArray;
                                                         ParametersCount  : integer;
                                                         var Value        : TprVarValue;
                                                         var IsProcessed  : boolean) of object;
TOnUnknownObjFunction     = procedure (Sender : TObject; Component        : TComponent;
                                                         const FuncName   : string;
                                                         const Parameters : TprVarsArray;
                                                         ParametersCount  : integer;
                                                         var Value        : TprVarValue;
                                                         var IsProcessed  : boolean) of object;
TOnUnknownObjProp     = procedure (Sender : TObject; Component        : TComponent;
                                                     const PropName   : string;
                                                     const IdentName  : string;
                                                     var Value        : TprVarValue;
                                                     var IsProcessed  : boolean) of object;

TOnDesignerSave           = procedure (Sender : TObject; var FileName : string; SaveAs : Boolean) of object;
TOnGetAvailableComponents = procedure (Sender : TObject; L : TStrings) of object;
TOnGetAvailableDatasets   = procedure (Sender : TObject; L : TStrings) of object;
TOnCloseSetupDialogEvent  = procedure (Sender : TObject; fOK : boolean) of object;
TOnInitDetailBandDataSet  = procedure (Sender : TObject; DetailBand : TprBand; DataSet : TObject; const DataSetName : string) of object;

TprReportMode     = (rmDesign, rmPrinting, rmNone);
TprPrintPagesMode = (ppmAll,ppmPagesRange,ppmSelection,ppmPagesList);
TprFormMode       = (fmNormal,fmMDIChild);

TOnTemplateChangedGlobalProc = procedure(Report : TprCustomReport);

TOnPreviewMouseMove = procedure (Sender : TObject; PreviewUserData : TprPreviewUserData; var cur : TCursor; var HighlightObject : boolean) of object;
TOnPreviewMouseDown = procedure (Sender : TObject; PreviewUserData : TprPreviewUserData; Shift : TShiftState) of object;
TOnPreviewDblClick = procedure (Sender : TObject; PreviewUserData : TprPreviewUserData) of object;
TOnPreviewGetUserData = procedure (Sender : TObject; Obj : TprObj; ObjRec : TprObjRec; var PreviewUserData : TprPreviewUserData) of object;

TprExportOptions = (preoShowParamsDlg,preoShowProgress,preoShowAfterGenerate,preoShowWhileGenerate);
TprExportOptionsSet = set of TprExportOptions;
TprCustomReport = class(TComponent)
private
  FExportFileName : string;
  FExportOptions : TprExportOptionsSet;
  FExportPagesMode : TprPrintPagesMode;
  FExportFromPage : integer;
  FExportToPage : integer;
  FExportPages : string;

  FTitle  : string;

  FCollate : boolean;

  FShowProgress : boolean;
  FCanUserEdit : boolean;

  FDesignerFormMode : TprFormMode;
  FPreviewFormMode : TprFormMode;

  FValues : TprValues;

  FCustomActionInPreviewCaption : string;

  FOnBandGenerateCell : TOnBandGenerateCell;
  FOnPageStart : TOnPageStart;
  FOnPageEnd : TOnPageEnd;
  FOnFirstPassObject : TOnFirstPassObject;
  FOnUnknownVariable : TOnUnknownVariable;
  FOnUnknownFunction : TOnUnknownFunction;
  FOnUnknownObjFunction : TOnUnknownObjFunction;
  FOnUnknownObjProp : TOnUnknownObjProp;
  FOnGetAvailableComponents : TOnGetAvailableComponents;
  FOnGetAvailableDatasets : TOnGetAvailableDatasets;
  FOnCustomActionInPreview : TNotifyEvent;
  FOnInitDetailBandDataSet : TOnInitDetailBandDataSet;
  FOnPrintComplete : TNotifyEvent;

  FOnDesignerSave : TOnDesignerSave;
  FOnCreateDesigner : TNotifyEvent;
  FOnDestroyDesigner : TNotifyEvent;
  FOnCreatePreview : TNotifyEvent;
  FOnDestroyPreview : TNotifyEvent;
  FOnCloseSetupDialog : TOnCloseSetupDialogEvent;

  FOnPreviewMouseMove : TOnPreviewMouseMove;
  FOnPreviewMouseDown : TOnPreviewMouseDown;
  FOnPreviewGetUserData : TOnPreviewGetUserData;
  FOnPreviewDblClick : TOnPreviewDblClick;

  FGACList : TStringList;
  FPreviewUserDataList : TList;
  FEndPages : TList;
  FPages : TList;
  FParser : TObject;
  ADSRN : TDataSetRecNoArray;


  FDesignerForm : TprDesigner;
  FPreviewForm : TprPreview;

  FReportPrepared : boolean;
  FTemplateChanged : boolean;

  function GetPage(index : integer) : TprCustomPage;
  function GetEndPage(index : integer) : TprCustomEndPage;

  function GetAllValuesCount : integer;
  function GetAllValue(i : integer) : TprValue;

  procedure OnCalcPagesCount(Value : TprValue);
  procedure OnCalcPageNo(ValueVersion : TprValueVersion);
  procedure OnCalcPageNo2(Value : TprValue);

  function  GetprOwner : TComponent;

  procedure ClearPreviewUserDataList;
  procedure ClearGrids;
protected
  FCopies : integer;
  FFromPage : integer;
  FToPage : integer;
  FPrintPages : string;
  FPrintPagesMode : TprPrintPagesMode;

  FActionCanceled : boolean;
  FProgressForm : TprProgressForm;
  FLastActiveWindow : HWND;
  FDisabledWindows : array of HWND;

  function GetPrinterName : string; virtual; abstract;
  procedure SetPrinterName(Value : string); virtual; abstract;

  procedure Loaded; override;
  procedure GetChildren(Proc: TGetChildProc; Root: TComponent); override;
  procedure Notification(AComponent : TComponent; Operation : TOperation); override;
  function GetChildOwner : TComponent; override;
  procedure ReadSystemInfo(Reader : TReader);
  procedure WriteSystemInfo(Writer : TWriter);
  procedure DefineProperties(Filer : TFiler); override;

  function GetDesignerFormClass : string; virtual; abstract;
  function GetPreviewFormClass : string; virtual; abstract;
  function CheckEndPagesCountOnPreview : boolean; virtual;

  procedure SetTemplateChanged(Value : boolean); virtual;

  procedure CreateProgressForm(const Caption : string; Max : integer);
  procedure CloseProgressForm;
public
  Designer : IUnknown; //    Delphi IDE

  StartDateTime : TDateTime;

  Groups : TprGroups;
  IndexCurEndPage : integer; //    

  SystemValues : TprValues;

  FPrintPagesList : TList;
  ObjectCalcSizesDevice  : TObject;

  property Parser : TObject read FParser;
  property DesignerForm : TprDesigner read FDesignerForm write FDesignerForm;
  property PreviewForm : TprPreview read FPreviewForm write FPreviewForm;
  property ProgressForm : TprProgressForm read FProgressForm write FProgressForm;

  property ActionCanceled : boolean read FActionCanceled;
  property TemplateChanged : boolean read FTemplateChanged write SetTemplateChanged;
  property ReportPrepared : boolean read FReportPrepared;

  property Pages[index : integer] : TprCustomPage read GetPage;
  property EndPages[index : integer] : TprCustomEndPage read GetEndPage;

  property AllValues[i : integer] : TprValue read GetAllValue;
  property AllValuesCount : integer read GetAllValuesCount;

  property prOwner : TComponent read GetprOwner;

  function PagesCount : integer;
  function EndPagesCount : integer;

  function CreateEndPage(Page : TprCustomPage) : TprCustomEndPage; virtual; abstract;
  function CreateEmptyEndPage : TprCustomEndPage; virtual; abstract;
  function CurEndPage : TprCustomEndPage;
  procedure AddEndPage(Page : TprCustomPage);
  procedure AddEndPageToList(EndPage : TprCustomEndPage);
  procedure InsertEndPageIntoList(EndPage : TprCustomEndPage; i : integer);
  function EndPageIndex(EndPage : TprCustomEndPage) : integer;
  procedure DeleteEndPage(index : integer);
  procedure ClearEndPages;
  procedure ClearValuesVersions;
  procedure AddPreviewUserData(PreviewUserData : TprPreviewUserData);

  procedure ConvertToDesignerCoords(const rSource : TRect; var rDest : TRect);

  function GetBandClass(BandType : TprBandType) : TprBandClass; virtual;

  procedure ChangePrinter(OldIndex,NewIndex : integer); virtual; abstract;

  function PrepareReport : boolean; virtual;
  procedure DesignReport(Modal : boolean);
  procedure PreviewPreparedReport(Modal : boolean);
  function SetupPrintParams : boolean; virtual; abstract;
  function PrintPreparedReport : boolean; virtual; abstract;
  procedure ClearPreparedReport; virtual;

  function Calc(var Expression : string) : Variant;
  function FormatTemplate(Template : string; var Res : string) : boolean;
  function FormatStrings(lSource,lDest : TStrings; DeleteEmptyLines,DeleteEmptyLinesAtEnd : boolean) : boolean;

  procedure DoOnBandGenerateCell(Band : TprBand);
  procedure DoOnDataSetNext(DataSet : TprDatasetLink; HorizontalBand : TprCustomHBand; VerticalBand : TprCustomVBand; Cell : TprGenCell);
  procedure DoOnDataSetEof(DataSet : TprDatasetLink);
  procedure DoOnGroupEnd(Group : TprGroup);
  procedure DoOnPageStart(EndPage : TprCustomEndPage);
  procedure DoOnPageEnd(EndPage : TprCustomEndPage);
  procedure DoOnFirstPassObject(Sender : TprObj; var ManuallyProcessed : boolean);
  procedure DoOnPreviewMouseMove(PreviewUserData : TprPreviewUserData; var cur : TCursor; var HighlightObject : boolean);
  procedure DoOnPreviewMouseDown(PreviewUserData : TprPreviewUserData; Shift : TShiftState);
  procedure DoOnPreviewDblClick(PreviewUserData : TprPreviewUserData);
  procedure DoOnPreviewGetUserData(Obj : TprObj; ObjRec : TprObjRec; var PreviewUserData : TprPreviewUserData);

  procedure ClearTemplate;
  procedure SaveTemplate(Stream : TStream; InBinaryFormat : boolean);
  procedure SaveTemplateToFile(FileName : string; InBinaryFormat : boolean);
  procedure SaveTemplateToStrings(Dest : TStrings);
  procedure LoadTemplate(Stream : TStream; InBinaryFormat : boolean);
  procedure LoadTemplateFromFile(FileName : string; InBinaryFormat : boolean);
  procedure LoadTemplateFromStrings(Source : TStrings);

  procedure LoadPreparedReport(Stream : TStream); virtual;
  procedure AppendPreparedReport(Stream : TStream); virtual;
  procedure SavePreparedReport(Stream : TStream); virtual;
  procedure LoadPreparedReportFromFile(FileName : string); virtual;
  procedure AppendPreparedReportFromFile(FileName : string); virtual;
  procedure SavePreparedReportToFile(FileName : string); virtual;

  procedure TranslateObjectName(Ident : string; var Component : TComponent; var LastName : string);

  procedure GetAvailableDataSets(L : TStrings);
  procedure GetAvailableComponents(L : TStrings);
  function GetDataSetByName(DataSetName : string) : TObject;

  function GetDataSetRecNo(Dataset : TprDatasetLink) : integer; overload;
  function GetDataSetRecNo(Dataset : TObject) : integer; overload;

  function ADSRN_GetIndex(DataSet : TprDatasetLink) : integer; overload;
  function ADSRN_GetIndex(DataSet : TObject) : integer; overload;
  procedure ADSRN_First(DataSet : TprDatasetLink);
  procedure ADSRN_Next(DataSet : TprDatasetLink);

  procedure UpdateProgressForm(Text : string);

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;
published
  property ShowProgress : boolean read FShowProgress write FShowProgress;
  property CanUserEdit : boolean read FCanUserEdit write FCanUserEdit;

  property DesignerFormMode : TprFormMode read FDesignerFormMode write FDesignerFormMode;
  property PreviewFormMode : TprFormMode read FPreviewFormMode write FPreviewFormMode;

  property Collate : boolean read FCollate write FCollate;
  property Copies : integer read FCopies write FCopies;
  property FromPage : integer read FFromPage write FFromPage;
  property ToPage : integer read FToPage write FToPage;
  property PrintPages : string read FPrintPages write FPrintPages;
  property PrintPagesMode : TprPrintPagesMode read FPrintPagesMode write FPrintPagesMode;
  property Title : string read FTitle write FTitle;

  property ExportFileName : string read FExportFileName write FExportFileName;
  property ExportOptions : TprExportOptionsSet read FExportOptions write FExportOptions;
  property ExportPagesMode : TprPrintPagesMode read FExportPagesMode write FExportPagesMode;
  property ExportFromPage : integer read FExportFromPage write FExportFromPage;
  property ExportToPage : integer read FExportToPage write FExportToPage;
  property ExportPages : string read FExportPages write FExportPages;

  property Values : TprValues read FValues write FValues;

  property PrinterName : string read GetPrinterName write SetPrinterName;
  property CustomActionInPreviewCaption : string read FCustomActionInPreviewCaption write FCustomActionInPreviewCaption;

  property OnPageStart : TOnPageStart read FOnPageStart write FOnPageStart;
  property OnPageEnd : TOnPageEnd read FOnPageEnd write FOnPageEnd;
  property OnFirstPassObject : TOnFirstPassObject read FOnFirstPassObject write FOnFirstPassObject;
  property OnUnknownVariable : TOnUnknownVariable read FOnUnknownVariable write FOnUnknownVariable;
  property OnUnknownFunction : TOnUnknownFunction read FOnUnknownFunction write FOnUnknownFunction;
  property OnUnknownObjFunction : TOnUnknownObjFunction read FOnUnknownObjFunction write FOnUnknownObjFunction;
  property OnUnknownObjProp : TOnUnknownObjProp read FOnUnknownObjProp write FOnUnknownObjProp;
  property OnGetAvailableComponents : TOnGetAvailableComponents read FOnGetAvailableComponents write FOnGetAvailableComponents;
  property OnGetAvailableDatasets : TOnGetAvailableDatasets read FOnGetAvailableDatasets write FOnGetAvailableDatasets;
  property OnDesignerSave : TOnDesignerSave read FOnDesignerSave write FOnDesignerSave;
  property OnCreateDesigner : TNotifyEvent read FOnCreateDesigner write FOnCreateDesigner;
  property OnDestroyDesigner : TNotifyEvent read FOnDestroyDesigner write FOnDestroyDesigner;
  property OnCreatePreview : TNotifyEvent read FOnCreatePreview write FOnCreatePreview;
  property OnDestroyPreview : TNotifyEvent read FOnDestroyPreview write FOnDestroyPreview;
  property OnCustomActionInPreview : TNotifyEvent read FOnCustomActionInPreview write FOnCustomActionInPreview;
  property OnCloseSetupDialog : TOnCloseSetupDialogEvent read FOnCloseSetupDialog write FOnCloseSetupDialog;
  property OnBandGenerateCell : TOnBandGenerateCell read FOnBandGenerateCell write FOnBandGenerateCell;
  property OnInitDetailBandDataSet : TOnInitDetailBandDataSet read FOnInitDetailBandDataSet write FOnInitDetailBandDataSet;
  property OnPrintComplete : TNotifyEvent read FOnPrintComplete write FOnPrintComplete;
  property OnPreviewMouseMove : TOnPreviewMouseMove read FOnPreviewMouseMove write FOnPreviewMouseMove;
  property OnPreviewMouseDown : TOnPreviewMouseDown read FOnPreviewMouseDown write FOnPreviewMouseDown;
  property OnPreviewDblClick : TOnPreviewDblClick read FOnPreviewDblClick write FOnPreviewDblClick;
  property OnPreviewGetUserData : TOnPreviewGetUserData read FOnPreviewGetUserData write FOnPreviewGetUserData;
end;

function  prGetDefaultPrinterName : string;

function  ReadString(Stream : TStream) : string;
procedure ReadRect(Stream : TStream; var r : TRect);
procedure WriteString(Stream : TStream; s : string);
procedure WriteRect(Stream : TStream; r : TRect);

procedure prLoadResImages(Form : TForm; IL : TImageList);
procedure LoadResImage(b : TBitmap; ResID : string);
function  GetValidComponentName(Component : TComponent) : string;
procedure prWriteCompListNames(Writer : TWriter; L : TList);
procedure prReadStringList(Reader : TReader; L : TStrings);
procedure GetEnumNamesToStrings(ti : PTypeInfo; Max : integer; L : TStrings);

procedure DrawRect(DC : HDC; const R : TRect);
function  Create90Font(Font : TFont) : HFont;
function  CreateAPIFont(Font : TFont) : HFont;
function  CreateDefFont(DC : HDC; Size : integer; Color : TColor) : HFont;
function  Create90DefFont(DC : HDC; Size : integer; Color : TColor) : HFont;

function MulRect(const R : TRect; cx,cy : integer) : TRect;
function DivRect(const R : TRect; cx,cy : integer) : TRect;
function MulDivRect(const r : TRect; cx1,cx2,cy1,cy2 : integer) : TRect;

procedure DrawAngleRect(DC : HDC; r : TRect);

procedure prRegisterObj(_ClassRef           : TprObjClass;
                        _RecClassRef        : TprObjRecClass;
                        _ReportRef          : TprCustomReportClass;
                        _CaptionResID       : integer;
                        _HintResID          : integer;
                        _PropsFormClassName : string;
                        _VersionPropsFormClassName : string);
function  CreatePrObj(ClassRef  : TprObjClass;
                      Band      : TprBand) : TprObj;
function  CreatePrObjRec(ClassRef  : TprObjRecClass;
                         EndPage   : TprCustomEndPage) : TprObjRec;

function CreatePrPreviewUserData(const ClassName : string) : TprPreviewUserData;

type

TprPaperInfo = record
  Typ : Integer;
  Name : String;
  X,Y : Integer;
end;

rBandInfo = record
  Title    : string;
  ClassRef : TprBandClass;
end;

TprObjRegInfo = record
  ClassRef           : TprObjClass;
  RecClassRef        : TprObjRecClass;
  ReportRef          : TprCustomReportClass;
  CaptionResID       : integer;
  HintResID          : integer;
  PropsFormClassName : string;
  VersionPropsFormClassName : string;
end;

var
  prObjRegInfos : array of TprObjRegInfo;
  prIniFileName : string;
  prGetComponentsReportDesc : string;

  prTemplateChangedGlobalProc : TOnTemplateChangedGlobalProc;
{$IFDEF PR_D4}
  prCreatedReports : TList;
{$ENDIF}

const
  PageBandsOrder : array [0..MAX_PAGEBANDSORDER] of TprBandType = (bthTitle,bthPageHeader,bthPageFooter,bthDetail,bthSummary,bthDetailHeader,bthDetailFooter,bthGroupHeader,bthGroupFooter);
  PageBandsOrderVert : array [0..MAX_PAGEBANDSORDERVERT] of TprBandType = (btvTitle,btvPageHeader,btvPageFooter,btvDetail,btvSummary,btvDetailHeader,btvDetailFooter,btvGroupHeader,btvGroupFooter);
  PageHeadersFootersBands : array [0..MAX_PAGEHEADERSFOOTERS] of TprBandType = (btvPageHeader,btvPageFooter,bthPageHeader,bthPageFooter);

  VerticalBands : set of TprBandType = [btvTitle,
                                        btvSummary,
                                        btvPageHeader,
                                        btvPageFooter,
                                        btvDetail,
                                        btvDetailHeader,
                                        btvDetailFooter,
                                        btvGroupHeader,
                                        btvGroupFooter];
  HorizontalBands : set of TprBandType = [bthTitle,
                                          bthSummary,
                                          bthPageHeader,
                                          bthPageFooter,
                                          bthDetail,
                                          bthDetailHeader,
                                          bthDetailFooter,
                                          bthGroupHeader,
                                          bthGroupFooter];
var
  BandTitles : array [TprBandType] of string = (
    ('Title'),
    ('Summary'),
    ('PageHeader'),
    ('PageFooter'),
    ('Detail'),
    ('DetailHeader'),
    ('DetailFooter'),
    ('GroupHeader'),
    ('GroupFooter'),
    ('VTitle'),
    ('VSummary'),
    ('VPageHeader'),
    ('VPageFooter'),
    ('VDetail'),
    ('VDetailHeader'),
    ('VDetailFooter'),
    ('VGroupHeader'),
    ('VGroupFooter'));

implementation

uses
  pr_Strings, pr_Parser;

///////////////////////////
//
// 
//
///////////////////////////
function prGetDefaultPrinterName;
var
  n : integer;
  Buffer : pointer;
  BytesNeeded,NumInfo : cardinal;
begin
Result     :='';
Buffer     :=nil;
BytesNeeded:=0;

case Win32Platform of
  VER_PLATFORM_WIN32_WINDOWS:
    begin
      EnumPrinters(PRINTER_ENUM_DEFAULT,nil,5,Buffer,0,BytesNeeded,NumInfo);
      if BytesNeeded<>0 then
        begin
          GetMem(Buffer,BytesNeeded);
          try
            if EnumPrinters(PRINTER_ENUM_DEFAULT,nil,5,Buffer,BytesNeeded,BytesNeeded,NumInfo) then
              if NumInfo>0 then
                Result:=StrPas(PPrinterInfo5(Buffer).pPrinterName);
          finally
            FreeMem(Buffer);
          end
        end;
    end;
  VER_PLATFORM_WIN32_NT:
    begin
    {
      EnumPrinters(PRINTER_ENUM_DEFAULT,nil,4,Buffer,0,BytesNeeded,NumInfo);
      if BytesNeeded<>0 then
        begin
          GetMem(Buffer,BytesNeeded);
          try
            if EnumPrinters(PRINTER_ENUM_DEFAULT,nil,4,Buffer,BytesNeeded,BytesNeeded,NumInfo) then
              if NumInfo>0 then
                Result:=StrPas(PPrinterInfo4(Buffer).pPrinterName);
          finally
            FreeMem(Buffer);
          end
        end
      else
        outputdebugstring(pchar(syserrormessage(getlasterror)));
    }
    end;
end;

if Result='' then
  begin
    SetLength(Result,80);
    n:=GetProfileString('windows',
                        'device',
                        '',
                        @(Result[1]),
                        79);
    SetLength(Result,n);
    n:=pos(',',Result);
    if n<>0 then
      Result:=Copy(Result,1,n-1);
  end;
end;

procedure prLoadResImages;
var
  i : integer;
  c : TComponent;
  l : TStringList;
  b : TBitmap;

  function LoadImage(ResName : string) : integer;
  begin
  ResName:=AnsiUpperCase(Copy(ResName,2,Length(ResName)));
  Result :=l.IndexOf(ResName);
  if Result=-1 then
    begin
      if FindResource(hInstance,PChar('PR_'+ResName),RT_BITMAP)<>0 then
        try
          b.LoadFromResourceName(hInstance,'PR_'+ResName);
          l.AddObject(ResName,TObject(IL.AddMasked(b,b.TransparentColor)));
        except
          l.AddObject(ResName,TObject(-1));
        end
      else
        l.AddObject(ResName,TObject(-1));
      Result:=integer(l.Objects[l.Count-1])
    end
  else
    begin
      Result:=integer(l.Objects[Result]);
    end;
  end;

begin
l:=TStringList.Create;
b:=TBitmap.Create;
try
  for i:=0 to Form.ComponentCount-1 do
    begin
      c:=Form.Components[i];
      if (c is TToolButton) and (TToolButton(c).Action=nil) and (TToolButton(c).Style<>tbsSeparator) then
        begin
          TToolButton(c).ImageIndex:=LoadImage(TToolButton(c).Name);
        end;
  
      if Form.Components[i] is TAction then
        begin
          TAction(c).ImageIndex:=LoadImage(TAction(c).Name);
        end
    end;
finally
  l.Free;
  b.Free;
end;
end;

procedure GetEnumNamesToStrings;
var
  i : integer;
begin
for i:=0 to Max do
  L.Add(GetEnumName(ti,i));
end;

function MulRect;
begin
Result.Left := r.Left*cx;
Result.Right := r.Right*cx;
Result.Top := r.Top*cy;
Result.Bottom := r.Bottom*cy;
end;

function DivRect;
begin
Result.Left := r.Left div cx;
Result.Right := r.Right div cx;
Result.Top := r.Top div cy;
Result.Bottom := r.Bottom div cy;
end;

function MulDivRect(const r : TRect; cx1,cx2,cy1,cy2 : integer) : TRect;
begin
Result.Left := MulDiv(r.Left,cx1,cx2);
Result.Right := MulDiv(r.Right,cx1,cx2);
Result.Top := MulDiv(r.Top,cy1,cy2);
Result.Bottom := MulDiv(r.Bottom,cy1,cy2);
end;

procedure prRegisterObj;
begin
SetLength(prObjRegInfos,Length(prObjRegInfos)+1);
with prObjRegInfos[High(prObjRegInfos)] do
  begin
    ClassRef           :=_ClassRef;
    RecClassRef        :=_RecClassRef;
    ReportRef          :=_ReportRef;
    CaptionResID       :=_CaptionResID;
    HintResID          :=_HintResID;
    PropsFormClassName :=_PropsFormClassName;
    VersionPropsFormClassName := _VersionPropsFormClassName;
  end;
end;

procedure DrawAngleRect(DC : HDC; r : TRect);
var
  npn,opn : HPen;
begin
npn := CreatePen(PS_SOLID,1,clBlack);
opn := SelectObject(DC,npn);

MoveToEx(DC,r.Left+AngleSize,r.Top,nil);
LineTo(DC,r.Left,r.Top);
LineTo(DC,r.Left,r.Top+AngleSize);

MoveToEx(DC,r.Left+AngleSize,r.Bottom-1,nil);
LineTo(DC,r.Left,r.Bottom-1);
LineTo(DC,r.Left,r.Bottom-AngleSize-1);

MoveToEx(DC,r.Right-AngleSize-1,r.Top,nil);
LineTo(DC,r.Right-1,r.Top);
LineTo(DC,r.Right-1,r.Top+AngleSize);

MoveToEx(DC,r.Right-AngleSize-1,r.Bottom-1,nil);
LineTo(DC,r.Right-1,r.Bottom-1);
LineTo(DC,r.Right-1,r.Bottom-AngleSize-1);

SelectObject(DC,opn);
DeleteObject(npn);
end;

function CreatePrObj;
begin
Result     :=ClassRef.Create(Band.Report.prOwner);
Result.Band:=Band;
end;

function CreatePrObjRec;
begin
Result:=ClassRef.Create(EndPage,nil);
end;

procedure DrawRect;
begin
MoveToEx(DC,R.Left,R.Top,nil);
LineTo(DC,R.Right-1,R.Top);
MoveToEx(DC,R.Left,R.Bottom-1,nil);
LineTo(DC,R.Right-1,R.Bottom-1);
MoveToEx(DC,R.Left,R.Top+1,nil);
LineTo(DC,R.Left,R.Bottom-1);
MoveToEx(DC,R.Right-1,R.Top,nil);
LineTo(DC,R.Right-1,R.Bottom);
end;

procedure WriteString(Stream : TStream; s : string);
var
  b : integer;
begin
b:=Length(s);
Stream.Write(b,4);
Stream.Write(s[1],b);
end;

procedure WriteRect(Stream : TStream; r : TRect);
begin
Stream.Write(r.Left,4);
Stream.Write(r.Top,4);
Stream.Write(r.Right,4);
Stream.Write(r.Bottom,4);
end;

function ReadString(Stream : TStream) : string;
var
  b : integer;
begin
Stream.Read(b,4);
SetLength(Result,b);
Stream.Read(Result[1],b);
end;

procedure ReadRect(Stream : TStream; var r : TRect);
begin
Stream.Read(r.Left,4);
Stream.Read(r.Top,4);
Stream.Read(r.Right,4);
Stream.Read(r.Bottom,4);
end;

procedure LoadResImage;
begin
try
  if FindResource(hInstance,PChar('PR_'+ResID),RT_BITMAP)<>0 then
    b.LoadFromResourceName(hInstance,'PR_'+ResID);
except
end;
end;

function GetValidComponentName;
var
  i : integer;
  s : string;
begin
s:=Component.ClassName;
i:=1;
while Component.Owner.FindComponent(Copy(s,2,Length(s))+IntToStr(i))<>nil do Inc(i);
Result:=Copy(s,2,Length(s))+IntToStr(i);
end;

procedure prWriteCompListNames(Writer : TWriter; L : TList);
var
  i : integer;
begin
Writer.WriteListBegin;
for i:=0 to L.Count-1 do
  Writer.WriteString(TComponent(L[i]).Name);
Writer.WriteListEnd;
end;

procedure prReadStringList(Reader : TReader; L : TStrings);
begin
Reader.ReadListBegin;
while not Reader.EndOfList do
  L.Add(Reader.ReadString);
Reader.ReadListEnd;
end;

function Create90Font;
var
  F : TLogFont;
begin
  GetObject(Font.Handle, SizeOf(TLogFont), @F);
  F.lfEscapement  := 900;
  F.lfOrientation := 900;
  Result          := CreateFontIndirect(F);
end;

function CreateAPIFont;
var
  F : TLogFont;
begin
  GetObject(Font.Handle, SizeOf(TLogFont), @F);
  Result:= CreateFontIndirect(F);
end;

function  CreateDefFont;
var
  F : TLogFont;
begin
  SetTextColor(DC,Color);
  ZeroMemory(@F,sizeof(F));
  F.lfHeight  :=-MulDiv(Size, GetDeviceCaps(DC, LOGPIXELSY), 72);
  F.lfFaceName:='Arial';
  F.lfCharSet :=DEFAULT_CHARSET;
  Result      :=CreateFontIndirect(F);
end;

function  Create90DefFont;
var
  F : TLogFont;
begin
  SetTextColor(DC,Color);
  ZeroMemory(@F,sizeof(F));
  F.lfHeight      :=-MulDiv(Size, GetDeviceCaps(DC, LOGPIXELSY), 72);
  F.lfFaceName    :='Arial';
  F.lfCharSet     :=DEFAULT_CHARSET;
  F.lfEscapement  := 900;
  F.lfOrientation := 900;
  Result          :=CreateFontIndirect(F);
end;

///////////////////////////
//
// TprScrollBox
//
///////////////////////////
procedure TprScrollBox.mWM_VSCROLL;
begin
inherited;
if Assigned(OnVScroll) then
  OnVScroll(Self,Msg);
end;

procedure TprScrollBox.mWM_HSCROLL;
begin
inherited;
if Assigned(OnHScroll) then
  OnHScroll(Self,Msg);
end;

/////////////////////////////
//
// TprForm
//
/////////////////////////////
procedure TprForm.AfterConstruction;
var
  Ini : TIniFile;
begin
inherited;
Ini := TIniFile.Create(prIniFileName);
try
  prRestoreProperties(Ini,ClassName);
finally
  Ini.Free;
end;
end;

procedure TprForm.BeforeDestruction;
var
  Ini : TIniFile;
begin
inherited;
Ini := TIniFile.Create(prIniFileName);
try
  prSaveProperties(Ini,ClassName);
finally
  Ini.Free;
end;
end;

procedure TprForm.prRestoreProperties;
var
  ws : TWindowState;
begin
//   
ws := TWindowState(Ini.ReadInteger(sn,'WindowState',integer(wsNormal)));
if ws<>wsMinimized then
  begin
    if ws=wsNormal then
      begin
        Left := Ini.ReadInteger(sn,'Left',Left);
        Top := Ini.ReadInteger(sn,'Top',Top);
        if BorderStyle in [bsSizeToolWin,bsSizeable] then
          begin
            Width := Ini.ReadInteger(sn,'Width',Width);
            Height := Ini.ReadInteger(sn,'Height',Height);
          end
      end
    else
      WindowState := ws;
  end;
end;

procedure TprForm.prSaveProperties;
begin
Ini.WriteInteger(sn,'WindowState',integer(WindowState));
Ini.WriteInteger(sn,'Left',Left);
Ini.WriteInteger(sn,'Top',Top);
if BorderStyle in [bsSizeToolWin,bsSizeable] then
  begin
    Ini.WriteInteger(sn,'Width',Width);
    Ini.WriteInteger(sn,'Height',Height);
  end
end;

/////////////////////////////
//
// TprDesigner
//
/////////////////////////////
constructor TprDesigner.CreateDesigner;
begin
Report              :=_Report;
Report.FDesignerForm:=Self;
inherited Create(AOwner);
end;

procedure TprDesigner.BeforeDestruction;
begin
inherited;
Report.FDesignerForm:=nil;
if Assigned(Report.OnDestroyDesigner) then
  Report.OnDestroyDesigner(Report);
end;

procedure TprDesigner.Loaded;
begin
inherited;
if csDesigning in Report.ComponentState then
  begin
    FormStyle := fsNormal;
    Visible := false;
  end
else
  begin
    if Report.DesignerFormMode=fmNormal then
      begin
        FormStyle := fsNormal;
        Visible := false;
     end;
  end;
end;

procedure TprDesigner.CreateWnd;
begin
if csDesigning in Report.ComponentState then
  begin
    FormStyle := fsNormal;
    Visible := false;
  end
else
  begin
    if Report.DesignerFormMode=fmNormal then
      begin
        FormStyle := fsNormal;
        Visible := false;
      end;
  end;
inherited;
end;

procedure TprDesigner.ConvertToDesignerCoords;
begin
rDest:=rSource;
end;

function TprDesigner.ConvertXToDesignerCoords;
begin
Result:=X;
end;

function TprDesigner.ConvertYToDesignerCoords;
begin
Result:=Y;
end;

procedure TprDesigner.ConvertFromDesignerCoords;
begin
rDest:=rSource;
end;

function TprDesigner.ConvertXFromDesignerCoords;
begin
Result:=X;
end;

function TprDesigner.ConvertYFromDesignerCoords;
begin
Result:=Y;
end;

/////////////////////////////
//
// TprPreview
//
/////////////////////////////
constructor TprPreview.CreatePreview;
begin
Report             :=_Report;
Report.FPreviewForm:=Self;
inherited Create(AOwner);
end;

procedure TprPreview.BeforeDestruction;
begin
inherited;
Report.FPreviewForm:=nil;
if Assigned(Report.OnDestroyPreview) then
  Report.OnDestroyPreview(Report);
end;

procedure TprPreview.Loaded;
begin
inherited;
if csDesigning in Report.ComponentState then
  begin
    FormStyle := fsNormal;
    Visible := false;
  end
else
  begin
    if Report.PreviewFormMode=fmNormal then
      begin
        FormStyle:=fsNormal;
        Visible  :=false;
      end;
  end;
end;

procedure TprPreview.CreateWnd;
begin
if csDesigning in Report.ComponentState then
  begin
    FormStyle := fsNormal;
    Visible := false;
  end
else
  begin
    if Report.PreviewFormMode=fmNormal then
      begin
        FormStyle:=fsNormal;
        Visible  :=false;
      end;
  end;
inherited;
end;

procedure TprPreview.DoOnCustomAction;
begin
if Assigned(Report.OnCustomActionInPreview) then
  Report.OnCustomActionInPreview(Self);
end;

function CreateprPreviewUserData;
var
  PreviewUserDataClass : TPersistentClass;
begin
PreviewUserDataClass := GetClass(ClassName);
if PreviewUserDataClass=nil then
  raise Exception.CreateFmt(prLoadStr(sErrorGetPreviewUserDataClass),[ClassName]);
Result := TprPreviewUserData(PreviewUserDataClass.Create);
end;
       
/////////////////////
//
// TprPreviewUserData
//
/////////////////////
procedure TprPreviewUserData.Assign;
begin
with TprPreviewUserData(Source) do
  begin
    Self.Tag := Tag;
  end;
end;

procedure TprPreviewUserData.SaveToStream;
begin
Stream.Write(Tag,sizeof(Tag));
end;

procedure TprPreviewUserData.LoadFromStream;
begin
Stream.Read(Tag,sizeof(Tag));
end;

/////////////////////
//
// TprObjRecVersion
//
/////////////////////
constructor TprObjRecVersion.Create;
begin
inherited;
FVisible:=true;
end;

procedure TprObjRecVersion.Assign;
begin
with Source as TprObjRecVersion do
  begin
    Self.Formula                        :=Formula;
    Self.Visible                        :=Visible;
    Self.FCompiledFormula               :=FCompiledFormula;
    Self.FMayBeUse                      :=FMayBeUse;
    Self.FSecondPassCalcCurVersionNeeded:=FSecondPassCalcCurVersionNeeded;
  end;
end;

///////////////////////
//
// TprObjRecVersions
//
///////////////////////
function TprObjRecVersions.GetItm;
begin
Result:=TprObjRecVersion(inherited Items[i]);
end;

/////////////////////
//
// TprObjRec
//
/////////////////////
constructor TprObjRec.Create;
begin
inherited Create;
Page := _Page;
Obj := _Obj;
DefVersion := 0;
CurVersion := -1;
FVersions := CreateVersions;
end;

destructor TprObjRec.Destroy;
begin
FVersions.Free;
inherited;
end;

procedure TprObjRec.Save;
var
  Writer : TWriter;
begin
Stream.Write(FDefVersion,4);
WriteRect(Stream,pRect);
Writer := TWriter.Create(Stream,1024);
try
  Writer.WriteCollection(FVersions);
finally
  Writer.Free;
end;
end;

procedure TprObjRec.Load;
var
  Reader : TReader;
begin
Stream.Read(FDefVersion,4);
ReadRect(Stream,pRect);
Reader := TReader.Create(Stream,1024);
try
  Reader.ReadValue;
  Reader.ReadCollection(FVersions);
finally
  Reader.Free;
end;
end;

function TprObjRec.GetLeft;
begin
Result := pRect.Left;
end;

function TprObjRec.GetTop;
begin
Result := pRect.Top;
end;

function TprObjRec.GetRight;
begin
Result := pRect.Right;
end;

function TprObjRec.GetBottom;
begin
Result := pRect.Bottom;
end;

procedure TprObjRec.SetLeft;
begin
pRect.Left := value;
end;

procedure TprObjRec.SetTop;
begin
pRect.Top := value;
end;

procedure TprObjRec.SetRight;
begin
pRect.Right := value;
end;

procedure TprObjRec.SetBottom;
begin
pRect.Bottom := value;
end;

procedure TprObjRec.Assign;
begin
with Source as TprObjRec do
  begin
    Self.pRect := pRect;
    Self.X := X;
    Self.Y := Y;
    Self.DX := DX;
    Self.DY := DY;
    Self.WidthAsVerticalBand := WidthAsVerticalBand;
    Self.HeightAsHorizontalBand := HeightAsHorizontalBand;  
    Self.DefVersion := DefVersion;
    Self.CurVersion := CurVersion;
    Self.FSecondPassCalcCurVersionNeeded := FSecondPassCalcCurVersionNeeded;
    Self.PreviewUserData := PreviewUserData;
    Self.FVersions.Assign(Versions);
  end;
end;

procedure TprObjRec.FirstPassCalcCurVersion;
var
  i : integer;
  p : TprParser;
  Res : TprVarValue;
begin
CurVersion:=DefVersion;

for i:=0 to Versions.Count-1 do
  if i<>DefVersion then
    begin
      //    ,     
      // ,     FCompiledFormula
      p:=TprParser(Obj.Band.Report.FParser);
      Versions[i].FCompiledFormula:=Versions[i].Formula;

      Versions[i].FSecondPassCalcCurVersionNeeded:=not p.Calc(Versions[i].FCompiledFormula,Res);
      if not Versions[i].FSecondPassCalcCurVersionNeeded then
        begin
          Versions[i].FMayBeUse:=_vAsBoolean(Res);
          if CurVersion=DefVersion then
            CurVersion:=i;
        end;
    end;
end;

procedure TprObjRec.SecondPass;
var
  i : integer;
begin
//  
CurVersion:=DefVersion;

for i:=0 to Versions.Count-1 do
  if i<>DefVersion then
    begin
      if Versions[i].FSecondPassCalcCurVersionNeeded then
        begin
          if Obj.Band.Report.Calc(Versions[i].FCompiledFormula) then
            begin
              CurVersion:=i;
              break;
            end;
        end
      else
        if Versions[i].FMayBeUse then
          begin
            CurVersion:=i;
            break;
          end;
    end;
end;

//////////////////
//
// TprObjs
//
//////////////////
function TprObjs.GetItm;
begin
Result:=TprObj(inherited Items[index]);
end;

/////////////////////
//
// TprObj
//
/////////////////////
constructor TprObj.Create;
begin
inherited Create(AOwner);

TopObjs := TprObjs.Create;
LeftObjs := TprObjs.Create;
WidthObjs := TprObjs.Create;
HeightObjs := TprObjs.Create;

TopMode := prlmMaxBottom;
LeftMode := prlmMaxRight;
WidthMode := prrmMaxRight;
HeightMode := prrmMaxBottom;

Name := GetValidComponentName(Self);
PDI := nil;

InitdRec; //  
end;

destructor TprObj.Destroy;
begin
{$IFDEF DEBUG}
WriteToLog('TprObj.Destroy : '+Name);
{$ENDIF}
TopObjs.Free;
LeftObjs.Free;
WidthObjs.Free;
HeightObjs.Free;
FdRec.Free;
aRec.Free;

if PDI<>nil then
  FreeMem(PDI);

{$IFDEF DEBUG}
WriteToLog('TprObj.Destroy : '+Name+' destroyed');
{$ENDIF}
inherited;
end;

procedure TprObj.SetParentComponent;
begin
Band:=Value as TprBand;
end;

function TprObj.GetChildOwner;
begin
Result:=nil;
if Band<>nil then
  Result:=Band.Report;
end;

function TprObj.HasParent;
begin
Result:=true;
end;

function TprObj.GetParentComponent;
begin
Result:=Band;
end;

procedure TprObj.Notification;
begin
{$IFDEF DEBUG}
WriteToLog('TprObj.Notification : '+Name+' '+GetEnumName(TypeInfo(TOperation),integer(Operation))+' AComponent : '+AComponent.Name);
{$ENDIF}
if (Operation=opRemove) and (AComponent<>Self) and (AComponent is TprObj) then
  begin
    TopObjs.Remove(AComponent);
    LeftObjs.Remove(AComponent);
    WidthObjs.Remove(AComponent);
    HeightObjs.Remove(AComponent);
  end;
end;

procedure TprObj.DefineProperties;
begin
inherited;
Filer.DefineProperty('LeftObjs',ReadLeft,WriteLeft,LeftObjs.Count>0);
Filer.DefineProperty('TopObjs',ReadTop,WriteTop,TopObjs.Count>0);
Filer.DefineProperty('WidthObjs',ReadWidth,WriteWidth,WidthObjs.Count>0);
Filer.DefineProperty('HeightObjs',ReadHeight,WriteHeight,HeightObjs.Count>0);
end;

procedure TprObj.ReadLeft;
begin
FLeftObjsNames:=TStringList.Create;
prReadStringList(Reader,FLeftObjsNames);
end;

procedure TprObj.WriteLeft;
begin
prWriteCompListNames(Writer,LeftObjs);
end;

procedure TprObj.ReadTop;
begin
FTopObjsNames:=TStringList.Create;
prReadStringList(Reader,FTopObjsNames);
end;

procedure TprObj.WriteTop;
begin
prWriteCompListNames(Writer,TopObjs);
end;

procedure TprObj.ReadWidth;
begin
FWidthObjsNames:=TStringList.Create;
prReadStringList(Reader,FWidthObjsNames);
end;

procedure TprObj.WriteWidth;
begin
prWriteCompListNames(Writer,WidthObjs);
end;

procedure TprObj.ReadHeight;
begin
FHeightObjsNames:=TStringList.Create;
prReadStringList(Reader,FHeightObjsNames);
end;

procedure TprObj.WriteHeight;
begin
prWriteCompListNames(Writer,HeightObjs);
end;

procedure TprObj.AfterReportLoaded;

  procedure Update(LO : TprObjs; LS : TStrings);
  var
    i : integer;
    c : TComponent;
  begin
  if LS<>nil then
    for i:=0 to LS.Count-1 do
      begin
        c:=Band.Report.FindComponent(LS[i]);
        if c<>nil then
          LO.Add(c);
      end;
  end;

begin
try
  Update(LeftObjs,FLeftObjsNames);
  Update(TopObjs,FTopObjsNames);
  Update(WidthObjs,FWidthObjsNames);
  Update(HeightObjs,FHeightObjsNames);
finally
  FLeftObjsNames.Free;
  FTopObjsNames.Free;
  FWidthObjsNames.Free;
  FHeightObjsNames.Free;

  FLeftObjsNames := nil;
  FTopObjsNames := nil;
  FWidthObjsNames := nil;
  FHeightObjsNames := nil;
end;
end;

procedure TprObj.SetBand;
begin
if FBand=Value then exit;
if FBand<>nil then
  FBand.Objects.Remove(Self);
FBand:=Value;
if (FBand<>nil) and (FBand.Objects.IndexOf(Self)=-1) then
  FBand.Objects.Add(Self);
end;

function TprObj.GetReport;
begin
Result:=nil;
if Band<>nil then
  Result:=Band.Report;
end;

function TprObj.AllowInplaceEdit;
begin
Result:=false;
end;

procedure TprObj.InplaceEdit;
begin
end;

procedure TprObj.SaveInplaceEdit;
begin
end;

function TprObj.GetDesc;
begin
Result:=Name;
end;

procedure TprObj.UpdatePDIdPageRect;
begin
Band.Report.ConvertToDesignerCoords(dRec.pRect,pdi.dPageRect);
pdi.dPageRect.Left  :=pdi.dPageRect.Left  +Band.pdi.dPageRect.Left;
pdi.dPageRect.Top   :=pdi.dPageRect.Top   +Band.pdi.dPageRect.Top;
pdi.dPageRect.Right :=pdi.dPageRect.Right +Band.pdi.dPageRect.Left;
pdi.dPageRect.Bottom:=pdi.dPageRect.Bottom+Band.pdi.dPageRect.Top;
end;

procedure TprObj.UpdatePDI;
begin
if PDI=nil then
  begin
    GetMem(PDI,sizeof(rDesignInfo));
    with PDI^ do
      begin
        AllowResizeTypes :=[ppLeftTop,ppTop,ppRightTop,ppRight,ppRightBottom,ppBottom,ppLeftBottom,ppLeft];
        AllowDrag        :=true;
        AllowLinkTypes   :=[ltLeft,ltTop,ltRight,ltBottom];
        Parent           :=Self;
      end;
  end;
UpdatePDIdPageRect;
end;

procedure TprObj.DesignerResize;
begin
if not RectInRect(Rect(dRec.pRect.Left+oLeft+Band.dPageRect.Left,
                       dRec.pRect.Top+oTop+Band.dPageRect.Top,
                       dRec.pRect.Right+oRight+Band.dPageRect.Left,
                       dRec.pRect.Bottom+oBottom+Band.dPageRect.Top),
                  Band.dPageRect) then exit; //        

dRec.pRect.Top   :=dRec.pRect.Top+oTop;
dRec.pRect.Left  :=dRec.pRect.Left+oLeft;
dRec.pRect.Bottom:=dRec.pRect.Bottom+oBottom;
dRec.pRect.Right :=dRec.pRect.Right+oRight;
UpdatePDIdPageRect;
end;

procedure TprObj.DesignerDrag;
begin
if not RectInRect(Rect(dRec.pRect.Left+dx+Band.dPageRect.Left,
                       dRec.pRect.Top+dy+Band.dPageRect.Top,
                       dRec.pRect.Right+dx+Band.dPageRect.Left,
                       dRec.pRect.Bottom+dy+Band.dPageRect.Top),
                  Band.dPageRect) then exit; //        

dRec.pRect.Top   :=dRec.pRect.Top+dy;
dRec.pRect.Left  :=dRec.pRect.Left+dx;
dRec.pRect.Bottom:=dRec.pRect.Bottom+dy;
dRec.pRect.Right :=dRec.pRect.Right+dx;
UpdatePDIdPageRect;
end;

procedure TprObj.DesignerLink;
begin
if (Linked.Parent is TprObj) and
   (Band=TprObj(Linked.Parent).Band) then
  begin
    case LinkMode of
      ltLeft  : if LeftObjs.IndexOf(Linked.Parent)=-1 then
                  LeftObjs.Add(Linked.Parent);
      ltTop   : if TopObjs.IndexOf(Linked.Parent)=-1 then
                  TopObjs.Add(Linked.Parent);
      ltRight : if WidthObjs.IndexOf(Linked.Parent)=-1 then
                  WidthObjs.Add(Linked.Parent);
      ltBottom: if HeightObjs.IndexOf(Linked.Parent)=-1 then
                  HeightObjs.Add(Linked.Parent);
    end;
    LinkAccepted:=true;
  end;
end;

procedure TprObj.DesignerDelete;
begin
Free;
end;

function TprObj.IsLinkedTo;
begin
Result:=false;
case LinkMode of
  prlLeft  : Result:=LeftObjs.IndexOf(Obj)<>-1;
  prlTop   : Result:=TopObjs.IndexOf(Obj)<>-1;
  prlWidth : Result:=WidthObjs.IndexOf(Obj)<>-1;
  prlHeight: Result:=HeightObjs.IndexOf(Obj)<>-1;
end;
end;

//
//   aRec     
//   DX  DY (       )
//
procedure TprObj.FirstPass;
var
  MinBottomObj,MaxBottomObj,MinRightObj,MaxRightObj : TprObj;

  procedure CalcObjs(o : TprObjs; var MinY,MaxY,MinX,MaxX : TprObj; LinkMode : TprLinkMode);
  var
    i : integer;
    fCrlLink : boolean;
  begin
  if not o[0].FirstPassProcessed then
    o[0].FirstPass;
    
  MinY := o[0];
  MaxY := o[0];
  MinX := o[0];
  MaxX := o[0];
  fCrlLink := o[0].IsLinkedTo(LinkMode,Self);
  for i:=1 to o.Count-1 do
    begin
      if not o[i].FirstPassProcessed then
        o[i].FirstPass;

      fCrlLink:=fCrlLink or o[i].IsLinkedTo(LinkMode,Self);

      if o[i].aRec.Y+o[i].aRec.DY>MaxY.aRec.Y+MaxY.aRec.DY then
        MaxY:=o[i];
      if o[i].aRec.Y+o[i].aRec.DY<MinY.aRec.Y+MinY.aRec.DY then
        MinY:=o[i];
      if o[i].aRec.X+o[i].aRec.DX>MaxX.aRec.X+MaxX.aRec.DX then
        MaxX:=o[i];
      if o[i].aRec.X+o[i].aRec.DX<MinX.aRec.X+MinX.aRec.DX then
        MinX:=o[i];
    end;
    
  if fCrlLink then
    begin
      if Self.aRec.Y+Self.aRec.DY>MaxY.aRec.Y+MaxY.aRec.DY then
        MaxY:=Self;
      if Self.aRec.Y+Self.aRec.DY<MinY.aRec.Y+MinY.aRec.DY then
        MinY:=Self;
      if Self.aRec.X+Self.aRec.DX>MaxX.aRec.X+MaxX.aRec.DX then
        MaxX:=Self;
      if Self.aRec.X+Self.aRec.DX<MinX.aRec.X+MinX.aRec.DX then
        MinX:=Self;
    end;
  end;

begin
if aRec=nil then
  raise Exception.Create(prLoadStr(saRecNotInitializated));
FirstPassProcessed := true;

aRec.X := dRec.pRect.Left;
aRec.Y := dRec.pRect.Top;

//  TopObjs
if TopObjs.Count>0 then
  begin
    CalcObjs(TopObjs,MinBottomObj,MaxBottomObj,MinRightObj,MaxRightObj,prlTop);

    case TopMode of
      prlmMaxBottom:  //    ,     Bottom
        begin
          if MaxBottomObj<>Self then
            aRec.Y:=aRec.Y+(MaxBottomObj.aRec.Y+
                            MaxBottomObj.aRec.DY-
                            MaxBottomObj.dRec.pRect.Bottom);
        end;
      prlmMinBottom:  //    
        begin
          if MinBottomObj<>Self then
            aRec.Y:=aRec.Y+(MinBottomObj.aRec.Y+
                            MinBottomObj.aRec.DY-
                            MinBottomObj.dRec.pRect.Bottom);
        end;
    end;
  end;

//  LeftObjs
if LeftObjs.Count>0 then
  begin
    CalcObjs(LeftObjs,MinBottomObj,MaxBottomObj,MinRightObj,MaxRightObj,prlLeft);

    case LeftMode of
      prlmMaxRight:  //    ,     Right
        begin
          if MaxRightObj<>Self then
            aRec.X:=aRec.X+(MaxRightObj.aRec.X+
                            MaxRightObj.aRec.DX-
                            MaxRightObj.dRec.pRect.Right);
        end;
      prlmMinRight:  //    
        begin
          if MinRightObj<>Self then
            aRec.X:=aRec.X+(MinRightObj.aRec.X+
                            MinRightObj.aRec.DX-
                            MinRightObj.dRec.pRect.Right);
        end;
    end;
  end;

//  WidthObjs
if WidthObjs.Count>0 then
  begin
    CalcObjs(WidthObjs,MinBottomObj,MaxBottomObj,MinRightObj,MaxRightObj,prlWidth);

    case WidthMode of
      prrmMaxRight:  //    ,     Right
        begin
          if MaxRightObj<>Self then
            aRec.DX:=dRec.pRect.Right-
                     dRec.pRect.Left+
                     MaxRightObj.aRec.X+
                     MaxRightObj.aRec.DX-
                     MaxRightObj.dRec.pRect.Right;
        end;
      prrmMinRight:  //    
        begin
          if MinRightObj<>Self then
            aRec.DX:=dRec.pRect.Right-
                     dRec.pRect.Left+
                     MinRightObj.aRec.X+
                     MinRightObj.aRec.DX-
                     MinRightObj.dRec.pRect.Right;
        end;
    end;
  end;


//  HeightObjs
if HeightObjs.Count>0 then
  begin
    CalcObjs(HeightObjs,MinBottomObj,MaxBottomObj,MinRightObj,MaxRightObj,prlHeight);

    case HeightMode of
      prrmMaxBottom:  //    ,     Right
        begin
          if MaxBottomObj<>Self then
            aRec.DY:=dRec.pRect.Bottom-
                     dRec.pRect.Top+
                     MaxBottomObj.aRec.Y+
                     MaxBottomObj.aRec.DY-
                     MaxBottomObj.dRec.pRect.Bottom;
        end;
      prrmMinBottom:  //    
        begin
          if MinBottomObj<>Self then
            aRec.DY:=dRec.pRect.Bottom-
                     dRec.pRect.Top+
                     MinBottomObj.aRec.Y+
                     MinBottomObj.aRec.DY-
                     MinBottomObj.dRec.pRect.Bottom;
        end;
    end;
  end;
Report.DoOnPreviewGetUserData(Self,aRec,aRec.PreviewUserData);
end;

procedure TprObj.DrawDesign;
begin
end;

////////////////////////
//
// TprValueVersion
//
////////////////////////
constructor TprValueVersion.Create;
begin
inherited;
end;

////////////////////////
//
// TprValue
//
////////////////////////
constructor TprValue.Create;
var
  i : integer;
  cn : string;
begin
inherited;
DataSet := TprDatasetLink.Create;
ResetDataSet := TprDatasetLink.Create;
CrossTabHorzDataSet := TprDatasetLink.Create;
SavedIndex := 0;
DataSetName := '';
Group := nil;
FVersions := TList.Create;
FSavedValues := TList.Create;

i := 1;
cn := ClassName;
while Report.Values.IndexByName(Copy(cn,2,Length(cn))+IntToStr(i))<>-1 do Inc(i);
Name := Copy(cn,2,Length(cn))+IntToStr(i);
end;

destructor TprValue.Destroy;
begin
Clear;
Dataset.Free;
ResetDataset.Free;
CrossTabHorzDataset.Free;
FSavedValues.Free;
FVersions.Free;
inherited;
end;

function TprValue.Report;
begin
Result := TprValues(Collection).Report;
end;

procedure TprValue.SetName;
begin
if CompText(Value,Name)=0 then
  exit;
if Report.Values.IndexByName(Value)<>-1 then
  raise Exception.CreateFmt(prLoadStr(sVarAlreadyExists),[Value,Report.Name]);
FName := Value;
end;

procedure TprValue.SetFormula;

  function CheckFunction(const FuncName : string; AggFunction : TprAggFunction) : boolean;
  var
    b : string;
  begin
  Result := false;
  if AnsiCompareText(Copy(Value,1,Length(FuncName)),FuncName)<>0 then exit;
  b := Trim(Copy(Value,Length(FuncName)+1,Length(Value)));
  FFormula := Copy(b,2,Length(b)-2);
  FAggFunction := AggFunction;
  Result := true;
  end;

begin
Value := Trim(Value);
if CheckFunction('AggSum',prafSum) then exit;
if CheckFunction('AggCount',prafCount) then exit;
if CheckFunction('AggAvg',prafAvg) then exit;
if CheckFunction('AggMin',prafMin) then exit;
if CheckFunction('AggMax',prafMax) then exit;
FFormula := Value;
end;

function TprValue.GetVersion;
begin
Result := TprValueVersion(FVersions[index]);
end;

function TprValue.VersionsCount;
begin
Result := FVersions.Count;
end;

function TprValue.GetCurrentVersionID;
begin
if CalcOn=cvtCrossTab then
  begin
    Result := Format('%s_%d',[Name,Report.GetDataSetRecNo(CrossTabHorzDataSet.Dataset)+SavedIndex-1])
  end
else
  begin
    if FCurrentValueExists then
      Result := Format('%s_%d',[Name,FVersions.Count-1])
    else
      Result := Format('%s_%d',[Name,FVersions.Count])
  end;
end;

procedure TprValue.SetCurrentValue;
var
  ver : TprValueVersion;
begin
if CalcOn=cvtCrossTab then
  begin
    if Report.GetDataSetRecNo(CrossTabHorzDataSet)+SavedIndex-1<VersionsCount then
      Versions[Report.GetDataSetRecNo(CrossTabHorzDataSet)+SavedIndex-1].V:=Value
    else
      begin
        ver := TprValueVersion.Create;
        ver.Value := Self;
        ver.ID := FVersions.Count;
        ver.V := Value;
        FVersions.Add(ver);
      end;
  end
else
  begin
    if FCurrentValueExists then
      Versions[FVersions.Count-1].V := Value
    else
      begin
        ver :=TprValueVersion.Create;
        ver.Value := Self;
        ver.ID := FVersions.Count;
        ver.V := Value;
        FVersions.Add(ver);
        FCurrentValueExists := true;
      end;
  end;
end;

function TprValue.GetCurrentVersion : TprValueVersion;
var
  fCreated : boolean;
begin
Result := GetCurrentVersion(fCreated);
end;

function TprValue.GetCurrentVersion(var fCreated : boolean) : TprValueVersion;
begin
fCreated := false;
if CalcOn=cvtCrossTab then
  begin
    if Report.GetDataSetRecNo(CrossTabHorzDataSet.Dataset)+SavedIndex-1<VersionsCount then
      Result := Versions[Report.GetDataSetRecNo(CrossTabHorzDataSet.Dataset)+SavedIndex-1]
    else
      begin
        Result := TprValueVersion.Create;
        fCreated := true;
        FVersions.Add(Result);
      end;
  end
else
  begin
    if FCurrentValueExists then
      Result := Versions[FVersions.Count-1]
    else
      begin
        Result := TprValueVersion.Create;
        fCreated := true;
        FVersions.Add(Result);
        FCurrentValueExists := true;
      end;
  end;
end;

procedure TprValue.Reset;
var
  v : TprValueVersion;
  fCreated : boolean;
begin
v := GetCurrentVersion(fCreated);
if fCreated then
  begin
    v.V := UnAssigned;
    v.V1 := UnAssigned;
  end;

case CalcOn of
  cvtEventOnReset:
    begin
      if Assigned(OnCalc) then
        OnCalc(Self)
      else
        raise Exception.CreateFmt(prLoadStr(sReportVarNotCalced),[Name]);
    end;
  cvtCrossTab:
    begin
      SavedIndex := VersionsCount;
    end
  else
    begin
      FCurrentValueExists := false;
    end
end;
end;

procedure TprValue.Init;
  procedure GetDataSet(DataSet : TprDatasetLink; DataSetName : string);
  begin
  Dataset.Dataset:=Report.GetDataSetByName(DataSetName);
  if DataSet.Dataset=nil then
    raise Exception.CreateFmt(prLoadStr(sDataSetNotFound),[DataSetName]);
  end;
begin
if CalcOn in [cvtDataSetNext,cvtCrossTab] then
  GetDataSet(DataSet,DataSetName);
if ResetOn in [rvtDataSetEof] then
  GetDataSet(ResetDataSet,ResetDataSetName);
if CalcOn  in [cvtCrossTab] then
  GetDataSet(CrossTabHorzDataSet,CrossTabHorzDataSetName);
end;

procedure TprValue.Clear;
begin
FCurrentValueExists := false;
SavedIndex := 0;
while FVersions.Count>0 do
  begin
    Versions[0].Free;
    FVersions.Delete(0);
  end;
while FSavedValues.Count>0 do
  begin
    FreeMem(FSavedValues[0]);
    FSavedValues.Delete(0);
  end;
end;

function TprValue.AddSavedValue;
begin
Result := TprSavedValue.Create;
FSavedValues.Add(Result);
end;

procedure TprValue.InternalCalcValue;
begin
case AggFunction of
  prafSum:
    if v.vType in [prvvtInteger,prvvtDouble] then
      begin
        if VarIsEmpty(ver.V) then
          ver.V := _vAsVariant(v)
        else
          ver.V := ver.V+_vAsVariant(v);
      end;
  prafCount:
    begin
      if VarIsEmpty(ver.V) then
        ver.V := 1
      else
        ver.V := ver.V+1;
    end;
  prafAvg:
    if v.vType in [prvvtInteger,prvvtDouble] then
      begin
        if VarIsEmpty(ver.V) then
          begin
            ver.V1 := _vAsVariant(v);
            ver.V2 := 1;
            ver.V := _vAsVariant(v);
          end
        else
          begin
            ver.V1 := ver.V1+_vAsVariant(v);
            ver.V2 := ver.V2+1;
            ver.V := ver.V1 / ver.V2;
          end;
      end;
  prafMin:
    if v.vType in [prvvtInteger,prvvtDouble,prvvtDateTime,prvvtString] then
      begin
        if VarIsEmpty(ver.V) then
          ver.V := _vAsVariant(v)
        else
          if ver.V>_vAsVariant(v) then
            ver.V := _vAsVariant(v);
      end;
  prafMax:
    if v.vType in [prvvtInteger,prvvtDouble,prvvtDateTime,prvvtString] then
      begin
        if VarIsEmpty(ver.V) then
          ver.V := _vAsVariant(v)
        else
          if ver.V<_vAsVariant(v) then
            ver.V := _vAsVariant(v);
      end;
end;
end;

procedure TprValue.Calculate;
var
  s : string;
  v : TprVarValue;
  sv : TprSavedValue;
begin
if FFormula<>'' then
  begin
    s := FFormula;
    if not TprParser(Report.Parser).Calc(s,v) then
      raise Exception.Create(prLoadStr(sErrorCalcExpressionInOnePass));
  end
else
  _vSetNull(v);

if ResetOn=rvtPage then
  begin
    sv := AddSavedValue;
    sv.Cell := Cell;
    _vCopy(v,sv.v);
  end
else
  begin
    InternalCalcValue(GetCurrentVersion,v);
  end;
end;

function TprValue.VersionByVersionID;
var
  i : integer;
  sv : TprSavedValue;
begin
if ID<VersionsCount then
  begin
    Result := Versions[ID];
    if ResetOn=rvtPage then
      begin
        //   CurEndPage, FSavedValues    
        Result.V := UnAssigned;
        Result.V1 := UnAssigned;
        for i:=0 to FSavedValues.Count-1 do
          begin
            sv := TprSavedValue(FSavedValues[i]);
            if (sv.Cell<>nil) and (sv.Cell.Page<>nil) and (sv.Cell.Page=Report.CurEndPage) then
              InternalCalcValue(Result,sv.V);
          end;
      end;
    if Assigned(OnGetVersionByVersionID) then
      OnGetVersionByVersionID(Result);
  end
else
  raise Exception.CreateFmt(prLoadStr(sNoVarVersion),[Name,ID]);
end;

/////////////////////////
//
// TprValues
//
/////////////////////////
function TprValues.GetItm;
begin
Result := TprValue(inherited Items[index]);
end;

function TprValues.GetByName;
var
  i : integer;
begin
i := IndexByName(Name);
if i=-1 then
  raise Exception.CreateFmt(prLoadStr(sVarNotExists),[Name])
else
  Result := Items[i];
end;

function TprValues.IndexByName;
begin
Result := 0;
while (Result<Count) and
      (CompText(Items[Result].Name,Name)<>0) do Inc(Result);
if Result>=Count then
  Result := -1;
end;

function TprValues.VersionByVersionId;
var
  name : string;
  p,ind : integer;
begin
Result := nil;
p := PosLastChar(id,'_');
if p<>0 then
  begin
    ind := StrToIntDef(Copy(id,p+1,length(id)),-1);
    if Ind<>-1 then
      begin
        name := Copy(id,1,p-1);
        p := IndexByName(name);
        if p<>-1 then
          Result := Items[p].VersionByVersionID(ind)
        else
          raise Exception.CreateFmt(prLoadStr(sNoVarVersion),[Name,ind]);
      end;
  end;
end;

/////////////////////////
//
// TprGroup
//
/////////////////////////
constructor TprGroup.Create;
begin
inherited;

Headers   :=TprBands.Create;
Footers   :=TprBands.Create;
FPrevValue:=Unassigned;
Name      :=GetValidComponentName(Self);
end;

destructor TprGroup.Destroy;
begin
Headers.Free;
Footers.Free;
Report:=nil;

inherited;
end;

procedure TprGroup.Notification;
begin
inherited;
if AOperation=opRemove then
  begin
    if AComponent=FDetailBand then
      FDetailBand := nil;
    Headers.Remove(AComponent);
    Footers.Remove(AComponent);
  end;
end;

function TprGroup.GetChildOwner;
begin
Result:=Report;
end;

procedure TprGroup.SetParentComponent;
begin
Report:=Value as TprCustomReport;
end;

function TprGroup.HasParent;
begin
Result:=true;
end;

function TprGroup.GetParentComponent;
begin
Result:=Report;
end;

procedure TprGroup.SetReport;
begin
if FReport=Value then exit;
if FReport<>nil then
  FReport.Groups.Remove(Self);
FReport:=Value;
if (FReport<>nil) and (FReport.Groups.IndexOf(Self)=-1) then
  FReport.Groups.Add(Self);
end;

procedure TprGroup.SetDetailBand;
begin
if Value=FDetailBand then exit;
if FDetailBand<>nil then
  FDetailBand.GroupRemoved(Self);
FDetailBand:=Value;
if FDetailBand<>nil then
  FDetailBand.GroupAdded(Self);
end;

function TprGroup.IndexInReport;
begin
Result:=Report.Groups.IndexOf(Self);
end;

procedure TprGroup.Reset;
begin
FLineNo := 0;
FPrevValue := Unassigned;
end;

procedure TprGroup.CalcValue;
var
  CurValue : Variant;
begin
FLineNo := FLineNo+1;
CurValue := Report.Calc(FValid);
FNeedHeaders := VarIsEmpty(FPrevValue) or (FPrevValue<>CurValue);
FNeedFooters := not VarIsEmpty(FPrevValue) and (FPrevValue<>CurValue);
if FNeedFooters then
  FLineNo := 1;
FPrevValue := CurValue;
end;

procedure TprGroup.HeadersGenerateCell;
var
  i : integer;
begin
if FNeedHeaders then
  //   
  for i:=0 to Headers.Count-1 do
    Headers[i].GenerateCell(CallerBand,CallbackProc,false);
end;

procedure TprGroup.FootersGenerateCell;
var
  i : integer;
begin
if FNeedFooters then
  begin
    //   
    for i:=0 to Footers.Count-1 do
      Footers[i].GenerateCell(CallerBand,CallbackProc,false);
    Report.DoOnGroupEnd(Self);
  end;
end;

procedure TprGroup.FootersAlwaysGenerateCell;
var
  i : integer;
begin
//   
for i:=0 to Footers.Count-1 do
  Footers[i].GenerateCell(CallerBand,CallbackProc,false);
Report.DoOnGroupEnd(Self);
end;

///////////////////////////////
//
// TprGenCell
//
///////////////////////////////
constructor TprGenCell.Create;
begin
inherited;
FObjRecs := TList.Create;
end;

destructor TprGenCell.Destroy;
var
  i : integer;
begin
for i:=0 to FObjRecs.Count-1 do
  ObjRecs[i].Free;
FObjRecs.Free;
inherited;
end;

procedure TprGenCell.Add;
begin
FObjRecs.Add(ObjRec);
end;

function TprGenCell.GetObjRec;
begin
Result := TprObjRec(FObjRecs[i]);
end;

function TprGenCell.ObjRecsCount;
begin
Result := FObjRecs.Count;
end;

///////////////////////////////
//
// TprGenVector
//
///////////////////////////////
constructor TprGenVector.Create;
begin
inherited Create;
Band:=_Band;
end;

procedure TprGenVector.AddCell;
begin
inherited Add(Cell);
end;

function TprGenVector.GetItm;
begin
Result:=TprGenCell(inherited Items[i]);
end;

///////////////////////////////
//
// TprGenGrid
//
///////////////////////////////
constructor TprGenGrid.Create;
begin
inherited Create;
FCurVVectorIndex := -1;
Page := _Page;
FCells := TList.Create;
FVVectors := TList.Create;
FHVectors := TList.Create;
FInsertedVectors := TList.Create;
FHPageHeaderCells := TList.Create;
FHPageFooterCells := TList.Create;
FVPageHeaderCells := TList.Create;
FVPageFooterCells := TList.Create;
end;

destructor TprGenGrid.Destroy;
begin
Clear;
FCells.Free;
FVVectors.Free;
FHVectors.Free;
FInsertedVectors.Free;
FHPageHeaderCells.Free;
FHPageFooterCells.Free;
FVPageHeaderCells.Free;
FVPageFooterCells.Free;
inherited;
end;

procedure TprGenGrid.Clear;

  procedure FreeVectorsList(L : TList);
  begin
  while L.Count>0 do
    begin
      TprGenVector(L[0]).Free;
      L.Delete(0);
    end;
  end;

  procedure FreeCellsList(L : TList);
  begin
  while L.Count>0 do
    begin
      TprGenCell(L[0]).Free;
      L.Delete(0);
    end;
  end;

begin
FProgressUpdateCounter := 1;
FCurHVector := nil;
FCurVVectorIndex := -1;
if hTitleCell<>nil then
  begin
    hTitleCell.Free;
    hTitleCell := nil;
  end;
if vTitleCell<>nil then
  begin
    vTitleCell.Free;
    vTitleCell := nil;
  end;
if hSummaryCell<>nil then
  begin
    hSummaryCell.Free;
    hSummaryCell := nil;
  end;
if vSummaryCell<>nil then
  begin
    vSummaryCell.Free;
    vSummaryCell := nil;
  end;
FreeVectorsList(FVVectors);
FreeVectorsList(FHVectors);
FreeVectorsList(FInsertedVectors);
FreeCellsList(FCells);
FreeCellsList(FHPageHeaderCells);
FreeCellsList(FHPageFooterCells);
FreeCellsList(FVPageHeaderCells);
FreeCellsList(FVPageFooterCells);
end;

function TprGenGrid.AddCellSimple;
begin
Result := TprGenCell.Create;
FCells.Add(Result);
end;

procedure TprGenGrid.AddHPageHeaderCell;
begin
FHPageHeaderCells.Add(_Cell);
end;

procedure TprGenGrid.AddHPageFooterCell;
begin
FHPageFooterCells.Add(_Cell);
end;

procedure TprGenGrid.AddVPageHeaderCell;
begin
FVPageHeaderCells.Add(_Cell);
end;

procedure TprGenGrid.AddVPageFooterCell;
begin
FVPageFooterCells.Add(_Cell);
end;

function TprGenGrid.AddCell;
const
  GenGridUpdateCounter = 100;
begin
Result := TprGenCell.Create;
FCells.Add(Result);
if _HBand<>nil then
  begin
    if FCurHVector=nil then
      begin
        FCurHVector:=TprGenVector.Create(_HBand);
        FHVectors.Add(FCurHVector);
      end;
  end;

if _VBand<>nil then
  begin
    Inc(FCurVVectorIndex);
    if FCurVVectorIndex>=VVectorsCount then
      FVVectors.Add(TprGenVector.Create(_VBand));
  end;

if (_HBand<>nil) and (FCurHVector<>nil) then
  begin
    Result.HVector:=FCurHVector;
    FCurHVector.AddCell(Result);
  end;
if (FCurVVectorIndex>=0) and (FCurVVectorIndex<VVectorsCount) then
  begin
    Result.VVector:=VVectors[FCurVVectorIndex];
    Result.VVector.AddCell(Result);
  end;

Dec(FProgressUpdateCounter);
if FProgressUpdateCounter=0 then
  begin
    Page.Report.UpdateProgressForm(Format(prLoadStr(sFirstPassCaption),[HVectorsCount,VVectorsCount,CellsCount]));
    FProgressUpdateCounter := GenGridUpdateCounter;
  end;
end;

procedure TprGenGrid.EndOfLine;
begin
FCurHVector := nil;
FCurVVectorIndex := -1;
end;

function TprGenGrid.VVectorsCount;
begin
Result := FVVectors.Count;
end;

function TprGenGrid.HVectorsCount;
begin
Result := FHVectors.Count;
end;

function TprGenGrid.CellsCount;
begin
Result := FCells.Count;
end;

function TprGenGrid.HPageHeaderCellsCount;
begin
Result := FHPageHeaderCells.Count;
end;

function TprGenGrid.HPageFooterCellsCount;
begin
Result := FHPageFooterCells.Count;
end;

function TprGenGrid.VPageHeaderCellsCount;
begin
Result := FVPageHeaderCells.Count;
end;

function TprGenGrid.VPageFooterCellsCount;
begin
Result := FVPageFooterCells.Count;
end;

function TprGenGrid.GetVVector;
begin
Result := TprGenVector(FVVectors[i]);
end;

function TprGenGrid.GetHVector;
begin
Result := TprGenVector(FHVectors[i]);
end;

function TprGenGrid.GetCell;
begin
Result := TprGenCell(FCells[i]);
end;

function TprGenGrid.GetHPageHeaderCell;
begin
Result := TprGenCell(FHPageHeaderCells[i]);
end;

function TprGenGrid.GetHPageFooterCell;
begin
Result := TprGenCell(FHPageFooterCells[i]);
end;

function TprGenGrid.GetVPageHeaderCell;
begin
Result := TprGenCell(FVPageHeaderCells[i]);
end;

function TprGenGrid.GetVPageFooterCell;
begin
Result := TprGenCell(FVPageFooterCells[i]);
end;

function TprGenGrid.FindPriorVVector;
var
  i : integer;
begin
i:=FromIndex-1;
while (i>=MinEndPageIndex) and (VVectors[i].Band<>Band) do Dec(i);
if i<MinEndPageIndex then
  Result:=nil
else
  Result:=VVectors[i];
end;

function TprGenGrid.FindPriorVVectorOnPage;
var
  i : integer;
begin
i:=FromIndex-1;
while (i>=0) and (VVectors[i].Page>=EndPagePageX) and (VVectors[i].Band<>Band) do Dec(i);
if (i>=0) and (VVectors[i].Page=EndPagePageX) and (VVectors[i].Band=Band) then
  Result:=VVectors[i]
else
  Result:=nil;
end;

//   SourceVector    
//   Index
function TprGenGrid.CopyVVector;
var
  i,j : integer;
  Cell : TprGenCell;
begin
Result := TprGenVector.Create(SourceVector.Band);
Result.Width := SourceVector.Width;
Result.Height := SourceVector.Height;
for i:=0 to SourceVector.Count-1 do
  begin
    Cell := AddCellSimple;
    Cell.Height := SourceVector[i].Height;
    Cell.Width := SourceVector[i].Width;
    Cell.VVector := Result;
    Cell.HVector := SourceVector[i].HVector;

    for j:=0 to SourceVector[i].ObjRecsCount-1 do
      Cell.Add(SourceVector[i].ObjRecs[j].CreateCopy);

    Result.AddCell(Cell);
  end;
FInsertedVectors.Add(Result);
end;

function TprGenGrid.IndexOfVVector;
begin
Result := FVVectors.IndexOf(Vector);
end;

function TprGenGrid.FindPriorHVector;
var
  i : integer;
begin
i:=FromIndex-1;
while (i>=MinEndPageIndex) and (HVectors[i].Band<>Band) do Dec(i);
if i<MinEndPageIndex then
  Result:=nil
else
  Result:=HVectors[i];
end;

function TprGenGrid.FindPriorHVectorOnPage;
var
  i : integer;
begin
i:=FromIndex-1;
while (i>=0) and (HVectors[i].Page>=EndPagePageY) and (HVectors[i].Band<>Band) do Dec(i);
if (i>=0) and (HVectors[i].Page=EndPagePageY) and (HVectors[i].Band=Band) then
  Result:=HVectors[i]
else
  Result:=nil;
end;

//   SourceVector    
//   Index
function TprGenGrid.CopyHVector;
var
  i,j : integer;
  Cell : TprGenCell;
begin
Result := TprGenVector.Create(SourceVector.Band);
Result.Width := SourceVector.Width;
Result.Height := SourceVector.Height;
for i:=0 to SourceVector.Count-1 do
  begin
    Cell := AddCellSimple;
    Cell.Height := SourceVector[i].Height;
    Cell.Width := SourceVector[i].Width;
    Cell.HVector := Result;
    Cell.VVector := SourceVector[i].VVector;

    for j:=0 to SourceVector[i].ObjRecsCount-1 do
      Cell.Add(SourceVector[i].ObjRecs[j].CreateCopy);

    Result.AddCell(Cell);
  end;
FInsertedVectors.Add(Result);
end;

function TprGenGrid.IndexOfHVector;
begin
Result := FHVectors.IndexOf(Vector);
end;


/////////////////////////
//
// TprGroups
//
/////////////////////////
function TprGroups.GetItm;
begin
Result:=TprGroup(inherited Items[index]);
end;

function TprGroups.GetByName;
var
  i : integer;
begin
i:=IndexByName(Name);
if i=-1 then
  raise Exception.CreateFmt(prLoadStr(sGroupNotExists),[name])
else
  result:=Items[i];
end;

function TprGroups.IndexByName;
begin
Result:=0;
while (Result<Count) and (CompText(Items[Result].Name,Name)<>0) do Inc(Result);
if Result>=Count then
  Result:=-1;
end;

///////////////////////
//
// TprBand
//
///////////////////////
constructor TprBand.Create;
var
  i : integer;
  ClassRef: TClass;
begin
{$IFDEF DEBUG}
if AOwner=nil then
  WriteToLog('TprBand.Create : AOwner : nil')
else
  WriteToLog('TprBand.Create : AOwner : '+AOwner.Name);
{$ENDIF}

inherited Create(AOwner);

FVisible  :=true;
PDI       :=nil;
ResizeMode:=prbrmNone;
ResizeObjs:=TprObjs.Create;
Objects   :=TprObjs.Create;


ClassRef := ClassType;
while ClassRef<>nil do
  begin
    i:=GetEnumValue(TypeInfo(TprBandType),'bt'+Copy(ClassRef.ClassName,10,Length(ClassRef.ClassName)-13));
    if i<>-1 then
      begin
        BandType:=TprBandType(i);
        break;
      end;
    ClassRef:=ClassRef.ClassParent;
  end;

Name:=GetValidComponentName(Self);
end;

destructor TprBand.Destroy;
begin
{$IFDEF DEBUG}
WriteToLog('TprBand.Destroy : '+Name);
{$ENDIF}
if PDI<>nil then
  FreeMem(PDI);
while Objects.Count>0 do
  Objects[0].Free;

Objects.Free;
ResizeObjs.Free;

{$IFDEF DEBUG}
WriteToLog('TprBand.Destroy : '+Name+' destroyed');
{$ENDIF}
inherited;
end;

function TprBand.GetChildOwner;
begin
Result:=Report;
end;

procedure TprBand.SetParentComponent;
begin
Page:=Value as TprCustomPage;
end;

function TprBand.HasParent;
begin
Result:=true;
end;

function TprBand.GetParentComponent;
begin
Result:=Page;
end;

procedure TprBand.GetChildren;
var
  i : integer;
begin
for i:=0 to Objects.Count-1 do
  Proc(Objects[i]);
end;

procedure TprBand.Notification;
begin
{$IFDEF DEBUG}
if Owner=nil then
  WriteToLog('TprBand.Notification : '+Name+' '+GetEnumName(TypeInfo(TOperation),integer(Operation))+' AComponent : '+AComponent.Name+' Owner : nil')
else
  WriteToLog('TprBand.Notification : '+Name+' '+GetEnumName(TypeInfo(TOperation),integer(Operation))+' AComponent : '+AComponent.Name+' Owner : '+Owner.Name);
{$ENDIF}
if (Operation = opRemove) and (AComponent<>Self) and (AComponent is TprObj) then
  begin
    Objects.Remove(AComponent);
    ResizeObjs.Remove(AComponent);
  end;
end;

procedure TprBand.DefineProperties;
begin
inherited;
Filer.DefineProperty('ResizeObjs',ReadResizeObjs,WriteResizeObjs,ResizeObjs.Count>0);
end;

procedure TprBand.ReadResizeObjs;
begin
FResizeObjsNames:=TStringList.Create;
prReadStringList(Reader,FResizeObjsNames);
end;

procedure TprBand.WriteResizeObjs;
begin
prWriteCompListNames(Writer,ResizeObjs);
end;

procedure TprBand.GroupRemoved;
begin
end;

procedure TprBand.GroupAdded;
begin
end;

procedure TprBand.AfterReportLoaded;
var
  i,j : integer;
begin
if FResizeObjsNames<>nil then
  begin
    for i:=0 to FResizeObjsNames.Count-1 do
      begin
        j:=0;
        while (j<Objects.Count) and (CompText(Objects[j].Name,FResizeObjsNames[i])<>0) do Inc(j);
        if j<Objects.Count then
          ResizeObjs.Add(Objects[j]);
      end;
    FResizeObjsNames.Free;
  end;
end;

procedure TprBand.SetPage;
begin
if FPage=Value then exit;
if FPage<>nil then
  Page.Bands.Remove(Self);
FPage:=Value;
if (FPage<>nil) and (FPage.Bands.IndexOf(Self)=-1) then
  FPage.Bands.Add(Self);
end;

function TprBand.GetFullBandName;
begin
Result:=Name;
end;

function TprBand.Report;
begin
Result:=nil;
if Page<>nil then
  Result:=Page.Report;
end;

procedure TprBand.InitDataset;
begin
end;

//  , ,     
//   
function TprBand.GetDrawDesignCaption;
begin
Result:=BandTitles[BandType];
end;

//      ,
//   Exception    
procedure TprBand.OnInsertIntoPage;
begin
if p.Bands.IndexByBandType(BandType)<>-1 then
  raise Exception.CreateFmt(prLoadStr(sBandAlreadyExistsInPageType),[GetDrawDesignCaption]);
end;

//  PDI
procedure TprBand.UpdatePDI;
begin
if PDI=nil then
  begin
    GetMem(PDI,sizeof(rDesignInfo));
    with PDI^ do
      begin
        if BandType in HorizontalBands then
          AllowResizeTypes:=[ppTop,ppBottom]
        else
          AllowResizeTypes:=[ppLeft,ppRight];
        AllowDrag        :=false;
        AllowLinkTypes   :=[ltBottom];
        Parent           :=Self;
      end;
  end;
Report.ConvertToDesignerCoords(dPageRect,PDI.dPageRect);
end;

procedure TprBand.DesignerResize;
begin
end;

procedure TprBand.DesignerLink;
begin
end;

procedure TprBand.DesignerDelete;
begin
Free;
end;

function TprBand.GetStartNewPage;
begin
Result:=false;
end;

function TprBand.GetLinkToBand;
begin
Result:=nil;
end;

function TprBand.GetLinkType;
begin
Result:=prltAfter;
end;

//////////////////////////
//
// TprBands
//
//////////////////////////
function TprBands.GetItm;
begin
Result:=TprBand(inherited Items[index]);
end;

function TprBands.GetByBandType;
var
  i : integer;
begin
i:=IndexByBandType(BandType);
if i=-1 then
  raise Exception.CreateFmt(prLoadStr(sUnknownBandType),[GetEnumName(TypeInfo(TprBandType),integer(BandType))])
else
  Result:=Items[i];
end;

function TprBands.GetByName;
var
  i : integer;
begin
i:=IndexByName(Name);
if i=-1 then
  raise Exception.CreateFmt(prLoadStr(sUnknownBandName),[Name])
else
  Result:=Items[i];
end;

function TprBands.IndexByBandType;
begin
Result:=0;
while (Result<Count) and (Items[Result].BandType<>BandType) do Inc(Result);
if Result>=Count then
  Result:=-1;
end;

function TprBands.IndexByName;
begin
Result:=0;
while (Result<Count) and (CompText(Items[Result].Name,Name)<>0) do Inc(Result);
if Result>=Count then
  Result:=-1;
end;

/////////////////////////////
//
// TprCustomHBand
//
/////////////////////////////
constructor TprCustomHBand.Create;
begin
inherited;
end;

procedure TprCustomHBand.CalcdPageRect;
begin
if FCalced then exit;
dPageRect      :=Rect(CurPageRect.Left,CurPageRect.Top,CurPageRect.Right,CurPageRect.Top+Height);
CurPageRect.Top:=CurPageRect.Top+Height;
FCalced        :=true;
end;

procedure TprCustomHBand.DesignerResize;
begin
Height:=dPageRect.Bottom+oBottom-dPageRect.Top-oTop;
Report.ConvertToDesignerCoords(dPageRect,PDI.dPageRect);
end;

procedure TprCustomHBand.DesignerLink;
begin
if (Linked.Parent is TprObj) and
   (Self=TprObj(Linked.Parent).Band) then
  begin
    case LinkMode of
      ltBottom : if ResizeObjs.IndexOf(Linked.Parent)=-1 then
                   ResizeObjs.Add(Linked.Parent);
    end;
    LinkAccepted:=true;
  end;
end;

//
//
//
function TprCustomHBand.GenerateCell;
var
  i : integer;
  o : TprObjRec;
  MinObj,MaxObj : TprObj;
begin
Report.DoOnBandGenerateCell(Self);
Result := nil;
if not Visible then exit;
if Page.HasVerticalBands and UseVerticalBands then
  begin
    //     
    for i:=0 to Page.Bands.Count-1 do
      if Page.Bands[i].BandType in VerticalBands then
        Page.Bands[i].InitDataSet;

    //      Detail  ,
    //  ,        
    //   Detail
    for i:=0 to Page.Bands.Count-1 do
      if (Page.Bands[i].BandType=btvDetail) and (TprCustomVDetailBand(Page.Bands[i]).ParentDetail=nil) then
        TprCustomVBand(Page.Bands[i]).GenerateCell(Self,GenerateCellCallback,false);

    //  
    i:=Page.Bands.IndexByBandType(btvSummary);
    if i<>-1 then
      Page.Bands[i].GenerateCell(nil,nil,false);
  end
else
  begin
    //     ,
    //   ,    
    if fSimpleCreateCell then
      Result := TprGenCell.Create
    else
      Result := Page.Grid.AddCell(Self,nil);

    try
      //    
      for i:=0 to Objects.Count-1 do
        Objects[i].FirstPassProcessed:=false;

      //     aRec.X,Y,DX,DY
      for i:=0 to Objects.Count-1 do
        Objects[i].FirstPass;

      //   Band, ..  Cell
      Result.Height:=Height;
      case ResizeMode of
        prbrmMaxObj:
          begin
            //      Band
            if Objects.Count>0 then
              begin
                Result.Height:=Objects[0].aRec.Y+Objects[0].aRec.DY;
                for i:=1 to Objects.Count-1 do
                  if (Objects[i].aRec.Y+Objects[i].aRec.DY)>Result.Height then
                    Result.Height:=Objects[i].aRec.Y+Objects[i].aRec.DY;
              end
          end;
        prbrmMaxResizeObj,prbrmMinResizeObj:
          begin
            if ResizeObjs.Count>0 then
              begin
                MinObj:=ResizeObjs[0];
                MaxObj:=ResizeObjs[0];
                for i:=1 to ResizeObjs.Count-1 do
                  begin
                    if ResizeObjs[i].aRec.Y+ResizeObjs[i].aRec.DY>MaxObj.aRec.Y+MaxObj.aRec.DY then
                      MaxObj:=ResizeObjs[i];
                    if ResizeObjs[i].aRec.Y+ResizeObjs[i].aRec.DY<MaxObj.aRec.Y+MaxObj.aRec.DY then
                      MinObj:=ResizeObjs[i];
                  end;

                if ResizeMode=prbrmMaxResizeObj then
                  Result.Height:=Height+(MaxObj.aRec.Y+MaxObj.aRec.DY-MaxObj.dRec.pRect.Bottom)
                else
                  Result.Height:=Height+(MinObj.aRec.Y+MinObj.aRec.DY-MinObj.dRec.pRect.Bottom);
              end;
          end;
      end;

      //    Cell
      for i:=0 to Objects.Count-1 do
        begin
          o := Objects[i].aRec.CreateCopy;
          o.Page := nil;
          o.Obj := Objects[i];
          o.pRect.Left := o.X;
          o.pRect.Right := o.X+o.DX;
          o.pRect.Top := o.Y;
          o.pRect.Bottom := o.Y+o.DY;
          Result.Add(o);
        end;
    except
      if fSimpleCreateCell then
        Result.Free;
      raise;
    end;
  end;
Page.Grid.EndOfLine;
end;

procedure TprCustomHBand.GenerateCellCallback;
var
  i : integer;
  Obj,MinObj,MaxObj : TprObj;
begin
//   Band, ..  Cell
Cell.Height:=Height;
case ResizeMode of
  prbrmMaxObj:
    begin
      //      Band
      if Objects.Count>0 then
        begin
          Cell.Height:=Objects[0].aRec.Y+Objects[0].aRec.DY;
          for i:=1 to Objects.Count-1 do
            if (Objects[i].aRec.Y+Objects[i].aRec.DY)>Cell.Height then
              Cell.Height:=Objects[i].aRec.Y+Objects[i].aRec.DY;
        end
    end;
  prbrmMaxResizeObj,prbrmMinResizeObj:
    begin
      MinObj:=nil;
      MaxObj:=nil;
      for i:=0 to ResizeObjs.Count-1 do
        begin
          Obj:=ResizeObjs[i];
          if Objects.IndexOf(Obj)<>-1 then
            begin
              if (MaxObj=nil) or (Obj.aRec.Y+Obj.aRec.DY>MaxObj.aRec.Y+MaxObj.aRec.DY) then
                MaxObj:=Obj;
              if (MinObj=nil) or (Obj.aRec.Y+Obj.aRec.DY<MaxObj.aRec.Y+MaxObj.aRec.DY) then
                MinObj:=Obj;
            end;
        end;
      if ResizeMode=prbrmMaxResizeObj then
        begin
          if (MaxObj<>nil) then
            Cell.Height:=Height+(MaxObj.aRec.Y+MaxObj.aRec.DY-MaxObj.dRec.pRect.Bottom)
        end
      else
        begin
          if (MinObj<>nil) then
            Cell.Height:=Height+(MinObj.aRec.Y+MinObj.aRec.DY-MinObj.dRec.pRect.Bottom);
        end;
    end;
end;
end;

function TprCustomHBand.GetUseColumns;
begin
Result:=false;
end;

function TprCustomHBand.GetColCount;
begin
Result:=0;
end;

function TprCustomHBand.GetColDirection;
begin
Result:=prcdTopBottomLeftRight;
end;















//////////////////////////
//
// TprCustomHTitleBand
//
//////////////////////////

/////////////////////////
//
// TprCustomHSummaryBand
//
/////////////////////////
constructor TprCustomHSummaryBand.Create;
begin
inherited;
end;

function TprCustomHSummaryBand.GetLinkToBand;
begin
Result:=PrintWithBand;
end;

function TprCustomHSummaryBand.GetLinkType;
begin
Result:=prltBefore;
end;

//////////////////////////
//
// TprCustomHPageHeaderBand
//
//////////////////////////

/////////////////////////////
//
// TprCustomHPageFooterBand
//
/////////////////////////////
procedure TprCustomHPageFooterBand.CalcdPageRect;
begin
if FCalced then exit;
dPageRect := Rect(CurPageRect.Left,CurPageRect.Bottom-Height,CurPageRect.Right,CurPageRect.Bottom);
CurPageRect.Bottom := CurPageRect.Bottom-Height;
FCalced := true;
end;

//////////////////////////
//
// TprCustomHDetailBand
//
//////////////////////////
constructor TprCustomHDetailBand.Create;
begin
inherited;
Dataset     :=TprDatasetLink.Create;
Bands       :=TprBands.Create;
Groups      :=TprGroups.Create;
end;

destructor TprCustomHDetailBand.Destroy;
begin
Bands.Free;
Bands:=nil;
Groups.Free;
Groups:=nil;
Dataset.Free;
inherited;
end;

procedure TprCustomHDetailBand.Notification;
begin
if (Operation=opRemove) and (AComponent<>Self) then
  begin
    if AComponent is TprGroup then
      Groups.Remove(AComponent);
    if AComponent is TprBand then
      Bands.Remove(AComponent);
    if AComponent=FParentDetail then
      FParentDetail:=nil;
  end;

inherited;
end;

procedure TprCustomHDetailBand.DefineProperties;
begin
inherited;
Filer.DefineProperty('Groups',ReadGroups,WriteGroups,Groups.Count>0);
Filer.DefineProperty('Bands',ReadBands,WriteBands,Bands.Count>0);
end;

procedure TprCustomHDetailBand.ReadGroups;
begin
FGroupsNames:=TStringList.Create;
prReadStringList(Reader,FGroupsNames);
end;

procedure TprCustomHDetailBand.WriteGroups;
begin
prWriteCompListNames(Writer,Groups);
end;

procedure TprCustomHDetailBand.ReadBands;
begin
FBandsNames:=TStringList.Create;
prReadStringList(Reader,FBandsNames);
end;

procedure TprCustomHDetailBand.WriteBands;
begin
prWriteCompListNames(Writer,Bands);
end;

procedure TprCustomHDetailBand.GroupRemoved;
begin
Groups.Remove(Group);
end;

procedure TprCustomHDetailBand.GroupAdded;
var
  i : integer;
begin
i:=Groups.IndexOf(Group);
if i=-1 then
  Groups.Add(Group);
end;

procedure TprCustomHDetailBand.AfterReportLoaded;
var
  i,j : integer;
begin
inherited;
if FGroupsNames<>nil then
  begin
    Groups.Clear;
    for i:=0 to FGroupsNames.Count-1 do
      begin
        j:=Report.Groups.IndexByName(FGroupsNames[i]);
        if j<>-1 then
          Groups.Add(Report.Groups[j]);
      end;
    FGroupsNames.Free;
  end;
if FBandsNames<>nil then
  begin
    Bands.Clear;
    for i:=0 to FBandsNames.Count-1 do
      begin
        j:=Page.Bands.IndexByName(FBandsNames[i]);
        if j<>-1 then
          Bands.Add(Page.Bands[j]);
      end;
    FBandsNames.Free;
  end;
end;

procedure TprCustomHDetailBand.SetParentDetail;
var
  i : integer;
begin
if Value=FParentDetail then exit;
if (FParentDetail<>nil) and (FParentDetail.Bands<>nil) then
  begin
    FParentDetail.Bands.Remove(Self);
  end;
FParentDetail:=Value;
if (FParentDetail<>nil) and (FParentDetail.Bands<>nil) then
  begin
    i:=FParentDetail.Bands.IndexOf(Self);
    if i=-1 then
      FParentDetail.Bands.Add(Self);
  end;
end;

function TprCustomHDetailBand.GetUseColumns;
begin
Result:=ColCount>1;
end;

function TprCustomHDetailBand.GetColCount;
begin
Result:=ColCount;
end;

function TprCustomHDetailBand.GetColDirection;
begin
Result:=ColDirection;
end;

function TprCustomHDetailBand.GenerateCell;
var
  i : integer;
  s : string;
  v : TprVarValue;
  Cell : TprGenCell;
  fGroupEnded : boolean;
begin
Result:=nil;
//     
i:=Bands.IndexByBandType(bthDetailHeader);
if i<>-1 then
  (Bands[i] as TprCustomHBand).GenerateCell(nil,nil,false);

//  
for i:=0 to Groups.Count-1 do
  Groups[i].Reset;

//     
while not DataSet.Eof do
  begin
    if FValid<>'' then
      begin
        s := FValid;
        if not TprParser(Report.FParser).Calc(s,v) then
          Exception.CreateFmt(prLoadStr(sDetailBandValidError),[FValid]);
        if not _vAsBoolean(v) then
          break;
      end;
    // 
    for i:=0 to Groups.Count-1 do
      Groups[i].CalcValue;

    for i:=Groups.Count-1 downto 0 do
      begin
        fGroupEnded:=Groups[i].GroupEnded;
        if fGroupEnded then
          DataSet.Prior;
        Groups[i].FootersGenerateCell(nil,nil);
        if fGroupEnded then
          DataSet.Next;
      end;
    for i:=0 to Groups.Count-1 do
      Groups[i].HeadersGenerateCell(nil,nil);

    //   
    Cell := inherited GenerateCell(nil,nil,false);

    // 
    Report.DoOnDataSetNext(DataSet,Self,nil,Cell);

    //    Band
    for i:=0 to Bands.Count-1 do
      if Bands[i].BandType in [bthDetail] then
        (Bands[i] as TprCustomHBand).GenerateCell(nil,nil,false);

    DataSet.Next;
    Report.ADSRN_Next(DataSet);
  end;

//  FooterBands
for i:=Groups.Count-1 downto 0 do
  begin
//    DataSet.Prior;
    Groups[i].FootersAlwaysGenerateCell(nil,nil);
//    DataSet.Next;
  end;

//    
i:=Bands.IndexByBandType(bthDetailFooter);
if i<>-1 then
  (Bands[i] as TprCustomHBand).GenerateCell(nil,nil,false);

//     DataSet
Report.DoOnDataSetEof(DataSet);
end;


procedure TprCustomHDetailBand.InitDataSet;
begin
Dataset.Dataset := Report.GetDataSetByName(DataSetName);
if Dataset.Dataset=nil then
  raise Exception.CreateFmt(prLoadStr(sDataSetNotFound),[DataSetName]);
if not Dataset.Active then
  Dataset.Open;
if Assigned(Report.OnInitDetailBandDataSet) then
  Report.OnInitDetailBandDataSet(Report,Self,DataSet.Dataset,DataSetName)
else
  DataSet.First;
Report.ADSRN_First(DataSet);
end;

procedure TprCustomHDetailBand.CalcdPageRect;
var
  i,j : integer;
begin
if FCalced then exit;

i:=Bands.IndexByBandType(bthDetailHeader);
if i<>-1 then
  Bands[i].CalcdPageRect(CurPageRect,nil);

for i:=0 to Groups.Count-1 do
  for j:=0 to Groups[i].Headers.Count-1 do
    Groups[i].Headers[j].CalcdPageRect(CurPageRect,nil);

inherited;

for i:=0 to Bands.Count-1 do
  if Bands[i].BandType in [bthDetail] then
    Bands[i].CalcdPageRect(CurPageRect,nil);

for i:=Groups.Count-1 downto 0 do
  for j:=0 to Groups[i].Footers.Count-1 do
    Groups[i].Footers[j].CalcdPageRect(CurPageRect,nil);

i:=Bands.IndexByBandType(bthDetailFooter);
if i<>-1 then
  Bands[i].CalcdPageRect(CurPageRect,nil);

FCalced:=true;
end;

procedure TprCustomHDetailBand.OnInsertIntoPage;
begin
end;

function TprCustomHDetailBand.GetDrawDesignCaption;
begin
if ParentDetail=nil then
  Result := inherited GetDrawDesignCaption
else
  Result := Format('%s (Parent : %s)',[inherited GetDrawDesignCaption,ParentDetail.Name]);
end;

////////////////////////////////
//
// TprCustomHDetailHeaderBand
//
////////////////////////////////
procedure TprCustomHDetailHeaderBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FDetailBand) then
  FDetailBand:=nil;

inherited;
end;

procedure TprCustomHDetailHeaderBand.SetDetailBand;
var
  i : integer;
begin
if Value=FDetailBand then exit;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    FDetailBand.Bands.Remove(Self);
  end;
FDetailBand:=Value;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    i:=FDetailBand.Bands.IndexOf(Self);
    if i=-1 then
      FDetailBand.Bands.Add(Self);
  end;
end;

procedure TprCustomHDetailHeaderBand.OnInsertIntoPage;
begin
end;

function TprCustomHDetailHeaderBand.GetUseColumns;
begin
Result:=ColCount>1;
end;

function TprCustomHDetailHeaderBand.GetColCount;
begin
Result:=ColCount;
end;

function TprCustomHDetailHeaderBand.GetColDirection;
begin
Result:=ColDirection;
end;

function TprCustomHDetailHeaderBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (DetailBand<>nil) then
  Result:=DetailBand;
end;

function TprCustomHDetailHeaderBand.GetLinkType;
begin
Result:=prltAfter;
end;

function TprCustomHDetailHeaderBand.GetDrawDesignCaption;
begin
if DetailBand=nil then
  Result := inherited GetDrawDesignCaption
else
  Result := Format('%s (%s)',[inherited GetDrawDesignCaption,DetailBand.Name]);
end;

////////////////////////////////
//
// TprCustomHDetailFooterBand
//
////////////////////////////////
procedure TprCustomHDetailFooterBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FDetailBand) then
  FDetailBand:=nil;

inherited;
end;

procedure TprCustomHDetailFooterBand.SetDetailBand;
var
  i : integer;
begin
if Value=FDetailBand then exit;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    FDetailBand.Bands.Remove(Self);
  end;
FDetailBand:=Value;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    i:=FDetailBand.Bands.IndexOf(Self);
    if i=-1 then
      FDetailBand.Bands.Add(Self);
  end;
end;

procedure TprCustomHDetailFooterBand.OnInsertIntoPage;
begin
end;

function TprCustomHDetailFooterBand.GetUseColumns;
begin
Result:=ColCount>1;
end;

function TprCustomHDetailFooterBand.GetColCount;
begin
Result:=ColCount;
end;

function TprCustomHDetailFooterBand.GetColDirection;
begin
Result:=ColDirection;
end;

function TprCustomHDetailFooterBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (DetailBand<>nil) then
  Result:=DetailBand;
end;

function TprCustomHDetailFooterBand.GetLinkType;
begin
Result:=prltBefore;
end;

function TprCustomHDetailFooterBand.GetDrawDesignCaption;
begin
if DetailBand=nil then
  Result := inherited GetDrawDesignCaption
else
  Result := Format('%s (%s)',[inherited GetDrawDesignCaption,DetailBand.Name]);
end;

////////////////////////////////////
//
// TprCustomHGroupHeaderBand
//
////////////////////////////////////
procedure TprCustomHGroupHeaderBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FGroup) then
  FGroup:=nil;

inherited;
end;

procedure TprCustomHGroupHeaderBand.OnInsertIntoPage;
begin
end;

procedure TprCustomHGroupHeaderBand.SetGroup;
var
  i : integer;
begin
if Value=FGroup then exit;
if FGroup<>nil then
  begin
    FGroup.Headers.Remove(Self);
  end;
FGroup:=Value;
if FGroup<>nil then
  begin
    i:=FGroup.Headers.IndexOf(Self);
    if i=-1 then
      FGroup.Headers.Add(Self);
  end;
end;

function TprCustomHGroupHeaderBand.GetDrawDesignCaption;
begin
if (Group=nil) or (Group.DetailBand=nil) then
  Result:=inherited GetDrawDesignCaption
else
  Result:=Format('%s (%s,%s)',[inherited GetDrawDesignCaption,Group.Name,Group.DetailBand.Name]);
end;

function TprCustomHGroupHeaderBand.GetUseColumns;
begin
Result:=ColCount>1;
end;

function TprCustomHGroupHeaderBand.GetColCount;
begin
Result:=ColCount;
end;

function TprCustomHGroupHeaderBand.GetColDirection;
begin
Result:=ColDirection;
end;

function TprCustomHGroupHeaderBand.GetStartNewPage;
begin
Result:=StartNewPage;
end;

function TprCustomHGroupHeaderBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (Group<>nil) then
  Result:=Group.DetailBand;
end;

function TprCustomHGroupHeaderBand.GetLinkType;
begin
Result:=prltAfter;
end;

////////////////////////////////////
//
// TprCustomHGroupFooterBand
//
////////////////////////////////////
procedure TprCustomHGroupFooterBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FGroup) then
  FGroup:=nil;

inherited;
end;

procedure TprCustomHGroupFooterBand.OnInsertIntoPage;
begin
end;

procedure TprCustomHGroupFooterBand.SetGroup;
var
  i : integer;
begin
if Value=FGroup then exit;
if FGroup<>nil then
  begin
    FGroup.Footers.Remove(Self);
  end;
FGroup:=Value;
if FGroup<>nil then
  begin
    i:=FGroup.Footers.IndexOf(Self);
    if i=-1 then
      FGroup.Footers.Add(Self);
  end;
end;

function TprCustomHGroupFooterBand.GetDrawDesignCaption;
begin
if (Group=nil) or (Group.DetailBand=nil) then
  Result:=inherited GetDrawDesignCaption
else
  Result:=Format('%s (%s,%s)',[inherited GetDrawDesignCaption,Group.Name,Group.DetailBand.Name]);
end;

function TprCustomHGroupFooterBand.GetUseColumns;
begin
Result:=ColCount>1;
end;

function TprCustomHGroupFooterBand.GetColCount;
begin
Result:=ColCount;
end;

function TprCustomHGroupFooterBand.GetColDirection;
begin
Result:=ColDirection;
end;

function TprCustomHGroupFooterBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (Group<>nil) then
  Result:=Group.DetailBand;
end;

function TprCustomHGroupFooterBand.GetLinkType;
begin
Result:=prltBefore;
end;



















/////////////////////////////
//
// TprCustomVBand
//
/////////////////////////////
constructor TprCustomVBand.Create;
begin
inherited;
end;

//
//  Band  
//
procedure TprCustomVBand.CalcdPageRect;
begin
if FCalced then exit;
dPageRect       :=Rect(CurPageRect.Left,CurPageRect.Top,CurPageRect.Left+Width,CurPageRect.Bottom);
CurPageRect.Left:=CurPageRect.Left+Width;
FCalced         :=true;
end;

procedure TprCustomVBand.DesignerResize;
begin
Width:=dPageRect.Right+oRight-dPageRect.Left-oLeft;
Report.ConvertToDesignerCoords(dPageRect,PDI.dPageRect);
end;

procedure TprCustomVBand.DesignerLink;
begin
if (Linked.Parent is TprObj) and
   RectInRect(Linked.dPageRect,PDI.dPageRect) then
  begin
    case LinkMode of
      ltRight : if ResizeObjs.IndexOf(Linked.Parent)=-1 then
                  ResizeObjs.Add(Linked.Parent);
    end;
    LinkAccepted:=true;
  end;
end;

function TprCustomVBand.GenerateCell;
var
  i : integer;
  o : TprObjRec;
  HBand : TprCustomHBand;
  MinObj,MaxObj : TprObj;
begin
Result:=nil;
if (CallerBand=nil) and FCrossTabGenerated then exit;

Report.DoOnBandGenerateCell(Self);

if not Visible then exit;

if (CallerBand=nil) or not UseHorizontalBands then
  HBand:=nil
else
  HBand:=CallerBand as TprCustomHBand;

if fSimpleCreateCell then
  Result:=TprGenCell.Create
else
  Result:=Page.Grid.AddCell(HBand,Self);
  
try
  try
    //   Objects   ,    
    //   Band    Band
    if (HBand<>nil) and (UseHorizontalBands) then
      for i:=0 to HBand.Objects.Count-1 do
        if (HBand.Objects[i].dRec.pRect.Left+HBand.dPageRect.Left>=dPageRect.Left) and
           (HBand.Objects[i].dRec.pRect.Right+HBand.dPageRect.Left<=dPageRect.Right) then
          //     Band
          Objects.Add(HBand.Objects[i]);

    for i:=0 to Objects.Count-1 do
      Objects[i].FirstPassProcessed:=false;
    
    //     aRec.X,Y,DX,DY
    for i:=0 to Objects.Count-1 do
      Objects[i].FirstPass;

    //   Band   
    Result.Width:=Width;
    case ResizeMode of
      prbrmMaxObj:
        begin
          if Objects.Count>0 then
            begin
              //    
              Result.Width:=Objects[0].aRec.X+Objects[0].aRec.DX;
              for i:=1 to Objects.Count-1 do
                if (Objects[i].aRec.X+Objects[i].aRec.DX)>Result.Width then
                  Result.Width:=Objects[i].aRec.X+Objects[i].aRec.DX;

              if HBand<>nil then
                // ,    -
                //   , ,     X
                //  -    
                Result.Width:=Result.Width-dPageRect.Left+Objects[0].Band.dPageRect.Left;
            end;
        end;
      prbrmMaxResizeObj,prbrmMinResizeObj:
        begin
          if ResizeObjs.Count>0 then
            begin
              MinObj:=ResizeObjs[0];
              MaxObj:=ResizeObjs[0];
              for i:=1 to ResizeObjs.Count-1 do
                begin
                  if ResizeObjs[i].aRec.X+ResizeObjs[i].aRec.DX>MaxObj.aRec.X+MaxObj.aRec.DX then
                    MaxObj:=ResizeObjs[i];
                  if ResizeObjs[i].aRec.X+ResizeObjs[i].aRec.DX<MaxObj.aRec.X+MaxObj.aRec.DX then
                    MinObj:=ResizeObjs[i];
                end;
    
              if ResizeMode=prbrmMaxResizeObj then
                Result.Width:=Width+(MaxObj.aRec.DX-
                                     (MaxObj.dRec.pRect.Right-
                                      MaxObj.dRec.pRect.Left))
              else
                Result.Width:=Width+(MinObj.aRec.DX-
                                     (MinObj.dRec.pRect.Right-
                                      MinObj.dRec.pRect.Left))
            end;
        end;
    end;

    if Assigned(CallBackProc) then
      CallBackProc(Self,Result,Objects);

    for i:=0 to Objects.Count-1 do
      begin
        o             :=Objects[i].aRec.CreateCopy;
        o.Page        :=nil;
        o.Obj         :=Objects[i];
        o.pRect.Top   :=o.Y;
        o.pRect.Bottom:=o.Y+o.DY;
        o.pRect.Left  :=o.X;
        o.pRect.Right :=o.X+o.DX;
        Result.Add(o);
      end;

    FCrossTabGenerated:=true;
  except
    if fSimpleCreateCell then
      Result.Free;
    raise;
  end;
finally
  if (HBand<>nil) and (UseHorizontalBands) then
    Objects.Clear
end;
end;











//////////////////////////
//
// TprCustomVTitleBand
//
//////////////////////////

/////////////////////////
//
// TprCustomVSummaryBand
//
/////////////////////////
constructor TprCustomVSummaryBand.Create;
begin
inherited;
end;

function TprCustomVSummaryBand.GetLinkToBand;
begin
Result:=PrintWithBand;
end;

function TprCustomVSummaryBand.GetLinkType;
begin
Result:=prltBefore;
end;

//////////////////////////
//
// TprCustomVPageHeaderBand
//
//////////////////////////

/////////////////////////////
//
// TprCustomVPageFooterBand
//
/////////////////////////////
procedure TprCustomVPageFooterBand.CalcdPageRect;
begin
if FCalced then exit;
dPageRect         :=Rect(CurPageRect.Right-Width,CurPageRect.Top,CurPageRect.Right,CurPageRect.Bottom);
CurPageRect.Right :=CurPageRect.Right-Width;
FCalced           :=true;
end;

//////////////////////////
//
// TprCustomVDetailBand
//
//////////////////////////
constructor TprCustomVDetailBand.Create;
begin
inherited;
Dataset:=TprDatasetLink.Create;
Bands  :=TprBands.Create;
Groups :=TprGroups.Create;
end;

destructor TprCustomVDetailBand.Destroy;
begin
Bands.Free;
Bands:=nil;
Groups.Free;
Groups:=nil;
Dataset.Free;
inherited;
end;

procedure TprCustomVDetailBand.Notification;
begin
if (Operation=opRemove) and (AComponent<>Self) then
  begin
    if AComponent is TprGroup then
      Groups.Remove(AComponent);
    if AComponent is TprBand then
      Bands.Remove(AComponent);
    if AComponent=FParentDetail then
      FParentDetail:=nil;
  end;

inherited;
end;

procedure TprCustomVDetailBand.DefineProperties;
begin
inherited;
Filer.DefineProperty('Groups',ReadGroups,WriteGroups,Groups.Count>0);
Filer.DefineProperty('Bands',ReadBands,WriteBands,Bands.Count>0);
end;

procedure TprCustomVDetailBand.ReadGroups;
begin
FGroupsNames:=TStringList.Create;
prReadStringList(Reader,FGroupsNames);
end;

procedure TprCustomVDetailBand.WriteGroups;
begin
prWriteCompListNames(Writer,Groups);
end;

procedure TprCustomVDetailBand.ReadBands;
begin
FBandsNames:=TStringList.Create;
prReadStringList(Reader,FBandsNames);
end;

procedure TprCustomVDetailBand.WriteBands;
begin
prWriteCompListNames(Writer,Bands);
end;

procedure TprCustomVDetailBand.GroupRemoved;
begin
Groups.Remove(Group);
end;

procedure TprCustomVDetailBand.GroupAdded;
var
  i : integer;
begin
i:=Groups.IndexOf(Group);
if i=-1 then
  Groups.Add(Group);
end;

procedure TprCustomVDetailBand.AfterReportLoaded;
var
  i : integer;
begin
inherited;
if FGroupsNames<>nil then
  begin
    Groups.Clear;
    for i:=0 to FGroupsNames.Count-1 do
      Groups.Add(Report.Groups.ByName[FGroupsNames[i]]);
    FGroupsNames.Free;
  end;
if FBandsNames<>nil then
  begin
    Bands.Clear;
    for i:=0 to FBandsNames.Count-1 do
      Bands.Add(Page.Bands.ByName[FBandsNames[i]]);
    FBandsNames.Free;
  end;
end;

procedure TprCustomVDetailBand.SetParentDetail;
var
  i : integer;
begin
if Value=FParentDetail then exit;
if (FParentDetail<>nil) and (FParentDetail.Bands<>nil) then
  begin
    FParentDetail.Bands.Remove(Self);
  end;
FParentDetail:=Value;
if (FParentDetail<>nil) and (FParentDetail.Bands<>nil) then
  begin
    i:=FParentDetail.Bands.IndexOf(Self);
    if i=-1 then
      FParentDetail.Bands.Add(Self);
  end;
end;

procedure TprCustomVDetailBand.InitDataSet;
begin
Dataset.Dataset:=Report.GetDataSetByName(DataSetName);
if Dataset.Dataset=nil then
  raise Exception.CreateFmt(prLoadStr(sDataSetNotFound),[DataSetName]);
if not Dataset.Active then
  Dataset.Open;
if Assigned(Report.OnInitDetailBandDataSet) then
  Report.OnInitDetailBandDataSet(Report,Self,DataSet.Dataset,DataSetName)
else
  DataSet.First;
Report.ADSRN_First(DataSet);
end;

function TprCustomVDetailBand.GenerateCell;
var
  i : integer;
  s : string;
  v : TprVarValue;
  Cell : TprGenCell;
  fGroupEnded : boolean;
begin
Result:=nil;

// 
i:=Bands.IndexByBandType(btvDetailHeader);
if i<>-1 then
  Bands[i].GenerateCell(CallerBand,CallbackProc,false);

//  
for i:=0 to Groups.Count-1 do
  Groups[i].Reset;

while not DataSet.Eof do
  begin
    if FValid<>'' then
      begin
        s := FValid;
        if not TprParser(Report.FParser).Calc(s,v) then
          Exception.CreateFmt(prLoadStr(sDetailBandValidError),[FValid]);
        if not _vAsBoolean(v) then
          break;
      end;
    // 
    for i:=0 to Groups.Count-1 do
      Groups[i].CalcValue;

    for i:=Groups.Count-1 downto 0 do
      begin
        fGroupEnded:=Groups[i].GroupEnded;
        if fGroupEnded {and not Dataset.Eof} then
          DataSet.Prior;
        Groups[i].FootersGenerateCell(CallerBand,CallbackProc);
        if fGroupEnded {and not Dataset.Eof} then
          DataSet.Next;
      end;
    for i:=0 to Groups.Count-1 do
      Groups[i].HeadersGenerateCell(CallerBand,CallbackProc);

    //   
    Cell := inherited GenerateCell(CallerBand,CallbackProc,false);

    // 
    if (CallerBand<>nil) and (CallerBand is TprCustomHBand) then
      Report.DoOnDataSetNext(DataSet,TprCustomHBand(CallerBand),Self,Cell)
    else
      Report.DoOnDataSetNext(DataSet,nil,Self,Cell);

    //    Band
    for i:=0 to Bands.Count-1 do
      if Bands[i].BandType in [bthDetail] then
        Bands[i].GenerateCell(CallerBand,CallbackProc,false);

    DataSet.Next;
    Report.ADSRN_Next(DataSet);
  end;

//  FooterBands
for i:=Groups.Count-1 downto 0 do
  begin
//    if not Dataset.Eof then
//      DataSet.Prior;
    Groups[i].FootersAlwaysGenerateCell(CallerBand,CallbackProc);
//    DataSet.Next;
  end;

//    
i:=Bands.IndexByBandType(btvDetailFooter);
if i<>-1 then
  Bands[i].GenerateCell(CallerBand,CallbackProc,false);

//     DataSet
Report.DoOnDataSetEof(DataSet);
end;


procedure TprCustomVDetailBand.CalcdPageRect;
var
  i,j : integer;
begin
if FCalced then exit;

i:=Bands.IndexByBandType(btvDetailHeader);
if i<>-1 then
  Bands[i].CalcdPageRect(CurPageRect,nil);

for i:=0 to Groups.Count-1 do
  for j:=0 to Groups[i].Headers.Count-1 do
    Groups[i].Headers[j].CalcdPageRect(CurPageRect,nil);

inherited;

for i:=0 to Bands.Count-1 do
  if Bands[i].BandType in [btvDetail] then
    Bands[i].CalcdPageRect(CurPageRect,nil);

for i:=0 to Groups.Count-1 do
  for j:=0 to Groups[i].Footers.Count-1 do
    Groups[i].Footers[j].CalcdPageRect(CurPageRect,nil);

i:=Bands.IndexByBandType(btvDetailFooter);
if i<>-1 then
  Bands[i].CalcdPageRect(CurPageRect,nil);

FCalced:=true;
end;

procedure TprCustomVDetailBand.OnInsertIntoPage;
begin
end;

function TprCustomVDetailBand.GetDrawDesignCaption;
begin
if ParentDetail=nil then
  Result := inherited GetDrawDesignCaption
else
  Result := Format('%s (Parent : %s)',[inherited GetDrawDesignCaption,ParentDetail.Name]);
end;

////////////////////////////////
//
// TprCustomVDetailHeaderBand
//
////////////////////////////////
procedure TprCustomVDetailHeaderBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FDetailBand) then
  FDetailBand:=nil;

inherited;
end;

procedure TprCustomVDetailHeaderBand.SetDetailBand;
var
  i : integer;
begin
if Value=FDetailBand then exit;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    FDetailBand.Bands.Remove(Self);
  end;
FDetailBand:=Value;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    i:=FDetailBand.Bands.IndexOf(Self);
    if i=-1 then
      FDetailBand.Bands.Add(Self);
  end;
end;

procedure TprCustomVDetailHeaderBand.OnInsertIntoPage;
begin
end;

function TprCustomVDetailHeaderBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (DetailBand<>nil) then
  Result:=DetailBand;
end;

function TprCustomVDetailHeaderBand.GetLinkType;
begin
Result:=prltAfter;
end;

function TprCustomVDetailHeaderBand.GetDrawDesignCaption;
begin
if DetailBand=nil then
  Result := inherited GetDrawDesignCaption
else
  Result := Format('%s (%s)',[inherited GetDrawDesignCaption,DetailBand.Name]);
end;

////////////////////////////////
//
// TprCustomVDetailFooterBand
//
////////////////////////////////
procedure TprCustomVDetailFooterBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FDetailBand) then
  FDetailBand:=nil;

inherited;
end;

procedure TprCustomVDetailFooterBand.SetDetailBand;
var
  i : integer;
begin
if Value=FDetailBand then exit;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    FDetailBand.Bands.Remove(Self);
  end;
FDetailBand:=Value;
if (FDetailBand<>nil) and (FDetailBand.Bands<>nil) then
  begin
    i:=FDetailBand.Bands.IndexOf(Self);
    if i=-1 then
      FDetailBand.Bands.Add(Self);
  end;
end;

procedure TprCustomVDetailFooterBand.OnInsertIntoPage;
begin
end;

function TprCustomVDetailFooterBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (DetailBand<>nil) then
  Result:=DetailBand;
end;

function TprCustomVDetailFooterBand.GetLinkType;
begin
Result:=prltBefore;
end;

function TprCustomVDetailFooterBand.GetDrawDesignCaption;
begin
if DetailBand=nil then
  Result := inherited GetDrawDesignCaption
else
  Result := Format('%s (%s)',[inherited GetDrawDesignCaption,DetailBand.Name]);
end;

////////////////////////////////////
//
// TprCustomVGroupHeaderBand
//
////////////////////////////////////
procedure TprCustomVGroupHeaderBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FGroup) then
  FGroup:=nil;

inherited;
end;

procedure TprCustomVGroupHeaderBand.OnInsertIntoPage;
begin
end;

function TprCustomVGroupHeaderBand.GetStartNewPage;
begin
Result:=StartNewPage;
end;

function TprCustomVGroupHeaderBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (Group<>nil) then
  Result:=Group.DetailBand;
end;

function TprCustomVGroupHeaderBand.GetLinkType;
begin
Result:=prltAfter;
end;

procedure TprCustomVGroupHeaderBand.SetGroup;
var
  i : integer;
begin
if Value=FGroup then exit;
if FGroup<>nil then
  begin
    FGroup.Headers.Remove(Self);
  end;
FGroup:=Value;
if FGroup<>nil then
  begin
    i:=FGroup.Headers.IndexOf(Self);
    if i=-1 then
      FGroup.Headers.Add(Self);
  end;
end;

function TprCustomVGroupHeaderBand.GetDrawDesignCaption;
begin
if (Group=nil) or (Group.DetailBand=nil) then
  Result:=inherited GetDrawDesignCaption
else
  Result:=Format('%s (%s,%s)',[inherited GetDrawDesignCaption,Group.Name,Group.DetailBand.Name]);
end;

////////////////////////////////////
//
// TprCustomVGroupFooterBand
//
////////////////////////////////////
procedure TprCustomVGroupFooterBand.Notification;
begin
if (Operation=opRemove) and (AComponent=FGroup) then
  FGroup:=nil;

inherited;
end;

procedure TprCustomVGroupFooterBand.OnInsertIntoPage;
begin
end;

procedure TprCustomVGroupFooterBand.SetGroup;
var
  i : integer;
begin
if Value=FGroup then exit;
if FGroup<>nil then
  begin
    FGroup.Footers.Remove(Self);
  end;
FGroup:=Value;
if FGroup<>nil then
  begin
    i:=FGroup.Footers.IndexOf(Self);
    if i=-1 then
      FGroup.Footers.Add(Self);
  end;
end;

function TprCustomVGroupFooterBand.GetLinkToBand;
begin
Result:=nil;
if LinkToDetail and (Group<>nil) then
  Result:=Group.DetailBand;
end;

function TprCustomVGroupFooterBand.GetLinkType;
begin
Result:=prltBefore;
end;

function TprCustomVGroupFooterBand.GetDrawDesignCaption;
begin
if (Group=nil) or (Group.DetailBand=nil) then
  Result:=inherited GetDrawDesignCaption
else
  Result:=Format('%s (%s,%s)',[inherited GetDrawDesignCaption,Group.Name,Group.DetailBand.Name]);
end;



















//////////////////////////
//
// TprCustomEndPage
//
//////////////////////////
constructor TprCustomEndPage.CreateEmpty;
begin
inherited Create;
Report:=_Report;
FoRecs:=TList.Create;
end;

constructor TprCustomEndPage.Create;
begin
CreateEmpty(_Page.Report);
end;

destructor TprCustomEndPage.Destroy;
var
  i : integer;
begin
for i:=0 to FoRecs.Count-1 do
  oRec[i].Free;
FoRecs.Free;
inherited;
end;

function TprCustomEndPage.oRecsCount;
begin
Result:=FoRecs.Count;
end;

function TprCustomEndPage.GetoRec;
begin
Result:=TprObjRec(FoRecs[index]);
end;

procedure TprCustomEndPage.FreeGeneratedObjects;
var
  i : integer;
begin
for i:=0 to oRecsCount-1 do
  oRec[i].Free;
FoRecs.Clear;
end;

function TprCustomEndPage.CurrentWidth;
begin
Result:=Rect.Right-Rect.Left;
end;

function TprCustomEndPage.CurrentHeight;
begin
Result:=Rect.Bottom-Rect.Top;
end;

//////////////////////////
//
// TprCustomPage
//
//////////////////////////
constructor TprCustomPage.Create;
begin
{$IFDEF DEBUG}
if AOwner=nil then
  WriteToLog('TprCustomPage.Create : AOwner : nil')
else
  WriteToLog('TprCustomPage.Create : AOwner : '+AOwner.Name);
{$ENDIF}
inherited;
dPageRect:=nil;
Bands    :=TprBands.Create;
Grid     :=TprGenGrid.Create(Self);

Initialize(FOldEndPagesRects);

Name:=GetValidComponentName(Self);
end;

destructor TprCustomPage.Destroy;
begin
{$IFDEF DEBUG}
WriteToLog('TprCustomPage.Destroy : '+Name);
{$ENDIF}
Grid.Free;

while Bands.Count>0 do
  Bands[0].Free;

Bands.Free;
Finalize(FOldEndPagesRects);

{$IFDEF DEBUG}
WriteToLog('TprCustomPage.Destroy : '+Name+' destroyed');
{$ENDIF}

inherited;
end;

procedure TprCustomPage.SetParentComponent;
begin
Report:=Value as TprCustomReport;
{$IFDEF DEBUG}
if Report=nil then
  WriteToLog('TprCustomPage.SetParentComponent : nil')
else
  WriteToLog('TprCustomPage.SetParentComponent : '+Report.Name);
{$ENDIF}
end;

function TprCustomPage.HasParent;
begin
Result:=true;
end;

function TprCustomPage.GetParentComponent;
begin
Result:=Report;
end;

function TprCustomPage.GetChildOwner;
begin
Result:=Report;
end;

procedure TprCustomPage.GetChildren;
var
  i : integer;
begin
for i:=0 to Bands.Count-1 do
  Proc(Bands[i]);
end;

procedure TprCustomPage.Notification;
begin
{$IFDEF DEBUG}
if Owner=nil then
  WriteToLog('TprCustomPage.Notification : '+Name+' '+GetEnumName(TypeInfo(TOperation),integer(Operation))+' AComponent : '+AComponent.Name+' Owner : nil')
else
  WriteToLog('TprCustomPage.Notification : '+Name+' '+GetEnumName(TypeInfo(TOperation),integer(Operation))+' AComponent : '+AComponent.Name+' Owner : '+Owner.Name);
{$ENDIF}
if (Operation=opRemove) and (AComponent<>Self) then
  begin
    if AComponent is TprBand then
      Bands.Remove(AComponent);
  end;
end;

procedure TprCustomPage.SetReport;
begin
if FReport=Value then exit;
if FReport<>nil then
  FReport.FPages.Remove(Self);

FReport:=Value;

if (FReport<>nil) and (FReport.FPages.IndexOf(Self)=-1) then
  begin
    FReport.FPages.Add(Self);
    ReportSetted;
  end;
{$IFDEF DEBUG}
if Report=nil then
  WriteToLog('TprCustomPage.SetReport : nil')
else
  WriteToLog('TprCustomPage.SetReport : '+Report.Name);
{$ENDIF}
end;

procedure TprCustomPage.ReportSetted;
begin
end;

function TprCustomPage.IndexInReport;
begin
Result:=Report.FPages.IndexOf(Self);
end;

function TprCustomPage.HasVerticalBands;
var
  i : integer;
begin
Result:=false;
for i:=0 to Bands.Count-1 do
  if Bands[i].BandType in VerticalBands then
    begin
      Result:=true;
      exit;
    end;
end;

procedure TprCustomPage.FirstPassGenerateGrid;
var
  i : integer;
begin
//  Grid,   - 
Grid.Clear;

//
for i:=0 to Bands.Count-1 do
  if Bands[i].BandType in VerticalBands then
    TprCustomVBand(Bands[i]).FCrossTabGenerated:=false;

//   
for i:=0 to Bands.Count-1 do
  if Bands[i].BandType in HorizontalBands then
    Bands[i].InitDataSet;

//   
i:=Bands.IndexByBandType(btvTitle);
if i<>-1 then
  Grid.vTitleCell:=Bands[i].GenerateCell(nil,nil,true);

//   
i:=Bands.IndexByBandType(bthTitle);
if i<>-1 then
  Grid.hTitleCell:=Bands[i].GenerateCell(nil,nil,true);

//         , 
//        ,
//       
for i:=0 to Bands.Count-1 do
  if (Bands[i].BandType=bthDetail) and
     (TprCustomHDetailBand(Bands[i]).ParentDetail=nil) then
    Bands[i].GenerateCell(nil,nil,false);

//   
i:=Bands.IndexByBandType(bthSummary);
if i<>-1 then
  Bands[i].GenerateCell(nil,nil,false);
end;

type

TLinkInfo = class(TObject)
  Vector : TprGenVector;
  Band   : TprBand;

  constructor Create(_Vector : TprGenVector; _Band : TprBand);
end;

//////////////////////////////////
//
// TLinkInfo
//
//////////////////////////////////
constructor TLinkInfo.Create;
begin
inherited Create;
Vector:=_Vector;
Band  :=_Band;
end;

type

TLinksList = class(TList)
private
  function GetItm(i : integer) : TLinkInfo;
public
  property Items[i : integer] : TLinkInfo read GetItm; default;

  procedure FreeItem(i : integer);
  procedure FreeAll;

  destructor Destroy; override;
end;

///////////////////////
//
// TLinksList
//
///////////////////////
destructor TLinksList.Destroy;
begin
FreeAll;
inherited;
end;

function TLinksList.GetItm;
begin
Result:=TLinkInfo(inherited Items[i]);
end;

procedure TLinksList.FreeItem;
begin
Items[i].Free;
Delete(i);
end;

procedure TLinksList.FreeAll;
begin
while Count>0 do
  FreeItem(0);
end;

//
//   
//
procedure TprCustomPage.SecondPassPlaceGridOnEndPage;
var
  Cell : TprGenCell;
  Band : TprBand;
  LinksList : TLinksList;
  PriorEndPage : TprCustomEndPage;
  MaxCell,MinCell : TprGenCell;
  PriorColDirection : TprColDirectionType;
  V,Vector,MinVector : TprGenVector;
  rv : TprObjRec;
  i,k,PriorPage,CurVectorIndex,j,PageX,PageY,StartEndPageIndex,MaxTop,StartPageTop,ColWidth : integer;
  HPageFooter : TprCustomHPageFooterBand;
  VPageFooter : TprCustomVPageFooterBand;

  procedure DeleteBandFromLinksList(Vector : TprGenVector; Band : TprBand);
  var
    i : integer;
  begin
  i:=0;
  while i<LinksList.Count do
    if LinksList[i].Band=Band then
      begin
        //      Vector
        //     - LinksList[j].Vector
        LinksList[i].Vector.FLinkToVector:=Vector;
        LinksList.FreeItem(i);
      end
    else
      Inc(i);
  end;

  function FindEndPage(PageX,PageY : integer) : TprCustomEndPage;
  var
    i : integer;
  begin
  i:=Report.EndPagesCount-1;
  while (i>=StartEndPageIndex) and ((Report.EndPages[i].PageX<>PageX) or (Report.EndPages[i].PageY<>PageY)) do Dec(i);
  if i>=StartEndPageIndex then
    Result:=Report.EndPages[i]
  else
    Result:=nil;
  end;

  procedure InsertVerticalDetailHeader(Band : TprBand);
  var
    j : integer;
    VDetailBand : TprCustomVDetailBand;
  begin
  if Band.BandType=btvGroupHeader then
    VDetailBand:=TprCustomVDetailBand(TprCustomVGroupHeaderBand(Band).Group.DetailBand)
  else
    if Band.BandType=btvGroupFooter then
      VDetailBand:=TprCustomVDetailBand(TprCustomVGroupFooterBand(Band).Group.DetailBand)
    else
      if Band.BandType=btvDetail then
        VDetailBand:=TprCustomVDetailBand(Band)
      else
        if Band.BandType=btvDetailFooter then
          VDetailBand:=TprCustomVDetailBand(TprCustomVDetailFooterBand(Band).DetailBand)
        else
          exit;
  if VDetailBand=nil then exit;

  //         ,  
  //   , (    )
  //  
  for j:=0 to VDetailBand.Bands.Count-1 do
    if (VDetailBand.Bands[j].BandType=btvDetailHeader) and TprCustomVDetailHeaderBand(VDetailBand.Bands[j]).ReprintOnEachPage then
      begin
        //        
        V:=Grid.FindPriorVVector(CurVectorIndex,VDetailBand.Bands[j],0{StartEndPageIndex});
        if V<>nil then
          begin
            V      :=Grid.CopyVVector(V,CurVectorIndex);
            V.Page :=PageX;
            V.YOffs:=-1;
            V.XOffs:=Report.CurEndPage.Rect.Left;
            Report.CurEndPage.Rect.Left:=Report.CurEndPage.Rect.Left+V.Width;
          end;
      end;
  end;

  procedure InsertHorizontalDetailHeader(Band : TprBand);
  var
    j : integer;
    HDetailBand : TprCustomHDetailBand;
  begin
  if Band.BandType=bthGroupHeader then
    HDetailBand:=TprCustomHDetailBand(TprCustomHGroupHeaderBand(Band).Group.DetailBand)
  else
    if Band.BandType=bthGroupFooter then
      HDetailBand:=TprCustomHDetailBand(TprCustomHGroupFooterBand(Band).Group.DetailBand)
    else
      if Band.BandType=bthDetail then
        HDetailBand:=TprCustomHDetailBand(Band)
      else
        if Band.BandType=bthDetailFooter then
          HDetailBand:=TprCustomHDetailBand(TprCustomHDetailFooterBand(Band).DetailBand)
        else
          exit;
  if HDetailBand=nil then exit;

  //         ,  
  //   , (    )
  //  
  for j:=0 to HDetailBand.Bands.Count-1 do
    if (HDetailBand.Bands[j].BandType=bthDetailHeader) and TprCustomHDetailHeaderBand(HDetailBand.Bands[j]).ReprintOnEachPage then
      begin
        //        
        V := Grid.FindPriorHVector(CurVectorIndex,HDetailBand.Bands[j],0{StartEndPageIndex});
        if V<>nil then
          begin
            V := Grid.CopyHVector(V,CurVectorIndex);
            V.Page := PageY;
            V.XOffs := Report.CurEndPage.Rect.Left;
            V.YOffs := Report.CurEndPage.Rect.Top;
            Report.CurEndPage.Rect.Top:=Report.CurEndPage.Rect.Top+V.Height;
          end;
      end;
  end;

  procedure MoveObjects(Cell : TprGenCell);
  var
    i : integer;
  begin
  for i:=0 to Cell.ObjRecsCount-1 do
    begin
      Cell.ObjRecs[i].pRect.Left := Cell.ObjRecs[i].pRect.Left+Cell.XOffs;
      Cell.ObjRecs[i].pRect.Top := Cell.ObjRecs[i].pRect.Top+Cell.YOffs;
      Cell.ObjRecs[i].pRect.Right := Cell.ObjRecs[i].pRect.Right+Cell.XOffs;
      Cell.ObjRecs[i].pRect.Bottom := Cell.ObjRecs[i].pRect.Bottom+Cell.YOffs;

      if (Cell.VVector<>nil) and (Cell.HVector<>nil) then
        begin
          Cell.ObjRecs[i].pRect.Left := Cell.ObjRecs[i].pRect.Left-Cell.VVector.Band.dPageRect.Left;
          Cell.ObjRecs[i].pRect.Right := Cell.ObjRecs[i].pRect.Right-Cell.VVector.Band.dPageRect.Left;
          if dPageRect<>nil then
            begin
              Cell.ObjRecs[i].pRect.Left := Cell.ObjRecs[i].pRect.Left+dPageRect.Left;
              Cell.ObjRecs[i].pRect.Right := Cell.ObjRecs[i].pRect.Right+dPageRect.Left;
            end;
        end;

      Cell.ObjRecs[i].Page := Cell.Page;
      Cell.Page.FoRecs.Add(Cell.ObjRecs[i]);
    end;
  Cell.FObjRecs.Clear; // !!!
  end;

  procedure MoveCellsObjects(L : TList);
  var
    i : integer;
  begin
  for i:=0 to L.Count-1 do
    MoveObjects(TprGenCell(L[i]));
  end;

  //  :
  //      
  //  :
  //    
  //      
  //      
  //    /    
  //
  procedure SelectEndPage;
  var
    Cell : TprGenCell;
    i,j,Left,Top : integer;
  begin
  i:=StartEndPageIndex;
  while (i<Report.EndPagesCount) and
        ((Report.EndPages[i].PageX<>PageX) or
         (Report.EndPages[i].PageY<>PageY)) do Inc(i);
  if i>=Report.EndPagesCount then
    begin
      //  
      if (Report.CurEndPage<>nil) and (StartEndPageIndex<Report.EndPagesCount) then
        Report.DoOnPageEnd(Report.CurEndPage);

      //   
      Report.AddEndPage(Self);
      Report.CurEndPage.PageX := PageX;
      Report.CurEndPage.PageY := PageY;

      //  
      Report.DoOnPageStart(Report.CurEndPage);

      //  ProgressForm
      Report.UpdateProgressForm(Format(prLoadStr(sSecondPassCaption),[Report.EndPagesCount]));

      Left := Report.CurEndPage.Rect.Left;
      Top := Report.CurEndPage.Rect.Top;

      if (PageX=0) and (Grid.vTitleCell<>nil) then
        begin
          if PageY=0 then
            begin
              //    
              Grid.vTitleCell.Page := Report.CurEndPage;
              Grid.vTitleCell.XOffs := Left;
              Grid.vTitleCell.YOffs := Top;
              MoveObjects(Grid.vTitleCell);
            end;
          Report.CurEndPage.Rect.Left := Report.CurEndPage.Rect.Left+Grid.vTitleCell.Width;
        end;

      if (PageY=0) and (Grid.hTitleCell<>nil) then
        begin
          if PageX=0 then
            begin
              //    
              Grid.hTitleCell.Page := Report.CurEndPage;
              Grid.hTitleCell.XOffs := Left;
              Grid.hTitleCell.YOffs := Top;
              MoveObjects(Grid.hTitleCell);
            end;
          Report.CurEndPage.Rect.Top := Report.CurEndPage.Rect.Top+Grid.hTitleCell.Height;
        end;

      //  / 
      for i:=0 to High(PageHeadersFootersBands) do
        for j:=0 to Bands.Count-1 do
          if Bands[j].BandType=PageHeadersFootersBands[i] then
            begin
              Cell := nil;
              case Bands[j].BandType of
                btvPageHeader:
                  with TprCustomVPageHeaderBand(Bands[j]) do
                    if PrintOnFirstPage or (PageX>0) then
                      begin
                        FCrossTabGenerated := false;
                        Cell := GenerateCell(nil,nil,true);
                        if Cell<>nil then
                          begin
                            Cell.YOffs := Top;
                            Cell.XOffs := Report.CurEndPage.Rect.Left;
                            Report.CurEndPage.Rect.Left := Report.CurEndPage.Rect.Left+Cell.Width;
                            Grid.AddVPageHeaderCell(Cell);
                          end;
                      end;
                btvPageFooter:
                  with TprCustomVPageFooterBand(Bands[j]) do
                    if PrintOnFirstPage or (PageX>0) then
                      begin
                        VPageFooter := TprCustomVPageFooterBand(Bands[j]);
                        FCrossTabGenerated := false;
                        Cell := GenerateCell(nil,nil,true);
                        if Cell<>nil then
                          begin
                            Cell.YOffs := Top;
                            Report.CurEndPage.Rect.Right := Report.CurEndPage.Rect.Right-Cell.Width;
                            Cell.XOffs := Report.CurEndPage.Rect.Right;
                            Grid.AddVPageFooterCell(Cell);
                          end;
                      end;
                bthPageHeader:
                  with TprCustomHPageHeaderBand(Bands[j]) do
                    if PrintOnFirstPage or (PageY>0) then
                      begin
                        Cell := GenerateCell(nil,nil,true);
                        if Cell<>nil then
                          begin
                            Cell.XOffs := Left;
                            Cell.YOffs := Report.CurEndPage.Rect.Top;
                            Report.CurEndPage.Rect.Top := Report.CurEndPage.Rect.Top+Cell.Height;
                            Grid.AddHPageHeaderCell(Cell);
                          end;
                      end;
                bthPageFooter:
                  with TprCustomHPageFooterBand(Bands[j]) do
                    if PrintOnFirstPage or (PageY>0) then
                      begin
                        HPageFooter := TprCustomHPageFooterBand(Bands[j]);
                        Cell := GenerateCell(nil,nil,true);
                        if Cell<>nil then
                          begin
                            Cell.XOffs := Left;
                            Report.CurEndPage.Rect.Bottom := Report.CurEndPage.Rect.Bottom-Cell.Height;
                            Cell.YOffs := Report.CurEndPage.Rect.Bottom;
                            Grid.AddHPageFooterCell(Cell);
                          end;
                      end;
              end;
              if Cell<>nil then
                Cell.Page := Report.CurEndPage;
            end;
      Report.CurEndPage.AvailableRect:=Report.CurEndPage.Rect;
    end
  else
    begin
      Report.IndexCurEndPage:=i;
    end;
  end;


  function CheckHLinksList : boolean;
  var
    i : integer;
    MinVector : TprGenVector;
  begin
  Result:=false;
  if LinksList.Count>0 then
    begin
      MinVector:=LinksList[0].Vector;
      for i:=1 to LinksList.Count-1 do
        if MinVector.YOffs>LinksList[i].Vector.YOffs then
          MinVector:=LinksList[i].Vector;

      //    MinVector   
      //         
      //        :((.

      //  
      LinksList.FreeAll;

      CurVectorIndex:=Grid.IndexOfHVector(MinVector);
      Result:=true;
    end;
  end;

begin
LinksList := TLinksList.Create;
HPageFooter := nil;
VPageFooter := nil;
try
//          
//   Band     
// ,      
for i:=0 to Grid.HVectorsCount-1 do
  begin
    Vector := Grid.HVectors[i];
    MaxCell := Vector[0];
    MinCell := Vector[0];
    for j:=1 to Vector.Count-1 do
      begin
        if Vector[j].Height>MaxCell.Height then
          MaxCell := Vector[j];
        if Vector[j].Height<MinCell.Height then
          MinCell := Vector[j];
      end;
    case Vector.Band.FResizeMode of
      prbrmNone,prbrmMaxObj,prbrmMaxResizeObj:
        Vector.Height := MaxCell.Height;
      prbrmMinResizeObj:
        Vector.Height := MinCell.Height;
    end;
    for j:=0 to Vector.Count-1 do
      begin
        MinCell := Vector[j];
        for k:=0 to MinCell.ObjRecsCount-1 do
          begin
            rv := MinCell.ObjRecs[k];
            if rv.HeightAsHorizontalBand then
              rv.pRect.Bottom := rv.pRect.Top+Vector.Height-rv.pRect.Top;
          end;
      end;
  end;

for i:=0 to Grid.VVectorsCount-1 do
  begin
    Vector := Grid.VVectors[i];
    MaxCell := Vector[0];
    MinCell := Vector[0];
    for j:=1 to Vector.Count-1 do
      begin
        if Vector[j].Width>MaxCell.Width then
          MaxCell := Vector[j];
        if Vector[j].Width<MinCell.Width then
          MinCell := Vector[j];
      end;
    case Vector.Band.FResizeMode of
      prbrmNone,prbrmMaxObj,prbrmMaxResizeObj:
        Vector.Width := MaxCell.Width;
      prbrmMinResizeObj:
        Vector.Width := MinCell.Width;
    end;
    for j:=0 to Vector.Count-1 do
      begin
        MinCell := Vector[j];
        for k:=0 to MinCell.ObjRecsCount-1 do
          begin
            rv := MinCell.ObjRecs[k];
            if rv.WidthAsVerticalBand then
              rv.pRect.Right := rv.pRect.Left+Vector.Width-rv.pRect.Left;
          end;
      end;
  end;

//  ,     
StartEndPageIndex:=Report.EndPagesCount;

//   
LinksList.FreeAll;

PageX:=0;
PageY:=0;
SelectEndPage;
CurVectorIndex:=0;
while CurVectorIndex<Grid.VVectorsCount do
  begin
    Vector := Grid.VVectors[CurVectorIndex];
    Band := Vector.Band;

    if Band.GetStartNewPage then
      begin
        //     
        //     ,       
        if Grid.FindPriorVVector(CurVectorIndex,Band,0{StartEndPageIndex})<>nil then
          begin
            Inc(PageX);
            SelectEndPage;

            //  ( )   
            //      
            InsertVerticalDetailHeader(Band);

            LinksList.FreeAll;
          end
      end
    else
      begin
        if Report.CurEndPage.CurrentWidth<Vector.Width then
          begin
            //      
            Inc(PageX);
            SelectEndPage;

            //  ( )   
            InsertVerticalDetailHeader(Band);

            //     ,
            //   LinksList
            //        
            //   
            if LinksList.Count>0 then
              begin
                MinVector:=LinksList[0].Vector;
                for j:=1 to LinksList.Count-1 do
                  if MinVector.XOffs>LinksList[j].Vector.XOffs then
                    MinVector:=LinksList[j].Vector;

                //    MinVector   
                //         
                //        :((.

                //  
                LinksList.FreeAll;


                CurVectorIndex:=Grid.IndexOfVVector(MinVector);
                continue;
              end;
          end;
      end;

    if (Band.GetLinkToBand<>nil) and (Band.GetLinkType=prltAfter) then
      //  Band      
      //  Band  
      LinksList.Add(TLinkInfo.Create(Vector,Band.GetLinkToBand));

    if (Band.GetLinkToBand<>nil) and (Band.GetLinkType=prltBefore) then
      begin
        //         GetLinkToBand
        V:=Grid.FindPriorVVectorOnPage(CurVectorIndex,Band.GetLinkToBand,PageX);
        if V=nil then
          begin
            //       !!!
            //      
            V:=Grid.FindPriorVVectorOnPage(CurVectorIndex,Band.GetLinkToBand,PageX-1);
            if V<>nil then
              begin
                //  V         
                //    CurVectorIndex,      V
                //     ,    
                //    ,     
                //   Vector      
                //    :   
                //   ,   
                //  -  ,    
                j:=Grid.IndexOfVVector(V);
                MinVector:=nil;
                while (j>=0) and (Grid.VVectors[j].Page=PageX-1) do
                  begin
                    if Grid.VVectors[j].FLinkToVector=V then
                      MinVector:=Grid.VVectors[j];
                    Dec(j);
                  end;
                if MinVector<>nil then
                  V:=MinVector;

                PriorEndPage:=FindEndPage(PageX-1,0);
                if PriorEndPage.CurrentWidth+(V.XOffs-PriorEndPage.AvailableRect.Left)>=V.Width then
                  begin
                    //  
                    CurVectorIndex:=Grid.IndexOfVVector(V);
                    continue;
                  end;
              end;
          end;
      end;

    //    LinksList , 
    //   Band     Vector
    DeleteBandFromLinksList(Vector,Band);

    Vector.Page                :=PageX;
    Vector.YOffs               :=-1;
    Vector.XOffs               :=Report.CurEndPage.Rect.Left;
    Report.CurEndPage.Rect.Left:=Report.CurEndPage.Rect.Left+Vector.Width;

    Inc(CurVectorIndex);
  end;






//   ,   ,  
// - 
LinksList.FreeAll;
PageX:=0;
PageY:=0;
SelectEndPage;
CurVectorIndex:=0;
while CurVectorIndex<Grid.HVectorsCount do
  begin
    Vector := Grid.HVectors[CurVectorIndex];
    Band := Vector.Band;

    if TprCustomHBand(Vector.Band).GetUseColumns then
      begin
        //
        //  
        //
        //     
        StartPageTop     :=Report.CurEndPage.Rect.Top;
        MaxTop           :=Report.CurEndPage.Rect.Top;
        PriorColDirection:=TprCustomHBand(Vector.Band).GetColDirection;
        while (CurVectorIndex<Grid.HVectorsCount) and
              (TprCustomHBand(Grid.HVectors[CurVectorIndex].Band).GetUseColumns) and
              (TprCustomHBand(Grid.HVectors[CurVectorIndex].Band).GetColDirection=PriorColDirection) do
          begin
            Vector  :=Grid.HVectors[CurVectorIndex];
            ColWidth:=(Report.CurEndPage.AvailableRect.Right-Report.CurEndPage.AvailableRect.Left) div TprCustomHBand(Vector.Band).GetColCount;

            case PriorColDirection of
              prcdTopBottomLeftRight:
                begin
                  //    
                  if Report.CurEndPage.CurrentHeight<Vector.Height then
                    begin
                      Report.CurEndPage.Rect.Left:=Report.CurEndPage.Rect.Left+ColWidth;
                      if Report.CurEndPage.CurrentWidth<ColWidth then
                        begin
                          //  
                          Inc(PageY);
                          SelectEndPage;
                          MaxTop      :=Report.CurEndPage.Rect.Top;
                          StartPageTop:=Report.CurEndPage.Rect.Top;

                          if CheckHLinksList then
                            continue;
                        end
                      else
                        //  
                        Report.CurEndPage.Rect.Top:=StartPageTop;
                    end;
                  Vector.Page               :=PageY;
                  Vector.XOffs              :=Report.CurEndPage.Rect.Left;
                  Vector.YOffs              :=Report.CurEndPage.Rect.Top;
                  Report.CurEndPage.Rect.Top:=Report.CurEndPage.Rect.Top+Vector.Height;

                  if Report.CurEndPage.Rect.Top>MaxTop then
                    MaxTop:=Report.CurEndPage.Rect.Top;
                end;
              prcdLeftRightTopBottom:
                begin
                  if Report.CurEndPage.CurrentWidth<ColWidth then
                    begin
                      //    
                      Report.CurEndPage.Rect.Top := MaxTop;
                      Report.CurEndPage.Rect.Left := Report.CurEndPage.AvailableRect.Left;
                    end;

                  if Report.CurEndPage.CurrentHeight<Vector.Height then
                    begin
                      //    
                      Inc(PageY);
                      SelectEndPage;
                      MaxTop:=Report.CurEndPage.Rect.Top;

                      if CheckHLinksList then
                        continue;
                    end;

                  Vector.Page                :=PageY;
                  Vector.XOffs               :=Report.CurEndPage.Rect.Left;
                  Vector.YOffs               :=Report.CurEndPage.Rect.Top;
                  Report.CurEndPage.Rect.Left:=Report.CurEndPage.Rect.Left+ColWidth;

                  if Report.CurEndPage.Rect.Top+Vector.Height>MaxTop then
                    MaxTop:=Report.CurEndPage.Rect.Top+Vector.Height;
                end;
            end;
            DeleteBandFromLinksList(Vector,Vector.Band);
            //
            Inc(CurVectorIndex);
          end;

        //   
        Report.CurEndPage.Rect.Top :=MaxTop;
        Report.CurEndPage.Rect.Left:=Report.CurEndPage.AvailableRect.Left;
      end
    else
      begin
        //
        //   
        //
        if Band.GetStartNewPage then
          begin
            //     
            //     ,       
            if Grid.FindPriorHVector(CurVectorIndex,Band,0{StartEndPageIndex})<>nil then
              begin
                Inc(PageY);
                SelectEndPage;

                //  ( )   
                //      
                InsertHorizontalDetailHeader(Band);

                LinksList.FreeAll;
              end;
          end
        else
          begin
            if Report.CurEndPage.CurrentHeight<Vector.Height then
              begin
                Inc(PageY);
                SelectEndPage;

                //  ( )   
                InsertHorizontalDetailHeader(Band);

                //     ,
                //   LinksList
                //        
                //   
                if CheckHLinksList then
                  continue;
              end;
          end;
    
        if (Band.GetLinkToBand<>nil) and (Band.GetLinkType=prltAfter) then
          //  Band      
          //  Band  
          LinksList.Add(TLinkInfo.Create(Vector,Band.GetLinkToBand));
    
        if (Band.GetLinkToBand<>nil) and (Band.GetLinkType=prltBefore) then
          begin
            //         GetLinkToBand
            V:=Grid.FindPriorHVectorOnPage(CurVectorIndex,Band.GetLinkToBand,PageY);
            if V=nil then
              begin
                //       !!!
                //      
                V:=Grid.FindPriorHVectorOnPage(CurVectorIndex,Band.GetLinkToBand,PageY-1);
                if V<>nil then
                  begin
                    //  V         
                    //    CurVectorIndex,      V
                    //     ,    
                    //    ,     
                    //   Vector      
                    //    :   
                    //   ,   
                    //  -  ,    
                    j:=Grid.IndexOfHVector(V);
                    MinVector:=nil;
                    while (j>=0) and (Grid.HVectors[j].Page=PageY-1) do
                      begin
                        if Grid.HVectors[j].FLinkToVector=V then
                          MinVector:=Grid.HVectors[j];
                        Dec(j);
                      end;
                    if MinVector<>nil then
                      V:=MinVector;
    
                    PriorEndPage:=FindEndPage(0,PageY-1);
                    if PriorEndPage.CurrentHeight+(V.YOffs-PriorEndPage.AvailableRect.Top)>=V.Height then
                      begin
                        //  
                        CurVectorIndex:=Grid.IndexOfHVector(V);
                        continue;
                      end;
                  end;
              end;
          end;
    
        //    LinksList , 
        //   Band     Vector
        DeleteBandFromLinksList(Vector,Band);

        Vector.Page               :=PageY;
        Vector.XOffs              :=Report.CurEndPage.AvailableRect.Left;
        Vector.YOffs              :=Report.CurEndPage.Rect.Top;
        Report.CurEndPage.Rect.Top:=Report.CurEndPage.Rect.Top+Vector.Height;
        //    
        Inc(CurVectorIndex);
      end;
  end;

//       
for i:=0 to Grid.CellsCount-1 do
  begin
    Cell := Grid.Cells[i];
    if Cell.VVector=nil then
      begin
        //     -   
        //   
        //    ,    
        //    CrossTab ( )
        PageX := 0;
        PageY := Cell.HVector.Page;
        SelectEndPage;
        Cell.Page := Report.CurEndPage;
        Cell.YOffs := Cell.HVector.YOffs;
        Cell.XOffs := Cell.HVector.XOffs
      end
    else
      if Cell.HVector=nil then
        begin
          PageX := Cell.VVector.Page;
          PageY := 0;
          SelectEndPage;
          Cell.Page := Report.CurEndPage;
          Cell.XOffs := Cell.VVector.XOffs;
          Cell.YOffs := Report.CurEndPage.AvailableRect.Top;
        end
      else
        begin
          PageX := Cell.VVector.Page;
          PageY := Cell.HVector.Page;
          SelectEndPage;
          Cell.Page := Report.CurEndPage;
          Cell.XOffs := Cell.VVector.XOffs;
          Cell.YOffs := Cell.HVector.YOffs;
        end;
  end;

//   ,   
//    
//  - ,  - ,      ,
//         (     )
if Grid.VVectorsCount>0 then
  begin
    for i:=0 to Report.EndPagesCount-1 do
      for j:=i+1 to Report.EndPagesCount-1 do
        if (Report.EndPages[i].PageY>Report.EndPages[j].PageY) or
           ((Report.EndPages[i].PageY=Report.EndPages[j].PageY) and (Report.EndPages[i].PageX>Report.EndPages[j].PageX)) then
          Report.FEndPages.Exchange(i,j);
  end;

//     ,     
// PrintAfterLastBandOnPage=true       
//   
if (HPageFooter<>nil) and HPageFooter.PrintAfterLastBandOnPage then
  begin
    if Grid.HVectorsCount=0 then
      begin
        for i:=0 to Grid.HPageFooterCellsCount-1 do
          Grid.HPageFooterCells[i].YOffs := Grid.HPageFooterCells[i].Page.AvailableRect.Top;
      end
    else
      begin
        PriorPage := 0;
        i := 0;
        while i<Grid.HVectorsCount do
          begin
            MaxTop := 0;
            while (i<Grid.HVectorsCount) and (Grid.HVectors[i].Page=PriorPage) do
              begin
                if MaxTop<Grid.HVectors[i].YOffs+Grid.HVectors[i].Height then
                  MaxTop := Grid.HVectors[i].YOffs+Grid.HVectors[i].Height;
                Inc(i);
              end;
            for j:=0 to Grid.HPageFooterCellsCount-1 do
              if Grid.HPageFooterCells[j].Page.PageY=PriorPage then
                Grid.HPageFooterCells[j].YOffs := MaxTop;
            if i<Grid.HVectorsCount then
              PriorPage := Grid.HVectors[i].Page;
          end;
      end;
  end;

if (VPageFooter<>nil) and VPageFooter.PrintAfterLastBandOnPage then
  begin
    if Grid.VVectorsCount=0 then
      begin
        for i:=0 to Grid.VPageFooterCellsCount-1 do
          Grid.VPageFooterCells[i].XOffs := Grid.VPageFooterCells[i].Page.AvailableRect.Left;
      end
    else
      begin
        PriorPage := 0;
        i := 0;
        while i<Grid.VVectorsCount do
          begin
            MaxTop := 0;
            while (i<Grid.VVectorsCount) and (Grid.VVectors[i].Page=PriorPage) do
              begin
                if MaxTop<Grid.VVectors[i].XOffs+Grid.VVectors[i].Width then
                  MaxTop := Grid.VVectors[i].XOffs+Grid.VVectors[i].Width;
                Inc(i);
              end;
            for j:=0 to Grid.VPageFooterCellsCount-1 do
              if Grid.VPageFooterCells[j].Page.PageX=PriorPage then
                Grid.VPageFooterCells[j].XOffs := MaxTop;
            if i<Grid.VVectorsCount then
              PriorPage := Grid.VVectors[i].Page;
          end;
      end;
  end;

//   ,  -     
// EndPage
MoveCellsObjects(Grid.FCells);
MoveCellsObjects(Grid.FHPageFooterCells);
MoveCellsObjects(Grid.FVPageFooterCells);
MoveCellsObjects(Grid.FHPageHeaderCells);
MoveCellsObjects(Grid.FVPageHeaderCells);

finally
  LinksList.Free;
end;
end;


procedure TprCustomPage.UpdateBandsPageRect;
var
  r : TRect;
  i,j : integer;
begin
for i:=0 to Bands.Count-1 do
  Bands[i].FCalced:=false;

r:=GetPageRect;
for i:=0 to MAX_PAGEBANDSORDER do
  for j:=0 to Bands.Count-1 do
    if Bands[j].BandType=PageBandsOrder[i] then
      Bands[j].CalcdPageRect(r,nil);

r:=GetPageRect;
for i:=0 to MAX_PAGEBANDSORDERVERT do
  for j:=0 to Bands.Count-1 do
    if Bands[j].BandType=PageBandsOrderVert[i] then
      Bands[j].CalcdPageRect(r,nil);
end;

procedure TprCustomPage.DrawDesign;
begin
end;

///////////////////////////
//
// TprCustomReport
//
///////////////////////////
constructor TprCustomReport.Create;
begin
inherited;
FExportOptions := [preoShowParamsDlg,preoShowProgress,preoShowAfterGenerate];

ObjectCalcSizesDevice := nil;

Designer := nil;

FReportPrepared := false;

FCollate := false;
FCopies := 1;
FFromPage := -1;
FToPage := -1;

FPreviewUserDataList := TList.Create;
FGACList := TStringList.Create;
FEndPages := TList.Create;
FPages := TList.Create;
FPrintPagesList := TList.Create;

Groups := TprGroups.Create;
FValues := TprValues.Create(TprValue);
FValues.Report := Self;

SystemValues := TprValues.Create(TprValue);
SystemValues.Report := Self;

FParser := TprParser.Create(Self);

with TprValue(SystemValues.Add) do
  begin
    Name := 'PagesCount';
    ResetOn := rvtReport;
    CalcOn := cvtEventOnReset;
    OnCalc := OnCalcPagesCount;
  end;
with TprValue(SystemValues.Add) do
  begin
    Name := 'Page';
    ResetOn := rvtReport;
    CalcOn := cvtEventOnReset;
    OnGetVersionByVersionID := OnCalcPageNo;
    OnCalc := OnCalcPageNo2;
  end;

{$IFDEF PR_D4}
prCreatedReports.Add(Self);
{$ENDIF}
end;

destructor TprCustomReport.Destroy;
begin
{$IFDEF DEBUG}
WriteToLog('TprCustomReport.Destroy');
{$ENDIF}
if FProgressForm<>nil then
  FProgressForm.Free;
{$IFDEF DEBUG}
WriteToLog('FProgressForm.Free');
{$ENDIF}
if FPreviewForm<>nil then
  FPreviewForm.Free;
{$IFDEF DEBUG}
WriteToLog('FPreviewForm.Free');
{$ENDIF}
if FDesignerForm<>nil then
  FDesignerForm.Free;
{$IFDEF DEBUG}
WriteToLog('FDesignerForm.Free');
{$ENDIF}

while PagesCount>0 do
  Pages[0].Free;

while Groups.Count>0 do
  Groups[0].Free;

ClearEndPages;  
FEndPages.Free;
FPages.Free;
FParser.Free;
FValues.Free;
SystemValues.Free;
Groups.Free;
FGACList.Free;
FPrintPagesList.Free;
ClearPreviewUserDataList;
FPreviewUserDataList.Free;

{$IFDEF PR_D4}
prCreatedReports.Remove(Self);
{$ENDIF}
inherited;
end;

procedure TprCustomReport.Loaded;
var
  i,j,k : integer;
begin
{$IFDEF DEBUG}
WriteToLog('TprCustomReport.Loaded');
{$ENDIF}
inherited;

for i:=0 to PagesCount-1 do
  for j:=0 to Pages[i].Bands.Count-1 do
    for k:=0 to Pages[i].Bands[j].Objects.Count-1 do
      Pages[i].Bands[j].Objects[k].AfterReportLoaded;
for i:=0 to PagesCount-1 do
  for j:=0 to Pages[i].Bands.Count-1 do
    Pages[i].Bands[j].AfterReportLoaded;
end;

function TprCustomReport.GetChildOwner;
begin
Result:=Self;
end;

procedure TprCustomReport.GetChildren;
var
  i : integer;
begin
for i:=0 to PagesCount-1 do
  Proc(Pages[i]);
for i:=0 to Groups.Count-1 do
  Proc(Groups[i]);
end;

procedure TprCustomReport.Notification;
var
  i : integer;
begin
{$IFDEF DEBUG}
WriteToLog('TprCustomReport.Notification : '+Name+' '+GetEnumName(TypeInfo(TOperation),integer(Operation))+' AComponent : '+AComponent.Name);
{$ENDIF}
if (Operation=opRemove) and (AComponent<>Self) then
  begin
    if AComponent is TprGroup then
      begin
        Groups.Remove(AComponent);
        for i:=0 to AllValuesCount-1 do
          if AllValues[i].Group=AComponent then
            AllValues[i].Group:=nil;
      end;

    if AComponent is TprCustomPage then
      FPages.Remove(AComponent);
  end;

inherited;
end;

function TprCustomReport.GetprOwner;
begin
Result:=Self;
end;

procedure TprCustomReport.DefineProperties;
begin
inherited;
Filer.DefineProperty('SystemInfo',ReadSystemInfo,WriteSystemInfo,true);
end;

procedure TprCustomReport.ReadSystemInfo;
begin
Reader.ReadListBegin;
while not Reader.EndOfList do
  Reader.ReadString;
Reader.ReadListEnd;
end;

procedure TprCustomReport.WriteSystemInfo;
const
  PlatformIDs : array [0..2] of string = ('WIN32s','WIN32_WINDOWS','WIN32_NT');
var
  s : string;
  si : SYSTEM_INFO;
  ovi : OSVERSIONINFO;
begin
Writer.WriteListBegin;

ZeroMemory(@ovi,sizeof(ovi));
ovi.dwOSVersionInfoSize := sizeof(ovi);
if GetVersionEx(ovi) then
  begin
    if ovi.dwPlatformId<=2 then
      s := PlatformIDs[ovi.dwPlatformId]
    else
      s := 'Unknown';
    Writer.WriteString(Format('OS: %s %d.%d.%d %s',[s,ovi.dwMajorVersion,ovi.dwMinorVersion,ovi.dwBuildNumber,StrPas(ovi.szCSDVersion)]));
    Writer.WriteString('');
  end;

GetSystemInfo(si);
Writer.WriteString(Format('PageSize: %d',[si.dwPageSize]));
Writer.WriteString(Format('ActiveProcessorMask: $%4.4x',[si.dwPageSize]));
Writer.WriteString(Format('NumberOfProcessors: %d',[si.dwNumberOfProcessors]));
Writer.WriteString(Format('ProcessorType: %d',[si.dwProcessorType]));
Writer.WriteString('');

{$IFDEF PR_D4}
  Writer.WriteString('Compiler version: Delphi4');
{$ENDIF}
{$IFDEF PR_D5}
  {$IFDEF PR_CB5}
    Writer.WriteString('Compiler version: Builder5');
  {$ELSE}
    Writer.WriteString('Compiler version: Delphi5');
  {$ENDIF}
{$ENDIF}
{$IFDEF PR_D6}
  Writer.WriteString('Compiler version: Delphi6');
{$ENDIF}
Writer.WriteString('PReport version: '+SPReportVersion);

Writer.WriteListEnd;
end;



function TprCustomReport.GetAllValuesCount;
begin
Result:=FValues.Count+SystemValues.Count;
end;

function TprCustomReport.GetAllValue;
begin
if i<SystemValues.Count then
  Result:=SystemValues[i]
else
  Result:=FValues[i-SystemValues.Count];
end;

function TprCustomReport.ADSRN_GetIndex(Dataset : TprDatasetLink) : integer;
begin
Result:=0;
while (Result<Length(ADSRN)) and (ADSRN[Result].DataSet<>DataSet) do Inc(Result);
if Result>=Length(ADSRN) then
  Result:=-1;
end;

function TprCustomReport.ADSRN_GetIndex(Dataset : TObject) : integer;
begin
Result:=0;
while (Result<Length(ADSRN)) and (ADSRN[Result].DataSet.Dataset<>DataSet) do Inc(Result);
if Result>=Length(ADSRN) then
  Result:=-1;
end;

procedure TprCustomReport.ADSRN_First;
var
  i : integer;
begin
i:=ADSRN_GetIndex(Dataset);
if i<>-1 then
  ADSRN[i].RecNo:=1
else
  begin
    SetLength(ADSRN,Length(ADSRN)+1);
    ADSRN[High(ADSRN)].DataSet:=DataSet;
    ADSRN[High(ADSRN)].RecNo  :=1;
  end;
end;

procedure TprCustomReport.ADSRN_Next;
var
  i : integer;
begin
i:=ADSRN_GetIndex(Dataset);
if (i<>-1) and (not ADSRN[i].DataSet.Eof) then
  ADSRN[i].RecNo:=ADSRN[i].RecNo+1
else
  begin
    SetLength(ADSRN,Length(ADSRN)+1);
    ADSRN[High(ADSRN)].DataSet:=DataSet;
    ADSRN[High(ADSRN)].RecNo  :=1;
  end;
end;

function  TprCustomReport.GetDataSetRecNo(Dataset : TprDatasetLink) : integer;
var
  i : integer;
begin
i:=ADSRN_GetIndex(Dataset);
if i<>-1 then
  Result:=ADSRN[i].RecNo
else
  Result:=-1;
end;

function  TprCustomReport.GetDataSetRecNo(Dataset : TObject) : integer;
var
  i : integer;
begin
i:=ADSRN_GetIndex(Dataset);
if i<>-1 then
  Result:=ADSRN[i].RecNo
else
  Result:=-1;
end;

procedure TprCustomReport.OnCalcPagesCount;
begin
Value.CurrentValue:=EndPagesCount;
end;

procedure TprCustomReport.OnCalcPageNo;
begin
ValueVersion.V:=IndexCurEndPage+1;
end;

procedure TprCustomReport.OnCalcPageNo2;
begin
Value.CurrentValue:=0;
end;

function TprCustomReport.GetPage;
begin
Result:=TprCustomPage(FPages[index]);
end;

function TprCustomReport.GetEndPage;
begin
Result:=TprCustomEndPage(FEndPages[index]);
end;

function TprCustomReport.PagesCount;
begin
Result:=FPages.Count;
end;

function TprCustomReport.EndPagesCount;
begin
Result:=FEndPages.Count;
end;

function TprCustomReport.CurEndPage;
begin
if (IndexCurEndPage<0) or (IndexCurEndPage>=FEndPages.Count) then
  Result:=nil
else
  Result:=TprCustomEndPage(FEndPages[IndexCurEndPage]);
end;

procedure TprCustomReport.AddEndPage;
begin
FEndPages.Add(CreateEndPage(Page));
IndexCurEndPage := FEndPages.Count-1;
end;

procedure TprCustomReport.AddEndPageToList;
begin
FEndPages.Add(EndPage);
end;

procedure TprCustomReport.InsertEndPageIntoList;
begin
FEndPages.Insert(i,EndPage);
end;

function TprCustomReport.EndPageIndex;
begin
Result := FEndPages.IndexOf(EndPage);
end;

procedure TprCustomReport.DeleteEndPage;
begin
EndPages[index].Free;
FEndPages.Delete(index);
end;

function TprCustomReport.Calc;
var
  v : TprVarValue;
begin
if TprParser(FParser).Calc(Expression,v) then
  Result := _vAsVariant(v)
else
  raise Exception.Create(prLoadStr(sErrorCalcExpressionInOnePass));
end;

function TprCustomReport.FormatTemplate;
begin
Result:=TprParser(FParser).FormatTemplate(Template,Res);
end;

function TprCustomReport.FormatStrings;
var
  i : integer;
  s,Buf : string;
begin
Buf   :='';
Result:=true;
for i:=0 to lSource.Count-1 do
  begin
    Result:=FormatTemplate(lSource[i],s) and Result;
    //   #13,#10
    if (Trim(s)<>'') or (not DeleteEmptyLines) then
      begin
        if Buf='' then
          Buf:=s
        else
          Buf:=Buf+#13#10+s;
      end;
  end;

lDest.Text:=Buf;

if not DeleteEmptyLines and DeleteEmptyLinesAtEnd then
  begin
    while lDest.Count>0 do
      begin
        if Trim(lDest[lDest.Count-1])<>'' then
          break;
        lDest.Delete(lDest.Count-1);
      end;
  end;
end;

function DoDisableWindow(Window: HWND; Data: Longint): Bool; stdcall;
var
  l : integer;
  r : TprCustomReport;
begin
if IsWindowVisible(Window) and IsWindowEnabled(Window) then
  begin
    r := TprCustomReport(Data);
    l := Length(r.FDisabledWindows);
    SetLength(r.FDisabledWindows,l+1);
    r.FDisabledWindows[l] := Window;
    EnableWindow(Window, False);
  end;
Result := True;
end;

procedure TprCustomReport.CreateProgressForm;
begin
FLastActiveWindow := GetActiveWindow;
EnumThreadWindows(GetCurrentThreadID,@DoDisableWindow,integer(Self));
FProgressForm := TprProgressForm.Create(Application);
FProgressForm.InitPF(Caption,Max);
end;

procedure TprCustomReport.CloseProgressForm;
var
  i : integer;
begin
if FProgressForm=nil then exit;
for i:=0 to High(FDisabledWindows) do
  EnableWindow(FDisabledWindows[i],true);
SetLEngth(FDisabledWindows,0);
if FLastActiveWindow<>0 then
  SetActiveWindow(FLastActiveWindow);
FProgressForm.Free;
FProgressForm := nil;
end;

procedure TprCustomReport.DoOnBandGenerateCell;
begin
if Assigned(OnBandGenerateCell) then
  OnBandGenerateCell(Self,Band);
end;

procedure TprCustomReport.DoOnDataSetNext;
var
  i : integer;
begin
for i:=0 to AllValuesCount-1 do
  begin
    if (AllValues[i].CalcOn=cvtDataSetNext) and (AllValues[i].Dataset.Dataset=DataSet.Dataset) then
      AllValues[i].Calculate(Cell);

    if (AllValues[i].CalcOn=cvtCrossTab) and (AllValues[i].CrossTabHorzDataSet.Dataset=DataSet.Dataset) then
      begin
        //    
        //        
        //  DetailBand
        if (HorizontalBand<>nil) and (HorizontalBand.BandType in [bthDetail]) then
          AllValues[i].Calculate(Cell);
      end;
  end;
end;

procedure TprCustomReport.DoOnGroupEnd;
var
  i : integer;
begin
for i:=0 to AllValuesCount-1 do
  begin
    if (AllValues[i].ResetOn=rvtGroup) and (AllValues[i].Group=Group) then
      begin
        AllValues[i].Reset;
      end;
  end;
end;

procedure TprCustomReport.DoOnDataSetEof;
var
  i : integer;
begin
for i:=0 to AllValuesCount-1 do
  begin
    if (AllValues[i].ResetOn=rvtDataSetEof) and (AllValues[i].ResetDataSet.Dataset=DataSet.Dataset) then
      begin
        AllValues[i].Reset;
      end;

    if AllValues[i].CalcOn=cvtCrossTab then
      begin
        if AllValues[i].CrossTabHorzDataSet.Dataset=DataSet.Dataset then
          begin
            //  Eof   
          end;
      end;
  end;
end;

procedure TprCustomReport.DoOnPageEnd;
begin
if Assigned(FOnPageEnd) then
  FOnPageEnd(Self,EndPage);
end;

procedure TprCustomReport.DoOnPageStart;
begin
if Assigned(FOnPageStart) then
  FOnPageStart(Self,EndPage);
end;

procedure TprCustomReport.DoOnPreviewMouseMove;
begin
if Assigned(FOnPreviewMouseMove) then
  FOnPreviewMouseMove(Self,PreviewUserData,cur,HighlightObject);
end;

procedure TprCustomReport.DoOnPreviewMouseDown;
begin
if Assigned(FOnPreviewMouseDown) then
  FOnPreviewMouseDown(Self,PreviewUserData,Shift);
end;

procedure TprCustomReport.DoOnPreviewDblClick;
begin
if Assigned(FOnPreviewDblClick) then
  FOnPReviewDblClick(Self,PreviewUserData);
end;

procedure TprCustomReport.DoOnPreviewGetUserData;
begin
PreviewUserData := nil;
if Assigned(FOnPreviewGetUserData) then
  begin
    FOnPreviewGetUserData(Self,Obj,ObjRec,PreviewUserData);
    if PreviewUserData<>nil then
      FPreviewUserDataList.Add(PreviewUserData);
  end;
end;

procedure TprCustomReport.DoOnFirstPassObject;
begin
ManuallyProcessed := false;
if Assigned(FOnFirstPassObject) then
  FOnFirstPassObject(Self,Sender,ManuallyProcessed);
end;

procedure TprCustomReport.ConvertToDesignerCoords;
begin
if DesignerForm<>nil then
  DesignerForm.ConvertToDesignerCoords(rSource,rDest)
else
  rDest := rSource;
end;

procedure TprCustomReport.ClearPreviewUserDataList;
var
  i : integer;
begin
for i:=0 to FPreviewUserDataList.Count-1 do
  TprPreviewUserData(FPreviewUserDataList[i]).Free;
FPreviewUserDataList.Clear;
end;

procedure TprCustomReport.ClearGrids;
var
  i : integer;
begin
for i:=0 to PagesCount-1 do
  Pages[i].Grid.Clear;
end;

procedure TprCustomReport.AddPreviewUserData;
begin
FPreviewUserDataList.Add(PreviewUserData);
end;

procedure TprCustomReport.ClearEndPages;
begin
while EndPagesCount>0 do
  DeleteEndPage(0);
end;

procedure TprCustomReport.ClearValuesVersions;
var
  i : integer;
begin
for i:=0 to Values.Count-1 do
  Values[i].Clear;
for i:=0 to SystemValues.Count-1 do
  SystemValues[i].Clear;
end;

procedure TprCustomReport.ClearPreparedReport;
begin
if FPreviewForm<>nil then
  FPreviewForm.Free;
ClearEndPages;
ClearPreviewUserDataList;
end;

//
//      
//
function TprCustomReport.PrepareReport;
var
  i : integer;
  ep : TprCustomEndPage;
begin
FActionCanceled := false;
Result := false;
FReportPrepared := false;

if PreviewForm<>nil then
  PreviewForm.Free;

StartDateTime := Now;
IndexCurEndPage := -1;
FProgressForm := nil;

if ShowProgress then
  CreateProgressForm(prLoadStr(sCreateReportCaption),0);

try
  try
    SetLength(ADSRN,0);

    //    
    ClearEndPages;
    ClearPreviewUserDataList;

    //   
    for i:=0 to AllValuesCount-1 do
      begin
        AllValues[i].Clear;
        AllValues[i].Init;
      end;

    //  ,  Grid
    i:=0;
    while i<PagesCount do
      begin
        Pages[i].FirstPassGenerateGrid;
        Inc(i);
      end;

    //    Grid  
    i:=0;
    while i<PagesCount do
      begin
        Pages[i].SecondPassPlaceGridOnEndPage;
        Inc(i);
      end;

    //   ,     
    for i:=0 to AllValuesCount-1 do
      AllValues[i].Reset;

    //      
    i:=0;
    while i<EndPagesCount do
      begin
        UpdateProgressForm(Format(prLoadStr(sThirdPassCaption),[i+1,EndPagesCount]));

        IndexCurEndPage := i;
        ep := EndPages[i];

        ep.ThirdPass;

        ep.FreeGeneratedObjects;

        Inc(i);
      end;

    FReportPrepared := true;
    Result := true;
  except
    on E : Exception do
      begin
        ClearEndPages;
        ClearPreviewUserDataList;
        ClearGrids;
        if E is EActionCanceled then
          FActionCanceled:=true
        else
          raise;
      end;
  end;

finally
  CloseProgressForm;
  Finalize(ADSRN);
  ClearValuesVersions;
  TprParser(Parser).ClearInternalStructs;
end;
end;

function TprCustomReport.GetDataSetByName;
var
  i : integer;
  L : TStringList;
begin
L:=TStringList.Create;
try
  GetAvailableDataSets(L);
  i:=L.IndexOf(DataSetName);
  if i=-1 then
    Result:=nil
  else
    Result:=TDataSet(L.Objects[i]);
finally
  L.Free;
end;
end;

procedure TprCustomReport.GetAvailableDataSets;
var
  i : integer;
begin
if Assigned(OnGetAvailableDatasets) then
  begin
    L.Clear;
    FOnGetAvailableDatasets(Self,L);
  end
else
  begin
    GetAvailableComponents(L);
    //   TDataSet
    i:=0;
    while i<L.Count do
      if (TComponent(L.Objects[i]) is TDataSet) or (TComponent(L.Objects[i]) is TprDataSet) then
        Inc(i)
      else
        L.Delete(i);
  end;
end;

procedure TprCustomReport.GetAvailableComponents;
var
  i{$IFDEF PR_D6},j{$ENDIF} : integer;

  procedure AddComponents(C : TComponent);
  var
    i,j : integer;
  begin
  for i:=0 to C.ComponentCount-1 do
    begin
      // component must have method or property
      j:=1;
      while (j<=prMAX_OBJFUNCTIONS) and not (C.Components[i] is ObjFuncInfo[j].ObjClassRef) do Inc(j);
      if j>prMAX_OBJFUNCTIONS then
        begin
          j:=1;
          while (j<=prMAX_OBJPROPS) and not (C.Components[i] is ObjPropInfo[j].ObjClassRef) do Inc(j);
          if j>prMAX_OBJPROPS then continue;
        end;
      // add this component
      if L.IndexOfObject(C.Components[i])=-1 then
        begin
          if (Owner=C) or (C=Self) then
            L.AddObject(C.Components[i].Name,C.Components[i])
          else
            L.AddObject(C.Name+'.'+C.Components[i].Name,C.Components[i])
        end;
    end;
  end;


begin
L.Clear;
L.AddObject(prLoadStr(sReportObjectName),Self);

if Assigned(OnGetAvailableComponents) then
  begin
    FOnGetAvailableComponents(Self,L);
  end
else
  begin
    AddComponents(Self);
    if Owner<>nil then
      AddComponents(Owner);

{$IFDEF PR_D6}
    if csDesigning in ComponentState then
      begin
        for i:=0 to Screen.CustomFormCount-1 do
          if AnsiCompareText(Screen.CustomForms[i].ClassName,'TDataModuleForm')=0 then
            for j:=0 to Screen.CustomForms[i].ComponentCount-1 do
              if Screen.CustomForms[i].Components[j] is TDataModule then
                AddComponents(Screen.CustomForms[i].Components[j])
      end
    else
      begin
        for i:=0 to Screen.DataModuleCount-1 do
          AddComponents(Screen.DataModules[i]);
      end;
{$ELSE}
    for i:=0 to Screen.DataModuleCount-1 do
      AddComponents(Screen.DataModules[i]);
{$ENDIF}

{$IFDEF DEBUG}
    WriteToLog('Screen.FormCount = '+IntToStr(Screen.FormCount));
{$ENDIF}
    for i:=0 to Screen.FormCount-1 do
      AddComponents(Screen.Forms[i]);
  end;
end;

procedure TprCustomReport.TranslateObjectName;
var
  j,l,p : integer;
  ModuleName : string;
begin
l        :=Length(Ident);
Component:=nil;
LastName :='';

// -   
p:=l;
while (p>=1) and (Ident[p]<>'.') do Dec(p);
if p<1 then exit;

ModuleName:=Copy(Ident,1,p-1);
Component :=Self.FindComponent(ModuleName);
if Component<>nil then
  begin
    LastName:=Copy(Ident,p+1,l);
    exit;
  end;

// p          -     Ident
// ModuleName -    
if Assigned(OnGetAvailableComponents) then
  begin
    FGACList.Clear;
    OnGetAvailableComponents(Self,FGACList);
    
    j:=0;
    while (j<FGACList.Count) and
          (CompText(FGACList[j],ModuleName)<>0) do Inc(j);
    if j<FGACList.Count then
      begin
        Component:=TComponent(FGACList.Objects[j]);
        LastName :=Copy(Ident,p+1,l);
      end;
  end
else
  begin
    //   ( )  :
    //   -   Owner    
    //   - DataModule  
    //   -   
    p        :=1;
    LastName :=ExtractSubStr(Ident,p,['.']);
    Component:=Owner.FindComponent(LastName);
    if Component=nil then
      begin
        j:=0;
        while (j<Screen.DataModuleCount) and
              (CompText(Screen.DataModules[j].Name,LastName)<>0) do Inc(j);
        if j>=Screen.DatamoduleCount then
          begin
            j:=0;
            while (j<Screen.FormCount) and
                  (CompText(Screen.Forms[j].Name,LastName)<>0) do Inc(j);
            if j<Screen.FormCount then
              Component:=Screen.Forms[j];
          end
        else
          Component:=Screen.DataModules[j];
      end;

    if Component<>nil then
      begin
        LastName:=ExtractSubStr(Ident,p,['.']);
        while (p<=l) and (Component<>nil) do
          begin
            Component:=Component.FindComponent(LastName);
            LastName :=ExtractSubStr(Ident,p,['.']);
          end;
      end;
  end;
end;

procedure TprCustomReport.UpdateProgressForm;
begin
if FProgressForm<>nil then
  FProgressForm.UpdatePF(Text);
end;

procedure TprCustomReport.DesignReport;
var
  FormClass : TClass;
begin
FReportPrepared:=false;
if DesignerForm<>nil then
  begin
    DesignerForm.Show;
  end
else
  begin
    if not (csDesigning in ComponentState) and (DesignerFormMode=fmMDIChild) and Modal then
      raise Exception.Create(prLoadStr(sErrorNoModalForMDIChild));

    FormClass:=GetClass(GetDesignerFormClass);
    if FormClass=nil then
      raise Exception.Create(prLoadStr(sErrorDesignerClassNotFound));

    TprDesignerClass(FormClass).CreateDesigner(nil,Self);
    if Assigned(OnCreateDesigner) then
      OnCreateDesigner(Self);

    if Modal then
      DesignerForm.ShowModal
    else
      DesignerForm.Show;
  end;

if DesignerForm.WindowState=wsMinimized then
  DesignerForm.WindowState:=wsNormal;
end;

procedure TprCustomReport.PreviewPreparedReport;
var
  FormClass : TClass;
begin
if CheckEndPagesCountOnPreview and (EndPagesCount<=0) then
  raise Exception.Create(prLoadStr(sReportEmptyInPreview));

if PreviewForm<>nil then
  begin
    PreviewForm.Show;
  end
else
  begin
    if not (csDesigning in ComponentState) and (DesignerFormMode=fmMDIChild) and Modal then
      raise Exception.Create(prLoadStr(sErrorNoModalForMDIChild));

    FormClass:=GetClass(GetPreviewFormClass);
    if FormClass=nil then
      raise Exception.Create(prLoadStr(sErrorPreviewClassNotFound));

    TprPreviewClass(FormClass).CreatePreview(nil,Self);
    if Assigned(OnCreatePreview) then
      OnCreatePreview(Self);

    if Modal then
      PreviewForm.ShowModal
    else
      PreviewForm.Show;
  end;

if PreviewForm.WindowState=wsMinimized then
  PreviewForm.WindowState:=wsNormal;
end;

procedure TprCustomReport.ClearTemplate;
begin
while PagesCount>0 do
  Pages[0].Free;

while Groups.Count>0 do
  Groups[0].Free;

Values.Clear;
end;

procedure TprCustomReport.SetTemplateChanged;
begin
FTemplateChanged:=Value;
if Assigned(prTemplateChangedGlobalProc) then
  prTemplateChangedGlobalProc(Self);
end;

function TprCustomReport.CheckEndPagesCountOnPreview;
begin
Result := true;
end;

//
//    
//
procedure TprCustomReport.SaveTemplate;
var
  s : string;
  ms : TMemoryStream;
begin
s:=Name;
try
  Name:='';
  if InBinaryFormat then
    begin
      Stream.WriteComponent(Self);
    end
  else
    begin
      ms:=TMemoryStream.Create;
      try
        ms.WriteComponent(Self);
        ms.Seek(0,soFromBeginning);
        ObjectBinaryToText(ms,Stream);
      finally
        ms.Free;
      end;
    end;
  FTemplateChanged:=false;
finally
  Name:=s
end;
end;

procedure TprCustomReport.LoadTemplate;
var
  s : string;
  ms : TMemoryStream;
begin
ClearTemplate;
s:=Name;
try
  if InBinaryFormat then
    begin
      Stream.ReadComponent(Self);
    end
  else
    begin
      ms:=TMemoryStream.Create;
      try
        ObjectTextToBinary(Stream,ms);
        ms.Seek(0,soFromBeginning);
        ms.ReadComponent(Self);
      finally
        ms.Free;
      end;
    end;
  FReportPrepared :=false;
  FTemplateChanged:=false;
finally
  Name:=s
end;
end;

procedure TprCustomReport.SaveTemplateToFile;
var
  fs : TFileStream;
begin
fs:=TFileStream.Create(FileName,fmCreate);
try
  SaveTemplate(fs,InBinaryFormat);
finally
  fs.Free;
end;
end;

procedure TprCustomReport.SaveTemplateToStrings;
var
  ms : TMemoryStream;
begin
ms:=TMemoryStream.Create;
try
  SaveTemplate(ms,false);
  ms.Seek(0,soFromBeginning);
  Dest.LoadFromStream(ms);
finally
  ms.Free;
end;
end;

procedure TprCustomReport.LoadTemplateFromStrings;
var
  ms : TMemoryStream;
begin
if Source.Count=0 then exit;
ms:=TMemoryStream.Create;
try
  Source.SaveToStream(ms);
  ms.Seek(0,soFromBeginning);
  LoadTemplate(ms,false);
finally
  ms.Free;
end;
end;

procedure TprCustomReport.LoadTemplateFromFile;
var
  fs : TFileStream;
begin
fs := TFileStream.Create(FileName,fmOpenRead);
try
  ClearTemplate;
  LoadTemplate(fs,InBinaryFormat);
finally
  fs.Free;
end;
end;

procedure TprCustomReport.LoadPreparedReport;
begin
end;

procedure TprCustomReport.AppendPreparedReport;
begin
end;

procedure TprCustomReport.SavePreparedReport;
begin
end;

procedure TprCustomReport.LoadPreparedReportFromFile;
var
  fs : TFileStream;
begin
fs := TFileStream.Create(FileName,fmOpenRead);
try
  LoadPreparedReport(fs);
finally
  fs.Free;
end;
end;

procedure TprCustomReport.AppendPreparedReportFromFile;
var
  fs : TFileStream;
begin
fs := TFileStream.Create(FileName,fmOpenRead);
try
  AppendPreparedReport(fs);
finally
  fs.Free;
end;
end;

procedure TprCustomReport.SavePreparedReportToFile;
var
  fs : TFileStream;
begin
fs := TFileStream.Create(FileName,fmCreate);
try
  SavePreparedReport(fs);
finally
  fs.Free;
end;
end;

function TprCustomReport.GetBandClass;
begin
Result:=nil;
end;

{$IFDEF PR_D4}
var
  OldFindGlobalComponent : TFindGlobalComponent;

function FindGlobalComponent(const Name: string): TComponent;
var
  i : integer;
begin
Result:=nil;
i     :=0;
while (i<prCreatedReports.Count) and
      ((TComponent(prCreatedReports[i]).Name='') or
       (CompText(TComponent(prCreatedReports[i]).Name,Name)<>0)) do Inc(i);
if i<prCreatedReports.Count then
  Result:=TComponent(prCreatedReports[i])
else
  if Assigned(OldFindGlobalComponent) then
    Result:=OldFindGlobalComponent(Name);
end;
{$ENDIF}

var
  i : integer;
  buf : array [0..255] of string;

initialization

RegisterClass(TprPreviewUserData);
{$IFDEF DEBUG}
WriteToLog('initialization: '+ParamStr(0));
{$ENDIF}

{$IFDEF PR_D4}
prCreatedReports := TList.Create;
OldFindGlobalComponent := Classes.FindGlobalComponent;
Classes.FindGlobalComponent := FindGlobalComponent;
{$ENDIF}

prGetComponentsReportDesc  :=prLoadStr(sGetComponentsReportDesc);
for i:=integer(Low(TprBandType)) to integer(High(TprBandType)) do
  BandTitles[TprBandType(i)] := prLoadStr(sBandTitlesOffset-i);
for i:=0 to 23 do
  MonthsArray[(i div 12)+1,i-(i div 12)*12+1] := prLoadStr(sMonthsNamesOffset-i);

if GetEnvironmentVariable('PR_INIFILENAME',@buf,sizeof(buf))>0 then
  begin
    prIniFileName := Trim(StrPas(@buf));
    if prIniFileName='' then
      prIniFileName := AddFlash(ExtractFilePath(Application.ExeName))+_sPrIniFileName;
  end
else
  prIniFileName := GetFindFileName(_sPrIniFileName);

finalization

{$IFDEF DEBUG}
WriteToLog('finalization');
{$ENDIF}
{$IFDEF PR_D4}
Classes.FindGlobalComponent := OldFindGlobalComponent;
prCreatedReports.Free;
prCreatedReports := nil;
{$ENDIF}
Finalize(prObjRegInfos);

end.


