{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_ColorButton;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  stdctrls,

  pr_Utils;

const
  ColorPerX = 4;
  ColorPerY = 5;

  LeftOffset = 2;
  RightOffset = 2;
  TopOffset = 2;
  BottomOffset = 2;
  DeltaXOffset = 2;
  DeltaYOffset = 2;

  ColorBoxWidth = 21;
  ColorBoxHeight = 21;

  OtherColorButtonWidth = 65;
  OtherColorButtonHeight = 21;
  TransparentButtonHeight = 21;

type
  TprButtonType = (prbtColorBox,prbtOtherColorBox,prbtOtherColor,prbtTransparent,prbtNone);
  TprColorSelectedEvent = procedure (Sender : TObject; Color : TColor) of object;

  //////////////////////////////////
  //
  // TprColorPaletteForm
  //
  //////////////////////////////////
  TprColorPaletteForm = class(TForm)
    ColorDialog: TColorDialog;
    procedure FormPaint(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDeactivate(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    FSelectedColor : TColor;
    FOtherColor : TColor;
    FOtherString : string;
    FTransparentString : string;
    FOnColorSelected : TprColorSelectedEvent;

    FLastP : TPoint;
    FLastButton : TprButtonType;
    FColorBoxesRect : TRect;
    FOtherColorButtonRect : TRect;
    FOtherColorBox : TRect;
    FTransparentButtonRect : TRect;
    function GetSelectedColor : TColor;
    procedure SetSelectedColor(Value : TColor);
    procedure SetOtherColor(Value : TColor);
    procedure GetBoxFromPoint(const pcursor : TPoint; var Button : TprButtonType; var p : TPoint);
    procedure DrawButton(Button : TprButtonType; const p : TPoint; Selected : boolean; Highlighted : boolean);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    { Public declarations }
    property SelectedColor : TColor read GetSelectedColor write SetSelectedColor;
    property OtherColor : TColor read FOtherColor write SetOtherColor;
    property OtherString : string read FOtherString write FOtherString;
    property TransparentString : string read FTransparentString write FTransparentString;
    property OnColorSelected : TprColorSelectedEvent read FOnColorSelected write FOnColorSelected;
  end;

  //////////////////////////////
  //
  // TprColorButton
  //
  //////////////////////////////
  TprColorButton = class(TButtonControl)
  private
    FSelectedColor : TColor;
    FOtherColor : TColor;
    FOnColorSelected : TprColorSelectedEvent;
    FOtherString : string;
    FTransparentString : string;

    FPaletteForm : TprColorPaletteForm;

    procedure SetSelectedColor(Value : TColor);
    procedure SetOtherColor(Value : TColor);
    procedure DrawButton(DC : HDC; Disabled,Pushed,Focused : boolean);
    procedure _OnColorSelected(Sender : TObject; Color : TColor);
    procedure CNMeasureItem(var Msg: TWMMeasureItem); message CN_MEASUREITEM;
    procedure CNDrawItem(var Msg: TWMDrawItem); message CN_DRAWITEM;
    procedure CNCommand(var Msg: TWMCommand); message CN_COMMAND;
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    procedure Click; override;
    constructor Create(AOwner : TComponent); override;
  published
    property Action;
    property Anchors;
    property BiDiMode;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property ParentBiDiMode;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop default True;
    property Visible;
{$IFDEF PR_D5}
    property OnContextPopup;
{$ENDIF}
    property OnDragDrop;
    property OnDragOver;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;

    property SelectedColor : TColor read FSelectedColor write SetSelectedColor;
    property OtherColor : TColor read FOtherColor write SetOtherColor;
    property OtherString : string read FOtherString write FOtherString;
    property TransparentString : string read FTransparentString write FTransparentString;
    property OnColorSelected : TprColorSelectedEvent read FOnColorSelected write FOnColorSelected;
  end;

function PopupPaletteForm(AOwner : TComponent; X,Y : integer; SelectedColor,OtherColor : TColor; OnColorSelected : TprColorSelectedEvent; const OtherString,TransparentString : string) : TprColorPaletteForm;

implementation

var
  aColors : array [0..ColorPerY-1,0..ColorPerX-1] of TColor =
            ((clWhite,clBlack,clSilver,clGray),
             (clRed,clMaroon,clYellow,clOlive),
             (clLime,clGreen,clAqua,clTeal),
             (clBlue,clNavy,clFuchsia,clPurple),
             (clBtnFace,clHighlight,clBtnHighlight,clInactiveCaption));
{$R *.DFM}

function PopupPaletteForm;
var
  r : TRect;
begin
Result := TprColorPaletteForm.Create(AOwner);
Result.OtherColor := OtherColor;
Result.SelectedColor := SelectedColor;
Result.OtherString := OtherString;
Result.TransparentString := TransparentString;
Result.OnColorSelected := OnColorSelected;
SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
if X+Result.Width>r.Right then
  X := X-Result.Width;
if Y+Result.Height>r.Bottom then
  Y := Y-Result.Height;
Result.Left := X;
Result.Top := Y;
Result.Show;
end;

//////////////////////////////
//
// TprColorButton
//
//////////////////////////////
constructor TprColorButton.Create;
begin
inherited;
Width := 45;
Height := 22;
TabStop := true;
FOtherString := 'Other...';
FTransparentString := 'Transparent';
end;

procedure TprColorButton.SetSelectedColor;
begin
FSelectedColor := Value;
Invalidate;
end;

procedure TprColorButton.SetOtherColor;
begin
FOtherColor := Value;
end;

procedure TprColorButton.CreateParams(var Params: TCreateParams);
begin
inherited;
CreateSubClass(Params, 'BUTTON');
Params.Style := Params.Style or BS_PUSHBUTTON or BS_OWNERDRAW;
end;

procedure TprColorButton.CNMeasureItem(var Msg: TWMMeasureItem);
begin
with Msg.MeasureItemStruct^ do
  begin
    itemWidth := Width;
    itemHeight := Height;
  end;
Msg.Result := 1;
end;

procedure TprColorButton.CNDrawItem(var Msg: TWMDrawItem);
begin
DrawButton(Msg.DrawItemStruct^.hDC,
           (Msg.DrawItemStruct^.itemState and ODS_DISABLED)<>0,
           (Msg.DrawItemStruct^.itemState and ODS_SELECTED)<>0,
           (Msg.DrawItemStruct^.itemState and ODS_FOCUS)<>0);
Msg.Result := 1;
end;

procedure TprColorButton.CNCommand;
begin
if Msg.NotifyCode = BN_CLICKED then
  Click;
end;

procedure TprColorButton.DrawButton;
var
  r : TRect;
  cr : COLORREF;
  uState : cardinal;
  npn,opn : HPEN;
  nbr,obr : HBRUSH;
begin
r := ClientRect;
uState := DFCS_BUTTONPUSH;
if Pushed then
  uState := uState or DFCS_PUSHED;
if Disabled then
  uState := uState or DFCS_INACTIVE;
DrawFrameControl(DC,r,DFC_BUTTON,uState);
InflateRect(r,-3,-3);
if Focused then
  DrawFocusRect(DC,r);
if Pushed then
  begin
    r.Top := r.Top+1;
    r.Left := r.Left+1;
  end;
// draw arrow
npn := CreatePen(PS_SOLID,1,clBlack);
opn := SelectObject(DC,npn);
MoveToEx(DC,r.Right-7,r.Top+6,nil);
LineTo(DC,r.Right-2,r.Top+6);
MoveToEx(DC,r.Right-6,r.Top+7,nil);
LineTo(DC,r.Right-3,r.Top+7);
MoveToEx(DC,r.Right-5,r.Top+8,nil);
LineTo(DC,r.Right-4,r.Top+8);
// draw line
r.Right := r.Right-8;
r.Top := r.Top+2;
r.Bottom := r.Bottom-2;
DrawEdge(DC,r,EDGE_ETCHED,BF_RIGHT);
// draw color box
if FSelectedColor<>clNone then
  begin
    if (FSelectedColor and $80000000)<>0 then
      cr := GetSysColor(FSelectedColor and not $80000000)
    else
      cr := FSelectedColor;
    r.Right := r.Right-4;
    r.Left := r.Left+2;
    nbr := CreateSolidBrush(cr);
    obr := SelectObject(DC,nbr);
    Rectangle(DC,r.Left,r.Top,r.Right,r.Bottom);
    SelectObject(DC,opn);
    SelectObject(DC,obr);
  end;
end;

procedure TprColorButton._OnColorSelected;
begin
FOtherColor := FPaletteForm.OtherColor;
SelectedColor := Color;
if Assigned(OnColorSelected) then
  OnColorSelected(Self,SelectedColor);
end;

procedure TprColorButton.Click;
var
  r : TRect;
  p : TPoint;
begin
inherited;
FPaletteForm := TprColorPaletteForm.Create(Self);
FPaletteForm.OnColorSelected := _OnColorSelected;
SystemParametersInfo(SPI_GETWORKAREA,0,@r,0);
p := ClientToScreen(Point(0,0));
p.Y := p.Y+Height;
if p.X+FPaletteForm.Width>r.Right then
  p.X := p.X-FPaletteForm.Width;
if p.Y+FPaletteForm.Height>r.Bottom then
  p.Y := p.Y-FPaletteForm.Height-Height;
FPaletteForm.OtherColor := FOtherColor;
FPaletteForm.SelectedColor := FSelectedColor;
FPaletteForm.Left := p.X;
FPaletteForm.Top := p.Y;
FPaletteForm.Show;
end;



/////////////////////////////////
//
// TprColorPaletteForm
//
/////////////////////////////////
function TprColorPaletteForm.GetSelectedColor;
begin
if (FSelectedColor<>clNone) and ((FSelectedColor and $80000000)<>0) then
  Result := GetSysColor(FSelectedColor and not $80000000)
else
  Result := FSelectedColor;
end;

procedure TprColorPaletteForm.SetSelectedColor;
label
  lbl1;
var
  i,j : integer;
begin
FSelectedColor := Value;
for i:=0 to ColorPerX-1 do
  for j:=0 to ColorPerY-1 do
    if aColors[j,i]=FSelectedColor then
      goto lbl1;
FOtherColor := FSelectedColor;
lbl1:
Invalidate;
end;

procedure TprColorPaletteForm.SetOtherColor;
begin
FOtherColor := Value;
end;

procedure TprColorPaletteForm.GetBoxFromPoint;
begin
if PointInRect(pcursor.x,pcursor.y,FColorBoxesRect) then
  begin
    Button := prbtColorBox;
    p.X := (pcursor.X-LeftOffset) div (ColorBoxWidth+DeltaXOffset);
    p.Y := (pcursor.Y-TopOffset) div (ColorBoxHeight+DeltaYOffset);
  end
else
  if PointInRect(pcursor.x,pcursor.y,FOtherColorBox) then
    Button := prbtOtherColorBox
  else
    if PointInRect(pcursor.x,pcursor.y,FOtherColorButtonRect) then
      Button := prbtOtherColor
    else
      if PointInRect(pcursor.x,pcursor.y,FTransparentButtonRect) then
        Button := prbtTransparent
      else
        Button := prbtNone;
end;

procedure TprColorPaletteForm.DrawButton;
var
  r : TRect;
  procedure DrawColorBox(Color : TColor);
  begin
  Canvas.Brush.Color := clBtnFace;
  Canvas.FillRect(r);
  if Selected or Highlighted then
    begin
      Canvas.Brush.Color := clHighlight;
      Canvas.FrameRect(r);
      InflateRect(r,-1,-1);
    end;
  if Highlighted then
    begin
      Canvas.Brush.Color := clBtnHighlight;
      Canvas.FillRect(r);
    end;
  InflateRect(r,-4,-4);
  Canvas.Brush.Color := clHighlight;
  Canvas.FrameRect(r);
  InflateRect(r,-1,-1);
  Canvas.Brush.Color := Color;
  Canvas.FillRect(r);
  end;

  procedure DrawPushButton(const s : string);
  begin
  if Selected or Highlighted then
    begin
      Canvas.Brush.Color := clHighlight;
      Canvas.FrameRect(r);
      InflateRect(r,-1,-1);
    end;
  if Highlighted then
    Canvas.Brush.Color := clBtnHighlight
  else
    Canvas.Brush.Color := clBtnFace;
  Canvas.FillRect(r);
  DrawText(Canvas.Handle,PChar(s),length(s),r,DT_CENTER	or DT_VCENTER or DT_SINGLELINE);
  end;
begin
case Button of
  prbtColorBox:
    begin
      r.Left := LeftOffset+p.x*(ColorBoxWidth+DeltaXOffset);
      r.Top := TopOffset+p.y*(ColorBoxHeight+DeltaYOffset);
      r.Right := r.Left+ColorBoxWidth;
      r.Bottom := r.Top+ColorBoxHeight;
      DrawColorBox(aColors[p.y,p.x]);
    end;
  prbtOtherColorBox:
    begin
      r := FOtherColorBox;
      DrawColorBox(FOtherColor);
    end;
  prbtOtherColor:
    begin
      r := FOtherColorButtonRect;
      DrawPushButton(FOtherString);
    end;
  prbtTransparent:
    begin
      r := FTransparentButtonRect;
      DrawPushButton(FTransparentString);
    end;
end;
end;

procedure TprColorPaletteForm.CreateParams;
begin
inherited;
Params.Style := Params.Style and not WS_CAPTION;
end;

procedure TprColorPaletteForm.FormPaint(Sender: TObject);
var
  r : TRect;
  i,j : integer;
begin
for i:=0 to ColorPerX-1 do
  for j:=0 to ColorPerY-1 do
    DrawButton(prbtColorBox,Point(i,j),aColors[j,i]=FSelectedColor,false);

r := Rect(FColorBoxesRect.Left,
          FColorBoxesRect.Bottom+5,
          FColorBoxesRect.Right,
          FColorBoxesRect.Bottom+5);
DrawEdge(Canvas.Handle,r,EDGE_ETCHED,BF_TOP);

DrawButton(prbtOtherColorBox,Point(0,0),FSelectedColor=FOtherColor,false);

DrawButton(prbtOtherColor,Point(0,0),false,false);

DrawButton(prbtTransparent,Point(0,0),FSelectedColor=clNone,false);
end;

procedure TprColorPaletteForm.FormCreate(Sender: TObject);
begin
FOtherString := 'Other...';
FTransparentString := 'Transparent';

FColorBoxesRect := Rect(LeftOffset,
                        TopOffset,
                        LeftOffset+ColorPerX*ColorBoxWidth+(ColorPerX-1)*DeltaXOffset,
                        TopOffset+ColorPerY*ColorBoxHeight+(ColorPerY-1)*DeltaYOffset);
FOtherColorButtonRect := Rect(LeftOffset,
                              FColorBoxesRect.Bottom+10,
                              LeftOffset+OtherColorButtonWidth,
                              FColorBoxesRect.Bottom+10+OtherColorButtonHeight);
FOtherColorBox := Rect(FColorBoxesRect.Right-ColorBoxWidth,
                       FColorBoxesRect.Bottom+10,
                       FColorBoxesRect.Right,
                       FColorBoxesRect.Bottom+10+ColorBoxHeight);
FTransparentButtonRect := Rect(FColorBoxesRect.Left,
                               FOtherColorButtonRect.Bottom+4,
                               FColorBoxesRect.Right,
                               FOtherColorButtonRect.Bottom+4+TransparentButtonHeight);

ClientWidth := FColorBoxesRect.Right+RightOffset;
ClientHeight := FTransparentButtonRect.Bottom+BottomOffset
end;

procedure TprColorPaletteForm.FormMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
var
  FNewP : TPoint;
  FNewButton : TprButtonType;
begin
GetBoxFromPoint(Point(X,Y),FNewButton,FNewP);
if (FLastButton=FNewButton) and
   ((FLastButton<>prbtColorBox) or
    ((FLastP.x=FNewP.X) and (FLastP.y=FNewP.Y))) then exit;
if FLastButton<>prbtNone then
  DrawButton(FLastButton,
             FLastP,
             ((FLastButton=prbtColorBox) and
              (aColors[FLastP.Y,FLastP.X]=FSelectedColor)) or
             ((FLastButton=prbtOtherColorBox) and
              (FOtherColor=FSelectedColor)) or
             ((FLastButton=prbtTransparent) and
              (FSelectedColor=clNone)),
             false);
FLastP := FNewP;
FLastButton := FNewButton;
if FLastButton<>prbtNone then
  DrawButton(FLastButton,
             FLastP,
             ((FLastButton=prbtColorBox) and
              (aColors[FLastP.Y,FLastP.X] = FSelectedColor)) or
             ((FLastButton=prbtOtherColorBox) and
              (FOtherColor=FSelectedColor)) or
             ((FLastButton=prbtTransparent) and
              (FSelectedColor=clNone)),
             true);
end;

procedure TprColorPaletteForm.FormMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  FNewP : TPoint;
  FNewButton : TprButtonType;
  Color : TColor;
begin
GetBoxFromPoint(Point(X,Y),FNewButton,FNewP);
if FNewButton=prbtNone then exit;
Color := clWhite;
case FNewButton of
  prbtColorBox: Color := aColors[FNewP.Y,FNewP.X];
  prbtOtherColorBox: Color := FOtherColor;
  prbtOtherColor:
    begin
      ColorDialog.Color := FOtherColor;
      if not ColorDialog.Execute then
        exit;
      Color := ColorDialog.Color;
      OtherColor := Color;
    end;
  prbtTransparent: Color := clNone;
end;
SelectedColor := Color;
if Assigned(OnColorSelected) then
  OnColorSelected(Self,SelectedColor);
Close;
end;

procedure TprColorPaletteForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
Action := caFree;
end;

procedure TprColorPaletteForm.FormDeactivate(Sender: TObject);
begin
Close;
end;

procedure TprColorPaletteForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
inherited;
if (Key=VK_ESCAPE) and (Shift=[]) then
  Close;
end;

end.
