{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_Classes;

{$i pr.inc}

interface

uses
  SysUtils, Windows, Classes, Graphics, WinSpool, DB,
  Dialogs, typinfo, Math, Forms, IniFiles, Messages, Controls,
  stdctrls, CommDlg, comctrls, {$ifdef PR_D6} variants, types, {$endif}
  comobj, richedit,

  Pr_Utils, pr_XLSConts, pr_Common, pr_Progress, pr_MultiLang;

const
  oLeft = 1; // for TprMemoObj offsets from borders of rect
  oTop = 1;
  oRight = 1;
  oBottom = 1;
  StepLine = 0;

  MillimetersPerInch = 25.412;
  HundredthMillimetersPerInch = 2541;
  SantimetersPerInch = MillimetersPerInch / 10;
  MetersPerInch = MillimetersPerInch / 1000;

  DefEmptyLine = 'gM';
  DefEmptyLineLength = 2;
  sArialFont = 'Arial Cyr';

  MaxRichTextWidth = 5000;
  MaxRichTextHeight = 5000;

  Rich2FindTextTextColor = clWhite;
  Rich2FindTextBackColor = clBlack;
  RichFindTextTextColor = clBlue;

  PreparedReportSavePrefix = $FFFFFFFF;
  PreparedReportSaveFormatVersion = $00000001;

type

TprPage = class;
TprReport = class;
TprEndPage = class;

TprPreviewDrawMode = (dmDraw,dmFind,dmFindFirst);
TprPosSizeUnits = (prpsuPixels,prpsuMM,prpsuSm,prpsuInch,prpsuM);

rPrPreviewDrawInfo = record
  DrawMode      : TprPreviewDrawMode;

  FindText      : string;
  CaseSensitive : boolean;
  FindList      : TList;

  StatusBar     : TStatusBar;
  ProgressBar   : TProgressBar;
end;
PPrPreviewDrawInfo = ^rPrPreviewDrawInfo;

rPrDrawInfo = record
  xmul : integer;
  xdiv : integer;
  ymul : integer;
  ydiv : integer;
  bRect : TRect;
  IsPrinter : boolean;
  hsb : integer;  // Position of HorizontalScrollBar
  vsb : integer;  // Position of VerticalScrollBar
  ppdi : PPrPreviewDrawInfo;
end;
PPrDrawInfo = ^rPrDrawInfo;

//////////////////////
//
// TprPageInfo
//
//////////////////////
TprPageInfo = record
  sWidth,sHeight : integer; //      ,       
  pWidth,pHeight : integer; //     
  PrnSRect       : TRect;   //  ,       
  PrnPRect       : TRect;   //  ,       

  mmlMargin      : integer; //       
  mmtMargin      : integer; //    
  mmrMargin      : integer; //     (  )
  mmbMargin      : integer; //     (  )

  saRect         : TRect;   // ,     ,   
  paRect         : TRect;   //     ,   
end;
PprPageInfo = ^TprPageInfo;

///////////////////////////
//
// TprFindText
//
///////////////////////////
TprFindText = class
  TextRect : TRect;
  constructor CreateFT(_TextRect : TRect);
end;

///////////////////////
//
// TprExObjRecVersion
//
///////////////////////
TprExObjRecVersion = class(TprObjRecVersion)
private
  ResExport1 : pointer;
protected
  procedure ReadGeneratedRect(Stream : TStream);
  procedure WriteGeneratedRect(Stream : TStream);
  procedure ReadPreviewUserData(Stream : TStream);
  procedure WritePreviewUserData(Stream : TStream);
  procedure DefineProperties(Filer : TFiler); override;
public
  //    
  GeneratedRect : TRect;
  RealRect : TRect;
  PrinterRealRect : TRect;
  PreviewUserData : TprPreviewUserData;
  procedure CalcRealRect(pdi : PPrDrawInfo); 
  procedure PreviewUpdateProps(pdi : PPrDrawInfo); virtual;
  procedure Draw(DC : HDC; pdi : PPrDrawInfo); virtual; abstract;
  procedure ExportToXLS(V : Variant); virtual; abstract;
  procedure InitInDesigner; virtual; abstract;
  procedure Scale(cx1,cx2,cy1,cy2 : integer); virtual;

  procedure Assign(Source : TPersistent); override;
end;

////////////////////////
//
// TprFrameLine
//
////////////////////////
TprFrameLine = class(TPersistent)
private
  FShow  : boolean;
  FStyle : TPenStyle;
  FColor : TColor;
  FWidth : integer;
public
  procedure Assign(Source : TPersistent); override;
published
  property Show  : boolean read FShow write FShow;
  property Style : TPenStyle read FStyle write FStyle;
  property Color : TColor read FColor write FColor;
  property Width : integer read FWidth write FWidth;
end;

//////////////////////////
//
// TprMemoObjRecVersion
//
//////////////////////////
TprMemoObjRecVersion = class(TprExObjRecVersion)
private
  FMemo : TStrings;
  FlBorder : TprFrameLine;
  FrBorder : TprFrameLine;
  FtBorder : TprFrameLine;
  FbBorder : TprFrameLine;
  FFillColor : TColor;
  FhAlign : TprHAlign;
  FvAlign : TprVAlign;
  FFont : TFont;
  FRotate90 : boolean;
  FDeleteEmptyLinesAtEnd : boolean;
  FDeleteEmptyLines : boolean;
  FCanResizeX : boolean;
  FCanResizeY : boolean;
  FWordWrap : boolean;

  SecondPassNeeded       : boolean; // true - in second pass Memo must be reformatted

  // filled while generation
  FGeneratedTextWidths : array of integer; // width for each line of text
  FGeneratedTextHeight : integer;          // height of all text

  procedure CalcGeneratedData(DC : HDC);
protected
  procedure ReadGeneratedData(Stream : TStream);
  procedure WriteGeneratedData(Stream : TStream);
  procedure ReadFontSize(Reader : TReader);
  procedure WriteFontSize(Writer : TWriter);
  procedure DefineProperties(Filer : TFiler); override;
public
  procedure Assign(Source : TPersistent); override;

  procedure PreviewUpdateProps(pdi : PPrDrawInfo); override;
  procedure Draw(DC : HDC; pdi : PPrDrawInfo); override;
  procedure ExportToXLS(V : Variant); override;
  procedure InitInDesigner; override;
  procedure Scale(cx1,cx2,cy1,cy2 : integer); override;

  constructor Create(Collection : TCollection); override;
  destructor Destroy; override;
published
  property Memo : TStrings read FMemo write FMemo;
  property lBorder : TprFrameLine read FlBorder write FlBorder;
  property rBorder : TprFrameLine read FrBorder write FrBorder;
  property tBorder : TprFrameLine read FtBorder write FtBorder;
  property bBorder : TprFrameLine read FbBorder write FbBorder;
  property FillColor : TColor read FFillColor write FFillColor;
  property hAlign : TprHAlign read FhAlign write FhAlign;
  property vAlign : TprvAlign read FvAlign write FvAlign;
  property Font : TFont read FFont write FFont;
  property Rotate90 : boolean read FRotate90 write FRotate90;
  property DeleteEmptyLinesAtEnd : boolean read FDeleteEmptyLinesAtEnd write FDeleteEmptyLinesAtEnd;
  property DeleteEmptyLines : boolean read FDeleteEmptyLines write FDeleteEmptyLines;
  property CanResizeX : boolean read FCanResizeX write FCanResizeX;
  property CanResizeY : boolean read FCanResizeY write FCanResizeY;
  property WordWrap : boolean read FWordWrap write FWordWrap;
end;

//////////////////////////
//
// TprMemoObjRec
//
//////////////////////////
TprMemoObjRec = class(TprObjRec)
protected
  function CreateVersions : TprObjRecVersions; override;
public
  procedure PlaceOnEndPage(Device : TObject; r : TRect); override;
  procedure SecondPass; override;
  function  CreateCopy : TprObjRec; override;
end;

//////////////////////////
//
// TprMemoObj
//
//////////////////////////
TprMemoObj = class(TprObj)
protected
  procedure InitdRec; override;
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  function  GetDesc : string; override;

  function  AllowInplaceEdit : boolean; override;
  procedure InplaceEdit(_Parent : TWinControl; var InplaceEditor : TWinControl); override;
  procedure SaveInplaceEdit(InplaceEditor : TWinControl); override;

  procedure FirstPass; override;
end;

//////////////////////////
//
// TprRichObjRecVersion
//
//////////////////////////
TprRichObjRecVersion = class(TprExObjRecVersion)
private
  FhwndRich : THandle;
  FhwndRichFind : THandle;
  FlBorder : TprFrameLine;
  FrBorder : TprFrameLine;
  FtBorder : TprFrameLine;
  FbBorder : TprFrameLine;
  FDeleteEmptyLinesAtEnd : boolean;
  FDeleteEmptyLines : boolean;
  FCanResizeY : boolean;
  FWordWrap : boolean;

  SecondPassNeeded : boolean;
protected
  procedure ReadRichText(Stream : TStream);
  procedure WriteRichText(Stream : TStream);
  procedure DefineProperties(Filer : TFiler); override;
public
  property hwndRich : THandle read FhwndRich;
  procedure Assign(Source : TPersistent); override;

  procedure PreviewUpdateProps(pdi : PPrDrawInfo); override;
  procedure Draw(DC : HDC; pdi : PPrDrawInfo); override;
  procedure ExportToXLS(V : Variant); override;
  procedure InitInDesigner; override;

  constructor Create(Collection : TCollection); override;
  destructor Destroy; override;
published
  property lBorder : TprFrameLine read FlBorder write FlBorder;
  property rBorder : TprFrameLine read FrBorder write FrBorder;
  property tBorder : TprFrameLine read FtBorder write FtBorder;
  property bBorder : TprFrameLine read FbBorder write FbBorder;
  property DeleteEmptyLinesAtEnd : boolean read FDeleteEmptyLinesAtEnd write FDeleteEmptyLinesAtEnd;
  property DeleteEmptyLines : boolean read FDeleteEmptyLines write FDeleteEmptyLines;
  property CanResizeY : boolean read FCanResizeY write FCanResizeY;
  property WordWrap : boolean read FWordWrap write FWordWrap;
end;

//////////////////////////
//
// TprRichObjRec
//
//////////////////////////
TprRichObjRec = class(TprObjRec)
protected
  function CreateVersions : TprObjRecVersions; override;
public
  //  
  procedure PlaceOnEndPage(Device : TObject; r : TRect); override;

  procedure SecondPass; override;

  function  CreateCopy : TprObjRec; override;
end;

//////////////////////////
//
// TprRichObj
//
//////////////////////////
TprRichObj = class(TprObj)
protected
  procedure InitdRec; override;
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  function  GetDesc : string; override;

  function  AllowInplaceEdit : boolean; override;
  procedure InplaceEdit(_Parent : TWinControl; var InplaceEditor : TWinControl); override;
  procedure SaveInplaceEdit(InplaceEditor : TWinControl); override;

  procedure FirstPass; override;
end;

//////////////////////////
//
// TprImageObjRecVersion
//
//////////////////////////
TprImageSource   = (isPicture,isFileName,isDBFieldName);
TprImageDrawMode = (prdmCenter,prdmStretch,prdmStretchProp,prdmResizeHeightWidth);
TprImageObjRecVersion = class(TprExObjRecVersion)
private
  FImageSource : TprImageSource;
  FPicture : TPicture;
  FFileName : string;
  FDBFieldName : string;
  FDrawMode : TprImageDrawMode;
  FFillColor : TColor;
public
  procedure Assign(Source : TPersistent); override;

  procedure Draw(DC : HDC; pdi : PPrDrawInfo); override;
  procedure ExportToXLS(V : Variant); override;
  procedure InitInDesigner; override;

  procedure GetPicture(Report : TprCustomReport; var p : TPicture; var pCreated : boolean);

  constructor Create(Collection : TCollection); override;
  destructor Destroy; override;
published
  property ImageSource : TprImageSource read FImageSource write FImageSource;
  property Picture : TPicture read FPicture write FPicture;
  property FileName : string read FFileName write FFileName;
  property DBFieldName : string read FDBFieldName write FDBFieldName;
  property DrawMode : TprImageDrawMode read FDrawMode write FDrawMode;
  property FillColor : TColor read FFillColor write FFillColor;
end;

//////////////////////////
//
// TprImageObjRec
//
//////////////////////////
TprImageObjRec = class(TprObjRec)
protected
  function CreateVersions : TprObjRecVersions; override;
public
  procedure SecondPass; override;
  procedure PlaceOnEndPage(Device : TObject; r : TRect); override;

  function  CreateCopy : TprObjRec; override;
end;

//////////////////////////
//
// TprImageObj
//
//////////////////////////
TprImageObj = class(TprObj)
protected
  procedure InitdRec; override;
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
  function  GetDesc : string; override;

  procedure FirstPass; override;
end;


///////////////////////////////
//
// TprHTitleBand
//
///////////////////////////////
TprHTitleBand = class(TprCustomHTitleBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

//////////////////////////////
//
// TprHSummaryBand
//
//////////////////////////////
TprHSummaryBand = class(TprCustomHSummaryBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

/////////////////////////
//
// TprHPageHeaderBand
//
/////////////////////////
TprHPageHeaderBand = class(TprCustomHPageHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

/////////////////////////
//
// TprHPageFooterBand
//
/////////////////////////
TprHPageFooterBand = class(TprCustomHPageFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////////////
//
// TprHDetailBand
//
///////////////////////////////////
TprHDetailBand = class(TprCustomHDetailBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////
//
// TprHDetailHeaderBand
//
///////////////////////////
TprHDetailHeaderBand = class(TprCustomHDetailHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

////////////////////////////
//
// TprHDetailFooterBand
//
////////////////////////////
TprHDetailFooterBand = class(TprCustomHDetailFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////
//
// TprHGroupHeaderBand
//
///////////////////////////
TprHGroupHeaderBand = class(TprCustomHGroupHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////
//
// TprHGroupFooterBand
//
///////////////////////////
TprHGroupFooterBand = class(TprCustomHGroupFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;







///////////////////////////////
//
// TprVTitleBand
//
///////////////////////////////
TprVTitleBand = class(TprCustomVTitleBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

//////////////////////////////
//
// TprVSummaryBand
//
//////////////////////////////
TprVSummaryBand = class(TprCustomVSummaryBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

/////////////////////////
//
// TprVPageHeaderBand
//
/////////////////////////
TprVPageHeaderBand = class(TprCustomVPageHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

/////////////////////////
//
// TprVPageFooterBand
//
/////////////////////////
TprVPageFooterBand = class(TprCustomVPageFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////////////
//
// TprVDetailBand
//
///////////////////////////////////
TprVDetailBand = class(TprCustomVDetailBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////
//
// TprVDetailHeaderBand
//
///////////////////////////
TprVDetailHeaderBand = class(TprCustomVDetailHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

////////////////////////////
//
// TprVDetailFooterBand
//
////////////////////////////
TprVDetailFooterBand = class(TprCustomVDetailFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////
//
// TprVGroupHeaderBand
//
///////////////////////////
TprVGroupHeaderBand = class(TprCustomVGroupHeaderBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;

///////////////////////////
//
// TprVGroupFooterBand
//
///////////////////////////
TprVGroupFooterBand = class(TprCustomVGroupFooterBand)
public
  procedure DrawDesign(DC : HDC; ExData : pointer); override;
end;








//////////////////////////
//
// TprPage
//
//////////////////////////
TprPage = class(TprCustomPage)
private
  FPaperSize   : integer;
  FOrientation : TprPrinterOrientation;
  FlMargin     : integer;
  FrMargin     : integer;
  FtMargin     : integer;
  FbMargin     : integer;
protected
  procedure Loaded; override;
  procedure ReportSetted; override;
public
  pInfo : TprPageInfo;

  // Designer
  function GetPageRect : TRect; override;

  // Other
  procedure ChangePaper(ASize,aWidth,aHeight : integer; aOrientation : TprPrinterOrientation);

  constructor Create(AOwner : TComponent); override;
published
  property PaperSize   : integer read FPaperSize write FPaperSize;
  property Orientation : TprPrinterOrientation read FOrientation write FOrientation;
  property lMargin     : integer read FlMargin write FlMargin;
  property rMargin     : integer read FrMargin write FrMargin;
  property tMargin     : integer read FtMargin write FtMargin;
  property bMargin     : integer read FbMargin write FbMargin;
end;

//////////////////////////
//
// TprEndPage
//
//////////////////////////
TprEndPage = class(TprCustomEndPage)
private
  procedure ClearVL;
public
  //     TprPage
  PaperSize : integer;
  Orientation : TprPrinterOrientation;
  lMargin : integer; // margins left, top and etc
  rMargin : integer;
  tMargin : integer;
  bMargin : integer;
  pInfo : TprPageInfo;

  // list of generated objects
  VL : TList;

  // info for draw on EndPageDC
  rdi : rPrDrawInfo;
  rpdi : rPrDrawInfo;

  procedure ThirdPass; override;
  function  GetPageRect : TRect; override;

  procedure Cache(BoundsRect : TRect; IsPrinter : boolean);

  procedure Save(Stream : TStream);
  procedure Load(Stream : TStream);

  procedure ChangePaper(Report : TprReport; ASize,aWidth,aHeight : integer; aOrientation : TprPrinterOrientation);
  
  constructor Create(_Page : TprCustomPage); override;
  constructor CreateEmpty(_Report : TprCustomReport); override;
  destructor Destroy; override;
end;

///////////////////////////
//
// TprPrinter
//
///////////////////////////
TArrayWord = array [0..16383] of Word;
PArrayWord = ^TArrayWord;

TprPrinter = class(TObject)
private
  FPrinters : TStringList;
  FPaperNames : TStringList;
  FPrinterIndex : Integer; 

  FInfoInitializated : boolean;
  FStructuresInitializated : boolean;

  procedure UpdatePrintersList;
  procedure SetPrinterIndex(Value : integer);
  procedure SetPrinterName(Value : string);
  function  GetPrinterName : string;
  procedure ClearStructures;
  procedure ClearInfo;
public
  PrinterDC : HDC;
  Title : string;

  DeviceName : string;
  DriverName : string;
  PortName : string;
  DevNames : PDevNames;
  DevMode : PDevMode;
  DevNamesSize : integer;
  DevModeSize : integer;

  Orientation : TprPrinterOrientation;
  PaperSize : integer;
  PaperWidth : integer;
  PaperLength : integer;
  PixelsPerX : integer;
  PixelsPerY : integer;
  PaperSizes : PArrayWord;
  PaperSizesCount : integer;

  scrPixelsPerX : integer;
  scrPixelsPerY : integer;
  CreatedscrPixelsPerX : integer;
  CreatedscrPixelsPerY : integer;

  property PaperNames : TStringList read FPaperNames; // list of paper types
  property Printers : TStringList read FPrinters; // list of installed printers with virtual printer
  property PrinterIndex : Integer read FPrinterIndex write SetPrinterIndex; // current printer index
  property PrinterName : string read GetPrinterName write SetPrinterName; // name of current printer

  function  InitStructures : boolean; 
  function  InitInfo : boolean;
  procedure UpdatepInfo(Page : TObject; var pInfo : TprPageInfo;_lMargin,_rMargin,_tMargin,_bMargin : integer);
  procedure SetToDefaultPrinter;

  procedure BeginDoc;
  procedure EndDoc;
  procedure NewPage;

  procedure SetPrinterInfo(pgSize : integer;
                           pgWidth : integer;
                           pgHeight : integer;
                           pgOrientation : TprPrinterOrientation);
  function SetDevMode(NewDevMode : PDevMode; NewDevModeSize : integer) : boolean;

  function IsEqual(pgSize : integer;
                   pgWidth : integer;
                   pgHeight : Integer;
                   pgOrientation : TprPrinterOrientation) : boolean;

  function GetPaperSizeArrayPos(pgSize : Integer) : Integer;

  constructor Create;
  destructor Destroy; override;
end;

///////////////////////////
//
// TprPreviewParams
//
///////////////////////////
TprPreviewOptions = (prpoShowMenu,prpoAllowShowHideToolbars,prpoAllowDragToolbars,prpoAllowChangePreviewMode);
TprPreviewOptionsSet = set of TprPreviewOptions;
TprPreviewToolbars = (prptPreviewCommon,prptEdit,prptInsertObject,prptText,prptBorders,prptAlign,prptSize,prptNudge,prptObjects,prptObject);
TprPreviewToolbarsSet = set of TprPreviewToolbars;
TprPreviewParams = class(TPersistent)
private
  FOptions : TprPreviewOptionsSet;
  FShowToolbars : TprPreviewToolbarsSet;
published
  property Options : TprPreviewOptionsSet read FOptions write FOptions;
  property ShowToolbars : TprPreviewToolbarsSet read FShowToolbars write FShowToolbars;
end;

///////////////////////////
//
// TprReport
//
///////////////////////////
TprReport = class(TprCustomReport)
private
  FExportPrecision : integer;
  FExportPrecisionLow : integer;
  FExportPrecisionNormal : integer;
  FExportPrecisionHigh : integer;
  FPreviewParams : TprPreviewParams;
  FOnPreviewModeChanged : TNotifyEvent;
protected
  function GetDesignerFormClass : string; override;
  function GetPreviewFormClass : string; override;
  procedure InternalLoadPreparedReport(Stream : TStream);
  procedure ReadLOGPIXELSX(Reader : TReader);
  procedure WriteLOGPIXELSX(Writer : TWriter);
  procedure ReadLOGPIXELSY(Reader : TReader);
  procedure WriteLOGPIXELSY(Writer : TWriter);
  procedure DefineProperties(Filer : TFiler); override;
  procedure Loaded; override;
public
  prPrinter : TprPrinter;

  function GetPrinterName : string; override;
  procedure SetPrinterName(Value : string); override;

  function CreateEndPage(Page : TprCustomPage) : TprCustomEndPage; override;
  function CreateEmptyEndPage : TprCustomEndPage; override;
  procedure ChangePrinter(OldIndex,NewIndex : integer); override;

  function GetBandClass(BandType : TprBandType) : TprBandClass; override;

  function SetupPrintParams : boolean; override;
  function PrintPreparedReport : boolean; override;

  procedure LoadPreparedReport(Stream : TStream); override;
  procedure AppendPreparedReport(Stream : TStream); override;
  procedure SavePreparedReport(Stream : TStream); override;

  function SetupExportParams : boolean;
  procedure ExportToXLS;

  constructor Create(AOwner : TComponent); override;
  destructor Destroy; override;
published
  property ExportPrecision : integer read FExportPrecision write FExportPrecision;
  property ExportPrecisionLow : integer read FExportPrecisionLow write FExportPrecisionLow;
  property ExportPrecisionNormal : integer read FExportPrecisionNormal write FExportPrecisionNormal;
  property ExportPrecisionHigh : integer read FExportPrecisionHigh write FExportPrecisionHigh;

  property PreviewParams : TprPreviewParams read FPreviewParams write FPreviewParams;

  property OnPreviewModeChanged : TNotifyEvent read FOnPreviewModeChanged write FOnPreviewModeChanged; 
end;

function GetBW(b : TprFrameLine) : integer;
function prConvertFromPixelsString(Value : integer; ToU : TprPosSizeUnits; IsHor : boolean) : string;
function prConvertFromPixels(Value : integer; ToU : TprPosSizeUnits; IsHor : boolean) : double;
function prConvertToPixels(Value : double; FromU : TprPosSizeUnits; IsHor : boolean) : integer;

function FormatRichText(Report : TprCustomReport; hwnd : THandle; DeleteEmptyLines,DeleteEmptyLinesAtEnd : boolean) : boolean;
procedure CopyRichText(hwndSource, hwndDest : THandle); overload;
procedure CopyRichText(hwndSource : THandle; RichEditDest : TRichEdit); overload;
procedure CopyRichText(RichEditSource : TRichEdit; hwndDest : THandle); overload;

procedure SaveObjectsVersionsToStream(Stream : TStream; LV : TList);
procedure LoadObjectsVersionsFromStream(Stream : TStream; LV : TList);

const
  PrintTemplateName : array [0..4] of char = 'TEST'#0;

implementation

uses
  pr_Parser, pr_Preview, pr_ExportParams, pr_Strings;

var
  FRichEditModule : THandle;

const
  PenStyles : array[TPenStyle] of DWORD = (PS_SOLID,PS_DASH,PS_DOT,PS_DASHDOT,PS_DASHDOTDOT,PS_NULL,PS_INSIDEFRAME);
  PAPERCOUNT = 67;
  
var
  PaperInfo: Array[0..PAPERCOUNT-1] of TprPaperInfo = (
    (Typ:0;  Name: ''; X:0;    Y:0),
    (Typ:1;  Name: 'Letter, 8 1/2 x 11"'; X:2159; Y:2794),
    (Typ:2;  Name: 'Letter small, 8 1/2 x 11"'; X:2159; Y:2794),
    (Typ:3;  Name: 'Tabloid, 11 x 17"'; X:2794; Y:4318),
    (Typ:4;  Name: 'Ledger, 17 x 11"'; X:4318; Y:2794),
    (Typ:5;  Name: 'Legal, 8 1/2 x 14"'; X:2159; Y:3556),
    (Typ:6;  Name: 'Statement, 5 1/2 x 8 1/2"'; X:1397; Y:2159),
    (Typ:7;  Name: 'Executive, 7 1/4 x 10 1/2"'; X:1842; Y:2667),
    (Typ:8;  Name: 'A3 297 x 420 '; X:2970; Y:4200),
    (Typ:9;  Name: 'A4 210 x 297 '; X:2100; Y:2970),
    (Typ:10; Name: 'A4 small sheet, 210 x 297 '; X:2100; Y:2970),
    (Typ:11; Name: 'A5 148 x 210 '; X:1480; Y:2100),
    (Typ:12; Name: 'B4 250 x 354 '; X:2500; Y:3540),
    (Typ:13; Name: 'B5 182 x 257 '; X:1820; Y:2570),
    (Typ:14; Name: 'Folio, 8 1/2 x 13"'; X:2159; Y:3302),
    (Typ:15; Name: 'Quarto Sheet, 215 x 275 '; X:2150; Y:2750),
    (Typ:16; Name: '10 x 14"'; X:2540; Y:3556),
    (Typ:17; Name: '11 x 17"'; X:2794; Y:4318),
    (Typ:18; Name: 'Note, 8 1/2 x 11"'; X:2159; Y:2794),
    (Typ:19; Name: '9 Envelope, 3 7/8 x 8 7/8"'; X:984;  Y:2254),
    (Typ:20; Name: '#10 Envelope, 4 1/8  x 9 1/2"'; X:1048; Y:2413),
    (Typ:21; Name: '#11 Envelope, 4 1/2 x 10 3/8"'; X:1143; Y:2635),
    (Typ:22; Name: '#12 Envelope, 4 3/4 x 11"'; X:1207; Y:2794),
    (Typ:23; Name: '#14 Envelope, 5 x 11 1/2"'; X:1270; Y:2921),
    (Typ:24; Name: 'C Sheet, 17 x 22"'; X:4318; Y:5588),
    (Typ:25; Name: 'D Sheet, 22 x 34"'; X:5588; Y:8636),
    (Typ:26; Name: 'E Sheet, 34 x 44"'; X:8636; Y:11176),
    (Typ:27; Name: 'DL Envelope, 110 x 220 '; X:1100; Y:2200),
    (Typ:28; Name: 'C5 Envelope, 162 x 229 '; X:1620; Y:2290),
    (Typ:29; Name: 'C3 Envelope,  324 x 458 '; X:3240; Y:4580),
    (Typ:30; Name: 'C4 Envelope,  229 x 324 '; X:2290; Y:3240),
    (Typ:31; Name: 'C6 Envelope,  114 x 162 '; X:1140; Y:1620),
    (Typ:32; Name: 'C65 Envelope, 114 x 229 '; X:1140; Y:2290),
    (Typ:33; Name: 'B4 Envelope,  250 x 353 '; X:2500; Y:3530),
    (Typ:34; Name: 'B5 Envelope,  176 x 250 '; X:1760; Y:2500),
    (Typ:35; Name: 'B6 Envelope,  176 x 125 '; X:1760; Y:1250),
    (Typ:36; Name: 'Italy Envelope, 110 x 230 '; X:1100; Y:2300),
    (Typ:37; Name: 'Monarch Envelope, 3 7/8 x 7 1/2"'; X:984;  Y:1905),
    (Typ:38; Name: '6 3/4 Envelope, 3 5/8 x 6 1/2"'; X:920;  Y:1651),
    (Typ:39; Name: 'US Std Fanfold, 14 7/8 x 11"'; X:3778; Y:2794),
    (Typ:40; Name: 'German Std Fanfold, 8 1/2 x 12"'; X:2159; Y:3048),
    (Typ:41; Name: 'German Legal Fanfold, 8 1/2 x 13"'; X:2159; Y:3302),
    (Typ:42; Name: 'B4 (ISO) 250 x 353 '; X:2500; Y:3530),
    (Typ:43; Name: 'Japanese Postcard 100 x 148 '; X:1000; Y:1480),
    (Typ:44; Name: '9 x 11"'; X:2286; Y:2794),
    (Typ:45; Name: '10 x 11"'; X:2540; Y:2794),
    (Typ:46; Name: '15 x 11"'; X:3810; Y:2794),
    (Typ:47; Name: 'Envelope Invite 220 x 220 '; X:2200; Y:2200),
    (Typ:50; Name: 'Letter Extra 9 \ 275 x 12"'; X:2355; Y:3048),
    (Typ:51; Name: 'Legal Extra 9 \275 x 15"'; X:2355; Y:3810),
    (Typ:52; Name: 'Tabloid Extra 11.69 x 18"'; X:2969; Y:4572),
    (Typ:53; Name: 'A4 Extra 9.27 x 12.69"'; X:2354; Y:3223),
    (Typ:54; Name: 'Letter Transverse 8 \275 x 11"'; X:2101; Y:2794),
    (Typ:55; Name: 'A4 Transverse 210 x 297 '; X:2100; Y:2970),
    (Typ:56; Name: 'Letter Extra Transverse 9\275 x 12"'; X:2355; Y:3048),
    (Typ:57; Name: 'SuperASuperAA4 227 x 356 '; X:2270; Y:3560),
    (Typ:58; Name: 'SuperBSuperBA3 305 x 487 '; X:3050; Y:4870),
    (Typ:59; Name: 'Letter Plus 8.5 x 12.69"'; X:2159; Y:3223),
    (Typ:60; Name: 'A4 Plus 210 x 330 '; X:2100; Y:3300),
    (Typ:61; Name: 'A5 Transverse 148 x 210 '; X:1480; Y:2100),
    (Typ:62; Name: 'B5 (JIS) Transverse 182 x 257 '; X:1820; Y:2570),
    (Typ:63; Name: 'A3 Extra 322 x 445 '; X:3220; Y:4450),
    (Typ:64; Name: 'A5 Extra 174 x 235 '; X:1740; Y:2350),
    (Typ:65; Name: 'B5 (ISO) Extra 201 x 276 '; X:2010; Y:2760),
    (Typ:66; Name: 'A2 420 x 594 '; X:4200; Y:5940),
    (Typ:67; Name: 'A3 Transverse 297 x 420 '; X:2970; Y:4200),
    (Typ:68; Name: 'A3 Extra Transverse 322 x 445 '; X:3220; Y:4450));


function prConvertFromPixelsString;
const
  aformats : array [TprPosSizeUnits] of string = ('0','0.00','0.000','0.000','0.00000');
begin
Result:=FormatFloat(aformats[ToU],prConvertFromPixels(Value,ToU,IsHor));
end;

function prConvertFromPixels;
var
  DC : HDC;
  ppi : integer;
begin
Result:=0.0;
DC:=GetDC(0);
if IsHor then ppi:=GetDeviceCaps(DC,LOGPIXELSX)
         else ppi:=GetDeviceCaps(DC,LOGPIXELSY);
ReleaseDC(0,DC);
case ToU of
  prpsuPixels: Result:=Value;
  prpsuMM    : Result:=Value / ppi * MillimetersPerInch;
  prpsuSm    : Result:=Value / ppi * SantimetersPerInch;
  prpsuInch  : Result:=Value / ppi;
  prpsuM     : Result:=Value / ppi * MetersPerInch;
end;
end;

function prConvertToPixels;
var
  DC : HDC;
  ppi : integer;
begin
Result := 0;
DC := GetDC(0);
if IsHor then ppi := GetDeviceCaps(DC,LOGPIXELSX)
         else ppi := GetDeviceCaps(DC,LOGPIXELSY);
ReleaseDC(0,DC);
case FromU of
  prpsuPixels : Result := Round(Value);
  prpsuMM : Result := Round(Value * ppi / MillimetersPerInch);
  prpsuSm : Result := Round(Value * ppi / SantimetersPerInch);
  prpsuInch : Result := Round(Value * ppi);
  prpsuM : Result := Round(Value * ppi / MetersPerInch);
end;
end;



function GetBW;
begin
if b.Show then
  Result:=b.Width
else
  Result:=0;
end;

function CalcMemoHeight(DC : HDC; Memo : TStrings) : integer;
var
  i : integer;
  s : string;
  sz : tagSize;
begin
Result := Max(0,(Memo.Count-1)*StepLine);
for i:=0 to Memo.Count-1 do
  begin
    s := Memo[i];
    if s='' then
      GetTextExtentPoint32(DC,DefEmptyLine,DefEmptyLineLength,sz)
    else
      GetTextExtentPoint32(DC,PChar(s),Length(Memo[i]),sz);
    Result := Result+sz.cy;
  end;
end;

procedure WrapMemo(DC : HDC; Memo : TStrings; w : integer);
var
  s : string;
  l : TStringList;
  sz : tagSize;
  i,ls,p1,p2 : integer;
begin
l := TStringList.Create;
try
  for i:=0 to Memo.Count-1 do
    begin
      s := Memo[i];
      repeat
        ls := Length(s);
        p1 := ls;
        while p1>0 do
          begin
            GetTextExtentPoint(DC,PChar(s),p1,sz);
            if sz.cx<=w then break;
            Dec(p1);
          end;
        // width of string from 1 to p1 less then w
        if p1<ls then
          begin
            if s[p1+1]=' ' then
              begin
                while (p1<=ls) and (s[p1]=' ') do Inc(p1);
              end
            else
              begin
                p2 := p1;
                while (p2>0) and not(s[p2] in [' ','.',',','-',';']) do Dec(p2);
                if p2>0 then
                  p1 := p2;
              end;
            l.Add(Trim(Copy(s,1,p1)));
            Delete(s,1,p1)
          end
        else
          break;
      until false;
      l.Add(s);
    end;
  Memo.Assign(l);
finally
  l.Free;
end;
end;

procedure SaveDCObjects(DC : HDC; var hpn : HPEN; var hbr : HBRUSH; var hfn : HFONT);
begin
hpn := GetCurrentObject(DC,OBJ_PEN);
hbr := GetCurrentObject(DC,OBJ_BRUSH);
hfn := GetCurrentObject(DC,OBJ_FONT);
end;

procedure RestoreDCObjects(DC : HDC; var hpn : HPEN; var hbr : HBRUSH; var hfn : HFONT);
begin
SelectObject(DC,hpn);
SelectObject(DC,hbr);
SelectObject(DC,hfn);
end;

//////////////////////
//
// TprExObjRecVersion
//
//////////////////////
procedure TprExObjRecVersion.Assign;
begin
inherited;
if Source is TprExObjRecVersion then
  with TprExObjRecVersion(Source) do
    begin
      Self.GeneratedRect := GeneratedRect;
      Self.PreviewUserData := PreviewUserData;
    end;
end;

procedure TprExObjRecVersion.DefineProperties;
begin
inherited;
Filer.DefineBinaryProperty('DrawRect',
                           ReadGeneratedRect,
                           WriteGeneratedRect,
                           not((GeneratedRect.Left=0) and
                               (GeneratedRect.Top=0) and
                               (GeneratedRect.Right=0) and
                               (GeneratedRect.Bottom=0)));
Filer.DefineBinaryProperty('PreviewUserData',
                           ReadPreviewUserData,
                           WritePreviewUserData,
                           PreviewUserData<>nil);
end;

procedure TprExObjRecVersion.ReadGeneratedRect;
begin
Stream.ReadBuffer(GeneratedRect,sizeof(GeneratedRect));
end;

procedure TprExObjRecVersion.WriteGeneratedRect;
begin
Stream.WriteBuffer(GeneratedRect,sizeof(GeneratedRect));
end;

procedure TprExObjRecVersion.ReadPreviewUserData;
begin
PreviewUserData := CreateprPreviewUserData(ReadString(Stream));
PreviewUserData.LoadFromStream(Stream);
end;

procedure TprExObjRecVersion.WritePreviewUserData;
begin
WriteString(Stream,PreviewUserData.ClassName);
PreviewUserData.SaveToStream(Stream);
end;

procedure TprExObjRecVersion.Scale;
begin
GeneratedRect := MulDivRect(GeneratedRect,cx1,cx2,cy1,cy2);
end;

procedure TprExObjRecVersion.CalcRealRect;
begin
if pdi.IsPrinter then
  begin
    PrinterRealRect := MulDivRect(GeneratedRect,pdi.xmul,pdi.xdiv,pdi.ymul,pdi.ydiv);
  end
else
  begin
    RealRect := MulDivRect(GeneratedRect,pdi.xmul,pdi.xdiv,pdi.ymul,pdi.ydiv);
  end;
end;

procedure TprExObjRecVersion.PreviewUpdateProps;
begin                    
end;

///////////////////////////
//
// TprFindText
//
///////////////////////////
constructor TprFindText.CreateFT;
begin
inherited;
TextRect := _TextRect;
end;

//////////////////////
//
// TprFrameLine
//
//////////////////////
procedure TprFrameLine.Assign;
begin
with Source as TprFrameLine do
  begin
    Self.FShow := FShow;
    Self.FStyle := FStyle;
    Self.FColor := FColor;
    Self.FWidth := FWidth;
  end;
end;




procedure JustifyArray(a : PprIntegerArray; aLen,NeededSize,RealSize : integer);
var
  i,n,step,Delta,DeltaAbs : integer;
begin
if aLen=0 then exit;
Delta   :=NeededSize-RealSize;
DeltaAbs:=abs(Delta);
if DeltaAbs>=aLen then
  begin
    //     
    n:=Delta div aLen;
    for i:=0 to aLen-1 do
      begin
        Inc(a^[i],n);
        Dec(Delta,n);
      end;
    DeltaAbs:=abs(Delta);
  end;
if Delta<>0 then
  begin
    //   Delta
    if Delta>0 then step:=1
               else step:=-1;
    n:=aLen div DeltaAbs;
    i:=0;
    while (i<aLen) and (DeltaAbs>0) do
      begin
        Inc(a^[i],step);
        Inc(i,n);
        Dec(DeltaAbs);
      end;
    if DeltaAbs>0 then
      Inc(a^[aLen div 2],step);
  end;
end;

function DrawTextJustify(DC          : HDC;
                         s           : PChar;
                         ls          : integer;
                         yOffs       : integer;
                         xOffs       : integer;
                         Rotate90    : boolean;
                         AllSize     : integer;
                         JustifySize : integer;
                         TextRect    : TRect;
                         Align       : TprCommonAlign;
                         pdi         : PprDrawInfo) : integer;
var
  r : TRect;
  sz : TSize;
  aDx : PprIntegerArray;
  tl,fCompare : cardinal;
  pStart,Width,p,lft,i,offs : integer;

  b1 : integer;
  szbuf : TSize;
begin
offs:=0;
case Align of
  praCenter: if AllSize>JustifySize then offs:=(AllSize-JustifySize) div 2;
  praToMax : if AllSize>JustifySize then offs:=AllSize-JustifySize;
end;

if Rotate90 then yOffs:=yOffs-Offs
            else xOffs:=xOffs+Offs;

GetTextExtentPoint32(DC,s,ls,sz);
Result:=sz.cy;
aDx   :=nil;
try
  if (sz.cx=JustifySize) or (ls=1) then
    begin
      //   
      ExtTextOut(DC,
                 xOffs,
                 yOffs,
                 ETO_CLIPPED,
                 @TextRect,
                 s,
                 ls,
                 nil);
    end
  else
    begin
      //   
      GetMem(aDx,4*ls);
      if GetTextExtentExPoint(DC,s,ls,sz.cx,@b1,@(aDx^[0]),szbuf) then
        begin
          for i:=ls-1 downto 1 do
            aDx^[i]:=aDx^[i]-aDx^[i-1];
          JustifyArray(@(aDx^[0]),ls-1,JustifySize,sz.cx);
          ExtTextOut(DC,
                     xOffs,
                     yOffs,
                     ETO_CLIPPED,
                     @TextRect,
                     s,
                     ls,
                     @(aDx^[0]));
        end;
    end;

  if (pdi^.ppdi<>nil) and (pdi^.ppdi^.DrawMode in [dmFind,dmFindFirst]) then
    begin
      fCompare:=SORT_STRINGSORT;
      if not pdi^.ppdi^.CaseSensitive then
        fCompare:=fCompare or NORM_IGNORECASE;

      //       
      tl :=GetThreadLocale;
      p  :=0;
      lft:=Length(pdi^.ppdi^.FindText);
      while p<=ls-lft do
        begin
          if CompareString(tl,
                           fCompare,
                           s+p,
                           lft,
                           PChar(pdi^.ppdi^.FindText),
                           lft)=2 then
            begin
              //  ,   
              if aDx=nil then
                begin
                  GetTextExtentPoint32(DC,@(s[0]),p,sz);
                  pStart:=sz.cx;
                  GetTextExtentPoint32(DC,@(s[p]),lft,sz);
                  Width :=sz.cx;
                end
              else
                begin
                  pStart:=0;
                  i     :=0;
                  while i<p do
                    begin pStart:=pStart+aDx^[i]; Inc(i); end;
                  Width :=0;
                  while (i<p+lft) and (i<ls-1) do
                    begin Width:=Width+aDx^[i]; Inc(i); end;
                  if (i>=ls-1) and (ls=p+lft) then
                    begin
                      //    
                      GetTextExtentPoint32(DC,s+ls-1,1,sz);
                      Width:=Width+sz.cx;
                    end;
                end;

              if Rotate90 then
                r:=Rect(xoffs,yoffs-pStart-Width,xoffs+Result,yoffs-pStart)
              else
                r:=Rect(xoffs+pStart,yoffs,xoffs+pStart+Width,yoffs+Result);
              InvertRect(DC,r);

              if pdi^.ppdi^.DrawMode=dmFindFirst then
                //  ,   
                pdi^.ppdi^.FindList.Add(TprFindText.CreateFT(r));
            end;
          Inc(p);
        end;
    end;
finally
  if aDx<>nil then
    FreeMem(aDx);
end;
end;

procedure DrawDesignObjBorders(DC : HDC; const r : TRect; lBorder,tBorder,rBorder,bBorder : TprFrameLine);
var
  tb : tagLOGBRUSH;
  NewH,OldH : HGDIOBJ;
  w1,w2 : integer;
  nbr,obr : HBRUSH;
  lbr : tagLOGBRUSH;

  procedure SetPS(b : TprFrameLine);
  begin
  tb.lbStyle := BS_SOLID;
  tb.lbColor := b.Color;
  NewH := ExtCreatePen(PS_GEOMETRIC+PS_ENDCAP_SQUARE+PenStyles[b.Style],b.Width,tb,0,nil);
  OldH := SelectObject(DC,NewH);
  end;
begin
//        ,   
// ,     
if not(tBorder.Show or lBorder.Show or bBorder.Show or rBorder.Show) then
  begin
    DrawAngleRect(DC,r);
  end
else
  begin
    if (tBorder.Show and lBorder.Show and bBorder.Show and rBorder.Show) and
       ((tBorder.Style=lBorder.Style) and (tBorder.Style=bBorder.Style) and (tBorder.Style=rBorder.Style)) and
       ((tBorder.Color=lBorder.Color) and (tBorder.Color=bBorder.Color) and (tBorder.Color=rBorder.Color)) and
       ((tBorder.Width=lBorder.Width) and (tBorder.Width=bBorder.Width) and (tBorder.Width=rBorder.Width)) then
      begin
        if tBorder.Show then
          begin
            w1 := (tBorder.Width div 2);
            w2 := (tBorder.Width mod 2);

            SetPS(tBorder);
            lbr.lbStyle := BS_NULL;
            nbr := CreateBrushIndirect(lbr);
            obr := SelectObject(DC,nbr);

            Rectangle(DC,
                      r.Left+w1,
                      r.Top+w1,
                      r.Right-w1+(w2 xor 1),
                      r.Bottom-w1+(w2 xor 1));

            SelectObject(DC,obr);
            DeleteObject(nbr);
            SelectObject(DC,OldH);
            DeleteObject(NewH);
          end;
      end
    else
      begin
        //
        //    PageRect,   Width>1
        //      Width>1,        10
        //      9   10,   3   9  11
        //  4   8  11   
        //
        //  : , , ,   
        //
        if tBorder.Show then
          begin
            SetPS(tBorder);

            w1 := (tBorder.Width div 2);
            w2 := (tBorder.Width div 2)+(tBorder.Width mod 2);
            MoveToEx(DC,r.Left+w1,r.Top+w1,nil);
            LineTo(DC,r.Right-w2,r.Top+w1);

            SelectObject(DC,OldH);
            DeleteObject(NewH);
          end;

        if rBorder.Show then
          begin
            SetPS(rBorder);

            w1 := (rBorder.Width div 2);
            w2 := (rBorder.Width div 2)+(rBorder.Width mod 2);
            MoveToEx(DC,r.Right-w2,r.Top+w1,nil);
            LineTo(DC,r.Right-w2,r.Bottom-w2);

            SelectObject(DC,OldH);
            DeleteObject(NewH);
          end;

        if bBorder.Show then
          begin
            SetPS(bBorder);

            w1 := (bBorder.Width div 2);
            w2 := (bBorder.Width div 2)+(bBorder.Width mod 2);
            MoveToEx(DC,r.Right-w2,r.Bottom-w2,nil);
            LineTo(DC,r.Left+w1,r.Bottom-w2);

            SelectObject(DC,OldH);
            DeleteObject(NewH);
          end;

        if lBorder.Show then
          begin
            SetPS(lBorder);

            w1 := (lBorder.Width div 2);
            w2 := (lBorder.Width div 2)+(lBorder.Width mod 2);
            MoveToEx(DC,r.Left+w1,r.Bottom-w2,nil);
            LineTo(DC,r.Left+w1,r.Top+w1);

            SelectObject(DC,OldH);
            DeleteObject(NewH);
          end;
      end;
  end;
end;

procedure DrawObjBorders(DC : HDC; const r : TRect; lBorder,tBorder,rBorder,bBorder : TprFrameLine; Flw,Ftw,Frw,Fbw : integer);
var
  tb : tagLOGBRUSH;
  NewH,OldH : HGDIOBJ;
  w1,w2 : integer;
  nbr,obr : HBRUSH;
  lbr : tagLOGBRUSH;

  procedure SetPS(b : TprFrameLine; w : integer);
  begin
  tb.lbStyle := BS_SOLID;
  tb.lbColor := b.Color;
  NewH := ExtCreatePen(PS_GEOMETRIC+PS_ENDCAP_SQUARE+PenStyles[b.Style],w,tb,0,nil);
  OldH := SelectObject(DC,NewH);
  end;

begin
if (tBorder.Show and lBorder.Show and bBorder.Show and rBorder.Show) and
   ((tBorder.Style=lBorder.Style) and (tBorder.Style=bBorder.Style) and (tBorder.Style=rBorder.Style)) and
   ((tBorder.Color=lBorder.Color) and (tBorder.Color=bBorder.Color) and (tBorder.Color=rBorder.Color)) and
   ((tBorder.Width=lBorder.Width) and (tBorder.Width=bBorder.Width) and (tBorder.Width=rBorder.Width)) then
  begin
    if tBorder.Show then
      begin
        w1:=(Ftw div 2);
        w2:=(Ftw mod 2);

        SetPS(tBorder,Ftw);
        lbr.lbStyle := BS_NULL;
        nbr := CreateBrushIndirect(lbr);
        obr := SelectObject(DC,nbr);

        Rectangle(DC,
                  r.Left+w1,
                  r.Top+w1,
                  r.Right-w1+(w2 xor 1),
                  r.Bottom-w1+(w2 xor 1));

        SelectObject(DC,obr);
        DeleteObject(nbr);
        SelectObject(DC,OldH);
        DeleteObject(NewH);
      end;
  end
else
  begin
    //
    //    PageRect,   Width>1
    //      Width>1,        10
    //      9   10,   3   9  11
    //  4   8  11   
    //
    //  : , , ,   
    //
    if tBorder.Show then
      begin
        SetPS(tBorder,Ftw);

        w1:=(Ftw div 2);
        w2:=(Ftw div 2)+(Ftw mod 2);
        MoveToEx(DC,r.Left+w1,r.Top+w1,nil);
        LineTo(DC,r.Right-w2,r.Top+w1);

        SelectObject(DC,OldH);
        DeleteObject(NewH);
      end;

    if rBorder.Show then
      begin
        SetPS(rBorder,Frw);

        w1:=(Frw div 2);
        w2:=(Frw div 2)+(Frw mod 2);
        MoveToEx(DC,r.Right-w2,r.Top+w1,nil);
        LineTo(DC,r.Right-w2,r.Bottom-w2);

        SelectObject(DC,OldH);
        DeleteObject(NewH);
      end;

    if bBorder.Show then
      begin
        SetPS(bBorder,Fbw);

        w1:=(Fbw div 2);
        w2:=(Fbw div 2)+(Fbw mod 2);
        MoveToEx(DC,r.Right-w2,r.Bottom-w2,nil);
        LineTo(DC,r.Left+w1,r.Bottom-w2);

        SelectObject(DC,OldH);
        DeleteObject(NewH);
      end;

    if lBorder.Show then
      begin
        SetPS(lBorder,Flw);

        w1:=(Flw div 2);
        w2:=(Flw div 2)+(Flw mod 2);
        MoveToEx(DC,r.Left+w1,r.Bottom-w2,nil);
        LineTo(DC,r.Left+w1,r.Top+w1);

        SelectObject(DC,OldH);
        DeleteObject(NewH);
      end;
  end;
end;

/////////////////////////
//
// TprMemoObjRecVersion
//
/////////////////////////
constructor TprMemoObjRecVersion.Create;
begin
inherited;
FMemo := TStringList.Create;
FFont := TFont.Create;
FFont.Name := sArialFont;
FFont.Size := 10;
FFont.Charset := DEFAULT_CHARSET;
FlBorder := TprFrameLine.Create;
FtBorder := TprFrameLine.Create;
FrBorder := TprFrameLine.Create;
FbBorder := TprFrameLine.Create;
end;

destructor TprMemoObjRecVersion.Destroy;
begin
FMemo.Free;
FFont.Free;
FlBorder.Free;
FtBorder.Free;
FrBorder.Free;
FbBorder.Free;
inherited;
end;

procedure TprMemoObjRecVersion.Scale;
var
  i,x1,x2,y1,y2 : integer;
begin
inherited;
if Rotate90 then
  begin
    x1 := cy1;
    x2 := cy2;
    y1 := cx1;
    y2 := cx2;
  end
else
  begin
    x1 := cx1;
    x2 := cx2;
    y1 := cy1;
    y2 := cy2;
  end;
for i:=0 to High(FGeneratedTextWidths) do
  FGeneratedTextWidths[i] := MulDiv(FGeneratedTextWidths[i],x1,x2);
FGeneratedTextHeight := MulDiv(FGeneratedTextHeight,y1,y2);
end;

procedure TprMemoObjRecVersion.DefineProperties;
begin
inherited;
Filer.DefineProperty('FontSize',ReadFontSize,WriteFontSize,true);
Filer.DefineBinaryProperty('GeneratedData',
                           ReadGeneratedData,
                           WriteGeneratedData,
                           (FGeneratedTextHeight<>0) or
                           (Length(FGeneratedTextWidths)>0));
end;

procedure TprMemoObjRecVersion.ReadFontSize;
begin
Font.Size := Reader.ReadInteger;
end;

procedure TprMemoObjRecVersion.WriteFontSize;
begin
Writer.WriteInteger(Font.Size);
end;

procedure TprMemoObjRecVersion.ReadGeneratedData;
var
  i,n : integer;
begin
Stream.ReadBuffer(FGeneratedTextHeight,4);
Stream.ReadBuffer(n,4);
SetLength(FGeneratedTextWidths,n);
for i:=0 to n-1 do
  Stream.ReadBuffer(FGeneratedTextWidths[i],4);
end;

procedure TprMemoObjRecVersion.WriteGeneratedData;
var
  i,n : integer;
begin
Stream.WriteBuffer(FGeneratedTextHeight,4);
n:=Length(FGeneratedTextWidths);
Stream.WriteBuffer(n,4);
for i:=0 to n-1 do
  Stream.WriteBuffer(FGeneratedTextWidths[i],4);
end;

procedure TprMemoObjRecVersion.Assign;
var
  i : integer;
begin
with Source as TprMemoObjRecVersion do
  begin
    Self.SecondPassNeeded := SecondPassNeeded;
    Self.FFillColor := FFillColor;
    Self.FhAlign := FhAlign;
    Self.FvAlign := FvAlign;
    Self.FRotate90 := FRotate90;
    Self.FDeleteEmptyLinesAtEnd := FDeleteEmptyLinesAtEnd;
    Self.FDeleteEmptyLines := FDeleteEmptyLines;
    Self.FCanResizeX := FCanResizeX;
    Self.FCanResizeY := FCanResizeY;
    Self.FWordWrap := FWordWrap;

    Self.FlBorder.Assign(FlBorder);
    Self.FtBorder.Assign(FtBorder);
    Self.FbBorder.Assign(FbBorder);
    Self.FrBorder.Assign(FrBorder);

    Self.FFont.Assign(FFont);
    Self.FMemo.Assign(FMemo);

    Self.FGeneratedTextHeight := FGeneratedTextHeight;
    SetLength(Self.FGeneratedTextWidths,Length(FGeneratedTextWidths));
    for i:=0 to Length(FGeneratedTextWidths)-1 do
      Self.FGeneratedTextWidths[i] := FGeneratedTextWidths[i];
  end;
inherited;
end;

procedure TprMemoObjRecVersion.InitInDesigner;
  procedure InitFrameLine(fl : TprFrameLine);
  begin
  fl.Show := true;
  fl.Width := 1;
  fl.Color := clBlack;
  fl.Style := psSolid;
  end;
begin
FillColor := clWhite;
InitFrameLine(lBorder);
InitFrameLine(rBorder);
InitFrameLine(tBorder);
InitFrameLine(bBorder);
end;

procedure TprMemoObjRecVersion.CalcGeneratedData;
var
  j : integer;
  s : string;
  sz : TSize;
  NewFont,OldFont : HFONT;
begin
if Rotate90 then
  NewFont := Create90Font(Font)
else
  NewFont := CreateAPIFont(Font);
OldFont := SelectObject(DC,NewFont);
try
  //     Memo
  SetLength(FGeneratedTextWidths,Memo.Count);
  FGeneratedTextHeight := 0;
  for j:=0 to Memo.Count-1 do
    begin
      s := Memo[j];
      if s='' then
        GetTextExtentPoint32(DC,DefEmptyLine,DefEmptyLineLength,sz)
      else
        GetTextExtentPoint32(DC,PChar(s),Length(s),sz);
      FGeneratedTextWidths[j] := sz.cx;
      FGeneratedTextHeight := FGeneratedTextHeight+sz.cy;
    end;
finally
  SelectObject(DC,OldFont);
  DeleteObject(NewFont);
end;
end;

procedure TprMemoObjRecVersion.PreviewUpdateProps;
var
  DC : HDC;
begin
DC := GetDC(0);
try
  CalcGeneratedData(DC);
  CalcRealRect(pdi);
finally
  ReleaseDC(0,DC);
end;
end;

procedure TprMemoObjRecVersion.Draw;
var
  s : string;
  r : TRect;
  sz : tagSize;
  nbr : HBRUSH;
  aHeights : PprIntegerArray;
  NewFont,OldFont : HFONT;
  TextHeight,i,CurY,CurX,ls : integer;

  RealRect : PRect;
  Flw,Ftw,Frw,Fbw : integer;
  FRealTextHeight : integer;
  FRealTextWidths : array of integer;

  //    90  HFONT,
  //  
  function _Create90Font(Font : TFont) : HFont;
  var
    F : TLogFont;
  begin
    GetObject(Font.Handle, SizeOf(TLogFont), @F);
    F.lfEscapement  := 900;
    F.lfOrientation := 900;
    if pdi.IsPrinter then
      F.lfHeight := -MulDiv(Font.Size, GetDeviceCaps(DC, LOGPIXELSY), 72)
    else
      F.lfHeight := MulDiv(F.lfHeight,pdi.ymul,pdi.ydiv);
    Result := CreateFontIndirect(F);
  end;

  //   HFONT
  //  
  function _CreateAPIFont(Font : TFont) : HFont;
  var
    F : TLogFont;
  begin
    GetObject(Font.Handle, SizeOf(TLogFont), @F);
    if pdi.IsPrinter then
      F.lfHeight := -MulDiv(Font.Size, GetDeviceCaps(DC, LOGPIXELSY), 72)
    else
      F.lfHeight := MulDiv(F.lfHeight,pdi.ymul,pdi.ydiv);
    Result := CreateFontIndirect(F);
  end;

begin
if lBorder.Show then Flw := Max(1,muldiv(lBorder.Width,pdi.xmul,pdi.xdiv))
                else Flw := 0;
if tBorder.Show then Ftw := Max(1,muldiv(tBorder.Width,pdi.ymul,pdi.ydiv))
                else Ftw := 0;
if rBorder.Show then Frw := Max(1,muldiv(rBorder.Width,pdi.xmul,pdi.xdiv))
                else Frw := 0;
if bBorder.Show then Fbw := Max(1,muldiv(bBorder.Width,pdi.ymul,pdi.ydiv))
                else Fbw := 0;
FRealTextHeight := muldiv(FGeneratedTextHeight,pdi.ymul,pdi.ydiv);
ls := Length(FGeneratedTextWidths);
SetLength(FRealTextWidths,ls);
for i:=0 to ls-1 do
  FRealTextWidths[i] := muldiv(FGeneratedTextWidths[i],pdi.xmul,pdi.xdiv);
if pdi.IsPrinter then
  RealRect := @Self.PrinterRealRect
else
  RealRect := @Self.RealRect;

if (FillColor<>clNone) and (FillColor<>clWhite) then
  begin
    // 
    nbr:=CreateSolidBrush(FillColor);
    FillRect(DC,RealRect^,nbr);
    DeleteObject(nbr);
  end;

// 
DrawObjBorders(DC,RealRect^,lBorder,tBorder,rBorder,bBorder,Flw,Ftw,Frw,Fbw);

//   ,   
r:=Rect(RealRect.Left+Flw+muldiv(oLeft,pdi.xmul,pdi.xdiv),
        RealRect.Top+Ftw+muldiv(oTop,pdi.ymul,pdi.ydiv),
        RealRect.Right-Frw-muldiv(oRight,pdi.xmul,pdi.xdiv),
        RealRect.Bottom-Fbw-muldiv(oBottom,pdi.ymul,pdi.ydiv));

if Memo.Count>0 then
  begin
    SetTextColor(DC,Font.Color);
    SetBkMode(DC,TRANSPARENT);
    if Rotate90 then
      begin
        NewFont:=_Create90Font(Font);
        OldFont:=SelectObject(DC,NewFont);
        GetMem(aHeights,(Memo.Count-1)*4);
        try
          ZeroMemory(aHeights,(Memo.Count-1)*4);
          JustifyArray(aHeights,
                       Memo.Count-1,
                       FRealTextHeight,
                       CalcMemoHeight(DC,Memo));
    
          CurX:=r.Left;
          case hAlign of
            prhCenter:
              if r.Right-r.Left>FRealTextHeight then CurX:=r.Left+(r.Right-r.Left-FRealTextHeight) div 2;
            prhRight:
              if r.Right-r.Left>FRealTextHeight then CurX:=r.Right-FRealTextHeight;
          end;
    
          //  
          for i:=0 to Memo.Count-1 do
            begin
              s:=Memo[i];
              if s<>'' then
                begin
                  ls:=Length(s);
    
                  TextHeight:=DrawTextJustify(DC,
                                              PChar(s),
                                              ls,
                                              r.Bottom,
                                              CurX,
                                              true,
                                              r.Bottom-r.Top,
                                              FRealTextWidths[i],
                                              r,
                                              TprCommonAlign(vAlign),
                                              pdi);
    
                end
              else
                begin
                  GetTextExtentPoint32(DC,DefEmptyLine,DefEmptyLineLength,sz);
                  TextHeight:=sz.cy;
                end;
    
              CurX:=CurX+StepLine+TextHeight;
              if i<Memo.Count-1 then
                CurX:=CurX+aHeights^[i];
            end;
        finally
          FreeMem(aHeights);
          SelectObject(DC,OldFont);
          DeleteObject(NewFont);
        end;
      end
    else
      begin
        NewFont:=_CreateAPIFont(Font);
        OldFont:=SelectObject(DC,NewFont);
        GetMem(aHeights,(Memo.Count-1)*4);
        try
          //    
          ZeroMemory(aHeights,(Memo.Count-1)*4);
          JustifyArray(aHeights,
                       Memo.Count-1,
                       FRealTextHeight,
                       CalcMemoHeight(DC,Memo));
    
          CurY:=r.Top;
          case vAlign of
            prvCenter:
              if r.Bottom-r.Top>FRealTextHeight then CurY:=r.Top+(r.Bottom-r.Top-FRealTextHeight) div 2;
            prvBottom:
              if r.Bottom-r.Top>FRealTextHeight then CurY:=r.Bottom-FRealTextHeight;
          end;
    
          //  
          for i:=0 to Memo.Count-1 do
            begin
              s:=Memo[i];
              if s<>'' then
                begin
                  ls:=Length(s);
    
                  TextHeight:=DrawTextJustify(DC,
                                              PChar(s),
                                              ls,
                                              CurY,
                                              r.Left,
                                              false,
                                              r.Right-r.Left,
                                              FRealTextWidths[i],
                                              r,
                                              TprCommonAlign(hAlign),
                                              pdi);
    
                end
              else
                begin
                  GetTextExtentPoint32(DC,DefEmptyLine,DefEmptyLineLength,sz);
                  TextHeight:=sz.cy;
                end;

              CurY:=CurY+StepLine+TextHeight;
              if i<Memo.Count-1 then
                CurY:=CurY+aHeights^[i];
            end;
        finally
          FreeMem(aHeights);
          SelectObject(DC,OldFont);
          DeleteObject(NewFont);
        end;
      end;
    SetBkMode(DC,OPAQUE);
  end;
end;

procedure SetXLSBorders(V : Variant; lBorder,tBorder,rBorder,bBorder : TprFrameLine);
  procedure SetXLSBorder(bi : cardinal; b : TprFrameLine);
  begin
  if not b.Show then exit;
  V.Borders[bi].Color := b.Color;
  V.Borders[bi].LineStyle := XLSLineStyle[b.Style];
  V.Borders[bi].Weight := xlThin;
  end;
begin
SetXLSBorder(xlEdgeLeft,lBorder);
SetXLSBorder(xlEdgeTop,tBorder);
SetXLSBorder(xlEdgeRight,rBorder);
SetXLSBorder(xlEdgeBottom,bBorder);
end;

procedure TprMemoObjRecVersion.ExportToXLS;
var
  s : string;
begin
s := Memo.Text;
Delete(s,Length(s)-1,2);
V.Value := StringReplace(s,#13,'',[rfReplaceAll]);
V.VerticalAlignment := XLSVertAlignment[vAlign];
V.HorizontalAlignment := XLSHorAlignment[hAlign];
V.Font.Color := Font.Color;
V.Font.Name := Font.Name;
V.Font.Size := Font.Size;
V.Font.Bold := fsBold in Font.Style;
V.Font.Italic := fsItalic in Font.Style;
V.Font.Underline := fsUnderline in Font.Style;
V.Font.Strikethrough := fsStrikeOut in Font.Style;
if WordWrap then
  V.WrapText := true;
if Rotate90 then
  V.Orientation := 90;
SetXLSBorders(V,lBorder,tBorder,rBorder,bBorder);
if (FillColor<>clNone) and (FillColor<>clWhite) then
  begin
    V.Interior.Color := FillColor;
    V.Interior.Pattern := xlSolid;
  end;
end;

//////////////////////
//
// TprMemoObjRec
//
//////////////////////
function TprMemoObjRec.CreateCopy;
begin
Result:=TprMemoObjRec.Create(Self.Page,Self.Obj);
Result.Assign(Self);
end;

function TprMemoObjRec.CreateVersions;
begin
Result:=TprObjRecVersions.Create(TprMemoObjRecVersion);
end;

procedure TprMemoObjRec.SecondPass;
var
  l : TStringList;
  v : TprMemoObjRecVersion;
  i,w : integer;
  NewFont,OldFont : HFONT;
begin
inherited; //  
l:=TStringList.Create;
try
  for i:=0 to Versions.Count-1 do
    if TprMemoObjRecVersion(Versions[i]).SecondPassNeeded then
      begin
        v:=TprMemoObjRecVersion(Versions[i]);
        Obj.Band.Report.FormatStrings(v.Memo,
                                      l,
                                      v.DeleteEmptyLines,
                                      v.DeleteEmptyLinesAtEnd);
        v.Memo.Assign(l);

        if v.WordWrap then
          begin
            //   
            if v.Rotate90 then
              begin
                NewFont:=Create90Font(v.Font);
                w      :=dy;
              end
            else
              begin
                NewFont:=CreateAPIFont(v.Font);
                w      :=dx;
              end;
            OldFont:=SelectObject(HDC(Obj.Report.ObjectCalcSizesDevice),NewFont);
            try
              WrapMemo(HDC(Obj.Report.ObjectCalcSizesDevice),v.Memo,w);
            finally
              SelectObject(HDC(Obj.Report.ObjectCalcSizesDevice),OldFont);
              DeleteObject(NewFont);
            end;
          end;
      end;
finally
  l.Free;
end;
end;

procedure TprMemoObjRec.PlaceOnEndPage;
var
  v : TprMemoObjRecVersion;
begin
if not Versions[CurVersion].Visible then exit;
v := TprMemoObjRecVersion.Create(nil);
v.Assign(TprMemoObjRecVersion(Versions[CurVersion]));
v.PreviewUserData := PreviewUserData;
PreviewUserData := nil;
TprEndPage(Page).vl.Add(v);

//   
v.GeneratedRect := r;
v.CalcGeneratedData(HDC(Device));
end;

//////////////////////////////
//
// TprMemoObj
//
//////////////////////////////
function TprMemoObj.AllowInplaceEdit;
begin
Result:=true;
end;

procedure TprMemoObj.InplaceEdit;
var
  r : TRect;
  v : TprMemoObjRecVersion;
begin
v:=TprMemoObjRecVersion(dRec.Versions[dRec.DefVersion]);
InplaceEditor:=TMemo.Create(_Parent);

with TMemo(InplaceEditor) do
  begin
    WordWrap       := false;
    ParentCtl3D    := False;
    Ctl3D          := False;
    TabStop        := False;
    BorderStyle    := bsNone;
    DoubleBuffered := False;

    if v.Rotate90 then
      begin
        Left  :=pdi.dPageRect.Left+GetBW(v.lBorder);
        Top   :=pdi.dPageRect.Top+GetBW(v.tBorder);
        Width :=pdi.dPageRect.Bottom-pdi.dPageRect.Top-GetBW(v.tBorder)-GetBW(v.bBorder);
        Height:=pdi.dPageRect.Right-pdi.dPageRect.Left-GetBW(v.lBorder)-GetBW(v.rBorder);
      end
    else
      begin
        Left  :=pdi.dPageRect.Left+GetBW(v.lBorder);
        Top   :=pdi.dPageRect.Top+GetBW(v.tBorder);
        Width :=pdi.dPageRect.Right-pdi.dPageRect.Left-GetBW(v.lBorder)-GetBW(v.rBorder);
        Height:=pdi.dPageRect.Bottom-pdi.dPageRect.Top-GetBW(v.tBorder)-GetBW(v.bBorder);
      end;
    if v.FillColor=clNone then
      Color:=clWindow
    else
      Color:=v.FillColor;
    Parent:=_Parent;

    Font.Assign(v.Font);
    Lines.Assign(v.Memo);

    r:=Rect(0,0,Width,Height);
    SendMessage(InplaceEditor.Handle, EM_SETRECT, 0, LongInt(@R));
    SendMessage(InplaceEditor.Handle, EM_SETSEL, 0, 0);

    Show;
    SetFocus;
  end;
end;

procedure TprMemoObj.SaveInplaceEdit;
begin
TprMemoObjRecVersion(dRec.Versions[dRec.DefVersion]).Memo.Assign(TMemo(InplaceEditor).Lines);
end;

procedure TprMemoObj.InitdRec;
begin
FdRec := TprMemoObjRec.Create(nil,Self);
TprExObjRecVersion(dRec.Versions.Add).InitInDesigner;
end;

function TprMemoObj.GetDesc;
var
  i : integer;
  v : TprMemoObjRecVersion;
begin
v:=TprMemoObjRecVersion(dRec.Versions[dRec.DefVersion]);
i:=0;
while (i<v.Memo.Count) and
      (Trim(v.Memo[i])='') do Inc(i);
if i<v.Memo.Count then
  Result:=Trim(v.Memo[i])
else
  Result:=inherited GetDesc;
end;

procedure TprMemoObj.DrawDesign;
var
  s : string;
  v : TprMemoObjRecVersion;
  r : TRect;
  nbr : HBRUSH;
  CalcH : integer;
  i,CurY,CurX : integer;
  NewFont,OldFont : HFONT;
  sz : tagSize;
begin
v:=TprMemoObjRecVersion(dRec.Versions[dRec.DefVersion]);
r:=PDI.dPageRect;

//  
if v.FillColor=clNone then
  nbr:=CreateSolidBrush(clWhite)
else
  nbr:=CreateSolidBrush(v.FillColor);
FillRect(DC,Rect(r.Left+GetBW(v.lBorder),
                 r.Top+GetBW(v.tBorder),
                 r.Right-GetBW(v.rBorder),
                 r.Bottom-GetBW(v.bBorder)),nbr);
DeleteObject(nbr);

DrawDesignObjBorders(DC,r,v.lBorder,v.tBorder,v.rBorder,v.bBorder);

//   ,   
r:=Rect(r.Left+GetBW(v.lBorder)+oLeft,
        r.Top+GetBW(v.tBorder)+oTop,
        r.Right-GetBW(v.rBorder)-oRight,
        r.Bottom-GetBW(v.bBorder)-oBottom);

if v.Memo.Count>0 then
  begin
    if v.Rotate90 then
      begin
        NewFont:=Create90Font(v.Font);
        OldFont:=SelectObject(DC,NewFont);
        SetTextColor(DC,v.Font.Color);
    
        try
          CalcH:=CalcMemoHeight(DC,v.Memo)+oLeft+oRight;
    
          case v.hAlign of
            prhCenter:
              if r.Right-r.Left<CalcH then CurX:=r.Left
                                      else CurX:=r.Left+(r.Right-r.Left-CalcH) div 2;
            prhRight:
              if r.Right-r.Left<CalcH then CurX:=r.Left
                                      else CurX:=r.Right-CalcH
            else
              CurX:=r.Left;
          end;
    
          SetBkMode(DC,TRANSPARENT);
          for i:=0 to v.Memo.Count-1 do
            begin
              s:=v.Memo[i];
              if s='' then
                GetTextExtentPoint32(DC,DefEmptyLine,DefEmptyLineLength,sz)
              else
                GetTextExtentPoint32(DC,PChar(s),Length(s),sz);
    
              case v.vAlign of
                prvCenter:
                  if r.Bottom-r.Top<sz.cx then CurY:=r.Bottom
                                          else CurY:=r.Bottom-(r.Bottom-r.Top-sz.cx) div 2;
                prvTop:
                  if r.Bottom-r.Top<sz.cx then CurY:=r.Bottom
                                          else CurY:=r.Bottom-(r.Bottom-r.Top-sz.cx)
                else
                  CurY:=r.Bottom;
              end;
    
              ExtTextOut(DC,
                         CurX,
                         CurY,
                         ETO_CLIPPED,
                         @r,
                         PChar(s),
                         Length(s),
                         nil);
              CurX:=CurX+StepLine+sz.cy;
            end;
          SetBkMode(DC,OPAQUE);
        finally
          SelectObject(DC,OldFont);
          DeleteObject(NewFont);
        end;
      end
    else
      begin
        NewFont:=CreateAPIFont(v.Font);
        OldFont:=SelectObject(DC,NewFont);
        SetTextColor(DC,v.Font.Color);
    
        try
          CalcH:=CalcMemoHeight(DC,v.Memo)+oTop+oBottom;
    
          case v.vAlign of
            prvCenter:
              if r.Bottom-r.Top<CalcH then CurY:=r.Top
                                      else CurY:=r.Top+(r.Bottom-r.Top-CalcH) div 2;
            prvBottom:
              if r.Bottom-r.Top<CalcH then CurY:=r.Top
                                      else CurY:=r.Bottom-CalcH
            else
              CurY:=r.Top;
          end;
    
          SetBkMode(DC,TRANSPARENT);
          for i:=0 to v.Memo.Count-1 do
            begin
              s:=v.Memo[i];
              if s='' then
                GetTextExtentPoint32(DC,DefEmptyLine,DefEmptyLineLength,sz)
              else
                GetTextExtentPoint32(DC,PChar(s),Length(s),sz);
    
              case v.hAlign of
                prhCenter:
                  if r.Right-r.Left<sz.cx then CurX:=r.Left
                                          else CurX:=r.Left+(r.Right-r.Left-sz.cx) div 2;
                prhRight:
                  if r.Right-r.Left<sz.cx then CurX:=r.Left
                                          else CurX:=r.Right-sz.cx
                else
                  CurX:=r.Left;
              end;
    
              ExtTextOut(DC,
                         CurX,
                         CurY,
                         ETO_CLIPPED,
                         @r,
                         PChar(s),
                         Length(s),
                         nil);
              CurY:=CurY+StepLine+sz.cy;
            end;
          SetBkMode(DC,OPAQUE);
        finally
          SelectObject(DC,OldFont);
          DeleteObject(NewFont);
        end;
      end;
  end;
end;

procedure TprMemoObj.FirstPass;
var
  v : TprMemoObjRecVersion;
  i,mw : integer;
  OldFont,NewFont : HFONT;
  sz : tagSize;
  DC : HDC;
  ManuallyProcessed : boolean;

begin
DC:=HDC(Report.ObjectCalcSizesDevice);

if aRec=nil then
  aRec:=TprMemoObjRec.Create(nil,Self);
aRec.Assign(dRec);

//   
aRec.FirstPassCalcCurVersion;

//   (OnFirstPassObject)
Band.Report.DoOnFirstPassObject(Self,ManuallyProcessed);

//    aRec.Memo
if not ManuallyProcessed then
  for i:=0 to aRec.Versions.Count-1 do
    TprMemoObjRecVersion(aRec.Versions[i]).SecondPassNeeded:=not Band.Report.FormatStrings(TprMemoObjRecVersion(dRec.Versions[i]).Memo,
                                                                                           TprMemoObjRecVersion(aRec.Versions[i]).Memo,
                                                                                           TprMemoObjRecVersion(aRec.Versions[i]).DeleteEmptyLines,
                                                                                           TprMemoObjRecVersion(aRec.Versions[i]).DeleteEmptyLinesAtEnd);

v:=TprMemoObjRecVersion(aRec.Versions[aRec.CurVersion]);

aRec.DX:=dRec.pRect.Right-dRec.pRect.Left;
aRec.DY:=dRec.pRect.Bottom-dRec.pRect.Top;

if v.Rotate90 then
  begin
    NewFont:=Create90Font(v.Font);
    OldFont:=SelectObject(DC,NewFont);

    try
      if v.WordWrap then
        WrapMemo(DC,v.Memo,dRec.pRect.Bottom-dRec.pRect.Top-GetBW(v.rBorder)-GetBW(v.lBorder)-oTop-oBottom)
      else
        if v.CanResizeY then
          begin
            //  DY       Memo
            mw:=0;
            for i:=0 to v.Memo.Count-1 do
              begin
                GetTextExtentPoint32(DC,PChar(v.Memo[i]),Length(v.Memo[i]),sz);
                if mw<sz.cx then
                  mw:=sz.cx;
              end;
            aRec.DY:=mw+oBottom+oTop+GetBW(v.tBorder)+GetBW(v.bBorder);
          end;

      // DX -   
      if v.CanResizeX then
        begin
          aRec.DX:=CalcMemoHeight(DC,v.Memo)+GetBW(v.lBorder)+GetBW(v.rBorder)+oLeft+oRight;
        end;
    finally
      SelectObject(DC,OldFont);
      DeleteObject(NewFont);
    end;
  end
else
  begin
    NewFont:=CreateAPIFont(v.Font);
    OldFont:=SelectObject(DC,NewFont);

    try
      if v.WordWrap then
        WrapMemo(DC,v.Memo,dRec.pRect.Right-dRec.pRect.Left-GetBW(v.rBorder)-GetBW(v.lBorder)-oLeft-oRight)
      else
        if v.CanResizeX then
          begin
            //  DX       Memo
            mw:=0;
            for i:=0 to v.Memo.Count-1 do
              begin
                GetTextExtentPoint32(DC,PChar(v.Memo[i]),Length(v.Memo[i]),sz);
                if mw<sz.cx then
                  mw:=sz.cx;
              end;
            aRec.DX:=mw+oLeft+oRight+GetBW(v.lBorder)+GetBW(v.rBorder);
          end;

      if v.CanResizeY then
        begin
          // DY -   
          aRec.DY:=CalcMemoHeight(DC,v.Memo)+GetBW(v.tBorder)+GetBW(v.bBorder)+oTop+oBottom;
        end;
    finally
      SelectObject(DC,OldFont);
      DeleteObject(NewFont);
    end;
  end;

aRec.pRect:=Rect(-1,-1,-1,-1);

inherited;
end;










type

rRTFStreamIn = record
  Text : string;
end;
pRTFStreamIn = ^rRTFStreamIn;

rRTFStreamOut = record
  Text : PChar;
  Size : integer;
  Pos : integer;
end;
pRTFStreamOut = ^rRTFStreamOut;

rRTFReplaceData = record
  hwnd : THandle;
  Offs : integer;
end;
pRTFReplaceData = ^rRTFReplaceData;

function FormatRichTextWriteCallback(dwCookie : LongInt; Buf : PByte; cb : LongInt; var pcb : LongInt) : integer; stdcall;
var
  l : integer;
begin
l := Length(pRTFStreamIn(dwCookie)^.Text);
SetLength(pRTFStreamIn(dwCookie)^.Text,l+cb);
MoveMemory(@(pRTFStreamIn(dwCookie)^.Text[l+1]),Buf,cb);
pcb := cb;
Result := 0;
end;

function FormatRichTextReadCallback(dwCookie : LongInt; Buf : PByte; cb : LongInt; var pcb : LongInt) : integer; stdcall;
begin
with pRTFStreamOut(dwCookie)^ do
  begin
    pcb := Min(cb,Size-Pos);
    MoveMemory(Buf,@(Text[Pos]),pcb);
    Pos := Pos+pcb;
  end;
Result := 0;
end;

procedure RTFReplaceCallback(FromPos,Count : integer; const Buf : PChar; BufSize : integer; Flags : TprFormatReplaceCallBackOptionsSet; CallBackData : pointer);
var
  cr : _CHARRANGE;
  es : _EDITSTREAM;
  rSO : rRTFStreamOut;
  rd : pRTFReplaceData;
begin
rd := pRTFReplaceData(CallBackData);
cr.cpMin := rd.Offs+FromPos-1;
cr.cpMax := rd.Offs+FromPos+Count-1;
rd.Offs := rd.Offs+BufSize-Count;
SendMessage(rd.hwnd,EM_EXSETSEL,0,integer(@cr));
if prfrcRTF in Flags then
  begin
    //    EM_STREAMIN
    rSO.Text := Buf;
    rSO.Size := BufSize;
    rSO.Pos := 0;
    es.dwCookie := integer(@rSO);
    es.pfnCallback := @FormatRichTextReadCallback;
    SendMessage(rd.hwnd,EM_STREAMIN,SFF_SELECTION or SF_RTF,integer(@es));
  end
else
  begin
    SendMessage(rd.hwnd,EM_REPLACESEL,0,integer(Buf));
  end;
end;

//
//  FormatStrings,   RTF 
//
function FormatRichText;
var
  es : _EDITSTREAM;
  cr : _CHARRANGE;
  rd : rRTFReplaceData;
  rSI : rRTFStreamIn;
  s : string;
  i,LinesCount,LineIndex : integer;
begin
//     
rSI.Text := '';
ZeroMemory(@es,sizeof(es));
es.dwCookie := integer(@rSI);
es.pfnCallback := @FormatRichTextWriteCallback;
SendMessage(hwnd,EM_STREAMOUT,SF_TEXT,integer(@es));
rd.hwnd := hwnd;
rd.Offs := 0;
Result := TprParser(Report.Parser).FormatTemplateEx(rSI.Text,RTFReplaceCallback,pointer(@rd),s);
if Result then
  begin
    //   
    LinesCount := SendMessage(hwnd,EM_GETLINECOUNT,0,0);
    if DeleteEmptyLines then
      begin
        i := 0;
        while i<LinesCount do
          begin
            LineIndex := SendMessage(hwnd,EM_LINEINDEX,i,0);
            if SendMessage(hwnd,EM_LINELENGTH,LineIndex,0)=0 then
              begin
                //  
                if i=LinesCount-1 then
                  begin
                    cr.cpMin := LineIndex-1;
                    cr.cpMax := -1;
                  end
                else
                  begin
                    cr.cpMin := LineIndex;
                    cr.cpMax := SendMessage(hwnd,EM_LINEINDEX,i+1,0)
                  end;
                SendMessage(hwnd,EM_EXSETSEL,0,integer(@cr));
                SendMessage(hwnd,EM_REPLACESEL,0,integer(PChar('')));
                Dec(LinesCount);
              end
            else
              Inc(i);
          end;
      end
    else
      if DeleteEmptyLinesAtEnd then
        begin
          i := LinesCount-1;
          while i>=0 do
            begin
              LineIndex := SendMessage(hwnd,EM_LINEINDEX,i,0);
              if SendMessage(hwnd,EM_LINELENGTH,LineIndex,0)<>0 then
                begin
                  if i<LinesCount-1 then
                    begin
                      cr.cpMin := SendMessage(hwnd,EM_LINEINDEX,i+1,0)-1;
                      cr.cpMax := -1;
                      SendMessage(hwnd,EM_EXSETSEL,0,integer(@cr));
                      SendMessage(hwnd,EM_REPLACESEL,0,integer(PChar('')));
                    end;
                  break;
                end;
              Dec(i);
            end
        end;
  end;
end;

function RichWriteCallback(dwCookie : LongInt; Buf : PByte; cb : LongInt; var pcb : LongInt) : integer; stdcall;
begin
pcb := cb;
TStream(dwCookie).Write(Buf^,cb);
Result := 0;
end;

function RichReadCallback(dwCookie : LongInt; Buf : PByte; cb : LongInt; var pcb : LongInt) : integer; stdcall;
begin
pcb := TStream(dwCookie).Read(Buf^,cb);
Result := 0;
end;

procedure CopyRichText(hwndSource, hwndDest : THandle); overload;
var
  ms : TMemoryStream;
  es : _EDITSTREAM;
begin
ms := TMemoryStream.Create;
try
  ZeroMemory(@es,sizeof(es));
  es.dwCookie := integer(ms);
  es.pfnCallback := @RichWriteCallback;
  SendMessage(hwndSource,EM_STREAMOUT,SF_RTF,integer(@es));
  ms.Seek(0,soFromBeginning);
  es.pfnCallback := @RichReadCallback;
  SendMessage(hwndDest,EM_STREAMIN,SF_RTF,integer(@es));
finally
  ms.Free;
end;
end;

procedure CopyRichText(hwndSource : THandle; RichEditDest : TRichEdit); overload;
var
  ms : TMemoryStream;
  es : _EDITSTREAM;
begin
ms := TMemoryStream.Create;
try
  ZeroMemory(@es,sizeof(es));
  es.dwCookie := integer(ms);
  es.pfnCallback := @RichWriteCallback;
  SendMessage(hwndSource,EM_STREAMOUT,SF_RTF,integer(@es));
  ms.Seek(0,soFromBeginning);
  RichEditDest.Lines.LoadFromStream(ms);
finally
  ms.Free;
end;
end;

procedure CopyRichText(RichEditSource : TRichEdit; hwndDest : THandle); overload;
begin
CopyRichText(RichEditSource.Handle,hwndDest);
end;


/////////////////////////
//
// TprRichObjRecVersion
//
/////////////////////////
constructor TprRichObjRecVersion.Create;
begin
inherited;
if FRichEditModule = 0 then
  begin
    FRichEditModule := LoadLibrary('RICHED32.DLL');
    if FRichEditModule <= HINSTANCE_ERROR then
      FRichEditModule := 0;
  end;
FhwndRich := CreateWindowEx(0, 'RICHEDIT', '',
                            WS_HSCROLL or WS_VSCROLL or ES_NOHIDESEL or ES_AUTOVSCROLL or ES_MULTILINE or ES_SAVESEL,
                            0, 0, MaxRichTextWidth, MaxRichTextHeight,
                            0, 0, hInstance, nil);
FlBorder := TprFrameLine.Create;
FtBorder := TprFrameLine.Create;
FrBorder := TprFrameLine.Create;
FbBorder := TprFrameLine.Create;
FWordWrap := true;
end;

destructor TprRichObjRecVersion.Destroy;
begin
FlBorder.Free;
FtBorder.Free;
FrBorder.Free;
FbBorder.Free;
if FhwndRich<>0 then
  DestroyWindow(FhwndRich);
if FhwndRichFind<>0 then
  DestroyWindow(FhwndRichFind);
inherited;
end;

procedure TprRichObjRecVersion.DefineProperties;
begin
inherited;
Filer.DefineBinaryProperty('RichText',
                           ReadRichText,
                           WriteRichText,
                           true);
end;

procedure TprRichObjRecVersion.ReadRichText;
var
  n : integer;
  ms : TMemoryStream;
  es : _EDITSTREAM;
begin
ms := TMemoryStream.Create;
try
  Stream.Read(n,4);
  ms.CopyFrom(Stream,n);
  ms.Seek(0,soFromBeginning);
  ZeroMemory(@es,sizeof(es));
  es.dwCookie := integer(ms);
  es.pfnCallback := @RichReadCallback;
  SendMessage(FhwndRich,EM_STREAMIN,SF_RTF,integer(@es));
finally
  ms.Free;
end;
end;

procedure TprRichObjRecVersion.WriteRichText;
var
  n : integer;
  ms : TMemoryStream;
  es : _EDITSTREAM;
begin
ms := TMemoryStream.Create;
try
  ZeroMemory(@es,sizeof(es));
  es.dwCookie := integer(ms);
  es.pfnCallback := @RichWriteCallback;
  SendMessage(FhwndRich,EM_STREAMOUT,SF_RTF,integer(@es));
  ms.Seek(0,soFromBeginning);
  n := ms.Size;
  Stream.Write(n,4);
  Stream.CopyFrom(ms,n);
finally
  ms.Free;
end;
end;

procedure TprRichObjRecVersion.Assign;
begin
with Source as TprRichObjRecVersion do
  begin
    CopyRichText(FhwndRich,Self.FhwndRich);
    Self.SecondPassNeeded := SecondPassNeeded;
    Self.FDeleteEmptyLinesAtEnd := FDeleteEmptyLinesAtEnd;
    Self.FDeleteEmptyLines := FDeleteEmptyLines;
    Self.FCanResizeY := FCanResizeY;
    Self.FWordWrap := FWordWrap;

    Self.FlBorder.Assign(FlBorder);
    Self.FtBorder.Assign(FtBorder);
    Self.FbBorder.Assign(FbBorder);
    Self.FrBorder.Assign(FrBorder);
  end;
inherited;
end;

procedure TprRichObjRecVersion.PreviewUpdateProps;
begin
inherited;
end;

procedure TprRichObjRecVersion.Draw;
var
  p : integer;
  ft : TFindTextExA;
  fr : _FORMATRANGE;
  cf2 : TCharFormat2;
  cf : TCharFormat;
  Rgn : HRGN;
  hwnd : THandle;
  r : TRect;
  scrDC : HDC;
  flFind : boolean;
  fFind,PixelsPerX,PixelsPerY : integer;
  mf : TMetaFile;
  mfc : TMetaFileCanvas;
{$IFNDEF PRINT_RTF_AS_METAFILE}
  Flw,Ftw,Frw,Fbw : integer;
{$ENDIF}
  RealRect : PRect;
begin
if pdi.IsPrinter then
  RealRect := @Self.PrinterRealRect
else
  RealRect := @Self.RealRect;
{$IFNDEF PRINT_RTF_AS_METAFILE}
if lBorder.Show then Flw := Max(1,muldiv(lBorder.Width,pdi.xmul,pdi.xdiv))
                else Flw := 0;
if tBorder.Show then Ftw := Max(1,muldiv(tBorder.Width,pdi.ymul,pdi.ydiv))
                else Ftw := 0;
if rBorder.Show then Frw := Max(1,muldiv(rBorder.Width,pdi.xmul,pdi.xdiv))
                else Frw := 0;
if bBorder.Show then Fbw := Max(1,muldiv(bBorder.Width,pdi.ymul,pdi.ydiv))
                else Fbw := 0;

if pdi.IsPrinter then
  begin
    //  
    DrawObjBorders(DC,RealRect,lBorder,tBorder,rBorder,bBorder,Flw,Ftw,Frw,Fbw);

    //  Rich
    r:=Rect(RealRect.Left+Flw+muldiv(oLeft,pdi.xmul,pdi.xdiv),
            RealRect.Top+Ftw+muldiv(oTop,pdi.ymul,pdi.ydiv),
            RealRect.Right-Frw-muldiv(oRight,pdi.xmul,pdi.xdiv),
            RealRect.Bottom-Fbw-muldiv(oBottom,pdi.ymul,pdi.ydiv));

    //
    PixelsPerX := GetDeviceCaps(DC,LOGPIXELSX);
    PixelsPerY := GetDeviceCaps(DC,LOGPIXELSY);

    ZeroMemory(@fr,sizeof(fr));
    fr.hdc := DC;
    fr.hdcTarget := DC;
    fr.chrg.cpMin := 0;
    fr.chrg.cpMax := -1;

    if WordWrap then
      fr.rc := Rect(MulDiv(r.Left,1440,PixelsPerX),
                    MulDiv(r.Top,1440,PixelsPerY),
                    MulDiv(r.Right,1440,PixelsPerX),
                    MulDiv(MaxRichTextHeight,1440,PixelsPerY))
    else
      fr.rc := Rect(MulDiv(r.Left,1440,PixelsPerX),
                    MulDiv(r.Top,1440,PixelsPerY),
                    MulDiv(MaxRichTextWidth,1440,PixelsPerX),
                    MulDiv(MaxRichTextHeight,1440,PixelsPerY));
    fr.rcPage := fr.rc;

    SendMessage(FhwndRich,EM_FORMATRANGE,1,integer(@fr));
    SendMessage(FhwndRich,EM_FORMATRANGE,0,0);
  end
else
{$ENDIF}
  begin
    //  
    //      Metafile    
    scrDC := GetDC(0);
    PixelsPerX := GetDeviceCaps(scrDC,LOGPIXELSX);
    PixelsPerY := GetDeviceCaps(scrDC,LOGPIXELSY);
    ReleaseDC(0,scrDC);
    r := Rect(0,0,GeneratedRect.Right-GeneratedRect.Left,GeneratedRect.Bottom-GeneratedRect.Top);
    mf := TMetaFile.Create;
    mfc := nil;
    try
      mf.Width := GeneratedRect.Right-GeneratedRect.Left;
      mf.Height := GeneratedRect.Bottom-GeneratedRect.Top;
      mfc := TMetaFileCanvas.Create(mf,0);

      //  
      DrawObjBorders(mfc.Handle,r,lBorder,tBorder,rBorder,bBorder,lBorder.Width,tBorder.Width,rBorder.Width,bBorder.Width);
      hwnd := FhwndRich;
      if not pdi.IsPrinter then
        begin
          case pdi.ppdi.DrawMode of
            dmFindFirst :
              begin
                if FhwndRichFind=0 then
                  begin
                    FhwndRichFind := CreateWindowEx(0, 'RICHEDIT', '',
                                                    WS_HSCROLL or WS_VSCROLL or ES_NOHIDESEL or ES_AUTOVSCROLL or ES_MULTILINE or ES_SAVESEL,
                                                    0, 0, 100, 100,
                                                    0, 0, hInstance, nil);
                  end;
                CopyRichText(FhwndRich,FhwndRichFind);
                //  
                if pdi.ppdi.CaseSensitive then
                  fFind := FR_MATCHCASE
                else
                  fFind := 0;
                ft.lpstrText := PChar(pdi.ppdi.FindText);
                ft.chrg.cpMin := 0;
                ft.chrg.cpMax := -1;
                flFind := false;
                ZeroMemory(@cf2,sizeof(cf2));
                cf2.cbSize := sizeof(cf2);
                cf2.crTextColor := Rich2FindTextTextColor;
                cf2.crBackColor := Rich2FindTextBackColor;
                cf2.dwMask := CFM_COLOR or CFM_BACKCOLOR;
                ZeroMemory(@cf,sizeof(cf));
                cf.cbSize := sizeof(cf);
                cf.crTextColor := RichFindTextTextColor;
                cf.dwMask := CFM_COLOR;
                while true do
                  begin
                    p := SendMessage(FhwndRichFind,EM_FINDTEXTEX,fFind,integer(@ft));
                    if p=-1 then break;
                    flFind := true;
                    SendMessage(FhwndRichFind,EM_EXSETSEL,0,integer(@ft.chrgText));
                    if SendMessage(FhwndRichFind,EM_SETCHARFORMAT,SCF_SELECTION,integer(@cf2))=0 then
                      SendMessage(FhwndRichFind,EM_SETCHARFORMAT,SCF_SELECTION,integer(@cf));
                    ft.chrg.cpMin := ft.chrgText.cpMax+1;
                  end;
                if flFind then
                  pdi^.ppdi^.FindList.Add(TprFindText.CreateFT(RealRect^));
                hwnd := FhwndRichFind;
              end;
            dmFind :
              hwnd := FhwndRichFind;
          end;
        end;

      //      Rich
      r:=Rect(r.Left+GetBW(lBorder)+oLeft,
              r.Top+GetBW(tBorder)+oTop,
              r.Right-GetBW(rBorder)-oRight,
              r.Bottom-GetBW(tBorder)-oBottom);

      ZeroMemory(@fr,sizeof(fr));
      fr.hdc := mfc.Handle;
      fr.hdcTarget := mfc.Handle;
      fr.chrg.cpMin := 0;
      fr.chrg.cpMax := -1;

      if WordWrap then
        fr.rc := Rect(MulDiv(r.Left,1440,PixelsPerX),
                      MulDiv(r.Top,1440,PixelsPerY),
                      MulDiv(r.Right,1440,PixelsPerX),
                      MulDiv(MaxRichTextHeight,1440,PixelsPerY))
      else
        fr.rc := Rect(MulDiv(r.Left,1440,PixelsPerX),
                      MulDiv(r.Top,1440,PixelsPerY),
                      MulDiv(MaxRichTextWidth,1440,PixelsPerX),
                      MulDiv(MaxRichTextHeight,1440,PixelsPerY));
      fr.rcPage := fr.rc;

      Rgn := CreateRectRgnIndirect(r);
      SelectClipRgn(mfc.Handle,Rgn);
      SendMessage(hwnd,EM_FORMATRANGE,1,integer(@fr));
      SendMessage(hwnd,EM_FORMATRANGE,0,0);
      SelectClipRgn(mfc.Handle,0);
      DeleteObject(Rgn);
      mfc.Free;
      mfc := nil;
      PlayEnhMetaFile(DC,mf.Handle,RealRect^);
    finally
      if mfc<>nil then
        mfc.Free;
      mf.Free;
    end;
  end;
end;

//
//    
//
procedure TprRichObjRecVersion.ExportToXLS;
var
  es : _EDITSTREAM;
  rSI : rRTFStreamIn;
begin
//     
rSI.Text := '';
ZeroMemory(@es,sizeof(es));
es.dwCookie := integer(@rSI);
es.pfnCallback := @FormatRichTextWriteCallback;
SendMessage(FhwndRich,EM_STREAMOUT,SF_TEXT,integer(@es));

SetXLSBorders(V,lBorder,tBorder,rBorder,bBorder);
V.Value := StringReplace(rSI.Text,#13,'',[rfReplaceAll]);
V.VerticalAlignment := xlVAlignTop;
V.HorizontalAlignment := xlHAlignLeft;
V.WrapText := true;
end;

procedure TprRichObjRecVersion.InitInDesigner;
  procedure InitFrameLine(fl : TprFrameLine);
  begin
  fl.Show := true;
  fl.Width := 1;
  fl.Color := clBlack;
  fl.Style := psSolid;
  end;
begin
InitFrameLine(lBorder);
InitFrameLine(rBorder);
InitFrameLine(tBorder);
InitFrameLine(bBorder);
end;

//////////////////////
//
// TprRichObjRec
//
//////////////////////
function TprRichObjRec.CreateCopy;
begin
Result := TprRichObjRec.Create(Self.Page,Self.Obj);
Result.Assign(Self);
end;

function TprRichObjRec.CreateVersions;
begin
Result := TprObjRecVersions.Create(TprRichObjRecVersion);
end;

procedure TprRichObjRec.SecondPass;
var
  i : integer;
begin
inherited;
for i:=0 to Versions.Count-1 do
  with TprRichObjRecVersion(Versions[i]) do
    if SecondPassNeeded then
      FormatRichText(Obj.Report,FhwndRich,DeleteEmptyLines,DeleteEmptyLinesAtEnd);
end;

procedure TprRichObjRec.PlaceOnEndPage;
var
  v : TprRichObjRecVersion;
begin
if not Versions[CurVersion].Visible then exit;

v := TprRichObjRecVersion.Create(nil);
v.Assign(TprRichObjRecVersion(Versions[CurVersion]));
v.PreviewUserData := PreviewUserData;
PreviewUserData := nil;
v.GeneratedRect := r;

TprEndPage(Page).vl.Add(v);
end;

//////////////////////////////
//
// TprRichObj
//
//////////////////////////////
function TprRichObj.AllowInplaceEdit;
begin
Result := false;
end;

procedure TprRichObj.InplaceEdit;
begin
end;

procedure TprRichObj.SaveInplaceEdit;
begin
end;

procedure TprRichObj.InitdRec;
begin
FdRec := TprRichObjRec.Create(nil,Self);
TprExObjRecVersion(dRec.Versions.Add).InitInDesigner;
end;

function TprRichObj.GetDesc;
begin
Result := inherited GetDesc;
end;

procedure TprRichObj.DrawDesign;
var
  v : TprRichObjRecVersion;
  r : TRect;
  fr : _FORMATRANGE;
  nbr : HBRUSH;
  OldRgn,rgn : HRGN;
  PixelsPerX,PixelsPerY : integer;

begin
v := TprRichObjRecVersion(dRec.Versions[dRec.DefVersion]);
r := PDI.dPageRect;

//  
nbr := CreateSolidBrush(clWhite);
FillRect(DC,Rect(r.Left+GetBW(v.lBorder),
                 r.Top+GetBW(v.tBorder),
                 r.Right-GetBW(v.rBorder),
                 r.Bottom-GetBW(v.bBorder)),nbr);
DeleteObject(nbr);

DrawDesignObjBorders(DC,r,v.lBorder,v.tBorder,v.rBorder,v.bBorder);

//   Rich 
r:=Rect(r.Left+GetBW(v.lBorder)+oLeft,
        r.Top+GetBW(v.tBorder)+oTop,
        r.Right-GetBW(v.rBorder)-oRight,
        r.Bottom-GetBW(v.bBorder)-oBottom);

// r -     (  )
PixelsPerX := GetDeviceCaps(DC,LOGPIXELSX);
PixelsPerY := GetDeviceCaps(DC,LOGPIXELSY);
ZeroMemory(@fr,sizeof(fr));
fr.hdc := DC;
fr.hdcTarget := DC;
fr.chrg.cpMin := -1;
fr.chrg.cpMax := -1;

if v.WordWrap then
  begin
    fr.rc := Rect(MulDiv(r.Left,1440,PixelsPerX),
                  MulDiv(r.Top,1440,PixelsPerY),
                  MulDiv(r.Right,1440,PixelsPerX),
                  MulDiv(MaxRichTextHeight,1440,PixelsPerY));
  end
else
  begin
    fr.rc := Rect(MulDiv(r.Left,1440,PixelsPerX),
                  MulDiv(r.Top,1440,PixelsPerY),
                  MulDiv(MaxRichTextWidth,1440,PixelsPerX),
                  MulDiv(MaxRichTextHeight,1440,PixelsPerY));
  end;
fr.rcPage := fr.rc;

OldRgn := CreateRectRgnIndirect(r);
GetClipRgn(DC,OldRgn);
Rgn := CreateRectRgnIndirect(r);
SelectClipRgn(DC,Rgn);
SendMessage(v.FhwndRich,EM_FORMATRANGE,1,integer(@fr));
SendMessage(v.FhwndRich,EM_FORMATRANGE,0,0);
DeleteObject(Rgn);
SelectClipRgn(DC,OldRgn);
DeleteObject(OldRgn);
end;


procedure TprRichObj.FirstPass;
var
  v : TprRichObjRecVersion;
  fr : _FORMATRANGE;
  DC : HDC;
  ManuallyProcessed : boolean;
  i,PixelsPerX,PixelsPerY : integer;
begin
DC:=HDC(Report.ObjectCalcSizesDevice);

if aRec=nil then
  aRec:=TprRichObjRec.Create(nil,Self);
aRec.Assign(dRec);

//   
aRec.FirstPassCalcCurVersion;

//   (OnFirstPassObject)
Band.Report.DoOnFirstPassObject(Self,ManuallyProcessed);

if not ManuallyProcessed then
  for i:=0 to aRec.Versions.Count-1 do
    with TprRichObjRecVersion(aRec.Versions[i]) do
      SecondPassNeeded := not FormatRichText(Report,FhwndRich,DeleteEmptyLines,DeleteEmptyLinesAtEnd);

v := TprRichObjRecVersion(aRec.Versions[aRec.CurVersion]);
aRec.DX := dRec.pRect.Right-dRec.pRect.Left;
aRec.DY := dRec.pRect.Bottom-dRec.pRect.Top;
if v.CanResizeY then
  begin
    PixelsPerX := GetDeviceCaps(DC,LOGPIXELSX);
    PixelsPerY := GetDeviceCaps(DC,LOGPIXELSY);
    ZeroMemory(@fr,sizeof(fr));
    fr.hdc := DC;
    fr.hdcTarget := DC;
    fr.chrg.cpMin := -1;
    fr.chrg.cpMax := -1;
    if v.WordWrap then
      fr.rc.Right := MulDiv(aRec.DX-GetBW(v.rBorder)-GetBW(v.lBorder),1440,PixelsPerX)
    else
      fr.rc.Right := MulDiv(MaxRichTextWidth,1440,PixelsPerX);
    fr.rc.Bottom := MulDiv(MaxRichTextHeight,1440,PixelsPerY);
    fr.rcPage := fr.rc;
    SendMessage(v.FhwndRich,EM_FORMATRANGE,0,integer(@fr));

    aRec.DY := MulDiv(fr.rc.Bottom,PixelsPerY,1440)+GetBW(v.tBorder)+GetBW(v.bBorder)+oTop+oBottom;
  end;
aRec.pRect:=Rect(-1,-1,-1,-1);
inherited;
end;








/////////////////////////
//
// TprImageObjRecVersion
//
/////////////////////////
constructor TprImageObjRecVersion.Create;
begin
inherited;
FPicture := TPicture.Create;
FDrawMode := prdmCenter;
end;

destructor TprImageObjRecVersion.Destroy;
begin
FPicture.Free;
inherited;
end;

procedure TprImageObjRecVersion.Assign;
begin
with Source as TprImageObjRecVersion do
  begin
    Self.FImageSource := ImageSource;
    Self.FFileName := FileName;
    Self.FDBFieldName := DBFieldName;
    Self.FDrawMode := DrawMode;
    Self.FFillColor := FillColor;
    Self.FPicture.Assign(Picture);
  end;
inherited;
end;

procedure TprImageObjRecVersion.GetPicture;
var
  f : TField;
  DataSet   : TComponent;
  FieldName : string;
begin
p:=nil;
pCreated:=false;

case ImageSource of
  isPicture:
    p:=Picture;
  isFileName:
    begin
      p:=TPicture.Create;
      pCreated:=true;
      p.LoadFromFile(FileName);
    end;
  isDBFieldName:
    begin
      Report.TranslateObjectName(DBFieldName,DataSet,FieldName);
      if DataSet is TDataSet then
        begin
          f:=TDataSet(DataSet).FindField(FieldName);
          if (f<>nil) and f.IsBlob then
            begin
              p:=TPicture.Create;
              pCreated:=true;
              p.Assign(f);
            end;
        end;
    end;
end;
end;

procedure TprImageObjRecVersion.Draw;
var
  r : TRect;
  nbr : HBRUSH;
  spn : HPEN;
  sbr : HBRUSH;
  sfn : HFONT;
  Canvas : TCanvas;
  pw,ph,w,h,kmul,kdiv : integer;
  OldRgn,Rgn : HRGN;
  RealRect : PRect;
begin
if pdi.IsPrinter then
  RealRect := @Self.PrinterRealRect
else
  RealRect := @Self.RealRect;
SaveDCObjects(DC,spn,sbr,sfn);
Canvas := TCanvas.Create;
Canvas.Handle := DC;

try
  if (FillColor<>clNone) and (FillColor<>clWhite) then
    begin
      nbr := CreateSolidBrush(FillColor);
      FillRect(Canvas.Handle,RealRect^,nbr);
      DeleteObject(nbr);
    end;

  pw := muldiv(Picture.Width,pdi.xmul,pdi.xdiv);
  ph := muldiv(Picture.Height,pdi.ymul,pdi.ydiv);
  //  
  case DrawMode of
    prdmCenter:
      begin
        //  
        OldRgn := 0;
        if not pdi.IsPrinter then
          begin
            OldRgn := CreateRectRgn(0,0,1,1);
            GetClipRgn(DC,OldRgn);
          end;
        if pdi.IsPrinter then
          Rgn := CreateRectRgn(RealRect.Left-pdi.hsb,
                               RealRect.Top-pdi.vsb,
                               RealRect.Right-pdi.hsb,
                               RealRect.Bottom-pdi.vsb)
        else
          Rgn := CreateRectRgn(RealRect.Left+pdi.bRect.Left-pdi.hsb,
                               RealRect.Top+pdi.bRect.Top-pdi.vsb,
                               RealRect.Right+pdi.bRect.Left-pdi.hsb,
                               RealRect.Bottom+pdi.bRect.Top-pdi.vsb);
        SelectClipRgn(Canvas.Handle,Rgn);
        r.Left := RealRect.Left+(RealRect.Right-RealRect.Left-pw) div 2;
        r.Top := RealRect.Top+(RealRect.Bottom-RealRect.Top-ph) div 2;
        r.Right := r.Left+pw;
        r.Bottom := r.Top+ph;
        Canvas.StretchDraw(r,Picture.Graphic);
        if not pdi.isprinter then
          begin
            SelectClipRgn(DC,OldRgn);
            DeleteObject(OldRgn);
          end
        else
          SelectClipRgn(DC,0);
        DeleteObject(Rgn);
      end;
    prdmStretch:
      begin
        //    
        Canvas.StretchDraw(RealRect^,Picture.Graphic);
      end;
    prdmStretchProp:
      begin
        if (RealRect.Right-RealRect.Left)/pw<(RealRect.Bottom-RealRect.Top)/ph then
          begin
            kmul := RealRect.Right-RealRect.Left;
            kdiv := pw;
          end
        else
          begin
            kmul := RealRect.Bottom-RealRect.Top;
            kdiv := ph;
          end;
        w := muldiv(pw,kmul,kdiv);
        h := muldiv(ph,kmul,kdiv);
        r.Left := RealRect.Left+((RealRect.Right-RealRect.Left-w) div 2);
        r.Top := RealRect.Top+((RealRect.Bottom-RealRect.Top-h) div 2);
        r.Right := r.Left+w;
        r.Bottom := r.Top+h;
        Canvas.StretchDraw(r,Picture.Graphic);
      end;
    prdmResizeHeightWidth:
      begin
        Canvas.StretchDraw(RealRect^,Picture.Graphic);
      end;
  end;
finally
  Canvas.Free;
  RestoreDCObjects(DC,spn,sbr,sfn);
end;
end;

procedure TprImageObjRecVersion.ExportToXLS;
var
  s : string;
  w,h,kmul,kdiv : integer;
  TempDir : array [0..255] of char;
  TempFile : array [0..255] of char;
begin
if GetTempPath(sizeof(TempDir),TempDir)=0 then exit;
if GetTempFileName(TempDir,'pr',0,TempFile)=0 then exit;
s := StrPas(TempFile);
try
  Picture.SaveToFile(s);
  case DrawMode of
    prdmCenter:
      V.Worksheet.Shapes.AddPicture(s,false,true,V.Left,V.Top,V.Width,V.Height);
    prdmStretch,prdmResizeHeightWidth:
      V.Worksheet.Shapes.AddPicture(s,false,true,V.Left,V.Top,V.Width,V.Height);
    prdmStretchProp:
      begin
        if V.Width/Picture.Width<V.Height/Picture.Height then
          begin
            kmul := V.Width;
            kdiv := Picture.Width;
          end
        else
          begin
            kmul := V.Height;
            kdiv := Picture.Height;
          end;
        w := muldiv(V.Width,kmul,kdiv);
        h := muldiv(V.Height,kmul,kdiv);
        V.Worksheet.Shapes.AddPicture(s,false,true,V.Left+(V.Width-w) div 2,V.Top+(V.Height-h) div 2,w,h);
      end;
  end;
finally
  DeleteFile(PChar(s));
end;
end;

procedure TprImageObjRecVersion.InitInDesigner;
begin
FillColor := clNone;
end;

//////////////////////
//
// TprImageObjRec
//
//////////////////////
function TprImageObjRec.CreateCopy;
begin
Result:=TprImageObjRec.Create(Self.Page,Self.Obj);
Result.Assign(Self);
end;

function TprImageObjRec.CreateVersions;
begin
Result:=TprObjRecVersions.Create(TprImageObjRecVersion);
end;

procedure TprImageObjRec.SecondPass;
begin
end;

procedure TprImageObjRec.PlaceOnEndPage;
var
  v : TprImageObjRecVersion;
begin
if not Versions[CurVersion].Visible then exit;

v:=TprImageObjRecVersion.Create(nil);
v.Assign(TprImageObjRecVersion(Versions[CurVersion]));
v.PreviewUserData := PreviewUserData;
PreviewUserData := nil;
v.GeneratedRect:=r;

TprEndPage(Page).vl.Add(v);
end;

//////////////////////////////
//
// TprImageObj
//
//////////////////////////////
procedure TprImageObj.InitdRec;
begin
FdRec := TprImageObjRec.Create(nil,Self);
TprExObjRecVersion(dRec.Versions.Add).InitInDesigner;
end;

function TprImageObj.GetDesc;
var
  v : TprImageObjRecVersion;
begin
v:=TprImageObjRecVersion(dRec.Versions[dRec.DefVersion]);
case v.ImageSource of
  isFileName   : Result:=Format(prLoadStr(sImageObjDescFileMask),[v.FileName]);
  isDBFieldName: Result:=Format(prLoadStr(sImageObjDescDBFieldMask),[v.DBFieldName]);
  else           Result:=inherited GetDesc;
end;
end;

procedure TprImageObj.DrawDesign;
var
  v : TprImageObjRecVersion;
  r : TRect;
  p : TPicture;
  s1 : string;
  w,h,kmul,kdiv : integer;
  nbr : HBRUSH;
  Canvas : TCanvas;
  nfn,ofn : HFONT;
  Rgn1,OldRgn : HRGN;

  spn : HPEN;
  sbr : HBRUSH;
  sfn : HFONT;
begin
v:=TprImageObjRecVersion(dRec.Versions[dRec.DefVersion]);
r:=PDI.dPageRect;

if v.FillColor=clNone then
  nbr:=CreateSolidBrush(clWhite)
else
  nbr:=CreateSolidBrush(v.FillColor);
FillRect(DC,
         Rect(r.Left,
              r.Top,
              r.Right,
              r.Bottom),
         nbr);
DeleteObject(nbr);
DrawAngleRect(DC,r);

//   (, ,  )
if v.ImageSource=isPicture then
  begin
    p:=v.Picture;

    if (p<>nil) and (p.Graphic<>nil) then
      begin
        SaveDCObjects(DC,spn,sbr,sfn);
        Canvas       :=TCanvas.Create;
        Canvas.Handle:=DC;
        try
          case v.DrawMode of
            prdmCenter:
              begin
                OldRgn:=0;
                GetClipRgn(DC,OldRgn);
                Rgn1  :=CreateRectRgnIndirect(r);
                CombineRgn(Rgn1,Rgn1,OldRgn,RGN_AND);
                SelectClipRgn(DC,Rgn1);
                try
                  Canvas.Draw(r.Left+(r.Right-r.Left-p.Width) div 2,
                              r.Top+(r.Bottom-r.Top-p.Height) div 2,
                              p.Graphic);
                finally
                  SelectClipRgn(DC,OldRgn);
                  DeleteObject(Rgn1);
                  DeleteObject(OldRgn);
                end;
              end;
            prdmStretch:
              begin
                //    
                Canvas.StretchDraw(r,p.Graphic);
              end;
            prdmStretchProp:
              begin
                if (r.Right-r.Left)/p.Width<(r.Bottom-r.Top)/p.Height then
                  begin
                    kmul := r.Right-r.Left;
                    kdiv := p.Width;
                  end
                else
                  begin
                    kmul := r.Bottom-r.Top;
                    kdiv := p.Height;
                  end;
                w       :=muldiv(p.Width,kmul,kdiv);
                h       :=muldiv(p.Height,kmul,kdiv);
                r.Left  :=r.Left+((r.Right-r.Left-w) div 2);
                r.Top   :=r.Top+((r.Bottom-r.Top-h) div 2);
                r.Right :=r.Left+w;
                r.Bottom:=r.Top+h;
                Canvas.StretchDraw(r,p.Graphic);
              end;
            prdmResizeHeightWidth:
              begin
                Canvas.Draw(r.Left,
                            r.Top,
                            p.Graphic);
              end;
          end;
        finally
          Canvas.Free;
          RestoreDCObjects(DC,spn,sbr,sfn);
        end;
      end;
  end
else
  begin
    if v.ImageSource=isFileName then begin s1 := Format(prLoadStr(sImageObjDescFileMask),[v.FileName]) end
                                else begin s1 := Format(prLoadStr(sImageObjDescDBFieldMask),[v.DBFieldName]) end;

    nfn:=CreateDefFont(DC,8,clBlack);
    ofn:=SelectObject(DC,nfn);

    SetBkMode(DC,TRANSPARENT);
    DrawText(DC,PChar(s1),Length(s1),r,DT_LEFT);
    SetBkMode(DC,OPAQUE);

    SelectObject(DC,ofn);
    DeleteObject(nfn);
  end;
end;

procedure TprImageObj.FirstPass;
var
  v : TprImageObjRecVersion;
  p : TPicture;
  i : integer;
  NeedFree : boolean;
  ManuallyProcessed : boolean;
begin
if aRec=nil then
  aRec:=TprImageObjRec.Create(nil,Self);
aRec.Assign(dRec);

//   
aRec.FirstPassCalcCurVersion;

//   (OnFirstPassObject)
Band.Report.DoOnFirstPassObject(Self,ManuallyProcessed);

if not ManuallyProcessed then
  //     ,
  //     
  for i:=0 to aRec.Versions.Count-1 do
    with TprImageObjRecVersion(aRec.Versions[i]) do
      begin
        GetPicture(Band.Report,p,NeedFree);
        try
          if (p<>nil) and (p<>Picture) then
            Picture.Assign(p);
          ImageSource:=isPicture;
        finally
          if NeedFree then
            p.Free;
        end;
      end;

v      :=TprImageObjRecVersion(aRec.Versions[aRec.CurVersion]);
aRec.DX:=dRec.pRect.Right-dRec.pRect.Left;
aRec.DY:=dRec.pRect.Bottom-dRec.pRect.Top;

// 
if v.DrawMode=prdmResizeHeightWidth then
  begin
    if (v.Picture<>nil) and (v.Picture.Width<>0) and (v.Picture.Height<>0) then
      begin
        aRec.DX:=v.Picture.Width;
        aRec.DY:=v.Picture.Height;
      end;
  end;

aRec.pRect:=Rect(-1,-1,-1,-1);

inherited;
end;

//
// Band   -  
// DC     -   
// R      - ,    ,   
//           
//
procedure TprHBand_DrawDesign(Band : TprCustomHBand; DC : HDC);
var
  s : string;
  sz : tagSize;
  npn,opn : HPEN;
  nfn,ofn : HFONT;
  i,ColWidth : integer;
begin
npn :=CreatePen(PS_DOT,1,clBlue);
opn :=SelectObject(DC,npn);

nfn :=CreateDefFont(DC,8,clBlack);
ofn :=SelectObject(DC,nfn);

try
  DrawRect(DC,Band.dPageRect);

  s:=Band.GetDrawDesignCaption;
  GetTextExtentPoint32(DC,PChar(s),Length(s),sz);
  ExtTextOut(DC,
             Band.dPageRect.Left+2,
             Band.dPageRect.Bottom-sz.cy-2,
             ETO_CLIPPED,
             @Band.dPageRect,
             PChar(s),
             Length(s),
             nil);

  //  
  if Band.GetUseColumns then
    begin
      ColWidth:=(Band.dPageRect.Right-Band.dPageRect.Left) div Band.GetColCount;
      for i:=1 to Band.GetColCount-1 do
        begin
          MoveToEx(DC,Band.dPageRect.Left+ColWidth*i,Band.dPageRect.Top,nil);
          LineTo(DC,Band.dPageRect.Left+ColWidth*i,Band.dPageRect.Bottom);
        end;
  end;
finally
  SelectObject(DC,opn);
  SelectObject(DC,ofn);
  DeleteObject(npn);
  DeleteObject(nfn);
end;
end;

//////////////////////////
//
// TprHTitleBand
//
//////////////////////////
procedure TprHTitleBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

/////////////////////////
//
// TprHSummaryBand
//
/////////////////////////
procedure TprHSummaryBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

//////////////////////////
//
// TprHPageHeaderBand
//
//////////////////////////
procedure TprHPageHeaderBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

/////////////////////////////
//
// TprHPageFooterBand
//
/////////////////////////////
procedure TprHPageFooterBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

//////////////////////////
//
// TprHDetailBand
//
//////////////////////////
procedure TprHDetailBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

////////////////////////////////
//
// TprHDetailHeaderBand
//
////////////////////////////////
procedure TprHDetailHeaderBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

////////////////////////////////
//
// TprHDetailFooterBand
//
////////////////////////////////
procedure TprHDetailFooterBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

////////////////////////////////////
//
// TprHGroupHeaderBand
//
////////////////////////////////////
procedure TprHGroupHeaderBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;

////////////////////////////////////
//
// TprHGroupFooterBand
//
////////////////////////////////////
procedure TprHGroupFooterBand.DrawDesign;
begin
TprHBand_DrawDesign(Self,DC);
end;





////////////////////////////////
//
//  BANDS
//
////////////////////////////////



//
// DC -   
// R  - ,    ,   
//       
//
procedure TprVBand_DrawDesign(Band : TprBand; DC : HDC);
var
  s : string;
  sz : tagSize;
  npn,opn : HPEN;
  nfn,ofn : HFONT;
begin
npn :=CreatePen(PS_DOT,1,clRed);
opn :=SelectObject(DC,npn);

nfn :=Create90DefFont(DC,8,clBlack);
ofn :=SelectObject(DC,nfn);

try
  DrawRect(DC,Band.PDI.dPageRect);

  s:=Band.GetDrawDesignCaption;
  GetTextExtentPoint32(DC,PChar(s),Length(s),sz);
  ExtTextOut(DC,
             Band.dPageRect.Right-sz.cy-2,
             Band.dPageRect.Bottom-2,
             ETO_CLIPPED,
             @Band.dPageRect,
             PChar(s),
             Length(s),
             nil);
finally
  SelectObject(DC,opn);
  SelectObject(DC,ofn);
  DeleteObject(npn);
  DeleteObject(nfn);
end;
end;

//////////////////////////
//
// TprVTitleBand
//
//////////////////////////
procedure TprVTitleBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;

/////////////////////////
//
// TprVSummaryBand
//
/////////////////////////
procedure TprVSummaryBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;

//////////////////////////
//
// TprVPageHeaderBand
//
//////////////////////////
procedure TprVPageHeaderBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;

/////////////////////////////
//
// TprVPageFooterBand
//
/////////////////////////////
procedure TprVPageFooterBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;

//////////////////////////
//
// TprVDetailBand
//
//////////////////////////
procedure TprVDetailBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;



////////////////////////////////
//
// TprVDetailHeaderBand
//
////////////////////////////////
procedure TprVDetailHeaderBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;

////////////////////////////////
//
// TprVDetailFooterBand
//
////////////////////////////////
procedure TprVDetailFooterBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;

////////////////////////////////////
//
// TprVGroupHeaderBand
//
////////////////////////////////////
procedure TprVGroupHeaderBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;

////////////////////////////////////
//
// TprVGroupFooterBand
//
////////////////////////////////////
procedure TprVGroupFooterBand.DrawDesign;
begin
TprVBand_DrawDesign(Self,DC);
end;


















//////////////////////////
//
// TprEndPage
//
//////////////////////////
constructor TprEndPage.CreateEmpty;
begin
inherited;
vl := TList.Create;
end;

constructor TprEndPage.Create;
begin
inherited;

Width       :=TprPage(_Page).pInfo.sWidth;
Height      :=TprPage(_Page).pInfo.sHeight;
PaperSize   :=TprPage(_Page).PaperSize;
Orientation :=TprPage(_Page).Orientation;
pInfo       :=TprPage(_Page).pInfo;
Rect        :=TprPage(_Page).pInfo.saRect;

lMargin     :=TprPage(_Page).lMargin;
tMargin     :=TprPage(_Page).tMargin;
rMargin     :=TprPage(_Page).rMargin;
bMargin     :=TprPage(_Page).bMargin;
end;

destructor TprEndPage.Destroy;
begin
ClearVL;
vl.Free;
inherited;
end;

procedure TprEndPage.ClearVL;
begin
while vl.Count>0 do
  begin
    TprExObjRecVersion(vl[0]).Free;
    vl.Delete(0);
  end;
end;

function TprEndPage.GetPageRect;
begin
Result := pInfo.saRect;
end;

procedure TprEndPage.ThirdPass;
var
  i : integer;
begin
for i:=0 to oRecsCount-1 do
  begin
    oRec[i].SecondPass;
    oRec[i].PlaceOnEndPage(Report.ObjectCalcSizesDevice,oRec[i].pRect);
  end;
end;

procedure SaveObjectsVersionsToStream;
var
  l : TList;
  w : TWriter;
  i,j : integer;
begin
l := TList.Create;
try
  for i:=0 to LV.Count-1 do
    begin
      //      
      j := 0;
      while (j<l.Count) and (not(TObject(LV[i]) is TCollection(l[j]).ItemClass)) do Inc(j);
      if j>=l.Count then
        j := l.Add(TCollection.Create(TCollectionItemClass(TObject(LV[i]).ClassType)));
      //    
      TCollection(l[j]).Add.Assign(LV[i]);
    end;

  i := l.Count;
  Stream.Write(i,4);
  for i:=0 to l.Count-1 do
    begin
      WriteString(Stream,TCollection(l[i]).ItemClass.ClassName);
      w := TWriter.Create(Stream,1024);
      try
        w.WriteCollection(TCollection(l[i]));
      finally
        w.Free;
      end;
    end;
finally
  for i:=0 to l.Count-1 do
    TCollection(l[i]).Free;
  l.Free;
end;
end;

procedure TprEndPage.Save;
begin
Stream.Write(Width,4);
Stream.Write(Height,4);
Stream.Write(PaperSize,4);
Stream.Write(Orientation,sizeof(Orientation));
Stream.Write(lMargin,4);
Stream.Write(rMargin,4);
Stream.Write(tMargin,4);
Stream.Write(bMargin,4);

Stream.Write(pInfo.sWidth,4);
Stream.Write(pInfo.sHeight,4);
Stream.Write(pInfo.pWidth,4);
Stream.Write(pInfo.pHeight,4);
WriteRect(Stream,pInfo.PrnSRect);
WriteRect(Stream,pInfo.PrnPRect);
WriteRect(Stream,pInfo.saRect);
WriteRect(Stream,pInfo.paRect);

SaveObjectsVersionsToStream(Stream,VL);
end;

procedure LoadObjectsVersionsFromStream;
var
  c : TCollection;
  r : TReader;
  ci : TCollectionItem;
  i,n,j : integer;
  ciClass : string;
begin
Stream.Read(n,4);
for i:=0 to n-1 do
  begin
    ciClass := ReadString(Stream);
    c := TCollection.Create(TCollectionItemClass(GetClass(ciClass)));
    try
      r := TReader.Create(Stream,1024);
      try
        r.ReadValue;
        r.ReadCollection(c);
      finally
        r.Free;
      end;

      for j:=0 to c.Count-1 do
        begin
          ci:=TCollectionItemClass(GetClass(ciClass)).Create(nil);
          ci.Assign(c.Items[j]);
          LV.Add(ci);
        end;
    finally
      c.Free;
    end;
  end;
end;

procedure TprEndPage.Load;
var
  i : integer;
begin
Stream.Read(Width,4);
Stream.Read(Height,4);
Stream.Read(PaperSize,4);
Stream.Read(Orientation,sizeof(Orientation));
Stream.Read(lMargin,4);
Stream.Read(rMargin,4);
Stream.Read(tMargin,4);
Stream.Read(bMargin,4);

Stream.Read(pInfo.sWidth,4);
Stream.Read(pInfo.sHeight,4);
Stream.Read(pInfo.pWidth,4);
Stream.Read(pInfo.pHeight,4);
ReadRect(Stream,pInfo.PrnSRect);
ReadRect(Stream,pInfo.PrnPRect);
ReadRect(Stream,pInfo.saRect);
ReadRect(Stream,pInfo.paRect);

pInfo.sWidth := MulDiv(pInfo.sWidth,TprReport(Report).prPrinter.scrPixelsPerX,TprReport(Report).prPrinter.CreatedscrPixelsPerX);
pInfo.sHeight := MulDiv(pInfo.sHeight,TprReport(Report).prPrinter.scrPixelsPerY,TprReport(Report).prPrinter.CreatedscrPixelsPerY);

LoadObjectsVersionsFromStream(Stream,VL);
for i:=0 to VL.Count-1 do
  TprExObjRecVersion(VL[i]).Scale(TprReport(Report).prPrinter.scrPixelsPerX,
                                  TprReport(Report).prPrinter.CreatedscrPixelsPerX,
                                  TprReport(Report).prPrinter.scrPixelsPerY,
                                  TprReport(Report).prPrinter.CreatedscrPixelsPerY);
end;

procedure TprEndPage.Cache;
var
  i : integer;
  pdi : PPrDrawInfo;
begin
if IsPrinter then pdi := @rpdi
             else pdi := @rdi;
pdi.IsPrinter := IsPrinter;
pdi.xmul := BoundsRect.Right-BoundsRect.Left;
pdi.xdiv := pInfo.sWidth;
pdi.ymul := BoundsRect.Bottom-BoundsRect.Top;
pdi.ydiv := pInfo.sHeight;
pdi.bRect := BoundsRect;
for i:=0 to vl.Count-1 do
  TprExObjRecVersion(vl[i]).CalcRealRect(pdi);
end;

procedure TprEndPage.ChangePaper;
begin
try
  Report.prPrinter.SetPrinterInfo(ASize, AWidth, AHeight, AOrientation);
  Report.prPrinter.UpdatepInfo(Self,pInfo,lMargin,rMargin,tMargin,bMargin);
except
  Report.prPrinter.SetPrinterInfo(0, AWidth, AHeight, AOrientation);
  Report.prPrinter.UpdatepInfo(Self,pInfo,lMargin,rMargin,tMargin,bMargin);
end;
PaperSize := Report.prPrinter.PaperSize;
Width := Report.prPrinter.PaperWidth;
Height := Report.prPrinter.PaperLength;
Orientation := Report.prPrinter.Orientation;
end;

//////////////////////////
//
// TprPage
//
//////////////////////////
constructor TprPage.Create;
begin
inherited;
dPageRect:=@pInfo.saRect;
end;

procedure TprPage.Loaded;
begin
ChangePaper(PaperSize,Width,Height,Orientation);
inherited;
end;

procedure TprPage.ReportSetted;
begin
ChangePaper(DMPAPER_A4,0,0,poPortrait);
//    ,   pInfo.mmXXXXXXX
lMargin     :=pInfo.mmlMargin;
tMargin     :=pInfo.mmtMargin;
rMargin     :=pInfo.mmrMargin;
bMargin     :=pInfo.mmbMargin;
pInfo.saRect:=pInfo.PrnSRect;
pInfo.paRect:=pInfo.PrnPRect;
end;

procedure TprPage.ChangePaper;
begin
try
  TprReport(Report).prPrinter.SetPrinterInfo(ASize, AWidth, AHeight, AOrientation);
  TprReport(Report).prPrinter.UpdatepInfo(Self,pInfo,lMargin,rMargin,tMargin,bMargin);
except
  TprReport(Report).prPrinter.SetPrinterInfo(0, AWidth, AHeight, AOrientation);
  TprReport(Report).prPrinter.UpdatepInfo(Self,pInfo,lMargin,rMargin,tMargin,bMargin);
end;

PaperSize   := TprReport(Report).prPrinter.PaperSize;
Width       := TprReport(Report).prPrinter.PaperWidth;
Height      := TprReport(Report).prPrinter.PaperLength;
Orientation := TprReport(Report).prPrinter.Orientation;
UpdateBandsPageRect;
end;

function TprPage.GetPageRect;
begin
Result:=pInfo.saRect;
end;

//////////////////////////////
//
// TprPrinter
//
//////////////////////////////
constructor TprPrinter.Create;
var
  DC : HDC;
begin
inherited Create;
DevNames := nil;
DevNamesSize := 0;
DevMode := nil;
DevModeSize := 0;
FPrinterIndex := -1;
FPrinters := TStringList.Create;
FPaperNames := TStringList.Create;

DC := GetDC(0);
scrPixelsPerX := GetDeviceCaps(DC,LOGPIXELSX);
scrPixelsPerY := GetDeviceCaps(DC,LOGPIXELSY);
ReleaseDC(0,DC);
CreatedscrPixelsPerX := scrPixelsPerX;
CreatedscrPixelsPerY := scrPixelsPerY;

UpdatePrintersList;
SetToDefaultPrinter;
end;

destructor TprPrinter.Destroy;
begin
ClearStructures;
ClearInfo;
FPrinters.Free;
FPaperNames.Free;

inherited;
end;

procedure TprPrinter.UpdatePrintersList;
begin
pr_Utils.UpdatePrintersList(FPrinters,prLoadStr(sDefaultPrinterName));
end;

//       ,
//    -
procedure TprPrinter.SetToDefaultPrinter;
var
  pn : string;
  pi : integer;
begin
pi := 0;
pn := prGetDefaultPrinterName;
if pn<>'' then
  pi := FPrinters.IndexOf(pn);
PrinterIndex := pi;
end;

procedure TprPrinter.SetPrinterIndex;
begin
if FPrinterIndex<>Value then
  begin
    FPrinterIndex := Value;

    ClearStructures;
    ClearInfo;
  end;
end;

procedure TprPrinter.SetPrinterName;
var
  i : integer;
begin
i := FPrinters.IndexOf(Value);
if i=-1 then
  raise Exception.Create(prLoadStr(sInvalidPrinterName))
else
  PrinterIndex := i;
end;

function TprPrinter.GetPrinterName;
begin
Result := FPrinters[FPrinterIndex];
end;

procedure TprPrinter.ClearStructures;
begin
FStructuresInitializated:=false;
DriverName :='';
DeviceName :='';
PortName   :='';
if DevNames<>nil then
  begin
    FreeMem(DevNames);
    DevNames:=nil;
    DevNamesSize:=0;
  end;
if DevMode<>nil then
  begin
    FreeMem(DevMode);
    DevMode    :=nil;
    DevModeSize:=0;
  end;
end;

procedure TprPrinter.ClearInfo;
begin
FInfoInitializated:=false;
PixelsPerX        :=0;
PixelsPerY        :=0;
PaperSize         :=0;
PaperWidth        :=0;
PaperLength       :=0;
FPaperNames.Clear;
if PaperSizes<>nil then
  begin
    FreeMem(PaperSizes);
    PaperSizes:=nil;
  end;
if PrinterDC<>0 then
  begin
    DeleteDC(PrinterDC);
    PrinterDC:=0;
  end;
end;

//   DevNames,DevMode
function TprPrinter.InitStructures;
var
  pi2 : PPrinterInfo2;
  Offset: PChar;
  hPrinter : THandle;
  OldError : UINT;
  TempDevMode : TDevMode;
  BytesNeeded : cardinal;
begin
Result:=false;
ClearStructures;

if FPrinterIndex=0 then
  begin
    //  "" 
    DeviceName := prLoadStr(sDefaultPrinterName);
  end
else
  begin
    //  
    hPrinter := 0;
    pi2 := nil;
    if not OpenPrinter(PChar(PrinterName),hPrinter,nil) then exit;

    try
      GetPrinter(hPrinter,2,nil,0,@BytesNeeded);
      if BytesNeeded=0 then
        begin
          ClosePrinter(hPrinter);
          exit;
        end;

      GetMem(pi2,BytesNeeded);
      if not GetPrinter(hPrinter,2,pi2,BytesNeeded,@BytesNeeded) then exit;

      DevNamesSize:=sizeof(TDevNames)+strlen(pi2.pPrinterName)+strlen(pi2.pDriverName)+strlen(pi2.pPortName)+3;
      GetMem(DevNames,DevNamesSize);

      Offset                 :=PChar(DevNames)+SizeOf(TDevnames);
      DevNames^.wDriverOffset:=Longint(Offset)-Longint(DevNames);
      Offset                 :=StrECopy(Offset, pi2.pDriverName)+1;
      DevNames^.wDeviceOffset:=Longint(Offset)-Longint(DevNames);
      Offset                 :=StrECopy(Offset, pi2.pPrinterName) + 1;
      DevNames^.wOutputOffset:=Longint(Offset)-Longint(DevNames);
      StrCopy(Offset, pi2.pPortName);

      SetLength(DeviceName,strlen(pi2.pPrinterName));
      MoveMemory(@(DeviceName[1]),pi2.pPrinterName,strlen(pi2.pPrinterName));
      SetLength(DriverName,strlen(pi2.pDriverName));
      MoveMemory(@(DriverName[1]),pi2.pDriverName,strlen(pi2.pDriverName));
      SetLength(PortName,strlen(pi2.pPortName));
      MoveMemory(@(PortName[1]),pi2.pPortName,strlen(pi2.pPortName));

      //  DevMode  
      OldError:=SetErrorMode(SEM_FAILCRITICALERRORS);
      try
        DevModeSize := DocumentProperties(0,hPrinter,PChar(DeviceName),TempDevMode,TempDevMode,0);
      finally
        SetErrorMode(OldError);
      end;

      if DevModeSize<=0 then
        DevMode := AllocMem(sizeof(TDeviceMode))
      else
        DevMode := AllocMem(DevModeSize);
      DevMode.dmSize := sizeof(TDeviceMode);
      if DevModeSize<=0 then
        begin
          DevMode.dmFields := DM_ORIENTATION or DM_PAPERSIZE;
          DevMode.dmOrientation := DMORIENT_PORTRAIT;
          DevMode.dmPaperSize := DMPAPER_A4;
        end
      else
        begin
          if DocumentProperties(0,hPrinter,PChar(DeviceName),DevMode^,DevMode^,DM_OUT_BUFFER)<0 then
            begin
              FreeMem(DevMode);
              DevMode := nil;
              DevModeSize := 0;
            end
        end;
    finally
      FreeMem(pi2);
      if hPrinter<>0 then
        ClosePrinter(hPrinter);
    end;

    if DevMode=nil then
      begin
        ClearStructures;
        Result:=false;
        exit;
      end;

  end;
FStructuresInitializated:=true;
Result                  :=true;
end;

//   
function TprPrinter.InitInfo;
var
  i,Count : integer;
  PSize : TPoint;
  Buffer : PChar;
  EscapeFunc : word;
  OldError : UINT;
begin
Result := false;
ClearInfo;

if not FStructuresInitializated then exit;

if FPrinterIndex=0 then
  begin
    PixelsPerX:=600;
    PixelsPerY:=600;

    PaperSizesCount:=PAPERCOUNT;
    GetMem(PaperSizes,PaperSizesCount*2);
    for i := 0 to PAPERCOUNT-1 do
      begin
        FPaperNames.Add(PaperInfo[i].Name);
        PaperSizes[i] := PaperInfo[i].Typ;
        if (PaperSize <> 0) and (PaperSize = PaperInfo[i].Typ) then
          begin
            if Orientation = poLandscape then
              begin
                PaperWidth  := PaperInfo[i].Y;
                PaperLength := PaperInfo[i].X;
              end
            else
              begin
                PaperWidth  := PaperInfo[i].X;
                PaperLength := PaperInfo[i].Y;
              end;
          end;
      end;
  end
else
  begin
    OldError := SetErrorMode(SEM_FAILCRITICALERRORS);
    try
      PrinterDC := CreateIC(PChar(DriverName),PChar(DeviceName),PChar(PortName),DevMode);
    finally
      SetErrorMode(OldError);
    end;
    if PrinterDC=0 then exit;

    // 
    PixelsPerX:=GetDeviceCaps(PrinterDC, LOGPIXELSX);
    PixelsPerY:=GetDeviceCaps(PrinterDC, LOGPIXELSY);

    //  
    if (DevMode.dmFields and DM_PAPERSIZE)<>0 then
      PaperSize := DevMode.dmPaperSize;

    // 
    if (DevMode.dmFields and DM_ORIENTATION)<>0 then
      begin
        case DevMode.dmOrientation of
          dmorient_portrait : Orientation:=poPortrait;
          dmorient_landscape: Orientation:=poLandscape;
        end;
      end;

    //  
    EscapeFunc := GetPhysPageSize;
    if Escape(PrinterDC, QueryEscSupport, SizeOf(EscapeFunc), @EscapeFunc, nil) <> 0 then
      begin
        Escape(PrinterDC, GetPhysPageSize, 0, nil, @PSize);
        PaperWidth  := MulDiv(PSize.X,254,PixelsPerX);
        PaperLength := MulDiv(PSize.Y,254,PixelsPerY);
      end
    else
      begin
        PaperWidth := 0;
        PaperLength := 0;
      end;

    //  
    OldError := SetErrorMode(SEM_FAILCRITICALERRORS);
    try
      PaperSizesCount := DeviceCapabilities(PChar(DeviceName), PChar(PortName), DC_PAPERS, nil, DevMode);
      if PaperSizesCount>0 then
        begin
          GetMem(PaperSizes,PaperSizesCount*2);
          DeviceCapabilities(PChar(DeviceName), PChar(PortName), DC_PAPERS, PChar(PaperSizes), DevMode);
        end
      else
        begin
          GetMem(PaperSizes,sizeof(Word));
          PaperSizes[0] := DMPAPER_A4;
        end;

      //  
      Count := DeviceCapabilities(PChar(DeviceName), PChar(PortName), DC_PAPERNAMES, nil, DevMode);
      if Count>0 then
        begin
          GetMem(Buffer,Count*64);
          try
            DeviceCapabilities(PChar(DeviceName), PChar(PortName), DC_PAPERNAMES, Buffer, DevMode);
            FPaperNames.Clear;
            for i := 0 to Count - 1 do
              FPaperNames.Add(Buffer+i*64);
          finally
            FreeMem(Buffer);
          end;
        end
      else
        begin
          FPaperNames.Clear;
          FPaperNames.Add(PaperInfo[DMPAPER_A4].Name);
        end;
    finally
      SetErrorMode(OldError);
    end;
  end;

FInfoInitializated:=true;
Result            :=true;
end;

procedure TprPrinter.UpdatepInfo;

  function md(mm : integer; mmInInch : integer) : integer;
  begin
  Result := Round(mm*mmInInch/MillimetersPerInch);
  end;

  function dm(pxls : integer; mmInInch : integer) : integer;
  begin
  Result := Round(pxls*MillimetersPerInch/mmInInch+0.5);
  end;

begin
if not FInfoInitializated then
  raise Exception.Create(prLoadStr(sPrinterErrorNotInitInfo));

if FPrinterIndex = 0 then
  with pInfo do
    begin
      sWidth := MulDiv(PaperWidth,scrPixelsPerX,254);
      sHeight := MulDiv(PaperLength,scrPixelsPerY,254);

      mmlMargin := 5;
      mmrMargin := 5;
      mmtMargin := 5;
      mmbMargin := 5;
    end
else
  with pInfo do
    begin
      pWidth := GetDeviceCaps(PrinterDC,PHYSICALWIDTH);
      pHeight := GetDeviceCaps(PrinterDC,PHYSICALHEIGHT);
      sWidth := muldiv(pWidth,scrPixelsPerX,PixelsPerX);
      sHeight := muldiv(pHeight,scrPixelsPerY,PixelsPerY);

      PrnpRect.Left := GetDeviceCaps(PrinterDC,PHYSICALOFFSETX);
      PrnpRect.Top := GetDeviceCaps(PrinterDC,PHYSICALOFFSETY);
      PrnpRect.Right := GetDeviceCaps(PrinterDC,HORZRES)+PrnpRect.Left;
      PrnpRect.Bottom := GetDeviceCaps(PrinterDC,VERTRES)+PrnpRect.Top;

      mmlMargin := dm(PrnpRect.Left,PixelsPerX);
      mmtMargin := dm(PrnpRect.Top,PixelsPerY);
      mmrMargin := dm(pWidth-PrnpRect.Right,PixelsPerX);
      mmbMargin := dm(pHeight-PrnpRect.Bottom,PixelsPerY);

      PrnpRect.Left := md(mmlMargin,PixelsPerX);
      PrnpRect.Right := pWidth-md(mmrMargin,PixelsPerX);
      PrnpRect.Top := md(mmtMargin,PixelsPerY);
      PrnpRect.Bottom := pHeight-md(mmbMargin,PixelsPerY);

      paRect.Left := md(_lMargin,PixelsPerX);
      paRect.Right := pWidth-md(_rMargin,PixelsPerX);
      paRect.Top := md(_tMargin,PixelsPerY);
      paRect.Bottom := pHeight-md(_bMargin,PixelsPerY);
    end;
with pInfo do
  begin
    PrnsRect.Left := md(mmlMargin,scrPixelsPerX);
    PrnsRect.Right := sWidth-md(mmrMargin,scrPixelsPerX);
    PrnsRect.Top := md(mmtMargin,scrPixelsPerY);
    PrnsRect.Bottom := sHeight-md(mmbMargin,scrPixelsPerY);

    saRect.Left := md(_lMargin,scrPixelsPerX);
    saRect.Right := sWidth-md(_rMargin,scrPixelsPerX);
    saRect.Top := md(_tMargin,scrPixelsPerY);
    saRect.Bottom := sHeight-md(_bMargin,scrPixelsPerY);
  end;
end;

function TprPrinter.SetDevMode;
begin
Result:=false;
if not InitStructures then exit;

if (DevModeSize<>NewDevModeSize) and (DevModeSize<>0) then
  begin
    FreeMem(DevMode);
    DevMode:=nil;
  end;

if DevMode=nil then
  GetMem(DevMode,NewDevModeSize);

MoveMemory(DevMode,NewDevMode,NewDevModeSize);
DevModeSize:=NewDevModeSize;

if not InitInfo then exit;
Result:=true;
end;

function TprPrinter.IsEqual;
begin
Result:=false;
if not FInfoInitializated then exit;

if (PaperSize=pgSize) and (pgSize=-1) then
  begin
    Result:= (PaperSize = pgSize) and
             (PaperWidth = pgWidth) and
             (PaperLength = pgHeight) and
             (Orientation = pgOrientation);
  end
else
  begin
    Result:=(PaperSize = pgSize) and
            (Orientation = pgOrientation);
  end;
end;

procedure TprPrinter.SetPrinterInfo;
var
  i : Integer;
  hPrinter : THandle;
begin
if not FStructuresInitializated and not InitStructures then
  raise Exception.Create(prLoadStr(sPrinterErrorUnaibleInitializeStructures));
if not FInfoInitializated and not InitInfo then
  raise Exception.Create(prLoadStr(sPrinterErrorUnaibleInitializeInfo));
if IsEqual(pgSize,pgWidth,pgHeight,pgOrientation) then exit;
if FPrinterIndex = 0 then
  begin
    if pgSize=-1 then
      begin
        PaperWidth := pgWidth;
        PaperLength := pgHeight;
      end
    else
      begin
        i := GetPaperSizeArrayPos(pgSize);
        if i<>-1 then
          begin
            if pgOrientation = poLandscape then
              begin
                PaperWidth := PaperInfo[i].Y;
                PaperLength := PaperInfo[i].X;
              end
            else
              begin
                PaperWidth := PaperInfo[i].X;
                PaperLength := PaperInfo[i].Y;
              end;
          end
        else
          raise Exception.Create(prLoadStr(sPrinterErrorInvalidPaperSize));
      end;
    PaperSize := pgSize;
    Orientation := pgOrientation;
  end
else
  begin
    if pgSize = -1 then
      begin
        DevMode.dmFields := DevMode.dmFields or DM_PAPERLENGTH or DM_PAPERWIDTH;
        DevMode.dmPaperLength := pgHeight;
        DevMode.dmPaperWidth := pgWidth;
      end
    else
      if (DevMode.dmFields and DM_PAPERSIZE)<>0 then
        begin
          DevMode.dmFields := DevMode.dmFields or DM_PAPERSIZE;
          DevMode.dmPaperSize := pgSize;
        end;

    if (DevMode.dmFields and DM_ORIENTATION)<>0 then
      begin
        DevMode.dmFields := DevMode.dmFields or DM_ORIENTATION;
        if pgOrientation=poPortrait then
          DevMode.dmOrientation := dmorient_portrait
        else
          DevMode.dmOrientation := dmorient_landscape;
      end;

    if OpenPrinter(PChar(DeviceName),hPrinter,nil) then
      begin
        DocumentProperties(0,hPrinter,PChar(DeviceName),DevMode^,DevMode^,DM_IN_BUFFER or DM_OUT_BUFFER);
        ClosePrinter(hPrinter);
        InitInfo;
      end;
  end;
end;

function TprPrinter.GetPaperSizeArrayPos;
begin
Result := 0;
while (Result<PaperSizesCount) and (PaperSizes[Result]<>pgSize) do Inc(Result);
if Result>=PaperSizesCount then
  Result := -1;
end;

procedure TprPrinter.BeginDoc;
var
  DocInfo : TDocInfo;
begin
if PrinterDC<>0 then
  begin
    DeleteDC(PrinterDC);
    PrinterDC := 0;
  end;
PrinterDC := CreateDC(PChar(DriverName),PChar(DeviceName),PChar(PortName),DevMode);
if PrinterDC=0 then
  raise Exception.Create(prLoadStr(sPrinterErrorUnaibleCreateCanvas));

ZeroMemory(@DocInfo,sizeof(TDocInfo));
DocInfo.cbSize := sizeof(TDocInfo);
DocInfo.lpszDocName := PChar(Title);
DocInfo.lpszOutput := nil;
//SetAbortProc(DC, AbortProc);
StartDoc(PrinterDC,DocInfo);
StartPage(PrinterDC);
end;

procedure TprPrinter.EndDoc;
begin
EndPage(PrinterDC);
Windows.EndDoc(PrinterDC);
DeleteDC(PrinterDC);
PrinterDC := 0;
end;

procedure TprPrinter.NewPage;
begin
EndPage(PrinterDC);
StartPage(PrinterDC);
end;

///////////////////////////
//
// TprReport
//
///////////////////////////
constructor TprReport.Create;
var
  DC : HDC;
begin
inherited;

FPreviewParams := TprPreviewParams.Create;
FPreviewParams.Options := [];
FPreviewParams.ShowToolbars := [prptPreviewCommon];
FExportPrecisionLow := 10;
FExportPrecisionNormal := 5;
FExportPrecisionHigh := 1;
FExportPrecision := FExportPrecisionHigh;

prPrinter := TprPrinter.Create;

DC := GetDC(0);
ObjectCalcSizesDevice := TObject(CreateCompatibleDC(DC));
ReleaseDC(0,DC);
end;

destructor TprReport.Destroy;
begin
prPrinter.Free;
DeleteDC(HDC(ObjectCalcSizesDevice));
FPreviewParams.Free;
inherited;
end;

procedure TprReport.Loaded;
var
  i,j,k : integer;
begin
inherited;
if (prPrinter.CreatedscrPixelsPerX<>prPrinter.scrPixelsPerX) or
   (prPrinter.CreatedscrPixelsPerY<>prPrinter.scrPixelsPerY) then
  // scale all objects in report 
  for i:=0 to PagesCount-1 do
    begin
      for j:=0 to Pages[i].Bands.Count-1 do
        begin
          if Pages[i].Bands[j].BandType in HorizontalBands then
            TprCustomHBand(Pages[i].Bands[j]).Height := MulDiv(TprCustomHBand(Pages[i].Bands[j]).Height,prPrinter.scrPixelsPerY,prPrinter.CreatedscrPixelsPerY)
          else
            TprCustomVBand(Pages[i].Bands[j]).Width := MulDiv(TprCustomVBand(Pages[i].Bands[j]).Width,prPrinter.scrPixelsPerX,prPrinter.CreatedscrPixelsPerX);
          for k:=0 to Pages[i].Bands[j].Objects.Count-1 do
            Pages[i].Bands[j].Objects[k].dRec.pRect := MuldivRect(Pages[i].Bands[j].Objects[k].dRec.pRect,prPrinter.scrPixelsPerX,prPrinter.CreatedscrPixelsPerX,prPrinter.scrPixelsPerY,prPrinter.CreatedscrPixelsPerY);
        end;
      Pages[i].UpdateBandsPageRect;
    end;
end;

procedure TprReport.ReadLOGPIXELSX;
begin
prPrinter.CreatedscrPixelsPerX := Reader.ReadInteger;
end;

procedure TprReport.WriteLOGPIXELSX;
var
  DC : HDC;
begin
DC := GetDC(0);
Writer.WriteInteger(GetDeviceCaps(DC,LOGPIXELSX));
ReleaseDC(0,DC);
end;

procedure TprReport.ReadLOGPIXELSY;
begin
prPrinter.CreatedscrPixelsPerY := Reader.ReadInteger;
end;

procedure TprReport.WriteLOGPIXELSY;
var
  DC : HDC;
begin
DC := GetDC(0);
Writer.WriteInteger(GetDeviceCaps(DC,LOGPIXELSY));
ReleaseDC(0,DC);
end;

procedure TprReport.DefineProperties;
begin
inherited;
Filer.DefineProperty('LOGPIXELSX',ReadLOGPIXELSX,WriteLOGPIXELSX,true);
Filer.DefineProperty('LOGPIXELSY',ReadLOGPIXELSY,WriteLOGPIXELSY,true);
end;

function TprReport.GetPrinterName;
begin
Result := prPrinter.Printers[prPrinter.PrinterIndex];
end;

procedure TprReport.SetPrinterName;
var
  i : integer;
begin
i:=prPrinter.Printers.IndexOf(Value);
if i<>-1 then
  ChangePrinter(prPrinter.PrinterIndex,i);
end;

function TprReport.GetDesignerFormClass;
begin
Result := 'TprDesignerForm';
end;

function TprReport.GetPreviewFormClass;
begin
Result := 'TprPreviewForm';
end;

function TprReport.CreateEndPage;
begin
Result:=TprEndPage.Create(Page as TprPage);
end;

function TprReport.CreateEmptyEndPage;
begin
Result:=TprEndPage.CreateEmpty(Self);
end;

procedure TprReport.InternalLoadPreparedReport;
var
  ep : TprEndPage;
  buf : cardinal;
  i,b,j : integer;
begin
Stream.Read(buf,4);
if buf=PreparedReportSavePrefix then
  begin
    Stream.Read(buf,4);
    case buf of
      1 : begin
            Stream.Read(prPrinter.CreatedscrPixelsPerX,4);
            Stream.Read(prPrinter.CreatedscrPixelsPerY,4);
          end;
    end;
  end
else
  begin
    Stream.Seek(0,soFromBeginning);
    prPrinter.CreatedscrPixelsPerX := prPrinter.scrPixelsPerX;
    prPrinter.CreatedscrPixelsPerY := prPrinter.scrPixelsPerY;
  end;
Stream.Read(b,4);
for i:=0 to b-1 do
  begin
    ep := TprEndPage(CreateEmptyEndPage);
    try
      ep.Load(Stream);
      for j:=0 to ep.VL.Count-1 do
        if TprExObjRecVersion(ep.VL[j]).PreviewUserData<>nil then
          AddPreviewUserData(TprExObjRecVersion(ep.VL[j]).PreviewUserData);
    except
      ep.Free;
      raise;
    end;
    AddEndPageToList(ep);
  end;
end;

procedure TprReport.LoadPreparedReport;
begin
inherited;
ClearEndPages;
InternalLoadPreparedReport(Stream);
end;

procedure TprReport.AppendPreparedReport;
begin
inherited;
InternalLoadPreparedReport(Stream);
end;

procedure TprReport.SavePreparedReport;
var
  b,i : integer;
  buf : cardinal;
begin
inherited;
buf := PreparedReportSavePrefix;
Stream.Write(buf,4);
buf := PreparedReportSaveFormatVersion;
Stream.Write(buf,4);
Stream.Write(prPrinter.CreatedscrPixelsPerX,4);
Stream.Write(prPrinter.CreatedscrPixelsPerY,4);
b := EndPagesCount;
Stream.Write(b,4);
if (Stream is TMemoryStream) and (b>0) then
  begin
    i := 0;
    repeat
      TprEndPage(EndPages[i]).Save(Stream);
      Inc(i);
      if Stream.Size=Stream.Position then
        Stream.Size := muldiv(b,Stream.Size,i);
    until (i>=b);
    Stream.Size := Stream.Position;
  end
else
  begin
    for i:=0 to b-1 do
      TprEndPage(EndPages[i]).Save(Stream);
  end
end;

procedure TprReport.ChangePrinter;

  procedure ChangePages;
  var
    i : Integer;
  begin
    for i := 0 to PagesCount-1 do
      with TprPage(Pages[i]) do
        ChangePaper(PaperSize, Width, Height, Orientation);
  end;

begin
try
  prPrinter.PrinterIndex := NewIndex;
  prPrinter.PaperSize := -2;
  ChangePages;
except
  on E : Exception do
    begin
      MBError(Format(prLoadStr(sErrorSelectPrinter2),[prPrinter.Printers[NewIndex],E.Message]));
      prPrinter.PrinterIndex := OldIndex;
      ChangePages;
    end;
  end;
end;

const
  IDD_PRINTTEMPLATE = 1001;
  IDC_PAGESLIST     = 1000;
  IDC_ALL           = 1056;
  IDC_PAGES         = 1058;
  IDC_SELECTION     = 1057;
  IDC_EDITPAGESLIST = 1001;
  IDC_FROMPAGE      = 1152;
  IDC_TOPAGE        = 1153;

var
  cpd : PPrintDlg;

procedure CenterWindow(Wnd: HWnd);
var
  Rect: TRect;
  Monitor: TMonitor;
begin
  GetWindowRect(Wnd, Rect);
  if Application.MainForm <> nil then
    Monitor := Application.MainForm.Monitor
  else
    Monitor := Screen.Monitors[0];
  SetWindowPos(Wnd, 0,
    Monitor.Left + ((Monitor.Width - Rect.Right + Rect.Left) div 2),
    Monitor.Top + ((Monitor.Height - Rect.Bottom + Rect.Top) div 3),
    0, 0, SWP_NOACTIVATE or SWP_NOSIZE or SWP_NOZORDER);
end;

function DialogHook(Wnd: HWnd; Msg: UINT; WParam: WPARAM; LParam: LPARAM): UINT; stdcall;
var
  pl : TList;
  Buf : string;
  Min,Max,lMin,lMax,CtrlID,TextLength : integer;
begin
Result := 0;

case Msg of
  WM_INITDIALOG:
    begin
      cpd:=PPrintDlg(lParam);
      SetDlgItemText(Wnd,IDC_EDITPAGESLIST,PChar(TprReport(cpd.lCustData).PrintPages));

      SendMessage(GetDlgItem(Wnd,IDC_PAGESLIST),BM_SETCHECK,BST_UNCHECKED,0);
      case TprReport(cpd.lCustData).PrintPagesMode of
        ppmPagesList:
          CtrlID:=IDC_PAGESLIST;
        ppmPagesRange:
          CtrlID:=IDC_PAGES;
        ppmSelection:
          CtrlID:=IDC_SELECTION
        else
          CtrlID:=IDC_ALL;
      end;
      SendMessage(GetDlgItem(Wnd,CtrlID),BM_SETCHECK,BST_CHECKED,0);

      CenterWindow(Wnd);
    end;
  WM_COMMAND:
    begin
      case wParam of
        IDOK:
          begin
            if SendMessage(GetDlgItem(Wnd,IDC_PAGESLIST),BM_GETCHECK,0,0)=BST_CHECKED then
              begin
                // 
                TextLength:=GetWindowTextLength(GetDlgItem(Wnd,IDC_EDITPAGESLIST));
                if TextLength>0 then
                  begin
                    SetLength(Buf,TextLength);
                    if GetDlgItemText(Wnd,IDC_EDITPAGESLIST,@(Buf[1]),TextLength+1)>0 then
                      begin
                        if Buf='' then
                          begin
                            Application.MessageBox(PChar(prLoadStr(sSetupPrintError1)),PChar(prLoadStr(sAttention)),MB_OK+MB_ICONEXCLAMATION);
                            Result:=1;
                          end
                        else
                          begin
                            pl:=TList.Create;
                            try
                              TextToPageList(Buf,pl);
                              Min :=cpd.nMinPage;
                              Max :=cpd.nMaxPage;
                              lMin:=integer(pl[0]);
                              lMax:=integer(pl[pl.Count-1]);
                              if (lMin<Min) or (lMin>Max) or (lMax<Min) or (lMax>Max) then
                                begin
                                  SetFocus(GetDlgItem(Wnd,IDC_EDITPAGESLIST));
                                  Application.MessageBox(PChar(Format(prLoadStr(sSetupPrintError2),[Min,Max])),PChar(prLoadStr(sAttention)),MB_ICONEXCLAMATION+MB_OK);
                                  Result:=1;
                                end;
                            finally
                              pl.Free;
                            end;
                          end;
                      end;
                  end
                else
                  begin
                    Application.MessageBox(PChar(prLoadStr(sSetupPrintError1)),PChar(prLoadStr(sAttention)),MB_OK+MB_ICONEXCLAMATION);
                    Result:=1;
                  end;
              end;

            if Result=0 then
              begin
                TextLength:=GetWindowTextLength(GetDlgItem(Wnd,IDC_EDITPAGESLIST));
                if TextLength>0 then
                  begin
                    SetLength(Buf,TextLength);
                    if GetDlgItemText(Wnd,IDC_EDITPAGESLIST,@(Buf[1]),TextLength+1)>0 then
                      begin
                        TprReport(cpd.lCustData).PrintPages:=Buf;
                        TextToPageList(Buf,TprReport(cpd.lCustData).FPrintPagesList);
                      end;
                  end
                else
                  TprReport(cpd.lCustData).PrintPages:='';

                if SendMessage(GetDlgItem(Wnd,IDC_PAGESLIST),BM_GETCHECK,0,0)=BST_CHECKED then
                  TprReport(cpd.lCustData).PrintPagesMode:=ppmPagesList
                else
                  if SendMessage(GetDlgItem(Wnd,IDC_ALL),BM_GETCHECK,0,0)=BST_CHECKED then
                    TprReport(cpd.lCustData).PrintPagesMode:=ppmAll
                  else
                    if SendMessage(GetDlgItem(Wnd,IDC_PAGES),BM_GETCHECK,0,0)=BST_CHECKED then
                      TprReport(cpd.lCustData).PrintPagesMode:=ppmPagesRange
                    else
                      Result:=1;
              end;
          end
        else
          case WParam shr 16 of
            BN_CLICKED :
              begin
                CtrlID:=GetDlgCtrlID(LParam);
                case CtrlID of
                  IDC_PAGESLIST:
                    begin
                      SendMessage(lParam,BM_SETCHECK,BST_CHECKED,0);
                      SendMessage(GetDlgItem(Wnd,IDC_ALL),BM_SETCHECK,BST_UNCHECKED,0);
                      SendMessage(GetDlgItem(Wnd,IDC_PAGES),BM_SETCHECK,BST_UNCHECKED,0);
                      SendMessage(GetDlgItem(Wnd,IDC_SELECTION),BM_SETCHECK,BST_UNCHECKED,0);
                      SetFocus(GetDlgItem(Wnd,IDC_EDITPAGESLIST));
                      Result:=1;
                    end;
                  IDC_ALL,IDC_PAGES,IDC_SELECTION:
                    begin
                      SendMessage(GetDlgItem(Wnd,IDC_PAGESLIST),BM_SETCHECK,BST_UNCHECKED,0);
                    end;
                end;
              end;
            EN_CHANGE:
              begin
                case GetDlgCtrlID(lParam) of
                  IDC_EDITPAGESLIST:
                    begin
                      SendMessage(GetDlgItem(Wnd,IDC_PAGESLIST),BM_SETCHECK,BST_CHECKED,0);
                      SendMessage(GetDlgItem(Wnd,IDC_ALL),BM_SETCHECK,BST_UNCHECKED,0);
                      SendMessage(GetDlgItem(Wnd,IDC_PAGES),BM_SETCHECK,BST_UNCHECKED,0);
                      SendMessage(GetDlgItem(Wnd,IDC_SELECTION),BM_SETCHECK,BST_UNCHECKED,0);
                    end;
                  IDC_FROMPAGE,IDC_TOPAGE:
                    begin
                      SendMessage(GetDlgItem(Wnd,IDC_PAGESLIST),BM_SETCHECK,BST_UNCHECKED,0);
                    end;
                end;
              end;
          end;
      end;
    end;
end;
end;

function TprReport.SetupPrintParams;
var
  pd : tagPDA;
  DevMode : PDevMode;
  DevNames : PDevNames;

  function CreateMemHandle(Data : pointer; DataSize : integer) : THandle;
  var
    b : pointer;
  begin
  Result:=GlobalAlloc(GHND,DataSize);
  b:=GlobalLock(Result);
  MoveMemory(b,Data,DataSize);
  GlobalUnlock(Result);
  end;

begin
ZeroMemory(@pd,sizeof(pd));
pd.hWndOwner          :=application.Handle;
pd.lStructSize        :=sizeof(pd);
pd.hInstance          :=SysInit.hInstance;
pd.lpPrintTemplateName:=PChar(IDD_PRINTTEMPLATE);

pd.nCopies            :=Copies;
if pd.nCopies=0 then
  pd.nCopies:=1;
pd.nMinPage           :=1;
pd.nMaxPage           :=EndPagesCount;
pd.nFromPage          :=Self.FromPage;
if pd.nFromPage=0 then
  pd.nFromPage:=1;
pd.nToPage            :=Self.ToPage;
if pd.nToPage>pd.nMaxPage then
  pd.nToPage:=pd.nMaxPage;
if pd.nToPage=0 then
  pd.nToPage:=1;

pd.lCustData          :=integer(Self);
pd.lpfnPrintHook      :=@DialogHook;
pd.Flags              :=PD_HIDEPRINTTOFILE or PD_NONETWORKBUTTON or
                        PD_ENABLEPRINTHOOK or PD_NOSELECTION or
                        PD_ENABLEPRINTTEMPLATE;
case Self.PrintPagesMode of
  ppmAll       : pd.Flags:=pd.Flags+PD_ALLPAGES;
  ppmPagesRange: pd.Flags:=pd.Flags+PD_PAGENUMS;
end;
if Self.Collate then
  pd.Flags:=pd.Flags+PD_COLLATE;

if prPrinter.PrinterIndex=0 then
  prPrinter.SetToDefaultPrinter;
  
if prPrinter.FStructuresInitializated or prPrinter.InitStructures then
  begin
    pd.hDevNames:=CreateMemHandle(prPrinter.DevNames,prPrinter.DevNamesSize);
    pd.hDevMode :=CreateMemHandle(prPrinter.DevMode,prPrinter.DevModeSize);
  end;

try
  Result:=PrintDlg(pd);
  if Result then
    begin
      Self.Collate         :=(pd.Flags and PD_COLLATE)<>0;
      Self.Copies          :=pd.nCopies;
      Self.FromPage        :=pd.nFromPage;
      Self.ToPage          :=pd.nToPage;
                           
      DevNames             :=PDevNames(GlobalLock(pd.hDevNames));
      DevMode              :=PDevMode(GlobalLock(pd.hDevMode));
      prPrinter.PrinterName:=StrPas(PChar(DevNames) + DevNames^.wDeviceOffset);
      Result               :=prPrinter.SetDevMode(DevMode,GlobalSize(pd.hDevMode));
      GlobalUnlock(pd.hDevNames);
      GlobalUnLock(pd.hDevMode);
      if not Result then
        MBError(Format(prLoadStr(sPrinterErrorUnknown),[prPrinter.PrinterName]));
    end;
  if Assigned(OnCloseSetupDialog) then
    OnCloseSetupDialog(Self,Result);
finally
  GlobalFree(pd.hDevNames);
  GlobalFree(pd.hDevNames);
end;
end;

function TprReport.PrintPreparedReport;
var
  f : boolean;
  i,j,_FromPage,_ToPage : integer;

  procedure PrintPage(pn : Integer);
  var
    i : integer;
    ep : TprEndPage;
    pInfo : TprPageInfo;
    OldOrgEx : TPoint;
  begin
  ep := TprEndPage(EndPages[pn]);
  if not prPrinter.IsEqual(ep.PaperSize,ep.Width,ep.Height,ep.Orientation) then
    begin
      if f then
        prPrinter.EndDoc;
      prPrinter.SetPrinterInfo(ep.PaperSize,ep.Width,ep.Height,ep.Orientation);
      prPrinter.BeginDoc;
    end
  else
    if f then
      prPrinter.NewPage
    else
      prPrinter.BeginDoc;

  prPrinter.UpdatepInfo(ep,pInfo,ep.lMargin,ep.rMargin,ep.tMargin,ep.bMargin);

  ep.Cache(Rect(0,0,pInfo.pWidth,pInfo.pHeight),true);
  ep.rpdi.hsb := pInfo.PrnPRect.Left;
  ep.rpdi.vsb := pInfo.PrnPRect.Top;

  SetViewportOrgEx(prPrinter.PrinterDC,-pInfo.PrnPRect.Left,-pInfo.PrnPRect.Top,@OldOrgEx);

  for i:=0 to ep.vl.Count-1 do
    TprExObjRecVersion(ep.vl[i]).Draw(prPrinter.PrinterDC,@ep.rpdi);

  SetViewportOrgEx(prPrinter.PrinterDC,OldOrgEx.X,OldOrgEx.Y,nil);

  f := true;
  end;

begin
Result := false;
FActionCanceled := false;
_FromPage := 0;
_ToPage := EndPagescount-1;
if PrintPagesMode=ppmPagesRange then
  begin
    _FromPage := FromPage-1;
    _ToPage := ToPage-1;
  end;

if ShowProgress then
  CreateProgressForm(prLoadStr(sPrintReportCaption),0);

if Title<>'' then
  prPrinter.Title := Title
else
  prPrinter.Title := prLoadStr(sNoReportName);

try
  try
    f := false;
    if Collate then
      begin
        for i:=0 to Copies-1 do
          if PrintPagesMode=ppmPagesList then
            begin
              for j:=0 to FPrintPagesList.Count-1 do
                begin
                  UpdateProgressForm(Format(prLoadStr(sPrintReport),[integer(FPrintPagesList[j]),i+1,FPrintPagesList.Count,Copies]));
                  PrintPage(integer(FPrintPagesList[j])-1);
                end;
            end
          else
            begin
              for j:=_FromPage to _ToPage do
                begin
                  UpdateProgressForm(Format(prLoadStr(sPrintReport),[j+1,i+1,_ToPage-_FromPage+1,Copies]));
                  PrintPage(j);
                end;
            end;
      end
    else
      begin
        if PrintPagesMode=ppmPagesList then
          begin
            for i:=0 to FPrintPagesList.Count-1 do
              for j:=0 to Copies-1 do
                begin
                  UpdateProgressForm(Format(prLoadStr(sPrintReport),[integer(FPrintPagesList[i]),j+1,FPrintPagesList.Count,Copies]));
                  PrintPage(integer(FPrintPagesList[i])-1);
                end;
          end
        else
          begin
            for i:=_FromPage to _ToPage do
              for j:=0 to Copies-1 do
                begin
                  UpdateProgressForm(Format(prLoadStr(sPrintReport),[i+1,j+1,_ToPage-_FromPage+1,Copies]));
                  PrintPage(i);
                end;
          end;
      end;

    Result := true;

  except
    on E : Exception do
      begin
        if E is EActionCanceled then
          FActionCanceled := true
        else
          raise;
      end;
  end

finally
  prPrinter.EndDoc;
  CloseProgressForm;
  if Result and Assigned(OnPrintComplete) then
    OnPrintComplete(Self);
end;
end;

function TprReport.GetBandClass;
begin
Result:=TprBandClass(GetClass('Tpr'+Copy(GetEnumName(TypeInfo(TprBandType),integer(BandType)),3,Length(GetEnumName(TypeInfo(TprBandType),integer(BandType))))+'Band'));
end;



type

TCol = class(TObject)
  X : integer;
  Index : integer;
  constructor CreateCol(_X : integer);
end;

constructor TCol.CreateCol;
begin
inherited Create;
X := _X;
end;

type

TRow = class(TObject)
  Y : integer;
  Index : integer;
  PageIndex : integer;
  constructor CreateRow(_Y : integer; _PageIndex : integer);
end;

constructor TRow.CreateRow;
begin
inherited Create;
Y := _Y;
PageIndex := _PageIndex;
end;

type
rXLSExport = record
  LeftCol : TCol;
  RightCol : TCol;
  TopRow : TRow;
  BottomRow : TRow;
end;
pXLSExport = ^rXLSExport;


function SortCols(Item1,Item2 : pointer) : integer;
begin
Result := TCol(Item1).X-TCol(Item2).X;
end;

function SortRows(Item1,Item2 : pointer) : integer;
begin
if TRow(Item1).PageIndex=TRow(Item2).PageIndex then
  Result := TRow(Item1).Y-TRow(Item2).Y
else
  Result := TRow(Item1).PageIndex-TRow(Item2).PageIndex;
end;

function TprReport.SetupExportParams;
begin
Result := TprExportParamsForm.Create(nil).EditParams(Self);
end;

procedure TprReport.ExportToXLS;
var
  epStart,i,j,k,rStart : integer;
  v : TprExObjRecVersion;
  pl : TList;
  pi : PprPageInfo;
  ep : TprEndPage;
  pe : pXLSExport;
  pCap1 : string;
  Cols : TList;
  Rows : TList;
  pr,r : TRow;
  KoefX,KoefY : double;
  ErrorsExists : boolean;
  Range,Excel,WB,SH : Variant;

  function CEP(v1,v2 : integer) : boolean;
  begin
  Result := Abs(v1-v2)<=ExportPrecision;
  end;

  function IsExportPage(PageNumber : integer) : boolean;
  begin
  PageNumber := PageNumber+1;
  Result := (ExportPagesMode=ppmAll) or
            ((ExportPagesMode=ppmPagesRange) and (PageNumber>=ExportFromPage) and (PageNumber<=ExportToPage)) or
            ((ExportPagesMode=ppmPagesList) and (pl.IndexOf(pointer(PageNumber))<>-1));
  end;

  procedure ClearColsAndRows;
  var
    j : integer;
  begin
  for j:=0 to Cols.Count-1 do
    TCol(Cols[j]).Free;
  Cols.Clear;
  for j:=0 to Rows.Count-1 do
    TRow(Rows[j]).Free;
  Rows.Clear;
  end;

begin
if EndPagesCount<=0 then
  raise Exception.Create(prLoadStr(sReportEmptyInExport));
if preoShowParamsDlg in ExportOptions then
  if not SetupExportParams then
    exit;

try
  Excel := CreateOleObject(ExcelOLEServerName);
  Excel.Visible := preoShowWhileGenerate in ExportOptions;
  Excel.DisplayAlerts := false;
  WB := Excel.WorkBooks.Add;
  while WB.Sheets.Count>1 do
    WB.Sheets[WB.Sheets.Count].Delete;
  SH := WB.Sheets[1];
except
  on E : Exception do
    raise Exception.CreateFmt(prLoadStr(sExportErrorInitOLEServer),[ExcelOLEServerName,E.Message]);
end;

Cols := TList.Create;
Rows := TList.Create;
ErrorsExists := false;

KoefX := Excel.InchesToPoints(1)*SH.Columns[1].ColumnWidth/XLS_EXPORT_LOGPIXELSX/SH.Columns[1].Width;
KoefY := Excel.InchesToPoints(1)*SH.Rows[1].RowHeight/XLS_EXPORT_LOGPIXELSY/SH.Rows[1].Height;

if ExportPagesMode=ppmPagesList then pl := TList.Create
                                else pl := nil;
try
  if pl<>nil then
    TextToPageList(ExportPages,pl);

  pCap1 := prLoadStr(sExportReportProgress);
  if preoShowProgress in ExportOptions then
    begin
      j := 0;
      for k:=0 to EndPagesCount-1 do
        if IsExportPage(k) then
          Inc(j);
      CreateProgressForm(Format(prLoadStr(sExportReportCaption),[ExportFileName]),j);
    end;

  try
    i := 0;
    while i<EndPagesCount do
      begin
        if not IsExportPage(i) then
          begin
            Inc(i);
            continue;
          end;
        pi := @TprEndPage(EndPages[i]).pInfo;
        epStart := i;
        while (i<EndPagesCount) and
              (pi.pWidth=TprEndPage(EndPages[i]).pInfo.pWidth) and
              (pi.pHeight=TprEndPage(EndPages[i]).pInfo.pHeight) and
              (pi.mmlMargin=TprEndPage(EndPages[i]).pInfo.mmlMargin) and
              (pi.mmrMargin=TprEndPage(EndPages[i]).pInfo.mmrMargin) and
              (pi.mmtMargin=TprEndPage(EndPages[i]).pInfo.mmtMargin) and
              (pi.mmbMargin=TprEndPage(EndPages[i]).pInfo.mmbMargin) do
          begin
            if not IsExportPage(i) then
              begin
                Inc(i);
                continue;
              end;
            ep := TprEndPage(EndPages[i]);
            rStart := Rows.Count;
            for j:=0 to ep.VL.Count-1 do
              begin
                v := TprExObjRecVersion(ep.VL[j]);
                GetMem(v.ResExport1,sizeof(rXLSExport));
                k := 0;
                while (k<Cols.Count) and not CEP(TCol(Cols[k]).X,v.GeneratedRect.Left) do Inc(k);
                if k>=Cols.Count then
                  pXLSExport(v.ResExport1).LeftCol := TCol(Cols[Cols.Add(TCol.CreateCol(v.GeneratedRect.Left))])
                else
                  pXLSExport(v.ResExport1).LeftCol := TCol(Cols[k]);
                k := 0;
                while (k<Cols.Count) and not CEP(TCol(Cols[k]).X,v.GeneratedRect.Right) do Inc(k);
                if k>=Cols.Count then
                  pXLSExport(v.ResExport1).RightCol := TCol(Cols[Cols.Add(TCol.CreateCol(v.GeneratedRect.Right))])
                else
                  pXLSExport(v.ResExport1).RightCol := TCol(Cols[k]);

                k := rStart;
                while (k<Rows.Count) and not CEP(TRow(Rows[k]).Y,v.GeneratedRect.Top) do Inc(k);
                if k>=Rows.Count then
                  pXLSExport(v.ResExport1).TopRow := TRow(Rows[Rows.Add(TRow.CreateRow(v.GeneratedRect.Top,i))])
                else
                  pXLSExport(v.ResExport1).TopRow := TRow(Rows[k]);
                k := rStart;
                while (k<Rows.Count) and not CEP(TRow(Rows[k]).Y,v.GeneratedRect.Bottom) do Inc(k);
                if k>=Rows.Count then
                  pXLSExport(v.ResExport1).BottomRow := TRow(Rows[Rows.Add(TRow.CreateRow(v.GeneratedRect.Bottom,i))])
                else
                  pXLSExport(v.ResExport1).BottomRow := TRow(Rows[k]);
              end;
            Inc(i);
          end;
        //  Cols
        Cols.Sort(SortCols);
        //  Rows
        Rows.Sort(SortRows);

        //     Cols -  , Rows -  
        for j:=0 to Cols.Count-1 do
          TCol(Cols[j]).Index := j;
        for j:=0 to Rows.Count-1 do
          TRow(Rows[j]).Index := j;

        if VarIsEmpty(SH) then
          SH := WB.Sheets.Add(,WB.Sheets[WB.Sheets.Count]);
        if TprEndPage(EndPages[epStart]).PaperSize=0 then
          SH.PageSetup.PaperSize := xlPaperUser
        else
          SH.PageSetup.PaperSize := TprEndPage(EndPages[epStart]).PaperSize;
        SH.PageSetup.Orientation := XLSOrientation[TprEndPage(EndPages[epStart]).Orientation];
        SH.PageSetup.LeftMargin := 0; //       
        SH.PageSetup.TopMargin := 0;
        SH.PageSetup.RightMargin := 0;
        SH.PageSetup.BottomMargin := 0;
        SH.PageSetup.HeaderMargin := 0;
        SH.PageSetup.FooterMargin := 0;

        for j:=0 to Cols.Count-1 do
          begin
            if j=0 then
              SH.Columns[j+1].ColumnWidth := Min(MAX_EXCEL_COLUMN_WIDTH,KoefX*TCol(Cols[j]).X)
            else
              SH.Columns[j+1].ColumnWidth := Min(MAX_EXCEL_COLUMN_WIDTH,KoefX*(TCol(Cols[j]).X-TCol(Cols[j-1]).X));
          end;
        for j:=0 to Rows.Count-1 do
          begin
            r := TRow(Rows[j]);
            if j=0 then
              SH.Rows[j+1].RowHeight := Min(MAX_EXCEL_ROW_HEIGHT,KoefY*r.Y)
            else
              begin
                pr := TRow(Rows[j-1]);
                if r.PageIndex=pr.PageIndex then
                  SH.Rows[j+1].RowHeight := Min(MAX_EXCEL_ROW_HEIGHT,KoefY*(r.Y-pr.Y))
                else
                  begin
                    SH.Rows[j+1].RowHeight := Min(MAX_EXCEL_ROW_HEIGHT,KoefY*r.Y);
                    SH.HPageBreaks.Add(SH.Rows[j+1]);
                  end;
              end;
          end;

        //  
        j := epStart;
        while j<i do
          begin
            if IsExportPage(j) then
              begin
                UpdateProgressForm(Format(pCap1,[j+1,EndPagesCount]));
                ep := TprEndPage(EndPages[j]);
                for k:=0 to ep.VL.Count-1 do
                  begin
                    v := TprExObjRecVersion(ep.VL[k]);
                    pe := pXLSExport(v.ResExport1);
                    Range := SH.Range[SH.Cells[pe.TopRow.Index+2,pe.LeftCol.Index+2],SH.Cells[pe.BottomRow.Index+1,pe.RightCol.Index+1]];
                    Range.Merge;
                    v.ExportToXLS(Range);
                  end;
              end;
            Inc(j);
          end;
        ClearColsAndRows;
        SH := UnAssigned;
      end;
    WB.SaveAs(ExportFileName);
  except
    on E : Exception do
      begin
        ErrorsExists := true;
        if not (E is EActionCanceled) then
          raise;
      end;
  end;
finally
  CloseProgressForm;
  if pl<>nil then
    pl.Free;
  ClearColsAndRows;
  Cols.Free;
  Rows.Free;
  for i:=0 to EndPagesCount-1 do
    with TprEndPage(EndPages[i]) do
      for j:=0 to VL.Count-1 do
        begin
          FreeMem(TprExObjRecVersion(VL[j]).ResExport1);
          TprExObjRecVersion(VL[j]).ResExport1 := nil;
        end;
  if ErrorsExists then
    begin
      WB.Saved := true;
      Excel.Quit;
    end
  else
    begin
      if preoShowAfterGenerate in ExportOptions then
        begin
          if not (preoShowWhileGenerate in ExportOptions) then
            Excel.Visible := true;
          Excel.DisplayAlerts := true;
        end
      else
        begin
          WB.Saved := true;
          Excel.Quit;
        end;
    end;
end;
end;

initialization
  RegisterClass(TprHTitleBand);
  RegisterClass(TprHSummaryBand);
  RegisterClass(TprHPageHeaderBand);
  RegisterClass(TprHPageFooterBand);
  RegisterClass(TprHDetailBand);
  RegisterClass(TprHDetailHeaderBand);
  RegisterClass(TprHDetailFooterBand);
  RegisterClass(TprHGroupHeaderBand);
  RegisterClass(TprHGroupFooterBand);
  RegisterClass(TprVTitleBand);
  RegisterClass(TprVSummaryBand);
  RegisterClass(TprVPageHeaderBand);
  RegisterClass(TprVPageFooterBand);
  RegisterClass(TprVDetailBand);
  RegisterClass(TprVDetailHeaderBand);
  RegisterClass(TprVDetailFooterBand);
  RegisterClass(TprVGroupHeaderBand);
  RegisterClass(TprVGroupFooterBand);

  RegisterClass(TprPage);
  RegisterClass(TprMemoObj);
  RegisterClass(TprImageObj);
  RegisterClass(TprRichObj);
  RegisterClass(TprImageObj);

  RegisterClass(TprMemoObjRecVersion);
  RegisterClass(TprImageObjRecVersion);
  RegisterClass(TprRichObjRecVersion);

  prRegisterObj(TprMemoObj,
                TprMemoObjRec,
                TprReport,
                sMemoObjCaption,
                sMemoObjHint,
                'TprMemoEditorForm',
                'TprPrvMemoEditorForm');
  prRegisterObj(TprImageObj,
                TprImageObjRec,
                TprReport,
                sImageObjCaption,
                sImageObjHint,
                'TprImageEditorForm',
                'TprPrvImageEditorForm');
  prRegisterObj(TprRichObj,
                TprRichObjRec,
                TprReport,
                sRichObjCaption,
                sRichObjHint,
                'TprRichEditorForm',
                'TprPrvRichEditorForm');
  PaperInfo[0].Name := prLoadStr(sOtherPageSize);

finalization
//  if FRichEditModule <> 0 then FreeLibrary(FRichEditModule);
  
end.

