{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_BandLinks;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls, Pr_Utils, Buttons,

  pr_Common, pr_MultiLang;

type
  TprBandLinksForm = class(TprForm)
    PC: TPageControl;
    PLeft: TTabSheet;
    Label1: TLabel;
    LBResize: TListBox;
    CBResizeMode: TComboBox;
    bDelLink: TSpeedButton;
    prMLRes1: TprMLRes;
    procedure FormShow(Sender: TObject);
    procedure bDelLinkClick(Sender: TObject);
    procedure CBResizeModeChange(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    Band : TprBand;

    procedure UpdateObjLinksInfo(_Band : TprBand);
  end;

implementation

uses pr_CommonDesigner, pr_Strings;

{$R *.DFM}

procedure TprBandLinksForm.UpdateObjLinksInfo;

  procedure AddList(var o : TprObjs; LB : TListBox);
  var
    i : integer;
  begin
  LB.Clear;
  for i:=0 to o.Count-1 do
    LB.Items.AddObject(o[i].GetDesc,o[i]);
  if LB.Items.Count>0 then
    LB.ItemIndex:=0;
  end;

begin
Band:=_Band;
if Band=nil then
  begin
    Caption         :=prLoadStr(sNoBandSelected);
    PC.Visible      :=false;
    bDelLink.Enabled:=false;
  end
else
  begin
    Caption         :=Band.GetDrawDesignCaption;
    PC.Visible      :=true;
    bDelLink.Enabled:=true;

    AddList(Band.ResizeObjs,LBResize);
    CBResizeMode.ItemIndex:=integer(Band.ResizeMode);
  end;
end;

procedure TprBandLinksForm.FormShow(Sender: TObject);
begin
if fsModal in TForm(Owner).FormState then
  begin
    SetWindowPos(Handle, HWND_TOPMOST, 0, 0, 0, 0, SWP_NOMOVE +
      SWP_NOSIZE + SWP_NOACTIVATE + SWP_NOZORDER);

    SetWindowLong (Handle, GWL_HWNDPARENT, Longint(TForm(Owner).Handle));
  end;
end;

procedure TprBandLinksForm.bDelLinkClick(Sender: TObject);
begin
if LBResize.ItemIndex<0 then
  MBError(prLoadStr(sLinkNotSelected))
else
  begin
    TprCustomDesignerForm(Band.Report.DesignerForm).DrawLinks;

    Band.ResizeObjs.Remove(LBResize.Items.Objects[LBResize.ItemIndex]);
    LBResize.Items.Delete(LBResize.ItemIndex);
    if LBResize.Items.Count>0 then
      LBResize.ItemIndex:=0;

    TprCustomDesignerForm(Band.Report.DesignerForm).DrawLinks;
    Band.Report.TemplateChanged:=true;
  end;
end;

procedure TprBandLinksForm.CBResizeModeChange(Sender: TObject);
begin
Band.ResizeMode            :=TprBandResizeMode(CBResizeMode.ItemIndex);
Band.Report.TemplateChanged:=true;
end;

procedure TprBandLinksForm.FormCreate(Sender: TObject);
begin
LoadResImage(bDelLink.Glyph,'DELVERSION');

CBResizeMode.Items.Add(prLoadStr(sBandResizeNoChange));
CBResizeMode.Items.Add(prLoadStr(sBandResizeMaxBottom));
CBResizeMode.Items.Add(prLoadStr(sBandResizeMaxBottomInLinksList));
CBResizeMode.Items.Add(prLoadStr(sBandResizeMinBottomInLinksList));
end;

end.
