{******************************************}
{                                          }
{                 PReport v1.5             }
{                                          }
{ Copyright (c) 1999-2002 by Manuzin A.    }
{                                          }
{******************************************}

unit pr_BandEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Buttons, ComCtrls,

  pr_CommonDesigner, pr_Common, pr_MultiLang, pr_Strings, ExtCtrls;

type
  TprBandEditorForm = class(TprPropsForm)
    PC: TPageControl;
    PCommon: TTabSheet;
    Label1: TLabel;
    Label7: TLabel;
    EDName: TEdit;
    CBUseVerticalBands: TCheckBox;
    CBResizeMode: TComboBox;
    CBUseHorizontalBands: TCheckBox;
    PData: TTabSheet;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    EDDataSet: TComboBox;
    EDGroup: TComboBox;
    EDDetailBand: TComboBox;
    EDParent: TComboBox;
    PGroups: TTabSheet;
    bGroupUp: TSpeedButton;
    bGroupDown: TSpeedButton;
    LBGroups: TListBox;
    PChildBands: TTabSheet;
    bChildUp: TSpeedButton;
    bChildDown: TSpeedButton;
    LBChilds: TListBox;
    prMLRes1: TprMLRes;
    CBVisible: TCheckBox;
    PColumns: TTabSheet;
    Label6: TLabel;
    EDColCount: TEdit;
    UDColCount: TUpDown;
    Label8: TLabel;
    EDColDirection: TComboBox;
    POther: TTabSheet;
    CBPrintOnFirstPage: TCheckBox;
    CBReprintOnEachPage: TCheckBox;
    CBLinkToDetail: TCheckBox;
    CBStartNewPage: TCheckBox;
    Label9: TLabel;
    EDPrintWithBand: TComboBox;
    Bevel1: TBevel;
    Label10: TLabel;
    EDValid: TEdit;
    CBPrintAfterLastBandOnPage: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure LBGroupsClick(Sender: TObject);
    procedure LBChildsClick(Sender: TObject);
    procedure bGroupUpClick(Sender: TObject);
    procedure bGroupDownClick(Sender: TObject);
    procedure bChildUpClick(Sender: TObject);
    procedure bChildDownClick(Sender: TObject);
  private
    { Private declarations }
    function Obj : TprBand;
    
    procedure SetEnable;
    procedure UpdateButtons;
    procedure CopyToControls;
    procedure CopyFromControls;
  public
    { Public declarations }
    procedure DesignerSelectionChanged; override;

    procedure Apply; override; 
  end;

implementation

uses pr_DesignerFunctions;

{$R *.DFM}

procedure TprBandEditorForm.FormCreate(Sender: TObject);
begin
LoadResImage(bGroupUp.Glyph,'MOVEUP');
LoadResImage(bGroupDown.Glyph,'MOVEDOWN');
LoadResImage(bChildUp.Glyph,'MOVEUP');
LoadResImage(bChildDown.Glyph,'MOVEDOWN');

GetEnumNamesToStrings(TypeInfo(TprColDirectionType),integer(High(TprColDirectionType)),EDColDirection.Items);
CBResizeMode.Items.Add(prLoadStr(sBandResizeNoChange));
CBResizeMode.Items.Add(prLoadStr(sBandResizeMaxBottom));
CBResizeMode.Items.Add(prLoadStr(sBandResizeMaxBottomInLinksList));
CBResizeMode.Items.Add(prLoadStr(sBandResizeMinBottomInLinksList));
end;

procedure TprBandEditorForm.DesignerSelectionChanged;
begin
CopyToControls;
end;

procedure TprBandEditorForm.UpdateButtons;
begin
bGroupUp.Enabled  :=LBGroups.ItemIndex>0;
bGroupDown.Enabled:=LBGroups.ItemIndex<(LBGroups.Items.Count-1);
bChildUp.Enabled  :=LBChilds.ItemIndex>0;
bChildDown.Enabled:=LBChilds.ItemIndex<(LBChilds.Items.Count-1);
end;

procedure TprBandEditorForm.SetEnable;
var
  bt : TprBandType;
begin
if Designer.SelObjs.Count<0 then
  bt:=TprBandType(-1)
else
  bt:=TprBand(Designer.SelObjs[0]).BandType;

Label1.Enabled              :=Designer.SelObjs.Count=1;
EDName.Enabled              :=Designer.SelObjs.Count=1;
Label6.Enabled              :=bt in [bthDetail,bthDetailHeader,bthDetailFooter,bthGroupFooter,bthGroupHeader];
Label8.Enabled              :=bt in [bthDetail,bthDetailHeader,bthDetailFooter,bthGroupFooter,bthGroupHeader];
EDColCount.Enabled          :=bt in [bthDetail,bthDetailHeader,bthDetailFooter,bthGroupFooter,bthGroupHeader];
UDColCount.Enabled          :=bt in [bthDetail,bthDetailHeader,bthDetailFooter,bthGroupFooter,bthGroupHeader];
EDColDirection.Enabled      :=bt in [bthDetail,bthDetailHeader,bthDetailFooter,bthGroupFooter,bthGroupHeader];

CBUseVerticalBands.Enabled  :=bt in [bthDetail..bthGroupFooter];
CBUseHorizontalBands.Enabled:=bt in [btvDetail..btvGroupFooter];

Label9.Enabled              :=bt in [bthSummary,btvSummary];
EDPrintWithBand.Enabled     :=bt in [bthSummary,btvSummary];
CBPrintOnFirstPage.Enabled  :=bt in [bthPageHeader,bthPageFooter,btvPageHeader,btvPageFooter];
CBReprintOnEachPage.Enabled :=bt in [btvDetailHeader,bthDetailHeader];
CBLinkToDetail.Enabled      :=bt in [btvDetailHeader,btvDetailFooter,bthDetailHeader,bthDetailFooter,btvGroupHeader,btvGroupFooter,bthGroupHeader,bthGroupFooter];
CBStartNewPage.Enabled      :=bt in [bthGroupHeader,btvGroupHeader];
CBPrintAfterLastBandOnPage.Enabled :=bt in [bthPageFooter,btvPageFooter];

EDDataSet.Enabled           :=bt in [bthDetail,btvDetail];
Label2.Enabled              :=bt in [bthDetail,btvDetail];

Label3.Enabled              :=bt in [bthGroupHeader,bthGroupFooter,btvGroupHeader,btvGroupFooter];
EDGroup.Enabled             :=bt in [bthGroupHeader,bthGroupFooter,btvGroupHeader,btvGroupFooter];

Label4.Enabled              :=bt in [bthDetailHeader,bthDetailFooter,btvDetailHeader,btvDetailFooter];
EDDetailBand.Enabled        :=bt in [bthDetailHeader,bthDetailFooter,btvDetailHeader,btvDetailFooter];

Label5.Enabled              :=bt in [bthDetail,btvDetail];
EDParent.Enabled            :=bt in [bthDetail,btvDetail];
EDValid.Enabled             :=bt in [bthDetail,btvDetail];
Label10.Enabled             :=bt in [bthDetail,btvDetail];

LBGroups.Enabled            :=(Designer.SelObjs.Count=1) and (bt in [bthDetail,btvDetail]);
LBChilds.Enabled            :=(Designer.SelObjs.Count=1) and (bt in [bthDetail,btvDetail]);
end;

procedure TprBandEditorForm.CopyToControls;
var
  b : TprBand;
  i : integer;
begin
SetEnable;

LBGroups.Items.Clear;
LBChilds.Items.Clear;
EDDataSet.Items.Clear;
EDGroup.Items.Clear;
EDDetailBand.Items.Clear;
EDParent.Items.Clear;
EDPrintWithBand.Items.Clear;

if (Designer.SelObjs.Count=1) and
   (TprBand(Designer.SelObjs[0]).BandType in [bthDetail,btvDetail]) then
  begin
    b:=TprBand(Designer.SelObjs[0]);
    case b.BandType of
      btvDetail:
        begin
          with TprCustomVDetailBand(b) do
            begin
              for i:=0 to Groups.Count-1 do
                LBGroups.Items.AddObject(Groups[i].Name,Groups[i]);
              if LBGroups.Items.Count>0 then
                LBGroups.ItemIndex:=0;

              for i:=0 to Bands.Count-1 do
                if Bands[i].BandType in [btvDetail] then
                  LBChilds.Items.AddObject(Bands[i].Name,Bands[i]);
              if LBChilds.Items.Count>0 then
                LBChilds.ItemIndex:=0;
            end;
        end;
      bthDetail:
        begin
          with TprCustomHDetailBand(b) do
            begin
              for i:=0 to Groups.Count-1 do
                LBGroups.Items.AddObject(Groups[i].Name,Groups[i]);
              if LBGroups.Items.Count>0 then
                LBGroups.ItemIndex:=0;

              for i:=0 to Bands.Count-1 do
                if Bands[i].BandType in [bthDetail] then
                  LBChilds.Items.AddObject(Bands[i].Name,Bands[i]);
              if LBChilds.Items.Count>0 then
                LBChilds.ItemIndex:=0;
            end;
        end;
    end;
  end;

b:=TprBand(Designer.SelObjs[0]);
if b.BandType in [bthGroupHeader,bthGroupFooter,btvGroupHeader,btvGroupFooter] then
  begin
    for i:=0 to b.Page.Report.Groups.Count-1 do
      if (b.Page.Report.Groups[i].DetailBand<>nil) and
         ((b.BandType in [bthGroupHeader,bthGroupFooter]) and
          (b.Page.Report.Groups[i].DetailBand.BandType in [bthDetail])) or
         ((b.BandType in [btvGroupHeader,btvGroupFooter]) and
          (b.Page.Report.Groups[i].DetailBand.BandType in [btvDetail])) then
        EDGroup.Items.AddObject(b.Page.Report.Groups[i].Name,
                                b.Page.Report.Groups[i]);
  end;

if b.BandType in [bthDetailHeader,bthDetailFooter,btvDetailHeader,btvDetailFooter] then
  begin
    for i:=0 to b.Page.Bands.Count-1 do
      if ((b.BandType in [bthDetailHeader,bthDetailFooter]) and
          (b.Page.Bands[i].BandType in [bthDetail])) or
         ((b.BandType in [btvDetailHeader,btvDetailFooter]) and
          (b.Page.Bands[i].BandType in [btvDetail])) then
        EDDetailBand.Items.AddObject(b.Page.Bands[i].Name,b.Page.Bands[i]);
  end;

if b.BandType in [bthDetail,btvDetail] then
  begin
    for i:=0 to b.Page.Bands.Count-1 do
      if b<>b.Page.Bands[i] then
        begin
          if ((b.BandType in [bthDetail]) and (b.Page.Bands[i].BandType in [bthDetail])) or
             ((b.BandType in [btvDetail]) and (b.Page.Bands[i].BandType in [btvDetail])) then
            EDParent.Items.AddObject(b.Page.Bands[i].Name,b.Page.Bands[i]);
        end;
  end;

if b.BandType in [bthSummary,btvSummary] then
  begin
    EDPrintWithBand.Items.AddObject(prLoadStr(NullPointerString),nil);
    for i:=0 to b.Page.Bands.Count-1 do
      if b<>b.Page.Bands[i] then
        begin
          if ((b.BandType in [bthSummary]) and (b.Page.Bands[i].BandType in [bthTitle..bthGroupFooter])) or
             ((b.BandType in [btvSummary]) and (b.Page.Bands[i].BandType in [btvTitle..btvGroupFooter])) then
            EDPrintWithBand.Items.AddObject(b.Page.Bands[i].Name,b.Page.Bands[i]);
        end;
  end;

b.Page.Report.GetAvailableDataSets(EDDataSet.Items);

if Designer.SelObjs.Count=1 then
  EDName.Text := TprBand(Designer.SelObjs[0]).Name
else
  EDName.Text := '';
CBResizeMode.ItemIndex := prGetPropDef(Designer.SelObjs,'ResizeMode',-1);
CBPrintOnFirstPage.State := prGetPropDefBool(Designer.SelObjs,'PrintOnFirstPage');
CBReprintOnEachPage.State := prGetPropDefBool(Designer.SelObjs,'ReprintOnEachPage');
CBLinkToDetail.State := prGetPropDefBool(Designer.SelObjs,'LinkToDetail');
CBStartNewPage.State := prGetPropDefBool(Designer.SelObjs,'StartNewPage');
CBPrintAfterLastBandOnPage.State := prGetPropDefBool(Designer.SelObjs,'PrintAfterLastBandOnPage');
UDColCount.Position := prGetPropDef(Designer.SelObjs,'ColCount',-1);
EDColDirection.ItemIndex := prGetPropDef(Designer.SelObjs,'ColDirection',-1);
CBUseVerticalBands.State := prGetPropDefBool(Designer.SelObjs,'UseVerticalBands');
CBUseHorizontalBands.State := prGetPropDefBool(Designer.SelObjs,'UseHorizontalBands');
CBVisible.State := prGetPropDefBool(Designer.SelObjs,'Visible');

EDPrintWithBand.ItemIndex := EDPrintWithBand.Items.IndexOfObject(pointer(integer(prGetPropDef(Designer.SelObjs,'PrintWithBand',-1))));

EDDataSet.ItemIndex := EDDataSet.Items.IndexOf(prGetPropDef(Designer.SelObjs,'DatasetName',''));
EDGroup.ItemIndex := EDGroup.Items.IndexOfObject(pointer(integer(prGetPropDef(Designer.SelObjs,'Group',-1))));
EDDetailBand.ItemIndex := EDDetailBand.Items.IndexOfObject(pointer(integer(prGetPropDef(Designer.SelObjs,'DetailBand',-1))));
EDParent.ItemIndex := EDParent.Items.IndexOfObject(pointer(integer(prGetPropDef(Designer.SelObjs,'ParentDetail',-1))));
EDValid.Text := prGetPropDef(Designer.SelObjs,'Valid','');

UpdateButtons;
end;

procedure TprBandEditorForm.CopyFromControls;
begin
if EDName.Enabled then
  Obj.Name:=EDName.Text;

prSetProp(Designer.SelObjs,'ResizeMode',CBResizeMode.ItemIndex,CBResizeMode.ItemIndex=-1);
prSetProp(Designer.SelObjs,'PrintOnFirstPage',CBPrintOnFirstPage.State=cbChecked,CBPrintOnFirstPage.State=cbGrayed);
prSetProp(Designer.SelObjs,'ReprintOnEachPage',CBReprintOnEachPage.State=cbChecked,CBReprintOnEachPage.State=cbGrayed);
prSetProp(Designer.SelObjs,'LinkToDetail',CBLinkToDetail.State=cbChecked,CBLinkToDetail.State=cbGrayed);
prSetProp(Designer.SelObjs,'StartNewPage',CBStartNewPage.State=cbChecked,CBStartNewPage.State=cbGrayed);
prSetProp(Designer.SelObjs,'PrintAfterLastBandOnPage',CBPrintAfterLastBandOnPage.State=cbChecked,CBPrintAfterLastBandOnPage.State=cbGrayed);

prSetProp(Designer.SelObjs,'ColCount',UDColCount.Position,UDColCount.Position=-1);
prSetProp(Designer.SelObjs,'ColDirection',EDColDirection.ItemIndex,EDColDirection.ItemIndex=-1);
prSetProp(Designer.SelObjs,'UseVerticalBands',CBUseVerticalBands.State=cbChecked,CBUseVerticalBands.State=cbGrayed);
prSetProp(Designer.SelObjs,'UseHorizontalBands',CBUseHorizontalBands.State=cbChecked,CBUseHorizontalBands.State=cbGrayed);
prSetProp(Designer.SelObjs,'Visible',CBVisible.State=cbChecked,CBVisible.State=cbGrayed);

prSetProp(Designer.SelObjs,'DatasetName',prGetListItemString(EDDataSet),EDDataSet.ItemIndex=-1);
prSetProp(Designer.SelObjs,'Group',integer(prGetListItemObject(EDGroup)),EDGroup.ItemIndex=-1);
prSetProp(Designer.SelObjs,'PrintWithBand',integer(prGetListItemObject(EDPrintWithBand)),EDPrintWithBand.ItemIndex=-1);
prSetProp(Designer.SelObjs,'DetailBand',integer(prGetListItemObject(EDDetailBand)),EDDetailBand.ItemIndex=-1);
prSetProp(Designer.SelObjs,'ParentDetail',integer(prGetListItemObject(EDParent)),EDParent.ItemIndex=-1);
prSetProp(Designer.SelObjs,'Valid',EDValid.Text,false);
end;

procedure TprBandEditorForm.LBGroupsClick(Sender: TObject);
begin
UpdateButtons;
end;

procedure TprBandEditorForm.LBChildsClick(Sender: TObject);
begin
UpdateButtons;
end;

function TprBandEditorForm.Obj : TprBand;
begin
if Designer.SelObjs.Count>0 then
  Obj:=TprBand(Designer.SelObjs[0])
else
  Obj:=nil;
end;

procedure TprBandEditorForm.bGroupUpClick(Sender: TObject);
begin
if LBGroups.ItemIndex>0 then
  begin
    LBGroups.Items.Exchange(LBGroups.ItemIndex,LBGroups.ItemIndex-1);
    case Obj.BandType of
      bthDetail:
        TprCustomHDetailBand(Obj).Groups.Exchange(LBGroups.ItemIndex,LBGroups.ItemIndex-1);
      btvDetail:
        TprCustomVDetailBand(Obj).Groups.Exchange(LBGroups.ItemIndex,LBGroups.ItemIndex-1);
    end;
    LBGroups.ItemIndex:=LBGroups.ItemIndex-1;
    UpdateButtons;
    Designer.UpdateCurrentPage;
  end;
end;

procedure TprBandEditorForm.bGroupDownClick(Sender: TObject);
begin
if LBGroups.ItemIndex<LBGroups.Items.Count-1 then
  begin
    LBGroups.Items.Exchange(LBGroups.ItemIndex,LBGroups.ItemIndex+1);
    case Obj.BandType of
      bthDetail:
        TprCustomHDetailBand(Obj).Groups.Exchange(LBGroups.ItemIndex,LBGroups.ItemIndex+1);
      btvDetail:
        TprCustomVDetailBand(Obj).Groups.Exchange(LBGroups.ItemIndex,LBGroups.ItemIndex+1);
    end;
    LBGroups.ItemIndex:=LBGroups.ItemIndex+1;
    UpdateButtons;
    Designer.UpdateCurrentPage;
  end;
end;

procedure TprBandEditorForm.bChildUpClick(Sender: TObject);
var
  i1,i2 : integer;
begin
if LBChilds.ItemIndex>0 then
  begin
    LBChilds.Items.Exchange(LBChilds.ItemIndex,LBChilds.ItemIndex-1);
    case Obj.BandType of
      bthDetail:
        with TprCustomHDetailBand(Obj) do
          begin
            i1:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex]);
            i2:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex+1]);
            Bands.Exchange(i1,i2);
          end;
      btvDetail:
        with TprCustomVDetailBand(Obj) do
          begin
            i1:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex]);
            i2:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex+1]);
            Bands.Exchange(i1,i2);
          end;
    end;
    UpdateButtons;
    Designer.UpdateCurrentPage;
  end;
end;

procedure TprBandEditorForm.bChildDownClick(Sender: TObject);
var
  i1,i2 : integer;
begin
if LBChilds.ItemIndex<LbChilds.Items.Count-1 then
  begin
    LBChilds.Items.Exchange(LBChilds.ItemIndex,LBChilds.ItemIndex+1);
    case Obj.BandType of
      bthDetail:
        with TprCustomHDetailBand(Obj) do
          begin
            i1:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex]);
            i2:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex-1]);
            Bands.Exchange(i1,i2);
          end;
      btvDetail:
        with TprCustomVDetailBand(Obj) do
          begin
            i1:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex]);
            i2:=Bands.IndexOf(LBChilds.Items.Objects[LBChilds.ItemIndex-1]);
            Bands.Exchange(i1,i2);
          end;
    end;
    UpdateButtons;
    Designer.UpdateCurrentPage;
  end;
end;

procedure TprBandEditorForm.Apply;
begin
CopyFromControls;
Designer.UpdateCurrentPage;
inherited;
end;

end.
 