unit ftpolylist; {Test application for TPolyMorphicList}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  PolyList, StdCtrls;

type
  //test objects
  TEventGetString=Procedure(Sender:TObject;var Value:String) of object; //test event

  TMyPersistent1=Class(TPersistent)
  private
    fProp1:String;
    fProp2:integer;
    fOnGetProp1:TEventGetString;
    Function GetProp1:String;
  public
    Constructor Create;
  published
    Property Prop1:String  read GetProp1 write fProp1;
    Property Prop2:integer read fProp2 write fProp2;
    Property OnGetProp1:TEventGetString read fOnGetProp1 write fOnGetProp1;
  end;

  TMyPersistent2=Class(TMyPersistent1)
  private
    fProp3:String;
  public
    Constructor Create;
  published
    Property Prop3:String read fProp3 write fProp3;
  end;

  TMyComponent=class(TComponent)
  private
    fProp4:String;
  public
    Constructor Create(aOwner:TComponent); override;
  published
    Property Prop4:String read fProp4 write fProp4;
  end;

  TForm1 = class(TForm)
    Button1: TButton;
    Button2: TButton;
    Memo1: TMemo;
    PolyList1: TPolymorphicList;
    Label1: TLabel;
    EdProp1: TEdit;
    Button3: TButton;
    Button4: TButton;
    BWrite: TButton;
    BRead: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure PolyList1CreatePersistent(Sender: TObject;
      C: TPersistentClass; var aObj: TPersistent);
    procedure Button4Click(Sender: TObject);
    procedure BWriteClick(Sender: TObject);
    procedure BReadClick(Sender: TObject);
  private
    procedure Form1GetProp1(Sender:TObject;var Value:String);
  public
  end;

var
  Form1: TForm1;

implementation
Uses
  fPolyList;

{$R *.DFM}

{ TMyPersistent1 }
constructor TMyPersistent1.Create;
begin
  inherited;
  fProp1:='Comp1';
  fProp2:=0;
  fOnGetProp1:=nil;
end;

function TMyPersistent1.GetProp1: String;
begin
  Result:=fProp1;
  if Assigned(fOnGetProp1) then fOnGetProp1(Self,Result);
end;

{ TMyPersistent2 }

constructor TMyPersistent2.Create;
begin
  inherited;
  fProp1:='Comp2';
  fProp3:='';
end;

{ TComp4 }

constructor TMyComponent.Create(aOwner: TComponent);
begin
  inherited Create(aOwner);
  fProp4:='Prop4';
end;

{ TForm1 }
procedure TForm1.Button1Click(Sender: TObject);
var aC1:TMyPersistent1; aC2:TMyPersistent2; aC3:TMyComponent;
    //B:TButton;

    Procedure SetCompName(aComp:TComponent;const Prefix:String);
    var Ok:boolean; i:integer;
    begin
      Ok:=FALSE;
      i:=1;
      repeat
        try
          aComp.Name:=Prefix+IntToStr(i); //duplicate comp names are not allowed
          Ok:=TRUE;
        except
          inc(i);
        end;
      until ok;
    end;

begin
  aC1:=TMyPersistent1.Create;
  aC1.Prop1:='Property 1.1';
  aC1.Prop2:=69;
  //Known Bug: Events are not handled correctly
  //aC1.OnGetProp1:=Form1GetProp1;
  PolyList1.Add(aC1);

  aC2:=TMyPersistent2.Create;
  aC2.Prop1:='Property 2.1';
  aC2.Prop2:=24;
  aC2.Prop3:='Property 2.3';
  PolyList1.Add(aC2);

  aC3:=TMyComponent.Create(Self);
  SetCompName(aC3,'MyComponent');
  aC3.Prop4:='My component Prop4';
  PolyList1.Add(aC3);

  //Known Bug: did not initialize the Parent property correctly
  //B:=TButton.Create(Self);
  //B.Parent:=Self;
  //SetCompName(B,'RTBtn');
  //B.Caption:='RT Btn';
  //B.Top:=100;
  //B.Left:=100;
  //PolyList1.Add(B);
end;

procedure TForm1.Form1GetProp1(Sender:TObject;var Value:String);
begin
  Value:=EdProp1.Text;
end;

//show objects
procedure TForm1.Button2Click(Sender: TObject);
var i:integer; aC:TPersistent;
begin
  Memo1.Lines.Clear;
  for i:=0 to PolyList1.Count-1 do
    begin
      aC:=PolyList1.Items[i];
      Memo1.Lines.Add('Class:'+aC.ClassName); //show class name
      if aC is TMyPersistent1 then            //show poroperties
        begin
          Memo1.Lines.Add('Prop1:'+(aC as TMyPersistent1).Prop1);
          Memo1.Lines.Add('Prop2:'+IntToStr((aC as TMyPersistent1).Prop2));
        end;
      if aC is TMyPersistent2 then Memo1.Lines.Add('Prop3:'+(aC as TMyPersistent2).Prop3);
      if aC is TMyComponent then Memo1.Lines.Add('Prop4:'+(aC as TMyComponent).Prop4);
      Memo1.Lines.Add('----------------------');
    end;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  PolyList1.Clear;
end;

procedure TForm1.PolyList1CreatePersistent(Sender: TObject;
  C: TPersistentClass; var aObj:TPersistent);
begin
  if C=TMyPersistent1 then aObj:=TMyPersistent1.Create
  else if C=TMyPersistent2 then aObj:=TMyPersistent2.Create;
  //no need to test TMyComponent, since its a component
  //and the correct Create is called automaticaly
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  PolyList1.Edit;
end;

procedure TForm1.BWriteClick(Sender: TObject);
var St:TFileStream;
begin
  St:=TFileStream.Create('test.st',fmCreate);
  try
    PolyList1.SaveToStream(st);
  finally
    St.Free;
  end;
end;

procedure TForm1.BReadClick(Sender: TObject);
var St:TFileStream;
begin
  St:=TFileStream.Create('test.st',fmOpenRead);
  try
    PolyList1.Clear;
    PolyList1.ReadFromStream(st);
  finally
    St.Free;
  end;
end;

initialization
  //remember to Register all classes you define, or the
  //registration system will not recognize the class name
  RegisterClasses([TMyPersistent1,TMyPersistent2,TMyComponent,TButton]);
end.

