unit fPolyList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls,ComCtrls,TypInfo, ToolIntf,ExptIntf,ImgList,PolyList, Buttons;

type
  TFormEditPolymorphicList = class(TForm)
    TVListImages: TImageList;
    PCPolyList: TPageControl;
    TabList: TTabSheet;
    TVList: TTreeView;
    TVProperties: TTreeView;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    LPropKind: TLabel;
    LPropValue: TLabel;
    TabClasses: TTabSheet;
    TVClasses: TTreeView;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    procedure FormCreate(Sender: TObject);
    procedure TVListClick(Sender: TObject);
    procedure TVPropertiesClick(Sender: TObject);
  private
    fPolyList:TPolymorphicList;
    fCurrentObject:TPersistent;
    Procedure SetPolyList(value:TPolymorphicList);
    Procedure PopulateTVList;
  public
    Property PolyList:TPolymorphicList read fPolyList write SetPolyList;
  end;

var
  FormEditPolymorphicList: TFormEditPolymorphicList;

implementation

{$R *.DFM}

procedure TFormEditPolymorphicList.FormCreate(Sender: TObject);
begin
  fPolyList:=nil;
  fCurrentObject:=nil;
end;

procedure TFormEditPolymorphicList.SetPolyList(value: TPolymorphicList);
begin
  if (value<>fPolyList) then
    begin
      fPolyList:=value;
      PopulateTVList;
    end;
end;

(*
Procedure TFormEditPolymorphicList.PopulateTVClasses;
var
  i:integer;
  aNode:TTreeNode;
  aObj:TPersistent;
begin
  TVClasses.Items.BeginUpdate;
  TVClasses.Items.Clear;
  try
    for i:=0 to ClassList.Count-1 do
      begin
        aObj:=fPolyList.Items[i];
        aNode:=TVClasses.Items.AddChild(nil,aObj.ClassName);
        aNode.Data:=aObj;
        if aObj.InheritsFrom(TComponent) then aNode.ImageIndex:=1 {(C)}
          else aNode.ImageIndex:=0; {(P)}
        aNode.SelectedIndex:=aNode.ImageIndex+2;
      end;
  finally
    TVClasses.Items.EndUpdate;
  end;
end;
*)

Procedure TFormEditPolymorphicList.PopulateTVList;
var
  i:integer;
  aNode:TTreeNode;
  aObj:TPersistent;
begin
  TVList.Items.BeginUpdate;
  TVList.Items.Clear;
  try
    if Assigned(fPolyList) then for i:=0 to fPolyList.Count - 1 do
      begin
        aObj:=fPolyList.Items[i];
        aNode:=TVList.Items.AddChild(nil,aObj.ClassName);
        aNode.Data:=aObj;
        if aObj.InheritsFrom(TComponent) then aNode.ImageIndex:=1 {(C)}
          else aNode.ImageIndex:=0; {(P)}
        aNode.SelectedIndex:=aNode.ImageIndex+2;
      end;
  finally
    TVList.Items.EndUpdate;
  end;
end;

procedure TFormEditPolymorphicList.TVListClick(Sender: TObject);
var
  i:integer;
  aNode :TTreeNode;
  aClassName:String;
  ClassTypeInfo:PTypeInfo;
  ClassTypeData:PTypeData;
  Sz:integer;
  PropInfo:PPropInfo;
  PropList:PPropList;
begin
  LPropKind.Caption:='';
  LPropValue.Caption:='';
  TVProperties.Items.BeginUpdate;
  TVProperties.Items.Clear;
  try
    aNode:=TVList.Selected;
    if not Assigned(aNode) then exit;
    aClassName:=aNode.Text;
    fCurrentObject:=aNode.Data;
    ClassTypeInfo:=fCurrentObject.ClassInfo;
    ClassTypeData:=GetTypeData(ClassTypeInfo);
    if ClassTypeData.PropCount<>0 then
      begin
        Sz:=SizeOf(PropInfo)*ClassTypeData.PropCount; //calc the size of the property list
        GetMem(PropList,Sz);
        try
          GetPropInfos(ClassTypeInfo,PropList);
          for i:=0 to ClassTypeData.PropCount-1 do
            begin
              PropInfo:=PropList[i];
              TVProperties.Items.AddChild(nil,PropInfo^.Name);
            end;
        finally
          FreeMem(PropList,Sz);
        end;
      end;
  finally
    TVProperties.Items.EndUpdate;
  end;
end;

procedure TFormEditPolymorphicList.TVPropertiesClick(Sender: TObject);
var
  i:integer;
  aNode :TTreeNode;
  ClassTypeInfo:PTypeInfo;
  ClassTypeData:PTypeData;
  Sz:integer;
  PropInfo:PPropInfo;
  PropList:PPropList;
  S:String;
begin
  LPropKind.Caption:='';
  LPropValue.Caption:='';
  aNode:=TVProperties.Selected;
  if not Assigned(aNode) then exit;
  ClassTypeInfo:=fCurrentObject.ClassInfo;
  ClassTypeData:=GetTypeData(ClassTypeInfo);
  if ClassTypeData.PropCount<>0 then
    begin
      Sz:=SizeOf(PropInfo)*ClassTypeData.PropCount; //calc the size of the property list
      GetMem(PropList,Sz);
      try
        GetPropInfos(ClassTypeInfo,PropList);
        for i:=0 to ClassTypeData.PropCount-1 do
          begin
            PropInfo:=PropList[i];
            if (aNode.Text=PropInfo^.Name) then
              begin
                LPropKind.Caption:=GetEnumName(TypeInfo(TTypeKind),Ord(PropInfo^.PropType^.Kind));
                case PropInfo^.PropType^.Kind of
                  tkInteger,
                  tkChar,
                  tkSet,
                  tkEnumeration: S:=IntToStr(GetOrdProp(fCurrentObject,PropInfo));
                  tkFloat: S:=FloatToStr(GetFloatProp(fCurrentObject,PropInfo));
                  tkString, tkLString, tkWString:
                    S:=GetStrProp(fCurrentObject,PropInfo);
                  tkClass:   S:='class';
                  tkMethod:  S:='method';
                  tkVariant: S:='variant';  //could be better here...
                else
                  S:='?';
                end;
                LPropValue.Caption:=S;
                break;
              end;
          end;
      finally
        FreeMem(PropList,Sz);
      end;
    end;
end;

end.
