{*************************************************************}
{            TPasswordEdit Component for Delphi 2+            }
{ Version: 1.3                                                }
{ Created: August, 31, 2000                                   }
{ Copyright  2000 Andrzej Maliszewski                        }
{*************************************************************}
{ Author: Andrzej "Aragorn" Maliszewski                       }
{ E-Mail: andrzejm@hektor.umcs.lublin.pl                      }
{ ICQ#    47968525                                            }
{*************************************************************}
{ This component is used to entering password. It is          }
{ protected against reading password by WM_GETTEXT message or }
{ changing PasswordChar by EM_SETPASSWORDCHAR message.        }
{ Software like GetPass (Copyright  1999 Luis Rodrigues,     }
{ LFRodrigues@mail.pt) is useless with this control.          }
{ I did not attached any demo program, you can check it with  }
{ GetPass (http:\\delphi.icm.edu.pl\ftp\tools\getpass.zip).   }
{ Tested with D4 & D5, but I think it should work with        }
{ earlier versions too.                                       }
{*************************************************************}
{ Properties:                                                 }
{ FalsePassword: string - contains text that will be sent     }
{   to application trying to read password                    }
{ AllowPasswordCharChange: boolean - switches on/off          }
{   protection against changing PasswordChar                  }
{ AllowPasswordRead: boolean - switches on/off protection     }
{   against reading password                                  }
{*************************************************************}
{ Any questions, comments or bug reports will be welcome.     }
{*************************************************************}
{                     IMPORTANT NOTE:                         }
{ This software is provided 'as-is', without any express or   }
{ implied warranty. In no event will the author be held       }
{ liable for any damages arising from the use of this         }
{ software.                                                   }
{ Permission is granted to anyone to use this software for    }
{ any purpose, including commercial applications, and to      }
{ alter it and redistribute it freely, subject to the         }
{ following restrictions:                                     }
{ 1. The origin of this software must not be misrepresented,  }
{    you must not claim that you wrote the original software. }
{    If you use this software in a product, an acknowledgment }
{    in the product documentation would be appreciated but is }
{    not required.                                            }
{ 2. Altered source versions must be plainly marked as such,  }
{    and must not be misrepresented as being the original     }
{    software.                                                }
{ 3. This notice may not be removed or altered from any       }
{    source distribution.                                     }
{*************************************************************}

unit PassEdit;

interface

uses
  Classes, StdCtrls, Messages, SysUtils, Controls, Windows;

type
  TPasswordEdit = class(TEdit)
  private
    FFalsePassword: TCaption;
    FAllowPasswordRead: Boolean;
    FAllowPasswordCharChange: Boolean;
    function GetPasswordChar: Char;
    function GetText: TCaption;
    procedure SetPasswordChar(const Value: Char);
    procedure SetText(const Value: TCaption);
  public
    constructor Create(AOwner: TComponent); override;
    procedure DefaultHandler(var Message); override;
  published
    property AllowPasswordCharChange: Boolean read FAllowPasswordCharChange write FAllowPasswordCharChange;
    property AllowPasswordRead: Boolean read FAllowPasswordRead write FAllowPasswordRead;
    property PasswordChar: Char read GetPasswordChar write SetPasswordChar default '*';
    property FalsePassword: TCaption read FFalsePassword write FFalsePassword;
    property Text: TCaption read GetText write SetText;
  end;

procedure Register;

implementation

constructor TPasswordEdit.Create(AOwner: TComponent);
begin
  AllowPasswordCharChange := true;
  AllowPasswordRead := true;
  inherited Create(AOwner);
  AllowPasswordCharChange := false;
  AllowPasswordRead := false;
  PasswordChar := '*';
end;

procedure TPasswordEdit.SetPasswordChar(const Value: Char);
var
  OldAPCC, OldAPR: boolean;
begin
  OldAPCC := FAllowPasswordCharChange;
  OldAPR := FAllowPasswordRead;
  FAllowPasswordCharChange := true;
  FAllowPasswordRead := true;
  if HandleAllocated then
    inherited PasswordChar := Char(Sendmessage(Handle, EM_GETPASSWORDCHAR, 0, 0));
  inherited PasswordChar := Value;
  FAllowPasswordCharChange := OldAPCC;
  FAllowPasswordRead := OldAPR;
end;

function TPasswordEdit.GetPasswordChar: Char;
begin
if HandleAllocated then
  Result := Char(Sendmessage(Handle, EM_GETPASSWORDCHAR, 0, 0))
else
  Result := inherited PasswordChar;
end;

procedure TPasswordEdit.SetText(const Value: TCaption);
begin
  inherited Text := Value;
end;

function TPasswordEdit.GetText: TCaption;
var
  OldAPCC, OldAPR: boolean;
begin
  OldAPCC := FAllowPasswordCharChange;
  OldAPR := FAllowPasswordRead;
  FAllowPasswordCharChange := true;
  FAllowPasswordRead := true;
  Result := inherited Text;
  FAllowPasswordCharChange := OldAPCC;
  FAllowPasswordRead := OldAPR;
end;

procedure TPasswordEdit.DefaultHandler(var Message);
var
  P: PChar;
begin
if (csDesigning in ComponentState) or (csCreating in ControlState) then
  inherited
else
  with TMessage(Message) do
    case msg of
      EM_SETPASSWORDCHAR: if FAllowPasswordCharChange then
        inherited;
      WM_GETTEXT: if FAllowPasswordRead then inherited
      else begin
        P := PChar(FFalsePassword);
        Result := StrLen(StrLCopy(PChar(LParam), P, WParam - 1));
      end;
      WM_GETTEXTLENGTH: if FAllowPasswordRead then inherited
        else
          if PChar(FFalsePassword) = nil then Result := 0
          else Result := StrLen(PChar(FFalsePassword));
      else
        inherited;
    end
end;

procedure Register;
begin
  RegisterComponents('Aragorn', [TPasswordEdit]);
end;

end.
