// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'OrtusShellExplorer.pas' rev: 5.00

#ifndef OrtusShellExplorerHPP
#define OrtusShellExplorerHPP

#pragma delphiheader begin
#pragma option push -w-
#pragma option push -Vx
#include <Menus.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <OrtusShellChangeNotifier.hpp>	// Pascal unit
#include <OrtusShellGlobal.hpp>	// Pascal unit
#include <ActiveX.hpp>	// Pascal unit
#include <ShlObj.hpp>	// Pascal unit
#include <ShellAPI.hpp>	// Pascal unit
#include <TypInfo.hpp>	// Pascal unit
#include <ImgList.hpp>	// Pascal unit
#include <Commctrl.hpp>	// Pascal unit
#include <ComCtrls.hpp>	// Pascal unit
#include <StdCtrls.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------
#include <oleidl.h>
#include <systobj.h>
DECLARE_DINTERFACE_TYPE(IDropTarget)

namespace Ortusshellexplorer
{
//-- type declarations -------------------------------------------------------
#pragma option push -b-
enum TOrtusShellOleDragEffect { deCopy, deMove, deLink };
#pragma option pop

typedef Set<TOrtusShellOleDragEffect, deCopy, deLink>  TOrtusShellOleDragEffects;

#pragma option push -b-
enum TOrtusShellOleDropEffect { deDefault, deCopyOnly, deMoveOnly, deLinkOnly };
#pragma option pop

#pragma option push -b-
enum TOrtusShellOleDropResult { drNone, drCopy, drMove, drLink };
#pragma option pop

class DELPHICLASS TOrtusShellItem;
class PASCALIMPLEMENTATION TOrtusShellItem : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	void *FAbsolutePIDL;
	void *FRelativePIDL;
	_di_IShellFolder FShellFolder;
	AnsiString __fastcall GetDisplayName();
	bool __fastcall GetIsFile(void);
	bool __fastcall GetIsFolder(void);
	AnsiString __fastcall GetPathName();
	
public:
	__fastcall TOrtusShellItem(void * AbsolutePIDL);
	__fastcall virtual ~TOrtusShellItem(void);
	__property void * AbsolutePIDL = {read=FAbsolutePIDL};
	__property AnsiString DisplayName = {read=GetDisplayName};
	__property bool IsFile = {read=GetIsFile, nodefault};
	__property bool IsFolder = {read=GetIsFolder, nodefault};
	__property AnsiString PathName = {read=GetPathName};
	__property void * RelativePIDL = {read=FRelativePIDL};
	__property _di_IShellFolder ShellFolder = {read=FShellFolder};
};


typedef DynamicArray<TOrtusShellItem* >  OrtusShellExplorer__3;

class DELPHICLASS TOrtusShellItems;
class PASCALIMPLEMENTATION TOrtusShellItems : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	Classes::TStringList* FDisplayNames;
	DynamicArray<TOrtusShellItem* >  FItems;
	_di_IShellFolder FParentShellFolder;
	Classes::TStringList* FPathNames;
	int __fastcall GetCount(void);
	Classes::TStringList* __fastcall GetDisplayNames(void);
	TOrtusShellItem* __fastcall GetItem(int Idx);
	Classes::TStringList* __fastcall GetPathNames(void);
	
protected:
	int __fastcall Add(TOrtusShellItem* Item);
	void __fastcall Clear(void);
	
public:
	__fastcall TOrtusShellItems(void);
	__fastcall virtual ~TOrtusShellItems(void);
	bool __fastcall CopyToClipboard(void);
	bool __fastcall CreateShortcut(void);
	bool __fastcall CutToClipboard(void);
	bool __fastcall Delete(void);
	bool __fastcall Open(void);
	bool __fastcall ExecuteCommand(const AnsiString Command);
	__property int Count = {read=GetCount, nodefault};
	__property Classes::TStringList* DisplayNames = {read=GetDisplayNames};
	__property TOrtusShellItem* Items[int Idx] = {read=GetItem/*, default*/};
	__property _di_IShellFolder ParentShellFolder = {read=FParentShellFolder};
	__property Classes::TStringList* PathNames = {read=GetPathNames};
};


class DELPHICLASS TOrtusShellOleDragDropInfo;
class PASCALIMPLEMENTATION TOrtusShellOleDragDropInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
private:
	TOrtusShellOleDropResult FDropResult;
	TOrtusShellItem* FSource;
	TOrtusShellItems* FSourceItems;
	TOrtusShellItem* FTarget;
	
protected:
	void __fastcall SetDropResult(TOrtusShellOleDropResult Value);
	void __fastcall SetSource(Shlobj::PItemIDList Value);
	void __fastcall SetTarget(Shlobj::PItemIDList Value);
	
public:
	__fastcall TOrtusShellOleDragDropInfo(void);
	__fastcall virtual ~TOrtusShellOleDragDropInfo(void);
	__property TOrtusShellOleDropResult DropResult = {read=FDropResult, nodefault};
	__property TOrtusShellItem* Source = {read=FSource};
	__property TOrtusShellItems* SourceItems = {read=FSourceItems};
	__property TOrtusShellItem* Target = {read=FTarget};
};


typedef void __fastcall (__closure *TOrtusShellSelectionChangedEvent)(System::TObject* Sender);

class DELPHICLASS TCustomOrtusShellComboBox;
class DELPHICLASS TCustomOrtusShellTreeView;
class DELPHICLASS TCustomOrtusShellListView;
typedef void __fastcall (__closure *TOrtusShellContextMenuCommandEvent)(System::TObject* Sender, TOrtusShellItems* 
	Items, const AnsiString Command, bool &Accept);

typedef void __fastcall (__closure *TOrtusShellContextMenuPopupEvent)(System::TObject* Sender, TOrtusShellItems* 
	Items, bool &Accept);

typedef void __fastcall (__closure *TOrtusShellNavigateFolderEvent)(System::TObject* Sender, const AnsiString 
	Folder, bool &Accept);

class PASCALIMPLEMENTATION TCustomOrtusShellListView : public Comctrls::TCustomListView 
{
	typedef Comctrls::TCustomListView inherited;
	
private:
	AnsiString FAbout;
	bool FAutoContextMenu;
	bool FAutoDefaultCommand;
	bool FAutoKeyboardShortcuts;
	bool FAutoNavigateFolder;
	bool FAutoRefreshContents;
	int FAutoScrollInterval;
	bool FBorlandDragDropBehaviour;
	Ortusshellglobal::TOrtusShellItemTypes FItemTypes;
	TOrtusShellOleDragEffects FOleDragEffects;
	bool FOleDragEnabled;
	TOrtusShellOleDropEffect FOleDropEffect;
	bool FOleDropEnabled;
	AnsiString FRootFolder;
	TOrtusShellItems* FSelectedItems;
	bool FShowHiddenAsTransparent;
	TCustomOrtusShellTreeView* FTreeView;
	Classes::TNotifyEvent FOnAfterPopulate;
	Classes::TNotifyEvent FOnBeforePopulate;
	TOrtusShellContextMenuCommandEvent FOnContextMenuCommand;
	TOrtusShellContextMenuPopupEvent FOnContextMenuPopup;
	TOrtusShellNavigateFolderEvent FOnNavigateFolder;
	TOrtusShellSelectionChangedEvent FOnSelectionChanged;
	_ITEMIDLIST *FRootPIDL;
	Ortusshellchangenotifier::TOrtusShellChangeNotifier* ChangeNotifier;
	_di_IContextMenu2 ContextMenu2;
	bool CreatingRoot;
	bool IsDragDropLeftButton;
	_di_IDataObject OleDragDropDataObject;
	TOrtusShellOleDragDropInfo* OleDragDropInfo;
	bool OleDragDropRegistered;
	bool PrevOleDragDropAccept;
	Comctrls::TListItem* PrevOleDragDropItem;
	bool Refreshing;
	Comctrls::TListItem* RenameItem;
	unsigned StartAutoScrollTickCount;
	int SysLargeImagesHandle;
	int SysSmallImagesHandle;
	Comctrls::TViewStyle __fastcall GetViewStyle(void);
	HIDESBASE void __fastcall SetViewStyle(Comctrls::TViewStyle Value);
	void __fastcall SetRootPIDL(Shlobj::PItemIDList Value);
	void __fastcall SetAutoContextMenu(bool Value);
	void __fastcall SetAutoDefaultCommand(bool Value);
	void __fastcall SetAutoKeyboardShortcuts(bool Value);
	void __fastcall SetAutoNavigateFolder(bool Value);
	void __fastcall SetAutoRefreshContents(bool Value);
	void __fastcall SetAutoScrollInterval(int Value);
	void __fastcall SetBorlandDragDropBehaviour(bool Value);
	void __fastcall SetItemTypes(Ortusshellglobal::TOrtusShellItemTypes Value);
	void __fastcall SetOleDragEffects(TOrtusShellOleDragEffects Value);
	void __fastcall SetOleDragEnabled(bool Value);
	void __fastcall SetOleDropEffect(TOrtusShellOleDropEffect Value);
	void __fastcall SetOleDropEnabled(bool Value);
	void __fastcall SetRootFolder(const AnsiString Value);
	TOrtusShellItems* __fastcall GetSelectedItems(void);
	void __fastcall SetShowHiddenAsTransparent(bool Value);
	void __fastcall SetTreeView(TCustomOrtusShellTreeView* Value);
	HRESULT __stdcall DragEnter(const _di_IDataObject DataObj, int KeyState, const Windows::TPoint P, int 
		&Effect);
	HRESULT __stdcall IDropTarget_DragOver(int KeyState, const Windows::TPoint P, int &Effect);
	HRESULT __stdcall DragLeave(void);
	HRESULT __stdcall Drop(const _di_IDataObject DataObj, int KeyState, const Windows::TPoint P, int &Effect
		);
	HIDESBASE MESSAGE void __fastcall CNNotify(Messages::TWMNotify &Msg);
	void __fastcall HandleChangeNotifierAssocChangedEvent(System::TObject* Sender, bool TriggeredBySystemInterrupt
		);
	void __fastcall HandleChangeNotifierAttributesEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierCreateEvent(System::TObject* Sender, const AnsiString ItemName, 
		bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierDeleteEvent(System::TObject* Sender, const AnsiString ItemName, 
		bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierDriveAddEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierDriveAddGUIEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierDriveRemovedEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierMediaInsertedEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierMediaRemovedEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierMkDirEvent(System::TObject* Sender, const AnsiString ItemName, 
		bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierRenameFolderEvent(System::TObject* Sender, const AnsiString OldItemName
		, const AnsiString NewItemName, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierRenameItemEvent(System::TObject* Sender, const AnsiString OldItemName
		, const AnsiString NewItemName, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierRmDirEvent(System::TObject* Sender, const AnsiString ItemName, 
		bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierUpdateDirEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierUpdateImageEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierUpdateItemEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall ClearItems(void);
	void __fastcall CreateRoot(void);
	HIDESBASE _di_IDropTarget __fastcall GetDropTarget(const Windows::TPoint &P);
	void __fastcall InitItem(Comctrls::TListItem* Item);
	bool __fastcall PopulateRoot(void);
	void __fastcall StartOleDrag(bool IsRightButton);
	
protected:
	DYNAMIC bool __fastcall CanChange(Comctrls::TListItem* Item, int Change);
	DYNAMIC bool __fastcall CanEdit(Comctrls::TListItem* Item);
	DYNAMIC void __fastcall Change(Comctrls::TListItem* Item, int Change);
	virtual void __fastcall CreateWnd(void);
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall Delete(Comctrls::TListItem* Item);
	virtual void __fastcall DestroyWnd(void);
	DYNAMIC void __fastcall DoContextPopup(const Windows::TPoint &MousePos, bool &Handled);
	DYNAMIC void __fastcall Edit(const tagLVITEMA &Item);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	virtual void __fastcall Notification(Classes::TComponent* Component, Classes::TOperation Operation)
		;
	virtual void __fastcall WndProc(Messages::TMessage &Msg);
	void __fastcall DoAfterPopulate(void);
	void __fastcall DoBeforePopulate(void);
	void __fastcall DoContextMenuCommand(TOrtusShellItems* Items, const AnsiString Command, bool &Accept
		);
	void __fastcall DoContextMenuPopup(TOrtusShellItems* Items, bool &Accept);
	void __fastcall DoNavigateFolder(const AnsiString Folder, bool &Accept);
	void __fastcall DoOleDragOver(TOrtusShellOleDragDropInfo* Info, int X, int Y, Controls::TDragState 
		State, bool &Accept);
	void __fastcall DoOleDragDrop(TOrtusShellOleDragDropInfo* Info, int X, int Y);
	void __fastcall DoOleEndDrag(TOrtusShellOleDragDropInfo* Info, int X, int Y);
	void __fastcall DoOleStartDrag(void);
	void __fastcall DoSelectionChanged(void);
	virtual void __fastcall CreateColumns(void);
	virtual void __fastcall FillColumns(Comctrls::TListItem* Item);
	__property Comctrls::TViewStyle ViewStyle = {read=GetViewStyle, write=SetViewStyle, nodefault};
	void __fastcall SetRootFromPIDL(Shlobj::PItemIDList PIDL);
	__property Shlobj::PItemIDList RootPIDL = {read=FRootPIDL, write=SetRootPIDL};
	__property bool AutoContextMenu = {read=FAutoContextMenu, write=SetAutoContextMenu, default=1};
	__property bool AutoDefaultCommand = {read=FAutoDefaultCommand, write=SetAutoDefaultCommand, default=1
		};
	__property bool AutoKeyboardShortcuts = {read=FAutoKeyboardShortcuts, write=SetAutoKeyboardShortcuts
		, default=1};
	__property bool AutoNavigateFolder = {read=FAutoNavigateFolder, write=SetAutoNavigateFolder, default=1
		};
	__property bool AutoRefreshContents = {read=FAutoRefreshContents, write=SetAutoRefreshContents, default=1
		};
	__property int AutoScrollInterval = {read=FAutoScrollInterval, write=SetAutoScrollInterval, default=50
		};
	__property bool BorlandDragDropBehaviour = {read=FBorlandDragDropBehaviour, write=SetBorlandDragDropBehaviour
		, nodefault};
	__property Ortusshellglobal::TOrtusShellItemTypes ItemTypes = {read=FItemTypes, write=SetItemTypes, 
		default=7};
	__property TOrtusShellOleDragEffects OleDragEffects = {read=FOleDragEffects, write=SetOleDragEffects
		, default=7};
	__property bool OleDragEnabled = {read=FOleDragEnabled, write=SetOleDragEnabled, default=1};
	__property TOrtusShellOleDropEffect OleDropEffect = {read=FOleDropEffect, write=SetOleDropEffect, default=0
		};
	__property bool OleDropEnabled = {read=FOleDropEnabled, write=SetOleDropEnabled, default=1};
	__property AnsiString RootFolder = {read=FRootFolder, write=SetRootFolder};
	__property TOrtusShellItems* SelectedItems = {read=GetSelectedItems};
	__property bool ShowHiddenAsTransparent = {read=FShowHiddenAsTransparent, write=SetShowHiddenAsTransparent
		, default=1};
	__property TCustomOrtusShellTreeView* TreeView = {read=FTreeView, write=SetTreeView};
	__property Classes::TNotifyEvent OnAfterPopulate = {read=FOnAfterPopulate, write=FOnAfterPopulate};
		
	__property Classes::TNotifyEvent OnBeforePopulate = {read=FOnBeforePopulate, write=FOnBeforePopulate
		};
	__property TOrtusShellContextMenuCommandEvent OnContextMenuCommand = {read=FOnContextMenuCommand, write=
		FOnContextMenuCommand};
	__property TOrtusShellContextMenuPopupEvent OnContextMenuPopup = {read=FOnContextMenuPopup, write=FOnContextMenuPopup
		};
	__property TOrtusShellNavigateFolderEvent OnNavigateFolder = {read=FOnNavigateFolder, write=FOnNavigateFolder
		};
	__property TOrtusShellSelectionChangedEvent OnSelectionChanged = {read=FOnSelectionChanged, write=FOnSelectionChanged
		};
	
public:
	__property Items ;
	__fastcall virtual TCustomOrtusShellListView(Classes::TComponent* Owner);
	__fastcall virtual ~TCustomOrtusShellListView(void);
	void __fastcall ClearSelection(void);
	void __fastcall SelectAll(void);
	bool __fastcall CreateNewFolder(const AnsiString Folder);
	void __fastcall RefreshContents(void);
	void __fastcall UpFolder(void);
	
__published:
	__property AnsiString About = {read=FAbout, write=FAbout};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TCustomOrtusShellListView(HWND ParentWindow) : Comctrls::TCustomListView(
		ParentWindow) { }
	#pragma option pop
	
private:
	void *__IDropTarget;	/* IDropTarget [DragOver=IDropTarget_DragOver] */
	
public:
	operator IDropTarget*(void) { return (IDropTarget*)&__IDropTarget; }
	
};


typedef void __fastcall (__closure *TOrtusShellDriveAddedEvent)(System::TObject* Sender, const AnsiString 
	RootFolder);

typedef void __fastcall (__closure *TOrtusShellDriveRemovedEvent)(System::TObject* Sender, const AnsiString 
	RootFolder);

typedef void __fastcall (__closure *TOrtusShellMediaInsertedEvent)(System::TObject* Sender, const AnsiString 
	RootFolder);

typedef void __fastcall (__closure *TOrtusShellMediaRemovedEvent)(System::TObject* Sender, const AnsiString 
	RootFolder);

class PASCALIMPLEMENTATION TCustomOrtusShellTreeView : public Comctrls::TCustomTreeView 
{
	typedef Comctrls::TCustomTreeView inherited;
	
private:
	AnsiString FAbout;
	bool FAutoContextMenu;
	bool FAutoDefaultCommand;
	int FAutoExpandInterval;
	bool FAutoKeyboardShortcuts;
	bool FAutoRefreshContents;
	int FAutoScrollInterval;
	bool FBorlandDragDropBehaviour;
	TCustomOrtusShellComboBox* FComboBox;
	Ortusshellglobal::TOrtusShellItemTypes FItemTypes;
	TCustomOrtusShellListView* FListView;
	TOrtusShellOleDragEffects FOleDragEffects;
	bool FOleDragEnabled;
	TOrtusShellOleDropEffect FOleDropEffect;
	bool FOleDropEnabled;
	AnsiString FRootFolder;
	TOrtusShellItems* FSelectedItems;
	bool FShowHiddenAsTransparent;
	TOrtusShellContextMenuCommandEvent FOnContextMenuCommand;
	TOrtusShellContextMenuPopupEvent FOnContextMenuPopup;
	TOrtusShellDriveAddedEvent FOnDriveAdded;
	TOrtusShellDriveRemovedEvent FOnDriveRemoved;
	TOrtusShellMediaInsertedEvent FOnMediaInserted;
	TOrtusShellMediaRemovedEvent FOnMediaRemoved;
	TOrtusShellSelectionChangedEvent FOnSelectionChanged;
	Ortusshellchangenotifier::TOrtusShellChangeNotifier* ChangeNotifier;
	bool CreatingRoot;
	_di_IContextMenu2 ContextMenu2;
	bool IsDragDropLeftButton;
	bool PrevOleDragDropAccept;
	Comctrls::TTreeNode* PrevOleDragDropNode;
	_di_IDataObject OleDragDropDataObject;
	TOrtusShellOleDragDropInfo* OleDragDropInfo;
	bool OleDragDropRegistered;
	bool Refreshing;
	Comctrls::TTreeNode* RenameNode;
	unsigned StartAutoExpandTickCount;
	unsigned StartAutoScrollTickCount;
	int SysImagesHandle;
	void __fastcall SetAutoContextMenu(bool Value);
	void __fastcall SetAutoDefaultCommand(bool Value);
	void __fastcall SetAutoExpandInterval(int Value);
	void __fastcall SetAutoKeyboardShortcuts(bool Value);
	void __fastcall SetAutoRefreshContents(bool Value);
	void __fastcall SetAutoScrollInterval(int Value);
	void __fastcall SetBorlandDragDropBehaviour(bool Value);
	void __fastcall SetComboBox(TCustomOrtusShellComboBox* Value);
	void __fastcall SetItemTypes(Ortusshellglobal::TOrtusShellItemTypes Value);
	void __fastcall SetListView(TCustomOrtusShellListView* Value);
	void __fastcall SetOleDragEffects(TOrtusShellOleDragEffects Value);
	void __fastcall SetOleDragEnabled(bool Value);
	void __fastcall SetOleDropEffect(TOrtusShellOleDropEffect Value);
	void __fastcall SetOleDropEnabled(bool Value);
	void __fastcall SetRootFolder(const AnsiString Value);
	TOrtusShellItems* __fastcall GetSelectedItems(void);
	void __fastcall SetShowHiddenAsTransparent(bool Value);
	HRESULT __stdcall DragEnter(const _di_IDataObject DataObj, int KeyState, const Windows::TPoint P, int 
		&Effect);
	HRESULT __stdcall IDropTarget_DragOver(int KeyState, const Windows::TPoint P, int &Effect);
	HRESULT __stdcall DragLeave(void);
	HRESULT __stdcall Drop(const _di_IDataObject DataObj, int KeyState, const Windows::TPoint P, int &Effect
		);
	HIDESBASE MESSAGE void __fastcall CNNotify(Messages::TWMNotify &Msg);
	void __fastcall HandleChangeNotifierDriveAddEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierDriveAddGUIEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierDriveRemovedEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierMediaInsertedEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierMediaRemovedEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierMkDirEvent(System::TObject* Sender, const AnsiString ItemName, 
		bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierRenameFolderEvent(System::TObject* Sender, const AnsiString OldItemName
		, const AnsiString NewItemName, bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierRmDirEvent(System::TObject* Sender, const AnsiString ItemName, 
		bool TriggeredBySystemInterrupt);
	void __fastcall HandleChangeNotifierUpdateDirEvent(System::TObject* Sender, const AnsiString ItemName
		, bool TriggeredBySystemInterrupt);
	void __fastcall CreateRoot(void);
	HIDESBASE _di_IDropTarget __fastcall GetDropTarget(const Windows::TPoint &P);
	void __fastcall InitNode(Comctrls::TTreeNode* Node);
	bool __fastcall PopulateNode(Comctrls::TTreeNode* Node);
	void __fastcall StartOleDrag(Comctrls::TTreeNode* Node, bool IsRightButton);
	
protected:
	DYNAMIC bool __fastcall CanChange(Comctrls::TTreeNode* Node);
	DYNAMIC bool __fastcall CanEdit(Comctrls::TTreeNode* Node);
	DYNAMIC bool __fastcall CanExpand(Comctrls::TTreeNode* Node);
	DYNAMIC void __fastcall Change(Comctrls::TTreeNode* Node);
	virtual void __fastcall CreateParams(Controls::TCreateParams &Params);
	virtual void __fastcall CreateWnd(void);
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall Delete(Comctrls::TTreeNode* Node);
	virtual void __fastcall DestroyWnd(void);
	DYNAMIC void __fastcall DoContextPopup(const Windows::TPoint &MousePos, bool &Handled);
	DYNAMIC void __fastcall Edit(const tagTVITEMA &Item);
	DYNAMIC void __fastcall Expand(Comctrls::TTreeNode* Node);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	virtual void __fastcall Loaded(void);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	virtual void __fastcall Notification(Classes::TComponent* Component, Classes::TOperation Operation)
		;
	virtual void __fastcall WndProc(Messages::TMessage &Msg);
	void __fastcall DoContextMenuCommand(TOrtusShellItems* Items, const AnsiString Command, bool &Accept
		);
	void __fastcall DoContextMenuPopup(TOrtusShellItems* Items, bool &Accept);
	void __fastcall DoDriveAdded(const AnsiString RootFolder);
	void __fastcall DoDriveRemoved(const AnsiString RootFolder);
	void __fastcall DoMediaInserted(const AnsiString RootFolder);
	void __fastcall DoMediaRemoved(const AnsiString RootFolder);
	void __fastcall DoOleDragOver(TOrtusShellOleDragDropInfo* Info, int X, int Y, Controls::TDragState 
		State, bool &Accept);
	void __fastcall DoOleDragDrop(TOrtusShellOleDragDropInfo* Info, int X, int Y);
	void __fastcall DoOleEndDrag(TOrtusShellOleDragDropInfo* Info, int X, int Y);
	void __fastcall DoOleStartDrag(void);
	void __fastcall DoSelectionChanged(void);
	void __fastcall SetItemFromPIDL(Shlobj::PItemIDList PIDL);
	__property bool AutoContextMenu = {read=FAutoContextMenu, write=SetAutoContextMenu, default=1};
	__property bool AutoDefaultCommand = {read=FAutoDefaultCommand, write=SetAutoDefaultCommand, default=1
		};
	__property int AutoExpandInterval = {read=FAutoExpandInterval, write=SetAutoExpandInterval, default=500
		};
	__property bool AutoKeyboardShortcuts = {read=FAutoKeyboardShortcuts, write=SetAutoKeyboardShortcuts
		, default=1};
	__property bool AutoRefreshContents = {read=FAutoRefreshContents, write=SetAutoRefreshContents, default=1
		};
	__property int AutoScrollInterval = {read=FAutoScrollInterval, write=SetAutoScrollInterval, default=50
		};
	__property bool BorlandDragDropBehaviour = {read=FBorlandDragDropBehaviour, write=SetBorlandDragDropBehaviour
		, nodefault};
	__property TCustomOrtusShellComboBox* ComboBox = {read=FComboBox, write=SetComboBox};
	__property Ortusshellglobal::TOrtusShellItemTypes ItemTypes = {read=FItemTypes, write=SetItemTypes, 
		default=5};
	__property TCustomOrtusShellListView* ListView = {read=FListView, write=SetListView};
	__property TOrtusShellOleDragEffects OleDragEffects = {read=FOleDragEffects, write=SetOleDragEffects
		, default=7};
	__property bool OleDragEnabled = {read=FOleDragEnabled, write=SetOleDragEnabled, default=1};
	__property TOrtusShellOleDropEffect OleDropEffect = {read=FOleDropEffect, write=SetOleDropEffect, default=0
		};
	__property bool OleDropEnabled = {read=FOleDropEnabled, write=SetOleDropEnabled, default=1};
	__property AnsiString RootFolder = {read=FRootFolder, write=SetRootFolder};
	__property TOrtusShellItems* SelectedItems = {read=GetSelectedItems};
	__property bool ShowHiddenAsTransparent = {read=FShowHiddenAsTransparent, write=SetShowHiddenAsTransparent
		, default=1};
	__property TOrtusShellContextMenuCommandEvent OnContextMenuCommand = {read=FOnContextMenuCommand, write=
		FOnContextMenuCommand};
	__property TOrtusShellContextMenuPopupEvent OnContextMenuPopup = {read=FOnContextMenuPopup, write=FOnContextMenuPopup
		};
	__property TOrtusShellDriveAddedEvent OnDriveAdded = {read=FOnDriveAdded, write=FOnDriveAdded};
	__property TOrtusShellDriveRemovedEvent OnDriveRemoved = {read=FOnDriveRemoved, write=FOnDriveRemoved
		};
	__property TOrtusShellMediaInsertedEvent OnMediaInserted = {read=FOnMediaInserted, write=FOnMediaInserted
		};
	__property TOrtusShellMediaRemovedEvent OnMediaRemoved = {read=FOnMediaRemoved, write=FOnMediaRemoved
		};
	__property TOrtusShellSelectionChangedEvent OnSelectionChanged = {read=FOnSelectionChanged, write=FOnSelectionChanged
		};
	
public:
	__property Items ;
	__fastcall virtual TCustomOrtusShellTreeView(Classes::TComponent* Owner);
	__fastcall virtual ~TCustomOrtusShellTreeView(void);
	bool __fastcall CreateNewFolder(const AnsiString Folder);
	void __fastcall SelectFolder(const AnsiString Folder);
	void __fastcall RefreshContents(void);
	
__published:
	__property AnsiString About = {read=FAbout, write=FAbout};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TCustomOrtusShellTreeView(HWND ParentWindow) : Comctrls::TCustomTreeView(
		ParentWindow) { }
	#pragma option pop
	
private:
	void *__IDropTarget;	/* IDropTarget [DragOver=IDropTarget_DragOver] */
	
public:
	operator IDropTarget*(void) { return (IDropTarget*)&__IDropTarget; }
	
};


class PASCALIMPLEMENTATION TCustomOrtusShellComboBox : public Stdctrls::TCustomComboBox 
{
	typedef Stdctrls::TCustomComboBox inherited;
	
private:
	AnsiString FAbout;
	TOrtusShellItems* FSelectedItems;
	TCustomOrtusShellTreeView* FTreeView;
	TOrtusShellSelectionChangedEvent FOnSelectionChanged;
	bool FDrawingEdit;
	Controls::TImageList* FImageList;
	int FIndent;
	bool FInternalChange;
	_ITEMIDLIST *FPIDL;
	TOrtusShellItems* __fastcall GetSelectedItems(void);
	void __fastcall SetTreeView(TCustomOrtusShellTreeView* Value);
	void __fastcall ClearItems(void);
	void __fastcall FillItems(void);
	int __fastcall IndexOfPIDL(Shlobj::PItemIDList PIDL);
	HIDESBASE MESSAGE void __fastcall CNDrawItem(Messages::TWMDrawItem &Msg);
	
protected:
	DYNAMIC void __fastcall Change(void);
	virtual void __fastcall CreateWnd(void);
	virtual void __fastcall DestroyWnd(void);
	virtual void __fastcall DrawItem(int Index, const Windows::TRect &Rect, Windows::TOwnerDrawState State
		);
	virtual void __fastcall Loaded(void);
	virtual void __fastcall Notification(Classes::TComponent* Component, Classes::TOperation Operation)
		;
	virtual void __fastcall WndProc(Messages::TMessage &Msg);
	void __fastcall DoSelectionChanged(void);
	void __fastcall SetPIDL(Shlobj::PItemIDList PIDL);
	__property TOrtusShellItems* SelectedItems = {read=GetSelectedItems};
	__property TCustomOrtusShellTreeView* TreeView = {read=FTreeView, write=SetTreeView};
	__property TOrtusShellSelectionChangedEvent OnSelectionChanged = {read=FOnSelectionChanged, write=FOnSelectionChanged
		};
	
public:
	__fastcall virtual TCustomOrtusShellComboBox(Classes::TComponent* Owner);
	__fastcall virtual ~TCustomOrtusShellComboBox(void);
	
__published:
	__property AnsiString About = {read=FAbout, write=FAbout};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TCustomOrtusShellComboBox(HWND ParentWindow) : Stdctrls::TCustomComboBox(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TOrtusShellComboBox;
class PASCALIMPLEMENTATION TOrtusShellComboBox : public TCustomOrtusShellComboBox 
{
	typedef TCustomOrtusShellComboBox inherited;
	
public:
	__property SelectedItems ;
	
__published:
	__property Align ;
	__property Anchors ;
	__property Color ;
	__property DropDownCount ;
	__property Font ;
	__property ParentColor ;
	__property ParentFont ;
	__property TabOrder ;
	__property TreeView ;
	__property OnSelectionChanged ;
public:
	#pragma option push -w-inl
	/* TCustomOrtusShellComboBox.Create */ inline __fastcall virtual TOrtusShellComboBox(Classes::TComponent* 
		Owner) : TCustomOrtusShellComboBox(Owner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomOrtusShellComboBox.Destroy */ inline __fastcall virtual ~TOrtusShellComboBox(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TOrtusShellComboBox(HWND ParentWindow) : TCustomOrtusShellComboBox(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TOrtusShellTreeView;
class PASCALIMPLEMENTATION TOrtusShellTreeView : public TCustomOrtusShellTreeView 
{
	typedef TCustomOrtusShellTreeView inherited;
	
public:
	__property SelectedItems ;
	
__published:
	__property Align ;
	__property Anchors ;
	__property BiDiMode ;
	__property BorderStyle ;
	__property BorderWidth ;
	__property Color ;
	__property Ctl3D ;
	__property Constraints ;
	__property Enabled ;
	__property Font ;
	__property HideSelection ;
	__property HotTrack ;
	__property Indent ;
	__property ParentBiDiMode ;
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PopupMenu ;
	__property ReadOnly ;
	__property RightClickSelect ;
	__property RowSelect ;
	__property ShowButtons ;
	__property ShowHint ;
	__property ShowLines ;
	__property TabOrder ;
	__property TabStop ;
	__property ToolTips ;
	__property Visible ;
	__property OnAdvancedCustomDraw ;
	__property OnAdvancedCustomDrawItem ;
	__property OnChange ;
	__property OnChanging ;
	__property OnClick ;
	__property OnCollapsed ;
	__property OnCollapsing ;
	__property OnContextPopup ;
	__property OnCustomDraw ;
	__property OnCustomDrawItem ;
	__property OnDblClick ;
	__property OnDeletion ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnEditing ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnExpanding ;
	__property OnExpanded ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnStartDrag ;
	__property AutoContextMenu ;
	__property AutoDefaultCommand ;
	__property AutoExpandInterval ;
	__property AutoKeyboardShortcuts ;
	__property AutoRefreshContents ;
	__property AutoScrollInterval ;
	__property BorlandDragDropBehaviour ;
	__property ComboBox ;
	__property ItemTypes ;
	__property ListView ;
	__property OleDragEffects ;
	__property OleDragEnabled ;
	__property OleDropEffect ;
	__property OleDropEnabled ;
	__property RootFolder ;
	__property ShowHiddenAsTransparent ;
	__property OnContextMenuCommand ;
	__property OnContextMenuPopup ;
	__property OnDriveAdded ;
	__property OnDriveRemoved ;
	__property OnMediaInserted ;
	__property OnMediaRemoved ;
	__property OnSelectionChanged ;
public:
	#pragma option push -w-inl
	/* TCustomOrtusShellTreeView.Create */ inline __fastcall virtual TOrtusShellTreeView(Classes::TComponent* 
		Owner) : TCustomOrtusShellTreeView(Owner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomOrtusShellTreeView.Destroy */ inline __fastcall virtual ~TOrtusShellTreeView(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TOrtusShellTreeView(HWND ParentWindow) : TCustomOrtusShellTreeView(
		ParentWindow) { }
	#pragma option pop
	
};


class DELPHICLASS TOrtusShellListView;
class PASCALIMPLEMENTATION TOrtusShellListView : public TCustomOrtusShellListView 
{
	typedef TCustomOrtusShellListView inherited;
	
public:
	__property SelectedItems ;
	
__published:
	__property Align ;
	__property Anchors ;
	__property BiDiMode ;
	__property BorderStyle ;
	__property BorderWidth ;
	__property Color ;
	__property Constraints ;
	__property Ctl3D ;
	__property Enabled ;
	__property Font ;
	__property FlatScrollBars ;
	__property GridLines ;
	__property HideSelection ;
	__property HotTrack ;
	__property HotTrackStyles ;
	__property HoverTime ;
	__property MultiSelect ;
	__property OwnerDraw ;
	__property ParentBiDiMode ;
	__property ParentColor ;
	__property ParentCtl3D ;
	__property ParentFont ;
	__property ParentShowHint ;
	__property PopupMenu ;
	__property ReadOnly ;
	__property ShowHint ;
	__property TabOrder ;
	__property TabStop ;
	__property ViewStyle ;
	__property Visible ;
	__property OnAdvancedCustomDraw ;
	__property OnAdvancedCustomDrawItem ;
	__property OnAdvancedCustomDrawSubItem ;
	__property OnChange ;
	__property OnChanging ;
	__property OnClick ;
	__property OnContextPopup ;
	__property OnCustomDraw ;
	__property OnCustomDrawItem ;
	__property OnCustomDrawSubItem ;
	__property OnDblClick ;
	__property OnDragDrop ;
	__property OnDragOver ;
	__property OnDrawItem ;
	__property OnEditing ;
	__property OnEndDrag ;
	__property OnEnter ;
	__property OnExit ;
	__property OnKeyDown ;
	__property OnKeyPress ;
	__property OnKeyUp ;
	__property OnMouseDown ;
	__property OnMouseMove ;
	__property OnMouseUp ;
	__property OnResize ;
	__property OnSelectItem ;
	__property OnStartDrag ;
	__property AutoContextMenu ;
	__property AutoDefaultCommand ;
	__property AutoKeyboardShortcuts ;
	__property AutoNavigateFolder ;
	__property AutoRefreshContents ;
	__property AutoScrollInterval ;
	__property BorlandDragDropBehaviour ;
	__property ItemTypes ;
	__property OleDragEffects ;
	__property OleDragEnabled ;
	__property OleDropEffect ;
	__property OleDropEnabled ;
	__property RootFolder ;
	__property ShowHiddenAsTransparent ;
	__property TreeView ;
	__property OnAfterPopulate ;
	__property OnBeforePopulate ;
	__property OnContextMenuCommand ;
	__property OnContextMenuPopup ;
	__property OnNavigateFolder ;
	__property OnSelectionChanged ;
public:
	#pragma option push -w-inl
	/* TCustomOrtusShellListView.Create */ inline __fastcall virtual TOrtusShellListView(Classes::TComponent* 
		Owner) : TCustomOrtusShellListView(Owner) { }
	#pragma option pop
	#pragma option push -w-inl
	/* TCustomOrtusShellListView.Destroy */ inline __fastcall virtual ~TOrtusShellListView(void) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TOrtusShellListView(HWND ParentWindow) : TCustomOrtusShellListView(
		ParentWindow) { }
	#pragma option pop
	
};


//-- var, const, procedure ---------------------------------------------------

}	/* namespace Ortusshellexplorer */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Ortusshellexplorer;
#endif
#pragma option pop	// -w-
#pragma option pop	// -Vx

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// OrtusShellExplorer
