unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, OrtusShellChangeNotifier, StdCtrls, ComCtrls, OrtusShellExplorer,
  Buttons, OrtusShellTrayIcon, Menus, CheckLst, ExtCtrls, ImgList;

type
  TForm1 = class(TForm)
    OrtusShellChangeNotifier1: TOrtusShellChangeNotifier;
    OrtusShellTrayIcon1: TOrtusShellTrayIcon;
    PopupMenu1: TPopupMenu;
    Show1: TMenuItem;
    Exit1: TMenuItem;
    Panel1: TPanel;
    Panel2: TPanel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Button1: TButton;
    Button2: TButton;
    Panel3: TPanel;
    ListView1: TListView;
    Panel4: TPanel;
    OrtusShellTreeView1: TOrtusShellTreeView;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    Label2: TLabel;
    CheckListBox1: TCheckListBox;
    Panel8: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    Panel9: TPanel;
    Label1: TLabel;
    ListBox1: TListBox;
    ImageList1: TImageList;
    ImageList2: TImageList;
    procedure Button2Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure Show1Click(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    EventHistory: string;

    procedure HandleAssocChangedEvent(Sender: TObject; TriggeredBySystemInterrupt: Boolean);
    procedure HandleAttributesEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleCreateEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleDeleteEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleDriveAddEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleDriveAddGUIEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleDriveRemovedEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleFreeSpaceEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleMediaInsertedEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleMediaRemovedEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleMkDirEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleNetShareEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleNetUnshareEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleRenameFolderEvent(Sender: TObject; const OldItemName, NewItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleRenameItemEvent(Sender: TObject; const OldItemName, NewItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleRmDirEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleServerDisconnectEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleUpdateDirEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleUpdateImageEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
    procedure HandleUpdateItemEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);

    procedure UpdateNotifier;
    procedure AddToEventHistory(S: string);
    procedure ShowBalloonHint;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.HandleAssocChangedEvent(Sender: TObject; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A file type association has changed';
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleAttributesEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'The attributes of an item or folder have changed';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleCreateEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A nonfolder item has been created';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleDeleteEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A nonfolder item has been deleted';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleDriveAddEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A drive has been added';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleDriveAddGUIEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A drive has been added by way of a graphic user interface';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleDriveRemovedEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A drive has been removed';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleFreeSpaceEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'The amount of free space on a drive has changed';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleMediaInsertedEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'Storage media has been inserted into a drive';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleMediaRemovedEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'Storage media has been removed from a drive';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleMkDirEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A folder has been created';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleNetShareEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A folder on the local computer is being shared via the network';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleNetUnshareEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A folder on the local computer is no longer being shared via the network';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleRenameFolderEvent(Sender: TObject; const OldItemName, NewItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'The name of a folder has changed';
    SubItems.Add(OldItemName);
    SubItems.Add(NewItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleRenameItemEvent(Sender: TObject; const OldItemName, NewItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'The name of a nonfolder item has changed';
    SubItems.Add(OldItemName);
    SubItems.Add(NewItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleRmDirEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'A folder has been removed';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleServerDisconnectEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'The computer has disconnected from a server';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleUpdateDirEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'The contents of an existing folder have changed, but the folder still exists and has not been renamed';
    SubItems.Add(ItemName);
    AddToEventHistory('The contents of an existing folder have changed');
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleUpdateImageEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'An image in the system image list has changed';
    SubItems.Add(ItemName);
    AddToEventHistory(Caption);
    ShowBalloonHint;
  end;
end;

procedure TForm1.HandleUpdateItemEvent(Sender: TObject; const ItemName: string; TriggeredBySystemInterrupt: Boolean);
begin
  with ListView1.Items.Add do begin
    Caption := 'An existing nonfolder item has changed, but the item still exists and has not been renamed';
    SubItems.Add(ItemName);
    AddToEventHistory('An existing nonfolder item has changed');
    ShowBalloonHint;
  end;
end;

procedure TForm1.UpdateNotifier;
var
  I: Integer;
begin
  OrtusShellChangeNotifier1.Active := False;
  OrtusShellChangeNotifier1.Folders.Clear;
  for I := 0 to ListBox1.Items.Count - 1 do with OrtusShellChangeNotifier1.Folders.Add do begin
    Folder := ListBox1.Items[I];
    WatchSubTree := True;
  end;
  if CheckListBox1.Checked[0] then OrtusShellChangeNotifier1.OnAssocChanged := HandleAssocChangedEvent else OrtusShellChangeNotifier1.OnAssocChanged := nil;
  if CheckListBox1.Checked[1] then OrtusShellChangeNotifier1.OnAttributes := HandleAttributesEvent else OrtusShellChangeNotifier1.OnAttributes := nil;
  if CheckListBox1.Checked[2] then OrtusShellChangeNotifier1.OnCreate := HandleCreateEvent else OrtusShellChangeNotifier1.OnCreate := nil;
  if CheckListBox1.Checked[3] then OrtusShellChangeNotifier1.OnDelete := HandleDeleteEvent else OrtusShellChangeNotifier1.OnDelete := nil;
  if CheckListBox1.Checked[4] then OrtusShellChangeNotifier1.OnDriveAdd := handleDriveAddEvent else OrtusShellChangeNotifier1.OnDriveAdd := nil;
  if CheckListBox1.Checked[5] then OrtusShellChangeNotifier1.OnDriveAddGUI := HandleDriveAddGUIEvent else OrtusShellChangeNotifier1.OnDriveAddGUI := nil;
  if CheckListBox1.Checked[6] then OrtusShellChangeNotifier1.OnDriveRemoved := HandleDriveRemovedEvent else OrtusShellChangeNotifier1.OnDriveRemoved := nil;
  if CheckListBox1.Checked[7] then OrtusShellChangeNotifier1.OnFreeSpace := HandleFreeSpaceEvent else OrtusShellChangeNotifier1.OnFreeSpace := nil;
  if CheckListBox1.Checked[8] then OrtusShellChangeNotifier1.OnMediaInserted := HandleMediaInsertedEvent else OrtusShellChangeNotifier1.OnMediaInserted := nil;
  if CheckListBox1.Checked[9] then OrtusShellChangeNotifier1.OnMediaRemoved := HandleMediaRemovedEvent else OrtusShellChangeNotifier1.OnMediaRemoved := nil;
  if CheckListBox1.Checked[10] then OrtusShellChangeNotifier1.OnMkDir := HandleMkDirEvent else OrtusShellChangeNotifier1.OnMkDir := nil;
  if CheckListBox1.Checked[11] then OrtusShellChangeNotifier1.OnNetShare := HandleNetshareEvent else OrtusShellChangeNotifier1.OnNetShare := nil;
  if CheckListBox1.Checked[12] then OrtusShellChangeNotifier1.OnNetUnshare := HandleNetUnshareEvent else OrtusShellChangeNotifier1.OnNetUnshare := nil;
  if CheckListBox1.Checked[13] then OrtusShellChangeNotifier1.OnRenameFolder := HandlerenameFolderEvent else OrtusShellChangeNotifier1.OnRenameFolder := nil;
  if CheckListBox1.Checked[14] then OrtusShellChangeNotifier1.OnRenameItem := HandleRenameItemEvent else OrtusShellChangeNotifier1.OnRenameItem := nil;
  if CheckListBox1.Checked[15] then OrtusShellChangeNotifier1.OnRmDir := HandleRmDirEvent else OrtusShellChangeNotifier1.OnRmDir := nil;
  if CheckListBox1.Checked[16] then OrtusShellChangeNotifier1.OnServerDisconnect := HandleServerDisconnectEvent else OrtusShellChangeNotifier1.OnServerDisconnect := nil;
  if CheckListBox1.Checked[17] then OrtusShellChangeNotifier1.OnUpdateDir := HandleUpdateDirEvent else OrtusShellChangeNotifier1.OnUpdateDir := nil;
  if CheckListBox1.Checked[18] then OrtusShellChangeNotifier1.OnUpdateImage := HandleUpdateImageEvent else OrtusShellChangeNotifier1.OnUpdateImage := nil;
  if CheckListBox1.Checked[19] then OrtusShellChangeNotifier1.OnUpdateItem := HandleUpdateItemEvent else OrtusShellChangeNotifier1.OnUpdateItem := nil; 
  OrtusShellChangeNotifier1.Active := CheckBox1.Checked;
  if OrtusShellChangeNotifier1.Active then
    OrtusShellTrayIcon1.StartAnimation('Animation1', True)
  else
    OrtusShellTrayIcon1.StopAnimation;
end;

procedure TForm1.AddToEventHistory(S: string);
var
  SL: TStringList;
begin
  SL := TStringList.Create;
  try
    SL.Text := EventHistory;
    SL.Add(S);
    while Length(SL.Text) > 255 do SL.Delete(0);
    EventHistory := SL.Text;
  finally
    SL.Free;
  end {try};
end;

procedure TForm1.ShowBalloonHint;
begin
  OrtusShellTrayIcon1.ShowBalloonHint('Ortus Shell Change Notifier Demo', EventHistory, itInfo, 2);
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  OrtusShellTrayIcon1.HideMainForm;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.Show1Click(Sender: TObject);
begin
  OrtusShellTrayIcon1.ShowMainForm;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
begin
  if OrtusShellTreeView1.SelectedItems.Count > 0 then begin
    if OrtusShellTreeView1.SelectedItems[0].PathName <> '' then begin
      ListBox1.ItemIndex := ListBox1.Items.Add(OrtusShellTreeView1.SelectedItems[0].PathName);
      UpdateNotifier;
    end;
  end;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
  ListBox1.Items.Clear;
  UpdateNotifier;
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  if ListBox1.ItemIndex <> -1 then begin
    ListBox1.Items.Delete(ListBox1.ItemIndex);
    UpdateNotifier;
  end;
end;

procedure TForm1.CheckBox1Click(Sender: TObject);
begin
  UpdateNotifier;
end;

procedure TForm1.CheckBox2Click(Sender: TObject);
begin
  UpdateNotifier;
end;

procedure TForm1.FormShow(Sender: TObject);
var
  I: Integer;
begin
  for I := 0 to CheckListBox1.Items.Count - 1 do CheckListBox1.Checked[I] := True;
  UpdateNotifier;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  Panel1.Height := (ClientHeight - Panel2.Height) div 2;
  Panel4.Width := Panel1.Width div 2;
  Panel6.Height := Panel5.Height div 2;
  ListView1.Columns[0].Width := (ListView1.ClientWidth - 16) div 3;
  ListView1.Columns[1].Width := (ListView1.ClientWidth - 16) div 3;
  ListView1.Columns[2].Width := (ListView1.ClientWidth - 16) div 3;
end;

end.
