unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, OrtusShellExplorer, ExtCtrls, StdCtrls, Buttons;

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    OrtusShellTreeView1: TOrtusShellTreeView;
    OrtusShellListView1: TOrtusShellListView;
    GroupBox1: TGroupBox;
    cbxTreeViewDragEnabled: TCheckBox;
    cbxTreeViewCopy: TCheckBox;
    cbxTreeViewMove: TCheckBox;
    cbxTreeViewLink: TCheckBox;
    GroupBox2: TGroupBox;
    cbxTreeViewDropEnabled: TCheckBox;
    rbnTreeViewDefault: TRadioButton;
    rbnTreeViewCopyOnly: TRadioButton;
    rbnTreeViewMoveOnly: TRadioButton;
    rbnTreeViewLinkOnly: TRadioButton;
    GroupBox3: TGroupBox;
    cbxListViewDragEnabled: TCheckBox;
    cbxListViewCopy: TCheckBox;
    cbxListViewMove: TCheckBox;
    cbxListViewLink: TCheckBox;
    GroupBox4: TGroupBox;
    cbxListViewDropEnabled: TCheckBox;
    rbnListViewDefault: TRadioButton;
    rbnListViewCopyOnly: TRadioButton;
    rbnListViewMoveOnly: TRadioButton;
    rbnListViewLinkOnly: TRadioButton;
    Panel1: TPanel;
    OrtusShellComboBox1: TOrtusShellComboBox;
    btnLargeIcons: TSpeedButton;
    btnSmallIcons: TSpeedButton;
    btnList: TSpeedButton;
    btnDetails: TSpeedButton;
    btnUp: TSpeedButton;
    Panel6: TPanel;
    Panel7: TPanel;
    lblDragSource: TLabel;
    lblDropTarget: TLabel;
    GroupBox5: TGroupBox;
    cbxTreeViewConfirmContextMenuPopup: TCheckBox;
    cbxTreeViewConfirmCommandExecute: TCheckBox;
    GroupBox6: TGroupBox;
    cbxListViewConfirmContextMenuPopup: TCheckBox;
    cbxListViewConfirmcommandExecute: TCheckBox;
    procedure btnUpClick(Sender: TObject);
    procedure btnLargeIconsClick(Sender: TObject);
    procedure btnSmallIconsClick(Sender: TObject);
    procedure btnListClick(Sender: TObject);
    procedure btnDetailsClick(Sender: TObject);
    procedure cbxTreeViewDragEnabledClick(Sender: TObject);
    procedure cbxTreeViewCopyClick(Sender: TObject);
    procedure cbxTreeViewMoveClick(Sender: TObject);
    procedure cbxTreeViewLinkClick(Sender: TObject);
    procedure cbxTreeViewDropEnabledClick(Sender: TObject);
    procedure rbnTreeViewMoveOnlyClick(Sender: TObject);
    procedure cbxListViewDragEnabledClick(Sender: TObject);
    procedure cbxListViewCopyClick(Sender: TObject);
    procedure cbxListViewMoveClick(Sender: TObject);
    procedure cbxListViewLinkClick(Sender: TObject);
    procedure cbxListViewDropEnabledClick(Sender: TObject);
    procedure rbnListViewDefaultClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
    procedure OrtusShellTreeView1DragOver(Sender, Source: TObject; X,
      Y: Integer; State: TDragState; var Accept: Boolean);
    procedure OrtusShellListView1DragDrop(Sender, Source: TObject; X,
      Y: Integer);
    procedure OrtusShellListView1EndDrag(Sender, Target: TObject; X,
      Y: Integer);
    procedure OrtusShellTreeView1ContextMenuPopup(Sender: TObject;
      Items: TOrtusShellItems; var Accept: Boolean);
    procedure OrtusShellListView1ContextMenuPopup(Sender: TObject;
      Items: TOrtusShellItems; var Accept: Boolean);
    procedure OrtusShellTreeView1ContextMenuCommand(Sender: TObject;
      Items: TOrtusShellItems; const Command: String; var Accept: Boolean);
    procedure OrtusShellListView1ContextMenuCommand(Sender: TObject;
      Items: TOrtusShellItems; const Command: String; var Accept: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.btnUpClick(Sender: TObject);
begin
  OrtusShellListView1.UpFolder;
end;

procedure TForm1.btnLargeIconsClick(Sender: TObject);
begin
  OrtusShellListView1.ViewStyle := vsIcon;
end;

procedure TForm1.btnSmallIconsClick(Sender: TObject);
begin
  OrtusShellListView1.ViewStyle := vsSmallIcon;
end;

procedure TForm1.btnListClick(Sender: TObject);
begin
  OrtusShellListView1.ViewStyle := vsList;
end;

procedure TForm1.btnDetailsClick(Sender: TObject);
begin
  OrtusShellListView1.ViewStyle := vsReport;
end;

procedure TForm1.cbxTreeViewDragEnabledClick(Sender: TObject);
begin
  OrtusShellTreeView1.OleDragEnabled := cbxTreeViewDragEnabled.Checked;
end;

procedure TForm1.cbxTreeViewCopyClick(Sender: TObject);
begin
  if cbxTreeViewCopy.Checked then
    OrtusShellTreeView1.OleDragEffects := OrtusShellTreeView1.OleDragEffects + [deCopy]
  else
    OrtusShellTreeView1.OleDragEffects := OrtusShellTreeView1.OleDragEffects - [deCopy];
end;

procedure TForm1.cbxTreeViewMoveClick(Sender: TObject);
begin
  if cbxTreeViewCopy.Checked then
    OrtusShellTreeView1.OleDragEffects := OrtusShellTreeView1.OleDragEffects + [deMove]
  else
    OrtusShellTreeView1.OleDragEffects := OrtusShellTreeView1.OleDragEffects - [deMove];
end;

procedure TForm1.cbxTreeViewLinkClick(Sender: TObject);
begin
  if cbxTreeViewCopy.Checked then
    OrtusShellTreeView1.OleDragEffects := OrtusShellTreeView1.OleDragEffects + [deLink]
  else
    OrtusShellTreeView1.OleDragEffects := OrtusShellTreeView1.OleDragEffects - [deLink];
end;

procedure TForm1.cbxTreeViewDropEnabledClick(Sender: TObject);
begin
  OrtusShellTreeView1.OleDropEnabled := cbxTreeViewDropEnabled.Checked;
end;

procedure TForm1.rbnTreeViewMoveOnlyClick(Sender: TObject);
begin
  if rbnTreeViewDefault.Checked then
    OrtusShellTreeView1.OleDropEffect := deDefault
  else
    if rbnTreeViewCopyOnly.Checked then
      OrtusShellTreeView1.OleDropEffect := deCopyOnly
    else
      if rbnTreeViewMoveOnly.Checked then
        OrtusShellTreeView1.OleDropEffect := deMoveOnly
      else
        OrtusShellTreeView1.OleDropEffect := deLinkOnly;
end;

procedure TForm1.cbxListViewDragEnabledClick(Sender: TObject);
begin
  OrtusShellListView1.OleDragEnabled := cbxListViewDragEnabled.Checked;
end;

procedure TForm1.cbxListViewCopyClick(Sender: TObject);
begin
  if cbxListViewCopy.Checked then
    OrtusShellListView1.OleDragEffects := OrtusShellListView1.OleDragEffects + [deCopy]
  else
    OrtusShellListView1.OleDragEffects := OrtusShellListView1.OleDragEffects - [deCopy];
end;

procedure TForm1.cbxListViewMoveClick(Sender: TObject);
begin
  if cbxListViewMove.Checked then
    OrtusShellListView1.OleDragEffects := OrtusShellListView1.OleDragEffects + [deMove]
  else
    OrtusShellListView1.OleDragEffects := OrtusShellListView1.OleDragEffects - [deMove];
end;

procedure TForm1.cbxListViewLinkClick(Sender: TObject);
begin
  if cbxListViewLink.Checked then
    OrtusShellListView1.OleDragEffects := OrtusShellListView1.OleDragEffects + [deLink]
  else
    OrtusShellListView1.OleDragEffects := OrtusShellListView1.OleDragEffects - [deLink];
end;

procedure TForm1.cbxListViewDropEnabledClick(Sender: TObject);
begin
  OrtusShellListView1.OleDropEnabled := cbxListViewDropEnabled.Checked;
end;

procedure TForm1.rbnListViewDefaultClick(Sender: TObject);
begin
  if rbnListViewDefault.Checked then
    OrtusShellListView1.OleDropEffect := deDefault
  else
    if rbnListViewCopyOnly.Checked then
      OrtusShellListView1.OleDropEffect := deCopyOnly
    else
      if rbnListViewMoveOnly.Checked then
        OrtusShellListView1.OleDropEffect := deMoveOnly
      else
        OrtusShellListView1.OleDropEffect := deLinkOnly;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  Panel2.Width := 2 * (ClientWidth div 5);
end;

procedure TForm1.OrtusShellTreeView1DragOver(Sender, Source: TObject; X,
  Y: Integer; State: TDragState; var Accept: Boolean);
var
  DragDropInfo: TOrtusShellOleDragDropInfo;
  I: Integer;
begin
  case State of
    dsDragEnter: begin
    end;
    dsDragMove: begin
      DragDropInfo := Source as TOrtusShellOleDragDropInfo;

      lblDragSource.Caption := 'Drag source: ' + DragDropInfo.Source.PathName + ' [' + DragDropInfo.SourceItems.DisplayNames[0];
      for I := 1 to DragDropInfo.SourceItems.DisplayNames.Count - 1 do
        lblDragSource.Caption := lblDragSource.Caption + ', ' + DragDropInfo.SourceItems.DisplayNames[I];
      lblDragSource.Caption := lblDragSource.Caption + ']';

      if DragDropInfo.Target = nil then
        lblDropTarget.Caption := 'Drop target: '
      else
        lblDropTarget.Caption := 'Drop target: ' + DragDropInfo.Target.PathName;
    end;
    dsDragLeave: begin
      lblDragSource.Caption := '';
      lblDropTarget.Caption := '';
    end;
  end {case};
end;

procedure TForm1.OrtusShellListView1DragDrop(Sender, Source: TObject; X,
  Y: Integer);
begin
  lblDragSource.Caption := '';
  lblDropTarget.Caption := '';
end;

procedure TForm1.OrtusShellListView1EndDrag(Sender, Target: TObject; X,
  Y: Integer);
begin
  lblDragSource.Caption := '';
  lblDropTarget.Caption := '';

  if Target = nil then
    lblDragSource.Caption := 'Drag canceled'
  else
    lblDragSource.Caption := 'Drag accepted: X=' + IntToStr(X) + ', Y=' + IntToStr(Y);
end;

procedure TForm1.OrtusShellTreeView1ContextMenuPopup(Sender: TObject;
  Items: TOrtusShellItems; var Accept: Boolean);
begin
  if cbxTreeViewConfirmContextMenuPopup.Checked then
    Accept :=
      MessageDlg(
        'Do you want to popup the context menu for the following items ?' + #13#10#13#10 +
        Items.DisplayNames.Text,
        mtConfirmation, [mbYes, mbNo], 0
      ) = mrYes;
end;

procedure TForm1.OrtusShellListView1ContextMenuPopup(Sender: TObject;
  Items: TOrtusShellItems; var Accept: Boolean);
begin
  if cbxListViewConfirmContextMenuPopup.Checked then
    Accept :=
      MessageDlg(
        'Do you want to popup the context menu for the following items ?' + #13#10#13#10 +
        Items.DisplayNames.Text,
        mtConfirmation, [mbYes, mbNo], 0
      ) = mrYes;
end;

procedure TForm1.OrtusShellTreeView1ContextMenuCommand(Sender: TObject;
  Items: TOrtusShellItems; const Command: String; var Accept: Boolean);
begin
  if cbxTreeViewConfirmCommandExecute.Checked then
    Accept :=
      MessageDlg(
        'Do you want to execute the command "' + Command + '" on the following items ?' + #13#10#13#10 +
        Items.DisplayNames.Text,
        mtConfirmation, [mbYes, mbNo], 0
      ) = mrYes;
end;

procedure TForm1.OrtusShellListView1ContextMenuCommand(Sender: TObject;
  Items: TOrtusShellItems; const Command: String; var Accept: Boolean);
begin
  if cbxListViewConfirmCommandExecute.Checked then
    Accept :=
      MessageDlg(
        'Do you want to execute the command "' + Command + '" on the following items ?' + #13#10#13#10 +
        Items.DisplayNames.Text,
        mtConfirmation, [mbYes, mbNo], 0
      ) = mrYes;
end;

end.
