unit MyExpert;

{ my.Expert v1.00 - freeware stand-alone Expert for Delphi 4 (.BPL) }
{ ----------02.feb.1999------------------------ written -by- tkcham }
{ 1) Multi-Line Component Palette for Delphi 4                      }
{    enable  = just add this package to Delphi 4                    }
{    disable = un-check this package to Delphi 4                    }
{    *note* original source code from GExpert 0.96.1                }
{ ----------------------------------------- mailto:gongxi@tm.net.my }

{ ------------ VISION Software (M) Sdn. Bhd. (393369-T) ----------- }
{                                                                   }
{ [ my.Delphi Home ] Developer Home Page for Delphi                 }
{   http://www.geocities.com/SiliconValley/Peaks/6789/delphi.html   }
{   http://members.xoom.com/tkcham/delphi.html                      }
{                                                                   }
{ [ PasPDF Home ] Native PDF Creation for Delphi                    }
{   http://www.geocities.com/SiliconValley/Peaks/6789/pdfindex.html }
{   http://members.xoom.com/tkcham/pdfindex.html                    }
{                                                                   }
{ ----------------------------------------------------------------- }


{$ifndef ver120}
!! error !! "my.Expert" for Delphi 4 only
end.
{$endif}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, ExtCtrls,
  Forms, Dialogs, ComCtrls;

implementation

type

  TMyExpertObject = Class(TObject)
  public
    procedure ResizeMultiLineComponentPalette ( Sender: TObject );
  end;

var MyExpertObject1 : TMyExpertObject;

{ original source code from GExpert 0.96.1 }
procedure TMyExpertObject.ResizeMultiLineComponentPalette ( Sender: TObject );
var AHeight: Integer;
begin
  with Sender as TTabControl do begin
    AHeight := Height - ( DisplayRect.Bottom - DisplayRect.Top ) + 29;
    // AHeight := ( Trunc ( AHeight / 26 ) + 1 ) * 26;
    Constraints.MinHeight := AHeight;
    ( ( Sender as TTabControl ).Parent as TWinControl ).Constraints.MaxHeight := AHeight;
  end;
end;

procedure SetMultiLineComponentPalette ( _multiLine :boolean );
var App: TForm; TabControl: TTabControl;
begin
   App := TForm(Application.FindComponent ( 'AppBuilder' ) );
   if App <> nil then begin
     TabControl:=TTabControl ( App.FindComponent ( 'TabControl' ) );
     if TabControl <> nil then begin
       TabControl.MultiLine := _multiLine;
       if _multiLine then
         TabControl.OnResize := MyExpertObject1.ResizeMultiLineComponentPalette
       else
         TabControl.OnResize := nil;
    end;
   End;
end;

initialization

 { "Enable" at the beginning }
 MyExpertObject1 := TMyExpertObject.Create;
 SetMultiLineComponentPalette ( True );

finalization

 { "Disable" at the end or un-check }
 SetMultiLineComponentPalette ( False );
 MyExpertObject1.Free;

end.
