unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Midi, StdCtrls, SyncObjs, CheckLst;

type
  TForm1 = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    memLog: TMemo;
    Label3: TLabel;
    lbxInputDevices: TCheckListBox;
    lbxOutputDevices: TCheckListBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure lbxInputDevicesClickCheck(Sender: TObject);
    procedure lbxOutputDevicesClickCheck(Sender: TObject);
  private
    fCriticalSection: TCriticalSection;
  public
    procedure DoMidiInData( const aDeviceIndex: integer; const aStatus, aData1, aData2: byte );
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.DoMidiInData(const aDeviceIndex: integer; const aStatus,
  aData1, aData2: byte);
var
  i: integer;
  lHour, lMin, lSec, lMSec: Word;
begin
  // skip active sensing signals from keyboard
  if aStatus = $FE then Exit;

  fCriticalSection.Acquire;
  memLog.Lines.BeginUpdate;
  try

    // send the messages on to the selected output devices
    for i:=MidiOutput.Devices.COunt - 1 downto 0 do
      if lbxOUtputDevices.Checked[i] then
      begin
        MidiOutput.Send( i, aStatus, aData1, aData2 );
        memLog.Lines.Insert( 0, ' -->' + MidiOutput.Devices[i] );
      end;

    // print the message log
    DecodeTime( now, lHour, lMin, lSec, lMSec );
    memLog.Lines.Insert( 0, Format( '[%.2d:%.2d:%.2d:%.3d] %s: <Status> %.2x, <Data 1> %.2x <Data 2> %.2x',
      [ lHour, lMin, lSec, lMSec,
        MidiInput.Devices[aDeviceIndex],
        aStatus,
        aData1,
        aData2 ] ));
  finally
    memLog.Lines.EndUpdate;
    fCriticalSection.Leave;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  fCriticalSection := TCriticalSection.Create;
  lbxInputDevices.Items.Assign( MidiInput.Devices );
  lbxOutputDevices.Items.Assign( MidiOutput.Devices );

  MidiInput.OnMidiData := DoMidiInData;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  fCriticalSection.Free;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  MidiInput.CloseAll;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  MidiOutput.CloseAll;
end;

procedure TForm1.lbxInputDevicesClickCheck(Sender: TObject);
begin
  if lbxINputDevices.Checked[ lbxInputDevices.ItemIndex ] then
    MidiInput.Open( lbxInputDevices.ItemIndex )
  else
    MidiInput.Close( lbxInputDevices.ItemIndex )
end;

procedure TForm1.lbxOutputDevicesClickCheck(Sender: TObject);
begin
  if lbxOutputDevices.Checked[ lbxOutputDevices.ItemIndex ] then
    MidiOutput.Open( lbxOutputDevices.ItemIndex )
  else
    MidiOutput.Close( lbxOutputDevices.ItemIndex )
end;

end.
