{+--------------------------------------------------------------------------+
 | Class:       TmVmtMethodList
 | Created:     8.98
 | Author:      Martin Waldenburg
 | Copyright    1998 all rights reserved.
 | Description: Fills a stringlist with descriptions of Methods from the VMT
 |              of a given class.
 | Version:     1.0
 | Status:      FreeWare
 | Disclaimer:
 | This is provided as is, expressly without a warranty of any kind.
 | You use it at your own risc.
 +--------------------------------------------------------------------------+}
unit mwVmtMethodList;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, TypInfo;

type
  { Published method record }
  PVmtMethod = ^TVmtMethod;
  TVmtMethod = packed record
    Size: Word;
    Address: Pointer;
    Name: ShortString;
  end;
  { Published method table }
  PVmtMethodTable = ^TVmtMethodTable;
  TVmtMethodTable = packed record
    Count: Word;
    Methods: array[0..MaxListSize] of Byte;
    { Methods: array[1..Count] of TVmtMethod; }
  end;

  PPointer=^Pointer;

  TmVmtMethodList = class(TObject)
  private
  protected
    { Protected-Deklarationen}
  public
    Class procedure GetMethodInfo(aObject: Tobject; List: TStringList);
  published
    { Published-Deklarationen }
  end;

implementation

{ TmVmt }

Class procedure TmVmtMethodList.GetMethodInfo(aObject: Tobject; List: TStringList);
var
  I: Integer;
  Meth: PVmtMethod;
  MethodTable: PvmtMethodTable;
  Ptr: PByte;
begin
  MethodTable:=ppointer(longint(pointer(aObject.ClassType)) + vmtMethodTable)^;
  if MethodTable <> Nil then
  begin
    List.Add('');
    List.Add('MethodTable');
    List.Add('  Count: ' + IntToStr(MethodTable^.Count));
    Ptr := PByte(@MethodTable^.Methods);
    for I := 1 to MethodTable^.Count do
    begin
      Meth := PVmtMethod(Ptr);
      with Meth^ do
      begin
        Inc(Ptr, Meth.Size);
        List.Add('    Method: ' + IntToStr(I) + '  ' + Meth.Name + ' = ' + IntToStr(Integer(Meth.Address)));
      end;
    end;
  end;
end;

end.
