unit mwIDETree;
{
  Vcl IDETree Expert

  Author:  Martin_Waldenburg
  Created: 8.98
  Version: 0.7 beta
  Status: FreeWare
  You can learn more about RTTI routines
  from the book " Secrets of Delphi 2 "  by Ray Lischner.
  In my opinion the best Delphi book.
  Unfortunately it's out of print,
  however if the demand is large enough, maybe...

  Disclaimer:  This is provided as is, expressly without a
              warranty of any kind.
              You use it at your own risc.
}

interface

uses SysUtils,
  Classes,
  Messages,
  Consts,
  Forms,
  Windows,
  Dialogs,
  ClipBrd,
  Controls,
  ToolsApi,
  ExtCtrls,
  Menus,
  comCtrls,
  StdCtrls,
  LibIntf,
  TypInfo,
  WinTypes,
  mwTypeList,
  mwVmtMethodList;

type
  TfrmIDETree = class(TForm)
    Memo1: TMemo;
    TreeView1: TTreeView;
    Splitter1: TSplitter;
    IDETreePopup: TPopupMenu;
    ApplicationPop: TMenuItem;
    ScreenPop: TMenuItem;
    procedure TreeView1Change(Sender: TObject; Node: TTreeNode);
    procedure FormShow(Sender: TObject);
    procedure TreeView1Deletion(Sender: TObject; Node: TTreeNode);
    procedure ApplicationPopClick(Sender: TObject);
    procedure ScreenPopClick(Sender: TObject);
  private
    FRoot: TComponent;
  public
    { public declarations }
  end;

  TIDETreeExpert = class(TInterfacedObject, IOTAMenuWizard, IOTAWizard)
  private
  protected
  public
    constructor Create; virtual;
    destructor Destroy; override;
    function GetName: string;
    function GetAuthor: string;
    function GetIDString: string;
    procedure AfterSave;
    procedure BeforeSave;
    procedure Modified;
    procedure Destroyed;
    procedure Execute;
    function GetMenuText: string;
    function GetState: TWizardState;
  end;

procedure Register;
var
  frmIDETree: TfrmIDETree;

implementation

{$R *.DFM}

procedure Register;
begin
  RegisterPackageWizard(TIDETreeExpert.Create);
end;

{ TIDETreeExpert code }
function TIDETreeExpert.GetName: String;
begin
  Result := 'IDETreeExpert'
end;

function TIDETreeExpert.GetAuthor: String;
begin
  Result := 'Martin_Waldenburg'; { author }
end;

function TIDETreeExpert.GetIDString: String;
begin
  Result := 'private.IDETreeExpert';
end;

function AddType(aNode: TTreeNode; Name: String; aObject: TObject): TTreeNode;
begin
  Result:= frmIDETree.TreeView1.Items.AddChild(aNode, Name + ': ' + PTypeInfo(aObject.ClassInfo)^.Name);
  Result.Data:= aObject;
end;

procedure ScanComponents(aNode: TTreeNode; aComponent: TComponent);
var
  I: Integer;
begin
  aNode:= AddType(aNode, aComponent.Name, aComponent);
  for I:= 0 to aComponent.ComponentCount -1 do
  begin
   ScanComponents(aNode, aComponent.Components[I]);
  end;
end;

procedure LookupStuff;
Begin
  frmIDETree.Memo1.Clear;
  ScanComponents(nil, frmIDETree.FRoot);
End;

{ TfrmIDETree code }

procedure TfrmIDETree.TreeView1Change(Sender: TObject; Node: TTreeNode);
begin
  Memo1.Clear;
  Memo1.Lines.BeginUpdate;
  try
    TmTypeList.GetInfo(TObject(Node.Data), TStringList(Memo1.Lines));
    TmVmtMethodList.GetMethodInfo(TObject(Node.Data), TStringList(Memo1.Lines));
  finally
    Memo1.Lines.EndUpdate;
  end;
end;

procedure TfrmIDETree.FormShow(Sender: TObject);
begin
  Memo1.Clear;
  TreeView1.Items.BeginUpdate;
  TreeView1.Items.Clear;
  fRoot:= Application;
  LookupStuff;
  TreeView1.Items.EndUpdate;
end;

procedure TfrmIDETree.TreeView1Deletion(Sender: TObject; Node: TTreeNode);
begin
  Node.Data:= nil;
end;

procedure TIDETreeExpert.AfterSave;
begin

end;

procedure TIDETreeExpert.BeforeSave;
begin

end;

constructor TIDETreeExpert.Create;
begin

end;

destructor TIDETreeExpert.Destroy;
begin
  inherited Destroy;
  frmIDETree.Free;
end;

procedure TIDETreeExpert.Destroyed;
begin

end;

procedure TIDETreeExpert.Execute;
begin
  if not Assigned(frmIDETree) then
    frmIDETree := TfrmIDETree.Create(nil);
  frmIDETree.Show;
  frmIDETree.SetFocus
end;

function TIDETreeExpert.GetMenuText: string;
begin
  Result:= 'IDETree';
end;

function TIDETreeExpert.GetState: TWizardState;
begin
  Result := [wsEnabled];
end;

procedure TIDETreeExpert.Modified;
begin

end;

procedure TfrmIDETree.ApplicationPopClick(Sender: TObject);
begin
  Memo1.Clear;
  TreeView1.Items.BeginUpdate;
  TreeView1.Items.Clear;
  fRoot:= Application;
  LookupStuff;
  TreeView1.Items.EndUpdate;
end;

procedure TfrmIDETree.ScreenPopClick(Sender: TObject);
var
  I: Integer;
  aNode: TTreeNode;
begin
  Memo1.Clear;
  TreeView1.Items.BeginUpdate;
  TreeView1.Items.Clear;
  fRoot:= Screen;
  aNode:= AddType(nil, Screen.Name, Screen);
  for I:= 0 to Screen.FormCount -1 do
    ScanComponents(aNode, Screen.Forms[I]);
  TreeView1.Items.EndUpdate;
end;

end.
