unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, ProCtrls, Tools1, About,
  Spin, RXCtrls, RXSpin, RXShell;

type
  TBarFrm = class(TForm)
    Panel1: TPanel;
    Panel2: TPanel;
    Image1: TImage;
    Button1: TRxSpeedButton;
    Button2: TRxSpeedButton;
    Button3: TRxSpeedButton;
    Button4: TRxSpeedButton;
    Button5: TRxSpeedButton;
    Button6: TRxSpeedButton;
    Button7: TRxSpeedButton;
    Button8: TRxSpeedButton;
    Button9: TRxSpeedButton;
    Button10: TRxSpeedButton;
    PrevBtn: TRxSpeedButton;
    RxSpeedButton2: TRxSpeedButton;
    Panel3: TPanel;
    Image2: TImage;
    HideBtn: TRxSpeedButton;
    ShowBtn: TRxSpeedButton;
    SetBtn: TRxSpeedButton;
    InfoBtn: TRxSpeedButton;
    HelpBtn: TRxSpeedButton;
    ExitBtn: TRxSpeedButton;
    ComboBox1: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure SetBar1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure ButtonAllClick(Sender: TObject);
    procedure ComboBox1Click(Sender: TObject);
    procedure AppIdle(Sender: TObject; var Done: Boolean);
    procedure AppActivate(Sender: TObject);
    procedure AppDeactivate(Sender: TObject);
    procedure HelpBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure InfoBtnClick(Sender: TObject);
    procedure NextBtnClick(Sender: TObject);
    procedure PrevBtnClick(Sender: TObject);
    procedure HideBtnClick(Sender: TObject);
    procedure ShowBtnClick(Sender: TObject);
  protected
    procedure WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo);
                                  message wm_GetMinMaxInfo;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHitTest;
  private
    procedure DoFileExecute(configNumber:Integer);
    procedure IncrTop;
    procedure DecrTop;
    { Private declarations }
  public
    TheButtons : Array[1..10] of TRxSpeedButton;
    { Public declarations }
  end;

var
  BarFrm: TBarFrm;

implementation

{$R *.DFM}
uses Config;

{Call procedure to launch programs and determines some behaviors of Bar}
procedure TBarFrm.DoFileExecute(configNumber:Integer);
var
   {rc           : Integer;
   fName        : PChar;}
   numbString,
   FileName,
   InitialDir   : String;
begin
  numbString := IntToStr(configNumber);
  FileName   := Tools1.Programs[configNumber];

  if FileName <> '' then
  begin
    InitialDir := ExtractFilePath(FileName);
    ExecuteFile(FileName,'',Initialdir, SW_SHOW);
    if Config.CfgFrm.CheckSmall.Checked = true then
    begin
      BarFrm.Height := 56;
    end
    else begin
      BarFrm.Height := 303;
    end;
    if Config.CfgFrm.CheckMin.Checked = true then
    BarFrm.WindowState := wsMinimized
    else
    BarFrm.WindowState := wsNormal;
  end;
end;

{Set Min and Max dimensions of MgBar}
procedure TBarFrm.WMGetMinMaxInfo(var Message: TWMGetMinMaxInfo);
begin
  with Message.MinMaxInfo^ do
  begin
    ptMaxTrackSize.X := 138;
    ptMaxTrackSize.Y := 303;
    ptMinTrackSize.X := 138;
    ptMinTrackSize.Y := 56;
  end;
end;

{initializes array of buttons, and call combobox items setting active item}
procedure TBarFrm.FormCreate(Sender: TObject);
begin
  Main.BarFrm.Height := 56;
  TheButtons[1]  := Button1;
  TheButtons[2]  := Button2;
  TheButtons[3]  := Button3;
  TheButtons[4]  := Button4;
  TheButtons[5]  := Button5;
  TheButtons[6]  := Button6;
  TheButtons[7]  := Button7;
  TheButtons[8]  := Button8;
  TheButtons[9]  := Button9;
  TheButtons[10] := Button10;
  ComboBox1.Items.LoadFromFile(((ExtractFilePath(Application.ExeName))+'Items.txt'));
  ComboBox1.ItemIndex := 0;
  Application.OnIdle := AppIdle;
  Application.OnActivate := AppActivate;
  Application.OnDeactivate := AppDeactivate;
end;

{verifies if buttons captions must be uppercase and if there is a caption or not}
procedure TBarFrm.AppIdle(Sender: TObject; var Done: Boolean);
var
ix : Integer;
begin
  if Config.cfgFrm = nil then
  begin
    Done := False;
  end
  else
  begin
    for ix := 1 to 10 do
    begin
      if Config.CfgFrm.CheckUppercase.Checked then
        TheButtons[ix].Caption := UpperCase(TheButtons[ix].caption);
      if TheButtons[iX].caption = '' then
        TheButtons[iX].caption := '?';
    end;
    Done := False;
  end;
end;

{set authomatic resize for onActivate event}
procedure TBarFrm.AppActivate(Sender: TObject);
begin
  if Config.CfgFrm.CheckResize.Checked then
  begin
    Main.BarFrm.Height := 303;
    DecrTop;
  end;
end;

{set authomatic resize for onDeactivate event}
procedure TBarFrm.AppDeactivate(Sender: TObject);
begin
  if Config.CfgFrm.CheckResize.Checked then
  begin
    Main.BarFrm.Height := 56;
    IncrTop;
  end;
end;

procedure TBarFrm.SetBar1Click(Sender: TObject);
begin
  Config.CfgFrm.Show;
end;

procedure TBarFrm.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TBarFrm.ComboBox1Change(Sender: TObject);
var
  tabOfset : Integer;
  ix       : Integer;
begin
  tabOfset := ComboBox1.ItemIndex * 10;
  for ix := 1 to 10 do
  begin
    TheButtons[iX].caption := Tools1.Captions[tabOfset+ix];
    TheButtons[iX].enabled := (Tools1.Programs[tabOfset+ix] <> '');
  end;
end;

procedure TBarFrm.ButtonAllClick(Sender: TObject);
begin
  doFileExecute(ComboBox1.ItemIndex * 10
                + TRxSpeedButton(Sender).Tag);
end;

procedure TBarFrm.ComboBox1Click(Sender: TObject);
begin
  Main.BarFrm.Height := 303;
end;

procedure TBarFrm.HelpBtnClick(Sender: TObject);
begin
 Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TBarFrm.FormDestroy(Sender: TObject);
begin
  Application.HelpCommand(HELP_QUIT, 0);
end;

procedure TBarFrm.InfoBtnClick(Sender: TObject);
begin
  About.AboutBox.ShowModal;
end;

procedure TBarFrm.NextBtnClick(Sender: TObject);
begin
  if ComboBox1.ItemIndex <> 9 then
    ComboBox1.ItemIndex := ComboBox1.ItemIndex + 1;
    ComboBox1Change(Sender);
end;

procedure TBarFrm.PrevBtnClick(Sender: TObject);
begin
  if ComboBox1.ItemIndex <> 0 then
  begin
    ComboBox1.ItemIndex := ComboBox1.ItemIndex - 1;
    ComboBox1Change(Sender);
  end;
end;

procedure TBarFrm.HideBtnClick(Sender: TObject);
begin
  BarFrm.Height := 56;
  IncrTop;
end;

procedure TBarFrm.ShowBtnClick(Sender: TObject);
begin
  BarFrm.Height := 303;
  DecrTop;
end;

procedure TBarFrm.WMNCHitTest(var Message: TWMNCHitTest);
begin
  inherited;
  if Message.Result = htClient then
    Message.Result := htCaption;
end;

procedure TBarFrm.IncrTop;
begin
  if Config.CfgFrm.ComboBox3.ItemIndex = 1 then
     Main.BarFrm.Top := 500;
  if Config.CfgFrm.ComboBox3.ItemIndex = 2 then
     Main.BarFrm.Top := 242;
end;

procedure TBarFrm.DecrTop;
begin
  if Config.CfgFrm.ComboBox3.ItemIndex = 1 then
     Main.BarFrm.Top := 268;
  if Config.CfgFrm.ComboBox3.ItemIndex = 2 then
     Main.BarFrm.Top := 135;
end;


end.

