{ tools1.pas                                   by Marco Gasi / Edy Hinzen 1998 }
{ addinitional routines for MGBar project                                      }

unit Tools1;

interface

uses sysutils, winprocs, wintypes, BigIni;

procedure ExecuteFile(ExeName,ExeParms,Initialdir:String; CmdShow: Word);
procedure DoInitIniFile;
procedure DoSaveIniFile;
procedure DoDropIniFile;

var {they are public to other units/forms}
{** this is not the best technique, cause you may reach the 64k-limit when
unsing bigger arrays (let's say [1..200]) }
  Programs      : Array[1..100] of String;
  Captions      : Array[1..100] of String[30];
  IniFile       : TAppIniFile;

implementation

{------------------------------------------------------------------------------}
{ Runs a Windows or DOS command                                                }
{------------------------------------------------------------------------------}
procedure ExecuteFile(ExeName,ExeParms,Initialdir:String; CmdShow: Word);
var
  rc           : word;
  CmdLine      : PChar;
begin
  ChDir(Initialdir);                            { change current directory }
  GetMem(CmdLine,256);                          { allocate memory to pointer }
  { I hope, I interpreted the second parameter correctly as ExeParms: }
  if ExeParms <> '' then ExeName := ExeName + ' ' +ExeParms;
  CmdLine := StrPCopy(CmdLine,ExeName);         { copy params into CmdLine }
  rc := WinExec(CmdLine, SW_SHOW);              { call exe program }
  FreeMem(CmdLine,256);                         { free memory again }
end;

{------------------------------------------------------------------------------}
{ create an instance for inifile and read *.ini from disk                      }
{------------------------------------------------------------------------------}
procedure DoInitIniFile;
var
  ix : Integer;
begin
  inifile := TAppIniFile.Create;
  for ix := low(programs) to high(programs) do
  begin
    {** you may still want to use this (compatible to your old ini):
    Programs[ix] := IniFile.ReadString('Config', 'Prog'+IntToStr(ix), '');
    Captions[ix] := IniFile.ReadString('Config', 'Caption'+IntToStr(ix), '');
    }
    {** I prefer this: }
    Programs[ix] := IniFile.ReadString('Config.Prog',IntToStr(ix), '');
    Captions[ix] := IniFile.ReadString('Config.Caption',IntToStr(ix), '');
  end;
end;

{------------------------------------------------------------------------------}
{ releases memory of inifile instance                                          }
{------------------------------------------------------------------------------}
procedure DoDropIniFile;
begin
  inifile.Free;
end;

{------------------------------------------------------------------------------}
{ saves current settings to *.ini file                                         }
{------------------------------------------------------------------------------}
procedure DoSaveIniFile;
var
  ix : Integer;
begin
  IniFile.EraseSection('Config.File');
  IniFile.EraseSection('Config.Prog');
  IniFile.EraseSection('Config.Caption');
  for ix := low(programs) to high(programs) do
  begin
    {** you may still want to use this:
    IniFile.WriteString('Config', 'Prog'+IntToStr(ix), Programs[ix]);
    IniFile.WriteString('Config', 'Caption'+IntToStr(ix), Captions[ix]);
    }
    {** I prefer this: }
    if Programs[ix] <> '' then IniFile.WriteString('Config.Prog',IntToStr(ix), Programs[ix]);
    if Captions[ix] <> '' then IniFile.WriteString('Config.Caption',IntToStr(ix), Captions[ix]);
  end;
  inifile.FlushFile;
end;

{------------------------------------------------------------------------------}
{ unit's main program / start routine                                          }
{------------------------------------------------------------------------------}
begin
  inifile := Nil; { in case of calls prior to DoInitIniFile }
end.
