(*

Component name...................: Mail2000 (Mail2000.pas)
Classes implemented..............: TPOP2000, TSMTP2000, TMailMessage2000
Version..........................: 1.8.1
Status...........................: Beta
Last update......................: 2001-02-21
Author...........................: Marcello Tavares
Comments, bugs, suggestions to...: tmail2000@yahoogroups.com
Language.........................: English
Platform (tested)................: Windows 95/98/98SE
Requires.........................: Borland Delphi 5 Professional or Enterprise

Features
--------

1. Retrieve and delete messages from POP3 servers;

2. Interpret and divide MIME or UUE messages in header, body, alternative
   texts and attachments;

3. Implement methods to create new MIME messages or handle and modify
   retrieved messages for further resending or processing;

4. Enable access to the integral message source for manual manipulation or
   database storing;

5. Send messages to SMTP servers.


Know limitations
----------------

1. Does not build UUCODE messages;

2. SMTP and POP3 doesn't work with slow connections (dial-up for instance);

3. Some problems when running on Windows NT/2000/ME;

4. Strange behaviours when netlink not present;

5. Some troubles when sending big messages;

6. Some bugs here or there...


Future improvements
-------------------

1. Work with threads;

2. More and more detailed error messages;

3. Native calls to WinSock;

4. WAN support.


How to install
--------------

Create a directory;
Extract archive contents on it;
Open Delphi;
Click File/Close All;
Click Component/Install Component;
In "Unit File Name" select mail2000.pas;
Click Ok;
Select Yes to rebuild package;
Wait for the message saying that the component is installed;
Click File/Close All;
Select Yes to save the package;
Now try to run the demo.


How to use
----------

The better way to learn is looking at the demo source.
Please open and run Demo.dpr
I'm not planning to type a help file.
Fell free to mail your questions to me.


License stuff
-------------

Mail2000 Copyleft 1999-2001

This software is provided as-is, without any express or implied
warranty. In no event will the author be held liable for any damages
arising from the use of this software.

As a freeware, the author reserve your rights to not provide support,
requested changes in the code, specific versions, improvements of any
kind and bug fixes. The main purpose is to help a little the programmers
community over the world as a whole, not just one person or organization.

Permission is granted to anyone to use this software for any purpose,
including commercial applications, and to alter it and redistribute it
freely, subject to the following restrictions:

1. The origin of this software must not be misrepresented, you must not
   claim that you wrote the original software. If you use this software
   in a product, an acknowledgment in the product documentation would be
   appreciated.

2. Altered source versions must be plainly marked as such, and must not be
   misrepresented as being the original software.

3. If you make changes to this software, you must send me the modified
   integral version.

Please, consider my hard work.


Thanks to
---------

Mariano D. Podesta (marianopodesta@usa.net) - The author of wlPop3
component, from where I copied some decoding routines;

Sergio Kessler (sergio@perio.unlp.edu.ar) - The author of SakEmail
component, from where I based my encoding and smtp algorithms;

Delphi Super Page (http://sunsite.icm.edu.pl/delphi/) - For providing
the best way to find great programs and to join the Delphi community;

Yunarso Anang (yasx@hotmail.com) - For providing some functions for
correct threatment of oriental charsets;

Christian Bormann (chris@xynx.de) - For giving a lot of suggestions
and hard testing of this component;

Tommy Andersen (sorry, I lost his address) - For warning about some
bugs in code;

Kunikazu Okada (kunikazu@okada.cc) - For detailed and careful suggestions
to help mail composition;

Anderson (andermuller@conex.com.br) - Advices;

Rene de Jong (rmdejong@ism.nl) - Extensive bugfixes;


Anyone interested in helping me to improve this component, including you,
just by downloading it.


What's new in 1.1 version
-------------------------

1.  Fixed the threatment of encoded fields in header;
2.  Fixed some fake attachments found in message;
3.  Included a string property "LastMessage" containing the source of
    last message retrieved;
4.  Now decoding file names;
5.  Fixed way to identify kind of host address;
6.  Added support for some tunnel proxy servers (eg via telnet port);
7.  Socket changed to non-blocking to improve communication;
8.  Fixed crashes when decoding encoded labels;
9.  Fixed header decoding with ansi charsets;
10. Fixed crashes when there are deleted messages on server;
11. Now recognizing text/??? file attachments;
12. Added Content-ID label at attachment header, now you can reference
    attached files on HTML code as <img src=cid:file.ext>;
13. Improved a lot the speed when decoding messages;
14. Thousands of minor bug fixes.


What's new in 1.2 version
-------------------------

1.  Added HELO command when talking to SMTP server;
2.  Changed CCO: fields (in portuguese) to BCC:
3.  It doesn't remove BCC: field after SMTP send anymore;
4.  Some random bugs fixed.


What's new in 1.3 version
-------------------------

1.  POP and SMTP routines discontinued, but they will remain in the code;
2.  Some suggestions added.


What's new in 1.4 version
-------------------------

1.  Improved UUCODE decoding;
2.  Range overflow bugs fixed;
3.  Changed MailMessage to MailMessage2000 to avoid class name conflicts.


What's new in 1.5 version
-------------------------

1.  I decided to improve POP and SMTP, but still aren't reliable;
2.  Another sort of bug fixes;
3.  TPOP2000.RetrieveHeader procedure added;
4.  TPOP2000.DeleteAfterRetrieve property added;
5.  Improved threatment of messages with no text parts;
6.  Proxy support will remain, but has been discontinued;
7.  TMailMessage2000.LoadFromFile procedure added;
8.  TMailMessage2000.SaveToFile procedure added.


What's new in 1.6 version
-------------------------

1.  Fixed expecting '+OK ' instead of '+OK' from SMTP;
2.  Stopped using TClientSocket.ReceiveLength, which is innacurate.


What's new in 1.7 version
-------------------------

1.  Handling of 'Received' (hop) headers. Now it is possible to trace the
    path e-mail went on;
2.  Again, bug fixes;
3.  Added properties to read (and just to read) 'To:' information and 'Cc:'
    information using TStringList;
4.  Added procedures to set destinations in comma-delimited format;
5.  Removed text/rtf handling.


What's new in 1.8 version
-------------------------

1.  Guess what? Bug fixes;
2.  Some memory leaks identified;
3.  Improved SMTP processing.


Author data
-----------

Marcello Roberto Tavares Pereira
mycelo@yahoo.com
http://mpanda.8m.com
ICQ 5831833
Sorocaba/SP - BRAZIL
Spoken languages: Portuguese, English, Spanish


Discussion Group
----------------

Please join TMail2000 group, exchange information about mailing
application development with another power programmers, and receive
suggestions, advices, bugfixes and updates for this component.

http://groups.yahoo.com/group/tmail2000

tmail2000@yahoogroups.com


*)

unit Mail2000;

{Please don't remove the following line:}
{$BOOLEVAL OFF}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  WinSock, ScktComp, Math, Registry, ExtCtrls;

type

  TMailPartList = class;
  TMailMessage2000 = class;
  TSocketTalk = class;

  TMessageSize = array of Integer;

  TSessionState = (stNone, stProxy, stConnect, stUser, stPass, stStat, stList, stRetr, stDele, stHelo, stMail, stRcpt, stData, stSendData, stQuit);
  TTalkError = (teGeneral, teSend, teReceive, teConnect, teDisconnect, teAccept, teTimeout, teNoError);

  TProgressEvent = procedure(Sender: TObject; Total, Current: Integer) of object;
  TEndOfDataEvent = procedure(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean) of object;
  TSocketTalkErrorEvent = procedure(Sender: TObject; SessionState: TSessionState; TalkError: TTalkError) of object;
  TReceiveDataEvent = procedure(Sender: TObject; Sessionstate: TSessionState; Data: String; var ServerResult: Boolean) of object;

  TReceivedField = (reFrom, reBy, reFor, reDate, reNone);

  TReceived = record
    From: String;
    By: String;
    Address: String;
    Date: TDateTime;
  end;

  { TMailPart - A recursive class to handle parts, subparts, and the mail by itself }

  TMailPart = class(TComponent)
  private

    FHeader: TStringList {TMailText};
    FBody: TMemoryStream;
    FDecoded: TMemoryStream;
    FBoundary: String;
    FOwnerMessage: TMailMessage2000;
    FSubPartList: TMailPartList;
    FOwnerPart: TMailPart;
    FAttachedMessage: TMailMessage2000;
    FIsDecoded: Boolean;

    function GetAttachInfo: String;
    function GetFileName: String;

    procedure SetAttachInfo(AttachInfo: String);
    procedure SetFileName(FileName: String);

    procedure EncodeText;
    procedure EncodeBinary;

  public

    constructor Create(AOwner: TComponent); override;
		destructor Destroy; override;

    function GetLabelValue(cLabel: String): String;                           // Get the value of a label. e.g. Label: value
    function GetLabelParamValue(cLabel, Param: String): String;               // Get the value of a label parameter. e.g. Label: xxx; param=value
    function LabelExists(cLabel: String): Boolean;                            // Determine if a label exists
    function LabelParamExists(cLabel, Param: String): Boolean;                // Determine if a label parameter exists

    function Decode: Boolean;                                                 // Decode body in Decoded stream and result true if successful

    procedure SetLabelValue(cLabel, cValue: String);                          // Set the value of a label
    procedure SetLabelParamValue(cLabel, cParam, cValue: String);             // Set the value of a label parameter

    procedure Fill(Data: PChar; HasHeader: Boolean);                          // Store the data on mail part (divide body, header, determine subparts)
    procedure Remove;                                                         // Delete this mailpart from message

    procedure LoadFromFile(FileName: String);                                 // Load the data from a file
    procedure SaveToFile(FileName: String);                                   // Save the data to a file

    property Header: TStringList {TMailText} read FHeader;                    // The header text
    property Body: TMemoryStream read FBody;                                  // The original body
    property Decoded: TMemoryStream read FDecoded;                            // Stream with the body decoded
    property Boundary: String read FBoundary;                                 // String that divides this mail part from others
    property SubPartList: TMailPartList read FSubPartList;                    // List of subparts of this mail part
    property FileName: String read GetFileName write SetFileName;             // Name of file when this mail part is an attached file
    property AttachInfo: String read GetAttachInfo write SetAttachInfo;       // E.g. application/octet-stream
    property OwnerMessage: TMailMessage2000 read FOwnerMessage;               // Main message that owns this mail part
    property OwnerPart: TMailPart read FOwnerPart;                            // Father part of this part (can be the main message too)
    property AttachedMessage: TMailMessage2000 read FAttachedMessage;         // If this part is a message/rfc822, here is the message (need Decode)
    property IsDecoded: Boolean read FIsDecoded;                              // If this part is decoded
  end;

  { TMailPartList - Just a collection of TMailPart's }

	TMailPartList = class(TList)
	private

		function Get(const Index: Integer): TMailPart;

	public

		destructor Destroy; override;

		property Items[const Index: Integer]: TMailPart read Get; default;
	end;

  { TMailMessage2000 - A descendant of TMailPart with some tools to handle the mail }

  TMailMessage2000 = class(TMailPart)
  private

    FAttachList: TMailPartList;
    FTextPlain: TStringList;
    FTextHTML: TStringList;
    FTextPart: TMailPart;
    FTextPlainPart: TMailPart;
    FTextHTMLPart: TMailPart;
    FCharset: String;
    FOnProgress: TProgressEvent;
    FNameCount: Integer;
    FToNames: TStringList;
    FToAddresses: TStringList;
    FCcNames: TStringList;
    FCcAddresses: TStringList;

    FNeedRebuild: Boolean;

    function GetDestName(Field: String; const Index: Integer): String;
    function GetDestAddress(Field: String; const Index: Integer): String;
    function GetDestCount(Field: String): Integer;

    function GetReceivedCount: Integer;
    function GetReceived(const Index: Integer): TReceived;

    function GetToName(const Index: Integer): String;
    function GetToAddress(const Index: Integer): String;
    function GetToCount: Integer;
    function GetCcName(const Index: Integer): String;
    function GetCcAddress(const Index: Integer): String;
    function GetCcCount: Integer;
    function GetBccName(const Index: Integer): String;
    function GetBccAddress(const Index: Integer): String;
    function GetBccCount: Integer;

    function GetFromName: String;
    function GetFromAddress: String;
    function GetReplyToName: String;
    function GetReplyToAddress: String;
    function GetSubject: String;
    function GetDate: TDateTime;
    function GetMessageId: String;

    procedure AddDest(Field, Name, Address: String);
    procedure SetDest(Field, Names, Addresses: String);

    procedure PutText(Text: String; Part: TMailPart; Content: String);

    procedure SetSubject(Subject: String);
    procedure SetDate(Date: TDateTime);
    procedure SetMessageId(MessageId: String);

  public

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AddTo(Name, Address: String);                                   // Add a To: destination to message header
    procedure AddCc(Name, Address: String);                                   // Add a Cc: destination to message header
    procedure AddBcc(Name, Address: String);                                  // Add a Bcc: destination to message header

    procedure SetTo(Names, Addresses: String);                                // Set To: destinations in commatext format
    procedure SetCc(Names, Addresses: String);                                // Set Cc: destinations in commatext format
    procedure SetBcc(Names, Addresses: String);                               // Set Bcc: destinations in commatext format

    procedure ClearTo;                                                        // Delete the To: field
    procedure ClearCc;                                                        // Delete the Cc: field
    procedure ClearBcc;                                                       // Delete the Bcc: field

    procedure SetFrom(Name, Address: String);                                 // Create/modify the From: field
    procedure SetReplyTo(Name, Address: String);                              // Create/modify the Reply-To: field

    procedure GetAttachList;                                                  // Search for the attachments and text
    procedure RebuildBody;                                                    // Build the mail body according to mailparts
    procedure Reset;                                                          // Clear all stored data in the object
    procedure AttachFile(FileName: String; ContentType: String = '');         // Create a mailpart and encode a file on it (doesn't rebuild body)
    procedure SetTextPlain(Text: TStrings);                                   // Create/modify a mailpart for text/plain (doesn't rebuild body)
    procedure SetTextHTML(Text: TStrings);                                    // Create/modify a mailpart for text/html (doesn't rebuild body)
    procedure RemoveTextPlain;                                                // Remove the first text/plain mailpart (doesn't rebuild body)
    procedure RemoveTextHTML;                                                 // Remove the first text/html mailpart (doesn't rebuild body)

    property ToName[const Index: Integer]: String read GetToName;             // Retrieve the name of To: destination number # (first is zero)
    property ToAddress[const Index: Integer]: String read GetToAddress;       // Retrieve the address of To: destination number #
    property ToCount: Integer read GetToCount;                                // Count the number of To: destinations
    property CcName[const Index: Integer]: String read GetCcName;             // Retrieve the name of Cc: destination number #
    property CcAddress[const Index: Integer]: String read GetCcAddress;       // Retrieve the address of Cc: destination number #
    property CcCount: Integer read GetCcCount;                                // Count the number of Cc: destinations
    property BccName[const Index: Integer]: String read GetBccName;           // Retrieve the name of Bcc: destination number #
    property BccAddress[const Index: Integer]: String read GetBccAddress;     // Retrieve the address of Bcc: destination number #
    property BccCount: Integer read GetBccCount;                              // Count the number of Bcc: destinations
    property Received[const Index: Integer]: TReceived read GetReceived;      // Retrieve the n-th 'Received' header
    property ReceivedCount: Integer read GetReceivedCount;                    // Count the instances of 'Received' fields (hops)
    property ToNames: TStringList read FToNames;                              // Names of To: destinations filled in a StringList (readonly! need GetAttachList)
    property CcNames: TStringList read FCcNames;                              // Names of Cc: destinations filled in a StringList (readonly! need GetAttachList)
    property ToAddresses: TStringList read FToAddresses;                      // Addresses of To: destinations filled in a StringList (readonly! need GetAttachList)
    property CcAddresses: TStringList read FCcAddresses;                      // Addresses of Cc: destinations filled in a StringList (readonly! need GetAttachList)

    property FromName: String read GetFromName;                               // Retrieve the From: name
    property FromAddress: String read GetFromAddress;                         // Retrieve the From: address
    property ReplyToName: String read GetReplyToName;                         // Retrieve the Reply-To: name
    property ReplyToAddress: String read GetReplyToAddress;                   // Retrieve the Reply-To: address
    property Subject: String read GetSubject write SetSubject;                // Retrieve or set the Subject: string
    property Date: TDateTime read GetDate write SetDate;                      // Retrieve or set the Date: in TDateTime format
    property MessageId: String read GetMessageId write SetMessageId;          // Retrieve or set the Message-Id:
    property AttachList: TMailPartList read FAttachList;                      // A list of all attached files (need GetAttachList)
    property TextPlain: TStringList read FTextPlain;                          // A StringList with the text/plain from message (need GetAttachList)
    property TextHTML: TStringList read FTextHTML;                            // A StringList with the text/html from message (need GetAttachList)
    property TextPlainPart: TMailPart read FTextPlainPart;                    // The text/plain part
    property TextHTMLPart: TMailPart read FTextHTMLPart;                      // The text/html part
    property NeedRebuild: Boolean read FNeedRebuild;                          // True if RebuildBody is needed

  published

    property Charset: String read FCharSet write FCharset;                    // Charset to build headers and text (allways 7bit)
    property OnProgress: TProgressEvent read FOnProgress write FOnProgress;   // Occurs when storing message in memory
  end;

  { TSocketTalk }

  TSocketTalk = class(TComponent)
  private

    FTimeOut: Integer;
    FExpectedEnd: String;
    FLastResponse: String;
    FDataSize: Integer;
    FPacketSize: Integer;
    FTalkError: TTalkError;
    FSessionState: TSessionState;
    FClientSocket: TClientSocket;
    FWaitingServer: Boolean;
    FTimer: TTimer;
    FServerResult: Boolean;

    FOnProgress: TProgressEvent;
    FOnEndOfData: TEndOfDataEvent;
    FOnSocketTalkError: TSocketTalkErrorEvent;
    FOnReceiveData: TReceiveDataEvent;
    FOnDisconnect: TNotifyEvent;

    procedure SocketRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure SocketError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure SocketDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure Timer(Sender: TObject);
  public

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure Talk(Buffer, EndStr: String; SessionState: TSessionState);
    procedure Cancel;
    procedure ForceState(SessionState: TSessionState);
    procedure WaitServer;

    property LastResponse: String read FLastResponse;
    property DataSize: Integer read FDataSize write FDataSize;
    property PacketSize: Integer read FPacketSize write FPacketSize;
    property TimeOut: Integer read FTimeOut write FTimeOut;
    property TalkError: TTalkError read FTalkError;
    property ClientSocket: TClientSocket read FClientSocket;
    property ServerResult: Boolean read FServerResult;

    property OnEndOfData: TEndOfDataEvent read FOnEndOfData write FOnEndOfData;
    property OnSocketTalkError: TSocketTalkErrorEvent read FOnSocketTalkError write FOnSocketTalkError;
    property OnReceiveData: TReceiveDataEvent read FOnReceiveData write FOnReceiveData;
    property OnProgress: TProgressEvent read FOnProgress write FOnProgress;
    property OnDisconnect: TNotifyEvent read FOnDisconnect write FOnDisconnect;
  end;

  { TPOP2000 }

  TPOP2000 = class(TComponent)
  private

    FMailMessage: TMailMessage2000;

    FSessionMessageCount: Integer;
    FSessionMessageSize: TMessageSize;
    FSessionConnected: Boolean;
    FSessionLogged: Boolean;
    FLastMessage: String;
    FSocketTalk: TSocketTalk;

    FUserName: String;
    FPassword: String;
    FPort: Integer;
    FHost: String;
    FProxyPort: Integer;
    FProxyHost: String;
    FProxyUsage: Boolean;
    FProxyString: String;
    FDeleteOnRetrieve: Boolean;

    procedure EndOfData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
    procedure SocketTalkError(Sender: TObject; SessionState: TSessionState; TalkError: TTalkError);
    procedure ReceiveData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
    procedure SocketDisconnect(Sender: TObject);

    function GetTimeOut: Integer;
    procedure SetTimeOut(Value: Integer);

    function GetProgress: TProgressEvent;
    procedure SetProgress(Value: TProgressEvent);

    function GetLastResponse: String;

  public

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    function Connect: Boolean;                                                // Connect to mail server
    function Login: Boolean;                                                  // Autenticate to mail server
    function Quit: Boolean;                                                   // Logout and disconnect

    function RetrieveMessage(Number: Integer): Boolean;                       // Retrieve mail number # and put in MailMessage
    function RetrieveHeader(Number: Integer): Boolean;
    function DeleteMessage(Number: Integer): Boolean;                         // Delete mail number #

    property SessionMessageCount: Integer read FSessionMessageCount;          // Number of messages found on server
    property SessionMessageSize: TMessageSize read FSessionMessageSize;       // Dynamic array with size of the messages
    property SessionConnected: Boolean read FSessionConnected;                // True if conencted to server
    property SessionLogged: Boolean read FSessionLogged;                      // True if autenticated on server
    property LastMessage: String read FLastMessage;                           // Last integral message text
    property LastResponse: String read GetLastResponse;                       // Last string received from server

  published

    property UserName: String read FUserName write FUserName;                 // User name to login on server
    property Password: String read FPassword write FPassword;                 // Password
    property Port: Integer read FPort write FPort;                            // Port (usualy 110)
    property Host: String read FHost write FHost;                             // Host address
    property ProxyPort: Integer read FProxyPort write FProxyPort;             // Port to connect on proxy server
    property ProxyHost: String read FProxyHost write FProxyHost;              // Address of proxy server
    property ProxyUsage: Boolean read FProxyUsage write FProxyUsage;          // True when using a proxy server to get mail
    property ProxyString: String read FProxyString write FProxyString;        // String to inform proxy server where to connect (%h% Host, %p% Port, %u% User)
    property MailMessage: TMailMessage2000 read FMailMessage write FMailMessage;  // Message retrieved
    property TimeOut: Integer read GetTimeOut write SetTimeOut;               // Max time to wait for server reply in seconds
    property OnProgress: TProgressEvent read GetProgress write SetProgress;   // Occurs when receiving data from server
    property DeleteOnRetrieve: Boolean read FDeleteOnRetrieve write FDeleteOnRetrieve;  // If message will be deleted after successful retrieve
  end;

  { TSMTP2000 }

  TSMTP2000 = class(TComponent)
  private

    FMailMessage: TMailMessage2000;

    FSessionConnected: Boolean;
    FSocketTalk: TSocketTalk;
    FPacketSize: Integer;

    FPort: Integer;
    FHost: String;
    FProxyPort: Integer;
    FProxyHost: String;
    FProxyUsage: Boolean;
    FProxyString: String;

    procedure EndOfData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
    procedure SocketTalkError(Sender: TObject; SessionState: TSessionState; TalkError: TTalkError);
    procedure ReceiveData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
    procedure SocketDisconnect(Sender: TObject);

    function GetTimeOut: Integer;
    procedure SetTimeOut(Value: Integer);

    function GetProgress: TProgressEvent;
    procedure SetProgress(Value: TProgressEvent);

    function GetLastResponse: String;

  public

    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    function Connect: Boolean;                                                // Connect to mail server
    function Quit: Boolean;                                                   // Disconnect

    function SendMessage: Boolean;                                            // Send MailMessage to server

    property SessionConnected: Boolean read FSessionConnected;                // True if conencted to server
    property LastResponse: String read GetLastResponse;                       // Last string received from server

  published

    property Port: Integer read FPort write FPort;                            // Port (usualy 25)
    property Host: String read FHost write FHost;                             // Host address
    property ProxyPort: Integer read FProxyPort write FProxyPort;             // Port to connect on proxy server
    property ProxyHost: String read FProxyHost write FProxyHost;              // Address of proxy server
    property ProxyUsage: Boolean read FProxyUsage write FProxyUsage;          // True when using a proxy server to send mail
    property ProxyString: String read FProxyString write FProxyString;        // String to inform proxy server where to connect (%h% Host, %p% Port)
    property TimeOut: Integer read GetTimeOut write SetTimeOut;               // Max time to wait for a response in seconds
    property MailMessage: TMailMessage2000 read FMailMessage write FMailMessage;  // Message to send
    property PacketSize: Integer read FPacketSize write FPacketSize;          // Size of packets to send to server
    property OnProgress: TProgressEvent read GetProgress write SetProgress;   // Occurs when sending data to server
  end;

procedure Register;

{ Very useful functions ====================================================== }

function DecodeLine7Bit(Texto: String): String; forward;
function EncodeLine7Bit(Texto, Charset: String): String; forward;
function DecodeQuotedPrintable(Texto: String): String; forward;
function EncodeQuotedPrintable(Texto: String; HeaderLine: Boolean): String; forward;
function DecodeUUCODE(Encoded: PChar; Decoded: TMemoryStream): Boolean; forward;
function DecodeLineUUCODE(const Buffer: String; Decoded: PChar): Integer; forward;
function DecodeLineBASE64(const Buffer: String; Decoded: PChar): Integer; forward;
function EncodeBASE64(Encoded: TMemoryStream {TMailText}; Decoded: TMemoryStream): Integer; forward;
function NormalizeLabel(Texto: String): String; forward;
function LabelValue(cLabel: String): String; forward;
function WriteLabelValue(cLabel, Value: String): String; forward;
function LabelParamValue(cLabel, cParam: String): String; forward;
function WriteLabelParamValue(cLabel, cParam, Value: String): String; forward;
function GetTimeZoneBias: Double; forward;
function PadL(Str: String; Tam: Integer; PadStr: String): String; forward;
function GetMimeType(FileName: String): String; forward;
function GetMimeExtension(MimeType: String): String; forward;
function GenerateBoundary: String; forward;
function SearchStringList(Lista: TStringList; Chave: String; Occorrence: Integer = 0): Integer; forward;
procedure DataLine(var Data, Line: String; var nPos: Integer); forward;
procedure DataLinePChar(const Data: PChar; const TotalLength: Integer; var LinePos, LineLen: Integer; var Line: PChar; var DataEnd: Boolean); forward;
procedure WrapSL(Source: TStringList; var Dest: String; Margin: Integer); forward;
function IsIPAddress(SS: String): Boolean; forward;
function FindReplace(Source, Old, New: String): String; forward;
function TrimSpace(const S: string): string; forward;
function TrimLeftSpace(const S: string): string; forward;
function TrimRightSpace(const S: string): string; forward;
function MailDateToDelphiDate(const DateStr: String): TDateTime; forward;
function ValidFileName(FileName: String): String;

implementation

const
  _C_T  = 'Content-Type';
  _C_D  = 'Content-Disposition';
  _C_TE = 'Content-Transfer-Encoding';
  _C_ID = 'Content-ID';


procedure Register;
begin

  RegisterComponents('Mail2000', [TPOP2000, TSMTP2000, TMailMessage2000]);
end;

// Decode an encoded field e.g. =?iso-8859-1?x?xxxxxx=?=

function DecodeLine7Bit(Texto: String): String;
var
  Buffer: PChar;
  Encoding: Char;
  Size: Integer;
  nPos0: Integer;
  nPos1: Integer;
  nPos2: Integer;
  nPos3: Integer;
  Found: Boolean;

begin

  Result := TrimSpace(Texto);

  repeat

    nPos0 := Pos('=?', Result);
    Found := False;

    if nPos0 > 0 then
    begin

      nPos1 := Pos('?', Copy(Result, nPos0+2, Length(Result)))+nPos0+1;
      nPos2 := Pos('?=', Copy(Result, nPos1+1, Length(Result)))+nPos1;
      nPos3 := Pos('?', Copy(Result, nPos2+1, Length(Result)))+nPos2;

      if nPos3 > nPos2 then
      begin

        if Length(Result) > nPos3 then
        begin

          if Result[nPos3+1] = '=' then
          begin

            nPos2 := nPos3;
          end;
        end;
      end;

      if (nPos1 > nPos0) and (nPos2 > nPos1) then
      begin

        Texto := Copy(Result, nPos1+1, nPos2-nPos1-1);

        if (Length(Texto) >= 2) and (Texto[2] = '?') and (UpCase(Texto[1]) in ['B', 'Q', 'U']) then
        begin

          Encoding := UpCase(Texto[1]);
        end
        else
        begin

          Encoding := 'Q';
        end;

        Texto := Copy(Texto, 3, Length(Texto)-2);
        
        case Encoding of

          'B':
          begin

            GetMem(Buffer, Length(Texto));
            Size := DecodeLineBASE64(Texto, Buffer);
            Buffer[Size] := #0;
            Texto := String(Buffer);
          end;

          'Q':
          begin

            while Pos('_', Texto) > 0 do
              Texto[Pos('_', Texto)] := #32;

            Texto := DecodeQuotedPrintable(Texto);
          end;

          'U':
          begin

            GetMem(Buffer, Length(Texto));
            Size := DecodeLineUUCODE(Texto, Buffer);
            Buffer[Size] := #0;
            Texto := String(Buffer);
          end;
        end;

        Result := Copy(Result, 1, nPos0-1)+Texto+Copy(Result,nPos2+2,Length(Result));
        Found := True;
      end;
    end;

  until not Found;
end;

// Encode an ISO8859-1 encoded line e.g. =?iso-8859-1?x?xxxxxx=?=

function EncodeLine7Bit(Texto, Charset: String): String;
var
  Loop: Integer;
  Encode: Boolean;
begin

  Encode := False;

  for Loop := 1 to Length(Texto) do
    if (Ord(Texto[Loop]) > 127) or (Ord(Texto[Loop]) < 32) then
    begin

      Encode := True;
      Break;
    end;

  if Encode then
    Result := '=?'+Charset+'?Q?'+EncodeQuotedPrintable(Texto, True)+'?='
  else
    Result := Texto;
end;

// Decode a quoted-printable encoded string

function DecodeQuotedPrintable(Texto: String): String;
var
  nPos: Integer;
  nLastPos: Integer;
  lFound: Boolean;

begin

  Result := Texto;

  lFound := True;
  nLastPos := 0;

  while lFound do
  begin

    lFound := False;

    if nLastPos < Length(Result) then
      nPos := Pos('=', Copy(Result, nLastPos+1, Length(Result)-nLastPos))+nLastPos
    else
      nPos := 0;

    if (nPos < (Length(Result)-1)) and (nPos > nLastPos) then
    begin

      if (Result[nPos+1] in ['A'..'F', '0'..'9']) and (Result[nPos+2] in ['A'..'F', '0'..'9']) then
      begin

        Insert(Char(StrToInt('$'+Result[nPos+1]+Result[nPos+2])), Result, nPos);
        Delete(Result, nPos+1, 3);
      end
      else
      begin

        if (Result[nPos+1] = #13) and (Result[nPos+2] = #10) then
        begin

          Delete(Result, nPos, 3);
        end
        else
        begin

          if (Result[nPos+1] = #10) and (Result[nPos+2] = #13) then
          begin

            Delete(Result, nPos, 3);
          end
          else
          begin

            if (Result[nPos+1] = #13) and (Result[nPos+2] <> #10) then
            begin

              Delete(Result, nPos, 2);
            end
            else
            begin

              if (Result[nPos+1] = #10) and (Result[nPos+2] <> #13) then
              begin

                Delete(Result, nPos, 2);
              end;
            end;
          end;
        end;
      end;

      lFound := True;
      nLastPos := nPos;
    end
    else
    begin

      if nPos = Length(Result) then
      begin

        Delete(Result, nPos, 1);
      end;
    end;
  end;
end;

// Encode a string in quoted-printable format

function EncodeQuotedPrintable(Texto: String; HeaderLine: Boolean): String;
var
  nPos: Integer;
  LineLen: Integer;

begin

  Result := '';
  LineLen := 0;

  for nPos := 1 to Length(Texto) do
  begin

    if (Texto[nPos] > #127) or
       (Texto[nPos] = '=') or
       ((Texto[nPos] <= #32) and HeaderLine) or
       ((Texto[nPos] = '"') and HeaderLine) then
    begin

      Result := Result + '=' + PadL(Format('%2x', [Ord(Texto[nPos])]), 2, '0');
      Inc(LineLen, 3);
    end
    else
    begin

      Result := Result + Texto[nPos];
      Inc(LineLen);
    end;

    if Texto[nPos] = #13 then LineLen := 0;

    if (LineLen >= 70) and (not HeaderLine) then
    begin

      Result := Result + '='#13#10;
      LineLen := 0;
    end;
  end;
end;

// Decode an UUCODE encoded line

function DecodeLineUUCODE(const Buffer: String; Decoded: PChar): Integer;
const
	CHARS_PER_LINE = 45;
	Table: String = '`!"#$%&''()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_';

var
	A24Bits: array[0..8 * CHARS_PER_LINE] of Boolean;
	i, j, k, b: Word;
	LineLen, ActualLen: Byte;

	function p_ByteFromTable(Ch: Char): Byte;
	var
		ij: Integer;
	begin

		ij := Pos(Ch, Table);

		if (ij > 64) or (ij = 0) then
		begin
			if Ch = #32 then
				Result := 0 else
				raise Exception.Create('UUCODE: Message format error');
		end else
			Result := ij - 1;
	end;

begin

  if Buffer = '' then
  begin

    Result := 0;
    Exit;
  end;

	LineLen := p_ByteFromTable(Buffer[1]);
	ActualLen := 4 * LineLen div 3;

	FillChar(A24Bits, 8 * CHARS_PER_LINE + 1, 0);
	Result := LineLen;

	if ActualLen <> (4 * CHARS_PER_LINE div 3) then
		ActualLen := Length(Buffer) - 1;

	k := 0;
	for i := 2 to ActualLen + 1 do
	begin
		b := p_ByteFromTable(Buffer[i]);
		for j := 5 downto 0 do
		begin
			A24Bits[k] := b and (1 shl j) > 0;
			Inc(k);
		end;
	end;

	k := 0;
	for i := 1 to CHARS_PER_LINE do
	begin
		b := 0;
		for j := 7 downto 0 do
		begin
			if A24Bits[k] then b := b or (1 shl j);
			Inc(k);
		end;
		Decoded[i-1] := Char(b);
	end;
end;

// Decode an UUCODE text

function DecodeUUCODE(Encoded: PChar; Decoded: TMemoryStream): Boolean;
var
  nTL, nPos, nLen: Integer;
  Line: PChar;
  LineDec: array[0..79] of Char;
  LineLen: Integer;
  DataEnd: Boolean;

begin

  Decoded.Clear;

  DataEnd := False;
  nPos := -1;
  nTL := StrLen(Encoded);

  DataLinePChar(Encoded, nTL, nPos, nLen, Line, DataEnd);

  while not DataEnd do
  begin

    if nLen > 0 then
    begin

      LineLen := DecodeLineUUCODE(String(Line), LineDec);

      if LineLen > 0 then
        Decoded.Write(LineDec[0], LineLen);
    end;

    DataLinePChar(Encoded, nTL, nPos, nLen, Line, DataEnd);
  end;

  Result := True;
end;

// Decode a BASE64 encoded line

function DecodeLineBASE64(const Buffer: String; Decoded: PChar): Integer;
var
  A1: array[1..4] of Byte;
  B1: array[1..3] of Byte;
  I, J: Integer;
  BytePtr, RealBytes: Integer;

begin

  BytePtr := 0;
  Result := 0;

  for J := 1 to Length(Buffer) do
  begin

    Inc(BytePtr);

    case Buffer[J] of

      'A'..'Z': A1[BytePtr] := Ord(Buffer[J])-65;

      'a'..'z': A1[BytePtr] := Ord(Buffer[J])-71;

      '0'..'9': A1[BytePtr] := Ord(Buffer[J])+4;

      '+': A1[BytePtr] := 62;

      '/': A1[BytePtr] := 63;

      '=': A1[BytePtr] := 64;
    end;

    if BytePtr = 4 then
    begin

      BytePtr := 0;
      RealBytes := 3;

      if A1[1] = 64 then RealBytes:=0;

      if A1[3] = 64 then
      begin

        A1[3] := 0;
        A1[4] := 0;
        RealBytes := 1;
      end;

      if A1[4] = 64 then
      begin

        A1[4] := 0;
        RealBytes := 2;
      end;

      B1[1] := A1[1]*4 + (A1[2] div 16);
      B1[2] := (A1[2] mod 16)*16+(A1[3] div 4);
      B1[3] := (A1[3] mod 4)*64 + A1[4];

      for I := 1 to RealBytes do
      begin

        Decoded[Result+I-1] := Chr(B1[I]);
      end;

      Inc(Result, RealBytes);
    end;
  end;
end;

// Padronize header labels; remove double spaces, decode quoted text, lower the cases, indentify mail addresses

function NormalizeLabel(Texto: String): String;
const
  EncLabels: String = _C_T+':'+_C_TE+':'+_C_D+':';

var
  Quote: Boolean;
  Quoted: String;
  Loop: Integer;
  lLabel: Boolean;
  sLabel: String;
  Value: String;

begin

  Quote := False;
  lLabel := True;
  Value := '';
  sLabel := '';

  for Loop := 1 to Length(Texto) do
  begin

    if (Texto[Loop] = '"') and (not lLabel) then
    begin

      Quote := not Quote;

      if Quote then
      begin

        Quoted := '';
      end
      else
      begin

        Value := Value + Quoted;
      end;
    end;

    if not Quote then
    begin

      if lLabel then
      begin

        if (sLabel = '') or (sLabel[Length(sLabel)] = '-') then
          sLabel := sLabel + UpCase(Texto[Loop])
        else
          if (Copy(sLabel, Length(sLabel)-1, 2) = '-I') and (UpCase(Texto[Loop]) = 'D') and
             (Loop < Length(Texto)) and (Texto[Loop+1] = ':') then
            sLabel := sLabel + 'D'
          else
            sLabel := sLabel + LowerCase(Texto[Loop]);

        if Texto[Loop] = ':' then
        begin

          lLabel := False;
          Value := '';
        end;
      end
      else
      begin

        if Texto[Loop] = #32 then
        begin

          Value := TrimRightSpace(Value) + #32;
        end
        else
        begin

          if (not lLabel) and (Pos(sLabel, EncLabels) > 0) then
            Value := Value + LowerCase(Texto[Loop]);

          if (not lLabel) and (Pos(sLabel, EncLabels) = 0) then
            Value := Value + Texto[Loop];
        end;
      end;
    end
    else
    begin

      Quoted := Quoted + Texto[Loop];
    end;
  end;

  Result := TrimSpace(sLabel)+' '+TrimSpace(Value);
end;

// Return the value of a label; e.g. Label: value

function LabelValue(cLabel: String): String;
var
  Loop: Integer;
  Quote: Boolean;
  Value: Boolean;
  Ins: Boolean;

begin

  Quote := False;
  Value := False;
  Result := '';

  for Loop := 1 to Length(cLabel) do
  begin

    Ins := True;

    if cLabel[Loop] = '"' then
    begin

      Quote := not Quote;
      Ins := False;
    end;

    if not Quote then
    begin

      if (cLabel[Loop] = ':') and (not Value) then
      begin

        Value := True;
        Ins := False;
      end
      else
      begin

        if (cLabel[Loop] = ';') and Value then
        begin

          Break;
        end;
      end;
    end;

    if Ins and Value then
    begin

      Result := Result + cLabel[Loop];
    end;
  end;

  Result := TrimSpace(Result);

  if (Copy(Result, 1, 1) = '"') and (Copy(Result, Length(Result), 1) = '"') then
    Result := Copy(Result, 2, Length(Result)-2);
end;

// Set the value of a label;

function WriteLabelValue(cLabel, Value: String): String;
var
  Loop: Integer;
  Quote: Boolean;
  ValPos, ValLen: Integer;

begin

  Quote := False;
  ValPos := 0;
  ValLen := -1;

  for Loop := 1 to Length(cLabel) do
  begin

    if cLabel[Loop] = '"' then
    begin

      Quote := not Quote;
    end;

    if not Quote then
    begin

      if (cLabel[Loop] = ':') and (ValPos = 0) then
      begin

        ValPos := Loop+1;
      end
      else
      begin

        if (cLabel[Loop] = ';') and (ValPos > 0) then
        begin

          ValLen := Loop - ValPos;
          Break;
        end;
      end;
    end;
  end;

  Result := cLabel;

  if (ValLen < 0) and (ValPos > 0) then
    ValLen := Length(cLabel) - ValPos + 1;

  if ValPos > 0 then
  begin

    Delete(Result, ValPos, ValLen);
    Insert(' '+TrimSpace(Value), Result, ValPos);
  end;
end;

// Return the value of a label parameter; e.g. Label: xxx; param=value

function LabelParamValue(cLabel, cParam: String): String;
var
  Loop: Integer;
  Quote: Boolean;
  Value: Boolean;
  Params: Boolean;
  ParamValue: Boolean;
  Ins: Boolean;
  Param: String;

begin

  Quote := False;
  Value := False;
  Params := False;
  ParamValue := False;

  Param := '';
  Result := '';

  cLabel := TrimSpace(cLabel);

  if Copy(cLabel, Length(cLabel), 1) <> ';' then cLabel := cLabel + ';';

  for Loop := 1 to Length(cLabel) do
  begin

    Ins := True;

    if cLabel[Loop] = '"' then
    begin

      Quote := not Quote;
      Ins := False;
    end;

    if not Quote then
    begin

      if (cLabel[Loop] = ':') and (not Value) and (not Params) then
      begin

        Value := True;
        Params := False;
        ParamValue := False;
        Ins := False;
      end
      else
      begin

        if (cLabel[Loop] = ';') and (Value or Params) then
        begin

          Params := True;
          Value := False;
          ParamValue := False;
          Param := '';
          Ins := False;
        end
        else
        begin

          if (cLabel[Loop] = '=') and Params then
          begin

            ParamValue := UpperCase(TrimSpace(Param)) = UpperCase(TrimSpace(cParam));
            Ins := False;
            Param := '';
          end;
        end;
      end;
    end;

    if Ins and ParamValue then
    begin

      Result := Result + cLabel[Loop];
    end;

    if Ins and (not ParamValue) and Params then
    begin

      Param := Param + cLabel[Loop];
    end;
  end;

  Result := TrimSpace(Result);

  if (Copy(Result, 1, 1) = '"') and (Copy(Result, Length(Result), 1) = '"') then
    Result := Copy(Result, 2, Length(Result)-2);
end;

// Set the value of a label parameter;

function WriteLabelParamValue(cLabel, cParam, Value: String): String;
var
  Loop: Integer;
  Quote: Boolean;
  LabelValue: Boolean;
  Params: Boolean;
  ValPos, ValLen: Integer;
  Ins: Boolean;
  Param: String;

begin

  Quote := False;
  LabelValue := False;
  Params := False;
  ValPos := 0;
  ValLen := -1;

  Param := '';
  Result := '';

  cLabel := TrimSpace(cLabel);

  for Loop := 1 to Length(cLabel) do
  begin

    Ins := True;

    if cLabel[Loop] = '"' then
    begin

      Quote := not Quote;
      Ins := False;
    end;

    if not Quote then
    begin

      if (cLabel[Loop] = ':') and (not LabelValue) and (not Params) then
      begin

        LabelValue := True;
        Params := False;
        ValPos := 0;
        ValLen := 0;
        Ins := False;
      end
      else
      begin

        if (cLabel[Loop] = ';') and (LabelValue or Params) then
        begin

          if Params and (ValPos > 0) then
          begin

            ValLen := Loop - ValPos;
            Break;
          end;

          Params := True;
          LabelValue := False;
          Param := '';
          Ins := False;
        end
        else
        begin

          if (cLabel[Loop] = '=') and Params then
          begin

            if UpperCase(TrimSpace(Param)) = UpperCase(TrimSpace(cParam)) then
            begin

              ValPos := Loop+1;
              ValLen := 0;
            end;

            Ins := False;
            Param := '';
          end;
        end;
      end;
    end;

    if Ins and (ValPos = 0) and Params then
    begin

      Param := Param + cLabel[Loop];
    end;
  end;

  Result := cLabel;

  if ValPos = 0 then
  begin

    Result := TrimSpace(Result) + '; ' + TrimSpace(cParam) + '=' + TrimSpace(Value);
  end
  else
  begin

    if (ValLen < 0) and (ValPos > 0) then
      ValLen := Length(cLabel) - ValPos + 1;

    Delete(Result, ValPos, ValLen);
    Insert(TrimSpace(Value), Result, ValPos);

    if Result[Length(Result)] = ';' then
      Delete(Result, Length(Result), 1);
  end;
end;

// Return the Timezone adjust in days

function GetTimeZoneBias: Double;
var
  TzInfo: TTimeZoneInformation;

begin

  case GetTimeZoneInformation(TzInfo) of

    1: Result := - (TzInfo.StandardBias + TzInfo.Bias) / (24*60);

    2: Result := - (TzInfo.DaylightBias + TzInfo.Bias) / (24*60);

    else Result := 0;
  end;
end;

// Fills left of string with char

function PadL(Str: String; Tam: Integer; PadStr: String): String;
var
  TempStr: String;

begin

  TempStr := TrimLeftSpace(Str);

  if Length(TempStr) <= Tam then
  begin

    while Length(TempStr) < Tam do
      TempStr := PadStr + TempStr;
  end
  else
  begin

    TempStr := Copy(TempStr, Length(TempStr) - Tam + 1, Tam);
  end;

  Result := TempStr;
end;

// Get mime type of a file extension

function GetMimeType(FileName: String): String;
var
  Key: string;

begin

  Result := '';

  with TRegistry.Create do
    try

      RootKey := HKEY_CLASSES_ROOT;
      Key := ExtractFileExt(FileName);

      if KeyExists(Key) then
      begin

        OpenKey(Key,false);
        Result := ReadString('Content Type');
        CloseKey;
      end;

    finally

      if Result = '' then
        Result := 'application/octet-stream';

      Free;
    end;
end;

// Get file extension of a mime type

function GetMimeExtension(MimeType: String): String;
var
  Key: string;

begin

  Result := '';

  with TRegistry.Create do
    try

      RootKey := HKEY_CLASSES_ROOT;

      if OpenKey('MIME\Database\Content Type', False) then
      begin

        Key := MimeType;

        if KeyExists(Key) then
        begin

          OpenKey(Key,false);
          Result := ReadString('Extension');
          CloseKey;
        end;
      end;

    finally

      if Result = '' then
        Result := '.txt';

      Free;
    end;
end;

// Generate a random boundary

function GenerateBoundary: String;
begin

  Result := 'boundary'+PadL(Format('%8x', [Random($FFFFFFFF)]), 8, '0');
end;

// Encode in base64

function EncodeBASE64(Encoded: TMemoryStream {TMailText}; Decoded: TMemoryStream): Integer;
const
  _Code64: String[64] =
    ('ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/');
var
  I: LongInt;
  B: array[0..2279] of Byte;
  J, K, L, M, Quads: Integer;
  Stream: string[76];
  EncLine: String;

begin

  Encoded.Clear;

  Stream := '';
  Quads := 0;
  J := Decoded.Size div 2280;

  Decoded.Position := 0;

  for I := 1 to J do
  begin

    Decoded.Read(B, 2280);

    for M := 0 to 39 do
    begin

      for K := 0 to 18 do
      begin

        L:= 57*M + 3*K;

        Stream[Quads+1] := _Code64[(B[L] div 4)+1];
        Stream[Quads+2] := _Code64[(B[L] mod 4)*16 + (B[L+1] div 16)+1];
        Stream[Quads+3] := _Code64[(B[L+1] mod 16)*4 + (B[L+2] div 64)+1];
        Stream[Quads+4] := _Code64[B[L+2] mod 64+1];

        Inc(Quads, 4);

        if Quads = 76 then
        begin

          Stream[0] := #76;
          EncLine := Stream+#13#10;
          Encoded.Write(EncLine[1], Length(EncLine));
          Quads := 0;
        end;
      end;
    end;
  end;

  J := (Decoded.Size mod 2280) div 3;

  for I := 1 to J do
  begin

    Decoded.Read(B, 3);

    Stream[Quads+1] := _Code64[(B[0] div 4)+1];
    Stream[Quads+2] := _Code64[(B[0] mod 4)*16 + (B[1] div 16)+1];
    Stream[Quads+3] := _Code64[(B[1] mod 16)*4 + (B[2] div 64)+1];
    Stream[Quads+4] := _Code64[B[2] mod 64+1];

    Inc(Quads, 4);

    if Quads = 76 then
    begin

      Stream[0] := #76;
      EncLine := Stream+#13#10;
      Encoded.Write(EncLine[1], Length(EncLine));
      Quads := 0;
    end;
  end;

  if (Decoded.Size mod 3) = 2 then
  begin

    Decoded.Read(B, 2);

    Stream[Quads+1] := _Code64[(B[0] div 4)+1];
    Stream[Quads+2] := _Code64[(B[0] mod 4)*16 + (B[1] div 16)+1];
    Stream[Quads+3] := _Code64[(B[1] mod 16)*4 + 1];
    Stream[Quads+4] := '=';

    Inc(Quads, 4);
  end;

  if (Decoded.Size mod 3) = 1 then
  begin

    Decoded.Read(B, 1);

    Stream[Quads+1] := _Code64[(B[0] div 4)+1];
    Stream[Quads+2] := _Code64[(B[0] mod 4)*16 + 1];
    Stream[Quads+3] := '=';
    Stream[Quads+4] := '=';
    Inc(Quads, 4);
  end;

  Stream[0] := Chr(Quads);

  if Quads > 0 then
  begin

    EncLine := Stream+#13#10;
    Encoded.Write(EncLine[1], Length(EncLine));
  end;

  Result := Encoded.Size;
end;

// Search in a StringList

function SearchStringList(Lista: TStringList; Chave: String; Occorrence: Integer = 0): Integer;
var
  nPos: Integer;
  lAchou: Boolean;
  Casas: Integer;
  Temp: String;
  nOccor: Integer;

begin

  Casas := Length(Chave);
  lAchou := False;
  nPos := 0;
  nOccor := 0;

  try

    if Lista <> nil then
    begin

      while (not lAchou) and (nPos < Lista.Count) do
      begin

        Temp := Lista[nPos];

        if UpperCase(Copy(Temp, 1, Casas)) = UpperCase(Chave) then
        begin

          if nOccor = Occorrence then
          begin
          
            lAchou := True;
          end
          else
          begin

            Inc(nOccor);
          end;
        end;

        if not lAchou then
          Inc(nPos);
      end;
    end;

  finally

    if lAchou then
      result := nPos
    else
      result := -1;
  end;
end;

// Search lines into a string

procedure DataLine(var Data, Line: String; var nPos: Integer);
begin

  Line := '';

  while True do
  begin

    Line := Line + Data[nPos];
    Inc(nPos);

    if nPos > Length(Data) then
    begin

      nPos := -1;
      Break;
    end
    else
    begin

      if Length(Line) >= 2 then
      begin

        if (Line[Length(Line)-1] = #13) and (Line[Length(Line)] = #10) then
        begin

          Break;
        end;
      end;
    end;
  end;
end;

// Search lines into a string
// I need to do in this confusing way in order to improve performance

procedure DataLinePChar(const Data: PChar; const TotalLength: Integer; var LinePos, LineLen: Integer; var Line: PChar; var DataEnd: Boolean); assembler;
begin

  if LinePos >= 0 then
  begin

    Data[LinePos+LineLen] := #13;
    LinePos := LinePos+LineLen+2;
    LineLen := 0;
  end
  else
  begin

    LinePos := 0;
    LineLen := 0;
  end;

  while (LinePos+LineLen) < TotalLength do
  begin

    if Data[LinePos+LineLen] = #13 then
    begin

      if (LinePos+LineLen+1) < TotalLength then
      begin

        if Data[LinePos+LineLen+1] = #10 then
        begin

          Data[LinePos+LineLen] := #0;
          Line := @Data[LinePos];
          Exit;
        end;
      end;
    end;

    Inc(LineLen);
  end;

  if LinePos < TotalLength then
    Line := @Data[LinePos]
  else
    DataEnd := True;
end;

// Wrap long lines in a StringList

procedure WrapSL(Source: TStringList; var Dest: String; Margin: Integer);
var
  Buffer: PChar;
  Loop: Integer;
  Line: String;
  Quote: Boolean;

begin

  Buffer := PChar(Source.Text);
  Line := '';
  Dest := '';
  Quote := False;

  for Loop := 0 to StrLen(Buffer)-1 do
  begin

    if Buffer[Loop] = '"' then
      Quote := not Quote;

    Line := Line + Buffer[Loop];

    if (Loop > 0) then
    begin

      if (Buffer[Loop] = #10) and (Buffer[Loop-1] = #13) then
      begin

        Dest := Dest + Line;
        Line := '';
      end;
    end;

    if (Length(Line) >= Margin) and (Buffer[Loop] = #32) and (not Quote) then
    begin

      Dest := Dest + Copy(Line, 1, Length(Line)-1) + #13#10;
      Line := #9;
    end;
  end;
end;

// Determine if string is a numeric IP or not (Thanks to Hou Yg yghou@yahoo.com)

function IsIPAddress(SS: String): Boolean;
var
  Loop: Integer;
  P: String;

begin

  Result := True;
  P := '';

  for Loop := 1 to Length(SS)+1 do
  begin

    if (Loop > Length(SS)) or (SS[Loop] = '.') then
    begin

      if StrToIntDef(P, -1) < 0 then
      begin

        Result := False;
        Break;
      end;

      P := '';
    end
    else
    begin

      P := P + SS[Loop];
    end;
  end;
end;

// Find and replace substrings

function FindReplace(Source, Old, New: String): String;
var
  Position: Integer;

  function Stuff(Source: String; Position, DelCount: Integer; InsString: String): String;
  begin

    result := Copy(Source, 1, Position-1) + InsString +
              Copy(Source, Position+DelCount, Length(Source));
  end;

begin

  repeat
  begin

    Position := Pos(Old, Source);

    if Position > 0 then
      Source := Stuff(Source, Position, Length(Old), New);
  end
  until Position = 0;

  Result := Source;
end;

// Remove leading and trailing spaces from string
// Thanks to Yunarso Anang (yasx@hotmail.com)

function TrimSpace(const S: string): string;
var
  I, L: Integer;

begin

  L := Length(S);
  I := 1;

  while (I <= L) and (S[I] = ' ') do
    Inc(I);

  if I > L then Result := '' else
  begin

    while S[L] = ' ' do
      Dec(L);

    Result := Copy(S, I, L - I + 1);
  end;
end;

// Remove left spaces from string
// Thanks to Yunarso Anang (yasx@hotmail.com)

function TrimLeftSpace(const S: string): string;
var
  I, L: Integer;

begin

  L := Length(S);
  I := 1;

  while (I <= L) and (S[I] = ' ') do
    Inc(I);

  Result := Copy(S, I, Maxint);
end;

// Remove right spaces from string
// Thanks to Yunarso Anang (yasx@hotmail.com)

function TrimRightSpace(const S: string): string;
var
  I: Integer;

begin

  I := Length(S);

  while (I > 0) and (S[I] = ' ') do
    Dec(I);

  Result := Copy(S, 1, I);
end;

// Convert date from message to Delphi format

function MailDateToDelphiDate(const DateStr: String): TDateTime;
const
  Months: String = 'Jan,Feb,Mar,Apr,May,Jun,Jul,Ago,Sep,Oct,Nov,Dec,';

var
  Field, Loop: Integer;
  Hour, Min, Sec, Year, Month, Day: Word;
  sHour, sMin, sSec, sYear, sMonth, sDay, sTZ: String;
  HTZM, MTZM: Word;
  STZM: Integer;
  TZM: Double;

begin

  sHour := '';
  sMin := '';
  sSec := '';
  sYear := '';
  sMonth := '';
  sDay := '';
  sTZ := '';

  if DateStr <> '' then
  begin

    if DateStr[1] in ['0'..'9'] then
      Field := 1
    else
      Field := 0;

    for Loop := 1 to Length(DateStr) do
    begin

      if DateStr[Loop] in [' ', ':'] then
      begin

        Inc(Field);
      end
      else
      begin

        case Field of

          1: sDay := sDay + DateStr[Loop];
          2: sMonth := sMonth + DateStr[Loop];
          3: sYear := sYear + DateStr[Loop];
          4: sHour := sHour + DateStr[Loop];
          5: sMin := sMin + DateStr[Loop];
          6: sSec := sSec + DateStr[Loop];
          7: sTZ := sTZ + DateStr[Loop];
        end;
      end;
    end;

    Hour := StrToIntDef(sHour, 0);
    Min := StrToIntDef(sMin, 0);
    Sec := StrToIntDef(sSec, 0);
    Year := StrToIntDef(syear, 0);
    Month := (Pos(sMonth, Months)-1) div 4 + 1;
    Day := StrToIntDef(sDay, 0);

    if Year < 100 then
    begin

      if Year < 50 then
        Year := 2000 + Year
      else
        Year := 1900 + Year;
    end;

    if (sTZ = 'GMT') or (Length(Trim(sTZ)) <> 5) then
    begin

      STZM := 1;
      HTZM := 0;
      MTZM := 0;
    end
    else
    begin

      STZM := StrToIntDef(Copy(sTZ, 1, 1)+'1', 1);
      HTZM := StrToIntDef(Copy(sTZ, 2, 2), 0);
      MTZM := StrToIntDef(Copy(sTZ, 4, 2), 0);
    end;

    TZM := EncodeTime(HTZM, MTZM, 0, 0)*STZM;

    Result := EncodeDate(Year, Month, Day) + EncodeTime(Hour, Min, Sec, 0) + TZM - GetTimeZoneBias;
  end
  else
  begin

    Result := Now;
  end;
end;

// To make sure that a file name (without path!) is valid

function ValidFileName(FileName: String): String;
const
  InvChars: String = ':.\/*?"<>| ';

var
  Loop: Integer;

begin

  FileName := Copy(TrimSpace(FileName), 1, 254);
  Result := '';

  for Loop := 1 to Length(FileName) do
  begin

    if (Ord(FileName[Loop]) < 32) or (Pos(FileName[Loop], InvChars) > 0) then
      Result := Result + '_'
    else
      Result := Result + FileName[Loop];
  end;
end;

{ TMailPart ================================================================== }

// Initialize MailPart

constructor TMailPart.Create(AOwner: TComponent);
begin

  FHeader := TStringList.Create;
  FBody := TMemoryStream.Create;
  FDecoded := TMemoryStream.Create;
  FSubPartList := TMailPartList.Create;
  FOwnerPart := nil;
  FOwnerMessage := nil;
  FAttachedMessage := nil;

  inherited Create(AOwner);
end;

// Finalize MailPart

destructor TMailPart.Destroy;
var
  Loop: Integer;

begin

  for Loop := 0 to FSubPartList.Count-1 do
    FSubPartList.Items[Loop].Destroy;

  FHeader.Free;
  FBody.Free;
  FDecoded.Free;
  FSubPartList.Free;

  if FAttachedMessage <> nil then
    FAttachedMessage.Free;

  inherited Destroy;
end;

// Return the value of a label from the header like "To", "Subject"

function TMailPart.GetLabelValue(cLabel: String): String;
var
  Loop: Integer;

begin

  Result := '';
  Loop := SearchStringList(FHeader, cLabel+':');

  if Loop >= 0 then
    Result := LabelValue(FHeader[Loop]);
end;

// Return de value of a parameter of a value from the header

function TMailPart.GetLabelParamValue(cLabel, Param: String): String;
var
  Loop: Integer;

begin

  Result := '';
  Loop := SearchStringList(FHeader, cLabel+':');

  if Loop >= 0 then
    Result := TrimSpace(LabelParamValue(FHeader[Loop], Param));
end;

// Set the value of a label

procedure TMailPart.SetLabelValue(cLabel, cValue: String);
var
  Loop: Integer;

begin

  Loop := SearchStringList(FHeader, cLabel+':');

  if cValue <> '' then
  begin

    if Loop < 0 then
    begin

      FHeader.Add(cLabel+': ');
      Loop := FHeader.Count-1;
    end;

    FHeader[Loop] := WriteLabelValue(FHeader[Loop], cValue);
  end
  else
  begin

    if Loop >= 0 then
    begin

      FHeader.Delete(Loop);
    end;
  end;
end;

// Set the value of a label parameter

procedure TMailPart.SetLabelParamValue(cLabel, cParam, cValue: String);
var
  Loop: Integer;

begin

  Loop := SearchStringList(FHeader, cLabel+':');

  if Loop < 0 then
  begin

    FHeader.Add(cLabel+': ');
    Loop := FHeader.Count-1;
  end;

  FHeader[Loop] := WriteLabelParamValue(FHeader[Loop], cParam, cValue);
end;

// Look for a label in the header

function TMailPart.LabelExists(cLabel: String): Boolean;
begin

  Result := SearchStringList(FHeader, cLabel+':') >= 0;
end;

// Look for a parameter in a label in the header

function TMailPart.LabelParamExists(cLabel, Param: String): Boolean;
var
  Loop: Integer;

begin

  Result := False;
  Loop := SearchStringList(FHeader, cLabel+':');

  if Loop >= 0 then
    Result := TrimSpace(LabelParamValue(FHeader[Loop], Param)) <> '';
end;

// Divide header and body; normalize header;

procedure TMailPart.Fill(Data: PChar; HasHeader: Boolean);
const
  CRLF: array[0..2] of Char = (#13, #10, #0);

var
  Loop: Integer;
  BoundStart: array[0..99] of Char;
  BoundEnd: array[0..99] of Char;
  InBound: Boolean;
  IsBoundStart: Boolean;
  IsBoundEnd: Boolean;
  BoundStartLen: Integer;
  BoundEndLen: Integer;
  PartText: PChar;
  DataEnd: Boolean;
  MultPart: Boolean;
  NoParts: Boolean;
  InUUCode: Boolean;
  UUFile, UUBound: String;
  Part: TMailPart;
  nPos: Integer;
  nLen: Integer;
  nTL: Integer;
  nSPos: Integer;
  Line: PChar;
  SChar: Char;

begin

  if FOwnerMessage = nil then
    Exception.Create('MailPart must be owned by a MailMessage');

  for Loop := 0 to FSubPartList.Count-1 do
    FSubPartList.Items[Loop].Destroy;

  FHeader.Clear;
  FBody.Clear;
  FDecoded.Clear;
  FSubPartList.Clear;
  FOwnerMessage.FNeedRebuild := True;
  FIsDecoded := False;

  nPos := -1;
  DataEnd := False;
  nTL := StrLen(Data);
  nSPos := nTL+1;

  if (Self is TMailMessage2000) and Assigned(FOwnerMessage.FOnProgress) then
  begin

    FOwnerMessage.FOnProgress(Self, nTL, 0);
    Application.ProcessMessages;
  end;

  if HasHeader then
  begin

    // Get Header

    DataLinePChar(Data, nTL, nPos, nLen, Line, DataEnd);

    while not DataEnd do
    begin

      if nLen = 0 then
      begin

        Break;
      end
      else
      begin

        if (Line[0] in [#9, #32]) and (FHeader.Count > 0) then
        begin

          FHeader[FHeader.Count-1] := FHeader[FHeader.Count-1] + #32 + String(PChar(@Line[1]));
        end
        else
        begin

          FHeader.Add(String(Line));
        end;
      end;

      DataLinePChar(Data, nTL, nPos, nLen, Line, DataEnd);

      if (Self is TMailMessage2000) and Assigned(FOwnerMessage.FOnProgress) then
      begin

        FOwnerMessage.FOnProgress(Self, nTL, nPos+1);
        Application.ProcessMessages;
      end;
    end;

    for Loop := 0 to FHeader.Count-1 do
      FHeader[Loop] := NormalizeLabel(FHeader[Loop]);
  end;

  MultPart := Copy(GetLabelValue(_C_T), 1, 10) = 'multipart/';
  InBound := False;
  IsBoundStart := False;
  IsBoundEnd := False;
  UUBound := '';

  if MultPart then
  begin

    StrPCopy(BoundStart, '--'+GetLabelParamValue(_C_T, 'boundary'));
    StrPCopy(BoundEnd, '--'+GetLabelParamValue(_C_T, 'boundary')+'--');
    BoundStartLen := StrLen(BoundStart);
    BoundEndLen := StrLen(BoundEnd);
    NoParts := False;
  end
  else
  begin

    if LabelExists(_C_T) then
    begin

      NoParts := True;
      BoundStartLen := 0;
      BoundEndLen := 0;
    end
    else
    begin

      StrPCopy(BoundStart, 'begin 6');
      StrPCopy(BoundEnd, 'end');
      BoundStartLen := StrLen(BoundStart);
      BoundEndLen := StrLen(BoundEnd);
      NoParts := False;
    end;
  end;

  PartText := nil;

  // Get Body

  DataLinePChar(Data, nTL, nPos, nLen, Line, DataEnd);

  while (not DataEnd) and (not InBound) do
  begin

    if (not NoParts) and (((Line[0] = '-') and (Line[1] = '-')) or ((Line[0] = 'b') and (Line[1] = 'e'))) then
    begin

      IsBoundStart := StrLComp(Line, BoundStart, BoundStartLen) = 0;
    end;

    if NoParts or (not IsBoundStart) then
    begin

      if PartText = nil then
      begin

        PartText := Line;
        nSPos := nPos;
      end;

      DataLinePChar(Data, nTL, nPos, nLen, Line, DataEnd);

      if (Self is TMailMessage2000) and Assigned(FOwnerMessage.FOnProgress) then
      begin

        FOwnerMessage.FOnProgress(Self, nTL, nPos+1);
        Application.ProcessMessages;
      end;
    end
    else
    begin

      InBound := True;
    end;
  end;

  if nPos > nSPos then
  begin

    SChar := Data[nPos];
    Data[nPos] := #0;
    FBody.Write(PartText[0], nPos-nSPos);
    Data[nPos] := SChar;
  end;

  if not NoParts then
  begin

    PartText := nil;

    if MultPart then
    begin

      // Get Mime parts

      while not DataEnd do
      begin

        if IsBoundStart or IsBoundEnd then
        begin

          if (PartText <> nil) and (PartText[0] <> #0) then
          begin

            Part := TMailPart.Create(Self);
            Part.FOwnerPart := Self;
            Part.FOwnerMessage := Self.FOwnerMessage;

            SChar := Data[nPos-2];
            Data[nPos-2] := #0;
            Part.Fill(PartText, True);
            Data[nPos-2] := SChar;

            Part.FBoundary := GetLabelParamValue(_C_T, 'boundary');
            FSubPartList.Add(Part);
            PartText := nil;
          end;

          if IsBoundEnd then
          begin

            Break;
          end;

          IsBoundStart := False;
          IsBoundEnd := False;
        end
        else
        begin

          if PartText = nil then
          begin

            PartText := Line;
          end;
        end;

        DataLinePChar(Data, nTL, nPos, nLen, Line, DataEnd);

        if (Self is TMailMessage2000) and Assigned(FOwnerMessage.FOnProgress) then
        begin

          FOwnerMessage.FOnProgress(Self, nTL, nPos+1);
          Application.ProcessMessages;
        end;

        if not DataEnd then
        begin

          if (Line[0] = '-') and (Line[1] = '-') then
          begin

            IsBoundStart := StrLComp(Line, BoundStart, BoundStartLen) = 0;

            if not IsBoundStart then
            begin

              IsBoundEnd := StrLComp(Line, BoundEnd, BoundEndLen) = 0;
            end;
          end;
        end;
      end;
    end
    else
    begin

      // Get UUCode parts

      InUUCode := IsBoundStart;

      while not DataEnd do
      begin

        if IsBoundStart then
        begin

          if UUBound = '' then
          begin

            GetMem(PartText, FBody.Size+1);
            UUBound := GenerateBoundary;
            StrLCopy(PartText, FBody.Memory, FBody.Size);
            PartText[FBody.Size] := #0;

            Part := TMailPart.Create(Self);
            Part.FOwnerPart := Self;
            Part.FOwnerMessage := Self.FOwnerMessage;
            Part.Fill(PChar(EncodeQuotedPrintable(String(PartText), False)), False);
            Part.FBoundary := UUBound;
            Part.SetLabelValue(_C_T, 'text/plain');
            Part.SetLabelParamValue(_C_T, 'charset', '"'+FOwnerMessage.FCharset+'"');
            Part.SetLabelValue(_C_TE, 'quoted-printable');

            FSubPartList.Add(Part);
            SetLabelValue(_C_T, '');
            SetLabelValue(_C_T, 'multipart/mixed');
            SetLabelParamValue(_C_T, 'boundary', '"'+UUBound+'"');

            FreeMem(PartText);
          end;

          PartText := nil;
          IsBoundStart := False;
          UUFile := TrimSpace(Copy(String(Line), 11, 999));
        end
        else
        begin

          if IsBoundEnd then
          begin

            Part := TMailPart.Create(Self);
            Part.FOwnerPart := Self;
            Part.FOwnerMessage := Self.FOwnerMessage;

            SChar := Data[nPos-2];
            Data[nPos-2] := #0;
            DecodeUUCODE(PartText, Part.FDecoded);
            Data[nPos-2] := SChar;

            Part.EncodeBinary;
            Part.FBoundary := UUBound;
            Part.SetLabelValue(_C_T, GetMimeType(UUFile));
            Part.SetLabelValue(_C_TE, 'base64');
            Part.SetLabelValue(_C_D, 'attachment');
            Part.SetLabelParamValue(_C_T, 'name', '"'+UUFile+'"');
            Part.SetLabelParamValue(_C_D, 'filename', '"'+UUFile+'"');

            FSubPartList.Add(Part);
            PartText := nil;
            IsBoundEnd := False;
          end
          else
          begin

            if PartText = nil then
            begin

              PartText := Line;
            end;
          end;
        end;

        DataLinePChar(Data, nTL, nPos, nLen, Line, DataEnd);

        if (Self is TMailMessage2000) and Assigned(FOwnerMessage.FOnProgress) then
        begin

          FOwnerMessage.FOnProgress(Self, nTL, nPos+1);
          Application.ProcessMessages;
        end;

        if not DataEnd then
        begin

          if (Line[0] = 'b') and (Line[1] = 'e') then
          begin

            IsBoundStart := StrLComp(Line, BoundStart, BoundStartLen) = 0;
            InUUCode := True;
          end;

          if (not IsBoundStart) and InUUCode then
          begin

            if (Line[0] = 'e') and (Line[1] = 'n') and (Line[2] = 'd') then
            begin

              IsBoundEnd := True;
              InUUCode := False;
            end;
          end;
        end;
      end;
    end;
  end;

  if Self = FOwnerMessage then
  begin

    if not LabelExists(_C_T) then
    begin

      SetLabelValue(_C_T, 'text/plain');
    end;

    FOwnerMessage.PutText('', nil, '');
    FOwnerMessage.GetAttachList;
  end;
end;

// Remove mailpart from its owner

procedure TMailPart.Remove;
begin

  FOwnerPart.FSubPartList.Delete(FOwnerPart.FSubPartList.IndexOf(Self));
  FOwnerMessage.FNeedRebuild := True;
  Free;
end;

// Fill part with a file contents

procedure TMailPart.LoadFromFile(FileName: String);
var
  SL: TStringList;

begin

  SL := TStringList.Create;
  SL.LoadFromFile(FileName);

  Fill(PChar(SL.Text), True);

  SL.Free;
end;

// Save the part data to a file

procedure TMailPart.SaveToFile(FileName: String);
var
  SL: TStringList;
  Text: String;

begin

  SetLength(Text, FBody.Size+1);
  FBody.Position := 0;
  FBody.ReadBuffer(Text[1], FBody.Size);

  SL := TStringList.Create;
  SL.Text := FHeader.Text+#13#10+Text;
  SL.SaveToFile(FileName);
  SL.Free;
end;

// Get file name of attachment

function TMailPart.GetFileName: String;
const
  InvChars: String = '<>?*:|"/\';

var
  Name: String;
  Loop: Integer;

begin

  Name := '';

  if LabelParamExists(_C_T, 'name') then
  begin

    Name := GetLabelParamValue(_C_T, 'name');
  end
  else
  begin

    if LabelParamExists(_C_D, 'filename') then
    begin

      Name := GetLabelParamValue(_C_D, 'filename');
    end
    else
    begin

      if LabelExists(_C_ID) then
      begin

        Name := GetLabelValue(_C_ID);
      end
      else
      begin

        if LabelExists(_C_T) then
        begin

          Name := GetLabelValue(_C_T)+GetMimeExtension(GetLabelValue(_C_T));
        end
        else
        begin

          Name := 'Unknow';
        end;
      end;
    end;
  end;

  Name := DecodeLine7Bit(Name);

  if Pos('.', Name) = 0 then
    Name := Name + GetMimeExtension(GetLabelValue(_C_T));

  Result := '';

  for Loop := 1 to Length(Name) do
    if Pos(Name[Loop], InvChars) = 0 then
      Result := Result + Name[Loop];
end;

// Get file name of attachment

function TMailPart.GetAttachInfo: String;
begin

  Result := GetLabelValue(_C_T);
end;

// Write the content-type label

procedure TMailPart.SetAttachInfo(AttachInfo: String);
var
  Line: Integer;

begin

  Line := SearchStringList(FHeader, _C_T+':');

  if Line < 0 then
  begin

    FHeader.Add(_C_T+': ');
    Line := FHeader.Count-1;
  end;

  FHeader[Line] := WriteLabelValue(FHeader[Line], AttachInfo);
end;

// Write the content-disposition label

procedure TMailPart.SetFileName(FileName: String);
var
  Line: Integer;

begin

  Line := SearchStringList(FHeader, _C_T+':');

  if Line < 0 then
  begin

    FHeader.Add(_C_T+': ');
    Line := FHeader.Count-1;
  end;

  FHeader[Line] := WriteLabelValue(FHeader[Line], AttachInfo);
end;

// Decode mail part

function TMailPart.Decode;
var
  Content: String;
  Encoding: String;
  Data: String;
  DecoLine: String;
  Buffer: PChar;
  Size: Integer;
  nPos: Integer;

begin

  Result := True;
  
  if FIsDecoded then
    Exit;

  FIsDecoded := True;

  if FBody.Size = 0 then Exit;

  Content := GetLabelValue(_C_T);
  Encoding := GetLabelValue(_C_TE);

  FDecoded.Clear;

  if (Encoding = 'quoted-printable') or (Encoding = '7bit') then
  begin

    GetMem(Buffer, FBody.Size+1);
    StrLCopy(Buffer, FBody.Memory, FBody.Size);
    Buffer[FBody.Size] := #0;
    DecoLine := DecodeQuotedPrintable(Buffer);
    FreeMem(Buffer);

    GetMem(Buffer, Length(DecoLine)+1);
    StrPCopy(Buffer, DecoLine);
    FDecoded.Write(Buffer^, Length(DecoLine));
    FreeMem(Buffer);
  end
  else
  begin

    if Encoding = 'base64' then
    begin

      nPos := 1;

      SetLength(Data, FBody.Size);
      FBody.Position := 0;
      FBody.ReadBuffer(Data[1], FBody.Size);

      while nPos >= 0 do
      begin

        DataLine(Data, DecoLine, nPos);

        GetMem(Buffer, 132);
        Size := DecodeLineBASE64(TrimSpace(DecoLine), Buffer);

        if Size > 0 then
          FDecoded.Write(Buffer^, Size);

        FreeMem(Buffer);
      end;
    end
    else
    begin

      if Encoding = 'uucode' then
      begin

        nPos := 1;

        SetLength(Data, FBody.Size);
        FBody.Position := 0;
        FBody.ReadBuffer(Data[1], FBody.Size);

        while nPos >= 0 do
        begin

          DataLine(Data, DecoLine, nPos);

          GetMem(Buffer, 80);
          Size := DecodeLineUUCODE(TrimSpace(DecoLine), Buffer);
          FDecoded.Write(Buffer^, Size);
          FreeMem(Buffer);
        end;

        EncodeBinary; // Convert to base64
      end
      else
      begin

        GetMem(Buffer, FBody.Size);
        FBody.Position := 0;
        FBody.Read(Buffer^, FBody.Size);
        FDecoded.Write(Buffer^, FBody.Size);
        FreeMem(Buffer);
      end;
    end;
  end;

  if Content = 'message/rfc822' then
  begin

    GetMem(Buffer, FDecoded.Size+1);
    FDecoded.Position := 0;
    FDecoded.Read(Buffer^, FDecoded.Size);
    Buffer[FDecoded.Size] := #0;

    FAttachedMessage := TMailMessage2000.Create(FOwnerMessage.Owner);
    FAttachedMessage.Fill(Buffer, True);

    FreeMem(Buffer);
  end;
end;

// Encode mail part in base64

procedure TMailPart.EncodeBinary;
begin

  EncodeBASE64(FBody, FDecoded);
  SetLabelValue(_C_TE, 'base64');
end;

// Encode mail part in quoted-printable

procedure TMailPart.EncodeText;
var
  Buffer: String;
  Encoded: String;
begin

  SetLength(Buffer, FDecoded.Size);
  FDecoded.Position := 0;
  FDecoded.ReadBuffer(Buffer[1], FDecoded.Size);

  Encoded := EncodeQuotedPrintable(Buffer, False);
  FBody.Clear;
  FBody.Write(Encoded[1], Length(Encoded));
  SetLabelValue(_C_TE, 'quoted-printable');
end;

{ TMailPartList ============================================================== }

// Retrieve an item from the list

function TMailPartList.Get(const Index: Integer): TMailPart;
begin

	Result := inherited Items[Index];
end;

// Finalize MailPartList

destructor TMailPartList.Destroy;
begin

  inherited Destroy;
end;

{ TMailMessage2000 =============================================================== }

// Initialize MailMessage

constructor TMailMessage2000.Create(AOwner: TComponent);
begin

  FAttachList := TMailPartList.Create;
  FTextPlain := TStringList.Create;
  FTextHTML := TStringList.Create;
  FTextPart := nil;
  FTextPlainPart := nil;
  FTextHTMLPart := nil;
  FNeedRebuild := False;
  FCharset := 'iso-8859-1';
  FNameCount := 0;
  FToNames := TStringList.Create;
  FToAddresses := TStringList.Create;
  FCcNames := TStringList.Create;
  FCcAddresses := TStringList.Create;

  inherited Create(AOwner);

  FOwnerMessage := Self;
end;

// Finalize MailMessage

destructor TMailMessage2000.Destroy;
begin

  FAttachList.Free;
  FTextPlain.Free;
  FTextHTML.Free;
  FToNames.Free;
  FToAddresses.Free;
  FCcNames.Free;
  FCcAddresses.Free;

  inherited Destroy;
end;

// Get a dest. name from a field

function TMailMessage2000.GetDestName(Field: String; const Index: Integer): String;
var
  Dests: String;
  Loop: Integer;
  Count: Integer;
  Quote: Boolean;
  Name: String;

begin

  Dests := TrimSpace(GetLabelValue(Field));
  Count := 0;
  Name := '';
  Quote := False;

  for Loop := 1 to Length(Dests) do
  begin

    if Dests[Loop] = '"' then
    begin

      Quote := not Quote;
    end
    else
    begin

      if (not Quote) and (Dests[Loop] in [',', ';']) then Inc(Count);

      if Count > Index then
      begin

        Name := '';
        Break;
      end;

      if Count = Index then
      begin

        if (Dests[Loop] = '<') and (not Quote) then
        begin

          Break;
        end
        else
        begin

          if Quote or (not (Dests[Loop] in [',', ';'])) then
            Name := Name + Dests[Loop];
        end;
      end;
    end;

    if Loop = Length(Dests) then Name := '';
  end;

  Result := DecodeLine7Bit(TrimSpace(Name));
end;

// Get a dest. address from a field

function TMailMessage2000.GetDestAddress(Field: String; const Index: Integer): String;
var
  Dests: String;
  Loop: Integer;
  Count: Integer;
  Quote: Boolean;
  Address: String;

begin

  Dests := TrimSpace(GetLabelValue(Field));
  Count := 0;
  Address := '';
  Quote := False;

  for Loop := 1 to Length(Dests) do
  begin

    if Dests[Loop] = '"' then
    begin

      Quote := not Quote;
    end
    else
    begin

      if (not Quote) and (Dests[Loop] in [',', ';']) then Inc(Count);

      if Count > Index then Break;

      if Count = Index then
      begin

        if (not Quote) and (not (Dests[Loop] in [',', ';', '<', '>', #32])) then
          Address := Address + Dests[Loop];

        if (Dests[Loop] = '<') and (not Quote) then
        begin

          Address := '';
        end;

        if (Dests[Loop] = '>') and (not Quote) then
        begin

          Break;
        end;
      end;
    end;
  end;

  Result := TrimSpace(Address);
end;

// Get a dest. count from a field

function TMailMessage2000.GetDestCount(Field: String): Integer;
var
  Dests: String;
  Loop: Integer;
  Quote: Boolean;

begin

  Dests := TrimSpace(GetLabelValue(Field));
  Result := 0;
  Quote := False;

  for Loop := 1 to Length(Dests) do
  begin

    if Result = 0 then Result := 1;

    if Dests[Loop] = '"' then
    begin

      Quote := not Quote;
    end
    else
    begin

      if (not Quote) and (Dests[Loop] in [',', ';']) then
        Inc(Result);
    end
  end;
end;

// Count the instances of 'Received' fields in header

function TMailMessage2000.GetReceivedCount: Integer;
begin

  Result := 0;

  while SearchStringList(FHeader, 'Received:', Result) >= 0 do
    Inc(Result);
end;

// Retrieve a 'Received' field

function TMailMessage2000.GetReceived(const Index: Integer): TReceived;
var
  Dests: String;
  Loop: Integer;
  Quote: Integer;
  Value: String;
  Field: TReceivedField;

begin

  Result.From := '';
  Result.By := '';
  Result.Address := '';
  Result.Date := 0;

  Dests := Trim(Copy(FHeader[SearchStringList(FHeader, 'Received', Index)], 10, 9999))+#32;
  Value := '';
  Field := reNone;
  Quote := 0;

  for Loop := 1 to Length(Dests) do
  begin

    if Dests[Loop] in ['(', '['] then
      Inc(Quote);

    if Dests[Loop] in [')', ']'] then
      Dec(Quote);

    if Quote < 0 then
      Quote := 0;

    if (not (Dests[Loop] in ['"', '<', '>', #39, ')', ']'])) and (Quote = 0) then
    begin

      if (Dests[Loop] <> #32) or ((Dests[Loop] = #32) and (Loop > 1) and (Dests[Loop-1] <> #32)) then
      begin

        if Dests[Loop] in [#32, ';'] then
        begin

          if (Field = reNone) and (Trim(Value) <> '') then
          begin

            if LowerCase(Trim(Value)) = 'from' then
              Field := reFrom;

            if LowerCase(Trim(Value)) = 'by' then
              Field := reBy;

            if LowerCase(Trim(Value)) = 'for' then
              Field := reFor;

            if LowerCase(Trim(Value)) = ';' then
              Field := reDate;

            Value := '';
          end;

          if (Field <> reNone) and (Trim(Value) <> '') then
          begin

            case Field of

              reFrom: Result.From := Trim(Value);

              reBy: Result.By := Trim(Value);

              reFor: Result.Address := Trim(Value);

              reDate:
              if Loop = Length(Dests) then
              begin

                Result.Date := MailDateToDelphiDate(Trim(Value))
              end
              else
              begin

                Value := Value + #32;
              end;
            end;

            if Field <> reDate then
            begin

              Value := '';
              Field := reNone;

              if Dests[Loop] = ';' then
              begin

                Value := ';';
              end;
            end;
          end;
        end
        else
        begin

          Value := Value + Dests[Loop];
        end;
      end;
    end;
  end;
end;

// Get a To: name

function TMailMessage2000.GetToName(const Index: Integer): String;
begin

  Result := GetDestName('To', Index);
end;

// Get a To: address

function TMailMessage2000.GetToAddress(const Index: Integer): String;
begin

  Result := GetDestAddress('To', Index);
end;

// Get To: count

function TMailMessage2000.GetToCount: Integer;
begin

  Result := GetDestCount('To');
end;

// Get a Cc: name

function TMailMessage2000.GetCcName(const Index: Integer): String;
begin

  Result := GetDestName('Cc', Index);
end;

// Get a Cc: address

function TMailMessage2000.GetCcAddress(const Index: Integer): String;
begin

  Result := GetDestAddress('Cc', Index);
end;

// Get Cc: count

function TMailMessage2000.GetCcCount: Integer;
begin

  Result := GetDestCount('Cc');
end;

// Get a Bcc: name

function TMailMessage2000.GetBccName(const Index: Integer): String;
begin

  Result := GetDestName('Bcc', Index);
end;

// Get a Bcc: address

function TMailMessage2000.GetBccAddress(const Index: Integer): String;
begin

  Result := GetDestAddress('Bcc', Index);
end;

// Get Bcc: count

function TMailMessage2000.GetBccCount: Integer;
begin

  Result := GetDestCount('Bcc');
end;

// Add a name/address to a field

procedure TMailMessage2000.AddDest(Field, Name, Address: String);
var
  Line: Integer;
  Dests: String;

begin

  Line := SearchStringList(FHeader, Field + ':');

  if Line < 0 then
  begin

    FHeader.Add(Field + ': "' + EncodeLine7Bit(Name, FCharset) + '" <' + Address + '>');
  end
  else
  begin

    Dests := TrimSpace(FHeader[Line]);

    if Dests[Length(Dests)] <> ':' then
      Dests := Dests + ',';

    Dests := Dests + ' "' + EncodeLine7Bit(Name, FCharset) + '" <' + Address + '>';

    FHeader[Line] := Dests;
  end;
end;

// Add a names/addresses to a field in commatext format

procedure TMailMessage2000.SetDest(Field, Names, Addresses: String);
var
  Line, Loop: Integer;
  N, A: TStringList;
  Dests: String;

begin

  N := TStringList.Create;
  A := TStringList.Create;

  N.CommaText := Names;
  A.CommaText := Addresses;

  for Loop := 1 to A.Count-N.Count do
    N.Add(A[Loop+N.Count-1]);

  Line := SearchStringList(FHeader, Field + ':');

  if Line < 0 then
  begin

    FHeader.Add('');
    Line := FHeader.Count-1;
  end;

  Dests := Field + ':';

  for Loop := 0 to A.Count-1 do
  begin

    if Loop > 0 then
      Dests := Dests + ',';

    Dests := Dests + #32'"' + EncodeLine7Bit(N[Loop], FCharset) + '" <' + A[Loop] + '>';
  end;

  FHeader[Line] := Dests;

  N.Free;
  A.Free;
end;

// Add a name/address to To:

procedure TMailMessage2000.AddTo(Name, Address: String);
begin

  AddDest('To', Name, Address);
end;

// Add a name/address to Cc:

procedure TMailMessage2000.AddCc(Name, Address: String);
begin

  AddDest('Cc', Name, Address);
end;

// Add a name/address to Bcc:

procedure TMailMessage2000.AddBcc(Name, Address: String);
begin

  AddDest('Bcc', Name, Address);
end;

// Set To: destinations in commatext format

procedure TMailMessage2000.SetTo(Names, Addresses: String);
begin

  SetDest('To', Names, Addresses);
end;

// Set Cc: destinations in commatext format

procedure TMailMessage2000.SetCc(Names, Addresses: String);
begin

  SetDest('Cc', Names, Addresses);
end;

// Set Bcc: destinations in commatext format

procedure TMailMessage2000.SetBcc(Names, Addresses: String);
begin

  SetDest('Bcc', Names, Addresses);
end;

// Clear the To: label

procedure TMailMessage2000.ClearTo;
var
  Line: Integer;

begin

  Line := SearchStringList(FHeader, 'To:');

  if Line >= 0 then FHeader.Delete{Line}(Line);
end;

// Clear the Cc: label

procedure TMailMessage2000.ClearCc;
var
  Line: Integer;

begin

  Line := SearchStringList(FHeader, 'Cc:');

  if Line >= 0 then FHeader.Delete{Line}(Line);
end;

// Clear the Bcc: label

procedure TMailMessage2000.ClearBcc;
var
  Line: Integer;

begin

  Line := 0;

  while Line >= 0 do
  begin

    Line := SearchStringList(FHeader, 'Bcc:');

    if Line >= 0 then FHeader.Delete(Line);
  end;
end;

// Get the From: name

function TMailMessage2000.GetFromName: String;
begin

  Result := GetDestName('From', 0);
end;

// Get the From: address

function TMailMessage2000.GetFromAddress: String;
begin

  Result := GetDestAddress('From', 0);
end;

// Get the Reply-To: name

function TMailMessage2000.GetReplyToName: String;
begin

  Result := GetDestName('Reply-To', 0);
end;

// Get the Reply-To: address

function TMailMessage2000.GetReplyToAddress: String;
begin

  Result := GetDestAddress('Reply-To', 0);
end;

// Set the From: name/address

procedure TMailMessage2000.SetFrom(Name, Address: String);
begin

  SetLabelValue('From', '"' + EncodeLine7Bit(Name, FCharset) + '" <' + Address + '>');
end;

// Set the Reply-To: name/address

procedure TMailMessage2000.SetReplyTo(Name, Address: String);
begin

  SetLabelValue('Reply-To', '"' + EncodeLine7Bit(Name, FCharset) + '" <' + Address + '>');
end;

// Get the subject

function TMailMessage2000.GetSubject: String;
begin

  Result := DecodeLine7Bit(GetLabelValue('Subject'));
end;

// Set the subject

procedure TMailMessage2000.SetSubject(Subject: String);
begin

  SetLabelValue('Subject', EncodeLine7Bit(Subject, FCharset));
end;

// Get the date in TDateTime format

function TMailMessage2000.GetDate: TDateTime;
begin

  Result := MailDateToDelphiDate(TrimSpace(GetLabelValue('Date')));
end;

// Set the date in RFC822 format

procedure TMailMessage2000.SetDate(Date: TDateTime);
const
  Months: String = 'Jan,Feb,Mar,Apr,May,Jun,Jul,Ago,Sep,Oct,Nov,Dec,';
  Weeks: String = 'Sun,Mon,Tue,Wed,Thu,Fri,Sat,';

var
  TZH: Double;
  DateStr: String;
  TZStr: String;
  Day, Month, Year: Word;

begin

  TZH := GetTimeZoneBias;
  DecodeDate(Date, Year, Month, Day);

  if TZH < 0 then
  begin

    TZStr := '-'+FormatDateTime('hhmm', Abs(TZH));
  end
  else
  begin

    if TZH = 0 then
    begin

      TZStr := 'GMT'
    end
    else
    begin

      TZStr := '+'+FormatDateTime('hhmm', Abs(TZH));
    end;
  end;

  DateStr := Copy(Weeks, (DayOfWeek(Date)-1)*4+1, 3)+',';
  DateStr := DateStr + FormatDateTime(' dd ', Date);
  DateStr := DateStr + Copy(Months, (Month-1)*4+1, 3);
  DateStr := DateStr + FormatDateTime(' yyyy hh:nn:ss ', Date) + TZStr;

  SetLabelValue('Date', DateStr);
end;

// Get message id

function TMailMessage2000.GetMessageId: String;
begin

  Result := GetLabelValue('Message-ID');
end;

// Set a unique message id (the parameter is just the host)

procedure TMailMessage2000.SetMessageId(MessageId: String);
var
  IDStr: String;
begin

  IDStr := '<'+FormatDateTime('yyyymmddhhnnss', Now)+'.'+TrimSpace(Format('%8x', [Random($FFFFFFFF)]))+'.'+TrimSpace(Format('%8x', [Random($FFFFFFFF)]))+'@'+MessageId+'>';

  SetLabelValue('Message-ID', IDStr);
end;

// Searches for attached files and determines AttachList, TextPlain, TextHTML.

procedure TMailMessage2000.GetAttachList;
var
  Text: PChar;
  Loop: Integer;

  procedure GetPart(Part: TMailPart);
  var
    Buffer: PChar;
    Ext: String;
    IsText: Boolean;

  begin

    if (FTextPart = nil) and (Part.GetAttachInfo = 'multipart/alternative') then
    begin

      FTextPart := Part;
    end;

    IsText := False;

    if (FTextPlainPart = nil) and (Part.GetAttachInfo = 'text/plain') then
    begin

      IsText := True;

      FTextPlainPart := Part;

      if Part.Decode then
      begin

        GetMem(Buffer, Part.FDecoded.Size+1);
        StrLCopy(Buffer, Part.FDecoded.Memory, Part.FDecoded.Size);
        Buffer[Part.FDecoded.Size] := #0;
        FTextPlain.SetText(Buffer);
        FreeMem(Buffer);
      end
      else
      begin

        GetMem(Text, Part.FBody.Size+1);
        StrLCopy(Text, Part.FBody.Memory, Part.FBody.Size);
        Text[Part.FBody.Size] := #0;
        FTextPlain.SetText(Text);
        FreeMem(Text);
      end;
    end;

    if (FTextHTMLPart = nil) and (Part.GetAttachInfo = 'text/html') then
    begin

      IsText := True;

      FTextHTMLPart := Part;

      if Part.Decode then
      begin

        GetMem(Buffer, Part.FDecoded.Size+1);
        StrLCopy(Buffer, Part.FDecoded.Memory, Part.FDecoded.Size);
        Buffer[Part.FDecoded.Size] := #0;
        FTextHTML.SetText(Buffer);
        FreeMem(Buffer);
      end
      else
      begin

        GetMem(Text, Part.FBody.Size+1);
        StrLCopy(Text, Part.FBody.Memory, Part.FBody.Size);
        Text[Part.FBody.Size] := #0;
        FTextHTML.SetText(Text);
        FreeMem(Text);
      end;
    end;

    if (not IsText) and (Copy(Part.GetAttachInfo, 1, 10) <> 'multipart/') and (Part.Body.Size > 0) then
    begin

      if Part.GetLabelValue(_C_T) = '' then
      begin

        Part.SetLabelValue(_C_T, 'text/plain');
      end;

      if (Part.GetLabelParamValue(_C_T, 'name') = '') and
         (Part.GetLabelValue(_C_ID) = '') and
         (Part.GetLabelParamValue(_C_D, 'filename') = '') then
      begin

        Ext := GetMimeExtension(Part.GetLabelValue(_C_T));

        Part.SetLabelParamValue(_C_T, 'name', '"file_'+IntToStr(FNameCount)+Ext+'"');
        Inc(FNameCount);
      end;

      FAttachList.Add(Part);
    end;
  end;

  procedure DecodeRec(MPL: TMailPartList);
  var
    Loop: Integer;

  begin

    for Loop := 0 to MPL.Count-1 do
    begin

      GetPart(MPL[Loop]);
      DecodeRec(MPL[Loop].FSubPartList);
    end;
  end;

begin

  FAttachList.Clear;
  FTextPart := nil;
  FTextPlainPart := nil;
  FTextHTMLPart := nil;
  FTextPlain.Clear;
  FTextHTML.Clear;
  FToNames.Clear;
  FToAddresses.Clear;
  FCcNames.Clear;
  FCcAddresses.Clear;
  FNameCount := 0;

  GetPart(Self);

  DecodeRec(FSubPartList);

  for Loop := 0 to GetToCount-1 do
  begin

    FToNames.Add(GetToName(Loop));
    FToAddresses.Add(GetToAddress(Loop));
  end;

  for Loop := 0 to GetCcCount-1 do
  begin

    FCcNames.Add(GetCcName(Loop));
    FCcAddresses.Add(GetCcAddress(Loop));
  end;

  (*
  if Decode then
  begin

    GetMem(Text, FDecoded.Size+1);
    StrLCopy(Text, FDecoded.Memory, FDecoded.Size);
    Text[FDecoded.Size] := #0;
  end
  else
  begin

    GetMem(Text, FBody.Size+1);
    StrLCopy(Text, FBody.Memory, FBody.Size);
    Text[FBody.Size] := #0;
  end;

  if (FTextPlain.Count = 0) and (GetLabelValue(_C_T) = 'text/plain') then
    FTextPlain.SetText(Text);

  if (FTextHTML.Count = 0) and (GetLabelValue(_C_T) = 'text/html') then
    FTextHTML.SetText(Text);

  if (FTextPlain.Count = 0) and (not LabelExists(_C_T)) then
    FTextPlain.SetText(Text);

  FreeMem(Text);
  *)
end;

// Create a mailpart and encode the file

procedure TMailMessage2000.AttachFile(FileName: String; ContentType: String = '');
var
  Boundary: String;
  Part: TMailPart;
  Loop: Integer;

begin

  if (GetLabelValue(_C_T) = 'multipart/alternative') and (FTextPart = nil) then
  begin

    Boundary := GenerateBoundary;
    FTextPart := TMailPart.Create(Self);
    FTextPart.FOwnerPart := Self;
    FTextPart.FOwnerMessage := Self.FOwnerMessage;
    FTextPart.FBoundary := GetLabelParamValue(_C_T, 'boundary');
    FTextPart.SetLabelValue(_C_T, '');
    FTextPart.SetLabelValue(_C_T, 'multipart/alternative');
    FTextPart.SetLabelParamValue(_C_T, 'boundary', '"'+Boundary+'"');

    for Loop := 0 to FSubPartList.Count do
    begin

      FTextPart.FSubPartList.Add(FSubPartList[Loop]);
    end;

    FSubPartList.Clear;
    FSubPartList.Add(FTextPart);
    SetLabelValue(_C_T, '');
    SetLabelValue(_C_T, 'multipart/mixed');
  end
  else
  begin

    if not LabelExists(_C_T) then
    begin

      SetLabelValue(_C_T, 'text/plain');
    end;

    PutText('', nil, '');
  end;

  Part := TMailPart.Create(Self);
  Part.FOwnerPart := Self;
  Part.FOwnerMessage := Self.FOwnerMessage;
  FSubPartList.Add(Part);

  Part.Decoded.LoadFromFile(FileName);
  Part.EncodeBinary;
  Part.FBoundary := GetLabelParamValue(_C_T, 'boundary');

  if ContentType = '' then
    Part.SetLabelValue(_C_T, GetMimeType(FileName))
  else
    Part.SetLabelValue(_C_T, ContentType);

  Part.SetLabelValue(_C_D, 'attachment');

  Part.SetLabelParamValue(_C_T, 'name', '"'+ExtractFileName(FileName)+'"');
  Part.SetLabelParamValue(_C_D, 'filename', '"'+ExtractFileName(FileName)+'"');
  Part.SetLabelValue(_C_ID, '<'+ExtractFileName(FileName)+'>');

  FNeedRebuild := True;
end;

// Rebuild body text according to the mailparts

procedure TMailMessage2000.RebuildBody;
var
  sLine: String;

  procedure RebuildBodyRec(MP: TMailPart);
  var
    Loop: Integer;
    Line: Integer;
    Data: String;
    nPos: Integer;

  begin

    for Loop := 0 to MP.SubPartList.Count-1 do
    begin

      sLine := #13#10;
      FBody.Write(sLine[1], Length(sLine));

      sLine :=  '--'+MP.SubPartList[Loop].FBoundary+#13#10;
      FBody.Write(sLine[1], Length(sLine));

      for Line := 0 to MP.SubPartList[Loop].FHeader.Count-1 do
      begin

        sLine := MP.SubPartList[Loop].FHeader[Line];

        if Length(sLine) > 0 then
        begin

          sLine := MP.SubPartList[Loop].FHeader[Line]+#13#10;
          FBody.Write(sLine[1], Length(sLine));
        end;
      end;

      sLine := #13#10;
      FBody.Write(sLine[1], Length(sLine));

      if MP.SubPartList[Loop].SubPartList.Count > 0 then
      begin

        RebuildBodyRec(MP.SubPartList[Loop]);
      end
      else
      begin

        SetLength(Data, MP.SubPartList[Loop].FBody.Size);

        if MP.SubPartList[Loop].FBody.Size > 0 then
        begin

          MP.SubPartList[Loop].FBody.Position := 0;
          MP.SubPartList[Loop].FBody.ReadBuffer(Data[1], MP.SubPartList[Loop].FBody.Size);

          nPos := 1;

          while nPos >= 0 do
          begin

            DataLine(Data, sLine, nPos);

            sLine := sLine;
            FBody.Write(sLine[1], Length(sLine));
          end;
        end;
      end;
    end;

    if MP.SubPartList.Count > 0 then
    begin

      sLine := #13#10;
      FBody.Write(sLine[1], Length(sLine));

      sLine := '--'+MP.SubPartList[0].FBoundary+'--'#13#10;
      FBody.Write(sLine[1], Length(sLine));
    end;
  end;

begin

  if SubPartList.Count > 0 then
  begin

    FBody.Clear;

    sLine := 'This is a multipart message in mime format.'#13#10;
    FBody.Write(sLine[1], Length(sLine));

    RebuildBodyRec(Self);
  end;

  FNeedRebuild := False;
end;

procedure TMailMessage2000.PutText(Text: String; Part: TMailPart; Content: String);
var
  Buffer: PChar;
  Boundary: String;
  Data: String;

begin

  if (SubPartList.Count = 0) and
     (Copy(GetLabelValue(_C_T), 1, 5) = 'text/') and
     (GetLabelValue(_C_T) <> Content) then
  begin

    SetLength(Data, FBody.Size);

    if Length(Data) > 0 then
    begin

      FBody.Position := 0;
      FBody.ReadBuffer(Data[1], FBody.Size);
    end
    else
    begin

      Data := #13#10;
    end;

    if GetLabelValue(_C_T) = 'text/plain' then
      PutText(Data, FTextPlainPart, 'text/plain');

    if GetLabelValue(_C_T) = 'text/html' then
      PutText(Data, FTextHTMLPart, 'text/html');
  end
  else
  begin

    if Text <> '' then
    begin

      GetAttachList;
      FNeedRebuild := True;

      if Part <> nil then
      begin

        Buffer := PChar(Text);
        Part.Decoded.Clear;
        Part.Decoded.Write(Buffer^, Length(Text));
        Part.EncodeText;
      end
      else
      begin

        if FTextPart = nil then
        begin

          Boundary := GenerateBoundary;
          FTextPart := TMailPart.Create(Self);
          FTextPart.FOwnerPart := Self;
          FTextPart.FOwnerMessage := Self.FOwnerMessage;
          FTextPart.SetLabelValue(_C_T, '');
          FTextPart.SetLabelValue(_C_T, 'multipart/alternative');
          FTextPart.SetLabelParamValue(_C_T, 'boundary', '"'+Boundary+'"');

          FSubPartList.Insert(0, FTextPart);

          Boundary := GenerateBoundary;
          SetLabelValue(_C_T, '');
          SetLabelValue(_C_T, 'multipart/mixed');
          SetLabelParamValue(_C_T, 'boundary', '"'+Boundary+'"');
          FTextPart.FBoundary := Boundary;

          if FTextPlainPart <> nil then
          begin

            if FTextPlainPart.FOwnerPart = Self then
            begin

              FSubPartList.Delete(FSubPartList.IndexOf(FTextPlainPart));
              FTextPart.FSubPartList.Insert(0, FTextPlainPart);
              FTextPlainPart.FOwnerPart := FTextPart;
              FTextPlainPart.FBoundary := FTextPart.GetLabelParamValue(_C_T, 'boundary');
            end;
          end;

          if FTextHTMLPart <> nil then
          begin

            if FTextHTMLPart.FOwnerPart = Self then
            begin

              FSubPartList.Delete(FSubPartList.IndexOf(FTextHTMLPart));
              FTextPart.FSubPartList.Insert(0, FTextHTMLPart);
              FTextHTMLPart.FOwnerPart := FTextPart;
              FTextHTMLPart.FBoundary := FTextPart.GetLabelParamValue(_C_T, 'boundary');
            end;
          end;
        end;

        Part := TMailPart.Create(Self);
        Part.FOwnerPart := FTextPart;
        Part.FOwnerMessage := Self.FOwnerMessage;
        Buffer := PChar(Text);
        Part.Decoded.Clear;
        Part.Decoded.Write(Buffer^, Length(Text));
        Part.SetLabelValue(_C_T, Content);
        Part.SetLabelParamValue(_C_T, 'charset', '"'+FOwnerMessage.FCharset+'"');
        Part.EncodeText;

        Part.FBoundary := FTextPart.GetLabelParamValue(_C_T, 'boundary');
        FTextPart.SubPartList.Add(Part);
      end;
    end;
  end;
end;

// Replace or create a mailpart for text/plain

procedure TMailMessage2000.SetTextPlain(Text: TStrings);
begin

  PutText(Text.Text, FTextPlainPart, 'text/plain');
end;

// Replace or create a mailpart for text/html

procedure TMailMessage2000.SetTextHTML(Text: TStrings);
begin

  PutText(Text.Text, FTextHTMLPart, 'text/html');
end;

// Remove text/plain mailpart

procedure TMailMessage2000.RemoveTextPlain;
begin

  if FTextPlainPart <> nil then
    FTextPlainPart.Remove;

  FTextPlainPart := nil;
end;

// Remove text/html mailpart

procedure TMailMessage2000.RemoveTextHTML;
begin

  if FTextHTMLPart <> nil then
    FTextHTMLPart.Remove;

  FTextHTMLPart := nil;
end;

// Empty data stored in the object

procedure TMailMessage2000.Reset;
var
  Loop: Integer;

begin

  for Loop := 0 to FSubPartList.Count-1 do
    FSubPartList.Items[Loop].Destroy;

  FHeader.Clear;
  FBody.Clear;
  FDecoded.Clear;
  FSubPartList.Clear;

  FAttachList.Clear;
  FTextPlain.Clear;
  FTextHTML.Clear;
  FTextPart := nil;
  FTextPlainPart := nil;
  FTextHTMLPart := nil;
  FNeedRebuild := False;
  FNameCount := 0;
end;

{ TSocketTalk =================================================================== }

// Initialize TSocketTalk

constructor TSocketTalk.Create(AOwner: TComponent);
begin

  FClientSocket := TClientSocket.Create(Self);
  FClientSocket.ClientType := ctNonBlocking;
  FClientSocket.OnRead := SocketRead;
  FClientSocket.OnDisconnect := SocketDisconnect;
  FClientSocket.Socket.OnErrorEvent := SocketError;

  FTimer := TTimer.Create(Self);
  FTimer.Enabled := False;
  FTimer.OnTimer := Timer;

  FTimeOut := 60;
  FLastResponse := '';
  FExpectedEnd := '';
  FDataSize := 0;
  FPacketSize := 0;
  FTalkError := teNoError;

  inherited Create(AOwner);
end;

// Finalize TSocketTalk

destructor TSocketTalk.Destroy;
begin

  FClientSocket.Free;
  FTimer.Free;

  inherited Destroy;
end;

// Occurs when data is comming from the socket

procedure TSocketTalk.SocketRead(Sender: TObject; Socket: TCustomWinSocket);
var
  Buffer: String;
  BufLen: Integer;

begin

  SetLength(Buffer, Socket.ReceiveLength);
  BufLen := Socket.ReceiveBuf(Buffer[1], Length(Buffer));
//  Buffer := Socket.ReceiveText;
  FLastResponse := FLastResponse + Copy(Buffer, 1, BufLen);
  FTalkError := teNoError;
  FTimer.Enabled := False;

  if Assigned(FOnReceiveData) then
  begin

    FOnReceiveData(Self, FSessionState, Buffer, FServerResult);
  end;

  if (FDataSize > 0) and Assigned(FOnProgress) then
  begin

    FOnProgress(Self.Owner, FDataSize, Length(FLastResponse));
  end;

  if (FExpectedEnd = '') or (Copy(FLastResponse, Length(FLastResponse)-Length(FExpectedEnd)+1, Length(FExpectedEnd)) = FExpectedEnd) then
  begin

    FTalkError := teNoError;
    FDataSize := 0;
    FExpectedEnd := '';
    FWaitingServer := False;

    if Assigned(FOnEndOfData) then
    begin

      FOnEndOfData(Self, FSessionState, FLastResponse, FServerResult);
    end;

    FSessionState := stNone;
  end
  else
  begin

    FTimer.Enabled := True;
  end;
end;

// Occurs when socket is disconnected

procedure TSocketTalk.SocketDisconnect(Sender: TObject; Socket: TCustomWinSocket);
begin

  if Assigned(FOnDisconnect) then
    FOnDisconnect(Self);

  FTimer.Enabled := False;
  FExpectedEnd := '';
  FDataSize := 0;
  FPacketSize := 0;
end;

// Occurs on socket error

procedure TSocketTalk.SocketError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
begin

  FTimer.Enabled := False;
  FTalkError := TTalkError(Ord(ErrorEvent));
  FDataSize := 0;
  FExpectedEnd := '';
  FWaitingServer := False;
  FServerResult := False;

  if Assigned(FOnSocketTalkError) then
  begin

    FOnSocketTalkError(Self, FSessionState, FTalkError);
  end;

  FSessionState := stNone;
  ErrorCode := 0;
end;

// Occurs on timeout

procedure TSocketTalk.Timer(Sender: TObject);
begin

  FTimer.Enabled := False;
  FTalkError := teTimeout;
  FDataSize := 0;
  FExpectedEnd := '';
  FWaitingServer := False;
  FServerResult := False;

  if Assigned(FOnSocketTalkError) then
  begin

    FOnSocketTalkError(Self, FSessionState, FTalkError);
  end;

  FSessionState := stNone;
end;

// Cancel waiting for server response

procedure TSocketTalk.Cancel;
begin

  FTimer.Enabled := False;
  FTalkError := teNoError;
  FSessionState := stNone;
  FExpectedEnd := '';
  FDataSize := 0;
  FWaitingServer := False;
  FServerResult := False;
end;

// Inform that the data comming belongs

procedure TSocketTalk.ForceState(SessionState: TSessionState);
begin

  FExpectedEnd := '';
  FLastResponse := '';
  FTimer.Interval := FTimeOut * 1000;
  FTimer.Enabled := True;
  FDataSize := 0;
  FTalkError := teNoError;
  FSessionState := SessionState;
  FWaitingServer := True;
  FServerResult := False;
end;

// Send a command to server

procedure TSocketTalk.Talk(Buffer, EndStr: String; SessionState: TSessionState);
var
  nPos: Integer;
  nLen: Integer;

begin

  FExpectedEnd := EndStr;
  FSessionState := SessionState;
  FLastResponse := '';
  FTimer.Interval := FTimeOut * 1000;
  FTalkError := teNoError;
  FWaitingServer := True;
  FServerResult := False;
  nPos := 1;

  if (FPacketSize > 0) and (Length(Buffer) > FPacketSize) then
  begin

    if Assigned(OnProgress) then
      OnProgress(Self.Owner, Length(Buffer), 0);

    while nPos <= Length(Buffer) do
    begin

      Application.ProcessMessages;

      if (nPos+FPacketSize-1) > Length(Buffer) then
        nLen := Length(Buffer)-nPos+1
      else
        nLen := FPacketSize;
// by Rene de Jong (rmdejong@ism.nl) >>>>>>>>>>>>>>
      FTimer.Enabled := TRUE;

      while (FClientSocket.Socket.SendBuf(Buffer[nPos], nLen) = -1) do
        Sleep(10);

      FTimer.Enabled := FALSE;
// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<
      nPos := nPos + nLen;

      if Assigned(OnProgress) then
        OnProgress(Self.Owner, Length(Buffer), nPos-1);
    end;
  end
  else
  begin

    while (FClientSocket.Socket.SendBuf(Buffer[1], Length(Buffer)) = -1 )
       do Sleep (10);
  end;

  FPacketSize := 0;
end;

// Wait for server response
// by Rene de Jong (rmdejong@ism.nl)

procedure TSocketTalk.WaitServer;
begin

  FTimer.Interval := FTimeOut * 1000;

  while FWaitingServer and (not FServerResult) do
  begin

    FTimer.Enabled := True;
    Application.ProcessMessages;
  end;

  FTimer.Enabled:= False;
end;

{ TPOP2000 ====================================================================== }

// Initialize TPOP2000

constructor TPOP2000.Create;
begin

  FSocketTalk := TSocketTalk.Create(Self);
  FSocketTalk.OnEndOfData := EndOfData;
  FSocketTalk.OnSocketTalkError := SocketTalkError;
  FSocketTalk.OnReceiveData := ReceiveData;
  FSocketTalk.OnDisconnect := SocketDisconnect;

  FHost := '';
  FPort := 110;
  FUserName := '';
  FPassword := '';
  FSessionMessageCount := -1;
  FSessionConnected := False;
  FSessionLogged := False;
  FMailMessage := nil;
  FProxyPort := 23;
  FProxyHost := '';
  FProxyUsage := False;
  FProxyString := '%h% %p%';
  FDeleteOnRetrieve := False;

  SetLength(FSessionMessageSize, 0);

  inherited Create(AOwner);
end;

// Finalize TPOP2000

destructor TPOP2000.Destroy;
begin

  FSocketTalk.Free;

  SetLength(FSessionMessageSize, 0);

  inherited Destroy;
end;

// Set timeout

procedure TPOP2000.SetTimeOut(Value: Integer);
begin

  FSocketTalk.TimeOut := Value;
end;

// Get timeout

function TPOP2000.GetTimeOut: Integer;
begin

  Result := FSocketTalk.TimeOut;
end;

// Set OnProgress event

procedure TPOP2000.SetProgress(Value: TProgressEvent);
begin

  FSocketTalk.OnProgress := Value;
end;

// Get OnProgress event

function TPOP2000.GetProgress: TProgressEvent;
begin

  Result := FSocketTalk.OnProgress;
end;

// Get LastResponse

function TPOP2000.GetLastResponse: String;
begin

  Result := FSocketTalk.LastResponse;
end;

// When data from server ends

procedure TPOP2000.EndOfData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
begin

  case SessionState of

    stProxy: ServerResult := True;

    stConnect, stUser, stPass, stStat, stList, stRetr, stQuit, stDele:
    if Copy(Data, 1, 3) = '+OK' then
      ServerResult := True;
  end;
end;

// On socket error

procedure TPOP2000.SocketTalkError(Sender: TObject; SessionState: TSessionState; TalkError: TTalkError);
begin

  FSocketTalk.Cancel;
end;

// On data received

procedure TPOP2000.ReceiveData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
begin

  if (Copy(Data, 1, 5) = '-ERR ') and (Copy(Data, Length(Data)-1, 2) = #13#10) then
  begin

    ServerResult := False;
    FSocketTalk.Cancel;
  end;
end;

// On socket disconnected

procedure TPOP2000.SocketDisconnect(Sender: TObject);
begin

  FSessionMessageCount := -1;
  FSessionConnected := False;
  FSessionLogged := False;

  SetLength(FSessionMessageSize, 0);
end;

// Connect socket

function TPOP2000.Connect: Boolean;
var
  Connect: String;

begin

  if FSessionConnected or FSocketTalk.ClientSocket.Active then
  begin

    Result := False;
    Exit;
  end;

  if Length(FHost) = 0 then
  begin

    Result := False;
    Exit;
  end;

  if not FProxyUsage then
  begin

    if not IsIPAddress(FHost) then
    begin

      FSocketTalk.ClientSocket.Host := FHost;
      FSocketTalk.ClientSocket.Address := '';
    end
    else
    begin

      FSocketTalk.ClientSocket.Host := '';
      FSocketTalk.ClientSocket.Address := FHost;
    end;

    FSocketTalk.ClientSocket.Port := FPort;
    FSocketTalk.ForceState(stConnect);
    FSocketTalk.ClientSocket.Open;
  end
  else
  begin

    Connect := FindReplace(FProxyString, '%h%', FHost);
    Connect := FindReplace(Connect, '%p%', IntToStr(FPort));
    Connect := FindReplace(Connect, '%u%', FUserName);

    if not IsIPAddress(FProxyHost) then
    begin

      FSocketTalk.ClientSocket.Host := FProxyHost;
      FSocketTalk.ClientSocket.Address := '';
    end
    else
    begin

      FSocketTalk.ClientSocket.Host := '';
      FSocketTalk.ClientSocket.Address := FProxyHost;
    end;

    FSocketTalk.ClientSocket.Port := FProxyPort;
    FSocketTalk.ForceState(stProxy);
    FSocketTalk.ClientSocket.Open;
    FSocketTalk.WaitServer;

    if FSocketTalk.ServerResult then
      FSocketTalk.Talk(Connect+#13#10, #13#10, stConnect);
  end;

  FSocketTalk.WaitServer;

  FSessionConnected := FSocketTalk.ServerResult;
  Result := FSocketTalk.ServerResult;
end;

// POP3 Logon

function TPOP2000.Login: Boolean;
var
  MsgList: TStringList;
  Loop: Integer;
  cStat: String;

begin

  Result := False;

  if (not FSessionConnected) or (not FSocketTalk.ClientSocket.Active) then
  begin

    Exit;
  end;

  FSocketTalk.Talk('USER '+FUserName+#13#10, #13#10, stUser);
  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    FSocketTalk.Talk('PASS '+FPassword+#13#10, #13#10, stPass);
    FSocketTalk.WaitServer;

    if FSocketTalk.ServerResult then
    begin

      FSessionLogged := True;

      FSocketTalk.Talk('LIST'#13#10, #13#10'.'#13#10, stList);
      FSocketTalk.WaitServer;

      if FSocketTalk.ServerResult then
      begin

        MsgList := TStringList.Create;
        MsgList.Text := FSocketTalk.LastResponse;

        if MsgList.Count > 2 then
        begin

          cStat := TrimSpace(MsgList[MsgList.Count-2]);

          FSessionMessageCount := StrToIntDef(Copy(cStat, 1, Pos(#32, cStat)-1), -1);

          if FSessionMessageCount > 0 then
          begin

            SetLength(FSessionMessageSize, FSessionMessageCount);

            for Loop := 1 to MsgList.Count-2 do
            begin

              cStat := TrimSpace(MsgList[Loop]);
              cStat := Copy(cStat, 1, Pos(#32, cStat)-1);

              if StrToIntDef(cStat, 0) > 0 then
                FSessionMessageSize[StrToInt(cStat)-1] := StrToIntDef(Copy(MsgList[Loop], Pos(#32, MsgList[Loop])+1, 99), 0);
            end;
          end;
        end
        else
        begin

          FSessionMessageCount := 0;
          SetLength(FSessionMessageSize, 0);
        end;

        MsgList.Free;
      end;
    end;
  end;

  Result := FSessionLogged;
end;

// POP3 Quit

function TPOP2000.Quit: Boolean;
begin

  Result := False;

  if (not FSessionConnected) or (not FSocketTalk.ClientSocket.Active) then
  begin

    Exit;
  end;

  FSocketTalk.Talk('QUIT'#13#10, #13#10, stQuit);
  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    FSocketTalk.ClientSocket.Close;
    FSessionConnected := False;
    FSessionLogged := False;
    FSessionMessageCount := -1;
    Result := True;
  end;
end;

// Retrieve message#

function TPOP2000.RetrieveMessage(Number: Integer): Boolean;
var
  MailTxt: TStringList;

begin

  Result := False;
  FLastMessage := '';

  if not Assigned(FMailMessage) then
  begin

    Exception.Create('MailMessage unassigned');
    Exit;
  end;

  if (not FSessionConnected) or (not FSessionLogged) or (not FSocketTalk.ClientSocket.Active) then
  begin

    Exit;
  end;

  FSocketTalk.DataSize := FSessionMessageSize[Number-1];
  FSocketTalk.Talk('RETR '+IntToStr(Number)+#13#10, #13#10'.'#13#10, stRetr);
  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    MailTxt := TStringList.Create;
    MailTxt.Text := FSocketTalk.LastResponse;
    MailTxt.Delete(MailTxt.Count-1);
    MailTxt.Delete(0);
    FLastMessage := MailTxt.Text;
    FMailMessage.Reset;
    FMailMessage.Fill(PChar(FLastMessage), True);

    Result := True;

    if FDeleteOnRetrieve then
      DeleteMessage(Number);
  end;
end;

// Retrieve message#

function TPOP2000.RetrieveHeader(Number: Integer): Boolean;
var
  MailTxt: TStringList;

begin

  Result := False;
  FLastMessage := '';

  if not Assigned(FMailMessage) then
  begin

    Exception.Create('MailMessage unassigned');
    Exit;
  end;

  if (not FSessionConnected) or (not FSessionLogged) or (not FSocketTalk.ClientSocket.Active) then
  begin

    Exit;
  end;

  FSocketTalk.DataSize := FSessionMessageSize[Number-1];
  FSocketTalk.Talk('TOP '+IntToStr(Number)+#32'1'#13#10, #13#10'.'#13#10, stRetr);
  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    MailTxt := TStringList.Create;
    MailTxt.Text := FSocketTalk.LastResponse;
    MailTxt.Delete(MailTxt.Count-1);
    MailTxt.Delete(0);
    FLastMessage := MailTxt.Text;
    FMailMessage.Reset;
    FMailMessage.Fill(PChar(FLastMessage), True);

    Result := True;
  end;
end;

// Delete message#

function TPOP2000.DeleteMessage(Number: Integer): Boolean;
begin

  Result := False;

  if (not FSessionConnected) or (not FSessionLogged) or (not FSocketTalk.ClientSocket.Active) then
  begin

    Exit;
  end;

  FSocketTalk.Talk('DELE '+IntToStr(Number)+#13#10, #13#10, stDele);
  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    Result := True;
  end;
end;

{ TSMTP2000 ====================================================================== }

// Initialize TSMTP2000

constructor TSMTP2000.Create;
begin

  FSocketTalk := TSocketTalk.Create(Self);
  FSocketTalk.OnEndOfData := EndOfData;
  FSocketTalk.OnSocketTalkError := SocketTalkError;
  FSocketTalk.OnReceiveData := ReceiveData;
  FSocketTalk.OnDisconnect := SocketDisconnect;

  FHost := '';
  FPort := 25;
  FSessionConnected := False;
  FProxyPort := 23;
  FProxyHost := '';
  FProxyUsage := False;
  FProxyString := '%h% %p%';
  FPacketSize := 1024;

  inherited Create(AOwner);
end;

// Finalize TSMTP2000

destructor TSMTP2000.Destroy;
begin

  FSocketTalk.Free;

  inherited Destroy;
end;

// Set timeout

procedure TSMTP2000.SetTimeOut(Value: Integer);
begin

  FSocketTalk.TimeOut := Value;
end;

// Get timeout

function TSMTP2000.GetTimeOut: Integer;
begin

  Result := FSocketTalk.TimeOut;
end;

// Set OnProgress event

procedure TSMTP2000.SetProgress(Value: TProgressEvent);
begin

  FSocketTalk.OnProgress := Value;
end;

// Get OnProgress event

function TSMTP2000.GetProgress: TProgressEvent;
begin

  Result := FSocketTalk.OnProgress;
end;

// Get LastResponse

function TSMTP2000.GetLastResponse: String;
begin

  Result := FSocketTalk.LastResponse;
end;

// When data from server ends

procedure TSMTP2000.EndOfData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
begin

  case SessionState of

    stProxy: ServerResult := True;

    stConnect:
    if Copy(Data, 1, 3) = '220' then
      ServerResult := True;

    stHelo, stMail, stRcpt, stSendData:
    if Copy(Data, 1, 3) = '250' then
      ServerResult := True;

    stData:
    if Copy(Data, 1, 3) = '354' then
      ServerResult := True;

    stQuit:
    if Copy(Data, 1, 3) = '221' then
      ServerResult := True;
  end;
end;

// On socket error

procedure TSMTP2000.SocketTalkError(Sender: TObject; SessionState: TSessionState; TalkError: TTalkError);
begin

  FSocketTalk.Cancel;
end;

// On data received

procedure TSMTP2000.ReceiveData(Sender: TObject; SessionState: TSessionState; Data: String; var ServerResult: Boolean);
begin

  if (StrToIntDef(Copy(Data, 1, 3), 0) >= 500) and (Copy(Data, Length(Data)-1, 2) = #13#10) then
  begin

    ServerResult := False;
    FSocketTalk.Cancel;
  end;
end;

// On socket disconnected

procedure TSMTP2000.SocketDisconnect(Sender: TObject);
begin

  FSessionConnected := False;
end;

// Connect socket

function TSMTP2000.Connect: Boolean;
var
  Connect: String;
begin

  Result := False;

  if FSessionConnected or FSocketTalk.ClientSocket.Active then
  begin

    Exit;
  end;

  if Length(FHost) = 0 then
  begin

    Exit;
  end;

  if not FProxyUsage then
  begin

    if not IsIPAddress(FHost) then
    begin

      FSocketTalk.ClientSocket.Host := FHost;
      FSocketTalk.ClientSocket.Address := '';
    end
    else
    begin

      FSocketTalk.ClientSocket.Host := '';
      FSocketTalk.ClientSocket.Address := FHost;
    end;

    FSocketTalk.ClientSocket.Port := FPort;
    FSocketTalk.ForceState(stConnect);
    FSocketTalk.ClientSocket.Open;
  end
  else
  begin

    Connect := FindReplace(FProxyString, '%h%', FHost);
    Connect := FindReplace(Connect, '%p%', IntToStr(FPort));

    if not IsIPAddress(FProxyHost) then
    begin

      FSocketTalk.ClientSocket.Host := FProxyHost;
      FSocketTalk.ClientSocket.Address := '';
    end
    else
    begin

      FSocketTalk.ClientSocket.Host := '';
      FSocketTalk.ClientSocket.Address := FProxyHost;
    end;

    FSocketTalk.ClientSocket.Port := FProxyPort;
    FSocketTalk.ForceState(stProxy);
    FSocketTalk.ClientSocket.Open;
    FSocketTalk.WaitServer;

    if FSocketTalk.ServerResult then
      FSocketTalk.Talk(Connect+#13#10, #13#10, stConnect);
  end;

  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    FSocketTalk.Talk('HELO '+FSocketTalk.FClientSocket.Socket.LocalHost+#13#10, #13#10, stHelo);
    FSocketTalk.WaitServer;
  end;

  FSessionConnected := FSocketTalk.ServerResult;
  Result := FSocketTalk.ServerResult;
end;

// SMTP Quit

function TSMTP2000.Quit: Boolean;
begin

  Result := False;

  if (not FSessionConnected) or (not FSocketTalk.ClientSocket.Active) then
  begin

    Exit;
  end;

  FSocketTalk.Talk('QUIT'#13#10, #13#10, stQuit);
  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    FSocketTalk.ClientSocket.Close;
    FSessionConnected := False;
    Result := True;
  end;
end;

// Send message

function TSMTP2000.SendMessage: Boolean;
var
  Dests: TStringList;
  Loop: Integer;
  AllOk: Boolean;
  sHeader: String;
  sText: String;
  sBCC: String;

begin

  Result := False;

  if not Assigned(FMailMessage) then
  begin

    Exception.Create('MailMessage unassigned');
    Exit;
  end;

  if (not FSessionConnected) or (not FSocketTalk.ClientSocket.Active) then
  begin

    Exit;
  end;

  if FMailMessage.FNeedRebuild then
  begin

    Exception.Create('MailMessage need rebuild');
    Exit;
  end;

  Dests := TStringList.Create;
  Dests.Sorted := True;
  Dests.Duplicates := dupIgnore;

  for Loop := 0 to FMailMessage.ToCount-1 do
    Dests.Add(FMailMessage.ToAddress[Loop]);

  for Loop := 0 to FMailMessage.CcCount-1 do
    Dests.Add(FMailMessage.CcAddress[Loop]);

  for Loop := 0 to FMailMessage.BccCount-1 do
    Dests.Add(FMailMessage.BccAddress[Loop]);

  sBCC := FMailMessage.GetLabelValue('Bcc:');

  FMailMessage.SetMessageId(FSocketTalk.ClientSocket.Socket.LocalAddress);
  FMailMessage.ClearBcc;

  FSocketTalk.Talk('MAIL FROM: <'+FMailMessage.GetFromAddress+'>'#13#10, #13#10, stMail);
  FSocketTalk.WaitServer;

  if FSocketTalk.ServerResult then
  begin

    AllOk := True;

    for Loop := 0 to Dests.Count-1 do
    begin

      FSocketTalk.Talk('RCPT TO: <'+Dests[Loop]+'>'#13#10, #13#10, stRcpt);
      FSocketTalk.WaitServer;

      if not FSocketTalk.ServerResult then
        AllOk := False;
    end;

    if AllOk then
    begin

      FSocketTalk.Talk('DATA'#13#10, #13#10, stData);
      FSocketTalk.WaitServer;

      if FSocketTalk.ServerResult then
      begin

        SetLength(sText, FMailMessage.FBody.Size);
        FMailMessage.FBody.Position := 0;
        FMailMessage.FBody.ReadBuffer(sText[1], FMailMessage.FBody.Size);

        WrapSL(FMailMessage.FHeader, sHeader, 70);

        FSocketTalk.PacketSize := FPacketSize;
        FSocketTalk.Talk(sHeader+#13#10+sText+#13#10'.'#13#10, #13#10, stSendData);
        FSocketTalk.WaitServer;

        if FSocketTalk.ServerResult then
        begin

          Result := True;
        end;
      end;
    end;
  end;

  FMailMessage.SetLabelValue('Bcc:', sBCC);
  Dests.Free;
end;

// =============================================================================

begin

  Randomize;
end.
